/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gui.h"

/**
 * lw6gui_point_is_inside_rect
 *
 * @point: point to test
 * @rect: rectangle in which point is supposed to be
 *
 * Tests wether a point is inside a rectangle, this is typically used to know
 * if a point is inside the right texture or if we're outside.
 *
 * Return value: 1 if OK, 0 if outside
 */
int
lw6gui_point_is_inside_rect (lw6gui_point_t point, const lw6gui_rect_t * rect)
{
  return (point.x >= rect->x1 && point.x < rect->x2 && point.y >= rect->y1
	  && point.y < rect->y2);
}
