/* random.h

   written by Frederic Bois
   modifications by Don Robert Maszle
   8 January 1992

   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  %F%
    Revision:  %I%
        Date:  %G%
     Modtime:  %U%
      Author:  @a
   -- SCCS  ---------

   Header for random number generator.  See random.c for extensive
   documentation.

   Gives prototypes for random functions.
*/

#ifndef _RANDOM_H_

#include <math.h>

/* ----------------------------------------------------------------------------
   Constants  */

#define SEED_DEFAULT 314159265.3589793


/* ----------------------------------------------------------------------------
   Prototypes  */

/* Initialize the random generators, optional but recommended */
void InitRandom (double dSeed, int bWarmUp);

/* Two random generators */
/*     one that shuffles its output, */
double RandomShuffle (void);

/*     and one that doesn't */
double Randoms (void);


/* Several types of random variates */

double BetaRandom (double alpha, double beta, double a, double b);
double BinomialRandom (double p, long n);
double Chi2Random (double dof);
double ExpRandom (double beta);
double InvGGammaRandom (double alpha, double beta);
double GammaRandom (double alpha);
double GGammaRandom (double alpha, double beta);
double LogNormalRandom (double dMean, double dStdDev);
double LogUniformRandom (double a, double b);
double NormalRandom (double dMean, double dStdDev);
double PiecewiseRandom (double min, double a, double b, double max);
double PiecewiseVariate (long cDim, double rg_x[], double rg_pdf[],
                         double rg_Cdf[], int iOrder, double *pVal_pdf);
long   PoissonRandom (double mu);
double TruncLogNormalRandom (double dMean, double dStdDev, double a, double b);
double TruncNormalRandom (double dMean, double dStdDev, double a, double b);
double UniformRandom (double a, double b);
void   Multinomial (long n, int dim, double *p, double *x);
void   WishartRandom (long n, long p, double *t, double *w, double *work);


/* ----------------------------------------------------------------------------
   Utility functions */

double CDFNormal(double z);
double InterpolateX (double rgX[], double rgY[], long lLower, double dY);
double erfc(double x);
double lnDFNormal(double x, double mu, double sd);
double lnGamma (double x);
void   CalcCumulative (long cDim, double *rg_x, double *rg_pdf,
                       double *rg_Cdf, int  iOrder);
void   SetSeed (double dSeed);
 
#define _RANDOM_H_
#endif

/* End */

