/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef GAMEPERSISTANCESERVICE_H
#define GAMEPERSISTANCESERVICE_H
#include <string>
#include <vector>
#include "GameDispatcher.h"
class GamePersistanceService
{
  public:
    //create game and generate
  static std::string create(std::string username);
  static std::string createFromJson(std::string username);
  static void attachUser(std::string gameId,std::string username);
  static void save(std::string gameId,std::string json);
  static std::string load(std::string gameId);
  static std::vector<std::string> loads(std::string username);
  static std::vector<std::string> loads();
  
};
class ListGames: public IndividualAction{
  public:
    virtual std::string internalDispatch(std::string msg,std::string session);


};
class ListMyGames: public IndividualAction{
  public:
    virtual std::string internalDispatch(std::string msg,std::string session);


};

class GetGame: public IndividualAction{
  public:
    virtual std::string internalDispatch(std::string msg,std::string session);


};



#endif // GAMEPERSISTANCESERVICE_H
