#line 559 "../grecs/build-aux/getopt.m4"
/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/
#line 1 "cmdline.opt"
/* This file is part of GNU Pies. -*- c -*-
   Copyright (C) 2008-2022 Sergey Poznyakoff

   GNU Pies is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Pies is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Pies.  If not, see <http://www.gnu.org/licenses/>. */

char *incpath = DEFAULT_INCLUDE_PATH;

#line 236 "cmdline.opt"
#ifdef HAVE_CONFIG_H
#line 236
# include <config.h>
#line 236
#endif
#line 236
#ifdef HAVE_GETOPT_H
#line 236
# include <getopt.h>
#line 236
#endif
#line 236
#include <unistd.h>
#line 236
#include <stdlib.h>
#line 236
#include <grecs.h>
#line 236
#include <grecs/opt.h>
#line 236
#ifndef EX_USAGE
#line 236
# define EX_USAGE 64
#line 236
#endif
#line 236
/* Option codes */
#line 236
enum {
#line 236
	_OPTION_INIT=255,
#line 34 "cmdline.opt"
	OPTION_CONFIG_HELP,
#line 47 "cmdline.opt"
	OPTION_FORCE,
#line 53 "cmdline.opt"
	OPTION_FOREGROUND,
#line 60 "cmdline.opt"
	OPTION_NO_INIT,
#line 75 "cmdline.opt"
	OPTION_INSTANCE,
#line 81 "cmdline.opt"
	OPTION_RATE,
#line 93 "cmdline.opt"
	OPTION_STDERR,
#line 99 "cmdline.opt"
	OPTION_SYNTAX,
#line 110 "cmdline.opt"
	OPTION_SYSLOG,
#line 123 "cmdline.opt"
#if PIES_SYSVINIT_ENABLED
#line 130 "cmdline.opt"
#endif
#line 134 "cmdline.opt"
	OPTION_PREPROCESSOR,
#line 140 "cmdline.opt"
	OPTION_NO_PREPROCESSOR,
#line 152 "cmdline.opt"
	OPTION_NO_INCLUDE,
#line 203 "cmdline.opt"
	OPTION_DUMP_DEPMAP,
#line 210 "cmdline.opt"
	OPTION_TRACE_DEPEND,
#line 217 "cmdline.opt"
	OPTION_TRACE_PREREQ,
#line 224 "cmdline.opt"
	OPTION_SOURCE_INFO,
#line 236 "cmdline.opt"
	OPTION_USAGE,
#line 236 "cmdline.opt"
	MAX_OPTION
#line 236
};
#line 236
#ifdef HAVE_GETOPT_LONG
#line 236
static struct option long_options[] = {
#line 28 "cmdline.opt"
	{ "config-file", required_argument, 0, 'c' },
#line 34 "cmdline.opt"
	{ "config-help", no_argument, 0, OPTION_CONFIG_HELP },
#line 47 "cmdline.opt"
	{ "force", no_argument, 0, OPTION_FORCE },
#line 53 "cmdline.opt"
	{ "foreground", no_argument, 0, OPTION_FOREGROUND },
#line 60 "cmdline.opt"
	{ "no-init", no_argument, 0, OPTION_NO_INIT },
#line 66 "cmdline.opt"
	{ "inetd", no_argument, 0, 'i' },
#line 75 "cmdline.opt"
	{ "instance", required_argument, 0, OPTION_INSTANCE },
#line 81 "cmdline.opt"
	{ "rate", required_argument, 0, OPTION_RATE },
#line 93 "cmdline.opt"
	{ "stderr", no_argument, 0, OPTION_STDERR },
#line 99 "cmdline.opt"
	{ "syntax", required_argument, 0, OPTION_SYNTAX },
#line 110 "cmdline.opt"
	{ "syslog", no_argument, 0, OPTION_SYSLOG },
#line 116 "cmdline.opt"
	{ "lint", no_argument, 0, 't' },
#line 123 "cmdline.opt"
#if PIES_SYSVINIT_ENABLED
#line 124 "cmdline.opt"
	{ "telinit", no_argument, 0, 'T' },
#line 130 "cmdline.opt"
#endif
#line 134 "cmdline.opt"
	{ "preprocessor", required_argument, 0, OPTION_PREPROCESSOR },
#line 140 "cmdline.opt"
	{ "no-preprocessor", no_argument, 0, OPTION_NO_PREPROCESSOR },
#line 146 "cmdline.opt"
	{ "include-directory", required_argument, 0, 'I' },
#line 152 "cmdline.opt"
	{ "no-include", no_argument, 0, OPTION_NO_INCLUDE },
#line 158 "cmdline.opt"
	{ "define", required_argument, 0, 'D' },
#line 164 "cmdline.opt"
	{ "undefine", required_argument, 0, 'U' },
#line 172 "cmdline.opt"
	{ "reload", no_argument, 0, 'r' },
#line 180 "cmdline.opt"
	{ "restart-component", no_argument, 0, 'R' },
#line 187 "cmdline.opt"
	{ "status", no_argument, 0, 's' },
#line 194 "cmdline.opt"
	{ "stop", no_argument, 0, 'S' },
#line 203 "cmdline.opt"
	{ "dump-depmap", no_argument, 0, OPTION_DUMP_DEPMAP },
#line 210 "cmdline.opt"
	{ "trace-depend", no_argument, 0, OPTION_TRACE_DEPEND },
#line 217 "cmdline.opt"
	{ "trace-prereq", no_argument, 0, OPTION_TRACE_PREREQ },
#line 224 "cmdline.opt"
	{ "source-info", no_argument, 0, OPTION_SOURCE_INFO },
#line 230 "cmdline.opt"
	{ "debug", required_argument, 0, 'x' },
#line 236 "cmdline.opt"
	{ "help", no_argument, 0, 'h' },
#line 236 "cmdline.opt"
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 236 "cmdline.opt"
	{ "version", no_argument, 0, 'V' },
#line 236 "cmdline.opt"
	{0, 0, 0, 0}
#line 236
};
#line 236
#endif
#line 236

#line 236
static struct grecs_opthelp opthelp[] = {
#line 26 "cmdline.opt"
	{ NULL, NULL, 0, N_("Operation Mode") },
#line 30 "cmdline.opt"
	{
#line 30
#ifdef HAVE_GETOPT_LONG
#line 30
	  "-c, --config-file",
#line 30
#else
#line 30
	  "-c",
#line 30
#endif
#line 30
				   N_("FILE"), 0, N_("use FILE instead of the default configuration") },
#line 36 "cmdline.opt"
	{
#line 36
#ifdef HAVE_GETOPT_LONG
#line 36
	  "--config-help",
#line 36
#else
#line 36
	  "",
#line 36
#endif
#line 36
				   NULL, 0, N_("show configuration file summary") },
#line 43 "cmdline.opt"
	{
#line 43
#ifdef HAVE_GETOPT_LONG
#line 43
	  "-E",
#line 43
#else
#line 43
	  "-E",
#line 43
#endif
#line 43
				   NULL, 0, N_("preprocess configuration file and exit") },
#line 49 "cmdline.opt"
	{
#line 49
#ifdef HAVE_GETOPT_LONG
#line 49
	  "--force",
#line 49
#else
#line 49
	  "",
#line 49
#endif
#line 49
				   NULL, 0, N_("force startup even if another instance may be running") },
#line 55 "cmdline.opt"
	{
#line 55
#ifdef HAVE_GETOPT_LONG
#line 55
	  "--foreground",
#line 55
#else
#line 55
	  "",
#line 55
#endif
#line 55
				   NULL, 0, N_("remain in foreground") },
#line 62 "cmdline.opt"
	{
#line 62
#ifdef HAVE_GETOPT_LONG
#line 62
	  "--no-init",
#line 62
#else
#line 62
	  "",
#line 62
#endif
#line 62
				   NULL, 0, N_("don't suppose SysV init mode if PID is 1") },
#line 68 "cmdline.opt"
	{
#line 68
#ifdef HAVE_GETOPT_LONG
#line 68
	  "-i, --inetd",
#line 68
#else
#line 68
	  "-i",
#line 68
#endif
#line 68
				   NULL, 0, N_("run in inetd mode") },
#line 77 "cmdline.opt"
	{
#line 77
#ifdef HAVE_GETOPT_LONG
#line 77
	  "--instance",
#line 77
#else
#line 77
	  "",
#line 77
#endif
#line 77
				   N_("NAME"), 0, N_("set instance name") },
#line 83 "cmdline.opt"
	{
#line 83
#ifdef HAVE_GETOPT_LONG
#line 83
	  "--rate",
#line 83
#else
#line 83
	  "",
#line 83
#endif
#line 83
				   N_("NUMBER"), 0, N_("set default maximum rate for inetd-style components") },
#line 95 "cmdline.opt"
	{
#line 95
#ifdef HAVE_GETOPT_LONG
#line 95
	  "--stderr",
#line 95
#else
#line 95
	  "",
#line 95
#endif
#line 95
				   NULL, 0, N_("log to stderr") },
#line 101 "cmdline.opt"
	{
#line 101
#ifdef HAVE_GETOPT_LONG
#line 101
	  "--syntax",
#line 101
#else
#line 101
	  "",
#line 101
#endif
#line 101
				   N_("{pies|meta1|inetd|inittab}"), 0, N_("expect configuration files in the given syntax") },
#line 112 "cmdline.opt"
	{
#line 112
#ifdef HAVE_GETOPT_LONG
#line 112
	  "--syslog",
#line 112
#else
#line 112
	  "",
#line 112
#endif
#line 112
				   NULL, 0, N_("log to syslog") },
#line 118 "cmdline.opt"
	{
#line 118
#ifdef HAVE_GETOPT_LONG
#line 118
	  "-t, --lint",
#line 118
#else
#line 118
	  "-t",
#line 118
#endif
#line 118
				   NULL, 0, N_("parse configuration file and exit") },
#line 123 "cmdline.opt"
#if PIES_SYSVINIT_ENABLED
#line 126 "cmdline.opt"
	{
#line 126
#ifdef HAVE_GETOPT_LONG
#line 126
	  "-T, --telinit",
#line 126
#else
#line 126
	  "-T",
#line 126
#endif
#line 126
				   NULL, 0, N_("telinit command: run \"pies -T --help\" for help") },
#line 130 "cmdline.opt"
#endif
#line 132 "cmdline.opt"
	{ NULL, NULL, 0, N_("Preprocessor") },
#line 136 "cmdline.opt"
	{
#line 136
#ifdef HAVE_GETOPT_LONG
#line 136
	  "--preprocessor",
#line 136
#else
#line 136
	  "",
#line 136
#endif
#line 136
				   N_("COMMAND"), 0, N_("use COMMAND instead of the default preprocessor") },
#line 142 "cmdline.opt"
	{
#line 142
#ifdef HAVE_GETOPT_LONG
#line 142
	  "--no-preprocessor",
#line 142
#else
#line 142
	  "",
#line 142
#endif
#line 142
				   NULL, 0, N_("disable preprocessing") },
#line 148 "cmdline.opt"
	{
#line 148
#ifdef HAVE_GETOPT_LONG
#line 148
	  "-I, --include-directory",
#line 148
#else
#line 148
	  "-I",
#line 148
#endif
#line 148
				   N_("DIR"), 0, N_("add include directory") },
#line 154 "cmdline.opt"
	{
#line 154
#ifdef HAVE_GETOPT_LONG
#line 154
	  "--no-include",
#line 154
#else
#line 154
	  "",
#line 154
#endif
#line 154
				   NULL, 0, N_("clear default preprocessor search path") },
#line 160 "cmdline.opt"
	{
#line 160
#ifdef HAVE_GETOPT_LONG
#line 160
	  "-D, --define",
#line 160
#else
#line 160
	  "-D",
#line 160
#endif
#line 160
				   N_("NAME[=VALUE]"), 0, N_("define a preprocessor symbol NAME as having VALUE or empty") },
#line 166 "cmdline.opt"
	{
#line 166
#ifdef HAVE_GETOPT_LONG
#line 166
	  "-U, --undefine",
#line 166
#else
#line 166
	  "-U",
#line 166
#endif
#line 166
				   N_("NAME"), 0, N_("undefine a preprocessor symbol NAME") },
#line 170 "cmdline.opt"
	{ NULL, NULL, 0, N_("Component Management") },
#line 175 "cmdline.opt"
	{
#line 175
#ifdef HAVE_GETOPT_LONG
#line 175
	  "-r, --reload",
#line 175
#else
#line 175
	  "-r",
#line 175
#endif
#line 175
				   NULL, 0, N_("reload the running instance of pies") },
#line 182 "cmdline.opt"
	{
#line 182
#ifdef HAVE_GETOPT_LONG
#line 182
	  "-R, --restart-component",
#line 182
#else
#line 182
	  "-R",
#line 182
#endif
#line 182
				   NULL, 0, N_("restart components named in the command line") },
#line 189 "cmdline.opt"
	{
#line 189
#ifdef HAVE_GETOPT_LONG
#line 189
	  "-s, --status",
#line 189
#else
#line 189
	  "-s",
#line 189
#endif
#line 189
				   NULL, 0, N_("display info about the running instance") },
#line 196 "cmdline.opt"
	{
#line 196
#ifdef HAVE_GETOPT_LONG
#line 196
	  "-S, --stop",
#line 196
#else
#line 196
	  "-S",
#line 196
#endif
#line 196
				   NULL, 0, N_("stop the running instance") },
#line 201 "cmdline.opt"
	{ NULL, NULL, 0, N_("Debugging and Additional Diagnostics") },
#line 205 "cmdline.opt"
	{
#line 205
#ifdef HAVE_GETOPT_LONG
#line 205
	  "--dump-depmap",
#line 205
#else
#line 205
	  "",
#line 205
#endif
#line 205
				   NULL, 0, N_("dump dependency map") },
#line 212 "cmdline.opt"
	{
#line 212
#ifdef HAVE_GETOPT_LONG
#line 212
	  "--trace-depend",
#line 212
#else
#line 212
	  "",
#line 212
#endif
#line 212
				   NULL, 0, N_("trace dependencies") },
#line 219 "cmdline.opt"
	{
#line 219
#ifdef HAVE_GETOPT_LONG
#line 219
	  "--trace-prereq",
#line 219
#else
#line 219
	  "",
#line 219
#endif
#line 219
				   NULL, 0, N_("trace prerequisites") },
#line 226 "cmdline.opt"
	{
#line 226
#ifdef HAVE_GETOPT_LONG
#line 226
	  "--source-info",
#line 226
#else
#line 226
	  "",
#line 226
#endif
#line 226
				   NULL, 0, N_("show source info with debugging messages") },
#line 232 "cmdline.opt"
	{
#line 232
#ifdef HAVE_GETOPT_LONG
#line 232
	  "-x, --debug",
#line 232
#else
#line 232
	  "-x",
#line 232
#endif
#line 232
				   N_("LEVEL"), 0, N_("set debug verbosity level") },
#line 236 "cmdline.opt"
	{ NULL, NULL, 0, N_("Other options") },
#line 236 "cmdline.opt"
	{
#line 236
#ifdef HAVE_GETOPT_LONG
#line 236
	  "-h, --help",
#line 236
#else
#line 236
	  "-h",
#line 236
#endif
#line 236
				   NULL, 0, N_("Give this help list") },
#line 236 "cmdline.opt"
	{
#line 236
#ifdef HAVE_GETOPT_LONG
#line 236
	  "--usage",
#line 236
#else
#line 236
	  "",
#line 236
#endif
#line 236
				   NULL, 0, N_("Give a short usage message") },
#line 236 "cmdline.opt"
	{
#line 236
#ifdef HAVE_GETOPT_LONG
#line 236
	  "-V, --version",
#line 236
#else
#line 236
	  "-V",
#line 236
#endif
#line 236
				   NULL, 0, N_("Print program version") },
#line 236 "cmdline.opt"
};
#line 19 "cmdline.opt"

#line 19

#line 19
#ifndef PACKAGE_URL
#line 19
# define PACKAGE_URL NULL
#line 19
#endif
#line 19
static struct grecs_proginfo proginfo = {
#line 19
	"pies", /* progname */
#line 19
	NULL, /* subcommands */
#line 19
	N_("process invocation and execution supervisor"), /* docstring */
#line 19
	"", /* args_doc */
#line 19
	opthelp, /* opthelp */
#line 19
	sizeof(opthelp)/sizeof(opthelp[0]), /* optcount */
#line 19
	NULL, /* print_help_hook */
#line 19
	NULL, /* print_version_hook */
#line 19
	PACKAGE_NAME,    /* package */
#line 19
	PACKAGE_VERSION, /* version */
#line 19
	NULL, /* license */
#line 19
	"2008-2022",/* copyright_year */
#line 19
	"Sergey Poznyakoff", /* copyright_holder */
#line 19
	NULL, /* *authors */
#line 19
	"<" PACKAGE_BUGREPORT ">", /* bug_address */
#line 19
	PACKAGE_URL, /* url */
#line 19
	NULL  /* epilogue */
#line 19
};
#line 19

#line 123 "cmdline.opt"
#if PIES_SYSVINIT_ENABLED
#line 130 "cmdline.opt"
#endif
#line 236 "cmdline.opt"

#line 236


static void
pies_help_hook (FILE *fp)
{
  if (DEFAULT_PREPROCESSOR)
    {
      char *p;

      fprintf (fp, _("This pies preprocesses its configuration using %s\n"),
               DEFAULT_PREPROCESSOR);
      fprintf (fp, _("Preprocessor include path: %s\n"),
               DEFAULT_INCLUDE_PATH);
    }
  else
    fprintf (fp, _("This pies does not use configuration preprocessor.\n"));
  fputc ('\n', fp);
}

void
parse_options (int *pargc, char ***pargv)
{
  int argc = *pargc;
  char **argv = *pargv;
  int index;

  proginfo.print_help_hook = pies_help_hook;
  if (SYSVINIT_ACTIVE)
    {
      sysvinit_parse_argv (argc, argv);
      index = argc;
    }
  else
    {
      
#line 270
 {
#line 270
  int c;
#line 270

#line 270
  optind = 0;
#line 270
#ifdef HAVE_GETOPT_LONG
#line 270
  while ((c = getopt_long(argc, argv, "c:EitTI:D:U:rRsSx:hV",
#line 270
			  long_options, NULL)) != EOF)
#line 270
#else
#line 270
  while ((c = getopt(argc, argv, "c:EitTI:D:U:rRsSx:hV")) != EOF)
#line 270
#endif
#line 270
    {
#line 270
      switch (c)
#line 270
	{
#line 270
	default:
#line 270
	   	   exit(EX_USAGE);
#line 270
	#line 30 "cmdline.opt"
	 case 'c':
#line 30
	  {
#line 30

  config_file_add (current_syntax, optarg);

#line 32
	     break;
#line 32
	  }
#line 36 "cmdline.opt"
	 case OPTION_CONFIG_HELP:
#line 36
	  {
#line 36

  config_help ();
  exit (0);

#line 39
	     break;
#line 39
	  }
#line 43 "cmdline.opt"
	 case 'E':
#line 43
	  {
#line 43

  preprocess_only = 1;

#line 45
	     break;
#line 45
	  }
#line 49 "cmdline.opt"
	 case OPTION_FORCE:
#line 49
	  {
#line 49

  force_option = 1;

#line 51
	     break;
#line 51
	  }
#line 55 "cmdline.opt"
	 case OPTION_FOREGROUND:
#line 55
	  {
#line 55

  log_to_stderr_only = 1;
  foreground = 1;

#line 58
	     break;
#line 58
	  }
#line 62 "cmdline.opt"
	 case OPTION_NO_INIT:
#line 62
	  {
#line 62

  /* handled separately */

#line 64
	     break;
#line 64
	  }
#line 68 "cmdline.opt"
	 case 'i':
#line 68
	  {
#line 68

  if (!instance)
    instance = "inetd";
  current_syntax = &config_syntax_tab[CONF_INETD];
  inetd_mode = 1;

#line 73
	     break;
#line 73
	  }
#line 77 "cmdline.opt"
	 case OPTION_INSTANCE:
#line 77
	  {
#line 77

  instance = optarg;

#line 79
	     break;
#line 79
	  }
#line 83 "cmdline.opt"
	 case OPTION_RATE:
#line 83
	  {
#line 83

  char *p;
  default_max_rate = strtoul (optarg, &p, 10);
  if (*p)
    {
      logmsg (LOG_ERR, _("not a number: %s"), optarg);
      exit (EX_USAGE);
    }

#line 91
	     break;
#line 91
	  }
#line 95 "cmdline.opt"
	 case OPTION_STDERR:
#line 95
	  {
#line 95

  log_to_stderr_only = 1;

#line 97
	     break;
#line 97
	  }
#line 101 "cmdline.opt"
	 case OPTION_SYNTAX:
#line 101
	  {
#line 101

  current_syntax = str_to_config_syntax (optarg);
  if (!current_syntax)
    {
      logmsg (LOG_ERR, _("unknown syntax type: %s"), optarg);
      exit (EX_USAGE);
    }

#line 108
	     break;
#line 108
	  }
#line 112 "cmdline.opt"
	 case OPTION_SYSLOG:
#line 112
	  {
#line 112

  log_to_stderr_only = 0;

#line 114
	     break;
#line 114
	  }
#line 118 "cmdline.opt"
	 case 't':
#line 118
	  {
#line 118

  log_to_stderr_only = 1;
  lint_mode = 1;

#line 121
	     break;
#line 121
	  }
#line 123 "cmdline.opt"
#if PIES_SYSVINIT_ENABLED
#line 126 "cmdline.opt"
	 case 'T':
#line 126
	  {
#line 126

  log_to_stderr_only = 1;
  exit (telinit (argc - (optind - 1), argv + (optind - 1)));

#line 129
	     break;
#line 129
	  }
#line 130 "cmdline.opt"
#endif
#line 136 "cmdline.opt"
	 case OPTION_PREPROCESSOR:
#line 136
	  {
#line 136

    grecs_preprocessor = optarg;

#line 138
	     break;
#line 138
	  }
#line 142 "cmdline.opt"
	 case OPTION_NO_PREPROCESSOR:
#line 142
	  {
#line 142

    grecs_preprocessor = NULL;

#line 144
	     break;
#line 144
	  }
#line 148 "cmdline.opt"
	 case 'I':
#line 148
	  {
#line 148

  pp_add_option ("-I", optarg);

#line 150
	     break;
#line 150
	  }
#line 154 "cmdline.opt"
	 case OPTION_NO_INCLUDE:
#line 154
	  {
#line 154

  incpath = NULL;

#line 156
	     break;
#line 156
	  }
#line 160 "cmdline.opt"
	 case 'D':
#line 160
	  {
#line 160

  pp_add_option ("-D", optarg);

#line 162
	     break;
#line 162
	  }
#line 166 "cmdline.opt"
	 case 'U':
#line 166
	  {
#line 166

  pp_add_option ("-U", optarg);

#line 168
	     break;
#line 168
	  }
#line 175 "cmdline.opt"
	 case 'r':
#line 175
	  {
#line 175

  log_to_stderr_only = 1;
  command = COM_RELOAD;

#line 178
	     break;
#line 178
	  }
#line 182 "cmdline.opt"
	 case 'R':
#line 182
	  {
#line 182

  log_to_stderr_only = 1;
  command = COM_RESTART_COMPONENT;

#line 185
	     break;
#line 185
	  }
#line 189 "cmdline.opt"
	 case 's':
#line 189
	  {
#line 189

  log_to_stderr_only = 1;
  command = COM_STATUS;

#line 192
	     break;
#line 192
	  }
#line 196 "cmdline.opt"
	 case 'S':
#line 196
	  {
#line 196

  log_to_stderr_only = 1;
  command = COM_STOP;

#line 199
	     break;
#line 199
	  }
#line 205 "cmdline.opt"
	 case OPTION_DUMP_DEPMAP:
#line 205
	  {
#line 205

  log_to_stderr_only = 1;
  command = COM_DUMP_DEPMAP;

#line 208
	     break;
#line 208
	  }
#line 212 "cmdline.opt"
	 case OPTION_TRACE_DEPEND:
#line 212
	  {
#line 212

  log_to_stderr_only = 1;
  command = COM_TRACE_DEPEND;  

#line 215
	     break;
#line 215
	  }
#line 219 "cmdline.opt"
	 case OPTION_TRACE_PREREQ:
#line 219
	  {
#line 219

  log_to_stderr_only = 1;
  command = COM_TRACE_PREREQ;  

#line 222
	     break;
#line 222
	  }
#line 226 "cmdline.opt"
	 case OPTION_SOURCE_INFO:
#line 226
	  {
#line 226

  source_info_option = 1;

#line 228
	     break;
#line 228
	  }
#line 232 "cmdline.opt"
	 case 'x':
#line 232
	  {
#line 232

  debug_level = strtoul (optarg, NULL, 0);

#line 234
	     break;
#line 234
	  }
#line 236 "cmdline.opt"
	 case 'h':
#line 236
	  {
#line 236

#line 236
		grecs_print_help(&proginfo);
#line 236
		exit(0);
#line 236
	 
#line 236
	     break;
#line 236
	  }
#line 236 "cmdline.opt"
	 case OPTION_USAGE:
#line 236
	  {
#line 236

#line 236
		grecs_print_usage(&proginfo);
#line 236
		exit(0);
#line 236
	 
#line 236
	     break;
#line 236
	  }
#line 236 "cmdline.opt"
	 case 'V':
#line 236
	  {
#line 236

#line 236
	        /* Give version */
#line 236
		grecs_print_version(&proginfo, stdout);
#line 236
		exit(0);
#line 236
	 
#line 236
	     break;
#line 236
	  }

#line 270 "cmdline.opt"
	}
#line 270
    }
#line 270
  index = optind;
#line 270
 }
#line 270
;
      pp_init (incpath);
    }
  *pargc -= index;
  *pargv += index;
}
