<?php

//        # Copyright (C) 2012-2013 GNU remotecontrol authors.
//        #
//        # This program is free software: you can redistribute it and/or modify
//        # it under the terms of the GNU Affero General Public License as
//        # published by the Free Software Foundation, either version 3 of the
//        # License, or (at your option) any later version.
//        #
//        # This program is distributed in the hope that it will be useful,
//        # but WITHOUT ANY WARRANTY; without even the implied warranty of
//        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//        # GNU Affero General Public License for more details.
//        #
//        # You should have received a copy of the GNU Affero General Public License
//        # along with this program.  If not, see <http://www.gnu.org/licenses/>.

	class TransactionLogRecordCollection extends ArrayObject
	{
		// Constructor
		public function __construct($loadData)
		{
			if($loadData)
			{
				$this->Load();
			}
		}

		// Methods
		public function Load($userId)
		{
			$dataAccess = new MySqlDataAccess(Common::ConnectionString);
			$dataAccess->Command->CommandType = CommandType::StoredProcedure;
			$dataAccess->Command->CommandText = "CALL sp_Transaction_Log_Load_All($userId)";
			$dataAccess->GetData();

			if($dataAccess->ResultSet)
			{
				while($row = $dataAccess->ResultSet->fetch_assoc())
				{
					$this->append(new TransactionLogRecord(intval($row['TransactionId']), intval($row['ThermostatId']),
						$row['OID'], $row['OldValue'], $row['NewValue'], $row['TransactionTimeStamp']));
				}
			}

			$dataAccess->Cleanup();
		}
	}

?>
