<?php

//        # Copyright (C) 2012-2013 GNU remotecontrol authors.
//        #
//        # This program is free software: you can redistribute it and/or modify
//        # it under the terms of the GNU Affero General Public License as
//        # published by the Free Software Foundation, either version 3 of the
//        # License, or (at your option) any later version.
//        #
//        # This program is distributed in the hope that it will be useful,
//        # but WITHOUT ANY WARRANTY; without even the implied warranty of
//        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//        # GNU Affero General Public License for more details.
//        #
//        # You should have received a copy of the GNU Affero General Public License
//        # along with this program.  If not, see <http://www.gnu.org/licenses/>.

class Common
{
	// Properties
	const ConnectionString = 'Host=localhost;DB=iptstat;UN=tstatuser;PW=Yell0w';

        // Methods
        public static function ConstructTZODDLItems($selectedOffsetValue = null)
        {
            $timeZoneOffsets = new TimeZoneOffsetCollection(true);
            $resourcesGRCHM_CLM9 = new ResourceCollection(true, 'GRCHM$CLM9', null, 1, true);
            $GRCHM_CLM9_DDI1 = $resourcesGRCHM_CLM9->FindResourceByCode('GRCHM$CLM9$DDI1');

            $output = '';
            $output .= '<option value="'.$GRCHM_CLM9_DDI1->DropDownItemValue.'">'.$GRCHM_CLM9_DDI1->Value.'</option>';

            foreach($timeZoneOffsets as $timeZoneOffset)
            {
                if ($selectedOffsetValue != null && $timeZoneOffset->ID == $selectedOffsetValue)
                {
                    $output .= '<option value="'.$timeZoneOffset->ID.'" selected>'.$timeZoneOffset->Description.'</option>';
                }
                else
                {
                    $output .= '<option value="'.$timeZoneOffset->ID.'">'.$timeZoneOffset->Description.'</option>';
                }
            }

            return $output;
        }

        public static function ConstructLangDDLItems($selectedLangValue = null)
        {
            $languages = new LanguageCollection(true);
            $output = '';

            foreach($languages as $language)
            {
                if ($selectedLangValue != null && $language->Code == $selectedLangValue)
                {
                    $output .= '<option value="'.$language->Code.'" selected>'.$language->Description.'</option>';
                }
                else
                {
                    $output .= '<option value="'.$language->Code.'">'.$language->Description.'</option>';
                }
            }

            return $output;
        }

		public static function ConstructGroupDDLItems($selectedGroupValue = null)
        {
            $groups = new IPThermostatGroupCollection(true);
			$resourcesGRCHM_CLM10 = new ResourceCollection(true, 'GRCHM$CLM10', null, 1, true);
            $GRCHM_CLM10_DDI1 = $resourcesGRCHM_CLM10->FindResourceByCode('GRCHM$CLM10$DDL1');

            $output = '';
            $output .= '<option value="'.$GRCHM_CLM10_DDI1->DropDownItemValue.'">'.$GRCHM_CLM10_DDI1->Value.'</option>';

            foreach($groups as $group)
            {
                if ($selectedGroupValue != null && $group->ID == $selectedGroupValue)
                {
                    $output .= '<option value="'.$group->ID.'" selected>'.$group->Name.'</option>';
                }
                else
                {
                    $output .= '<option value="'.$group->ID.'">'.$group->Name.'</option>';
                }
            }

            return $output;
        }

        public static function GetAppName()
        {
            $currentUser = $_SESSION['User'];
            $GRC = new Resource();
            $GRC->LoadByCode('GRC', $currentUser->Language->Code);

            return $GRC->Value;
        }

}

?>
