# Solfege - free ear training software
# Copyright (C) 2007, 2008 Tom Cato Amundsen
# License is GPL, see file COPYING

import unittest
from mpd.mpdutils import *

class TestMpdUtils(unittest.TestCase):
    def test_1(self):
        self.assertEquals((0, 1), find_possible_first_note("d e"))
        self.assertEquals((1, 3), find_possible_first_note("<d'4 e>"))
        self.assertEquals((11, 12), find_possible_first_note(r"\clef bass <3X d'4 e>"))
        self.assertEquals((12, 14), find_possible_first_note(r"\clef bass <d'4 e>"))
        self.assertEquals((10, 12), find_possible_first_note(r"\time 3/4 d'4 e "))
        self.assertEquals((13, 15), find_possible_first_note(r"\times 3/4 { d'4 e }"))
        self.assertEquals((1, 2), find_possible_first_note(r"[c8 d]"))
    def test_validate_only_notenames(self):
        self.assertEquals(validate_only_notenames("c e g"), (None, None, None))
        self.assertEquals(validate_only_notenames("c4 e2 g"), (None, None, None))
        self.assertEquals(validate_only_notenames("c4 e2 g~ g"), (0, 7, 8))
        self.assertEquals(validate_only_notenames("c4 [e8 e] "), (0, 3, 4))
        self.assertEquals(validate_only_notenames("c ERR g"), (0, 2, 5))
        self.assertEquals(validate_only_notenames("c\nERR\ng"), (1, 0, 3))
        self.assertEquals(validate_only_notenames("c\n  ERR\ng"), (1, 2, 5))

suite = unittest.makeSuite(TestMpdUtils)

