#!/bin/sh

#
#  Add a newline after the file and control_file object keywords
#  to enable the awk program to decipher the multi-line records.
#

(
sed    -e 's/^[[:space:][:space:]]*//' -e '/^$/d' -e 's/#.*//' |
sed    -e 's/^[[:space:][:space:]]*file.*/\
file/' -e 's/^[[:space:][:space:]]*control_file.*/\
control_file/' |
awk -- '
BEGIN { RS = ""; FS="\n"; }
{
	#print $0
	if (/[ \t]*file[# \t]*/) { 
		#printf ("HERE %s\n", $0);
		path = field("path"); 
		md5sum = field("md5sum");
		group = field("group");
		owner = field("owner");
		mode = field("mode");
		type = field("type");
		mtime = field("mtime");
			printf("%s:md5sum:%s\n", path, md5sum); 
			printf("%s:type:%s\n", path, type); 
			printf("%s:mode:%s\n", path, mode); 
			printf("%s:owner:%s\n", path, owner); 
			printf("%s:group:%s\n", path, group); 
			printf("%s:mtime:%s\n", path, mtime); 
			printf("\n"); 
		next;
	}
}
END {  }
function field(name,	i,f) {
	#printf("NF = %d  NR = %d\n", NF, NR);
	for (i = 1; i <= NF; i++) {
		#printf ("IIII %s\n", $i);
		split($i, f, " ")
		if (f[1] == name)
		     return f[2]
        }
	printf("error: no field %s in record\n", name)  | "cat 1>&2"
}
'
) 2>/dev/null 

