--
-- This file is part of TALER
-- Copyright (C) 2014--2024 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE TABLE IF NOT EXISTS auditor_fee_time_inconsistency
(
    row_id BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE PRIMARY KEY,
    problem_row_id BIGINT NOT NULL,
    fee_type BYTEA NOT NULL,
    fee_time BIGINT NOT NULL,
    diagnostic BYTEA NOT NULL,
    suppressed BOOLEAN NOT NULL DEFAULT FALSE
);
COMMENT ON TABLE auditor_fee_time_inconsistency
    IS 'Report a (serious) fee time inconsistency in the exchange''s database';
