var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn2, res) => function __init() {
  return fn2 && (res = (0, fn2[__getOwnPropNames(fn2)[0]])(fn2 = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name2 in all)
    __defProp(target, name2, { get: all[name2], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// ../../node_modules/.pnpm/big-integer@1.6.52/node_modules/big-integer/BigInteger.js
var require_BigInteger = __commonJS({
  "../../node_modules/.pnpm/big-integer@1.6.52/node_modules/big-integer/BigInteger.js"(exports, module) {
    var bigInt = function(undefined2) {
      "use strict";
      var BASE = 1e7, LOG_BASE = 7, MAX_INT = 9007199254740992, MAX_INT_ARR = smallToArray(MAX_INT), DEFAULT_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz";
      var supportsNativeBigInt = typeof BigInt === "function";
      function Integer(v3, radix, alphabet, caseSensitive) {
        if (typeof v3 === "undefined")
          return Integer[0];
        if (typeof radix !== "undefined")
          return +radix === 10 && !alphabet ? parseValue(v3) : parseBase(v3, radix, alphabet, caseSensitive);
        return parseValue(v3);
      }
      function BigInteger(value, sign2) {
        this.value = value;
        this.sign = sign2;
        this.isSmall = false;
      }
      BigInteger.prototype = Object.create(Integer.prototype);
      function SmallInteger(value) {
        this.value = value;
        this.sign = value < 0;
        this.isSmall = true;
      }
      SmallInteger.prototype = Object.create(Integer.prototype);
      function NativeBigInt(value) {
        this.value = value;
      }
      NativeBigInt.prototype = Object.create(Integer.prototype);
      function isPrecise(n2) {
        return -MAX_INT < n2 && n2 < MAX_INT;
      }
      function smallToArray(n2) {
        if (n2 < 1e7)
          return [n2];
        if (n2 < 1e14)
          return [n2 % 1e7, Math.floor(n2 / 1e7)];
        return [n2 % 1e7, Math.floor(n2 / 1e7) % 1e7, Math.floor(n2 / 1e14)];
      }
      function arrayToSmall(arr) {
        trim(arr);
        var length = arr.length;
        if (length < 4 && compareAbs(arr, MAX_INT_ARR) < 0) {
          switch (length) {
            case 0:
              return 0;
            case 1:
              return arr[0];
            case 2:
              return arr[0] + arr[1] * BASE;
            default:
              return arr[0] + (arr[1] + arr[2] * BASE) * BASE;
          }
        }
        return arr;
      }
      function trim(v3) {
        var i6 = v3.length;
        while (v3[--i6] === 0)
          ;
        v3.length = i6 + 1;
      }
      function createArray(length) {
        var x6 = new Array(length);
        var i6 = -1;
        while (++i6 < length) {
          x6[i6] = 0;
        }
        return x6;
      }
      function truncate(n2) {
        if (n2 > 0)
          return Math.floor(n2);
        return Math.ceil(n2);
      }
      function add4(a6, b5) {
        var l_a = a6.length, l_b = b5.length, r3 = new Array(l_a), carry = 0, base2 = BASE, sum, i6;
        for (i6 = 0; i6 < l_b; i6++) {
          sum = a6[i6] + b5[i6] + carry;
          carry = sum >= base2 ? 1 : 0;
          r3[i6] = sum - carry * base2;
        }
        while (i6 < l_a) {
          sum = a6[i6] + carry;
          carry = sum === base2 ? 1 : 0;
          r3[i6++] = sum - carry * base2;
        }
        if (carry > 0)
          r3.push(carry);
        return r3;
      }
      function addAny(a6, b5) {
        if (a6.length >= b5.length)
          return add4(a6, b5);
        return add4(b5, a6);
      }
      function addSmall(a6, carry) {
        var l3 = a6.length, r3 = new Array(l3), base2 = BASE, sum, i6;
        for (i6 = 0; i6 < l3; i6++) {
          sum = a6[i6] - base2 + carry;
          carry = Math.floor(sum / base2);
          r3[i6] = sum - carry * base2;
          carry += 1;
        }
        while (carry > 0) {
          r3[i6++] = carry % base2;
          carry = Math.floor(carry / base2);
        }
        return r3;
      }
      BigInteger.prototype.add = function(v3) {
        var n2 = parseValue(v3);
        if (this.sign !== n2.sign) {
          return this.subtract(n2.negate());
        }
        var a6 = this.value, b5 = n2.value;
        if (n2.isSmall) {
          return new BigInteger(addSmall(a6, Math.abs(b5)), this.sign);
        }
        return new BigInteger(addAny(a6, b5), this.sign);
      };
      BigInteger.prototype.plus = BigInteger.prototype.add;
      SmallInteger.prototype.add = function(v3) {
        var n2 = parseValue(v3);
        var a6 = this.value;
        if (a6 < 0 !== n2.sign) {
          return this.subtract(n2.negate());
        }
        var b5 = n2.value;
        if (n2.isSmall) {
          if (isPrecise(a6 + b5))
            return new SmallInteger(a6 + b5);
          b5 = smallToArray(Math.abs(b5));
        }
        return new BigInteger(addSmall(b5, Math.abs(a6)), a6 < 0);
      };
      SmallInteger.prototype.plus = SmallInteger.prototype.add;
      NativeBigInt.prototype.add = function(v3) {
        return new NativeBigInt(this.value + parseValue(v3).value);
      };
      NativeBigInt.prototype.plus = NativeBigInt.prototype.add;
      function subtract(a6, b5) {
        var a_l = a6.length, b_l = b5.length, r3 = new Array(a_l), borrow = 0, base2 = BASE, i6, difference;
        for (i6 = 0; i6 < b_l; i6++) {
          difference = a6[i6] - borrow - b5[i6];
          if (difference < 0) {
            difference += base2;
            borrow = 1;
          } else
            borrow = 0;
          r3[i6] = difference;
        }
        for (i6 = b_l; i6 < a_l; i6++) {
          difference = a6[i6] - borrow;
          if (difference < 0)
            difference += base2;
          else {
            r3[i6++] = difference;
            break;
          }
          r3[i6] = difference;
        }
        for (; i6 < a_l; i6++) {
          r3[i6] = a6[i6];
        }
        trim(r3);
        return r3;
      }
      function subtractAny(a6, b5, sign2) {
        var value;
        if (compareAbs(a6, b5) >= 0) {
          value = subtract(a6, b5);
        } else {
          value = subtract(b5, a6);
          sign2 = !sign2;
        }
        value = arrayToSmall(value);
        if (typeof value === "number") {
          if (sign2)
            value = -value;
          return new SmallInteger(value);
        }
        return new BigInteger(value, sign2);
      }
      function subtractSmall(a6, b5, sign2) {
        var l3 = a6.length, r3 = new Array(l3), carry = -b5, base2 = BASE, i6, difference;
        for (i6 = 0; i6 < l3; i6++) {
          difference = a6[i6] + carry;
          carry = Math.floor(difference / base2);
          difference %= base2;
          r3[i6] = difference < 0 ? difference + base2 : difference;
        }
        r3 = arrayToSmall(r3);
        if (typeof r3 === "number") {
          if (sign2)
            r3 = -r3;
          return new SmallInteger(r3);
        }
        return new BigInteger(r3, sign2);
      }
      BigInteger.prototype.subtract = function(v3) {
        var n2 = parseValue(v3);
        if (this.sign !== n2.sign) {
          return this.add(n2.negate());
        }
        var a6 = this.value, b5 = n2.value;
        if (n2.isSmall)
          return subtractSmall(a6, Math.abs(b5), this.sign);
        return subtractAny(a6, b5, this.sign);
      };
      BigInteger.prototype.minus = BigInteger.prototype.subtract;
      SmallInteger.prototype.subtract = function(v3) {
        var n2 = parseValue(v3);
        var a6 = this.value;
        if (a6 < 0 !== n2.sign) {
          return this.add(n2.negate());
        }
        var b5 = n2.value;
        if (n2.isSmall) {
          return new SmallInteger(a6 - b5);
        }
        return subtractSmall(b5, Math.abs(a6), a6 >= 0);
      };
      SmallInteger.prototype.minus = SmallInteger.prototype.subtract;
      NativeBigInt.prototype.subtract = function(v3) {
        return new NativeBigInt(this.value - parseValue(v3).value);
      };
      NativeBigInt.prototype.minus = NativeBigInt.prototype.subtract;
      BigInteger.prototype.negate = function() {
        return new BigInteger(this.value, !this.sign);
      };
      SmallInteger.prototype.negate = function() {
        var sign2 = this.sign;
        var small = new SmallInteger(-this.value);
        small.sign = !sign2;
        return small;
      };
      NativeBigInt.prototype.negate = function() {
        return new NativeBigInt(-this.value);
      };
      BigInteger.prototype.abs = function() {
        return new BigInteger(this.value, false);
      };
      SmallInteger.prototype.abs = function() {
        return new SmallInteger(Math.abs(this.value));
      };
      NativeBigInt.prototype.abs = function() {
        return new NativeBigInt(this.value >= 0 ? this.value : -this.value);
      };
      function multiplyLong(a6, b5) {
        var a_l = a6.length, b_l = b5.length, l3 = a_l + b_l, r3 = createArray(l3), base2 = BASE, product, carry, i6, a_i, b_j;
        for (i6 = 0; i6 < a_l; ++i6) {
          a_i = a6[i6];
          for (var j4 = 0; j4 < b_l; ++j4) {
            b_j = b5[j4];
            product = a_i * b_j + r3[i6 + j4];
            carry = Math.floor(product / base2);
            r3[i6 + j4] = product - carry * base2;
            r3[i6 + j4 + 1] += carry;
          }
        }
        trim(r3);
        return r3;
      }
      function multiplySmall(a6, b5) {
        var l3 = a6.length, r3 = new Array(l3), base2 = BASE, carry = 0, product, i6;
        for (i6 = 0; i6 < l3; i6++) {
          product = a6[i6] * b5 + carry;
          carry = Math.floor(product / base2);
          r3[i6] = product - carry * base2;
        }
        while (carry > 0) {
          r3[i6++] = carry % base2;
          carry = Math.floor(carry / base2);
        }
        return r3;
      }
      function shiftLeft(x6, n2) {
        var r3 = [];
        while (n2-- > 0)
          r3.push(0);
        return r3.concat(x6);
      }
      function multiplyKaratsuba(x6, y6) {
        var n2 = Math.max(x6.length, y6.length);
        if (n2 <= 30)
          return multiplyLong(x6, y6);
        n2 = Math.ceil(n2 / 2);
        var b5 = x6.slice(n2), a6 = x6.slice(0, n2), d6 = y6.slice(n2), c5 = y6.slice(0, n2);
        var ac = multiplyKaratsuba(a6, c5), bd = multiplyKaratsuba(b5, d6), abcd = multiplyKaratsuba(addAny(a6, b5), addAny(c5, d6));
        var product = addAny(addAny(ac, shiftLeft(subtract(subtract(abcd, ac), bd), n2)), shiftLeft(bd, 2 * n2));
        trim(product);
        return product;
      }
      function useKaratsuba(l1, l22) {
        return -0.012 * l1 - 0.012 * l22 + 15e-6 * l1 * l22 > 0;
      }
      BigInteger.prototype.multiply = function(v3) {
        var n2 = parseValue(v3), a6 = this.value, b5 = n2.value, sign2 = this.sign !== n2.sign, abs;
        if (n2.isSmall) {
          if (b5 === 0)
            return Integer[0];
          if (b5 === 1)
            return this;
          if (b5 === -1)
            return this.negate();
          abs = Math.abs(b5);
          if (abs < BASE) {
            return new BigInteger(multiplySmall(a6, abs), sign2);
          }
          b5 = smallToArray(abs);
        }
        if (useKaratsuba(a6.length, b5.length))
          return new BigInteger(multiplyKaratsuba(a6, b5), sign2);
        return new BigInteger(multiplyLong(a6, b5), sign2);
      };
      BigInteger.prototype.times = BigInteger.prototype.multiply;
      function multiplySmallAndArray(a6, b5, sign2) {
        if (a6 < BASE) {
          return new BigInteger(multiplySmall(b5, a6), sign2);
        }
        return new BigInteger(multiplyLong(b5, smallToArray(a6)), sign2);
      }
      SmallInteger.prototype._multiplyBySmall = function(a6) {
        if (isPrecise(a6.value * this.value)) {
          return new SmallInteger(a6.value * this.value);
        }
        return multiplySmallAndArray(Math.abs(a6.value), smallToArray(Math.abs(this.value)), this.sign !== a6.sign);
      };
      BigInteger.prototype._multiplyBySmall = function(a6) {
        if (a6.value === 0)
          return Integer[0];
        if (a6.value === 1)
          return this;
        if (a6.value === -1)
          return this.negate();
        return multiplySmallAndArray(Math.abs(a6.value), this.value, this.sign !== a6.sign);
      };
      SmallInteger.prototype.multiply = function(v3) {
        return parseValue(v3)._multiplyBySmall(this);
      };
      SmallInteger.prototype.times = SmallInteger.prototype.multiply;
      NativeBigInt.prototype.multiply = function(v3) {
        return new NativeBigInt(this.value * parseValue(v3).value);
      };
      NativeBigInt.prototype.times = NativeBigInt.prototype.multiply;
      function square(a6) {
        var l3 = a6.length, r3 = createArray(l3 + l3), base2 = BASE, product, carry, i6, a_i, a_j;
        for (i6 = 0; i6 < l3; i6++) {
          a_i = a6[i6];
          carry = 0 - a_i * a_i;
          for (var j4 = i6; j4 < l3; j4++) {
            a_j = a6[j4];
            product = 2 * (a_i * a_j) + r3[i6 + j4] + carry;
            carry = Math.floor(product / base2);
            r3[i6 + j4] = product - carry * base2;
          }
          r3[i6 + l3] = carry;
        }
        trim(r3);
        return r3;
      }
      BigInteger.prototype.square = function() {
        return new BigInteger(square(this.value), false);
      };
      SmallInteger.prototype.square = function() {
        var value = this.value * this.value;
        if (isPrecise(value))
          return new SmallInteger(value);
        return new BigInteger(square(smallToArray(Math.abs(this.value))), false);
      };
      NativeBigInt.prototype.square = function(v3) {
        return new NativeBigInt(this.value * this.value);
      };
      function divMod1(a6, b5) {
        var a_l = a6.length, b_l = b5.length, base2 = BASE, result = createArray(b5.length), divisorMostSignificantDigit = b5[b_l - 1], lambda = Math.ceil(base2 / (2 * divisorMostSignificantDigit)), remainder = multiplySmall(a6, lambda), divisor = multiplySmall(b5, lambda), quotientDigit, shift, carry, borrow, i6, l3, q6;
        if (remainder.length <= a_l)
          remainder.push(0);
        divisor.push(0);
        divisorMostSignificantDigit = divisor[b_l - 1];
        for (shift = a_l - b_l; shift >= 0; shift--) {
          quotientDigit = base2 - 1;
          if (remainder[shift + b_l] !== divisorMostSignificantDigit) {
            quotientDigit = Math.floor((remainder[shift + b_l] * base2 + remainder[shift + b_l - 1]) / divisorMostSignificantDigit);
          }
          carry = 0;
          borrow = 0;
          l3 = divisor.length;
          for (i6 = 0; i6 < l3; i6++) {
            carry += quotientDigit * divisor[i6];
            q6 = Math.floor(carry / base2);
            borrow += remainder[shift + i6] - (carry - q6 * base2);
            carry = q6;
            if (borrow < 0) {
              remainder[shift + i6] = borrow + base2;
              borrow = -1;
            } else {
              remainder[shift + i6] = borrow;
              borrow = 0;
            }
          }
          while (borrow !== 0) {
            quotientDigit -= 1;
            carry = 0;
            for (i6 = 0; i6 < l3; i6++) {
              carry += remainder[shift + i6] - base2 + divisor[i6];
              if (carry < 0) {
                remainder[shift + i6] = carry + base2;
                carry = 0;
              } else {
                remainder[shift + i6] = carry;
                carry = 1;
              }
            }
            borrow += carry;
          }
          result[shift] = quotientDigit;
        }
        remainder = divModSmall(remainder, lambda)[0];
        return [arrayToSmall(result), arrayToSmall(remainder)];
      }
      function divMod2(a6, b5) {
        var a_l = a6.length, b_l = b5.length, result = [], part = [], base2 = BASE, guess, xlen, highx, highy, check;
        while (a_l) {
          part.unshift(a6[--a_l]);
          trim(part);
          if (compareAbs(part, b5) < 0) {
            result.push(0);
            continue;
          }
          xlen = part.length;
          highx = part[xlen - 1] * base2 + part[xlen - 2];
          highy = b5[b_l - 1] * base2 + b5[b_l - 2];
          if (xlen > b_l) {
            highx = (highx + 1) * base2;
          }
          guess = Math.ceil(highx / highy);
          do {
            check = multiplySmall(b5, guess);
            if (compareAbs(check, part) <= 0)
              break;
            guess--;
          } while (guess);
          result.push(guess);
          part = subtract(part, check);
        }
        result.reverse();
        return [arrayToSmall(result), arrayToSmall(part)];
      }
      function divModSmall(value, lambda) {
        var length = value.length, quotient = createArray(length), base2 = BASE, i6, q6, remainder, divisor;
        remainder = 0;
        for (i6 = length - 1; i6 >= 0; --i6) {
          divisor = remainder * base2 + value[i6];
          q6 = truncate(divisor / lambda);
          remainder = divisor - q6 * lambda;
          quotient[i6] = q6 | 0;
        }
        return [quotient, remainder | 0];
      }
      function divModAny(self2, v3) {
        var value, n2 = parseValue(v3);
        if (supportsNativeBigInt) {
          return [new NativeBigInt(self2.value / n2.value), new NativeBigInt(self2.value % n2.value)];
        }
        var a6 = self2.value, b5 = n2.value;
        var quotient;
        if (b5 === 0)
          throw new Error("Cannot divide by zero");
        if (self2.isSmall) {
          if (n2.isSmall) {
            return [new SmallInteger(truncate(a6 / b5)), new SmallInteger(a6 % b5)];
          }
          return [Integer[0], self2];
        }
        if (n2.isSmall) {
          if (b5 === 1)
            return [self2, Integer[0]];
          if (b5 == -1)
            return [self2.negate(), Integer[0]];
          var abs = Math.abs(b5);
          if (abs < BASE) {
            value = divModSmall(a6, abs);
            quotient = arrayToSmall(value[0]);
            var remainder = value[1];
            if (self2.sign)
              remainder = -remainder;
            if (typeof quotient === "number") {
              if (self2.sign !== n2.sign)
                quotient = -quotient;
              return [new SmallInteger(quotient), new SmallInteger(remainder)];
            }
            return [new BigInteger(quotient, self2.sign !== n2.sign), new SmallInteger(remainder)];
          }
          b5 = smallToArray(abs);
        }
        var comparison = compareAbs(a6, b5);
        if (comparison === -1)
          return [Integer[0], self2];
        if (comparison === 0)
          return [Integer[self2.sign === n2.sign ? 1 : -1], Integer[0]];
        if (a6.length + b5.length <= 200)
          value = divMod1(a6, b5);
        else
          value = divMod2(a6, b5);
        quotient = value[0];
        var qSign = self2.sign !== n2.sign, mod = value[1], mSign = self2.sign;
        if (typeof quotient === "number") {
          if (qSign)
            quotient = -quotient;
          quotient = new SmallInteger(quotient);
        } else
          quotient = new BigInteger(quotient, qSign);
        if (typeof mod === "number") {
          if (mSign)
            mod = -mod;
          mod = new SmallInteger(mod);
        } else
          mod = new BigInteger(mod, mSign);
        return [quotient, mod];
      }
      BigInteger.prototype.divmod = function(v3) {
        var result = divModAny(this, v3);
        return {
          quotient: result[0],
          remainder: result[1]
        };
      };
      NativeBigInt.prototype.divmod = SmallInteger.prototype.divmod = BigInteger.prototype.divmod;
      BigInteger.prototype.divide = function(v3) {
        return divModAny(this, v3)[0];
      };
      NativeBigInt.prototype.over = NativeBigInt.prototype.divide = function(v3) {
        return new NativeBigInt(this.value / parseValue(v3).value);
      };
      SmallInteger.prototype.over = SmallInteger.prototype.divide = BigInteger.prototype.over = BigInteger.prototype.divide;
      BigInteger.prototype.mod = function(v3) {
        return divModAny(this, v3)[1];
      };
      NativeBigInt.prototype.mod = NativeBigInt.prototype.remainder = function(v3) {
        return new NativeBigInt(this.value % parseValue(v3).value);
      };
      SmallInteger.prototype.remainder = SmallInteger.prototype.mod = BigInteger.prototype.remainder = BigInteger.prototype.mod;
      BigInteger.prototype.pow = function(v3) {
        var n2 = parseValue(v3), a6 = this.value, b5 = n2.value, value, x6, y6;
        if (b5 === 0)
          return Integer[1];
        if (a6 === 0)
          return Integer[0];
        if (a6 === 1)
          return Integer[1];
        if (a6 === -1)
          return n2.isEven() ? Integer[1] : Integer[-1];
        if (n2.sign) {
          return Integer[0];
        }
        if (!n2.isSmall)
          throw new Error("The exponent " + n2.toString() + " is too large.");
        if (this.isSmall) {
          if (isPrecise(value = Math.pow(a6, b5)))
            return new SmallInteger(truncate(value));
        }
        x6 = this;
        y6 = Integer[1];
        while (true) {
          if (b5 & true) {
            y6 = y6.times(x6);
            --b5;
          }
          if (b5 === 0)
            break;
          b5 /= 2;
          x6 = x6.square();
        }
        return y6;
      };
      SmallInteger.prototype.pow = BigInteger.prototype.pow;
      NativeBigInt.prototype.pow = function(v3) {
        var n2 = parseValue(v3);
        var a6 = this.value, b5 = n2.value;
        var _0 = BigInt(0), _1 = BigInt(1), _22 = BigInt(2);
        if (b5 === _0)
          return Integer[1];
        if (a6 === _0)
          return Integer[0];
        if (a6 === _1)
          return Integer[1];
        if (a6 === BigInt(-1))
          return n2.isEven() ? Integer[1] : Integer[-1];
        if (n2.isNegative())
          return new NativeBigInt(_0);
        var x6 = this;
        var y6 = Integer[1];
        while (true) {
          if ((b5 & _1) === _1) {
            y6 = y6.times(x6);
            --b5;
          }
          if (b5 === _0)
            break;
          b5 /= _22;
          x6 = x6.square();
        }
        return y6;
      };
      BigInteger.prototype.modPow = function(exp, mod) {
        exp = parseValue(exp);
        mod = parseValue(mod);
        if (mod.isZero())
          throw new Error("Cannot take modPow with modulus 0");
        var r3 = Integer[1], base2 = this.mod(mod);
        if (exp.isNegative()) {
          exp = exp.multiply(Integer[-1]);
          base2 = base2.modInv(mod);
        }
        while (exp.isPositive()) {
          if (base2.isZero())
            return Integer[0];
          if (exp.isOdd())
            r3 = r3.multiply(base2).mod(mod);
          exp = exp.divide(2);
          base2 = base2.square().mod(mod);
        }
        return r3;
      };
      NativeBigInt.prototype.modPow = SmallInteger.prototype.modPow = BigInteger.prototype.modPow;
      function compareAbs(a6, b5) {
        if (a6.length !== b5.length) {
          return a6.length > b5.length ? 1 : -1;
        }
        for (var i6 = a6.length - 1; i6 >= 0; i6--) {
          if (a6[i6] !== b5[i6])
            return a6[i6] > b5[i6] ? 1 : -1;
        }
        return 0;
      }
      BigInteger.prototype.compareAbs = function(v3) {
        var n2 = parseValue(v3), a6 = this.value, b5 = n2.value;
        if (n2.isSmall)
          return 1;
        return compareAbs(a6, b5);
      };
      SmallInteger.prototype.compareAbs = function(v3) {
        var n2 = parseValue(v3), a6 = Math.abs(this.value), b5 = n2.value;
        if (n2.isSmall) {
          b5 = Math.abs(b5);
          return a6 === b5 ? 0 : a6 > b5 ? 1 : -1;
        }
        return -1;
      };
      NativeBigInt.prototype.compareAbs = function(v3) {
        var a6 = this.value;
        var b5 = parseValue(v3).value;
        a6 = a6 >= 0 ? a6 : -a6;
        b5 = b5 >= 0 ? b5 : -b5;
        return a6 === b5 ? 0 : a6 > b5 ? 1 : -1;
      };
      BigInteger.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var n2 = parseValue(v3), a6 = this.value, b5 = n2.value;
        if (this.sign !== n2.sign) {
          return n2.sign ? 1 : -1;
        }
        if (n2.isSmall) {
          return this.sign ? -1 : 1;
        }
        return compareAbs(a6, b5) * (this.sign ? -1 : 1);
      };
      BigInteger.prototype.compareTo = BigInteger.prototype.compare;
      SmallInteger.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var n2 = parseValue(v3), a6 = this.value, b5 = n2.value;
        if (n2.isSmall) {
          return a6 == b5 ? 0 : a6 > b5 ? 1 : -1;
        }
        if (a6 < 0 !== n2.sign) {
          return a6 < 0 ? -1 : 1;
        }
        return a6 < 0 ? 1 : -1;
      };
      SmallInteger.prototype.compareTo = SmallInteger.prototype.compare;
      NativeBigInt.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var a6 = this.value;
        var b5 = parseValue(v3).value;
        return a6 === b5 ? 0 : a6 > b5 ? 1 : -1;
      };
      NativeBigInt.prototype.compareTo = NativeBigInt.prototype.compare;
      BigInteger.prototype.equals = function(v3) {
        return this.compare(v3) === 0;
      };
      NativeBigInt.prototype.eq = NativeBigInt.prototype.equals = SmallInteger.prototype.eq = SmallInteger.prototype.equals = BigInteger.prototype.eq = BigInteger.prototype.equals;
      BigInteger.prototype.notEquals = function(v3) {
        return this.compare(v3) !== 0;
      };
      NativeBigInt.prototype.neq = NativeBigInt.prototype.notEquals = SmallInteger.prototype.neq = SmallInteger.prototype.notEquals = BigInteger.prototype.neq = BigInteger.prototype.notEquals;
      BigInteger.prototype.greater = function(v3) {
        return this.compare(v3) > 0;
      };
      NativeBigInt.prototype.gt = NativeBigInt.prototype.greater = SmallInteger.prototype.gt = SmallInteger.prototype.greater = BigInteger.prototype.gt = BigInteger.prototype.greater;
      BigInteger.prototype.lesser = function(v3) {
        return this.compare(v3) < 0;
      };
      NativeBigInt.prototype.lt = NativeBigInt.prototype.lesser = SmallInteger.prototype.lt = SmallInteger.prototype.lesser = BigInteger.prototype.lt = BigInteger.prototype.lesser;
      BigInteger.prototype.greaterOrEquals = function(v3) {
        return this.compare(v3) >= 0;
      };
      NativeBigInt.prototype.geq = NativeBigInt.prototype.greaterOrEquals = SmallInteger.prototype.geq = SmallInteger.prototype.greaterOrEquals = BigInteger.prototype.geq = BigInteger.prototype.greaterOrEquals;
      BigInteger.prototype.lesserOrEquals = function(v3) {
        return this.compare(v3) <= 0;
      };
      NativeBigInt.prototype.leq = NativeBigInt.prototype.lesserOrEquals = SmallInteger.prototype.leq = SmallInteger.prototype.lesserOrEquals = BigInteger.prototype.leq = BigInteger.prototype.lesserOrEquals;
      BigInteger.prototype.isEven = function() {
        return (this.value[0] & 1) === 0;
      };
      SmallInteger.prototype.isEven = function() {
        return (this.value & 1) === 0;
      };
      NativeBigInt.prototype.isEven = function() {
        return (this.value & BigInt(1)) === BigInt(0);
      };
      BigInteger.prototype.isOdd = function() {
        return (this.value[0] & 1) === 1;
      };
      SmallInteger.prototype.isOdd = function() {
        return (this.value & 1) === 1;
      };
      NativeBigInt.prototype.isOdd = function() {
        return (this.value & BigInt(1)) === BigInt(1);
      };
      BigInteger.prototype.isPositive = function() {
        return !this.sign;
      };
      SmallInteger.prototype.isPositive = function() {
        return this.value > 0;
      };
      NativeBigInt.prototype.isPositive = SmallInteger.prototype.isPositive;
      BigInteger.prototype.isNegative = function() {
        return this.sign;
      };
      SmallInteger.prototype.isNegative = function() {
        return this.value < 0;
      };
      NativeBigInt.prototype.isNegative = SmallInteger.prototype.isNegative;
      BigInteger.prototype.isUnit = function() {
        return false;
      };
      SmallInteger.prototype.isUnit = function() {
        return Math.abs(this.value) === 1;
      };
      NativeBigInt.prototype.isUnit = function() {
        return this.abs().value === BigInt(1);
      };
      BigInteger.prototype.isZero = function() {
        return false;
      };
      SmallInteger.prototype.isZero = function() {
        return this.value === 0;
      };
      NativeBigInt.prototype.isZero = function() {
        return this.value === BigInt(0);
      };
      BigInteger.prototype.isDivisibleBy = function(v3) {
        var n2 = parseValue(v3);
        if (n2.isZero())
          return false;
        if (n2.isUnit())
          return true;
        if (n2.compareAbs(2) === 0)
          return this.isEven();
        return this.mod(n2).isZero();
      };
      NativeBigInt.prototype.isDivisibleBy = SmallInteger.prototype.isDivisibleBy = BigInteger.prototype.isDivisibleBy;
      function isBasicPrime(v3) {
        var n2 = v3.abs();
        if (n2.isUnit())
          return false;
        if (n2.equals(2) || n2.equals(3) || n2.equals(5))
          return true;
        if (n2.isEven() || n2.isDivisibleBy(3) || n2.isDivisibleBy(5))
          return false;
        if (n2.lesser(49))
          return true;
      }
      function millerRabinTest(n2, a6) {
        var nPrev = n2.prev(), b5 = nPrev, r3 = 0, d6, t5, i6, x6;
        while (b5.isEven())
          b5 = b5.divide(2), r3++;
        next:
          for (i6 = 0; i6 < a6.length; i6++) {
            if (n2.lesser(a6[i6]))
              continue;
            x6 = bigInt(a6[i6]).modPow(b5, n2);
            if (x6.isUnit() || x6.equals(nPrev))
              continue;
            for (d6 = r3 - 1; d6 != 0; d6--) {
              x6 = x6.square().mod(n2);
              if (x6.isUnit())
                return false;
              if (x6.equals(nPrev))
                continue next;
            }
            return false;
          }
        return true;
      }
      BigInteger.prototype.isPrime = function(strict) {
        var isPrime = isBasicPrime(this);
        if (isPrime !== undefined2)
          return isPrime;
        var n2 = this.abs();
        var bits = n2.bitLength();
        if (bits <= 64)
          return millerRabinTest(n2, [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37]);
        var logN = Math.log(2) * bits.toJSNumber();
        var t5 = Math.ceil(strict === true ? 2 * Math.pow(logN, 2) : logN);
        for (var a6 = [], i6 = 0; i6 < t5; i6++) {
          a6.push(bigInt(i6 + 2));
        }
        return millerRabinTest(n2, a6);
      };
      NativeBigInt.prototype.isPrime = SmallInteger.prototype.isPrime = BigInteger.prototype.isPrime;
      BigInteger.prototype.isProbablePrime = function(iterations, rng) {
        var isPrime = isBasicPrime(this);
        if (isPrime !== undefined2)
          return isPrime;
        var n2 = this.abs();
        var t5 = iterations === undefined2 ? 5 : iterations;
        for (var a6 = [], i6 = 0; i6 < t5; i6++) {
          a6.push(bigInt.randBetween(2, n2.minus(2), rng));
        }
        return millerRabinTest(n2, a6);
      };
      NativeBigInt.prototype.isProbablePrime = SmallInteger.prototype.isProbablePrime = BigInteger.prototype.isProbablePrime;
      BigInteger.prototype.modInv = function(n2) {
        var t5 = bigInt.zero, newT = bigInt.one, r3 = parseValue(n2), newR = this.abs(), q6, lastT, lastR;
        while (!newR.isZero()) {
          q6 = r3.divide(newR);
          lastT = t5;
          lastR = r3;
          t5 = newT;
          r3 = newR;
          newT = lastT.subtract(q6.multiply(newT));
          newR = lastR.subtract(q6.multiply(newR));
        }
        if (!r3.isUnit())
          throw new Error(this.toString() + " and " + n2.toString() + " are not co-prime");
        if (t5.compare(0) === -1) {
          t5 = t5.add(n2);
        }
        if (this.isNegative()) {
          return t5.negate();
        }
        return t5;
      };
      NativeBigInt.prototype.modInv = SmallInteger.prototype.modInv = BigInteger.prototype.modInv;
      BigInteger.prototype.next = function() {
        var value = this.value;
        if (this.sign) {
          return subtractSmall(value, 1, this.sign);
        }
        return new BigInteger(addSmall(value, 1), this.sign);
      };
      SmallInteger.prototype.next = function() {
        var value = this.value;
        if (value + 1 < MAX_INT)
          return new SmallInteger(value + 1);
        return new BigInteger(MAX_INT_ARR, false);
      };
      NativeBigInt.prototype.next = function() {
        return new NativeBigInt(this.value + BigInt(1));
      };
      BigInteger.prototype.prev = function() {
        var value = this.value;
        if (this.sign) {
          return new BigInteger(addSmall(value, 1), true);
        }
        return subtractSmall(value, 1, this.sign);
      };
      SmallInteger.prototype.prev = function() {
        var value = this.value;
        if (value - 1 > -MAX_INT)
          return new SmallInteger(value - 1);
        return new BigInteger(MAX_INT_ARR, true);
      };
      NativeBigInt.prototype.prev = function() {
        return new NativeBigInt(this.value - BigInt(1));
      };
      var powersOfTwo = [1];
      while (2 * powersOfTwo[powersOfTwo.length - 1] <= BASE)
        powersOfTwo.push(2 * powersOfTwo[powersOfTwo.length - 1]);
      var powers2Length = powersOfTwo.length, highestPower2 = powersOfTwo[powers2Length - 1];
      function shift_isSmall(n2) {
        return Math.abs(n2) <= BASE;
      }
      BigInteger.prototype.shiftLeft = function(v3) {
        var n2 = parseValue(v3).toJSNumber();
        if (!shift_isSmall(n2)) {
          throw new Error(String(n2) + " is too large for shifting.");
        }
        if (n2 < 0)
          return this.shiftRight(-n2);
        var result = this;
        if (result.isZero())
          return result;
        while (n2 >= powers2Length) {
          result = result.multiply(highestPower2);
          n2 -= powers2Length - 1;
        }
        return result.multiply(powersOfTwo[n2]);
      };
      NativeBigInt.prototype.shiftLeft = SmallInteger.prototype.shiftLeft = BigInteger.prototype.shiftLeft;
      BigInteger.prototype.shiftRight = function(v3) {
        var remQuo;
        var n2 = parseValue(v3).toJSNumber();
        if (!shift_isSmall(n2)) {
          throw new Error(String(n2) + " is too large for shifting.");
        }
        if (n2 < 0)
          return this.shiftLeft(-n2);
        var result = this;
        while (n2 >= powers2Length) {
          if (result.isZero() || result.isNegative() && result.isUnit())
            return result;
          remQuo = divModAny(result, highestPower2);
          result = remQuo[1].isNegative() ? remQuo[0].prev() : remQuo[0];
          n2 -= powers2Length - 1;
        }
        remQuo = divModAny(result, powersOfTwo[n2]);
        return remQuo[1].isNegative() ? remQuo[0].prev() : remQuo[0];
      };
      NativeBigInt.prototype.shiftRight = SmallInteger.prototype.shiftRight = BigInteger.prototype.shiftRight;
      function bitwise(x6, y6, fn2) {
        y6 = parseValue(y6);
        var xSign = x6.isNegative(), ySign = y6.isNegative();
        var xRem = xSign ? x6.not() : x6, yRem = ySign ? y6.not() : y6;
        var xDigit = 0, yDigit = 0;
        var xDivMod = null, yDivMod = null;
        var result = [];
        while (!xRem.isZero() || !yRem.isZero()) {
          xDivMod = divModAny(xRem, highestPower2);
          xDigit = xDivMod[1].toJSNumber();
          if (xSign) {
            xDigit = highestPower2 - 1 - xDigit;
          }
          yDivMod = divModAny(yRem, highestPower2);
          yDigit = yDivMod[1].toJSNumber();
          if (ySign) {
            yDigit = highestPower2 - 1 - yDigit;
          }
          xRem = xDivMod[0];
          yRem = yDivMod[0];
          result.push(fn2(xDigit, yDigit));
        }
        var sum = fn2(xSign ? 1 : 0, ySign ? 1 : 0) !== 0 ? bigInt(-1) : bigInt(0);
        for (var i6 = result.length - 1; i6 >= 0; i6 -= 1) {
          sum = sum.multiply(highestPower2).add(bigInt(result[i6]));
        }
        return sum;
      }
      BigInteger.prototype.not = function() {
        return this.negate().prev();
      };
      NativeBigInt.prototype.not = SmallInteger.prototype.not = BigInteger.prototype.not;
      BigInteger.prototype.and = function(n2) {
        return bitwise(this, n2, function(a6, b5) {
          return a6 & b5;
        });
      };
      NativeBigInt.prototype.and = SmallInteger.prototype.and = BigInteger.prototype.and;
      BigInteger.prototype.or = function(n2) {
        return bitwise(this, n2, function(a6, b5) {
          return a6 | b5;
        });
      };
      NativeBigInt.prototype.or = SmallInteger.prototype.or = BigInteger.prototype.or;
      BigInteger.prototype.xor = function(n2) {
        return bitwise(this, n2, function(a6, b5) {
          return a6 ^ b5;
        });
      };
      NativeBigInt.prototype.xor = SmallInteger.prototype.xor = BigInteger.prototype.xor;
      var LOBMASK_I = 1 << 30, LOBMASK_BI = (BASE & -BASE) * (BASE & -BASE) | LOBMASK_I;
      function roughLOB(n2) {
        var v3 = n2.value, x6 = typeof v3 === "number" ? v3 | LOBMASK_I : typeof v3 === "bigint" ? v3 | BigInt(LOBMASK_I) : v3[0] + v3[1] * BASE | LOBMASK_BI;
        return x6 & -x6;
      }
      function integerLogarithm(value, base2) {
        if (base2.compareTo(value) <= 0) {
          var tmp = integerLogarithm(value, base2.square(base2));
          var p4 = tmp.p;
          var e5 = tmp.e;
          var t5 = p4.multiply(base2);
          return t5.compareTo(value) <= 0 ? { p: t5, e: e5 * 2 + 1 } : { p: p4, e: e5 * 2 };
        }
        return { p: bigInt(1), e: 0 };
      }
      BigInteger.prototype.bitLength = function() {
        var n2 = this;
        if (n2.compareTo(bigInt(0)) < 0) {
          n2 = n2.negate().subtract(bigInt(1));
        }
        if (n2.compareTo(bigInt(0)) === 0) {
          return bigInt(0);
        }
        return bigInt(integerLogarithm(n2, bigInt(2)).e).add(bigInt(1));
      };
      NativeBigInt.prototype.bitLength = SmallInteger.prototype.bitLength = BigInteger.prototype.bitLength;
      function max(a6, b5) {
        a6 = parseValue(a6);
        b5 = parseValue(b5);
        return a6.greater(b5) ? a6 : b5;
      }
      function min(a6, b5) {
        a6 = parseValue(a6);
        b5 = parseValue(b5);
        return a6.lesser(b5) ? a6 : b5;
      }
      function gcd(a6, b5) {
        a6 = parseValue(a6).abs();
        b5 = parseValue(b5).abs();
        if (a6.equals(b5))
          return a6;
        if (a6.isZero())
          return b5;
        if (b5.isZero())
          return a6;
        var c5 = Integer[1], d6, t5;
        while (a6.isEven() && b5.isEven()) {
          d6 = min(roughLOB(a6), roughLOB(b5));
          a6 = a6.divide(d6);
          b5 = b5.divide(d6);
          c5 = c5.multiply(d6);
        }
        while (a6.isEven()) {
          a6 = a6.divide(roughLOB(a6));
        }
        do {
          while (b5.isEven()) {
            b5 = b5.divide(roughLOB(b5));
          }
          if (a6.greater(b5)) {
            t5 = b5;
            b5 = a6;
            a6 = t5;
          }
          b5 = b5.subtract(a6);
        } while (!b5.isZero());
        return c5.isUnit() ? a6 : a6.multiply(c5);
      }
      function lcm(a6, b5) {
        a6 = parseValue(a6).abs();
        b5 = parseValue(b5).abs();
        return a6.divide(gcd(a6, b5)).multiply(b5);
      }
      function randBetween(a6, b5, rng) {
        a6 = parseValue(a6);
        b5 = parseValue(b5);
        var usedRNG = rng || Math.random;
        var low = min(a6, b5), high = max(a6, b5);
        var range = high.subtract(low).add(1);
        if (range.isSmall)
          return low.add(Math.floor(usedRNG() * range));
        var digits = toBase(range, BASE).value;
        var result = [], restricted = true;
        for (var i6 = 0; i6 < digits.length; i6++) {
          var top = restricted ? digits[i6] + (i6 + 1 < digits.length ? digits[i6 + 1] / BASE : 0) : BASE;
          var digit = truncate(usedRNG() * top);
          result.push(digit);
          if (digit < digits[i6])
            restricted = false;
        }
        return low.add(Integer.fromArray(result, BASE, false));
      }
      var parseBase = function(text, base2, alphabet, caseSensitive) {
        alphabet = alphabet || DEFAULT_ALPHABET;
        text = String(text);
        if (!caseSensitive) {
          text = text.toLowerCase();
          alphabet = alphabet.toLowerCase();
        }
        var length = text.length;
        var i6;
        var absBase = Math.abs(base2);
        var alphabetValues = {};
        for (i6 = 0; i6 < alphabet.length; i6++) {
          alphabetValues[alphabet[i6]] = i6;
        }
        for (i6 = 0; i6 < length; i6++) {
          var c5 = text[i6];
          if (c5 === "-")
            continue;
          if (c5 in alphabetValues) {
            if (alphabetValues[c5] >= absBase) {
              if (c5 === "1" && absBase === 1)
                continue;
              throw new Error(c5 + " is not a valid digit in base " + base2 + ".");
            }
          }
        }
        base2 = parseValue(base2);
        var digits = [];
        var isNegative = text[0] === "-";
        for (i6 = isNegative ? 1 : 0; i6 < text.length; i6++) {
          var c5 = text[i6];
          if (c5 in alphabetValues)
            digits.push(parseValue(alphabetValues[c5]));
          else if (c5 === "<") {
            var start = i6;
            do {
              i6++;
            } while (text[i6] !== ">" && i6 < text.length);
            digits.push(parseValue(text.slice(start + 1, i6)));
          } else
            throw new Error(c5 + " is not a valid character");
        }
        return parseBaseFromArray(digits, base2, isNegative);
      };
      function parseBaseFromArray(digits, base2, isNegative) {
        var val = Integer[0], pow = Integer[1], i6;
        for (i6 = digits.length - 1; i6 >= 0; i6--) {
          val = val.add(digits[i6].times(pow));
          pow = pow.times(base2);
        }
        return isNegative ? val.negate() : val;
      }
      function stringify(digit, alphabet) {
        alphabet = alphabet || DEFAULT_ALPHABET;
        if (digit < alphabet.length) {
          return alphabet[digit];
        }
        return "<" + digit + ">";
      }
      function toBase(n2, base2) {
        base2 = bigInt(base2);
        if (base2.isZero()) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          throw new Error("Cannot convert nonzero numbers to base 0.");
        }
        if (base2.equals(-1)) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          if (n2.isNegative())
            return {
              value: [].concat.apply(
                [],
                Array.apply(null, Array(-n2.toJSNumber())).map(Array.prototype.valueOf, [1, 0])
              ),
              isNegative: false
            };
          var arr = Array.apply(null, Array(n2.toJSNumber() - 1)).map(Array.prototype.valueOf, [0, 1]);
          arr.unshift([1]);
          return {
            value: [].concat.apply([], arr),
            isNegative: false
          };
        }
        var neg = false;
        if (n2.isNegative() && base2.isPositive()) {
          neg = true;
          n2 = n2.abs();
        }
        if (base2.isUnit()) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          return {
            value: Array.apply(null, Array(n2.toJSNumber())).map(Number.prototype.valueOf, 1),
            isNegative: neg
          };
        }
        var out = [];
        var left = n2, divmod;
        while (left.isNegative() || left.compareAbs(base2) >= 0) {
          divmod = left.divmod(base2);
          left = divmod.quotient;
          var digit = divmod.remainder;
          if (digit.isNegative()) {
            digit = base2.minus(digit).abs();
            left = left.next();
          }
          out.push(digit.toJSNumber());
        }
        out.push(left.toJSNumber());
        return { value: out.reverse(), isNegative: neg };
      }
      function toBaseString(n2, base2, alphabet) {
        var arr = toBase(n2, base2);
        return (arr.isNegative ? "-" : "") + arr.value.map(function(x6) {
          return stringify(x6, alphabet);
        }).join("");
      }
      BigInteger.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      SmallInteger.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      NativeBigInt.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      BigInteger.prototype.toString = function(radix, alphabet) {
        if (radix === undefined2)
          radix = 10;
        if (radix !== 10 || alphabet)
          return toBaseString(this, radix, alphabet);
        var v3 = this.value, l3 = v3.length, str = String(v3[--l3]), zeros = "0000000", digit;
        while (--l3 >= 0) {
          digit = String(v3[l3]);
          str += zeros.slice(digit.length) + digit;
        }
        var sign2 = this.sign ? "-" : "";
        return sign2 + str;
      };
      SmallInteger.prototype.toString = function(radix, alphabet) {
        if (radix === undefined2)
          radix = 10;
        if (radix != 10 || alphabet)
          return toBaseString(this, radix, alphabet);
        return String(this.value);
      };
      NativeBigInt.prototype.toString = SmallInteger.prototype.toString;
      NativeBigInt.prototype.toJSON = BigInteger.prototype.toJSON = SmallInteger.prototype.toJSON = function() {
        return this.toString();
      };
      BigInteger.prototype.valueOf = function() {
        return parseInt(this.toString(), 10);
      };
      BigInteger.prototype.toJSNumber = BigInteger.prototype.valueOf;
      SmallInteger.prototype.valueOf = function() {
        return this.value;
      };
      SmallInteger.prototype.toJSNumber = SmallInteger.prototype.valueOf;
      NativeBigInt.prototype.valueOf = NativeBigInt.prototype.toJSNumber = function() {
        return parseInt(this.toString(), 10);
      };
      function parseStringValue(v3) {
        if (isPrecise(+v3)) {
          var x6 = +v3;
          if (x6 === truncate(x6))
            return supportsNativeBigInt ? new NativeBigInt(BigInt(x6)) : new SmallInteger(x6);
          throw new Error("Invalid integer: " + v3);
        }
        var sign2 = v3[0] === "-";
        if (sign2)
          v3 = v3.slice(1);
        var split = v3.split(/e/i);
        if (split.length > 2)
          throw new Error("Invalid integer: " + split.join("e"));
        if (split.length === 2) {
          var exp = split[1];
          if (exp[0] === "+")
            exp = exp.slice(1);
          exp = +exp;
          if (exp !== truncate(exp) || !isPrecise(exp))
            throw new Error("Invalid integer: " + exp + " is not a valid exponent.");
          var text = split[0];
          var decimalPlace = text.indexOf(".");
          if (decimalPlace >= 0) {
            exp -= text.length - decimalPlace - 1;
            text = text.slice(0, decimalPlace) + text.slice(decimalPlace + 1);
          }
          if (exp < 0)
            throw new Error("Cannot include negative exponent part for integers");
          text += new Array(exp + 1).join("0");
          v3 = text;
        }
        var isValid3 = /^([0-9][0-9]*)$/.test(v3);
        if (!isValid3)
          throw new Error("Invalid integer: " + v3);
        if (supportsNativeBigInt) {
          return new NativeBigInt(BigInt(sign2 ? "-" + v3 : v3));
        }
        var r3 = [], max2 = v3.length, l3 = LOG_BASE, min2 = max2 - l3;
        while (max2 > 0) {
          r3.push(+v3.slice(min2, max2));
          min2 -= l3;
          if (min2 < 0)
            min2 = 0;
          max2 -= l3;
        }
        trim(r3);
        return new BigInteger(r3, sign2);
      }
      function parseNumberValue(v3) {
        if (supportsNativeBigInt) {
          return new NativeBigInt(BigInt(v3));
        }
        if (isPrecise(v3)) {
          if (v3 !== truncate(v3))
            throw new Error(v3 + " is not an integer.");
          return new SmallInteger(v3);
        }
        return parseStringValue(v3.toString());
      }
      function parseValue(v3) {
        if (typeof v3 === "number") {
          return parseNumberValue(v3);
        }
        if (typeof v3 === "string") {
          return parseStringValue(v3);
        }
        if (typeof v3 === "bigint") {
          return new NativeBigInt(v3);
        }
        return v3;
      }
      for (var i5 = 0; i5 < 1e3; i5++) {
        Integer[i5] = parseValue(i5);
        if (i5 > 0)
          Integer[-i5] = parseValue(-i5);
      }
      Integer.one = Integer[1];
      Integer.zero = Integer[0];
      Integer.minusOne = Integer[-1];
      Integer.max = max;
      Integer.min = min;
      Integer.gcd = gcd;
      Integer.lcm = lcm;
      Integer.isInstance = function(x6) {
        return x6 instanceof BigInteger || x6 instanceof SmallInteger || x6 instanceof NativeBigInt;
      };
      Integer.randBetween = randBetween;
      Integer.fromArray = function(digits, base2, isNegative) {
        return parseBaseFromArray(digits.map(parseValue), parseValue(base2 || 10), isNegative);
      };
      return Integer;
    }();
    if (typeof module !== "undefined" && module.hasOwnProperty("exports")) {
      module.exports = bigInt;
    }
    if (typeof define === "function" && define.amd) {
      define(function() {
        return bigInt;
      });
    }
  }
});

// ../../node_modules/.pnpm/jed@1.1.1/node_modules/jed/jed.js
var require_jed = __commonJS({
  "../../node_modules/.pnpm/jed@1.1.1/node_modules/jed/jed.js"(exports, module) {
    (function(root, undef) {
      var ArrayProto = Array.prototype, ObjProto = Object.prototype, slice = ArrayProto.slice, hasOwnProp = ObjProto.hasOwnProperty, nativeForEach = ArrayProto.forEach, breaker = {};
      var _3 = {
        forEach: function(obj, iterator, context) {
          var i5, l3, key;
          if (obj === null) {
            return;
          }
          if (nativeForEach && obj.forEach === nativeForEach) {
            obj.forEach(iterator, context);
          } else if (obj.length === +obj.length) {
            for (i5 = 0, l3 = obj.length; i5 < l3; i5++) {
              if (i5 in obj && iterator.call(context, obj[i5], i5, obj) === breaker) {
                return;
              }
            }
          } else {
            for (key in obj) {
              if (hasOwnProp.call(obj, key)) {
                if (iterator.call(context, obj[key], key, obj) === breaker) {
                  return;
                }
              }
            }
          }
        },
        extend: function(obj) {
          this.forEach(slice.call(arguments, 1), function(source) {
            for (var prop in source) {
              obj[prop] = source[prop];
            }
          });
          return obj;
        }
      };
      var Jed2 = function(options) {
        this.defaults = {
          "locale_data": {
            "messages": {
              "": {
                "domain": "messages",
                "lang": "en",
                "plural_forms": "nplurals=2; plural=(n != 1);"
              }
              // There are no default keys, though
            }
          },
          // The default domain if one is missing
          "domain": "messages",
          // enable debug mode to log untranslated strings to the console
          "debug": false
        };
        this.options = _3.extend({}, this.defaults, options);
        this.textdomain(this.options.domain);
        if (options.domain && !this.options.locale_data[this.options.domain]) {
          throw new Error("Text domain set to non-existent domain: `" + options.domain + "`");
        }
      };
      Jed2.context_delimiter = String.fromCharCode(4);
      function getPluralFormFunc(plural_form_string) {
        return Jed2.PF.compile(plural_form_string || "nplurals=2; plural=(n != 1);");
      }
      function Chain(key, i18n2) {
        this._key = key;
        this._i18n = i18n2;
      }
      _3.extend(Chain.prototype, {
        onDomain: function(domain) {
          this._domain = domain;
          return this;
        },
        withContext: function(context) {
          this._context = context;
          return this;
        },
        ifPlural: function(num, pkey) {
          this._val = num;
          this._pkey = pkey;
          return this;
        },
        fetch: function(sArr) {
          if ({}.toString.call(sArr) != "[object Array]") {
            sArr = [].slice.call(arguments, 0);
          }
          return (sArr && sArr.length ? Jed2.sprintf : function(x6) {
            return x6;
          })(
            this._i18n.dcnpgettext(this._domain, this._context, this._key, this._pkey, this._val),
            sArr
          );
        }
      });
      _3.extend(Jed2.prototype, {
        // The sexier api start point
        translate: function(key) {
          return new Chain(key, this);
        },
        textdomain: function(domain) {
          if (!domain) {
            return this._textdomain;
          }
          this._textdomain = domain;
        },
        gettext: function(key) {
          return this.dcnpgettext.call(this, undef, undef, key);
        },
        dgettext: function(domain, key) {
          return this.dcnpgettext.call(this, domain, undef, key);
        },
        dcgettext: function(domain, key) {
          return this.dcnpgettext.call(this, domain, undef, key);
        },
        ngettext: function(skey, pkey, val) {
          return this.dcnpgettext.call(this, undef, undef, skey, pkey, val);
        },
        dngettext: function(domain, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, undef, skey, pkey, val);
        },
        dcngettext: function(domain, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, undef, skey, pkey, val);
        },
        pgettext: function(context, key) {
          return this.dcnpgettext.call(this, undef, context, key);
        },
        dpgettext: function(domain, context, key) {
          return this.dcnpgettext.call(this, domain, context, key);
        },
        dcpgettext: function(domain, context, key) {
          return this.dcnpgettext.call(this, domain, context, key);
        },
        npgettext: function(context, skey, pkey, val) {
          return this.dcnpgettext.call(this, undef, context, skey, pkey, val);
        },
        dnpgettext: function(domain, context, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, context, skey, pkey, val);
        },
        // The most fully qualified gettext function. It has every option.
        // Since it has every option, we can use it from every other method.
        // This is the bread and butter.
        // Technically there should be one more argument in this function for 'Category',
        // but since we never use it, we might as well not waste the bytes to define it.
        dcnpgettext: function(domain, context, singular_key, plural_key, val) {
          plural_key = plural_key || singular_key;
          domain = domain || this._textdomain;
          var fallback;
          if (!this.options) {
            fallback = new Jed2();
            return fallback.dcnpgettext.call(fallback, void 0, void 0, singular_key, plural_key, val);
          }
          if (!this.options.locale_data) {
            throw new Error("No locale data provided.");
          }
          if (!this.options.locale_data[domain]) {
            throw new Error("Domain `" + domain + "` was not found.");
          }
          if (!this.options.locale_data[domain][""]) {
            throw new Error("No locale meta information provided.");
          }
          if (!singular_key) {
            throw new Error("No translation key found.");
          }
          var key = context ? context + Jed2.context_delimiter + singular_key : singular_key, locale_data = this.options.locale_data, dict = locale_data[domain], defaultConf = (locale_data.messages || this.defaults.locale_data.messages)[""], pluralForms = dict[""].plural_forms || dict[""]["Plural-Forms"] || dict[""]["plural-forms"] || defaultConf.plural_forms || defaultConf["Plural-Forms"] || defaultConf["plural-forms"], val_list, res;
          var val_idx;
          if (val === void 0) {
            val_idx = 0;
          } else {
            if (typeof val != "number") {
              val = parseInt(val, 10);
              if (isNaN(val)) {
                throw new Error("The number that was passed in is not a number.");
              }
            }
            val_idx = getPluralFormFunc(pluralForms)(val);
          }
          if (!dict) {
            throw new Error("No domain named `" + domain + "` could be found.");
          }
          val_list = dict[key];
          if (!val_list || val_idx > val_list.length) {
            if (this.options.missing_key_callback) {
              this.options.missing_key_callback(key, domain);
            }
            res = [singular_key, plural_key];
            if (this.options.debug === true) {
              console.log(res[getPluralFormFunc(pluralForms)(val)]);
            }
            return res[getPluralFormFunc()(val)];
          }
          res = val_list[val_idx];
          if (!res) {
            res = [singular_key, plural_key];
            return res[getPluralFormFunc()(val)];
          }
          return res;
        }
      });
      var sprintf = function() {
        function get_type(variable) {
          return Object.prototype.toString.call(variable).slice(8, -1).toLowerCase();
        }
        function str_repeat(input, multiplier) {
          for (var output = []; multiplier > 0; output[--multiplier] = input) {
          }
          return output.join("");
        }
        var str_format = function() {
          if (!str_format.cache.hasOwnProperty(arguments[0])) {
            str_format.cache[arguments[0]] = str_format.parse(arguments[0]);
          }
          return str_format.format.call(null, str_format.cache[arguments[0]], arguments);
        };
        str_format.format = function(parse_tree, argv) {
          var cursor = 1, tree_length = parse_tree.length, node_type = "", arg, output = [], i5, k6, match6, pad, pad_character, pad_length;
          for (i5 = 0; i5 < tree_length; i5++) {
            node_type = get_type(parse_tree[i5]);
            if (node_type === "string") {
              output.push(parse_tree[i5]);
            } else if (node_type === "array") {
              match6 = parse_tree[i5];
              if (match6[2]) {
                arg = argv[cursor];
                for (k6 = 0; k6 < match6[2].length; k6++) {
                  if (!arg.hasOwnProperty(match6[2][k6])) {
                    throw sprintf('[sprintf] property "%s" does not exist', match6[2][k6]);
                  }
                  arg = arg[match6[2][k6]];
                }
              } else if (match6[1]) {
                arg = argv[match6[1]];
              } else {
                arg = argv[cursor++];
              }
              if (/[^s]/.test(match6[8]) && get_type(arg) != "number") {
                throw sprintf("[sprintf] expecting number but found %s", get_type(arg));
              }
              if (typeof arg == "undefined" || arg === null) {
                arg = "";
              }
              switch (match6[8]) {
                case "b":
                  arg = arg.toString(2);
                  break;
                case "c":
                  arg = String.fromCharCode(arg);
                  break;
                case "d":
                  arg = parseInt(arg, 10);
                  break;
                case "e":
                  arg = match6[7] ? arg.toExponential(match6[7]) : arg.toExponential();
                  break;
                case "f":
                  arg = match6[7] ? parseFloat(arg).toFixed(match6[7]) : parseFloat(arg);
                  break;
                case "o":
                  arg = arg.toString(8);
                  break;
                case "s":
                  arg = (arg = String(arg)) && match6[7] ? arg.substring(0, match6[7]) : arg;
                  break;
                case "u":
                  arg = Math.abs(arg);
                  break;
                case "x":
                  arg = arg.toString(16);
                  break;
                case "X":
                  arg = arg.toString(16).toUpperCase();
                  break;
              }
              arg = /[def]/.test(match6[8]) && match6[3] && arg >= 0 ? "+" + arg : arg;
              pad_character = match6[4] ? match6[4] == "0" ? "0" : match6[4].charAt(1) : " ";
              pad_length = match6[6] - String(arg).length;
              pad = match6[6] ? str_repeat(pad_character, pad_length) : "";
              output.push(match6[5] ? arg + pad : pad + arg);
            }
          }
          return output.join("");
        };
        str_format.cache = {};
        str_format.parse = function(fmt) {
          var _fmt = fmt, match6 = [], parse_tree = [], arg_names = 0;
          while (_fmt) {
            if ((match6 = /^[^\x25]+/.exec(_fmt)) !== null) {
              parse_tree.push(match6[0]);
            } else if ((match6 = /^\x25{2}/.exec(_fmt)) !== null) {
              parse_tree.push("%");
            } else if ((match6 = /^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-fosuxX])/.exec(_fmt)) !== null) {
              if (match6[2]) {
                arg_names |= 1;
                var field_list = [], replacement_field = match6[2], field_match = [];
                if ((field_match = /^([a-z_][a-z_\d]*)/i.exec(replacement_field)) !== null) {
                  field_list.push(field_match[1]);
                  while ((replacement_field = replacement_field.substring(field_match[0].length)) !== "") {
                    if ((field_match = /^\.([a-z_][a-z_\d]*)/i.exec(replacement_field)) !== null) {
                      field_list.push(field_match[1]);
                    } else if ((field_match = /^\[(\d+)\]/.exec(replacement_field)) !== null) {
                      field_list.push(field_match[1]);
                    } else {
                      throw "[sprintf] huh?";
                    }
                  }
                } else {
                  throw "[sprintf] huh?";
                }
                match6[2] = field_list;
              } else {
                arg_names |= 2;
              }
              if (arg_names === 3) {
                throw "[sprintf] mixing positional and named placeholders is not (yet) supported";
              }
              parse_tree.push(match6);
            } else {
              throw "[sprintf] huh?";
            }
            _fmt = _fmt.substring(match6[0].length);
          }
          return parse_tree;
        };
        return str_format;
      }();
      var vsprintf = function(fmt, argv) {
        argv.unshift(fmt);
        return sprintf.apply(null, argv);
      };
      Jed2.parse_plural = function(plural_forms, n2) {
        plural_forms = plural_forms.replace(/n/g, n2);
        return Jed2.parse_expression(plural_forms);
      };
      Jed2.sprintf = function(fmt, args) {
        if ({}.toString.call(args) == "[object Array]") {
          return vsprintf(fmt, [].slice.call(args));
        }
        return sprintf.apply(this, [].slice.call(arguments));
      };
      Jed2.prototype.sprintf = function() {
        return Jed2.sprintf.apply(this, arguments);
      };
      Jed2.PF = {};
      Jed2.PF.parse = function(p4) {
        var plural_str = Jed2.PF.extractPluralExpr(p4);
        return Jed2.PF.parser.parse.call(Jed2.PF.parser, plural_str);
      };
      Jed2.PF.compile = function(p4) {
        function imply(val) {
          return val === true ? 1 : val ? val : 0;
        }
        var ast = Jed2.PF.parse(p4);
        return function(n2) {
          return imply(Jed2.PF.interpreter(ast)(n2));
        };
      };
      Jed2.PF.interpreter = function(ast) {
        return function(n2) {
          var res;
          switch (ast.type) {
            case "GROUP":
              return Jed2.PF.interpreter(ast.expr)(n2);
            case "TERNARY":
              if (Jed2.PF.interpreter(ast.expr)(n2)) {
                return Jed2.PF.interpreter(ast.truthy)(n2);
              }
              return Jed2.PF.interpreter(ast.falsey)(n2);
            case "OR":
              return Jed2.PF.interpreter(ast.left)(n2) || Jed2.PF.interpreter(ast.right)(n2);
            case "AND":
              return Jed2.PF.interpreter(ast.left)(n2) && Jed2.PF.interpreter(ast.right)(n2);
            case "LT":
              return Jed2.PF.interpreter(ast.left)(n2) < Jed2.PF.interpreter(ast.right)(n2);
            case "GT":
              return Jed2.PF.interpreter(ast.left)(n2) > Jed2.PF.interpreter(ast.right)(n2);
            case "LTE":
              return Jed2.PF.interpreter(ast.left)(n2) <= Jed2.PF.interpreter(ast.right)(n2);
            case "GTE":
              return Jed2.PF.interpreter(ast.left)(n2) >= Jed2.PF.interpreter(ast.right)(n2);
            case "EQ":
              return Jed2.PF.interpreter(ast.left)(n2) == Jed2.PF.interpreter(ast.right)(n2);
            case "NEQ":
              return Jed2.PF.interpreter(ast.left)(n2) != Jed2.PF.interpreter(ast.right)(n2);
            case "MOD":
              return Jed2.PF.interpreter(ast.left)(n2) % Jed2.PF.interpreter(ast.right)(n2);
            case "VAR":
              return n2;
            case "NUM":
              return ast.val;
            default:
              throw new Error("Invalid Token found.");
          }
        };
      };
      Jed2.PF.extractPluralExpr = function(p4) {
        p4 = p4.replace(/^\s\s*/, "").replace(/\s\s*$/, "");
        if (!/;\s*$/.test(p4)) {
          p4 = p4.concat(";");
        }
        var nplurals_re = /nplurals\=(\d+);/, plural_re = /plural\=(.*);/, nplurals_matches = p4.match(nplurals_re), res = {}, plural_matches;
        if (nplurals_matches.length > 1) {
          res.nplurals = nplurals_matches[1];
        } else {
          throw new Error("nplurals not found in plural_forms string: " + p4);
        }
        p4 = p4.replace(nplurals_re, "");
        plural_matches = p4.match(plural_re);
        if (!(plural_matches && plural_matches.length > 1)) {
          throw new Error("`plural` expression not found: " + p4);
        }
        return plural_matches[1];
      };
      Jed2.PF.parser = function() {
        var parser = {
          trace: function trace() {
          },
          yy: {},
          symbols_: { "error": 2, "expressions": 3, "e": 4, "EOF": 5, "?": 6, ":": 7, "||": 8, "&&": 9, "<": 10, "<=": 11, ">": 12, ">=": 13, "!=": 14, "==": 15, "%": 16, "(": 17, ")": 18, "n": 19, "NUMBER": 20, "$accept": 0, "$end": 1 },
          terminals_: { 2: "error", 5: "EOF", 6: "?", 7: ":", 8: "||", 9: "&&", 10: "<", 11: "<=", 12: ">", 13: ">=", 14: "!=", 15: "==", 16: "%", 17: "(", 18: ")", 19: "n", 20: "NUMBER" },
          productions_: [0, [3, 2], [4, 5], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 1], [4, 1]],
          performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
            var $0 = $$.length - 1;
            switch (yystate) {
              case 1:
                return { type: "GROUP", expr: $$[$0 - 1] };
                break;
              case 2:
                this.$ = { type: "TERNARY", expr: $$[$0 - 4], truthy: $$[$0 - 2], falsey: $$[$0] };
                break;
              case 3:
                this.$ = { type: "OR", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 4:
                this.$ = { type: "AND", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 5:
                this.$ = { type: "LT", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 6:
                this.$ = { type: "LTE", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 7:
                this.$ = { type: "GT", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 8:
                this.$ = { type: "GTE", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 9:
                this.$ = { type: "NEQ", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 10:
                this.$ = { type: "EQ", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 11:
                this.$ = { type: "MOD", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 12:
                this.$ = { type: "GROUP", expr: $$[$0 - 1] };
                break;
              case 13:
                this.$ = { type: "VAR" };
                break;
              case 14:
                this.$ = { type: "NUM", val: Number(yytext) };
                break;
            }
          },
          table: [{ 3: 1, 4: 2, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 1: [3] }, { 5: [1, 6], 6: [1, 7], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16] }, { 4: 17, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 5: [2, 13], 6: [2, 13], 7: [2, 13], 8: [2, 13], 9: [2, 13], 10: [2, 13], 11: [2, 13], 12: [2, 13], 13: [2, 13], 14: [2, 13], 15: [2, 13], 16: [2, 13], 18: [2, 13] }, { 5: [2, 14], 6: [2, 14], 7: [2, 14], 8: [2, 14], 9: [2, 14], 10: [2, 14], 11: [2, 14], 12: [2, 14], 13: [2, 14], 14: [2, 14], 15: [2, 14], 16: [2, 14], 18: [2, 14] }, { 1: [2, 1] }, { 4: 18, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 19, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 20, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 21, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 22, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 23, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 24, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 25, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 26, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 27, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 6: [1, 7], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [1, 28] }, { 6: [1, 7], 7: [1, 29], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16] }, { 5: [2, 3], 6: [2, 3], 7: [2, 3], 8: [2, 3], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 3] }, { 5: [2, 4], 6: [2, 4], 7: [2, 4], 8: [2, 4], 9: [2, 4], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 4] }, { 5: [2, 5], 6: [2, 5], 7: [2, 5], 8: [2, 5], 9: [2, 5], 10: [2, 5], 11: [2, 5], 12: [2, 5], 13: [2, 5], 14: [2, 5], 15: [2, 5], 16: [1, 16], 18: [2, 5] }, { 5: [2, 6], 6: [2, 6], 7: [2, 6], 8: [2, 6], 9: [2, 6], 10: [2, 6], 11: [2, 6], 12: [2, 6], 13: [2, 6], 14: [2, 6], 15: [2, 6], 16: [1, 16], 18: [2, 6] }, { 5: [2, 7], 6: [2, 7], 7: [2, 7], 8: [2, 7], 9: [2, 7], 10: [2, 7], 11: [2, 7], 12: [2, 7], 13: [2, 7], 14: [2, 7], 15: [2, 7], 16: [1, 16], 18: [2, 7] }, { 5: [2, 8], 6: [2, 8], 7: [2, 8], 8: [2, 8], 9: [2, 8], 10: [2, 8], 11: [2, 8], 12: [2, 8], 13: [2, 8], 14: [2, 8], 15: [2, 8], 16: [1, 16], 18: [2, 8] }, { 5: [2, 9], 6: [2, 9], 7: [2, 9], 8: [2, 9], 9: [2, 9], 10: [2, 9], 11: [2, 9], 12: [2, 9], 13: [2, 9], 14: [2, 9], 15: [2, 9], 16: [1, 16], 18: [2, 9] }, { 5: [2, 10], 6: [2, 10], 7: [2, 10], 8: [2, 10], 9: [2, 10], 10: [2, 10], 11: [2, 10], 12: [2, 10], 13: [2, 10], 14: [2, 10], 15: [2, 10], 16: [1, 16], 18: [2, 10] }, { 5: [2, 11], 6: [2, 11], 7: [2, 11], 8: [2, 11], 9: [2, 11], 10: [2, 11], 11: [2, 11], 12: [2, 11], 13: [2, 11], 14: [2, 11], 15: [2, 11], 16: [2, 11], 18: [2, 11] }, { 5: [2, 12], 6: [2, 12], 7: [2, 12], 8: [2, 12], 9: [2, 12], 10: [2, 12], 11: [2, 12], 12: [2, 12], 13: [2, 12], 14: [2, 12], 15: [2, 12], 16: [2, 12], 18: [2, 12] }, { 4: 30, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 5: [2, 2], 6: [1, 7], 7: [2, 2], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 2] }],
          defaultActions: { 6: [2, 1] },
          parseError: function parseError(str, hash4) {
            throw new Error(str);
          },
          parse: function parse2(input) {
            var self2 = this, stack = [0], vstack = [null], lstack = [], table2 = this.table, yytext = "", yylineno = 0, yyleng = 0, recovering = 0, TERROR = 2, EOF = 1;
            this.lexer.setInput(input);
            this.lexer.yy = this.yy;
            this.yy.lexer = this.lexer;
            if (typeof this.lexer.yylloc == "undefined")
              this.lexer.yylloc = {};
            var yyloc = this.lexer.yylloc;
            lstack.push(yyloc);
            if (typeof this.yy.parseError === "function")
              this.parseError = this.yy.parseError;
            function popStack(n2) {
              stack.length = stack.length - 2 * n2;
              vstack.length = vstack.length - n2;
              lstack.length = lstack.length - n2;
            }
            function lex() {
              var token;
              token = self2.lexer.lex() || 1;
              if (typeof token !== "number") {
                token = self2.symbols_[token] || token;
              }
              return token;
            }
            var symbol, preErrorSymbol, state, action, a6, r3, yyval = {}, p4, len, newState, expected;
            while (true) {
              state = stack[stack.length - 1];
              if (this.defaultActions[state]) {
                action = this.defaultActions[state];
              } else {
                if (symbol == null)
                  symbol = lex();
                action = table2[state] && table2[state][symbol];
              }
              _handle_error:
                if (typeof action === "undefined" || !action.length || !action[0]) {
                  if (!recovering) {
                    expected = [];
                    for (p4 in table2[state])
                      if (this.terminals_[p4] && p4 > 2) {
                        expected.push("'" + this.terminals_[p4] + "'");
                      }
                    var errStr = "";
                    if (this.lexer.showPosition) {
                      errStr = "Parse error on line " + (yylineno + 1) + ":\n" + this.lexer.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + this.terminals_[symbol] + "'";
                    } else {
                      errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == 1 ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
                    }
                    this.parseError(
                      errStr,
                      { text: this.lexer.match, token: this.terminals_[symbol] || symbol, line: this.lexer.yylineno, loc: yyloc, expected }
                    );
                  }
                  if (recovering == 3) {
                    if (symbol == EOF) {
                      throw new Error(errStr || "Parsing halted.");
                    }
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    symbol = lex();
                  }
                  while (1) {
                    if (TERROR.toString() in table2[state]) {
                      break;
                    }
                    if (state == 0) {
                      throw new Error(errStr || "Parsing halted.");
                    }
                    popStack(1);
                    state = stack[stack.length - 1];
                  }
                  preErrorSymbol = symbol;
                  symbol = TERROR;
                  state = stack[stack.length - 1];
                  action = table2[state] && table2[state][TERROR];
                  recovering = 3;
                }
              if (action[0] instanceof Array && action.length > 1) {
                throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
              }
              switch (action[0]) {
                case 1:
                  stack.push(symbol);
                  vstack.push(this.lexer.yytext);
                  lstack.push(this.lexer.yylloc);
                  stack.push(action[1]);
                  symbol = null;
                  if (!preErrorSymbol) {
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    if (recovering > 0)
                      recovering--;
                  } else {
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                  }
                  break;
                case 2:
                  len = this.productions_[action[1]][1];
                  yyval.$ = vstack[vstack.length - len];
                  yyval._$ = {
                    first_line: lstack[lstack.length - (len || 1)].first_line,
                    last_line: lstack[lstack.length - 1].last_line,
                    first_column: lstack[lstack.length - (len || 1)].first_column,
                    last_column: lstack[lstack.length - 1].last_column
                  };
                  r3 = this.performAction.call(yyval, yytext, yyleng, yylineno, this.yy, action[1], vstack, lstack);
                  if (typeof r3 !== "undefined") {
                    return r3;
                  }
                  if (len) {
                    stack = stack.slice(0, -1 * len * 2);
                    vstack = vstack.slice(0, -1 * len);
                    lstack = lstack.slice(0, -1 * len);
                  }
                  stack.push(this.productions_[action[1]][0]);
                  vstack.push(yyval.$);
                  lstack.push(yyval._$);
                  newState = table2[stack[stack.length - 2]][stack[stack.length - 1]];
                  stack.push(newState);
                  break;
                case 3:
                  return true;
              }
            }
            return true;
          }
        };
        var lexer = function() {
          var lexer2 = {
            EOF: 1,
            parseError: function parseError(str, hash4) {
              if (this.yy.parseError) {
                this.yy.parseError(str, hash4);
              } else {
                throw new Error(str);
              }
            },
            setInput: function(input) {
              this._input = input;
              this._more = this._less = this.done = false;
              this.yylineno = this.yyleng = 0;
              this.yytext = this.matched = this.match = "";
              this.conditionStack = ["INITIAL"];
              this.yylloc = { first_line: 1, first_column: 0, last_line: 1, last_column: 0 };
              return this;
            },
            input: function() {
              var ch = this._input[0];
              this.yytext += ch;
              this.yyleng++;
              this.match += ch;
              this.matched += ch;
              var lines = ch.match(/\n/);
              if (lines)
                this.yylineno++;
              this._input = this._input.slice(1);
              return ch;
            },
            unput: function(ch) {
              this._input = ch + this._input;
              return this;
            },
            more: function() {
              this._more = true;
              return this;
            },
            pastInput: function() {
              var past = this.matched.substr(0, this.matched.length - this.match.length);
              return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
            },
            upcomingInput: function() {
              var next = this.match;
              if (next.length < 20) {
                next += this._input.substr(0, 20 - next.length);
              }
              return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
            },
            showPosition: function() {
              var pre = this.pastInput();
              var c5 = new Array(pre.length + 1).join("-");
              return pre + this.upcomingInput() + "\n" + c5 + "^";
            },
            next: function() {
              if (this.done) {
                return this.EOF;
              }
              if (!this._input)
                this.done = true;
              var token, match6, col, lines;
              if (!this._more) {
                this.yytext = "";
                this.match = "";
              }
              var rules = this._currentRules();
              for (var i5 = 0; i5 < rules.length; i5++) {
                match6 = this._input.match(this.rules[rules[i5]]);
                if (match6) {
                  lines = match6[0].match(/\n.*/g);
                  if (lines)
                    this.yylineno += lines.length;
                  this.yylloc = {
                    first_line: this.yylloc.last_line,
                    last_line: this.yylineno + 1,
                    first_column: this.yylloc.last_column,
                    last_column: lines ? lines[lines.length - 1].length - 1 : this.yylloc.last_column + match6[0].length
                  };
                  this.yytext += match6[0];
                  this.match += match6[0];
                  this.matches = match6;
                  this.yyleng = this.yytext.length;
                  this._more = false;
                  this._input = this._input.slice(match6[0].length);
                  this.matched += match6[0];
                  token = this.performAction.call(this, this.yy, this, rules[i5], this.conditionStack[this.conditionStack.length - 1]);
                  if (token)
                    return token;
                  else
                    return;
                }
              }
              if (this._input === "") {
                return this.EOF;
              } else {
                this.parseError(
                  "Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(),
                  { text: "", token: null, line: this.yylineno }
                );
              }
            },
            lex: function lex() {
              var r3 = this.next();
              if (typeof r3 !== "undefined") {
                return r3;
              } else {
                return this.lex();
              }
            },
            begin: function begin(condition) {
              this.conditionStack.push(condition);
            },
            popState: function popState() {
              return this.conditionStack.pop();
            },
            _currentRules: function _currentRules() {
              return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
            },
            topState: function() {
              return this.conditionStack[this.conditionStack.length - 2];
            },
            pushState: function begin(condition) {
              this.begin(condition);
            }
          };
          lexer2.performAction = function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
            var YYSTATE = YY_START;
            switch ($avoiding_name_collisions) {
              case 0:
                break;
              case 1:
                return 20;
                break;
              case 2:
                return 19;
                break;
              case 3:
                return 8;
                break;
              case 4:
                return 9;
                break;
              case 5:
                return 6;
                break;
              case 6:
                return 7;
                break;
              case 7:
                return 11;
                break;
              case 8:
                return 13;
                break;
              case 9:
                return 10;
                break;
              case 10:
                return 12;
                break;
              case 11:
                return 14;
                break;
              case 12:
                return 15;
                break;
              case 13:
                return 16;
                break;
              case 14:
                return 17;
                break;
              case 15:
                return 18;
                break;
              case 16:
                return 5;
                break;
              case 17:
                return "INVALID";
                break;
            }
          };
          lexer2.rules = [/^\s+/, /^[0-9]+(\.[0-9]+)?\b/, /^n\b/, /^\|\|/, /^&&/, /^\?/, /^:/, /^<=/, /^>=/, /^</, /^>/, /^!=/, /^==/, /^%/, /^\(/, /^\)/, /^$/, /^./];
          lexer2.conditions = { "INITIAL": { "rules": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17], "inclusive": true } };
          return lexer2;
        }();
        parser.lexer = lexer;
        return parser;
      }();
      if (typeof exports !== "undefined") {
        if (typeof module !== "undefined" && module.exports) {
          exports = module.exports = Jed2;
        }
        exports.Jed = Jed2;
      } else {
        if (typeof define === "function" && define.amd) {
          define(function() {
            return Jed2;
          });
        }
        root["Jed"] = Jed2;
      }
    })(exports);
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/dist/preact.module.js
function s(n2, l3) {
  for (var u5 in l3)
    n2[u5] = l3[u5];
  return n2;
}
function a(n2) {
  var l3 = n2.parentNode;
  l3 && l3.removeChild(n2);
}
function h(l3, u5, i5) {
  var t5, o3, r3, f3 = {};
  for (r3 in u5)
    "key" == r3 ? t5 = u5[r3] : "ref" == r3 ? o3 = u5[r3] : f3[r3] = u5[r3];
  if (arguments.length > 2 && (f3.children = arguments.length > 3 ? n.call(arguments, 2) : i5), "function" == typeof l3 && null != l3.defaultProps)
    for (r3 in l3.defaultProps)
      void 0 === f3[r3] && (f3[r3] = l3.defaultProps[r3]);
  return v(l3, f3, t5, o3, null);
}
function v(n2, i5, t5, o3, r3) {
  var f3 = { type: n2, props: i5, key: t5, ref: o3, __k: null, __: null, __b: 0, __e: null, __d: void 0, __c: null, __h: null, constructor: void 0, __v: null == r3 ? ++u : r3 };
  return null == r3 && null != l.vnode && l.vnode(f3), f3;
}
function y() {
  return { current: null };
}
function p2(n2) {
  return n2.children;
}
function d(n2, l3) {
  this.props = n2, this.context = l3;
}
function _(n2, l3) {
  if (null == l3)
    return n2.__ ? _(n2.__, n2.__.__k.indexOf(n2) + 1) : null;
  for (var u5; l3 < n2.__k.length; l3++)
    if (null != (u5 = n2.__k[l3]) && null != u5.__e)
      return u5.__e;
  return "function" == typeof n2.type ? _(n2) : null;
}
function k(n2) {
  var l3, u5;
  if (null != (n2 = n2.__) && null != n2.__c) {
    for (n2.__e = n2.__c.base = null, l3 = 0; l3 < n2.__k.length; l3++)
      if (null != (u5 = n2.__k[l3]) && null != u5.__e) {
        n2.__e = n2.__c.base = u5.__e;
        break;
      }
    return k(n2);
  }
}
function b(n2) {
  (!n2.__d && (n2.__d = true) && t.push(n2) && !g.__r++ || o !== l.debounceRendering) && ((o = l.debounceRendering) || setTimeout)(g);
}
function g() {
  for (var n2; g.__r = t.length; )
    n2 = t.sort(function(n3, l3) {
      return n3.__v.__b - l3.__v.__b;
    }), t = [], n2.some(function(n3) {
      var l3, u5, i5, t5, o3, r3;
      n3.__d && (o3 = (t5 = (l3 = n3).__v).__e, (r3 = l3.__P) && (u5 = [], (i5 = s({}, t5)).__v = t5.__v + 1, j(r3, t5, i5, l3.__n, void 0 !== r3.ownerSVGElement, null != t5.__h ? [o3] : null, u5, null == o3 ? _(t5) : o3, t5.__h), z(u5, t5), t5.__e != o3 && k(t5)));
    });
}
function w(n2, l3, u5, i5, t5, o3, r3, c5, s6, a6) {
  var h5, y6, d6, k6, b5, g4, w6, x6 = i5 && i5.__k || e, C3 = x6.length;
  for (u5.__k = [], h5 = 0; h5 < l3.length; h5++)
    if (null != (k6 = u5.__k[h5] = null == (k6 = l3[h5]) || "boolean" == typeof k6 ? null : "string" == typeof k6 || "number" == typeof k6 || "bigint" == typeof k6 ? v(null, k6, null, null, k6) : Array.isArray(k6) ? v(p2, { children: k6 }, null, null, null) : k6.__b > 0 ? v(k6.type, k6.props, k6.key, k6.ref ? k6.ref : null, k6.__v) : k6)) {
      if (k6.__ = u5, k6.__b = u5.__b + 1, null === (d6 = x6[h5]) || d6 && k6.key == d6.key && k6.type === d6.type)
        x6[h5] = void 0;
      else
        for (y6 = 0; y6 < C3; y6++) {
          if ((d6 = x6[y6]) && k6.key == d6.key && k6.type === d6.type) {
            x6[y6] = void 0;
            break;
          }
          d6 = null;
        }
      j(n2, k6, d6 = d6 || f, t5, o3, r3, c5, s6, a6), b5 = k6.__e, (y6 = k6.ref) && d6.ref != y6 && (w6 || (w6 = []), d6.ref && w6.push(d6.ref, null, k6), w6.push(y6, k6.__c || b5, k6)), null != b5 ? (null == g4 && (g4 = b5), "function" == typeof k6.type && k6.__k === d6.__k ? k6.__d = s6 = m(k6, s6, n2) : s6 = A2(n2, k6, d6, x6, b5, s6), "function" == typeof u5.type && (u5.__d = s6)) : s6 && d6.__e == s6 && s6.parentNode != n2 && (s6 = _(d6));
    }
  for (u5.__e = g4, h5 = C3; h5--; )
    null != x6[h5] && N(x6[h5], x6[h5]);
  if (w6)
    for (h5 = 0; h5 < w6.length; h5++)
      M2(w6[h5], w6[++h5], w6[++h5]);
}
function m(n2, l3, u5) {
  for (var i5, t5 = n2.__k, o3 = 0; t5 && o3 < t5.length; o3++)
    (i5 = t5[o3]) && (i5.__ = n2, l3 = "function" == typeof i5.type ? m(i5, l3, u5) : A2(u5, i5, i5, t5, i5.__e, l3));
  return l3;
}
function x(n2, l3) {
  return l3 = l3 || [], null == n2 || "boolean" == typeof n2 || (Array.isArray(n2) ? n2.some(function(n3) {
    x(n3, l3);
  }) : l3.push(n2)), l3;
}
function A2(n2, l3, u5, i5, t5, o3) {
  var r3, f3, e5;
  if (void 0 !== l3.__d)
    r3 = l3.__d, l3.__d = void 0;
  else if (null == u5 || t5 != o3 || null == t5.parentNode)
    n:
      if (null == o3 || o3.parentNode !== n2)
        n2.appendChild(t5), r3 = null;
      else {
        for (f3 = o3, e5 = 0; (f3 = f3.nextSibling) && e5 < i5.length; e5 += 1)
          if (f3 == t5)
            break n;
        n2.insertBefore(t5, o3), r3 = o3;
      }
  return void 0 !== r3 ? r3 : t5.nextSibling;
}
function C(n2, l3, u5, i5, t5) {
  var o3;
  for (o3 in u5)
    "children" === o3 || "key" === o3 || o3 in l3 || H(n2, o3, null, u5[o3], i5);
  for (o3 in l3)
    t5 && "function" != typeof l3[o3] || "children" === o3 || "key" === o3 || "value" === o3 || "checked" === o3 || u5[o3] === l3[o3] || H(n2, o3, l3[o3], u5[o3], i5);
}
function $(n2, l3, u5) {
  "-" === l3[0] ? n2.setProperty(l3, u5) : n2[l3] = null == u5 ? "" : "number" != typeof u5 || c.test(l3) ? u5 : u5 + "px";
}
function H(n2, l3, u5, i5, t5) {
  var o3;
  n:
    if ("style" === l3)
      if ("string" == typeof u5)
        n2.style.cssText = u5;
      else {
        if ("string" == typeof i5 && (n2.style.cssText = i5 = ""), i5)
          for (l3 in i5)
            u5 && l3 in u5 || $(n2.style, l3, "");
        if (u5)
          for (l3 in u5)
            i5 && u5[l3] === i5[l3] || $(n2.style, l3, u5[l3]);
      }
    else if ("o" === l3[0] && "n" === l3[1])
      o3 = l3 !== (l3 = l3.replace(/Capture$/, "")), l3 = l3.toLowerCase() in n2 ? l3.toLowerCase().slice(2) : l3.slice(2), n2.l || (n2.l = {}), n2.l[l3 + o3] = u5, u5 ? i5 || n2.addEventListener(l3, o3 ? T : I2, o3) : n2.removeEventListener(l3, o3 ? T : I2, o3);
    else if ("dangerouslySetInnerHTML" !== l3) {
      if (t5)
        l3 = l3.replace(/xlink(H|:h)/, "h").replace(/sName$/, "s");
      else if ("href" !== l3 && "list" !== l3 && "form" !== l3 && "tabIndex" !== l3 && "download" !== l3 && l3 in n2)
        try {
          n2[l3] = null == u5 ? "" : u5;
          break n;
        } catch (n3) {
        }
      "function" == typeof u5 || (null == u5 || false === u5 && -1 == l3.indexOf("-") ? n2.removeAttribute(l3) : n2.setAttribute(l3, u5));
    }
}
function I2(n2) {
  this.l[n2.type + false](l.event ? l.event(n2) : n2);
}
function T(n2) {
  this.l[n2.type + true](l.event ? l.event(n2) : n2);
}
function j(n2, u5, i5, t5, o3, r3, f3, e5, c5) {
  var a6, h5, v3, y6, _3, k6, b5, g4, m6, x6, A5, C3, $3, H6, I6, T6 = u5.type;
  if (void 0 !== u5.constructor)
    return null;
  null != i5.__h && (c5 = i5.__h, e5 = u5.__e = i5.__e, u5.__h = null, r3 = [e5]), (a6 = l.__b) && a6(u5);
  try {
    n:
      if ("function" == typeof T6) {
        if (g4 = u5.props, m6 = (a6 = T6.contextType) && t5[a6.__c], x6 = a6 ? m6 ? m6.props.value : a6.__ : t5, i5.__c ? b5 = (h5 = u5.__c = i5.__c).__ = h5.__E : ("prototype" in T6 && T6.prototype.render ? u5.__c = h5 = new T6(g4, x6) : (u5.__c = h5 = new d(g4, x6), h5.constructor = T6, h5.render = O), m6 && m6.sub(h5), h5.props = g4, h5.state || (h5.state = {}), h5.context = x6, h5.__n = t5, v3 = h5.__d = true, h5.__h = [], h5._sb = []), null == h5.__s && (h5.__s = h5.state), null != T6.getDerivedStateFromProps && (h5.__s == h5.state && (h5.__s = s({}, h5.__s)), s(h5.__s, T6.getDerivedStateFromProps(g4, h5.__s))), y6 = h5.props, _3 = h5.state, v3)
          null == T6.getDerivedStateFromProps && null != h5.componentWillMount && h5.componentWillMount(), null != h5.componentDidMount && h5.__h.push(h5.componentDidMount);
        else {
          if (null == T6.getDerivedStateFromProps && g4 !== y6 && null != h5.componentWillReceiveProps && h5.componentWillReceiveProps(g4, x6), !h5.__e && null != h5.shouldComponentUpdate && false === h5.shouldComponentUpdate(g4, h5.__s, x6) || u5.__v === i5.__v) {
            for (h5.props = g4, h5.state = h5.__s, u5.__v !== i5.__v && (h5.__d = false), h5.__v = u5, u5.__e = i5.__e, u5.__k = i5.__k, u5.__k.forEach(function(n3) {
              n3 && (n3.__ = u5);
            }), A5 = 0; A5 < h5._sb.length; A5++)
              h5.__h.push(h5._sb[A5]);
            h5._sb = [], h5.__h.length && f3.push(h5);
            break n;
          }
          null != h5.componentWillUpdate && h5.componentWillUpdate(g4, h5.__s, x6), null != h5.componentDidUpdate && h5.__h.push(function() {
            h5.componentDidUpdate(y6, _3, k6);
          });
        }
        if (h5.context = x6, h5.props = g4, h5.__v = u5, h5.__P = n2, C3 = l.__r, $3 = 0, "prototype" in T6 && T6.prototype.render) {
          for (h5.state = h5.__s, h5.__d = false, C3 && C3(u5), a6 = h5.render(h5.props, h5.state, h5.context), H6 = 0; H6 < h5._sb.length; H6++)
            h5.__h.push(h5._sb[H6]);
          h5._sb = [];
        } else
          do {
            h5.__d = false, C3 && C3(u5), a6 = h5.render(h5.props, h5.state, h5.context), h5.state = h5.__s;
          } while (h5.__d && ++$3 < 25);
        h5.state = h5.__s, null != h5.getChildContext && (t5 = s(s({}, t5), h5.getChildContext())), v3 || null == h5.getSnapshotBeforeUpdate || (k6 = h5.getSnapshotBeforeUpdate(y6, _3)), I6 = null != a6 && a6.type === p2 && null == a6.key ? a6.props.children : a6, w(n2, Array.isArray(I6) ? I6 : [I6], u5, i5, t5, o3, r3, f3, e5, c5), h5.base = u5.__e, u5.__h = null, h5.__h.length && f3.push(h5), b5 && (h5.__E = h5.__ = null), h5.__e = false;
      } else
        null == r3 && u5.__v === i5.__v ? (u5.__k = i5.__k, u5.__e = i5.__e) : u5.__e = L2(i5.__e, u5, i5, t5, o3, r3, f3, c5);
    (a6 = l.diffed) && a6(u5);
  } catch (n3) {
    u5.__v = null, (c5 || null != r3) && (u5.__e = e5, u5.__h = !!c5, r3[r3.indexOf(e5)] = null), l.__e(n3, u5, i5);
  }
}
function z(n2, u5) {
  l.__c && l.__c(u5, n2), n2.some(function(u6) {
    try {
      n2 = u6.__h, u6.__h = [], n2.some(function(n3) {
        n3.call(u6);
      });
    } catch (n3) {
      l.__e(n3, u6.__v);
    }
  });
}
function L2(l3, u5, i5, t5, o3, r3, e5, c5) {
  var s6, h5, v3, y6 = i5.props, p4 = u5.props, d6 = u5.type, k6 = 0;
  if ("svg" === d6 && (o3 = true), null != r3) {
    for (; k6 < r3.length; k6++)
      if ((s6 = r3[k6]) && "setAttribute" in s6 == !!d6 && (d6 ? s6.localName === d6 : 3 === s6.nodeType)) {
        l3 = s6, r3[k6] = null;
        break;
      }
  }
  if (null == l3) {
    if (null === d6)
      return document.createTextNode(p4);
    l3 = o3 ? document.createElementNS("http://www.w3.org/2000/svg", d6) : document.createElement(d6, p4.is && p4), r3 = null, c5 = false;
  }
  if (null === d6)
    y6 === p4 || c5 && l3.data === p4 || (l3.data = p4);
  else {
    if (r3 = r3 && n.call(l3.childNodes), h5 = (y6 = i5.props || f).dangerouslySetInnerHTML, v3 = p4.dangerouslySetInnerHTML, !c5) {
      if (null != r3)
        for (y6 = {}, k6 = 0; k6 < l3.attributes.length; k6++)
          y6[l3.attributes[k6].name] = l3.attributes[k6].value;
      (v3 || h5) && (v3 && (h5 && v3.__html == h5.__html || v3.__html === l3.innerHTML) || (l3.innerHTML = v3 && v3.__html || ""));
    }
    if (C(l3, p4, y6, o3, c5), v3)
      u5.__k = [];
    else if (k6 = u5.props.children, w(l3, Array.isArray(k6) ? k6 : [k6], u5, i5, t5, o3 && "foreignObject" !== d6, r3, e5, r3 ? r3[0] : i5.__k && _(i5, 0), c5), null != r3)
      for (k6 = r3.length; k6--; )
        null != r3[k6] && a(r3[k6]);
    c5 || ("value" in p4 && void 0 !== (k6 = p4.value) && (k6 !== l3.value || "progress" === d6 && !k6 || "option" === d6 && k6 !== y6.value) && H(l3, "value", k6, y6.value, false), "checked" in p4 && void 0 !== (k6 = p4.checked) && k6 !== l3.checked && H(l3, "checked", k6, y6.checked, false));
  }
  return l3;
}
function M2(n2, u5, i5) {
  try {
    "function" == typeof n2 ? n2(u5) : n2.current = u5;
  } catch (n3) {
    l.__e(n3, i5);
  }
}
function N(n2, u5, i5) {
  var t5, o3;
  if (l.unmount && l.unmount(n2), (t5 = n2.ref) && (t5.current && t5.current !== n2.__e || M2(t5, null, u5)), null != (t5 = n2.__c)) {
    if (t5.componentWillUnmount)
      try {
        t5.componentWillUnmount();
      } catch (n3) {
        l.__e(n3, u5);
      }
    t5.base = t5.__P = null, n2.__c = void 0;
  }
  if (t5 = n2.__k)
    for (o3 = 0; o3 < t5.length; o3++)
      t5[o3] && N(t5[o3], u5, i5 || "function" != typeof n2.type);
  i5 || null == n2.__e || a(n2.__e), n2.__ = n2.__e = n2.__d = void 0;
}
function O(n2, l3, u5) {
  return this.constructor(n2, u5);
}
function P(u5, i5, t5) {
  var o3, r3, e5;
  l.__ && l.__(u5, i5), r3 = (o3 = "function" == typeof t5) ? null : t5 && t5.__k || i5.__k, e5 = [], j(i5, u5 = (!o3 && t5 || i5).__k = h(p2, null, [u5]), r3 || f, f, void 0 !== i5.ownerSVGElement, !o3 && t5 ? [t5] : r3 ? null : i5.firstChild ? n.call(i5.childNodes) : null, e5, !o3 && t5 ? t5 : r3 ? r3.__e : i5.firstChild, o3), z(e5, u5);
}
function S2(n2, l3) {
  P(n2, l3, S2);
}
function q(l3, u5, i5) {
  var t5, o3, r3, f3 = s({}, l3.props);
  for (r3 in u5)
    "key" == r3 ? t5 = u5[r3] : "ref" == r3 ? o3 = u5[r3] : f3[r3] = u5[r3];
  return arguments.length > 2 && (f3.children = arguments.length > 3 ? n.call(arguments, 2) : i5), v(l3.type, f3, t5 || l3.key, o3 || l3.ref, null);
}
function B(n2, l3) {
  var u5 = { __c: l3 = "__cC" + r++, __: n2, Consumer: function(n3, l4) {
    return n3.children(l4);
  }, Provider: function(n3) {
    var u6, i5;
    return this.getChildContext || (u6 = [], (i5 = {})[l3] = this, this.getChildContext = function() {
      return i5;
    }, this.shouldComponentUpdate = function(n4) {
      this.props.value !== n4.value && u6.some(b);
    }, this.sub = function(n4) {
      u6.push(n4);
      var l4 = n4.componentWillUnmount;
      n4.componentWillUnmount = function() {
        u6.splice(u6.indexOf(n4), 1), l4 && l4.call(n4);
      };
    }), n3.children;
  } };
  return u5.Provider.__ = u5.Consumer.contextType = u5;
}
var n, l, u, i, t, o, r, f, e, c;
var init_preact_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/dist/preact.module.js"() {
    f = {};
    e = [];
    c = /acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i;
    n = e.slice, l = { __e: function(n2, l3, u5, i5) {
      for (var t5, o3, r3; l3 = l3.__; )
        if ((t5 = l3.__c) && !t5.__)
          try {
            if ((o3 = t5.constructor) && null != o3.getDerivedStateFromError && (t5.setState(o3.getDerivedStateFromError(n2)), r3 = t5.__d), null != t5.componentDidCatch && (t5.componentDidCatch(n2, i5 || {}), r3 = t5.__d), r3)
              return t5.__E = t5;
          } catch (l4) {
            n2 = l4;
          }
      throw n2;
    } }, u = 0, i = function(n2) {
      return null != n2 && void 0 === n2.constructor;
    }, d.prototype.setState = function(n2, l3) {
      var u5;
      u5 = null != this.__s && this.__s !== this.state ? this.__s : this.__s = s({}, this.state), "function" == typeof n2 && (n2 = n2(s({}, u5), this.props)), n2 && s(u5, n2), null != n2 && this.__v && (l3 && this._sb.push(l3), b(this));
    }, d.prototype.forceUpdate = function(n2) {
      this.__v && (this.__e = true, n2 && this.__h.push(n2), b(this));
    }, d.prototype.render = p2, t = [], g.__r = 0, r = 0;
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/hooks/dist/hooks.module.js
function d2(t5, u5) {
  l.__h && l.__h(r2, t5, o2 || u5), o2 = 0;
  var i5 = r2.__H || (r2.__H = { __: [], __h: [] });
  return t5 >= i5.__.length && i5.__.push({ __V: c2 }), i5.__[t5];
}
function p3(n2) {
  return o2 = 1, y2(B2, n2);
}
function y2(n2, u5, i5) {
  var o3 = d2(t2++, 2);
  if (o3.t = n2, !o3.__c && (o3.__ = [i5 ? i5(u5) : B2(void 0, u5), function(n3) {
    var t5 = o3.__N ? o3.__N[0] : o3.__[0], r3 = o3.t(t5, n3);
    t5 !== r3 && (o3.__N = [r3, o3.__[1]], o3.__c.setState({}));
  }], o3.__c = r2, !r2.u)) {
    r2.u = true;
    var f3 = r2.shouldComponentUpdate;
    r2.shouldComponentUpdate = function(n3, t5, r3) {
      if (!o3.__c.__H)
        return true;
      var u6 = o3.__c.__H.__.filter(function(n4) {
        return n4.__c;
      });
      if (u6.every(function(n4) {
        return !n4.__N;
      }))
        return !f3 || f3.call(this, n3, t5, r3);
      var i6 = false;
      return u6.forEach(function(n4) {
        if (n4.__N) {
          var t6 = n4.__[0];
          n4.__ = n4.__N, n4.__N = void 0, t6 !== n4.__[0] && (i6 = true);
        }
      }), !(!i6 && o3.__c.props === n3) && (!f3 || f3.call(this, n3, t5, r3));
    };
  }
  return o3.__N || o3.__;
}
function h2(u5, i5) {
  var o3 = d2(t2++, 3);
  !l.__s && z2(o3.__H, i5) && (o3.__ = u5, o3.i = i5, r2.__H.__h.push(o3));
}
function s2(u5, i5) {
  var o3 = d2(t2++, 4);
  !l.__s && z2(o3.__H, i5) && (o3.__ = u5, o3.i = i5, r2.__h.push(o3));
}
function _2(n2) {
  return o2 = 5, F(function() {
    return { current: n2 };
  }, []);
}
function A3(n2, t5, r3) {
  o2 = 6, s2(function() {
    return "function" == typeof n2 ? (n2(t5()), function() {
      return n2(null);
    }) : n2 ? (n2.current = t5(), function() {
      return n2.current = null;
    }) : void 0;
  }, null == r3 ? r3 : r3.concat(n2));
}
function F(n2, r3) {
  var u5 = d2(t2++, 7);
  return z2(u5.__H, r3) ? (u5.__V = n2(), u5.i = r3, u5.__h = n2, u5.__V) : u5.__;
}
function T2(n2, t5) {
  return o2 = 8, F(function() {
    return n2;
  }, t5);
}
function q2(n2) {
  var u5 = r2.context[n2.__c], i5 = d2(t2++, 9);
  return i5.c = n2, u5 ? (null == i5.__ && (i5.__ = true, u5.sub(r2)), u5.props.value) : n2.__;
}
function x2(t5, r3) {
  l.useDebugValue && l.useDebugValue(r3 ? r3(t5) : t5);
}
function P2(n2) {
  var u5 = d2(t2++, 10), i5 = p3();
  return u5.__ = n2, r2.componentDidCatch || (r2.componentDidCatch = function(n3, t5) {
    u5.__ && u5.__(n3, t5), i5[1](n3);
  }), [i5[0], function() {
    i5[1](void 0);
  }];
}
function V() {
  var n2 = d2(t2++, 11);
  if (!n2.__) {
    for (var u5 = r2.__v; null !== u5 && !u5.__m && null !== u5.__; )
      u5 = u5.__;
    var i5 = u5.__m || (u5.__m = [0, 0]);
    n2.__ = "P" + i5[0] + "-" + i5[1]++;
  }
  return n2.__;
}
function b2() {
  for (var t5; t5 = f2.shift(); )
    if (t5.__P && t5.__H)
      try {
        t5.__H.__h.forEach(k2), t5.__H.__h.forEach(w2), t5.__H.__h = [];
      } catch (r3) {
        t5.__H.__h = [], l.__e(r3, t5.__v);
      }
}
function j2(n2) {
  var t5, r3 = function() {
    clearTimeout(u5), g2 && cancelAnimationFrame(t5), setTimeout(n2);
  }, u5 = setTimeout(r3, 100);
  g2 && (t5 = requestAnimationFrame(r3));
}
function k2(n2) {
  var t5 = r2, u5 = n2.__c;
  "function" == typeof u5 && (n2.__c = void 0, u5()), r2 = t5;
}
function w2(n2) {
  var t5 = r2;
  n2.__c = n2.__(), r2 = t5;
}
function z2(n2, t5) {
  return !n2 || n2.length !== t5.length || t5.some(function(t6, r3) {
    return t6 !== n2[r3];
  });
}
function B2(n2, t5) {
  return "function" == typeof t5 ? t5(n2) : t5;
}
var t2, r2, u2, i2, o2, f2, c2, e2, a2, v2, l2, m2, g2;
var init_hooks_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/hooks/dist/hooks.module.js"() {
    init_preact_module();
    o2 = 0;
    f2 = [];
    c2 = [];
    e2 = l.__b;
    a2 = l.__r;
    v2 = l.diffed;
    l2 = l.__c;
    m2 = l.unmount;
    l.__b = function(n2) {
      r2 = null, e2 && e2(n2);
    }, l.__r = function(n2) {
      a2 && a2(n2), t2 = 0;
      var i5 = (r2 = n2.__c).__H;
      i5 && (u2 === r2 ? (i5.__h = [], r2.__h = [], i5.__.forEach(function(n3) {
        n3.__N && (n3.__ = n3.__N), n3.__V = c2, n3.__N = n3.i = void 0;
      })) : (i5.__h.forEach(k2), i5.__h.forEach(w2), i5.__h = [])), u2 = r2;
    }, l.diffed = function(t5) {
      v2 && v2(t5);
      var o3 = t5.__c;
      o3 && o3.__H && (o3.__H.__h.length && (1 !== f2.push(o3) && i2 === l.requestAnimationFrame || ((i2 = l.requestAnimationFrame) || j2)(b2)), o3.__H.__.forEach(function(n2) {
        n2.i && (n2.__H = n2.i), n2.__V !== c2 && (n2.__ = n2.__V), n2.i = void 0, n2.__V = c2;
      })), u2 = r2 = null;
    }, l.__c = function(t5, r3) {
      r3.some(function(t6) {
        try {
          t6.__h.forEach(k2), t6.__h = t6.__h.filter(function(n2) {
            return !n2.__ || w2(n2);
          });
        } catch (u5) {
          r3.some(function(n2) {
            n2.__h && (n2.__h = []);
          }), r3 = [], l.__e(u5, t6.__v);
        }
      }), l2 && l2(t5, r3);
    }, l.unmount = function(t5) {
      m2 && m2(t5);
      var r3, u5 = t5.__c;
      u5 && u5.__H && (u5.__H.__.forEach(function(n2) {
        try {
          k2(n2);
        } catch (n3) {
          r3 = n3;
        }
      }), u5.__H = void 0, r3 && l.__e(r3, u5.__v));
    };
    g2 = "function" == typeof requestAnimationFrame;
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/compat/dist/compat.module.js
var compat_module_exports = {};
__export(compat_module_exports, {
  Children: () => O2,
  Component: () => d,
  Fragment: () => p2,
  PureComponent: () => w3,
  StrictMode: () => vn2,
  Suspense: () => D3,
  SuspenseList: () => V2,
  __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: () => rn,
  cloneElement: () => cn,
  createContext: () => B,
  createElement: () => h,
  createFactory: () => on,
  createPortal: () => j3,
  createRef: () => y,
  default: () => bn,
  findDOMNode: () => an,
  flushSync: () => hn,
  forwardRef: () => k3,
  hydrate: () => q3,
  isValidElement: () => ln,
  lazy: () => M3,
  memo: () => R,
  render: () => Y2,
  startTransition: () => dn,
  unmountComponentAtNode: () => fn,
  unstable_batchedUpdates: () => sn,
  useCallback: () => T2,
  useContext: () => q2,
  useDebugValue: () => x2,
  useDeferredValue: () => pn,
  useEffect: () => h2,
  useErrorBoundary: () => P2,
  useId: () => V,
  useImperativeHandle: () => A3,
  useInsertionEffect: () => yn,
  useLayoutEffect: () => s2,
  useMemo: () => F,
  useReducer: () => y2,
  useRef: () => _2,
  useState: () => p3,
  useSyncExternalStore: () => _n,
  useTransition: () => mn,
  version: () => un
});
function g3(n2, t5) {
  for (var e5 in t5)
    n2[e5] = t5[e5];
  return n2;
}
function C2(n2, t5) {
  for (var e5 in n2)
    if ("__source" !== e5 && !(e5 in t5))
      return true;
  for (var r3 in t5)
    if ("__source" !== r3 && n2[r3] !== t5[r3])
      return true;
  return false;
}
function E(n2, t5) {
  return n2 === t5 && (0 !== n2 || 1 / n2 == 1 / t5) || n2 != n2 && t5 != t5;
}
function w3(n2) {
  this.props = n2;
}
function R(n2, e5) {
  function r3(n3) {
    var t5 = this.props.ref, r4 = t5 == n3.ref;
    return !r4 && t5 && (t5.call ? t5(null) : t5.current = null), e5 ? !e5(this.props, n3) || !r4 : C2(this.props, n3);
  }
  function u5(e6) {
    return this.shouldComponentUpdate = r3, h(n2, e6);
  }
  return u5.displayName = "Memo(" + (n2.displayName || n2.name) + ")", u5.prototype.isReactComponent = true, u5.__f = true, u5;
}
function k3(n2) {
  function t5(t6) {
    var e5 = g3({}, t6);
    return delete e5.ref, n2(e5, t6.ref || null);
  }
  return t5.$$typeof = N2, t5.render = t5, t5.prototype.isReactComponent = t5.__f = true, t5.displayName = "ForwardRef(" + (n2.displayName || n2.name) + ")", t5;
}
function L3(n2, t5, e5) {
  return n2 && (n2.__c && n2.__c.__H && (n2.__c.__H.__.forEach(function(n3) {
    "function" == typeof n3.__c && n3.__c();
  }), n2.__c.__H = null), null != (n2 = g3({}, n2)).__c && (n2.__c.__P === e5 && (n2.__c.__P = t5), n2.__c = null), n2.__k = n2.__k && n2.__k.map(function(n3) {
    return L3(n3, t5, e5);
  })), n2;
}
function U(n2, t5, e5) {
  return n2 && (n2.__v = null, n2.__k = n2.__k && n2.__k.map(function(n3) {
    return U(n3, t5, e5);
  }), n2.__c && n2.__c.__P === t5 && (n2.__e && e5.insertBefore(n2.__e, n2.__d), n2.__c.__e = true, n2.__c.__P = e5)), n2;
}
function D3() {
  this.__u = 0, this.t = null, this.__b = null;
}
function F2(n2) {
  var t5 = n2.__.__c;
  return t5 && t5.__a && t5.__a(n2);
}
function M3(n2) {
  var e5, r3, u5;
  function o3(o4) {
    if (e5 || (e5 = n2()).then(function(n3) {
      r3 = n3.default || n3;
    }, function(n3) {
      u5 = n3;
    }), u5)
      throw u5;
    if (!r3)
      throw e5;
    return h(r3, o4);
  }
  return o3.displayName = "Lazy", o3.__f = true, o3;
}
function V2() {
  this.u = null, this.o = null;
}
function P3(n2) {
  return this.getChildContext = function() {
    return n2.context;
  }, n2.children;
}
function $2(n2) {
  var e5 = this, r3 = n2.i;
  e5.componentWillUnmount = function() {
    P(null, e5.l), e5.l = null, e5.i = null;
  }, e5.i && e5.i !== r3 && e5.componentWillUnmount(), n2.__v ? (e5.l || (e5.i = r3, e5.l = { nodeType: 1, parentNode: r3, childNodes: [], appendChild: function(n3) {
    this.childNodes.push(n3), e5.i.appendChild(n3);
  }, insertBefore: function(n3, t5) {
    this.childNodes.push(n3), e5.i.appendChild(n3);
  }, removeChild: function(n3) {
    this.childNodes.splice(this.childNodes.indexOf(n3) >>> 1, 1), e5.i.removeChild(n3);
  } }), P(h(P3, { context: e5.context }, n2.__v), e5.l)) : e5.l && e5.componentWillUnmount();
}
function j3(n2, e5) {
  var r3 = h($2, { __v: n2, i: e5 });
  return r3.containerInfo = e5, r3;
}
function Y2(n2, t5, e5) {
  return null == t5.__k && (t5.textContent = ""), P(n2, t5), "function" == typeof e5 && e5(), n2 ? n2.__c : null;
}
function q3(n2, t5, e5) {
  return S2(n2, t5), "function" == typeof e5 && e5(), n2 ? n2.__c : null;
}
function J() {
}
function K3() {
  return this.cancelBubble;
}
function Q() {
  return this.defaultPrevented;
}
function on(n2) {
  return h.bind(null, n2);
}
function ln(n2) {
  return !!n2 && n2.$$typeof === z3;
}
function cn(n2) {
  return ln(n2) ? q.apply(null, arguments) : n2;
}
function fn(n2) {
  return !!n2.__k && (P(null, n2), true);
}
function an(n2) {
  return n2 && (n2.base || 1 === n2.nodeType && n2) || null;
}
function dn(n2) {
  n2();
}
function pn(n2) {
  return n2;
}
function mn() {
  return [false, dn];
}
function _n(n2, t5) {
  var e5 = t5(), r3 = p3({ h: { __: e5, v: t5 } }), u5 = r3[0].h, o3 = r3[1];
  return s2(function() {
    u5.__ = e5, u5.v = t5, E(u5.__, t5()) || o3({ h: u5 });
  }, [n2, e5, t5]), h2(function() {
    return E(u5.__, u5.v()) || o3({ h: u5 }), n2(function() {
      E(u5.__, u5.v()) || o3({ h: u5 });
    });
  }, [n2]), e5;
}
var x3, N2, A4, O2, T3, I3, W, z3, B3, H2, Z2, G, X2, nn, tn, en, rn, un, sn, hn, vn2, yn, bn;
var init_compat_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/compat/dist/compat.module.js"() {
    init_preact_module();
    init_preact_module();
    init_hooks_module();
    init_hooks_module();
    (w3.prototype = new d()).isPureReactComponent = true, w3.prototype.shouldComponentUpdate = function(n2, t5) {
      return C2(this.props, n2) || C2(this.state, t5);
    };
    x3 = l.__b;
    l.__b = function(n2) {
      n2.type && n2.type.__f && n2.ref && (n2.props.ref = n2.ref, n2.ref = null), x3 && x3(n2);
    };
    N2 = "undefined" != typeof Symbol && Symbol.for && Symbol.for("react.forward_ref") || 3911;
    A4 = function(n2, t5) {
      return null == n2 ? null : x(x(n2).map(t5));
    };
    O2 = { map: A4, forEach: A4, count: function(n2) {
      return n2 ? x(n2).length : 0;
    }, only: function(n2) {
      var t5 = x(n2);
      if (1 !== t5.length)
        throw "Children.only";
      return t5[0];
    }, toArray: x };
    T3 = l.__e;
    l.__e = function(n2, t5, e5, r3) {
      if (n2.then) {
        for (var u5, o3 = t5; o3 = o3.__; )
          if ((u5 = o3.__c) && u5.__c)
            return null == t5.__e && (t5.__e = e5.__e, t5.__k = e5.__k), u5.__c(n2, t5);
      }
      T3(n2, t5, e5, r3);
    };
    I3 = l.unmount;
    l.unmount = function(n2) {
      var t5 = n2.__c;
      t5 && t5.__R && t5.__R(), t5 && true === n2.__h && (n2.type = null), I3 && I3(n2);
    }, (D3.prototype = new d()).__c = function(n2, t5) {
      var e5 = t5.__c, r3 = this;
      null == r3.t && (r3.t = []), r3.t.push(e5);
      var u5 = F2(r3.__v), o3 = false, i5 = function() {
        o3 || (o3 = true, e5.__R = null, u5 ? u5(l3) : l3());
      };
      e5.__R = i5;
      var l3 = function() {
        if (!--r3.__u) {
          if (r3.state.__a) {
            var n3 = r3.state.__a;
            r3.__v.__k[0] = U(n3, n3.__c.__P, n3.__c.__O);
          }
          var t6;
          for (r3.setState({ __a: r3.__b = null }); t6 = r3.t.pop(); )
            t6.forceUpdate();
        }
      }, c5 = true === t5.__h;
      r3.__u++ || c5 || r3.setState({ __a: r3.__b = r3.__v.__k[0] }), n2.then(i5, i5);
    }, D3.prototype.componentWillUnmount = function() {
      this.t = [];
    }, D3.prototype.render = function(n2, e5) {
      if (this.__b) {
        if (this.__v.__k) {
          var r3 = document.createElement("div"), o3 = this.__v.__k[0].__c;
          this.__v.__k[0] = L3(this.__b, r3, o3.__O = o3.__P);
        }
        this.__b = null;
      }
      var i5 = e5.__a && h(p2, null, n2.fallback);
      return i5 && (i5.__h = null), [h(p2, null, e5.__a ? null : n2.children), i5];
    };
    W = function(n2, t5, e5) {
      if (++e5[1] === e5[0] && n2.o.delete(t5), n2.props.revealOrder && ("t" !== n2.props.revealOrder[0] || !n2.o.size))
        for (e5 = n2.u; e5; ) {
          for (; e5.length > 3; )
            e5.pop()();
          if (e5[1] < e5[0])
            break;
          n2.u = e5 = e5[2];
        }
    };
    (V2.prototype = new d()).__a = function(n2) {
      var t5 = this, e5 = F2(t5.__v), r3 = t5.o.get(n2);
      return r3[0]++, function(u5) {
        var o3 = function() {
          t5.props.revealOrder ? (r3.push(u5), W(t5, n2, r3)) : u5();
        };
        e5 ? e5(o3) : o3();
      };
    }, V2.prototype.render = function(n2) {
      this.u = null, this.o = /* @__PURE__ */ new Map();
      var t5 = x(n2.children);
      n2.revealOrder && "b" === n2.revealOrder[0] && t5.reverse();
      for (var e5 = t5.length; e5--; )
        this.o.set(t5[e5], this.u = [1, 0, this.u]);
      return n2.children;
    }, V2.prototype.componentDidUpdate = V2.prototype.componentDidMount = function() {
      var n2 = this;
      this.o.forEach(function(t5, e5) {
        W(n2, e5, t5);
      });
    };
    z3 = "undefined" != typeof Symbol && Symbol.for && Symbol.for("react.element") || 60103;
    B3 = /^(?:accent|alignment|arabic|baseline|cap|clip(?!PathU)|color|dominant|fill|flood|font|glyph(?!R)|horiz|image|letter|lighting|marker(?!H|W|U)|overline|paint|pointer|shape|stop|strikethrough|stroke|text(?!L)|transform|underline|unicode|units|v|vector|vert|word|writing|x(?!C))[A-Z]/;
    H2 = "undefined" != typeof document;
    Z2 = function(n2) {
      return ("undefined" != typeof Symbol && "symbol" == typeof Symbol() ? /fil|che|rad/i : /fil|che|ra/i).test(n2);
    };
    d.prototype.isReactComponent = {}, ["componentWillMount", "componentWillReceiveProps", "componentWillUpdate"].forEach(function(t5) {
      Object.defineProperty(d.prototype, t5, { configurable: true, get: function() {
        return this["UNSAFE_" + t5];
      }, set: function(n2) {
        Object.defineProperty(this, t5, { configurable: true, writable: true, value: n2 });
      } });
    });
    G = l.event;
    l.event = function(n2) {
      return G && (n2 = G(n2)), n2.persist = J, n2.isPropagationStopped = K3, n2.isDefaultPrevented = Q, n2.nativeEvent = n2;
    };
    nn = { configurable: true, get: function() {
      return this.class;
    } };
    tn = l.vnode;
    l.vnode = function(n2) {
      var t5 = n2.type, e5 = n2.props, u5 = e5;
      if ("string" == typeof t5) {
        var o3 = -1 === t5.indexOf("-");
        for (var i5 in u5 = {}, e5) {
          var l3 = e5[i5];
          H2 && "children" === i5 && "noscript" === t5 || "value" === i5 && "defaultValue" in e5 && null == l3 || ("defaultValue" === i5 && "value" in e5 && null == e5.value ? i5 = "value" : "download" === i5 && true === l3 ? l3 = "" : /ondoubleclick/i.test(i5) ? i5 = "ondblclick" : /^onchange(textarea|input)/i.test(i5 + t5) && !Z2(e5.type) ? i5 = "oninput" : /^onfocus$/i.test(i5) ? i5 = "onfocusin" : /^onblur$/i.test(i5) ? i5 = "onfocusout" : /^on(Ani|Tra|Tou|BeforeInp|Compo)/.test(i5) ? i5 = i5.toLowerCase() : o3 && B3.test(i5) ? i5 = i5.replace(/[A-Z0-9]/g, "-$&").toLowerCase() : null === l3 && (l3 = void 0), /^oninput$/i.test(i5) && (i5 = i5.toLowerCase(), u5[i5] && (i5 = "oninputCapture")), u5[i5] = l3);
        }
        "select" == t5 && u5.multiple && Array.isArray(u5.value) && (u5.value = x(e5.children).forEach(function(n3) {
          n3.props.selected = -1 != u5.value.indexOf(n3.props.value);
        })), "select" == t5 && null != u5.defaultValue && (u5.value = x(e5.children).forEach(function(n3) {
          n3.props.selected = u5.multiple ? -1 != u5.defaultValue.indexOf(n3.props.value) : u5.defaultValue == n3.props.value;
        })), n2.props = u5, e5.class != e5.className && (nn.enumerable = "className" in e5, null != e5.className && (u5.class = e5.className), Object.defineProperty(u5, "className", nn));
      }
      n2.$$typeof = z3, tn && tn(n2);
    };
    en = l.__r;
    l.__r = function(n2) {
      en && en(n2), X2 = n2.__c;
    };
    rn = { ReactCurrentDispatcher: { current: { readContext: function(n2) {
      return X2.__n[n2.__c].props.value;
    } } } };
    un = "17.0.2";
    sn = function(n2, t5) {
      return n2(t5);
    };
    hn = function(n2, t5) {
      return n2(t5);
    };
    vn2 = p2;
    yn = s2;
    bn = { useState: p3, useId: V, useReducer: y2, useEffect: h2, useLayoutEffect: s2, useInsertionEffect: yn, useTransition: mn, useDeferredValue: pn, useSyncExternalStore: _n, startTransition: dn, useRef: _2, useImperativeHandle: A3, useMemo: F, useCallback: T2, useContext: q2, useDebugValue: x2, version: "17.0.2", Children: O2, render: Y2, hydrate: q3, unmountComponentAtNode: fn, createPortal: j3, createElement: h, createContext: B, createFactory: on, cloneElement: cn, createRef: y, Fragment: p2, isValidElement: ln, findDOMNode: an, Component: d, PureComponent: w3, memo: R, forwardRef: k3, flushSync: hn, unstable_batchedUpdates: sn, StrictMode: vn2, Suspense: D3, SuspenseList: V2, lazy: M3, __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: rn };
  }
});

// ../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/cjs/use-sync-external-store-shim.production.min.js
var require_use_sync_external_store_shim_production_min = __commonJS({
  "../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/cjs/use-sync-external-store-shim.production.min.js"(exports) {
    "use strict";
    var e5 = (init_compat_module(), __toCommonJS(compat_module_exports));
    function h5(a6, b5) {
      return a6 === b5 && (0 !== a6 || 1 / a6 === 1 / b5) || a6 !== a6 && b5 !== b5;
    }
    var k6 = "function" === typeof Object.is ? Object.is : h5;
    var l3 = e5.useState;
    var m6 = e5.useEffect;
    var n2 = e5.useLayoutEffect;
    var p4 = e5.useDebugValue;
    function q6(a6, b5) {
      var d6 = b5(), f3 = l3({ inst: { value: d6, getSnapshot: b5 } }), c5 = f3[0].inst, g4 = f3[1];
      n2(function() {
        c5.value = d6;
        c5.getSnapshot = b5;
        r3(c5) && g4({ inst: c5 });
      }, [a6, d6, b5]);
      m6(function() {
        r3(c5) && g4({ inst: c5 });
        return a6(function() {
          r3(c5) && g4({ inst: c5 });
        });
      }, [a6]);
      p4(d6);
      return d6;
    }
    function r3(a6) {
      var b5 = a6.getSnapshot;
      a6 = a6.value;
      try {
        var d6 = b5();
        return !k6(a6, d6);
      } catch (f3) {
        return true;
      }
    }
    function t5(a6, b5) {
      return b5();
    }
    var u5 = "undefined" === typeof window || "undefined" === typeof window.document || "undefined" === typeof window.document.createElement ? t5 : q6;
    exports.useSyncExternalStore = void 0 !== e5.useSyncExternalStore ? e5.useSyncExternalStore : u5;
  }
});

// ../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/shim/index.js
var require_shim = __commonJS({
  "../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/shim/index.js"(exports, module) {
    "use strict";
    if (true) {
      module.exports = require_use_sync_external_store_shim_production_min();
    } else {
      module.exports = null;
    }
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/AcademicCapIcon.js
var require_AcademicCapIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/AcademicCapIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function AcademicCapIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M9.664 1.319a.75.75 0 01.672 0 41.059 41.059 0 018.198 5.424.75.75 0 01-.254 1.285 31.372 31.372 0 00-7.86 3.83.75.75 0 01-.84 0 31.508 31.508 0 00-2.08-1.287V9.394c0-.244.116-.463.302-.592a35.504 35.504 0 013.305-2.033.75.75 0 00-.714-1.319 37 37 0 00-3.446 2.12A2.216 2.216 0 006 9.393v.38a31.293 31.293 0 00-4.28-1.746.75.75 0 01-.254-1.285 41.059 41.059 0 018.198-5.424zM6 11.459a29.848 29.848 0 00-2.455-1.158 41.029 41.029 0 00-.39 3.114.75.75 0 00.419.74c.528.256 1.046.53 1.554.82-.21.324-.455.63-.739.914a.75.75 0 101.06 1.06c.37-.369.69-.77.96-1.193a26.61 26.61 0 013.095 2.348.75.75 0 00.992 0 26.547 26.547 0 015.93-3.95.75.75 0 00.42-.739 41.053 41.053 0 00-.39-3.114 29.925 29.925 0 00-5.199 2.801 2.25 2.25 0 01-2.514 0c-.41-.275-.826-.541-1.25-.797a6.985 6.985 0 01-1.084 3.45 26.503 26.503 0 00-1.281-.78A5.487 5.487 0 006 12v-.54z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(AcademicCapIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/AdjustmentsHorizontalIcon.js
var require_AdjustmentsHorizontalIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/AdjustmentsHorizontalIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function AdjustmentsHorizontalIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10 3.75a2 2 0 10-4 0 2 2 0 004 0zM17.25 4.5a.75.75 0 000-1.5h-5.5a.75.75 0 000 1.5h5.5zM5 3.75a.75.75 0 01-.75.75h-1.5a.75.75 0 010-1.5h1.5a.75.75 0 01.75.75zM4.25 17a.75.75 0 000-1.5h-1.5a.75.75 0 000 1.5h1.5zM17.25 17a.75.75 0 000-1.5h-5.5a.75.75 0 000 1.5h5.5zM9 10a.75.75 0 01-.75.75h-5.5a.75.75 0 010-1.5h5.5A.75.75 0 019 10zM17.25 10.75a.75.75 0 000-1.5h-1.5a.75.75 0 000 1.5h1.5zM14 10a2 2 0 10-4 0 2 2 0 004 0zM10 16.25a2 2 0 10-4 0 2 2 0 004 0z"
      }));
    }
    var ForwardRef = React.forwardRef(AdjustmentsHorizontalIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/AdjustmentsVerticalIcon.js
var require_AdjustmentsVerticalIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/AdjustmentsVerticalIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function AdjustmentsVerticalIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M17 2.75a.75.75 0 00-1.5 0v5.5a.75.75 0 001.5 0v-5.5zM17 15.75a.75.75 0 00-1.5 0v1.5a.75.75 0 001.5 0v-1.5zM3.75 15a.75.75 0 01.75.75v1.5a.75.75 0 01-1.5 0v-1.5a.75.75 0 01.75-.75zM4.5 2.75a.75.75 0 00-1.5 0v5.5a.75.75 0 001.5 0v-5.5zM10 11a.75.75 0 01.75.75v5.5a.75.75 0 01-1.5 0v-5.5A.75.75 0 0110 11zM10.75 2.75a.75.75 0 00-1.5 0v1.5a.75.75 0 001.5 0v-1.5zM10 6a2 2 0 100 4 2 2 0 000-4zM3.75 10a2 2 0 100 4 2 2 0 000-4zM16.25 10a2 2 0 100 4 2 2 0 000-4z"
      }));
    }
    var ForwardRef = React.forwardRef(AdjustmentsVerticalIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArchiveBoxArrowDownIcon.js
var require_ArchiveBoxArrowDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArchiveBoxArrowDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArchiveBoxArrowDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 3a1 1 0 00-1 1v1a1 1 0 001 1h16a1 1 0 001-1V4a1 1 0 00-1-1H2zm0 4.5h16l-.811 7.71a2 2 0 01-1.99 1.79H4.802a2 2 0 01-1.99-1.79L2 7.5zM10 9a.75.75 0 01.75.75v2.546l.943-1.048a.75.75 0 111.114 1.004l-2.25 2.5a.75.75 0 01-1.114 0l-2.25-2.5a.75.75 0 111.114-1.004l.943 1.048V9.75A.75.75 0 0110 9z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArchiveBoxArrowDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArchiveBoxXMarkIcon.js
var require_ArchiveBoxXMarkIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArchiveBoxXMarkIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArchiveBoxXMarkIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M2 3a1 1 0 00-1 1v1a1 1 0 001 1h16a1 1 0 001-1V4a1 1 0 00-1-1H2z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 7.5h16l-.811 7.71a2 2 0 01-1.99 1.79H4.802a2 2 0 01-1.99-1.79L2 7.5zm5.22 1.72a.75.75 0 011.06 0L10 10.94l1.72-1.72a.75.75 0 111.06 1.06L11.06 12l1.72 1.72a.75.75 0 11-1.06 1.06L10 13.06l-1.72 1.72a.75.75 0 01-1.06-1.06L8.94 12l-1.72-1.72a.75.75 0 010-1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArchiveBoxXMarkIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArchiveBoxIcon.js
var require_ArchiveBoxIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArchiveBoxIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArchiveBoxIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M2 3a1 1 0 00-1 1v1a1 1 0 001 1h16a1 1 0 001-1V4a1 1 0 00-1-1H2z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 7.5h16l-.811 7.71a2 2 0 01-1.99 1.79H4.802a2 2 0 01-1.99-1.79L2 7.5zM7 11a1 1 0 011-1h4a1 1 0 110 2H8a1 1 0 01-1-1z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArchiveBoxIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownCircleIcon.js
var require_ArrowDownCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowDownCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zm.75-11.25a.75.75 0 00-1.5 0v4.59L7.3 9.24a.75.75 0 00-1.1 1.02l3.25 3.5a.75.75 0 001.1 0l3.25-3.5a.75.75 0 10-1.1-1.02l-1.95 2.1V6.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownLeftIcon.js
var require_ArrowDownLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowDownLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M14.78 5.22a.75.75 0 00-1.06 0L6.5 12.44V6.75a.75.75 0 00-1.5 0v7.5c0 .414.336.75.75.75h7.5a.75.75 0 000-1.5H7.56l7.22-7.22a.75.75 0 000-1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownOnSquareStackIcon.js
var require_ArrowDownOnSquareStackIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownOnSquareStackIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowDownOnSquareStackIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M8 1a.75.75 0 01.75.75V6h-1.5V1.75A.75.75 0 018 1zm-.75 5v3.296l-.943-1.048a.75.75 0 10-1.114 1.004l2.25 2.5a.75.75 0 001.114 0l2.25-2.5a.75.75 0 00-1.114-1.004L8.75 9.296V6h2A2.25 2.25 0 0113 8.25v4.5A2.25 2.25 0 0110.75 15h-5.5A2.25 2.25 0 013 12.75v-4.5A2.25 2.25 0 015.25 6h2zM7 16.75v-.25h3.75a3.75 3.75 0 003.75-3.75V10h.25A2.25 2.25 0 0117 12.25v4.5A2.25 2.25 0 0114.75 19h-5.5A2.25 2.25 0 017 16.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownOnSquareStackIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownOnSquareIcon.js
var require_ArrowDownOnSquareIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownOnSquareIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowDownOnSquareIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M13.75 7h-3v5.296l1.943-2.048a.75.75 0 011.114 1.004l-3.25 3.5a.75.75 0 01-1.114 0l-3.25-3.5a.75.75 0 111.114-1.004l1.943 2.048V7h1.5V1.75a.75.75 0 00-1.5 0V7h-3A2.25 2.25 0 004 9.25v7.5A2.25 2.25 0 006.25 19h7.5A2.25 2.25 0 0016 16.75v-7.5A2.25 2.25 0 0013.75 7z"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownOnSquareIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownRightIcon.js
var require_ArrowDownRightIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownRightIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowDownRightIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M6.28 5.22a.75.75 0 00-1.06 1.06l7.22 7.22H6.75a.75.75 0 000 1.5h7.5a.747.747 0 00.75-.75v-7.5a.75.75 0 00-1.5 0v5.69L6.28 5.22z"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownRightIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownTrayIcon.js
var require_ArrowDownTrayIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownTrayIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowDownTrayIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10.75 2.75a.75.75 0 00-1.5 0v8.614L6.295 8.235a.75.75 0 10-1.09 1.03l4.25 4.5a.75.75 0 001.09 0l4.25-4.5a.75.75 0 00-1.09-1.03l-2.955 3.129V2.75z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M3.5 12.75a.75.75 0 00-1.5 0v2.5A2.75 2.75 0 004.75 18h10.5A2.75 2.75 0 0018 15.25v-2.5a.75.75 0 00-1.5 0v2.5c0 .69-.56 1.25-1.25 1.25H4.75c-.69 0-1.25-.56-1.25-1.25v-2.5z"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownTrayIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownIcon.js
var require_ArrowDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 3a.75.75 0 01.75.75v10.638l3.96-4.158a.75.75 0 111.08 1.04l-5.25 5.5a.75.75 0 01-1.08 0l-5.25-5.5a.75.75 0 111.08-1.04l3.96 4.158V3.75A.75.75 0 0110 3z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLeftCircleIcon.js
var require_ArrowLeftCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLeftCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowLeftCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("g", {
        clipPath: "url(#clip0_9_2121)"
      }, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zm3.25-7.25a.75.75 0 000-1.5H8.66l2.1-1.95a.75.75 0 10-1.02-1.1l-3.5 3.25a.75.75 0 000 1.1l3.5 3.25a.75.75 0 001.02-1.1l-2.1-1.95h4.59z",
        clipRule: "evenodd"
      })), /* @__PURE__ */ React.createElement("defs", null, /* @__PURE__ */ React.createElement("clipPath", {
        id: "clip0_9_2121"
      }, /* @__PURE__ */ React.createElement("path", {
        d: "M0 0h20v20H0z"
      }))));
    }
    var ForwardRef = React.forwardRef(ArrowLeftCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLeftOnRectangleIcon.js
var require_ArrowLeftOnRectangleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLeftOnRectangleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowLeftOnRectangleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3 4.25A2.25 2.25 0 015.25 2h5.5A2.25 2.25 0 0113 4.25v2a.75.75 0 01-1.5 0v-2a.75.75 0 00-.75-.75h-5.5a.75.75 0 00-.75.75v11.5c0 .414.336.75.75.75h5.5a.75.75 0 00.75-.75v-2a.75.75 0 011.5 0v2A2.25 2.25 0 0110.75 18h-5.5A2.25 2.25 0 013 15.75V4.25z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M19 10a.75.75 0 00-.75-.75H8.704l1.048-.943a.75.75 0 10-1.004-1.114l-2.5 2.25a.75.75 0 000 1.114l2.5 2.25a.75.75 0 101.004-1.114l-1.048-.943h9.546A.75.75 0 0019 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowLeftOnRectangleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLeftIcon.js
var require_ArrowLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M17 10a.75.75 0 01-.75.75H5.612l4.158 3.96a.75.75 0 11-1.04 1.08l-5.5-5.25a.75.75 0 010-1.08l5.5-5.25a.75.75 0 111.04 1.08L5.612 9.25H16.25A.75.75 0 0117 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLongDownIcon.js
var require_ArrowLongDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLongDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowLongDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 2a.75.75 0 01.75.75v12.59l1.95-2.1a.75.75 0 111.1 1.02l-3.25 3.5a.75.75 0 01-1.1 0l-3.25-3.5a.75.75 0 111.1-1.02l1.95 2.1V2.75A.75.75 0 0110 2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowLongDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLongLeftIcon.js
var require_ArrowLongLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLongLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowLongLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M18 10a.75.75 0 01-.75.75H4.66l2.1 1.95a.75.75 0 11-1.02 1.1l-3.5-3.25a.75.75 0 010-1.1l3.5-3.25a.75.75 0 111.02 1.1l-2.1 1.95h12.59A.75.75 0 0118 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowLongLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLongRightIcon.js
var require_ArrowLongRightIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLongRightIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowLongRightIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 10a.75.75 0 01.75-.75h12.59l-2.1-1.95a.75.75 0 111.02-1.1l3.5 3.25a.75.75 0 010 1.1l-3.5 3.25a.75.75 0 11-1.02-1.1l2.1-1.95H2.75A.75.75 0 012 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowLongRightIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLongUpIcon.js
var require_ArrowLongUpIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowLongUpIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowLongUpIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a.75.75 0 01-.75-.75V4.66L7.3 6.76a.75.75 0 11-1.1-1.02l3.25-3.5a.75.75 0 011.1 0l3.25 3.5a.75.75 0 01-1.1 1.02l-1.95-2.1v12.59A.75.75 0 0110 18z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowLongUpIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowPathRoundedSquareIcon.js
var require_ArrowPathRoundedSquareIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowPathRoundedSquareIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowPathRoundedSquareIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 4.5c1.215 0 2.417.055 3.604.162a.68.68 0 01.615.597c.124 1.038.208 2.088.25 3.15l-1.689-1.69a.75.75 0 00-1.06 1.061l2.999 3a.75.75 0 001.06 0l3.001-3a.75.75 0 10-1.06-1.06l-1.748 1.747a41.31 41.31 0 00-.264-3.386 2.18 2.18 0 00-1.97-1.913 41.512 41.512 0 00-7.477 0 2.18 2.18 0 00-1.969 1.913 41.16 41.16 0 00-.16 1.61.75.75 0 101.495.12c.041-.52.093-1.038.154-1.552a.68.68 0 01.615-.597A40.012 40.012 0 0110 4.5zM5.281 9.22a.75.75 0 00-1.06 0l-3.001 3a.75.75 0 101.06 1.06l1.748-1.747c.042 1.141.13 2.27.264 3.386a2.18 2.18 0 001.97 1.913 41.533 41.533 0 007.477 0 2.18 2.18 0 001.969-1.913c.064-.534.117-1.071.16-1.61a.75.75 0 10-1.495-.12c-.041.52-.093 1.037-.154 1.552a.68.68 0 01-.615.597 40.013 40.013 0 01-7.208 0 .68.68 0 01-.615-.597 39.785 39.785 0 01-.25-3.15l1.689 1.69a.75.75 0 001.06-1.061l-2.999-3z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowPathRoundedSquareIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowPathIcon.js
var require_ArrowPathIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowPathIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowPathIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M15.312 11.424a5.5 5.5 0 01-9.201 2.466l-.312-.311h2.433a.75.75 0 000-1.5H3.989a.75.75 0 00-.75.75v4.242a.75.75 0 001.5 0v-2.43l.31.31a7 7 0 0011.712-3.138.75.75 0 00-1.449-.39zm1.23-3.723a.75.75 0 00.219-.53V2.929a.75.75 0 00-1.5 0V5.36l-.31-.31A7 7 0 003.239 8.188a.75.75 0 101.448.389A5.5 5.5 0 0113.89 6.11l.311.31h-2.432a.75.75 0 000 1.5h4.243a.75.75 0 00.53-.219z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowPathIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowRightCircleIcon.js
var require_ArrowRightCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowRightCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowRightCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zM6.75 9.25a.75.75 0 000 1.5h4.59l-2.1 1.95a.75.75 0 001.02 1.1l3.5-3.25a.75.75 0 000-1.1l-3.5-3.25a.75.75 0 10-1.02 1.1l2.1 1.95H6.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowRightCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowRightOnRectangleIcon.js
var require_ArrowRightOnRectangleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowRightOnRectangleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowRightOnRectangleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3 4.25A2.25 2.25 0 015.25 2h5.5A2.25 2.25 0 0113 4.25v2a.75.75 0 01-1.5 0v-2a.75.75 0 00-.75-.75h-5.5a.75.75 0 00-.75.75v11.5c0 .414.336.75.75.75h5.5a.75.75 0 00.75-.75v-2a.75.75 0 011.5 0v2A2.25 2.25 0 0110.75 18h-5.5A2.25 2.25 0 013 15.75V4.25z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M6 10a.75.75 0 01.75-.75h9.546l-1.048-.943a.75.75 0 111.004-1.114l2.5 2.25a.75.75 0 010 1.114l-2.5 2.25a.75.75 0 11-1.004-1.114l1.048-.943H6.75A.75.75 0 016 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowRightOnRectangleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowRightIcon.js
var require_ArrowRightIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowRightIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowRightIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3 10a.75.75 0 01.75-.75h10.638L10.23 5.29a.75.75 0 111.04-1.08l5.5 5.25a.75.75 0 010 1.08l-5.5 5.25a.75.75 0 11-1.04-1.08l4.158-3.96H3.75A.75.75 0 013 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowRightIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowSmallDownIcon.js
var require_ArrowSmallDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowSmallDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowSmallDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 5a.75.75 0 01.75.75v6.638l1.96-2.158a.75.75 0 111.08 1.04l-3.25 3.5a.75.75 0 01-1.08 0l-3.25-3.5a.75.75 0 111.08-1.04l1.96 2.158V5.75A.75.75 0 0110 5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowSmallDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowSmallLeftIcon.js
var require_ArrowSmallLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowSmallLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowSmallLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M15 10a.75.75 0 01-.75.75H7.612l2.158 1.96a.75.75 0 11-1.04 1.08l-3.5-3.25a.75.75 0 010-1.08l3.5-3.25a.75.75 0 111.04 1.08L7.612 9.25h6.638A.75.75 0 0115 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowSmallLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowSmallRightIcon.js
var require_ArrowSmallRightIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowSmallRightIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowSmallRightIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5 10a.75.75 0 01.75-.75h6.638L10.23 7.29a.75.75 0 111.04-1.08l3.5 3.25a.75.75 0 010 1.08l-3.5 3.25a.75.75 0 11-1.04-1.08l2.158-1.96H5.75A.75.75 0 015 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowSmallRightIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowSmallUpIcon.js
var require_ArrowSmallUpIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowSmallUpIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowSmallUpIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 15a.75.75 0 01-.75-.75V7.612L7.29 9.77a.75.75 0 01-1.08-1.04l3.25-3.5a.75.75 0 011.08 0l3.25 3.5a.75.75 0 11-1.08 1.04l-1.96-2.158v6.638A.75.75 0 0110 15z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowSmallUpIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowTopRightOnSquareIcon.js
var require_ArrowTopRightOnSquareIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowTopRightOnSquareIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowTopRightOnSquareIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.25 5.5a.75.75 0 00-.75.75v8.5c0 .414.336.75.75.75h8.5a.75.75 0 00.75-.75v-4a.75.75 0 011.5 0v4A2.25 2.25 0 0112.75 17h-8.5A2.25 2.25 0 012 14.75v-8.5A2.25 2.25 0 014.25 4h5a.75.75 0 010 1.5h-5z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M6.194 12.753a.75.75 0 001.06.053L16.5 4.44v2.81a.75.75 0 001.5 0v-4.5a.75.75 0 00-.75-.75h-4.5a.75.75 0 000 1.5h2.553l-9.056 8.194a.75.75 0 00-.053 1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowTopRightOnSquareIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowTrendingDownIcon.js
var require_ArrowTrendingDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowTrendingDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowTrendingDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1.22 5.222a.75.75 0 011.06 0L7 9.942l3.768-3.769a.75.75 0 011.113.058 20.908 20.908 0 013.813 7.254l1.574-2.727a.75.75 0 011.3.75l-2.475 4.286a.75.75 0 01-1.025.275l-4.287-2.475a.75.75 0 01.75-1.3l2.71 1.565a19.422 19.422 0 00-3.013-6.024L7.53 11.533a.75.75 0 01-1.06 0l-5.25-5.25a.75.75 0 010-1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowTrendingDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowTrendingUpIcon.js
var require_ArrowTrendingUpIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowTrendingUpIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowTrendingUpIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M12.577 4.878a.75.75 0 01.919-.53l4.78 1.281a.75.75 0 01.531.919l-1.281 4.78a.75.75 0 01-1.449-.387l.81-3.022a19.407 19.407 0 00-5.594 5.203.75.75 0 01-1.139.093L7 10.06l-4.72 4.72a.75.75 0 01-1.06-1.061l5.25-5.25a.75.75 0 011.06 0l3.074 3.073a20.923 20.923 0 015.545-4.931l-3.042-.815a.75.75 0 01-.53-.919z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowTrendingUpIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpCircleIcon.js
var require_ArrowUpCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowUpCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zm-.75-4.75a.75.75 0 001.5 0V8.66l1.95 2.1a.75.75 0 101.1-1.02l-3.25-3.5a.75.75 0 00-1.1 0L6.2 9.74a.75.75 0 101.1 1.02l1.95-2.1v4.59z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpLeftIcon.js
var require_ArrowUpLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowUpLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M14.78 14.78a.75.75 0 01-1.06 0L6.5 7.56v5.69a.75.75 0 01-1.5 0v-7.5A.75.75 0 015.75 5h7.5a.75.75 0 010 1.5H7.56l7.22 7.22a.75.75 0 010 1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpOnSquareStackIcon.js
var require_ArrowUpOnSquareStackIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpOnSquareStackIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowUpOnSquareStackIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10.75 6h-2v4.25a.75.75 0 01-1.5 0V6h1.5V3.704l.943 1.048a.75.75 0 001.114-1.004l-2.25-2.5a.75.75 0 00-1.114 0l-2.25 2.5a.75.75 0 001.114 1.004l.943-1.048V6h-2A2.25 2.25 0 003 8.25v4.5A2.25 2.25 0 005.25 15h5.5A2.25 2.25 0 0013 12.75v-4.5A2.25 2.25 0 0010.75 6zM7 16.75v-.25h3.75a3.75 3.75 0 003.75-3.75V10h.25A2.25 2.25 0 0117 12.25v4.5A2.25 2.25 0 0114.75 19h-5.5A2.25 2.25 0 017 16.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpOnSquareStackIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpOnSquareIcon.js
var require_ArrowUpOnSquareIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpOnSquareIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowUpOnSquareIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M13.75 7h-3V3.66l1.95 2.1a.75.75 0 101.1-1.02l-3.25-3.5a.75.75 0 00-1.1 0L6.2 4.74a.75.75 0 001.1 1.02l1.95-2.1V7h-3A2.25 2.25 0 004 9.25v7.5A2.25 2.25 0 006.25 19h7.5A2.25 2.25 0 0016 16.75v-7.5A2.25 2.25 0 0013.75 7zm-3 0h-1.5v5.25a.75.75 0 001.5 0V7z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpOnSquareIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpRightIcon.js
var require_ArrowUpRightIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpRightIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowUpRightIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5.22 14.78a.75.75 0 001.06 0l7.22-7.22v5.69a.75.75 0 001.5 0v-7.5a.75.75 0 00-.75-.75h-7.5a.75.75 0 000 1.5h5.69l-7.22 7.22a.75.75 0 000 1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpRightIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpTrayIcon.js
var require_ArrowUpTrayIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpTrayIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowUpTrayIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M9.25 13.25a.75.75 0 001.5 0V4.636l2.955 3.129a.75.75 0 001.09-1.03l-4.25-4.5a.75.75 0 00-1.09 0l-4.25 4.5a.75.75 0 101.09 1.03L9.25 4.636v8.614z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M3.5 12.75a.75.75 0 00-1.5 0v2.5A2.75 2.75 0 004.75 18h10.5A2.75 2.75 0 0018 15.25v-2.5a.75.75 0 00-1.5 0v2.5c0 .69-.56 1.25-1.25 1.25H4.75c-.69 0-1.25-.56-1.25-1.25v-2.5z"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpTrayIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpIcon.js
var require_ArrowUpIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUpIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowUpIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 17a.75.75 0 01-.75-.75V5.612L5.29 9.77a.75.75 0 01-1.08-1.04l5.25-5.5a.75.75 0 011.08 0l5.25 5.5a.75.75 0 11-1.08 1.04l-3.96-4.158V16.25A.75.75 0 0110 17z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUturnDownIcon.js
var require_ArrowUturnDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUturnDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowUturnDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2.232 12.207a.75.75 0 011.06.025l3.958 4.146V6.375a5.375 5.375 0 0110.75 0V9.25a.75.75 0 01-1.5 0V6.375a3.875 3.875 0 00-7.75 0v10.003l3.957-4.146a.75.75 0 011.085 1.036l-5.25 5.5a.75.75 0 01-1.085 0l-5.25-5.5a.75.75 0 01.025-1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUturnDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUturnLeftIcon.js
var require_ArrowUturnLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUturnLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowUturnLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M7.793 2.232a.75.75 0 01-.025 1.06L3.622 7.25h10.003a5.375 5.375 0 010 10.75H10.75a.75.75 0 010-1.5h2.875a3.875 3.875 0 000-7.75H3.622l4.146 3.957a.75.75 0 01-1.036 1.085l-5.5-5.25a.75.75 0 010-1.085l5.5-5.25a.75.75 0 011.06.025z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUturnLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUturnRightIcon.js
var require_ArrowUturnRightIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUturnRightIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowUturnRightIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M12.207 2.232a.75.75 0 00.025 1.06l4.146 3.958H6.375a5.375 5.375 0 000 10.75H9.25a.75.75 0 000-1.5H6.375a3.875 3.875 0 010-7.75h10.003l-4.146 3.957a.75.75 0 001.036 1.085l5.5-5.25a.75.75 0 000-1.085l-5.5-5.25a.75.75 0 00-1.06.025z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUturnRightIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUturnUpIcon.js
var require_ArrowUturnUpIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowUturnUpIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowUturnUpIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M17.768 7.793a.75.75 0 01-1.06-.025L12.75 3.622v10.003a5.375 5.375 0 01-10.75 0V10.75a.75.75 0 011.5 0v2.875a3.875 3.875 0 007.75 0V3.622L7.293 7.768a.75.75 0 01-1.086-1.036l5.25-5.5a.75.75 0 011.085 0l5.25 5.5a.75.75 0 01-.024 1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUturnUpIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowsPointingInIcon.js
var require_ArrowsPointingInIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowsPointingInIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowsPointingInIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3.28 2.22a.75.75 0 00-1.06 1.06L5.44 6.5H2.75a.75.75 0 000 1.5h4.5A.75.75 0 008 7.25v-4.5a.75.75 0 00-1.5 0v2.69L3.28 2.22zM13.5 2.75a.75.75 0 00-1.5 0v4.5c0 .414.336.75.75.75h4.5a.75.75 0 000-1.5h-2.69l3.22-3.22a.75.75 0 00-1.06-1.06L13.5 5.44V2.75zM3.28 17.78l3.22-3.22v2.69a.75.75 0 001.5 0v-4.5a.75.75 0 00-.75-.75h-4.5a.75.75 0 000 1.5h2.69l-3.22 3.22a.75.75 0 101.06 1.06zM13.5 14.56l3.22 3.22a.75.75 0 101.06-1.06l-3.22-3.22h2.69a.75.75 0 000-1.5h-4.5a.75.75 0 00-.75.75v4.5a.75.75 0 001.5 0v-2.69z"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowsPointingInIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowsPointingOutIcon.js
var require_ArrowsPointingOutIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowsPointingOutIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowsPointingOutIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M13.28 7.78l3.22-3.22v2.69a.75.75 0 001.5 0v-4.5a.75.75 0 00-.75-.75h-4.5a.75.75 0 000 1.5h2.69l-3.22 3.22a.75.75 0 001.06 1.06zM2 17.25v-4.5a.75.75 0 011.5 0v2.69l3.22-3.22a.75.75 0 011.06 1.06L4.56 16.5h2.69a.75.75 0 010 1.5h-4.5a.747.747 0 01-.75-.75zM12.22 13.28l3.22 3.22h-2.69a.75.75 0 000 1.5h4.5a.747.747 0 00.75-.75v-4.5a.75.75 0 00-1.5 0v2.69l-3.22-3.22a.75.75 0 10-1.06 1.06zM3.5 4.56l3.22 3.22a.75.75 0 001.06-1.06L4.56 3.5h2.69a.75.75 0 000-1.5h-4.5a.75.75 0 00-.75.75v4.5a.75.75 0 001.5 0V4.56z"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowsPointingOutIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowsRightLeftIcon.js
var require_ArrowsRightLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowsRightLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowsRightLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M13.2 2.24a.75.75 0 00.04 1.06l2.1 1.95H6.75a.75.75 0 000 1.5h8.59l-2.1 1.95a.75.75 0 101.02 1.1l3.5-3.25a.75.75 0 000-1.1l-3.5-3.25a.75.75 0 00-1.06.04zm-6.4 8a.75.75 0 00-1.06-.04l-3.5 3.25a.75.75 0 000 1.1l3.5 3.25a.75.75 0 101.02-1.1l-2.1-1.95h8.59a.75.75 0 000-1.5H4.66l2.1-1.95a.75.75 0 00.04-1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowsRightLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowsUpDownIcon.js
var require_ArrowsUpDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ArrowsUpDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ArrowsUpDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2.24 6.8a.75.75 0 001.06-.04l1.95-2.1v8.59a.75.75 0 001.5 0V4.66l1.95 2.1a.75.75 0 101.1-1.02l-3.25-3.5a.75.75 0 00-1.1 0L2.2 5.74a.75.75 0 00.04 1.06zm8 6.4a.75.75 0 00-.04 1.06l3.25 3.5a.75.75 0 001.1 0l3.25-3.5a.75.75 0 10-1.1-1.02l-1.95 2.1V6.75a.75.75 0 00-1.5 0v8.59l-1.95-2.1a.75.75 0 00-1.06-.04z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowsUpDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/AtSymbolIcon.js
var require_AtSymbolIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/AtSymbolIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function AtSymbolIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5.404 14.596A6.5 6.5 0 1116.5 10a1.25 1.25 0 01-2.5 0 4 4 0 10-.571 2.06A2.75 2.75 0 0018 10a8 8 0 10-2.343 5.657.75.75 0 00-1.06-1.06 6.5 6.5 0 01-9.193 0zM10 7.5a2.5 2.5 0 100 5 2.5 2.5 0 000-5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(AtSymbolIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BackspaceIcon.js
var require_BackspaceIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BackspaceIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BackspaceIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M7.22 3.22A.75.75 0 017.75 3h9A2.25 2.25 0 0119 5.25v9.5A2.25 2.25 0 0116.75 17h-9a.75.75 0 01-.53-.22L.97 10.53a.75.75 0 010-1.06l6.25-6.25zm3.06 4a.75.75 0 10-1.06 1.06L10.94 10l-1.72 1.72a.75.75 0 101.06 1.06L12 11.06l1.72 1.72a.75.75 0 101.06-1.06L13.06 10l1.72-1.72a.75.75 0 00-1.06-1.06L12 8.94l-1.72-1.72z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BackspaceIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BackwardIcon.js
var require_BackwardIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BackwardIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BackwardIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M7.712 4.819A1.5 1.5 0 0110 6.095v2.973c.104-.131.234-.248.389-.344l6.323-3.905A1.5 1.5 0 0119 6.095v7.81a1.5 1.5 0 01-2.288 1.277l-6.323-3.905a1.505 1.505 0 01-.389-.344v2.973a1.5 1.5 0 01-2.288 1.276l-6.323-3.905a1.5 1.5 0 010-2.553L7.712 4.82z"
      }));
    }
    var ForwardRef = React.forwardRef(BackwardIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BanknotesIcon.js
var require_BanknotesIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BanknotesIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BanknotesIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1 4a1 1 0 011-1h16a1 1 0 011 1v8a1 1 0 01-1 1H2a1 1 0 01-1-1V4zm12 4a3 3 0 11-6 0 3 3 0 016 0zM4 9a1 1 0 100-2 1 1 0 000 2zm13-1a1 1 0 11-2 0 1 1 0 012 0zM1.75 14.5a.75.75 0 000 1.5c4.417 0 8.693.603 12.749 1.73 1.111.309 2.251-.512 2.251-1.696v-.784a.75.75 0 00-1.5 0v.784a.272.272 0 01-.35.25A49.043 49.043 0 001.75 14.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BanknotesIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Bars2Icon.js
var require_Bars2Icon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Bars2Icon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Bars2Icon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 6.75A.75.75 0 012.75 6h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 6.75zm0 6.5a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75a.75.75 0 01-.75-.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(Bars2Icon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Bars3BottomLeftIcon.js
var require_Bars3BottomLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Bars3BottomLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Bars3BottomLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 4.75A.75.75 0 012.75 4h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 4.75zm0 10.5a.75.75 0 01.75-.75h7.5a.75.75 0 010 1.5h-7.5a.75.75 0 01-.75-.75zM2 10a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(Bars3BottomLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Bars3BottomRightIcon.js
var require_Bars3BottomRightIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Bars3BottomRightIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Bars3BottomRightIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 4.75A.75.75 0 012.75 4h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 4.75zm7 10.5a.75.75 0 01.75-.75h7.5a.75.75 0 010 1.5h-7.5a.75.75 0 01-.75-.75zM2 10a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(Bars3BottomRightIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Bars3CenterLeftIcon.js
var require_Bars3CenterLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Bars3CenterLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Bars3CenterLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 4.75A.75.75 0 012.75 4h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 4.75zm0 10.5a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75a.75.75 0 01-.75-.75zM2 10a.75.75 0 01.75-.75h7.5a.75.75 0 010 1.5h-7.5A.75.75 0 012 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(Bars3CenterLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Bars3Icon.js
var require_Bars3Icon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Bars3Icon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Bars3Icon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 4.75A.75.75 0 012.75 4h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 4.75zM2 10a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 10zm0 5.25a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75a.75.75 0 01-.75-.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(Bars3Icon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Bars4Icon.js
var require_Bars4Icon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Bars4Icon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Bars4Icon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 3.75A.75.75 0 012.75 3h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 3.75zm0 4.167a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75a.75.75 0 01-.75-.75zm0 4.166a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75a.75.75 0 01-.75-.75zm0 4.167a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75a.75.75 0 01-.75-.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(Bars4Icon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BarsArrowDownIcon.js
var require_BarsArrowDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BarsArrowDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BarsArrowDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 3.75A.75.75 0 012.75 3h11.5a.75.75 0 010 1.5H2.75A.75.75 0 012 3.75zM2 7.5a.75.75 0 01.75-.75h7.508a.75.75 0 010 1.5H2.75A.75.75 0 012 7.5zM14 7a.75.75 0 01.75.75v6.59l1.95-2.1a.75.75 0 111.1 1.02l-3.25 3.5a.75.75 0 01-1.1 0l-3.25-3.5a.75.75 0 111.1-1.02l1.95 2.1V7.75A.75.75 0 0114 7zM2 11.25a.75.75 0 01.75-.75h4.562a.75.75 0 010 1.5H2.75a.75.75 0 01-.75-.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BarsArrowDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BarsArrowUpIcon.js
var require_BarsArrowUpIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BarsArrowUpIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BarsArrowUpIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 3.75A.75.75 0 012.75 3h11.5a.75.75 0 010 1.5H2.75A.75.75 0 012 3.75zM2 7.5a.75.75 0 01.75-.75h6.365a.75.75 0 010 1.5H2.75A.75.75 0 012 7.5zM14 7a.75.75 0 01.55.24l3.25 3.5a.75.75 0 11-1.1 1.02l-1.95-2.1v6.59a.75.75 0 01-1.5 0V9.66l-1.95 2.1a.75.75 0 11-1.1-1.02l3.25-3.5A.75.75 0 0114 7zM2 11.25a.75.75 0 01.75-.75H7A.75.75 0 017 12H2.75a.75.75 0 01-.75-.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BarsArrowUpIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Battery0Icon.js
var require_Battery0Icon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Battery0Icon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Battery0Icon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1 7.25A2.25 2.25 0 013.25 5h12.5A2.25 2.25 0 0118 7.25v1.085a1.5 1.5 0 011 1.415v.5a1.5 1.5 0 01-1 1.415v1.085A2.25 2.25 0 0115.75 15H3.25A2.25 2.25 0 011 12.75v-5.5zm2.25-.75a.75.75 0 00-.75.75v5.5c0 .414.336.75.75.75h12.5a.75.75 0 00.75-.75v-5.5a.75.75 0 00-.75-.75H3.25z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(Battery0Icon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Battery100Icon.js
var require_Battery100Icon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Battery100Icon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Battery100Icon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M4.75 8a.75.75 0 00-.75.75v2.5c0 .414.336.75.75.75h9.5a.75.75 0 00.75-.75v-2.5a.75.75 0 00-.75-.75h-9.5z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1 7.25A2.25 2.25 0 013.25 5h12.5A2.25 2.25 0 0118 7.25v1.085a1.5 1.5 0 011 1.415v.5a1.5 1.5 0 01-1 1.415v1.085A2.25 2.25 0 0115.75 15H3.25A2.25 2.25 0 011 12.75v-5.5zm2.25-.75a.75.75 0 00-.75.75v5.5c0 .414.336.75.75.75h12.5a.75.75 0 00.75-.75v-5.5a.75.75 0 00-.75-.75H3.25z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(Battery100Icon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Battery50Icon.js
var require_Battery50Icon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Battery50Icon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Battery50Icon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M4.75 8a.75.75 0 00-.75.75v2.5c0 .414.336.75.75.75H9.5a.75.75 0 00.75-.75v-2.5A.75.75 0 009.5 8H4.75z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3.25 5A2.25 2.25 0 001 7.25v5.5A2.25 2.25 0 003.25 15h12.5A2.25 2.25 0 0018 12.75v-1.085a1.5 1.5 0 001-1.415v-.5a1.5 1.5 0 00-1-1.415V7.25A2.25 2.25 0 0015.75 5H3.25zM2.5 7.25a.75.75 0 01.75-.75h12.5a.75.75 0 01.75.75v5.5a.75.75 0 01-.75.75H3.25a.75.75 0 01-.75-.75v-5.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(Battery50Icon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BeakerIcon.js
var require_BeakerIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BeakerIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BeakerIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M8.5 3.528v4.644c0 .729-.29 1.428-.805 1.944l-1.217 1.216a8.75 8.75 0 013.55.621l.502.201a7.25 7.25 0 004.178.365l-2.403-2.403a2.75 2.75 0 01-.805-1.944V3.528a40.205 40.205 0 00-3 0zm4.5.084l.19.015a.75.75 0 10.12-1.495 41.364 41.364 0 00-6.62 0 .75.75 0 00.12 1.495L7 3.612v4.56c0 .331-.132.649-.366.883L2.6 13.09c-1.496 1.496-.817 4.15 1.403 4.475C5.961 17.852 7.963 18 10 18s4.039-.148 5.997-.436c2.22-.325 2.9-2.979 1.403-4.475l-4.034-4.034A1.25 1.25 0 0113 8.172v-4.56z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BeakerIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BellAlertIcon.js
var require_BellAlertIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BellAlertIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BellAlertIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M4.214 3.227a.75.75 0 00-1.156-.956 8.97 8.97 0 00-1.856 3.826.75.75 0 001.466.316 7.47 7.47 0 011.546-3.186zM16.942 2.271a.75.75 0 00-1.157.956 7.47 7.47 0 011.547 3.186.75.75 0 001.466-.316 8.971 8.971 0 00-1.856-3.826z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 2a6 6 0 00-6 6c0 1.887-.454 3.665-1.257 5.234a.75.75 0 00.515 1.076 32.94 32.94 0 003.256.508 3.5 3.5 0 006.972 0 32.933 32.933 0 003.256-.508.75.75 0 00.515-1.076A11.448 11.448 0 0116 8a6 6 0 00-6-6zm0 14.5a2 2 0 01-1.95-1.557 33.54 33.54 0 003.9 0A2 2 0 0110 16.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BellAlertIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BellSlashIcon.js
var require_BellSlashIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BellSlashIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BellSlashIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M4 8c0-.26.017-.517.049-.77l7.722 7.723a33.56 33.56 0 01-3.722-.01 2 2 0 003.862.15l1.134 1.134a3.5 3.5 0 01-6.53-1.409 32.91 32.91 0 01-3.257-.508.75.75 0 01-.515-1.076A11.448 11.448 0 004 8zM17.266 13.9a.756.756 0 01-.068.116L6.389 3.207A6 6 0 0116 8c.001 1.887.455 3.665 1.258 5.234a.75.75 0 01.01.666zM3.28 2.22a.75.75 0 00-1.06 1.06l14.5 14.5a.75.75 0 101.06-1.06L3.28 2.22z"
      }));
    }
    var ForwardRef = React.forwardRef(BellSlashIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BellSnoozeIcon.js
var require_BellSnoozeIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BellSnoozeIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BellSnoozeIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4 8a6 6 0 1112 0c0 1.887.454 3.665 1.257 5.234a.75.75 0 01-.515 1.076 32.903 32.903 0 01-3.256.508 3.5 3.5 0 01-6.972 0 32.91 32.91 0 01-3.256-.508.75.75 0 01-.515-1.076A11.448 11.448 0 004 8zm6 7c-.655 0-1.305-.02-1.95-.057a2 2 0 003.9 0c-.645.038-1.295.057-1.95.057zM8.75 6a.75.75 0 000 1.5h1.043L8.14 9.814A.75.75 0 008.75 11h2.5a.75.75 0 000-1.5h-1.043l1.653-2.314A.75.75 0 0011.25 6h-2.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BellSnoozeIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BellIcon.js
var require_BellIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BellIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BellIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 2a6 6 0 00-6 6c0 1.887-.454 3.665-1.257 5.234a.75.75 0 00.515 1.076 32.91 32.91 0 003.256.508 3.5 3.5 0 006.972 0 32.903 32.903 0 003.256-.508.75.75 0 00.515-1.076A11.448 11.448 0 0116 8a6 6 0 00-6-6zM8.05 14.943a33.54 33.54 0 003.9 0 2 2 0 01-3.9 0z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BellIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BoltSlashIcon.js
var require_BoltSlashIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BoltSlashIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BoltSlashIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2.22 2.22a.75.75 0 011.06 0l14.5 14.5a.75.75 0 11-1.06 1.06L2.22 3.28a.75.75 0 010-1.06z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M4.73 7.912L2.191 10.75A.75.75 0 002.75 12h6.068L4.73 7.912zM9.233 12.415l-1.216 5.678a.75.75 0 001.292.657l2.956-3.303-3.032-3.032zM15.27 12.088l2.539-2.838A.75.75 0 0017.25 8h-6.068l4.088 4.088zM10.767 7.585l1.216-5.678a.75.75 0 00-1.292-.657L7.735 4.553l3.032 3.032z"
      }));
    }
    var ForwardRef = React.forwardRef(BoltSlashIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BoltIcon.js
var require_BoltIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BoltIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BoltIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M11.983 1.907a.75.75 0 00-1.292-.657l-8.5 9.5A.75.75 0 002.75 12h6.572l-1.305 6.093a.75.75 0 001.292.657l8.5-9.5A.75.75 0 0017.25 8h-6.572l1.305-6.093z"
      }));
    }
    var ForwardRef = React.forwardRef(BoltIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BookOpenIcon.js
var require_BookOpenIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BookOpenIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BookOpenIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10.75 16.82A7.462 7.462 0 0115 15.5c.71 0 1.396.098 2.046.282A.75.75 0 0018 15.06v-11a.75.75 0 00-.546-.721A9.006 9.006 0 0015 3a8.963 8.963 0 00-4.25 1.065V16.82zM9.25 4.065A8.963 8.963 0 005 3c-.85 0-1.673.118-2.454.339A.75.75 0 002 4.06v11a.75.75 0 00.954.721A7.506 7.506 0 015 15.5c1.579 0 3.042.487 4.25 1.32V4.065z"
      }));
    }
    var ForwardRef = React.forwardRef(BookOpenIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BookmarkSlashIcon.js
var require_BookmarkSlashIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BookmarkSlashIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BookmarkSlashIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M17 4.517v9.301L5.433 2.252a41.44 41.44 0 019.637.058C16.194 2.45 17 3.414 17 4.517zM3 17.25V6.182l10.654 10.654L10 15.082l-5.925 2.844A.75.75 0 013 17.25zM3.28 2.22a.75.75 0 00-1.06 1.06l14.5 14.5a.75.75 0 101.06-1.06L3.28 2.22z"
      }));
    }
    var ForwardRef = React.forwardRef(BookmarkSlashIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BookmarkSquareIcon.js
var require_BookmarkSquareIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BookmarkSquareIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BookmarkSquareIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.25 2A2.25 2.25 0 002 4.25v11.5A2.25 2.25 0 004.25 18h11.5A2.25 2.25 0 0018 15.75V4.25A2.25 2.25 0 0015.75 2H4.25zM6 13.25V3.5h8v9.75a.75.75 0 01-1.064.681L10 12.576l-2.936 1.355A.75.75 0 016 13.25z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BookmarkSquareIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BookmarkIcon.js
var require_BookmarkIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BookmarkIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BookmarkIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 2c-1.716 0-3.408.106-5.07.31C3.806 2.45 3 3.414 3 4.517V17.25a.75.75 0 001.075.676L10 15.082l5.925 2.844A.75.75 0 0017 17.25V4.517c0-1.103-.806-2.068-1.93-2.207A41.403 41.403 0 0010 2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BookmarkIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BriefcaseIcon.js
var require_BriefcaseIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BriefcaseIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BriefcaseIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M6 3.75A2.75 2.75 0 018.75 1h2.5A2.75 2.75 0 0114 3.75v.443c.572.055 1.14.122 1.706.2C17.053 4.582 18 5.75 18 7.07v3.469c0 1.126-.694 2.191-1.83 2.54-1.952.599-4.024.921-6.17.921s-4.219-.322-6.17-.921C2.694 12.73 2 11.665 2 10.539V7.07c0-1.321.947-2.489 2.294-2.676A41.047 41.047 0 016 4.193V3.75zm6.5 0v.325a41.622 41.622 0 00-5 0V3.75c0-.69.56-1.25 1.25-1.25h2.5c.69 0 1.25.56 1.25 1.25zM10 10a1 1 0 00-1 1v.01a1 1 0 001 1h.01a1 1 0 001-1V11a1 1 0 00-1-1H10z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M3 15.055v-.684c.126.053.255.1.39.142 2.092.642 4.313.987 6.61.987 2.297 0 4.518-.345 6.61-.987.135-.041.264-.089.39-.142v.684c0 1.347-.985 2.53-2.363 2.686a41.454 41.454 0 01-9.274 0C3.985 17.585 3 16.402 3 15.055z"
      }));
    }
    var ForwardRef = React.forwardRef(BriefcaseIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BugAntIcon.js
var require_BugAntIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BugAntIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BugAntIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M6.56 1.14a.75.75 0 01.177 1.045 3.989 3.989 0 00-.464.86c.185.17.382.329.59.473A3.993 3.993 0 0110 2c1.272 0 2.405.594 3.137 1.518.208-.144.405-.302.59-.473a3.989 3.989 0 00-.464-.86.75.75 0 011.222-.869c.369.519.65 1.105.822 1.736a.75.75 0 01-.174.707 7.03 7.03 0 01-1.299 1.098A4 4 0 0114 6c0 .52-.301.963-.723 1.187a6.961 6.961 0 01-1.158.486c.13.208.231.436.296.679 1.413-.174 2.779-.5 4.081-.96a19.655 19.655 0 00-.09-2.319.75.75 0 111.493-.146 21.239 21.239 0 01.08 3.028.75.75 0 01-.482.667 20.874 20.874 0 01-5.153 1.249 2.51 2.51 0 01-.107.247 20.86 20.86 0 015.253 1.257.75.75 0 01.48.74 20.946 20.946 0 01-.907 5.107.75.75 0 01-1.433-.444c.415-1.34.69-2.743.806-4.19-.495-.174-1-.328-1.512-.461.05.284.076.575.076.873 0 1.814-.517 3.312-1.426 4.37A4.639 4.639 0 0110 19a4.64 4.64 0 01-3.574-1.63C5.516 16.311 5 14.813 5 13c0-.298.026-.59.076-.873-.513.133-1.017.287-1.512.46.116 1.448.39 2.85.806 4.191a.75.75 0 01-1.433.444 20.94 20.94 0 01-.908-5.107.75.75 0 01.482-.74 20.857 20.857 0 015.252-1.257 2.481 2.481 0 01-.107-.247 20.874 20.874 0 01-5.153-1.249.75.75 0 01-.482-.667 21.342 21.342 0 01.08-3.028.75.75 0 111.493.146 19.745 19.745 0 00-.09 2.32c1.302.459 2.668.785 4.08.959.066-.243.166-.471.297-.679a6.962 6.962 0 01-1.158-.486A1.348 1.348 0 016 6a4 4 0 01.166-1.143 7.032 7.032 0 01-1.3-1.098.75.75 0 01-.173-.707 5.48 5.48 0 01.822-1.736.75.75 0 011.046-.176z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BugAntIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BuildingLibraryIcon.js
var require_BuildingLibraryIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BuildingLibraryIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BuildingLibraryIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M9.674 2.075a.75.75 0 01.652 0l7.25 3.5A.75.75 0 0117 6.957V16.5h.25a.75.75 0 010 1.5H2.75a.75.75 0 010-1.5H3V6.957a.75.75 0 01-.576-1.382l7.25-3.5zM11 6a1 1 0 11-2 0 1 1 0 012 0zM7.5 9.75a.75.75 0 00-1.5 0v5.5a.75.75 0 001.5 0v-5.5zm3.25 0a.75.75 0 00-1.5 0v5.5a.75.75 0 001.5 0v-5.5zm3.25 0a.75.75 0 00-1.5 0v5.5a.75.75 0 001.5 0v-5.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BuildingLibraryIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BuildingOffice2Icon.js
var require_BuildingOffice2Icon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BuildingOffice2Icon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BuildingOffice2Icon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1 2.75A.75.75 0 011.75 2h10.5a.75.75 0 010 1.5H12v13.75a.75.75 0 01-.75.75h-1.5a.75.75 0 01-.75-.75v-2.5a.75.75 0 00-.75-.75h-2.5a.75.75 0 00-.75.75v2.5a.75.75 0 01-.75.75h-2.5a.75.75 0 010-1.5H2v-13h-.25A.75.75 0 011 2.75zM4 5.5a.5.5 0 01.5-.5h1a.5.5 0 01.5.5v1a.5.5 0 01-.5.5h-1a.5.5 0 01-.5-.5v-1zM4.5 9a.5.5 0 00-.5.5v1a.5.5 0 00.5.5h1a.5.5 0 00.5-.5v-1a.5.5 0 00-.5-.5h-1zM8 5.5a.5.5 0 01.5-.5h1a.5.5 0 01.5.5v1a.5.5 0 01-.5.5h-1a.5.5 0 01-.5-.5v-1zM8.5 9a.5.5 0 00-.5.5v1a.5.5 0 00.5.5h1a.5.5 0 00.5-.5v-1a.5.5 0 00-.5-.5h-1zM14.25 6a.75.75 0 00-.75.75V17a1 1 0 001 1h3.75a.75.75 0 000-1.5H18v-9h.25a.75.75 0 000-1.5h-4zm.5 3.5a.5.5 0 01.5-.5h1a.5.5 0 01.5.5v1a.5.5 0 01-.5.5h-1a.5.5 0 01-.5-.5v-1zm.5 3.5a.5.5 0 00-.5.5v1a.5.5 0 00.5.5h1a.5.5 0 00.5-.5v-1a.5.5 0 00-.5-.5h-1z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BuildingOffice2Icon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BuildingOfficeIcon.js
var require_BuildingOfficeIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BuildingOfficeIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BuildingOfficeIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4 16.5v-13h-.25a.75.75 0 010-1.5h12.5a.75.75 0 010 1.5H16v13h.25a.75.75 0 010 1.5h-3.5a.75.75 0 01-.75-.75v-2.5a.75.75 0 00-.75-.75h-2.5a.75.75 0 00-.75.75v2.5a.75.75 0 01-.75.75h-3.5a.75.75 0 010-1.5H4zm3-11a.5.5 0 01.5-.5h1a.5.5 0 01.5.5v1a.5.5 0 01-.5.5h-1a.5.5 0 01-.5-.5v-1zM7.5 9a.5.5 0 00-.5.5v1a.5.5 0 00.5.5h1a.5.5 0 00.5-.5v-1a.5.5 0 00-.5-.5h-1zM11 5.5a.5.5 0 01.5-.5h1a.5.5 0 01.5.5v1a.5.5 0 01-.5.5h-1a.5.5 0 01-.5-.5v-1zm.5 3.5a.5.5 0 00-.5.5v1a.5.5 0 00.5.5h1a.5.5 0 00.5-.5v-1a.5.5 0 00-.5-.5h-1z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(BuildingOfficeIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BuildingStorefrontIcon.js
var require_BuildingStorefrontIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/BuildingStorefrontIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function BuildingStorefrontIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M2.879 7.121A3 3 0 007.5 6.66a2.997 2.997 0 002.5 1.34 2.997 2.997 0 002.5-1.34 3 3 0 104.622-3.78l-.293-.293A2 2 0 0015.415 2H4.585a2 2 0 00-1.414.586l-.292.292a3 3 0 000 4.243zM3 9.032a4.507 4.507 0 004.5-.29A4.48 4.48 0 0010 9.5a4.48 4.48 0 002.5-.758 4.507 4.507 0 004.5.29V16.5h.25a.75.75 0 010 1.5h-4.5a.75.75 0 01-.75-.75v-3.5a.75.75 0 00-.75-.75h-2.5a.75.75 0 00-.75.75v3.5a.75.75 0 01-.75.75h-4.5a.75.75 0 010-1.5H3V9.032z"
      }));
    }
    var ForwardRef = React.forwardRef(BuildingStorefrontIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CakeIcon.js
var require_CakeIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CakeIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CakeIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M6.75.98l-.884.883a1.25 1.25 0 101.768 0L6.75.98zM13.25.98l-.884.883a1.25 1.25 0 101.768 0L13.25.98zM10 .98l.884.883a1.25 1.25 0 11-1.768 0L10 .98zM7.5 5.75a.75.75 0 00-1.5 0v.464c-1.179.305-2 1.39-2 2.622v.094c.1-.02.202-.038.306-.051A42.869 42.869 0 0110 8.5c1.93 0 3.83.129 5.694.379.104.013.206.03.306.051v-.094c0-1.232-.821-2.317-2-2.622V5.75a.75.75 0 00-1.5 0v.318a45.645 45.645 0 00-1.75-.062V5.75a.75.75 0 00-1.5 0v.256c-.586.01-1.17.03-1.75.062V5.75zM4.505 10.365A41.377 41.377 0 0110 10c1.863 0 3.697.124 5.495.365C16.967 10.562 18 11.838 18 13.28v.693a3.72 3.72 0 01-1.665-.393 5.222 5.222 0 00-4.67 0 3.722 3.722 0 01-3.33 0 5.222 5.222 0 00-4.67 0A3.72 3.72 0 012 13.972v-.693c0-1.441 1.033-2.716 2.505-2.914zM15.665 14.921a5.22 5.22 0 002.335.551V16.5a1.5 1.5 0 01-1.5 1.5h-13A1.5 1.5 0 012 16.5v-1.028c.8 0 1.6-.183 2.335-.551a3.722 3.722 0 013.33 0c1.47.735 3.2.735 4.67 0a3.722 3.722 0 013.33 0z"
      }));
    }
    var ForwardRef = React.forwardRef(CakeIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CalculatorIcon.js
var require_CalculatorIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CalculatorIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CalculatorIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 1c-1.716 0-3.408.106-5.07.31C3.806 1.45 3 2.414 3 3.517V16.75A2.25 2.25 0 005.25 19h9.5A2.25 2.25 0 0017 16.75V3.517c0-1.103-.806-2.068-1.93-2.207A41.403 41.403 0 0010 1zM5.99 8.75A.75.75 0 016.74 8h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75v-.01zm.75 1.417a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75v-.01a.75.75 0 00-.75-.75h-.01zm-.75 2.916a.75.75 0 01.75-.75h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75v-.01zm.75 1.417a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75v-.01a.75.75 0 00-.75-.75h-.01zm1.417-5.75a.75.75 0 01.75-.75h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75v-.01zm.75 1.417a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75v-.01a.75.75 0 00-.75-.75h-.01zm-.75 2.916a.75.75 0 01.75-.75h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75v-.01zm.75 1.417a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75v-.01a.75.75 0 00-.75-.75h-.01zm1.42-5.75a.75.75 0 01.75-.75h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75v-.01zm.75 1.417a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75v-.01a.75.75 0 00-.75-.75h-.01zm-.75 2.916a.75.75 0 01.75-.75h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75v-.01zm.75 1.417a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75v-.01a.75.75 0 00-.75-.75h-.01zM12.5 8.75a.75.75 0 01.75-.75h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75v-.01zm.75 1.417a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75v-.01a.75.75 0 00-.75-.75h-.01zm0 2.166a.75.75 0 01.75.75v2.167a.75.75 0 11-1.5 0v-2.167a.75.75 0 01.75-.75zM6.75 4a.75.75 0 00-.75.75v.5c0 .414.336.75.75.75h6.5a.75.75 0 00.75-.75v-.5a.75.75 0 00-.75-.75h-6.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CalculatorIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CalendarDaysIcon.js
var require_CalendarDaysIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CalendarDaysIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CalendarDaysIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M5.25 12a.75.75 0 01.75-.75h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75H6a.75.75 0 01-.75-.75V12zM6 13.25a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75V14a.75.75 0 00-.75-.75H6zM7.25 12a.75.75 0 01.75-.75h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75H8a.75.75 0 01-.75-.75V12zM8 13.25a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75V14a.75.75 0 00-.75-.75H8zM9.25 10a.75.75 0 01.75-.75h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75H10a.75.75 0 01-.75-.75V10zM10 11.25a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75V12a.75.75 0 00-.75-.75H10zM9.25 14a.75.75 0 01.75-.75h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75H10a.75.75 0 01-.75-.75V14zM12 9.25a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75V10a.75.75 0 00-.75-.75H12zM11.25 12a.75.75 0 01.75-.75h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75H12a.75.75 0 01-.75-.75V12zM12 13.25a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75V14a.75.75 0 00-.75-.75H12zM13.25 10a.75.75 0 01.75-.75h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75H14a.75.75 0 01-.75-.75V10zM14 11.25a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75V12a.75.75 0 00-.75-.75H14z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5.75 2a.75.75 0 01.75.75V4h7V2.75a.75.75 0 011.5 0V4h.25A2.75 2.75 0 0118 6.75v8.5A2.75 2.75 0 0115.25 18H4.75A2.75 2.75 0 012 15.25v-8.5A2.75 2.75 0 014.75 4H5V2.75A.75.75 0 015.75 2zm-1 5.5c-.69 0-1.25.56-1.25 1.25v6.5c0 .69.56 1.25 1.25 1.25h10.5c.69 0 1.25-.56 1.25-1.25v-6.5c0-.69-.56-1.25-1.25-1.25H4.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CalendarDaysIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CalendarIcon.js
var require_CalendarIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CalendarIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CalendarIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5.75 2a.75.75 0 01.75.75V4h7V2.75a.75.75 0 011.5 0V4h.25A2.75 2.75 0 0118 6.75v8.5A2.75 2.75 0 0115.25 18H4.75A2.75 2.75 0 012 15.25v-8.5A2.75 2.75 0 014.75 4H5V2.75A.75.75 0 015.75 2zm-1 5.5c-.69 0-1.25.56-1.25 1.25v6.5c0 .69.56 1.25 1.25 1.25h10.5c.69 0 1.25-.56 1.25-1.25v-6.5c0-.69-.56-1.25-1.25-1.25H4.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CalendarIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CameraIcon.js
var require_CameraIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CameraIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CameraIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1 8a2 2 0 012-2h.93a2 2 0 001.664-.89l.812-1.22A2 2 0 018.07 3h3.86a2 2 0 011.664.89l.812 1.22A2 2 0 0016.07 6H17a2 2 0 012 2v7a2 2 0 01-2 2H3a2 2 0 01-2-2V8zm13.5 3a4.5 4.5 0 11-9 0 4.5 4.5 0 019 0zM10 14a3 3 0 100-6 3 3 0 000 6z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CameraIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChartBarSquareIcon.js
var require_ChartBarSquareIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChartBarSquareIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChartBarSquareIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.25 2A2.25 2.25 0 002 4.25v11.5A2.25 2.25 0 004.25 18h11.5A2.25 2.25 0 0018 15.75V4.25A2.25 2.25 0 0015.75 2H4.25zM15 5.75a.75.75 0 00-1.5 0v8.5a.75.75 0 001.5 0v-8.5zm-8.5 6a.75.75 0 00-1.5 0v2.5a.75.75 0 001.5 0v-2.5zM8.584 9a.75.75 0 01.75.75v4.5a.75.75 0 01-1.5 0v-4.5a.75.75 0 01.75-.75zm3.58-1.25a.75.75 0 00-1.5 0v6.5a.75.75 0 001.5 0v-6.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChartBarSquareIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChartBarIcon.js
var require_ChartBarIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChartBarIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChartBarIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M15.5 2A1.5 1.5 0 0014 3.5v13a1.5 1.5 0 001.5 1.5h1a1.5 1.5 0 001.5-1.5v-13A1.5 1.5 0 0016.5 2h-1zM9.5 6A1.5 1.5 0 008 7.5v9A1.5 1.5 0 009.5 18h1a1.5 1.5 0 001.5-1.5v-9A1.5 1.5 0 0010.5 6h-1zM3.5 10A1.5 1.5 0 002 11.5v5A1.5 1.5 0 003.5 18h1A1.5 1.5 0 006 16.5v-5A1.5 1.5 0 004.5 10h-1z"
      }));
    }
    var ForwardRef = React.forwardRef(ChartBarIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChartPieIcon.js
var require_ChartPieIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChartPieIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChartPieIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M12 9a1 1 0 01-1-1V3c0-.553.45-1.008.997-.93a7.004 7.004 0 015.933 5.933c.078.547-.378.997-.93.997h-5z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M8.003 4.07C8.55 3.992 9 4.447 9 5v5a1 1 0 001 1h5c.552 0 1.008.45.93.997A7.001 7.001 0 012 11a7.002 7.002 0 016.003-6.93z"
      }));
    }
    var ForwardRef = React.forwardRef(ChartPieIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleBottomCenterTextIcon.js
var require_ChatBubbleBottomCenterTextIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleBottomCenterTextIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChatBubbleBottomCenterTextIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 2c-2.236 0-4.43.18-6.57.524C1.993 2.755 1 4.014 1 5.426v5.148c0 1.413.993 2.67 2.43 2.902 1.168.188 2.352.327 3.55.414.28.02.521.18.642.413l1.713 3.293a.75.75 0 001.33 0l1.713-3.293a.783.783 0 01.642-.413 41.102 41.102 0 003.55-.414c1.437-.231 2.43-1.49 2.43-2.902V5.426c0-1.413-.993-2.67-2.43-2.902A41.289 41.289 0 0010 2zM6.75 6a.75.75 0 000 1.5h6.5a.75.75 0 000-1.5h-6.5zm0 2.5a.75.75 0 000 1.5h3.5a.75.75 0 000-1.5h-3.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleBottomCenterTextIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleBottomCenterIcon.js
var require_ChatBubbleBottomCenterIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleBottomCenterIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChatBubbleBottomCenterIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3.43 2.524A41.29 41.29 0 0110 2c2.236 0 4.43.18 6.57.524 1.437.231 2.43 1.49 2.43 2.902v5.148c0 1.413-.993 2.67-2.43 2.902a41.102 41.102 0 01-3.55.414c-.28.02-.521.18-.643.413l-1.712 3.293a.75.75 0 01-1.33 0l-1.713-3.293a.783.783 0 00-.642-.413 41.108 41.108 0 01-3.55-.414C1.993 13.245 1 11.986 1 10.574V5.426c0-1.413.993-2.67 2.43-2.902z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleBottomCenterIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleLeftEllipsisIcon.js
var require_ChatBubbleLeftEllipsisIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleLeftEllipsisIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChatBubbleLeftEllipsisIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 2c-2.236 0-4.43.18-6.57.524C1.993 2.755 1 4.014 1 5.426v5.148c0 1.413.993 2.67 2.43 2.902.848.137 1.705.248 2.57.331v3.443a.75.75 0 001.28.53l3.58-3.579a.78.78 0 01.527-.224 41.202 41.202 0 005.183-.5c1.437-.232 2.43-1.49 2.43-2.903V5.426c0-1.413-.993-2.67-2.43-2.902A41.289 41.289 0 0010 2zm0 7a1 1 0 100-2 1 1 0 000 2zM8 8a1 1 0 11-2 0 1 1 0 012 0zm5 1a1 1 0 100-2 1 1 0 000 2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleLeftEllipsisIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleLeftRightIcon.js
var require_ChatBubbleLeftRightIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleLeftRightIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChatBubbleLeftRightIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3.505 2.365A41.369 41.369 0 019 2c1.863 0 3.697.124 5.495.365 1.247.167 2.18 1.108 2.435 2.268a4.45 4.45 0 00-.577-.069 43.141 43.141 0 00-4.706 0C9.229 4.696 7.5 6.727 7.5 8.998v2.24c0 1.413.67 2.735 1.76 3.562l-2.98 2.98A.75.75 0 015 17.25v-3.443c-.501-.048-1-.106-1.495-.172C2.033 13.438 1 12.162 1 10.72V5.28c0-1.441 1.033-2.717 2.505-2.914z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M14 6c-.762 0-1.52.02-2.271.062C10.157 6.148 9 7.472 9 8.998v2.24c0 1.519 1.147 2.839 2.71 2.935.214.013.428.024.642.034.2.009.385.09.518.224l2.35 2.35a.75.75 0 001.28-.531v-2.07c1.453-.195 2.5-1.463 2.5-2.915V8.998c0-1.526-1.157-2.85-2.729-2.936A41.645 41.645 0 0014 6z"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleLeftRightIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleLeftIcon.js
var require_ChatBubbleLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChatBubbleLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3.43 2.524A41.29 41.29 0 0110 2c2.236 0 4.43.18 6.57.524 1.437.231 2.43 1.49 2.43 2.902v5.148c0 1.413-.993 2.67-2.43 2.902a41.202 41.202 0 01-5.183.501.78.78 0 00-.528.224l-3.579 3.58A.75.75 0 016 17.25v-3.443a41.033 41.033 0 01-2.57-.33C1.993 13.244 1 11.986 1 10.573V5.426c0-1.413.993-2.67 2.43-2.902z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleOvalLeftEllipsisIcon.js
var require_ChatBubbleOvalLeftEllipsisIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleOvalLeftEllipsisIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChatBubbleOvalLeftEllipsisIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 3c-4.31 0-8 3.033-8 7 0 2.024.978 3.825 2.499 5.085a3.478 3.478 0 01-.522 1.756.75.75 0 00.584 1.143 5.976 5.976 0 003.936-1.108c.487.082.99.124 1.503.124 4.31 0 8-3.033 8-7s-3.69-7-8-7zm0 8a1 1 0 100-2 1 1 0 000 2zm-2-1a1 1 0 11-2 0 1 1 0 012 0zm5 1a1 1 0 100-2 1 1 0 000 2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleOvalLeftEllipsisIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleOvalLeftIcon.js
var require_ChatBubbleOvalLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChatBubbleOvalLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChatBubbleOvalLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 10c0-3.967 3.69-7 8-7 4.31 0 8 3.033 8 7s-3.69 7-8 7a9.165 9.165 0 01-1.504-.123 5.976 5.976 0 01-3.935 1.107.75.75 0 01-.584-1.143 3.478 3.478 0 00.522-1.756C2.979 13.825 2 12.025 2 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleOvalLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CheckBadgeIcon.js
var require_CheckBadgeIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CheckBadgeIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CheckBadgeIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M16.403 12.652a3 3 0 000-5.304 3 3 0 00-3.75-3.751 3 3 0 00-5.305 0 3 3 0 00-3.751 3.75 3 3 0 000 5.305 3 3 0 003.75 3.751 3 3 0 005.305 0 3 3 0 003.751-3.75zm-2.546-4.46a.75.75 0 00-1.214-.883l-3.483 4.79-1.88-1.88a.75.75 0 10-1.06 1.061l2.5 2.5a.75.75 0 001.137-.089l4-5.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CheckBadgeIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CheckCircleIcon.js
var require_CheckCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CheckCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CheckCircleIcon2({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zm3.857-9.809a.75.75 0 00-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 10-1.06 1.061l2.5 2.5a.75.75 0 001.137-.089l4-5.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CheckCircleIcon2);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CheckIcon.js
var require_CheckIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CheckIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CheckIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M16.704 4.153a.75.75 0 01.143 1.052l-8 10.5a.75.75 0 01-1.127.075l-4.5-4.5a.75.75 0 011.06-1.06l3.894 3.893 7.48-9.817a.75.75 0 011.05-.143z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CheckIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronDoubleDownIcon.js
var require_ChevronDoubleDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronDoubleDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChevronDoubleDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M14.77 4.21a.75.75 0 01.02 1.06l-4.25 4.5a.75.75 0 01-1.08 0l-4.25-4.5a.75.75 0 011.08-1.04L10 8.168l3.71-3.938a.75.75 0 011.06-.02zm0 6a.75.75 0 01.02 1.06l-4.25 4.5a.75.75 0 01-1.08 0l-4.25-4.5a.75.75 0 111.08-1.04L10 14.168l3.71-3.938a.75.75 0 011.06-.02z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronDoubleDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronDoubleLeftIcon.js
var require_ChevronDoubleLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronDoubleLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChevronDoubleLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M15.79 14.77a.75.75 0 01-1.06.02l-4.5-4.25a.75.75 0 010-1.08l4.5-4.25a.75.75 0 111.04 1.08L11.832 10l3.938 3.71a.75.75 0 01.02 1.06zm-6 0a.75.75 0 01-1.06.02l-4.5-4.25a.75.75 0 010-1.08l4.5-4.25a.75.75 0 111.04 1.08L5.832 10l3.938 3.71a.75.75 0 01.02 1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronDoubleLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronDoubleRightIcon.js
var require_ChevronDoubleRightIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronDoubleRightIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChevronDoubleRightIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10.21 14.77a.75.75 0 01.02-1.06L14.168 10 10.23 6.29a.75.75 0 111.04-1.08l4.5 4.25a.75.75 0 010 1.08l-4.5 4.25a.75.75 0 01-1.06-.02z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.21 14.77a.75.75 0 01.02-1.06L8.168 10 4.23 6.29a.75.75 0 111.04-1.08l4.5 4.25a.75.75 0 010 1.08l-4.5 4.25a.75.75 0 01-1.06-.02z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronDoubleRightIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronDoubleUpIcon.js
var require_ChevronDoubleUpIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronDoubleUpIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChevronDoubleUpIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5.23 15.79a.75.75 0 01-.02-1.06l4.25-4.5a.75.75 0 011.08 0l4.25 4.5a.75.75 0 11-1.08 1.04L10 11.832 6.29 15.77a.75.75 0 01-1.06.02zm0-6a.75.75 0 01-.02-1.06l4.25-4.5a.75.75 0 011.08 0l4.25 4.5a.75.75 0 11-1.08 1.04L10 5.832 6.29 9.77a.75.75 0 01-1.06.02z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronDoubleUpIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronDownIcon.js
var require_ChevronDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChevronDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5.23 7.21a.75.75 0 011.06.02L10 11.168l3.71-3.938a.75.75 0 111.08 1.04l-4.25 4.5a.75.75 0 01-1.08 0l-4.25-4.5a.75.75 0 01.02-1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronLeftIcon.js
var require_ChevronLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChevronLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M12.79 5.23a.75.75 0 01-.02 1.06L8.832 10l3.938 3.71a.75.75 0 11-1.04 1.08l-4.5-4.25a.75.75 0 010-1.08l4.5-4.25a.75.75 0 011.06.02z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronRightIcon.js
var require_ChevronRightIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronRightIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChevronRightIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M7.21 14.77a.75.75 0 01.02-1.06L11.168 10 7.23 6.29a.75.75 0 111.04-1.08l4.5 4.25a.75.75 0 010 1.08l-4.5 4.25a.75.75 0 01-1.06-.02z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronRightIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronUpDownIcon.js
var require_ChevronUpDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronUpDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChevronUpDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 3a.75.75 0 01.55.24l3.25 3.5a.75.75 0 11-1.1 1.02L10 4.852 7.3 7.76a.75.75 0 01-1.1-1.02l3.25-3.5A.75.75 0 0110 3zm-3.76 9.2a.75.75 0 011.06.04l2.7 2.908 2.7-2.908a.75.75 0 111.1 1.02l-3.25 3.5a.75.75 0 01-1.1 0l-3.25-3.5a.75.75 0 01.04-1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronUpDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronUpIcon.js
var require_ChevronUpIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ChevronUpIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ChevronUpIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M14.77 12.79a.75.75 0 01-1.06-.02L10 8.832 6.29 12.77a.75.75 0 11-1.08-1.04l4.25-4.5a.75.75 0 011.08 0l4.25 4.5a.75.75 0 01-.02 1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronUpIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CircleStackIcon.js
var require_CircleStackIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CircleStackIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CircleStackIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 1c3.866 0 7 1.79 7 4s-3.134 4-7 4-7-1.79-7-4 3.134-4 7-4zm5.694 8.13c.464-.264.91-.583 1.306-.952V10c0 2.21-3.134 4-7 4s-7-1.79-7-4V8.178c.396.37.842.688 1.306.953C5.838 10.006 7.854 10.5 10 10.5s4.162-.494 5.694-1.37zM3 13.179V15c0 2.21 3.134 4 7 4s7-1.79 7-4v-1.822c-.396.37-.842.688-1.306.953-1.532.875-3.548 1.369-5.694 1.369s-4.162-.494-5.694-1.37A7.009 7.009 0 013 13.179z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CircleStackIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ClipboardDocumentCheckIcon.js
var require_ClipboardDocumentCheckIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ClipboardDocumentCheckIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ClipboardDocumentCheckIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M18 5.25a2.25 2.25 0 00-2.012-2.238A2.25 2.25 0 0013.75 1h-1.5a2.25 2.25 0 00-2.238 2.012c-.875.092-1.6.686-1.884 1.488H11A2.5 2.5 0 0113.5 7v7h2.25A2.25 2.25 0 0018 11.75v-6.5zM12.25 2.5a.75.75 0 00-.75.75v.25h3v-.25a.75.75 0 00-.75-.75h-1.5z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3 6a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V7a1 1 0 00-1-1H3zm6.874 4.166a.75.75 0 10-1.248-.832l-2.493 3.739-.853-.853a.75.75 0 00-1.06 1.06l1.5 1.5a.75.75 0 001.154-.114l3-4.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ClipboardDocumentCheckIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ClipboardDocumentListIcon.js
var require_ClipboardDocumentListIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ClipboardDocumentListIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ClipboardDocumentListIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M15.988 3.012A2.25 2.25 0 0118 5.25v6.5A2.25 2.25 0 0115.75 14H13.5V7A2.5 2.5 0 0011 4.5H8.128a2.252 2.252 0 011.884-1.488A2.25 2.25 0 0112.25 1h1.5a2.25 2.25 0 012.238 2.012zM11.5 3.25a.75.75 0 01.75-.75h1.5a.75.75 0 01.75.75v.25h-3v-.25z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 7a1 1 0 011-1h8a1 1 0 011 1v10a1 1 0 01-1 1H3a1 1 0 01-1-1V7zm2 3.25a.75.75 0 01.75-.75h4.5a.75.75 0 010 1.5h-4.5a.75.75 0 01-.75-.75zm0 3.5a.75.75 0 01.75-.75h4.5a.75.75 0 010 1.5h-4.5a.75.75 0 01-.75-.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ClipboardDocumentListIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ClipboardDocumentIcon.js
var require_ClipboardDocumentIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ClipboardDocumentIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ClipboardDocumentIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M15.988 3.012A2.25 2.25 0 0118 5.25v6.5A2.25 2.25 0 0115.75 14H13.5v-3.379a3 3 0 00-.879-2.121l-3.12-3.121a3 3 0 00-1.402-.791 2.252 2.252 0 011.913-1.576A2.25 2.25 0 0112.25 1h1.5a2.25 2.25 0 012.238 2.012zM11.5 3.25a.75.75 0 01.75-.75h1.5a.75.75 0 01.75.75v.25h-3v-.25z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M3.5 6A1.5 1.5 0 002 7.5v9A1.5 1.5 0 003.5 18h7a1.5 1.5 0 001.5-1.5v-5.879a1.5 1.5 0 00-.44-1.06L8.44 6.439A1.5 1.5 0 007.378 6H3.5z"
      }));
    }
    var ForwardRef = React.forwardRef(ClipboardDocumentIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ClipboardIcon.js
var require_ClipboardIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ClipboardIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ClipboardIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M13.887 3.182c.396.037.79.08 1.183.128C16.194 3.45 17 4.414 17 5.517V16.75A2.25 2.25 0 0114.75 19h-9.5A2.25 2.25 0 013 16.75V5.517c0-1.103.806-2.068 1.93-2.207.393-.048.787-.09 1.183-.128A3.001 3.001 0 019 1h2c1.373 0 2.531.923 2.887 2.182zM7.5 4A1.5 1.5 0 019 2.5h2A1.5 1.5 0 0112.5 4v.5h-5V4z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ClipboardIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ClockIcon.js
var require_ClockIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ClockIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ClockIcon2({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zm.75-13a.75.75 0 00-1.5 0v5c0 .414.336.75.75.75h4a.75.75 0 000-1.5h-3.25V5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ClockIcon2);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CloudArrowDownIcon.js
var require_CloudArrowDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CloudArrowDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CloudArrowDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5.5 17a4.5 4.5 0 01-1.44-8.765 4.5 4.5 0 018.302-3.046 3.5 3.5 0 014.504 4.272A4 4 0 0115 17H5.5zm5.25-9.25a.75.75 0 00-1.5 0v4.59l-1.95-2.1a.75.75 0 10-1.1 1.02l3.25 3.5a.75.75 0 001.1 0l3.25-3.5a.75.75 0 10-1.1-1.02l-1.95 2.1V7.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CloudArrowDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CloudArrowUpIcon.js
var require_CloudArrowUpIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CloudArrowUpIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CloudArrowUpIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5.5 17a4.5 4.5 0 01-1.44-8.765 4.5 4.5 0 018.302-3.046 3.5 3.5 0 014.504 4.272A4 4 0 0115 17H5.5zm3.75-2.75a.75.75 0 001.5 0V9.66l1.95 2.1a.75.75 0 101.1-1.02l-3.25-3.5a.75.75 0 00-1.1 0l-3.25 3.5a.75.75 0 101.1 1.02l1.95-2.1v4.59z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CloudArrowUpIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CloudIcon.js
var require_CloudIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CloudIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CloudIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M1 12.5A4.5 4.5 0 005.5 17H15a4 4 0 001.866-7.539 3.504 3.504 0 00-4.504-4.272A4.5 4.5 0 004.06 8.235 4.502 4.502 0 001 12.5z"
      }));
    }
    var ForwardRef = React.forwardRef(CloudIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CodeBracketSquareIcon.js
var require_CodeBracketSquareIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CodeBracketSquareIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CodeBracketSquareIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.25 2A2.25 2.25 0 002 4.25v11.5A2.25 2.25 0 004.25 18h11.5A2.25 2.25 0 0018 15.75V4.25A2.25 2.25 0 0015.75 2H4.25zm4.03 6.28a.75.75 0 00-1.06-1.06L4.97 9.47a.75.75 0 000 1.06l2.25 2.25a.75.75 0 001.06-1.06L6.56 10l1.72-1.72zm4.5-1.06a.75.75 0 10-1.06 1.06L13.44 10l-1.72 1.72a.75.75 0 101.06 1.06l2.25-2.25a.75.75 0 000-1.06l-2.25-2.25z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CodeBracketSquareIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CodeBracketIcon.js
var require_CodeBracketIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CodeBracketIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CodeBracketIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M6.28 5.22a.75.75 0 010 1.06L2.56 10l3.72 3.72a.75.75 0 01-1.06 1.06L.97 10.53a.75.75 0 010-1.06l4.25-4.25a.75.75 0 011.06 0zm7.44 0a.75.75 0 011.06 0l4.25 4.25a.75.75 0 010 1.06l-4.25 4.25a.75.75 0 01-1.06-1.06L17.44 10l-3.72-3.72a.75.75 0 010-1.06zM11.377 2.011a.75.75 0 01.612.867l-2.5 14.5a.75.75 0 01-1.478-.255l2.5-14.5a.75.75 0 01.866-.612z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CodeBracketIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Cog6ToothIcon.js
var require_Cog6ToothIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Cog6ToothIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Cog6ToothIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M7.84 1.804A1 1 0 018.82 1h2.36a1 1 0 01.98.804l.331 1.652a6.993 6.993 0 011.929 1.115l1.598-.54a1 1 0 011.186.447l1.18 2.044a1 1 0 01-.205 1.251l-1.267 1.113a7.047 7.047 0 010 2.228l1.267 1.113a1 1 0 01.206 1.25l-1.18 2.045a1 1 0 01-1.187.447l-1.598-.54a6.993 6.993 0 01-1.929 1.115l-.33 1.652a1 1 0 01-.98.804H8.82a1 1 0 01-.98-.804l-.331-1.652a6.993 6.993 0 01-1.929-1.115l-1.598.54a1 1 0 01-1.186-.447l-1.18-2.044a1 1 0 01.205-1.251l1.267-1.114a7.05 7.05 0 010-2.227L1.821 7.773a1 1 0 01-.206-1.25l1.18-2.045a1 1 0 011.187-.447l1.598.54A6.993 6.993 0 017.51 3.456l.33-1.652zM10 13a3 3 0 100-6 3 3 0 000 6z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(Cog6ToothIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Cog8ToothIcon.js
var require_Cog8ToothIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Cog8ToothIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Cog8ToothIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M8.34 1.804A1 1 0 019.32 1h1.36a1 1 0 01.98.804l.295 1.473c.497.144.971.342 1.416.587l1.25-.834a1 1 0 011.262.125l.962.962a1 1 0 01.125 1.262l-.834 1.25c.245.445.443.919.587 1.416l1.473.294a1 1 0 01.804.98v1.361a1 1 0 01-.804.98l-1.473.295a6.95 6.95 0 01-.587 1.416l.834 1.25a1 1 0 01-.125 1.262l-.962.962a1 1 0 01-1.262.125l-1.25-.834a6.953 6.953 0 01-1.416.587l-.294 1.473a1 1 0 01-.98.804H9.32a1 1 0 01-.98-.804l-.295-1.473a6.957 6.957 0 01-1.416-.587l-1.25.834a1 1 0 01-1.262-.125l-.962-.962a1 1 0 01-.125-1.262l.834-1.25a6.957 6.957 0 01-.587-1.416l-1.473-.294A1 1 0 011 10.68V9.32a1 1 0 01.804-.98l1.473-.295c.144-.497.342-.971.587-1.416l-.834-1.25a1 1 0 01.125-1.262l.962-.962A1 1 0 015.38 3.03l1.25.834a6.957 6.957 0 011.416-.587l.294-1.473zM13 10a3 3 0 11-6 0 3 3 0 016 0z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(Cog8ToothIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CogIcon.js
var require_CogIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CogIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CogIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M13.024 9.25c.47 0 .827-.433.637-.863a4 4 0 00-4.094-2.364c-.468.05-.665.576-.43.984l1.08 1.868a.75.75 0 00.649.375h2.158zM7.84 7.758c-.236-.408-.79-.5-1.068-.12A3.982 3.982 0 006 10c0 .884.287 1.7.772 2.363.278.38.832.287 1.068-.12l1.078-1.868a.75.75 0 000-.75L7.839 7.758zM9.138 12.993c-.235.408-.039.934.43.984a4 4 0 004.094-2.364c.19-.43-.168-.863-.638-.863h-2.158a.75.75 0 00-.65.375l-1.078 1.868z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M14.13 4.347l.644-1.117a.75.75 0 00-1.299-.75l-.644 1.116a6.954 6.954 0 00-2.081-.556V1.75a.75.75 0 00-1.5 0v1.29a6.954 6.954 0 00-2.081.556L6.525 2.48a.75.75 0 10-1.3.75l.645 1.117A7.04 7.04 0 004.347 5.87L3.23 5.225a.75.75 0 10-.75 1.3l1.116.644A6.954 6.954 0 003.04 9.25H1.75a.75.75 0 000 1.5h1.29c.078.733.27 1.433.556 2.081l-1.116.645a.75.75 0 10.75 1.298l1.117-.644a7.04 7.04 0 001.523 1.523l-.645 1.117a.75.75 0 101.3.75l.644-1.116a6.954 6.954 0 002.081.556v1.29a.75.75 0 001.5 0v-1.29a6.954 6.954 0 002.081-.556l.645 1.116a.75.75 0 001.299-.75l-.645-1.117a7.042 7.042 0 001.523-1.523l1.117.644a.75.75 0 00.75-1.298l-1.116-.645a6.954 6.954 0 00.556-2.081h1.29a.75.75 0 000-1.5h-1.29a6.954 6.954 0 00-.556-2.081l1.116-.644a.75.75 0 00-.75-1.3l-1.117.645a7.04 7.04 0 00-1.524-1.523zM10 4.5a5.475 5.475 0 00-2.781.754A5.527 5.527 0 005.22 7.277 5.475 5.475 0 004.5 10a5.475 5.475 0 00.752 2.777 5.527 5.527 0 002.028 2.004c.802.458 1.73.719 2.72.719a5.474 5.474 0 002.78-.753 5.527 5.527 0 002.001-2.027c.458-.802.719-1.73.719-2.72a5.475 5.475 0 00-.753-2.78 5.528 5.528 0 00-2.028-2.002A5.475 5.475 0 0010 4.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CogIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CommandLineIcon.js
var require_CommandLineIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CommandLineIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CommandLineIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3.25 3A2.25 2.25 0 001 5.25v9.5A2.25 2.25 0 003.25 17h13.5A2.25 2.25 0 0019 14.75v-9.5A2.25 2.25 0 0016.75 3H3.25zm.943 8.752a.75.75 0 01.055-1.06L6.128 9l-1.88-1.693a.75.75 0 111.004-1.114l2.5 2.25a.75.75 0 010 1.114l-2.5 2.25a.75.75 0 01-1.06-.055zM9.75 10.25a.75.75 0 000 1.5h2.5a.75.75 0 000-1.5h-2.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CommandLineIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ComputerDesktopIcon.js
var require_ComputerDesktopIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ComputerDesktopIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ComputerDesktopIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 4.25A2.25 2.25 0 014.25 2h11.5A2.25 2.25 0 0118 4.25v8.5A2.25 2.25 0 0115.75 15h-3.105a3.501 3.501 0 001.1 1.677A.75.75 0 0113.26 18H6.74a.75.75 0 01-.484-1.323A3.501 3.501 0 007.355 15H4.25A2.25 2.25 0 012 12.75v-8.5zm1.5 0a.75.75 0 01.75-.75h11.5a.75.75 0 01.75.75v7.5a.75.75 0 01-.75.75H4.25a.75.75 0 01-.75-.75v-7.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ComputerDesktopIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CpuChipIcon.js
var require_CpuChipIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CpuChipIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CpuChipIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M14 6H6v8h8V6z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M9.25 3V1.75a.75.75 0 011.5 0V3h1.5V1.75a.75.75 0 011.5 0V3h.5A2.75 2.75 0 0117 5.75v.5h1.25a.75.75 0 010 1.5H17v1.5h1.25a.75.75 0 010 1.5H17v1.5h1.25a.75.75 0 010 1.5H17v.5A2.75 2.75 0 0114.25 17h-.5v1.25a.75.75 0 01-1.5 0V17h-1.5v1.25a.75.75 0 01-1.5 0V17h-1.5v1.25a.75.75 0 01-1.5 0V17h-.5A2.75 2.75 0 013 14.25v-.5H1.75a.75.75 0 010-1.5H3v-1.5H1.75a.75.75 0 010-1.5H3v-1.5H1.75a.75.75 0 010-1.5H3v-.5A2.75 2.75 0 015.75 3h.5V1.75a.75.75 0 011.5 0V3h1.5zM4.5 5.75c0-.69.56-1.25 1.25-1.25h8.5c.69 0 1.25.56 1.25 1.25v8.5c0 .69-.56 1.25-1.25 1.25h-8.5c-.69 0-1.25-.56-1.25-1.25v-8.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CpuChipIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CreditCardIcon.js
var require_CreditCardIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CreditCardIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CreditCardIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2.5 4A1.5 1.5 0 001 5.5V6h18v-.5A1.5 1.5 0 0017.5 4h-15zM19 8.5H1v6A1.5 1.5 0 002.5 16h15a1.5 1.5 0 001.5-1.5v-6zM3 13.25a.75.75 0 01.75-.75h1.5a.75.75 0 010 1.5h-1.5a.75.75 0 01-.75-.75zm4.75-.75a.75.75 0 000 1.5h3.5a.75.75 0 000-1.5h-3.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CreditCardIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CubeTransparentIcon.js
var require_CubeTransparentIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CubeTransparentIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CubeTransparentIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M9.638 1.093a.75.75 0 01.724 0l2 1.104a.75.75 0 11-.724 1.313L10 2.607l-1.638.903a.75.75 0 11-.724-1.313l2-1.104zM5.403 4.287a.75.75 0 01-.295 1.019l-.805.444.805.444a.75.75 0 01-.724 1.314L3.5 7.02v.73a.75.75 0 01-1.5 0v-2a.75.75 0 01.388-.657l1.996-1.1a.75.75 0 011.019.294zm9.194 0a.75.75 0 011.02-.295l1.995 1.101A.75.75 0 0118 5.75v2a.75.75 0 01-1.5 0v-.73l-.884.488a.75.75 0 11-.724-1.314l.806-.444-.806-.444a.75.75 0 01-.295-1.02zM7.343 8.284a.75.75 0 011.02-.294L10 8.893l1.638-.903a.75.75 0 11.724 1.313l-1.612.89v1.557a.75.75 0 01-1.5 0v-1.557l-1.612-.89a.75.75 0 01-.295-1.019zM2.75 11.5a.75.75 0 01.75.75v1.557l1.608.887a.75.75 0 01-.724 1.314l-1.996-1.101A.75.75 0 012 14.25v-2a.75.75 0 01.75-.75zm14.5 0a.75.75 0 01.75.75v2a.75.75 0 01-.388.657l-1.996 1.1a.75.75 0 11-.724-1.313l1.608-.887V12.25a.75.75 0 01.75-.75zm-7.25 4a.75.75 0 01.75.75v.73l.888-.49a.75.75 0 01.724 1.313l-2 1.104a.75.75 0 01-.724 0l-2-1.104a.75.75 0 11.724-1.313l.888.49v-.73a.75.75 0 01.75-.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CubeTransparentIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CubeIcon.js
var require_CubeIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CubeIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CubeIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10.362 1.093a.75.75 0 00-.724 0L2.523 5.018 10 9.143l7.477-4.125-7.115-3.925zM18 6.443l-7.25 4v8.25l6.862-3.786A.75.75 0 0018 14.25V6.443zm-8.75 12.25v-8.25l-7.25-4v7.807a.75.75 0 00.388.657l6.862 3.786z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CubeIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CurrencyBangladeshiIcon.js
var require_CurrencyBangladeshiIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CurrencyBangladeshiIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CurrencyBangladeshiIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 2a8 8 0 100 16 8 8 0 000-16zM5.94 5.5c.944-.945 2.56-.276 2.56 1.06V8h5.75a.75.75 0 010 1.5H8.5v4.275c0 .296.144.455.26.499a3.5 3.5 0 004.402-1.77h-.412a.75.75 0 010-1.5h.537c.462 0 .887.21 1.156.556.278.355.383.852.184 1.337a5.001 5.001 0 01-6.4 2.78C7.376 15.353 7 14.512 7 13.774V9.5H5.75a.75.75 0 010-1.5H7V6.56l-.22.22a.75.75 0 11-1.06-1.06l.22-.22z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CurrencyBangladeshiIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CurrencyDollarIcon.js
var require_CurrencyDollarIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CurrencyDollarIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CurrencyDollarIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10.75 10.818v2.614A3.13 3.13 0 0011.888 13c.482-.315.612-.648.612-.875 0-.227-.13-.56-.612-.875a3.13 3.13 0 00-1.138-.432zM8.33 8.62c.053.055.115.11.184.164.208.16.46.284.736.363V6.603a2.45 2.45 0 00-.35.13c-.14.065-.27.143-.386.233-.377.292-.514.627-.514.909 0 .184.058.39.202.592.037.051.08.102.128.152z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-8-6a.75.75 0 01.75.75v.316a3.78 3.78 0 011.653.713c.426.33.744.74.925 1.2a.75.75 0 01-1.395.55 1.35 1.35 0 00-.447-.563 2.187 2.187 0 00-.736-.363V9.3c.698.093 1.383.32 1.959.696.787.514 1.29 1.27 1.29 2.13 0 .86-.504 1.616-1.29 2.13-.576.377-1.261.603-1.96.696v.299a.75.75 0 11-1.5 0v-.3c-.697-.092-1.382-.318-1.958-.695-.482-.315-.857-.717-1.078-1.188a.75.75 0 111.359-.636c.08.173.245.376.54.569.313.205.706.353 1.138.432v-2.748a3.782 3.782 0 01-1.653-.713C6.9 9.433 6.5 8.681 6.5 7.875c0-.805.4-1.558 1.097-2.096a3.78 3.78 0 011.653-.713V4.75A.75.75 0 0110 4z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CurrencyDollarIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CurrencyEuroIcon.js
var require_CurrencyEuroIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CurrencyEuroIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CurrencyEuroIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zM8.798 7.45c.512-.67 1.135-.95 1.702-.95s1.19.28 1.702.95a.75.75 0 001.192-.91C12.637 5.55 11.596 5 10.5 5s-2.137.55-2.894 1.54A5.205 5.205 0 006.83 8H5.75a.75.75 0 000 1.5h.77a6.333 6.333 0 000 1h-.77a.75.75 0 000 1.5h1.08c.183.528.442 1.023.776 1.46.757.99 1.798 1.54 2.894 1.54s2.137-.55 2.894-1.54a.75.75 0 00-1.192-.91c-.512.67-1.135.95-1.702.95s-1.19-.28-1.702-.95a3.505 3.505 0 01-.343-.55h1.795a.75.75 0 000-1.5H8.026a4.835 4.835 0 010-1h2.224a.75.75 0 000-1.5H8.455c.098-.195.212-.38.343-.55z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CurrencyEuroIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CurrencyPoundIcon.js
var require_CurrencyPoundIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CurrencyPoundIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CurrencyPoundIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zM8.732 6.232a2.5 2.5 0 013.536 0 .75.75 0 101.06-1.06A4 4 0 006.5 8v.165c0 .364.034.728.1 1.085h-.35a.75.75 0 000 1.5h.737a5.25 5.25 0 01-.367 3.072l-.055.123a.75.75 0 00.848 1.037l1.272-.283a3.493 3.493 0 011.604.021 4.992 4.992 0 002.422 0l.97-.242a.75.75 0 00-.363-1.456l-.971.243a3.491 3.491 0 01-1.694 0 4.992 4.992 0 00-2.258-.038c.19-.811.227-1.651.111-2.477H9.75a.75.75 0 000-1.5H8.136A4.397 4.397 0 018 8.165V8c0-.641.244-1.28.732-1.768z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CurrencyPoundIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CurrencyRupeeIcon.js
var require_CurrencyRupeeIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CurrencyRupeeIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CurrencyRupeeIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zM6 5.75A.75.75 0 016.75 5h6.5a.75.75 0 010 1.5h-2.127c.4.5.683 1.096.807 1.75h1.32a.75.75 0 010 1.5h-1.32a4.003 4.003 0 01-3.404 3.216l1.754 1.754a.75.75 0 01-1.06 1.06l-3-3a.75.75 0 01.53-1.28H8c1.12 0 2.067-.736 2.386-1.75H6.75a.75.75 0 010-1.5h3.636A2.501 2.501 0 008 6.5H6.75A.75.75 0 016 5.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CurrencyRupeeIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CurrencyYenIcon.js
var require_CurrencyYenIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CurrencyYenIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CurrencyYenIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zM7.346 5.294a.75.75 0 00-1.192.912L9.056 10H6.75a.75.75 0 000 1.5h2.5v1h-2.5a.75.75 0 000 1.5h2.5v1.25a.75.75 0 001.5 0V14h2.5a.75.75 0 100-1.5h-2.5v-1h2.5a.75.75 0 100-1.5h-2.306l2.902-3.794a.75.75 0 10-1.192-.912L10 8.765l-2.654-3.47z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CurrencyYenIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CursorArrowRaysIcon.js
var require_CursorArrowRaysIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CursorArrowRaysIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CursorArrowRaysIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 1a.75.75 0 01.75.75v1.5a.75.75 0 01-1.5 0v-1.5A.75.75 0 0110 1zM5.05 3.05a.75.75 0 011.06 0l1.062 1.06A.75.75 0 116.11 5.173L5.05 4.11a.75.75 0 010-1.06zm9.9 0a.75.75 0 010 1.06l-1.06 1.062a.75.75 0 01-1.062-1.061l1.061-1.06a.75.75 0 011.06 0zM3 8a.75.75 0 01.75-.75h1.5a.75.75 0 010 1.5h-1.5A.75.75 0 013 8zm11 0a.75.75 0 01.75-.75h1.5a.75.75 0 010 1.5h-1.5A.75.75 0 0114 8zm-6.828 2.828a.75.75 0 010 1.061L6.11 12.95a.75.75 0 01-1.06-1.06l1.06-1.06a.75.75 0 011.06 0zm3.594-3.317a.75.75 0 00-1.37.364l-.492 6.861a.75.75 0 001.204.65l1.043-.799.985 3.678a.75.75 0 001.45-.388l-.978-3.646 1.292.204a.75.75 0 00.74-1.16l-3.874-5.764z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CursorArrowRaysIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CursorArrowRippleIcon.js
var require_CursorArrowRippleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/CursorArrowRippleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function CursorArrowRippleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M6.111 11.89A5.5 5.5 0 1115.501 8 .75.75 0 1017 8a7 7 0 10-11.95 4.95.75.75 0 001.06-1.06zm2.121-5.658a2.5 2.5 0 000 3.536.75.75 0 11-1.06 1.06A4 4 0 1114 8a.75.75 0 01-1.5 0 2.5 2.5 0 00-4.268-1.768zm2.534 1.279a.75.75 0 00-1.37.364l-.492 6.861a.75.75 0 001.204.65l1.043-.799.985 3.678a.75.75 0 001.45-.388l-.978-3.646 1.292.204a.75.75 0 00.74-1.16l-3.874-5.764z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(CursorArrowRippleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DevicePhoneMobileIcon.js
var require_DevicePhoneMobileIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DevicePhoneMobileIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function DevicePhoneMobileIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M8 16.25a.75.75 0 01.75-.75h2.5a.75.75 0 010 1.5h-2.5a.75.75 0 01-.75-.75z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4 4a3 3 0 013-3h6a3 3 0 013 3v12a3 3 0 01-3 3H7a3 3 0 01-3-3V4zm4-1.5v.75c0 .414.336.75.75.75h2.5a.75.75 0 00.75-.75V2.5h1A1.5 1.5 0 0114.5 4v12a1.5 1.5 0 01-1.5 1.5H7A1.5 1.5 0 015.5 16V4A1.5 1.5 0 017 2.5h1z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(DevicePhoneMobileIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DeviceTabletIcon.js
var require_DeviceTabletIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DeviceTabletIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function DeviceTabletIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5 1a3 3 0 00-3 3v12a3 3 0 003 3h10a3 3 0 003-3V4a3 3 0 00-3-3H5zM3.5 4A1.5 1.5 0 015 2.5h10A1.5 1.5 0 0116.5 4v12a1.5 1.5 0 01-1.5 1.5H5A1.5 1.5 0 013.5 16V4zm5.25 11.5a.75.75 0 000 1.5h2.5a.75.75 0 000-1.5h-2.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(DeviceTabletIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentArrowDownIcon.js
var require_DocumentArrowDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentArrowDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function DocumentArrowDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.5 2A1.5 1.5 0 003 3.5v13A1.5 1.5 0 004.5 18h11a1.5 1.5 0 001.5-1.5V7.621a1.5 1.5 0 00-.44-1.06l-4.12-4.122A1.5 1.5 0 0011.378 2H4.5zm4.75 6.75a.75.75 0 011.5 0v2.546l.943-1.048a.75.75 0 011.114 1.004l-2.25 2.5a.75.75 0 01-1.114 0l-2.25-2.5a.75.75 0 111.114-1.004l.943 1.048V8.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentArrowDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentArrowUpIcon.js
var require_DocumentArrowUpIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentArrowUpIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function DocumentArrowUpIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.5 2A1.5 1.5 0 003 3.5v13A1.5 1.5 0 004.5 18h11a1.5 1.5 0 001.5-1.5V7.621a1.5 1.5 0 00-.44-1.06l-4.12-4.122A1.5 1.5 0 0011.378 2H4.5zm4.75 11.25a.75.75 0 001.5 0v-2.546l.943 1.048a.75.75 0 101.114-1.004l-2.25-2.5a.75.75 0 00-1.114 0l-2.25 2.5a.75.75 0 101.114 1.004l.943-1.048v2.546z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentArrowUpIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentChartBarIcon.js
var require_DocumentChartBarIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentChartBarIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function DocumentChartBarIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3 3.5A1.5 1.5 0 014.5 2h6.879a1.5 1.5 0 011.06.44l4.122 4.12A1.5 1.5 0 0117 7.622V16.5a1.5 1.5 0 01-1.5 1.5h-11A1.5 1.5 0 013 16.5v-13zM13.25 9a.75.75 0 01.75.75v4.5a.75.75 0 01-1.5 0v-4.5a.75.75 0 01.75-.75zm-6.5 4a.75.75 0 01.75.75v.5a.75.75 0 01-1.5 0v-.5a.75.75 0 01.75-.75zm4-1.25a.75.75 0 00-1.5 0v2.5a.75.75 0 001.5 0v-2.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentChartBarIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentCheckIcon.js
var require_DocumentCheckIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentCheckIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function DocumentCheckIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3 3.5A1.5 1.5 0 014.5 2h6.879a1.5 1.5 0 011.06.44l4.122 4.12A1.5 1.5 0 0117 7.622V16.5a1.5 1.5 0 01-1.5 1.5h-11A1.5 1.5 0 013 16.5v-13zm10.857 5.691a.75.75 0 00-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 00-1.06 1.061l2.5 2.5a.75.75 0 001.137-.089l4-5.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentCheckIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentDuplicateIcon.js
var require_DocumentDuplicateIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentDuplicateIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function DocumentDuplicateIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M7 3.5A1.5 1.5 0 018.5 2h3.879a1.5 1.5 0 011.06.44l3.122 3.12A1.5 1.5 0 0117 6.622V12.5a1.5 1.5 0 01-1.5 1.5h-1v-3.379a3 3 0 00-.879-2.121L10.5 5.379A3 3 0 008.379 4.5H7v-1z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M4.5 6A1.5 1.5 0 003 7.5v9A1.5 1.5 0 004.5 18h7a1.5 1.5 0 001.5-1.5v-5.879a1.5 1.5 0 00-.44-1.06L9.44 6.439A1.5 1.5 0 008.378 6H4.5z"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentDuplicateIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentMagnifyingGlassIcon.js
var require_DocumentMagnifyingGlassIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentMagnifyingGlassIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function DocumentMagnifyingGlassIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M8 10a1.5 1.5 0 113 0 1.5 1.5 0 01-3 0z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.5 2A1.5 1.5 0 003 3.5v13A1.5 1.5 0 004.5 18h11a1.5 1.5 0 001.5-1.5V7.621a1.5 1.5 0 00-.44-1.06l-4.12-4.122A1.5 1.5 0 0011.378 2H4.5zm5 5a3 3 0 101.524 5.585l1.196 1.195a.75.75 0 101.06-1.06l-1.195-1.196A3 3 0 009.5 7z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentMagnifyingGlassIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentMinusIcon.js
var require_DocumentMinusIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentMinusIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function DocumentMinusIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.5 2A1.5 1.5 0 003 3.5v13A1.5 1.5 0 004.5 18h11a1.5 1.5 0 001.5-1.5V7.621a1.5 1.5 0 00-.44-1.06l-4.12-4.122A1.5 1.5 0 0011.378 2H4.5zm7.75 9.75a.75.75 0 000-1.5h-4.5a.75.75 0 000 1.5h4.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentMinusIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentPlusIcon.js
var require_DocumentPlusIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentPlusIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function DocumentPlusIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.5 2A1.5 1.5 0 003 3.5v13A1.5 1.5 0 004.5 18h11a1.5 1.5 0 001.5-1.5V7.621a1.5 1.5 0 00-.44-1.06l-4.12-4.122A1.5 1.5 0 0011.378 2H4.5zM10 8a.75.75 0 01.75.75v1.5h1.5a.75.75 0 010 1.5h-1.5v1.5a.75.75 0 01-1.5 0v-1.5h-1.5a.75.75 0 010-1.5h1.5v-1.5A.75.75 0 0110 8z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentPlusIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentTextIcon.js
var require_DocumentTextIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentTextIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function DocumentTextIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.5 2A1.5 1.5 0 003 3.5v13A1.5 1.5 0 004.5 18h11a1.5 1.5 0 001.5-1.5V7.621a1.5 1.5 0 00-.44-1.06l-4.12-4.122A1.5 1.5 0 0011.378 2H4.5zm2.25 8.5a.75.75 0 000 1.5h6.5a.75.75 0 000-1.5h-6.5zm0 3a.75.75 0 000 1.5h6.5a.75.75 0 000-1.5h-6.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentTextIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentIcon.js
var require_DocumentIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/DocumentIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function DocumentIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3 3.5A1.5 1.5 0 014.5 2h6.879a1.5 1.5 0 011.06.44l4.122 4.12A1.5 1.5 0 0117 7.622V16.5a1.5 1.5 0 01-1.5 1.5h-11A1.5 1.5 0 013 16.5v-13z"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EllipsisHorizontalCircleIcon.js
var require_EllipsisHorizontalCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EllipsisHorizontalCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function EllipsisHorizontalCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 10a8 8 0 1116 0 8 8 0 01-16 0zm8 1a1 1 0 100-2 1 1 0 000 2zm-3-1a1 1 0 11-2 0 1 1 0 012 0zm7 1a1 1 0 100-2 1 1 0 000 2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(EllipsisHorizontalCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EllipsisHorizontalIcon.js
var require_EllipsisHorizontalIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EllipsisHorizontalIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function EllipsisHorizontalIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3 10a1.5 1.5 0 113 0 1.5 1.5 0 01-3 0zM8.5 10a1.5 1.5 0 113 0 1.5 1.5 0 01-3 0zM15.5 8.5a1.5 1.5 0 100 3 1.5 1.5 0 000-3z"
      }));
    }
    var ForwardRef = React.forwardRef(EllipsisHorizontalIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EllipsisVerticalIcon.js
var require_EllipsisVerticalIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EllipsisVerticalIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function EllipsisVerticalIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10 3a1.5 1.5 0 110 3 1.5 1.5 0 010-3zM10 8.5a1.5 1.5 0 110 3 1.5 1.5 0 010-3zM11.5 15.5a1.5 1.5 0 10-3 0 1.5 1.5 0 003 0z"
      }));
    }
    var ForwardRef = React.forwardRef(EllipsisVerticalIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EnvelopeOpenIcon.js
var require_EnvelopeOpenIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EnvelopeOpenIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function EnvelopeOpenIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2.106 6.447A2 2 0 001 8.237V16a2 2 0 002 2h14a2 2 0 002-2V8.236a2 2 0 00-1.106-1.789l-7-3.5a2 2 0 00-1.788 0l-7 3.5zm1.48 4.007a.75.75 0 00-.671 1.342l5.855 2.928a2.75 2.75 0 002.46 0l5.852-2.926a.75.75 0 10-.67-1.342l-5.853 2.926a1.25 1.25 0 01-1.118 0l-5.856-2.928z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(EnvelopeOpenIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EnvelopeIcon.js
var require_EnvelopeIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EnvelopeIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function EnvelopeIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3 4a2 2 0 00-2 2v1.161l8.441 4.221a1.25 1.25 0 001.118 0L19 7.162V6a2 2 0 00-2-2H3z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M19 8.839l-7.77 3.885a2.75 2.75 0 01-2.46 0L1 8.839V14a2 2 0 002 2h14a2 2 0 002-2V8.839z"
      }));
    }
    var ForwardRef = React.forwardRef(EnvelopeIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ExclamationCircleIcon.js
var require_ExclamationCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ExclamationCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ExclamationCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-8-5a.75.75 0 01.75.75v4.5a.75.75 0 01-1.5 0v-4.5A.75.75 0 0110 5zm0 10a1 1 0 100-2 1 1 0 000 2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ExclamationCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ExclamationTriangleIcon.js
var require_ExclamationTriangleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ExclamationTriangleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ExclamationTriangleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M8.485 2.495c.673-1.167 2.357-1.167 3.03 0l6.28 10.875c.673 1.167-.17 2.625-1.516 2.625H3.72c-1.347 0-2.189-1.458-1.515-2.625L8.485 2.495zM10 5a.75.75 0 01.75.75v3.5a.75.75 0 01-1.5 0v-3.5A.75.75 0 0110 5zm0 9a1 1 0 100-2 1 1 0 000 2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ExclamationTriangleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EyeDropperIcon.js
var require_EyeDropperIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EyeDropperIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function EyeDropperIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M12.1 3.667a3.502 3.502 0 116.782 1.738 3.487 3.487 0 01-.907 1.57 3.495 3.495 0 01-1.617.919L16 7.99V10a.75.75 0 01-.22.53l-.25.25a.75.75 0 01-1.06 0l-.845-.844L7.22 16.34A2.25 2.25 0 015.629 17H5.12a.75.75 0 00-.53.22l-1.56 1.56a.75.75 0 01-1.061 0l-.75-.75a.75.75 0 010-1.06l1.56-1.561a.75.75 0 00.22-.53v-.508c0-.596.237-1.169.659-1.59l6.405-6.406-.844-.845a.75.75 0 010-1.06l.25-.25A.75.75 0 0110 4h2.01l.09-.333zM4.72 13.84l6.405-6.405 1.44 1.439-6.406 6.405a.75.75 0 01-.53.22H5.12c-.258 0-.511.044-.75.129a2.25 2.25 0 00.129-.75v-.508a.75.75 0 01.22-.53z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(EyeDropperIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EyeSlashIcon.js
var require_EyeSlashIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EyeSlashIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function EyeSlashIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3.28 2.22a.75.75 0 00-1.06 1.06l14.5 14.5a.75.75 0 101.06-1.06l-1.745-1.745a10.029 10.029 0 003.3-4.38 1.651 1.651 0 000-1.185A10.004 10.004 0 009.999 3a9.956 9.956 0 00-4.744 1.194L3.28 2.22zM7.752 6.69l1.092 1.092a2.5 2.5 0 013.374 3.373l1.091 1.092a4 4 0 00-5.557-5.557z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M10.748 13.93l2.523 2.523a9.987 9.987 0 01-3.27.547c-4.258 0-7.894-2.66-9.337-6.41a1.651 1.651 0 010-1.186A10.007 10.007 0 012.839 6.02L6.07 9.252a4 4 0 004.678 4.678z"
      }));
    }
    var ForwardRef = React.forwardRef(EyeSlashIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EyeIcon.js
var require_EyeIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/EyeIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function EyeIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10 12.5a2.5 2.5 0 100-5 2.5 2.5 0 000 5z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M.664 10.59a1.651 1.651 0 010-1.186A10.004 10.004 0 0110 3c4.257 0 7.893 2.66 9.336 6.41.147.381.146.804 0 1.186A10.004 10.004 0 0110 17c-4.257 0-7.893-2.66-9.336-6.41zM14 10a4 4 0 11-8 0 4 4 0 018 0z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(EyeIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FaceFrownIcon.js
var require_FaceFrownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FaceFrownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function FaceFrownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zm-3.536-3.475a.75.75 0 001.061 0 3.5 3.5 0 014.95 0 .75.75 0 101.06-1.06 5 5 0 00-7.07 0 .75.75 0 000 1.06zM9 8.5c0 .828-.448 1.5-1 1.5s-1-.672-1-1.5S7.448 7 8 7s1 .672 1 1.5zm3 1.5c.552 0 1-.672 1-1.5S12.552 7 12 7s-1 .672-1 1.5.448 1.5 1 1.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(FaceFrownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FaceSmileIcon.js
var require_FaceSmileIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FaceSmileIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function FaceSmileIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zm3.536-4.464a.75.75 0 10-1.061-1.061 3.5 3.5 0 01-4.95 0 .75.75 0 00-1.06 1.06 5 5 0 007.07 0zM9 8.5c0 .828-.448 1.5-1 1.5s-1-.672-1-1.5S7.448 7 8 7s1 .672 1 1.5zm3 1.5c.552 0 1-.672 1-1.5S12.552 7 12 7s-1 .672-1 1.5.448 1.5 1 1.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(FaceSmileIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FilmIcon.js
var require_FilmIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FilmIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function FilmIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1 4.75C1 3.784 1.784 3 2.75 3h14.5c.966 0 1.75.784 1.75 1.75v10.515a1.75 1.75 0 01-1.75 1.75h-1.5c-.078 0-.155-.005-.23-.015H4.48c-.075.01-.152.015-.23.015h-1.5A1.75 1.75 0 011 15.265V4.75zm16.5 7.385V11.01a.25.25 0 00-.25-.25h-1.5a.25.25 0 00-.25.25v1.125c0 .138.112.25.25.25h1.5a.25.25 0 00.25-.25zm0 2.005a.25.25 0 00-.25-.25h-1.5a.25.25 0 00-.25.25v1.125c0 .108.069.2.165.235h1.585a.25.25 0 00.25-.25v-1.11zm-15 1.11v-1.11a.25.25 0 01.25-.25h1.5a.25.25 0 01.25.25v1.125a.25.25 0 01-.164.235H2.75a.25.25 0 01-.25-.25zm2-4.24v1.125a.25.25 0 01-.25.25h-1.5a.25.25 0 01-.25-.25V11.01a.25.25 0 01.25-.25h1.5a.25.25 0 01.25.25zm13-2.005V7.88a.25.25 0 00-.25-.25h-1.5a.25.25 0 00-.25.25v1.125c0 .138.112.25.25.25h1.5a.25.25 0 00.25-.25zM4.25 7.63a.25.25 0 01.25.25v1.125a.25.25 0 01-.25.25h-1.5a.25.25 0 01-.25-.25V7.88a.25.25 0 01.25-.25h1.5zm0-3.13a.25.25 0 01.25.25v1.125a.25.25 0 01-.25.25h-1.5a.25.25 0 01-.25-.25V4.75a.25.25 0 01.25-.25h1.5zm11.5 1.625a.25.25 0 01-.25-.25V4.75a.25.25 0 01.25-.25h1.5a.25.25 0 01.25.25v1.125a.25.25 0 01-.25.25h-1.5zm-9 3.125a.75.75 0 000 1.5h6.5a.75.75 0 000-1.5h-6.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(FilmIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FingerPrintIcon.js
var require_FingerPrintIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FingerPrintIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function FingerPrintIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 2.5c-1.31 0-2.526.386-3.546 1.051a.75.75 0 01-.82-1.256A8 8 0 0118 9a22.47 22.47 0 01-1.228 7.351.75.75 0 11-1.417-.49A20.97 20.97 0 0016.5 9 6.5 6.5 0 0010 2.5zM4.333 4.416a.75.75 0 01.218 1.038A6.466 6.466 0 003.5 9a7.966 7.966 0 01-1.293 4.362.75.75 0 01-1.257-.819A6.466 6.466 0 002 9c0-1.61.476-3.11 1.295-4.365a.75.75 0 011.038-.219zM10 6.12a3 3 0 00-3.001 3.041 11.455 11.455 0 01-2.697 7.24.75.75 0 01-1.148-.965A9.957 9.957 0 005.5 9c0-.028.002-.055.004-.082a4.5 4.5 0 018.996.084V9.15l-.005.297a.75.75 0 11-1.5-.034c.003-.11.004-.219.005-.328a3 3 0 00-3-2.965zm0 2.13a.75.75 0 01.75.75c0 3.51-1.187 6.745-3.181 9.323a.75.75 0 11-1.186-.918A13.687 13.687 0 009.25 9a.75.75 0 01.75-.75zm3.529 3.698a.75.75 0 01.584.885 18.883 18.883 0 01-2.257 5.84.75.75 0 11-1.29-.764 17.386 17.386 0 002.078-5.377.75.75 0 01.885-.584z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(FingerPrintIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FireIcon.js
var require_FireIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FireIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function FireIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M13.5 4.938a7 7 0 11-9.006 1.737c.202-.257.59-.218.793.039.278.352.594.672.943.954.332.269.786-.049.773-.476a5.977 5.977 0 01.572-2.759 6.026 6.026 0 012.486-2.665c.247-.14.55-.016.677.238A6.967 6.967 0 0013.5 4.938zM14 12a4 4 0 01-4 4c-1.913 0-3.52-1.398-3.91-3.182-.093-.429.44-.643.814-.413a4.043 4.043 0 001.601.564c.303.038.531-.24.51-.544a5.975 5.975 0 011.315-4.192.447.447 0 01.431-.16A4.001 4.001 0 0114 12z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(FireIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FlagIcon.js
var require_FlagIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FlagIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function FlagIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3.5 2.75a.75.75 0 00-1.5 0v14.5a.75.75 0 001.5 0v-4.392l1.657-.348a6.449 6.449 0 014.271.572 7.948 7.948 0 005.965.524l2.078-.64A.75.75 0 0018 12.25v-8.5a.75.75 0 00-.904-.734l-2.38.501a7.25 7.25 0 01-4.186-.363l-.502-.2a8.75 8.75 0 00-5.053-.439l-1.475.31V2.75z"
      }));
    }
    var ForwardRef = React.forwardRef(FlagIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FolderArrowDownIcon.js
var require_FolderArrowDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FolderArrowDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function FolderArrowDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 4.75C2 3.784 2.784 3 3.75 3h4.836c.464 0 .909.184 1.237.513l1.414 1.414a.25.25 0 00.177.073h4.836c.966 0 1.75.784 1.75 1.75v8.5A1.75 1.75 0 0116.25 17H3.75A1.75 1.75 0 012 15.25V4.75zm8.75 4a.75.75 0 00-1.5 0v2.546l-.943-1.048a.75.75 0 10-1.114 1.004l2.25 2.5a.75.75 0 001.114 0l2.25-2.5a.75.75 0 10-1.114-1.004l-.943 1.048V8.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(FolderArrowDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FolderMinusIcon.js
var require_FolderMinusIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FolderMinusIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function FolderMinusIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 4.75C2 3.784 2.784 3 3.75 3h4.836c.464 0 .909.184 1.237.513l1.414 1.414a.25.25 0 00.177.073h4.836c.966 0 1.75.784 1.75 1.75v8.5A1.75 1.75 0 0116.25 17H3.75A1.75 1.75 0 012 15.25V4.75zm10.25 7a.75.75 0 000-1.5h-4.5a.75.75 0 000 1.5h4.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(FolderMinusIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FolderOpenIcon.js
var require_FolderOpenIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FolderOpenIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function FolderOpenIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M4.75 3A1.75 1.75 0 003 4.75v2.752l.104-.002h13.792c.035 0 .07 0 .104.002V6.75A1.75 1.75 0 0015.25 5h-3.836a.25.25 0 01-.177-.073L9.823 3.513A1.75 1.75 0 008.586 3H4.75zM3.104 9a1.75 1.75 0 00-1.673 2.265l1.385 4.5A1.75 1.75 0 004.488 17h11.023a1.75 1.75 0 001.673-1.235l1.384-4.5A1.75 1.75 0 0016.896 9H3.104z"
      }));
    }
    var ForwardRef = React.forwardRef(FolderOpenIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FolderPlusIcon.js
var require_FolderPlusIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FolderPlusIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function FolderPlusIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3.75 3A1.75 1.75 0 002 4.75v10.5c0 .966.784 1.75 1.75 1.75h12.5A1.75 1.75 0 0018 15.25v-8.5A1.75 1.75 0 0016.25 5h-4.836a.25.25 0 01-.177-.073L9.823 3.513A1.75 1.75 0 008.586 3H3.75zM10 8a.75.75 0 01.75.75v1.5h1.5a.75.75 0 010 1.5h-1.5v1.5a.75.75 0 01-1.5 0v-1.5h-1.5a.75.75 0 010-1.5h1.5v-1.5A.75.75 0 0110 8z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(FolderPlusIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FolderIcon.js
var require_FolderIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FolderIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function FolderIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3.75 3A1.75 1.75 0 002 4.75v3.26a3.235 3.235 0 011.75-.51h12.5c.644 0 1.245.188 1.75.51V6.75A1.75 1.75 0 0016.25 5h-4.836a.25.25 0 01-.177-.073L9.823 3.513A1.75 1.75 0 008.586 3H3.75zM3.75 9A1.75 1.75 0 002 10.75v4.5c0 .966.784 1.75 1.75 1.75h12.5A1.75 1.75 0 0018 15.25v-4.5A1.75 1.75 0 0016.25 9H3.75z"
      }));
    }
    var ForwardRef = React.forwardRef(FolderIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ForwardIcon.js
var require_ForwardIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ForwardIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ForwardIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3.288 4.819A1.5 1.5 0 001 6.095v7.81a1.5 1.5 0 002.288 1.277l6.323-3.905c.155-.096.285-.213.389-.344v2.973a1.5 1.5 0 002.288 1.276l6.323-3.905a1.5 1.5 0 000-2.553L12.288 4.82A1.5 1.5 0 0010 6.095v2.973a1.506 1.506 0 00-.389-.344L3.288 4.82z"
      }));
    }
    var ForwardRef = React.forwardRef(ForwardIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FunnelIcon.js
var require_FunnelIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/FunnelIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function FunnelIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2.628 1.601C5.028 1.206 7.49 1 10 1s4.973.206 7.372.601a.75.75 0 01.628.74v2.288a2.25 2.25 0 01-.659 1.59l-4.682 4.683a2.25 2.25 0 00-.659 1.59v3.037c0 .684-.31 1.33-.844 1.757l-1.937 1.55A.75.75 0 018 18.25v-5.757a2.25 2.25 0 00-.659-1.591L2.659 6.22A2.25 2.25 0 012 4.629V2.34a.75.75 0 01.628-.74z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(FunnelIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GifIcon.js
var require_GifIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GifIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function GifIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1 5.25A2.25 2.25 0 013.25 3h13.5A2.25 2.25 0 0119 5.25v9.5A2.25 2.25 0 0116.75 17H3.25A2.25 2.25 0 011 14.75v-9.5zm4.026 2.879C5.356 7.65 5.72 7.5 6 7.5s.643.15.974.629a.75.75 0 001.234-.854C7.66 6.484 6.873 6 6 6c-.873 0-1.66.484-2.208 1.275C3.25 8.059 3 9.048 3 10c0 .952.25 1.941.792 2.725C4.34 13.516 5.127 14 6 14c.873 0 1.66-.484 2.208-1.275a.75.75 0 00.133-.427V10a.75.75 0 00-.75-.75H6.25a.75.75 0 000 1.5h.591v1.295c-.293.342-.6.455-.841.455-.279 0-.643-.15-.974-.629C4.69 11.386 4.5 10.711 4.5 10c0-.711.19-1.386.526-1.871zM10.75 6a.75.75 0 01.75.75v6.5a.75.75 0 01-1.5 0v-6.5a.75.75 0 01.75-.75zm3 0h2.5a.75.75 0 010 1.5H14.5v1.75h.75a.75.75 0 010 1.5h-.75v2.5a.75.75 0 01-1.5 0v-6.5a.75.75 0 01.75-.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(GifIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GiftTopIcon.js
var require_GiftTopIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GiftTopIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function GiftTopIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M9.25 3H3.5A1.5 1.5 0 002 4.5v4.75h3.365A2.75 2.75 0 019.25 5.362V3zM2 10.75v4.75A1.5 1.5 0 003.5 17h5.75v-4.876A4.75 4.75 0 015 14.75a.75.75 0 010-1.5 3.251 3.251 0 003.163-2.5H2zM10.75 17h5.75a1.5 1.5 0 001.5-1.5v-4.75h-6.163A3.251 3.251 0 0015 13.25a.75.75 0 010 1.5 4.75 4.75 0 01-4.25-2.626V17zM18 9.25V4.5A1.5 1.5 0 0016.5 3h-5.75v2.362a2.75 2.75 0 013.885 3.888H18zm-4.496-2.755a1.25 1.25 0 00-1.768 0c-.36.359-.526.999-.559 1.697-.01.228-.006.443.004.626.183.01.398.014.626.003.698-.033 1.338-.2 1.697-.559a1.25 1.25 0 000-1.767zm-5.24 0a1.25 1.25 0 00-1.768 1.767c.36.36 1 .526 1.697.56.228.01.443.006.626-.004.01-.183.015-.398.004-.626-.033-.698-.2-1.338-.56-1.697z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(GiftTopIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GiftIcon.js
var require_GiftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GiftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function GiftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M14 6a2.5 2.5 0 00-4-3 2.5 2.5 0 00-4 3H3.25C2.56 6 2 6.56 2 7.25v.5C2 8.44 2.56 9 3.25 9h6V6h1.5v3h6C17.44 9 18 8.44 18 7.75v-.5C18 6.56 17.44 6 16.75 6H14zm-1-1.5a1 1 0 01-1 1h-1v-1a1 1 0 112 0zm-6 0a1 1 0 001 1h1v-1a1 1 0 00-2 0z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M9.25 10.5H3v4.75A2.75 2.75 0 005.75 18h3.5v-7.5zM10.75 18v-7.5H17v4.75A2.75 2.75 0 0114.25 18h-3.5z"
      }));
    }
    var ForwardRef = React.forwardRef(GiftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GlobeAltIcon.js
var require_GlobeAltIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GlobeAltIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function GlobeAltIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M16.555 5.412a8.028 8.028 0 00-3.503-2.81 14.899 14.899 0 011.663 4.472 8.547 8.547 0 001.84-1.662zM13.326 7.825a13.43 13.43 0 00-2.413-5.773 8.087 8.087 0 00-1.826 0 13.43 13.43 0 00-2.413 5.773A8.473 8.473 0 0010 8.5c1.18 0 2.304-.24 3.326-.675zM6.514 9.376A9.98 9.98 0 0010 10c1.226 0 2.4-.22 3.486-.624a13.54 13.54 0 01-.351 3.759A13.54 13.54 0 0110 13.5c-1.079 0-2.128-.127-3.134-.366a13.538 13.538 0 01-.352-3.758zM5.285 7.074a14.9 14.9 0 011.663-4.471 8.028 8.028 0 00-3.503 2.81c.529.638 1.149 1.199 1.84 1.66zM17.334 6.798a7.973 7.973 0 01.614 4.115 13.47 13.47 0 01-3.178 1.72 15.093 15.093 0 00.174-3.939 10.043 10.043 0 002.39-1.896zM2.666 6.798a10.042 10.042 0 002.39 1.896 15.196 15.196 0 00.174 3.94 13.472 13.472 0 01-3.178-1.72 7.973 7.973 0 01.615-4.115zM10 15c.898 0 1.778-.079 2.633-.23a13.473 13.473 0 01-1.72 3.178 8.099 8.099 0 01-1.826 0 13.47 13.47 0 01-1.72-3.178c.855.151 1.735.23 2.633.23zM14.357 14.357a14.912 14.912 0 01-1.305 3.04 8.027 8.027 0 004.345-4.345c-.953.542-1.971.981-3.04 1.305zM6.948 17.397a8.027 8.027 0 01-4.345-4.345c.953.542 1.971.981 3.04 1.305a14.912 14.912 0 001.305 3.04z"
      }));
    }
    var ForwardRef = React.forwardRef(GlobeAltIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GlobeAmericasIcon.js
var require_GlobeAmericasIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GlobeAmericasIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function GlobeAmericasIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-1.5 0a6.5 6.5 0 11-11-4.69v.447a3.5 3.5 0 001.025 2.475L8.293 10 8 10.293a1 1 0 000 1.414l1.06 1.06a1.5 1.5 0 01.44 1.061v.363a1 1 0 00.553.894l.276.139a1 1 0 001.342-.448l1.454-2.908a1.5 1.5 0 00-.281-1.731l-.772-.772a1 1 0 00-1.023-.242l-.384.128a.5.5 0 01-.606-.25l-.296-.592a.481.481 0 01.646-.646l.262.131a1 1 0 00.447.106h.188a1 1 0 00.949-1.316l-.068-.204a.5.5 0 01.149-.538l1.44-1.234A6.492 6.492 0 0116.5 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(GlobeAmericasIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GlobeAsiaAustraliaIcon.js
var require_GlobeAsiaAustraliaIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GlobeAsiaAustraliaIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function GlobeAsiaAustraliaIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-6.5 6.326a6.52 6.52 0 01-1.5.174 6.487 6.487 0 01-5.011-2.36l.49-.98a.423.423 0 01.614-.164l.294.196a.992.992 0 001.491-1.139l-.197-.593a.252.252 0 01.126-.304l1.973-.987a.938.938 0 00.361-1.359.375.375 0 01.239-.576l.125-.025A2.421 2.421 0 0012.327 6.6l.05-.149a1 1 0 00-.242-1.023l-1.489-1.489a.5.5 0 01-.146-.353v-.067a6.5 6.5 0 015.392 9.23 1.398 1.398 0 00-.68-.244l-.566-.566a1.5 1.5 0 00-1.06-.439h-.172a1.5 1.5 0 00-1.06.44l-.593.592a.501.501 0 01-.13.093l-1.578.79a1 1 0 00-.553.894v.191a1 1 0 001 1h.5a.5.5 0 01.5.5v.326z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(GlobeAsiaAustraliaIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GlobeEuropeAfricaIcon.js
var require_GlobeEuropeAfricaIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/GlobeEuropeAfricaIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function GlobeEuropeAfricaIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-1.503.204A6.5 6.5 0 117.95 3.83L6.927 5.62a1.453 1.453 0 001.91 2.02l.175-.087a.5.5 0 01.224-.053h.146a.5.5 0 01.447.724l-.028.055a.4.4 0 01-.357.221h-.502a2.26 2.26 0 00-1.88 1.006l-.044.066a2.099 2.099 0 001.085 3.156.58.58 0 01.397.547v1.05a1.175 1.175 0 002.093.734l1.611-2.014c.192-.24.296-.536.296-.842 0-.316.128-.624.353-.85a1.363 1.363 0 00.173-1.716l-.464-.696a.369.369 0 01.527-.499l.343.257c.316.237.738.275 1.091.098a.586.586 0 01.677.11l1.297 1.297z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(GlobeEuropeAfricaIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HandRaisedIcon.js
var require_HandRaisedIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HandRaisedIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function HandRaisedIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M11 2a1 1 0 10-2 0v6.5a.5.5 0 01-1 0V3a1 1 0 10-2 0v5.5a.5.5 0 01-1 0V5a1 1 0 10-2 0v7a7 7 0 1014 0V8a1 1 0 10-2 0v3.5a.5.5 0 01-1 0V3a1 1 0 10-2 0v5.5a.5.5 0 01-1 0V2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(HandRaisedIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HandThumbDownIcon.js
var require_HandThumbDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HandThumbDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function HandThumbDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M18.905 12.75a1.25 1.25 0 01-2.5 0v-7.5a1.25 1.25 0 112.5 0v7.5zM8.905 17v1.3c0 .268-.14.526-.395.607A2 2 0 015.905 17c0-.995.182-1.948.514-2.826.204-.54-.166-1.174-.744-1.174h-2.52c-1.242 0-2.26-1.01-2.146-2.247.193-2.08.652-4.082 1.341-5.974C2.752 3.678 3.833 3 5.005 3h3.192a3 3 0 011.342.317l2.733 1.366A3 3 0 0013.613 5h1.292v7h-.963c-.684 0-1.258.482-1.612 1.068a4.012 4.012 0 01-2.165 1.73c-.433.143-.854.386-1.012.814-.16.432-.248.9-.248 1.388z"
      }));
    }
    var ForwardRef = React.forwardRef(HandThumbDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HandThumbUpIcon.js
var require_HandThumbUpIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HandThumbUpIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function HandThumbUpIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M1 8.25a1.25 1.25 0 112.5 0v7.5a1.25 1.25 0 11-2.5 0v-7.5zM11 3V1.7c0-.268.14-.526.395-.607A2 2 0 0114 3c0 .995-.182 1.948-.514 2.826-.204.54.166 1.174.744 1.174h2.52c1.243 0 2.261 1.01 2.146 2.247a23.864 23.864 0 01-1.341 5.974C17.153 16.323 16.072 17 14.9 17h-3.192a3 3 0 01-1.341-.317l-2.734-1.366A3 3 0 006.292 15H5V8h.963c.685 0 1.258-.483 1.612-1.068a4.011 4.011 0 012.166-1.73c.432-.143.853-.386 1.011-.814.16-.432.248-.9.248-1.388z"
      }));
    }
    var ForwardRef = React.forwardRef(HandThumbUpIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HashtagIcon.js
var require_HashtagIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HashtagIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function HashtagIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M9.493 2.853a.75.75 0 00-1.486-.205L7.545 6H4.198a.75.75 0 000 1.5h3.14l-.69 5H3.302a.75.75 0 000 1.5h3.14l-.435 3.148a.75.75 0 001.486.205L7.955 14h2.986l-.434 3.148a.75.75 0 001.486.205L12.456 14h3.346a.75.75 0 000-1.5h-3.14l.69-5h3.346a.75.75 0 000-1.5h-3.14l.435-3.147a.75.75 0 00-1.486-.205L12.045 6H9.059l.434-3.147zM8.852 7.5l-.69 5h2.986l.69-5H8.852z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(HashtagIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HeartIcon.js
var require_HeartIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HeartIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function HeartIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M9.653 16.915l-.005-.003-.019-.01a20.759 20.759 0 01-1.162-.682 22.045 22.045 0 01-2.582-1.9C4.045 12.733 2 10.352 2 7.5a4.5 4.5 0 018-2.828A4.5 4.5 0 0118 7.5c0 2.852-2.044 5.233-3.885 6.82a22.049 22.049 0 01-3.744 2.582l-.019.01-.005.003h-.002a.739.739 0 01-.69.001l-.002-.001z"
      }));
    }
    var ForwardRef = React.forwardRef(HeartIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HomeModernIcon.js
var require_HomeModernIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HomeModernIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function HomeModernIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M14.916 2.404a.75.75 0 01-.32 1.012l-.596.31V17a1 1 0 01-1 1h-2.26a.75.75 0 01-.75-.75v-3.5a.75.75 0 00-.75-.75H6.75a.75.75 0 00-.75.75v3.5a.75.75 0 01-.75.75h-3.5a.75.75 0 010-1.5H2V9.957a.75.75 0 01-.596-1.372L2 8.275V5.75a.75.75 0 011.5 0v1.745l10.404-5.41a.75.75 0 011.012.32zM15.861 8.57a.75.75 0 01.736-.025l1.999 1.04A.75.75 0 0118 10.957V16.5h.25a.75.75 0 110 1.5h-2a.75.75 0 01-.75-.75V9.21a.75.75 0 01.361-.64z"
      }));
    }
    var ForwardRef = React.forwardRef(HomeModernIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HomeIcon.js
var require_HomeIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/HomeIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function HomeIcon2({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M9.293 2.293a1 1 0 011.414 0l7 7A1 1 0 0117 11h-1v6a1 1 0 01-1 1h-2a1 1 0 01-1-1v-3a1 1 0 00-1-1H9a1 1 0 00-1 1v3a1 1 0 01-1 1H5a1 1 0 01-1-1v-6H3a1 1 0 01-.707-1.707l7-7z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(HomeIcon2);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/IdentificationIcon.js
var require_IdentificationIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/IdentificationIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function IdentificationIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1 6a3 3 0 013-3h12a3 3 0 013 3v8a3 3 0 01-3 3H4a3 3 0 01-3-3V6zm4 1.5a2 2 0 114 0 2 2 0 01-4 0zm2 3a4 4 0 00-3.665 2.395.75.75 0 00.416 1A8.98 8.98 0 007 14.5a8.98 8.98 0 003.249-.604.75.75 0 00.416-1.001A4.001 4.001 0 007 10.5zm5-3.75a.75.75 0 01.75-.75h2.5a.75.75 0 010 1.5h-2.5a.75.75 0 01-.75-.75zm0 6.5a.75.75 0 01.75-.75h2.5a.75.75 0 010 1.5h-2.5a.75.75 0 01-.75-.75zm.75-4a.75.75 0 000 1.5h2.5a.75.75 0 000-1.5h-2.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(IdentificationIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/InboxArrowDownIcon.js
var require_InboxArrowDownIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/InboxArrowDownIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function InboxArrowDownIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10 2a.75.75 0 01.75.75v5.59l1.95-2.1a.75.75 0 111.1 1.02l-3.25 3.5a.75.75 0 01-1.1 0L6.2 7.26a.75.75 0 111.1-1.02l1.95 2.1V2.75A.75.75 0 0110 2z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M5.273 4.5a1.25 1.25 0 00-1.205.918l-1.523 5.52c-.006.02-.01.041-.015.062H6a1 1 0 01.894.553l.448.894a1 1 0 00.894.553h3.438a1 1 0 00.86-.49l.606-1.02A1 1 0 0114 11h3.47a1.318 1.318 0 00-.015-.062l-1.523-5.52a1.25 1.25 0 00-1.205-.918h-.977a.75.75 0 010-1.5h.977a2.75 2.75 0 012.651 2.019l1.523 5.52c.066.239.099.485.099.732V15a2 2 0 01-2 2H3a2 2 0 01-2-2v-3.73c0-.246.033-.492.099-.73l1.523-5.521A2.75 2.75 0 015.273 3h.977a.75.75 0 010 1.5h-.977z"
      }));
    }
    var ForwardRef = React.forwardRef(InboxArrowDownIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/InboxStackIcon.js
var require_InboxStackIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/InboxStackIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function InboxStackIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1.045 6.954a2.75 2.75 0 01.217-.678L2.53 3.58A2.75 2.75 0 015.019 2h9.962a2.75 2.75 0 012.488 1.58l1.27 2.696c.101.216.174.444.216.678A1 1 0 0119 7.25v1.5a2.75 2.75 0 01-2.75 2.75H3.75A2.75 2.75 0 011 8.75v-1.5a1 1 0 01.045-.296zm2.843-2.736A1.25 1.25 0 015.02 3.5h9.962c.484 0 .925.28 1.13.718l.957 2.032H14a1 1 0 00-.86.49l-.606 1.02a1 1 0 01-.86.49H8.236a1 1 0 01-.894-.553l-.448-.894A1 1 0 006 6.25H2.932l.956-2.032z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M1 14a1 1 0 011-1h4a1 1 0 01.894.553l.448.894a1 1 0 00.894.553h3.438a1 1 0 00.86-.49l.606-1.02A1 1 0 0114 13h4a1 1 0 011 1v2a2 2 0 01-2 2H3a2 2 0 01-2-2v-2z"
      }));
    }
    var ForwardRef = React.forwardRef(InboxStackIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/InboxIcon.js
var require_InboxIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/InboxIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function InboxIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1 11.27c0-.246.033-.492.099-.73l1.523-5.521A2.75 2.75 0 015.273 3h9.454a2.75 2.75 0 012.651 2.019l1.523 5.52c.066.239.099.485.099.732V15a2 2 0 01-2 2H3a2 2 0 01-2-2v-3.73zm3.068-5.852A1.25 1.25 0 015.273 4.5h9.454a1.25 1.25 0 011.205.918l1.523 5.52c.006.02.01.041.015.062H14a1 1 0 00-.86.49l-.606 1.02a1 1 0 01-.86.49H8.236a1 1 0 01-.894-.553l-.448-.894A1 1 0 006 11H2.53l.015-.062 1.523-5.52z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(InboxIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/InformationCircleIcon.js
var require_InformationCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/InformationCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function InformationCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a.75.75 0 000 1.5h.253a.25.25 0 01.244.304l-.459 2.066A1.75 1.75 0 0010.747 15H11a.75.75 0 000-1.5h-.253a.25.25 0 01-.244-.304l.459-2.066A1.75 1.75 0 009.253 9H9z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(InformationCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/KeyIcon.js
var require_KeyIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/KeyIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function KeyIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M8 7a5 5 0 113.61 4.804l-1.903 1.903A1 1 0 019 14H8v1a1 1 0 01-1 1H6v1a1 1 0 01-1 1H3a1 1 0 01-1-1v-2a1 1 0 01.293-.707L8.196 8.39A5.002 5.002 0 018 7zm5-3a.75.75 0 000 1.5A1.5 1.5 0 0114.5 7 .75.75 0 0016 7a3 3 0 00-3-3z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(KeyIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/LanguageIcon.js
var require_LanguageIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/LanguageIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function LanguageIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M7.75 2.75a.75.75 0 00-1.5 0v1.258a32.987 32.987 0 00-3.599.278.75.75 0 10.198 1.487A31.545 31.545 0 018.7 5.545 19.381 19.381 0 017 9.56a19.418 19.418 0 01-1.002-2.05.75.75 0 00-1.384.577 20.935 20.935 0 001.492 2.91 19.613 19.613 0 01-3.828 4.154.75.75 0 10.945 1.164A21.116 21.116 0 007 12.331c.095.132.192.262.29.391a.75.75 0 001.194-.91c-.204-.266-.4-.538-.59-.815a20.888 20.888 0 002.333-5.332c.31.031.618.068.924.108a.75.75 0 00.198-1.487 32.832 32.832 0 00-3.599-.278V2.75z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M13 8a.75.75 0 01.671.415l4.25 8.5a.75.75 0 11-1.342.67L15.787 16h-5.573l-.793 1.585a.75.75 0 11-1.342-.67l4.25-8.5A.75.75 0 0113 8zm2.037 6.5L13 10.427 10.964 14.5h4.073z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(LanguageIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/LifebuoyIcon.js
var require_LifebuoyIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/LifebuoyIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function LifebuoyIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M7.171 4.146l1.947 2.466a3.514 3.514 0 011.764 0l1.947-2.466a6.52 6.52 0 00-5.658 0zm8.683 3.025l-2.466 1.947c.15.578.15 1.186 0 1.764l2.466 1.947a6.52 6.52 0 000-5.658zm-3.025 8.683l-1.947-2.466c-.578.15-1.186.15-1.764 0l-1.947 2.466a6.52 6.52 0 005.658 0zM4.146 12.83l2.466-1.947a3.514 3.514 0 010-1.764L4.146 7.171a6.52 6.52 0 000 5.658zM5.63 3.297a8.01 8.01 0 018.738 0 8.031 8.031 0 012.334 2.334 8.01 8.01 0 010 8.738 8.033 8.033 0 01-2.334 2.334 8.01 8.01 0 01-8.738 0 8.032 8.032 0 01-2.334-2.334 8.01 8.01 0 010-8.738A8.03 8.03 0 015.63 3.297zm5.198 4.882a2.008 2.008 0 00-2.243.407 1.994 1.994 0 00-.407 2.243 1.993 1.993 0 00.992.992 2.008 2.008 0 002.243-.407c.176-.175.31-.374.407-.585a2.008 2.008 0 00-.407-2.243 1.993 1.993 0 00-.585-.407z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(LifebuoyIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/LightBulbIcon.js
var require_LightBulbIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/LightBulbIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function LightBulbIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10 1a6 6 0 00-3.815 10.631C7.237 12.5 8 13.443 8 14.456v.644a.75.75 0 00.572.729 6.016 6.016 0 002.856 0A.75.75 0 0012 15.1v-.644c0-1.013.762-1.957 1.815-2.825A6 6 0 0010 1zM8.863 17.414a.75.75 0 00-.226 1.483 9.066 9.066 0 002.726 0 .75.75 0 00-.226-1.483 7.553 7.553 0 01-2.274 0z"
      }));
    }
    var ForwardRef = React.forwardRef(LightBulbIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/LinkIcon.js
var require_LinkIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/LinkIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function LinkIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M12.232 4.232a2.5 2.5 0 013.536 3.536l-1.225 1.224a.75.75 0 001.061 1.06l1.224-1.224a4 4 0 00-5.656-5.656l-3 3a4 4 0 00.225 5.865.75.75 0 00.977-1.138 2.5 2.5 0 01-.142-3.667l3-3z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M11.603 7.963a.75.75 0 00-.977 1.138 2.5 2.5 0 01.142 3.667l-3 3a2.5 2.5 0 01-3.536-3.536l1.225-1.224a.75.75 0 00-1.061-1.06l-1.224 1.224a4 4 0 105.656 5.656l3-3a4 4 0 00-.225-5.865z"
      }));
    }
    var ForwardRef = React.forwardRef(LinkIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ListBulletIcon.js
var require_ListBulletIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ListBulletIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ListBulletIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M6 4.75A.75.75 0 016.75 4h10.5a.75.75 0 010 1.5H6.75A.75.75 0 016 4.75zM6 10a.75.75 0 01.75-.75h10.5a.75.75 0 010 1.5H6.75A.75.75 0 016 10zm0 5.25a.75.75 0 01.75-.75h10.5a.75.75 0 010 1.5H6.75a.75.75 0 01-.75-.75zM1.99 4.75a1 1 0 011-1H3a1 1 0 011 1v.01a1 1 0 01-1 1h-.01a1 1 0 01-1-1v-.01zM1.99 15.25a1 1 0 011-1H3a1 1 0 011 1v.01a1 1 0 01-1 1h-.01a1 1 0 01-1-1v-.01zM1.99 10a1 1 0 011-1H3a1 1 0 011 1v.01a1 1 0 01-1 1h-.01a1 1 0 01-1-1V10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ListBulletIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/LockClosedIcon.js
var require_LockClosedIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/LockClosedIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function LockClosedIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 1a4.5 4.5 0 00-4.5 4.5V9H5a2 2 0 00-2 2v6a2 2 0 002 2h10a2 2 0 002-2v-6a2 2 0 00-2-2h-.5V5.5A4.5 4.5 0 0010 1zm3 8V5.5a3 3 0 10-6 0V9h6z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(LockClosedIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/LockOpenIcon.js
var require_LockOpenIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/LockOpenIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function LockOpenIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M14.5 1A4.5 4.5 0 0010 5.5V9H3a2 2 0 00-2 2v6a2 2 0 002 2h10a2 2 0 002-2v-6a2 2 0 00-2-2h-1.5V5.5a3 3 0 116 0v2.75a.75.75 0 001.5 0V5.5A4.5 4.5 0 0014.5 1z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(LockOpenIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MagnifyingGlassCircleIcon.js
var require_MagnifyingGlassCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MagnifyingGlassCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function MagnifyingGlassCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M6.5 9a2.5 2.5 0 115 0 2.5 2.5 0 01-5 0z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zM9 5a4 4 0 102.248 7.309l1.472 1.471a.75.75 0 101.06-1.06l-1.471-1.472A4 4 0 009 5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(MagnifyingGlassCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MagnifyingGlassMinusIcon.js
var require_MagnifyingGlassMinusIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MagnifyingGlassMinusIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function MagnifyingGlassMinusIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M6.75 8.25a.75.75 0 000 1.5h4.5a.75.75 0 000-1.5h-4.5z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M9 2a7 7 0 104.391 12.452l3.329 3.328a.75.75 0 101.06-1.06l-3.328-3.329A7 7 0 009 2zM3.5 9a5.5 5.5 0 1111 0 5.5 5.5 0 01-11 0z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(MagnifyingGlassMinusIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MagnifyingGlassPlusIcon.js
var require_MagnifyingGlassPlusIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MagnifyingGlassPlusIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function MagnifyingGlassPlusIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M9 6a.75.75 0 01.75.75v1.5h1.5a.75.75 0 010 1.5h-1.5v1.5a.75.75 0 01-1.5 0v-1.5h-1.5a.75.75 0 010-1.5h1.5v-1.5A.75.75 0 019 6z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 9a7 7 0 1112.452 4.391l3.328 3.329a.75.75 0 11-1.06 1.06l-3.329-3.328A7 7 0 012 9zm7-5.5a5.5 5.5 0 100 11 5.5 5.5 0 000-11z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(MagnifyingGlassPlusIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MagnifyingGlassIcon.js
var require_MagnifyingGlassIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MagnifyingGlassIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function MagnifyingGlassIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M9 3.5a5.5 5.5 0 100 11 5.5 5.5 0 000-11zM2 9a7 7 0 1112.452 4.391l3.328 3.329a.75.75 0 11-1.06 1.06l-3.329-3.328A7 7 0 012 9z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(MagnifyingGlassIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MapPinIcon.js
var require_MapPinIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MapPinIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function MapPinIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M9.69 18.933l.003.001C9.89 19.02 10 19 10 19s.11.02.308-.066l.002-.001.006-.003.018-.008a5.741 5.741 0 00.281-.14c.186-.096.446-.24.757-.433.62-.384 1.445-.966 2.274-1.765C15.302 14.988 17 12.493 17 9A7 7 0 103 9c0 3.492 1.698 5.988 3.355 7.584a13.731 13.731 0 002.273 1.765 11.842 11.842 0 00.976.544l.062.029.018.008.006.003zM10 11.25a2.25 2.25 0 100-4.5 2.25 2.25 0 000 4.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(MapPinIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MapIcon.js
var require_MapIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MapIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function MapIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M8.157 2.175a1.5 1.5 0 00-1.147 0l-4.084 1.69A1.5 1.5 0 002 5.251v10.877a1.5 1.5 0 002.074 1.386l3.51-1.453 4.26 1.763a1.5 1.5 0 001.146 0l4.083-1.69A1.5 1.5 0 0018 14.748V3.873a1.5 1.5 0 00-2.073-1.386l-3.51 1.452-4.26-1.763zM7.58 5a.75.75 0 01.75.75v6.5a.75.75 0 01-1.5 0v-6.5A.75.75 0 017.58 5zm5.59 2.75a.75.75 0 00-1.5 0v6.5a.75.75 0 001.5 0v-6.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(MapIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MegaphoneIcon.js
var require_MegaphoneIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MegaphoneIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function MegaphoneIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M13.92 3.845a19.361 19.361 0 01-6.3 1.98C6.765 5.942 5.89 6 5 6a4 4 0 00-.504 7.969 15.974 15.974 0 001.271 3.341c.397.77 1.342 1 2.05.59l.867-.5c.726-.42.94-1.321.588-2.021-.166-.33-.315-.666-.448-1.004 1.8.358 3.511.964 5.096 1.78A17.964 17.964 0 0015 10c0-2.161-.381-4.234-1.08-6.155zM15.243 3.097A19.456 19.456 0 0116.5 10c0 2.431-.445 4.758-1.257 6.904l-.03.077a.75.75 0 001.401.537 20.902 20.902 0 001.312-5.745 1.999 1.999 0 000-3.545 20.902 20.902 0 00-1.312-5.745.75.75 0 00-1.4.537l.029.077z"
      }));
    }
    var ForwardRef = React.forwardRef(MegaphoneIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MicrophoneIcon.js
var require_MicrophoneIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MicrophoneIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function MicrophoneIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M7 4a3 3 0 016 0v6a3 3 0 11-6 0V4z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M5.5 9.643a.75.75 0 00-1.5 0V10c0 3.06 2.29 5.585 5.25 5.954V17.5h-1.5a.75.75 0 000 1.5h4.5a.75.75 0 000-1.5h-1.5v-1.546A6.001 6.001 0 0016 10v-.357a.75.75 0 00-1.5 0V10a4.5 4.5 0 01-9 0v-.357z"
      }));
    }
    var ForwardRef = React.forwardRef(MicrophoneIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MinusCircleIcon.js
var require_MinusCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MinusCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function MinusCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zM6.75 9.25a.75.75 0 000 1.5h6.5a.75.75 0 000-1.5h-6.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(MinusCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MinusSmallIcon.js
var require_MinusSmallIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MinusSmallIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function MinusSmallIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M6.75 9.25a.75.75 0 000 1.5h6.5a.75.75 0 000-1.5h-6.5z"
      }));
    }
    var ForwardRef = React.forwardRef(MinusSmallIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MinusIcon.js
var require_MinusIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MinusIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function MinusIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4 10a.75.75 0 01.75-.75h10.5a.75.75 0 010 1.5H4.75A.75.75 0 014 10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(MinusIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MoonIcon.js
var require_MoonIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MoonIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function MoonIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M7.455 2.004a.75.75 0 01.26.77 7 7 0 009.958 7.967.75.75 0 011.067.853A8.5 8.5 0 116.647 1.921a.75.75 0 01.808.083z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(MoonIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MusicalNoteIcon.js
var require_MusicalNoteIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/MusicalNoteIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function MusicalNoteIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M17.721 1.599a.75.75 0 01.279.584v11.29a2.25 2.25 0 01-1.774 2.198l-2.041.442a2.216 2.216 0 01-.938-4.333l2.662-.576a.75.75 0 00.591-.734V6.112l-8 1.73v7.684a2.25 2.25 0 01-1.774 2.2l-2.042.44a2.216 2.216 0 11-.935-4.33l2.659-.574A.75.75 0 007 12.53V4.237a.75.75 0 01.591-.733l9.5-2.054a.75.75 0 01.63.149z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(MusicalNoteIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/NewspaperIcon.js
var require_NewspaperIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/NewspaperIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function NewspaperIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 3.5A1.5 1.5 0 013.5 2h9A1.5 1.5 0 0114 3.5v11.75A2.75 2.75 0 0016.75 18h-12A2.75 2.75 0 012 15.25V3.5zm3.75 7a.75.75 0 000 1.5h4.5a.75.75 0 000-1.5h-4.5zm0 3a.75.75 0 000 1.5h4.5a.75.75 0 000-1.5h-4.5zM5 5.75A.75.75 0 015.75 5h4.5a.75.75 0 01.75.75v2.5a.75.75 0 01-.75.75h-4.5A.75.75 0 015 8.25v-2.5z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M16.5 6.5h-1v8.75a1.25 1.25 0 102.5 0V8a1.5 1.5 0 00-1.5-1.5z"
      }));
    }
    var ForwardRef = React.forwardRef(NewspaperIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/NoSymbolIcon.js
var require_NoSymbolIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/NoSymbolIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function NoSymbolIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5.965 4.904l9.131 9.131a6.5 6.5 0 00-9.131-9.131zm8.07 10.192L4.904 5.965a6.5 6.5 0 009.131 9.131zM4.343 4.343a8 8 0 1111.314 11.314A8 8 0 014.343 4.343z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(NoSymbolIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PaintBrushIcon.js
var require_PaintBrushIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PaintBrushIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PaintBrushIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M15.993 1.385a1.87 1.87 0 012.623 2.622l-4.03 5.27a12.749 12.749 0 01-4.237 3.562 4.508 4.508 0 00-3.188-3.188 12.75 12.75 0 013.562-4.236l5.27-4.03zM6 11a3 3 0 00-3 3 .5.5 0 01-.72.45.75.75 0 00-1.035.931A4.001 4.001 0 009 14.004V14a3.01 3.01 0 00-1.66-2.685A2.99 2.99 0 006 11z"
      }));
    }
    var ForwardRef = React.forwardRef(PaintBrushIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PaperAirplaneIcon.js
var require_PaperAirplaneIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PaperAirplaneIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PaperAirplaneIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3.105 2.289a.75.75 0 00-.826.95l1.414 4.925A1.5 1.5 0 005.135 9.25h6.115a.75.75 0 010 1.5H5.135a1.5 1.5 0 00-1.442 1.086l-1.414 4.926a.75.75 0 00.826.95 28.896 28.896 0 0015.293-7.154.75.75 0 000-1.115A28.897 28.897 0 003.105 2.289z"
      }));
    }
    var ForwardRef = React.forwardRef(PaperAirplaneIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PaperClipIcon.js
var require_PaperClipIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PaperClipIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PaperClipIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M15.621 4.379a3 3 0 00-4.242 0l-7 7a3 3 0 004.241 4.243h.001l.497-.5a.75.75 0 011.064 1.057l-.498.501-.002.002a4.5 4.5 0 01-6.364-6.364l7-7a4.5 4.5 0 016.368 6.36l-3.455 3.553A2.625 2.625 0 119.52 9.52l3.45-3.451a.75.75 0 111.061 1.06l-3.45 3.451a1.125 1.125 0 001.587 1.595l3.454-3.553a3 3 0 000-4.242z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(PaperClipIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PauseCircleIcon.js
var require_PauseCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PauseCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PauseCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 10a8 8 0 1116 0 8 8 0 01-16 0zm5-2.25A.75.75 0 017.75 7h.5a.75.75 0 01.75.75v4.5a.75.75 0 01-.75.75h-.5a.75.75 0 01-.75-.75v-4.5zm4 0a.75.75 0 01.75-.75h.5a.75.75 0 01.75.75v4.5a.75.75 0 01-.75.75h-.5a.75.75 0 01-.75-.75v-4.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(PauseCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PauseIcon.js
var require_PauseIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PauseIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PauseIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M5.75 3a.75.75 0 00-.75.75v12.5c0 .414.336.75.75.75h1.5a.75.75 0 00.75-.75V3.75A.75.75 0 007.25 3h-1.5zM12.75 3a.75.75 0 00-.75.75v12.5c0 .414.336.75.75.75h1.5a.75.75 0 00.75-.75V3.75a.75.75 0 00-.75-.75h-1.5z"
      }));
    }
    var ForwardRef = React.forwardRef(PauseIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PencilSquareIcon.js
var require_PencilSquareIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PencilSquareIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PencilSquareIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M5.433 13.917l1.262-3.155A4 4 0 017.58 9.42l6.92-6.918a2.121 2.121 0 013 3l-6.92 6.918c-.383.383-.84.685-1.343.886l-3.154 1.262a.5.5 0 01-.65-.65z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M3.5 5.75c0-.69.56-1.25 1.25-1.25H10A.75.75 0 0010 3H4.75A2.75 2.75 0 002 5.75v9.5A2.75 2.75 0 004.75 18h9.5A2.75 2.75 0 0017 15.25V10a.75.75 0 00-1.5 0v5.25c0 .69-.56 1.25-1.25 1.25h-9.5c-.69 0-1.25-.56-1.25-1.25v-9.5z"
      }));
    }
    var ForwardRef = React.forwardRef(PencilSquareIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PencilIcon.js
var require_PencilIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PencilIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PencilIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M2.695 14.763l-1.262 3.154a.5.5 0 00.65.65l3.155-1.262a4 4 0 001.343-.885L17.5 5.5a2.121 2.121 0 00-3-3L3.58 13.42a4 4 0 00-.885 1.343z"
      }));
    }
    var ForwardRef = React.forwardRef(PencilIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PhoneArrowDownLeftIcon.js
var require_PhoneArrowDownLeftIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PhoneArrowDownLeftIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PhoneArrowDownLeftIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3.5 2A1.5 1.5 0 002 3.5V5c0 1.149.15 2.263.43 3.326a13.022 13.022 0 009.244 9.244c1.063.28 2.177.43 3.326.43h1.5a1.5 1.5 0 001.5-1.5v-1.148a1.5 1.5 0 00-1.175-1.465l-3.223-.716a1.5 1.5 0 00-1.767 1.052l-.267.933c-.117.41-.555.643-.95.48a11.542 11.542 0 01-6.254-6.254c-.163-.395.07-.833.48-.95l.933-.267a1.5 1.5 0 001.052-1.767l-.716-3.223A1.5 1.5 0 004.648 2H3.5zM16.72 2.22a.75.75 0 111.06 1.06L14.56 6.5h2.69a.75.75 0 010 1.5h-4.5a.75.75 0 01-.75-.75v-4.5a.75.75 0 011.5 0v2.69l3.22-3.22z"
      }));
    }
    var ForwardRef = React.forwardRef(PhoneArrowDownLeftIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PhoneArrowUpRightIcon.js
var require_PhoneArrowUpRightIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PhoneArrowUpRightIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PhoneArrowUpRightIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3.5 2A1.5 1.5 0 002 3.5V5c0 1.149.15 2.263.43 3.326a13.022 13.022 0 009.244 9.244c1.063.28 2.177.43 3.326.43h1.5a1.5 1.5 0 001.5-1.5v-1.148a1.5 1.5 0 00-1.175-1.465l-3.223-.716a1.5 1.5 0 00-1.767 1.052l-.267.933c-.117.41-.555.643-.95.48a11.542 11.542 0 01-6.254-6.254c-.163-.395.07-.833.48-.95l.933-.267a1.5 1.5 0 001.052-1.767l-.716-3.223A1.5 1.5 0 004.648 2H3.5zM16.5 4.56l-3.22 3.22a.75.75 0 11-1.06-1.06l3.22-3.22h-2.69a.75.75 0 010-1.5h4.5a.75.75 0 01.75.75v4.5a.75.75 0 01-1.5 0V4.56z"
      }));
    }
    var ForwardRef = React.forwardRef(PhoneArrowUpRightIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PhoneXMarkIcon.js
var require_PhoneXMarkIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PhoneXMarkIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PhoneXMarkIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3.5 2A1.5 1.5 0 002 3.5V5c0 1.149.15 2.263.43 3.326a13.022 13.022 0 009.244 9.244c1.063.28 2.177.43 3.326.43h1.5a1.5 1.5 0 001.5-1.5v-1.148a1.5 1.5 0 00-1.175-1.465l-3.223-.716a1.5 1.5 0 00-1.767 1.052l-.267.933c-.117.41-.555.643-.95.48a11.542 11.542 0 01-6.254-6.254c-.163-.395.07-.833.48-.95l.933-.267a1.5 1.5 0 001.052-1.767l-.716-3.223A1.5 1.5 0 004.648 2H3.5zm9.78.22a.75.75 0 10-1.06 1.06L13.94 5l-1.72 1.72a.75.75 0 001.06 1.06L15 6.06l1.72 1.72a.75.75 0 101.06-1.06L16.06 5l1.72-1.72a.75.75 0 00-1.06-1.06L15 3.94l-1.72-1.72z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(PhoneXMarkIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PhoneIcon.js
var require_PhoneIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PhoneIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PhoneIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 3.5A1.5 1.5 0 013.5 2h1.148a1.5 1.5 0 011.465 1.175l.716 3.223a1.5 1.5 0 01-1.052 1.767l-.933.267c-.41.117-.643.555-.48.95a11.542 11.542 0 006.254 6.254c.395.163.833-.07.95-.48l.267-.933a1.5 1.5 0 011.767-1.052l3.223.716A1.5 1.5 0 0118 15.352V16.5a1.5 1.5 0 01-1.5 1.5H15c-1.149 0-2.263-.15-3.326-.43A13.022 13.022 0 012.43 8.326 13.019 13.019 0 012 5V3.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(PhoneIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PhotoIcon.js
var require_PhotoIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PhotoIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PhotoIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1 5.25A2.25 2.25 0 013.25 3h13.5A2.25 2.25 0 0119 5.25v9.5A2.25 2.25 0 0116.75 17H3.25A2.25 2.25 0 011 14.75v-9.5zm1.5 5.81v3.69c0 .414.336.75.75.75h13.5a.75.75 0 00.75-.75v-2.69l-2.22-2.219a.75.75 0 00-1.06 0l-1.91 1.909.47.47a.75.75 0 11-1.06 1.06L6.53 8.091a.75.75 0 00-1.06 0l-2.97 2.97zM12 7a1 1 0 11-2 0 1 1 0 012 0z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(PhotoIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PlayCircleIcon.js
var require_PlayCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PlayCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PlayCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 10a8 8 0 1116 0 8 8 0 01-16 0zm6.39-2.908a.75.75 0 01.766.027l3.5 2.25a.75.75 0 010 1.262l-3.5 2.25A.75.75 0 018 12.25v-4.5a.75.75 0 01.39-.658z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(PlayCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PlayPauseIcon.js
var require_PlayPauseIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PlayPauseIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PlayPauseIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M12.75 4a.75.75 0 00-.75.75v10.5c0 .414.336.75.75.75h.5a.75.75 0 00.75-.75V4.75a.75.75 0 00-.75-.75h-.5zM17.75 4a.75.75 0 00-.75.75v10.5c0 .414.336.75.75.75h.5a.75.75 0 00.75-.75V4.75a.75.75 0 00-.75-.75h-.5zM3.288 4.819A1.5 1.5 0 001 6.095v7.81a1.5 1.5 0 002.288 1.277l6.323-3.906a1.5 1.5 0 000-2.552L3.288 4.819z"
      }));
    }
    var ForwardRef = React.forwardRef(PlayPauseIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PlayIcon.js
var require_PlayIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PlayIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PlayIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M6.3 2.841A1.5 1.5 0 004 4.11V15.89a1.5 1.5 0 002.3 1.269l9.344-5.89a1.5 1.5 0 000-2.538L6.3 2.84z"
      }));
    }
    var ForwardRef = React.forwardRef(PlayIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PlusCircleIcon.js
var require_PlusCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PlusCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PlusCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zm.75-11.25a.75.75 0 00-1.5 0v2.5h-2.5a.75.75 0 000 1.5h2.5v2.5a.75.75 0 001.5 0v-2.5h2.5a.75.75 0 000-1.5h-2.5v-2.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(PlusCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PlusSmallIcon.js
var require_PlusSmallIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PlusSmallIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PlusSmallIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10.75 6.75a.75.75 0 00-1.5 0v2.5h-2.5a.75.75 0 000 1.5h2.5v2.5a.75.75 0 001.5 0v-2.5h2.5a.75.75 0 000-1.5h-2.5v-2.5z"
      }));
    }
    var ForwardRef = React.forwardRef(PlusSmallIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PlusIcon.js
var require_PlusIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PlusIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PlusIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10.75 4.75a.75.75 0 00-1.5 0v4.5h-4.5a.75.75 0 000 1.5h4.5v4.5a.75.75 0 001.5 0v-4.5h4.5a.75.75 0 000-1.5h-4.5v-4.5z"
      }));
    }
    var ForwardRef = React.forwardRef(PlusIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PowerIcon.js
var require_PowerIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PowerIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PowerIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 2a.75.75 0 01.75.75v7.5a.75.75 0 01-1.5 0v-7.5A.75.75 0 0110 2zM5.404 4.343a.75.75 0 010 1.06 6.5 6.5 0 109.192 0 .75.75 0 111.06-1.06 8 8 0 11-11.313 0 .75.75 0 011.06 0z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(PowerIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PresentationChartBarIcon.js
var require_PresentationChartBarIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PresentationChartBarIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PresentationChartBarIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1 2.75A.75.75 0 011.75 2h16.5a.75.75 0 010 1.5H18v8.75A2.75 2.75 0 0115.25 15h-1.072l.798 3.06a.75.75 0 01-1.452.38L13.41 18H6.59l-.114.44a.75.75 0 01-1.452-.38L5.823 15H4.75A2.75 2.75 0 012 12.25V3.5h-.25A.75.75 0 011 2.75zM7.373 15l-.391 1.5h6.037l-.392-1.5H7.373zM13.25 5a.75.75 0 01.75.75v5.5a.75.75 0 01-1.5 0v-5.5a.75.75 0 01.75-.75zm-6.5 4a.75.75 0 01.75.75v1.5a.75.75 0 01-1.5 0v-1.5A.75.75 0 016.75 9zm4-1.25a.75.75 0 00-1.5 0v3.5a.75.75 0 001.5 0v-3.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(PresentationChartBarIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PresentationChartLineIcon.js
var require_PresentationChartLineIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PresentationChartLineIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PresentationChartLineIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1 2.75A.75.75 0 011.75 2h16.5a.75.75 0 010 1.5H18v8.75A2.75 2.75 0 0115.25 15h-1.072l.798 3.06a.75.75 0 01-1.452.38L13.41 18H6.59l-.114.44a.75.75 0 01-1.452-.38L5.823 15H4.75A2.75 2.75 0 012 12.25V3.5h-.25A.75.75 0 011 2.75zM7.373 15l-.391 1.5h6.037l-.392-1.5H7.373zm7.49-8.931a.75.75 0 01-.175 1.046 19.326 19.326 0 00-3.398 3.098.75.75 0 01-1.097.04L8.5 8.561l-2.22 2.22A.75.75 0 115.22 9.72l2.75-2.75a.75.75 0 011.06 0l1.664 1.663a20.786 20.786 0 013.122-2.74.75.75 0 011.046.176z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(PresentationChartLineIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PrinterIcon.js
var require_PrinterIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PrinterIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PrinterIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5 2.75C5 1.784 5.784 1 6.75 1h6.5c.966 0 1.75.784 1.75 1.75v3.552c.377.046.752.097 1.126.153A2.212 2.212 0 0118 8.653v4.097A2.25 2.25 0 0115.75 15h-.241l.305 1.984A1.75 1.75 0 0114.084 19H5.915a1.75 1.75 0 01-1.73-2.016L4.492 15H4.25A2.25 2.25 0 012 12.75V8.653c0-1.082.775-2.034 1.874-2.198.374-.056.75-.107 1.127-.153L5 6.25v-3.5zm8.5 3.397a41.533 41.533 0 00-7 0V2.75a.25.25 0 01.25-.25h6.5a.25.25 0 01.25.25v3.397zM6.608 12.5a.25.25 0 00-.247.212l-.693 4.5a.25.25 0 00.247.288h8.17a.25.25 0 00.246-.288l-.692-4.5a.25.25 0 00-.247-.212H6.608z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(PrinterIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PuzzlePieceIcon.js
var require_PuzzlePieceIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/PuzzlePieceIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function PuzzlePieceIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M12 4.467c0-.405.262-.75.559-1.027.276-.257.441-.584.441-.94 0-.828-.895-1.5-2-1.5s-2 .672-2 1.5c0 .362.171.694.456.953.29.265.544.6.544.994a.968.968 0 01-1.024.974 39.655 39.655 0 01-3.014-.306.75.75 0 00-.847.847c.14.993.242 1.999.306 3.014A.968.968 0 014.447 10c-.393 0-.729-.253-.994-.544C3.194 9.17 2.862 9 2.5 9 1.672 9 1 9.895 1 11s.672 2 1.5 2c.356 0 .683-.165.94-.441.276-.297.622-.559 1.027-.559a.997.997 0 011.004 1.03 39.747 39.747 0 01-.319 3.734.75.75 0 00.64.842c1.05.146 2.111.252 3.184.318A.97.97 0 0010 16.948c0-.394-.254-.73-.545-.995C9.171 15.693 9 15.362 9 15c0-.828.895-1.5 2-1.5s2 .672 2 1.5c0 .356-.165.683-.441.94-.297.276-.559.622-.559 1.027a.998.998 0 001.03 1.005c1.337-.05 2.659-.162 3.961-.337a.75.75 0 00.644-.644c.175-1.302.288-2.624.337-3.961A.998.998 0 0016.967 12c-.405 0-.75.262-1.027.559-.257.276-.584.441-.94.441-.828 0-1.5-.895-1.5-2s.672-2 1.5-2c.362 0 .694.17.953.455.265.291.601.545.995.545a.97.97 0 00.976-1.024 41.159 41.159 0 00-.318-3.184.75.75 0 00-.842-.64c-1.228.164-2.473.271-3.734.319A.997.997 0 0112 4.467z"
      }));
    }
    var ForwardRef = React.forwardRef(PuzzlePieceIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/QrCodeIcon.js
var require_QrCodeIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/QrCodeIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function QrCodeIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3.75 2A1.75 1.75 0 002 3.75v3.5C2 8.216 2.784 9 3.75 9h3.5A1.75 1.75 0 009 7.25v-3.5A1.75 1.75 0 007.25 2h-3.5zM3.5 3.75a.25.25 0 01.25-.25h3.5a.25.25 0 01.25.25v3.5a.25.25 0 01-.25.25h-3.5a.25.25 0 01-.25-.25v-3.5zM3.75 11A1.75 1.75 0 002 12.75v3.5c0 .966.784 1.75 1.75 1.75h3.5A1.75 1.75 0 009 16.25v-3.5A1.75 1.75 0 007.25 11h-3.5zm-.25 1.75a.25.25 0 01.25-.25h3.5a.25.25 0 01.25.25v3.5a.25.25 0 01-.25.25h-3.5a.25.25 0 01-.25-.25v-3.5zm7.5-9c0-.966.784-1.75 1.75-1.75h3.5c.966 0 1.75.784 1.75 1.75v3.5A1.75 1.75 0 0116.25 9h-3.5A1.75 1.75 0 0111 7.25v-3.5zm1.75-.25a.25.25 0 00-.25.25v3.5c0 .138.112.25.25.25h3.5a.25.25 0 00.25-.25v-3.5a.25.25 0 00-.25-.25h-3.5zm-7.26 1a1 1 0 00-1 1v.01a1 1 0 001 1h.01a1 1 0 001-1V5.5a1 1 0 00-1-1h-.01zm9 0a1 1 0 00-1 1v.01a1 1 0 001 1h.01a1 1 0 001-1V5.5a1 1 0 00-1-1h-.01zm-9 9a1 1 0 00-1 1v.01a1 1 0 001 1h.01a1 1 0 001-1v-.01a1 1 0 00-1-1h-.01zm9 0a1 1 0 00-1 1v.01a1 1 0 001 1h.01a1 1 0 001-1v-.01a1 1 0 00-1-1h-.01zm-3.5-1.5a1 1 0 011-1H12a1 1 0 011 1v.01a1 1 0 01-1 1h-.01a1 1 0 01-1-1V12zm6-1a1 1 0 00-1 1v.01a1 1 0 001 1H17a1 1 0 001-1V12a1 1 0 00-1-1h-.01zm-1 6a1 1 0 011-1H17a1 1 0 011 1v.01a1 1 0 01-1 1h-.01a1 1 0 01-1-1V17zm-4-1a1 1 0 00-1 1v.01a1 1 0 001 1H12a1 1 0 001-1V17a1 1 0 00-1-1h-.01z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(QrCodeIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/QuestionMarkCircleIcon.js
var require_QuestionMarkCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/QuestionMarkCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function QuestionMarkCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zM8.94 6.94a.75.75 0 11-1.061-1.061 3 3 0 112.871 5.026v.345a.75.75 0 01-1.5 0v-.5c0-.72.57-1.172 1.081-1.287A1.5 1.5 0 108.94 6.94zM10 15a1 1 0 100-2 1 1 0 000 2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(QuestionMarkCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/QueueListIcon.js
var require_QueueListIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/QueueListIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function QueueListIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M2 4.5A2.5 2.5 0 014.5 2h11a2.5 2.5 0 010 5h-11A2.5 2.5 0 012 4.5zM2.75 9.083a.75.75 0 000 1.5h14.5a.75.75 0 000-1.5H2.75zM2.75 12.663a.75.75 0 000 1.5h14.5a.75.75 0 000-1.5H2.75zM2.75 16.25a.75.75 0 000 1.5h14.5a.75.75 0 100-1.5H2.75z"
      }));
    }
    var ForwardRef = React.forwardRef(QueueListIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/RadioIcon.js
var require_RadioIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/RadioIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function RadioIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M17.45 3.473a.75.75 0 10-.4-1.446L5.313 5.265c-.84.096-1.671.217-2.495.362A2.212 2.212 0 001 7.817v7.933A2.25 2.25 0 003.25 18h13.5A2.25 2.25 0 0019 15.75V7.816c0-1.06-.745-2-1.817-2.189a41.124 41.124 0 00-5.406-.589l5.673-1.565zM16 9.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0zM14.5 16a1.5 1.5 0 100-3 1.5 1.5 0 000 3zm-9.26-5a.75.75 0 01.75-.75H6a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75V11zm2.75-.75a.75.75 0 00-.75.75v.01c0 .415.336.75.75.75H8a.75.75 0 00.75-.75V11a.75.75 0 00-.75-.75h-.01zm-1.75-1.5A.75.75 0 016.99 8H7a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75v-.01zm3.583.42a.75.75 0 00-1.06 0l-.007.007a.75.75 0 000 1.06l.007.008a.75.75 0 001.06 0l.007-.007a.75.75 0 000-1.061l-.007-.007zm.427 2.08A.75.75 0 0111 12v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75V12a.75.75 0 01.75-.75h.01zm-.42 3.584a.75.75 0 000-1.061l-.007-.007a.75.75 0 00-1.06 0l-.007.007a.75.75 0 000 1.06l.007.008a.75.75 0 001.06 0l.008-.007zm-3.59.416a.75.75 0 01.75-.75H7a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75v-.01zm-1.013-1.484a.75.75 0 00-1.06 0l-.008.007a.75.75 0 000 1.06l.007.008a.75.75 0 001.061 0l.007-.007a.75.75 0 000-1.061l-.007-.007zM3.75 11.25a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75V12a.75.75 0 01.75-.75h.01zm1.484-1.012a.75.75 0 000-1.061l-.007-.007a.75.75 0 00-1.06 0l-.007.007a.75.75 0 000 1.06l.007.008a.75.75 0 001.06 0l.007-.007zM7.24 13a.75.75 0 01.75-.75H8a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75V13zm-1.25-.75a.75.75 0 00-.75.75v.01c0 .415.336.75.75.75H6a.75.75 0 00.75-.75V13a.75.75 0 00-.75-.75h-.01z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(RadioIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ReceiptPercentIcon.js
var require_ReceiptPercentIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ReceiptPercentIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ReceiptPercentIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.93 1.31a41.401 41.401 0 0110.14 0C16.194 1.45 17 2.414 17 3.517V18.25a.75.75 0 01-1.075.676l-2.8-1.344-2.8 1.344a.75.75 0 01-.65 0l-2.8-1.344-2.8 1.344A.75.75 0 013 18.25V3.517c0-1.103.806-2.068 1.93-2.207zm8.85 5.97a.75.75 0 00-1.06-1.06l-6.5 6.5a.75.75 0 101.06 1.06l6.5-6.5zM9 8a1 1 0 11-2 0 1 1 0 012 0zm3 5a1 1 0 100-2 1 1 0 000 2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ReceiptPercentIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ReceiptRefundIcon.js
var require_ReceiptRefundIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ReceiptRefundIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ReceiptRefundIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.93 1.31a41.401 41.401 0 0110.14 0C16.194 1.45 17 2.414 17 3.517V18.25a.75.75 0 01-1.075.676l-2.8-1.344-2.8 1.344a.75.75 0 01-.65 0l-2.8-1.344-2.8 1.344A.75.75 0 013 18.25V3.517c0-1.103.806-2.068 1.93-2.207zm4.822 4.997a.75.75 0 10-1.004-1.114l-2.5 2.25a.75.75 0 000 1.114l2.5 2.25a.75.75 0 001.004-1.114L8.704 8.75h1.921a1.875 1.875 0 010 3.75.75.75 0 000 1.5 3.375 3.375 0 100-6.75h-1.92l1.047-.943z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ReceiptRefundIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/RectangleGroupIcon.js
var require_RectangleGroupIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/RectangleGroupIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function RectangleGroupIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2.5 3A1.5 1.5 0 001 4.5v4A1.5 1.5 0 002.5 10h6A1.5 1.5 0 0010 8.5v-4A1.5 1.5 0 008.5 3h-6zm11 2A1.5 1.5 0 0012 6.5v7a1.5 1.5 0 001.5 1.5h4a1.5 1.5 0 001.5-1.5v-7A1.5 1.5 0 0017.5 5h-4zm-10 7A1.5 1.5 0 002 13.5v2A1.5 1.5 0 003.5 17h6a1.5 1.5 0 001.5-1.5v-2A1.5 1.5 0 009.5 12h-6z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(RectangleGroupIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/RectangleStackIcon.js
var require_RectangleStackIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/RectangleStackIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function RectangleStackIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M5.127 3.502L5.25 3.5h9.5c.041 0 .082 0 .123.002A2.251 2.251 0 0012.75 2h-5.5a2.25 2.25 0 00-2.123 1.502zM1 10.25A2.25 2.25 0 013.25 8h13.5A2.25 2.25 0 0119 10.25v5.5A2.25 2.25 0 0116.75 18H3.25A2.25 2.25 0 011 15.75v-5.5zM3.25 6.5c-.04 0-.082 0-.123.002A2.25 2.25 0 015.25 5h9.5c.98 0 1.814.627 2.123 1.502a3.819 3.819 0 00-.123-.002H3.25z"
      }));
    }
    var ForwardRef = React.forwardRef(RectangleStackIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/RocketLaunchIcon.js
var require_RocketLaunchIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/RocketLaunchIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function RocketLaunchIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.606 12.97a.75.75 0 01-.134 1.051 2.494 2.494 0 00-.93 2.437 2.494 2.494 0 002.437-.93.75.75 0 111.186.918 3.995 3.995 0 01-4.482 1.332.75.75 0 01-.461-.461 3.994 3.994 0 011.332-4.482.75.75 0 011.052.134z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5.752 12A13.07 13.07 0 008 14.248v4.002c0 .414.336.75.75.75a5 5 0 004.797-6.414 12.984 12.984 0 005.45-10.848.75.75 0 00-.735-.735 12.984 12.984 0 00-10.849 5.45A5 5 0 001 11.25c.001.414.337.75.751.75h4.002zM13 9a2 2 0 100-4 2 2 0 000 4z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(RocketLaunchIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/RssIcon.js
var require_RssIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/RssIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function RssIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3.75 3a.75.75 0 00-.75.75v.5c0 .414.336.75.75.75H4c6.075 0 11 4.925 11 11v.25c0 .414.336.75.75.75h.5a.75.75 0 00.75-.75V16C17 8.82 11.18 3 4 3h-.25z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M3 8.75A.75.75 0 013.75 8H4a8 8 0 018 8v.25a.75.75 0 01-.75.75h-.5a.75.75 0 01-.75-.75V16a6 6 0 00-6-6h-.25A.75.75 0 013 9.25v-.5zM7 15a2 2 0 11-4 0 2 2 0 014 0z"
      }));
    }
    var ForwardRef = React.forwardRef(RssIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ScaleIcon.js
var require_ScaleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ScaleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ScaleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 2a.75.75 0 01.75.75v.258a33.186 33.186 0 016.668.83.75.75 0 01-.336 1.461 31.28 31.28 0 00-1.103-.232l1.702 7.545a.75.75 0 01-.387.832A4.981 4.981 0 0115 14c-.825 0-1.606-.2-2.294-.556a.75.75 0 01-.387-.832l1.77-7.849a31.743 31.743 0 00-3.339-.254v11.505a20.01 20.01 0 013.78.501.75.75 0 11-.339 1.462A18.558 18.558 0 0010 17.5c-1.442 0-2.845.165-4.191.477a.75.75 0 01-.338-1.462 20.01 20.01 0 013.779-.501V4.509c-1.129.026-2.243.112-3.34.254l1.771 7.85a.75.75 0 01-.387.83A4.98 4.98 0 015 14a4.98 4.98 0 01-2.294-.556.75.75 0 01-.387-.832L4.02 5.067c-.37.07-.738.148-1.103.232a.75.75 0 01-.336-1.462 32.845 32.845 0 016.668-.829V2.75A.75.75 0 0110 2zM5 7.543L3.92 12.33a3.499 3.499 0 002.16 0L5 7.543zm10 0l-1.08 4.787a3.498 3.498 0 002.16 0L15 7.543z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ScaleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ScissorsIcon.js
var require_ScissorsIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ScissorsIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ScissorsIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1.469 3.75a3.5 3.5 0 005.617 4.11l.883.51c.025.092.147.116.21.043a3.75 3.75 0 01.5-.484c.286-.23.3-.709-.018-.892l-.825-.477A3.501 3.501 0 001.47 3.75zm2.03 3.482a2 2 0 112-3.464 2 2 0 01-2 3.464zM9.956 8.322a2.75 2.75 0 00-1.588 1.822L7.97 11.63l-.884.51a3.501 3.501 0 10.75 1.3l10.68-6.166a.75.75 0 00-.182-1.374l-.703-.189a2.75 2.75 0 00-1.78.123L9.955 8.322zM2.768 15.5a2 2 0 113.464-2 2 2 0 01-3.464 2z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M12.52 11.89a.5.5 0 00.056.894l3.274 1.381a2.75 2.75 0 001.78.123l.704-.188a.75.75 0 00.18-1.374l-3.47-2.004a.5.5 0 00-.5 0L12.52 11.89z"
      }));
    }
    var ForwardRef = React.forwardRef(ScissorsIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ServerStackIcon.js
var require_ServerStackIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ServerStackIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ServerStackIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M4.464 3.162A2 2 0 016.28 2h7.44a2 2 0 011.816 1.162l1.154 2.5c.067.145.115.291.145.438A3.508 3.508 0 0016 6H4c-.288 0-.568.035-.835.1.03-.147.078-.293.145-.438l1.154-2.5z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 9.5a2 2 0 012-2h12a2 2 0 110 4H4a2 2 0 01-2-2zm13.24 0a.75.75 0 01.75-.75H16a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75V9.5zm-2.25-.75a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75H13a.75.75 0 00.75-.75V9.5a.75.75 0 00-.75-.75h-.01zM2 15a2 2 0 012-2h12a2 2 0 110 4H4a2 2 0 01-2-2zm13.24 0a.75.75 0 01.75-.75H16a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75V15zm-2.25-.75a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75H13a.75.75 0 00.75-.75V15a.75.75 0 00-.75-.75h-.01z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ServerStackIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ServerIcon.js
var require_ServerIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ServerIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ServerIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M4.632 3.533A2 2 0 016.577 2h6.846a2 2 0 011.945 1.533l1.976 8.234A3.489 3.489 0 0016 11.5H4c-.476 0-.93.095-1.344.267l1.976-8.234z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4 13a2 2 0 100 4h12a2 2 0 100-4H4zm11.24 2a.75.75 0 01.75-.75H16a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75h-.01a.75.75 0 01-.75-.75V15zm-2.25-.75a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75H13a.75.75 0 00.75-.75V15a.75.75 0 00-.75-.75h-.01z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ServerIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ShareIcon.js
var require_ShareIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ShareIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ShareIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M13 4.5a2.5 2.5 0 11.702 1.737L6.97 9.604a2.518 2.518 0 010 .792l6.733 3.367a2.5 2.5 0 11-.671 1.341l-6.733-3.367a2.5 2.5 0 110-3.475l6.733-3.366A2.52 2.52 0 0113 4.5z"
      }));
    }
    var ForwardRef = React.forwardRef(ShareIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ShieldCheckIcon.js
var require_ShieldCheckIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ShieldCheckIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ShieldCheckIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M9.661 2.237a.531.531 0 01.678 0 11.947 11.947 0 007.078 2.749.5.5 0 01.479.425c.069.52.104 1.05.104 1.59 0 5.162-3.26 9.563-7.834 11.256a.48.48 0 01-.332 0C5.26 16.564 2 12.163 2 7c0-.538.035-1.069.104-1.589a.5.5 0 01.48-.425 11.947 11.947 0 007.077-2.75zm4.196 5.954a.75.75 0 00-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 10-1.06 1.061l2.5 2.5a.75.75 0 001.137-.089l4-5.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ShieldCheckIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ShieldExclamationIcon.js
var require_ShieldExclamationIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ShieldExclamationIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ShieldExclamationIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10.339 2.237a.532.532 0 00-.678 0 11.947 11.947 0 01-7.078 2.75.5.5 0 00-.479.425A12.11 12.11 0 002 7c0 5.163 3.26 9.564 7.834 11.257a.48.48 0 00.332 0C14.74 16.564 18 12.163 18 7.001c0-.54-.035-1.07-.104-1.59a.5.5 0 00-.48-.425 11.947 11.947 0 01-7.077-2.75zM10 6a.75.75 0 01.75.75v3.5a.75.75 0 01-1.5 0v-3.5A.75.75 0 0110 6zm0 9a1 1 0 100-2 1 1 0 000 2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ShieldExclamationIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ShoppingBagIcon.js
var require_ShoppingBagIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ShoppingBagIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ShoppingBagIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M6 5v1H4.667a1.75 1.75 0 00-1.743 1.598l-.826 9.5A1.75 1.75 0 003.84 19H16.16a1.75 1.75 0 001.743-1.902l-.826-9.5A1.75 1.75 0 0015.333 6H14V5a4 4 0 00-8 0zm4-2.5A2.5 2.5 0 007.5 5v1h5V5A2.5 2.5 0 0010 2.5zM7.5 10a2.5 2.5 0 005 0V8.75a.75.75 0 011.5 0V10a4 4 0 01-8 0V8.75a.75.75 0 011.5 0V10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(ShoppingBagIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ShoppingCartIcon.js
var require_ShoppingCartIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ShoppingCartIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ShoppingCartIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M1 1.75A.75.75 0 011.75 1h1.628a1.75 1.75 0 011.734 1.51L5.18 3a65.25 65.25 0 0113.36 1.412.75.75 0 01.58.875 48.645 48.645 0 01-1.618 6.2.75.75 0 01-.712.513H6a2.503 2.503 0 00-2.292 1.5H17.25a.75.75 0 010 1.5H2.76a.75.75 0 01-.748-.807 4.002 4.002 0 012.716-3.486L3.626 2.716a.25.25 0 00-.248-.216H1.75A.75.75 0 011 1.75zM6 17.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0zM15.5 19a1.5 1.5 0 100-3 1.5 1.5 0 000 3z"
      }));
    }
    var ForwardRef = React.forwardRef(ShoppingCartIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SignalSlashIcon.js
var require_SignalSlashIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SignalSlashIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function SignalSlashIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M2.22 2.22a.75.75 0 011.06 0l6.783 6.782a1 1 0 01.935.935l6.782 6.783a.75.75 0 11-1.06 1.06l-6.783-6.782a1 1 0 01-.935-.935L2.22 3.28a.75.75 0 010-1.06zM3.636 16.364a9.004 9.004 0 01-1.39-10.936L3.349 6.53a7.503 7.503 0 001.348 8.773.75.75 0 01-1.061 1.061zM6.464 13.536a5 5 0 01-1.213-5.103l1.262 1.262a3.493 3.493 0 001.012 2.78.75.75 0 01-1.06 1.06zM16.364 3.636a9.004 9.004 0 011.39 10.937l-1.103-1.104a7.503 7.503 0 00-1.348-8.772.75.75 0 111.061-1.061zM13.536 6.464a5 5 0 011.213 5.103l-1.262-1.262a3.493 3.493 0 00-1.012-2.78.75.75 0 011.06-1.06z"
      }));
    }
    var ForwardRef = React.forwardRef(SignalSlashIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SignalIcon.js
var require_SignalIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SignalIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function SignalIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M16.364 3.636a.75.75 0 00-1.06 1.06 7.5 7.5 0 010 10.607.75.75 0 001.06 1.061 9 9 0 000-12.728zM4.697 4.697a.75.75 0 00-1.061-1.06 9 9 0 000 12.727.75.75 0 101.06-1.06 7.5 7.5 0 010-10.607z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M12.475 6.465a.75.75 0 011.06 0 5 5 0 010 7.07.75.75 0 11-1.06-1.06 3.5 3.5 0 000-4.95.75.75 0 010-1.06zM7.525 6.465a.75.75 0 010 1.06 3.5 3.5 0 000 4.95.75.75 0 01-1.06 1.06 5 5 0 010-7.07.75.75 0 011.06 0zM11 10a1 1 0 11-2 0 1 1 0 012 0z"
      }));
    }
    var ForwardRef = React.forwardRef(SignalIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SparklesIcon.js
var require_SparklesIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SparklesIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function SparklesIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M15.98 1.804a1 1 0 00-1.96 0l-.24 1.192a1 1 0 01-.784.785l-1.192.238a1 1 0 000 1.962l1.192.238a1 1 0 01.785.785l.238 1.192a1 1 0 001.962 0l.238-1.192a1 1 0 01.785-.785l1.192-.238a1 1 0 000-1.962l-1.192-.238a1 1 0 01-.785-.785l-.238-1.192zM6.949 5.684a1 1 0 00-1.898 0l-.683 2.051a1 1 0 01-.633.633l-2.051.683a1 1 0 000 1.898l2.051.684a1 1 0 01.633.632l.683 2.051a1 1 0 001.898 0l.683-2.051a1 1 0 01.633-.633l2.051-.683a1 1 0 000-1.898l-2.051-.683a1 1 0 01-.633-.633L6.95 5.684zM13.949 13.684a1 1 0 00-1.898 0l-.184.551a1 1 0 01-.632.633l-.551.183a1 1 0 000 1.898l.551.183a1 1 0 01.633.633l.183.551a1 1 0 001.898 0l.184-.551a1 1 0 01.632-.633l.551-.183a1 1 0 000-1.898l-.551-.184a1 1 0 01-.633-.632l-.183-.551z"
      }));
    }
    var ForwardRef = React.forwardRef(SparklesIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SpeakerWaveIcon.js
var require_SpeakerWaveIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SpeakerWaveIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function SpeakerWaveIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10 3.75a.75.75 0 00-1.264-.546L4.703 7H3.167a.75.75 0 00-.7.48A6.985 6.985 0 002 10c0 .887.165 1.737.468 2.52.111.29.39.48.7.48h1.535l4.033 3.796A.75.75 0 0010 16.25V3.75zM15.95 5.05a.75.75 0 00-1.06 1.061 5.5 5.5 0 010 7.778.75.75 0 001.06 1.06 7 7 0 000-9.899z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M13.829 7.172a.75.75 0 00-1.061 1.06 2.5 2.5 0 010 3.536.75.75 0 001.06 1.06 4 4 0 000-5.656z"
      }));
    }
    var ForwardRef = React.forwardRef(SpeakerWaveIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SpeakerXMarkIcon.js
var require_SpeakerXMarkIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SpeakerXMarkIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function SpeakerXMarkIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M9.547 3.062A.75.75 0 0110 3.75v12.5a.75.75 0 01-1.264.546L4.703 13H3.167a.75.75 0 01-.7-.48A6.985 6.985 0 012 10c0-.887.165-1.737.468-2.52a.75.75 0 01.7-.48h1.535l4.033-3.796a.75.75 0 01.811-.142zM13.28 7.22a.75.75 0 10-1.06 1.06L13.94 10l-1.72 1.72a.75.75 0 001.06 1.06L15 11.06l1.72 1.72a.75.75 0 101.06-1.06L16.06 10l1.72-1.72a.75.75 0 00-1.06-1.06L15 8.94l-1.72-1.72z"
      }));
    }
    var ForwardRef = React.forwardRef(SpeakerXMarkIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Square2StackIcon.js
var require_Square2StackIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Square2StackIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Square2StackIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M2 4.25A2.25 2.25 0 014.25 2h6.5A2.25 2.25 0 0113 4.25V5.5H9.25A3.75 3.75 0 005.5 9.25V13H4.25A2.25 2.25 0 012 10.75v-6.5z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M9.25 7A2.25 2.25 0 007 9.25v6.5A2.25 2.25 0 009.25 18h6.5A2.25 2.25 0 0018 15.75v-6.5A2.25 2.25 0 0015.75 7h-6.5z"
      }));
    }
    var ForwardRef = React.forwardRef(Square2StackIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Square3Stack3DIcon.js
var require_Square3Stack3DIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Square3Stack3DIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Square3Stack3DIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3.196 12.87l-.825.483a.75.75 0 000 1.294l7.25 4.25a.75.75 0 00.758 0l7.25-4.25a.75.75 0 000-1.294l-.825-.484-5.666 3.322a2.25 2.25 0 01-2.276 0L3.196 12.87z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M3.196 8.87l-.825.483a.75.75 0 000 1.294l7.25 4.25a.75.75 0 00.758 0l7.25-4.25a.75.75 0 000-1.294l-.825-.484-5.666 3.322a2.25 2.25 0 01-2.276 0L3.196 8.87z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M10.38 1.103a.75.75 0 00-.76 0l-7.25 4.25a.75.75 0 000 1.294l7.25 4.25a.75.75 0 00.76 0l7.25-4.25a.75.75 0 000-1.294l-7.25-4.25z"
      }));
    }
    var ForwardRef = React.forwardRef(Square3Stack3DIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Squares2X2Icon.js
var require_Squares2X2Icon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/Squares2X2Icon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function Squares2X2Icon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M4.25 2A2.25 2.25 0 002 4.25v2.5A2.25 2.25 0 004.25 9h2.5A2.25 2.25 0 009 6.75v-2.5A2.25 2.25 0 006.75 2h-2.5zm0 9A2.25 2.25 0 002 13.25v2.5A2.25 2.25 0 004.25 18h2.5A2.25 2.25 0 009 15.75v-2.5A2.25 2.25 0 006.75 11h-2.5zm9-9A2.25 2.25 0 0011 4.25v2.5A2.25 2.25 0 0013.25 9h2.5A2.25 2.25 0 0018 6.75v-2.5A2.25 2.25 0 0015.75 2h-2.5zm0 9A2.25 2.25 0 0011 13.25v2.5A2.25 2.25 0 0013.25 18h2.5A2.25 2.25 0 0018 15.75v-2.5A2.25 2.25 0 0015.75 11h-2.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(Squares2X2Icon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SquaresPlusIcon.js
var require_SquaresPlusIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SquaresPlusIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function SquaresPlusIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M2 4.25A2.25 2.25 0 014.25 2h2.5A2.25 2.25 0 019 4.25v2.5A2.25 2.25 0 016.75 9h-2.5A2.25 2.25 0 012 6.75v-2.5zM2 13.25A2.25 2.25 0 014.25 11h2.5A2.25 2.25 0 019 13.25v2.5A2.25 2.25 0 016.75 18h-2.5A2.25 2.25 0 012 15.75v-2.5zM11 4.25A2.25 2.25 0 0113.25 2h2.5A2.25 2.25 0 0118 4.25v2.5A2.25 2.25 0 0115.75 9h-2.5A2.25 2.25 0 0111 6.75v-2.5zM15.25 11.75a.75.75 0 00-1.5 0v2h-2a.75.75 0 000 1.5h2v2a.75.75 0 001.5 0v-2h2a.75.75 0 000-1.5h-2v-2z"
      }));
    }
    var ForwardRef = React.forwardRef(SquaresPlusIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/StarIcon.js
var require_StarIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/StarIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function StarIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10.868 2.884c-.321-.772-1.415-.772-1.736 0l-1.83 4.401-4.753.381c-.833.067-1.171 1.107-.536 1.651l3.62 3.102-1.106 4.637c-.194.813.691 1.456 1.405 1.02L10 15.591l4.069 2.485c.713.436 1.598-.207 1.404-1.02l-1.106-4.637 3.62-3.102c.635-.544.297-1.584-.536-1.65l-4.752-.382-1.831-4.401z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(StarIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/StopCircleIcon.js
var require_StopCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/StopCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function StopCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M2 10a8 8 0 1116 0 8 8 0 01-16 0zm5-2.25A.75.75 0 017.75 7h4.5a.75.75 0 01.75.75v4.5a.75.75 0 01-.75.75h-4.5a.75.75 0 01-.75-.75v-4.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(StopCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/StopIcon.js
var require_StopIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/StopIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function StopIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M5.25 3A2.25 2.25 0 003 5.25v9.5A2.25 2.25 0 005.25 17h9.5A2.25 2.25 0 0017 14.75v-9.5A2.25 2.25 0 0014.75 3h-9.5z"
      }));
    }
    var ForwardRef = React.forwardRef(StopIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SunIcon.js
var require_SunIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SunIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function SunIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10 2a.75.75 0 01.75.75v1.5a.75.75 0 01-1.5 0v-1.5A.75.75 0 0110 2zM10 15a.75.75 0 01.75.75v1.5a.75.75 0 01-1.5 0v-1.5A.75.75 0 0110 15zM10 7a3 3 0 100 6 3 3 0 000-6zM15.657 5.404a.75.75 0 10-1.06-1.06l-1.061 1.06a.75.75 0 001.06 1.06l1.06-1.06zM6.464 14.596a.75.75 0 10-1.06-1.06l-1.06 1.06a.75.75 0 001.06 1.06l1.06-1.06zM18 10a.75.75 0 01-.75.75h-1.5a.75.75 0 010-1.5h1.5A.75.75 0 0118 10zM5 10a.75.75 0 01-.75.75h-1.5a.75.75 0 010-1.5h1.5A.75.75 0 015 10zM14.596 15.657a.75.75 0 001.06-1.06l-1.06-1.061a.75.75 0 10-1.06 1.06l1.06 1.06zM5.404 6.464a.75.75 0 001.06-1.06l-1.06-1.06a.75.75 0 10-1.061 1.06l1.06 1.06z"
      }));
    }
    var ForwardRef = React.forwardRef(SunIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SwatchIcon.js
var require_SwatchIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/SwatchIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function SwatchIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3.5 2A1.5 1.5 0 002 3.5V15a3 3 0 106 0V3.5A1.5 1.5 0 006.5 2h-3zm11.753 6.99L9.5 14.743V6.257l1.51-1.51a1.5 1.5 0 012.122 0l2.121 2.121a1.5 1.5 0 010 2.122zM8.364 18H16.5a1.5 1.5 0 001.5-1.5v-3a1.5 1.5 0 00-1.5-1.5h-2.136l-6 6zM5 16a1 1 0 100-2 1 1 0 000 2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(SwatchIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TableCellsIcon.js
var require_TableCellsIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TableCellsIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function TableCellsIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M.99 5.24A2.25 2.25 0 013.25 3h13.5A2.25 2.25 0 0119 5.25l.01 9.5A2.25 2.25 0 0116.76 17H3.26A2.267 2.267 0 011 14.74l-.01-9.5zm8.26 9.52v-.625a.75.75 0 00-.75-.75H3.25a.75.75 0 00-.75.75v.615c0 .414.336.75.75.75h5.373a.75.75 0 00.627-.74zm1.5 0a.75.75 0 00.627.74h5.373a.75.75 0 00.75-.75v-.615a.75.75 0 00-.75-.75H11.5a.75.75 0 00-.75.75v.625zm6.75-3.63v-.625a.75.75 0 00-.75-.75H11.5a.75.75 0 00-.75.75v.625c0 .414.336.75.75.75h5.25a.75.75 0 00.75-.75zm-8.25 0v-.625a.75.75 0 00-.75-.75H3.25a.75.75 0 00-.75.75v.625c0 .414.336.75.75.75H8.5a.75.75 0 00.75-.75zM17.5 7.5v-.625a.75.75 0 00-.75-.75H11.5a.75.75 0 00-.75.75V7.5c0 .414.336.75.75.75h5.25a.75.75 0 00.75-.75zm-8.25 0v-.625a.75.75 0 00-.75-.75H3.25a.75.75 0 00-.75.75V7.5c0 .414.336.75.75.75H8.5a.75.75 0 00.75-.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(TableCellsIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TagIcon.js
var require_TagIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TagIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function TagIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M5.5 3A2.5 2.5 0 003 5.5v2.879a2.5 2.5 0 00.732 1.767l6.5 6.5a2.5 2.5 0 003.536 0l2.878-2.878a2.5 2.5 0 000-3.536l-6.5-6.5A2.5 2.5 0 008.38 3H5.5zM6 7a1 1 0 100-2 1 1 0 000 2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(TagIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TicketIcon.js
var require_TicketIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TicketIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function TicketIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M13 3v1.27a.75.75 0 001.5 0V3h2.25A2.25 2.25 0 0119 5.25v2.628a.75.75 0 01-.5.707 1.5 1.5 0 000 2.83c.3.106.5.39.5.707v2.628A2.25 2.25 0 0116.75 17H14.5v-1.27a.75.75 0 00-1.5 0V17H3.25A2.25 2.25 0 011 14.75v-2.628c0-.318.2-.601.5-.707a1.5 1.5 0 000-2.83.75.75 0 01-.5-.707V5.25A2.25 2.25 0 013.25 3H13zm1.5 4.396a.75.75 0 00-1.5 0v1.042a.75.75 0 001.5 0V7.396zm0 4.167a.75.75 0 00-1.5 0v1.041a.75.75 0 001.5 0v-1.041zM6 10.75a.75.75 0 01.75-.75h3.5a.75.75 0 010 1.5h-3.5a.75.75 0 01-.75-.75zm0 2.5a.75.75 0 01.75-.75h1.5a.75.75 0 010 1.5h-1.5a.75.75 0 01-.75-.75z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(TicketIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TrashIcon.js
var require_TrashIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TrashIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function TrashIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M8.75 1A2.75 2.75 0 006 3.75v.443c-.795.077-1.584.176-2.365.298a.75.75 0 10.23 1.482l.149-.022.841 10.518A2.75 2.75 0 007.596 19h4.807a2.75 2.75 0 002.742-2.53l.841-10.52.149.023a.75.75 0 00.23-1.482A41.03 41.03 0 0014 4.193V3.75A2.75 2.75 0 0011.25 1h-2.5zM10 4c.84 0 1.673.025 2.5.075V3.75c0-.69-.56-1.25-1.25-1.25h-2.5c-.69 0-1.25.56-1.25 1.25v.325C8.327 4.025 9.16 4 10 4zM8.58 7.72a.75.75 0 00-1.5.06l.3 7.5a.75.75 0 101.5-.06l-.3-7.5zm4.34.06a.75.75 0 10-1.5-.06l-.3 7.5a.75.75 0 101.5.06l.3-7.5z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(TrashIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TrophyIcon.js
var require_TrophyIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TrophyIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function TrophyIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 1c-1.828 0-3.623.149-5.371.435a.75.75 0 00-.629.74v.387c-.827.157-1.642.345-2.445.564a.75.75 0 00-.552.698 5 5 0 004.503 5.152 6 6 0 002.946 1.822A6.451 6.451 0 017.768 13H7.5A1.5 1.5 0 006 14.5V17h-.75C4.56 17 4 17.56 4 18.25c0 .414.336.75.75.75h10.5a.75.75 0 00.75-.75c0-.69-.56-1.25-1.25-1.25H14v-2.5a1.5 1.5 0 00-1.5-1.5h-.268a6.453 6.453 0 01-.684-2.202 6 6 0 002.946-1.822 5 5 0 004.503-5.152.75.75 0 00-.552-.698A31.804 31.804 0 0016 2.562v-.387a.75.75 0 00-.629-.74A33.227 33.227 0 0010 1zM2.525 4.422C3.012 4.3 3.504 4.19 4 4.09V5c0 .74.134 1.448.38 2.103a3.503 3.503 0 01-1.855-2.68zm14.95 0a3.503 3.503 0 01-1.854 2.68C15.866 6.449 16 5.74 16 5v-.91c.496.099.988.21 1.475.332z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(TrophyIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TruckIcon.js
var require_TruckIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TruckIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function TruckIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M6.5 3c-1.051 0-2.093.04-3.125.117A1.49 1.49 0 002 4.607V10.5h9V4.606c0-.771-.59-1.43-1.375-1.489A41.568 41.568 0 006.5 3zM2 12v2.5A1.5 1.5 0 003.5 16h.041a3 3 0 015.918 0h.791a.75.75 0 00.75-.75V12H2z"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M6.5 18a1.5 1.5 0 100-3 1.5 1.5 0 000 3zM13.25 5a.75.75 0 00-.75.75v8.514a3.001 3.001 0 014.893 1.44c.37-.275.61-.719.595-1.227a24.905 24.905 0 00-1.784-8.549A1.486 1.486 0 0014.823 5H13.25zM14.5 18a1.5 1.5 0 100-3 1.5 1.5 0 000 3z"
      }));
    }
    var ForwardRef = React.forwardRef(TruckIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TvIcon.js
var require_TvIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/TvIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function TvIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M4 5h12v7H4V5z"
      }), /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M1 3.5A1.5 1.5 0 012.5 2h15A1.5 1.5 0 0119 3.5v10a1.5 1.5 0 01-1.5 1.5H12v1.5h3.25a.75.75 0 010 1.5H4.75a.75.75 0 010-1.5H8V15H2.5A1.5 1.5 0 011 13.5v-10zm16.5 0h-15v10h15v-10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(TvIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/UserCircleIcon.js
var require_UserCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/UserCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function UserCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-5.5-2.5a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0zM10 12a5.99 5.99 0 00-4.793 2.39A6.483 6.483 0 0010 16.5a6.483 6.483 0 004.793-2.11A5.99 5.99 0 0010 12z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(UserCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/UserGroupIcon.js
var require_UserGroupIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/UserGroupIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function UserGroupIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10 9a3 3 0 100-6 3 3 0 000 6zM6 8a2 2 0 11-4 0 2 2 0 014 0zM1.49 15.326a.78.78 0 01-.358-.442 3 3 0 014.308-3.516 6.484 6.484 0 00-1.905 3.959c-.023.222-.014.442.025.654a4.97 4.97 0 01-2.07-.655zM16.44 15.98a4.97 4.97 0 002.07-.654.78.78 0 00.357-.442 3 3 0 00-4.308-3.517 6.484 6.484 0 011.907 3.96 2.32 2.32 0 01-.026.654zM18 8a2 2 0 11-4 0 2 2 0 014 0zM5.304 16.19a.844.844 0 01-.277-.71 5 5 0 019.947 0 .843.843 0 01-.277.71A6.975 6.975 0 0110 18a6.974 6.974 0 01-4.696-1.81z"
      }));
    }
    var ForwardRef = React.forwardRef(UserGroupIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/UserMinusIcon.js
var require_UserMinusIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/UserMinusIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function UserMinusIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M11 5a3 3 0 11-6 0 3 3 0 016 0zM2.046 15.253c-.058.468.172.92.57 1.175A9.953 9.953 0 008 18c1.982 0 3.83-.578 5.384-1.573.398-.254.628-.707.57-1.175a6.001 6.001 0 00-11.908 0zM12.75 7.75a.75.75 0 000 1.5h5.5a.75.75 0 000-1.5h-5.5z"
      }));
    }
    var ForwardRef = React.forwardRef(UserMinusIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/UserPlusIcon.js
var require_UserPlusIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/UserPlusIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function UserPlusIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M11 5a3 3 0 11-6 0 3 3 0 016 0zM2.615 16.428a1.224 1.224 0 01-.569-1.175 6.002 6.002 0 0111.908 0c.058.467-.172.92-.57 1.174A9.953 9.953 0 018 18a9.953 9.953 0 01-5.385-1.572zM16.25 5.75a.75.75 0 00-1.5 0v2h-2a.75.75 0 000 1.5h2v2a.75.75 0 001.5 0v-2h2a.75.75 0 000-1.5h-2v-2z"
      }));
    }
    var ForwardRef = React.forwardRef(UserPlusIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/UserIcon.js
var require_UserIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/UserIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function UserIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M10 8a3 3 0 100-6 3 3 0 000 6zM3.465 14.493a1.23 1.23 0 00.41 1.412A9.957 9.957 0 0010 18c2.31 0 4.438-.784 6.131-2.1.43-.333.604-.903.408-1.41a7.002 7.002 0 00-13.074.003z"
      }));
    }
    var ForwardRef = React.forwardRef(UserIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/UsersIcon.js
var require_UsersIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/UsersIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function UsersIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M7 8a3 3 0 100-6 3 3 0 000 6zM14.5 9a2.5 2.5 0 100-5 2.5 2.5 0 000 5zM1.615 16.428a1.224 1.224 0 01-.569-1.175 6.002 6.002 0 0111.908 0c.058.467-.172.92-.57 1.174A9.953 9.953 0 017 18a9.953 9.953 0 01-5.385-1.572zM14.5 16h-.106c.07-.297.088-.611.048-.933a7.47 7.47 0 00-1.588-3.755 4.502 4.502 0 015.874 2.636.818.818 0 01-.36.98A7.465 7.465 0 0114.5 16z"
      }));
    }
    var ForwardRef = React.forwardRef(UsersIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/VariableIcon.js
var require_VariableIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/VariableIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function VariableIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M15.212 2.079a.75.75 0 011.006.336A16.932 16.932 0 0118 10c0 2.724-.641 5.3-1.782 7.585a.75.75 0 11-1.342-.67A15.432 15.432 0 0016.5 10c0-2.486-.585-4.834-1.624-6.915a.75.75 0 01.336-1.006zm-10.424 0a.75.75 0 01.336 1.006A15.433 15.433 0 003.5 10c0 2.486.585 4.834 1.624 6.915a.75.75 0 11-1.342.67A16.933 16.933 0 012 10c0-2.724.641-5.3 1.782-7.585a.75.75 0 011.006-.336zm2.285 3.554a1.5 1.5 0 012.219.677l.856 2.08 1.146-1.77a2.25 2.25 0 013.137-.65l.235.156a.75.75 0 11-.832 1.248l-.235-.156a.75.75 0 00-1.045.216l-1.71 2.644 1.251 3.04.739-.492a.75.75 0 11.832 1.248l-.739.493a1.5 1.5 0 01-2.219-.677l-.856-2.08-1.146 1.77a2.25 2.25 0 01-3.137.65l-.235-.156a.75.75 0 01.832-1.248l.235.157a.75.75 0 001.045-.217l1.71-2.644-1.251-3.04-.739.492a.75.75 0 01-.832-1.248l.739-.493z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(VariableIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/VideoCameraSlashIcon.js
var require_VideoCameraSlashIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/VideoCameraSlashIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function VideoCameraSlashIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M1 13.75V7.182L9.818 16H3.25A2.25 2.25 0 011 13.75zM13 6.25v6.568L4.182 4h6.568A2.25 2.25 0 0113 6.25zM19 4.75a.75.75 0 00-1.28-.53l-3 3a.75.75 0 00-.22.53v4.5c0 .199.079.39.22.53l3 3a.75.75 0 001.28-.53V4.75zM2.28 4.22a.75.75 0 00-1.06 1.06l10.5 10.5a.75.75 0 101.06-1.06L2.28 4.22z"
      }));
    }
    var ForwardRef = React.forwardRef(VideoCameraSlashIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/VideoCameraIcon.js
var require_VideoCameraIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/VideoCameraIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function VideoCameraIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M3.25 4A2.25 2.25 0 001 6.25v7.5A2.25 2.25 0 003.25 16h7.5A2.25 2.25 0 0013 13.75v-7.5A2.25 2.25 0 0010.75 4h-7.5zM19 4.75a.75.75 0 00-1.28-.53l-3 3a.75.75 0 00-.22.53v4.5c0 .199.079.39.22.53l3 3a.75.75 0 001.28-.53V4.75z"
      }));
    }
    var ForwardRef = React.forwardRef(VideoCameraIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ViewColumnsIcon.js
var require_ViewColumnsIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ViewColumnsIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ViewColumnsIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M14 17h2.75A2.25 2.25 0 0019 14.75v-9.5A2.25 2.25 0 0016.75 3H14v14zM12.5 3h-5v14h5V3zM3.25 3H6v14H3.25A2.25 2.25 0 011 14.75v-9.5A2.25 2.25 0 013.25 3z"
      }));
    }
    var ForwardRef = React.forwardRef(ViewColumnsIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ViewfinderCircleIcon.js
var require_ViewfinderCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/ViewfinderCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function ViewfinderCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M4.25 2A2.25 2.25 0 002 4.25v2a.75.75 0 001.5 0v-2a.75.75 0 01.75-.75h2a.75.75 0 000-1.5h-2zM13.75 2a.75.75 0 000 1.5h2a.75.75 0 01.75.75v2a.75.75 0 001.5 0v-2A2.25 2.25 0 0015.75 2h-2zM3.5 13.75a.75.75 0 00-1.5 0v2A2.25 2.25 0 004.25 18h2a.75.75 0 000-1.5h-2a.75.75 0 01-.75-.75v-2zM18 13.75a.75.75 0 00-1.5 0v2a.75.75 0 01-.75.75h-2a.75.75 0 000 1.5h2A2.25 2.25 0 0018 15.75v-2zM7 10a3 3 0 116 0 3 3 0 01-6 0z"
      }));
    }
    var ForwardRef = React.forwardRef(ViewfinderCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/WalletIcon.js
var require_WalletIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/WalletIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function WalletIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M1 4.25a3.733 3.733 0 012.25-.75h13.5c.844 0 1.623.279 2.25.75A2.25 2.25 0 0016.75 2H3.25A2.25 2.25 0 001 4.25zM1 7.25a3.733 3.733 0 012.25-.75h13.5c.844 0 1.623.279 2.25.75A2.25 2.25 0 0016.75 5H3.25A2.25 2.25 0 001 7.25zM7 8a1 1 0 011 1 2 2 0 104 0 1 1 0 011-1h3.75A2.25 2.25 0 0119 10.25v5.5A2.25 2.25 0 0116.75 18H3.25A2.25 2.25 0 011 15.75v-5.5A2.25 2.25 0 013.25 8H7z"
      }));
    }
    var ForwardRef = React.forwardRef(WalletIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/WifiIcon.js
var require_WifiIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/WifiIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function WifiIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M.676 6.941A12.964 12.964 0 0110 3c3.657 0 6.963 1.511 9.324 3.941a.75.75 0 01-.008 1.053l-.353.354a.75.75 0 01-1.069-.008C15.894 6.28 13.097 5 10 5 6.903 5 4.106 6.28 2.106 8.34a.75.75 0 01-1.069.008l-.353-.354a.75.75 0 01-.008-1.053zm2.825 2.833A8.976 8.976 0 0110 7a8.976 8.976 0 016.499 2.774.75.75 0 01-.011 1.049l-.354.354a.75.75 0 01-1.072-.012A6.978 6.978 0 0010 9c-1.99 0-3.786.83-5.061 2.165a.75.75 0 01-1.073.012l-.354-.354a.75.75 0 01-.01-1.05zm2.82 2.84A4.989 4.989 0 0110 11c1.456 0 2.767.623 3.68 1.614a.75.75 0 01-.022 1.039l-.354.354a.75.75 0 01-1.085-.026A2.99 2.99 0 0010 13c-.88 0-1.67.377-2.22.981a.75.75 0 01-1.084.026l-.354-.354a.75.75 0 01-.021-1.039zm2.795 2.752a1.248 1.248 0 011.768 0 .75.75 0 010 1.06l-.354.354a.75.75 0 01-1.06 0l-.354-.353a.75.75 0 010-1.06z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(WifiIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/WindowIcon.js
var require_WindowIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/WindowIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function WindowIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M3.25 3A2.25 2.25 0 001 5.25v9.5A2.25 2.25 0 003.25 17h13.5A2.25 2.25 0 0019 14.75v-9.5A2.25 2.25 0 0016.75 3H3.25zM2.5 9v5.75c0 .414.336.75.75.75h13.5a.75.75 0 00.75-.75V9h-15zM4 5.25a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75V6a.75.75 0 00-.75-.75H4zM6.25 6A.75.75 0 017 5.25h.01a.75.75 0 01.75.75v.01a.75.75 0 01-.75.75H7a.75.75 0 01-.75-.75V6zM10 5.25a.75.75 0 00-.75.75v.01c0 .414.336.75.75.75h.01a.75.75 0 00.75-.75V6a.75.75 0 00-.75-.75H10z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(WindowIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/WrenchScrewdriverIcon.js
var require_WrenchScrewdriverIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/WrenchScrewdriverIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function WrenchScrewdriverIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M14.5 10a4.5 4.5 0 004.284-5.882c-.105-.324-.51-.391-.752-.15L15.34 6.66a.454.454 0 01-.493.11 3.01 3.01 0 01-1.618-1.616.455.455 0 01.11-.494l2.694-2.692c.24-.241.174-.647-.15-.752a4.5 4.5 0 00-5.873 4.575c.055.873-.128 1.808-.8 2.368l-7.23 6.024a2.724 2.724 0 103.837 3.837l6.024-7.23c.56-.672 1.495-.855 2.368-.8.096.007.193.01.291.01zM5 16a1 1 0 11-2 0 1 1 0 012 0z",
        clipRule: "evenodd"
      }), /* @__PURE__ */ React.createElement("path", {
        d: "M14.5 11.5c.173 0 .345-.007.514-.022l3.754 3.754a2.5 2.5 0 01-3.536 3.536l-4.41-4.41 2.172-2.607c.052-.063.147-.138.342-.196.202-.06.469-.087.777-.067.128.008.257.012.387.012zM6 4.586l2.33 2.33a.452.452 0 01-.08.09L6.8 8.214 4.586 6H3.309a.5.5 0 01-.447-.276l-1.7-3.402a.5.5 0 01.093-.577l.49-.49a.5.5 0 01.577-.094l3.402 1.7A.5.5 0 016 3.31v1.277z"
      }));
    }
    var ForwardRef = React.forwardRef(WrenchScrewdriverIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/WrenchIcon.js
var require_WrenchIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/WrenchIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function WrenchIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M19 5.5a4.5 4.5 0 01-4.791 4.49c-.873-.055-1.808.128-2.368.8l-6.024 7.23a2.724 2.724 0 11-3.837-3.837L9.21 8.16c.672-.56.855-1.495.8-2.368a4.5 4.5 0 015.873-4.575c.324.105.39.51.15.752L13.34 4.66a.455.455 0 00-.11.494 3.01 3.01 0 001.617 1.617c.17.07.363.02.493-.111l2.692-2.692c.241-.241.647-.174.752.15.14.435.216.9.216 1.382zM4 17a1 1 0 100-2 1 1 0 000 2z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(WrenchIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/XCircleIcon.js
var require_XCircleIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/XCircleIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function XCircleIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        fillRule: "evenodd",
        d: "M10 18a8 8 0 100-16 8 8 0 000 16zM8.28 7.22a.75.75 0 00-1.06 1.06L8.94 10l-1.72 1.72a.75.75 0 101.06 1.06L10 11.06l1.72 1.72a.75.75 0 101.06-1.06L11.06 10l1.72-1.72a.75.75 0 00-1.06-1.06L10 8.94 8.28 7.22z",
        clipRule: "evenodd"
      }));
    }
    var ForwardRef = React.forwardRef(XCircleIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/XMarkIcon.js
var require_XMarkIcon = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/XMarkIcon.js"(exports, module) {
    var React = (init_compat_module(), __toCommonJS(compat_module_exports));
    function XMarkIcon({
      title,
      titleId,
      ...props
    }, svgRef) {
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 20 20",
        fill: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        d: "M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z"
      }));
    }
    var ForwardRef = React.forwardRef(XMarkIcon);
    module.exports = ForwardRef;
  }
});

// ../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/index.js
var require_solid = __commonJS({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.3.1/node_modules/@heroicons/react/20/solid/index.js"(exports, module) {
    module.exports.AcademicCapIcon = require_AcademicCapIcon();
    module.exports.AdjustmentsHorizontalIcon = require_AdjustmentsHorizontalIcon();
    module.exports.AdjustmentsVerticalIcon = require_AdjustmentsVerticalIcon();
    module.exports.ArchiveBoxArrowDownIcon = require_ArchiveBoxArrowDownIcon();
    module.exports.ArchiveBoxXMarkIcon = require_ArchiveBoxXMarkIcon();
    module.exports.ArchiveBoxIcon = require_ArchiveBoxIcon();
    module.exports.ArrowDownCircleIcon = require_ArrowDownCircleIcon();
    module.exports.ArrowDownLeftIcon = require_ArrowDownLeftIcon();
    module.exports.ArrowDownOnSquareStackIcon = require_ArrowDownOnSquareStackIcon();
    module.exports.ArrowDownOnSquareIcon = require_ArrowDownOnSquareIcon();
    module.exports.ArrowDownRightIcon = require_ArrowDownRightIcon();
    module.exports.ArrowDownTrayIcon = require_ArrowDownTrayIcon();
    module.exports.ArrowDownIcon = require_ArrowDownIcon();
    module.exports.ArrowLeftCircleIcon = require_ArrowLeftCircleIcon();
    module.exports.ArrowLeftOnRectangleIcon = require_ArrowLeftOnRectangleIcon();
    module.exports.ArrowLeftIcon = require_ArrowLeftIcon();
    module.exports.ArrowLongDownIcon = require_ArrowLongDownIcon();
    module.exports.ArrowLongLeftIcon = require_ArrowLongLeftIcon();
    module.exports.ArrowLongRightIcon = require_ArrowLongRightIcon();
    module.exports.ArrowLongUpIcon = require_ArrowLongUpIcon();
    module.exports.ArrowPathRoundedSquareIcon = require_ArrowPathRoundedSquareIcon();
    module.exports.ArrowPathIcon = require_ArrowPathIcon();
    module.exports.ArrowRightCircleIcon = require_ArrowRightCircleIcon();
    module.exports.ArrowRightOnRectangleIcon = require_ArrowRightOnRectangleIcon();
    module.exports.ArrowRightIcon = require_ArrowRightIcon();
    module.exports.ArrowSmallDownIcon = require_ArrowSmallDownIcon();
    module.exports.ArrowSmallLeftIcon = require_ArrowSmallLeftIcon();
    module.exports.ArrowSmallRightIcon = require_ArrowSmallRightIcon();
    module.exports.ArrowSmallUpIcon = require_ArrowSmallUpIcon();
    module.exports.ArrowTopRightOnSquareIcon = require_ArrowTopRightOnSquareIcon();
    module.exports.ArrowTrendingDownIcon = require_ArrowTrendingDownIcon();
    module.exports.ArrowTrendingUpIcon = require_ArrowTrendingUpIcon();
    module.exports.ArrowUpCircleIcon = require_ArrowUpCircleIcon();
    module.exports.ArrowUpLeftIcon = require_ArrowUpLeftIcon();
    module.exports.ArrowUpOnSquareStackIcon = require_ArrowUpOnSquareStackIcon();
    module.exports.ArrowUpOnSquareIcon = require_ArrowUpOnSquareIcon();
    module.exports.ArrowUpRightIcon = require_ArrowUpRightIcon();
    module.exports.ArrowUpTrayIcon = require_ArrowUpTrayIcon();
    module.exports.ArrowUpIcon = require_ArrowUpIcon();
    module.exports.ArrowUturnDownIcon = require_ArrowUturnDownIcon();
    module.exports.ArrowUturnLeftIcon = require_ArrowUturnLeftIcon();
    module.exports.ArrowUturnRightIcon = require_ArrowUturnRightIcon();
    module.exports.ArrowUturnUpIcon = require_ArrowUturnUpIcon();
    module.exports.ArrowsPointingInIcon = require_ArrowsPointingInIcon();
    module.exports.ArrowsPointingOutIcon = require_ArrowsPointingOutIcon();
    module.exports.ArrowsRightLeftIcon = require_ArrowsRightLeftIcon();
    module.exports.ArrowsUpDownIcon = require_ArrowsUpDownIcon();
    module.exports.AtSymbolIcon = require_AtSymbolIcon();
    module.exports.BackspaceIcon = require_BackspaceIcon();
    module.exports.BackwardIcon = require_BackwardIcon();
    module.exports.BanknotesIcon = require_BanknotesIcon();
    module.exports.Bars2Icon = require_Bars2Icon();
    module.exports.Bars3BottomLeftIcon = require_Bars3BottomLeftIcon();
    module.exports.Bars3BottomRightIcon = require_Bars3BottomRightIcon();
    module.exports.Bars3CenterLeftIcon = require_Bars3CenterLeftIcon();
    module.exports.Bars3Icon = require_Bars3Icon();
    module.exports.Bars4Icon = require_Bars4Icon();
    module.exports.BarsArrowDownIcon = require_BarsArrowDownIcon();
    module.exports.BarsArrowUpIcon = require_BarsArrowUpIcon();
    module.exports.Battery0Icon = require_Battery0Icon();
    module.exports.Battery100Icon = require_Battery100Icon();
    module.exports.Battery50Icon = require_Battery50Icon();
    module.exports.BeakerIcon = require_BeakerIcon();
    module.exports.BellAlertIcon = require_BellAlertIcon();
    module.exports.BellSlashIcon = require_BellSlashIcon();
    module.exports.BellSnoozeIcon = require_BellSnoozeIcon();
    module.exports.BellIcon = require_BellIcon();
    module.exports.BoltSlashIcon = require_BoltSlashIcon();
    module.exports.BoltIcon = require_BoltIcon();
    module.exports.BookOpenIcon = require_BookOpenIcon();
    module.exports.BookmarkSlashIcon = require_BookmarkSlashIcon();
    module.exports.BookmarkSquareIcon = require_BookmarkSquareIcon();
    module.exports.BookmarkIcon = require_BookmarkIcon();
    module.exports.BriefcaseIcon = require_BriefcaseIcon();
    module.exports.BugAntIcon = require_BugAntIcon();
    module.exports.BuildingLibraryIcon = require_BuildingLibraryIcon();
    module.exports.BuildingOffice2Icon = require_BuildingOffice2Icon();
    module.exports.BuildingOfficeIcon = require_BuildingOfficeIcon();
    module.exports.BuildingStorefrontIcon = require_BuildingStorefrontIcon();
    module.exports.CakeIcon = require_CakeIcon();
    module.exports.CalculatorIcon = require_CalculatorIcon();
    module.exports.CalendarDaysIcon = require_CalendarDaysIcon();
    module.exports.CalendarIcon = require_CalendarIcon();
    module.exports.CameraIcon = require_CameraIcon();
    module.exports.ChartBarSquareIcon = require_ChartBarSquareIcon();
    module.exports.ChartBarIcon = require_ChartBarIcon();
    module.exports.ChartPieIcon = require_ChartPieIcon();
    module.exports.ChatBubbleBottomCenterTextIcon = require_ChatBubbleBottomCenterTextIcon();
    module.exports.ChatBubbleBottomCenterIcon = require_ChatBubbleBottomCenterIcon();
    module.exports.ChatBubbleLeftEllipsisIcon = require_ChatBubbleLeftEllipsisIcon();
    module.exports.ChatBubbleLeftRightIcon = require_ChatBubbleLeftRightIcon();
    module.exports.ChatBubbleLeftIcon = require_ChatBubbleLeftIcon();
    module.exports.ChatBubbleOvalLeftEllipsisIcon = require_ChatBubbleOvalLeftEllipsisIcon();
    module.exports.ChatBubbleOvalLeftIcon = require_ChatBubbleOvalLeftIcon();
    module.exports.CheckBadgeIcon = require_CheckBadgeIcon();
    module.exports.CheckCircleIcon = require_CheckCircleIcon();
    module.exports.CheckIcon = require_CheckIcon();
    module.exports.ChevronDoubleDownIcon = require_ChevronDoubleDownIcon();
    module.exports.ChevronDoubleLeftIcon = require_ChevronDoubleLeftIcon();
    module.exports.ChevronDoubleRightIcon = require_ChevronDoubleRightIcon();
    module.exports.ChevronDoubleUpIcon = require_ChevronDoubleUpIcon();
    module.exports.ChevronDownIcon = require_ChevronDownIcon();
    module.exports.ChevronLeftIcon = require_ChevronLeftIcon();
    module.exports.ChevronRightIcon = require_ChevronRightIcon();
    module.exports.ChevronUpDownIcon = require_ChevronUpDownIcon();
    module.exports.ChevronUpIcon = require_ChevronUpIcon();
    module.exports.CircleStackIcon = require_CircleStackIcon();
    module.exports.ClipboardDocumentCheckIcon = require_ClipboardDocumentCheckIcon();
    module.exports.ClipboardDocumentListIcon = require_ClipboardDocumentListIcon();
    module.exports.ClipboardDocumentIcon = require_ClipboardDocumentIcon();
    module.exports.ClipboardIcon = require_ClipboardIcon();
    module.exports.ClockIcon = require_ClockIcon();
    module.exports.CloudArrowDownIcon = require_CloudArrowDownIcon();
    module.exports.CloudArrowUpIcon = require_CloudArrowUpIcon();
    module.exports.CloudIcon = require_CloudIcon();
    module.exports.CodeBracketSquareIcon = require_CodeBracketSquareIcon();
    module.exports.CodeBracketIcon = require_CodeBracketIcon();
    module.exports.Cog6ToothIcon = require_Cog6ToothIcon();
    module.exports.Cog8ToothIcon = require_Cog8ToothIcon();
    module.exports.CogIcon = require_CogIcon();
    module.exports.CommandLineIcon = require_CommandLineIcon();
    module.exports.ComputerDesktopIcon = require_ComputerDesktopIcon();
    module.exports.CpuChipIcon = require_CpuChipIcon();
    module.exports.CreditCardIcon = require_CreditCardIcon();
    module.exports.CubeTransparentIcon = require_CubeTransparentIcon();
    module.exports.CubeIcon = require_CubeIcon();
    module.exports.CurrencyBangladeshiIcon = require_CurrencyBangladeshiIcon();
    module.exports.CurrencyDollarIcon = require_CurrencyDollarIcon();
    module.exports.CurrencyEuroIcon = require_CurrencyEuroIcon();
    module.exports.CurrencyPoundIcon = require_CurrencyPoundIcon();
    module.exports.CurrencyRupeeIcon = require_CurrencyRupeeIcon();
    module.exports.CurrencyYenIcon = require_CurrencyYenIcon();
    module.exports.CursorArrowRaysIcon = require_CursorArrowRaysIcon();
    module.exports.CursorArrowRippleIcon = require_CursorArrowRippleIcon();
    module.exports.DevicePhoneMobileIcon = require_DevicePhoneMobileIcon();
    module.exports.DeviceTabletIcon = require_DeviceTabletIcon();
    module.exports.DocumentArrowDownIcon = require_DocumentArrowDownIcon();
    module.exports.DocumentArrowUpIcon = require_DocumentArrowUpIcon();
    module.exports.DocumentChartBarIcon = require_DocumentChartBarIcon();
    module.exports.DocumentCheckIcon = require_DocumentCheckIcon();
    module.exports.DocumentDuplicateIcon = require_DocumentDuplicateIcon();
    module.exports.DocumentMagnifyingGlassIcon = require_DocumentMagnifyingGlassIcon();
    module.exports.DocumentMinusIcon = require_DocumentMinusIcon();
    module.exports.DocumentPlusIcon = require_DocumentPlusIcon();
    module.exports.DocumentTextIcon = require_DocumentTextIcon();
    module.exports.DocumentIcon = require_DocumentIcon();
    module.exports.EllipsisHorizontalCircleIcon = require_EllipsisHorizontalCircleIcon();
    module.exports.EllipsisHorizontalIcon = require_EllipsisHorizontalIcon();
    module.exports.EllipsisVerticalIcon = require_EllipsisVerticalIcon();
    module.exports.EnvelopeOpenIcon = require_EnvelopeOpenIcon();
    module.exports.EnvelopeIcon = require_EnvelopeIcon();
    module.exports.ExclamationCircleIcon = require_ExclamationCircleIcon();
    module.exports.ExclamationTriangleIcon = require_ExclamationTriangleIcon();
    module.exports.EyeDropperIcon = require_EyeDropperIcon();
    module.exports.EyeSlashIcon = require_EyeSlashIcon();
    module.exports.EyeIcon = require_EyeIcon();
    module.exports.FaceFrownIcon = require_FaceFrownIcon();
    module.exports.FaceSmileIcon = require_FaceSmileIcon();
    module.exports.FilmIcon = require_FilmIcon();
    module.exports.FingerPrintIcon = require_FingerPrintIcon();
    module.exports.FireIcon = require_FireIcon();
    module.exports.FlagIcon = require_FlagIcon();
    module.exports.FolderArrowDownIcon = require_FolderArrowDownIcon();
    module.exports.FolderMinusIcon = require_FolderMinusIcon();
    module.exports.FolderOpenIcon = require_FolderOpenIcon();
    module.exports.FolderPlusIcon = require_FolderPlusIcon();
    module.exports.FolderIcon = require_FolderIcon();
    module.exports.ForwardIcon = require_ForwardIcon();
    module.exports.FunnelIcon = require_FunnelIcon();
    module.exports.GifIcon = require_GifIcon();
    module.exports.GiftTopIcon = require_GiftTopIcon();
    module.exports.GiftIcon = require_GiftIcon();
    module.exports.GlobeAltIcon = require_GlobeAltIcon();
    module.exports.GlobeAmericasIcon = require_GlobeAmericasIcon();
    module.exports.GlobeAsiaAustraliaIcon = require_GlobeAsiaAustraliaIcon();
    module.exports.GlobeEuropeAfricaIcon = require_GlobeEuropeAfricaIcon();
    module.exports.HandRaisedIcon = require_HandRaisedIcon();
    module.exports.HandThumbDownIcon = require_HandThumbDownIcon();
    module.exports.HandThumbUpIcon = require_HandThumbUpIcon();
    module.exports.HashtagIcon = require_HashtagIcon();
    module.exports.HeartIcon = require_HeartIcon();
    module.exports.HomeModernIcon = require_HomeModernIcon();
    module.exports.HomeIcon = require_HomeIcon();
    module.exports.IdentificationIcon = require_IdentificationIcon();
    module.exports.InboxArrowDownIcon = require_InboxArrowDownIcon();
    module.exports.InboxStackIcon = require_InboxStackIcon();
    module.exports.InboxIcon = require_InboxIcon();
    module.exports.InformationCircleIcon = require_InformationCircleIcon();
    module.exports.KeyIcon = require_KeyIcon();
    module.exports.LanguageIcon = require_LanguageIcon();
    module.exports.LifebuoyIcon = require_LifebuoyIcon();
    module.exports.LightBulbIcon = require_LightBulbIcon();
    module.exports.LinkIcon = require_LinkIcon();
    module.exports.ListBulletIcon = require_ListBulletIcon();
    module.exports.LockClosedIcon = require_LockClosedIcon();
    module.exports.LockOpenIcon = require_LockOpenIcon();
    module.exports.MagnifyingGlassCircleIcon = require_MagnifyingGlassCircleIcon();
    module.exports.MagnifyingGlassMinusIcon = require_MagnifyingGlassMinusIcon();
    module.exports.MagnifyingGlassPlusIcon = require_MagnifyingGlassPlusIcon();
    module.exports.MagnifyingGlassIcon = require_MagnifyingGlassIcon();
    module.exports.MapPinIcon = require_MapPinIcon();
    module.exports.MapIcon = require_MapIcon();
    module.exports.MegaphoneIcon = require_MegaphoneIcon();
    module.exports.MicrophoneIcon = require_MicrophoneIcon();
    module.exports.MinusCircleIcon = require_MinusCircleIcon();
    module.exports.MinusSmallIcon = require_MinusSmallIcon();
    module.exports.MinusIcon = require_MinusIcon();
    module.exports.MoonIcon = require_MoonIcon();
    module.exports.MusicalNoteIcon = require_MusicalNoteIcon();
    module.exports.NewspaperIcon = require_NewspaperIcon();
    module.exports.NoSymbolIcon = require_NoSymbolIcon();
    module.exports.PaintBrushIcon = require_PaintBrushIcon();
    module.exports.PaperAirplaneIcon = require_PaperAirplaneIcon();
    module.exports.PaperClipIcon = require_PaperClipIcon();
    module.exports.PauseCircleIcon = require_PauseCircleIcon();
    module.exports.PauseIcon = require_PauseIcon();
    module.exports.PencilSquareIcon = require_PencilSquareIcon();
    module.exports.PencilIcon = require_PencilIcon();
    module.exports.PhoneArrowDownLeftIcon = require_PhoneArrowDownLeftIcon();
    module.exports.PhoneArrowUpRightIcon = require_PhoneArrowUpRightIcon();
    module.exports.PhoneXMarkIcon = require_PhoneXMarkIcon();
    module.exports.PhoneIcon = require_PhoneIcon();
    module.exports.PhotoIcon = require_PhotoIcon();
    module.exports.PlayCircleIcon = require_PlayCircleIcon();
    module.exports.PlayPauseIcon = require_PlayPauseIcon();
    module.exports.PlayIcon = require_PlayIcon();
    module.exports.PlusCircleIcon = require_PlusCircleIcon();
    module.exports.PlusSmallIcon = require_PlusSmallIcon();
    module.exports.PlusIcon = require_PlusIcon();
    module.exports.PowerIcon = require_PowerIcon();
    module.exports.PresentationChartBarIcon = require_PresentationChartBarIcon();
    module.exports.PresentationChartLineIcon = require_PresentationChartLineIcon();
    module.exports.PrinterIcon = require_PrinterIcon();
    module.exports.PuzzlePieceIcon = require_PuzzlePieceIcon();
    module.exports.QrCodeIcon = require_QrCodeIcon();
    module.exports.QuestionMarkCircleIcon = require_QuestionMarkCircleIcon();
    module.exports.QueueListIcon = require_QueueListIcon();
    module.exports.RadioIcon = require_RadioIcon();
    module.exports.ReceiptPercentIcon = require_ReceiptPercentIcon();
    module.exports.ReceiptRefundIcon = require_ReceiptRefundIcon();
    module.exports.RectangleGroupIcon = require_RectangleGroupIcon();
    module.exports.RectangleStackIcon = require_RectangleStackIcon();
    module.exports.RocketLaunchIcon = require_RocketLaunchIcon();
    module.exports.RssIcon = require_RssIcon();
    module.exports.ScaleIcon = require_ScaleIcon();
    module.exports.ScissorsIcon = require_ScissorsIcon();
    module.exports.ServerStackIcon = require_ServerStackIcon();
    module.exports.ServerIcon = require_ServerIcon();
    module.exports.ShareIcon = require_ShareIcon();
    module.exports.ShieldCheckIcon = require_ShieldCheckIcon();
    module.exports.ShieldExclamationIcon = require_ShieldExclamationIcon();
    module.exports.ShoppingBagIcon = require_ShoppingBagIcon();
    module.exports.ShoppingCartIcon = require_ShoppingCartIcon();
    module.exports.SignalSlashIcon = require_SignalSlashIcon();
    module.exports.SignalIcon = require_SignalIcon();
    module.exports.SparklesIcon = require_SparklesIcon();
    module.exports.SpeakerWaveIcon = require_SpeakerWaveIcon();
    module.exports.SpeakerXMarkIcon = require_SpeakerXMarkIcon();
    module.exports.Square2StackIcon = require_Square2StackIcon();
    module.exports.Square3Stack3DIcon = require_Square3Stack3DIcon();
    module.exports.Squares2X2Icon = require_Squares2X2Icon();
    module.exports.SquaresPlusIcon = require_SquaresPlusIcon();
    module.exports.StarIcon = require_StarIcon();
    module.exports.StopCircleIcon = require_StopCircleIcon();
    module.exports.StopIcon = require_StopIcon();
    module.exports.SunIcon = require_SunIcon();
    module.exports.SwatchIcon = require_SwatchIcon();
    module.exports.TableCellsIcon = require_TableCellsIcon();
    module.exports.TagIcon = require_TagIcon();
    module.exports.TicketIcon = require_TicketIcon();
    module.exports.TrashIcon = require_TrashIcon();
    module.exports.TrophyIcon = require_TrophyIcon();
    module.exports.TruckIcon = require_TruckIcon();
    module.exports.TvIcon = require_TvIcon();
    module.exports.UserCircleIcon = require_UserCircleIcon();
    module.exports.UserGroupIcon = require_UserGroupIcon();
    module.exports.UserMinusIcon = require_UserMinusIcon();
    module.exports.UserPlusIcon = require_UserPlusIcon();
    module.exports.UserIcon = require_UserIcon();
    module.exports.UsersIcon = require_UsersIcon();
    module.exports.VariableIcon = require_VariableIcon();
    module.exports.VideoCameraSlashIcon = require_VideoCameraSlashIcon();
    module.exports.VideoCameraIcon = require_VideoCameraIcon();
    module.exports.ViewColumnsIcon = require_ViewColumnsIcon();
    module.exports.ViewfinderCircleIcon = require_ViewfinderCircleIcon();
    module.exports.WalletIcon = require_WalletIcon();
    module.exports.WifiIcon = require_WifiIcon();
    module.exports.WindowIcon = require_WindowIcon();
    module.exports.WrenchScrewdriverIcon = require_WrenchScrewdriverIcon();
    module.exports.WrenchIcon = require_WrenchIcon();
    module.exports.XCircleIcon = require_XCircleIcon();
    module.exports.XMarkIcon = require_XMarkIcon();
  }
});

// ../taler-util/lib/nacl-fast.js
var gf = function(init = []) {
  const r3 = new Float64Array(16);
  if (init)
    for (let i5 = 0; i5 < init.length; i5++)
      r3[i5] = init[i5];
  return r3;
};
var randombytes = function(x6, n2) {
  throw new Error("no PRNG");
};
var _9 = new Uint8Array(32);
_9[0] = 9;
var gf0 = gf();
var gf1 = gf([1]);
var _121665 = gf([56129, 1]);
var D = gf([
  30883,
  4953,
  19914,
  30187,
  55467,
  16705,
  2637,
  112,
  59544,
  30585,
  16505,
  36039,
  65139,
  11119,
  27886,
  20995
]);
var D2 = gf([
  61785,
  9906,
  39828,
  60374,
  45398,
  33411,
  5274,
  224,
  53552,
  61171,
  33010,
  6542,
  64743,
  22239,
  55772,
  9222
]);
var X = gf([
  54554,
  36645,
  11616,
  51542,
  42930,
  38181,
  51040,
  26924,
  56412,
  64982,
  57905,
  49316,
  21502,
  52590,
  14035,
  8553
]);
var Y = gf([
  26200,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214
]);
var I = gf([
  41136,
  18958,
  6951,
  50414,
  58488,
  44335,
  6150,
  12099,
  55207,
  15867,
  153,
  11085,
  57099,
  20417,
  9344,
  11139
]);
function ts64(x6, i5, h5, l3) {
  x6[i5] = h5 >> 24 & 255;
  x6[i5 + 1] = h5 >> 16 & 255;
  x6[i5 + 2] = h5 >> 8 & 255;
  x6[i5 + 3] = h5 & 255;
  x6[i5 + 4] = l3 >> 24 & 255;
  x6[i5 + 5] = l3 >> 16 & 255;
  x6[i5 + 6] = l3 >> 8 & 255;
  x6[i5 + 7] = l3 & 255;
}
function vn(x6, xi, y6, yi, n2) {
  let i5, d6 = 0;
  for (i5 = 0; i5 < n2; i5++)
    d6 |= x6[xi + i5] ^ y6[yi + i5];
  return (1 & d6 - 1 >>> 8) - 1;
}
function crypto_verify_16(x6, xi, y6, yi) {
  return vn(x6, xi, y6, yi, 16);
}
function crypto_verify_32(x6, xi, y6, yi) {
  return vn(x6, xi, y6, yi, 32);
}
function core_salsa20(o3, p4, k6, c5) {
  var j0 = c5[0] & 255 | (c5[1] & 255) << 8 | (c5[2] & 255) << 16 | (c5[3] & 255) << 24, j1 = k6[0] & 255 | (k6[1] & 255) << 8 | (k6[2] & 255) << 16 | (k6[3] & 255) << 24, j22 = k6[4] & 255 | (k6[5] & 255) << 8 | (k6[6] & 255) << 16 | (k6[7] & 255) << 24, j32 = k6[8] & 255 | (k6[9] & 255) << 8 | (k6[10] & 255) << 16 | (k6[11] & 255) << 24, j4 = k6[12] & 255 | (k6[13] & 255) << 8 | (k6[14] & 255) << 16 | (k6[15] & 255) << 24, j5 = c5[4] & 255 | (c5[5] & 255) << 8 | (c5[6] & 255) << 16 | (c5[7] & 255) << 24, j6 = p4[0] & 255 | (p4[1] & 255) << 8 | (p4[2] & 255) << 16 | (p4[3] & 255) << 24, j7 = p4[4] & 255 | (p4[5] & 255) << 8 | (p4[6] & 255) << 16 | (p4[7] & 255) << 24, j8 = p4[8] & 255 | (p4[9] & 255) << 8 | (p4[10] & 255) << 16 | (p4[11] & 255) << 24, j9 = p4[12] & 255 | (p4[13] & 255) << 8 | (p4[14] & 255) << 16 | (p4[15] & 255) << 24, j10 = c5[8] & 255 | (c5[9] & 255) << 8 | (c5[10] & 255) << 16 | (c5[11] & 255) << 24, j11 = k6[16] & 255 | (k6[17] & 255) << 8 | (k6[18] & 255) << 16 | (k6[19] & 255) << 24, j12 = k6[20] & 255 | (k6[21] & 255) << 8 | (k6[22] & 255) << 16 | (k6[23] & 255) << 24, j13 = k6[24] & 255 | (k6[25] & 255) << 8 | (k6[26] & 255) << 16 | (k6[27] & 255) << 24, j14 = k6[28] & 255 | (k6[29] & 255) << 8 | (k6[30] & 255) << 16 | (k6[31] & 255) << 24, j15 = c5[12] & 255 | (c5[13] & 255) << 8 | (c5[14] & 255) << 16 | (c5[15] & 255) << 24;
  var x0 = j0, x1 = j1, x22 = j22, x32 = j32, x42 = j4, x52 = j5, x6 = j6, x7 = j7, x8 = j8, x9 = j9, x10 = j10, x11 = j11, x12 = j12, x13 = j13, x14 = j14, x15 = j15, u5;
  for (var i5 = 0; i5 < 20; i5 += 2) {
    u5 = x0 + x12 | 0;
    x42 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x42 + x0 | 0;
    x8 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x8 + x42 | 0;
    x12 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x12 + x8 | 0;
    x0 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x52 + x1 | 0;
    x9 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x9 + x52 | 0;
    x13 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x13 + x9 | 0;
    x1 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x1 + x13 | 0;
    x52 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x10 + x6 | 0;
    x14 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x14 + x10 | 0;
    x22 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x22 + x14 | 0;
    x6 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x6 + x22 | 0;
    x10 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x15 + x11 | 0;
    x32 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x32 + x15 | 0;
    x7 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x7 + x32 | 0;
    x11 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x11 + x7 | 0;
    x15 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x0 + x32 | 0;
    x1 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x1 + x0 | 0;
    x22 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x22 + x1 | 0;
    x32 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x32 + x22 | 0;
    x0 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x52 + x42 | 0;
    x6 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x6 + x52 | 0;
    x7 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x7 + x6 | 0;
    x42 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x42 + x7 | 0;
    x52 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x10 + x9 | 0;
    x11 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x11 + x10 | 0;
    x8 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x8 + x11 | 0;
    x9 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x9 + x8 | 0;
    x10 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x15 + x14 | 0;
    x12 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x12 + x15 | 0;
    x13 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x13 + x12 | 0;
    x14 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x14 + x13 | 0;
    x15 ^= u5 << 18 | u5 >>> 32 - 18;
  }
  x0 = x0 + j0 | 0;
  x1 = x1 + j1 | 0;
  x22 = x22 + j22 | 0;
  x32 = x32 + j32 | 0;
  x42 = x42 + j4 | 0;
  x52 = x52 + j5 | 0;
  x6 = x6 + j6 | 0;
  x7 = x7 + j7 | 0;
  x8 = x8 + j8 | 0;
  x9 = x9 + j9 | 0;
  x10 = x10 + j10 | 0;
  x11 = x11 + j11 | 0;
  x12 = x12 + j12 | 0;
  x13 = x13 + j13 | 0;
  x14 = x14 + j14 | 0;
  x15 = x15 + j15 | 0;
  o3[0] = x0 >>> 0 & 255;
  o3[1] = x0 >>> 8 & 255;
  o3[2] = x0 >>> 16 & 255;
  o3[3] = x0 >>> 24 & 255;
  o3[4] = x1 >>> 0 & 255;
  o3[5] = x1 >>> 8 & 255;
  o3[6] = x1 >>> 16 & 255;
  o3[7] = x1 >>> 24 & 255;
  o3[8] = x22 >>> 0 & 255;
  o3[9] = x22 >>> 8 & 255;
  o3[10] = x22 >>> 16 & 255;
  o3[11] = x22 >>> 24 & 255;
  o3[12] = x32 >>> 0 & 255;
  o3[13] = x32 >>> 8 & 255;
  o3[14] = x32 >>> 16 & 255;
  o3[15] = x32 >>> 24 & 255;
  o3[16] = x42 >>> 0 & 255;
  o3[17] = x42 >>> 8 & 255;
  o3[18] = x42 >>> 16 & 255;
  o3[19] = x42 >>> 24 & 255;
  o3[20] = x52 >>> 0 & 255;
  o3[21] = x52 >>> 8 & 255;
  o3[22] = x52 >>> 16 & 255;
  o3[23] = x52 >>> 24 & 255;
  o3[24] = x6 >>> 0 & 255;
  o3[25] = x6 >>> 8 & 255;
  o3[26] = x6 >>> 16 & 255;
  o3[27] = x6 >>> 24 & 255;
  o3[28] = x7 >>> 0 & 255;
  o3[29] = x7 >>> 8 & 255;
  o3[30] = x7 >>> 16 & 255;
  o3[31] = x7 >>> 24 & 255;
  o3[32] = x8 >>> 0 & 255;
  o3[33] = x8 >>> 8 & 255;
  o3[34] = x8 >>> 16 & 255;
  o3[35] = x8 >>> 24 & 255;
  o3[36] = x9 >>> 0 & 255;
  o3[37] = x9 >>> 8 & 255;
  o3[38] = x9 >>> 16 & 255;
  o3[39] = x9 >>> 24 & 255;
  o3[40] = x10 >>> 0 & 255;
  o3[41] = x10 >>> 8 & 255;
  o3[42] = x10 >>> 16 & 255;
  o3[43] = x10 >>> 24 & 255;
  o3[44] = x11 >>> 0 & 255;
  o3[45] = x11 >>> 8 & 255;
  o3[46] = x11 >>> 16 & 255;
  o3[47] = x11 >>> 24 & 255;
  o3[48] = x12 >>> 0 & 255;
  o3[49] = x12 >>> 8 & 255;
  o3[50] = x12 >>> 16 & 255;
  o3[51] = x12 >>> 24 & 255;
  o3[52] = x13 >>> 0 & 255;
  o3[53] = x13 >>> 8 & 255;
  o3[54] = x13 >>> 16 & 255;
  o3[55] = x13 >>> 24 & 255;
  o3[56] = x14 >>> 0 & 255;
  o3[57] = x14 >>> 8 & 255;
  o3[58] = x14 >>> 16 & 255;
  o3[59] = x14 >>> 24 & 255;
  o3[60] = x15 >>> 0 & 255;
  o3[61] = x15 >>> 8 & 255;
  o3[62] = x15 >>> 16 & 255;
  o3[63] = x15 >>> 24 & 255;
}
function core_hsalsa20(o3, p4, k6, c5) {
  var j0 = c5[0] & 255 | (c5[1] & 255) << 8 | (c5[2] & 255) << 16 | (c5[3] & 255) << 24, j1 = k6[0] & 255 | (k6[1] & 255) << 8 | (k6[2] & 255) << 16 | (k6[3] & 255) << 24, j22 = k6[4] & 255 | (k6[5] & 255) << 8 | (k6[6] & 255) << 16 | (k6[7] & 255) << 24, j32 = k6[8] & 255 | (k6[9] & 255) << 8 | (k6[10] & 255) << 16 | (k6[11] & 255) << 24, j4 = k6[12] & 255 | (k6[13] & 255) << 8 | (k6[14] & 255) << 16 | (k6[15] & 255) << 24, j5 = c5[4] & 255 | (c5[5] & 255) << 8 | (c5[6] & 255) << 16 | (c5[7] & 255) << 24, j6 = p4[0] & 255 | (p4[1] & 255) << 8 | (p4[2] & 255) << 16 | (p4[3] & 255) << 24, j7 = p4[4] & 255 | (p4[5] & 255) << 8 | (p4[6] & 255) << 16 | (p4[7] & 255) << 24, j8 = p4[8] & 255 | (p4[9] & 255) << 8 | (p4[10] & 255) << 16 | (p4[11] & 255) << 24, j9 = p4[12] & 255 | (p4[13] & 255) << 8 | (p4[14] & 255) << 16 | (p4[15] & 255) << 24, j10 = c5[8] & 255 | (c5[9] & 255) << 8 | (c5[10] & 255) << 16 | (c5[11] & 255) << 24, j11 = k6[16] & 255 | (k6[17] & 255) << 8 | (k6[18] & 255) << 16 | (k6[19] & 255) << 24, j12 = k6[20] & 255 | (k6[21] & 255) << 8 | (k6[22] & 255) << 16 | (k6[23] & 255) << 24, j13 = k6[24] & 255 | (k6[25] & 255) << 8 | (k6[26] & 255) << 16 | (k6[27] & 255) << 24, j14 = k6[28] & 255 | (k6[29] & 255) << 8 | (k6[30] & 255) << 16 | (k6[31] & 255) << 24, j15 = c5[12] & 255 | (c5[13] & 255) << 8 | (c5[14] & 255) << 16 | (c5[15] & 255) << 24;
  var x0 = j0, x1 = j1, x22 = j22, x32 = j32, x42 = j4, x52 = j5, x6 = j6, x7 = j7, x8 = j8, x9 = j9, x10 = j10, x11 = j11, x12 = j12, x13 = j13, x14 = j14, x15 = j15, u5;
  for (var i5 = 0; i5 < 20; i5 += 2) {
    u5 = x0 + x12 | 0;
    x42 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x42 + x0 | 0;
    x8 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x8 + x42 | 0;
    x12 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x12 + x8 | 0;
    x0 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x52 + x1 | 0;
    x9 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x9 + x52 | 0;
    x13 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x13 + x9 | 0;
    x1 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x1 + x13 | 0;
    x52 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x10 + x6 | 0;
    x14 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x14 + x10 | 0;
    x22 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x22 + x14 | 0;
    x6 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x6 + x22 | 0;
    x10 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x15 + x11 | 0;
    x32 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x32 + x15 | 0;
    x7 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x7 + x32 | 0;
    x11 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x11 + x7 | 0;
    x15 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x0 + x32 | 0;
    x1 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x1 + x0 | 0;
    x22 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x22 + x1 | 0;
    x32 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x32 + x22 | 0;
    x0 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x52 + x42 | 0;
    x6 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x6 + x52 | 0;
    x7 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x7 + x6 | 0;
    x42 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x42 + x7 | 0;
    x52 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x10 + x9 | 0;
    x11 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x11 + x10 | 0;
    x8 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x8 + x11 | 0;
    x9 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x9 + x8 | 0;
    x10 ^= u5 << 18 | u5 >>> 32 - 18;
    u5 = x15 + x14 | 0;
    x12 ^= u5 << 7 | u5 >>> 32 - 7;
    u5 = x12 + x15 | 0;
    x13 ^= u5 << 9 | u5 >>> 32 - 9;
    u5 = x13 + x12 | 0;
    x14 ^= u5 << 13 | u5 >>> 32 - 13;
    u5 = x14 + x13 | 0;
    x15 ^= u5 << 18 | u5 >>> 32 - 18;
  }
  o3[0] = x0 >>> 0 & 255;
  o3[1] = x0 >>> 8 & 255;
  o3[2] = x0 >>> 16 & 255;
  o3[3] = x0 >>> 24 & 255;
  o3[4] = x52 >>> 0 & 255;
  o3[5] = x52 >>> 8 & 255;
  o3[6] = x52 >>> 16 & 255;
  o3[7] = x52 >>> 24 & 255;
  o3[8] = x10 >>> 0 & 255;
  o3[9] = x10 >>> 8 & 255;
  o3[10] = x10 >>> 16 & 255;
  o3[11] = x10 >>> 24 & 255;
  o3[12] = x15 >>> 0 & 255;
  o3[13] = x15 >>> 8 & 255;
  o3[14] = x15 >>> 16 & 255;
  o3[15] = x15 >>> 24 & 255;
  o3[16] = x6 >>> 0 & 255;
  o3[17] = x6 >>> 8 & 255;
  o3[18] = x6 >>> 16 & 255;
  o3[19] = x6 >>> 24 & 255;
  o3[20] = x7 >>> 0 & 255;
  o3[21] = x7 >>> 8 & 255;
  o3[22] = x7 >>> 16 & 255;
  o3[23] = x7 >>> 24 & 255;
  o3[24] = x8 >>> 0 & 255;
  o3[25] = x8 >>> 8 & 255;
  o3[26] = x8 >>> 16 & 255;
  o3[27] = x8 >>> 24 & 255;
  o3[28] = x9 >>> 0 & 255;
  o3[29] = x9 >>> 8 & 255;
  o3[30] = x9 >>> 16 & 255;
  o3[31] = x9 >>> 24 & 255;
}
var sigma = new Uint8Array([
  101,
  120,
  112,
  97,
  110,
  100,
  32,
  51,
  50,
  45,
  98,
  121,
  116,
  101,
  32,
  107
]);
function crypto_stream_salsa20_xor(c5, cpos, m6, mpos, b5, n2, k6) {
  var z6 = new Uint8Array(16), x6 = new Uint8Array(64);
  var u5, i5;
  for (i5 = 0; i5 < 16; i5++)
    z6[i5] = 0;
  for (i5 = 0; i5 < 8; i5++)
    z6[i5] = n2[i5];
  while (b5 >= 64) {
    core_salsa20(x6, z6, k6, sigma);
    for (i5 = 0; i5 < 64; i5++)
      c5[cpos + i5] = m6[mpos + i5] ^ x6[i5];
    u5 = 1;
    for (i5 = 8; i5 < 16; i5++) {
      u5 = u5 + (z6[i5] & 255) | 0;
      z6[i5] = u5 & 255;
      u5 >>>= 8;
    }
    b5 -= 64;
    cpos += 64;
    mpos += 64;
  }
  if (b5 > 0) {
    core_salsa20(x6, z6, k6, sigma);
    for (i5 = 0; i5 < b5; i5++)
      c5[cpos + i5] = m6[mpos + i5] ^ x6[i5];
  }
  return 0;
}
function crypto_stream_salsa20(c5, cpos, b5, n2, k6) {
  var z6 = new Uint8Array(16), x6 = new Uint8Array(64);
  var u5, i5;
  for (i5 = 0; i5 < 16; i5++)
    z6[i5] = 0;
  for (i5 = 0; i5 < 8; i5++)
    z6[i5] = n2[i5];
  while (b5 >= 64) {
    core_salsa20(x6, z6, k6, sigma);
    for (i5 = 0; i5 < 64; i5++)
      c5[cpos + i5] = x6[i5];
    u5 = 1;
    for (i5 = 8; i5 < 16; i5++) {
      u5 = u5 + (z6[i5] & 255) | 0;
      z6[i5] = u5 & 255;
      u5 >>>= 8;
    }
    b5 -= 64;
    cpos += 64;
  }
  if (b5 > 0) {
    core_salsa20(x6, z6, k6, sigma);
    for (i5 = 0; i5 < b5; i5++)
      c5[cpos + i5] = x6[i5];
  }
  return 0;
}
function crypto_stream(c5, cpos, d6, n2, k6) {
  var s6 = new Uint8Array(32);
  core_hsalsa20(s6, n2, k6, sigma);
  var sn2 = new Uint8Array(8);
  for (var i5 = 0; i5 < 8; i5++)
    sn2[i5] = n2[i5 + 16];
  return crypto_stream_salsa20(c5, cpos, d6, sn2, s6);
}
function crypto_stream_xor(c5, cpos, m6, mpos, d6, n2, k6) {
  var s6 = new Uint8Array(32);
  core_hsalsa20(s6, n2, k6, sigma);
  var sn2 = new Uint8Array(8);
  for (var i5 = 0; i5 < 8; i5++)
    sn2[i5] = n2[i5 + 16];
  return crypto_stream_salsa20_xor(c5, cpos, m6, mpos, d6, sn2, s6);
}
var poly1305 = class {
  constructor(key) {
    this.buffer = new Uint8Array(16);
    this.r = new Uint16Array(10);
    this.h = new Uint16Array(10);
    this.pad = new Uint16Array(8);
    this.leftover = 0;
    this.fin = 0;
    var t0, t1, t22, t32, t42, t5, t6, t7;
    t0 = key[0] & 255 | (key[1] & 255) << 8;
    this.r[0] = t0 & 8191;
    t1 = key[2] & 255 | (key[3] & 255) << 8;
    this.r[1] = (t0 >>> 13 | t1 << 3) & 8191;
    t22 = key[4] & 255 | (key[5] & 255) << 8;
    this.r[2] = (t1 >>> 10 | t22 << 6) & 7939;
    t32 = key[6] & 255 | (key[7] & 255) << 8;
    this.r[3] = (t22 >>> 7 | t32 << 9) & 8191;
    t42 = key[8] & 255 | (key[9] & 255) << 8;
    this.r[4] = (t32 >>> 4 | t42 << 12) & 255;
    this.r[5] = t42 >>> 1 & 8190;
    t5 = key[10] & 255 | (key[11] & 255) << 8;
    this.r[6] = (t42 >>> 14 | t5 << 2) & 8191;
    t6 = key[12] & 255 | (key[13] & 255) << 8;
    this.r[7] = (t5 >>> 11 | t6 << 5) & 8065;
    t7 = key[14] & 255 | (key[15] & 255) << 8;
    this.r[8] = (t6 >>> 8 | t7 << 8) & 8191;
    this.r[9] = t7 >>> 5 & 127;
    this.pad[0] = key[16] & 255 | (key[17] & 255) << 8;
    this.pad[1] = key[18] & 255 | (key[19] & 255) << 8;
    this.pad[2] = key[20] & 255 | (key[21] & 255) << 8;
    this.pad[3] = key[22] & 255 | (key[23] & 255) << 8;
    this.pad[4] = key[24] & 255 | (key[25] & 255) << 8;
    this.pad[5] = key[26] & 255 | (key[27] & 255) << 8;
    this.pad[6] = key[28] & 255 | (key[29] & 255) << 8;
    this.pad[7] = key[30] & 255 | (key[31] & 255) << 8;
  }
  blocks(m6, mpos, bytes) {
    var hibit = this.fin ? 0 : 1 << 11;
    var t0, t1, t22, t32, t42, t5, t6, t7, c5;
    var d0, d1, d23, d32, d42, d52, d6, d7, d8, d9;
    var h0 = this.h[0], h1 = this.h[1], h22 = this.h[2], h32 = this.h[3], h42 = this.h[4], h5 = this.h[5], h6 = this.h[6], h7 = this.h[7], h8 = this.h[8], h9 = this.h[9];
    var r0 = this.r[0], r1 = this.r[1], r22 = this.r[2], r3 = this.r[3], r4 = this.r[4], r5 = this.r[5], r6 = this.r[6], r7 = this.r[7], r8 = this.r[8], r9 = this.r[9];
    while (bytes >= 16) {
      t0 = m6[mpos + 0] & 255 | (m6[mpos + 1] & 255) << 8;
      h0 += t0 & 8191;
      t1 = m6[mpos + 2] & 255 | (m6[mpos + 3] & 255) << 8;
      h1 += (t0 >>> 13 | t1 << 3) & 8191;
      t22 = m6[mpos + 4] & 255 | (m6[mpos + 5] & 255) << 8;
      h22 += (t1 >>> 10 | t22 << 6) & 8191;
      t32 = m6[mpos + 6] & 255 | (m6[mpos + 7] & 255) << 8;
      h32 += (t22 >>> 7 | t32 << 9) & 8191;
      t42 = m6[mpos + 8] & 255 | (m6[mpos + 9] & 255) << 8;
      h42 += (t32 >>> 4 | t42 << 12) & 8191;
      h5 += t42 >>> 1 & 8191;
      t5 = m6[mpos + 10] & 255 | (m6[mpos + 11] & 255) << 8;
      h6 += (t42 >>> 14 | t5 << 2) & 8191;
      t6 = m6[mpos + 12] & 255 | (m6[mpos + 13] & 255) << 8;
      h7 += (t5 >>> 11 | t6 << 5) & 8191;
      t7 = m6[mpos + 14] & 255 | (m6[mpos + 15] & 255) << 8;
      h8 += (t6 >>> 8 | t7 << 8) & 8191;
      h9 += t7 >>> 5 | hibit;
      c5 = 0;
      d0 = c5;
      d0 += h0 * r0;
      d0 += h1 * (5 * r9);
      d0 += h22 * (5 * r8);
      d0 += h32 * (5 * r7);
      d0 += h42 * (5 * r6);
      c5 = d0 >>> 13;
      d0 &= 8191;
      d0 += h5 * (5 * r5);
      d0 += h6 * (5 * r4);
      d0 += h7 * (5 * r3);
      d0 += h8 * (5 * r22);
      d0 += h9 * (5 * r1);
      c5 += d0 >>> 13;
      d0 &= 8191;
      d1 = c5;
      d1 += h0 * r1;
      d1 += h1 * r0;
      d1 += h22 * (5 * r9);
      d1 += h32 * (5 * r8);
      d1 += h42 * (5 * r7);
      c5 = d1 >>> 13;
      d1 &= 8191;
      d1 += h5 * (5 * r6);
      d1 += h6 * (5 * r5);
      d1 += h7 * (5 * r4);
      d1 += h8 * (5 * r3);
      d1 += h9 * (5 * r22);
      c5 += d1 >>> 13;
      d1 &= 8191;
      d23 = c5;
      d23 += h0 * r22;
      d23 += h1 * r1;
      d23 += h22 * r0;
      d23 += h32 * (5 * r9);
      d23 += h42 * (5 * r8);
      c5 = d23 >>> 13;
      d23 &= 8191;
      d23 += h5 * (5 * r7);
      d23 += h6 * (5 * r6);
      d23 += h7 * (5 * r5);
      d23 += h8 * (5 * r4);
      d23 += h9 * (5 * r3);
      c5 += d23 >>> 13;
      d23 &= 8191;
      d32 = c5;
      d32 += h0 * r3;
      d32 += h1 * r22;
      d32 += h22 * r1;
      d32 += h32 * r0;
      d32 += h42 * (5 * r9);
      c5 = d32 >>> 13;
      d32 &= 8191;
      d32 += h5 * (5 * r8);
      d32 += h6 * (5 * r7);
      d32 += h7 * (5 * r6);
      d32 += h8 * (5 * r5);
      d32 += h9 * (5 * r4);
      c5 += d32 >>> 13;
      d32 &= 8191;
      d42 = c5;
      d42 += h0 * r4;
      d42 += h1 * r3;
      d42 += h22 * r22;
      d42 += h32 * r1;
      d42 += h42 * r0;
      c5 = d42 >>> 13;
      d42 &= 8191;
      d42 += h5 * (5 * r9);
      d42 += h6 * (5 * r8);
      d42 += h7 * (5 * r7);
      d42 += h8 * (5 * r6);
      d42 += h9 * (5 * r5);
      c5 += d42 >>> 13;
      d42 &= 8191;
      d52 = c5;
      d52 += h0 * r5;
      d52 += h1 * r4;
      d52 += h22 * r3;
      d52 += h32 * r22;
      d52 += h42 * r1;
      c5 = d52 >>> 13;
      d52 &= 8191;
      d52 += h5 * r0;
      d52 += h6 * (5 * r9);
      d52 += h7 * (5 * r8);
      d52 += h8 * (5 * r7);
      d52 += h9 * (5 * r6);
      c5 += d52 >>> 13;
      d52 &= 8191;
      d6 = c5;
      d6 += h0 * r6;
      d6 += h1 * r5;
      d6 += h22 * r4;
      d6 += h32 * r3;
      d6 += h42 * r22;
      c5 = d6 >>> 13;
      d6 &= 8191;
      d6 += h5 * r1;
      d6 += h6 * r0;
      d6 += h7 * (5 * r9);
      d6 += h8 * (5 * r8);
      d6 += h9 * (5 * r7);
      c5 += d6 >>> 13;
      d6 &= 8191;
      d7 = c5;
      d7 += h0 * r7;
      d7 += h1 * r6;
      d7 += h22 * r5;
      d7 += h32 * r4;
      d7 += h42 * r3;
      c5 = d7 >>> 13;
      d7 &= 8191;
      d7 += h5 * r22;
      d7 += h6 * r1;
      d7 += h7 * r0;
      d7 += h8 * (5 * r9);
      d7 += h9 * (5 * r8);
      c5 += d7 >>> 13;
      d7 &= 8191;
      d8 = c5;
      d8 += h0 * r8;
      d8 += h1 * r7;
      d8 += h22 * r6;
      d8 += h32 * r5;
      d8 += h42 * r4;
      c5 = d8 >>> 13;
      d8 &= 8191;
      d8 += h5 * r3;
      d8 += h6 * r22;
      d8 += h7 * r1;
      d8 += h8 * r0;
      d8 += h9 * (5 * r9);
      c5 += d8 >>> 13;
      d8 &= 8191;
      d9 = c5;
      d9 += h0 * r9;
      d9 += h1 * r8;
      d9 += h22 * r7;
      d9 += h32 * r6;
      d9 += h42 * r5;
      c5 = d9 >>> 13;
      d9 &= 8191;
      d9 += h5 * r4;
      d9 += h6 * r3;
      d9 += h7 * r22;
      d9 += h8 * r1;
      d9 += h9 * r0;
      c5 += d9 >>> 13;
      d9 &= 8191;
      c5 = (c5 << 2) + c5 | 0;
      c5 = c5 + d0 | 0;
      d0 = c5 & 8191;
      c5 = c5 >>> 13;
      d1 += c5;
      h0 = d0;
      h1 = d1;
      h22 = d23;
      h32 = d32;
      h42 = d42;
      h5 = d52;
      h6 = d6;
      h7 = d7;
      h8 = d8;
      h9 = d9;
      mpos += 16;
      bytes -= 16;
    }
    this.h[0] = h0;
    this.h[1] = h1;
    this.h[2] = h22;
    this.h[3] = h32;
    this.h[4] = h42;
    this.h[5] = h5;
    this.h[6] = h6;
    this.h[7] = h7;
    this.h[8] = h8;
    this.h[9] = h9;
  }
  finish(mac, macpos) {
    var g4 = new Uint16Array(10);
    var c5, mask, f3, i5;
    if (this.leftover) {
      i5 = this.leftover;
      this.buffer[i5++] = 1;
      for (; i5 < 16; i5++)
        this.buffer[i5] = 0;
      this.fin = 1;
      this.blocks(this.buffer, 0, 16);
    }
    c5 = this.h[1] >>> 13;
    this.h[1] &= 8191;
    for (i5 = 2; i5 < 10; i5++) {
      this.h[i5] += c5;
      c5 = this.h[i5] >>> 13;
      this.h[i5] &= 8191;
    }
    this.h[0] += c5 * 5;
    c5 = this.h[0] >>> 13;
    this.h[0] &= 8191;
    this.h[1] += c5;
    c5 = this.h[1] >>> 13;
    this.h[1] &= 8191;
    this.h[2] += c5;
    g4[0] = this.h[0] + 5;
    c5 = g4[0] >>> 13;
    g4[0] &= 8191;
    for (i5 = 1; i5 < 10; i5++) {
      g4[i5] = this.h[i5] + c5;
      c5 = g4[i5] >>> 13;
      g4[i5] &= 8191;
    }
    g4[9] -= 1 << 13;
    mask = (c5 ^ 1) - 1;
    for (i5 = 0; i5 < 10; i5++)
      g4[i5] &= mask;
    mask = ~mask;
    for (i5 = 0; i5 < 10; i5++)
      this.h[i5] = this.h[i5] & mask | g4[i5];
    this.h[0] = (this.h[0] | this.h[1] << 13) & 65535;
    this.h[1] = (this.h[1] >>> 3 | this.h[2] << 10) & 65535;
    this.h[2] = (this.h[2] >>> 6 | this.h[3] << 7) & 65535;
    this.h[3] = (this.h[3] >>> 9 | this.h[4] << 4) & 65535;
    this.h[4] = (this.h[4] >>> 12 | this.h[5] << 1 | this.h[6] << 14) & 65535;
    this.h[5] = (this.h[6] >>> 2 | this.h[7] << 11) & 65535;
    this.h[6] = (this.h[7] >>> 5 | this.h[8] << 8) & 65535;
    this.h[7] = (this.h[8] >>> 8 | this.h[9] << 5) & 65535;
    f3 = this.h[0] + this.pad[0];
    this.h[0] = f3 & 65535;
    for (i5 = 1; i5 < 8; i5++) {
      f3 = (this.h[i5] + this.pad[i5] | 0) + (f3 >>> 16) | 0;
      this.h[i5] = f3 & 65535;
    }
    mac[macpos + 0] = this.h[0] >>> 0 & 255;
    mac[macpos + 1] = this.h[0] >>> 8 & 255;
    mac[macpos + 2] = this.h[1] >>> 0 & 255;
    mac[macpos + 3] = this.h[1] >>> 8 & 255;
    mac[macpos + 4] = this.h[2] >>> 0 & 255;
    mac[macpos + 5] = this.h[2] >>> 8 & 255;
    mac[macpos + 6] = this.h[3] >>> 0 & 255;
    mac[macpos + 7] = this.h[3] >>> 8 & 255;
    mac[macpos + 8] = this.h[4] >>> 0 & 255;
    mac[macpos + 9] = this.h[4] >>> 8 & 255;
    mac[macpos + 10] = this.h[5] >>> 0 & 255;
    mac[macpos + 11] = this.h[5] >>> 8 & 255;
    mac[macpos + 12] = this.h[6] >>> 0 & 255;
    mac[macpos + 13] = this.h[6] >>> 8 & 255;
    mac[macpos + 14] = this.h[7] >>> 0 & 255;
    mac[macpos + 15] = this.h[7] >>> 8 & 255;
  }
  update(m6, mpos, bytes) {
    let i5;
    let want;
    if (this.leftover) {
      want = 16 - this.leftover;
      if (want > bytes)
        want = bytes;
      for (i5 = 0; i5 < want; i5++)
        this.buffer[this.leftover + i5] = m6[mpos + i5];
      bytes -= want;
      mpos += want;
      this.leftover += want;
      if (this.leftover < 16)
        return;
      this.blocks(this.buffer, 0, 16);
      this.leftover = 0;
    }
    if (bytes >= 16) {
      want = bytes - bytes % 16;
      this.blocks(m6, mpos, want);
      mpos += want;
      bytes -= want;
    }
    if (bytes) {
      for (i5 = 0; i5 < bytes; i5++)
        this.buffer[this.leftover + i5] = m6[mpos + i5];
      this.leftover += bytes;
    }
  }
};
function crypto_onetimeauth(out, outpos, m6, mpos, n2, k6) {
  var s6 = new poly1305(k6);
  s6.update(m6, mpos, n2);
  s6.finish(out, outpos);
  return 0;
}
function crypto_onetimeauth_verify(h5, hpos, m6, mpos, n2, k6) {
  var x6 = new Uint8Array(16);
  crypto_onetimeauth(x6, 0, m6, mpos, n2, k6);
  return crypto_verify_16(h5, hpos, x6, 0);
}
function crypto_secretbox(c5, m6, d6, n2, k6) {
  var i5;
  if (d6 < 32)
    return -1;
  crypto_stream_xor(c5, 0, m6, 0, d6, n2, k6);
  crypto_onetimeauth(c5, 16, c5, 32, d6 - 32, c5);
  for (i5 = 0; i5 < 16; i5++)
    c5[i5] = 0;
  return 0;
}
function crypto_secretbox_open(m6, c5, d6, n2, k6) {
  var i5;
  var x6 = new Uint8Array(32);
  if (d6 < 32)
    return -1;
  crypto_stream(x6, 0, 32, n2, k6);
  if (crypto_onetimeauth_verify(c5, 16, c5, 32, d6 - 32, x6) !== 0)
    return -1;
  crypto_stream_xor(m6, 0, c5, 0, d6, n2, k6);
  for (i5 = 0; i5 < 32; i5++)
    m6[i5] = 0;
  return 0;
}
function set25519(r3, a6) {
  let i5;
  for (i5 = 0; i5 < 16; i5++)
    r3[i5] = a6[i5] | 0;
}
function car25519(o3) {
  let i5, v3, c5 = 1;
  for (i5 = 0; i5 < 16; i5++) {
    v3 = o3[i5] + c5 + 65535;
    c5 = Math.floor(v3 / 65536);
    o3[i5] = v3 - c5 * 65536;
  }
  o3[0] += c5 - 1 + 37 * (c5 - 1);
}
function sel25519(p4, q6, b5) {
  let t5;
  const c5 = ~(b5 - 1);
  for (let i5 = 0; i5 < 16; i5++) {
    t5 = c5 & (p4[i5] ^ q6[i5]);
    p4[i5] ^= t5;
    q6[i5] ^= t5;
  }
}
function pack25519(o3, n2) {
  let i5, j4, b5;
  const m6 = gf(), t5 = gf();
  for (i5 = 0; i5 < 16; i5++)
    t5[i5] = n2[i5];
  car25519(t5);
  car25519(t5);
  car25519(t5);
  for (j4 = 0; j4 < 2; j4++) {
    m6[0] = t5[0] - 65517;
    for (i5 = 1; i5 < 15; i5++) {
      m6[i5] = t5[i5] - 65535 - (m6[i5 - 1] >> 16 & 1);
      m6[i5 - 1] &= 65535;
    }
    m6[15] = t5[15] - 32767 - (m6[14] >> 16 & 1);
    b5 = m6[15] >> 16 & 1;
    m6[14] &= 65535;
    sel25519(t5, m6, 1 - b5);
  }
  for (i5 = 0; i5 < 16; i5++) {
    o3[2 * i5] = t5[i5] & 255;
    o3[2 * i5 + 1] = t5[i5] >> 8;
  }
}
function neq25519(a6, b5) {
  const c5 = new Uint8Array(32), d6 = new Uint8Array(32);
  pack25519(c5, a6);
  pack25519(d6, b5);
  return crypto_verify_32(c5, 0, d6, 0);
}
function par25519(a6) {
  const d6 = new Uint8Array(32);
  pack25519(d6, a6);
  return d6[0] & 1;
}
function unpack25519(o3, n2) {
  let i5;
  for (i5 = 0; i5 < 16; i5++)
    o3[i5] = n2[2 * i5] + (n2[2 * i5 + 1] << 8);
  o3[15] &= 32767;
}
function A(o3, a6, b5) {
  for (let i5 = 0; i5 < 16; i5++)
    o3[i5] = a6[i5] + b5[i5];
}
function Z(o3, a6, b5) {
  for (let i5 = 0; i5 < 16; i5++)
    o3[i5] = a6[i5] - b5[i5];
}
function M(o3, a6, b5) {
  let v3, c5, t0 = 0, t1 = 0, t22 = 0, t32 = 0, t42 = 0, t5 = 0, t6 = 0, t7 = 0, t8 = 0, t9 = 0, t10 = 0, t11 = 0, t12 = 0, t13 = 0, t14 = 0, t15 = 0, t16 = 0, t17 = 0, t18 = 0, t19 = 0, t20 = 0, t21 = 0, t222 = 0, t23 = 0, t24 = 0, t25 = 0, t26 = 0, t27 = 0, t28 = 0, t29 = 0, t30 = 0;
  const b0 = b5[0], b1 = b5[1], b22 = b5[2], b32 = b5[3], b42 = b5[4], b52 = b5[5], b6 = b5[6], b7 = b5[7], b8 = b5[8], b9 = b5[9], b10 = b5[10], b11 = b5[11], b12 = b5[12], b13 = b5[13], b14 = b5[14], b15 = b5[15];
  v3 = a6[0];
  t0 += v3 * b0;
  t1 += v3 * b1;
  t22 += v3 * b22;
  t32 += v3 * b32;
  t42 += v3 * b42;
  t5 += v3 * b52;
  t6 += v3 * b6;
  t7 += v3 * b7;
  t8 += v3 * b8;
  t9 += v3 * b9;
  t10 += v3 * b10;
  t11 += v3 * b11;
  t12 += v3 * b12;
  t13 += v3 * b13;
  t14 += v3 * b14;
  t15 += v3 * b15;
  v3 = a6[1];
  t1 += v3 * b0;
  t22 += v3 * b1;
  t32 += v3 * b22;
  t42 += v3 * b32;
  t5 += v3 * b42;
  t6 += v3 * b52;
  t7 += v3 * b6;
  t8 += v3 * b7;
  t9 += v3 * b8;
  t10 += v3 * b9;
  t11 += v3 * b10;
  t12 += v3 * b11;
  t13 += v3 * b12;
  t14 += v3 * b13;
  t15 += v3 * b14;
  t16 += v3 * b15;
  v3 = a6[2];
  t22 += v3 * b0;
  t32 += v3 * b1;
  t42 += v3 * b22;
  t5 += v3 * b32;
  t6 += v3 * b42;
  t7 += v3 * b52;
  t8 += v3 * b6;
  t9 += v3 * b7;
  t10 += v3 * b8;
  t11 += v3 * b9;
  t12 += v3 * b10;
  t13 += v3 * b11;
  t14 += v3 * b12;
  t15 += v3 * b13;
  t16 += v3 * b14;
  t17 += v3 * b15;
  v3 = a6[3];
  t32 += v3 * b0;
  t42 += v3 * b1;
  t5 += v3 * b22;
  t6 += v3 * b32;
  t7 += v3 * b42;
  t8 += v3 * b52;
  t9 += v3 * b6;
  t10 += v3 * b7;
  t11 += v3 * b8;
  t12 += v3 * b9;
  t13 += v3 * b10;
  t14 += v3 * b11;
  t15 += v3 * b12;
  t16 += v3 * b13;
  t17 += v3 * b14;
  t18 += v3 * b15;
  v3 = a6[4];
  t42 += v3 * b0;
  t5 += v3 * b1;
  t6 += v3 * b22;
  t7 += v3 * b32;
  t8 += v3 * b42;
  t9 += v3 * b52;
  t10 += v3 * b6;
  t11 += v3 * b7;
  t12 += v3 * b8;
  t13 += v3 * b9;
  t14 += v3 * b10;
  t15 += v3 * b11;
  t16 += v3 * b12;
  t17 += v3 * b13;
  t18 += v3 * b14;
  t19 += v3 * b15;
  v3 = a6[5];
  t5 += v3 * b0;
  t6 += v3 * b1;
  t7 += v3 * b22;
  t8 += v3 * b32;
  t9 += v3 * b42;
  t10 += v3 * b52;
  t11 += v3 * b6;
  t12 += v3 * b7;
  t13 += v3 * b8;
  t14 += v3 * b9;
  t15 += v3 * b10;
  t16 += v3 * b11;
  t17 += v3 * b12;
  t18 += v3 * b13;
  t19 += v3 * b14;
  t20 += v3 * b15;
  v3 = a6[6];
  t6 += v3 * b0;
  t7 += v3 * b1;
  t8 += v3 * b22;
  t9 += v3 * b32;
  t10 += v3 * b42;
  t11 += v3 * b52;
  t12 += v3 * b6;
  t13 += v3 * b7;
  t14 += v3 * b8;
  t15 += v3 * b9;
  t16 += v3 * b10;
  t17 += v3 * b11;
  t18 += v3 * b12;
  t19 += v3 * b13;
  t20 += v3 * b14;
  t21 += v3 * b15;
  v3 = a6[7];
  t7 += v3 * b0;
  t8 += v3 * b1;
  t9 += v3 * b22;
  t10 += v3 * b32;
  t11 += v3 * b42;
  t12 += v3 * b52;
  t13 += v3 * b6;
  t14 += v3 * b7;
  t15 += v3 * b8;
  t16 += v3 * b9;
  t17 += v3 * b10;
  t18 += v3 * b11;
  t19 += v3 * b12;
  t20 += v3 * b13;
  t21 += v3 * b14;
  t222 += v3 * b15;
  v3 = a6[8];
  t8 += v3 * b0;
  t9 += v3 * b1;
  t10 += v3 * b22;
  t11 += v3 * b32;
  t12 += v3 * b42;
  t13 += v3 * b52;
  t14 += v3 * b6;
  t15 += v3 * b7;
  t16 += v3 * b8;
  t17 += v3 * b9;
  t18 += v3 * b10;
  t19 += v3 * b11;
  t20 += v3 * b12;
  t21 += v3 * b13;
  t222 += v3 * b14;
  t23 += v3 * b15;
  v3 = a6[9];
  t9 += v3 * b0;
  t10 += v3 * b1;
  t11 += v3 * b22;
  t12 += v3 * b32;
  t13 += v3 * b42;
  t14 += v3 * b52;
  t15 += v3 * b6;
  t16 += v3 * b7;
  t17 += v3 * b8;
  t18 += v3 * b9;
  t19 += v3 * b10;
  t20 += v3 * b11;
  t21 += v3 * b12;
  t222 += v3 * b13;
  t23 += v3 * b14;
  t24 += v3 * b15;
  v3 = a6[10];
  t10 += v3 * b0;
  t11 += v3 * b1;
  t12 += v3 * b22;
  t13 += v3 * b32;
  t14 += v3 * b42;
  t15 += v3 * b52;
  t16 += v3 * b6;
  t17 += v3 * b7;
  t18 += v3 * b8;
  t19 += v3 * b9;
  t20 += v3 * b10;
  t21 += v3 * b11;
  t222 += v3 * b12;
  t23 += v3 * b13;
  t24 += v3 * b14;
  t25 += v3 * b15;
  v3 = a6[11];
  t11 += v3 * b0;
  t12 += v3 * b1;
  t13 += v3 * b22;
  t14 += v3 * b32;
  t15 += v3 * b42;
  t16 += v3 * b52;
  t17 += v3 * b6;
  t18 += v3 * b7;
  t19 += v3 * b8;
  t20 += v3 * b9;
  t21 += v3 * b10;
  t222 += v3 * b11;
  t23 += v3 * b12;
  t24 += v3 * b13;
  t25 += v3 * b14;
  t26 += v3 * b15;
  v3 = a6[12];
  t12 += v3 * b0;
  t13 += v3 * b1;
  t14 += v3 * b22;
  t15 += v3 * b32;
  t16 += v3 * b42;
  t17 += v3 * b52;
  t18 += v3 * b6;
  t19 += v3 * b7;
  t20 += v3 * b8;
  t21 += v3 * b9;
  t222 += v3 * b10;
  t23 += v3 * b11;
  t24 += v3 * b12;
  t25 += v3 * b13;
  t26 += v3 * b14;
  t27 += v3 * b15;
  v3 = a6[13];
  t13 += v3 * b0;
  t14 += v3 * b1;
  t15 += v3 * b22;
  t16 += v3 * b32;
  t17 += v3 * b42;
  t18 += v3 * b52;
  t19 += v3 * b6;
  t20 += v3 * b7;
  t21 += v3 * b8;
  t222 += v3 * b9;
  t23 += v3 * b10;
  t24 += v3 * b11;
  t25 += v3 * b12;
  t26 += v3 * b13;
  t27 += v3 * b14;
  t28 += v3 * b15;
  v3 = a6[14];
  t14 += v3 * b0;
  t15 += v3 * b1;
  t16 += v3 * b22;
  t17 += v3 * b32;
  t18 += v3 * b42;
  t19 += v3 * b52;
  t20 += v3 * b6;
  t21 += v3 * b7;
  t222 += v3 * b8;
  t23 += v3 * b9;
  t24 += v3 * b10;
  t25 += v3 * b11;
  t26 += v3 * b12;
  t27 += v3 * b13;
  t28 += v3 * b14;
  t29 += v3 * b15;
  v3 = a6[15];
  t15 += v3 * b0;
  t16 += v3 * b1;
  t17 += v3 * b22;
  t18 += v3 * b32;
  t19 += v3 * b42;
  t20 += v3 * b52;
  t21 += v3 * b6;
  t222 += v3 * b7;
  t23 += v3 * b8;
  t24 += v3 * b9;
  t25 += v3 * b10;
  t26 += v3 * b11;
  t27 += v3 * b12;
  t28 += v3 * b13;
  t29 += v3 * b14;
  t30 += v3 * b15;
  t0 += 38 * t16;
  t1 += 38 * t17;
  t22 += 38 * t18;
  t32 += 38 * t19;
  t42 += 38 * t20;
  t5 += 38 * t21;
  t6 += 38 * t222;
  t7 += 38 * t23;
  t8 += 38 * t24;
  t9 += 38 * t25;
  t10 += 38 * t26;
  t11 += 38 * t27;
  t12 += 38 * t28;
  t13 += 38 * t29;
  t14 += 38 * t30;
  c5 = 1;
  v3 = t0 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t0 = v3 - c5 * 65536;
  v3 = t1 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t1 = v3 - c5 * 65536;
  v3 = t22 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t22 = v3 - c5 * 65536;
  v3 = t32 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t32 = v3 - c5 * 65536;
  v3 = t42 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t42 = v3 - c5 * 65536;
  v3 = t5 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t5 = v3 - c5 * 65536;
  v3 = t6 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t6 = v3 - c5 * 65536;
  v3 = t7 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t7 = v3 - c5 * 65536;
  v3 = t8 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t8 = v3 - c5 * 65536;
  v3 = t9 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t9 = v3 - c5 * 65536;
  v3 = t10 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t10 = v3 - c5 * 65536;
  v3 = t11 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t11 = v3 - c5 * 65536;
  v3 = t12 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t12 = v3 - c5 * 65536;
  v3 = t13 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t13 = v3 - c5 * 65536;
  v3 = t14 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t14 = v3 - c5 * 65536;
  v3 = t15 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t15 = v3 - c5 * 65536;
  t0 += c5 - 1 + 37 * (c5 - 1);
  c5 = 1;
  v3 = t0 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t0 = v3 - c5 * 65536;
  v3 = t1 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t1 = v3 - c5 * 65536;
  v3 = t22 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t22 = v3 - c5 * 65536;
  v3 = t32 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t32 = v3 - c5 * 65536;
  v3 = t42 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t42 = v3 - c5 * 65536;
  v3 = t5 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t5 = v3 - c5 * 65536;
  v3 = t6 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t6 = v3 - c5 * 65536;
  v3 = t7 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t7 = v3 - c5 * 65536;
  v3 = t8 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t8 = v3 - c5 * 65536;
  v3 = t9 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t9 = v3 - c5 * 65536;
  v3 = t10 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t10 = v3 - c5 * 65536;
  v3 = t11 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t11 = v3 - c5 * 65536;
  v3 = t12 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t12 = v3 - c5 * 65536;
  v3 = t13 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t13 = v3 - c5 * 65536;
  v3 = t14 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t14 = v3 - c5 * 65536;
  v3 = t15 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t15 = v3 - c5 * 65536;
  t0 += c5 - 1 + 37 * (c5 - 1);
  o3[0] = t0;
  o3[1] = t1;
  o3[2] = t22;
  o3[3] = t32;
  o3[4] = t42;
  o3[5] = t5;
  o3[6] = t6;
  o3[7] = t7;
  o3[8] = t8;
  o3[9] = t9;
  o3[10] = t10;
  o3[11] = t11;
  o3[12] = t12;
  o3[13] = t13;
  o3[14] = t14;
  o3[15] = t15;
}
function S(o3, a6) {
  M(o3, a6, a6);
}
function inv25519(o3, i5) {
  const c5 = gf();
  let a6;
  for (a6 = 0; a6 < 16; a6++)
    c5[a6] = i5[a6];
  for (a6 = 253; a6 >= 0; a6--) {
    S(c5, c5);
    if (a6 !== 2 && a6 !== 4)
      M(c5, c5, i5);
  }
  for (a6 = 0; a6 < 16; a6++)
    o3[a6] = c5[a6];
}
function pow2523(o3, i5) {
  const c5 = gf();
  let a6;
  for (a6 = 0; a6 < 16; a6++)
    c5[a6] = i5[a6];
  for (a6 = 250; a6 >= 0; a6--) {
    S(c5, c5);
    if (a6 !== 1)
      M(c5, c5, i5);
  }
  for (a6 = 0; a6 < 16; a6++)
    o3[a6] = c5[a6];
}
var K = [
  1116352408,
  3609767458,
  1899447441,
  602891725,
  3049323471,
  3964484399,
  3921009573,
  2173295548,
  961987163,
  4081628472,
  1508970993,
  3053834265,
  2453635748,
  2937671579,
  2870763221,
  3664609560,
  3624381080,
  2734883394,
  310598401,
  1164996542,
  607225278,
  1323610764,
  1426881987,
  3590304994,
  1925078388,
  4068182383,
  2162078206,
  991336113,
  2614888103,
  633803317,
  3248222580,
  3479774868,
  3835390401,
  2666613458,
  4022224774,
  944711139,
  264347078,
  2341262773,
  604807628,
  2007800933,
  770255983,
  1495990901,
  1249150122,
  1856431235,
  1555081692,
  3175218132,
  1996064986,
  2198950837,
  2554220882,
  3999719339,
  2821834349,
  766784016,
  2952996808,
  2566594879,
  3210313671,
  3203337956,
  3336571891,
  1034457026,
  3584528711,
  2466948901,
  113926993,
  3758326383,
  338241895,
  168717936,
  666307205,
  1188179964,
  773529912,
  1546045734,
  1294757372,
  1522805485,
  1396182291,
  2643833823,
  1695183700,
  2343527390,
  1986661051,
  1014477480,
  2177026350,
  1206759142,
  2456956037,
  344077627,
  2730485921,
  1290863460,
  2820302411,
  3158454273,
  3259730800,
  3505952657,
  3345764771,
  106217008,
  3516065817,
  3606008344,
  3600352804,
  1432725776,
  4094571909,
  1467031594,
  275423344,
  851169720,
  430227734,
  3100823752,
  506948616,
  1363258195,
  659060556,
  3750685593,
  883997877,
  3785050280,
  958139571,
  3318307427,
  1322822218,
  3812723403,
  1537002063,
  2003034995,
  1747873779,
  3602036899,
  1955562222,
  1575990012,
  2024104815,
  1125592928,
  2227730452,
  2716904306,
  2361852424,
  442776044,
  2428436474,
  593698344,
  2756734187,
  3733110249,
  3204031479,
  2999351573,
  3329325298,
  3815920427,
  3391569614,
  3928383900,
  3515267271,
  566280711,
  3940187606,
  3454069534,
  4118630271,
  4000239992,
  116418474,
  1914138554,
  174292421,
  2731055270,
  289380356,
  3203993006,
  460393269,
  320620315,
  685471733,
  587496836,
  852142971,
  1086792851,
  1017036298,
  365543100,
  1126000580,
  2618297676,
  1288033470,
  3409855158,
  1501505948,
  4234509866,
  1607167915,
  987167468,
  1816402316,
  1246189591
];
function crypto_hashblocks_hl(hh, hl, m6, n2) {
  const wh = new Int32Array(16), wl = new Int32Array(16);
  let bh0, bh1, bh2, bh3, bh4, bh5, bh6, bh7, bl0, bl1, bl2, bl3, bl4, bl5, bl6, bl7, th, tl, i5, j4, h5, l3, a6, b5, c5, d6;
  let ah0 = hh[0], ah1 = hh[1], ah2 = hh[2], ah3 = hh[3], ah4 = hh[4], ah5 = hh[5], ah6 = hh[6], ah7 = hh[7], al0 = hl[0], al1 = hl[1], al2 = hl[2], al3 = hl[3], al4 = hl[4], al5 = hl[5], al6 = hl[6], al7 = hl[7];
  let pos = 0;
  while (n2 >= 128) {
    for (i5 = 0; i5 < 16; i5++) {
      j4 = 8 * i5 + pos;
      wh[i5] = m6[j4 + 0] << 24 | m6[j4 + 1] << 16 | m6[j4 + 2] << 8 | m6[j4 + 3];
      wl[i5] = m6[j4 + 4] << 24 | m6[j4 + 5] << 16 | m6[j4 + 6] << 8 | m6[j4 + 7];
    }
    for (i5 = 0; i5 < 80; i5++) {
      bh0 = ah0;
      bh1 = ah1;
      bh2 = ah2;
      bh3 = ah3;
      bh4 = ah4;
      bh5 = ah5;
      bh6 = ah6;
      bh7 = ah7;
      bl0 = al0;
      bl1 = al1;
      bl2 = al2;
      bl3 = al3;
      bl4 = al4;
      bl5 = al5;
      bl6 = al6;
      bl7 = al7;
      h5 = ah7;
      l3 = al7;
      a6 = l3 & 65535;
      b5 = l3 >>> 16;
      c5 = h5 & 65535;
      d6 = h5 >>> 16;
      h5 = (ah4 >>> 14 | al4 << 32 - 14) ^ (ah4 >>> 18 | al4 << 32 - 18) ^ (al4 >>> 41 - 32 | ah4 << 32 - (41 - 32));
      l3 = (al4 >>> 14 | ah4 << 32 - 14) ^ (al4 >>> 18 | ah4 << 32 - 18) ^ (ah4 >>> 41 - 32 | al4 << 32 - (41 - 32));
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      h5 = ah4 & ah5 ^ ~ah4 & ah6;
      l3 = al4 & al5 ^ ~al4 & al6;
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      h5 = K[i5 * 2];
      l3 = K[i5 * 2 + 1];
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      h5 = wh[i5 % 16];
      l3 = wl[i5 % 16];
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      b5 += a6 >>> 16;
      c5 += b5 >>> 16;
      d6 += c5 >>> 16;
      th = c5 & 65535 | d6 << 16;
      tl = a6 & 65535 | b5 << 16;
      h5 = th;
      l3 = tl;
      a6 = l3 & 65535;
      b5 = l3 >>> 16;
      c5 = h5 & 65535;
      d6 = h5 >>> 16;
      h5 = (ah0 >>> 28 | al0 << 32 - 28) ^ (al0 >>> 34 - 32 | ah0 << 32 - (34 - 32)) ^ (al0 >>> 39 - 32 | ah0 << 32 - (39 - 32));
      l3 = (al0 >>> 28 | ah0 << 32 - 28) ^ (ah0 >>> 34 - 32 | al0 << 32 - (34 - 32)) ^ (ah0 >>> 39 - 32 | al0 << 32 - (39 - 32));
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      h5 = ah0 & ah1 ^ ah0 & ah2 ^ ah1 & ah2;
      l3 = al0 & al1 ^ al0 & al2 ^ al1 & al2;
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      b5 += a6 >>> 16;
      c5 += b5 >>> 16;
      d6 += c5 >>> 16;
      bh7 = c5 & 65535 | d6 << 16;
      bl7 = a6 & 65535 | b5 << 16;
      h5 = bh3;
      l3 = bl3;
      a6 = l3 & 65535;
      b5 = l3 >>> 16;
      c5 = h5 & 65535;
      d6 = h5 >>> 16;
      h5 = th;
      l3 = tl;
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      b5 += a6 >>> 16;
      c5 += b5 >>> 16;
      d6 += c5 >>> 16;
      bh3 = c5 & 65535 | d6 << 16;
      bl3 = a6 & 65535 | b5 << 16;
      ah1 = bh0;
      ah2 = bh1;
      ah3 = bh2;
      ah4 = bh3;
      ah5 = bh4;
      ah6 = bh5;
      ah7 = bh6;
      ah0 = bh7;
      al1 = bl0;
      al2 = bl1;
      al3 = bl2;
      al4 = bl3;
      al5 = bl4;
      al6 = bl5;
      al7 = bl6;
      al0 = bl7;
      if (i5 % 16 === 15) {
        for (j4 = 0; j4 < 16; j4++) {
          h5 = wh[j4];
          l3 = wl[j4];
          a6 = l3 & 65535;
          b5 = l3 >>> 16;
          c5 = h5 & 65535;
          d6 = h5 >>> 16;
          h5 = wh[(j4 + 9) % 16];
          l3 = wl[(j4 + 9) % 16];
          a6 += l3 & 65535;
          b5 += l3 >>> 16;
          c5 += h5 & 65535;
          d6 += h5 >>> 16;
          th = wh[(j4 + 1) % 16];
          tl = wl[(j4 + 1) % 16];
          h5 = (th >>> 1 | tl << 32 - 1) ^ (th >>> 8 | tl << 32 - 8) ^ th >>> 7;
          l3 = (tl >>> 1 | th << 32 - 1) ^ (tl >>> 8 | th << 32 - 8) ^ (tl >>> 7 | th << 32 - 7);
          a6 += l3 & 65535;
          b5 += l3 >>> 16;
          c5 += h5 & 65535;
          d6 += h5 >>> 16;
          th = wh[(j4 + 14) % 16];
          tl = wl[(j4 + 14) % 16];
          h5 = (th >>> 19 | tl << 32 - 19) ^ (tl >>> 61 - 32 | th << 32 - (61 - 32)) ^ th >>> 6;
          l3 = (tl >>> 19 | th << 32 - 19) ^ (th >>> 61 - 32 | tl << 32 - (61 - 32)) ^ (tl >>> 6 | th << 32 - 6);
          a6 += l3 & 65535;
          b5 += l3 >>> 16;
          c5 += h5 & 65535;
          d6 += h5 >>> 16;
          b5 += a6 >>> 16;
          c5 += b5 >>> 16;
          d6 += c5 >>> 16;
          wh[j4] = c5 & 65535 | d6 << 16;
          wl[j4] = a6 & 65535 | b5 << 16;
        }
      }
    }
    h5 = ah0;
    l3 = al0;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[0];
    l3 = hl[0];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[0] = ah0 = c5 & 65535 | d6 << 16;
    hl[0] = al0 = a6 & 65535 | b5 << 16;
    h5 = ah1;
    l3 = al1;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[1];
    l3 = hl[1];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[1] = ah1 = c5 & 65535 | d6 << 16;
    hl[1] = al1 = a6 & 65535 | b5 << 16;
    h5 = ah2;
    l3 = al2;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[2];
    l3 = hl[2];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[2] = ah2 = c5 & 65535 | d6 << 16;
    hl[2] = al2 = a6 & 65535 | b5 << 16;
    h5 = ah3;
    l3 = al3;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[3];
    l3 = hl[3];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[3] = ah3 = c5 & 65535 | d6 << 16;
    hl[3] = al3 = a6 & 65535 | b5 << 16;
    h5 = ah4;
    l3 = al4;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[4];
    l3 = hl[4];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[4] = ah4 = c5 & 65535 | d6 << 16;
    hl[4] = al4 = a6 & 65535 | b5 << 16;
    h5 = ah5;
    l3 = al5;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[5];
    l3 = hl[5];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[5] = ah5 = c5 & 65535 | d6 << 16;
    hl[5] = al5 = a6 & 65535 | b5 << 16;
    h5 = ah6;
    l3 = al6;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[6];
    l3 = hl[6];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[6] = ah6 = c5 & 65535 | d6 << 16;
    hl[6] = al6 = a6 & 65535 | b5 << 16;
    h5 = ah7;
    l3 = al7;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[7];
    l3 = hl[7];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[7] = ah7 = c5 & 65535 | d6 << 16;
    hl[7] = al7 = a6 & 65535 | b5 << 16;
    pos += 128;
    n2 -= 128;
  }
  return n2;
}
function crypto_hash(out, m6, n2) {
  const hh = new Int32Array(8);
  const hl = new Int32Array(8);
  const x6 = new Uint8Array(256);
  const b5 = n2;
  hh[0] = 1779033703;
  hh[1] = 3144134277;
  hh[2] = 1013904242;
  hh[3] = 2773480762;
  hh[4] = 1359893119;
  hh[5] = 2600822924;
  hh[6] = 528734635;
  hh[7] = 1541459225;
  hl[0] = 4089235720;
  hl[1] = 2227873595;
  hl[2] = 4271175723;
  hl[3] = 1595750129;
  hl[4] = 2917565137;
  hl[5] = 725511199;
  hl[6] = 4215389547;
  hl[7] = 327033209;
  crypto_hashblocks_hl(hh, hl, m6, n2);
  n2 %= 128;
  for (let i5 = 0; i5 < n2; i5++)
    x6[i5] = m6[b5 - n2 + i5];
  x6[n2] = 128;
  n2 = 256 - 128 * (n2 < 112 ? 1 : 0);
  x6[n2 - 9] = 0;
  ts64(x6, n2 - 8, b5 / 536870912 | 0, b5 << 3);
  crypto_hashblocks_hl(hh, hl, x6, n2);
  for (let i5 = 0; i5 < 8; i5++)
    ts64(out, 8 * i5, hh[i5], hl[i5]);
  return 0;
}
var HashState = class {
  constructor() {
    this.hh = new Int32Array(8);
    this.hl = new Int32Array(8);
    this.next = new Uint8Array(128);
    this.p = 0;
    this.total = 0;
    this.hh[0] = 1779033703;
    this.hh[1] = 3144134277;
    this.hh[2] = 1013904242;
    this.hh[3] = 2773480762;
    this.hh[4] = 1359893119;
    this.hh[5] = 2600822924;
    this.hh[6] = 528734635;
    this.hh[7] = 1541459225;
    this.hl[0] = 4089235720;
    this.hl[1] = 2227873595;
    this.hl[2] = 4271175723;
    this.hl[3] = 1595750129;
    this.hl[4] = 2917565137;
    this.hl[5] = 725511199;
    this.hl[6] = 4215389547;
    this.hl[7] = 327033209;
  }
  update(data) {
    this.total += data.length;
    let i5 = 0;
    while (i5 < data.length) {
      const r3 = 128 - this.p;
      if (r3 > data.length - i5) {
        for (let j4 = 0; i5 + j4 < data.length; j4++) {
          this.next[this.p + j4] = data[i5 + j4];
        }
        this.p += data.length - i5;
        break;
      } else {
        for (let j4 = 0; this.p + j4 < 128; j4++) {
          this.next[this.p + j4] = data[i5 + j4];
        }
        crypto_hashblocks_hl(this.hh, this.hl, this.next, 128);
        i5 += 128 - this.p;
        this.p = 0;
      }
    }
    return this;
  }
  finish() {
    const out = new Uint8Array(64);
    let n2 = this.p;
    const x6 = new Uint8Array(256);
    const b5 = this.total;
    for (let i5 = 0; i5 < n2; i5++)
      x6[i5] = this.next[i5];
    x6[n2] = 128;
    n2 = 256 - 128 * (n2 < 112 ? 1 : 0);
    x6[n2 - 9] = 0;
    ts64(x6, n2 - 8, b5 / 536870912 | 0, b5 << 3);
    crypto_hashblocks_hl(this.hh, this.hl, x6, n2);
    for (let i5 = 0; i5 < 8; i5++)
      ts64(out, 8 * i5, this.hh[i5], this.hl[i5]);
    return out;
  }
};
function add(p4, q6) {
  const a6 = gf(), b5 = gf(), c5 = gf(), d6 = gf(), e5 = gf(), f3 = gf(), g4 = gf(), h5 = gf(), t5 = gf();
  Z(a6, p4[1], p4[0]);
  Z(t5, q6[1], q6[0]);
  M(a6, a6, t5);
  A(b5, p4[0], p4[1]);
  A(t5, q6[0], q6[1]);
  M(b5, b5, t5);
  M(c5, p4[3], q6[3]);
  M(c5, c5, D2);
  M(d6, p4[2], q6[2]);
  A(d6, d6, d6);
  Z(e5, b5, a6);
  Z(f3, d6, c5);
  A(g4, d6, c5);
  A(h5, b5, a6);
  M(p4[0], e5, f3);
  M(p4[1], h5, g4);
  M(p4[2], g4, f3);
  M(p4[3], e5, h5);
}
function cswap(p4, q6, b5) {
  let i5;
  for (i5 = 0; i5 < 4; i5++) {
    sel25519(p4[i5], q6[i5], b5);
  }
}
function pack(r3, p4) {
  const tx = gf(), ty = gf(), zi = gf();
  inv25519(zi, p4[2]);
  M(tx, p4[0], zi);
  M(ty, p4[1], zi);
  pack25519(r3, ty);
  r3[31] ^= par25519(tx) << 7;
}
function scalarmult(p4, q6, s6) {
  let b5, i5;
  set25519(p4[0], gf0);
  set25519(p4[1], gf1);
  set25519(p4[2], gf1);
  set25519(p4[3], gf0);
  for (i5 = 255; i5 >= 0; --i5) {
    b5 = s6[i5 / 8 | 0] >> (i5 & 7) & 1;
    cswap(p4, q6, b5);
    add(q6, p4);
    add(p4, p4);
    cswap(p4, q6, b5);
  }
}
function scalarbase(p4, s6) {
  const q6 = [gf(), gf(), gf(), gf()];
  set25519(q6[0], X);
  set25519(q6[1], Y);
  set25519(q6[2], gf1);
  M(q6[3], X, Y);
  scalarmult(p4, q6, s6);
}
function crypto_sign_keypair(pk, sk, seeded) {
  const d6 = new Uint8Array(64);
  const p4 = [gf(), gf(), gf(), gf()];
  if (!seeded)
    randombytes(sk, 32);
  crypto_hash(d6, sk, 32);
  d6[0] &= 248;
  d6[31] &= 127;
  d6[31] |= 64;
  scalarbase(p4, d6);
  pack(pk, p4);
  for (let i5 = 0; i5 < 32; i5++)
    sk[i5 + 32] = pk[i5];
  return 0;
}
var L = new Float64Array([
  237,
  211,
  245,
  92,
  26,
  99,
  18,
  88,
  214,
  156,
  247,
  162,
  222,
  249,
  222,
  20,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  16
]);
function modL(r3, x6) {
  let carry, i5, j4, k6;
  for (i5 = 63; i5 >= 32; --i5) {
    carry = 0;
    for (j4 = i5 - 32, k6 = i5 - 12; j4 < k6; ++j4) {
      x6[j4] += carry - 16 * x6[i5] * L[j4 - (i5 - 32)];
      carry = Math.floor((x6[j4] + 128) / 256);
      x6[j4] -= carry * 256;
    }
    x6[j4] += carry;
    x6[i5] = 0;
  }
  carry = 0;
  for (j4 = 0; j4 < 32; j4++) {
    x6[j4] += carry - (x6[31] >> 4) * L[j4];
    carry = x6[j4] >> 8;
    x6[j4] &= 255;
  }
  for (j4 = 0; j4 < 32; j4++)
    x6[j4] -= carry * L[j4];
  for (i5 = 0; i5 < 32; i5++) {
    x6[i5 + 1] += x6[i5] >> 8;
    r3[i5] = x6[i5] & 255;
  }
}
function reduce(r3) {
  const x6 = new Float64Array(64);
  for (let i5 = 0; i5 < 64; i5++)
    x6[i5] = r3[i5];
  for (let i5 = 0; i5 < 64; i5++)
    r3[i5] = 0;
  modL(r3, x6);
}
function crypto_sign(sm, m6, n2, sk) {
  const d6 = new Uint8Array(64), h5 = new Uint8Array(64), r3 = new Uint8Array(64);
  let i5, j4;
  const x6 = new Float64Array(64);
  const p4 = [gf(), gf(), gf(), gf()];
  crypto_hash(d6, sk, 32);
  d6[0] &= 248;
  d6[31] &= 127;
  d6[31] |= 64;
  const smlen = n2 + 64;
  for (i5 = 0; i5 < n2; i5++)
    sm[64 + i5] = m6[i5];
  for (i5 = 0; i5 < 32; i5++)
    sm[32 + i5] = d6[32 + i5];
  crypto_hash(r3, sm.subarray(32), n2 + 32);
  reduce(r3);
  scalarbase(p4, r3);
  pack(sm, p4);
  for (i5 = 32; i5 < 64; i5++)
    sm[i5] = sk[i5];
  crypto_hash(h5, sm, n2 + 64);
  reduce(h5);
  for (i5 = 0; i5 < 64; i5++)
    x6[i5] = 0;
  for (i5 = 0; i5 < 32; i5++)
    x6[i5] = r3[i5];
  for (i5 = 0; i5 < 32; i5++) {
    for (j4 = 0; j4 < 32; j4++) {
      x6[i5 + j4] += h5[i5] * d6[j4];
    }
  }
  modL(sm.subarray(32), x6);
  return smlen;
}
function unpackpos(r3, p4) {
  const q6 = [gf(), gf(), gf(), gf()];
  if (unpackneg(q6, p4))
    return -1;
  const scalar0 = new Uint8Array(32);
  const scalar1 = new Uint8Array(32);
  scalar1[0] = 1;
  const scalarNeg1 = crypto_core_ed25519_scalar_sub(scalar0, scalar1);
  scalarmult(r3, q6, scalarNeg1);
  return 0;
}
function unpackneg(r3, p4) {
  const t5 = gf();
  const chk = gf();
  const num = gf();
  const den = gf();
  const den2 = gf();
  const den4 = gf();
  const den6 = gf();
  set25519(r3[2], gf1);
  unpack25519(r3[1], p4);
  S(num, r3[1]);
  M(den, num, D);
  Z(num, num, r3[2]);
  A(den, r3[2], den);
  S(den2, den);
  S(den4, den2);
  M(den6, den4, den2);
  M(t5, den6, num);
  M(t5, t5, den);
  pow2523(t5, t5);
  M(t5, t5, num);
  M(t5, t5, den);
  M(t5, t5, den);
  M(r3[0], t5, den);
  S(chk, r3[0]);
  M(chk, chk, den);
  if (neq25519(chk, num))
    M(r3[0], r3[0], I);
  S(chk, r3[0]);
  M(chk, chk, den);
  if (neq25519(chk, num))
    return -1;
  if (par25519(r3[0]) === p4[31] >> 7)
    Z(r3[0], gf0, r3[0]);
  M(r3[3], r3[0], r3[1]);
  return 0;
}
function crypto_scalarmult_ed25519_base_noclamp(s6) {
  const r3 = new Uint8Array(32);
  const p4 = [gf(), gf(), gf(), gf()];
  scalarbase(p4, s6);
  pack(r3, p4);
  return r3;
}
function crypto_scalarmult_ed25519_noclamp(s6, q6) {
  const r3 = new Uint8Array(32);
  const p4 = [gf(), gf(), gf(), gf()];
  const ql = [gf(), gf(), gf(), gf()];
  if (unpackpos(ql, q6))
    throw new Error();
  scalarmult(p4, ql, s6);
  pack(r3, p4);
  return r3;
}
function crypto_sign_open(m6, sm, n2, pk) {
  let i5, mlen;
  const t5 = new Uint8Array(32), h5 = new Uint8Array(64);
  const p4 = [gf(), gf(), gf(), gf()], q6 = [gf(), gf(), gf(), gf()];
  mlen = -1;
  if (n2 < 64)
    return -1;
  if (unpackneg(q6, pk))
    return -1;
  for (i5 = 0; i5 < n2; i5++)
    m6[i5] = sm[i5];
  for (i5 = 0; i5 < 32; i5++)
    m6[i5 + 32] = pk[i5];
  crypto_hash(h5, m6, n2);
  reduce(h5);
  scalarmult(p4, q6, h5);
  scalarbase(q6, sm.subarray(32));
  add(p4, q6);
  pack(t5, p4);
  n2 -= 64;
  if (crypto_verify_32(sm, 0, t5, 0)) {
    for (i5 = 0; i5 < n2; i5++)
      m6[i5] = 0;
    return -1;
  }
  for (i5 = 0; i5 < n2; i5++)
    m6[i5] = sm[i5 + 64];
  mlen = n2;
  return mlen;
}
var crypto_secretbox_KEYBYTES = 32;
var crypto_secretbox_NONCEBYTES = 24;
var crypto_secretbox_ZEROBYTES = 32;
var crypto_secretbox_BOXZEROBYTES = 16;
var crypto_sign_BYTES = 64;
var crypto_sign_PUBLICKEYBYTES = 32;
var crypto_sign_SECRETKEYBYTES = 64;
var crypto_sign_SEEDBYTES = 32;
var crypto_hash_BYTES = 64;
function checkLengths(k6, n2) {
  if (k6.length !== crypto_secretbox_KEYBYTES)
    throw new Error("bad key size");
  if (n2.length !== crypto_secretbox_NONCEBYTES)
    throw new Error("bad nonce size");
}
function checkArrayTypes(...args) {
  for (let i5 = 0; i5 < args.length; i5++) {
    if (!(args[i5] instanceof Uint8Array))
      throw new TypeError("unexpected type, use Uint8Array");
  }
}
function randomBytes(n2) {
  const b5 = new Uint8Array(n2);
  randombytes(b5, n2);
  return b5;
}
function sign(msg, secretKey) {
  checkArrayTypes(msg, secretKey);
  if (secretKey.length !== crypto_sign_SECRETKEYBYTES)
    throw new Error("bad secret key size");
  const signedMsg = new Uint8Array(crypto_sign_BYTES + msg.length);
  crypto_sign(signedMsg, msg, msg.length, secretKey);
  return signedMsg;
}
function sign_detached(msg, secretKey) {
  const signedMsg = sign(msg, secretKey);
  const sig = new Uint8Array(crypto_sign_BYTES);
  for (let i5 = 0; i5 < sig.length; i5++)
    sig[i5] = signedMsg[i5];
  return sig;
}
function crypto_sign_keyPair_fromSeed(seed) {
  checkArrayTypes(seed);
  if (seed.length !== crypto_sign_SEEDBYTES)
    throw new Error(`bad seed size: ${seed.length}`);
  const pk = new Uint8Array(crypto_sign_PUBLICKEYBYTES);
  const sk = new Uint8Array(crypto_sign_SECRETKEYBYTES);
  for (let i5 = 0; i5 < 32; i5++)
    sk[i5] = seed[i5];
  crypto_sign_keypair(pk, sk, true);
  return { publicKey: pk, secretKey: sk };
}
function hash(msg) {
  checkArrayTypes(msg);
  const h5 = new Uint8Array(crypto_hash_BYTES);
  crypto_hash(h5, msg, msg.length);
  return h5;
}
function setPRNG(fn2) {
  randombytes = fn2;
}
function secretbox(msg, nonce, key) {
  checkArrayTypes(msg, nonce, key);
  checkLengths(key, nonce);
  var m6 = new Uint8Array(crypto_secretbox_ZEROBYTES + msg.length);
  var c5 = new Uint8Array(m6.length);
  for (var i5 = 0; i5 < msg.length; i5++)
    m6[i5 + crypto_secretbox_ZEROBYTES] = msg[i5];
  crypto_secretbox(c5, m6, m6.length, nonce, key);
  return c5.subarray(crypto_secretbox_BOXZEROBYTES);
}
function secretbox_open(box, nonce, key) {
  checkArrayTypes(box, nonce, key);
  checkLengths(key, nonce);
  var c5 = new Uint8Array(crypto_secretbox_BOXZEROBYTES + box.length);
  var m6 = new Uint8Array(c5.length);
  for (var i5 = 0; i5 < box.length; i5++)
    c5[i5 + crypto_secretbox_BOXZEROBYTES] = box[i5];
  if (c5.length < 32)
    return void 0;
  if (crypto_secretbox_open(m6, c5, c5.length, nonce, key) !== 0)
    return void 0;
  return m6.subarray(crypto_secretbox_ZEROBYTES);
}
function crypto_core_ed25519_scalar_reduce(x6) {
  const len = x6.length;
  const z6 = new Float64Array(64);
  for (let i5 = 0; i5 < len; i5++)
    z6[i5] = x6[i5];
  const o3 = new Uint8Array(32);
  modL(o3, z6);
  return o3;
}
function crypto_core_ed25519_scalar_sub(x6, y6) {
  const z6 = new Float64Array(64);
  for (let i5 = 0; i5 < 32; i5++) {
    z6[i5] = x6[i5] - y6[i5];
  }
  const o3 = new Uint8Array(32);
  modL(o3, z6);
  return o3;
}
function crypto_edx25519_private_key_create() {
  const seed = new Uint8Array(32);
  randombytes(seed, 32);
  return crypto_edx25519_private_key_create_from_seed(seed);
}
function crypto_edx25519_private_key_create_from_seed(seed) {
  const pk = hash(seed);
  pk[0] &= 248;
  pk[31] &= 127;
  pk[31] |= 64;
  return pk;
}
function crypto_edx25519_get_public(priv) {
  return crypto_scalarmult_ed25519_base_noclamp(priv.subarray(0, 32));
}
function crypto_edx25519_sign_detached(m6, skx, pkx) {
  const n2 = m6.length;
  const h5 = new Uint8Array(64);
  const r3 = new Uint8Array(64);
  let i5, j4;
  const x6 = new Float64Array(64);
  const p4 = [gf(), gf(), gf(), gf()];
  const sm = new Uint8Array(n2 + 64);
  for (i5 = 0; i5 < n2; i5++)
    sm[64 + i5] = m6[i5];
  for (i5 = 0; i5 < 32; i5++)
    sm[32 + i5] = skx[32 + i5];
  crypto_hash(r3, sm.subarray(32), n2 + 32);
  reduce(r3);
  scalarbase(p4, r3);
  pack(sm, p4);
  for (i5 = 32; i5 < 64; i5++)
    sm[i5] = pkx[i5 - 32];
  crypto_hash(h5, sm, n2 + 64);
  reduce(h5);
  for (i5 = 0; i5 < 64; i5++)
    x6[i5] = 0;
  for (i5 = 0; i5 < 32; i5++)
    x6[i5] = r3[i5];
  for (i5 = 0; i5 < 32; i5++) {
    for (j4 = 0; j4 < 32; j4++) {
      x6[i5 + j4] += h5[i5] * skx[j4];
    }
  }
  modL(sm.subarray(32), x6);
  return sm.subarray(0, 64);
}
function crypto_edx25519_sign_detached_verify(msg, sig, publicKey) {
  checkArrayTypes(msg, sig, publicKey);
  if (sig.length !== crypto_sign_BYTES)
    throw new Error("bad signature size");
  if (publicKey.length !== crypto_sign_PUBLICKEYBYTES)
    throw new Error("bad public key size");
  const sm = new Uint8Array(crypto_sign_BYTES + msg.length);
  const m6 = new Uint8Array(crypto_sign_BYTES + msg.length);
  let i5;
  for (i5 = 0; i5 < crypto_sign_BYTES; i5++)
    sm[i5] = sig[i5];
  for (i5 = 0; i5 < msg.length; i5++)
    sm[i5 + crypto_sign_BYTES] = msg[i5];
  return crypto_sign_open(m6, sm, sm.length, publicKey) >= 0;
}

// ../taler-util/lib/prng-browser.js
function loadBrowserPrng() {
  const cr = typeof self !== "undefined" ? self.crypto || self.msCrypto : null;
  const QUOTA = 65536;
  setPRNG(function(x6, n2) {
    let i5;
    const v3 = new Uint8Array(n2);
    for (i5 = 0; i5 < n2; i5 += QUOTA) {
      cr.getRandomValues(v3.subarray(i5, i5 + Math.min(n2 - i5, QUOTA)));
    }
    for (i5 = 0; i5 < n2; i5++)
      x6[i5] = v3[i5];
    for (i5 = 0; i5 < v3.length; i5++)
      v3[i5] = 0;
  });
}

// ../taler-util/lib/punycode.js
var maxInt = 2147483647;
var base = 36;
var tMin = 1;
var tMax = 26;
var skew = 38;
var damp = 700;
var initialBias = 72;
var initialN = 128;
var delimiter = "-";
var regexPunycode = /^xn--/;
var regexNonASCII = /[^\0-\x7E]/;
var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g;
var errors = {
  overflow: "Overflow: input needs wider integers to process",
  "not-basic": "Illegal input >= 0x80 (not a basic code point)",
  "invalid-input": "Invalid input"
};
var baseMinusTMin = base - tMin;
var floor = Math.floor;
var stringFromCharCode = String.fromCharCode;
function error(type) {
  throw new RangeError(errors[type]);
}
function map(array, fn2) {
  const result = [];
  let length = array.length;
  while (length--) {
    result[length] = fn2(array[length]);
  }
  return result;
}
function mapDomain(string, fn2) {
  const parts = string.split("@");
  let result = "";
  if (parts.length > 1) {
    result = parts[0] + "@";
    string = parts[1];
  }
  string = string.replace(regexSeparators, ".");
  const labels = string.split(".");
  const encoded = map(labels, fn2).join(".");
  return result + encoded;
}
function ucs2decode(string) {
  const output = [];
  let counter2 = 0;
  const length = string.length;
  while (counter2 < length) {
    const value = string.charCodeAt(counter2++);
    if (value >= 55296 && value <= 56319 && counter2 < length) {
      const extra = string.charCodeAt(counter2++);
      if ((extra & 64512) == 56320) {
        output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
      } else {
        output.push(value);
        counter2--;
      }
    } else {
      output.push(value);
    }
  }
  return output;
}
var ucs2encode = (array) => String.fromCodePoint(...array);
var basicToDigit = function(codePoint) {
  if (codePoint - 48 < 10) {
    return codePoint - 22;
  }
  if (codePoint - 65 < 26) {
    return codePoint - 65;
  }
  if (codePoint - 97 < 26) {
    return codePoint - 97;
  }
  return base;
};
var digitToBasic = function(digit, flag) {
  return digit + 22 + 75 * Number(digit < 26) - (Number(flag != 0) << 5);
};
var adapt = function(delta, numPoints, firstTime) {
  let k6 = 0;
  delta = firstTime ? floor(delta / damp) : delta >> 1;
  delta += floor(delta / numPoints);
  for (
    ;
    /* no initialization */
    delta > baseMinusTMin * tMax >> 1;
    k6 += base
  ) {
    delta = floor(delta / baseMinusTMin);
  }
  return floor(k6 + (baseMinusTMin + 1) * delta / (delta + skew));
};
var decode = function(input) {
  const output = [];
  const inputLength = input.length;
  let i5 = 0;
  let n2 = initialN;
  let bias = initialBias;
  let basic = input.lastIndexOf(delimiter);
  if (basic < 0) {
    basic = 0;
  }
  for (let j4 = 0; j4 < basic; ++j4) {
    if (input.charCodeAt(j4) >= 128) {
      error("not-basic");
    }
    output.push(input.charCodeAt(j4));
  }
  for (let index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
    let oldi = i5;
    for (let w6 = 1, k6 = base; ; k6 += base) {
      if (index >= inputLength) {
        error("invalid-input");
      }
      const digit = basicToDigit(input.charCodeAt(index++));
      if (digit >= base || digit > floor((maxInt - i5) / w6)) {
        error("overflow");
      }
      i5 += digit * w6;
      const t5 = k6 <= bias ? tMin : k6 >= bias + tMax ? tMax : k6 - bias;
      if (digit < t5) {
        break;
      }
      const baseMinusT = base - t5;
      if (w6 > floor(maxInt / baseMinusT)) {
        error("overflow");
      }
      w6 *= baseMinusT;
    }
    const out = output.length + 1;
    bias = adapt(i5 - oldi, out, oldi == 0);
    if (floor(i5 / out) > maxInt - n2) {
      error("overflow");
    }
    n2 += floor(i5 / out);
    i5 %= out;
    output.splice(i5++, 0, n2);
  }
  return String.fromCodePoint(...output);
};
var encode = function(inputArg) {
  const output = [];
  let input = ucs2decode(inputArg);
  let inputLength = input.length;
  let n2 = initialN;
  let delta = 0;
  let bias = initialBias;
  for (const currentValue of input) {
    if (currentValue < 128) {
      output.push(stringFromCharCode(currentValue));
    }
  }
  let basicLength = output.length;
  let handledCPCount = basicLength;
  if (basicLength) {
    output.push(delimiter);
  }
  while (handledCPCount < inputLength) {
    let m6 = maxInt;
    for (const currentValue of input) {
      if (currentValue >= n2 && currentValue < m6) {
        m6 = currentValue;
      }
    }
    const handledCPCountPlusOne = handledCPCount + 1;
    if (m6 - n2 > floor((maxInt - delta) / handledCPCountPlusOne)) {
      error("overflow");
    }
    delta += (m6 - n2) * handledCPCountPlusOne;
    n2 = m6;
    for (const currentValue of input) {
      if (currentValue < n2 && ++delta > maxInt) {
        error("overflow");
      }
      if (currentValue == n2) {
        let q6 = delta;
        for (let k6 = base; ; k6 += base) {
          const t5 = k6 <= bias ? tMin : k6 >= bias + tMax ? tMax : k6 - bias;
          if (q6 < t5) {
            break;
          }
          const qMinusT = q6 - t5;
          const baseMinusT = base - t5;
          output.push(stringFromCharCode(digitToBasic(t5 + qMinusT % baseMinusT, 0)));
          q6 = floor(qMinusT / baseMinusT);
        }
        output.push(stringFromCharCode(digitToBasic(q6, 0)));
        bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
        delta = 0;
        ++handledCPCount;
      }
    }
    ++delta;
    ++n2;
  }
  return output.join("");
};
var toUnicode = function(input) {
  return mapDomain(input, function(string) {
    return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
  });
};
var toASCII = function(input) {
  return mapDomain(input, function(string) {
    return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
  });
};
var punycode = {
  /**
   * A string representing the current Punycode.js version number.
   * @memberOf punycode
   * @type String
   */
  version: "2.1.0",
  /**
   * An object of methods to convert from JavaScript's internal character
   * representation (UCS-2) to Unicode code points, and back.
   * @see <https://mathiasbynens.be/notes/javascript-encoding>
   * @memberOf punycode
   * @type Object
   */
  ucs2: {
    decode: ucs2decode,
    encode: ucs2encode
  },
  decode,
  encode,
  toASCII,
  toUnicode
};

// ../taler-util/lib/whatwg-url.js
var utf8Encoder = new TextEncoder();
var utf8Decoder = new TextDecoder("utf-8", { ignoreBOM: true });
function utf8Encode(string) {
  return utf8Encoder.encode(string);
}
function utf8DecodeWithoutBOM(bytes) {
  return utf8Decoder.decode(bytes);
}
function parseUrlencoded(input) {
  const sequences = strictlySplitByteSequence(input, p("&"));
  const output = [];
  for (const bytes of sequences) {
    if (bytes.length === 0) {
      continue;
    }
    let name2, value;
    const indexOfEqual = bytes.indexOf(p("="));
    if (indexOfEqual >= 0) {
      name2 = bytes.slice(0, indexOfEqual);
      value = bytes.slice(indexOfEqual + 1);
    } else {
      name2 = bytes;
      value = new Uint8Array(0);
    }
    name2 = replaceByteInByteSequence(name2, 43, 32);
    value = replaceByteInByteSequence(value, 43, 32);
    const nameString = utf8DecodeWithoutBOM(percentDecodeBytes(name2));
    const valueString = utf8DecodeWithoutBOM(percentDecodeBytes(value));
    output.push([nameString, valueString]);
  }
  return output;
}
function parseUrlencodedString(input) {
  return parseUrlencoded(utf8Encode(input));
}
function serializeUrlencoded(tuples, encodingOverride = void 0) {
  let encoding = "utf-8";
  if (encodingOverride !== void 0) {
    encoding = encodingOverride;
  }
  let output = "";
  for (const [i5, tuple] of tuples.entries()) {
    const name2 = utf8PercentEncodeString(tuple[0], isURLEncodedPercentEncode, true);
    let value = tuple[1];
    if (tuple.length > 2 && tuple[2] !== void 0) {
      if (tuple[2] === "hidden" && name2 === "_charset_") {
        value = encoding;
      } else if (tuple[2] === "file") {
        value = value.name;
      }
    }
    value = utf8PercentEncodeString(value, isURLEncodedPercentEncode, true);
    if (i5 !== 0) {
      output += "&";
    }
    output += `${name2}=${value}`;
  }
  return output;
}
function strictlySplitByteSequence(buf, cp) {
  const list = [];
  let last = 0;
  let i5 = buf.indexOf(cp);
  while (i5 >= 0) {
    list.push(buf.slice(last, i5));
    last = i5 + 1;
    i5 = buf.indexOf(cp, last);
  }
  if (last !== buf.length) {
    list.push(buf.slice(last));
  }
  return list;
}
function replaceByteInByteSequence(buf, from, to) {
  let i5 = buf.indexOf(from);
  while (i5 >= 0) {
    buf[i5] = to;
    i5 = buf.indexOf(from, i5 + 1);
  }
  return buf;
}
function p(char) {
  return char.codePointAt(0);
}
function percentEncode(c5) {
  let hex = c5.toString(16).toUpperCase();
  if (hex.length === 1) {
    hex = `0${hex}`;
  }
  return `%${hex}`;
}
function percentDecodeBytes(input) {
  const output = new Uint8Array(input.byteLength);
  let outputIndex = 0;
  for (let i5 = 0; i5 < input.byteLength; ++i5) {
    const byte = input[i5];
    if (byte !== 37) {
      output[outputIndex++] = byte;
    } else if (byte === 37 && (!isASCIIHex(input[i5 + 1]) || !isASCIIHex(input[i5 + 2]))) {
      output[outputIndex++] = byte;
    } else {
      const bytePoint = parseInt(String.fromCodePoint(input[i5 + 1], input[i5 + 2]), 16);
      output[outputIndex++] = bytePoint;
      i5 += 2;
    }
  }
  return output.slice(0, outputIndex);
}
function percentDecodeString(input) {
  const bytes = utf8Encode(input);
  return percentDecodeBytes(bytes);
}
function isC0ControlPercentEncode(c5) {
  return c5 <= 31 || c5 > 126;
}
var extraFragmentPercentEncodeSet = /* @__PURE__ */ new Set([
  p(" "),
  p('"'),
  p("<"),
  p(">"),
  p("`")
]);
function isFragmentPercentEncode(c5) {
  return isC0ControlPercentEncode(c5) || extraFragmentPercentEncodeSet.has(c5);
}
var extraQueryPercentEncodeSet = /* @__PURE__ */ new Set([
  p(" "),
  p('"'),
  p("#"),
  p("<"),
  p(">")
]);
function isQueryPercentEncode(c5) {
  return isC0ControlPercentEncode(c5) || extraQueryPercentEncodeSet.has(c5);
}
function isSpecialQueryPercentEncode(c5) {
  return isQueryPercentEncode(c5) || c5 === p("'");
}
var extraPathPercentEncodeSet = /* @__PURE__ */ new Set([p("?"), p("`"), p("{"), p("}")]);
function isPathPercentEncode(c5) {
  return isQueryPercentEncode(c5) || extraPathPercentEncodeSet.has(c5);
}
var extraUserinfoPercentEncodeSet = /* @__PURE__ */ new Set([
  p("/"),
  p(":"),
  p(";"),
  p("="),
  p("@"),
  p("["),
  p("\\"),
  p("]"),
  p("^"),
  p("|")
]);
function isUserinfoPercentEncode(c5) {
  return isPathPercentEncode(c5) || extraUserinfoPercentEncodeSet.has(c5);
}
var extraComponentPercentEncodeSet = /* @__PURE__ */ new Set([
  p("$"),
  p("%"),
  p("&"),
  p("+"),
  p(",")
]);
function isComponentPercentEncode(c5) {
  return isUserinfoPercentEncode(c5) || extraComponentPercentEncodeSet.has(c5);
}
var extraURLEncodedPercentEncodeSet = /* @__PURE__ */ new Set([
  p("!"),
  p("'"),
  p("("),
  p(")"),
  p("~")
]);
function isURLEncodedPercentEncode(c5) {
  return isComponentPercentEncode(c5) || extraURLEncodedPercentEncodeSet.has(c5);
}
function utf8PercentEncodeCodePointInternal(codePoint, percentEncodePredicate) {
  const bytes = utf8Encode(codePoint);
  let output = "";
  for (const byte of bytes) {
    if (!percentEncodePredicate(byte)) {
      output += String.fromCharCode(byte);
    } else {
      output += percentEncode(byte);
    }
  }
  return output;
}
function utf8PercentEncodeCodePoint(codePoint, percentEncodePredicate) {
  return utf8PercentEncodeCodePointInternal(String.fromCodePoint(codePoint), percentEncodePredicate);
}
function utf8PercentEncodeString(input, percentEncodePredicate, spaceAsPlus = false) {
  let output = "";
  for (const codePoint of input) {
    if (spaceAsPlus && codePoint === " ") {
      output += "+";
    } else {
      output += utf8PercentEncodeCodePointInternal(codePoint, percentEncodePredicate);
    }
  }
  return output;
}
function isASCIIDigit(c5) {
  return c5 >= 48 && c5 <= 57;
}
function isASCIIAlpha(c5) {
  return c5 >= 65 && c5 <= 90 || c5 >= 97 && c5 <= 122;
}
function isASCIIAlphanumeric(c5) {
  return isASCIIAlpha(c5) || isASCIIDigit(c5);
}
function isASCIIHex(c5) {
  return isASCIIDigit(c5) || c5 >= 65 && c5 <= 70 || c5 >= 97 && c5 <= 102;
}
var URLSearchParamsImpl = class {
  constructor(init, { doNotStripQMark = false } = {}) {
    this._list = [];
    this._url = null;
    if (!doNotStripQMark && typeof init === "string" && init[0] === "?") {
      init = init.slice(1);
    }
    if (Array.isArray(init)) {
      for (const pair of init) {
        if (pair.length !== 2) {
          throw new TypeError("Failed to construct 'URLSearchParams': parameter 1 sequence's element does not contain exactly two elements.");
        }
        this._list.push([pair[0], pair[1]]);
      }
    } else if (typeof init === "object" && Object.getPrototypeOf(init) === null) {
      for (const name2 of Object.keys(init)) {
        const value = init[name2];
        this._list.push([name2, value]);
      }
    } else {
      this._list = parseUrlencodedString(init);
    }
  }
  _updateSteps() {
    if (this._url !== null) {
      let query = serializeUrlencoded(this._list);
      if (query === "") {
        query = null;
      }
      this._url._url.query = query;
    }
  }
  append(name2, value) {
    this._list.push([name2, value]);
    this._updateSteps();
  }
  delete(name2) {
    let i5 = 0;
    while (i5 < this._list.length) {
      if (this._list[i5][0] === name2) {
        this._list.splice(i5, 1);
      } else {
        i5++;
      }
    }
    this._updateSteps();
  }
  get(name2) {
    for (const tuple of this._list) {
      if (tuple[0] === name2) {
        return tuple[1];
      }
    }
    return null;
  }
  getAll(name2) {
    const output = [];
    for (const tuple of this._list) {
      if (tuple[0] === name2) {
        output.push(tuple[1]);
      }
    }
    return output;
  }
  entries() {
    return [...this._list.map((x6) => [x6[0], x6[1]])];
  }
  forEach(callbackfn, thisArg) {
    for (const tuple of this._list) {
      callbackfn.call(thisArg, tuple[1], tuple[0], this);
    }
  }
  has(name2) {
    for (const tuple of this._list) {
      if (tuple[0] === name2) {
        return true;
      }
    }
    return false;
  }
  set(name2, value) {
    let found = false;
    let i5 = 0;
    while (i5 < this._list.length) {
      if (this._list[i5][0] === name2) {
        if (found) {
          this._list.splice(i5, 1);
        } else {
          found = true;
          this._list[i5][1] = value;
          i5++;
        }
      } else {
        i5++;
      }
    }
    if (!found) {
      this._list.push([name2, value]);
    }
    this._updateSteps();
  }
  sort() {
    this._list.sort((a6, b5) => {
      if (a6[0] < b5[0]) {
        return -1;
      }
      if (a6[0] > b5[0]) {
        return 1;
      }
      return 0;
    });
    this._updateSteps();
  }
  [Symbol.iterator]() {
    return this._list[Symbol.iterator]();
  }
  toString() {
    return serializeUrlencoded(this._list);
  }
};
var specialSchemes = {
  ftp: 21,
  file: null,
  http: 80,
  https: 443,
  ws: 80,
  wss: 443
};
var failure = Symbol("failure");
function countSymbols(str) {
  return [...str].length;
}
function at(input, idx) {
  const c5 = input[idx];
  return isNaN(c5) ? void 0 : String.fromCodePoint(c5);
}
function isSingleDot(buffer) {
  return buffer === "." || buffer.toLowerCase() === "%2e";
}
function isDoubleDot(buffer) {
  buffer = buffer.toLowerCase();
  return buffer === ".." || buffer === "%2e." || buffer === ".%2e" || buffer === "%2e%2e";
}
function isWindowsDriveLetterCodePoints(cp1, cp2) {
  return isASCIIAlpha(cp1) && (cp2 === p(":") || cp2 === p("|"));
}
function isWindowsDriveLetterString(string) {
  return string.length === 2 && isASCIIAlpha(string.codePointAt(0)) && (string[1] === ":" || string[1] === "|");
}
function isNormalizedWindowsDriveLetterString(string) {
  return string.length === 2 && isASCIIAlpha(string.codePointAt(0)) && string[1] === ":";
}
function containsForbiddenHostCodePoint(string) {
  return string.search(/\u0000|\u0009|\u000A|\u000D|\u0020|#|\/|:|<|>|\?|@|\[|\\|\]|\^|\|/u) !== -1;
}
function containsForbiddenDomainCodePoint(string) {
  return containsForbiddenHostCodePoint(string) || string.search(/[\u0000-\u001F]|%|\u007F/u) !== -1;
}
function isSpecialScheme(scheme) {
  return specialSchemes[scheme] !== void 0;
}
function isSpecial(url) {
  return isSpecialScheme(url.scheme);
}
function isNotSpecial(url) {
  return !isSpecialScheme(url.scheme);
}
function defaultPort(scheme) {
  return specialSchemes[scheme];
}
function parseIPv4Number(input) {
  if (input === "") {
    return failure;
  }
  let R4 = 10;
  if (input.length >= 2 && input.charAt(0) === "0" && input.charAt(1).toLowerCase() === "x") {
    input = input.substring(2);
    R4 = 16;
  } else if (input.length >= 2 && input.charAt(0) === "0") {
    input = input.substring(1);
    R4 = 8;
  }
  if (input === "") {
    return 0;
  }
  let regex = /[^0-7]/u;
  if (R4 === 10) {
    regex = /[^0-9]/u;
  }
  if (R4 === 16) {
    regex = /[^0-9A-Fa-f]/u;
  }
  if (regex.test(input)) {
    return failure;
  }
  return parseInt(input, R4);
}
function parseIPv4(input) {
  const parts = input.split(".");
  if (parts[parts.length - 1] === "") {
    if (parts.length > 1) {
      parts.pop();
    }
  }
  if (parts.length > 4) {
    return failure;
  }
  const numbers = [];
  for (const part of parts) {
    const n2 = parseIPv4Number(part);
    if (n2 === failure) {
      return failure;
    }
    numbers.push(n2);
  }
  for (let i5 = 0; i5 < numbers.length - 1; ++i5) {
    if (numbers[i5] > 255) {
      return failure;
    }
  }
  if (numbers[numbers.length - 1] >= 256 ** (5 - numbers.length)) {
    return failure;
  }
  let ipv4 = numbers.pop();
  let counter2 = 0;
  for (const n2 of numbers) {
    ipv4 += n2 * 256 ** (3 - counter2);
    ++counter2;
  }
  return ipv4;
}
function serializeIPv4(address) {
  let output = "";
  let n2 = address;
  for (let i5 = 1; i5 <= 4; ++i5) {
    output = String(n2 % 256) + output;
    if (i5 !== 4) {
      output = `.${output}`;
    }
    n2 = Math.floor(n2 / 256);
  }
  return output;
}
function parseIPv6(inputArg) {
  const address = [0, 0, 0, 0, 0, 0, 0, 0];
  let pieceIndex = 0;
  let compress2 = null;
  let pointer = 0;
  const input = Array.from(inputArg, (c5) => c5.codePointAt(0));
  if (input[pointer] === p(":")) {
    if (input[pointer + 1] !== p(":")) {
      return failure;
    }
    pointer += 2;
    ++pieceIndex;
    compress2 = pieceIndex;
  }
  while (pointer < input.length) {
    if (pieceIndex === 8) {
      return failure;
    }
    if (input[pointer] === p(":")) {
      if (compress2 !== null) {
        return failure;
      }
      ++pointer;
      ++pieceIndex;
      compress2 = pieceIndex;
      continue;
    }
    let value = 0;
    let length = 0;
    while (length < 4 && isASCIIHex(input[pointer])) {
      value = value * 16 + parseInt(at(input, pointer), 16);
      ++pointer;
      ++length;
    }
    if (input[pointer] === p(".")) {
      if (length === 0) {
        return failure;
      }
      pointer -= length;
      if (pieceIndex > 6) {
        return failure;
      }
      let numbersSeen = 0;
      while (input[pointer] !== void 0) {
        let ipv4Piece = null;
        if (numbersSeen > 0) {
          if (input[pointer] === p(".") && numbersSeen < 4) {
            ++pointer;
          } else {
            return failure;
          }
        }
        if (!isASCIIDigit(input[pointer])) {
          return failure;
        }
        while (isASCIIDigit(input[pointer])) {
          const number = parseInt(at(input, pointer));
          if (ipv4Piece === null) {
            ipv4Piece = number;
          } else if (ipv4Piece === 0) {
            return failure;
          } else {
            ipv4Piece = ipv4Piece * 10 + number;
          }
          if (ipv4Piece > 255) {
            return failure;
          }
          ++pointer;
        }
        address[pieceIndex] = address[pieceIndex] * 256 + ipv4Piece;
        ++numbersSeen;
        if (numbersSeen === 2 || numbersSeen === 4) {
          ++pieceIndex;
        }
      }
      if (numbersSeen !== 4) {
        return failure;
      }
      break;
    } else if (input[pointer] === p(":")) {
      ++pointer;
      if (input[pointer] === void 0) {
        return failure;
      }
    } else if (input[pointer] !== void 0) {
      return failure;
    }
    address[pieceIndex] = value;
    ++pieceIndex;
  }
  if (compress2 !== null) {
    let swaps = pieceIndex - compress2;
    pieceIndex = 7;
    while (pieceIndex !== 0 && swaps > 0) {
      const temp = address[compress2 + swaps - 1];
      address[compress2 + swaps - 1] = address[pieceIndex];
      address[pieceIndex] = temp;
      --pieceIndex;
      --swaps;
    }
  } else if (compress2 === null && pieceIndex !== 8) {
    return failure;
  }
  return address;
}
function serializeIPv6(address) {
  let output = "";
  const compress2 = findLongestZeroSequence(address);
  let ignore0 = false;
  for (let pieceIndex = 0; pieceIndex <= 7; ++pieceIndex) {
    if (ignore0 && address[pieceIndex] === 0) {
      continue;
    } else if (ignore0) {
      ignore0 = false;
    }
    if (compress2 === pieceIndex) {
      const separator = pieceIndex === 0 ? "::" : ":";
      output += separator;
      ignore0 = true;
      continue;
    }
    output += address[pieceIndex].toString(16);
    if (pieceIndex !== 7) {
      output += ":";
    }
  }
  return output;
}
function parseHost(input, isNotSpecialArg = false) {
  if (input[0] === "[") {
    if (input[input.length - 1] !== "]") {
      return failure;
    }
    return parseIPv6(input.substring(1, input.length - 1));
  }
  if (isNotSpecialArg) {
    return parseOpaqueHost(input);
  }
  const domain = utf8DecodeWithoutBOM(percentDecodeString(input));
  const asciiDomain = domainToASCII(domain);
  if (asciiDomain === failure) {
    return failure;
  }
  if (containsForbiddenDomainCodePoint(asciiDomain)) {
    return failure;
  }
  if (endsInANumber(asciiDomain)) {
    return parseIPv4(asciiDomain);
  }
  return asciiDomain;
}
function endsInANumber(input) {
  const parts = input.split(".");
  if (parts[parts.length - 1] === "") {
    if (parts.length === 1) {
      return false;
    }
    parts.pop();
  }
  const last = parts[parts.length - 1];
  if (parseIPv4Number(last) !== failure) {
    return true;
  }
  if (/^[0-9]+$/u.test(last)) {
    return true;
  }
  return false;
}
function parseOpaqueHost(input) {
  if (containsForbiddenHostCodePoint(input)) {
    return failure;
  }
  return utf8PercentEncodeString(input, isC0ControlPercentEncode);
}
function findLongestZeroSequence(arr) {
  let maxIdx = null;
  let maxLen = 1;
  let currStart = null;
  let currLen = 0;
  for (let i5 = 0; i5 < arr.length; ++i5) {
    if (arr[i5] !== 0) {
      if (currLen > maxLen) {
        maxIdx = currStart;
        maxLen = currLen;
      }
      currStart = null;
      currLen = 0;
    } else {
      if (currStart === null) {
        currStart = i5;
      }
      ++currLen;
    }
  }
  if (currLen > maxLen) {
    return currStart;
  }
  return maxIdx;
}
function serializeHost(host) {
  if (typeof host === "number") {
    return serializeIPv4(host);
  }
  if (host instanceof Array) {
    return `[${serializeIPv6(host)}]`;
  }
  return host;
}
function domainToASCII(domain, beStrict = false) {
  let result;
  try {
    result = punycode.toASCII(domain);
  } catch (e5) {
    return failure;
  }
  if (result === null || result === "") {
    return failure;
  }
  return result;
}
function trimControlChars(url) {
  return url.replace(/^[\u0000-\u001F\u0020]+|[\u0000-\u001F\u0020]+$/gu, "");
}
function trimTabAndNewline(url) {
  return url.replace(/\u0009|\u000A|\u000D/gu, "");
}
function shortenPath(url) {
  const { path } = url;
  if (path.length === 0) {
    return;
  }
  if (url.scheme === "file" && path.length === 1 && isNormalizedWindowsDriveLetter(path[0])) {
    return;
  }
  path.pop();
}
function includesCredentials(url) {
  return url.username !== "" || url.password !== "";
}
function cannotHaveAUsernamePasswordPort(url) {
  return url.host === null || url.host === "" || url.scheme === "file";
}
function hasAnOpaquePath(url) {
  return typeof url.path === "string";
}
function isNormalizedWindowsDriveLetter(string) {
  return /^[A-Za-z]:$/u.test(string);
}
var URLStateMachine = class {
  constructor(input, base2, encodingOverride, url, stateOverride) {
    this.table = {
      "parse scheme start": this.parseSchemeStart,
      "parse scheme": this.parseScheme,
      "parse no scheme": this.parseNoScheme,
      "parse special relative or authority": this.parseSpecialRelativeOrAuthority,
      "parse path or authority": this.parsePathOrAuthority,
      "parse relative": this.parseRelative,
      "parse relative slash": this.parseRelativeSlash,
      "parse special authority slashes": this.parseSpecialAuthoritySlashes,
      "parse special authority ignore slashes": this.parseSpecialAuthorityIgnoreSlashes,
      "parse authority": this.parseAuthority,
      "parse host": this.parseHostName,
      "parse hostname": this.parseHostName,
      "parse port": this.parsePort,
      "parse file": this.parseFile,
      "parse file slash": this.parseFileSlash,
      "parse file host": this.parseFileHost,
      "parse path start": this.parsePathStart,
      "parse path": this.parsePath,
      "parse opaque path": this.parseOpaquePath,
      "parse query": this.parseQuery,
      "parse fragment": this.parseFragment
    };
    this.pointer = 0;
    this.base = base2 || null;
    this.encodingOverride = encodingOverride || "utf-8";
    this.url = url;
    this.failure = false;
    this.parseError = false;
    if (!this.url) {
      this.url = {
        scheme: "",
        username: "",
        password: "",
        host: null,
        port: null,
        path: [],
        query: null,
        fragment: null
      };
      const res2 = trimControlChars(input);
      if (res2 !== input) {
        this.parseError = true;
      }
      input = res2;
    }
    const res = trimTabAndNewline(input);
    if (res !== input) {
      this.parseError = true;
    }
    input = res;
    this.state = stateOverride || "scheme start";
    this.buffer = "";
    this.atFlag = false;
    this.arrFlag = false;
    this.passwordTokenSeenFlag = false;
    this.input = Array.from(input, (c5) => c5.codePointAt(0));
    for (; this.pointer <= this.input.length; ++this.pointer) {
      const c5 = this.input[this.pointer];
      const cStr = isNaN(c5) ? void 0 : String.fromCodePoint(c5);
      const ret = this.table[`parse ${this.state}`].call(this, c5, cStr);
      if (!ret) {
        break;
      } else if (ret === failure) {
        this.failure = true;
        break;
      }
    }
  }
  parseSchemeStart(c5, cStr) {
    if (isASCIIAlpha(c5)) {
      this.buffer += cStr.toLowerCase();
      this.state = "scheme";
    } else if (!this.stateOverride) {
      this.state = "no scheme";
      --this.pointer;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseScheme(c5, cStr) {
    if (isASCIIAlphanumeric(c5) || c5 === p("+") || c5 === p("-") || c5 === p(".")) {
      this.buffer += cStr.toLowerCase();
    } else if (c5 === p(":")) {
      if (this.stateOverride) {
        if (isSpecial(this.url) && !isSpecialScheme(this.buffer)) {
          return false;
        }
        if (!isSpecial(this.url) && isSpecialScheme(this.buffer)) {
          return false;
        }
        if ((includesCredentials(this.url) || this.url.port !== null) && this.buffer === "file") {
          return false;
        }
        if (this.url.scheme === "file" && this.url.host === "") {
          return false;
        }
      }
      this.url.scheme = this.buffer;
      if (this.stateOverride) {
        if (this.url.port === defaultPort(this.url.scheme)) {
          this.url.port = null;
        }
        return false;
      }
      this.buffer = "";
      if (this.url.scheme === "file") {
        if (this.input[this.pointer + 1] !== p("/") || this.input[this.pointer + 2] !== p("/")) {
          this.parseError = true;
        }
        this.state = "file";
      } else if (isSpecial(this.url) && this.base !== null && this.base.scheme === this.url.scheme) {
        this.state = "special relative or authority";
      } else if (isSpecial(this.url)) {
        this.state = "special authority slashes";
      } else if (this.input[this.pointer + 1] === p("/")) {
        this.state = "path or authority";
        ++this.pointer;
      } else {
        this.url.path = [""];
        this.state = "opaque path";
      }
    } else if (!this.stateOverride) {
      this.buffer = "";
      this.state = "no scheme";
      this.pointer = -1;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseNoScheme(c5) {
    if (this.base === null || hasAnOpaquePath(this.base) && c5 !== p("#")) {
      return failure;
    } else if (hasAnOpaquePath(this.base) && c5 === p("#")) {
      this.url.scheme = this.base.scheme;
      this.url.path = this.base.path;
      this.url.query = this.base.query;
      this.url.fragment = "";
      this.state = "fragment";
    } else if (this.base.scheme === "file") {
      this.state = "file";
      --this.pointer;
    } else {
      this.state = "relative";
      --this.pointer;
    }
    return true;
  }
  parseSpecialRelativeOrAuthority(c5) {
    if (c5 === p("/") && this.input[this.pointer + 1] === p("/")) {
      this.state = "special authority ignore slashes";
      ++this.pointer;
    } else {
      this.parseError = true;
      this.state = "relative";
      --this.pointer;
    }
    return true;
  }
  parsePathOrAuthority(c5) {
    if (c5 === p("/")) {
      this.state = "authority";
    } else {
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseRelative(c5) {
    this.url.scheme = this.base.scheme;
    if (c5 === p("/")) {
      this.state = "relative slash";
    } else if (isSpecial(this.url) && c5 === p("\\")) {
      this.parseError = true;
      this.state = "relative slash";
    } else {
      this.url.username = this.base.username;
      this.url.password = this.base.password;
      this.url.host = this.base.host;
      this.url.port = this.base.port;
      this.url.path = this.base.path.slice();
      this.url.query = this.base.query;
      if (c5 === p("?")) {
        this.url.query = "";
        this.state = "query";
      } else if (c5 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      } else if (!isNaN(c5)) {
        this.url.query = null;
        this.url.path.pop();
        this.state = "path";
        --this.pointer;
      }
    }
    return true;
  }
  parseRelativeSlash(c5) {
    if (isSpecial(this.url) && (c5 === p("/") || c5 === p("\\"))) {
      if (c5 === p("\\")) {
        this.parseError = true;
      }
      this.state = "special authority ignore slashes";
    } else if (c5 === p("/")) {
      this.state = "authority";
    } else {
      this.url.username = this.base.username;
      this.url.password = this.base.password;
      this.url.host = this.base.host;
      this.url.port = this.base.port;
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseSpecialAuthoritySlashes(c5) {
    if (c5 === p("/") && this.input[this.pointer + 1] === p("/")) {
      this.state = "special authority ignore slashes";
      ++this.pointer;
    } else {
      this.parseError = true;
      this.state = "special authority ignore slashes";
      --this.pointer;
    }
    return true;
  }
  parseSpecialAuthorityIgnoreSlashes(c5) {
    if (c5 !== p("/") && c5 !== p("\\")) {
      this.state = "authority";
      --this.pointer;
    } else {
      this.parseError = true;
    }
    return true;
  }
  parseAuthority(c5, cStr) {
    if (c5 === p("@")) {
      this.parseError = true;
      if (this.atFlag) {
        this.buffer = `%40${this.buffer}`;
      }
      this.atFlag = true;
      const len = countSymbols(this.buffer);
      for (let pointer = 0; pointer < len; ++pointer) {
        const codePoint = this.buffer.codePointAt(pointer);
        if (codePoint === p(":") && !this.passwordTokenSeenFlag) {
          this.passwordTokenSeenFlag = true;
          continue;
        }
        const encodedCodePoints = utf8PercentEncodeCodePoint(codePoint, isUserinfoPercentEncode);
        if (this.passwordTokenSeenFlag) {
          this.url.password += encodedCodePoints;
        } else {
          this.url.username += encodedCodePoints;
        }
      }
      this.buffer = "";
    } else if (isNaN(c5) || c5 === p("/") || c5 === p("?") || c5 === p("#") || isSpecial(this.url) && c5 === p("\\")) {
      if (this.atFlag && this.buffer === "") {
        this.parseError = true;
        return failure;
      }
      this.pointer -= countSymbols(this.buffer) + 1;
      this.buffer = "";
      this.state = "host";
    } else {
      this.buffer += cStr;
    }
    return true;
  }
  parseHostName(c5, cStr) {
    if (this.stateOverride && this.url.scheme === "file") {
      --this.pointer;
      this.state = "file host";
    } else if (c5 === p(":") && !this.arrFlag) {
      if (this.buffer === "") {
        this.parseError = true;
        return failure;
      }
      if (this.stateOverride === "hostname") {
        return false;
      }
      const host = parseHost(this.buffer, isNotSpecial(this.url));
      if (host === failure) {
        return failure;
      }
      this.url.host = host;
      this.buffer = "";
      this.state = "port";
    } else if (isNaN(c5) || c5 === p("/") || c5 === p("?") || c5 === p("#") || isSpecial(this.url) && c5 === p("\\")) {
      --this.pointer;
      if (isSpecial(this.url) && this.buffer === "") {
        this.parseError = true;
        return failure;
      } else if (this.stateOverride && this.buffer === "" && (includesCredentials(this.url) || this.url.port !== null)) {
        this.parseError = true;
        return false;
      }
      const host = parseHost(this.buffer, isNotSpecial(this.url));
      if (host === failure) {
        return failure;
      }
      this.url.host = host;
      this.buffer = "";
      this.state = "path start";
      if (this.stateOverride) {
        return false;
      }
    } else {
      if (c5 === p("[")) {
        this.arrFlag = true;
      } else if (c5 === p("]")) {
        this.arrFlag = false;
      }
      this.buffer += cStr;
    }
    return true;
  }
  parsePort(c5, cStr) {
    if (isASCIIDigit(c5)) {
      this.buffer += cStr;
    } else if (isNaN(c5) || c5 === p("/") || c5 === p("?") || c5 === p("#") || isSpecial(this.url) && c5 === p("\\") || this.stateOverride) {
      if (this.buffer !== "") {
        const port = parseInt(this.buffer);
        if (port > 2 ** 16 - 1) {
          this.parseError = true;
          return failure;
        }
        this.url.port = port === defaultPort(this.url.scheme) ? null : port;
        this.buffer = "";
      }
      if (this.stateOverride) {
        return false;
      }
      this.state = "path start";
      --this.pointer;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseFile(c5) {
    this.url.scheme = "file";
    this.url.host = "";
    if (c5 === p("/") || c5 === p("\\")) {
      if (c5 === p("\\")) {
        this.parseError = true;
      }
      this.state = "file slash";
    } else if (this.base !== null && this.base.scheme === "file") {
      this.url.host = this.base.host;
      this.url.path = this.base.path.slice();
      this.url.query = this.base.query;
      if (c5 === p("?")) {
        this.url.query = "";
        this.state = "query";
      } else if (c5 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      } else if (!isNaN(c5)) {
        this.url.query = null;
        if (!startsWithWindowsDriveLetter(this.input, this.pointer)) {
          shortenPath(this.url);
        } else {
          this.parseError = true;
          this.url.path = [];
        }
        this.state = "path";
        --this.pointer;
      }
    } else {
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseFileSlash(c5) {
    if (c5 === p("/") || c5 === p("\\")) {
      if (c5 === p("\\")) {
        this.parseError = true;
      }
      this.state = "file host";
    } else {
      if (this.base !== null && this.base.scheme === "file") {
        if (!startsWithWindowsDriveLetter(this.input, this.pointer) && isNormalizedWindowsDriveLetterString(this.base.path[0])) {
          this.url.path.push(this.base.path[0]);
        }
        this.url.host = this.base.host;
      }
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseFileHost(c5, cStr) {
    if (isNaN(c5) || c5 === p("/") || c5 === p("\\") || c5 === p("?") || c5 === p("#")) {
      --this.pointer;
      if (!this.stateOverride && isWindowsDriveLetterString(this.buffer)) {
        this.parseError = true;
        this.state = "path";
      } else if (this.buffer === "") {
        this.url.host = "";
        if (this.stateOverride) {
          return false;
        }
        this.state = "path start";
      } else {
        let host = parseHost(this.buffer, isNotSpecial(this.url));
        if (host === failure) {
          return failure;
        }
        if (host === "localhost") {
          host = "";
        }
        this.url.host = host;
        if (this.stateOverride) {
          return false;
        }
        this.buffer = "";
        this.state = "path start";
      }
    } else {
      this.buffer += cStr;
    }
    return true;
  }
  parsePathStart(c5) {
    if (isSpecial(this.url)) {
      if (c5 === p("\\")) {
        this.parseError = true;
      }
      this.state = "path";
      if (c5 !== p("/") && c5 !== p("\\")) {
        --this.pointer;
      }
    } else if (!this.stateOverride && c5 === p("?")) {
      this.url.query = "";
      this.state = "query";
    } else if (!this.stateOverride && c5 === p("#")) {
      this.url.fragment = "";
      this.state = "fragment";
    } else if (c5 !== void 0) {
      this.state = "path";
      if (c5 !== p("/")) {
        --this.pointer;
      }
    } else if (this.stateOverride && this.url.host === null) {
      this.url.path.push("");
    }
    return true;
  }
  parsePath(c5) {
    if (isNaN(c5) || c5 === p("/") || isSpecial(this.url) && c5 === p("\\") || !this.stateOverride && (c5 === p("?") || c5 === p("#"))) {
      if (isSpecial(this.url) && c5 === p("\\")) {
        this.parseError = true;
      }
      if (isDoubleDot(this.buffer)) {
        shortenPath(this.url);
        if (c5 !== p("/") && !(isSpecial(this.url) && c5 === p("\\"))) {
          this.url.path.push("");
        }
      } else if (isSingleDot(this.buffer) && c5 !== p("/") && !(isSpecial(this.url) && c5 === p("\\"))) {
        this.url.path.push("");
      } else if (!isSingleDot(this.buffer)) {
        if (this.url.scheme === "file" && this.url.path.length === 0 && isWindowsDriveLetterString(this.buffer)) {
          this.buffer = `${this.buffer[0]}:`;
        }
        this.url.path.push(this.buffer);
      }
      this.buffer = "";
      if (c5 === p("?")) {
        this.url.query = "";
        this.state = "query";
      }
      if (c5 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      }
    } else {
      if (c5 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.buffer += utf8PercentEncodeCodePoint(c5, isPathPercentEncode);
    }
    return true;
  }
  parseOpaquePath(c5) {
    if (c5 === p("?")) {
      this.url.query = "";
      this.state = "query";
    } else if (c5 === p("#")) {
      this.url.fragment = "";
      this.state = "fragment";
    } else {
      if (!isNaN(c5) && c5 !== p("%")) {
        this.parseError = true;
      }
      if (c5 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      if (!isNaN(c5)) {
        this.url.path += utf8PercentEncodeCodePoint(c5, isC0ControlPercentEncode);
      }
    }
    return true;
  }
  parseQuery(c5, cStr) {
    if (!isSpecial(this.url) || this.url.scheme === "ws" || this.url.scheme === "wss") {
      this.encodingOverride = "utf-8";
    }
    if (!this.stateOverride && c5 === p("#") || isNaN(c5)) {
      const queryPercentEncodePredicate = isSpecial(this.url) ? isSpecialQueryPercentEncode : isQueryPercentEncode;
      this.url.query += utf8PercentEncodeString(this.buffer, queryPercentEncodePredicate);
      this.buffer = "";
      if (c5 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      }
    } else if (!isNaN(c5)) {
      if (c5 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.buffer += cStr;
    }
    return true;
  }
  parseFragment(c5) {
    if (!isNaN(c5)) {
      if (c5 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.url.fragment += utf8PercentEncodeCodePoint(c5, isFragmentPercentEncode);
    }
    return true;
  }
};
var fileOtherwiseCodePoints = /* @__PURE__ */ new Set([p("/"), p("\\"), p("?"), p("#")]);
function startsWithWindowsDriveLetter(input, pointer) {
  const length = input.length - pointer;
  return length >= 2 && isWindowsDriveLetterCodePoints(input[pointer], input[pointer + 1]) && (length === 2 || fileOtherwiseCodePoints.has(input[pointer + 2]));
}
function serializeURL(url, excludeFragment) {
  let output = `${url.scheme}:`;
  if (url.host !== null) {
    output += "//";
    if (url.username !== "" || url.password !== "") {
      output += url.username;
      if (url.password !== "") {
        output += `:${url.password}`;
      }
      output += "@";
    }
    output += serializeHost(url.host);
    if (url.port !== null) {
      output += `:${url.port}`;
    }
  }
  if (url.host === null && !hasAnOpaquePath(url) && url.path.length > 1 && url.path[0] === "") {
    output += "/.";
  }
  output += serializePath(url);
  if (url.query !== null) {
    output += `?${url.query}`;
  }
  if (!excludeFragment && url.fragment !== null) {
    output += `#${url.fragment}`;
  }
  return output;
}
function serializeOrigin(tuple) {
  let result = `${tuple.scheme}://`;
  result += serializeHost(tuple.host);
  if (tuple.port !== null) {
    result += `:${tuple.port}`;
  }
  return result;
}
function serializePath(url) {
  if (typeof url.path === "string") {
    return url.path;
  }
  let output = "";
  for (const segment of url.path) {
    output += `/${segment}`;
  }
  return output;
}
function serializeURLOrigin(url) {
  switch (url.scheme) {
    case "blob":
      try {
        return serializeURLOrigin(parseURL(serializePath(url)));
      } catch (e5) {
        return "null";
      }
    case "ftp":
    case "http":
    case "https":
    case "ws":
    case "wss":
      return serializeOrigin({
        scheme: url.scheme,
        host: url.host,
        port: url.port
      });
    case "file":
      return "null";
    default:
      return "null";
  }
}
function basicURLParse(input, options) {
  if (options === void 0) {
    options = {};
  }
  const usm = new URLStateMachine(input, options.baseURL, options.encodingOverride, options.url, options.stateOverride);
  if (usm.failure) {
    return null;
  }
  return usm.url;
}
function setTheUsername(url, username) {
  url.username = utf8PercentEncodeString(username, isUserinfoPercentEncode);
}
function setThePassword(url, password) {
  url.password = utf8PercentEncodeString(password, isUserinfoPercentEncode);
}
function serializeInteger(integer) {
  return String(integer);
}
function parseURL(input, options) {
  if (options === void 0) {
    options = {};
  }
  return basicURLParse(input, {
    baseURL: options.baseURL,
    encodingOverride: options.encodingOverride
  });
}
var NativeURL = typeof URL !== "undefined" ? URL : void 0;
var URLImpl = class {
  //Include URL type for "url" and "base" params.
  constructor(url, base2) {
    let parsedBase = null;
    if (base2 !== void 0) {
      if (base2 instanceof URL) {
        base2 = base2.href;
      }
      parsedBase = basicURLParse(base2);
      if (parsedBase === null) {
        throw new TypeError(`Invalid base URL: ${base2}`);
      }
    }
    if (url instanceof URL) {
      url = url.href;
    }
    const parsedURL = basicURLParse(url, { baseURL: parsedBase });
    if (parsedURL === null) {
      throw new TypeError(`Invalid URL: ${url}`);
    }
    const query = parsedURL.query !== null ? parsedURL.query : "";
    this._url = parsedURL;
    this._query = new URLSearchParamsImpl(query, {
      doNotStripQMark: true
    });
    this._query._url = this;
  }
  get href() {
    return serializeURL(this._url);
  }
  set href(v3) {
    const parsedURL = basicURLParse(v3);
    if (parsedURL === null) {
      throw new TypeError(`Invalid URL: ${v3}`);
    }
    this._url = parsedURL;
    this._query._list.splice(0);
    const { query } = parsedURL;
    if (query !== null) {
      this._query._list = parseUrlencodedString(query);
    }
  }
  get origin() {
    return serializeURLOrigin(this._url);
  }
  get protocol() {
    return `${this._url.scheme}:`;
  }
  set protocol(v3) {
    basicURLParse(`${v3}:`, {
      url: this._url,
      stateOverride: "scheme start"
    });
  }
  get username() {
    return this._url.username;
  }
  set username(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    setTheUsername(this._url, v3);
  }
  get password() {
    return this._url.password;
  }
  set password(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    setThePassword(this._url, v3);
  }
  get host() {
    const url = this._url;
    if (url.host === null) {
      return "";
    }
    if (url.port === null) {
      return serializeHost(url.host);
    }
    return `${serializeHost(url.host)}:${serializeInteger(url.port)}`;
  }
  set host(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    basicURLParse(v3, { url: this._url, stateOverride: "host" });
  }
  get hostname() {
    if (this._url.host === null) {
      return "";
    }
    return serializeHost(this._url.host);
  }
  set hostname(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    basicURLParse(v3, { url: this._url, stateOverride: "hostname" });
  }
  get port() {
    if (this._url.port === null) {
      return "";
    }
    return serializeInteger(this._url.port);
  }
  set port(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    if (v3 === "") {
      this._url.port = null;
    } else {
      basicURLParse(v3, { url: this._url, stateOverride: "port" });
    }
  }
  get pathname() {
    return serializePath(this._url);
  }
  set pathname(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    this._url.path = [];
    basicURLParse(v3, { url: this._url, stateOverride: "path start" });
  }
  get search() {
    if (this._url.query === null || this._url.query === "") {
      return "";
    }
    return `?${this._url.query}`;
  }
  set search(v3) {
    const url = this._url;
    if (v3 === "") {
      url.query = null;
      this._query._list = [];
      return;
    }
    const input = v3[0] === "?" ? v3.substring(1) : v3;
    url.query = "";
    basicURLParse(input, { url, stateOverride: "query" });
    this._query._list = parseUrlencodedString(input);
  }
  get searchParams() {
    return this._query;
  }
  get hash() {
    if (this._url.fragment === null || this._url.fragment === "") {
      return "";
    }
    return `#${this._url.fragment}`;
  }
  set hash(v3) {
    if (v3 === "") {
      this._url.fragment = null;
      return;
    }
    const input = v3[0] === "#" ? v3.substring(1) : v3;
    this._url.fragment = "";
    basicURLParse(input, { url: this._url, stateOverride: "fragment" });
  }
  toJSON() {
    return this.href;
  }
  static createObjectURL(blob) {
    if (!NativeURL)
      throw new Error("This method requires a native implementation, which does not exist");
    return NativeURL.createObjectURL(blob);
  }
  static revokeObjectURL(url) {
    if (!NativeURL)
      throw new Error("This method requires a native implementation, which does not exist");
    return NativeURL.revokeObjectURL(url);
  }
};

// ../taler-util/lib/url.js
(function() {
  if (typeof globalThis === "object")
    return;
  Object.defineProperty(Object.prototype, "__magic__", {
    get: function() {
      return this;
    },
    configurable: true
    // This makes it possible to `delete` the getter later.
  });
  __magic__.globalThis = __magic__;
  delete Object.prototype.__magic__;
})();
var useOwnUrlImp = true;
var _URL = globalThis.URL;
if (useOwnUrlImp || !_URL) {
  globalThis.URL = _URL = URLImpl;
  _URL = URLImpl;
}
var URL2 = _URL;
var _URLSearchParams = globalThis.URLSearchParams;
if (useOwnUrlImp || !_URLSearchParams) {
  globalThis.URLSearchParams = URLSearchParamsImpl;
  _URLSearchParams = URLSearchParamsImpl;
}
var URLSearchParams2 = _URLSearchParams;

// ../taler-util/lib/helpers.js
function canonicalizeBaseUrl(url) {
  if (!url.startsWith("http") && !url.startsWith("https")) {
    url = "https://" + url;
  }
  const x6 = new URL2(url);
  if (!x6.pathname.endsWith("/")) {
    x6.pathname = x6.pathname + "/";
  }
  x6.search = "";
  x6.hash = "";
  return x6.href;
}
function canonicalJson(obj) {
  obj = JSON.parse(JSON.stringify(obj));
  if (typeof obj === "string") {
    return JSON.stringify(obj);
  }
  if (typeof obj === "number" || typeof obj === "boolean" || obj === null) {
    return JSON.stringify(obj);
  }
  if (Array.isArray(obj)) {
    const objs = obj.map((e5) => canonicalJson(e5));
    return `[${objs.join(",")}]`;
  }
  const keys = [];
  for (const key in obj) {
    keys.push(key);
  }
  keys.sort();
  let s6 = "{";
  for (let i5 = 0; i5 < keys.length; i5++) {
    const key = keys[i5];
    s6 += JSON.stringify(key) + ":" + canonicalJson(obj[key]);
    if (i5 !== keys.length - 1) {
      s6 += ",";
    }
  }
  return s6 + "}";
}
function strcmp(s1, s23) {
  if (s1 < s23) {
    return -1;
  }
  if (s1 > s23) {
    return 1;
  }
  return 0;
}
function j2s(x6) {
  return JSON.stringify(x6, void 0, 2);
}

// ../taler-util/lib/logging.js
var isNode = typeof process !== "undefined" && typeof process.release !== "undefined" && process.release.name === "node";
var LogLevel;
(function(LogLevel2) {
  LogLevel2["Trace"] = "trace";
  LogLevel2["Message"] = "message";
  LogLevel2["Info"] = "info";
  LogLevel2["Warn"] = "warn";
  LogLevel2["Error"] = "error";
  LogLevel2["None"] = "none";
})(LogLevel || (LogLevel = {}));
var globalLogLevel = LogLevel.Info;
var byTagLogLevel = {};
var nativeLogging = false;
Error.prototype.toString = function() {
  if (this === null || typeof this !== "object" && typeof this !== "function") {
    throw new TypeError();
  }
  let name2 = this.name;
  name2 = name2 === void 0 ? "Error" : `${name2}`;
  let msg = this.message;
  msg = msg === void 0 ? "" : `${msg}`;
  let cause = "";
  if ("cause" in this) {
    cause = `
 Caused by: ${this.cause}`;
  }
  return `${name2}: ${msg}${cause}`;
};
function writeNativeLog(message, tag, level, args) {
  const logFn = globalThis.__nativeLog;
  if (logFn) {
    let m6;
    if (args.length == 0) {
      m6 = message;
    } else {
      m6 = message + " " + args.toString();
    }
    logFn(level, tag, message);
  }
}
function writeNodeLog(message, tag, level, args) {
  try {
    let msg = `${(/* @__PURE__ */ new Date()).toISOString()} ${tag} ${level} ${message}`;
    if (args.length != 0) {
      msg += ` ${JSON.stringify(args, void 0, 2)}
`;
    } else {
      msg += `
`;
    }
    process.stderr.write(msg);
  } catch (e5) {
    let msg = `${(/* @__PURE__ */ new Date()).toISOString()} (logger) FATAL `;
    if (e5 instanceof Error) {
      msg += `failed to write log: ${e5.message}
`;
    } else {
      msg += "failed to write log\n";
    }
    process.stderr.write(msg);
  }
}
var Logger = class {
  constructor(tag) {
    this.tag = tag;
  }
  getGlobalLogLevel() {
    return globalLogLevel;
  }
  shouldLogTrace() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
        return true;
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogInfo() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
        return true;
      case LogLevel.Warn:
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogWarn() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
        return true;
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogError() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
      case LogLevel.Error:
        return true;
      case LogLevel.None:
        return false;
    }
  }
  info(message, ...args) {
    if (!this.shouldLogInfo()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 2, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "INFO", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} INFO ` + message, ...args);
    }
  }
  warn(message, ...args) {
    if (!this.shouldLogWarn()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 3, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "WARN", args);
    } else {
      console.warn(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} INFO ` + message, ...args);
    }
  }
  error(message, ...args) {
    if (!this.shouldLogError()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 4, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "ERROR", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} ERROR ` + message, ...args);
    }
  }
  trace(message, ...args) {
    if (!this.shouldLogTrace()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 1, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "TRACE", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} TRACE ` + message, ...args);
    }
  }
  reportBreak() {
    if (!this.shouldLogError()) {
      return;
    }
    const location2 = new Error("programming error");
    this.error(`assertion failed: ${location2.stack}`);
  }
};

// ../taler-util/lib/codec.js
var logger = new Logger("codec.ts");
var DecodingError = class _DecodingError extends Error {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, _DecodingError.prototype);
    this.name = "DecodingError";
  }
};
function renderContext(c5) {
  const p4 = c5?.path;
  if (p4) {
    return p4.join(".");
  } else {
    return "(unknown)";
  }
}
function joinContext(c5, part) {
  const path = c5?.path ?? [];
  return {
    path: path.concat([part])
  };
}
var ObjectCodecBuilder = class {
  constructor() {
    this.propList = [];
    this.deprecatedProps = /* @__PURE__ */ new Set();
    this._allowExtra = false;
  }
  /**
   * Define a property for the object.
   */
  property(x6, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.propList.push({ name: x6, codec });
    return this;
  }
  /**
   * Define a property for the object.
   */
  propertyStrict(x6, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.propList.push({ name: x6, codec });
    return this;
  }
  /**
   * Concatenate properties from @a codec.
   *
   * @param other codec to concat properties from
   *
   * FIXME: do proper union of all `other' props.
   */
  mixin(other) {
    this.propList.push(...other.getProps());
    return this;
  }
  /**
   * Define a deprecated property for the object.
   *
   * Deprecated properties won't be validated, their presence will
   * be validated in TRACE mode.
   */
  deprecatedProperty(x6) {
    this.deprecatedProps.add(x6);
    return this;
  }
  /**
   * Do not log warnings if the object has extra properties.
   */
  allowExtra() {
    this._allowExtra = true;
    return this;
  }
  /**
   * Return the built codec.
   *
   * @param objectDisplayName name of the object that this codec operates on,
   *   used in error messages.
   */
  build(objectDisplayName) {
    const propList = this.propList;
    const allowExtra = this._allowExtra;
    const deprecatedPros = this.deprecatedProps;
    return {
      decode(x6, c5) {
        if (!c5) {
          c5 = {
            path: [`(${objectDisplayName})`]
          };
        }
        if (typeof x6 !== "object") {
          throw new DecodingError(`expected object for ${objectDisplayName} at ${renderContext(c5)} but got ${typeof x6}`);
        }
        const obj = {};
        for (const prop of propList) {
          const propRawVal = x6[prop.name];
          const propVal = prop.codec.decode(propRawVal, joinContext(c5, prop.name));
          obj[prop.name] = propVal;
        }
        for (const prop in x6) {
          if (prop in obj) {
            continue;
          }
          if (allowExtra) {
            obj[prop] = x6[prop];
          } else if (deprecatedPros.has(prop)) {
            logger.trace(`Deprecated property ${prop} for ${objectDisplayName} at ${renderContext(c5)}`);
          } else {
            logger.warn(`Extra property ${prop} for ${objectDisplayName} at ${renderContext(c5)}`);
          }
        }
        return obj;
      },
      getProps() {
        return propList;
      }
    };
  }
};
var UnionCodecBuilder = class {
  constructor(discriminator, baseCodec) {
    this.discriminator = discriminator;
    this.baseCodec = baseCodec;
    this.alternatives = /* @__PURE__ */ new Map();
  }
  /**
   * Define a property for the object.
   */
  alternative(tagValue, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.alternatives.set(tagValue, { codec, tagValue });
    return this;
  }
  /**
   * Return the built codec.
   *
   * @param objectDisplayName name of the object that this codec operates on,
   *   used in error messages.
   */
  build(objectDisplayName) {
    const alternatives = this.alternatives;
    const discriminator = this.discriminator;
    const baseCodec = this.baseCodec;
    return {
      decode(x6, c5) {
        if (!c5) {
          c5 = {
            path: [`(${objectDisplayName})`]
          };
        }
        const d6 = x6[discriminator];
        if (d6 === void 0 && !alternatives.has(d6)) {
          throw new DecodingError(`expected tag for ${objectDisplayName} at ${renderContext(c5)}.${String(discriminator)}`);
        }
        const alt = alternatives.get(d6);
        if (!alt) {
          throw new DecodingError(`unknown tag for ${objectDisplayName} ${d6} at ${renderContext(c5)}.${String(discriminator)}`);
        }
        const altDecoded = alt.codec.decode(x6);
        if (baseCodec) {
          const baseDecoded = baseCodec.decode(x6, c5);
          return { ...baseDecoded, ...altDecoded };
        } else {
          return altDecoded;
        }
      }
    };
  }
};
var UnionCodecPreBuilder = class {
  discriminateOn(discriminator, baseCodec) {
    return new UnionCodecBuilder(discriminator, baseCodec);
  }
};
function buildCodecForObject() {
  return new ObjectCodecBuilder();
}
function buildCodecForUnion() {
  return new UnionCodecPreBuilder();
}
function codecForMap(innerCodec) {
  if (!innerCodec) {
    throw Error("inner codec must be defined");
  }
  return {
    decode(x6, c5) {
      const map2 = {};
      if (typeof x6 !== "object") {
        throw new DecodingError(`expected object at ${renderContext(c5)}`);
      }
      for (const i5 in x6) {
        map2[i5] = innerCodec.decode(x6[i5], joinContext(c5, `[${i5}]`));
      }
      return map2;
    }
  };
}
function codecForList(innerCodec) {
  if (!innerCodec) {
    throw Error("inner codec must be defined");
  }
  return {
    decode(x6, c5) {
      const arr = [];
      if (!Array.isArray(x6)) {
        throw new DecodingError(`expected array at ${renderContext(c5)}`);
      }
      for (const i5 in x6) {
        arr.push(innerCodec.decode(x6[i5], joinContext(c5, `[${i5}]`)));
      }
      return arr;
    }
  };
}
function codecForNumber() {
  return {
    decode(x6, c5) {
      if (typeof x6 === "number") {
        return x6;
      }
      throw new DecodingError(`expected number at ${renderContext(c5)} but got ${typeof x6}`);
    }
  };
}
function codecForBoolean() {
  return {
    decode(x6, c5) {
      if (typeof x6 === "boolean") {
        return x6;
      }
      throw new DecodingError(`expected boolean at ${renderContext(c5)} but got ${typeof x6}`);
    }
  };
}
function codecForString() {
  return {
    decode(x6, c5) {
      if (typeof x6 === "string") {
        return x6;
      }
      throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
    }
  };
}
function codecForStringURL(shouldEndWithSlash) {
  return {
    decode(x6, c5) {
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
      }
      if (shouldEndWithSlash && !x6.endsWith("/")) {
        throw new DecodingError(`expected URL string that ends with slash at ${renderContext(c5)} but got ${x6}`);
      }
      try {
        const url = new URL(x6);
        return x6;
      } catch (e5) {
        if (e5 instanceof Error) {
          throw new DecodingError(e5.message);
        } else {
          throw new DecodingError(`expected an URL string at ${renderContext(c5)} but got "${x6}"`);
        }
      }
    }
  };
}
function codecForAny() {
  return {
    decode(x6, c5) {
      return x6;
    }
  };
}
function codecForConstString(s6) {
  return {
    decode(x6, c5) {
      if (x6 === s6) {
        return x6;
      }
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string constant "${s6}" at ${renderContext(c5)} but got ${typeof x6}`);
      }
      throw new DecodingError(`expected string constant "${s6}" at ${renderContext(c5)} but got string value "${x6}"`);
    }
  };
}
function codecForConstNumber(n2) {
  return {
    decode(x6, c5) {
      if (x6 === n2) {
        return x6;
      }
      throw new DecodingError(`expected number constant "${n2}" at ${renderContext(c5)}  but got ${typeof x6}`);
    }
  };
}
function codecOptional(innerCodec) {
  return {
    decode(x6, c5) {
      if (x6 === void 0 || x6 === null) {
        return void 0;
      }
      return innerCodec.decode(x6, c5);
    }
  };
}
function codecOptionalDefault(innerCodec, def) {
  return {
    decode(x6, c5) {
      if (x6 === void 0 || x6 === null) {
        return def;
      }
      return innerCodec.decode(x6, c5);
    }
  };
}
function codecForLazy(innerCodec) {
  let instance = void 0;
  return {
    decode(x6, c5) {
      if (instance === void 0) {
        instance = innerCodec();
      }
      return instance.decode(x6, c5);
    }
  };
}
function codecForEither(...alts) {
  return {
    decode(x6, c5) {
      for (const alt of alts) {
        try {
          return alt.decode(x6, c5);
        } catch (e5) {
          continue;
        }
      }
      if (logger.shouldLogTrace()) {
        logger.trace(`offending value: ${j2s(x6)}`);
      }
      throw new DecodingError(`No alternative matched at ${renderContext(c5)}`);
    }
  };
}

// ../taler-util/lib/errors.js
function makeErrorDetail(code, detail, hint) {
  if (!hint && !detail.hint) {
    hint = getDefaultTalerErrorHint(code);
  }
  const when = AbsoluteTime.now();
  return { code, when, hint, ...detail };
}
function getDefaultTalerErrorHint(code) {
  const errName = TalerErrorCode[code];
  if (errName) {
    return `Error (${errName})`;
  } else {
    return `Error (<unknown>)`;
  }
}
var TalerError = class _TalerError extends Error {
  constructor(d6, cause) {
    super(d6.hint ?? `Error (code ${d6.code})`);
    this.errorDetail = d6;
    this.cause = cause;
    Object.setPrototypeOf(this, _TalerError.prototype);
  }
  static fromDetail(code, detail, hint, cause) {
    if (!hint) {
      hint = getDefaultTalerErrorHint(code);
    }
    const when = AbsoluteTime.now();
    return new _TalerError({ code, when, hint, ...detail }, cause);
  }
  static fromUncheckedDetail(d6, c5) {
    return new _TalerError({ ...d6 }, c5);
  }
  static fromException(e5) {
    const errDetail = getErrorDetailFromException(e5);
    return new _TalerError(errDetail, e5);
  }
  hasErrorCode(code) {
    return this.errorDetail.code === code;
  }
  toString() {
    return `TalerError: ${JSON.stringify(this.errorDetail)}`;
  }
};
function getErrorDetailFromException(e5) {
  if (e5 instanceof TalerError) {
    return e5.errorDetail;
  }
  if (e5 instanceof CancellationToken.CancellationError) {
    const err2 = makeErrorDetail(TalerErrorCode.WALLET_CORE_REQUEST_CANCELLED, {});
    return err2;
  }
  if (e5 instanceof Error) {
    const err2 = makeErrorDetail(TalerErrorCode.WALLET_UNEXPECTED_EXCEPTION, {
      stack: e5.stack
    }, `unexpected exception (message: ${e5.message})`);
    return err2;
  }
  let excString;
  try {
    excString = e5.toString();
  } catch (e6) {
    excString = "can't stringify exception";
  }
  const err = makeErrorDetail(TalerErrorCode.WALLET_UNEXPECTED_EXCEPTION, {}, `unexpected exception (not an exception, ${excString})`);
  return err;
}
function assertUnreachable(x6) {
  throw new Error("Didn't expect to get here");
}

// ../taler-util/lib/taler-error-codes.js
var TalerErrorCode;
(function(TalerErrorCode2) {
  TalerErrorCode2[TalerErrorCode2["NONE"] = 0] = "NONE";
  TalerErrorCode2[TalerErrorCode2["INVALID"] = 1] = "INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CLIENT_INTERNAL_ERROR"] = 2] = "GENERIC_CLIENT_INTERNAL_ERROR";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CLIENT_UNSUPPORTED_PROTOCOL_VERSION"] = 3] = "GENERIC_CLIENT_UNSUPPORTED_PROTOCOL_VERSION";
  TalerErrorCode2[TalerErrorCode2["GENERIC_INVALID_RESPONSE"] = 10] = "GENERIC_INVALID_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TIMEOUT"] = 11] = "GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_VERSION_MALFORMED"] = 12] = "GENERIC_VERSION_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_REPLY_MALFORMED"] = 13] = "GENERIC_REPLY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CONFIGURATION_INVALID"] = 14] = "GENERIC_CONFIGURATION_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UNEXPECTED_REQUEST_ERROR"] = 15] = "GENERIC_UNEXPECTED_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_PERMISSION_INSUFFICIENT"] = 16] = "GENERIC_TOKEN_PERMISSION_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_METHOD_INVALID"] = 20] = "GENERIC_METHOD_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_ENDPOINT_UNKNOWN"] = 21] = "GENERIC_ENDPOINT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_JSON_INVALID"] = 22] = "GENERIC_JSON_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_HTTP_HEADERS_MALFORMED"] = 23] = "GENERIC_HTTP_HEADERS_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PAYTO_URI_MALFORMED"] = 24] = "GENERIC_PAYTO_URI_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARAMETER_MISSING"] = 25] = "GENERIC_PARAMETER_MISSING";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARAMETER_MALFORMED"] = 26] = "GENERIC_PARAMETER_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_RESERVE_PUB_MALFORMED"] = 27] = "GENERIC_RESERVE_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_COMPRESSION_INVALID"] = 28] = "GENERIC_COMPRESSION_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PATH_SEGMENT_MALFORMED"] = 29] = "GENERIC_PATH_SEGMENT_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CURRENCY_MISMATCH"] = 30] = "GENERIC_CURRENCY_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["GENERIC_URI_TOO_LONG"] = 31] = "GENERIC_URI_TOO_LONG";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UPLOAD_EXCEEDS_LIMIT"] = 32] = "GENERIC_UPLOAD_EXCEEDS_LIMIT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UNAUTHORIZED"] = 40] = "GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_UNKNOWN"] = 41] = "GENERIC_TOKEN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_EXPIRED"] = 42] = "GENERIC_TOKEN_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_MALFORMED"] = 43] = "GENERIC_TOKEN_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FORBIDDEN"] = 44] = "GENERIC_FORBIDDEN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_SETUP_FAILED"] = 50] = "GENERIC_DB_SETUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_START_FAILED"] = 51] = "GENERIC_DB_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_STORE_FAILED"] = 52] = "GENERIC_DB_STORE_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_FETCH_FAILED"] = 53] = "GENERIC_DB_FETCH_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_COMMIT_FAILED"] = 54] = "GENERIC_DB_COMMIT_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_SOFT_FAILURE"] = 55] = "GENERIC_DB_SOFT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_INVARIANT_FAILURE"] = 56] = "GENERIC_DB_INVARIANT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_INTERNAL_INVARIANT_FAILURE"] = 60] = "GENERIC_INTERNAL_INVARIANT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_COMPUTE_JSON_HASH"] = 61] = "GENERIC_FAILED_COMPUTE_JSON_HASH";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_COMPUTE_AMOUNT"] = 62] = "GENERIC_FAILED_COMPUTE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARSER_OUT_OF_MEMORY"] = 70] = "GENERIC_PARSER_OUT_OF_MEMORY";
  TalerErrorCode2[TalerErrorCode2["GENERIC_ALLOCATION_FAILURE"] = 71] = "GENERIC_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_JSON_ALLOCATION_FAILURE"] = 72] = "GENERIC_JSON_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CURL_ALLOCATION_FAILURE"] = 73] = "GENERIC_CURL_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_TO_LOAD_TEMPLATE"] = 74] = "GENERIC_FAILED_TO_LOAD_TEMPLATE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_TO_EXPAND_TEMPLATE"] = 75] = "GENERIC_FAILED_TO_EXPAND_TEMPLATE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FEATURE_NOT_IMPLEMENTED"] = 76] = "GENERIC_FEATURE_NOT_IMPLEMENTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_BAD_CONFIGURATION"] = 1e3] = "EXCHANGE_GENERIC_BAD_CONFIGURATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_OPERATION_UNKNOWN"] = 1001] = "EXCHANGE_GENERIC_OPERATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_WRONG_NUMBER_OF_SEGMENTS"] = 1002] = "EXCHANGE_GENERIC_WRONG_NUMBER_OF_SEGMENTS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_CONFLICTING_DENOMINATION_KEY"] = 1003] = "EXCHANGE_GENERIC_COIN_CONFLICTING_DENOMINATION_KEY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COINS_INVALID_COIN_PUB"] = 1004] = "EXCHANGE_GENERIC_COINS_INVALID_COIN_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_KEY_UNKNOWN"] = 1005] = "EXCHANGE_GENERIC_DENOMINATION_KEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_SIGNATURE_INVALID"] = 1006] = "EXCHANGE_DENOMINATION_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KEYS_MISSING"] = 1007] = "EXCHANGE_GENERIC_KEYS_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_VALIDITY_IN_FUTURE"] = 1008] = "EXCHANGE_GENERIC_DENOMINATION_VALIDITY_IN_FUTURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_EXPIRED"] = 1009] = "EXCHANGE_GENERIC_DENOMINATION_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_REVOKED"] = 1010] = "EXCHANGE_GENERIC_DENOMINATION_REVOKED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_SECMOD_TIMEOUT"] = 1011] = "EXCHANGE_GENERIC_SECMOD_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_INSUFFICIENT_FUNDS"] = 1012] = "EXCHANGE_GENERIC_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_HISTORY_COMPUTATION_FAILED"] = 1013] = "EXCHANGE_GENERIC_COIN_HISTORY_COMPUTATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_HISTORY_DB_ERROR_INSUFFICIENT_FUNDS"] = 1014] = "EXCHANGE_GENERIC_HISTORY_DB_ERROR_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_CONFLICTING_AGE_HASH"] = 1015] = "EXCHANGE_GENERIC_COIN_CONFLICTING_AGE_HASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_INVALID_DENOMINATION_CIPHER_FOR_OPERATION"] = 1016] = "EXCHANGE_GENERIC_INVALID_DENOMINATION_CIPHER_FOR_OPERATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_CIPHER_MISMATCH"] = 1017] = "EXCHANGE_GENERIC_CIPHER_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_NEW_DENOMS_ARRAY_SIZE_EXCESSIVE"] = 1018] = "EXCHANGE_GENERIC_NEW_DENOMS_ARRAY_SIZE_EXCESSIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_UNKNOWN"] = 1019] = "EXCHANGE_GENERIC_COIN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_CLOCK_SKEW"] = 1020] = "EXCHANGE_GENERIC_CLOCK_SKEW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AMOUNT_EXCEEDS_DENOMINATION_VALUE"] = 1021] = "EXCHANGE_GENERIC_AMOUNT_EXCEEDS_DENOMINATION_VALUE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_GLOBAL_FEES_MISSING"] = 1022] = "EXCHANGE_GENERIC_GLOBAL_FEES_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_WIRE_FEES_MISSING"] = 1023] = "EXCHANGE_GENERIC_WIRE_FEES_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_PUB_MALFORMED"] = 1024] = "EXCHANGE_GENERIC_PURSE_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_UNKNOWN"] = 1025] = "EXCHANGE_GENERIC_PURSE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_EXPIRED"] = 1026] = "EXCHANGE_GENERIC_PURSE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_RESERVE_UNKNOWN"] = 1027] = "EXCHANGE_GENERIC_RESERVE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_REQUIRED"] = 1028] = "EXCHANGE_GENERIC_KYC_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_CONFLICTING_ATTEST_VS_AGE_COMMITMENT"] = 1029] = "EXCHANGE_PURSE_DEPOSIT_COIN_CONFLICTING_ATTEST_VS_AGE_COMMITMENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_AGE_ATTESTATION_FAILURE"] = 1030] = "EXCHANGE_PURSE_DEPOSIT_COIN_AGE_ATTESTATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_DELETED"] = 1031] = "EXCHANGE_GENERIC_PURSE_DELETED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_PUB_MALFORMED"] = 1032] = "EXCHANGE_GENERIC_AML_OFFICER_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_GET_SIGNATURE_INVALID"] = 1033] = "EXCHANGE_GENERIC_AML_OFFICER_GET_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_ACCESS_DENIED"] = 1034] = "EXCHANGE_GENERIC_AML_OFFICER_ACCESS_DENIED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_PENDING"] = 1035] = "EXCHANGE_GENERIC_AML_PENDING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_FROZEN"] = 1036] = "EXCHANGE_GENERIC_AML_FROZEN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_CONVERTER_FAILED"] = 1037] = "EXCHANGE_GENERIC_KYC_CONVERTER_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_FAILED"] = 1038] = "EXCHANGE_GENERIC_KYC_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_FALLBACK_FAILED"] = 1039] = "EXCHANGE_GENERIC_KYC_FALLBACK_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_FALLBACK_UNKNOWN"] = 1040] = "EXCHANGE_GENERIC_KYC_FALLBACK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_BANK_ACCOUNT_UNKNOWN"] = 1041] = "EXCHANGE_GENERIC_BANK_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_PROGRAM_RECURSION_DETECTED"] = 1042] = "EXCHANGE_GENERIC_AML_PROGRAM_RECURSION_DETECTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_SANCTION_LIST_CHECK_FAILED"] = 1043] = "EXCHANGE_GENERIC_KYC_SANCTION_LIST_CHECK_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_TYPST_TEMPLATE_FAILURE"] = 1044] = "EXCHANGE_GENERIC_TYPST_TEMPLATE_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PDFTK_FAILURE"] = 1045] = "EXCHANGE_GENERIC_PDFTK_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_TYPST_CRASH"] = 1046] = "EXCHANGE_GENERIC_TYPST_CRASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PDFTK_CRASH"] = 1047] = "EXCHANGE_GENERIC_PDFTK_CRASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_NO_TYPST_OR_PDFTK"] = 1048] = "EXCHANGE_GENERIC_NO_TYPST_OR_PDFTK";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_NOT_FOUND"] = 1100] = "EXCHANGE_DEPOSITS_GET_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_H_WIRE"] = 1101] = "EXCHANGE_DEPOSITS_GET_INVALID_H_WIRE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_MERCHANT_PUB"] = 1102] = "EXCHANGE_DEPOSITS_GET_INVALID_MERCHANT_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_H_CONTRACT_TERMS"] = 1103] = "EXCHANGE_DEPOSITS_GET_INVALID_H_CONTRACT_TERMS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_COIN_PUB"] = 1104] = "EXCHANGE_DEPOSITS_GET_INVALID_COIN_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_SIGNATURE_BY_EXCHANGE"] = 1105] = "EXCHANGE_DEPOSITS_GET_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_MERCHANT_SIGNATURE_INVALID"] = 1106] = "EXCHANGE_DEPOSITS_GET_MERCHANT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_POLICY_NOT_ACCEPTED"] = 1107] = "EXCHANGE_DEPOSITS_POLICY_NOT_ACCEPTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_INSUFFICIENT_FUNDS"] = 1150] = "EXCHANGE_WITHDRAW_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_INSUFFICIENT_FUNDS"] = 1151] = "EXCHANGE_AGE_WITHDRAW_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_AMOUNT_FEE_OVERFLOW"] = 1152] = "EXCHANGE_WITHDRAW_AMOUNT_FEE_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_SIGNATURE_FAILED"] = 1153] = "EXCHANGE_WITHDRAW_SIGNATURE_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_RESERVE_SIGNATURE_INVALID"] = 1154] = "EXCHANGE_WITHDRAW_RESERVE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVE_HISTORY_ERROR_INSUFFICIENT_FUNDS"] = 1155] = "EXCHANGE_RESERVE_HISTORY_ERROR_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GET_RESERVE_HISTORY_ERROR_INSUFFICIENT_BALANCE"] = 1156] = "EXCHANGE_GET_RESERVE_HISTORY_ERROR_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_DENOMINATION_KEY_LOST"] = 1158] = "EXCHANGE_WITHDRAW_DENOMINATION_KEY_LOST";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_UNBLIND_FAILURE"] = 1159] = "EXCHANGE_WITHDRAW_UNBLIND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_NONCE_REUSE"] = 1160] = "EXCHANGE_WITHDRAW_NONCE_REUSE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_COMMITMENT_UNKNOWN"] = 1161] = "EXCHANGE_WITHDRAW_COMMITMENT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_AMOUNT_OVERFLOW"] = 1162] = "EXCHANGE_WITHDRAW_AMOUNT_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_AMOUNT_INCORRECT"] = 1163] = "EXCHANGE_AGE_WITHDRAW_AMOUNT_INCORRECT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_REVEAL_INVALID_HASH"] = 1164] = "EXCHANGE_WITHDRAW_REVEAL_INVALID_HASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_MAXIMUM_AGE_TOO_LARGE"] = 1165] = "EXCHANGE_WITHDRAW_MAXIMUM_AGE_TOO_LARGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_IDEMPOTENT_PLANCHET"] = 1175] = "EXCHANGE_WITHDRAW_IDEMPOTENT_PLANCHET";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_COIN_SIGNATURE_INVALID"] = 1205] = "EXCHANGE_DEPOSIT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_CONFLICTING_CONTRACT"] = 1206] = "EXCHANGE_DEPOSIT_CONFLICTING_CONTRACT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_NEGATIVE_VALUE_AFTER_FEE"] = 1207] = "EXCHANGE_DEPOSIT_NEGATIVE_VALUE_AFTER_FEE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_REFUND_DEADLINE_AFTER_WIRE_DEADLINE"] = 1208] = "EXCHANGE_DEPOSIT_REFUND_DEADLINE_AFTER_WIRE_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_WIRE_DEADLINE_IS_NEVER"] = 1209] = "EXCHANGE_DEPOSIT_WIRE_DEADLINE_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_JSON"] = 1210] = "EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_JSON";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_CONTRACT_HASH_CONFLICT"] = 1211] = "EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_CONTRACT_HASH_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_SIGNATURE_BY_EXCHANGE"] = 1221] = "EXCHANGE_DEPOSIT_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_FEE_ABOVE_AMOUNT"] = 1222] = "EXCHANGE_DEPOSIT_FEE_ABOVE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_EXTENSIONS_INVALID_FULFILLMENT"] = 1240] = "EXCHANGE_EXTENSIONS_INVALID_FULFILLMENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_COIN_HISTORY_BAD_SIGNATURE"] = 1251] = "EXCHANGE_COIN_HISTORY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVE_HISTORY_BAD_SIGNATURE"] = 1252] = "EXCHANGE_RESERVE_HISTORY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_FEES_EXCEED_CONTRIBUTION"] = 1302] = "EXCHANGE_MELT_FEES_EXCEED_CONTRIBUTION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_COIN_SIGNATURE_INVALID"] = 1303] = "EXCHANGE_MELT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_COIN_EXPIRED_NO_ZOMBIE"] = 1305] = "EXCHANGE_MELT_COIN_EXPIRED_NO_ZOMBIE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_INVALID_SIGNATURE_BY_EXCHANGE"] = 1306] = "EXCHANGE_MELT_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_COMMITMENT_VIOLATION"] = 1353] = "EXCHANGE_REFRESHES_REVEAL_COMMITMENT_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_SIGNING_ERROR"] = 1354] = "EXCHANGE_REFRESHES_REVEAL_SIGNING_ERROR";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_SESSION_UNKNOWN"] = 1355] = "EXCHANGE_REFRESHES_REVEAL_SESSION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_CNC_TRANSFER_ARRAY_SIZE_INVALID"] = 1356] = "EXCHANGE_REFRESHES_REVEAL_CNC_TRANSFER_ARRAY_SIZE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_NEW_DENOMS_ARRAY_SIZE_MISMATCH"] = 1358] = "EXCHANGE_REFRESHES_REVEAL_NEW_DENOMS_ARRAY_SIZE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_COST_CALCULATION_OVERFLOW"] = 1359] = "EXCHANGE_REFRESHES_REVEAL_COST_CALCULATION_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AMOUNT_INSUFFICIENT"] = 1360] = "EXCHANGE_REFRESHES_REVEAL_AMOUNT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_LINK_SIGNATURE_INVALID"] = 1361] = "EXCHANGE_REFRESHES_REVEAL_LINK_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_INVALID_RCH"] = 1362] = "EXCHANGE_REFRESHES_REVEAL_INVALID_RCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_OPERATION_INVALID"] = 1363] = "EXCHANGE_REFRESHES_REVEAL_OPERATION_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_NOT_SUPPORTED"] = 1364] = "EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_COMMITMENT_INVALID"] = 1365] = "EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_COMMITMENT_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_LINK_COIN_UNKNOWN"] = 1400] = "EXCHANGE_LINK_COIN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WTID_MALFORMED"] = 1450] = "EXCHANGE_TRANSFERS_GET_WTID_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WTID_NOT_FOUND"] = 1451] = "EXCHANGE_TRANSFERS_GET_WTID_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WIRE_FEE_NOT_FOUND"] = 1452] = "EXCHANGE_TRANSFERS_GET_WIRE_FEE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WIRE_FEE_INCONSISTENT"] = 1453] = "EXCHANGE_TRANSFERS_GET_WIRE_FEE_INCONSISTENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSES_INVALID_WAIT_TARGET"] = 1475] = "EXCHANGE_PURSES_INVALID_WAIT_TARGET";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSES_GET_INVALID_SIGNATURE_BY_EXCHANGE"] = 1476] = "EXCHANGE_PURSES_GET_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_COIN_NOT_FOUND"] = 1500] = "EXCHANGE_REFUND_COIN_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_CONFLICT_DEPOSIT_INSUFFICIENT"] = 1501] = "EXCHANGE_REFUND_CONFLICT_DEPOSIT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_DEPOSIT_NOT_FOUND"] = 1502] = "EXCHANGE_REFUND_DEPOSIT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_ALREADY_PAID"] = 1503] = "EXCHANGE_REFUND_MERCHANT_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_FEE_TOO_LOW"] = 1504] = "EXCHANGE_REFUND_FEE_TOO_LOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_FEE_ABOVE_AMOUNT"] = 1505] = "EXCHANGE_REFUND_FEE_ABOVE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_SIGNATURE_INVALID"] = 1506] = "EXCHANGE_REFUND_MERCHANT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_SIGNING_FAILED"] = 1507] = "EXCHANGE_REFUND_MERCHANT_SIGNING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INVALID_SIGNATURE_BY_EXCHANGE"] = 1508] = "EXCHANGE_REFUND_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INVALID_FAILURE_PROOF_BY_EXCHANGE"] = 1509] = "EXCHANGE_REFUND_INVALID_FAILURE_PROOF_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INCONSISTENT_AMOUNT"] = 1510] = "EXCHANGE_REFUND_INCONSISTENT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_SIGNATURE_INVALID"] = 1550] = "EXCHANGE_RECOUP_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_WITHDRAW_NOT_FOUND"] = 1551] = "EXCHANGE_RECOUP_WITHDRAW_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_COIN_BALANCE_ZERO"] = 1552] = "EXCHANGE_RECOUP_COIN_BALANCE_ZERO";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_BLINDING_FAILED"] = 1553] = "EXCHANGE_RECOUP_BLINDING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_COIN_BALANCE_NEGATIVE"] = 1554] = "EXCHANGE_RECOUP_COIN_BALANCE_NEGATIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_NOT_ELIGIBLE"] = 1555] = "EXCHANGE_RECOUP_NOT_ELIGIBLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_SIGNATURE_INVALID"] = 1575] = "EXCHANGE_RECOUP_REFRESH_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_MELT_NOT_FOUND"] = 1576] = "EXCHANGE_RECOUP_REFRESH_MELT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_BLINDING_FAILED"] = 1578] = "EXCHANGE_RECOUP_REFRESH_BLINDING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_NOT_ELIGIBLE"] = 1580] = "EXCHANGE_RECOUP_REFRESH_NOT_ELIGIBLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KEYS_TIMETRAVEL_FORBIDDEN"] = 1600] = "EXCHANGE_KEYS_TIMETRAVEL_FORBIDDEN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_SIGNATURE_INVALID"] = 1650] = "EXCHANGE_WIRE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_NO_ACCOUNTS_CONFIGURED"] = 1651] = "EXCHANGE_WIRE_NO_ACCOUNTS_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_INVALID_PAYTO_CONFIGURED"] = 1652] = "EXCHANGE_WIRE_INVALID_PAYTO_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_FEES_NOT_CONFIGURED"] = 1653] = "EXCHANGE_WIRE_FEES_NOT_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_CREATE_CONFLICTING_META_DATA"] = 1675] = "EXCHANGE_RESERVES_PURSE_CREATE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_MERGE_CONFLICTING_META_DATA"] = 1676] = "EXCHANGE_RESERVES_PURSE_MERGE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_CREATE_INSUFFICIENT_FUNDS"] = 1677] = "EXCHANGE_RESERVES_PURSE_CREATE_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_FEE_TOO_LOW"] = 1678] = "EXCHANGE_RESERVES_PURSE_FEE_TOO_LOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DELETE_ALREADY_DECIDED"] = 1679] = "EXCHANGE_PURSE_DELETE_ALREADY_DECIDED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DELETE_SIGNATURE_INVALID"] = 1680] = "EXCHANGE_PURSE_DELETE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_AGE_RESTRICTION_REQUIRED"] = 1681] = "EXCHANGE_RESERVES_AGE_RESTRICTION_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_UNAVAILABLE"] = 1700] = "EXCHANGE_DENOMINATION_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_BUG"] = 1701] = "EXCHANGE_DENOMINATION_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_TOO_EARLY"] = 1702] = "EXCHANGE_DENOMINATION_HELPER_TOO_EARLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_EXCHANGE_SIGNATURE_INVALID"] = 1725] = "EXCHANGE_PURSE_DEPOSIT_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_UNAVAILABLE"] = 1750] = "EXCHANGE_SIGNKEY_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_BUG"] = 1751] = "EXCHANGE_SIGNKEY_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_TOO_EARLY"] = 1752] = "EXCHANGE_SIGNKEY_HELPER_TOO_EARLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_OFFLINE_MISSING"] = 1753] = "EXCHANGE_SIGNKEY_HELPER_OFFLINE_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_EXPIRATION_BEFORE_NOW"] = 1775] = "EXCHANGE_RESERVES_PURSE_EXPIRATION_BEFORE_NOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_EXPIRATION_IS_NEVER"] = 1776] = "EXCHANGE_RESERVES_PURSE_EXPIRATION_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_MERGE_SIGNATURE_INVALID"] = 1777] = "EXCHANGE_RESERVES_PURSE_MERGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_RESERVE_MERGE_SIGNATURE_INVALID"] = 1778] = "EXCHANGE_RESERVES_RESERVE_MERGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_OPEN_BAD_SIGNATURE"] = 1785] = "EXCHANGE_RESERVES_OPEN_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_CLOSE_BAD_SIGNATURE"] = 1786] = "EXCHANGE_RESERVES_CLOSE_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_ATTEST_BAD_SIGNATURE"] = 1787] = "EXCHANGE_RESERVES_ATTEST_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_CLOSE_NO_TARGET_ACCOUNT"] = 1788] = "EXCHANGE_RESERVES_CLOSE_NO_TARGET_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_OPEN_INSUFFICIENT_FUNDS"] = 1789] = "EXCHANGE_RESERVES_OPEN_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_NOT_FOUND"] = 1800] = "EXCHANGE_MANAGEMENT_AUDITOR_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_MORE_RECENT_PRESENT"] = 1801] = "EXCHANGE_MANAGEMENT_AUDITOR_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_ADD_SIGNATURE_INVALID"] = 1802] = "EXCHANGE_MANAGEMENT_AUDITOR_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_DEL_SIGNATURE_INVALID"] = 1803] = "EXCHANGE_MANAGEMENT_AUDITOR_DEL_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_DENOMINATION_REVOKE_SIGNATURE_INVALID"] = 1804] = "EXCHANGE_MANAGEMENT_DENOMINATION_REVOKE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_SIGNKEY_REVOKE_SIGNATURE_INVALID"] = 1805] = "EXCHANGE_MANAGEMENT_SIGNKEY_REVOKE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_MORE_RECENT_PRESENT"] = 1806] = "EXCHANGE_MANAGEMENT_WIRE_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_UNKNOWN"] = 1807] = "EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_DETAILS_SIGNATURE_INVALID"] = 1808] = "EXCHANGE_MANAGEMENT_WIRE_DETAILS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_ADD_SIGNATURE_INVALID"] = 1809] = "EXCHANGE_MANAGEMENT_WIRE_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_DEL_SIGNATURE_INVALID"] = 1810] = "EXCHANGE_MANAGEMENT_WIRE_DEL_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_NOT_FOUND"] = 1811] = "EXCHANGE_MANAGEMENT_WIRE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_FEE_SIGNATURE_INVALID"] = 1812] = "EXCHANGE_MANAGEMENT_WIRE_FEE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_FEE_MISMATCH"] = 1813] = "EXCHANGE_MANAGEMENT_WIRE_FEE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_DENOMKEY_ADD_SIGNATURE_INVALID"] = 1814] = "EXCHANGE_MANAGEMENT_KEYS_DENOMKEY_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_ADD_SIGNATURE_INVALID"] = 1815] = "EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_GLOBAL_FEE_MISMATCH"] = 1816] = "EXCHANGE_MANAGEMENT_GLOBAL_FEE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_GLOBAL_FEE_SIGNATURE_INVALID"] = 1817] = "EXCHANGE_MANAGEMENT_GLOBAL_FEE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_DRAIN_PROFITS_SIGNATURE_INVALID"] = 1818] = "EXCHANGE_MANAGEMENT_DRAIN_PROFITS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_ADD_SIGNATURE_INVALID"] = 1825] = "EXCHANGE_AML_DECISION_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_INVALID_OFFICER"] = 1826] = "EXCHANGE_AML_DECISION_INVALID_OFFICER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_MORE_RECENT_PRESENT"] = 1827] = "EXCHANGE_AML_DECISION_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_UNKNOWN_CHECK"] = 1828] = "EXCHANGE_AML_DECISION_UNKNOWN_CHECK";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_UPDATE_AML_OFFICER_SIGNATURE_INVALID"] = 1830] = "EXCHANGE_MANAGEMENT_UPDATE_AML_OFFICER_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AML_OFFICERS_MORE_RECENT_PRESENT"] = 1831] = "EXCHANGE_MANAGEMENT_AML_OFFICERS_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_CONFLICTING_DENOMINATION_META_DATA"] = 1832] = "EXCHANGE_MANAGEMENT_CONFLICTING_DENOMINATION_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_CONFLICTING_SIGNKEY_META_DATA"] = 1833] = "EXCHANGE_MANAGEMENT_CONFLICTING_SIGNKEY_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA"] = 1850] = "EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_CONFLICTING_CONTRACT_STORED"] = 1851] = "EXCHANGE_PURSE_CREATE_CONFLICTING_CONTRACT_STORED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_COIN_SIGNATURE_INVALID"] = 1852] = "EXCHANGE_PURSE_CREATE_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXPIRATION_BEFORE_NOW"] = 1853] = "EXCHANGE_PURSE_CREATE_EXPIRATION_BEFORE_NOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXPIRATION_IS_NEVER"] = 1854] = "EXCHANGE_PURSE_CREATE_EXPIRATION_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_SIGNATURE_INVALID"] = 1855] = "EXCHANGE_PURSE_CREATE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_ECONTRACT_SIGNATURE_INVALID"] = 1856] = "EXCHANGE_PURSE_ECONTRACT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXCHANGE_SIGNATURE_INVALID"] = 1857] = "EXCHANGE_PURSE_CREATE_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA"] = 1858] = "EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA"] = 1859] = "EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CREATE_PURSE_NEGATIVE_VALUE_AFTER_FEE"] = 1860] = "EXCHANGE_CREATE_PURSE_NEGATIVE_VALUE_AFTER_FEE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_INVALID_MERGE_SIGNATURE"] = 1876] = "EXCHANGE_PURSE_MERGE_INVALID_MERGE_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_INVALID_RESERVE_SIGNATURE"] = 1877] = "EXCHANGE_PURSE_MERGE_INVALID_RESERVE_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_NOT_FULL"] = 1878] = "EXCHANGE_PURSE_NOT_FULL";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_EXCHANGE_SIGNATURE_INVALID"] = 1879] = "EXCHANGE_PURSE_MERGE_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MERGE_PURSE_PARTNER_UNKNOWN"] = 1880] = "EXCHANGE_MERGE_PURSE_PARTNER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_ADD_PARTNER_SIGNATURE_INVALID"] = 1890] = "EXCHANGE_MANAGEMENT_ADD_PARTNER_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_ADD_PARTNER_DATA_CONFLICT"] = 1891] = "EXCHANGE_MANAGEMENT_ADD_PARTNER_DATA_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_SIGNATURE_INVALID"] = 1900] = "EXCHANGE_AUDITORS_AUDITOR_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_UNKNOWN"] = 1901] = "EXCHANGE_AUDITORS_AUDITOR_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_INACTIVE"] = 1902] = "EXCHANGE_AUDITORS_AUDITOR_INACTIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_AML_PROGRAM_TIMEOUT"] = 1918] = "EXCHANGE_KYC_GENERIC_AML_PROGRAM_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_INFO_AUTHORIZATION_FAILED"] = 1919] = "EXCHANGE_KYC_INFO_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_RECURSIVE_RULE_DETECTED"] = 1920] = "EXCHANGE_KYC_RECURSIVE_RULE_DETECTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_AML_FORM_INCOMPLETE"] = 1921] = "EXCHANGE_KYC_AML_FORM_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_AML_PROGRAM_GONE"] = 1922] = "EXCHANGE_KYC_GENERIC_AML_PROGRAM_GONE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_NOT_A_FORM"] = 1923] = "EXCHANGE_KYC_NOT_A_FORM";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_CHECK_GONE"] = 1924] = "EXCHANGE_KYC_GENERIC_CHECK_GONE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_WALLET_SIGNATURE_INVALID"] = 1925] = "EXCHANGE_KYC_WALLET_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_INVALID_RESPONSE"] = 1926] = "EXCHANGE_KYC_PROOF_BACKEND_INVALID_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_ERROR"] = 1927] = "EXCHANGE_KYC_PROOF_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_AUTHORIZATION_FAILED"] = 1928] = "EXCHANGE_KYC_PROOF_BACKEND_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_REQUEST_UNKNOWN"] = 1929] = "EXCHANGE_KYC_PROOF_REQUEST_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_CHECK_AUTHORIZATION_FAILED"] = 1930] = "EXCHANGE_KYC_CHECK_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_UNKNOWN"] = 1931] = "EXCHANGE_KYC_GENERIC_LOGIC_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_GONE"] = 1932] = "EXCHANGE_KYC_GENERIC_LOGIC_GONE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_BUG"] = 1933] = "EXCHANGE_KYC_GENERIC_LOGIC_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_ACCESS_REFUSED"] = 1934] = "EXCHANGE_KYC_GENERIC_PROVIDER_ACCESS_REFUSED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_TIMEOUT"] = 1935] = "EXCHANGE_KYC_GENERIC_PROVIDER_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_UNEXPECTED_REPLY"] = 1936] = "EXCHANGE_KYC_GENERIC_PROVIDER_UNEXPECTED_REPLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_RATE_LIMIT_EXCEEDED"] = 1937] = "EXCHANGE_KYC_GENERIC_PROVIDER_RATE_LIMIT_EXCEEDED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_WEBHOOK_UNAUTHORIZED"] = 1938] = "EXCHANGE_KYC_WEBHOOK_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_CHECK_REQUEST_UNKNOWN"] = 1939] = "EXCHANGE_KYC_CHECK_REQUEST_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_CHECK_AUTHORIZATION_KEY_UNKNOWN"] = 1940] = "EXCHANGE_KYC_CHECK_AUTHORIZATION_KEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_FORM_ALREADY_UPLOADED"] = 1941] = "EXCHANGE_KYC_FORM_ALREADY_UPLOADED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_MEASURES_MALFORMED"] = 1942] = "EXCHANGE_KYC_MEASURES_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_MEASURE_INDEX_INVALID"] = 1943] = "EXCHANGE_KYC_MEASURE_INDEX_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_INVALID_LOGIC_TO_CHECK"] = 1944] = "EXCHANGE_KYC_INVALID_LOGIC_TO_CHECK";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_AML_PROGRAM_FAILURE"] = 1945] = "EXCHANGE_KYC_AML_PROGRAM_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_AML_PROGRAM_MALFORMED_RESULT"] = 1946] = "EXCHANGE_KYC_AML_PROGRAM_MALFORMED_RESULT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_REPLY"] = 1947] = "EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_REPLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_CONTEXT"] = 1948] = "EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_CONTEXT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_AML_LOGIC_BUG"] = 1949] = "EXCHANGE_KYC_GENERIC_AML_LOGIC_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_UNKNOWN"] = 1950] = "EXCHANGE_CONTRACTS_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_INVALID_CONTRACT_PUB"] = 1951] = "EXCHANGE_CONTRACTS_INVALID_CONTRACT_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_DECRYPTION_FAILED"] = 1952] = "EXCHANGE_CONTRACTS_DECRYPTION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_SIGNATURE_INVALID"] = 1953] = "EXCHANGE_CONTRACTS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_DECODING_FAILED"] = 1954] = "EXCHANGE_CONTRACTS_DECODING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_SIGNATURE_INVALID"] = 1975] = "EXCHANGE_PURSE_DEPOSIT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_DECIDED_ALREADY"] = 1976] = "EXCHANGE_PURSE_DEPOSIT_DECIDED_ALREADY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_INFO_BUSY"] = 1977] = "EXCHANGE_KYC_INFO_BUSY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TOTP_KEY_INVALID"] = 1980] = "EXCHANGE_TOTP_KEY_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_INSTANCE_UNKNOWN"] = 2e3] = "MERCHANT_GENERIC_INSTANCE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_HOLE_IN_WIRE_FEE_STRUCTURE"] = 2001] = "MERCHANT_GENERIC_HOLE_IN_WIRE_FEE_STRUCTURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_WIRE_REQUEST_FAILED"] = 2002] = "MERCHANT_GENERIC_EXCHANGE_WIRE_REQUEST_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CATEGORY_UNKNOWN"] = 2003] = "MERCHANT_GENERIC_CATEGORY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_UNIT_UNKNOWN"] = 2004] = "MERCHANT_GENERIC_UNIT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_ORDER_UNKNOWN"] = 2005] = "MERCHANT_GENERIC_ORDER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_PRODUCT_UNKNOWN"] = 2006] = "MERCHANT_GENERIC_PRODUCT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_REWARD_ID_UNKNOWN"] = 2007] = "MERCHANT_GENERIC_REWARD_ID_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_DB_CONTRACT_CONTENT_INVALID"] = 2008] = "MERCHANT_GENERIC_DB_CONTRACT_CONTENT_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CONTRACT_HASH_DOES_NOT_MATCH_ORDER"] = 2009] = "MERCHANT_GENERIC_CONTRACT_HASH_DOES_NOT_MATCH_ORDER";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_KEYS_FAILURE"] = 2010] = "MERCHANT_GENERIC_EXCHANGE_KEYS_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_TIMEOUT"] = 2011] = "MERCHANT_GENERIC_EXCHANGE_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_CONNECT_FAILURE"] = 2012] = "MERCHANT_GENERIC_EXCHANGE_CONNECT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_REPLY_MALFORMED"] = 2013] = "MERCHANT_GENERIC_EXCHANGE_REPLY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_UNEXPECTED_STATUS"] = 2014] = "MERCHANT_GENERIC_EXCHANGE_UNEXPECTED_STATUS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_UNAUTHORIZED"] = 2015] = "MERCHANT_GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_INSTANCE_DELETED"] = 2016] = "MERCHANT_GENERIC_INSTANCE_DELETED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TRANSFER_UNKNOWN"] = 2017] = "MERCHANT_GENERIC_TRANSFER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TEMPLATE_UNKNOWN"] = 2018] = "MERCHANT_GENERIC_TEMPLATE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_WEBHOOK_UNKNOWN"] = 2019] = "MERCHANT_GENERIC_WEBHOOK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_PENDING_WEBHOOK_UNKNOWN"] = 2020] = "MERCHANT_GENERIC_PENDING_WEBHOOK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_OTP_DEVICE_UNKNOWN"] = 2021] = "MERCHANT_GENERIC_OTP_DEVICE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_ACCOUNT_UNKNOWN"] = 2022] = "MERCHANT_GENERIC_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_H_WIRE_MALFORMED"] = 2023] = "MERCHANT_GENERIC_H_WIRE_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CURRENCY_MISMATCH"] = 2024] = "MERCHANT_GENERIC_CURRENCY_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_UNTRUSTED"] = 2025] = "MERCHANT_GENERIC_EXCHANGE_UNTRUSTED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TOKEN_FAMILY_UNKNOWN"] = 2026] = "MERCHANT_GENERIC_TOKEN_FAMILY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TOKEN_KEY_UNKNOWN"] = 2027] = "MERCHANT_GENERIC_TOKEN_KEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_DONAU_NOT_CONFIGURED"] = 2028] = "MERCHANT_GENERIC_DONAU_NOT_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_SIGN_PUB_UNKNOWN"] = 2029] = "MERCHANT_EXCHANGE_SIGN_PUB_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_FEATURE_NOT_AVAILABLE"] = 2030] = "MERCHANT_GENERIC_FEATURE_NOT_AVAILABLE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_MFA_MISSING"] = 2031] = "MERCHANT_GENERIC_MFA_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_DONAU_INVALID_RESPONSE"] = 2032] = "MERCHANT_GENERIC_DONAU_INVALID_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_UNIT_BUILTIN"] = 2033] = "MERCHANT_GENERIC_UNIT_BUILTIN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_EXCHANGE_TRACKING_FAILURE"] = 2100] = "MERCHANT_GET_ORDERS_EXCHANGE_TRACKING_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_EXCHANGE_REQUEST_FAILURE"] = 2103] = "MERCHANT_GET_ORDERS_ID_EXCHANGE_REQUEST_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_EXCHANGE_LOOKUP_START_FAILURE"] = 2104] = "MERCHANT_GET_ORDERS_ID_EXCHANGE_LOOKUP_START_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_TOKEN"] = 2105] = "MERCHANT_GET_ORDERS_ID_INVALID_TOKEN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_HASH"] = 2106] = "MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_HASH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_VERSION"] = 2107] = "MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_VERSION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_CHALLENGE_FAILED"] = 2125] = "MERCHANT_TAN_CHALLENGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_CHALLENGE_UNKNOWN"] = 2126] = "MERCHANT_TAN_CHALLENGE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_TOO_MANY_ATTEMPTS"] = 2127] = "MERCHANT_TAN_TOO_MANY_ATTEMPTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_MFA_HELPER_EXEC_FAILED"] = 2128] = "MERCHANT_TAN_MFA_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_CHALLENGE_SOLVED"] = 2129] = "MERCHANT_TAN_CHALLENGE_SOLVED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_TOO_EARLY"] = 2130] = "MERCHANT_TAN_TOO_EARLY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_MFA_FORBIDDEN"] = 2131] = "MERCHANT_MFA_FORBIDDEN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_FUNDS"] = 2150] = "MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_NOT_FOUND"] = 2151] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_AUDITOR_FAILURE"] = 2152] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_AUDITOR_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AMOUNT_OVERFLOW"] = 2153] = "MERCHANT_POST_ORDERS_ID_PAY_AMOUNT_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_FEES_EXCEED_PAYMENT"] = 2154] = "MERCHANT_POST_ORDERS_ID_PAY_FEES_EXCEED_PAYMENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_DUE_TO_FEES"] = 2155] = "MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_DUE_TO_FEES";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_PAYMENT_INSUFFICIENT"] = 2156] = "MERCHANT_POST_ORDERS_ID_PAY_PAYMENT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_COIN_SIGNATURE_INVALID"] = 2157] = "MERCHANT_POST_ORDERS_ID_PAY_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_LOOKUP_FAILED"] = 2158] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUND_DEADLINE_PAST_WIRE_TRANSFER_DEADLINE"] = 2159] = "MERCHANT_POST_ORDERS_ID_PAY_REFUND_DEADLINE_PAST_WIRE_TRANSFER_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_ALREADY_PAID"] = 2160] = "MERCHANT_POST_ORDERS_ID_PAY_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_OFFER_EXPIRED"] = 2161] = "MERCHANT_POST_ORDERS_ID_PAY_OFFER_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_MERCHANT_FIELD_MISSING"] = 2162] = "MERCHANT_POST_ORDERS_ID_PAY_MERCHANT_FIELD_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_WIRE_HASH_UNKNOWN"] = 2163] = "MERCHANT_POST_ORDERS_ID_PAY_WIRE_HASH_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_DEPOSIT_EXPIRED"] = 2165] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_DEPOSIT_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_WIRE_FEE_ADDITION_FAILED"] = 2166] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_WIRE_FEE_ADDITION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUNDED"] = 2167] = "MERCHANT_POST_ORDERS_ID_PAY_REFUNDED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUNDS_EXCEED_PAYMENTS"] = 2168] = "MERCHANT_POST_ORDERS_ID_PAY_REFUNDS_EXCEED_PAYMENTS";
  TalerErrorCode2[TalerErrorCode2["DEAD_QQQ_PAY_MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE"] = 2169] = "DEAD_QQQ_PAY_MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_FAILED"] = 2170] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_MISSING"] = 2171] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_SIZE_MISMATCH"] = 2172] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_SIZE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_VERIFICATION_FAILED"] = 2173] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_VERIFICATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_HASH_MISSING"] = 2174] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_HASH_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_WIRE_METHOD_UNSUPPORTED"] = 2175] = "MERCHANT_POST_ORDERS_ID_PAY_WIRE_METHOD_UNSUPPORTED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_MISSING"] = 2176] = "MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_OUT_OF_BOUNDS"] = 2177] = "MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_OUT_OF_BOUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INPUT_TOKENS_MISMATCH"] = 2178] = "MERCHANT_POST_ORDERS_ID_PAY_INPUT_TOKENS_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ISSUE_SIG_INVALID"] = 2179] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ISSUE_SIG_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_USE_SIG_INVALID"] = 2180] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_USE_SIG_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_COUNT_MISMATCH"] = 2181] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_COUNT_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ENVELOPE_COUNT_MISMATCH"] = 2182] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ENVELOPE_COUNT_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_INVALID"] = 2183] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_TRANSACTION_LIMIT_VIOLATION"] = 2184] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_TRANSACTION_LIMIT_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DONATION_AMOUNT_MISMATCH"] = 2185] = "MERCHANT_POST_ORDERS_ID_PAY_DONATION_AMOUNT_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAID_CONTRACT_HASH_MISMATCH"] = 2200] = "MERCHANT_POST_ORDERS_ID_PAID_CONTRACT_HASH_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAID_COIN_SIGNATURE_INVALID"] = 2201] = "MERCHANT_POST_ORDERS_ID_PAID_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_TOKEN_FAMILY_CONFLICT"] = 2225] = "MERCHANT_POST_TOKEN_FAMILY_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PATCH_TOKEN_FAMILY_NOT_FOUND"] = 2226] = "MERCHANT_PATCH_TOKEN_FAMILY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_REFUND_FAILED"] = 2251] = "MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_REFUND_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_LOOKUP_FAILED"] = 2252] = "MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_NOT_FOUND"] = 2253] = "MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE"] = 2254] = "MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_HASH_MISSMATCH"] = 2255] = "MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_HASH_MISSMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_COINS_ARRAY_EMPTY"] = 2256] = "MERCHANT_POST_ORDERS_ID_ABORT_COINS_ARRAY_EMPTY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_AWAITING_KEYS"] = 2258] = "MERCHANT_EXCHANGE_TRANSFERS_AWAITING_KEYS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_AWAITING_LIST"] = 2259] = "MERCHANT_EXCHANGE_TRANSFERS_AWAITING_LIST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_FATAL_NO_EXCHANGE"] = 2260] = "MERCHANT_EXCHANGE_TRANSFERS_FATAL_NO_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_FATAL_NOT_FOUND"] = 2261] = "MERCHANT_EXCHANGE_TRANSFERS_FATAL_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_RATE_LIMITED"] = 2262] = "MERCHANT_EXCHANGE_TRANSFERS_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_TRANSIENT_FAILURE"] = 2263] = "MERCHANT_EXCHANGE_TRANSFERS_TRANSIENT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_HARD_FAILURE"] = 2264] = "MERCHANT_EXCHANGE_TRANSFERS_HARD_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_NOT_FOUND"] = 2300] = "MERCHANT_POST_ORDERS_ID_CLAIM_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_ALREADY_CLAIMED"] = 2301] = "MERCHANT_POST_ORDERS_ID_CLAIM_ALREADY_CLAIMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_CLIENT_INTERNAL_FAILURE"] = 2302] = "MERCHANT_POST_ORDERS_ID_CLAIM_CLIENT_INTERNAL_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_REFUND_SIGNATURE_FAILED"] = 2350] = "MERCHANT_POST_ORDERS_ID_REFUND_SIGNATURE_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_UNBLIND_FAILURE"] = 2400] = "MERCHANT_REWARD_PICKUP_UNBLIND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_EXCHANGE_ERROR"] = 2403] = "MERCHANT_REWARD_PICKUP_EXCHANGE_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_SUMMATION_FAILED"] = 2404] = "MERCHANT_REWARD_PICKUP_SUMMATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_HAS_EXPIRED"] = 2405] = "MERCHANT_REWARD_PICKUP_HAS_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_AMOUNT_EXCEEDS_REWARD_REMAINING"] = 2406] = "MERCHANT_REWARD_PICKUP_AMOUNT_EXCEEDS_REWARD_REMAINING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_DENOMINATION_UNKNOWN"] = 2407] = "MERCHANT_REWARD_PICKUP_DENOMINATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_INSTANCE_CONFIGURATION_LACKS_WIRE"] = 2500] = "MERCHANT_PRIVATE_POST_ORDERS_INSTANCE_CONFIGURATION_LACKS_WIRE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_LOCALTIME"] = 2501] = "MERCHANT_PRIVATE_POST_ORDERS_NO_LOCALTIME";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_PROPOSAL_PARSE_ERROR"] = 2502] = "MERCHANT_PRIVATE_POST_ORDERS_PROPOSAL_PARSE_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ALREADY_EXISTS"] = 2503] = "MERCHANT_PRIVATE_POST_ORDERS_ALREADY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_REFUND_AFTER_WIRE_DEADLINE"] = 2504] = "MERCHANT_PRIVATE_POST_ORDERS_REFUND_AFTER_WIRE_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_DELIVERY_DATE_IN_PAST"] = 2505] = "MERCHANT_PRIVATE_POST_ORDERS_DELIVERY_DATE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_WIRE_DEADLINE_IS_NEVER"] = 2506] = "MERCHANT_PRIVATE_POST_ORDERS_WIRE_DEADLINE_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_PAY_DEADLINE_IN_PAST"] = 2507] = "MERCHANT_PRIVATE_POST_ORDERS_PAY_DEADLINE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_REFUND_DEADLINE_IN_PAST"] = 2508] = "MERCHANT_PRIVATE_POST_ORDERS_REFUND_DEADLINE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGES_FOR_WIRE_METHOD"] = 2509] = "MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGES_FOR_WIRE_METHOD";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_SYNTAX_INCORRECT"] = 2510] = "MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_SYNTAX_INCORRECT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_NOT_FORGETTABLE"] = 2511] = "MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_NOT_FORGETTABLE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_REFUND_EXCHANGE_TRANSACTION_LIMIT_VIOLATION"] = 2512] = "MERCHANT_POST_ORDERS_ID_REFUND_EXCHANGE_TRANSACTION_LIMIT_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_AMOUNT_EXCEEDS_LEGAL_LIMITS"] = 2513] = "MERCHANT_PRIVATE_POST_ORDERS_AMOUNT_EXCEEDS_LEGAL_LIMITS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGE_FOR_CURRENCY"] = 2514] = "MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGE_FOR_CURRENCY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_ORDERS_AWAITING_PAYMENT"] = 2520] = "MERCHANT_PRIVATE_DELETE_ORDERS_AWAITING_PAYMENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_ORDERS_ALREADY_PAID"] = 2521] = "MERCHANT_PRIVATE_DELETE_ORDERS_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_INCONSISTENT_AMOUNT"] = 2530] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_INCONSISTENT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_ORDER_UNPAID"] = 2531] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_ORDER_UNPAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_NOT_ALLOWED_BY_CONTRACT"] = 2532] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_NOT_ALLOWED_BY_CONTRACT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_SLUG_UNKNOWN"] = 2533] = "MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_SLUG_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_NOT_VALID"] = 2534] = "MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_NOT_VALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_EXCHANGE_UNKNOWN"] = 2550] = "MERCHANT_PRIVATE_POST_TRANSFERS_EXCHANGE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_REQUEST_ERROR"] = 2551] = "MERCHANT_PRIVATE_POST_TRANSFERS_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_TRANSFERS"] = 2552] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_TRANSFERS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_REPORTS"] = 2553] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_REPORTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_BAD_WIRE_FEE"] = 2554] = "MERCHANT_PRIVATE_POST_TRANSFERS_BAD_WIRE_FEE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_ACCOUNT_NOT_FOUND"] = 2555] = "MERCHANT_PRIVATE_POST_TRANSFERS_ACCOUNT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_TRANSFERS_ALREADY_CONFIRMED"] = 2556] = "MERCHANT_PRIVATE_DELETE_TRANSFERS_ALREADY_CONFIRMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_SUBMISSION"] = 2557] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_SUBMISSION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_TARGET_ACCOUNT_UNKNOWN"] = 2558] = "MERCHANT_EXCHANGE_TRANSFERS_TARGET_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_CONFLICTING_TRANSFERS"] = 2563] = "MERCHANT_EXCHANGE_TRANSFERS_CONFLICTING_TRANSFERS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_ALREADY_EXISTS"] = 2600] = "MERCHANT_PRIVATE_POST_INSTANCES_ALREADY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_BAD_AUTH"] = 2601] = "MERCHANT_PRIVATE_POST_INSTANCES_BAD_AUTH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCE_AUTH_BAD_AUTH"] = 2602] = "MERCHANT_PRIVATE_POST_INSTANCE_AUTH_BAD_AUTH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_PURGE_REQUIRED"] = 2603] = "MERCHANT_PRIVATE_POST_INSTANCES_PURGE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_INSTANCES_PURGE_REQUIRED"] = 2625] = "MERCHANT_PRIVATE_PATCH_INSTANCES_PURGE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_ACCOUNT_DELETE_UNKNOWN_ACCOUNT"] = 2626] = "MERCHANT_PRIVATE_ACCOUNT_DELETE_UNKNOWN_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_ACCOUNT_EXISTS"] = 2627] = "MERCHANT_PRIVATE_ACCOUNT_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PRODUCTS_CONFLICT_PRODUCT_EXISTS"] = 2650] = "MERCHANT_PRIVATE_POST_PRODUCTS_CONFLICT_PRODUCT_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_CATEGORIES_CONFLICT_CATEGORY_EXISTS"] = 2651] = "MERCHANT_PRIVATE_POST_CATEGORIES_CONFLICT_CATEGORY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_REDUCED"] = 2660] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_EXCEEDS_STOCKS"] = 2661] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_EXCEEDS_STOCKS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_STOCKED_REDUCED"] = 2662] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_STOCKED_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_SOLD_REDUCED"] = 2663] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_SOLD_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PRODUCTS_LOCK_INSUFFICIENT_STOCKS"] = 2670] = "MERCHANT_PRIVATE_POST_PRODUCTS_LOCK_INSUFFICIENT_STOCKS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_PRODUCTS_CONFLICTING_LOCK"] = 2680] = "MERCHANT_PRIVATE_DELETE_PRODUCTS_CONFLICTING_LOCK";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_RESERVES_UNSUPPORTED_WIRE_METHOD"] = 2700] = "MERCHANT_PRIVATE_POST_RESERVES_UNSUPPORTED_WIRE_METHOD";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_RESERVES_REWARDS_NOT_ALLOWED"] = 2701] = "MERCHANT_PRIVATE_POST_RESERVES_REWARDS_NOT_ALLOWED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_RESERVES_NO_SUCH_RESERVE"] = 2710] = "MERCHANT_PRIVATE_DELETE_RESERVES_NO_SUCH_RESERVE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_EXPIRED"] = 2750] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_UNKNOWN"] = 2751] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_INSUFFICIENT_FUNDS"] = 2752] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_NOT_FOUND"] = 2753] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_GET_ORDERS_ID_AMOUNT_ARITHMETIC_FAILURE"] = 2800] = "MERCHANT_PRIVATE_GET_ORDERS_ID_AMOUNT_ARITHMETIC_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TEMPLATES_CONFLICT_TEMPLATE_EXISTS"] = 2850] = "MERCHANT_PRIVATE_POST_TEMPLATES_CONFLICT_TEMPLATE_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_OTP_DEVICES_CONFLICT_OTP_DEVICE_EXISTS"] = 2851] = "MERCHANT_PRIVATE_POST_OTP_DEVICES_CONFLICT_OTP_DEVICE_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_AMOUNT_CONFLICT_TEMPLATES_CONTRACT_AMOUNT"] = 2860] = "MERCHANT_POST_USING_TEMPLATES_AMOUNT_CONFLICT_TEMPLATES_CONTRACT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_SUMMARY_CONFLICT_TEMPLATES_CONTRACT_SUBJECT"] = 2861] = "MERCHANT_POST_USING_TEMPLATES_SUMMARY_CONFLICT_TEMPLATES_CONTRACT_SUBJECT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_NO_AMOUNT"] = 2862] = "MERCHANT_POST_USING_TEMPLATES_NO_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_NO_SUMMARY"] = 2863] = "MERCHANT_POST_USING_TEMPLATES_NO_SUMMARY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_WEBHOOKS_CONFLICT_WEBHOOK_EXISTS"] = 2900] = "MERCHANT_PRIVATE_POST_WEBHOOKS_CONFLICT_WEBHOOK_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PENDING_WEBHOOKS_CONFLICT_PENDING_WEBHOOK_EXISTS"] = 2910] = "MERCHANT_PRIVATE_POST_PENDING_WEBHOOKS_CONFLICT_PENDING_WEBHOOK_EXISTS";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_GENERIC_UNAUTHORIZED"] = 3001] = "AUDITOR_GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_GENERIC_METHOD_NOT_ALLOWED"] = 3002] = "AUDITOR_GENERIC_METHOD_NOT_ALLOWED";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_DEPOSIT_CONFIRMATION_SIGNATURE_INVALID"] = 3100] = "AUDITOR_DEPOSIT_CONFIRMATION_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_EXCHANGE_SIGNING_KEY_REVOKED"] = 3101] = "AUDITOR_EXCHANGE_SIGNING_KEY_REVOKED";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_RESOURCE_NOT_FOUND"] = 3102] = "AUDITOR_RESOURCE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_URI_MISSING_PATH_COMPONENT"] = 3103] = "AUDITOR_URI_MISSING_PATH_COMPONENT";
  TalerErrorCode2[TalerErrorCode2["BANK_SAME_ACCOUNT"] = 5101] = "BANK_SAME_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_UNALLOWED_DEBIT"] = 5102] = "BANK_UNALLOWED_DEBIT";
  TalerErrorCode2[TalerErrorCode2["BANK_NEGATIVE_NUMBER_AMOUNT"] = 5103] = "BANK_NEGATIVE_NUMBER_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_NUMBER_TOO_BIG"] = 5104] = "BANK_NUMBER_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_ACCOUNT"] = 5106] = "BANK_UNKNOWN_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSACTION_NOT_FOUND"] = 5107] = "BANK_TRANSACTION_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["BANK_BAD_FORMAT_AMOUNT"] = 5108] = "BANK_BAD_FORMAT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_REJECT_NO_RIGHTS"] = 5109] = "BANK_REJECT_NO_RIGHTS";
  TalerErrorCode2[TalerErrorCode2["BANK_UNMANAGED_EXCEPTION"] = 5110] = "BANK_UNMANAGED_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["BANK_SOFT_EXCEPTION"] = 5111] = "BANK_SOFT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSFER_REQUEST_UID_REUSED"] = 5112] = "BANK_TRANSFER_REQUEST_UID_REUSED";
  TalerErrorCode2[TalerErrorCode2["BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT"] = 5113] = "BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_DUPLICATE_RESERVE_PUB_SUBJECT"] = 5114] = "BANK_DUPLICATE_RESERVE_PUB_SUBJECT";
  TalerErrorCode2[TalerErrorCode2["BANK_ANCIENT_TRANSACTION_GONE"] = 5115] = "BANK_ANCIENT_TRANSACTION_GONE";
  TalerErrorCode2[TalerErrorCode2["BANK_ABORT_CONFIRM_CONFLICT"] = 5116] = "BANK_ABORT_CONFIRM_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_CONFIRM_ABORT_CONFLICT"] = 5117] = "BANK_CONFIRM_ABORT_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_CONFLICT"] = 5118] = "BANK_REGISTER_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_POST_WITHDRAWAL_OPERATION_REQUIRED"] = 5119] = "BANK_POST_WITHDRAWAL_OPERATION_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["BANK_RESERVED_USERNAME_CONFLICT"] = 5120] = "BANK_RESERVED_USERNAME_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_USERNAME_REUSE"] = 5121] = "BANK_REGISTER_USERNAME_REUSE";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_PAYTO_URI_REUSE"] = 5122] = "BANK_REGISTER_PAYTO_URI_REUSE";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_BALANCE_NOT_ZERO"] = 5123] = "BANK_ACCOUNT_BALANCE_NOT_ZERO";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_CREDITOR"] = 5124] = "BANK_UNKNOWN_CREDITOR";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_DEBTOR"] = 5125] = "BANK_UNKNOWN_DEBTOR";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_IS_EXCHANGE"] = 5126] = "BANK_ACCOUNT_IS_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_IS_NOT_EXCHANGE"] = 5127] = "BANK_ACCOUNT_IS_NOT_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_BAD_CONVERSION"] = 5128] = "BANK_BAD_CONVERSION";
  TalerErrorCode2[TalerErrorCode2["BANK_MISSING_TAN_INFO"] = 5129] = "BANK_MISSING_TAN_INFO";
  TalerErrorCode2[TalerErrorCode2["BANK_CONFIRM_INCOMPLETE"] = 5130] = "BANK_CONFIRM_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_RATE_LIMITED"] = 5131] = "BANK_TAN_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHANNEL_NOT_SUPPORTED"] = 5132] = "BANK_TAN_CHANNEL_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHANNEL_SCRIPT_FAILED"] = 5133] = "BANK_TAN_CHANNEL_SCRIPT_FAILED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHALLENGE_FAILED"] = 5134] = "BANK_TAN_CHALLENGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_LEGAL_NAME"] = 5135] = "BANK_NON_ADMIN_PATCH_LEGAL_NAME";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_DEBT_LIMIT"] = 5136] = "BANK_NON_ADMIN_PATCH_DEBT_LIMIT";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_MISSING_OLD_PASSWORD"] = 5137] = "BANK_NON_ADMIN_PATCH_MISSING_OLD_PASSWORD";
  TalerErrorCode2[TalerErrorCode2["BANK_PATCH_BAD_OLD_PASSWORD"] = 5138] = "BANK_PATCH_BAD_OLD_PASSWORD";
  TalerErrorCode2[TalerErrorCode2["BANK_PATCH_ADMIN_EXCHANGE"] = 5139] = "BANK_PATCH_ADMIN_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_CASHOUT"] = 5140] = "BANK_NON_ADMIN_PATCH_CASHOUT";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_CONTACT"] = 5141] = "BANK_NON_ADMIN_PATCH_CONTACT";
  TalerErrorCode2[TalerErrorCode2["BANK_ADMIN_CREDITOR"] = 5142] = "BANK_ADMIN_CREDITOR";
  TalerErrorCode2[TalerErrorCode2["BANK_CHALLENGE_NOT_FOUND"] = 5143] = "BANK_CHALLENGE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHALLENGE_EXPIRED"] = 5144] = "BANK_TAN_CHALLENGE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_SET_TAN_CHANNEL"] = 5145] = "BANK_NON_ADMIN_SET_TAN_CHANNEL";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_SET_MIN_CASHOUT"] = 5146] = "BANK_NON_ADMIN_SET_MIN_CASHOUT";
  TalerErrorCode2[TalerErrorCode2["BANK_CONVERSION_AMOUNT_TO_SMALL"] = 5147] = "BANK_CONVERSION_AMOUNT_TO_SMALL";
  TalerErrorCode2[TalerErrorCode2["BANK_AMOUNT_DIFFERS"] = 5148] = "BANK_AMOUNT_DIFFERS";
  TalerErrorCode2[TalerErrorCode2["BANK_AMOUNT_REQUIRED"] = 5149] = "BANK_AMOUNT_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["BANK_PASSWORD_TOO_SHORT"] = 5150] = "BANK_PASSWORD_TOO_SHORT";
  TalerErrorCode2[TalerErrorCode2["BANK_PASSWORD_TOO_LONG"] = 5151] = "BANK_PASSWORD_TOO_LONG";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_LOCKED"] = 5152] = "BANK_ACCOUNT_LOCKED";
  TalerErrorCode2[TalerErrorCode2["BANK_UPDATE_ABORT_CONFLICT"] = 5153] = "BANK_UPDATE_ABORT_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSFER_WTID_REUSED"] = 5154] = "BANK_TRANSFER_WTID_REUSED";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_SET_CONVERSION_RATE_CLASS"] = 5155] = "BANK_NON_ADMIN_SET_CONVERSION_RATE_CLASS";
  TalerErrorCode2[TalerErrorCode2["BANK_CONVERSION_RATE_CLASS_UNKNOWN"] = 5156] = "BANK_CONVERSION_RATE_CLASS_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["BANK_NAME_REUSE"] = 5157] = "BANK_NAME_REUSE";
  TalerErrorCode2[TalerErrorCode2["SYNC_ACCOUNT_UNKNOWN"] = 6100] = "SYNC_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_IF_NONE_MATCH"] = 6101] = "SYNC_BAD_IF_NONE_MATCH";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_IF_MATCH"] = 6102] = "SYNC_BAD_IF_MATCH";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_SYNC_SIGNATURE"] = 6103] = "SYNC_BAD_SYNC_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["SYNC_INVALID_SIGNATURE"] = 6104] = "SYNC_INVALID_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["SYNC_MALFORMED_CONTENT_LENGTH"] = 6105] = "SYNC_MALFORMED_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_EXCESSIVE_CONTENT_LENGTH"] = 6106] = "SYNC_EXCESSIVE_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_OUT_OF_MEMORY_ON_CONTENT_LENGTH"] = 6107] = "SYNC_OUT_OF_MEMORY_ON_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_INVALID_UPLOAD"] = 6108] = "SYNC_INVALID_UPLOAD";
  TalerErrorCode2[TalerErrorCode2["SYNC_PAYMENT_GENERIC_TIMEOUT"] = 6109] = "SYNC_PAYMENT_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["SYNC_PAYMENT_CREATE_BACKEND_ERROR"] = 6110] = "SYNC_PAYMENT_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["SYNC_PREVIOUS_BACKUP_UNKNOWN"] = 6111] = "SYNC_PREVIOUS_BACKUP_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["SYNC_MISSING_CONTENT_LENGTH"] = 6112] = "SYNC_MISSING_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_GENERIC_BACKEND_ERROR"] = 6113] = "SYNC_GENERIC_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["SYNC_GENERIC_BACKEND_TIMEOUT"] = 6114] = "SYNC_GENERIC_BACKEND_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_PROTOCOL_VERSION_INCOMPATIBLE"] = 7e3] = "WALLET_EXCHANGE_PROTOCOL_VERSION_INCOMPATIBLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_UNEXPECTED_EXCEPTION"] = 7001] = "WALLET_UNEXPECTED_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["WALLET_RECEIVED_MALFORMED_RESPONSE"] = 7002] = "WALLET_RECEIVED_MALFORMED_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["WALLET_NETWORK_ERROR"] = 7003] = "WALLET_NETWORK_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_HTTP_REQUEST_THROTTLED"] = 7004] = "WALLET_HTTP_REQUEST_THROTTLED";
  TalerErrorCode2[TalerErrorCode2["WALLET_UNEXPECTED_REQUEST_ERROR"] = 7005] = "WALLET_UNEXPECTED_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_DENOMINATIONS_INSUFFICIENT"] = 7006] = "WALLET_EXCHANGE_DENOMINATIONS_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_API_OPERATION_UNKNOWN"] = 7007] = "WALLET_CORE_API_OPERATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["WALLET_INVALID_TALER_PAY_URI"] = 7008] = "WALLET_INVALID_TALER_PAY_URI";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_COIN_SIGNATURE_INVALID"] = 7009] = "WALLET_EXCHANGE_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_NOT_AVAILABLE"] = 7011] = "WALLET_CORE_NOT_AVAILABLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_OPERATION_ABORTED_BY_BANK"] = 7012] = "WALLET_WITHDRAWAL_OPERATION_ABORTED_BY_BANK";
  TalerErrorCode2[TalerErrorCode2["WALLET_HTTP_REQUEST_GENERIC_TIMEOUT"] = 7013] = "WALLET_HTTP_REQUEST_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["WALLET_ORDER_ALREADY_CLAIMED"] = 7014] = "WALLET_ORDER_ALREADY_CLAIMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_GROUP_INCOMPLETE"] = 7015] = "WALLET_WITHDRAWAL_GROUP_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["WALLET_REWARD_COIN_SIGNATURE_INVALID"] = 7016] = "WALLET_REWARD_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_BANK_INTEGRATION_PROTOCOL_VERSION_INCOMPATIBLE"] = 7017] = "WALLET_BANK_INTEGRATION_PROTOCOL_VERSION_INCOMPATIBLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_BASE_URL_MISMATCH"] = 7018] = "WALLET_CONTRACT_TERMS_BASE_URL_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_SIGNATURE_INVALID"] = 7019] = "WALLET_CONTRACT_TERMS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_MALFORMED"] = 7020] = "WALLET_CONTRACT_TERMS_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PENDING_OPERATION_FAILED"] = 7021] = "WALLET_PENDING_OPERATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PAY_MERCHANT_SERVER_ERROR"] = 7022] = "WALLET_PAY_MERCHANT_SERVER_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_CRYPTO_WORKER_ERROR"] = 7023] = "WALLET_CRYPTO_WORKER_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_CRYPTO_WORKER_BAD_REQUEST"] = 7024] = "WALLET_CRYPTO_WORKER_BAD_REQUEST";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_KYC_REQUIRED"] = 7025] = "WALLET_WITHDRAWAL_KYC_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["WALLET_DEPOSIT_GROUP_INSUFFICIENT_BALANCE"] = 7026] = "WALLET_DEPOSIT_GROUP_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PUSH_PAYMENT_INSUFFICIENT_BALANCE"] = 7027] = "WALLET_PEER_PUSH_PAYMENT_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PULL_PAYMENT_INSUFFICIENT_BALANCE"] = 7028] = "WALLET_PEER_PULL_PAYMENT_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_REFRESH_GROUP_INCOMPLETE"] = 7029] = "WALLET_REFRESH_GROUP_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_BASE_URL_MISMATCH"] = 7030] = "WALLET_EXCHANGE_BASE_URL_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["WALLET_ORDER_ALREADY_PAID"] = 7031] = "WALLET_ORDER_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_UNAVAILABLE"] = 7032] = "WALLET_EXCHANGE_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_USED"] = 7033] = "WALLET_EXCHANGE_ENTRY_USED";
  TalerErrorCode2[TalerErrorCode2["WALLET_DB_UNAVAILABLE"] = 7034] = "WALLET_DB_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_TALER_URI_MALFORMED"] = 7035] = "WALLET_TALER_URI_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_REQUEST_CANCELLED"] = 7036] = "WALLET_CORE_REQUEST_CANCELLED";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_TOS_NOT_ACCEPTED"] = 7037] = "WALLET_EXCHANGE_TOS_NOT_ACCEPTED";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_UPDATE_CONFLICT"] = 7038] = "WALLET_EXCHANGE_ENTRY_UPDATE_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_OUTDATED"] = 7039] = "WALLET_EXCHANGE_ENTRY_OUTDATED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PAY_MERCHANT_KYC_MISSING"] = 7040] = "WALLET_PAY_MERCHANT_KYC_MISSING";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PULL_DEBIT_PURSE_GONE"] = 7041] = "WALLET_PEER_PULL_DEBIT_PURSE_GONE";
  TalerErrorCode2[TalerErrorCode2["WALLET_TRANSACTION_ABORTED_BY_USER"] = 7042] = "WALLET_TRANSACTION_ABORTED_BY_USER";
  TalerErrorCode2[TalerErrorCode2["WALLET_TRANSACTION_ABANDONED_BY_USER"] = 7043] = "WALLET_TRANSACTION_ABANDONED_BY_USER";
  TalerErrorCode2[TalerErrorCode2["WALLET_PAY_MERCHANT_ORDER_GONE"] = 7044] = "WALLET_PAY_MERCHANT_ORDER_GONE";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_NOT_FOUND"] = 7045] = "WALLET_EXCHANGE_ENTRY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["WALLET_REQUEST_TRANSACTION_STATE_UNSUPPORTED"] = 7046] = "WALLET_REQUEST_TRANSACTION_STATE_UNSUPPORTED";
  TalerErrorCode2[TalerErrorCode2["WALLET_TRANSACTION_PROTOCOL_VIOLATION"] = 7047] = "WALLET_TRANSACTION_PROTOCOL_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_API_BAD_REQUEST"] = 7048] = "WALLET_CORE_API_BAD_REQUEST";
  TalerErrorCode2[TalerErrorCode2["WALLET_MERCHANT_ORDER_NOT_FOUND"] = 7049] = "WALLET_MERCHANT_ORDER_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_BACKEND_TIMEOUT"] = 8e3] = "ANASTASIS_GENERIC_BACKEND_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_INVALID_PAYMENT_REQUEST"] = 8001] = "ANASTASIS_GENERIC_INVALID_PAYMENT_REQUEST";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_BACKEND_ERROR"] = 8002] = "ANASTASIS_GENERIC_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_MISSING_CONTENT_LENGTH"] = 8003] = "ANASTASIS_GENERIC_MISSING_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_MALFORMED_CONTENT_LENGTH"] = 8004] = "ANASTASIS_GENERIC_MALFORMED_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_ORDER_CREATE_BACKEND_ERROR"] = 8005] = "ANASTASIS_GENERIC_ORDER_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PAYMENT_CHECK_UNAUTHORIZED"] = 8006] = "ANASTASIS_GENERIC_PAYMENT_CHECK_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PAYMENT_CHECK_START_FAILED"] = 8007] = "ANASTASIS_GENERIC_PAYMENT_CHECK_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PROVIDER_UNREACHABLE"] = 8008] = "ANASTASIS_GENERIC_PROVIDER_UNREACHABLE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_PAYMENT_GENERIC_TIMEOUT"] = 8009] = "ANASTASIS_PAYMENT_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UNKNOWN"] = 8108] = "ANASTASIS_TRUTH_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_AUTHORIZATION_METHOD_NO_LONGER_SUPPORTED"] = 8109] = "ANASTASIS_TRUTH_AUTHORIZATION_METHOD_NO_LONGER_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_RESPONSE_REQUIRED"] = 8110] = "ANASTASIS_TRUTH_CHALLENGE_RESPONSE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_FAILED"] = 8111] = "ANASTASIS_TRUTH_CHALLENGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_UNKNOWN"] = 8112] = "ANASTASIS_TRUTH_CHALLENGE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_AUTHORIZATION_START_FAILED"] = 8114] = "ANASTASIS_TRUTH_AUTHORIZATION_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_KEY_SHARE_GONE"] = 8115] = "ANASTASIS_TRUTH_KEY_SHARE_GONE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_ORDER_DISAPPEARED"] = 8116] = "ANASTASIS_TRUTH_ORDER_DISAPPEARED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_BACKEND_EXCHANGE_BAD"] = 8117] = "ANASTASIS_TRUTH_BACKEND_EXCHANGE_BAD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UNEXPECTED_PAYMENT_STATUS"] = 8118] = "ANASTASIS_TRUTH_UNEXPECTED_PAYMENT_STATUS";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_PAYMENT_CREATE_BACKEND_ERROR"] = 8119] = "ANASTASIS_TRUTH_PAYMENT_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_DECRYPTION_FAILED"] = 8120] = "ANASTASIS_TRUTH_DECRYPTION_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_RATE_LIMITED"] = 8121] = "ANASTASIS_TRUTH_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_WRONG_METHOD"] = 8123] = "ANASTASIS_TRUTH_CHALLENGE_WRONG_METHOD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UPLOAD_UUID_EXISTS"] = 8150] = "ANASTASIS_TRUTH_UPLOAD_UUID_EXISTS";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UPLOAD_METHOD_NOT_SUPPORTED"] = 8151] = "ANASTASIS_TRUTH_UPLOAD_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_PHONE_INVALID"] = 8200] = "ANASTASIS_SMS_PHONE_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_HELPER_EXEC_FAILED"] = 8201] = "ANASTASIS_SMS_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_HELPER_COMMAND_FAILED"] = 8202] = "ANASTASIS_SMS_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_INVALID"] = 8210] = "ANASTASIS_EMAIL_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_HELPER_EXEC_FAILED"] = 8211] = "ANASTASIS_EMAIL_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_HELPER_COMMAND_FAILED"] = 8212] = "ANASTASIS_EMAIL_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_INVALID"] = 8220] = "ANASTASIS_POST_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_HELPER_EXEC_FAILED"] = 8221] = "ANASTASIS_POST_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_HELPER_COMMAND_FAILED"] = 8222] = "ANASTASIS_POST_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_IBAN_INVALID"] = 8230] = "ANASTASIS_IBAN_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_IBAN_MISSING_TRANSFER"] = 8231] = "ANASTASIS_IBAN_MISSING_TRANSFER";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TOTP_KEY_MISSING"] = 8240] = "ANASTASIS_TOTP_KEY_MISSING";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TOTP_KEY_INVALID"] = 8241] = "ANASTASIS_TOTP_KEY_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_IF_NONE_MATCH"] = 8301] = "ANASTASIS_POLICY_BAD_IF_NONE_MATCH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_OUT_OF_MEMORY_ON_CONTENT_LENGTH"] = 8304] = "ANASTASIS_POLICY_OUT_OF_MEMORY_ON_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_SIGNATURE"] = 8305] = "ANASTASIS_POLICY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_IF_MATCH"] = 8306] = "ANASTASIS_POLICY_BAD_IF_MATCH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_INVALID_UPLOAD"] = 8307] = "ANASTASIS_POLICY_INVALID_UPLOAD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_NOT_FOUND"] = 8350] = "ANASTASIS_POLICY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_ACTION_INVALID"] = 8400] = "ANASTASIS_REDUCER_ACTION_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_STATE_INVALID"] = 8401] = "ANASTASIS_REDUCER_STATE_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_INVALID"] = 8402] = "ANASTASIS_REDUCER_INPUT_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_AUTHENTICATION_METHOD_NOT_SUPPORTED"] = 8403] = "ANASTASIS_REDUCER_AUTHENTICATION_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_INVALID_FOR_STATE"] = 8404] = "ANASTASIS_REDUCER_INPUT_INVALID_FOR_STATE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_BACKEND_FAILURE"] = 8405] = "ANASTASIS_REDUCER_BACKEND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_RESOURCE_MALFORMED"] = 8406] = "ANASTASIS_REDUCER_RESOURCE_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_RESOURCE_MISSING"] = 8407] = "ANASTASIS_REDUCER_RESOURCE_MISSING";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_REGEX_FAILED"] = 8408] = "ANASTASIS_REDUCER_INPUT_REGEX_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_VALIDATION_FAILED"] = 8409] = "ANASTASIS_REDUCER_INPUT_VALIDATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_POLICY_LOOKUP_FAILED"] = 8410] = "ANASTASIS_REDUCER_POLICY_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_BACKUP_PROVIDER_FAILED"] = 8411] = "ANASTASIS_REDUCER_BACKUP_PROVIDER_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDER_CONFIG_FAILED"] = 8412] = "ANASTASIS_REDUCER_PROVIDER_CONFIG_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_POLICY_MALFORMED"] = 8413] = "ANASTASIS_REDUCER_POLICY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_NETWORK_FAILED"] = 8414] = "ANASTASIS_REDUCER_NETWORK_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_SECRET_MALFORMED"] = 8415] = "ANASTASIS_REDUCER_SECRET_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_CHALLENGE_DATA_TOO_BIG"] = 8416] = "ANASTASIS_REDUCER_CHALLENGE_DATA_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_SECRET_TOO_BIG"] = 8417] = "ANASTASIS_REDUCER_SECRET_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDER_INVALID_CONFIG"] = 8418] = "ANASTASIS_REDUCER_PROVIDER_INVALID_CONFIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INTERNAL_ERROR"] = 8419] = "ANASTASIS_REDUCER_INTERNAL_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDERS_ALREADY_SYNCED"] = 8420] = "ANASTASIS_REDUCER_PROVIDERS_ALREADY_SYNCED";
  TalerErrorCode2[TalerErrorCode2["DONAU_GENERIC_KEYS_MISSING"] = 8607] = "DONAU_GENERIC_KEYS_MISSING";
  TalerErrorCode2[TalerErrorCode2["DONAU_CHARITY_SIGNATURE_INVALID"] = 8608] = "DONAU_CHARITY_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["DONAU_CHARITY_NOT_FOUND"] = 8609] = "DONAU_CHARITY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["DONAU_EXCEEDING_DONATION_LIMIT"] = 8610] = "DONAU_EXCEEDING_DONATION_LIMIT";
  TalerErrorCode2[TalerErrorCode2["DONAU_GENERIC_DONATION_UNIT_UNKNOWN"] = 8611] = "DONAU_GENERIC_DONATION_UNIT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["DONAU_DONATION_UNIT_HELPER_UNAVAILABLE"] = 8612] = "DONAU_DONATION_UNIT_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["DONAU_SIGNKEY_HELPER_UNAVAILABLE"] = 8613] = "DONAU_SIGNKEY_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["DONAU_SIGNKEY_HELPER_BUG"] = 8614] = "DONAU_SIGNKEY_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["DONAU_GENERIC_WRONG_NUMBER_OF_SEGMENTS"] = 8615] = "DONAU_GENERIC_WRONG_NUMBER_OF_SEGMENTS";
  TalerErrorCode2[TalerErrorCode2["DONAU_DONATION_RECEIPT_SIGNATURE_INVALID"] = 8616] = "DONAU_DONATION_RECEIPT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["DONAU_DONOR_IDENTIFIER_NONCE_REUSE"] = 8617] = "DONAU_DONOR_IDENTIFIER_NONCE_REUSE";
  TalerErrorCode2[TalerErrorCode2["DONAU_CHARITY_PUB_EXISTS"] = 8618] = "DONAU_CHARITY_PUB_EXISTS";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_NEXUS_GENERIC_ERROR"] = 9e3] = "LIBEUFIN_NEXUS_GENERIC_ERROR";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_NEXUS_UNCAUGHT_EXCEPTION"] = 9001] = "LIBEUFIN_NEXUS_UNCAUGHT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_SANDBOX_GENERIC_ERROR"] = 9500] = "LIBEUFIN_SANDBOX_GENERIC_ERROR";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_SANDBOX_UNCAUGHT_EXCEPTION"] = 9501] = "LIBEUFIN_SANDBOX_UNCAUGHT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["TALDIR_METHOD_NOT_SUPPORTED"] = 9600] = "TALDIR_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["TALDIR_REGISTER_RATE_LIMITED"] = 9601] = "TALDIR_REGISTER_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_CLIENT_UNKNOWN"] = 9750] = "CHALLENGER_GENERIC_CLIENT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_CLIENT_FORBIDDEN_BAD_REDIRECT_URI"] = 9751] = "CHALLENGER_GENERIC_CLIENT_FORBIDDEN_BAD_REDIRECT_URI";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_HELPER_EXEC_FAILED"] = 9752] = "CHALLENGER_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GRANT_UNKNOWN"] = 9753] = "CHALLENGER_GRANT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_BAD_CODE"] = 9754] = "CHALLENGER_CLIENT_FORBIDDEN_BAD_CODE";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_VALIDATION_UNKNOWN"] = 9755] = "CHALLENGER_GENERIC_VALIDATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_INVALID_CODE"] = 9756] = "CHALLENGER_CLIENT_FORBIDDEN_INVALID_CODE";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_TOO_MANY_ATTEMPTS"] = 9757] = "CHALLENGER_TOO_MANY_ATTEMPTS";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_INVALID_PIN"] = 9758] = "CHALLENGER_INVALID_PIN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_MISSING_ADDRESS"] = 9759] = "CHALLENGER_MISSING_ADDRESS";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_READ_ONLY"] = 9760] = "CHALLENGER_CLIENT_FORBIDDEN_READ_ONLY";
  TalerErrorCode2[TalerErrorCode2["END"] = 9999] = "END";
})(TalerErrorCode || (TalerErrorCode = {}));

// ../taler-util/lib/time.js
var opaque_AbsoluteTime = Symbol("opaque_AbsoluteTime");
var TalerPreciseTimestamp;
(function(TalerPreciseTimestamp2) {
  function now() {
    const absNow = AbsoluteTime.now();
    return AbsoluteTime.toPreciseTimestamp(absNow);
  }
  TalerPreciseTimestamp2.now = now;
  function round(t5) {
    return {
      t_s: t5.t_s
    };
  }
  TalerPreciseTimestamp2.round = round;
  function fromSeconds(s6) {
    return {
      t_s: Math.floor(s6),
      off_us: Math.floor((s6 - Math.floor(s6)) / 1e3 / 1e3)
    };
  }
  TalerPreciseTimestamp2.fromSeconds = fromSeconds;
  function fromMilliseconds(ms) {
    return {
      t_s: Math.floor(ms / 1e3),
      off_us: Math.floor((ms - Math.floor(ms / 1e3) * 1e3) * 1e3)
    };
  }
  TalerPreciseTimestamp2.fromMilliseconds = fromMilliseconds;
})(TalerPreciseTimestamp || (TalerPreciseTimestamp = {}));
var TalerProtocolDuration;
(function(TalerProtocolDuration2) {
  function fromSpec(d6) {
    return Duration.toTalerProtocolDuration(Duration.fromSpec(d6));
  }
  TalerProtocolDuration2.fromSpec = fromSpec;
  function forever() {
    return {
      d_us: "forever"
    };
  }
  TalerProtocolDuration2.forever = forever;
})(TalerProtocolDuration || (TalerProtocolDuration = {}));
var TalerProtocolTimestamp;
(function(TalerProtocolTimestamp2) {
  function isTimestamp(x6) {
    return typeof x6 === "object" && x6 !== null && "t_s" in x6 && (typeof x6.t_s === "number" || x6.t_s === "never");
  }
  TalerProtocolTimestamp2.isTimestamp = isTimestamp;
  function now() {
    return AbsoluteTime.toProtocolTimestamp(AbsoluteTime.now());
  }
  TalerProtocolTimestamp2.now = now;
  function zero() {
    return {
      t_s: 0
    };
  }
  TalerProtocolTimestamp2.zero = zero;
  function never() {
    return {
      t_s: "never"
    };
  }
  TalerProtocolTimestamp2.never = never;
  function isNever(t5) {
    return t5.t_s === "never";
  }
  TalerProtocolTimestamp2.isNever = isNever;
  function fromSeconds(s6) {
    return {
      t_s: s6
    };
  }
  TalerProtocolTimestamp2.fromSeconds = fromSeconds;
  function min(t1, t22) {
    if (t1.t_s === "never") {
      return { t_s: t22.t_s };
    }
    if (t22.t_s === "never") {
      return { t_s: t1.t_s };
    }
    return { t_s: Math.min(t1.t_s, t22.t_s) };
  }
  TalerProtocolTimestamp2.min = min;
  function max(t1, t22) {
    if (t1.t_s === "never" || t22.t_s === "never") {
      return { t_s: "never" };
    }
    return { t_s: Math.max(t1.t_s, t22.t_s) };
  }
  TalerProtocolTimestamp2.max = max;
})(TalerProtocolTimestamp || (TalerProtocolTimestamp = {}));
var timeshift = 0;
var Duration;
(function(Duration2) {
  function toMilliseconds(d6) {
    if (d6.d_ms === "forever") {
      return Number.MAX_VALUE;
    }
    return d6.d_ms;
  }
  Duration2.toMilliseconds = toMilliseconds;
  function getRemaining(deadline, now = AbsoluteTime.now()) {
    if (deadline.t_ms === "never") {
      return { d_ms: "forever" };
    }
    if (now.t_ms === "never") {
      throw Error("invalid argument for 'now'");
    }
    if (deadline.t_ms < now.t_ms) {
      return { d_ms: 0 };
    }
    return { d_ms: deadline.t_ms - now.t_ms };
  }
  Duration2.getRemaining = getRemaining;
  function fromPrettyString(s6) {
    let dMs = 0;
    let currentNum = "";
    let parsingNum = true;
    for (let i5 = 0; i5 < s6.length; i5++) {
      const cc = s6.charCodeAt(i5);
      if (cc >= "0".charCodeAt(0) && cc <= "9".charCodeAt(0)) {
        if (!parsingNum) {
          throw Error("invalid duration, unexpected number");
        }
        currentNum += s6[i5];
        continue;
      }
      if (s6[i5] == " ") {
        if (currentNum != "") {
          parsingNum = false;
        }
        continue;
      }
      if (currentNum == "") {
        throw Error("invalid duration, missing number");
      }
      if (s6[i5] === "s") {
        if (s6.startsWith("seconds", i5)) {
          i5 += "seconds".length - 1;
        }
        dMs += 1e3 * Number.parseInt(currentNum, 10);
      } else if (s6[i5] === "m") {
        if (s6.startsWith("minutes", i5)) {
          i5 += "minutes".length - 1;
        }
        dMs += 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else if (s6[i5] === "h") {
        if (s6.startsWith("hours", i5)) {
          i5 += "hours".length - 1;
        }
        dMs += 60 * 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else if (s6[i5] === "d") {
        if (s6.startsWith("days", i5)) {
          i5 += "days".length - 1;
        }
        dMs += 24 * 60 * 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else {
        throw Error("invalid duration, unsupported unit");
      }
      currentNum = "";
      parsingNum = true;
    }
    return {
      d_ms: dMs
    };
  }
  Duration2.fromPrettyString = fromPrettyString;
  function cmp(d1, d23) {
    if (d1.d_ms === "forever") {
      if (d23.d_ms === "forever") {
        return 0;
      }
      return 1;
    }
    if (d23.d_ms === "forever") {
      return -1;
    }
    if (d1.d_ms == d23.d_ms) {
      return 0;
    }
    if (d1.d_ms > d23.d_ms) {
      return 1;
    }
    return -1;
  }
  Duration2.cmp = cmp;
  function add4(d1, d23) {
    if (d1.d_ms === "forever") {
      return Duration2.getForever();
    }
    if (d23.d_ms === "forever") {
      return Duration2.getForever();
    }
    return Duration2.fromMilliseconds(d1.d_ms + d23.d_ms);
  }
  Duration2.add = add4;
  function max(d1, d23) {
    return durationMax(d1, d23);
  }
  Duration2.max = max;
  function min(d1, d23) {
    return durationMin(d1, d23);
  }
  Duration2.min = min;
  function multiply(d1, n2) {
    return durationMul(d1, n2);
  }
  Duration2.multiply = multiply;
  function toIntegerYears(d6) {
    if (typeof d6.d_ms !== "number") {
      throw Error("infinite duration");
    }
    return Math.ceil(d6.d_ms / 1e3 / 60 / 60 / 24 / 365);
  }
  Duration2.toIntegerYears = toIntegerYears;
  function fromSpec(spec) {
    let d_ms = 0;
    d_ms += (spec.seconds ?? 0) * SECONDS;
    d_ms += (spec.minutes ?? 0) * MINUTES;
    d_ms += (spec.hours ?? 0) * HOURS;
    d_ms += (spec.days ?? 0) * DAYS;
    d_ms += (spec.months ?? 0) * MONTHS;
    d_ms += (spec.years ?? 0) * YEARS;
    return { d_ms };
  }
  Duration2.fromSpec = fromSpec;
  function fromSpecOrUndefined(spec) {
    if (spec.seconds == void 0 && spec.minutes == void 0 && spec.hours == void 0 && spec.days == void 0 && spec.months == void 0 && spec.years == void 0) {
      return void 0;
    }
    return Duration2.fromSpec(spec);
  }
  Duration2.fromSpecOrUndefined = fromSpecOrUndefined;
  function toSpec({ d_ms }) {
    if (d_ms === "forever")
      return void 0;
    const ms = d_ms > 0 ? d_ms : 0;
    const Y_rest = ms % YEARS;
    const M_rest = Y_rest % MONTHS;
    const D_rest = M_rest % DAYS;
    const h_rest = D_rest % HOURS;
    const m_rest = h_rest % MINUTES;
    const millis = m_rest % SECONDS;
    return {
      years: (ms - Y_rest) / YEARS,
      month: (Y_rest - M_rest) / MONTHS,
      days: (M_rest - D_rest) / DAYS,
      hours: (D_rest - h_rest) / HOURS,
      minutes: (h_rest - m_rest) / MINUTES,
      seconds: (m_rest - millis) / SECONDS
    };
  }
  Duration2.toSpec = toSpec;
  function getForever() {
    return { d_ms: "forever" };
  }
  Duration2.getForever = getForever;
  function getZero() {
    return { d_ms: 0 };
  }
  Duration2.getZero = getZero;
  function fromTalerProtocolDuration(d6) {
    if (d6.d_us === "forever") {
      return {
        d_ms: "forever"
      };
    }
    return {
      d_ms: Math.floor(d6.d_us / 1e3)
    };
  }
  Duration2.fromTalerProtocolDuration = fromTalerProtocolDuration;
  function toTalerProtocolDuration(d6) {
    if (d6.d_ms === "forever") {
      return {
        d_us: "forever"
      };
    }
    return {
      d_us: d6.d_ms * 1e3
    };
  }
  Duration2.toTalerProtocolDuration = toTalerProtocolDuration;
  function fromMilliseconds(ms) {
    return {
      d_ms: ms
    };
  }
  Duration2.fromMilliseconds = fromMilliseconds;
  function clamp(args) {
    return durationMax(durationMin(args.value, args.upper), args.lower);
  }
  Duration2.clamp = clamp;
})(Duration || (Duration = {}));
var AbsoluteTime;
(function(AbsoluteTime3) {
  function getStampMsNow() {
    return (/* @__PURE__ */ new Date()).getTime();
  }
  AbsoluteTime3.getStampMsNow = getStampMsNow;
  function getStampMsNever() {
    return Number.MAX_SAFE_INTEGER;
  }
  AbsoluteTime3.getStampMsNever = getStampMsNever;
  function now() {
    return {
      t_ms: (/* @__PURE__ */ new Date()).getTime() + timeshift,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.now = now;
  function zero() {
    return {
      t_ms: 0,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.zero = zero;
  function never() {
    return {
      t_ms: "never",
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.never = never;
  function fromMilliseconds(ms) {
    return {
      t_ms: ms,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromMilliseconds = fromMilliseconds;
  function cmp(t1, t22) {
    if (t1.t_ms === "never") {
      if (t22.t_ms === "never") {
        return 0;
      }
      return 1;
    }
    if (t22.t_ms === "never") {
      return -1;
    }
    if (t1.t_ms == t22.t_ms) {
      return 0;
    }
    if (t1.t_ms > t22.t_ms) {
      return 1;
    }
    return -1;
  }
  AbsoluteTime3.cmp = cmp;
  function min(t1, t22) {
    if (t1.t_ms === "never") {
      return { t_ms: t22.t_ms, [opaque_AbsoluteTime]: true };
    }
    if (t22.t_ms === "never") {
      return { t_ms: t22.t_ms, [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.min(t1.t_ms, t22.t_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.min = min;
  function max(t1, t22) {
    if (t1.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    if (t22.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.max(t1.t_ms, t22.t_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.max = max;
  function difference(t1, t22) {
    if (t1.t_ms === "never") {
      return { d_ms: "forever" };
    }
    if (t22.t_ms === "never") {
      return { d_ms: "forever" };
    }
    return { d_ms: Math.abs(t1.t_ms - t22.t_ms) };
  }
  AbsoluteTime3.difference = difference;
  function isExpired(t5) {
    return cmp(t5, now()) <= 0;
  }
  AbsoluteTime3.isExpired = isExpired;
  function isNever(t5) {
    return t5.t_ms === "never";
  }
  AbsoluteTime3.isNever = isNever;
  function fromProtocolTimestamp(t5) {
    if (t5.t_s === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return {
      t_ms: t5.t_s * 1e3,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromProtocolTimestamp = fromProtocolTimestamp;
  function fromStampMs(stampMs) {
    return {
      t_ms: stampMs,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromStampMs = fromStampMs;
  function fromPreciseTimestamp(t5) {
    if (t5.t_s === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    const offsetUs = t5.off_us ?? 0;
    return {
      t_ms: t5.t_s * 1e3 + Math.floor(offsetUs / 1e3),
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromPreciseTimestamp = fromPreciseTimestamp;
  function toStampMs(at2) {
    if (at2.t_ms === "never") {
      return Number.MAX_SAFE_INTEGER;
    }
    return at2.t_ms;
  }
  AbsoluteTime3.toStampMs = toStampMs;
  function toPreciseTimestamp(at2) {
    if (at2.t_ms == "never") {
      return {
        t_s: "never"
      };
    }
    const t_s = Math.floor(at2.t_ms / 1e3);
    const off_us = Math.floor(1e3 * (at2.t_ms - t_s * 1e3));
    return {
      t_s,
      off_us
    };
  }
  AbsoluteTime3.toPreciseTimestamp = toPreciseTimestamp;
  function toProtocolTimestamp(at2) {
    if (at2.t_ms === "never") {
      return { t_s: "never" };
    }
    return {
      t_s: Math.floor(at2.t_ms / 1e3)
    };
  }
  AbsoluteTime3.toProtocolTimestamp = toProtocolTimestamp;
  function isBetween(t5, start, end) {
    if (cmp(t5, start) < 0) {
      return false;
    }
    if (cmp(t5, end) > 0) {
      return false;
    }
    return true;
  }
  AbsoluteTime3.isBetween = isBetween;
  function toIsoString(t5) {
    if (t5.t_ms === "never") {
      return "<never>";
    } else {
      return new Date(t5.t_ms).toISOString();
    }
  }
  AbsoluteTime3.toIsoString = toIsoString;
  function addDuration(t1, d6) {
    if (t1.t_ms === "never" || d6.d_ms === "forever") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return { t_ms: t1.t_ms + d6.d_ms, [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.addDuration = addDuration;
  function remaining(t1) {
    if (t1.t_ms === "never") {
      return Duration.getForever();
    }
    const stampNow = now();
    if (stampNow.t_ms === "never") {
      throw Error("invariant violated");
    }
    return Duration.fromMilliseconds(Math.max(0, t1.t_ms - stampNow.t_ms));
  }
  AbsoluteTime3.remaining = remaining;
  function subtractDuraction(t1, d6) {
    if (t1.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    if (d6.d_ms === "forever") {
      return { t_ms: 0, [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.max(0, t1.t_ms - d6.d_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.subtractDuraction = subtractDuraction;
  function stringify(t5) {
    if (t5.t_ms === "never") {
      return "never";
    }
    return new Date(t5.t_ms).toISOString();
  }
  AbsoluteTime3.stringify = stringify;
})(AbsoluteTime || (AbsoluteTime = {}));
var SECONDS = 1e3;
var MINUTES = SECONDS * 60;
var HOURS = MINUTES * 60;
var DAYS = HOURS * 24;
var MONTHS = DAYS * 30;
var YEARS = DAYS * 365;
function durationMin(d1, d23) {
  if (d1.d_ms === "forever") {
    return { d_ms: d23.d_ms };
  }
  if (d23.d_ms === "forever") {
    return { d_ms: d1.d_ms };
  }
  return { d_ms: Math.min(d1.d_ms, d23.d_ms) };
}
function durationMax(d1, d23) {
  if (d1.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  if (d23.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  return { d_ms: Math.max(d1.d_ms, d23.d_ms) };
}
function durationMul(d6, n2) {
  if (d6.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  return { d_ms: Math.round(d6.d_ms * n2) };
}
var codecForAbsoluteTime = {
  decode(x6, c5) {
    if (x6 === void 0) {
      throw Error(`got undefined and expected absolute time at ${renderContext(c5)}`);
    }
    const t_ms = x6.t_ms;
    if (typeof t_ms === "string") {
      if (t_ms === "never") {
        return { t_ms: "never", [opaque_AbsoluteTime]: true };
      }
    } else if (typeof t_ms === "number") {
      return { t_ms, [opaque_AbsoluteTime]: true };
    }
    throw Error(`expected timestamp at ${renderContext(c5)}`);
  }
};
var codecForTimestamp = {
  decode(x6, c5) {
    if (x6 === void 0) {
      throw Error(`got undefined and expected timestamp at ${renderContext(c5)}`);
    }
    const t_ms = x6.t_ms;
    if (typeof t_ms === "string") {
      if (t_ms === "never") {
        return { t_s: "never" };
      }
    } else if (typeof t_ms === "number") {
      return { t_s: Math.floor(t_ms / 1e3) };
    }
    const t_s = x6.t_s;
    if (typeof t_s === "string") {
      if (t_s === "never") {
        return { t_s: "never" };
      }
      throw Error(`expected timestamp at ${renderContext(c5)}`);
    }
    if (typeof t_s === "number") {
      return { t_s };
    }
    throw Error(`expected protocol timestamp at ${renderContext(c5)}`);
  }
};
var codecForDuration = {
  decode(x6, c5) {
    const d_us = x6.d_us;
    if (typeof d_us === "string") {
      if (d_us === "forever") {
        return { d_us: "forever" };
      }
      throw Error(`expected duration at ${renderContext(c5)}`);
    }
    if (typeof d_us === "number") {
      return { d_us };
    }
    throw Error(`expected duration at ${renderContext(c5)}`);
  }
};

// ../taler-util/lib/http-common.js
var textEncoder = new TextEncoder();
var logger2 = new Logger("http.ts");
var DEFAULT_REQUEST_TIMEOUT_MS = 6e4;
var HeadersImpl = class {
  constructor() {
    this.headerMap = /* @__PURE__ */ new Map();
  }
  get(name2) {
    const r3 = this.headerMap.get(name2.toLowerCase());
    if (r3) {
      return r3;
    }
    return null;
  }
  set(name2, value) {
    const normalizedName = name2.toLowerCase();
    const existing = this.headerMap.get(normalizedName);
    if (existing !== void 0) {
      this.headerMap.set(normalizedName, existing + "," + value);
    } else {
      this.headerMap.set(normalizedName, value);
    }
  }
  toJSON() {
    const m6 = {};
    this.headerMap.forEach((v3, k6) => m6[k6] = v3);
    return m6;
  }
};
async function readTalerErrorResponse(httpResponse) {
  const contentType = httpResponse.headers.get("content-type");
  if (contentType !== "application/json") {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      contentType: contentType || "<null>"
    }, "Error response did not even contain JSON. The request URL might be wrong or the service might be unavailable.");
  }
  let errJson;
  try {
    errJson = await httpResponse.json();
  } catch (e5) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e5 instanceof Error ? e5.message : String(e5)
    }, "Couldn't parse JSON format from error response");
  }
  const talerErrorCode = errJson.code;
  if (typeof talerErrorCode !== "number") {
    logger2.warn(`malformed error response (status ${httpResponse.status}): ${j2s(errJson)}`);
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text()
    }, "Error response did not contain error code");
  }
  return errJson;
}
async function readSuccessResponseJsonOrErrorCode(httpResponse, codec) {
  if (!(httpResponse.status >= 200 && httpResponse.status < 300)) {
    return {
      isError: true,
      talerErrorResponse: await readTalerErrorResponse(httpResponse)
    };
  }
  let respJson;
  try {
    respJson = await httpResponse.json();
  } catch (e5) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e5 instanceof Error ? e5.message : String(e5)
    }, "Couldn't parse JSON format from response");
  }
  let parsedResponse;
  try {
    parsedResponse = codec.decode(respJson);
  } catch (e5) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e5 instanceof Error ? e5.message : String(e5)
    }, "Response invalid");
  }
  return {
    isError: false,
    response: parsedResponse
  };
}
async function readResponseJsonOrThrow(httpResponse, codec) {
  let respJson;
  try {
    respJson = await httpResponse.json();
  } catch (e5) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e5 instanceof Error ? e5.message : String(e5)
    }, "Couldn't parse JSON format from response");
  }
  let parsedResponse;
  try {
    parsedResponse = codec.decode(respJson);
  } catch (e5) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e5 instanceof Error ? e5.message : String(e5)
    }, "Response invalid");
  }
  return parsedResponse;
}
function throwUnexpectedRequestError(httpResponse, talerErrorResponse) {
  const errorDetails = {
    requestUrl: httpResponse.requestUrl,
    requestMethod: httpResponse.requestMethod,
    httpStatusCode: httpResponse.status,
    errorResponse: talerErrorResponse
  };
  logger2.trace(`unexpected request error: ${j2s(errorDetails)}`);
  throw TalerError.fromDetail(TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR, errorDetails, `Unexpected HTTP status ${httpResponse.status} in response`);
}
async function readSuccessResponseJsonOrThrow(httpResponse, codec) {
  const r3 = await readSuccessResponseJsonOrErrorCode(httpResponse, codec);
  if (!r3.isError) {
    return r3.response;
  }
  throwUnexpectedRequestError(httpResponse, r3.talerErrorResponse);
}
function encodeBody(body) {
  if (body == null) {
    return new ArrayBuffer(0);
  }
  if (typeof body === "string") {
    return textEncoder.encode(body).buffer;
  } else if (ArrayBuffer.isView(body)) {
    return body.buffer;
  } else if (body instanceof ArrayBuffer) {
    return body;
  } else if (body instanceof URLSearchParams) {
    return textEncoder.encode(body.toString()).buffer;
  } else if (typeof body === "object" && body.constructor.name === "FormData") {
    return body;
  } else if (typeof body === "object") {
    return textEncoder.encode(JSON.stringify(body)).buffer;
  }
  throw new TypeError("unsupported request body type");
}
function getDefaultHeaders(method) {
  const headers = {};
  if (method === "POST" || method === "PUT" || method === "PATCH") {
    headers["Content-Type"] = "application/json";
  }
  headers["Accept"] = "application/json";
  return headers;
}
function makeBasicAuthHeader(username, password) {
  const auth = `${username}:${password}`;
  const authEncoded = base64FromArrayBuffer(stringToBytes(auth));
  return `Basic ${authEncoded}`;
}

// ../taler-util/lib/libtool-version.js
var LibtoolVersion;
(function(LibtoolVersion2) {
  function compare2(me, other) {
    const meVer = parseVersion(me);
    const otherVer = parseVersion(other);
    if (!(meVer && otherVer)) {
      return void 0;
    }
    const compatible = meVer.current - meVer.age <= otherVer.current && meVer.current >= otherVer.current - otherVer.age;
    const currentCmp = Math.sign(meVer.current - otherVer.current);
    return { compatible, currentCmp };
  }
  LibtoolVersion2.compare = compare2;
  function parseVersionOrThrow(v3) {
    const res = parseVersion(v3);
    if (!res) {
      throw Error("invalid libtool version");
    }
    return res;
  }
  LibtoolVersion2.parseVersionOrThrow = parseVersionOrThrow;
  function parseVersion(v3) {
    const [currentStr, revisionStr, ageStr, ...rest] = v3.split(":");
    if (rest.length !== 0) {
      return void 0;
    }
    const current = Number.parseInt(currentStr);
    const revision = Number.parseInt(revisionStr);
    const age = Number.parseInt(ageStr);
    if (Number.isNaN(current)) {
      return void 0;
    }
    if (Number.isNaN(revision)) {
      return void 0;
    }
    if (Number.isNaN(age)) {
      return void 0;
    }
    return { current, revision, age };
  }
  LibtoolVersion2.parseVersion = parseVersion;
})(LibtoolVersion || (LibtoolVersion = {}));

// ../taler-util/lib/types-taler-common.js
var codecForURLString = codecForString;
var codecForCurrencyName = codecForString;
var codecForDecimalNumber = codecForString;
var codecForEddsaPublicKey = codecForString;
var codecForEddsaSignature = codecForString;
var codecForInternationalizedString = () => codecForMap(codecForString());
var codecForCurrencySpecificiation = () => buildCodecForObject().property("name", codecForString()).property("num_fractional_input_digits", codecForNumber()).property("num_fractional_normal_digits", codecForNumber()).property("num_fractional_trailing_zero_digits", codecForNumber()).property("alt_unit_names", codecForMap(codecForString())).property("common_amounts", codecOptional(codecForList(codecForAmountString()))).deprecatedProperty("currency").build("CurrencySpecification");
var codecForTalerCommonConfigResponse = () => buildCodecForObject().allowExtra().property("name", codecForString()).property("version", codecForString()).build("TalerCommonConfigResponse");
var ExchangeProtocolVersion;
(function(ExchangeProtocolVersion2) {
  ExchangeProtocolVersion2[ExchangeProtocolVersion2["V12"] = 12] = "V12";
})(ExchangeProtocolVersion || (ExchangeProtocolVersion = {}));
var MerchantProtocolVersion;
(function(MerchantProtocolVersion2) {
  MerchantProtocolVersion2[MerchantProtocolVersion2["V3"] = 3] = "V3";
})(MerchantProtocolVersion || (MerchantProtocolVersion = {}));
var codecForTokenInfo = () => buildCodecForObject().property("creation_time", codecForTimestamp).property("expiration", codecForTimestamp).property("scope", codecForString()).property("refreshable", codecForBoolean()).property("description", codecOptional(codecForString())).property("serial", codecForNumber()).build("TokenInfo");
var codecForTokenInfoList = () => buildCodecForObject().property("tokens", codecForList(codecForTokenInfo())).build("TokenInfoList");
var codecForAccessToken = codecForString;
var codecForTokenSuccessResponse = () => buildCodecForObject().property("access_token", codecForAccessToken()).property("expiration", codecForTimestamp).build("TalerAuthentication.TokenSuccessResponse");
var codecForURN = codecForString;

// ../taler-util/lib/operation.js
function isOperationOk(c5) {
  return c5.type === "ok";
}
function isOperationFail(c5) {
  return c5.type === "fail";
}
async function opSuccessFromHttp(resp, codec) {
  const body = await readSuccessResponseJsonOrThrow(resp, codec);
  return { type: "ok", case: "ok", body };
}
function opFixedSuccess(body) {
  return { type: "ok", case: "ok", body };
}
function opEmptySuccess() {
  return { type: "ok", case: "ok", body: void 0 };
}
function opKnownFailure(case_) {
  return { type: "fail", case: case_ };
}
function opKnownFailureWithBody(case_, body) {
  return { type: "fail", case: case_, body };
}
async function carefullyParseConfig(expectedName, clientVersion, httpResponse, codec) {
  const minBody = await readSuccessResponseJsonOrThrow(httpResponse, codecForTalerCommonConfigResponse());
  if (minBody.name !== expectedName) {
    throw TalerError.fromUncheckedDetail({
      code: TalerErrorCode.GENERIC_UNEXPECTED_REQUEST_ERROR,
      requestUrl: httpResponse.requestUrl,
      httpStatusCode: httpResponse.status,
      detail: `Unexpected server component name (got ${minBody.name}, expected ${expectedName}})`
    });
  }
  if (!LibtoolVersion.compare(clientVersion, minBody.version)) {
    throw TalerError.fromUncheckedDetail({
      code: TalerErrorCode.GENERIC_CLIENT_UNSUPPORTED_PROTOCOL_VERSION,
      requestUrl: httpResponse.requestUrl,
      httpStatusCode: httpResponse.status,
      detail: `Unsupported protocol version, client supports ${clientVersion}, server supports ${minBody.version}`
    });
  }
  const body = await readSuccessResponseJsonOrThrow(httpResponse, codec);
  return opFixedSuccess(body);
}
async function opKnownAlternativeHttpFailure(resp, s6, codec) {
  const body = await readResponseJsonOrThrow(resp, codec);
  return { type: "fail", case: s6, body };
}
async function opKnownHttpFailure(_case, resp, detail) {
  if (!detail) {
    detail = await readTalerErrorResponse(resp);
  }
  return { type: "fail", case: _case, detail };
}
async function opUnknownHttpFailure(resp, detail) {
  if (!detail) {
    detail = await readTalerErrorResponse(resp);
  }
  throw TalerError.fromDetail(TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR, {
    requestUrl: resp.requestUrl,
    requestMethod: resp.requestMethod,
    httpStatusCode: resp.status,
    errorResponse: detail
  }, `Unexpected HTTP status ${resp.status} in response`);
}
function opKnownTalerFailure(_case, detail) {
  return { type: "fail", case: _case, detail };
}
function succeedOrThrow(resp) {
  if (isOperationOk(resp)) {
    return resp.body;
  }
  if (isOperationFail(resp)) {
    throw TalerError.fromUncheckedDetail({ ...resp, case: resp.case });
  }
  throw TalerError.fromException(resp);
}

// ../taler-util/lib/amounts.js
var amountFractionalBase = 1e8;
var amountFractionalLength = 8;
var amountMaxValue = 2 ** 52;
var FRAC_SEPARATOR = ".";
var CURRENCY_SEPARATOR = ":";
var Amount = class _Amount {
  static from(a6) {
    return new _Amount(Amounts.parseOrThrow(a6), 0);
  }
  static zeroOfCurrency(currency) {
    return new _Amount(Amounts.zeroOfCurrency(currency), 0);
  }
  add(...a6) {
    if (this.saturated) {
      return this;
    }
    const r3 = Amounts.add(this.val, ...a6);
    return new _Amount(r3.amount, r3.saturated ? 1 : 0);
  }
  isZero() {
    return this.val.fraction === 0 && this.val.value === 0;
  }
  sub(...a6) {
    if (this.saturated) {
      return this;
    }
    const r3 = Amounts.sub(this.val, ...a6);
    return new _Amount(r3.amount, r3.saturated ? 1 : 0);
  }
  mult(n2) {
    if (this.saturated) {
      return this;
    }
    const r3 = Amounts.mult(this, n2);
    return new _Amount(r3.amount, r3.saturated ? 1 : 0);
  }
  toJson() {
    return { ...this.val };
  }
  toString() {
    return Amounts.stringify(this.val);
  }
  constructor(val, saturated) {
    this.val = val;
    this.saturated = saturated;
  }
};
function codecForAmountString() {
  return {
    decode(x6, c5) {
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
      }
      if (Amounts.parse(x6) === void 0) {
        throw new DecodingError(`invalid amount at ${renderContext(c5)} got "${x6}"`);
      }
      return x6;
    }
  };
}
var AmountParseError;
(function(AmountParseError2) {
  AmountParseError2[AmountParseError2["MISSING_CURRENCY"] = 0] = "MISSING_CURRENCY";
  AmountParseError2[AmountParseError2["CURRENCY_TOO_LONG"] = 1] = "CURRENCY_TOO_LONG";
  AmountParseError2[AmountParseError2["BAD_CURRENCY"] = 2] = "BAD_CURRENCY";
  AmountParseError2[AmountParseError2["BAD_NUMBER"] = 3] = "BAD_NUMBER";
  AmountParseError2[AmountParseError2["TOO_HIGH"] = 4] = "TOO_HIGH";
  AmountParseError2[AmountParseError2["TOO_PRECISE"] = 5] = "TOO_PRECISE";
})(AmountParseError || (AmountParseError = {}));
var Amounts = class _Amounts {
  constructor() {
    throw Error("not instantiable");
  }
  static currencyOf(amount) {
    const amt = _Amounts.parseOrThrow(amount);
    return amt.currency;
  }
  static zeroOfAmount(amount) {
    const amt = _Amounts.parseOrThrow(amount);
    return {
      currency: amt.currency,
      fraction: 0,
      value: 0
    };
  }
  /**
   * Get an amount that represents zero units of a currency.
   */
  static zeroOfCurrency(currency) {
    return {
      currency,
      fraction: 0,
      value: 0
    };
  }
  static jsonifyAmount(amt) {
    if (typeof amt === "string") {
      return _Amounts.parseOrThrow(amt);
    }
    if (amt instanceof Amount) {
      return amt.toJson();
    }
    return amt;
  }
  static divmod(a1, a23) {
    const am1 = _Amounts.jsonifyAmount(a1);
    const am2 = _Amounts.jsonifyAmount(a23);
    if (am1.currency != am2.currency) {
      throw Error(`incompatible currency (${am1.currency} vs${am2.currency})`);
    }
    const x1 = BigInt(am1.value) * BigInt(amountFractionalBase) + BigInt(am1.fraction);
    const x22 = BigInt(am2.value) * BigInt(amountFractionalBase) + BigInt(am2.fraction);
    const quotient = x1 / x22;
    const remainderScaled = x1 % x22;
    return {
      quotient: Number(quotient),
      remainder: {
        currency: am1.currency,
        value: Number(remainderScaled / BigInt(amountFractionalBase)),
        fraction: Number(remainderScaled % BigInt(amountFractionalBase))
      }
    };
  }
  static sum(amounts) {
    if (amounts.length <= 0) {
      throw Error("can't sum zero amounts");
    }
    const jsonAmounts = amounts.map((x6) => _Amounts.jsonifyAmount(x6));
    return _Amounts.add(jsonAmounts[0], ...jsonAmounts.slice(1));
  }
  static sumOrZero(currency, amounts) {
    if (amounts.length <= 0) {
      return {
        amount: _Amounts.zeroOfCurrency(currency),
        saturated: false
      };
    }
    const jsonAmounts = amounts.map((x6) => _Amounts.jsonifyAmount(x6));
    return _Amounts.add(jsonAmounts[0], ...jsonAmounts.slice(1));
  }
  /**
   * Add two amounts.  Return the result and whether
   * the addition overflowed.  The overflow is always handled
   * by saturating and never by wrapping.
   *
   * Throws when currencies don't match.
   */
  static add(first, ...rest) {
    const firstJ = _Amounts.jsonifyAmount(first);
    const currency = firstJ.currency;
    let value = firstJ.value + Math.floor(firstJ.fraction / amountFractionalBase);
    if (value > amountMaxValue) {
      return {
        amount: {
          currency,
          value: amountMaxValue,
          fraction: amountFractionalBase - 1
        },
        saturated: true
      };
    }
    let fraction = firstJ.fraction % amountFractionalBase;
    for (const x6 of rest) {
      const xJ = _Amounts.jsonifyAmount(x6);
      if (xJ.currency.toUpperCase() !== currency.toUpperCase()) {
        throw Error(`Mismatched currency: ${xJ.currency} and ${currency}`);
      }
      value = value + xJ.value + Math.floor((fraction + xJ.fraction) / amountFractionalBase);
      fraction = Math.floor((fraction + xJ.fraction) % amountFractionalBase);
      if (value > amountMaxValue) {
        return {
          amount: {
            currency,
            value: amountMaxValue,
            fraction: amountFractionalBase - 1
          },
          saturated: true
        };
      }
    }
    return { amount: { currency, value, fraction }, saturated: false };
  }
  /**
   * Subtract two amounts.  Return the result and whether
   * the subtraction overflowed.  The overflow is always handled
   * by saturating and never by wrapping.
   *
   * Throws when currencies don't match.
   */
  static sub(a6, ...rest) {
    const aJ = _Amounts.jsonifyAmount(a6);
    const currency = aJ.currency;
    let value = aJ.value;
    let fraction = aJ.fraction;
    for (const b5 of rest) {
      const bJ = _Amounts.jsonifyAmount(b5);
      if (bJ.currency.toUpperCase() !== aJ.currency.toUpperCase()) {
        throw Error(`Mismatched currency: ${bJ.currency} and ${currency}`);
      }
      if (fraction < bJ.fraction) {
        if (value < 1) {
          return {
            amount: { currency, value: 0, fraction: 0 },
            saturated: true
          };
        }
        value--;
        fraction += amountFractionalBase;
      }
      console.assert(fraction >= bJ.fraction);
      fraction -= bJ.fraction;
      if (value < bJ.value) {
        return { amount: { currency, value: 0, fraction: 0 }, saturated: true };
      }
      value -= bJ.value;
    }
    return { amount: { currency, value, fraction }, saturated: false };
  }
  /**
   * Compare two amounts.  Returns 0 when equal, -1 when a < b
   * and +1 when a > b.  Throws when currencies don't match.
   */
  static cmp(a6, b5) {
    a6 = _Amounts.jsonifyAmount(a6);
    b5 = _Amounts.jsonifyAmount(b5);
    if (a6.currency !== b5.currency) {
      throw Error(`Mismatched currency: ${a6.currency} and ${b5.currency}`);
    }
    const av = a6.value + Math.floor(a6.fraction / amountFractionalBase);
    const af = a6.fraction % amountFractionalBase;
    const bv = b5.value + Math.floor(b5.fraction / amountFractionalBase);
    const bf = b5.fraction % amountFractionalBase;
    switch (true) {
      case av < bv:
        return -1;
      case av > bv:
        return 1;
      case af < bf:
        return -1;
      case af > bf:
        return 1;
      case af === bf:
        return 0;
      default:
        throw Error("assertion failed");
    }
  }
  /**
   * Create a copy of an amount.
   */
  static copy(a6) {
    return {
      currency: a6.currency,
      fraction: a6.fraction,
      value: a6.value
    };
  }
  /**
   * Divide an amount.  Throws on division by zero.
   */
  static divide(a6, n2) {
    if (n2 === 0) {
      throw Error(`Division by 0`);
    }
    if (n2 === 1) {
      return { value: a6.value, fraction: a6.fraction, currency: a6.currency };
    }
    const r3 = a6.value % n2;
    return {
      currency: a6.currency,
      fraction: Math.floor((r3 * amountFractionalBase + a6.fraction) / n2),
      value: Math.floor(a6.value / n2)
    };
  }
  /**
   * Check if an amount is non-zero.
   */
  static isNonZero(a6) {
    a6 = _Amounts.jsonifyAmount(a6);
    return a6.value > 0 || a6.fraction > 0;
  }
  static isZero(a6) {
    a6 = _Amounts.jsonifyAmount(a6);
    return a6.value === 0 && a6.fraction === 0;
  }
  /**
   * Check whether a string is a valid currency for a Taler amount.
   */
  static isCurrency(s6) {
    return /^[a-zA-Z]{1,11}$/.test(s6);
  }
  /**
   * Parse an amount like 'EUR:20.5' for 20 Euros and 50 ct.
   *
   * Currency name size limit is 11 of ASCII letters
   * Fraction size limit is 8
   */
  static parseWithError(s6) {
    const c_idx = s6.indexOf(CURRENCY_SEPARATOR);
    if (c_idx === -1 || c_idx === 0) {
      return opKnownFailure(AmountParseError.MISSING_CURRENCY);
    }
    if (c_idx > 11) {
      return opKnownFailure(AmountParseError.MISSING_CURRENCY);
    }
    const currency = s6.substring(0, c_idx).toUpperCase();
    if (!/^[a-zA-Z]+$/.test(currency)) {
      return opKnownFailure(AmountParseError.BAD_CURRENCY);
    }
    const number = s6.substring(c_idx + 1);
    const d_idx = number.indexOf(FRAC_SEPARATOR);
    const integerStr = d_idx === -1 ? number : number.substring(0, d_idx);
    const fractStr = d_idx === -1 || d_idx === number.length ? "0" : number.substring(d_idx + 1);
    if (!/^[0-9]+$/.test(integerStr) || !/^[0-9]+$/.test(fractStr)) {
      return opKnownFailure(AmountParseError.BAD_NUMBER);
    }
    const value = Number.parseInt(integerStr, 10);
    const fraction = Math.round(amountFractionalBase * Number.parseFloat(FRAC_SEPARATOR + fractStr));
    if (!Number.isInteger(value) || !Number.isInteger(fraction)) {
      return opKnownFailure(AmountParseError.BAD_NUMBER);
    }
    if (value > amountMaxValue) {
      return opKnownFailure(AmountParseError.TOO_HIGH);
    }
    if (fractStr.length > amountFractionalLength) {
      return opKnownFailure(AmountParseError.TOO_PRECISE);
    }
    return opFixedSuccess({
      currency,
      fraction,
      value
    });
  }
  /**
   * Parse an amount like 'EUR:20.5' for 20 Euros and 50 ct.
   *
   * Currency name size limit is 11 of ASCII letters
   * Fraction size limit is 8
   */
  static parse(s6) {
    const res = s6.match(/^([a-zA-Z]{1,11}):([0-9]+)([.][0-9]{1,8})?$/);
    if (!res) {
      return void 0;
    }
    const tail = res[3] || FRAC_SEPARATOR + "0";
    if (tail.length > amountFractionalLength + 1) {
      return void 0;
    }
    const value = Number.parseInt(res[2]);
    if (value > amountMaxValue) {
      return void 0;
    }
    return {
      currency: res[1].toUpperCase(),
      fraction: Math.round(amountFractionalBase * Number.parseFloat(tail)),
      value
    };
  }
  /**
   * Parse amount in standard string form (like 'EUR:20.5'),
   * throw if the input is not a valid amount.
   */
  static parseOrThrow(s6) {
    if (s6 instanceof Amount) {
      return s6.toJson();
    }
    if (typeof s6 === "object") {
      if (typeof s6.currency !== "string") {
        throw Error("invalid amount object");
      }
      if (typeof s6.value !== "number") {
        throw Error("invalid amount object");
      }
      if (typeof s6.fraction !== "number") {
        throw Error("invalid amount object");
      }
      return { currency: s6.currency, value: s6.value, fraction: s6.fraction };
    } else if (typeof s6 === "string") {
      const res = _Amounts.parse(s6);
      if (!res) {
        throw Error(`Can't parse amount: "${s6}"`);
      }
      return res;
    } else {
      throw Error("invalid amount (illegal type)");
    }
  }
  static min(a6, b5) {
    const cr = _Amounts.cmp(a6, b5);
    if (cr >= 0) {
      return _Amounts.jsonifyAmount(b5);
    } else {
      return _Amounts.jsonifyAmount(a6);
    }
  }
  static max(a6, b5) {
    const cr = _Amounts.cmp(a6, b5);
    if (cr >= 0) {
      return _Amounts.jsonifyAmount(a6);
    } else {
      return _Amounts.jsonifyAmount(b5);
    }
  }
  static mult(a6, n2) {
    a6 = this.jsonifyAmount(a6);
    if (!Number.isInteger(n2)) {
      throw Error("amount can only be multiplied by an integer");
    }
    if (n2 < 0) {
      throw Error("amount can only be multiplied by a positive integer");
    }
    if (n2 == 0) {
      return {
        amount: _Amounts.zeroOfCurrency(a6.currency),
        saturated: false
      };
    }
    let x6 = a6;
    let acc = _Amounts.zeroOfCurrency(a6.currency);
    while (n2 > 1) {
      if (n2 % 2 == 0) {
        n2 = n2 / 2;
      } else {
        n2 = (n2 - 1) / 2;
        const r23 = _Amounts.add(acc, x6);
        if (r23.saturated) {
          return r23;
        }
        acc = r23.amount;
      }
      const r22 = _Amounts.add(x6, x6);
      if (r22.saturated) {
        return r22;
      }
      x6 = r22.amount;
    }
    return _Amounts.add(acc, x6);
  }
  /**
   * Check if the argument is a valid amount in string form.
   */
  static check(a6) {
    if (typeof a6 !== "string") {
      return false;
    }
    try {
      const parsedAmount = _Amounts.parse(a6);
      return !!parsedAmount;
    } catch {
      return false;
    }
  }
  /**
   * Convert to standard human-readable string representation that's
   * also used in JSON formats.
   */
  static stringify(a6) {
    a6 = _Amounts.jsonifyAmount(a6);
    const s6 = this.stringifyValue(a6);
    return `${a6.currency}:${s6}`;
  }
  /**
   * Show an amount in a form suitable for the user.
   * FIXME:  In the future, this should consider currency-specific
   * settings such as significant digits or currency symbols.
   */
  static toPretty(amount) {
    const x6 = amount.value + amount.fraction / amountFractionalBase;
    return `${x6} ${amount.currency}`;
  }
  static amountHasSameCurrency(a1, a23) {
    const x1 = this.jsonifyAmount(a1);
    const x22 = this.jsonifyAmount(a23);
    return x1.currency.toUpperCase() === x22.currency.toUpperCase();
  }
  static isSameCurrency(curr1, curr2) {
    return curr1.toLowerCase() === curr2.toLowerCase();
  }
  static stringifyValue(a6, minFractional = 0) {
    const aJ = _Amounts.jsonifyAmount(a6);
    const av = aJ.value + Math.floor(aJ.fraction / amountFractionalBase);
    const af = aJ.fraction % amountFractionalBase;
    let s6 = av.toString();
    if (af || minFractional) {
      s6 = s6 + FRAC_SEPARATOR;
      let n2 = af;
      for (let i5 = 0; i5 < amountFractionalLength; i5++) {
        if (!n2 && i5 >= minFractional) {
          break;
        }
        s6 = s6 + Math.floor(n2 / amountFractionalBase * 10).toString();
        n2 = n2 * 10 % amountFractionalBase;
      }
    }
    return s6;
  }
  /**
   * Number of fractional digits needed to fully represent the amount
   * @param a amount
   * @returns
   */
  static maxFractionalDigits(a6) {
    if (a6.fraction === 0)
      return 0;
    if (a6.fraction < 0) {
      console.error("amount fraction can not be negative", a6);
      return 0;
    }
    let i5 = 0;
    let check = true;
    let rest = a6.fraction;
    while (rest > 0 && check) {
      check = rest % 10 === 0;
      rest = rest / 10;
      i5++;
    }
    return amountFractionalLength - i5 + 1;
  }
  static stringifyValueWithSpec(value, spec) {
    const strValue = _Amounts.stringifyValue(value);
    const pos = strValue.indexOf(FRAC_SEPARATOR);
    const originalPosition = pos < 0 ? strValue.length : pos;
    let currency = value.currency;
    const names2 = Object.keys(spec.alt_unit_names);
    let FRAC_POS_NEW_POSITION = originalPosition;
    if (names2.length > 0) {
      let unitIndex = "0";
      names2.forEach((index) => {
        const i5 = Number.parseInt(index, 10);
        if (Number.isNaN(i5))
          return;
        if (originalPosition - i5 <= 0)
          return;
        if (originalPosition - i5 < FRAC_POS_NEW_POSITION) {
          FRAC_POS_NEW_POSITION = originalPosition - i5;
          unitIndex = index;
        }
      });
      currency = spec.alt_unit_names[unitIndex];
    }
    if (originalPosition === FRAC_POS_NEW_POSITION) {
      const { normal: normal2, small: small2 } = splitNormalAndSmall(strValue, originalPosition, spec);
      return { currency, normal: normal2, small: small2 };
    }
    const intPart = strValue.substring(0, originalPosition);
    const fracPArt = strValue.substring(originalPosition + 1);
    const newValue = intPart.substring(0, FRAC_POS_NEW_POSITION) + FRAC_SEPARATOR + intPart.substring(FRAC_POS_NEW_POSITION) + fracPArt;
    const { normal, small } = splitNormalAndSmall(newValue, FRAC_POS_NEW_POSITION, spec);
    return { currency, normal, small };
  }
};
function splitNormalAndSmall(decimal, fracSeparatorIndex, spec) {
  let normal;
  let small;
  if (decimal.length - fracSeparatorIndex - 1 > spec.num_fractional_normal_digits) {
    const limit = fracSeparatorIndex + spec.num_fractional_normal_digits + 1;
    normal = decimal.substring(0, limit);
    small = decimal.substring(limit);
  } else {
    normal = decimal;
    small = void 0;
  }
  return { normal, small };
}

// ../taler-util/lib/http-impl.missing.js
var HttpLibImpl = class {
  fetch(url, opt) {
    throw new Error("Method not implemented.");
  }
};

// ../taler-util/lib/http.js
function createPlatformHttpLib(args) {
  return new HttpLibImpl(args);
}

// ../taler-util/lib/bank-api-client.js
var logger3 = new Logger("bank-api-client.ts");
var CreditDebitIndicator;
(function(CreditDebitIndicator2) {
  CreditDebitIndicator2["Credit"] = "credit";
  CreditDebitIndicator2["Debit"] = "debit";
})(CreditDebitIndicator || (CreditDebitIndicator = {}));

// ../taler-util/lib/base64.js
function base64FromArrayBuffer(arrayBuffer) {
  var base64 = "";
  var encodings = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  var bytes = new Uint8Array(arrayBuffer);
  var byteLength = bytes.byteLength;
  var byteRemainder = byteLength % 3;
  var mainLength = byteLength - byteRemainder;
  var a6, b5, c5, d6;
  var chunk;
  for (var i5 = 0; i5 < mainLength; i5 = i5 + 3) {
    chunk = bytes[i5] << 16 | bytes[i5 + 1] << 8 | bytes[i5 + 2];
    a6 = (chunk & 16515072) >> 18;
    b5 = (chunk & 258048) >> 12;
    c5 = (chunk & 4032) >> 6;
    d6 = chunk & 63;
    base64 += encodings[a6] + encodings[b5] + encodings[c5] + encodings[d6];
  }
  if (byteRemainder == 1) {
    chunk = bytes[mainLength];
    a6 = (chunk & 252) >> 2;
    b5 = (chunk & 3) << 4;
    base64 += encodings[a6] + encodings[b5] + "==";
  } else if (byteRemainder == 2) {
    chunk = bytes[mainLength] << 8 | bytes[mainLength + 1];
    a6 = (chunk & 64512) >> 10;
    b5 = (chunk & 1008) >> 4;
    c5 = (chunk & 15) << 2;
    base64 += encodings[a6] + encodings[b5] + encodings[c5] + "=";
  }
  return base64;
}

// ../taler-util/lib/bech32.js
var CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
var GENERATOR = [996825010, 642813549, 513874426, 1027748829, 705979059];
function polymod(values) {
  var chk = 1;
  for (var p4 = 0; p4 < values.length; ++p4) {
    var top = chk >> 25;
    chk = (chk & 33554431) << 5 ^ values[p4];
    for (var i5 = 0; i5 < 5; ++i5) {
      if (top >> i5 & 1) {
        chk ^= GENERATOR[i5];
      }
    }
  }
  return chk;
}
function hrpExpand(hrp) {
  const ret = [];
  for (let p4 = 0; p4 < hrp.length; ++p4) {
    ret.push(hrp.charCodeAt(p4) >> 5);
  }
  ret.push(0);
  for (let p4 = 0; p4 < hrp.length; ++p4) {
    ret.push(hrp.charCodeAt(p4) & 31);
  }
  return ret;
}
function getEncodingConst(enc) {
  switch (enc) {
    case BitcoinBech32.Encodings.BECH32:
      return 1;
    case BitcoinBech32.Encodings.BECH32M:
      return 734539939;
    default: {
      assertUnreachable(enc);
    }
  }
}
function verifyChecksum(hrp, data, enc) {
  return polymod(hrpExpand(hrp).concat(data)) === getEncodingConst(enc);
}
function createChecksum(hrp, data, enc) {
  const values = hrpExpand(hrp).concat(data).concat([0, 0, 0, 0, 0, 0]);
  const mod = polymod(values) ^ getEncodingConst(enc);
  const ret = [];
  for (let p4 = 0; p4 < 6; ++p4) {
    ret.push(mod >> 5 * (5 - p4) & 31);
  }
  return ret;
}
var BitcoinBech32;
(function(BitcoinBech322) {
  let Encodings;
  (function(Encodings2) {
    Encodings2["BECH32"] = "bech32";
    Encodings2["BECH32M"] = "bech32m";
  })(Encodings = BitcoinBech322.Encodings || (BitcoinBech322.Encodings = {}));
  ;
  function encode2(hrp, data, enc) {
    var combined = data.concat(createChecksum(hrp, data, enc));
    var ret = hrp + "1";
    for (var p4 = 0; p4 < combined.length; ++p4) {
      ret += CHARSET.charAt(combined[p4]);
    }
    return ret;
  }
  BitcoinBech322.encode = encode2;
  let BitcoinParseError;
  (function(BitcoinParseError2) {
    BitcoinParseError2[BitcoinParseError2["WRONG_CHARSET"] = 0] = "WRONG_CHARSET";
    BitcoinParseError2[BitcoinParseError2["MIXING_UPPER_AND_LOWER"] = 1] = "MIXING_UPPER_AND_LOWER";
    BitcoinParseError2[BitcoinParseError2["MISSING_HRP"] = 2] = "MISSING_HRP";
    BitcoinParseError2[BitcoinParseError2["TOO_LONG"] = 3] = "TOO_LONG";
    BitcoinParseError2[BitcoinParseError2["TOO_SHORT"] = 4] = "TOO_SHORT";
    BitcoinParseError2[BitcoinParseError2["WRONG_CHECKSUM"] = 5] = "WRONG_CHECKSUM";
  })(BitcoinParseError = BitcoinBech322.BitcoinParseError || (BitcoinBech322.BitcoinParseError = {}));
  function decode2(bechString, enc) {
    let p4;
    let has_lower = false;
    let has_upper = false;
    for (p4 = 0; p4 < bechString.length; ++p4) {
      if (bechString.charCodeAt(p4) < 33 || bechString.charCodeAt(p4) > 126) {
        return opKnownFailure(BitcoinParseError.WRONG_CHARSET);
      }
      if (bechString.charCodeAt(p4) >= 97 && bechString.charCodeAt(p4) <= 122) {
        has_lower = true;
      }
      if (bechString.charCodeAt(p4) >= 65 && bechString.charCodeAt(p4) <= 90) {
        has_upper = true;
      }
    }
    if (has_lower && has_upper) {
      return opKnownFailure(BitcoinParseError.MIXING_UPPER_AND_LOWER);
    }
    bechString = bechString.toLowerCase();
    const pos = bechString.lastIndexOf("1");
    if (pos < 1) {
      return opKnownFailure(BitcoinParseError.MISSING_HRP);
    }
    if (pos + 7 > bechString.length) {
      return opKnownFailure(BitcoinParseError.TOO_SHORT);
    }
    if (bechString.length > 90) {
      return opKnownFailure(BitcoinParseError.TOO_LONG);
    }
    const hrp = bechString.substring(0, pos);
    var data = [];
    for (p4 = pos + 1; p4 < bechString.length; ++p4) {
      var d6 = CHARSET.indexOf(bechString.charAt(p4));
      if (d6 === -1) {
        return opKnownFailure(BitcoinParseError.WRONG_CHARSET);
      }
      data.push(d6);
    }
    if (enc && !verifyChecksum(hrp, data, enc)) {
      return opKnownFailure(BitcoinParseError.WRONG_CHECKSUM);
    }
    return opFixedSuccess({ hrp, data: data.slice(0, data.length - 6) });
  }
  BitcoinBech322.decode = decode2;
})(BitcoinBech32 || (BitcoinBech32 = {}));

// ../taler-util/lib/segwit_addr.js
function convertbits(data, frombits, tobits, pad) {
  let acc = 0;
  let bits = 0;
  const ret = [];
  const maxv = (1 << tobits) - 1;
  for (let p4 = 0; p4 < data.length; ++p4) {
    const value = data[p4];
    if (value < 0 || value >> frombits !== 0) {
      return null;
    }
    acc = acc << frombits | value;
    bits += frombits;
    while (bits >= tobits) {
      bits -= tobits;
      ret.push(acc >> bits & maxv);
    }
  }
  if (pad) {
    if (bits > 0) {
      ret.push(acc << tobits - bits & maxv);
    }
  } else if (bits >= frombits || acc << tobits - bits & maxv) {
    return null;
  }
  return ret;
}
var BitcoinSewgit;
(function(BitcoinSewgit2) {
  let BitcoinSewgitParseError;
  (function(BitcoinSewgitParseError2) {
    BitcoinSewgitParseError2["INVALID_DATA"] = "invalid-data";
    BitcoinSewgitParseError2["DECODING_PROBLEM"] = "decoding-problem";
  })(BitcoinSewgitParseError = BitcoinSewgit2.BitcoinSewgitParseError || (BitcoinSewgit2.BitcoinSewgitParseError = {}));
  function decode2(addr, enc) {
    const decResp = BitcoinBech32.decode(addr, enc);
    if (decResp.type === "fail") {
      return decResp;
    }
    const { body: dec } = decResp;
    if (dec.data.length < 1 || dec.data[0] > 16) {
      return opKnownFailure(BitcoinSewgitParseError.INVALID_DATA);
    }
    const res = convertbits(dec.data.slice(1), 5, 8, false);
    if (res === null || res.length < 2 || res.length > 40) {
      return opKnownFailure(BitcoinSewgitParseError.DECODING_PROBLEM);
    }
    if (dec.data[0] === 0 && res.length !== 20 && res.length !== 32) {
      return opKnownFailure(BitcoinSewgitParseError.DECODING_PROBLEM);
    }
    if (dec.data[0] === 0 && enc === BitcoinBech32.Encodings.BECH32) {
      return opKnownFailure(BitcoinSewgitParseError.DECODING_PROBLEM);
    }
    if (dec.data[0] !== 0 && enc === BitcoinBech32.Encodings.BECH32M) {
      return opKnownFailure(BitcoinSewgitParseError.DECODING_PROBLEM);
    }
    return opFixedSuccess({ version: dec.data[0], program: res });
  }
  BitcoinSewgit2.decode = decode2;
  function encode2(hrp, version, program) {
    const enc = version > 0 ? BitcoinBech32.Encodings.BECH32M : BitcoinBech32.Encodings.BECH32;
    const bits = convertbits(program, 8, 5, true);
    if (!bits) {
      return opKnownFailure(BitcoinSewgitParseError.INVALID_DATA);
    }
    const ret = BitcoinBech32.encode(hrp, [version].concat(bits), enc);
    return opFixedSuccess(ret);
  }
  BitcoinSewgit2.encode = encode2;
})(BitcoinSewgit || (BitcoinSewgit = {}));

// ../taler-util/lib/bitcoin.js
var GenerateSegwitAddrError;
(function(GenerateSegwitAddrError2) {
  GenerateSegwitAddrError2["WRONG_RESERVE_PUB"] = "wrong-reserve-pub";
  GenerateSegwitAddrError2["WRONG_PREFIX"] = "wrong-prefix";
  GenerateSegwitAddrError2["INVALID_SEGWIT"] = "invalid-segwit";
})(GenerateSegwitAddrError || (GenerateSegwitAddrError = {}));
function generateFakeSegwitAddress(pub, addr) {
  const first_rnd = new Uint8Array(4);
  first_rnd.set(pub.subarray(0, 4));
  const second_rnd = new Uint8Array(4);
  second_rnd.set(pub.subarray(0, 4));
  first_rnd[0] = first_rnd[0] & 127;
  second_rnd[0] = second_rnd[0] | 128;
  const first_part = new Uint8Array(first_rnd.length + pub.length / 2);
  first_part.set(first_rnd, 0);
  first_part.set(pub.subarray(0, 16), 4);
  const second_part = new Uint8Array(first_rnd.length + pub.length / 2);
  second_part.set(second_rnd, 0);
  second_part.set(pub.subarray(16, 32), 4);
  const prefix = addr[0] === "t" && addr[1] == "b" ? "tb" : addr[0] === "b" && addr[1] == "c" && addr[2] === "r" && addr[3] == "t" ? "bcrt" : addr[0] === "b" && addr[1] == "c" ? "bc" : void 0;
  if (prefix === void 0) {
    return opKnownFailure(GenerateSegwitAddrError.WRONG_PREFIX);
  }
  const addr1 = BitcoinSewgit.encode(prefix, 0, Array.from(first_part));
  if (addr1.type === "fail") {
    return opKnownFailure(GenerateSegwitAddrError.INVALID_SEGWIT);
  }
  const addr2 = BitcoinSewgit.encode(prefix, 0, Array.from(second_part));
  if (addr2.type === "fail") {
    return opKnownFailure(GenerateSegwitAddrError.INVALID_SEGWIT);
  }
  const result = [addr1.body, addr2.body];
  return opFixedSuccess(result);
}

// ../taler-util/lib/CancellationToken.js
var NOOP = () => {
};
var CancellationToken = class _CancellationToken {
  /**
   * Whether the token has been cancelled.
   */
  get isCancelled() {
    return this._isCancelled;
  }
  /**
   * Whether the token can be cancelled.
   */
  get canBeCancelled() {
    return this._canBeCancelled;
  }
  /**
   * Why this token has been cancelled.
   */
  get reason() {
    if (this.isCancelled) {
      return this._reason;
    } else {
      throw new Error("This token is not cancelled.");
    }
  }
  /**
   * Make a promise that resolves when the async operation resolves,
   * or rejects when the operation is rejected or this token is cancelled.
   */
  racePromise(asyncOperation) {
    if (!this.canBeCancelled) {
      return asyncOperation;
    }
    return new Promise((resolve, reject) => {
      const unregister = this.onCancelled((reason) => reject(new _CancellationToken.CancellationError(reason)));
      asyncOperation.then((value) => {
        resolve(value);
        unregister();
      }, (err) => {
        reject(err);
        unregister();
      });
    });
  }
  /**
   * Throw a {CancellationToken.CancellationError} if this token is cancelled.
   */
  throwIfCancelled() {
    if (this._isCancelled) {
      throw new _CancellationToken.CancellationError(this._reason);
    }
  }
  /**
   * Invoke the callback when this token is cancelled.
   * If this token is already cancelled, the callback is invoked immediately.
   * Returns a function that unregisters the cancellation callback.
   */
  onCancelled(cb) {
    if (!this.canBeCancelled) {
      return NOOP;
    }
    if (this.isCancelled) {
      cb(this.reason);
      return NOOP;
    }
    this._callbacks?.add(cb);
    return () => this._callbacks?.delete(cb);
  }
  constructor(_isCancelled, _canBeCancelled) {
    this._isCancelled = _isCancelled;
    this._canBeCancelled = _canBeCancelled;
    this._callbacks = /* @__PURE__ */ new Set();
  }
  /**
   * Create a {CancellationTokenSource}.
   */
  static create() {
    const token = new _CancellationToken(false, true);
    const cancel = (reason) => {
      if (token._isCancelled)
        return;
      token._isCancelled = true;
      token._reason = reason;
      token._callbacks?.forEach((cb) => cb(reason));
      dispose();
    };
    const dispose = () => {
      token._canBeCancelled = token.isCancelled;
      delete token._callbacks;
    };
    return { token, cancel, dispose };
  }
  /**
   * Create a {CancellationTokenSource}.
   * The token will be cancelled automatically after the specified timeout in milliseconds.
   */
  static timeout(ms) {
    const { token, cancel: originalCancel, dispose: originalDispose } = _CancellationToken.create();
    let timer2;
    timer2 = setTimeout(() => originalCancel(`CancellationToken.timeout ${ms}`), ms);
    const disposeTimer = () => {
      if (timer2 == null)
        return;
      clearTimeout(timer2);
      timer2 = null;
    };
    const cancel = (reason) => {
      disposeTimer();
      originalCancel(reason);
    };
    const dispose = () => {
      disposeTimer();
      originalDispose();
    };
    return { token, cancel, dispose };
  }
  /**
   * Create a {CancellationToken} that is cancelled when all of the given tokens are cancelled.
   *
   * This is like {Promise<T>.all} for {CancellationToken}s.
   */
  static all(...tokens) {
    if (tokens.some((token) => !token.canBeCancelled)) {
      return _CancellationToken.CONTINUE;
    }
    const combined = _CancellationToken.create();
    let countdown = tokens.length;
    const handleNextTokenCancelled = () => {
      if (--countdown === 0) {
        const reasons = tokens.map((token) => token._reason);
        combined.cancel(reasons);
      }
    };
    tokens.forEach((token) => token.onCancelled(handleNextTokenCancelled));
    return combined.token;
  }
  /**
   * Create a {CancellationToken} that is cancelled when at least one of the given tokens is cancelled.
   *
   * This is like {Promise<T>.race} for {CancellationToken}s.
   */
  static race(...tokens) {
    for (const token of tokens) {
      if (token._isCancelled) {
        return token;
      }
    }
    const combined = _CancellationToken.create();
    let unregistrations;
    const handleAnyTokenCancelled = (reason) => {
      unregistrations.forEach((unregister) => unregister());
      combined.cancel(reason);
    };
    unregistrations = tokens.map((token) => token.onCancelled(handleAnyTokenCancelled));
    return combined.token;
  }
};
CancellationToken.CANCELLED = new CancellationToken(true, true);
CancellationToken.CONTINUE = new CancellationToken(false, false);
(function(CancellationToken2) {
  class CancellationError extends Error {
    constructor(reason) {
      super("Operation cancelled");
      this.reason = reason;
      Object.setPrototypeOf(this, CancellationError.prototype);
    }
  }
  CancellationToken2.CancellationError = CancellationError;
})(CancellationToken || (CancellationToken = {}));

// ../taler-util/lib/taler-crypto.js
var import_big_integer = __toESM(require_BigInteger(), 1);

// ../taler-util/lib/sha256.js
var digestLength = 32;
var blockSize = 64;
var K2 = new Uint32Array([
  1116352408,
  1899447441,
  3049323471,
  3921009573,
  961987163,
  1508970993,
  2453635748,
  2870763221,
  3624381080,
  310598401,
  607225278,
  1426881987,
  1925078388,
  2162078206,
  2614888103,
  3248222580,
  3835390401,
  4022224774,
  264347078,
  604807628,
  770255983,
  1249150122,
  1555081692,
  1996064986,
  2554220882,
  2821834349,
  2952996808,
  3210313671,
  3336571891,
  3584528711,
  113926993,
  338241895,
  666307205,
  773529912,
  1294757372,
  1396182291,
  1695183700,
  1986661051,
  2177026350,
  2456956037,
  2730485921,
  2820302411,
  3259730800,
  3345764771,
  3516065817,
  3600352804,
  4094571909,
  275423344,
  430227734,
  506948616,
  659060556,
  883997877,
  958139571,
  1322822218,
  1537002063,
  1747873779,
  1955562222,
  2024104815,
  2227730452,
  2361852424,
  2428436474,
  2756734187,
  3204031479,
  3329325298
]);
function hashBlocks(w6, v3, p4, pos, len) {
  let a6, b5, c5, d6, e5, f3, g4, h5, u5, i5, j4, t1, t22;
  while (len >= 64) {
    a6 = v3[0];
    b5 = v3[1];
    c5 = v3[2];
    d6 = v3[3];
    e5 = v3[4];
    f3 = v3[5];
    g4 = v3[6];
    h5 = v3[7];
    for (i5 = 0; i5 < 16; i5++) {
      j4 = pos + i5 * 4;
      w6[i5] = (p4[j4] & 255) << 24 | (p4[j4 + 1] & 255) << 16 | (p4[j4 + 2] & 255) << 8 | p4[j4 + 3] & 255;
    }
    for (i5 = 16; i5 < 64; i5++) {
      u5 = w6[i5 - 2];
      t1 = (u5 >>> 17 | u5 << 32 - 17) ^ (u5 >>> 19 | u5 << 32 - 19) ^ u5 >>> 10;
      u5 = w6[i5 - 15];
      t22 = (u5 >>> 7 | u5 << 32 - 7) ^ (u5 >>> 18 | u5 << 32 - 18) ^ u5 >>> 3;
      w6[i5] = (t1 + w6[i5 - 7] | 0) + (t22 + w6[i5 - 16] | 0);
    }
    for (i5 = 0; i5 < 64; i5++) {
      t1 = (((e5 >>> 6 | e5 << 32 - 6) ^ (e5 >>> 11 | e5 << 32 - 11) ^ (e5 >>> 25 | e5 << 32 - 25)) + (e5 & f3 ^ ~e5 & g4) | 0) + (h5 + (K2[i5] + w6[i5] | 0) | 0) | 0;
      t22 = ((a6 >>> 2 | a6 << 32 - 2) ^ (a6 >>> 13 | a6 << 32 - 13) ^ (a6 >>> 22 | a6 << 32 - 22)) + (a6 & b5 ^ a6 & c5 ^ b5 & c5) | 0;
      h5 = g4;
      g4 = f3;
      f3 = e5;
      e5 = d6 + t1 | 0;
      d6 = c5;
      c5 = b5;
      b5 = a6;
      a6 = t1 + t22 | 0;
    }
    v3[0] += a6;
    v3[1] += b5;
    v3[2] += c5;
    v3[3] += d6;
    v3[4] += e5;
    v3[5] += f3;
    v3[6] += g4;
    v3[7] += h5;
    pos += 64;
    len -= 64;
  }
  return pos;
}
var HashSha256 = class {
  constructor() {
    this.digestLength = digestLength;
    this.blockSize = blockSize;
    this.state = new Int32Array(8);
    this.temp = new Int32Array(64);
    this.buffer = new Uint8Array(128);
    this.bufferLength = 0;
    this.bytesHashed = 0;
    this.finished = false;
    this.reset();
  }
  // Resets hash state making it possible
  // to reuse this instance to hash other data.
  reset() {
    this.state[0] = 1779033703;
    this.state[1] = 3144134277;
    this.state[2] = 1013904242;
    this.state[3] = 2773480762;
    this.state[4] = 1359893119;
    this.state[5] = 2600822924;
    this.state[6] = 528734635;
    this.state[7] = 1541459225;
    this.bufferLength = 0;
    this.bytesHashed = 0;
    this.finished = false;
    return this;
  }
  // Cleans internal buffers and re-initializes hash state.
  clean() {
    for (let i5 = 0; i5 < this.buffer.length; i5++) {
      this.buffer[i5] = 0;
    }
    for (let i5 = 0; i5 < this.temp.length; i5++) {
      this.temp[i5] = 0;
    }
    this.reset();
  }
  // Updates hash state with the given data.
  //
  // Optionally, length of the data can be specified to hash
  // fewer bytes than data.length.
  //
  // Throws error when trying to update already finalized hash:
  // instance must be reset to use it again.
  update(data, dataLength = data.length) {
    if (this.finished) {
      throw new Error("SHA256: can't update because hash was finished.");
    }
    let dataPos = 0;
    this.bytesHashed += dataLength;
    if (this.bufferLength > 0) {
      while (this.bufferLength < 64 && dataLength > 0) {
        this.buffer[this.bufferLength++] = data[dataPos++];
        dataLength--;
      }
      if (this.bufferLength === 64) {
        hashBlocks(this.temp, this.state, this.buffer, 0, 64);
        this.bufferLength = 0;
      }
    }
    if (dataLength >= 64) {
      dataPos = hashBlocks(this.temp, this.state, data, dataPos, dataLength);
      dataLength %= 64;
    }
    while (dataLength > 0) {
      this.buffer[this.bufferLength++] = data[dataPos++];
      dataLength--;
    }
    return this;
  }
  // Finalizes hash state and puts hash into out.
  //
  // If hash was already finalized, puts the same value.
  finish(out) {
    if (!this.finished) {
      const bytesHashed = this.bytesHashed;
      const left = this.bufferLength;
      const bitLenHi = bytesHashed / 536870912 | 0;
      const bitLenLo = bytesHashed << 3;
      const padLength = bytesHashed % 64 < 56 ? 64 : 128;
      this.buffer[left] = 128;
      for (let i5 = left + 1; i5 < padLength - 8; i5++) {
        this.buffer[i5] = 0;
      }
      this.buffer[padLength - 8] = bitLenHi >>> 24 & 255;
      this.buffer[padLength - 7] = bitLenHi >>> 16 & 255;
      this.buffer[padLength - 6] = bitLenHi >>> 8 & 255;
      this.buffer[padLength - 5] = bitLenHi >>> 0 & 255;
      this.buffer[padLength - 4] = bitLenLo >>> 24 & 255;
      this.buffer[padLength - 3] = bitLenLo >>> 16 & 255;
      this.buffer[padLength - 2] = bitLenLo >>> 8 & 255;
      this.buffer[padLength - 1] = bitLenLo >>> 0 & 255;
      hashBlocks(this.temp, this.state, this.buffer, 0, padLength);
      this.finished = true;
    }
    for (let i5 = 0; i5 < 8; i5++) {
      out[i5 * 4 + 0] = this.state[i5] >>> 24 & 255;
      out[i5 * 4 + 1] = this.state[i5] >>> 16 & 255;
      out[i5 * 4 + 2] = this.state[i5] >>> 8 & 255;
      out[i5 * 4 + 3] = this.state[i5] >>> 0 & 255;
    }
    return this;
  }
  // Returns the final hash digest.
  digest() {
    const out = new Uint8Array(this.digestLength);
    this.finish(out);
    return out;
  }
  // Internal function for use in HMAC for optimization.
  _saveState(out) {
    for (let i5 = 0; i5 < this.state.length; i5++) {
      out[i5] = this.state[i5];
    }
  }
  // Internal function for use in HMAC for optimization.
  _restoreState(from, bytesHashed) {
    for (let i5 = 0; i5 < this.state.length; i5++) {
      this.state[i5] = from[i5];
    }
    this.bytesHashed = bytesHashed;
    this.finished = false;
    this.bufferLength = 0;
  }
};
function sha256(data) {
  const h5 = new HashSha256().update(data);
  const digest = h5.digest();
  h5.clean();
  return digest;
}

// ../taler-util/lib/kdf.js
function sha512(data) {
  return hash(data);
}
function hmac(digest, blockSize2, key, message) {
  if (key.byteLength > blockSize2) {
    key = digest(key);
  }
  if (key.byteLength < blockSize2) {
    const k6 = key;
    key = new Uint8Array(blockSize2);
    key.set(k6, 0);
  }
  const okp = new Uint8Array(blockSize2);
  const ikp = new Uint8Array(blockSize2);
  for (let i5 = 0; i5 < blockSize2; i5++) {
    ikp[i5] = key[i5] ^ 54;
    okp[i5] = key[i5] ^ 92;
  }
  const b1 = new Uint8Array(blockSize2 + message.byteLength);
  b1.set(ikp, 0);
  b1.set(message, blockSize2);
  const h0 = digest(b1);
  const b22 = new Uint8Array(blockSize2 + h0.length);
  b22.set(okp, 0);
  b22.set(h0, blockSize2);
  return digest(b22);
}
function hmacSha512(key, message) {
  return hmac(sha512, 128, key, message);
}
function hmacSha256(key, message) {
  return hmac(sha256, 64, key, message);
}

// ../taler-util/lib/iban.js
var ParseIbanError;
(function(ParseIbanError2) {
  ParseIbanError2[ParseIbanError2["UNSUPPORTED_COUNTRY"] = 0] = "UNSUPPORTED_COUNTRY";
  ParseIbanError2[ParseIbanError2["TOO_LONG"] = 1] = "TOO_LONG";
  ParseIbanError2[ParseIbanError2["TOO_SHORT"] = 2] = "TOO_SHORT";
  ParseIbanError2[ParseIbanError2["INVALID_CHARSET"] = 3] = "INVALID_CHARSET";
  ParseIbanError2[ParseIbanError2["INVALID_CHECKSUM"] = 4] = "INVALID_CHECKSUM";
})(ParseIbanError || (ParseIbanError = {}));
var ccZero = "0".charCodeAt(0);
var ccNine = "9".charCodeAt(0);
var ccA = "A".charCodeAt(0);
var ccZ = "Z".charCodeAt(0);
function appendDigit(digits, cc) {
  if (cc >= ccZero && cc <= ccNine) {
    digits.push(cc - ccZero);
  } else if (cc >= ccA && cc <= ccZ) {
    const n2 = cc - ccA + 10;
    digits.push(Math.floor(n2 / 10) % 10);
    digits.push(n2 % 10);
  } else {
    return false;
  }
  return true;
}
function mod97(digits) {
  let i5 = 0;
  let modAccum = 0;
  while (i5 < digits.length) {
    let n2 = 0;
    while (n2 < 9 && i5 < digits.length) {
      modAccum = modAccum * 10 + digits[i5];
      i5++;
      n2++;
    }
    modAccum = modAccum % 97;
  }
  return modAccum;
}
function parseIban(ibanString) {
  if (ibanString.length < 4) {
    return opKnownFailure(ParseIbanError.TOO_SHORT);
  }
  if (ibanString.length > 34) {
    return opKnownFailure(ParseIbanError.TOO_LONG);
  }
  const myIban = ibanString.toUpperCase().replace(/[\s-\._]/g, "");
  const countryCode = myIban.substring(0, 2);
  const countryInfo = ibanCountryInfoTable[countryCode];
  if (!countryInfo) {
    return opKnownFailure(ParseIbanError.UNSUPPORTED_COUNTRY);
  }
  let digits = [];
  for (let i5 = 4; i5 < myIban.length; i5++) {
    const cc = myIban.charCodeAt(i5);
    if (!appendDigit(digits, cc)) {
      return opKnownFailure(ParseIbanError.INVALID_CHARSET);
    }
  }
  for (let i5 = 0; i5 < 4; i5++) {
    const cc = myIban.charCodeAt(i5);
    if (!appendDigit(digits, cc)) {
      return opKnownFailure(ParseIbanError.INVALID_CHARSET);
    }
  }
  const rem = mod97(digits);
  if (rem === 1) {
    return opFixedSuccess(myIban);
  } else {
    return opKnownFailure(ParseIbanError.INVALID_CHECKSUM);
  }
}
var ibanCountryInfoTable = {
  AE: { name: "U.A.E." },
  AF: { name: "Afghanistan" },
  AL: { name: "Albania" },
  AM: { name: "Armenia" },
  AN: { name: "Netherlands Antilles" },
  AR: { name: "Argentina" },
  AT: { name: "Austria" },
  AU: { name: "Australia" },
  AZ: { name: "Azerbaijan" },
  BA: { name: "Bosnia and Herzegovina" },
  BD: { name: "Bangladesh" },
  BE: { name: "Belgium" },
  BG: { name: "Bulgaria" },
  BH: { name: "Bahrain" },
  BN: { name: "Brunei Darussalam" },
  BO: { name: "Bolivia" },
  BR: { name: "Brazil" },
  BT: { name: "Bhutan" },
  BY: { name: "Belarus" },
  BZ: { name: "Belize" },
  CA: { name: "Canada" },
  CG: { name: "Congo" },
  CH: { name: "Switzerland" },
  CI: { name: "Cote d'Ivoire" },
  CL: { name: "Chile" },
  CM: { name: "Cameroon" },
  CN: { name: "People's Republic of China" },
  CO: { name: "Colombia" },
  CR: { name: "Costa Rica" },
  CS: { name: "Serbia and Montenegro" },
  CZ: { name: "Czech Republic" },
  DE: { name: "Germany" },
  DK: { name: "Denmark" },
  DO: { name: "Dominican Republic" },
  DZ: { name: "Algeria" },
  EC: { name: "Ecuador" },
  EE: { name: "Estonia" },
  EG: { name: "Egypt" },
  ER: { name: "Eritrea" },
  ES: { name: "Spain" },
  ET: { name: "Ethiopia" },
  FI: { name: "Finland" },
  FO: { name: "Faroe Islands" },
  FR: { name: "France" },
  GB: { name: "United Kingdom" },
  GD: { name: "Caribbean" },
  GE: { name: "Georgia" },
  GL: { name: "Greenland" },
  GR: { name: "Greece" },
  GT: { name: "Guatemala" },
  HK: { name: "Hong Kong S.A.R." },
  HN: { name: "Honduras" },
  HR: { name: "Croatia" },
  HT: { name: "Haiti" },
  HU: { name: "Hungary" },
  ID: { name: "Indonesia" },
  IE: { name: "Ireland" },
  IL: { name: "Israel" },
  IN: { name: "India" },
  IQ: { name: "Iraq" },
  IR: { name: "Iran" },
  IS: { name: "Iceland" },
  IT: { name: "Italy" },
  JM: { name: "Jamaica" },
  JO: { name: "Jordan" },
  JP: { name: "Japan" },
  KE: { name: "Kenya" },
  KG: { name: "Kyrgyzstan" },
  KH: { name: "Cambodia" },
  KR: { name: "South Korea" },
  KW: { name: "Kuwait" },
  KZ: { name: "Kazakhstan" },
  LA: { name: "Laos" },
  LB: { name: "Lebanon" },
  LI: { name: "Liechtenstein" },
  LK: { name: "Sri Lanka" },
  LT: { name: "Lithuania" },
  LU: { name: "Luxembourg" },
  LV: { name: "Latvia" },
  LY: { name: "Libya" },
  MA: { name: "Morocco" },
  MC: { name: "Principality of Monaco" },
  MD: { name: "Moldava" },
  ME: { name: "Montenegro" },
  MK: { name: "Former Yugoslav Republic of Macedonia" },
  ML: { name: "Mali" },
  MM: { name: "Myanmar" },
  MN: { name: "Mongolia" },
  MO: { name: "Macau S.A.R." },
  MT: { name: "Malta" },
  MV: { name: "Maldives" },
  MX: { name: "Mexico" },
  MY: { name: "Malaysia" },
  NG: { name: "Nigeria" },
  NI: { name: "Nicaragua" },
  NL: { name: "Netherlands" },
  NO: { name: "Norway" },
  NP: { name: "Nepal" },
  NZ: { name: "New Zealand" },
  OM: { name: "Oman" },
  PA: { name: "Panama" },
  PE: { name: "Peru" },
  PH: { name: "Philippines" },
  PK: { name: "Islamic Republic of Pakistan" },
  PL: { name: "Poland" },
  PR: { name: "Puerto Rico" },
  PT: { name: "Portugal" },
  PY: { name: "Paraguay" },
  QA: { name: "Qatar" },
  RE: { name: "Reunion" },
  RO: { name: "Romania" },
  RS: { name: "Serbia" },
  RU: { name: "Russia" },
  RW: { name: "Rwanda" },
  SA: { name: "Saudi Arabia" },
  SE: { name: "Sweden" },
  SG: { name: "Singapore" },
  SI: { name: "Slovenia" },
  SK: { name: "Slovak" },
  SN: { name: "Senegal" },
  SO: { name: "Somalia" },
  SR: { name: "Suriname" },
  SV: { name: "El Salvador" },
  SY: { name: "Syria" },
  TH: { name: "Thailand" },
  TJ: { name: "Tajikistan" },
  TM: { name: "Turkmenistan" },
  TN: { name: "Tunisia" },
  TR: { name: "Turkey" },
  TT: { name: "Trinidad and Tobago" },
  TW: { name: "Taiwan" },
  TZ: { name: "Tanzania" },
  UA: { name: "Ukraine" },
  US: { name: "United States" },
  UY: { name: "Uruguay" },
  VA: { name: "Vatican" },
  VE: { name: "Venezuela" },
  VN: { name: "Viet Nam" },
  YE: { name: "Yemen" },
  ZA: { name: "South Africa" },
  ZW: { name: "Zimbabwe" }
};

// ../taler-util/lib/payto.js
var PAYTO_PREFIX = "payto://";
var PaytoType;
(function(PaytoType2) {
  PaytoType2["IBAN"] = "iban";
  PaytoType2["Bitcoin"] = "bitcoin";
  PaytoType2["TalerBank"] = "x-taler-bank";
  PaytoType2["TalerReserve"] = "taler-reserve";
  PaytoType2["TalerReserveHttp"] = "taler-reserve-http";
  PaytoType2["Ethereum"] = "ethereum";
})(PaytoType || (PaytoType = {}));
var ReservePubParseError;
(function(ReservePubParseError2) {
  ReservePubParseError2[ReservePubParseError2["WRONG_LENGTH"] = 0] = "WRONG_LENGTH";
  ReservePubParseError2[ReservePubParseError2["DECODE_ERROR"] = 1] = "DECODE_ERROR";
})(ReservePubParseError || (ReservePubParseError = {}));
var PaytoParseError;
(function(PaytoParseError2) {
  PaytoParseError2[PaytoParseError2["WRONG_PREFIX"] = 0] = "WRONG_PREFIX";
  PaytoParseError2[PaytoParseError2["INCOMPLETE"] = 1] = "INCOMPLETE";
  PaytoParseError2[PaytoParseError2["UNSUPPORTED"] = 2] = "UNSUPPORTED";
  PaytoParseError2[PaytoParseError2["COMPONENTS_LENGTH"] = 3] = "COMPONENTS_LENGTH";
  PaytoParseError2[PaytoParseError2["INVALID_TARGET_PATH"] = 4] = "INVALID_TARGET_PATH";
})(PaytoParseError || (PaytoParseError = {}));
var Paytos;
(function(Paytos2) {
  const supported_targets = {
    iban: true,
    bitcoin: true,
    "x-taler-bank": true,
    "taler-reserve": true,
    "taler-reserve-http": true,
    ethereum: true
  };
  function hash4(p4) {
    return hashTruncate32(stringToBytes(p4 + "\0"));
  }
  Paytos2.hash = hash4;
  function toNormalizedString(p4) {
    const url = new URL(`${PAYTO_PREFIX}${p4.targetType}/${p4.normalizedPath}`);
    return url.href;
  }
  Paytos2.toNormalizedString = toNormalizedString;
  function toFullString(p4) {
    const url = new URL(`${PAYTO_PREFIX}${p4.targetType}/${p4.fullPath}`);
    const paramList = !p4.params ? [] : Object.entries(p4.params);
    url.search = createSearchParams(paramList);
    return url.href;
  }
  Paytos2.toFullString = toFullString;
  function parseReservePub(reserve) {
    if (!reserve)
      return opKnownFailure(ReservePubParseError.WRONG_LENGTH);
    try {
      const pub = decodeCrock(reserve);
      if (!pub || pub.length !== 32) {
        return opKnownFailure(ReservePubParseError.WRONG_LENGTH);
      }
      return opFixedSuccess(pub);
    } catch (e5) {
      return opKnownFailureWithBody(ReservePubParseError.DECODE_ERROR, {
        message: String(e5)
      });
    }
  }
  Paytos2.parseReservePub = parseReservePub;
  function parseHostPortPath2(hostname, path, scheme = "https") {
    try {
      if (path === void 0) {
        path = "";
      }
      if (!path.endsWith("/")) {
        path = path + "/";
      }
      const url = new URL(path, `${scheme}://${hostname.toLowerCase()}`);
      url.search = "";
      url.password = "";
      url.username = "";
      url.hash = "";
      return url.href;
    } catch (e5) {
      console.log(e5);
      return void 0;
    }
  }
  Paytos2.parseHostPortPath2 = parseHostPortPath2;
  function withoutScheme(h5) {
    return h5.startsWith("http://") ? h5.substring(7) : h5.startsWith("https://") ? h5.substring(8) : h5;
  }
  function parseHostPortPath(hostnameAndPath) {
    const [host, path] = hostnameAndPath.split("/", 1);
    return parseHostPortPath2(host, path ?? "");
  }
  Paytos2.parseHostPortPath = parseHostPortPath;
  function parseEthereumAddress(str) {
    if (!str) {
      return void 0;
    }
    return str;
  }
  Paytos2.parseEthereumAddress = parseEthereumAddress;
  function parseTalerBankAccount(account) {
    if (!account) {
      return void 0;
    }
    return account;
  }
  Paytos2.parseTalerBankAccount = parseTalerBankAccount;
  function createUnsupported(targetType, path, params = {}) {
    return {
      targetType: void 0,
      target: targetType,
      params,
      normalizedPath: path.toLocaleLowerCase(),
      fullPath: path,
      displayName: path
    };
  }
  Paytos2.createUnsupported = createUnsupported;
  function createIban(iban, bic, params = {}) {
    iban = iban.toUpperCase();
    return {
      targetType: PaytoType.IBAN,
      iban,
      bic,
      params,
      normalizedPath: iban,
      fullPath: !bic ? iban : `${bic}/${iban}`,
      displayName: iban
    };
  }
  Paytos2.createIban = createIban;
  function createBitcoin(address, reservePub, params = {}) {
    const sgRes = !reservePub ? void 0 : generateFakeSegwitAddress(reservePub, address);
    const segwitAddrs = !sgRes || sgRes.type === "fail" ? [] : sgRes.body;
    return {
      targetType: PaytoType.Bitcoin,
      address,
      reservePub,
      segwitAddrs,
      params,
      normalizedPath: address.toLocaleLowerCase(),
      fullPath: !reservePub ? address : `${address}/${encodeCrock(reservePub)}`,
      displayName: address
    };
  }
  Paytos2.createBitcoin = createBitcoin;
  function createEthereum(address, params = {}) {
    return {
      targetType: PaytoType.Ethereum,
      address,
      params,
      normalizedPath: address,
      fullPath: address,
      displayName: address
    };
  }
  Paytos2.createEthereum = createEthereum;
  function createTalerReserve(exchange, reservePub, params = {}) {
    const path = withoutScheme(exchange);
    const pub = encodeCrock(reservePub);
    return {
      targetType: PaytoType.TalerReserve,
      exchange,
      reservePub,
      params,
      normalizedPath: `${path.toLocaleLowerCase()}${pub}`,
      fullPath: `${path}${pub}`,
      displayName: `${path}@${pub}`
    };
  }
  Paytos2.createTalerReserve = createTalerReserve;
  function createTalerReserveHttp(exchange, reservePub, params = {}) {
    const path = withoutScheme(exchange);
    const pub = encodeCrock(reservePub);
    return {
      targetType: PaytoType.TalerReserveHttp,
      exchange,
      reservePub,
      params,
      normalizedPath: `${path.toLocaleLowerCase()}${pub}`,
      fullPath: `${path}${pub}`,
      displayName: `${path}@${pub}`
    };
  }
  Paytos2.createTalerReserveHttp = createTalerReserveHttp;
  function createTalerBank(url, account, params = {}) {
    const path = withoutScheme(url);
    const host = path.endsWith("/") ? path.substring(0, path.length - 1) : path;
    return {
      targetType: PaytoType.TalerBank,
      host,
      url,
      account,
      params,
      normalizedPath: `${path.toLocaleLowerCase()}${account}`,
      fullPath: `${path}${account}`,
      displayName: `${account}@${url}`
    };
  }
  Paytos2.createTalerBank = createTalerBank;
  function asString(p4) {
    return succeedOrThrow(fromString(p4));
  }
  Paytos2.asString = asString;
  function fromString(s6, opts = {}) {
    if (!s6.startsWith(PAYTO_PREFIX)) {
      return opKnownFailure(PaytoParseError.WRONG_PREFIX);
    }
    const [acct, search] = s6.slice(PAYTO_PREFIX.length).split("?", 2);
    const firstSlashPos = acct.indexOf("/");
    const targetType = firstSlashPos === -1 ? acct : acct.slice(0, firstSlashPos);
    if (!opts.allowUnsupported && !supported_targets[targetType]) {
      const d6 = opKnownFailureWithBody(PaytoParseError.UNSUPPORTED, {
        targetType
      });
      return d6;
    }
    const targetPath = acct.slice(firstSlashPos + 1);
    if (firstSlashPos === -1 || !targetPath) {
      return opKnownFailureWithBody(PaytoParseError.INCOMPLETE, { targetType });
    }
    const params = {};
    if (search) {
      const searchParams = new URLSearchParams2(search);
      searchParams.forEach((v3, k6) => {
        params[k6] = v3;
      });
    }
    const cs = targetPath.split("/");
    switch (targetType) {
      case PaytoType.IBAN: {
        if (cs.length !== 1 && cs.length !== 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const bic = cs.length === 2 ? cs[0] : void 0;
        const iban = cs.length === 1 ? cs[0] : cs[1];
        const ibaRes = parseIban(iban);
        if (!opts.ignoreComponentError && ibaRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: ibaRes
          });
        }
        return opFixedSuccess(createIban(iban, bic, params));
      }
      case PaytoType.Bitcoin: {
        if (cs.length !== 1 && cs.length !== 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const address = cs[0].toLocaleLowerCase();
        const btRes = BitcoinBech32.decode(address, BitcoinBech32.Encodings.BECH32);
        if (!opts.ignoreComponentError && btRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: btRes
          });
        }
        const pubRes = cs.length === 1 ? void 0 : parseReservePub(cs[1]);
        if (!opts.ignoreComponentError && pubRes && pubRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 1,
            targetType,
            error: pubRes
          });
        }
        return opFixedSuccess(createBitcoin(address, pubRes && pubRes.type === "ok" ? pubRes.body : void 0, params));
      }
      case PaytoType.TalerBank: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const host = parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"));
        if (!opts.ignoreComponentError && !host) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: host
          });
        }
        const account = parseTalerBankAccount(cs[cs.length - 1]);
        if (!opts.ignoreComponentError && !account) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 1,
            targetType,
            error: account
          });
        }
        return opFixedSuccess(createTalerBank(host ?? cs[0], account ?? cs[1], params));
      }
      case PaytoType.TalerReserve: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const exchange = parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"));
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: exchange
          });
        }
        const reservePub = cs[cs.length - 1];
        const pubRes = parseReservePub(reservePub);
        if (!opts.ignoreComponentError && pubRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 1,
            targetType,
            error: pubRes
          });
        }
        return opFixedSuccess(createTalerReserve(exchange ?? cs[0], pubRes.type === "ok" ? pubRes.body : decodeCrock(reservePub), params));
      }
      case PaytoType.TalerReserveHttp: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const exchange = parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"), "http");
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: exchange
          });
        }
        const reservePub = cs[cs.length - 1];
        const pubRes = parseReservePub(reservePub);
        if (!opts.ignoreComponentError && pubRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 1,
            targetType,
            error: pubRes
          });
        }
        return opFixedSuccess(createTalerReserveHttp(exchange ?? cs[0], pubRes.type === "ok" ? pubRes.body : decodeCrock(reservePub), params));
      }
      case PaytoType.Ethereum: {
        if (cs.length !== 1) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const address = parseEthereumAddress(cs[0]);
        if (!opts.ignoreComponentError && !address) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: address
          });
        }
        return opFixedSuccess(createEthereum(address ?? cs[0], params));
      }
      default: {
        if (opts.allowUnsupported) {
          return opFixedSuccess(createUnsupported(targetType, targetPath, params));
        }
        assertUnreachable(targetType);
      }
    }
  }
  Paytos2.fromString = fromString;
})(Paytos || (Paytos = {}));
function codecForPaytoHash() {
  return {
    decode(x6, c5) {
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
      }
      return x6;
    }
  };
}
function codecFullForPaytoString() {
  return {
    decode(x6, c5) {
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
      }
      if (!x6.startsWith(PAYTO_PREFIX)) {
        throw new DecodingError(`expected start with payto at ${renderContext(c5)} but got "${x6}"`);
      }
      return x6;
    }
  };
}
function codecForPaytoString() {
  return {
    decode(x6, c5) {
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
      }
      if (!x6.startsWith(PAYTO_PREFIX)) {
        throw new DecodingError(`expected start with payto at ${renderContext(c5)} but got "${x6}"`);
      }
      return x6;
    }
  };
}
function encodeRFC3986URIComponent(str) {
  return encodeURIComponent(str).replace(/[!'()*]/g, (c5) => `%${c5.charCodeAt(0).toString(16).toUpperCase()}`);
}
var rfc3986 = encodeRFC3986URIComponent;
function createSearchParams(paramList) {
  return paramList.map(([key, value]) => `${rfc3986(key)}=${rfc3986(value)}`).join("&");
}
function stringifyPaytoUri(p4) {
  const url = new URL(`${PAYTO_PREFIX}${p4.targetType}/${p4.targetPath}`);
  const paramList = !p4.params ? [] : Object.entries(p4.params);
  url.search = createSearchParams(paramList);
  return url.href;
}
function hashNormalizedPaytoUri(p4) {
  const paytoUri = typeof p4 === "string" ? p4 : stringifyPaytoUri(p4);
  if (typeof p4 === "string") {
    const parseRes = parsePaytoUri(p4);
    if (!parseRes) {
      throw Error("invalid payto URI");
    }
    p4 = parseRes;
  }
  let paytoStr;
  if (!p4.isKnown) {
    const normalizedPayto = {
      targetType: p4.targetType,
      targetPath: p4.targetPath,
      isKnown: false,
      params: {}
    };
    paytoStr = stringifyPaytoUri(normalizedPayto);
  } else {
    switch (p4.targetType) {
      case "iban":
        paytoStr = `payto://iban/${p4.targetPath}`;
        break;
      case "x-taler-bank":
        paytoStr = `payto://x-taler-bank/${p4.host}/${p4.account}`;
        break;
      case "bitcoin":
        paytoStr = `payto://bitcoin/${p4.address}`;
        break;
      case "ethereum":
        paytoStr = `payto://ethereum/${p4.address}`;
        break;
      case "taler-reserve":
        paytoStr = `payto://taler-reserve/${p4.exchange}/${p4.reservePub}`;
        break;
      case "taler-reserve-http":
        paytoStr = `payto://taler-reserve-http/${p4.exchange}/${p4.reservePub}`;
        break;
    }
  }
  return hashTruncate32(stringToBytes(paytoStr + "\0"));
}
function parsePaytoUri(s6) {
  if (!s6.startsWith(PAYTO_PREFIX)) {
    return void 0;
  }
  const [acct, search] = s6.slice(PAYTO_PREFIX.length).split("?");
  const firstSlashPos = acct.indexOf("/");
  if (firstSlashPos === -1) {
    return void 0;
  }
  const targetType = acct.slice(0, firstSlashPos);
  const targetPath = acct.slice(firstSlashPos + 1);
  const params = {};
  const searchParams = new URLSearchParams2(search || "");
  searchParams.forEach((v3, k6) => {
    params[k6] = v3;
  });
  switch (targetType) {
    case "iban": {
      const parts = targetPath.split("/");
      let iban = void 0;
      let bic = void 0;
      if (parts.length === 1) {
        iban = parts[0].toUpperCase();
      }
      if (parts.length === 2) {
        bic = parts[0];
        iban = parts[1].toUpperCase();
      } else {
        iban = targetPath.toUpperCase();
      }
      return {
        isKnown: true,
        targetPath,
        targetType,
        params,
        iban,
        bic
      };
    }
    case "bitcoin": {
      const msg = /\b([A-Z0-9]{52})\b/.exec(params["message"]);
      const reserve = !msg ? params["subject"] : msg[0];
      const pubRes = !reserve ? void 0 : Paytos.parseReservePub(reserve);
      const addr = !pubRes || pubRes.type === "fail" ? void 0 : generateFakeSegwitAddress(pubRes.body, targetPath);
      const segwitAddrs = !addr || addr.type === "fail" ? [] : addr.body;
      const result = {
        isKnown: true,
        targetPath,
        targetType,
        address: targetPath,
        params,
        segwitAddrs
      };
      return result;
    }
    case "x-taler-bank": {
      const parts = targetPath.split("/");
      const host = parts[0];
      const account = parts[1];
      return {
        targetPath,
        targetType,
        params,
        isKnown: true,
        host,
        account
      };
    }
    case "taler-reserve": {
      const parts = targetPath.split("/");
      const exchange = parts[0];
      const reservePub = parts[1];
      return {
        targetPath,
        targetType,
        params,
        isKnown: true,
        exchange,
        reservePub
      };
    }
    case "ethereum": {
      const result = {
        isKnown: true,
        targetPath,
        targetType,
        address: targetPath,
        params
      };
      return result;
    }
    default: {
      return {
        targetPath,
        targetType,
        params,
        isKnown: false
      };
    }
  }
}

// ../taler-util/lib/taler-form-attributes.js
var TalerFormAttributes = {
  /**
   * Description: Suppress flagging this account when it creates a hit on a sanctions list, this is a false-positive.
   *
   * GANA Type: Boolean
   */
  SANCTION_LIST_SUPPRESS: "SANCTION_LIST_SUPPRESS",
  /**
   * Description: Date for the signature.
   *
   * GANA Type: AbsoluteDateTime
   */
  SIGN_DATE: "SIGN_DATE",
  /**
   * Description: Name of the contracting party for the purpose of signing.
   *
   * GANA Type: String
   */
  SIGNATURE: "SIGNATURE",
  /**
   * Description: Basic customer type classification to distinguish which basic info is relevant.
   *
   * GANA Type: 'NATURAL_PERSON' | 'LEGAL_ENTITY'
   */
  CUSTOMER_TYPE: "CUSTOMER_TYPE",
  /**
   * Description: Date of birth for natural persons. It should be in the past and less than 120 years.
   *
   * GANA Type: ISO Date
   */
  DATE_OF_BIRTH: "DATE_OF_BIRTH",
  /**
   * Description: If the customer is a natural person.
   *
   * GANA Type: File
   */
  PERSONAL_IDENTIFICATION_DOCUMENT_COPY: "PERSONAL_IDENTIFICATION_DOCUMENT_COPY",
  /**
   * Description: Is the customer a sole proprietor?
   *
   * GANA Type: Boolean
   */
  CUSTOMER_IS_SOLE_PROPRIETOR: "CUSTOMER_IS_SOLE_PROPRIETOR",
  /**
   * Description: If the customer is a natural person.
   *
   * GANA Type: String
   */
  COMPANY_NAME: "COMPANY_NAME",
  /**
   * Description:
   *
   * GANA Type: String
   */
  REGISTERED_OFFICE_ADDRESS: "REGISTERED_OFFICE_ADDRESS",
  /**
   * Description: Digital copy of the identification document for a legal entity.
   *
   * GANA Type: FileUpload
   */
  LEGAL_ENTITY_IDENTIFICATION_DOCUMENT_COPY: "LEGAL_ENTITY_IDENTIFICATION_DOCUMENT_COPY",
  /**
   * Description: Full name of the contact person.
   *
   * GANA Type: String
   */
  CONTACT_PERSON_NAME: "CONTACT_PERSON_NAME",
  /**
   * Description: Free-form description.
   *
   * GANA Type: String
   */
  DESCRIPTION: "DESCRIPTION",
  /**
   * Description:
   *
   * GANA Type: FileUpload[]
   */
  FILE: "FILE",
  /**
   * Description: List of founder with the fields below.
   *
   * GANA Type: Form<VQF_902_1_founder>[]
   */
  ESTABLISHER_LIST: "ESTABLISHER_LIST",
  /**
   * Description: Full name of a natural person.
   *
   * GANA Type: String
   */
  FULL_NAME: "FULL_NAME",
  /**
   * Description: Domicile address. A domicile is a place where you live, an address is just a place where you receive mail. A residential address is somewhere you live but not necessarily your primary place.
   *
   * GANA Type: ResidentialAddress
   */
  DOMICILE_ADDRESS: "DOMICILE_ADDRESS",
  /**
   * Description: Nationality, expressed as a country code.
   *
   * GANA Type: CountryCode
   */
  NATIONALITY: "NATIONALITY",
  /**
   * Description: Signatory of representation (single, collective two, ...)
   *
   * GANA Type: String
   */
  SIGNING_AUTHORITY_TYPE: "SIGNING_AUTHORITY_TYPE",
  /**
   * Description: Signatory of representation (other type)
   *
   * GANA Type: String
   */
  SIGNING_AUTHORITY_TYPE_OTHER: "SIGNING_AUTHORITY_TYPE_OTHER",
  /**
   * Description:
   *
   * GANA Type: 'CR' | 'MANDATE' | 'OTHER'
   */
  SIGNING_AUTHORITY_EVIDENCE: "SIGNING_AUTHORITY_EVIDENCE",
  /**
   * Description:
   *
   * GANA Type: String
   */
  SIGNING_AUTHORITY_EVIDENCE_OTHER: "SIGNING_AUTHORITY_EVIDENCE_OTHER",
  /**
   * Description:
   *
   * GANA Type: File
   */
  SIGNING_AUTHORITY_EVIDENCE_DOCUMENT_COPY: "SIGNING_AUTHORITY_EVIDENCE_DOCUMENT_COPY",
  /**
   * Description: Conclusion of the conract
   *
   * GANA Type: AbsoluteDate
   */
  ACCEPTANCE_DATE: "ACCEPTANCE_DATE",
  /**
   * Description:
   *
   * GANA Type: 'FACE_TO_FACE' | 'AUTHENTICATED_COPY' | 'RESIDENTIAL_ADDRESS_VALIDATED'
   */
  ACCEPTANCE_METHOD: "ACCEPTANCE_METHOD",
  /**
   * Description: Correspondence language of the customer.
   *
   * GANA Type: LangCode
   */
  CORRESPONDENCE_LANGUAGE: "CORRESPONDENCE_LANGUAGE",
  /**
   * Description: Further information on the acceptance of a customer.
   *
   * GANA Type: String
   */
  ACCEPTANCE_FURTHER_INFO: "ACCEPTANCE_FURTHER_INFO",
  /**
   * Description: Customer type under the VQF classification. Establishment of the beneficial owner of the assets and/or controlling person
   *
   * GANA Type: 'NATURAL_PERSON' | 'OPERATIONAL' | 'FOUNDATION' | 'TRUST' | 'LIFE_INSURANCE' | 'OTHER'
   */
  CUSTOMER_TYPE_VQF: "CUSTOMER_TYPE_VQF",
  /**
   * Description: Verification whether the customer, beneficial owners of the assets, controlling persons, authorised representatives or other involved persons are listed on an embargo-/terrorism list (date of verification/result)
   *
   * GANA Type: Paragraph
   */
  EMBARGO_TERRORISM_INFO: "EMBARGO_TERRORISM_INFO",
  /**
   * Description: Verification date in the sancations lists. It should be in the past and less than 120 years.
   *
   * GANA Type: Date
   */
  EMBARGO_TERRORISM_CHECK_DATE: "EMBARGO_TERRORISM_CHECK_DATE",
  /**
   * Description: Verification date.
   *
   * GANA Type: 'NOT_LISTED' | 'LISTED'
   */
  EMBARGO_TERRORISM_CHECK_RESULT: "EMBARGO_TERRORISM_CHECK_RESULT",
  /**
   * Description: True if the person is a PEP defined by 'Art 7 lit. g numeral 1'
   *
   * GANA Type: Boolean
   */
  PEP_FOREIGN: "PEP_FOREIGN",
  /**
   * Description: True if the person is a PEP defined by 'Art 7 lit. g numeral 2'
   *
   * GANA Type: Boolean
   */
  PEP_DOMESTIC: "PEP_DOMESTIC",
  /**
   * Description: True if the person is a PEP defined by 'Art 7 lit. g numeral 3'
   *
   * GANA Type: Boolean
   */
  PEP_INTERNATIONAL_ORGANIZATION: "PEP_INTERNATIONAL_ORGANIZATION",
  /**
   * Description: The decision of the Senior executive body on the acceptance of a business relationsip was obtained on ___. It should be in the past and less than 120 years.
   *
   * GANA Type: AbsoluteDateTime
   */
  PEP_ACCEPTANCE_DATE: "PEP_ACCEPTANCE_DATE",
  /**
   * Description: True if the person is in a country for which FATF requires increased dilegence.
   *
   * GANA Type: Boolean
   */
  HIGH_RISK_COUNTRY: "HIGH_RISK_COUNTRY",
  /**
   * Description: The decision of the Senior executive body on the acceptance of a business relationsip was obtained on ___. It should be in the past and less than 120 years.
   *
   * GANA Type: AbsoluteDateTime
   */
  HIGH_RISK_ACCEPTANCE_DATE: "HIGH_RISK_ACCEPTANCE_DATE",
  /**
   * Description:
   *
   * GANA Type: 'NATIONALITY_CUSTOMER' | 'NATIONALITY_OWNER' | 'DOMICILE_CUSTOMER' | 'DOMICILE_OWNER' | 'DOMICILE_CONTROLLING'
   */
  COUNTRY_RISK_NATIONALITY_TYPE: "COUNTRY_RISK_NATIONALITY_TYPE",
  /**
   * Description: Based on 902.4.1 country list
   *
   * GANA Type: 'LOW' | 'MEDIUM' | 'HIGH'
   */
  COUNTRY_RISK_NATIONALITY_LEVEL: "COUNTRY_RISK_NATIONALITY_LEVEL",
  /**
   * Description:
   *
   * GANA Type: 'CUSTOMER' | 'OWNER'
   */
  COUNTRY_RISK_BUSINESS_TYPE: "COUNTRY_RISK_BUSINESS_TYPE",
  /**
   * Description: Based on 902.4.1 country list
   *
   * GANA Type: 'LOW' | 'MEDIUM' | 'HIGH'
   */
  COUNTRY_RISK_BUSINESS_LEVEL: "COUNTRY_RISK_BUSINESS_LEVEL",
  /**
   * Description:
   *
   * GANA Type: 'CUSTOMER' | 'OWNER'
   */
  INDUSTRY_RISK_TYPE: "INDUSTRY_RISK_TYPE",
  /**
   * Description:
   *
   * GANA Type: 'TRANSPARENT' | 'HIGH_CASH_TRANSACTION' | 'NOT_WELL_KNOWN' | 'HIGH_RISK_TRADE' | 'UNKNOWN_INDUSTRY'
   */
  INDUSTRY_RISK_LEVEL: "INDUSTRY_RISK_LEVEL",
  /**
   * Description: Based on 902.4.1 country list
   *
   * GANA Type: 'LOW' | 'MEDIUM' | 'HIGH'
   */
  CONTACT_RISK_LEVEL: "CONTACT_RISK_LEVEL",
  /**
   * Description:
   *
   * GANA Type: 'EASY' | 'SOPHISTICATED' | 'OFFSHORE' | 'COMPLEX_STRUCTURE' | 'LARGE_NUMBER_OF_ACCOUNTS' | 'COMPLEX_SERVICE' | 'FREQ_TRANS_WITH_HIGH_RISK'
   */
  PRODUCT_RISK_LEVEL: "PRODUCT_RISK_LEVEL",
  /**
   * Description:
   *
   * GANA Type: 'HIGH_RISK' | 'NO_HIGH_RISK'
   */
  RISK_CLASSIFICATION_LEVEL: "RISK_CLASSIFICATION_LEVEL",
  /**
   * Description: Justification for differing risk assessment
   *
   * GANA Type: Paragraph
   */
  RISK_RATIONALE: "RISK_RATIONALE",
  /**
   * Description: The decision of the Senior executive body on the acceptance of a business relationsip was obtained on ___. It should be in the past and less than 120 years.
   *
   * GANA Type: AbsoluteDateTime
   */
  RISK_ACCEPTANCE_DATE: "RISK_ACCEPTANCE_DATE",
  /**
   * Description: Profession, business activities, etc. (former, current, potentially planned)
   *
   * GANA Type: String
   */
  BIZREL_PROFESSION: "BIZREL_PROFESSION",
  /**
   * Description: Income and assets, liabilities (estimated)
   *
   * GANA Type: String
   */
  BIZREL_INCOME: "BIZREL_INCOME",
  /**
   * Description: Does the customer have assets that will be deposited?
   *
   * GANA Type: Boolean
   */
  BIZREL_HAVE_ASSETS: "BIZREL_HAVE_ASSETS",
  /**
   * Description: Nature of the involved assets (amount, currency, ...).
   *
   * GANA Type: String
   */
  BIZREL_ORIGIN_NATURE: "BIZREL_ORIGIN_NATURE",
  /**
   * Description:
   *
   * GANA Type: 'SAVINGS' | 'OWN_BUSINESS' | 'INHERITANCE' | 'OTHER'
   */
  BIZREL_ORIGIN_CATEGORY: "BIZREL_ORIGIN_CATEGORY",
  /**
   * Description:
   *
   * GANA Type: String
   */
  BIZREL_ORIGIN_CATEGORY_OTHER: "BIZREL_ORIGIN_CATEGORY_OTHER",
  /**
   * Description: Detailed description of the origins.
   *
   * GANA Type: Paragraph
   */
  BIZREL_ORIGIN_DETAIL: "BIZREL_ORIGIN_DETAIL",
  /**
   * Description: Purpose of the business relationship.
   *
   * GANA Type: String
   */
  BIZREL_PURPOSE: "BIZREL_PURPOSE",
  /**
   * Description: Information on the planned development of the business relationship and the assets.
   *
   * GANA Type: String
   */
  BIZREL_DEVELOPMENT: "BIZREL_DEVELOPMENT",
  /**
   * Description: In the case of cash or money and asset transfer transacction with regular customer
   *
   * GANA Type: String
   */
  BIZREL_FINANCIAL_VOLUME: "BIZREL_FINANCIAL_VOLUME",
  /**
   * Description: Relation of the customer to the beneficial owner, controlling persons, authorised signatories and other persons involved in the business relationship.
   *
   * GANA Type: String
   */
  BIZREL_THIRDPARTY_RELATIONSHIP: "BIZREL_THIRDPARTY_RELATIONSHIP",
  /**
   * Description: Relation to other AMLA-files.
   *
   * GANA Type: String
   */
  BIZREL_THIRDPARTY_AMLA_FILES: "BIZREL_THIRDPARTY_AMLA_FILES",
  /**
   * Description: Introducer / agents / references.
   *
   * GANA Type: String
   */
  BIZREL_THIRDPARTY_REFERENCES: "BIZREL_THIRDPARTY_REFERENCES",
  /**
   * Description: Other relevant information.
   *
   * GANA Type: String
   */
  BIZREL_FURTHER_INFO: "BIZREL_FURTHER_INFO",
  /**
   * Description:
   *
   * GANA Type: Paragraph
   */
  IDENTITY_CONTRACTING_PARTNER: "IDENTITY_CONTRACTING_PARTNER",
  /**
   * Description:
   *
   * GANA Type: File
   */
  ATTACHMENT_SIGNED_DOCUMENT: "ATTACHMENT_SIGNED_DOCUMENT",
  /**
   * Description: The beneficial owners of the assets involved in the business relationship.
   *
   * GANA Type: Form<VQF_902_9_identity>[]
   */
  IDENTITY_LIST: "IDENTITY_LIST",
  /**
   * Description: Party that is filling out the form.
   *
   * GANA Type: 'AML_OFFICER' | 'CUSTOMER'
   */
  SUBMITTED_BY: "SUBMITTED_BY",
  /**
   * Description:
   *
   * GANA Type: 'HAS_25_MORE_RIGHTS' | 'OTHER_WAY' | 'DIRECTOR'
   */
  CONTROL_REASON: "CONTROL_REASON",
  /**
   * Description: Is a third person the beneficial owner of the assets?
   *
   * GANA Type: Boolean
   */
  THIRD_PARTY_OWNERSHIP: "THIRD_PARTY_OWNERSHIP",
  /**
   * Description: Description of the circumstances/transactions, which triggered the special clarifications
   *
   * GANA Type: String
   */
  INCRISK_REASON: "INCRISK_REASON",
  /**
   * Description:
   *
   * GANA Type: 'GATHERING' | 'CONSULTATION' | 'ENQUIRIES' | 'OTHER'
   */
  INCRISK_MEANS: "INCRISK_MEANS",
  /**
   * Description:
   *
   * GANA Type: String
   */
  INCRISK_MEANS_OTHER: "INCRISK_MEANS_OTHER",
  /**
   * Description:
   *
   * GANA Type: Paragraph
   */
  INCRISK_SUMMARY: "INCRISK_SUMMARY",
  /**
   * Description: Gathered or consulted documents
   *
   * GANA Type: Paragraph
   */
  INCRISK_DOCUMENTS: "INCRISK_DOCUMENTS",
  /**
   * Description:
   *
   * GANA Type: 'NO_SUSPICION' | 'REASONABLE_SUSPICION' | 'SIMPLE_SUSPICION' | 'OTHER'
   */
  INCRISK_RESULT: "INCRISK_RESULT",
  /**
   * Description:
   *
   * GANA Type: String
   */
  INCRISK_RESULT_OTHER: "INCRISK_RESULT_OTHER",
  /**
   * Description: First name(s) as on the identity document.
   *
   * GANA Type: String
   */
  PERSON_FIRST_NAMES: "PERSON_FIRST_NAMES",
  /**
   * Description: Last name of an individual as on the identity document.
   *
   * GANA Type: String
   */
  PERSON_LAST_NAME: "PERSON_LAST_NAME",
  /**
   * Description: Identification number or string of national identity card.
   *
   * GANA Type: String
   */
  PERSON_NATIONAL_ID: "PERSON_NATIONAL_ID",
  /**
   * Description: Scan of a recognized national identity card of an individual.
   *
   * GANA Type: File
   */
  PERSON_NATIONAL_ID_SCAN: "PERSON_NATIONAL_ID_SCAN",
  /**
   * Description: Nationality of an individual. Format is 2-letter ISO country-code.
   *
   * GANA Type: CountryCode
   */
  PERSON_NATIONALITY: "PERSON_NATIONALITY",
  /**
   * Description: Confirmation that the wallet user is a private customer, not a business.
   *
   * GANA Type: Boolean
   */
  WALLET_USER_IS_PRIVATE_CUSTOMER: "WALLET_USER_IS_PRIVATE_CUSTOMER",
  /**
   * Description: Name of the company or business.
   *
   * GANA Type: String
   */
  BUSINESS_DISPLAY_NAME: "BUSINESS_DISPLAY_NAME",
  /**
   * Description: Type of company form or business (selection from fixed list).
   *
   * GANA Type: String
   */
  BUSINESS_TYPE: "BUSINESS_TYPE",
  /**
   * Description: Type of company form or business (free-form entry for OTHER).
   *
   * GANA Type: String
   */
  BUSINESS_TYPE_OTHER: "BUSINESS_TYPE_OTHER",
  /**
   * Description: Registration id on legal entity of the company or business.
   *
   * GANA Type: String
   */
  COMMERCIAL_REGISTER_NUMBER: "COMMERCIAL_REGISTER_NUMBER",
  /**
   * Description: City or location where the company or business is registered.
   *
   * GANA Type: String
   */
  REGISTER_COURT_LOCATION: "REGISTER_COURT_LOCATION",
  /**
   * Description: Registration founding date of the company or business. It should be in the past and less than 120 years.
   *
   * GANA Type: AbsoluteDate
   */
  FOUNDING_DATE: "FOUNDING_DATE",
  /**
   * Description: True if the company or business is a non-profit.
   *
   * GANA Type: Boolean
   */
  BUSINESS_IS_NON_PROFIT: "BUSINESS_IS_NON_PROFIT",
  /**
   * Description: Industry in which the company or business mainly operate.
   *
   * GANA Type: String
   */
  BUSINESS_INDUSTRY: "BUSINESS_INDUSTRY",
  /**
   * Description: Free-form industry, when BUSINESS_INDUSTRY is OTHER.
   *
   * GANA Type: String
   */
  BUSINESS_INDUSTRY_OTHER: "BUSINESS_INDUSTRY_OTHER",
  /**
   * Description: List of natural persons that are legal representatives or shareholders.
   *
   * GANA Type: GLS_BusinessRepresentative[]
   */
  BUSINESS_PERSONS: "BUSINESS_PERSONS",
  /**
   * Description: List of natural persons that are legal representatives or shareholders.
   *
   * GANA Type: LEGAL_REPRESENTATIVE | SHAREHOLDER_GT_25_PERCENT | AUTHORIZED_EMPLOYEE
   */
  REPRESENTATIVE_TYPE: "REPRESENTATIVE_TYPE",
  /**
   * Description: DNS domain name owned by the individual or business.
   *
   * GANA Type: Hostname
   */
  CONTACT_DNS_DOMAIN: "CONTACT_DNS_DOMAIN",
  /**
   * Description: Web site owned by the individual or business.
   *
   * GANA Type: HttpHostnamePath
   */
  CONTACT_WEBSITE: "CONTACT_WEBSITE",
  /**
   * Description: E-mail address to contact the individual or business. Can be validated via E-mail with TAN.
   *
   * GANA Type: Email
   */
  CONTACT_EMAIL: "CONTACT_EMAIL",
  /**
   * Description: Phone number to contact the individual or business. Can be validated via SMS-TAN or phone call.
   *
   * GANA Type: Phone
   */
  CONTACT_PHONE: "CONTACT_PHONE",
  /**
   * Description: Natural person full-name or name of the business to contact.
   *
   * GANA Type: String
   */
  CONTACT_NAME: "CONTACT_NAME",
  /**
   * Description: Country where the individual or business resides. Format is 2-letter ISO country-code.
   *
   * GANA Type: CountryCode
   */
  ADDRESS_COUNTRY: "ADDRESS_COUNTRY",
  /**
   * Description: Street address name of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_STREET_NAME: "ADDRESS_STREET_NAME",
  /**
   * Description: Street address number of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_STREET_NUMBER: "ADDRESS_STREET_NUMBER",
  /**
   * Description: Additional address information of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_LINES: "ADDRESS_LINES",
  /**
   * Description: Building name of the of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_BUILDING_NAME: "ADDRESS_BUILDING_NAME",
  /**
   * Description: Building number of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_BUILDING_NUMBER: "ADDRESS_BUILDING_NUMBER",
  /**
   * Description: Postal code of the city where the individual or business resides.
   *
   * GANA Type: String
   */
  ADDRESS_ZIPCODE: "ADDRESS_ZIPCODE",
  /**
   * Description: Town location of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_TOWN_LOCATION: "ADDRESS_TOWN_LOCATION",
  /**
   * Description: Town district of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_TOWN_DISTRICT: "ADDRESS_TOWN_DISTRICT",
  /**
   * Description: Country subdivision of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_COUNTRY_SUBDIVISION: "ADDRESS_COUNTRY_SUBDIVISION",
  /**
   * Description: Country name of of the individual or business.
   *
   * GANA Type: CountryCode
   */
  TAX_COUNTRY: "TAX_COUNTRY",
  /**
   * Description: Tax identifier of the individual or business.
   *
   * GANA Type: String
   */
  TAX_ID: "TAX_ID",
  /**
   * Description: Is business founded or under USA law.
   *
   * GANA Type: Boolean
   */
  TAX_IS_USA_LAW: "TAX_IS_USA_LAW",
  /**
   * Description: Is the individual or business economically active or passive.
   *
   * GANA Type: Boolean
   */
  TAX_IS_ACTIVE: "TAX_IS_ACTIVE",
  /**
   * Description: Is the business entitled to deduct input tax.
   *
   * GANA Type: Boolean
   */
  TAX_IS_DEDUCTED: "TAX_IS_DEDUCTED",
  /**
   * Description: Wirtschafts-Identifikationsnummer / Steuernummer.
   *
   * GANA Type: Boolean
   */
  DE_BUSINESS_OR_TAX_ID: "DE_BUSINESS_OR_TAX_ID",
  /**
   * Description: Name of the version of the terms of service accepted by the customer.
   *
   * GANA Type: Boolean
   */
  ACCEPTED_TERMS_OF_SERVICE: "ACCEPTED_TERMS_OF_SERVICE",
  /**
   * Description: True if the customer read or downloaded the terms of service. It should be set automatically.
   *
   * GANA Type: Boolean
   */
  DOWNLOADED_TERMS_OF_SERVICE: "DOWNLOADED_TERMS_OF_SERVICE",
  /**
   * Description: Name of the form completed by the user.
   *
   * GANA Type: String
   */
  FORM_ID: "FORM_ID",
  /**
   * Description: Version of the form completed by the user.
   *
   * GANA Type: Number
   */
  FORM_VERSION: "FORM_VERSION",
  /**
   * Description: High entropy value used in forms where hash is going to be stored in plain text.
   *
   * GANA Type: String
   */
  FORM_SALT: "FORM_SALT",
  /**
   * Description: List of supplemental file attachments.
   *
   * GANA Type: List of records, usually the file upload and a description.
   */
  SUPPLEMENTAL_FILES_LIST: "SUPPLEMENTAL_FILES_LIST",
  /**
   * Description: Generic note description
   *
   * GANA Type: String
   */
  NOTE_TEXT: "NOTE_TEXT",
  /**
   * Description: Context for form submitted by the user.
   *
   * GANA Type: JSON
   */
  FORM_CONTEXT: "FORM_CONTEXT",
  /**
   * Description: Map of uploaded files.
   *
   * GANA Type: MapStrFile
   */
  FILE_MAP: "FILE_MAP"
};

// ../taler-util/lib/types-taler-exchange.js
var DenominationPubKey;
(function(DenominationPubKey2) {
  function cmp(p1, p22) {
    if (p1.cipher < p22.cipher) {
      return -1;
    } else if (p1.cipher > p22.cipher) {
      return 1;
    } else if (p1.cipher === DenomKeyType.Rsa && p22.cipher === DenomKeyType.Rsa) {
      if ((p1.age_mask ?? 0) < (p22.age_mask ?? 0)) {
        return -1;
      } else if ((p1.age_mask ?? 0) > (p22.age_mask ?? 0)) {
        return 1;
      }
      return strcmp(p1.rsa_public_key, p22.rsa_public_key);
    } else if (p1.cipher === DenomKeyType.ClauseSchnorr && p22.cipher === DenomKeyType.ClauseSchnorr) {
      if ((p1.age_mask ?? 0) < (p22.age_mask ?? 0)) {
        return -1;
      } else if ((p1.age_mask ?? 0) > (p22.age_mask ?? 0)) {
        return 1;
      }
      return strcmp(p1.cs_public_key, p22.cs_public_key);
    } else {
      throw Error("unsupported cipher");
    }
  }
  DenominationPubKey2.cmp = cmp;
})(DenominationPubKey || (DenominationPubKey = {}));
var codecForNgDenominations = codecForAny();
var DenomKeyType;
(function(DenomKeyType2) {
  DenomKeyType2["Rsa"] = "RSA";
  DenomKeyType2["ClauseSchnorr"] = "CS";
})(DenomKeyType || (DenomKeyType = {}));
(function(DenomKeyType2) {
  function toIntTag(t5) {
    switch (t5) {
      case DenomKeyType2.Rsa:
        return 1;
      case DenomKeyType2.ClauseSchnorr:
        return 2;
    }
  }
  DenomKeyType2.toIntTag = toIntTag;
})(DenomKeyType || (DenomKeyType = {}));
var codecForRsaBlindedDenominationSignature = () => buildCodecForObject().property("cipher", codecForConstString(DenomKeyType.Rsa)).property("blinded_rsa_signature", codecForString()).build("RsaBlindedDenominationSignature");
var codecForBlindedDenominationSignature = () => buildCodecForUnion().discriminateOn("cipher").alternative(DenomKeyType.Rsa, codecForRsaBlindedDenominationSignature()).build("BlindedDenominationSignature");
var codecForExchangeWithdrawResponse = () => buildCodecForObject().property("ev_sigs", codecForList(codecForBlindedDenominationSignature())).build("WithdrawResponse");
var codecForExchangeMeltResponse = () => buildCodecForObject().property("exchange_pub", codecForEddsaPublicKey()).property("exchange_sig", codecForEddsaSignature()).property("noreveal_index", codecForNumber()).property("refresh_base_url", codecOptional(codecForString())).build("ExchangeMeltResponse");
var codecForExchangeGetContractResponse = () => buildCodecForObject().property("purse_pub", codecForString()).property("econtract_sig", codecForString()).property("econtract", codecForString()).build("ExchangeGetContractResponse");
var codecForExchangeMergeSuccessResponse = () => buildCodecForObject().property("merge_amount", codecForAmountString()).property("exchange_timestamp", codecForTimestamp).property("exchange_sig", codecForEddsaSignature()).property("exchange_pub", codecForEddsaPublicKey()).build("ExchangeMergeSuccessResponse");
var codecForExchangeMergeConflictResponse = () => buildCodecForObject().property("merge_timestamp", codecForTimestamp).property("merge_sig", codecForEddsaSignature()).property("reserve_pub", codecForEddsaPublicKey()).property("partner_url", codecOptional(codecForString())).build("ExchangeMergeConflictResponse");
var codecForExchangePurseStatus = () => buildCodecForObject().property("balance", codecForAmountString()).property("deposit_timestamp", codecOptional(codecForTimestamp)).property("merge_timestamp", codecOptional(codecForTimestamp)).build("ExchangePurseStatus");
var AmlSpaDialect;
(function(AmlSpaDialect2) {
  AmlSpaDialect2["TOPS"] = "tops";
  AmlSpaDialect2["GLS"] = "gls";
  AmlSpaDialect2["TESTING"] = "testing";
})(AmlSpaDialect || (AmlSpaDialect = {}));
var LimitOperationType;
(function(LimitOperationType2) {
  LimitOperationType2["withdraw"] = "WITHDRAW";
  LimitOperationType2["deposit"] = "DEPOSIT";
  LimitOperationType2["merge"] = "MERGE";
  LimitOperationType2["aggregate"] = "AGGREGATE";
  LimitOperationType2["balance"] = "BALANCE";
  LimitOperationType2["refund"] = "REFUND";
  LimitOperationType2["close"] = "CLOSE";
  LimitOperationType2["transaction"] = "TRANSACTION";
})(LimitOperationType || (LimitOperationType = {}));
var AmlState;
(function(AmlState2) {
  AmlState2[AmlState2["normal"] = 0] = "normal";
  AmlState2[AmlState2["pending"] = 1] = "pending";
  AmlState2[AmlState2["frozen"] = 2] = "frozen";
})(AmlState || (AmlState = {}));
var codecForAmlSpaDialect = codecForEither(codecForConstString(AmlSpaDialect.GLS), codecForConstString(AmlSpaDialect.TOPS), codecForConstString(AmlSpaDialect.TESTING));
var codecForExchangeConfig = () => buildCodecForObject().property("version", codecForString()).property("name", codecForConstString("taler-exchange")).property("implementation", codecOptional(codecForURN())).property("currency", codecForString()).property("currency_specification", codecForCurrencySpecificiation()).property("supported_kyc_requirements", codecForList(codecForString())).property("aml_spa_dialect", codecOptional(codecForAmlSpaDialect)).deprecatedProperty("shopping_url").deprecatedProperty("wallet_balance_limit_without_kyc").build("TalerExchangeApi.ExchangeVersionResponse");
var codecForExchangeKeysResponse = () => buildCodecForObject().property("version", codecForString()).property("base_url", codecForURLString()).property("currency", codecForString()).property("accounts", codecForAny()).property("asset_type", codecForAny()).property("auditors", codecForAny()).property("currency_specification", codecForAny()).property("zero_limits", codecForAny()).property("hard_limits", codecForAny()).property("denominations", codecForAny()).property("exchange_pub", codecForAny()).property("exchange_sig", codecForAny()).property("extensions", codecForAny()).property("extensions_sig", codecForAny()).property("global_fees", codecForAny()).property("list_issue_date", codecForAny()).property("master_public_key", codecForAny()).property("recoup", codecForAny()).property("reserve_closing_delay", codecForAny()).property("signkeys", codecForAny()).property("stefan_abs", codecForAny()).property("stefan_lin", codecForAny()).property("stefan_log", codecForAny()).property("wads", codecForAny()).property("wallet_balance_limit_without_kyc", codecForAny()).property("wire_fees", codecForAny()).property("kyc_enabled", codecOptional(codecForBoolean())).property("shopping_url", codecOptional(codecForString())).property("tiny_amount", codecOptional(codecForAmountString())).property("disable_direct_deposit", codecOptional(codecForBoolean())).property("bank_compliance_language", codecOptional(codecForString())).property("open_banking_gateway", codecOptional(codecForURLString())).deprecatedProperty("rewards_allowed").build("TalerExchangeApi.ExchangeKeysResponse");
var codecForAmlStatisticsResponse = () => buildCodecForObject().property("statistics", codecForList(codecForEventCounter())).build("TalerExchangeApi.AmlStatisticsResponse");
var codecForEventCounter = () => buildCodecForObject().property("name", codecForString()).property("counter", codecForNumber()).build("TalerExchangeApi.EventCounter");
var codecForLegitimizationMeasuresList = () => buildCodecForObject().property("measures", codecForList(codecForLegitimizationMeasureDetails())).build("TalerExchangeApi.LegitimizationMeasuresList");
var codecForLegitimizationMeasureDetails = () => buildCodecForObject().property("h_payto", codecForAny()).property("rowid", codecForAny()).property("start_time", codecForAny()).property("measures", codecForAny()).property("is_finished", codecForAny()).build("TalerExchangeApi.LegitimizationMeasureDetails");
var codecForAvailableMeasureSummary = () => buildCodecForObject().property("checks", codecForMap(codecForKycCheckInformation())).property("programs", codecForMap(codecForAmlProgramRequirement())).property("roots", codecForMap(codecForMeasureInformation())).property("default_rules", codecForList(codecForKycRules())).build("TalerExchangeApi.AvailableMeasureSummary");
var codecForAmlProgramRequirement = () => buildCodecForObject().property("description", codecForString()).property("context", codecForList(codecForString())).property("inputs", codecForList(codecForString())).build("TalerExchangeApi.AmlProgramRequirement");
var codecForKycCheckInformation = () => buildCodecForObject().property("description", codecForString()).property("description_i18n", codecOptional(codecForInternationalizedString())).property("fallback", codecForString()).property("outputs", codecForList(codecForString())).property("requires", codecForList(codecForString())).build("TalerExchangeApi.KycCheckInformation");
var codecForMeasureInformation = () => buildCodecForObject().property("prog_name", codecOptional(codecForString())).property("check_name", codecForString()).property("context", codecForAny()).property("operation_type", codecOptional(codecForOperationType)).property("voluntary", codecOptional(codecForBoolean())).build("TalerExchangeApi.MeasureInformation");
var codecForAmlDecisionsResponse = () => buildCodecForObject().property("records", codecForList(codecForAmlDecision())).build("TalerExchangeApi.AmlDecisionsResponse");
var codecForAmlCustomerAccountSummary = () => buildCodecForObject().property("h_payto", codecForPaytoHash()).property("close_time", codecForTimestamp).property("open_time", codecForTimestamp).property("comments", codecOptional(codecForString())).property("full_payto", codecFullForPaytoString()).property("high_risk", codecForBoolean()).property("rowid", codecForNumber()).property("to_investigate", codecForBoolean()).build("TalerExchangeApi.CustomerAccountSummary");
var codecForAmlDecisionsAccounts = () => buildCodecForObject().property("accounts", codecForList(codecForAmlCustomerAccountSummary())).build("TalerExchangeApi.AmlAccountsResponse");
var codecForAmlDecision = () => buildCodecForObject().property("h_payto", codecForString()).property("full_payto", codecOptional(codecForString())).property("rowid", codecForNumber()).property("is_wallet", codecForBoolean()).property("justification", codecOptional(codecForString())).property("decision_time", codecForTimestamp).property("properties", codecOptional(codecForAccountProperties())).property("limits", codecForLegitimizationRuleSet()).property("to_investigate", codecForBoolean()).property("is_active", codecForBoolean()).build("TalerExchangeApi.AmlDecision");
var codecForAccountProperties = () => buildCodecForObject().property("pep", codecOptional(codecForBoolean())).property("sanctioned", codecOptional(codecForBoolean())).property("high_risk", codecOptional(codecForBoolean())).property("business_domain", codecOptional(codecForString())).property("is_frozen", codecOptional(codecForBoolean())).property("was_reported", codecOptional(codecForBoolean())).allowExtra().build("TalerExchangeApi.AccountProperties");
var codecForLegitimizationRuleSet = () => buildCodecForObject().property("expiration_time", codecForTimestamp).property("successor_measure", codecOptional(codecForString())).property("rules", codecForList(codecForKycRules())).property("custom_measures", codecForMap(codecForMeasureInformation())).build("TalerExchangeApi.LegitimizationRuleSet");
var codecForKycRules = () => buildCodecForObject().property("operation_type", codecForOperationType).property("threshold", codecForAmountString()).property("timeframe", codecForDuration).property("measures", codecForList(codecForString())).property("display_priority", codecForNumber()).property("exposed", codecOptional(codecForBoolean())).property("is_and_combinator", codecOptional(codecForBoolean())).property("rule_name", codecOptional(codecForString())).build("TalerExchangeApi.KycRule");
var codecForAmlKycAttributes = () => buildCodecForObject().property("details", codecForList(codecForKycAttributeCollectionEvent())).build("TalerExchangeApi.KycAttributes");
var codecForKycAttributeCollectionEvent = () => buildCodecForObject().property("rowid", codecForNumber()).property("provider_name", codecOptional(codecForString())).property("collection_time", codecForTimestamp).property("attributes", codecOptional(codecForAny())).build("TalerExchangeApi.KycAttributeCollectionEvent");
var codecForAmlWalletKycCheckResponse = () => buildCodecForObject().property("next_threshold", codecOptional(codecForAmountString())).property("expiration_time", codecForTimestamp).build("TalerExchangeApi.WalletKycCheckResponse");
var codecForLegitimizationNeededResponse = () => buildCodecForObject().property("code", codecForNumber()).property("hint", codecOptional(codecForString())).property("h_payto", codecForString()).property("account_pub", codecOptional(codecForEddsaPublicKey())).property("requirement_row", codecForNumber()).property("bad_kyc_auth", codecOptional(codecForBoolean())).build("TalerExchangeApi.LegitimizationNeededResponse");
var codecForAccountKycStatus = () => buildCodecForObject().property("aml_review", codecForBoolean()).property("access_token", codecForAccessToken()).property("limits", codecOptional(codecForList(codecForAccountLimit()))).property("rule_gen", codecForNumber()).build("TalerExchangeApi.AccountKycStatus");
var codecForOperationType = codecForEither(codecForConstString(LimitOperationType.withdraw), codecForConstString(LimitOperationType.deposit), codecForConstString(LimitOperationType.merge), codecForConstString(LimitOperationType.balance), codecForConstString(LimitOperationType.close), codecForConstString(LimitOperationType.aggregate), codecForConstString(LimitOperationType.transaction), codecForConstString(LimitOperationType.refund));
var codecForAccountLimit = () => buildCodecForObject().property("operation_type", codecForOperationType).property("timeframe", codecForDuration).property("threshold", codecForAmountString()).property("soft_limit", codecOptional(codecForBoolean())).property("rule_name", codecOptional(codecForString())).build("TalerExchangeApi.AccountLimit");
var codecForKycRequirementInformationId = () => codecForString();
var codecForKycFormId = () => codecForString();
var codecForKycRequirementInformation = () => buildCodecForObject().property("form", codecForEither(codecForConstString("LINK"), codecForConstString("INFO"), codecForKycFormId())).property("description", codecForString()).property("context", codecOptional(codecForAny())).property("description_i18n", codecOptional(codecForInternationalizedString())).property("id", codecOptional(codecForKycRequirementInformationId())).build("TalerExchangeApi.KycRequirementInformation");
var codecForKycProcessClientInformation = () => buildCodecForObject().property("requirements", codecOptionalDefault(codecForList(codecForKycRequirementInformation()), [])).property("is_and_combinator", codecOptional(codecForBoolean())).property("voluntary_measures", codecOptional(codecForList(codecForKycRequirementInformation()))).build("TalerExchangeApi.KycProcessClientInformation");
var codecForExchangeTransferList = () => buildCodecForObject().property("transfers", codecForList(codecForExchangeTransferListEntry())).build("TalerExchangeApi.ExchangeTransferList");
var codecForExchangeTransferListEntry = () => buildCodecForObject().property("rowid", codecForNumber()).property("payto_uri", codecForPaytoString()).property("amount", codecForAmountString()).property("execution_time", codecForTimestamp).build("TalerExchangeApi.ExchangeTransferListEntry");
var codecForKycProcessStartInformation = () => buildCodecForObject().property("redirect_url", codecForURLString()).build("TalerExchangeApi.KycProcessStartInformation");
var TransactionHistoryType;
(function(TransactionHistoryType2) {
  TransactionHistoryType2["setup"] = "SETUP";
  TransactionHistoryType2["withdraw"] = "WITHDRAW";
  TransactionHistoryType2["ageWithdraw"] = "AGEWITHDRAW";
  TransactionHistoryType2["credit"] = "CREDIT";
  TransactionHistoryType2["closing"] = "CLOSING";
  TransactionHistoryType2["open"] = "OPEN";
  TransactionHistoryType2["close"] = "CLOSE";
  TransactionHistoryType2["merge"] = "MERGE";
})(TransactionHistoryType || (TransactionHistoryType = {}));
var codecForPurseConflict = () => buildCodecForUnion().discriminateOn("code").alternative(TalerErrorCode.EXCHANGE_GENERIC_INSUFFICIENT_FUNDS, codecForDepositDoubleSpendError()).alternative(TalerErrorCode.EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA, codecForPurseCreateConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA, codecForPurseDepositConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA, codecForPurseContractConflict()).build("PurseConflict");
var codecForPurseConflictPartial = () => buildCodecForUnion().discriminateOn("code").alternative(TalerErrorCode.EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA, codecForPurseCreateConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA, codecForPurseDepositConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA, codecForPurseContractConflict()).build("PurseConflictPartial");
var codecForDepositDoubleSpendError = () => buildCodecForObject().property("code", codecForNumber()).property("hint", codecForString()).property("coin_pub", codecForString()).build("DepositDoubleSpendError");
var codecForPurseCreateConflict = () => buildCodecForObject().property("code", codecForNumber()).property("amount", codecForAmountString()).property("min_age", codecForNumber()).property("purse_expiration", codecForTimestamp).property("purse_sig", codecForString()).property("h_contract_terms", codecForString()).property("merge_pub", codecForString()).build("PurseCreateConflict");
var codecForPurseDepositConflict = () => buildCodecForObject().property("code", codecForNumber()).property("coin_pub", codecForString()).property("partner_url", codecOptional(codecForString())).property("amount", codecForAmountString()).build("PurseDepositConflict");
var codecForPurseContractConflict = () => buildCodecForObject().property("code", codecForNumber()).property("h_econtract", codecForString()).property("econtract_sig", codecForString()).property("contract_pub", codecForString()).build("PurseContractConflict");

// ../taler-util/lib/taler_signatures.js
var TalerSignaturePurpose;
(function(TalerSignaturePurpose2) {
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_AML_KEY"] = 1017] = "MASTER_AML_KEY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_DRAIN_PROFIT"] = 1018] = "MASTER_DRAIN_PROFIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_PARTNER_DETAILS"] = 1019] = "MASTER_PARTNER_DETAILS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_SIGNING_KEY_REVOKED"] = 1020] = "MASTER_SIGNING_KEY_REVOKED";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_ADD_WIRE"] = 1021] = "MASTER_ADD_WIRE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_GLOBAL_FEES"] = 1022] = "MASTER_GLOBAL_FEES";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_DEL_WIRE"] = 1023] = "MASTER_DEL_WIRE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_SIGNING_KEY_VALIDITY"] = 1024] = "MASTER_SIGNING_KEY_VALIDITY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_DENOMINATION_KEY_VALIDITY"] = 1025] = "MASTER_DENOMINATION_KEY_VALIDITY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_ADD_AUDITOR"] = 1026] = "MASTER_ADD_AUDITOR";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_DEL_AUDITOR"] = 1027] = "MASTER_DEL_AUDITOR";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_WIRE_FEES"] = 1028] = "MASTER_WIRE_FEES";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_DENOMINATION_KEY_REVOKED"] = 1029] = "MASTER_DENOMINATION_KEY_REVOKED";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_WIRE_DETAILS"] = 1030] = "MASTER_WIRE_DETAILS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_EXTENSION"] = 1031] = "MASTER_EXTENSION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_RESERVE_STATUS"] = 1032] = "EXCHANGE_RESERVE_STATUS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_DEPOSIT"] = 1033] = "EXCHANGE_CONFIRM_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_MELT"] = 1034] = "EXCHANGE_CONFIRM_MELT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_KEY_SET"] = 1035] = "EXCHANGE_KEY_SET";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_WIRE"] = 1036] = "EXCHANGE_CONFIRM_WIRE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_WIRE_DEPOSIT"] = 1037] = "EXCHANGE_CONFIRM_WIRE_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_REFUND"] = 1038] = "EXCHANGE_CONFIRM_REFUND";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_RECOUP"] = 1039] = "EXCHANGE_CONFIRM_RECOUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_RESERVE_CLOSED"] = 1040] = "EXCHANGE_RESERVE_CLOSED";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_RECOUP_REFRESH"] = 1041] = "EXCHANGE_CONFIRM_RECOUP_REFRESH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_AFFIRM_DENOM_UNKNOWN"] = 1042] = "EXCHANGE_AFFIRM_DENOM_UNKNOWN";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_AFFIRM_DENOM_EXPIRED"] = 1043] = "EXCHANGE_AFFIRM_DENOM_EXPIRED";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_PURSE_CREATION"] = 1045] = "EXCHANGE_CONFIRM_PURSE_CREATION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_PURSE_MERGED"] = 1046] = "EXCHANGE_CONFIRM_PURSE_MERGED";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_PURSE_STATUS"] = 1047] = "EXCHANGE_PURSE_STATUS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_RESERVE_ATTEST_DETAILS"] = 1048] = "EXCHANGE_RESERVE_ATTEST_DETAILS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_PURSE_REFUND"] = 1049] = "EXCHANGE_CONFIRM_PURSE_REFUND";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_WITHDRAW"] = 1050] = "EXCHANGE_CONFIRM_WITHDRAW";
  TalerSignaturePurpose2[TalerSignaturePurpose2["AUDITOR_EXCHANGE_KEYS"] = 1064] = "AUDITOR_EXCHANGE_KEYS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_CONTRACT"] = 1101] = "MERCHANT_CONTRACT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_REFUND"] = 1102] = "MERCHANT_REFUND";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_TRACK_TRANSACTION"] = 1103] = "MERCHANT_TRACK_TRANSACTION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_PAYMENT_OK"] = 1104] = "MERCHANT_PAYMENT_OK";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_WIRE_DETAILS"] = 1107] = "MERCHANT_WIRE_DETAILS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_TOKEN_ISSUE"] = 1108] = "MERCHANT_TOKEN_ISSUE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_WITHDRAW"] = 1200] = "WALLET_RESERVE_WITHDRAW";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_DEPOSIT"] = 1201] = "WALLET_COIN_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_MELT"] = 1202] = "WALLET_COIN_MELT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_RECOUP"] = 1203] = "WALLET_COIN_RECOUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_LINK"] = 1204] = "WALLET_COIN_LINK";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_ACCOUNT_SETUP"] = 1205] = "WALLET_ACCOUNT_SETUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_RECOUP_REFRESH"] = 1206] = "WALLET_COIN_RECOUP_REFRESH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_AGE_ATTESTATION"] = 1207] = "WALLET_AGE_ATTESTATION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_HISTORY"] = 1208] = "WALLET_RESERVE_HISTORY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_HISTORY"] = 1209] = "WALLET_COIN_HISTORY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_CREATE"] = 1210] = "WALLET_PURSE_CREATE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_DEPOSIT"] = 1211] = "WALLET_PURSE_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_STATUS"] = 1212] = "WALLET_PURSE_STATUS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_MERGE"] = 1213] = "WALLET_PURSE_MERGE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_ACCOUNT_MERGE"] = 1214] = "WALLET_ACCOUNT_MERGE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_CLOSE"] = 1215] = "WALLET_RESERVE_CLOSE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_ECONTRACT"] = 1216] = "WALLET_PURSE_ECONTRACT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_OPEN"] = 1217] = "WALLET_RESERVE_OPEN";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_OPEN_DEPOSIT"] = 1218] = "WALLET_RESERVE_OPEN_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_ATTEST_DETAILS"] = 1219] = "WALLET_RESERVE_ATTEST_DETAILS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_DELETE"] = 1220] = "WALLET_PURSE_DELETE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_AGE_WITHDRAW"] = 1221] = "WALLET_RESERVE_AGE_WITHDRAW";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_TOKEN_USE"] = 1222] = "WALLET_TOKEN_USE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["SM_RSA_DENOMINATION_KEY"] = 1250] = "SM_RSA_DENOMINATION_KEY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["SM_SIGNING_KEY"] = 1251] = "SM_SIGNING_KEY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["SM_CS_DENOMINATION_KEY"] = 1252] = "SM_CS_DENOMINATION_KEY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["CLIENT_TEST_EDDSA"] = 1302] = "CLIENT_TEST_EDDSA";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_TEST_EDDSA"] = 1303] = "EXCHANGE_TEST_EDDSA";
  TalerSignaturePurpose2[TalerSignaturePurpose2["AML_DECISION"] = 1350] = "AML_DECISION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["AML_QUERY"] = 1351] = "AML_QUERY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["KYC_AUTH"] = 1360] = "KYC_AUTH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["ANASTASIS_POLICY_UPLOAD"] = 1400] = "ANASTASIS_POLICY_UPLOAD";
  TalerSignaturePurpose2[TalerSignaturePurpose2["SYNC_BACKUP_UPLOAD"] = 1450] = "SYNC_BACKUP_UPLOAD";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MAILBOX_MESSAGES_DELETE"] = 1551] = "MAILBOX_MESSAGES_DELETE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MAILBOX_KEYS_UPDATE"] = 1552] = "MAILBOX_KEYS_UPDATE";
})(TalerSignaturePurpose || (TalerSignaturePurpose = {}));

// ../taler-util/lib/taler-crypto.js
var isEddsaPubP = Symbol("isEddsaPubP");
var isEddsaPrivP = Symbol("isEddsaPrivP");
var isEddsaSigP = Symbol("isEddsaSigP");
var isEdx25519PublicKey = Symbol("isEdx25519PublicKey");
var isEdx25519PrivateKey = Symbol("isEdx25519PrivateKey");
var isEcdhePrivP = Symbol("isEcdhePrivP");
var isEdx25519Signature = Symbol("isEdx25519Signature");
var isEdx25519PublicKeyEnc = Symbol("isEdx25519PublicKeyEnc");
var isEdx25519PrivateKeyEnc = Symbol("isEdx25519PrivateKeyEnc");
var isEncryptionNonce = Symbol("isEncryptionNone");
function getRandomBytes(n2) {
  return randomBytes(n2);
}
var useNative = true;
var tart;
if (useNative) {
  tart = globalThis._tart;
}
var encTable = "0123456789ABCDEFGHJKMNPQRSTVWXYZ";
var EncodingError = class _EncodingError extends Error {
  constructor() {
    super("Encoding error");
    Object.setPrototypeOf(this, _EncodingError.prototype);
  }
};
function getValue(chr) {
  let a6 = chr;
  switch (chr) {
    case "O":
    case "o":
      a6 = "0";
      break;
    case "i":
    case "I":
    case "l":
    case "L":
      a6 = "1";
      break;
    case "u":
    case "U":
      a6 = "V";
  }
  if (a6 >= "0" && a6 <= "9") {
    return a6.charCodeAt(0) - "0".charCodeAt(0);
  }
  if (a6 >= "a" && a6 <= "z")
    a6 = a6.toUpperCase();
  let dec = 0;
  if (a6 >= "A" && a6 <= "Z") {
    if ("I" < a6)
      dec++;
    if ("L" < a6)
      dec++;
    if ("O" < a6)
      dec++;
    if ("U" < a6)
      dec++;
    return a6.charCodeAt(0) - "A".charCodeAt(0) + 10 - dec;
  }
  throw new EncodingError();
}
function encodeCrock(data) {
  if (tart) {
    return tart.encodeCrock(data);
  }
  const dataBytes = new Uint8Array(data);
  let sb = "";
  const size = data.byteLength;
  let bitBuf = 0;
  let numBits = 0;
  let pos = 0;
  while (pos < size || numBits > 0) {
    if (pos < size && numBits < 5) {
      const d6 = dataBytes[pos++];
      bitBuf = bitBuf << 8 | d6;
      numBits += 8;
    }
    if (numBits < 5) {
      bitBuf = bitBuf << 5 - numBits;
      numBits = 5;
    }
    const v3 = bitBuf >>> numBits - 5 & 31;
    sb += encTable[v3];
    numBits -= 5;
  }
  return sb;
}
function kdf(outputLength, ikm, salt, info) {
  if (tart) {
    return tart.kdf(outputLength, ikm, salt, info);
  }
  salt = salt ?? new Uint8Array(64);
  const prk = hmacSha512(salt, ikm);
  info = info ?? new Uint8Array(0);
  const N3 = Math.ceil(outputLength / 32);
  const output = new Uint8Array(N3 * 32);
  for (let i5 = 0; i5 < N3; i5++) {
    let buf;
    if (i5 == 0) {
      buf = new Uint8Array(info.byteLength + 1);
      buf.set(info, 0);
    } else {
      buf = new Uint8Array(info.byteLength + 1 + 32);
      for (let j4 = 0; j4 < 32; j4++) {
        buf[j4] = output[(i5 - 1) * 32 + j4];
      }
      buf.set(info, 32);
    }
    buf[buf.length - 1] = i5 + 1;
    const chunk = hmacSha256(prk, buf);
    output.set(chunk, i5 * 32);
  }
  return output.slice(0, outputLength);
}
function kdfKw(args) {
  return kdf(args.outputLength, args.ikm, args.salt, args.info);
}
function decodeCrock(encoded) {
  if (tart) {
    return tart.decodeCrock(encoded);
  }
  const size = encoded.length;
  let bitpos = 0;
  let bitbuf = 0;
  let readPosition = 0;
  const outLen = Math.floor(size * 5 / 8);
  const out = new Uint8Array(outLen);
  let outPos = 0;
  while (readPosition < size || bitpos > 0) {
    if (readPosition < size) {
      const v3 = getValue(encoded[readPosition++]);
      bitbuf = bitbuf << 5 | v3;
      bitpos += 5;
    }
    while (bitpos >= 8) {
      const d6 = bitbuf >>> bitpos - 8 & 255;
      out[outPos++] = d6;
      bitpos -= 8;
    }
    if (readPosition == size && bitpos > 0) {
      bitbuf = bitbuf << 8 - bitpos & 255;
      bitpos = bitbuf == 0 ? 0 : 8;
    }
  }
  return out;
}
function eddsaGetPublic(eddsaPriv) {
  if (tart) {
    return tart.eddsaGetPublic(eddsaPriv);
  }
  const pair = crypto_sign_keyPair_fromSeed(eddsaPriv);
  return pair.publicKey;
}
var encoder;
function stringToBytes(s6) {
  if (!encoder) {
    encoder = new TextEncoder();
  }
  return encoder.encode(s6);
}
function typedArrayConcat(chunks) {
  let payloadLen = 0;
  for (const c5 of chunks) {
    payloadLen += c5.byteLength;
  }
  const buf = new ArrayBuffer(payloadLen);
  const u8buf = new Uint8Array(buf);
  let p4 = 0;
  for (const c5 of chunks) {
    u8buf.set(c5, p4);
    p4 += c5.byteLength;
  }
  return u8buf;
}
function createEddsaKeyPair() {
  const eddsaPriv = randomBytes(32);
  const eddsaPub = eddsaGetPublic(eddsaPriv);
  return { eddsaPriv, eddsaPub };
}
function hash2(d6) {
  if (tart) {
    return tart.hash(d6);
  }
  return hash(d6);
}
function hashTruncate32(d6) {
  const sha512HashCode = hash2(d6);
  return sha512HashCode.subarray(0, 32);
}
var logger4 = new Logger("talerCrypto.ts");
function eddsaSign(msg, eddsaPriv) {
  if (tart) {
    return tart.eddsaSign(msg, eddsaPriv);
  }
  const pair = crypto_sign_keyPair_fromSeed(eddsaPriv);
  return sign_detached(msg, pair.secretKey);
}
function bufferForUint32(n2) {
  const arrBuf = new ArrayBuffer(4);
  const buf = new Uint8Array(arrBuf);
  const dv = new DataView(arrBuf);
  dv.setUint32(0, n2);
  return buf;
}
function bufferForUint64(n2) {
  const arrBuf = new ArrayBuffer(8);
  const buf = new Uint8Array(arrBuf);
  const dv = new DataView(arrBuf);
  if (n2 < 0 || !Number.isInteger(n2)) {
    throw Error("non-negative integer expected");
  }
  dv.setBigUint64(0, BigInt(n2));
  return buf;
}
var WalletAccountMergeFlags;
(function(WalletAccountMergeFlags2) {
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["None"] = 0] = "None";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["MergeFullyPaidPurse"] = 1] = "MergeFullyPaidPurse";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["CreateFromPurseQuota"] = 2] = "CreateFromPurseQuota";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["CreateWithPurseFee"] = 3] = "CreateWithPurseFee";
})(WalletAccountMergeFlags || (WalletAccountMergeFlags = {}));
var SignaturePurposeBuilder = class {
  constructor(purposeNum) {
    this.purposeNum = purposeNum;
    this.chunks = [];
  }
  put(bytes) {
    this.chunks.push(Uint8Array.from(bytes));
    return this;
  }
  build() {
    let payloadLen = 0;
    for (const c5 of this.chunks) {
      payloadLen += c5.byteLength;
    }
    const buf = new ArrayBuffer(4 + 4 + payloadLen);
    const u8buf = new Uint8Array(buf);
    let p4 = 8;
    for (const c5 of this.chunks) {
      u8buf.set(c5, p4);
      p4 += c5.byteLength;
    }
    const dvbuf = new DataView(buf);
    dvbuf.setUint32(0, payloadLen + 4 + 4);
    dvbuf.setUint32(4, this.purposeNum);
    return u8buf;
  }
};
function buildSigPS(purposeNum) {
  return new SignaturePurposeBuilder(purposeNum);
}
function bigintToNaclArr(x6, size) {
  const byteArr = new Uint8Array(size);
  const arr = x6.toArray(256).value.reverse();
  byteArr.set(arr, 0);
  return byteArr;
}
function bigintFromNaclArr(arr) {
  let rev = new Uint8Array(arr);
  rev = rev.reverse();
  return import_big_integer.default.fromArray(Array.from(rev), 256, false);
}
var Edx25519;
(function(Edx255192) {
  const revL = [
    237,
    211,
    245,
    92,
    26,
    99,
    18,
    88,
    214,
    156,
    247,
    162,
    222,
    249,
    222,
    20,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    16
  ];
  const L6 = import_big_integer.default.fromArray(revL.reverse(), 256, false);
  async function keyCreateFromSeed(seed) {
    return crypto_edx25519_private_key_create_from_seed(seed);
  }
  Edx255192.keyCreateFromSeed = keyCreateFromSeed;
  async function keyCreate() {
    return crypto_edx25519_private_key_create();
  }
  Edx255192.keyCreate = keyCreate;
  async function getPublic(priv) {
    return crypto_edx25519_get_public(priv);
  }
  Edx255192.getPublic = getPublic;
  function sign2(msg, key) {
    throw Error("not implemented");
  }
  Edx255192.sign = sign2;
  async function deriveFactor(pub, seed) {
    const res = kdfKw({
      outputLength: 64,
      ikm: pub,
      salt: stringToBytes("edx25519-derivation"),
      info: seed
    });
    return res;
  }
  async function privateKeyDerive(priv, seed) {
    const pub = await getPublic(priv);
    const privDec = priv;
    const a6 = bigintFromNaclArr(privDec.subarray(0, 32));
    const factorEnc = await deriveFactor(pub, seed);
    const factorModL = bigintFromNaclArr(factorEnc).mod(L6);
    const aPrime = a6.divide(8).multiply(factorModL).mod(L6).multiply(8).mod(L6);
    const bPrime = hash(typedArrayConcat([privDec.subarray(32, 64), factorEnc])).subarray(0, 32);
    const newPriv = typedArrayConcat([bigintToNaclArr(aPrime, 32), bPrime]);
    return newPriv;
  }
  Edx255192.privateKeyDerive = privateKeyDerive;
  async function publicKeyDerive(pub, seed) {
    const factorEnc = await deriveFactor(pub, seed);
    const factorReduced = crypto_core_ed25519_scalar_reduce(factorEnc);
    const res = crypto_scalarmult_ed25519_noclamp(factorReduced, pub);
    return res;
  }
  Edx255192.publicKeyDerive = publicKeyDerive;
})(Edx25519 || (Edx25519 = {}));
function invariant(cond) {
  if (!cond) {
    throw Error("invariant failed");
  }
}
var AgeRestriction;
(function(AgeRestriction2) {
  AgeRestriction2.AGE_UNRESTRICTED = 32;
  function hashCommitment(ac) {
    const hc = new HashState();
    for (const pub of ac.publicKeys) {
      hc.update(decodeCrock(pub));
    }
    return encodeCrock(hc.finish().subarray(0, 32));
  }
  AgeRestriction2.hashCommitment = hashCommitment;
  function countAgeGroups(mask) {
    let count = 0;
    let m6 = mask;
    while (m6 > 0) {
      count += m6 & 1;
      m6 = m6 >> 1;
    }
    return count;
  }
  AgeRestriction2.countAgeGroups = countAgeGroups;
  function getAgeGroupsFromMask(mask) {
    const groups = [];
    let age = 1;
    let m6 = mask >> 1;
    while (m6 > 0) {
      if (m6 & 1) {
        groups.push(age);
      }
      m6 = m6 >> 1;
      age++;
    }
    return groups;
  }
  AgeRestriction2.getAgeGroupsFromMask = getAgeGroupsFromMask;
  function getAgeGroupIndex(mask, age) {
    invariant((mask & 1) === 1);
    let i5 = 0;
    let m6 = mask;
    let a6 = age;
    while (m6 > 0) {
      if (a6 <= 0) {
        break;
      }
      m6 = m6 >> 1;
      i5 += m6 & 1;
      a6--;
    }
    return i5;
  }
  AgeRestriction2.getAgeGroupIndex = getAgeGroupIndex;
  function ageGroupSpecToMask(ageGroupSpec) {
    throw Error("not implemented");
  }
  AgeRestriction2.ageGroupSpecToMask = ageGroupSpecToMask;
  async function restrictionCommit(ageMask, age) {
    invariant((ageMask & 1) === 1);
    const numPubs = countAgeGroups(ageMask) - 1;
    const numPrivs = getAgeGroupIndex(ageMask, age);
    const pubs = [];
    const privs = [];
    for (let i5 = 0; i5 < numPubs; i5++) {
      const priv = await Edx25519.keyCreate();
      const pub = await Edx25519.getPublic(priv);
      pubs.push(pub);
      if (i5 < numPrivs) {
        privs.push(priv);
      }
    }
    return {
      commitment: {
        mask: ageMask,
        publicKeys: pubs.map((x6) => encodeCrock(x6))
      },
      proof: {
        privateKeys: privs.map((x6) => encodeCrock(x6))
      }
    };
  }
  AgeRestriction2.restrictionCommit = restrictionCommit;
  const PublishedAgeRestrictionBaseKey = decodeCrock("CH0VKFDZ2GWRWHQBBGEK9MWV5YDQVJ0RXEE0KYT3NMB69F0R96TG");
  async function restrictionCommitSeeded(ageMask, age, seed) {
    invariant((ageMask & 1) === 1);
    const numPubs = countAgeGroups(ageMask) - 1;
    const numPrivs = getAgeGroupIndex(ageMask, age);
    const pubs = [];
    const privs = [];
    for (let i5 = 0; i5 < numPrivs; i5++) {
      const privSeed = await kdfKw({
        outputLength: 32,
        ikm: seed,
        info: stringToBytes("age-commitment"),
        salt: bufferForUint32(i5)
      });
      const priv = await Edx25519.keyCreateFromSeed(privSeed);
      const pub = await Edx25519.getPublic(priv);
      pubs.push(pub);
      privs.push(priv);
    }
    for (let i5 = numPrivs; i5 < numPubs; i5++) {
      const deriveSeed = await kdfKw({
        outputLength: 32,
        ikm: seed,
        info: stringToBytes("age-factor"),
        salt: bufferForUint32(i5)
      });
      const pub = await Edx25519.publicKeyDerive(PublishedAgeRestrictionBaseKey, deriveSeed);
      pubs.push(pub);
    }
    return {
      commitment: {
        mask: ageMask,
        publicKeys: pubs.map((x6) => encodeCrock(x6))
      },
      proof: {
        privateKeys: privs.map((x6) => encodeCrock(x6))
      }
    };
  }
  AgeRestriction2.restrictionCommitSeeded = restrictionCommitSeeded;
  async function commitCompare(c1, c22, salt) {
    if (c1.publicKeys.length != c22.publicKeys.length) {
      return false;
    }
    for (let i5 = 0; i5 < c1.publicKeys.length; i5++) {
      const k1 = decodeCrock(c1.publicKeys[i5]);
      const k22 = await Edx25519.publicKeyDerive(decodeCrock(c22.publicKeys[i5]), salt);
      if (k1 != k22) {
        return false;
      }
    }
    return true;
  }
  AgeRestriction2.commitCompare = commitCompare;
  async function commitmentDerive(commitmentProof, salt) {
    const newPrivs = [];
    const newPubs = [];
    for (const oldPub of commitmentProof.commitment.publicKeys) {
      newPubs.push(await Edx25519.publicKeyDerive(decodeCrock(oldPub), salt));
    }
    for (const oldPriv of commitmentProof.proof.privateKeys) {
      newPrivs.push(await Edx25519.privateKeyDerive(decodeCrock(oldPriv), salt));
    }
    return {
      commitment: {
        mask: commitmentProof.commitment.mask,
        publicKeys: newPubs.map((x6) => encodeCrock(x6))
      },
      proof: {
        privateKeys: newPrivs.map((x6) => encodeCrock(x6))
      }
    };
  }
  AgeRestriction2.commitmentDerive = commitmentDerive;
  function commitmentAttest(commitmentProof, age) {
    const d6 = buildSigPS(TalerSignaturePurpose.WALLET_AGE_ATTESTATION).put(bufferForUint32(commitmentProof.commitment.mask)).put(bufferForUint32(age)).build();
    const group = getAgeGroupIndex(commitmentProof.commitment.mask, age);
    if (group === 0) {
      return new Uint8Array(64);
    }
    const priv = commitmentProof.proof.privateKeys[group - 1];
    const pub = commitmentProof.commitment.publicKeys[group - 1];
    const sig = crypto_edx25519_sign_detached(d6, decodeCrock(priv), decodeCrock(pub));
    return sig;
  }
  AgeRestriction2.commitmentAttest = commitmentAttest;
  function commitmentVerify(commitment, sig, age) {
    const d6 = buildSigPS(TalerSignaturePurpose.WALLET_AGE_ATTESTATION).put(bufferForUint32(commitment.mask)).put(bufferForUint32(age)).build();
    const group = getAgeGroupIndex(commitment.mask, age);
    if (group === 0) {
      return true;
    }
    const pub = commitment.publicKeys[group - 1];
    return crypto_edx25519_sign_detached_verify(d6, decodeCrock(sig), decodeCrock(pub));
  }
  AgeRestriction2.commitmentVerify = commitmentVerify;
})(AgeRestriction || (AgeRestriction = {}));
async function deriveKey(keySeed, nonce, salt) {
  return kdfKw({
    outputLength: 32,
    salt: nonce,
    ikm: keySeed,
    info: stringToBytes(salt)
  });
}
async function encryptWithDerivedKey(nonce, keySeed, plaintext, salt) {
  const key = await deriveKey(keySeed, nonce, salt);
  const cipherText = secretbox(plaintext, nonce, key);
  return typedArrayConcat([nonce, cipherText]);
}
var nonceSize = 24;
async function decryptWithDerivedKey(ciphertext, keySeed, salt) {
  const ctBuf = ciphertext;
  const nonceBuf = ctBuf.slice(0, nonceSize);
  const enc = ctBuf.slice(nonceSize);
  const key = await deriveKey(keySeed, nonceBuf, salt);
  const clearText = secretbox_open(enc, nonceBuf, key);
  if (!clearText) {
    throw Error("could not decrypt");
  }
  return clearText;
}
var ContractFormatTag;
(function(ContractFormatTag2) {
  ContractFormatTag2[ContractFormatTag2["PaymentOffer"] = 0] = "PaymentOffer";
  ContractFormatTag2[ContractFormatTag2["PaymentRequest"] = 1] = "PaymentRequest";
})(ContractFormatTag || (ContractFormatTag = {}));
var foreverNum = 2n ** 64n - 1n;
function timestampRoundedToBuffer(ts) {
  const b5 = new ArrayBuffer(8);
  const v3 = new DataView(b5);
  const numVal = ts.t_s === "never" ? foreverNum : BigInt(ts.t_s) * 1000n * 1000n;
  if (typeof v3.setBigUint64 !== "undefined") {
    v3.setBigUint64(0, numVal);
  } else {
    const s6 = ts.t_s === "never" ? (0, import_big_integer.default)(foreverNum) : (0, import_big_integer.default)(ts.t_s).multiply(1e3 * 1e3);
    const arr = s6.toArray(2 ** 8).value;
    let offset = 8 - arr.length;
    for (let i5 = 0; i5 < arr.length; i5++) {
      v3.setUint8(offset++, arr[i5]);
    }
  }
  return new Uint8Array(b5);
}
var HpkeRole;
(function(HpkeRole2) {
  HpkeRole2[HpkeRole2["Sender"] = 0] = "Sender";
  HpkeRole2[HpkeRole2["Receiver"] = 1] = "Receiver";
})(HpkeRole || (HpkeRole = {}));
var HpkeMode;
(function(HpkeMode2) {
  HpkeMode2[HpkeMode2["Base"] = 0] = "Base";
  HpkeMode2[HpkeMode2["PSK"] = 1] = "PSK";
})(HpkeMode || (HpkeMode = {}));

// ../taler-util/lib/types-taler-merchant.js
var MerchantContractVersion;
(function(MerchantContractVersion2) {
  MerchantContractVersion2[MerchantContractVersion2["V0"] = 0] = "V0";
  MerchantContractVersion2[MerchantContractVersion2["V1"] = 1] = "V1";
})(MerchantContractVersion || (MerchantContractVersion = {}));
var MerchantContractInputType;
(function(MerchantContractInputType2) {
  MerchantContractInputType2["Token"] = "token";
})(MerchantContractInputType || (MerchantContractInputType = {}));
var MerchantContractOutputType;
(function(MerchantContractOutputType2) {
  MerchantContractOutputType2["Token"] = "token";
  MerchantContractOutputType2["TaxReceipt"] = "tax-receipt";
})(MerchantContractOutputType || (MerchantContractOutputType = {}));
var MerchantContractTokenKind;
(function(MerchantContractTokenKind2) {
  MerchantContractTokenKind2["Subscription"] = "subscription";
  MerchantContractTokenKind2["Discount"] = "discount";
})(MerchantContractTokenKind || (MerchantContractTokenKind = {}));
var codecForLocation = () => buildCodecForObject().property("country", codecOptional(codecForString())).property("country_subdivision", codecOptional(codecForString())).property("building_name", codecOptional(codecForString())).property("building_number", codecOptional(codecForString())).property("district", codecOptional(codecForString())).property("street", codecOptional(codecForString())).property("post_code", codecOptional(codecForString())).property("town", codecOptional(codecForString())).property("town_location", codecOptional(codecForString())).property("address_lines", codecOptional(codecForList(codecForString()))).build("Location");
var codecForMerchantInfo = () => buildCodecForObject().property("name", codecForString()).property("address", codecOptional(codecForLocation())).property("jurisdiction", codecOptional(codecForLocation())).build("MerchantInfo");
var codecForMerchantContractTermsCommon = () => buildCodecForObject().property("order_id", codecForString()).property("fulfillment_url", codecOptional(codecForString())).property("fulfillment_message", codecOptional(codecForString())).property("fulfillment_message_i18n", codecOptional(codecForInternationalizedString())).property("public_reorder_url", codecOptional(codecForString())).property("merchant_base_url", codecForString()).property("h_wire", codecForString()).property("auto_refund", codecOptional(codecForDuration)).property("wire_method", codecForString()).property("summary", codecForString()).property("summary_i18n", codecOptional(codecForInternationalizedString())).property("nonce", codecForString()).property("pay_deadline", codecForTimestamp).property("refund_deadline", codecForTimestamp).property("wire_transfer_deadline", codecForTimestamp).property("timestamp", codecForTimestamp).property("delivery_location", codecOptional(codecForLocation())).property("delivery_date", codecOptional(codecForTimestamp)).property("merchant", codecForMerchantInfo()).property("merchant_pub", codecForString()).property("exchanges", codecForList(codecForExchange())).property("products", codecOptional(codecForList(codecForProduct()))).property("extra", codecForAny()).property("minimum_age", codecOptional(codecForNumber())).build("TalerMerchantApi.ContractTermsCommon");
var codecForMerchantContractTermsV0 = () => buildCodecForObject().property("version", codecOptional(codecForConstNumber(MerchantContractVersion.V0))).property("amount", codecForAmountString()).property("max_fee", codecForAmountString()).mixin(codecForMerchantContractTermsCommon()).build("TalerMerchantApi.ContractTermsV0");
var codecForMerchantContractTermsV1 = () => buildCodecForObject().property("version", codecForConstNumber(MerchantContractVersion.V1)).property("choices", codecForList(codecForMerchantContractChoice())).property("token_families", codecForMap(codecForMerchantContractTokenFamily())).mixin(codecForMerchantContractTermsCommon()).build("TalerMerchantApi.ContractTermsV1");
var codecForMerchantContractTerms = () => buildCodecForUnion().discriminateOn("version").alternative(void 0, codecForMerchantContractTermsV0()).alternative(MerchantContractVersion.V0, codecForMerchantContractTermsV0()).alternative(MerchantContractVersion.V1, codecForMerchantContractTermsV1()).build("TalerMerchantApi.ContractTerms");
var codecForMerchantContractChoice = () => buildCodecForObject().property("amount", codecForAmountString()).property("description", codecOptional(codecForString())).property("description_i18n", codecOptional(codecForInternationalizedString())).property("inputs", codecForList(codecForMerchantContractInput())).property("outputs", codecForList(codecForMerchantContractOutput())).property("max_fee", codecForAmountString()).build("TalerMerchantApi.ContractChoice");
var codecForMerchantContractInput = () => buildCodecForUnion().discriminateOn("type").alternative(MerchantContractInputType.Token, codecForMerchantContractInputToken()).build("TalerMerchantApi.ContractInput");
var codecForMerchantContractInputToken = () => buildCodecForObject().property("type", codecForConstString(MerchantContractInputType.Token)).property("token_family_slug", codecForString()).property("count", codecOptional(codecForNumber())).build("TalerMerchantApi.ContractInputToken");
var codecForMerchantContractOutput = () => buildCodecForUnion().discriminateOn("type").alternative(MerchantContractOutputType.Token, codecForMerchantContractOutputToken()).alternative(MerchantContractOutputType.TaxReceipt, codecForMerchantContractOutputTaxReceipt()).build("TalerMerchantApi.ContractOutput");
var codecForMerchantContractOutputToken = () => buildCodecForObject().property("type", codecForConstString(MerchantContractOutputType.Token)).property("token_family_slug", codecForString()).property("count", codecOptional(codecForNumber())).property("key_index", codecForNumber()).build("TalerMerchantApi.ContractOutputToken");
var codecForMerchantContractOutputTaxReceipt = () => buildCodecForObject().property("type", codecForConstString(MerchantContractOutputType.TaxReceipt)).property("donau_urls", codecForList(codecForString())).property("amount", codecOptional(codecForAmountString())).build("TalerMerchantApi.ContractOutputTaxReceipt");
var codecForMerchantContractTokenFamily = () => buildCodecForObject().property("name", codecForString()).property("description", codecForString()).property("description_i18n", codecOptional(codecForInternationalizedString())).property("keys", codecForList(codecForTokenIssuePublicKey())).property("details", codecForMerchantContractTokenDetails()).property("critical", codecForBoolean()).build("TalerMerchantApi.ContractTokenFamily");
var codecForTokenIssuePublicKey = () => buildCodecForUnion().discriminateOn("cipher").alternative("RSA", codecForTokenIssueRsaPublicKey()).alternative("CS", codecForTokenIssueCsPublicKey()).build("TalerMerchantApi.TokenIssuePublicKey");
var codecForTokenIssueRsaPublicKey = () => buildCodecForObject().property("cipher", codecForConstString("RSA")).property("rsa_pub", codecForString()).property("signature_validity_start", codecForTimestamp).property("signature_validity_end", codecForTimestamp).build("TalerMerchantApi.TokenIssueRsaPublicKey");
var codecForTokenIssueCsPublicKey = () => buildCodecForObject().property("cipher", codecForConstString("CS")).property("cs_pub", codecForString()).property("signature_validity_start", codecForTimestamp).property("signature_validity_end", codecForTimestamp).build("TalerMerchantApi.TokenIssueRsaPublicKey");
var codecForMerchantContractTokenDetails = () => buildCodecForUnion().discriminateOn("class").alternative(MerchantContractTokenKind.Subscription, codecForMerchantContractSubscriptionTokenDetails()).alternative(MerchantContractTokenKind.Discount, codecForMerchantContractDiscountTokenDetails()).build("TalerMerchantApi.ContractTokenDetails");
var codecForMerchantContractSubscriptionTokenDetails = () => buildCodecForObject().property("class", codecForConstString(MerchantContractTokenKind.Subscription)).property("trusted_domains", codecForList(codecForString())).build("TalerMerchantApi.ContractSubscriptionTokenDetails");
var codecForMerchantContractDiscountTokenDetails = () => buildCodecForObject().property("class", codecForConstString(MerchantContractTokenKind.Discount)).property("expected_domains", codecForList(codecForString())).build("TalerMerchantApi.ContractDiscountTokenDetails");
var RoundingInterval;
(function(RoundingInterval2) {
  RoundingInterval2["NONE"] = "NONE";
  RoundingInterval2["SECOND"] = "SECOND";
  RoundingInterval2["MINUTE"] = "MINUTE";
  RoundingInterval2["HOUR"] = "HOUR";
  RoundingInterval2["DAY"] = "DAY";
  RoundingInterval2["WEEK"] = "WEEK";
  RoundingInterval2["MONTH"] = "MONTH";
  RoundingInterval2["QUARTER"] = "QUARTER";
  RoundingInterval2["YEAR"] = "YEAR";
})(RoundingInterval || (RoundingInterval = {}));
var KycStatusLongPollingReason;
(function(KycStatusLongPollingReason2) {
  KycStatusLongPollingReason2[KycStatusLongPollingReason2["AUTH_TRANSFER"] = 1] = "AUTH_TRANSFER";
  KycStatusLongPollingReason2[KycStatusLongPollingReason2["AML_INVESTIGATION"] = 2] = "AML_INVESTIGATION";
  KycStatusLongPollingReason2[KycStatusLongPollingReason2["TO_BE_OK"] = 3] = "TO_BE_OK";
})(KycStatusLongPollingReason || (KycStatusLongPollingReason = {}));
var LoginTokenScope;
(function(LoginTokenScope2) {
  LoginTokenScope2["ReadOnly"] = "readonly";
  LoginTokenScope2["All"] = "all";
  LoginTokenScope2["Spa"] = "spa";
  LoginTokenScope2["OrderSimple"] = "order-simple";
  LoginTokenScope2["OrderPos"] = "order-pos";
  LoginTokenScope2["OrderManagement"] = "order-mgmt";
  LoginTokenScope2["OrderFull"] = "order-full";
  LoginTokenScope2["ReadOnly_Refreshable"] = "readonly:refreshable";
  LoginTokenScope2["All_Refreshable"] = "all:refreshable";
  LoginTokenScope2["Spa_Refreshable"] = "spa:refreshable";
  LoginTokenScope2["OrderSimple_Refreshable"] = "order-simple:refreshable";
  LoginTokenScope2["OrderPos_Refreshable"] = "order-pos:refreshable";
  LoginTokenScope2["OrderManagement_Refreshable"] = "order-mgmt:refreshable";
  LoginTokenScope2["OrderFull_Refreshable"] = "order-full:refreshable";
})(LoginTokenScope || (LoginTokenScope = {}));
var MerchantAuthMethod;
(function(MerchantAuthMethod2) {
  MerchantAuthMethod2["TOKEN"] = "token";
})(MerchantAuthMethod || (MerchantAuthMethod = {}));
var MerchantAccountKycStatus;
(function(MerchantAccountKycStatus2) {
  MerchantAccountKycStatus2["NO_EXCHANGE_KEY"] = "no-exchange-keys";
  MerchantAccountKycStatus2["KYC_WIRE_IMPOSSIBLE"] = "kyc-wire-impossible";
  MerchantAccountKycStatus2["KYC_WIRE_REQUIRED"] = "kyc-wire-required";
  MerchantAccountKycStatus2["KYC_REQUIRED"] = "kyc-required";
  MerchantAccountKycStatus2["AWAITING_AML_REVIEW"] = "awaiting-aml-review";
  MerchantAccountKycStatus2["READY"] = "ready";
  MerchantAccountKycStatus2["LOGIC_BUG"] = "logic-bug";
  MerchantAccountKycStatus2["EXCHANGE_INTERNAL_ERROR"] = "exchange-internal-error";
  MerchantAccountKycStatus2["EXCHANGE_GATEWAY_TIMEOUT"] = "exchange-gateway-timeout";
  MerchantAccountKycStatus2["EXCHANGE_UNREACHABLE"] = "exchange-unreachable";
  MerchantAccountKycStatus2["EXCHANGE_STATUS_INVALID"] = "exchange-status-invalid";
})(MerchantAccountKycStatus || (MerchantAccountKycStatus = {}));
var MerchantAccountKycStatusSimplified;
(function(MerchantAccountKycStatusSimplified2) {
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["OK"] = 0] = "OK";
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["ACTION_REQUIRED"] = 100] = "ACTION_REQUIRED";
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["WARNING"] = 200] = "WARNING";
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["ERROR"] = 300] = "ERROR";
})(MerchantAccountKycStatusSimplified || (MerchantAccountKycStatusSimplified = {}));
var TokenFamilyKind;
(function(TokenFamilyKind2) {
  TokenFamilyKind2["Discount"] = "discount";
  TokenFamilyKind2["Subscription"] = "subscription";
})(TokenFamilyKind || (TokenFamilyKind = {}));
var StatisticBucketRange;
(function(StatisticBucketRange2) {
  StatisticBucketRange2["Hour"] = "hour";
  StatisticBucketRange2["Day"] = "day";
  StatisticBucketRange2["Week"] = "week";
  StatisticBucketRange2["Month"] = "month";
  StatisticBucketRange2["Quarter"] = "quarter";
  StatisticBucketRange2["Year"] = "year";
})(StatisticBucketRange || (StatisticBucketRange = {}));
var OrderInputType;
(function(OrderInputType2) {
  OrderInputType2["Token"] = "token";
})(OrderInputType || (OrderInputType = {}));
var OrderOutputType;
(function(OrderOutputType2) {
  OrderOutputType2["Token"] = "token";
  OrderOutputType2["TaxReceipt"] = "tax-receipt";
})(OrderOutputType || (OrderOutputType = {}));
var OrderVersion;
(function(OrderVersion2) {
  OrderVersion2[OrderVersion2["V0"] = 0] = "V0";
  OrderVersion2[OrderVersion2["V1"] = 1] = "V1";
})(OrderVersion || (OrderVersion = {}));
var codecForExchangeConfigInfo = () => buildCodecForObject().property("base_url", codecForString()).property("currency", codecForString()).property("master_pub", codecForEddsaPublicKey()).build("TalerMerchantApi.ExchangeConfigInfo");
var codecForTalerMerchantConfigResponse = () => buildCodecForObject().property("name", codecForConstString("taler-merchant")).property("currency", codecForString()).property("default_persona", codecOptionalDefault(codecForEither(codecForConstString("expert"), codecForConstString("offline-vending-machine"), codecForConstString("point-of-sale"), codecForConstString("digital-publishing"), codecForConstString("e-commerce")), "expert")).property("version", codecForString()).property("currencies", codecForMap(codecForCurrencySpecificiation())).property("exchanges", codecForList(codecForExchangeConfigInfo())).property("implementation", codecOptional(codecForString())).property("have_self_provisioning", codecOptionalDefault(codecForBoolean(), false)).property("have_donau", codecOptionalDefault(codecForBoolean(), false)).property("mandatory_tan_channels", codecOptionalDefault(codecForList(codecForEither(codecForConstString(TanChannel.SMS), codecForConstString(TanChannel.EMAIL))), [])).property("default_pay_delay", codecOptional(codecForDuration)).property("default_refund_delay", codecOptional(codecForDuration)).property("default_wire_transfer_delay", codecOptional(codecForDuration)).property("payment_target_regex", codecOptionalDefault(codecForString(), "*")).property("payment_target_types", codecOptionalDefault(codecForString(), "*")).property("default_wire_transfer_rounding_interval", codecOptional(codecForRoundingInterval)).build("TalerMerchantApi.VersionResponse");
var codecForRoundingInterval = codecForEither(codecForConstString(RoundingInterval.NONE), codecForConstString(RoundingInterval.SECOND), codecForConstString(RoundingInterval.MINUTE), codecForConstString(RoundingInterval.HOUR), codecForConstString(RoundingInterval.DAY), codecForConstString(RoundingInterval.WEEK), codecForConstString(RoundingInterval.MONTH), codecForConstString(RoundingInterval.QUARTER), codecForConstString(RoundingInterval.YEAR));
var codecForClaimResponse = () => buildCodecForObject().property("contract_terms", codecForAny()).property("sig", codecForEddsaSignature()).build("TalerMerchantApi.ClaimResponse");
var codecForPaymentResponse = () => buildCodecForObject().property("pos_confirmation", codecOptional(codecForString())).property("sig", codecForEddsaSignature()).build("TalerMerchantApi.PaymentResponse");
var codecForPaymentDeniedLegallyResponse = () => buildCodecForObject().property("exchange_base_urls", codecOptionalDefault(codecForList(codecForString()), [])).build("TalerMerchantApi.PaymentDeniedLegallyResponse");
var codecForStatusPaid = () => buildCodecForObject().property("refund_amount", codecForAmountString()).property("refund_pending", codecForBoolean()).property("refund_taken", codecForAmountString()).property("refunded", codecForBoolean()).property("type", codecForConstString("paid")).build("TalerMerchantApi.StatusPaid");
var codecForStatusGoto = () => buildCodecForObject().property("public_reorder_url", codecForURLString()).property("type", codecForConstString("goto")).build("TalerMerchantApi.StatusGotoResponse");
var codecForStatusStatusUnpaid = () => buildCodecForObject().property("type", codecForConstString("unpaid")).property("already_paid_order_id", codecOptional(codecForString())).property("fulfillment_url", codecOptional(codecForString())).property("taler_pay_uri", codecForTalerUriString()).build("TalerMerchantApi.PaymentResponse");
var codecForPaidRefundStatusResponse = () => buildCodecForObject().property("pos_confirmation", codecOptional(codecForString())).property("refunded", codecForBoolean()).build("TalerMerchantApi.PaidRefundStatusResponse");
var codecForMerchantAbortPayRefundSuccessStatus = () => buildCodecForObject().property("exchange_pub", codecForString()).property("exchange_sig", codecForString()).property("exchange_status", codecForConstNumber(200)).property("type", codecForConstString("success")).build("TalerMerchantApi.MerchantAbortPayRefundSuccessStatus");
var codecForMerchantAbortPayRefundFailureStatus = () => buildCodecForObject().property("exchange_code", codecForNumber()).property("exchange_reply", codecForAny()).property("exchange_status", codecForNumber()).property("type", codecForConstString("failure")).build("TalerMerchantApi.MerchantAbortPayRefundFailureStatus");
var codecForMerchantAbortPayRefundUndepositedStatus = () => buildCodecForObject().property("type", codecForConstString("undeposited")).build("TalerMerchantApi.MerchantAbortPayRefundUndepositedStatus");
var codecForMerchantAbortPayRefundStatus = () => buildCodecForUnion().discriminateOn("type").alternative("success", codecForMerchantAbortPayRefundSuccessStatus()).alternative("failure", codecForMerchantAbortPayRefundFailureStatus()).alternative("undeposited", codecForMerchantAbortPayRefundUndepositedStatus()).build("TalerMerchantApi.MerchantAbortPayRefundStatus");
var codecForAbortResponse = () => buildCodecForObject().property("refunds", codecForList(codecForMerchantAbortPayRefundStatus())).build("TalerMerchantApi.AbortResponse");
var codecForWalletRefundResponse = () => buildCodecForObject().property("merchant_pub", codecForEddsaPublicKey()).property("refund_amount", codecForAmountString()).property("refunds", codecForList(codecForMerchantCoinRefundStatus())).build("TalerMerchantApi.AbortResponse");
var codecForMerchantCoinRefundSuccessStatus = () => buildCodecForObject().property("type", codecForConstString("success")).property("coin_pub", codecForEddsaPublicKey()).property("exchange_status", codecForConstNumber(200)).property("exchange_sig", codecForEddsaSignature()).property("rtransaction_id", codecForNumber()).property("refund_amount", codecForAmountString()).property("exchange_pub", codecForEddsaPublicKey()).property("execution_time", codecForTimestamp).build("TalerMerchantApi.MerchantCoinRefundSuccessStatus");
var codecForMerchantCoinRefundFailureStatus = () => buildCodecForObject().property("type", codecForConstString("failure")).property("coin_pub", codecForEddsaPublicKey()).property("exchange_status", codecForNumber()).property("rtransaction_id", codecForNumber()).property("refund_amount", codecForAmountString()).property("exchange_code", codecOptional(codecForNumber())).property("exchange_reply", codecOptional(codecForAny())).property("execution_time", codecForTimestamp).build("TalerMerchantApi.MerchantCoinRefundFailureStatus");
var codecForMerchantCoinRefundStatus = () => buildCodecForUnion().discriminateOn("type").alternative("success", codecForMerchantCoinRefundSuccessStatus()).alternative("failure", codecForMerchantCoinRefundFailureStatus()).build("TalerMerchantApi.MerchantCoinRefundStatus");
var codecForMerchantAuthMethod = codecForEither(codecForConstString(MerchantAuthMethod.TOKEN));
var codecForQueryInstancesResponse = () => buildCodecForObject().property("name", codecForString()).property("email", codecOptional(codecForString())).property("phone_number", codecOptional(codecForString())).property("website", codecOptional(codecForString())).property("email_validated", codecOptional(codecForBoolean())).property("phone_validated", codecOptional(codecForBoolean())).property("logo", codecOptional(codecForString())).property("merchant_pub", codecForEddsaPublicKey()).property("address", codecForLocation()).property("jurisdiction", codecForLocation()).property("use_stefan", codecForBoolean()).property("default_wire_transfer_delay", codecForDuration).property("default_pay_delay", codecForDuration).property("default_refund_delay", codecForDuration).property("default_wire_transfer_rounding_interval", codecOptional(codecForRoundingInterval)).property("auth", buildCodecForObject().property("method", codecForMerchantAuthMethod).build("TalerMerchantApi.QueryInstancesResponse.auth")).build("TalerMerchantApi.QueryInstancesResponse");
var codecForAccountKycRedirects = () => buildCodecForObject().property("kyc_data", codecForList(codecForMerchantAccountKycRedirect())).build("TalerMerchantApi.MerchantAccountKycRedirectsResponse");
var codecForMerchantAccountKycStatus = codecForEither(codecForConstString(MerchantAccountKycStatus.AWAITING_AML_REVIEW), codecForConstString(MerchantAccountKycStatus.EXCHANGE_GATEWAY_TIMEOUT), codecForConstString(MerchantAccountKycStatus.EXCHANGE_INTERNAL_ERROR), codecForConstString(MerchantAccountKycStatus.EXCHANGE_STATUS_INVALID), codecForConstString(MerchantAccountKycStatus.EXCHANGE_UNREACHABLE), codecForConstString(MerchantAccountKycStatus.KYC_REQUIRED), codecForConstString(MerchantAccountKycStatus.KYC_WIRE_IMPOSSIBLE), codecForConstString(MerchantAccountKycStatus.KYC_WIRE_REQUIRED), codecForConstString(MerchantAccountKycStatus.LOGIC_BUG), codecForConstString(MerchantAccountKycStatus.NO_EXCHANGE_KEY), codecForConstString(MerchantAccountKycStatus.READY));
var codecForMerchantAccountKycRedirect = () => buildCodecForObject().property("status", codecForMerchantAccountKycStatus).property("h_wire", codecForString()).property("payto_uri", codecForPaytoString()).property("exchange_url", codecForURLString()).property("exchange_http_status", codecForNumber()).property("no_keys", codecForBoolean()).property("auth_conflict", codecForBoolean()).property("exchange_code", codecOptional(codecForNumber())).property("access_token", codecOptional(codecForAccessToken())).property("limits", codecOptional(codecForList(codecForAccountLimit()))).property("payto_kycauths", codecOptional(codecForList(codecForString()))).build("TalerMerchantApi.MerchantAccountKycRedirect");
var codecForTokenScope = codecForEither(codecForConstString(LoginTokenScope.All), codecForConstString(LoginTokenScope.Spa), codecForConstString(LoginTokenScope.OrderFull), codecForConstString(LoginTokenScope.OrderManagement), codecForConstString(LoginTokenScope.OrderPos), codecForConstString(LoginTokenScope.OrderSimple), codecForConstString(LoginTokenScope.ReadOnly), codecForConstString(LoginTokenScope.All_Refreshable), codecForConstString(LoginTokenScope.Spa_Refreshable), codecForConstString(LoginTokenScope.OrderFull_Refreshable), codecForConstString(LoginTokenScope.OrderManagement_Refreshable), codecForConstString(LoginTokenScope.OrderPos_Refreshable), codecForConstString(LoginTokenScope.OrderSimple_Refreshable), codecForConstString(LoginTokenScope.ReadOnly_Refreshable));
var codecForLoginTokenSuccessResponse = () => buildCodecForObject().property("scope", codecForTokenScope).property("access_token", codecForAccessToken()).property("expiration", codecForTimestamp).property("refreshable", codecForBoolean()).build("TalerMerchantApi.LoginTokenSuccessResponse");
var codecForAccountAddResponse = () => buildCodecForObject().property("h_wire", codecForString()).property("salt", codecForString()).build("TalerMerchantApi.AccountAddResponse");
var codecForAccountsSummaryResponse = () => buildCodecForObject().property("accounts", codecForList(codecForBankAccountEntry())).build("TalerMerchantApi.AccountsSummaryResponse");
var codecForBankAccountEntry = () => buildCodecForObject().property("payto_uri", codecForPaytoString()).property("h_wire", codecForString()).property("active", codecOptional(codecForBoolean())).build("TalerMerchantApi.BankAccountEntry");
var codecForBankAccountDetail = () => buildCodecForObject().property("payto_uri", codecForPaytoString()).property("h_wire", codecForString()).property("salt", codecForString()).property("credit_facade_url", codecOptional(codecForURLString())).property("active", codecOptional(codecForBoolean())).build("TalerMerchantApi.BankAccountEntry");
var codecForCategoryListResponse = () => buildCodecForObject().property("categories", codecForList(codecForCategoryListEntry())).build("TalerMerchantApi.CategoryListResponse");
var codecForCategoryListEntry = () => buildCodecForObject().property("category_id", codecForNumber()).property("name", codecForString()).property("name_i18n", codecForInternationalizedString()).property("product_count", codecForNumber()).build("TalerMerchantApi.CategoryListEntry");
var codecForCategoryProductList = () => buildCodecForObject().property("name", codecForString()).property("name_i18n", codecForInternationalizedString()).property("products", codecForList(codecForProductSummary())).build("TalerMerchantApi.CategoryProductList");
var codecForProductSummary = () => buildCodecForObject().property("product_id", codecForString()).build("TalerMerchantApi.ProductSummary");
var codecForInventorySummaryResponse = () => buildCodecForObject().property("products", codecForList(codecForInventoryEntry())).build("TalerMerchantApi.InventorySummaryResponse");
var codecForInventoryEntry = () => buildCodecForObject().property("product_id", codecForString()).property("product_serial", codecForNumber()).build("TalerMerchantApi.InventoryEntry");
var codecForMerchantPosProductDetail = () => buildCodecForObject().property("product_serial", codecForNumber()).property("product_id", codecOptional(codecForString())).property("product_name", codecOptional(codecForString())).property("categories", codecForList(codecForNumber())).property("description", codecForString()).property("description_i18n", codecForInternationalizedString()).property("unit", codecForString()).property("price", codecForAmountString()).property("image", codecForString()).property("taxes", codecOptional(codecForList(codecForTax()))).property("total_stock", codecForNumber()).property("minimum_age", codecOptional(codecForNumber())).build("TalerMerchantApi.MerchantPosProductDetail");
var codecForProductDetail = () => buildCodecForObject().property("description", codecForString()).property("description_i18n", codecForInternationalizedString()).property("unit", codecForString()).property("product_name", codecOptional(codecForString())).property("price", codecForAmountString()).property("image", codecForString()).property("categories", codecForList(codecForNumber())).property("taxes", codecOptional(codecForList(codecForTax()))).property("address", codecOptional(codecForLocation())).property("next_restock", codecOptional(codecForTimestamp)).property("total_stock", codecForNumber()).property("total_sold", codecForNumber()).property("total_lost", codecForNumber()).property("minimum_age", codecOptional(codecForNumber())).build("TalerMerchantApi.ProductDetail");
var codecForTax = () => buildCodecForObject().property("name", codecForString()).property("tax", codecForAmountString()).build("TalerMerchantApi.Tax");
var codecForPostOrderResponse = () => buildCodecForObject().property("order_id", codecForString()).property("pay_deadline", codecOptional(codecForTimestamp)).property("token", codecOptional(codecForString())).build("TalerMerchantApi.PostOrderResponse");
var codecForOutOfStockResponse = () => buildCodecForObject().property("product_id", codecForString()).property("available_quantity", codecForNumber()).property("requested_quantity", codecForNumber()).property("restock_expected", codecForTimestamp).build("TalerMerchantApi.OutOfStockResponse");
var codecForOrderHistory = () => buildCodecForObject().property("orders", codecForList(codecForOrderHistoryEntry())).build("TalerMerchantApi.OrderHistory");
var codecForOrderHistoryEntry = () => buildCodecForObject().property("order_id", codecForString()).property("row_id", codecForNumber()).property("timestamp", codecForTimestamp).property("amount", codecForAmountString()).property("refund_amount", codecOptional(codecForAmountString())).property("pending_refund_amount", codecOptional(codecForAmountString())).property("summary", codecForString()).property("refundable", codecForBoolean()).property("paid", codecForBoolean()).build("TalerMerchantApi.OrderHistoryEntry");
var codecForExchange = () => buildCodecForObject().property("master_pub", codecForEddsaPublicKey()).property("priority", codecForNumber()).property("url", codecForString()).property("max_contribution", codecOptional(codecForAmountString())).build("TalerMerchantApi.Exchange");
var codecForProduct = () => buildCodecForObject().property("product_id", codecOptional(codecForString())).property("product_name", codecOptional(codecForString())).property("description", codecForString()).property("description_i18n", codecOptional(codecForInternationalizedString())).property("quantity", codecOptional(codecForNumber())).property("unit", codecOptional(codecForString())).property("price", codecOptional(codecForAmountString())).property("image", codecOptional(codecForString())).property("taxes", codecOptional(codecForList(codecForTax()))).property("delivery_date", codecOptional(codecForTimestamp)).build("TalerMerchantApi.Product");
var codecForCheckPaymentPaidResponse = () => buildCodecForObject().property("order_status", codecForConstString("paid")).property("refunded", codecForBoolean()).property("refund_pending", codecForBoolean()).property("wired", codecForBoolean()).property("deposit_total", codecForAmountString()).property("exchange_code", codecForNumber()).property("exchange_http_status", codecForNumber()).property("refund_amount", codecForAmountString()).property("contract_terms", codecForMerchantContractTerms()).property("choice_index", codecOptional(codecForNumber())).property("last_payment", codecForTimestamp).property("wire_reports", codecForList(codecForTransactionWireReport())).property("wire_details", codecForList(codecForTransactionWireTransfer())).property("refund_details", codecForList(codecForRefundDetails())).property("order_status_url", codecForURLString()).build("TalerMerchantApi.CheckPaymentPaidResponse");
var codecForCheckPaymentUnpaidResponse = () => buildCodecForObject().property("order_status", codecForConstString("unpaid")).property("taler_pay_uri", codecForTalerUriString()).property("creation_time", codecForTimestamp).property("pay_deadline", codecOptional(codecForTimestamp)).property("summary", codecForString()).property("total_amount", codecOptional(codecForAmountString())).property("already_paid_order_id", codecOptional(codecForString())).property("already_paid_fulfillment_url", codecOptional(codecForString())).property("order_status_url", codecForString()).build("TalerMerchantApi.CheckPaymentUnpaidResponse");
var codecForCheckPaymentClaimedResponse = () => buildCodecForObject().property("order_status", codecForConstString("claimed")).property("contract_terms", codecForMerchantContractTerms()).property("order_status_url", codecForString()).build("TalerMerchantApi.CheckPaymentClaimedResponse");
var codecForMerchantOrderPrivateStatusResponse = () => buildCodecForUnion().discriminateOn("order_status").alternative("paid", codecForCheckPaymentPaidResponse()).alternative("unpaid", codecForCheckPaymentUnpaidResponse()).alternative("claimed", codecForCheckPaymentClaimedResponse()).build("TalerMerchantApi.MerchantOrderStatusResponse");
var codecForRefundDetails = () => buildCodecForObject().property("reason", codecForString()).property("pending", codecForBoolean()).property("timestamp", codecForTimestamp).property("amount", codecForAmountString()).build("TalerMerchantApi.RefundDetails");
var codecForTransactionWireTransfer = () => buildCodecForObject().property("exchange_url", codecForURLString()).property("wtid", codecForString()).property("execution_time", codecForTimestamp).property("amount", codecForAmountString()).property("confirmed", codecForBoolean()).build("TalerMerchantApi.TransactionWireTransfer");
var codecForTransactionWireReport = () => buildCodecForObject().property("code", codecForNumber()).property("hint", codecForString()).property("exchange_code", codecForNumber()).property("exchange_http_status", codecForNumber()).property("coin_pub", codecForEddsaPublicKey()).build("TalerMerchantApi.TransactionWireReport");
var codecForMerchantRefundResponse = () => buildCodecForObject().property("taler_refund_uri", codecForTalerUriString()).property("h_contract", codecForString()).build("TalerMerchantApi.MerchantRefundResponse");
var codecForTansferList = () => buildCodecForObject().property("transfers", codecForList(codecForTransferDetails())).build("TalerMerchantApi.TransferList");
var codecForIncomingTansferList = () => buildCodecForObject().property("incoming", codecForList(codecForIncomingTransferDetails())).build("TalerMerchantApi.IncomingTransferList");
var codecForTransferDetails = () => buildCodecForObject().property("credit_amount", codecForAmountString()).property("wtid", codecForString()).property("payto_uri", codecForPaytoString()).property("exchange_url", codecForURLString()).property("transfer_serial_id", codecForNumber()).property("execution_time", codecOptional(codecForTimestamp)).property("verified", codecOptional(codecForBoolean())).property("confirmed", codecOptional(codecForBoolean())).build("TalerMerchantApi.TransferDetails");
var codecForIncomingTransferDetails = () => buildCodecForObject().property("expected_credit_amount", codecOptional(codecForAmountString())).property("expected_transfer_serial_id", codecOptional(codecForNumber())).property("execution_time", codecOptional(codecForTimestamp)).property("wtid", codecForString()).property("payto_uri", codecForPaytoString()).property("exchange_url", codecForURLString()).property("validated", codecForBoolean()).property("confirmed", codecForBoolean()).property("last_http_status", codecForNumber()).property("last_ec", codecForNumber()).property("last_error_detail", codecOptional(codecForAny())).build("TalerMerchantApi.IncomingTransferDetails");
var codecForOtpDeviceSummaryResponse = () => buildCodecForObject().property("otp_devices", codecForList(codecForOtpDeviceEntry())).build("TalerMerchantApi.OtpDeviceSummaryResponse");
var codecForOtpDeviceEntry = () => buildCodecForObject().property("otp_device_id", codecForString()).property("device_description", codecForString()).build("TalerMerchantApi.OtpDeviceEntry");
var codecForOtpDeviceDetails = () => buildCodecForObject().property("device_description", codecForString()).property("otp_algorithm", codecForNumber()).property("otp_ctr", codecOptional(codecForNumber())).property("otp_timestamp", codecForNumber()).property("otp_code", codecOptional(codecForString())).build("TalerMerchantApi.OtpDeviceDetails");
var codecForTemplateSummaryResponse = () => buildCodecForObject().property("templates", codecForList(codecForTemplateEntry())).build("TalerMerchantApi.TemplateSummaryResponse");
var codecForTemplateEntry = () => buildCodecForObject().property("template_id", codecForString()).property("template_description", codecForString()).build("TalerMerchantApi.TemplateEntry");
var codecForTemplateDetails = () => buildCodecForObject().property("template_description", codecForString()).property("otp_id", codecOptional(codecForString())).property("template_contract", codecForTemplateContractDetails()).property("editable_defaults", codecOptional(codecForTemplateContractDetailsDefaults())).build("TalerMerchantApi.TemplateDetails");
var codecForTemplateContractDetails = () => buildCodecForObject().property("summary", codecOptional(codecForString())).property("currency", codecOptional(codecForString())).property("amount", codecOptional(codecForAmountString())).property("minimum_age", codecForNumber()).property("pay_duration", codecForDuration).build("TalerMerchantApi.TemplateContractDetails");
var codecForTemplateContractDetailsDefaults = () => buildCodecForObject().property("summary", codecOptional(codecForString())).property("currency", codecOptional(codecForString())).property("amount", codecOptional(codecForAmountString())).build("TalerMerchantApi.TemplateContractDetailsDefaults");
var codecForWalletTemplateDetails = () => buildCodecForObject().property("template_contract", codecForTemplateContractDetails()).property("editable_defaults", codecOptional(codecForTemplateContractDetailsDefaults())).build("TalerMerchantApi.WalletTemplateDetails");
var codecForWebhookSummaryResponse = () => buildCodecForObject().property("webhooks", codecForList(codecForWebhookEntry())).build("TalerMerchantApi.WebhookSummaryResponse");
var codecForWebhookEntry = () => buildCodecForObject().property("webhook_id", codecForString()).property("event_type", codecForString()).build("TalerMerchantApi.WebhookEntry");
var codecForWebhookDetails = () => buildCodecForObject().property("event_type", codecForString()).property("url", codecForString()).property("http_method", codecForString()).property("header_template", codecOptional(codecForString())).property("body_template", codecOptional(codecForString())).build("TalerMerchantApi.WebhookDetails");
var codecForTokenFamilyKind = codecForEither(codecForConstString(TokenFamilyKind.Discount), codecForConstString(TokenFamilyKind.Subscription));
var codecForTokenFamilyDetails = () => buildCodecForObject().property("slug", codecForString()).property("name", codecForString()).property("description", codecForString()).property("description_i18n", codecOptional(codecForInternationalizedString())).property("valid_after", codecForTimestamp).property("valid_before", codecForTimestamp).property("duration", codecForDuration).property("kind", codecForTokenFamilyKind).property("issued", codecForNumber()).property("used", codecForNumber()).build("TalerMerchantApi.TokenFamilyDetails");
var codecForTokenFamiliesList = () => buildCodecForObject().property("token_families", codecForList(codecForTokenFamilySummary())).build("TalerMerchantApi.TokenFamiliesList");
var codecForTokenFamilySummary = () => buildCodecForObject().property("slug", codecForString()).property("name", codecForString()).property("description", codecForString()).property("description_i18n", codecForInternationalizedString()).property("valid_after", codecForTimestamp).property("valid_before", codecForTimestamp).property("kind", codecForTokenFamilyKind).build("TalerMerchantApi.TokenFamilySummary");
var codecForStatisticBucketRange = codecForEither(codecForConstString(StatisticBucketRange.Day), codecForConstString(StatisticBucketRange.Hour), codecForConstString(StatisticBucketRange.Day), codecForConstString(StatisticBucketRange.Week), codecForConstString(StatisticBucketRange.Month), codecForConstString(StatisticBucketRange.Quarter), codecForConstString(StatisticBucketRange.Year));
var TanChannel;
(function(TanChannel2) {
  TanChannel2["SMS"] = "sms";
  TanChannel2["EMAIL"] = "email";
})(TanChannel || (TanChannel = {}));
var codecForChallenge = () => buildCodecForObject().property("challenge_id", codecForString()).property("tan_channel", codecForEither(codecForConstString(TanChannel.SMS), codecForConstString(TanChannel.EMAIL))).property("tan_info", codecForString()).build("MFA.Challenge");
var codecForChallengeResponse = () => buildCodecForObject().property("challenges", codecForList(codecForChallenge())).property("combi_and", codecForBoolean()).build("MFA.ChallengeResponse");
var codecForChallengeRequestResponse = () => buildCodecForObject().property("solve_expiration", codecOptional(codecForTimestamp)).property("earliest_retransmission", codecOptional(codecForTimestamp)).build("MFA.ChallengeRequestResponse");

// ../taler-util/lib/contract-terms.js
var logger5 = new Logger("contractTerms.ts");
var ContractTermsUtil;
(function(ContractTermsUtil2) {
  function forgetAllImpl(anyJson, path, pred) {
    const dup = JSON.parse(JSON.stringify(anyJson));
    if (Array.isArray(dup)) {
      for (let i5 = 0; i5 < dup.length; i5++) {
        dup[i5] = forgetAllImpl(dup[i5], [...path, `${i5}`], pred);
      }
    } else if (typeof dup === "object" && dup != null) {
      if (typeof dup.$forgettable === "object") {
        for (const x6 of Object.keys(dup.$forgettable)) {
          if (!pred([...path, x6])) {
            continue;
          }
          if (!dup.$forgotten) {
            dup.$forgotten = {};
          }
          if (!dup.$forgotten[x6]) {
            const membValCanon = stringToBytes(canonicalJson(scrub(dup[x6])) + "\0");
            const membSalt = stringToBytes(dup.$forgettable[x6] + "\0");
            const h5 = kdf(64, membValCanon, membSalt, new Uint8Array([]));
            dup.$forgotten[x6] = encodeCrock(h5);
          }
          delete dup[x6];
          delete dup.$forgettable[x6];
        }
        if (Object.keys(dup.$forgettable).length === 0) {
          delete dup.$forgettable;
        }
      }
      for (const x6 of Object.keys(dup)) {
        if (x6.startsWith("$")) {
          continue;
        }
        dup[x6] = forgetAllImpl(dup[x6], [...path, x6], pred);
      }
    }
    return dup;
  }
  ContractTermsUtil2.forgetAllImpl = forgetAllImpl;
  function scrub(anyJson) {
    return forgetAllImpl(anyJson, [], () => true);
  }
  ContractTermsUtil2.scrub = scrub;
  function forgetAll(anyJson, pred) {
    return forgetAllImpl(anyJson, [], pred);
  }
  ContractTermsUtil2.forgetAll = forgetAll;
  function saltForgettable(anyJson) {
    const dup = JSON.parse(JSON.stringify(anyJson));
    if (Array.isArray(dup)) {
      for (let i5 = 0; i5 < dup.length; i5++) {
        dup[i5] = saltForgettable(dup[i5]);
      }
    } else if (typeof dup === "object" && dup !== null) {
      if (typeof dup.$forgettable === "object") {
        for (const k6 of Object.keys(dup.$forgettable)) {
          if (dup.$forgettable[k6] === true) {
            dup.$forgettable[k6] = encodeCrock(getRandomBytes(32));
          }
        }
      }
      for (const x6 of Object.keys(dup)) {
        if (x6.startsWith("$")) {
          continue;
        }
        dup[x6] = saltForgettable(dup[x6]);
      }
    }
    return dup;
  }
  ContractTermsUtil2.saltForgettable = saltForgettable;
  const nameRegex = /^[0-9A-Za-z_]+$/;
  function validateForgettable(anyJson) {
    if (anyJson === void 0) {
      return true;
    }
    if (typeof anyJson === "string") {
      return true;
    }
    if (typeof anyJson === "number") {
      return Number.isInteger(anyJson) && anyJson >= Number.MIN_SAFE_INTEGER && anyJson <= Number.MAX_SAFE_INTEGER;
    }
    if (typeof anyJson === "boolean") {
      return true;
    }
    if (anyJson === null) {
      return true;
    }
    if (Array.isArray(anyJson)) {
      return anyJson.every((x6) => validateForgettable(x6));
    }
    if (typeof anyJson === "object") {
      for (const k6 of Object.keys(anyJson)) {
        if (k6.match(nameRegex)) {
          if (validateForgettable(anyJson[k6])) {
            continue;
          } else {
            return false;
          }
        }
        if (k6 === "$forgettable") {
          const fga = anyJson.$forgettable;
          if (!fga || typeof fga !== "object") {
            return false;
          }
          for (const fk of Object.keys(fga)) {
            if (!fk.match(nameRegex)) {
              return false;
            }
            if (!(fk in anyJson)) {
              return false;
            }
            const fv = anyJson.$forgettable[fk];
            if (typeof fv !== "string") {
              return false;
            }
          }
        } else if (k6 === "$forgotten") {
          const fgo = anyJson.$forgotten;
          if (!fgo || typeof fgo !== "object") {
            return false;
          }
          for (const fk of Object.keys(fgo)) {
            if (!fk.match(nameRegex)) {
              return false;
            }
            if (fk in anyJson) {
              return false;
            }
            const fv = anyJson.$forgotten[fk];
            if (typeof fv !== "string") {
              return false;
            }
            try {
              const decFv = decodeCrock(fv);
              if (decFv.length != 64) {
                return false;
              }
            } catch (e5) {
              return false;
            }
            if (anyJson.$forgettable?.[k6] !== void 0) {
              return false;
            }
          }
        } else {
          return false;
        }
      }
      return true;
    }
    return false;
  }
  ContractTermsUtil2.validateForgettable = validateForgettable;
  function validateNothingForgotten(contractTerms) {
    throw Error("not implemented yet");
  }
  ContractTermsUtil2.validateNothingForgotten = validateNothingForgotten;
  function validateParsed(contractTerms) {
    if (contractTerms.version === MerchantContractVersion.V1) {
      const regex = new RegExp("^(\\*\\.)?([\\w\\d]+\\.)+[\\w\\d]+$");
      for (const slug in contractTerms.token_families) {
        const family = contractTerms.token_families[slug];
        var domains = [];
        switch (family.details.class) {
          case MerchantContractTokenKind.Subscription:
            domains.push(...family.details.trusted_domains);
            break;
          case MerchantContractTokenKind.Discount:
            domains.push(...family.details.expected_domains);
            break;
          default:
            assertUnreachable(family.details);
        }
        for (const domain in domains) {
          if (domain !== "*" && !regex.test(domain)) {
            return false;
          }
        }
      }
    }
    return true;
  }
  ContractTermsUtil2.validateParsed = validateParsed;
  function hashContractTerms(contractTerms) {
    const cleaned = scrub(contractTerms);
    const canon = canonicalJson(cleaned) + "\0";
    const bytes = stringToBytes(canon);
    return encodeCrock(hash2(bytes));
  }
  ContractTermsUtil2.hashContractTerms = hashContractTerms;
  function extractAmounts(contractTerms, choiceIndex) {
    let amountRaw;
    let maxFee;
    switch (contractTerms.version) {
      case void 0:
      case MerchantContractVersion.V0:
        amountRaw = contractTerms.amount;
        maxFee = contractTerms.max_fee;
        break;
      case MerchantContractVersion.V1:
        if (choiceIndex === void 0) {
          logger5.trace("choice index not specified for contract v1");
          return {
            available: false,
            amountRaw: void 0,
            maxFee: void 0
          };
        }
        if (contractTerms.choices[choiceIndex] === void 0)
          throw Error(`invalid choice index ${choiceIndex}`);
        amountRaw = contractTerms.choices[choiceIndex].amount;
        maxFee = contractTerms.choices[choiceIndex].max_fee;
        break;
      default:
        assertUnreachable(contractTerms);
    }
    return {
      available: true,
      amountRaw,
      maxFee
    };
  }
  ContractTermsUtil2.extractAmounts = extractAmounts;
  function getV0CompatChoiceIndex(terms) {
    let firstGood = void 0;
    for (let i5 = 0; i5 < terms.choices.length; i5++) {
      if (terms.choices[i5].inputs.length == 0) {
        firstGood = i5;
        break;
      }
    }
    if (firstGood != null) {
      return firstGood;
    }
    return void 0;
  }
  ContractTermsUtil2.getV0CompatChoiceIndex = getV0CompatChoiceIndex;
  function downgradeContractTerms(terms) {
    if (terms.version == MerchantContractVersion.V0) {
      return terms;
    }
    if (terms.version !== MerchantContractVersion.V1) {
      return void 0;
    }
    const firstGood = getV0CompatChoiceIndex(terms);
    if (firstGood == null) {
      return void 0;
    }
    return {
      amount: terms.choices[firstGood].amount,
      exchanges: terms.exchanges,
      h_wire: terms.h_wire,
      max_fee: terms.choices[firstGood].max_fee,
      merchant: terms.merchant,
      merchant_base_url: terms.merchant_base_url,
      merchant_pub: terms.merchant_pub,
      nonce: terms.nonce,
      order_id: terms.order_id,
      pay_deadline: terms.pay_deadline,
      refund_deadline: terms.refund_deadline,
      summary: terms.summary,
      timestamp: terms.timestamp,
      wire_method: terms.wire_method,
      wire_transfer_deadline: terms.wire_transfer_deadline,
      auto_refund: terms.auto_refund,
      delivery_date: terms.delivery_date,
      delivery_location: terms.delivery_location,
      extra: terms.extra,
      fulfillment_message: terms.fulfillment_message,
      fulfillment_message_i18n: terms.fulfillment_message_i18n,
      fulfillment_url: terms.fulfillment_url,
      minimum_age: terms.minimum_age,
      products: terms.products,
      public_reorder_url: terms.public_reorder_url,
      summary_i18n: terms.summary_i18n,
      version: MerchantContractVersion.V0
    };
  }
  ContractTermsUtil2.downgradeContractTerms = downgradeContractTerms;
})(ContractTermsUtil || (ContractTermsUtil = {}));

// ../taler-util/lib/fnutils.js
var fnutil;
(function(fnutil2) {
  function all(arr, f3) {
    for (const x6 of arr) {
      if (!f3(x6)) {
        return false;
      }
    }
    return true;
  }
  fnutil2.all = all;
  function any(arr, f3) {
    for (const x6 of arr) {
      if (f3(x6)) {
        return true;
      }
    }
    return false;
  }
  fnutil2.any = any;
})(fnutil || (fnutil = {}));

// ../taler-util/lib/http-status-codes.js
var HttpStatusCode;
(function(HttpStatusCode2) {
  HttpStatusCode2[HttpStatusCode2["Continue"] = 100] = "Continue";
  HttpStatusCode2[HttpStatusCode2["SwitchingProtocols"] = 101] = "SwitchingProtocols";
  HttpStatusCode2[HttpStatusCode2["Processing"] = 102] = "Processing";
  HttpStatusCode2[HttpStatusCode2["Ok"] = 200] = "Ok";
  HttpStatusCode2[HttpStatusCode2["Created"] = 201] = "Created";
  HttpStatusCode2[HttpStatusCode2["Accepted"] = 202] = "Accepted";
  HttpStatusCode2[HttpStatusCode2["NonAuthoritativeInformation"] = 203] = "NonAuthoritativeInformation";
  HttpStatusCode2[HttpStatusCode2["NoContent"] = 204] = "NoContent";
  HttpStatusCode2[HttpStatusCode2["ResetContent"] = 205] = "ResetContent";
  HttpStatusCode2[HttpStatusCode2["PartialContent"] = 206] = "PartialContent";
  HttpStatusCode2[HttpStatusCode2["MultiStatus"] = 207] = "MultiStatus";
  HttpStatusCode2[HttpStatusCode2["AlreadyReported"] = 208] = "AlreadyReported";
  HttpStatusCode2[HttpStatusCode2["ImUsed"] = 226] = "ImUsed";
  HttpStatusCode2[HttpStatusCode2["MultipleChoices"] = 300] = "MultipleChoices";
  HttpStatusCode2[HttpStatusCode2["MovedPermanently"] = 301] = "MovedPermanently";
  HttpStatusCode2[HttpStatusCode2["Found"] = 302] = "Found";
  HttpStatusCode2[HttpStatusCode2["SeeOther"] = 303] = "SeeOther";
  HttpStatusCode2[HttpStatusCode2["NotModified"] = 304] = "NotModified";
  HttpStatusCode2[HttpStatusCode2["UseProxy"] = 305] = "UseProxy";
  HttpStatusCode2[HttpStatusCode2["SwitchProxy"] = 306] = "SwitchProxy";
  HttpStatusCode2[HttpStatusCode2["TemporaryRedirect"] = 307] = "TemporaryRedirect";
  HttpStatusCode2[HttpStatusCode2["PermanentRedirect"] = 308] = "PermanentRedirect";
  HttpStatusCode2[HttpStatusCode2["BadRequest"] = 400] = "BadRequest";
  HttpStatusCode2[HttpStatusCode2["Unauthorized"] = 401] = "Unauthorized";
  HttpStatusCode2[HttpStatusCode2["PaymentRequired"] = 402] = "PaymentRequired";
  HttpStatusCode2[HttpStatusCode2["Forbidden"] = 403] = "Forbidden";
  HttpStatusCode2[HttpStatusCode2["NotFound"] = 404] = "NotFound";
  HttpStatusCode2[HttpStatusCode2["MethodNotAllowed"] = 405] = "MethodNotAllowed";
  HttpStatusCode2[HttpStatusCode2["NotAcceptable"] = 406] = "NotAcceptable";
  HttpStatusCode2[HttpStatusCode2["ProxyAuthenticationRequired"] = 407] = "ProxyAuthenticationRequired";
  HttpStatusCode2[HttpStatusCode2["RequestTimeout"] = 408] = "RequestTimeout";
  HttpStatusCode2[HttpStatusCode2["Conflict"] = 409] = "Conflict";
  HttpStatusCode2[HttpStatusCode2["Gone"] = 410] = "Gone";
  HttpStatusCode2[HttpStatusCode2["LengthRequired"] = 411] = "LengthRequired";
  HttpStatusCode2[HttpStatusCode2["PreconditionFailed"] = 412] = "PreconditionFailed";
  HttpStatusCode2[HttpStatusCode2["PayloadTooLarge"] = 413] = "PayloadTooLarge";
  HttpStatusCode2[HttpStatusCode2["UriTooLong"] = 414] = "UriTooLong";
  HttpStatusCode2[HttpStatusCode2["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
  HttpStatusCode2[HttpStatusCode2["RangeNotSatisfiable"] = 416] = "RangeNotSatisfiable";
  HttpStatusCode2[HttpStatusCode2["ExpectationFailed"] = 417] = "ExpectationFailed";
  HttpStatusCode2[HttpStatusCode2["IAmATeapot"] = 418] = "IAmATeapot";
  HttpStatusCode2[HttpStatusCode2["MisdirectedRequest"] = 421] = "MisdirectedRequest";
  HttpStatusCode2[HttpStatusCode2["UnprocessableEntity"] = 422] = "UnprocessableEntity";
  HttpStatusCode2[HttpStatusCode2["Locked"] = 423] = "Locked";
  HttpStatusCode2[HttpStatusCode2["FailedDependency"] = 424] = "FailedDependency";
  HttpStatusCode2[HttpStatusCode2["TooEarly"] = 425] = "TooEarly";
  HttpStatusCode2[HttpStatusCode2["UpgradeRequired"] = 426] = "UpgradeRequired";
  HttpStatusCode2[HttpStatusCode2["PreconditionRequired"] = 428] = "PreconditionRequired";
  HttpStatusCode2[HttpStatusCode2["TooManyRequests"] = 429] = "TooManyRequests";
  HttpStatusCode2[HttpStatusCode2["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
  HttpStatusCode2[HttpStatusCode2["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
  HttpStatusCode2[HttpStatusCode2["InternalServerError"] = 500] = "InternalServerError";
  HttpStatusCode2[HttpStatusCode2["NotImplemented"] = 501] = "NotImplemented";
  HttpStatusCode2[HttpStatusCode2["BadGateway"] = 502] = "BadGateway";
  HttpStatusCode2[HttpStatusCode2["ServiceUnavailable"] = 503] = "ServiceUnavailable";
  HttpStatusCode2[HttpStatusCode2["GatewayTimeout"] = 504] = "GatewayTimeout";
  HttpStatusCode2[HttpStatusCode2["HttpVersionNotSupported"] = 505] = "HttpVersionNotSupported";
  HttpStatusCode2[HttpStatusCode2["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
  HttpStatusCode2[HttpStatusCode2["InsufficientStorage"] = 507] = "InsufficientStorage";
  HttpStatusCode2[HttpStatusCode2["LoopDetected"] = 508] = "LoopDetected";
  HttpStatusCode2[HttpStatusCode2["NotExtended"] = 510] = "NotExtended";
  HttpStatusCode2[HttpStatusCode2["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
})(HttpStatusCode || (HttpStatusCode = {}));

// ../taler-util/lib/types-taler-bank-conversion.js
var codecForCashoutConversionResponse = () => buildCodecForObject().property("amount_credit", codecForAmountString()).property("amount_debit", codecForAmountString()).build("TalerCorebankApi.CashoutConversionResponse");
var codecForCashinConversionResponse = () => buildCodecForObject().property("amount_credit", codecForAmountString()).property("amount_debit", codecForAmountString()).build("TalerCorebankApi.CashinConversionResponse");
var codecForConversionRate = () => buildCodecForObject().property("cashin_fee", codecForAmountString()).property("cashin_min_amount", codecForAmountString()).property("cashin_ratio", codecForDecimalNumber()).property("cashin_rounding_mode", codecForEither(codecForConstString("zero"), codecForConstString("up"), codecForConstString("nearest"))).property("cashin_tiny_amount", codecForAmountString()).property("cashout_fee", codecForAmountString()).property("cashout_min_amount", codecForAmountString()).property("cashout_ratio", codecForDecimalNumber()).property("cashout_rounding_mode", codecForEither(codecForConstString("zero"), codecForConstString("up"), codecForConstString("nearest"))).property("cashout_tiny_amount", codecForAmountString()).build("ConversionBankConfig.ConversionInfo");
var codecForConversionBankConfig = () => buildCodecForObject().property("name", codecForConstString("taler-conversion-info")).property("version", codecForString()).property("regional_currency", codecForString()).property("regional_currency_specification", codecForCurrencySpecificiation()).property("fiat_currency", codecForString()).property("fiat_currency_specification", codecForCurrencySpecificiation()).property("conversion_rate", codecForConversionRate()).build("ConversionBankConfig.IntegrationConfig");

// ../taler-util/lib/types-taler-wallet.js
var ScopeType;
(function(ScopeType2) {
  ScopeType2["Global"] = "global";
  ScopeType2["Exchange"] = "exchange";
  ScopeType2["Auditor"] = "auditor";
})(ScopeType || (ScopeType = {}));
var TransactionAmountMode;
(function(TransactionAmountMode2) {
  TransactionAmountMode2["Effective"] = "effective";
  TransactionAmountMode2["Raw"] = "raw";
})(TransactionAmountMode || (TransactionAmountMode = {}));
var codecForConvertAmountRequest = buildCodecForObject().property("amount", codecForAmountString()).property("depositPaytoUri", codecForPaytoString()).property("type", codecForEither(codecForConstString(TransactionAmountMode.Raw), codecForConstString(TransactionAmountMode.Effective))).build("ConvertAmountRequest");
var BalanceFlag;
(function(BalanceFlag2) {
  BalanceFlag2["IncomingKyc"] = "incoming-kyc";
  BalanceFlag2["IncomingAml"] = "incoming-aml";
  BalanceFlag2["IncomingConfirmation"] = "incoming-confirmation";
  BalanceFlag2["OutgoingKyc"] = "outgoing-kyc";
})(BalanceFlag || (BalanceFlag = {}));
var CoinStatus;
(function(CoinStatus2) {
  CoinStatus2["Fresh"] = "fresh";
  CoinStatus2["DenomLoss"] = "denom-loss";
  CoinStatus2["FreshSuspended"] = "fresh-suspended";
  CoinStatus2["Dormant"] = "dormant";
})(CoinStatus || (CoinStatus = {}));
var ConfirmPayResultType;
(function(ConfirmPayResultType2) {
  ConfirmPayResultType2["Done"] = "done";
  ConfirmPayResultType2["Pending"] = "pending";
})(ConfirmPayResultType || (ConfirmPayResultType = {}));
var codecForTalerErrorDetail = () => buildCodecForObject().property("code", codecForNumber()).property("when", codecOptional(codecForAbsoluteTime)).property("hint", codecOptional(codecForString())).build("TalerErrorDetail");
var PreparePayResultType;
(function(PreparePayResultType2) {
  PreparePayResultType2["PaymentPossible"] = "payment-possible";
  PreparePayResultType2["InsufficientBalance"] = "insufficient-balance";
  PreparePayResultType2["AlreadyConfirmed"] = "already-confirmed";
  PreparePayResultType2["ChoiceSelection"] = "choice-selection";
})(PreparePayResultType || (PreparePayResultType = {}));
var InsufficientBalanceHint;
(function(InsufficientBalanceHint2) {
  InsufficientBalanceHint2["MerchantAcceptInsufficient"] = "merchant-accept-insufficient";
  InsufficientBalanceHint2["MerchantDepositInsufficient"] = "merchant-deposit-insufficient";
  InsufficientBalanceHint2["AgeRestricted"] = "age-restricted";
  InsufficientBalanceHint2["WalletBalanceMaterialInsufficient"] = "wallet-balance-material-insufficient";
  InsufficientBalanceHint2["WalletBalanceAvailableInsufficient"] = "wallet-balance-available-insufficient";
  InsufficientBalanceHint2["ExchangeMissingGlobalFees"] = "exchange-missing-global-fees";
  InsufficientBalanceHint2["FeesNotCovered"] = "fees-not-covered";
})(InsufficientBalanceHint || (InsufficientBalanceHint = {}));
var TokenAvailabilityHint;
(function(TokenAvailabilityHint2) {
  TokenAvailabilityHint2["WalletTokensAvailableInsufficient"] = "wallet-tokens-available-insufficient";
  TokenAvailabilityHint2["MerchantUnexpected"] = "merchant-unexpected";
  TokenAvailabilityHint2["MerchantUntrusted"] = "merchant-untrusted";
})(TokenAvailabilityHint || (TokenAvailabilityHint = {}));
var RefreshReason;
(function(RefreshReason2) {
  RefreshReason2["Manual"] = "manual";
  RefreshReason2["PayMerchant"] = "pay-merchant";
  RefreshReason2["PayDeposit"] = "pay-deposit";
  RefreshReason2["PayPeerPush"] = "pay-peer-push";
  RefreshReason2["PayPeerPull"] = "pay-peer-pull";
  RefreshReason2["Refund"] = "refund";
  RefreshReason2["AbortPay"] = "abort-pay";
  RefreshReason2["AbortDeposit"] = "abort-deposit";
  RefreshReason2["AbortPeerPushDebit"] = "abort-peer-push-debit";
  RefreshReason2["AbortPeerPullDebit"] = "abort-peer-pull-debit";
  RefreshReason2["Recoup"] = "recoup";
  RefreshReason2["BackupRestored"] = "backup-restored";
  RefreshReason2["Scheduled"] = "scheduled";
})(RefreshReason || (RefreshReason = {}));
var ExchangeTosStatus;
(function(ExchangeTosStatus2) {
  ExchangeTosStatus2["Pending"] = "pending";
  ExchangeTosStatus2["Proposed"] = "proposed";
  ExchangeTosStatus2["Accepted"] = "accepted";
  ExchangeTosStatus2["MissingTos"] = "missing-tos";
})(ExchangeTosStatus || (ExchangeTosStatus = {}));
var ExchangeEntryStatus;
(function(ExchangeEntryStatus2) {
  ExchangeEntryStatus2["Preset"] = "preset";
  ExchangeEntryStatus2["Ephemeral"] = "ephemeral";
  ExchangeEntryStatus2["Used"] = "used";
})(ExchangeEntryStatus || (ExchangeEntryStatus = {}));
var ExchangeUpdateStatus;
(function(ExchangeUpdateStatus2) {
  ExchangeUpdateStatus2["Initial"] = "initial";
  ExchangeUpdateStatus2["InitialUpdate"] = "initial-update";
  ExchangeUpdateStatus2["Suspended"] = "suspended";
  ExchangeUpdateStatus2["UnavailableUpdate"] = "unavailable-update";
  ExchangeUpdateStatus2["Ready"] = "ready";
  ExchangeUpdateStatus2["ReadyUpdate"] = "ready-update";
  ExchangeUpdateStatus2["OutdatedUpdate"] = "o