/*
 This file is part of GNU Taler
 (C) 2021-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */
import { Fragment, h } from "preact";
import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { Input } from "./Input.js";

export function InputLocation({ name }: { name: string }) {
  const { i18n } = useTranslationContext();
  return (
    <>
      <Input name={`${name}.country`} label={i18n.str`Country`} />
      <Input
        name={`${name}.address_lines`}
        inputType="multiline"
        label={i18n.str`Address`}
        toStr={(v: string[] | undefined) => (!v ? "" : v.join("\n"))}
        fromStr={(v: string) => v.split("\n")}
      />
      <Input
        name={`${name}.building_number`}
        label={i18n.str`Building number`}
      />
      <Input name={`${name}.building_name`} label={i18n.str`Building name`} />
      <Input name={`${name}.street`} label={i18n.str`Street`} />
      <Input name={`${name}.post_code`} label={i18n.str`Post code`} />
      <Input name={`${name}.town_location`} label={i18n.str`Town location`} />
      <Input name={`${name}.town`} label={i18n.str`Town`} />
      <Input name={`${name}.district`} label={i18n.str`District`} />
      <Input
        name={`${name}.country_subdivision`}
        label={i18n.str`Country subdivision`}
      />
    </>
  );
}
