/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import {
  countryNamesByCode,
  countryNationalitiesByCode,
  currencyNamesByCode,
  langNamesByCode,
} from "@gnu-taler/taler-util";
import { InternationalizationAPI, SelectUiChoice } from "../index.browser.js";

export function currencyNameList(
  i18n: InternationalizationAPI,
): SelectUiChoice[] {
  return Object.entries(currencyNamesByCode).map(([value, translator]) => ({
    value,
    label: translator(i18n),
  }));
}

export function countryNameList(
  i18n: InternationalizationAPI,
): SelectUiChoice[] {
  return Object.entries(countryNamesByCode).map(([value, translator]) => ({
    value,
    label: translator(i18n),
  }));
}

export function countryNationalityList(
  i18n: InternationalizationAPI,
): SelectUiChoice[] {
  return Object.entries(countryNationalitiesByCode).map(
    ([value, translator]) => ({
      value,
      label: translator(i18n),
    }),
  );
}

export function languageNameList(
  i18n: InternationalizationAPI,
): SelectUiChoice[] {
  return Object.entries(langNamesByCode).map(([value, translator]) => ({
    value,
    label: translator(i18n),
  }));
}

export const germanBusinessTypesList = {
  DE_GMBH: (i18n: InternationalizationAPI) => i18n.str`GmbH`,
  DE_GMBH_IG: (i18n: InternationalizationAPI) => i18n.str`GmbH i.G.`,
  DE_UG: (i18n: InternationalizationAPI) => i18n.str`UG`,
  DE_UG_IG: (i18n: InternationalizationAPI) => i18n.str`UG i.G.`,
  DE_OHG: (i18n: InternationalizationAPI) => i18n.str`UHG`,
  DE_KG: (i18n: InternationalizationAPI) => i18n.str`KG`,
  DE_EV: (i18n: InternationalizationAPI) => i18n.str`e.V.`,
  DE_EV_IG: (i18n: InternationalizationAPI) => i18n.str`e.V. i.G.`,
  DE_EG: (i18n: InternationalizationAPI) => i18n.str`eG`,
  DE_EG_IG: (i18n: InternationalizationAPI) => i18n.str`eG i.G.`,
  DE_PARTG: (i18n: InternationalizationAPI) => i18n.str`PartG`,
  DE_EK: (i18n: InternationalizationAPI) => i18n.str`e.K.`,
  DE_AG_UNLISTED: (i18n: InternationalizationAPI) =>
    i18n.str`AG (nicht börsennotiert)`,
  DE_AG_LISTED: (i18n: InternationalizationAPI) => i18n.str`AG (börsennotiert)`,
  DE_GBR: (i18n: InternationalizationAPI) => i18n.str`GbR`,
  DE_NEV: (i18n: InternationalizationAPI) => i18n.str`n.e.V.`,
  DE_PARTEI: (i18n: InternationalizationAPI) => i18n.str`Partei`,
  DE_WEG: (i18n: InternationalizationAPI) => i18n.str`WEG`,
  OTHER: (i18n: InternationalizationAPI) => i18n.str`Anderes`,
};

export function germanBusinessTypes(
  i18n: InternationalizationAPI,
): SelectUiChoice[] {
  return Object.entries(germanBusinessTypesList).map(([value, translator]) => ({
    value,
    label: translator(i18n),
  }));
}

export const drilldownGlsIndustries = {
  "Land- und Forstwirtschaft, Fischerei": {
    "Landwirtschaft, Jagd": {
      Pflanzenbau: "aaa",
      Tierhaltung: "aab",
      "Gemischte Landwirtschaft": "aac",
      "Erbringung von landwirtschaftlichen und gärtnerischen Dienstleistungen":
        "aad",
      Jagd: "aae",
    },
    "Forstwirtschaft, Fischerei, Fischzucht": {
      "Erbringung von forstwirtschaftlichen Dienstleistungen": "aba",
      Fischerei: "abb",
    },
  },
  "Bergbau und Gewinnung von Steinen und Erden": {
    "Kohlenbergbau, Torfgewinnung, Erdöl, Erdgas, Erzbergbau": {
      "Steinkohlenbergbau und -brikettherstellung": "baa",
      "Gewinnung von Erdöl und Erdgas": "bab",
      Eisenerzbergbau: "bac",
    },
    "Gewinnung von Steinen und Erden, sonstiger Bergbau": {
      "Gewinnung von Natursteinen": "bba",
      "Gewinnung von Kies, Sand, Ton und Kaolin": "bbb",
      "Gewinnung von Mineralien für die Herstellung von chemischen Erzeugnissen":
        "bbc",
      "Gewinnung von Salz": "bbd",
      "Gewinnung von Steinen und Erden, anderweitig nicht genannt, sonstiger Bergbau":
        "bbe",
    },
  },
  "Verarbeitendes Gewerbe": {
    Ernährungsgewerbe: {
      "Schlachten und Fleischverarbeitung": "caa",
      Fischverarbeitung: "cab",
      "Obst- und Gemüseverarbeitung": "cac",
      "Herstellung von pflanzlichen und tierischen Ölen und Fetten": "cad",
      "Milchverarbeitung, Herstellung von Speiseeis": "cae",
      "Mahl- und Schälmühlen, Herstellung von Stärke und Stärkeerzeugnissen":
        "caf",
      "Herstellung von Futtermitteln": "cag",
      "Sonstiges Ernährungsgewerbe (ohne Getränkeherstellung)": "cah",
      "Herstellung von Getränken": "cai",
    },
    "Textil-, Bekleidungs-, Ledergewerbe": {
      "Spinnstoffaufbereitung und Spinnerei": "cba",
      Weberei: "cbb",
      Textilveredlung: "cbc",
      "Herstellung von konfektionierten Textilwaren (ohne Bekleidung)": "cbd",
      "Sonstiges Textilgewerbe (ohne Herstellung von Maschenware)": "cbe",
      "Herstellung von gewirktem und gestricktem Stoff": "cbf",
      "Herstellung von gewirkten und gestrickten Fertigerzeugnissen": "cbg",
      "Herstellung von Lederbekleidung": "cbh",
      "Herstellung von Bekleidung (ohne Lederbekleidung)": "cbi",
      "Zurichtung und Färben von Fellen, Herstellung von Pelzwaren": "cbj",
      "Herstellung von Leder und Lederfaserstoff": "cbk",
      "Lederverarbeitung (ohne Herstellung von Lederbekleidung und Schuhen)":
        "cbl",
      "Herstellung von Schuhen": "cbm",
    },
    "Holzgewerbe (ohne Herstellung von Möbeln)": {
      "Säge-, Hobel- und Holzimprägnierwerke": "cca",
      "Herstellung von Furnier-, Sperrholz-, Holzfaser- und Holzspanplatten":
        "ccb",
      "Herstellung von Konstruktionsteilen, Fertigbauteilen, Ausbauelementen und Fertigteilbauten aus Holz":
        "ccc",
      "Herstellung von Verpackungsmitteln, Lagerbehältern und Ladungsträgern aus Holz":
        "ccd",
      "Herstellung von Holzwaren, anderweitig nicht genannt, sowie von Kork-, Flecht- und Korbwaren (ohne Herstellung von Möbeln)":
        "cce",
    },
    "Papier-, Verlags-, Druckgewerbe": {
      "Herstellung von Holz- und Zellstoff, Papier, Karton und Pappe": "cda",
      "Herstellung von Waren aus Papier, Karton und Pappe": "cdb",
      Verlagsgewerbe: "cdc",
      Druckgewerbe: "cdd",
      "Vervielfältigung von bespielten Ton-, Bild- und Datenträgern": "cde",
    },
    "Kokerei, Mineralölverarbeitung": {
      Kokerei: "cea",
      Mineralölverarbeitung: "ceb",
    },
    "Herstellung von chemischen und pharmazeutischen Erzeugnissen": {
      "Herstellung von chemischen Grundstoffen": "cfa",
      "Herstellung von Schädlingsbekämpfungs-, Pflanzenschutz- und Desinfektionsmitteln":
        "cfb",
      "Herstellung von Anstrichmitteln, Druckfarben und Kitten": "cfc",
      "Herstellung von pharmazeutischen Erzeugnissen": "cfd",
      "Herstellung von Seifen, Wasch-, Reinigungs- und Körperpflegemitteln sowie von Duftstoffen":
        "cfe",
      "Herstellung von sonstigen chemischen Erzeugnissen": "cff",
      "Herstellung von Chemiefasern": "cfg",
    },
    "Herstellung von Gummi- und Kunststoffwaren": {
      "Herstellung von Gummiwaren": "cga",
      "Herstellung von Kunststoffwaren": "cgb",
    },
    "Herstellung von Glas und Glaswaren, Keramik, Verarbeitung von Steinen und Erden":
      {
        "Herstellung von Glas und Glaswaren": "cha",
        "Herstellung von keramischen Erzeugnissen (ohne Herstellung von Ziegeln und Baukeramik)":
          "chb",
        "Herstellung von keramischen Wand- und Bodenfliesen und -platten":
          "chc",
        "Herstellung von Ziegeln und sonstiger Baukeramik": "chd",
        "Herstellung von Zement, Kalk und gebranntem Gips": "che",
        "Herstellung von Erzeugnissen aus Beton, Zement und Gips": "chf",
        "Be- und Verarbeitung von Naturwerksteinen und Natursteinen, anderweitig nicht genannt":
          "chg",
        "Herstellung von sonstigen Erzeugnissen aus nicht metallischen Mineralien":
          "chh",
      },
    "Metallerzeugung und -bearbeitung": {
      "Erzeugung von Roheisen, Stahl und Ferrolegierungen": "cia",
      "Herstellung von Rohren": "cib",
      "Sonstige erste Bearbeitung von Eisen und Stahl": "cic",
      "Erzeugung und erste Bearbeitung von NE-Metallen": "cid",
      Gießereien: "cie",
    },
    "Herstellung von Metallerzeugnissen": {
      "Stahl- und Leichtmetallbau": "cja",
      "Herstellung von Metallbehältern mit einem Fassungsvermögen von mehr als 300 l, Herstellung von Heizkörpern und -kesseln für Zentralheizungen":
        "cjb",
      "Herstellung von Dampfkesseln (ohne Zentralheizungskessel)": "cjc",
      "Herstellung von Schmiede-, Press-, Zieh- und Stanzteilen, gewalzten Ringen und pulvermetallurgischen Erzeugnissen":
        "cjd",
      "Oberflächenveredlung und Wärmebehandlung, Mechanik, anderweitig nicht genannt":
        "cje",
      "Herstellung von Schneidwaren, Werkzeugen, Schlössern und Beschlägen aus unedlen Metallen":
        "cjf",
      "Herstellung von sonstigen Metallwaren": "cjg",
    },
    Maschinenbau: {
      "Herstellung von Maschinen für die Erzeugung und Nutzung von mechanischer Energie (ohne Motoren für Luft- und Straßenfahrzeuge)":
        "cka",
      "Herstellung von sonstigen nicht wirtschaftszweigspezifischen Maschinen":
        "ckb",
      "Herstellung von land- und forstwirtschaftlichen Maschinen": "ckc",
      "Herstellung von Werkzeugmaschinen": "ckd",
      "Herstellung von Maschinen für sonstige bestimmte Wirtschaftszweige":
        "cke",
      "Herstellung von Haushaltsgeräten, anderweitig nicht genannt": "ckf",
      "Reparatur von sonstigen Ausrüstungen": "ckg",
    },
    "Herstellung von Büromaschinen, Datenverarbeitungsgeräten und -einrichtungen":
      {
        "Herstellung von Büromaschinen": "cla",
        "Herstellung von Datenverarbeitungsgeräten und -einrichtungen": "clb",
        "Reparatur von Datenverarbeitungs- und Telekommunikationsgeräten":
          "clc",
      },
    "Herstellung von Geräten der Elektrizitätserzeugung, -verteilung": {
      "Herstellung von Elektromotoren, Generatoren und Transformatoren": "cma",
      "Herstellung von Elektrizitätsverteilungs- und -schalteinrichtungen":
        "cmb",
      "Herstellung von isolierten Elektrokabeln, -leitungen und -drähten":
        "cmc",
      "Herstellung von Akkumulatoren und Batterien": "cmd",
      "Herstellung von elektrischen Lampen und Leuchten": "cme",
      "Herstellung von elektrischen Ausrüstungen, anderweitig nicht genannt":
        "cmf",
    },
    "Rundfunk- und Nachrichtentechnik": {
      "Herstellung von elektronischen Bauelementen": "cna",
      "Herstellung von Geräten und Einrichtungen der Telekommunikationstechnik":
        "cnb",
      "Herstellung von Rundfunkgeräten sowie phono- und videotechnischen Geräten":
        "cnc",
    },
    "Medizin-, Mess-, Steuer- und Regelungstechnik, Optik, Herstellung von Uhren":
      {
        "Herstellung von medizinischen Geräten und orthopädischen Erzeugnissen":
          "coa",
        "Herstellung von Mess-, Kontroll-, Navigations- u.ä. Instrumenten und Vorrichtungen":
          "cob",
        "Herstellung von industriellen Prozesssteuerungseinrichtungen": "coc",
        "Herstellung von optischen und fotografischen Geräten": "cod",
        "Herstellung von Uhren": "coe",
        "Reparatur von Haushaltswaren und Ziergegenständen aus Glas, Ton, Steinzeug und Porzellan":
          "cof",
      },
    "Herstellung von Kraftwagen, Kraftwagenteilen": {
      "Herstellung von Kraftwagen und Kraftwagenmotoren": "cpa",
      "Herstellung von Karosserien, Aufbauten und Anhängern": "cpb",
      "Herstellung von Teilen und Zubehör für Kraftwagen und Kraftwagenmotoren":
        "cpc",
    },
    "Sonstiger Fahrzeugbau": {
      "Schiff- und Bootsbau": "cqa",
      Bahnindustrie: "cqb",
      "Luft- und Raumfahrzeugbau": "cqc",
      "Herstellung von Krafträdern, Fahrrädern und Behindertenfahrzeugen":
        "cqd",
      "Fahrzeugbau, anderweitig nicht genannt": "cqe",
    },
    "Herstellung von Möbeln, Schmuck, Musikinstrumenten, Sportgeräten, Spielwaren, sonstigen Erzeugnissen":
      {
        "Herstellung von Möbeln": "cra",
        "Herstellung von Schmuck u.ä. Erzeugnissen": "crb",
        "Herstellung von Musikinstrumenten": "crc",
        "Herstellung von Sportgeräten": "crd",
        "Herstellung von Spielwaren": "cre",
        "Herstellung von sonstigen Erzeugnissen": "crf",
      },
    Recycling: {
      "Recycling von metallischen Altmaterialien und Reststoffen": "csa",
      "Recycling von nicht metallischen Altmaterialien und Reststoffen": "csb",
    },
  },
  "Energie- und Wasserversorgung, Baugewerbe": {
    Energieversorgung: {
      Elektrizitätsversorgung: "daa",
      Gasversorgung: "dab",
      Wärmeversorgung: "dac",
    },
    Wasserversorgung: {
      "Wassergewinnung mit Fremdbezug zur Verteilung": "dba",
      "Wassergewinnung ohne Fremdbezug zur Verteilung": "dbb",
    },
    Baugewerbe: {
      "Vorbereitende Baustellenarbeiten": "dca",
      "Hoch- und Tiefbau": "dcb",
      Bauinstallation: "dcc",
      "Sonstiges Ausbaugewerbe": "dcd",
      "Vermietung von Baumaschinen und -geräten mit Bedienungspersonal": "dce",
    },
  },
  "Handel, Instandhaltung und Reparatur von Kraftfahrzeugen, Tankstellen": {
    "Kraftfahrzeughandel, Instandhaltung und Reparatur von Kraftfahrzeugen, Tankstellen":
      {
        "Handel mit Kraftwagen": "eaa",
        "Instandhaltung und Reparatur von Kraftwagen": "eab",
        "Handel mit Kraftwagenteilen und -zubehör": "eac",
        "Handel mit Krafträdern, Kraftradteilen und -zubehör, Instandhaltung und Reparatur von Krafträdern":
          "ead",
        Tankstellen: "eae",
      },
    "Handelsvermittlung, Großhandel": {
      Handelsvermittlung: "eba",
      "Großhandel mit landwirtschaftlichen Grundstoffen und lebenden Tieren":
        "ebb",
      "Großhandel mit Nahrungsmitteln, Getränken und Tabakwaren": "ebc",
      "Großhandel mit Gebrauchs- und Verbrauchsgütern": "ebd",
      "Großhandel mit nicht landwirtschaftlichen Halbwaren, Altmaterialien und Reststoffen":
        "ebe",
      "Großhandel mit Maschinen, Ausrüstungen und Zubehör": "ebf",
      "Sonstiger Großhandel": "ebg",
    },
    Einzelhandel: {
      "Einzelhandel mit Waren verschiedener Art (in Verkaufsräumen)": "eca",
      "Facheinzelhandel mit Nahrungsmitteln, Getränken und Tabakwaren (in Verkaufsräumen)":
        "ecb",
      "Apotheken, Facheinzelhandel mit medizinischen, orthopädischen und kosmetischen Artikeln (in Verkaufsräumen)":
        "ecc",
      "Sonstiger Facheinzelhandel (in Verkaufsräumen)": "ecd",
      "Einzelhandel mit Antiquitäten und Gebrauchtwaren (in Verkaufsräumen)":
        "ece",
      "Einzelhandel (nicht in Verkaufsräumen)": "ecf",
      "Reparatur von Gebrauchsgütern": "ecg",
    },
  },
  Gastgewerbe: {
    Beherbergung: {
      Hotellerie: "faa",
      "Sonstiges Beherbergungsgewerbe": "fab",
    },
    Gastronomie: {
      "Speisengeprägte Gastronomie": "fba",
      "Getränkegeprägte Gastronomie": "fbb",
      "Kantinen und Caterer": "fbc",
    },
  },
  "Verkehr und Lagerei": {
    "Landverkehr, Transport in Rohrfernleitungen": {
      Eisenbahnverkehr: "gaa",
      "Sonstiger Landverkehr": "gab",
      "Transport in Rohrfernleitungen": "gac",
      "Deutsche Bahn AG": "gad",
    },
    "Schifffahrt, Luftfahrt": {
      "See- und Küstenschifffahrt": "gba",
      Binnenschifffahrt: "gbb",
      Linienflugverkehr: "gbc",
    },
    "Lagerei sowie Erbringung von sonstigen Dienstleistungen für den Verkehr": {
      "Frachtumschlag und Lagerei": "gca",
      "Sonstige Hilfs- und Nebentätigkeiten für den Verkehr": "gcb",
      "Reisebüros und Reiseveranstalter": "gcc",
      "Spedition, sonstige Verkehrsvermittlung": "gcd",
    },
    "Post-, Kurier- und Expressdienste": {
      "Postverwaltung und private Post- und Kurierdienste": "gda",
      Fernmeldedienste: "gdb",
      "Telekom AG": "gdc",
      "Deutsche Post AG": "gdd",
    },
  },
  "Erbringung von Finanz- und Versicherungsdienstleistungen": {
    "Kreditgewerbe, Versicherungsgewerbe": {
      Wertpapierfirma: "haa",
      "Sonstige Finanzierungsinstitutionen": "hab",
      "Fonds von Kapitalgesellschaften": "hac",
      "Ausländ. Finanzges. Als Kreditinst. Gem. §1Abs.1KWG": "had",
      Geldmarktfonds: "hae",
      "Sonstiges Versicherungsgewerbe": "hag",
    },
    "Mit Finanz- und Versicherungsdienstleistungen verbundene Tätigkeiten": {
      "Mit dem Kreditgewerbe verbundene Tätigkeiten": "hba",
      "Mit dem Versicherungsgewerbe verbundene Tätigkeiten": "hbb",
      "Börseneinrichtungen mit tägl. Einschüssen": "hbc",
      Postgiroämter: "hae",
      "Zuständige genossenschaftliche Zentralbank": "hbg",
      "Andere Genossenschaftliche Zentralbanken": "hbh",
      "Angeschlossene Kreditgenoss.(nur für genoss. Zentralbanken)": "hbi",
      "Sonstige mindestreservepflichtige Kreditinstitute": "hbj",
      "Ausländische Kreditinstitute gem. § 53 KWG": "hbk",
      "Internationale Organisationen im Bereich KI": "hbl",
      "Multilaterale Entwicklungsbanken nicht mindestreservefrei und ohne Nullgewichtung":
        "hbm",
      "LbNRW/InvB Berlin/Hessen/WK/LaBo/BremAB": "hbo",
      "Multilaterale Entwicklungsbanken nicht mindestreservefrei mit Nullgewichtung":
        "hbp",
      "Sonstige mindestreservefreie Kreditinstitute": "hbq",
      "Internat. Organisationen im Bereich KI (AMR-frei)": "hbr",
      "Europäische Investitionsbank": "hbs",
      "Multilaterale Entwicklungsbanken (AMR-frei)": "hbt",
      "Multilaterale Entwicklungsbanken mindestreservefrei und mit Nullgewichtung":
        "hbu",
    },
  },
  "Grundstücks- und Wohnungswesen, Vermietung (inkl. Bewegl. Sachen)": {
    "Grundstücks- und Wohnungswesen, Vermietung n. bewegl. Sachen": {
      "Erschließung, Kauf und Verkauf von Grundstücken, Gebäuden und Wohnungen":
        "iaa",
      "Vermietung und Verpachtung von eigenen Grundstücken, Gebäuden und Wohnungen":
        "iab",
      "Vermittlung und Verwaltung von fremden Grundstücken, Gebäuden und Wohnungen":
        "iac",
      "Vermietung und Verpachtung von eigenen Grundstücken und Nichtwohngebäuden und Bauträger für Nichtwohngebäude":
        "iad",
    },
    "Vermietung beweglicher Sachen": {
      "Vermietung von Kraftwagen bis 3,5 t Gesamtgewicht": "iba",
      "Vermietung von Maschinen und Geräten": "ibb",
      "Vermietung von Gebrauchsgütern, anderweitig nicht genannt": "ibc",
      "Leasing von nichtfinanziellen immatriellen Vermögensgegenständen (ohne Copyrights)":
        "ibd",
    },
  },
  "Informations- und Datenverarbeitung, Forschung und Entwicklung": {
    Informationsdienstleistungen: {
      Hardwareberatung: "jaa",
      Softwarehäuser: "jab",
    },
    Datenverarbeitung: {
      Datenverarbeitungsdienste: "jba",
      Datenbanken: "jbb",
      "Instandhaltung und Reparatur von Büromaschinen, Datenverarbeitungsgeräten und -einrichtungen":
        "jbc",
      "Sonstige mit der Datenverarbeitung verbundene Tätigkeiten und Rundfunkveranstalter":
        "jbd",
    },
    "Forschung und Entwicklung": {
      "Forschung und Entwicklung im Bereich Natur-, Ingenieur-, Agrarwissenschaften und Medizin":
        "jca",
      "Forschung und Entwicklung im Bereich Rechts-, Wirtschafts- und Sozialwissenschaften sowie im Bereich Sprach-, Kultur- und Kunstwissenschaften":
        "jcb",
    },
  },
  "Erbringung von freiberuflichen, wirtschaftlichen und technischen Dienstleistungen":
    {
      "Freiberufliche Dienstleistungen": {
        "Rechts-, Steuer- und Unternehmensberatung, Wirtschaftsprüfung, Buchführung, Markt- und Meinungsforschung, Managementtätigkeiten von Holdinggesellschaften":
          "kaa",
        "Architektur- und Ingenieurbüros": "kab",
        Werbung: "kac",
        "Personal- und Stellenvermittlung, Überlassung von Arbeitskräften":
          "kad",
        "Wach- und Sicherheitsdienste sowie Detekteien": "kae",
      },
      "Technische Dienstleistungen": {
        "Technische, physikalische und chemische Untersuchung": "kba",
        "Reinigung von Gebäuden, Inventar und Verkehrsmitteln": "kbb",
      },
      "Wirtschaftliche Dienstleistungen": {
        "Erbringung von sonstigen wirtschaftlichen Dienstleistungen, anderweitig nicht genannt":
          "kca",
      },
    },
  "Öffentliche Verwaltung, Verteidigung, Sozialversicherung": {
    "Verwaltung, Verteidigung, Sozialversicherung": {
      "Öffentliche Verwaltung": "laa",
      "Auswärtige Angelegenheiten, Verteidigung, Rechtspflege, öffentliche Sicherheit und Ordnung":
        "lab",
      "Sozialversicherung und Arbeitsförderung": "lac",
    },
    Bund: {
      "Fonds Deutsche Einheit / Erblastentilgungsfonds": "lba",
      "ERP-Sondervermögen": "lbb",
      Bundeseisenbahnvermögen: "lbc",
    },
    Länder: {
      Gemeinden: "lcb",
      "Kommunale Zweckverbände": "lcc",
      "Sonstige ausländische Gebietskörperschaften": "lcd",
    },
  },
  "Gesundheits-, Veterinär- und Sozialwesen, Erziehung und Unterricht": {
    "Erziehung und Unterricht": {
      "Kindergärten, Vor- und Grundschulen": "maa",
      "Weiterführende Schulen": "mab",
      "Hochschulen und andere Bildungseinrichtungen des Tertiärsbereichs":
        "mac",
      "Erwachsenenbildung und sonstiger Unterricht": "mad",
    },
    "Gesundheits-, Veterinär- und Sozialwesen": {
      Gesundheitswesen: "mba",
      Veterinärwesen: "mbb",
      Sozialwesen: "mbc",
    },
  },
  "Abwasser- und Abfallentsorgung, Private Haushalte": {
    Abwasserentsorgung: {
      Abwasserbeseitigung: "naa",
    },
    Abfallbeseitigung: {
      Abfallbeseitigung: "nba",
    },
    "Private Haushalte": {
      "Private Haushalte mit sonstigem Hauspersonal": "nca",
    },
  },
  "Interessenvertretungen sowie kirchliche und sonstige Vereinigungen, Organisationen":
    {
      Interessenvertretungen: {
        "Wirtschafts- und Arbeitgeberverbände": "oaa",
        Gewerkschaften: "oab",
        Berufsorganisationen: "oac",
      },
      "Kirchliche und sonstige Vereinigungen": {
        "Kirchliche und sonstige religiöse Vereinigungen": "oba",
        "Politische Parteien und Vereinigungen": "obb",
        "Interessenvertretungen und Vereinigungen, anderweitig nicht genannt":
          "obc",
      },
      Organisationen: {
        "Organisationen der freien Wohlfahrts-/Jugendpflege": "oca",
        "Organisationen der Bildung/Wissenschaft/Forsch./Kultur": "ocb",
        "Organisationen des Sports und Gesundheitswesens": "occ",
        "Kommunale Spitzen- und Regionalverbände": "ocd",
        "Sonstige Organisationen ohne Erwerbszweck": "oce",
      },
    },
  "Kunst, Unterhaltung und Erholung, Erbringung von sonstigen Dienstleistungen":
    {
      "Kunst, Unterhaltung und Erholung": {
        "Film- und Videofilmherstellung, -verleih und -vertrieb, Kinos": "paa",
        "Rundfunkveranstalter, Herstellung von Hörfunk- und Fernsehprogrammen":
          "pab",
        "Erbringung von sonstigen kulturellen und unterhaltenden Leistungen":
          "pac",
        "Korrespondenz- und Nachrichtenbüros, selbstständige Journalistinnen und Journalisten":
          "pad",
        "Bibliotheken, Archive, Museen, botanische und zoologische Gärten":
          "pae",
        Sport: "paf",
        "Erbringung von sonstigen Dienstleistungen für Unterhaltung, Erholung und Freizeit":
          "pag",
      },
      "Erbringung von sonstigen Dienstleistungen": {
        "Wäscherei und chemische Reinigung": "pba",
        "Frisör- und Kosmetiksalons": "pbb",
        Bestattungswesen: "pbc",
        "Saunas, Solarien, Fitnesszentren u.ä.": "pbd",
        "Erbringung von Dienstleistungen, anderweitig nicht genannt": "pbe",
      },
    },
};
