#ifndef _LINUX_TYPES_H
#define _LINUX_TYPES_H

/* Debian: Use userland types instead.  */
# include <sys/types.h>
/* For other kernel headers.  */
# include <linux/posix_types.h>
# include <asm/types.h>
/* For util-linux / cryptoloop.  How lame.  */
typedef __u32 __kernel_dev_t;

/*
 * Below are truly Linux-specific types that should never collide with
 * any application/library that wants linux/types.h.
 */

#ifdef __CHECKER__
#define __bitwise__ __attribute__((bitwise))
#else
#define __bitwise__
#endif
#ifdef __CHECK_ENDIAN__
#define __bitwise __bitwise__
#else
#define __bitwise
#endif

typedef __u16 __bitwise __le16;
typedef __u16 __bitwise __be16;
typedef __u32 __bitwise __le32;
typedef __u32 __bitwise __be32;
#if defined(__GNUC__)
__extension__ typedef __u64 __bitwise __le64;
__extension__ typedef __u64 __bitwise __be64;
#endif
typedef __u16 __bitwise __sum16;
typedef __u32 __bitwise __wsum;


#if 0
/* Debian: This is available from <sys/ustat.h>.  */
struct ustat {
	__kernel_daddr_t	f_tfree;
	__kernel_ino_t		f_tinode;
	char			f_fname[6];
	char			f_fpack[6];
};
#endif

#endif /* _LINUX_TYPES_H */
