#ifndef _NF_CONNTRACK_SCTP_H
#define _NF_CONNTRACK_SCTP_H
/* SCTP tracking. */

#include <linux/netfilter/nf_conntrack_tuple_common.h>

enum sctp_conntrack {
	SCTP_CONNTRACK_NONE,
	SCTP_CONNTRACK_CLOSED,
	SCTP_CONNTRACK_COOKIE_WAIT,
	SCTP_CONNTRACK_COOKIE_ECHOED,
	SCTP_CONNTRACK_ESTABLISHED,
	SCTP_CONNTRACK_SHUTDOWN_SENT,
	SCTP_CONNTRACK_SHUTDOWN_RECD,
	SCTP_CONNTRACK_SHUTDOWN_ACK_SENT,
#ifndef __GENKSYMS__
	SCTP_CONNTRACK_HEARTBEAT_SENT,
	SCTP_CONNTRACK_HEARTBEAT_ACKED,
#endif
	SCTP_CONNTRACK_MAX
};

struct ip_ct_sctp
{
	enum sctp_conntrack state;

	__be32 vtag[IP_CT_DIR_MAX];
};

#endif /* _NF_CONNTRACK_SCTP_H */
