#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Night at the Watermill
# send your bug reports to contact@dotslashplay.it
###

script_version=20241223.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='a-night-at-the-watermill'
GAME_NAME='A Night at the Watermill'

ARCHIVE_BASE_1_NAME='a_night_at_the_watermill_1_0_799_74242.sh'
ARCHIVE_BASE_1_MD5='153c7b4b64b603bf256ea191ac3e959f'
ARCHIVE_BASE_1_SIZE='640563'
ARCHIVE_BASE_1_VERSION='1.0.799-gog74242'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/a_night_at_the_watermill'

ARCHIVE_BASE_0_NAME='a_night_at_the_watermill_1_0_794_70569.sh'
ARCHIVE_BASE_0_MD5='4e5c4f9b03e2ea0198742a4ca20f2aa1'
ARCHIVE_BASE_0_SIZE='624275'
ARCHIVE_BASE_0_VERSION='1.0.794-gog70569'

CONTENT_PATH_DEFAULT='data/noarch/game/game'
CONTENT_GAME_MAIN_FILES='
cache
audio.rpa
fonts.rpa
images.rpa
scripts.rpa
script_version.txt'

USER_PERSISTENT_DIRECTORIES='
saves'

APP_MAIN_TYPE='renpy'
APP_MAIN_ICON='../../support/icon.png'
## The game tries to write a log file in the current directory,
## so write access to this path is required.
APP_MAIN_PREFIX_TYPE='symlinks'

## Ensure easy upgrades from packages generated with pre-20241212.3 game scripts
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
a-night-at-the-watermill-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

## Generate standard size icons from the shipped 125×125 one
APP_MAIN_ICON_64="$(dirname "$APP_MAIN_ICON")/icon_64.png"
APP_MAIN_ICON_128="$(dirname "$APP_MAIN_ICON")/icon_128.png"
APP_MAIN_ICONS_LIST='APP_MAIN_ICON_64 APP_MAIN_ICON_128'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	convert "$APP_MAIN_ICON" -resize 64x64 "$APP_MAIN_ICON_64"
	convert "$APP_MAIN_ICON" -resize 128x128 "$APP_MAIN_ICON_128"
)
content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
