#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Place Full of Cats series:
# - A Building Full of Cats
# - A Castle Full of Cats
# send your bug reports to contact@dotslashplay.it
###

script_version=20241002.2

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID_BUILDING='a-building-full-of-cats'
GAME_NAME_BUILDING='A Building Full of Cats'

GAME_ID_CASTLE='a-castle-full-of-cats'
GAME_NAME_CASTLE='A Castle Full of Cats'

ARCHIVE_BASE_BUILDING_0_NAME='setup_a_building_full_of_cats_1.01-gog_(64bit)_(62634).exe'
ARCHIVE_BASE_BUILDING_0_MD5='0c1fc138578320932322f774670f655b'
ARCHIVE_BASE_BUILDING_0_TYPE='innosetup'
ARCHIVE_BASE_BUILDING_0_SIZE='150000'
ARCHIVE_BASE_BUILDING_0_VERSION='1.01-gog62634'
ARCHIVE_BASE_BUILDING_0_URL='https://www.gog.com/en/game/a_building_full_of_cats'

ARCHIVE_BASE_CASTLE_0_NAME='setup_a_castle_full_of_cats_1.07_gog_w_leaderboards_(63211).exe'
ARCHIVE_BASE_CASTLE_0_MD5='f0490493f27c903c5e07f87da5e1dde5'
ARCHIVE_BASE_CASTLE_0_TYPE='innosetup'
ARCHIVE_BASE_CASTLE_0_SIZE='300000'
ARCHIVE_BASE_CASTLE_0_VERSION='1.07-gog63211'
ARCHIVE_BASE_CASTLE_0_URL='https://www.gog.com/en/game/a_castle_full_of_cats'

CONTENT_PATH_DEFAULT='.'

CONTENT_GAME_BIN_FILES_BUILDING='
building.exe'
CONTENT_GAME_BIN_FILES_CASTLE='
castle.exe'
## The game fails to start if steam_api64.dll is missing
CONTENT_GAME0_BIN_FILES='
steam_api64.dll'
## TODO: A Castle Full of Cats - Check if the Galaxy library is required
CONTENT_GAME1_BIN_FILES_CASTLE='
galaxyconfig.json
galaxy64.dll'
CONTENT_GAME_DATA_FILES_BUILDING='
building.pck'
CONTENT_GAME_DATA_FILES_CASTLE='
castle.pck'

USER_PERSISTENT_FILES='
*.cfg'

APP_MAIN_EXE_BUILDING='building.exe'
APP_MAIN_EXE_CASTLE='castle.exe'
## Warning: xxx_WRESTOOL_OPTIONS has no support for contextual values
APP_MAIN_ICON_WRESTOOL_OPTIONS_CASTLE='--type=14 --name=GODOT_ICON --language=1033'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID_BUILDING="${GAME_ID_BUILDING}-data"
PKG_DATA_ID_CASTLE="${GAME_ID_CASTLE}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

## Explicitly set the contextual value for wrestool options
APP_MAIN_ICON_WRESTOOL_OPTIONS=$(context_value 'APP_MAIN_ICON_WRESTOOL_OPTIONS')

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
