---
title: 更新履歴(2023年)
layout: default
---

&gt; [Top](../) &gt; [更新履歴]({{ site.baseurl }}/history/) &gt; {{ page.title }}

## {{ page.title }}


<a name="0.11.0-unreleased"></a>
### [0.11.0-unreleased](https://github.com/JDimproved/JDim/compare/JDim-v0.10.1...master) (unreleased)


<a name="JDim-v0.10.1"></a>
### [**JDim-v0.10.1** Release](https://github.com/JDimproved/JDim/releases/tag/JDim-v0.10.1) (2023-07-23)
主な変更点
- [2023-07-11][20230711] から5ch.netのDATファイルへのアクセスが開放されたため過去ログ読み込みに対応した

[20230711]: https://agree.5ch.net/test/read.cgi/operate/9240230711/3


<a name="0.10.1-20230723"></a>
### [0.10.1-20230723](https://github.com/JDimproved/JDim/compare/JDim-v0.10.0...JDim-v0.10.1) (2023-07-23)
- ([#1206](https://github.com/JDimproved/JDim/pull/1206))
  Release 0.10.1
- ([#1205](https://github.com/JDimproved/JDim/pull/1205))
  `NodeTree2ch`: Fix loading of past log DATs to organize DAT URLs
- ([#1204](https://github.com/JDimproved/JDim/pull/1204))
  `NodeTree2ch`: Update loading of past log DATs to enable resume mode
- ([#1201](https://github.com/JDimproved/JDim/pull/1201))
  readme: Add Unity build tips for how to faster builds
- ([#1200](https://github.com/JDimproved/JDim/pull/1200))
  Weekly CI: Add logging for cloned muon repository and built version
- ([#1199](https://github.com/JDimproved/JDim/pull/1199))
  Fix crash on `NodeTreeBase::parse_date_id()`
- ([#1196](https://github.com/JDimproved/JDim/pull/1196))
  Add notice to change UA settings before posting to prevent error
- ([#1195](https://github.com/JDimproved/JDim/pull/1195))
  Implement reading past logs with access to 5ch.net DAT files
- ([#1193](https://github.com/JDimproved/JDim/pull/1193))
  docs: Add notice about 5ch thread access in JDim


<a name="JDim-v0.10.0"></a>
### [**JDim-v0.10.0** Release](https://github.com/JDimproved/JDim/releases/tag/JDim-v0.10.0) (2023-07-08)
主な変更点
- 不正なShift\_JIS文字列をUTF-8と見なすオプションを about:config に追加した
- スレビューで太文字、文字色、背景色などを表示する機能を強化した
- Emoji ZWJ Sequences (複数の絵文字を連結して1文字として見せる絵文字) の表示に対応した
- スレビューでURLのパーセントエンコーディングをデコードして表示するオプションを about:config に追加した
- HTTPの応答から文字エンコーディングを検出する仕組みを追加した


<a name="0.10.0-20230708"></a>
### [0.10.0-20230708](https://github.com/JDimproved/JDim/compare/2d85091f13...JDim-v0.10.0) (2023-07-08)
- ([#1191](https://github.com/JDimproved/JDim/pull/1191))
  Release 0.10.0
- ([#1190](https://github.com/JDimproved/JDim/pull/1190))
  docs: Fix doxygen warnings
- ([#1189](https://github.com/JDimproved/JDim/pull/1189))
  Add weekly CI for Unity build and muon
- ([#1188](https://github.com/JDimproved/JDim/pull/1188))
  `Login2ch`: Fix compile error about unused const variable
- ([#1187](https://github.com/JDimproved/JDim/pull/1187))
  `Core`: Get rid of unused private field
- ([#1186](https://github.com/JDimproved/JDim/pull/1186))
  Fix compile errors on Unity build
- ([#1185](https://github.com/JDimproved/JDim/pull/1185))
  Bump version to 0.10.0-beta
- ([#1184](https://github.com/JDimproved/JDim/pull/1184))
  Fix comparing floating point with '==' or '!='
- ([#1183](https://github.com/JDimproved/JDim/pull/1183))
  Fix implicit narrowing conversion for floating point literal
- ([#1182](https://github.com/JDimproved/JDim/pull/1182))
  Fix snprintf() format mismatch by changing param type to unsigned int
- ([#1181](https://github.com/JDimproved/JDim/pull/1181))
  `Socket`: Fix casting of pointers to types with different alignments
- ([#1180](https://github.com/JDimproved/JDim/pull/1180))
  `DrawAreaBase`: Fix memory leak for `PangoFontMetrics`
- ([#1179](https://github.com/JDimproved/JDim/pull/1179))
  `NodeTreeBase`: Fix bug missing reply anchors in 5ch threads
- ([#1175](https://github.com/JDimproved/JDim/pull/1175))
  Fix compiler warnings for useless cast
- ([#1174](https://github.com/JDimproved/JDim/pull/1174))
  `NodeTreeBase`: Fix parameter name shadowing
- ([#1173](https://github.com/JDimproved/JDim/pull/1173))
  `NodeTreeBase`: Suppress code analysis report about invalid lifetime
- ([#1172](https://github.com/JDimproved/JDim/pull/1172))
  `NodeTreeBase`: Modify parsing HTML to unconditionally parse `<a>` elements
- ([#1171](https://github.com/JDimproved/JDim/pull/1171))
  Fix resource leak for logging
- ([#1170](https://github.com/JDimproved/JDim/pull/1170))
  `NodeTree2chCompati`: Get rid of raw mode processing
- ([#1169](https://github.com/JDimproved/JDim/pull/1169))
  Remove Rokka support
- ([#1168](https://github.com/JDimproved/JDim/pull/1168))
  Add blank lines between replies which are concatenated
- ([#1167](https://github.com/JDimproved/JDim/pull/1167))
  `NodeTreeBase`: Do not mark thread as broken on HTTP 416 error
- ([#1166](https://github.com/JDimproved/JDim/pull/1166))
  `Root`: Treat manually added 2ch/5ch boards as native boards
- ([#1165](https://github.com/JDimproved/JDim/pull/1165))
  `NodeTreeBase`: Update fucntion to parse date, ID, and BE link
- ([#1164](https://github.com/JDimproved/JDim/pull/1164))
  NodeTreeBase::parse_name(): Update loop condition and text copy
- ([#1163](https://github.com/JDimproved/JDim/pull/1163))
  `NodeTreeBase`: Update DAT/HTML parsing to add newline after `<ul>` tag
- ([#1162](https://github.com/JDimproved/JDim/pull/1162))
  Add URL Percent-Encoding decoding option to about:config
- ([#1161](https://github.com/JDimproved/JDim/pull/1161))
  `NodeTreeBase`: Refactor check anchor and link
- ([#1160](https://github.com/JDimproved/JDim/pull/1160))
  `Css_Manager`: Change `get_classid()` parameter type to use `std::string_view`
- ([#1159](https://github.com/JDimproved/JDim/pull/1159))
  Add support for using HTML tag-specified text color in thread view
- ([#1158](https://github.com/JDimproved/JDim/pull/1158))
  `NodeTreeBase`: Implement color display for HTML `<span>` and `<mark>` elements
- ([#1157](https://github.com/JDimproved/JDim/pull/1157))
  `Css_Manager`: Implement `get_property()` function returning const reference
- ([#1156](https://github.com/JDimproved/JDim/pull/1156))
  `NodeTreeBase`: Implement code for coloring via HTML and CSS
- ([#1155](https://github.com/JDimproved/JDim/pull/1155))
  `NodeTreeBase`: Convert relative URLs in HTML `<a>` elements
- ([#1154](https://github.com/JDimproved/JDim/pull/1154))
  `NodeTreeBase`: Implement bold display for text inside HTML `<b>` elements
- ([#1153](https://github.com/JDimproved/JDim/pull/1153))
  `NodeTreeBase`: Update whitespace handling in node tree construction
- ([#1152](https://github.com/JDimproved/JDim/pull/1152))
  `NodeTreeBase`: Get rid of freeing memory from `init_loading()` to reuse buffers
- ([#1151](https://github.com/JDimproved/JDim/pull/1151))
  `NodeTreeBase`: Modify default name detection to ignore trailing whitespace
- ([#1150](https://github.com/JDimproved/JDim/pull/1150))
  `NodeTreeBase`: Fix input data size adjustment in buffer copying
- ([#1149](https://github.com/JDimproved/JDim/pull/1149))
  `NodeTreeBase`: Implement `sweep_buffer()`
- ([#1148](https://github.com/JDimproved/JDim/pull/1148))
  `NodeTreeBase`: Update `receive_data()` to improve processing large data
- ([#1147](https://github.com/JDimproved/JDim/pull/1147))
  `NodeTreeBase`: Use `std::string&` for `process_raw_lines()` parameter type
- ([#1146](https://github.com/JDimproved/JDim/pull/1146))
  `NodeTreeBase`: Use `std::string&` for `add_raw_lines()` parameter type
- ([#1145](https://github.com/JDimproved/JDim/pull/1145))
  `NodeTreeBase`: Modify `parse_html()` to collect UTF-8 byte seq into buffer
- ([#1144](https://github.com/JDimproved/JDim/pull/1144))
  dbtree: Modify HTTP request range for checking DAT update
- ([#1143](https://github.com/JDimproved/JDim/pull/1143))
  `ArticleViewBase`: Support 12 chars ID in ID extraction view
- ([#1142](https://github.com/JDimproved/JDim/pull/1142))
  dbtree: Modify interface function return type to use const reference
- ([#1141](https://github.com/JDimproved/JDim/pull/1141))
  `Loader`: Fix proxy connection using IPv6
- ([#1139](https://github.com/JDimproved/JDim/pull/1139))
  `NodeTreeMachi`: Fix regex pattern for DAT conversion
- ([#1138](https://github.com/JDimproved/JDim/pull/1138))
  `BBSListViewBase`: Modify URL comparison for row selection
- ([#1137](https://github.com/JDimproved/JDim/pull/1137))
  Update network connection
- ([#1136](https://github.com/JDimproved/JDim/pull/1136))
  Update histories



<a name="0.9.0-20230401"></a>
### [0.9.0-20230401](https://github.com/JDimproved/JDim/compare/JDim-v0.9.0...2d85091f13) (2023-04-01)
- ([#1134](https://github.com/JDimproved/JDim/pull/1134))
  Get rid of size limitation for `std::string`
- ([#1133](https://github.com/JDimproved/JDim/pull/1133))
  `Loadable`: Change `receive_data()` parameters to use `std::string_view`
- ([#1132](https://github.com/JDimproved/JDim/pull/1132))
  Fix C-style pointer cast
- ([#1131](https://github.com/JDimproved/JDim/pull/1131))
  meson: Update version requirement for GTest (>= 1.10.0)
- ([#1130](https://github.com/JDimproved/JDim/pull/1130))
  `TextLoader`: reduce memory allocation for buffer
- ([#1129](https://github.com/JDimproved/JDim/pull/1129))
  `Board2chCompati`: Update `parse_subject()`
- ([#1128](https://github.com/JDimproved/JDim/pull/1128))
  `Loadable`: Add character encoding detection by HTML meta element
- ([#1127](https://github.com/JDimproved/JDim/pull/1127))
  Implement `MISC::parse_charset_from_html_meta()`
- ([#1126](https://github.com/JDimproved/JDim/pull/1126))
  `Loadable`: Add character encoding detection by HTTP header Content-Type
- ([#1125](https://github.com/JDimproved/JDim/pull/1125))
  Modify `MISC::utf8_trim()` parameter to use `std::string_view`
- ([#1124](https://github.com/JDimproved/JDim/pull/1124))
  Implement `MISC::encoding_from_web_charset()`
- ([#1123](https://github.com/JDimproved/JDim/pull/1123))
  Add unsafe character encoding options
- ([#1122](https://github.com/JDimproved/JDim/pull/1122))
  Split `MISC::encoding_to_cstr()` and `encoding_to_iconv_cstr()`
- ([#1121](https://github.com/JDimproved/JDim/pull/1121))
  Rename `MISC::encoding_from_cstr()` to encoding_from_sv()
- ([#1120](https://github.com/JDimproved/JDim/pull/1120))
  Ignore `Encoding::unknown` read from info file
- ([#1119](https://github.com/JDimproved/JDim/pull/1119))
  `Iconv`: Remove unused constructors with `std::string` parameters
- ([#1118](https://github.com/JDimproved/JDim/pull/1118))
  Use enum `Encoding` for conversion functions and encoding settings
- ([#1117](https://github.com/JDimproved/JDim/pull/1117))
  `Iconv`: Add constructors with enum Encoding parameters
- ([#1116](https://github.com/JDimproved/JDim/pull/1116))
  Implement `MISC::encoding_from_cstr()`
- ([#1115](https://github.com/JDimproved/JDim/pull/1115))
  Implement `MISC::encoding_to_cstr()`
- ([#1114](https://github.com/JDimproved/JDim/pull/1114))
  Use `std::find_if()` instead of for loops
- ([#1113](https://github.com/JDimproved/JDim/pull/1113))
  Apply `MISC::url_encode_plus()` to encode HTML form data
- ([#1112](https://github.com/JDimproved/JDim/pull/1112))
  Rename `MISC::charset_url_encode()` with `url_encode()`
- ([#1111](https://github.com/JDimproved/JDim/pull/1111))
  Rename `MISC::charset_url_encode_split()` with `url_encode_plus()`
- ([#1110](https://github.com/JDimproved/JDim/pull/1110))
  Use logical and instead of bitwise and
- ([#1109](https://github.com/JDimproved/JDim/pull/1109))
  Change `MISC::charset_url_encode_split()` to HTML form compliant
- ([#1108](https://github.com/JDimproved/JDim/pull/1108))
  Implement `MISC::url_encode_plus()`
- ([#1107](https://github.com/JDimproved/JDim/pull/1107))
  `Iconv::convert`: use unsigned char for numerical comparison
- ([#1105](https://github.com/JDimproved/JDim/pull/1105))
  Change `MISC::url_encode()` behavior to decode @ mark
- ([#1104](https://github.com/JDimproved/JDim/pull/1104))
  Change `MISC::url_encode()` parameters to use `std::string_view`
- ([#1103](https://github.com/JDimproved/JDim/pull/1103))
  Add test cases for percent encoding functions
- ([#1102](https://github.com/JDimproved/JDim/pull/1102))
  Rename local variables to avoid shadowing outer function
- ([#1101](https://github.com/JDimproved/JDim/pull/1101))
  Update character encoding enumeration to `Encoding`
- ([#1100](https://github.com/JDimproved/JDim/pull/1100))
  `Iconv`: Add `convert()` overload for passing output buffer
- ([#1099](https://github.com/JDimproved/JDim/pull/1099))
  `Iconv`: Change `convert()` return type to const `std::string&`
- ([#1098](https://github.com/JDimproved/JDim/pull/1098))
  Add override keyword to virtual function declarations
- ([#1097](https://github.com/JDimproved/JDim/pull/1097))
  `Iconv`: Add about:config option that wrong sjis assumes to be utf8
- ([#1096](https://github.com/JDimproved/JDim/pull/1096))
  `Iconv`: Use U+FFFD REPLACEMENT CHARACTER on converting to UTF-8
- ([#1095](https://github.com/JDimproved/JDim/pull/1095))
  dbtree: Get rid of buffer length limitation
- ([#1094](https://github.com/JDimproved/JDim/pull/1094))
  `Iconv`: Grow buffer size to continue iconv if output buffer is shortage
- ([#1093](https://github.com/JDimproved/JDim/pull/1093))
  buidfix: add missing cstdint to misccharcode.cpp
- ([#1092](https://github.com/JDimproved/JDim/pull/1092))
  Update documents to replace autotools with meson
- ([#1091](https://github.com/JDimproved/JDim/pull/1091))
  Update requirements for dependencies (gcc >= 8)
- ([#1090](https://github.com/JDimproved/JDim/pull/1090))
  Clean up obsolete build option for regex


<a name="JDim-v0.9.0"></a>
### [**JDim-v0.9.0** Release](https://github.com/JDimproved/JDim/releases/tag/JDim-v0.9.0) (2023-01-07)
主な変更点
- スレ一覧に表示するスレタイトルに対して置換文字列の設定を追加した
- 正規表現を使った文字列置換に英数字とカナの文字幅(いわゆる全角半角)を区別しない設定を追加した
- 正規表現を使った文字列置換にUnicodeの互換文字を区別しない設定を追加した
- W3CやWHATWGのリファレンスを参考に名前付き文字参照の変換を追加した
- about:config に不正な数値文字参照をデコードするオプションを追加した


<a name="0.9.0-20230107"></a>
### [0.9.0-20230107](https://github.com/JDimproved/JDim/compare/660f4f6755...JDim-v0.9.0) (2023-01-07)
- ([#1088](https://github.com/JDimproved/JDim/pull/1088))
  Release 0.9.0
- ([#1087](https://github.com/JDimproved/JDim/pull/1087))
  Update year to 2023
- ([#1086](https://github.com/JDimproved/JDim/pull/1086))
  Revert "Set snapcraft config for i386 (2022-12)"
- ([#1085](https://github.com/JDimproved/JDim/pull/1085))
  Set snapcraft config for i386 (2022-12)
- ([#1084](https://github.com/JDimproved/JDim/pull/1084))
  Bump version to 0.9.0-beta
- ([#1083](https://github.com/JDimproved/JDim/pull/1083))
  CI: Add a job which uses AddressSanitizer
- ([#1082](https://github.com/JDimproved/JDim/pull/1082))
  Add `correct_character_reference` option to about:config
- ([#1081](https://github.com/JDimproved/JDim/pull/1081))
  Add surrogate pair handling to `DBTREE::decode_char_number()`
- ([#1080](https://github.com/JDimproved/JDim/pull/1080))
  Implement `DBTREE::decode_char_name()`
- ([#1079](https://github.com/JDimproved/JDim/pull/1079))
  Fix crashes for testing `MISC::decode_spchar_number()`
- ([#1077](https://github.com/JDimproved/JDim/pull/1077))
  Implement `MISC::decode_spchar_number_raw()`
- ([#1076](https://github.com/JDimproved/JDim/pull/1076))
  Implement `MISC::sanitize_numeric_charref()`
- ([#1075](https://github.com/JDimproved/JDim/pull/1075))
  Use `std::thread` instead of `JDLIB::Thread`
- ([#1074](https://github.com/JDimproved/JDim/pull/1074))
  Change return type int with `char32_t` for `MISC::decode_spchar_number()`
- ([#1073](https://github.com/JDimproved/JDim/pull/1073))
  Meson: Create dependency to organize macro
- ([#1072](https://github.com/JDimproved/JDim/pull/1072))
  Improve entity reference table for `DBTREE::decode_char()`
- ([#1071](https://github.com/JDimproved/JDim/pull/1071))
  dbtree: Modify function parameters for `DBTREE::decode_char()`
- ([#1070](https://github.com/JDimproved/JDim/pull/1070))
  `DrawAreaBase`: Add null check to read `LAYOUT::rect`
- ([#1069](https://github.com/JDimproved/JDim/pull/1069))
  Get rid of unused headers
- ([#1068](https://github.com/JDimproved/JDim/pull/1068))
  `Loader`: Implement `GzipDecoder` class
- ([#1067](https://github.com/JDimproved/JDim/pull/1067))
  `DrawAreaBase`: Fix layout to wrap text if next node is not line feed
- ([#1066](https://github.com/JDimproved/JDim/pull/1066))
  Deprecate platforms where gcc version less than 8
- ([#1065](https://github.com/JDimproved/JDim/pull/1065))
  Prenotice end of support for Autotools
- ([#1064](https://github.com/JDimproved/JDim/pull/1064))
  `NodeTreeBase`: Add null checks
- ([#1063](https://github.com/JDimproved/JDim/pull/1063))
  `NodeTreeBase`: Fix parsing `<li>` tag
- ([#1062](https://github.com/JDimproved/JDim/pull/1062))
  `NodeTreeBase`: Use `std::string_view` instead of `std::string`
- ([#1061](https://github.com/JDimproved/JDim/pull/1061))
  `ArticleViewMain`: Reserve relayout if the view is not mapped
- ([#1060](https://github.com/JDimproved/JDim/pull/1060))
  `ReplaceStr`: Rebuild nodetree to relayout completely if ok clicked
- ([#1059](https://github.com/JDimproved/JDim/pull/1059))
  Modify `HEAP::clear()` to not free allocated blocks
- ([#1058](https://github.com/JDimproved/JDim/pull/1058))
  `TabNotebook`: Fix known condition true/false
- ([#1057](https://github.com/JDimproved/JDim/pull/1057))
  Use `std::string::resize()` instead of `substr()`
- ([#1056](https://github.com/JDimproved/JDim/pull/1056))
  Add const qualifier to local variables part2
- ([#1055](https://github.com/JDimproved/JDim/pull/1055))
  `BoardViewBase`: Add const qualifier to local variables
- ([#1054](https://github.com/JDimproved/JDim/pull/1054))
  `Root`: Avoid moving files if board root path source and dest are same
- ([#1053](https://github.com/JDimproved/JDim/pull/1053))
  `Root`: Decode HTML char reference for bbsmenu
- ([#1052](https://github.com/JDimproved/JDim/pull/1052))
  `NodeTree2ch`: Add `parse_extattr()` to parse the result of "!extend:"
- ([#1051](https://github.com/JDimproved/JDim/pull/1051))
  article: Add config for number of max res to thread property
- ([#1050](https://github.com/JDimproved/JDim/pull/1050))
  `ReplaceStrPref`: Add Unicode normalize option
- ([#1049](https://github.com/JDimproved/JDim/pull/1049))
  Update histories
