// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

#pragma once

const char tracez_style[] =
    ""
    "body {"
    "  color: #252525;"
    "  text-align: center;"
    "  font-family: monospace, sans-serif;"
    "  word-break: break-all;"
    "  font-size: .9em"
    "}"
    ""
    "code {"
    "  font-size: 12px;"
    "}"
    ""
    "h1 {"
    "  margin: 20px 0 0;"
    "}"
    ""
    "table {"
    "  font-family: monospace, sans-serif;"
    "  border-collapse: collapse;"
    "  font-size: 1.05em;"
    "  width: 100%;"
    "}"
    ""
    ".table-wrap {"
    "  width: 100%;"
    "  min-width: 700px;"
    "  max-width: 2000px;"
    "  margin: auto;"
    "}"
    ""
    "td, th {"
    "  word-break: break-word;"
    "  border: 1px solid #f5f5f5;"
    "  padding: 6px;"
    "  text-align: center;"
    "}"
    ""
    "#overview_table th, #overview_table tr {"
    "  border-top: none;"
    "}"
    ""
    "#headers th, #headers tr {"
    "  border-bottom: none;"
    "}"
    ""
    "#top-right {"
    "  text-align: right;"
    "  position: absolute;"
    "  top: 10px;"
    "  right: 10px;"
    "  text-shadow: .5px .5px .25px #fff;"
    "}"
    ""
    "#top-right button {"
    "  color: #f6a81c;"
    "  border: 2px solid #f6a81c;"
    "  padding: 10px;"
    "  margin: 10px;"
    "  text-transform: uppercase;"
    "  letter-spacing: 1px;"
    "  background-color: white;"
    "  border-radius: 10px;"
    "  font-weight: bold;"
    "}"
    ""
    ".right {"
    "  text-align: right;"
    "  padding: 10px;"
    "}"
    ""
    ":hover {"
    "  transition-duration: .15s;"
    "}"
    ""
    "#top-right button:hover {"
    "  border-color: #4b5fab;"
    "  color: #4b5fab;"
    "  cursor: pointer;"
    "}"
    ""
    "tr:nth-child(even) {"
    "  background-color: #eee;"
    "}"
    ""
    ".click {"
    "  text-decoration: underline dotted #4b5fab;"
    "}"
    ""
    "tr:hover, td:hover, .click:hover {"
    "  color: white;"
    "  background-color: #4b5fab;"
    "}"
    ""
    "tr:hover {"
    "  background-color: #4b5fabcb;"
    "}"
    ""
    "th {"
    "  background-color: white;"
    "  color: #252525;"
    "}"
    ""
    ".click:hover {"
    "  cursor: pointer;"
    "  color: #f6a81ccc;"
    "}"
    ""
    ".empty {"
    "  color: #999;"
    "}"
    ""
    ".sm {"
    "  width: 7%;"
    "}"
    ""
    ".sm-md {"
    "  width: 13%;"
    "}"
    ""
    ".md {"
    "  width: 23%;"
    "}"
    ""
    ".lg {"
    "  width: 63%;"
    "}"
    ""
    "img {"
    "  width: 50%;"
    "  max-width: 500px;"
    "}"
    ""
    ".subhead-name {"
    "  color: #4b5fab;"
    "}"
    ""
    ".has-tooltip {"
    "  text-decoration: underline dotted #f6a81c;"
    "}"
    ""
    ".has-tooltip:hover .tooltip {"
    "  display: block;"
    "}"
    ""
    ".tooltip {"
    "  display: none;"
    "  position: absolute;"
    "}"
    ""
    ".tooltip, .tooltip:hover {"
    "  background: #ffffffd9;"
    "  padding: 10px;"
    "  z-index: 1000;"
    "  color: #252525 !important;"
    "  border-radius: 10px;"
    "  margin: 3px 20px 0 0;"
    "}"
    "";
