/* Constant multiply table for TILEPro.
   Copyright (C) 2011-2018 Free Software Foundation, Inc.
   Contributed by Walter Lee (walt@tilera.com)

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published
   by the Free Software Foundation; either version 3, or (at your
   option) any later version.

   GCC is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING3.  If not see
   <http://www.gnu.org/licenses/>.  */

/* Note this file is auto-generated from gen-mul-tables.cc.
   Make any required changes there.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "rtl.h"
#include "expmed.h"
#include "tilepro-multiply.h"

const enum insn_code tilepro_multiply_insn_seq_decode_opcode[] = {
  CODE_FOR_nothing /* must be first */ ,
  CODE_FOR_addsi3,
  CODE_FOR_subsi3,
  CODE_FOR_insn_s1a,
  CODE_FOR_insn_s2a,
  CODE_FOR_insn_s3a,
  CODE_FOR_ashlsi3
};

const struct tilepro_multiply_insn_seq tilepro_multiply_insn_seq_table[] = {
  {-2147483647 - 1 /* 0x80000000 */ ,
   {{6, 1, 31}}			/* shli r2, r1, 31 */
   },
  {-2147483647 /* 0x80000001 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {-2147483646 /* 0x80000002 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {-2147483645 /* 0x80000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147483644 /* 0x80000004 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {-2147483643 /* 0x80000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147483642 /* 0x80000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-2147483641 /* 0x80000007 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {-2147483640 /* 0x80000008 */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {-2147483639 /* 0x80000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147483638 /* 0x8000000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-2147483632 /* 0x80000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147483616 /* 0x80000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147483584 /* 0x80000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147483520 /* 0x80000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147483392 /* 0x80000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147483136 /* 0x80000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147482624 /* 0x80000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147481600 /* 0x80000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147479552 /* 0x80001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147475456 /* 0x80002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147467264 /* 0x80004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147450880 /* 0x80008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147418112 /* 0x80010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147352576 /* 0x80020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2147221504 /* 0x80040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2146959360 /* 0x80080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2146435072 /* 0x80100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2145386496 /* 0x80200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2143289344 /* 0x80400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2139095040 /* 0x80800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2130706432 /* 0x81000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2113929216 /* 0x82000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2080374784 /* 0x84000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-2013265920 /* 0x88000000 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {-1879048192 /* 0x90000000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 28}}			/* shli r3, r2, 28 */
   },
  {-1610612737 /* 0x9fffffff */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 29},			/* shli r3, r2, 29 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {-1610612736 /* 0xa0000000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 29}}			/* shli r3, r2, 29 */
   },
  {-1342177281 /* 0xafffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 28},			/* shli r4, r3, 28 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-1207959553 /* 0xb7ffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 27},			/* shli r4, r3, 27 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-1140850689 /* 0xbbffffff */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-1073741889 /* 0xbfffffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 27},			/* shli r3, r2, 27 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-1073741857 /* 0xbfffffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 27},			/* shli r3, r2, 27 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-1073741841 /* 0xbfffffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-1073741834 /* 0xbffffff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 30},			/* shli r4, r2, 30 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-1073741833 /* 0xbffffff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-1073741832 /* 0xbffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 30},			/* shli r3, r2, 30 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-1073741831 /* 0xbffffff9 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1073741830 /* 0xbffffffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 30},			/* shli r4, r2, 30 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {-1073741829 /* 0xbffffffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-1073741828 /* 0xbffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 30},			/* shli r3, r2, 30 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-1073741827 /* 0xbffffffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 30},			/* shli r3, r2, 30 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {-1073741826 /* 0xbffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 30},			/* shli r3, r2, 30 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-1073741825 /* 0xbfffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741824 /* 0xc0000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 30}}			/* shli r3, r2, 30 */
   },
  {-1073741823 /* 0xc0000001 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-1073741822 /* 0xc0000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741821 /* 0xc0000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741820 /* 0xc0000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741819 /* 0xc0000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741818 /* 0xc0000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 30},			/* shli r3, r2, 30 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-1073741817 /* 0xc0000007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 27},			/* shli r4, r2, 27 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-1073741816 /* 0xc0000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741815 /* 0xc0000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1073741814 /* 0xc000000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-805306369 /* 0xcfffffff */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-671088641 /* 0xd7ffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 27},			/* shli r4, r3, 27 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-603979777 /* 0xdbffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 26},			/* shli r4, r3, 26 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-570425345 /* 0xddffffff */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-536870977 /* 0xdfffffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 26},			/* shli r3, r2, 26 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-536870945 /* 0xdfffffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 26},			/* shli r3, r2, 26 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-536870929 /* 0xdfffffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-536870922 /* 0xdffffff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 29},			/* shli r4, r2, 29 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-536870921 /* 0xdffffff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-536870920 /* 0xdffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 29},			/* shli r3, r2, 29 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-536870919 /* 0xdffffff9 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-536870918 /* 0xdffffffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-536870917 /* 0xdffffffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-536870916 /* 0xdffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 29},			/* shli r3, r2, 29 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-536870915 /* 0xdffffffd */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-536870914 /* 0xdffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 29},			/* shli r3, r2, 29 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-536870913 /* 0xdfffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870912 /* 0xe0000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 29}}			/* shli r3, r2, 29 */
   },
  {-536870911 /* 0xe0000001 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-536870910 /* 0xe0000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870909 /* 0xe0000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870908 /* 0xe0000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870907 /* 0xe0000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870906 /* 0xe0000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-536870905 /* 0xe0000007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 26},			/* shli r4, r2, 26 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-536870904 /* 0xe0000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870903 /* 0xe0000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-536870902 /* 0xe000000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-402653185 /* 0xe7ffffff */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-335544321 /* 0xebffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 26},			/* shli r4, r3, 26 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-301989889 /* 0xedffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 25},			/* shli r4, r3, 25 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-285212673 /* 0xeeffffff */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-268435521 /* 0xefffffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 25},			/* shli r3, r2, 25 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-268435489 /* 0xefffffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 25},			/* shli r3, r2, 25 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-268435473 /* 0xefffffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-268435466 /* 0xeffffff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 28},			/* shli r4, r2, 28 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-268435465 /* 0xeffffff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-268435464 /* 0xeffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 28},			/* shli r3, r2, 28 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-268435463 /* 0xeffffff9 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-268435462 /* 0xeffffffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-268435461 /* 0xeffffffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-268435460 /* 0xeffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 28},			/* shli r3, r2, 28 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-268435459 /* 0xeffffffd */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-268435458 /* 0xeffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 28},			/* shli r3, r2, 28 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-268435457 /* 0xefffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435456 /* 0xf0000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 28}}			/* shli r3, r2, 28 */
   },
  {-268435455 /* 0xf0000001 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-268435454 /* 0xf0000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435453 /* 0xf0000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435452 /* 0xf0000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435451 /* 0xf0000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435450 /* 0xf0000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-268435449 /* 0xf0000007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 25},			/* shli r4, r2, 25 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-268435448 /* 0xf0000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435447 /* 0xf0000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-268435446 /* 0xf000000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-201326593 /* 0xf3ffffff */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-167772161 /* 0xf5ffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 25},			/* shli r4, r3, 25 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-150994945 /* 0xf6ffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 24},			/* shli r4, r3, 24 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-142606337 /* 0xf77fffff */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-134217793 /* 0xf7ffffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 24},			/* shli r3, r2, 24 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-134217761 /* 0xf7ffffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 24},			/* shli r3, r2, 24 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-134217745 /* 0xf7ffffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-134217738 /* 0xf7fffff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 27},			/* shli r4, r2, 27 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-134217737 /* 0xf7fffff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-134217736 /* 0xf7fffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 27},			/* shli r3, r2, 27 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-134217735 /* 0xf7fffff9 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-134217734 /* 0xf7fffffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-134217733 /* 0xf7fffffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-134217732 /* 0xf7fffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 27},			/* shli r3, r2, 27 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-134217731 /* 0xf7fffffd */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-134217730 /* 0xf7fffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 27},			/* shli r3, r2, 27 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-134217729 /* 0xf7ffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217728 /* 0xf8000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 27}}			/* shli r3, r2, 27 */
   },
  {-134217727 /* 0xf8000001 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-134217726 /* 0xf8000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217725 /* 0xf8000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217724 /* 0xf8000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217723 /* 0xf8000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217722 /* 0xf8000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-134217721 /* 0xf8000007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 24},			/* shli r4, r2, 24 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-134217720 /* 0xf8000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217719 /* 0xf8000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134217718 /* 0xf800000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-100663297 /* 0xf9ffffff */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-83886081 /* 0xfaffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 24},			/* shli r4, r3, 24 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-75497473 /* 0xfb7fffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 23},			/* shli r4, r3, 23 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-71303169 /* 0xfbbfffff */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-67108929 /* 0xfbffffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 23},			/* shli r3, r2, 23 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-67108897 /* 0xfbffffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 23},			/* shli r3, r2, 23 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-67108881 /* 0xfbffffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-67108874 /* 0xfbfffff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 26},			/* shli r4, r2, 26 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-67108873 /* 0xfbfffff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-67108872 /* 0xfbfffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 26},			/* shli r3, r2, 26 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-67108871 /* 0xfbfffff9 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-67108870 /* 0xfbfffffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-67108869 /* 0xfbfffffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-67108868 /* 0xfbfffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 26},			/* shli r3, r2, 26 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-67108867 /* 0xfbfffffd */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-67108866 /* 0xfbfffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 26},			/* shli r3, r2, 26 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-67108865 /* 0xfbffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108864 /* 0xfc000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 26}}			/* shli r3, r2, 26 */
   },
  {-67108863 /* 0xfc000001 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-67108862 /* 0xfc000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108861 /* 0xfc000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108860 /* 0xfc000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108859 /* 0xfc000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108858 /* 0xfc000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-67108857 /* 0xfc000007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 23},			/* shli r4, r2, 23 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-67108856 /* 0xfc000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108855 /* 0xfc000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-67108854 /* 0xfc00000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-50331649 /* 0xfcffffff */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-41943041 /* 0xfd7fffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 23},			/* shli r4, r3, 23 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-37748737 /* 0xfdbfffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 22},			/* shli r4, r3, 22 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-35651585 /* 0xfddfffff */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-33554497 /* 0xfdffffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 22},			/* shli r3, r2, 22 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-33554465 /* 0xfdffffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 22},			/* shli r3, r2, 22 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-33554449 /* 0xfdffffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-33554442 /* 0xfdfffff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 25},			/* shli r4, r2, 25 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-33554441 /* 0xfdfffff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-33554440 /* 0xfdfffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 25},			/* shli r3, r2, 25 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-33554439 /* 0xfdfffff9 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-33554438 /* 0xfdfffffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-33554437 /* 0xfdfffffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-33554436 /* 0xfdfffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 25},			/* shli r3, r2, 25 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-33554435 /* 0xfdfffffd */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-33554434 /* 0xfdfffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 25},			/* shli r3, r2, 25 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-33554433 /* 0xfdffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554432 /* 0xfe000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 25}}			/* shli r3, r2, 25 */
   },
  {-33554431 /* 0xfe000001 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-33554430 /* 0xfe000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554429 /* 0xfe000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554428 /* 0xfe000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554427 /* 0xfe000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554426 /* 0xfe000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-33554425 /* 0xfe000007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 22},			/* shli r4, r2, 22 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-33554424 /* 0xfe000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554423 /* 0xfe000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-33554422 /* 0xfe00000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-25165825 /* 0xfe7fffff */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-20971521 /* 0xfebfffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 22},			/* shli r4, r3, 22 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-18874369 /* 0xfedfffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 21},			/* shli r4, r3, 21 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-17825793 /* 0xfeefffff */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-16777281 /* 0xfeffffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 21},			/* shli r3, r2, 21 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-16777249 /* 0xfeffffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 21},			/* shli r3, r2, 21 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-16777233 /* 0xfeffffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-16777226 /* 0xfefffff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 24},			/* shli r4, r2, 24 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-16777225 /* 0xfefffff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-16777224 /* 0xfefffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 24},			/* shli r3, r2, 24 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-16777223 /* 0xfefffff9 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-16777222 /* 0xfefffffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-16777221 /* 0xfefffffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-16777220 /* 0xfefffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 24},			/* shli r3, r2, 24 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-16777219 /* 0xfefffffd */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-16777218 /* 0xfefffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 24},			/* shli r3, r2, 24 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-16777217 /* 0xfeffffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777216 /* 0xff000000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 24}}			/* shli r3, r2, 24 */
   },
  {-16777215 /* 0xff000001 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-16777214 /* 0xff000002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777213 /* 0xff000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777212 /* 0xff000004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777211 /* 0xff000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777210 /* 0xff000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-16777209 /* 0xff000007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 21},			/* shli r4, r2, 21 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-16777208 /* 0xff000008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777207 /* 0xff000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16777206 /* 0xff00000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-12582913 /* 0xff3fffff */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-11796480 /* 0xff4c0000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 18},			/* shli r3, r2, 18 */
    {6, 2, 22},			/* shli r4, r2, 22 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-10485761 /* 0xff5fffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 21},			/* shli r4, r3, 21 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-9437185 /* 0xff6fffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 20},			/* shli r4, r3, 20 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-8912897 /* 0xff77ffff */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-8388673 /* 0xff7fffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 20},			/* shli r3, r2, 20 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-8388641 /* 0xff7fffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 20},			/* shli r3, r2, 20 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-8388625 /* 0xff7fffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-8388618 /* 0xff7ffff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 23},			/* shli r4, r2, 23 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-8388617 /* 0xff7ffff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-8388616 /* 0xff7ffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 23},			/* shli r3, r2, 23 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-8388615 /* 0xff7ffff9 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-8388614 /* 0xff7ffffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-8388613 /* 0xff7ffffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-8388612 /* 0xff7ffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 23},			/* shli r3, r2, 23 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-8388611 /* 0xff7ffffd */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-8388610 /* 0xff7ffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 23},			/* shli r3, r2, 23 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-8388609 /* 0xff7fffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388608 /* 0xff800000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 23}}			/* shli r3, r2, 23 */
   },
  {-8388607 /* 0xff800001 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-8388606 /* 0xff800002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388605 /* 0xff800003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388604 /* 0xff800004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388603 /* 0xff800005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388602 /* 0xff800006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-8388601 /* 0xff800007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 20},			/* shli r4, r2, 20 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-8388600 /* 0xff800008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388599 /* 0xff800009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8388598 /* 0xff80000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-6291457 /* 0xff9fffff */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-5242881 /* 0xffafffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 20},			/* shli r4, r3, 20 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-4718593 /* 0xffb7ffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 19},			/* shli r4, r3, 19 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-4456449 /* 0xffbbffff */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-4194369 /* 0xffbfffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 19},			/* shli r3, r2, 19 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-4194337 /* 0xffbfffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 19},			/* shli r3, r2, 19 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-4194321 /* 0xffbfffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-4194314 /* 0xffbffff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 22},			/* shli r4, r2, 22 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-4194313 /* 0xffbffff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-4194312 /* 0xffbffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 22},			/* shli r3, r2, 22 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-4194311 /* 0xffbffff9 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4194310 /* 0xffbffffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-4194309 /* 0xffbffffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-4194308 /* 0xffbffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 22},			/* shli r3, r2, 22 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-4194307 /* 0xffbffffd */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4194306 /* 0xffbffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 22},			/* shli r3, r2, 22 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-4194305 /* 0xffbfffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194304 /* 0xffc00000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 22}}			/* shli r3, r2, 22 */
   },
  {-4194303 /* 0xffc00001 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-4194302 /* 0xffc00002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194301 /* 0xffc00003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194300 /* 0xffc00004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194299 /* 0xffc00005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194298 /* 0xffc00006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-4194297 /* 0xffc00007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 19},			/* shli r4, r2, 19 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-4194296 /* 0xffc00008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194295 /* 0xffc00009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4194294 /* 0xffc0000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-3145729 /* 0xffcfffff */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2621441 /* 0xffd7ffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 19},			/* shli r4, r3, 19 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-2359297 /* 0xffdbffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 18},			/* shli r4, r3, 18 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-2228225 /* 0xffddffff */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-2097217 /* 0xffdfffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 18},			/* shli r3, r2, 18 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-2097185 /* 0xffdfffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 18},			/* shli r3, r2, 18 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-2097169 /* 0xffdfffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-2097162 /* 0xffdffff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 21},			/* shli r4, r2, 21 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-2097161 /* 0xffdffff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-2097160 /* 0xffdffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 21},			/* shli r3, r2, 21 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-2097159 /* 0xffdffff9 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2097158 /* 0xffdffffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-2097157 /* 0xffdffffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-2097156 /* 0xffdffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 21},			/* shli r3, r2, 21 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-2097155 /* 0xffdffffd */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2097154 /* 0xffdffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 21},			/* shli r3, r2, 21 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-2097153 /* 0xffdfffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097152 /* 0xffe00000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 21}}			/* shli r3, r2, 21 */
   },
  {-2097151 /* 0xffe00001 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-2097150 /* 0xffe00002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097149 /* 0xffe00003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097148 /* 0xffe00004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097147 /* 0xffe00005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097146 /* 0xffe00006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-2097145 /* 0xffe00007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 18},			/* shli r4, r2, 18 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-2097144 /* 0xffe00008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097143 /* 0xffe00009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2097142 /* 0xffe0000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-1572865 /* 0xffe7ffff */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1310721 /* 0xffebffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 18},			/* shli r4, r3, 18 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-1179649 /* 0xffedffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 17},			/* shli r4, r3, 17 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-1114113 /* 0xffeeffff */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-1048641 /* 0xffefffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 17},			/* shli r3, r2, 17 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-1048609 /* 0xffefffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 17},			/* shli r3, r2, 17 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-1048593 /* 0xffefffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-1048586 /* 0xffeffff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 20},			/* shli r4, r2, 20 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-1048585 /* 0xffeffff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-1048584 /* 0xffeffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 20},			/* shli r3, r2, 20 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-1048583 /* 0xffeffff9 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1048582 /* 0xffeffffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-1048581 /* 0xffeffffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-1048580 /* 0xffeffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 20},			/* shli r3, r2, 20 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-1048579 /* 0xffeffffd */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1048578 /* 0xffeffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 20},			/* shli r3, r2, 20 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-1048577 /* 0xffefffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048576 /* 0xfff00000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 20}}			/* shli r3, r2, 20 */
   },
  {-1048575 /* 0xfff00001 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-1048574 /* 0xfff00002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048573 /* 0xfff00003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048572 /* 0xfff00004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048571 /* 0xfff00005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048570 /* 0xfff00006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-1048569 /* 0xfff00007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 17},			/* shli r4, r2, 17 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-1048568 /* 0xfff00008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048567 /* 0xfff00009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1048566 /* 0xfff0000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-786433 /* 0xfff3ffff */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-655361 /* 0xfff5ffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 17},			/* shli r4, r3, 17 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-589825 /* 0xfff6ffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 16},			/* shli r4, r3, 16 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-557057 /* 0xfff77fff */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-524353 /* 0xfff7ffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 16},			/* shli r3, r2, 16 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-524321 /* 0xfff7ffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 16},			/* shli r3, r2, 16 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-524305 /* 0xfff7ffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-524298 /* 0xfff7fff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 19},			/* shli r4, r2, 19 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-524297 /* 0xfff7fff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-524296 /* 0xfff7fff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 19},			/* shli r3, r2, 19 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-524295 /* 0xfff7fff9 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-524294 /* 0xfff7fffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-524293 /* 0xfff7fffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-524292 /* 0xfff7fffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 19},			/* shli r3, r2, 19 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-524291 /* 0xfff7fffd */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-524290 /* 0xfff7fffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 19},			/* shli r3, r2, 19 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-524289 /* 0xfff7ffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524288 /* 0xfff80000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 19}}			/* shli r3, r2, 19 */
   },
  {-524287 /* 0xfff80001 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-524286 /* 0xfff80002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524285 /* 0xfff80003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524284 /* 0xfff80004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524283 /* 0xfff80005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524282 /* 0xfff80006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-524281 /* 0xfff80007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 16},			/* shli r4, r2, 16 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-524280 /* 0xfff80008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524279 /* 0xfff80009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-524278 /* 0xfff8000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-393217 /* 0xfff9ffff */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-327681 /* 0xfffaffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 16},			/* shli r4, r3, 16 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-294913 /* 0xfffb7fff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 15},			/* shli r4, r3, 15 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-278529 /* 0xfffbbfff */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-262209 /* 0xfffbffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 15},			/* shli r3, r2, 15 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-262177 /* 0xfffbffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 15},			/* shli r3, r2, 15 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-262161 /* 0xfffbffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-262154 /* 0xfffbfff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 18},			/* shli r4, r2, 18 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-262153 /* 0xfffbfff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-262152 /* 0xfffbfff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 18},			/* shli r3, r2, 18 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-262151 /* 0xfffbfff9 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-262150 /* 0xfffbfffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-262149 /* 0xfffbfffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-262148 /* 0xfffbfffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 18},			/* shli r3, r2, 18 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-262147 /* 0xfffbfffd */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-262146 /* 0xfffbfffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 18},			/* shli r3, r2, 18 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-262145 /* 0xfffbffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262144 /* 0xfffc0000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 18}}			/* shli r3, r2, 18 */
   },
  {-262143 /* 0xfffc0001 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-262142 /* 0xfffc0002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262141 /* 0xfffc0003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262140 /* 0xfffc0004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262139 /* 0xfffc0005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262138 /* 0xfffc0006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-262137 /* 0xfffc0007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 15},			/* shli r4, r2, 15 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-262136 /* 0xfffc0008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262135 /* 0xfffc0009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-262134 /* 0xfffc000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-196609 /* 0xfffcffff */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-163841 /* 0xfffd7fff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 15},			/* shli r4, r3, 15 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-147457 /* 0xfffdbfff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 14},			/* shli r4, r3, 14 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-139265 /* 0xfffddfff */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-131137 /* 0xfffdffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 14},			/* shli r3, r2, 14 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-131105 /* 0xfffdffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 14},			/* shli r3, r2, 14 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-131089 /* 0xfffdffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-131082 /* 0xfffdfff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 17},			/* shli r4, r2, 17 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-131081 /* 0xfffdfff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-131080 /* 0xfffdfff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 17},			/* shli r3, r2, 17 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-131079 /* 0xfffdfff9 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-131078 /* 0xfffdfffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-131077 /* 0xfffdfffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-131076 /* 0xfffdfffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 17},			/* shli r3, r2, 17 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-131075 /* 0xfffdfffd */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-131074 /* 0xfffdfffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 17},			/* shli r3, r2, 17 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-131073 /* 0xfffdffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131072 /* 0xfffe0000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 17}}			/* shli r3, r2, 17 */
   },
  {-131071 /* 0xfffe0001 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-131070 /* 0xfffe0002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131069 /* 0xfffe0003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131068 /* 0xfffe0004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131067 /* 0xfffe0005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131066 /* 0xfffe0006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-131065 /* 0xfffe0007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 14},			/* shli r4, r2, 14 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-131064 /* 0xfffe0008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131063 /* 0xfffe0009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-131062 /* 0xfffe000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-98305 /* 0xfffe7fff */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-81921 /* 0xfffebfff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 14},			/* shli r4, r3, 14 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-73729 /* 0xfffedfff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 13},			/* shli r4, r3, 13 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-69633 /* 0xfffeefff */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-65601 /* 0xfffeffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 13},			/* shli r3, r2, 13 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-65569 /* 0xfffeffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 13},			/* shli r3, r2, 13 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-65553 /* 0xfffeffef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-65546 /* 0xfffefff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 16},			/* shli r4, r2, 16 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-65545 /* 0xfffefff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-65544 /* 0xfffefff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 16},			/* shli r3, r2, 16 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-65543 /* 0xfffefff9 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-65542 /* 0xfffefffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-65541 /* 0xfffefffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-65540 /* 0xfffefffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 16},			/* shli r3, r2, 16 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-65539 /* 0xfffefffd */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-65538 /* 0xfffefffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 16},			/* shli r3, r2, 16 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-65537 /* 0xfffeffff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65536 /* 0xffff0000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 16}}			/* shli r3, r2, 16 */
   },
  {-65535 /* 0xffff0001 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-65534 /* 0xffff0002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65533 /* 0xffff0003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65532 /* 0xffff0004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65531 /* 0xffff0005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65530 /* 0xffff0006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-65529 /* 0xffff0007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 13},			/* shli r4, r2, 13 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-65528 /* 0xffff0008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65527 /* 0xffff0009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-65526 /* 0xffff000a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-49153 /* 0xffff3fff */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-40961 /* 0xffff5fff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 13},			/* shli r4, r3, 13 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-36865 /* 0xffff6fff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 12},			/* shli r4, r3, 12 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-34817 /* 0xffff77ff */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-32833 /* 0xffff7fbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 12},			/* shli r3, r2, 12 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-32801 /* 0xffff7fdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 12},			/* shli r3, r2, 12 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-32785 /* 0xffff7fef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-32778 /* 0xffff7ff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 15},			/* shli r4, r2, 15 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-32777 /* 0xffff7ff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-32776 /* 0xffff7ff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 15},			/* shli r3, r2, 15 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-32775 /* 0xffff7ff9 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-32774 /* 0xffff7ffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-32773 /* 0xffff7ffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-32772 /* 0xffff7ffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 15},			/* shli r3, r2, 15 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-32771 /* 0xffff7ffd */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-32770 /* 0xffff7ffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 15},			/* shli r3, r2, 15 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-32769 /* 0xffff7fff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32768 /* 0xffff8000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 15}}			/* shli r3, r2, 15 */
   },
  {-32767 /* 0xffff8001 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-32766 /* 0xffff8002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32765 /* 0xffff8003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32764 /* 0xffff8004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32763 /* 0xffff8005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32762 /* 0xffff8006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-32761 /* 0xffff8007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 12},			/* shli r4, r2, 12 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-32760 /* 0xffff8008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32759 /* 0xffff8009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32758 /* 0xffff800a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-24577 /* 0xffff9fff */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-20481 /* 0xffffafff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 12},			/* shli r4, r3, 12 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-19447 /* 0xffffb409 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 10},			/* shli r4, r3, 10 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-18433 /* 0xffffb7ff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 11},			/* shli r4, r3, 11 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-17409 /* 0xffffbbff */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-16449 /* 0xffffbfbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 11},			/* shli r3, r2, 11 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-16423 /* 0xffffbfd9 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-16417 /* 0xffffbfdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 11},			/* shli r3, r2, 11 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-16401 /* 0xffffbfef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-16394 /* 0xffffbff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 14},			/* shli r4, r2, 14 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-16393 /* 0xffffbff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-16392 /* 0xffffbff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 14},			/* shli r3, r2, 14 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-16391 /* 0xffffbff9 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-16390 /* 0xffffbffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-16389 /* 0xffffbffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-16388 /* 0xffffbffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 14},			/* shli r3, r2, 14 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-16387 /* 0xffffbffd */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-16386 /* 0xffffbffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 14},			/* shli r3, r2, 14 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-16385 /* 0xffffbfff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16384 /* 0xffffc000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 14}}			/* shli r3, r2, 14 */
   },
  {-16383 /* 0xffffc001 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-16382 /* 0xffffc002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16381 /* 0xffffc003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16380 /* 0xffffc004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16379 /* 0xffffc005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16378 /* 0xffffc006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-16377 /* 0xffffc007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 11},			/* shli r4, r2, 11 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-16376 /* 0xffffc008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16375 /* 0xffffc009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16374 /* 0xffffc00a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-12289 /* 0xffffcfff */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-11248 /* 0xffffd410 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-10241 /* 0xffffd7ff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 11},			/* shli r4, r3, 11 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-9232 /* 0xffffdbf0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 10},			/* shli r3, r2, 10 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-9217 /* 0xffffdbff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 10},			/* shli r4, r3, 10 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-9198 /* 0xffffdc12 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 10},			/* shli r4, r2, 10 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-9191 /* 0xffffdc19 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 1, 3},			/* s1a r4, r1, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-8705 /* 0xffffddff */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-8257 /* 0xffffdfbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 10},			/* shli r3, r2, 10 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-8225 /* 0xffffdfdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 10},			/* shli r3, r2, 10 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-8209 /* 0xffffdfef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-8208 /* 0xffffdff0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-8202 /* 0xffffdff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 13},			/* shli r4, r2, 13 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-8201 /* 0xffffdff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-8200 /* 0xffffdff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 13},			/* shli r3, r2, 13 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-8199 /* 0xffffdff9 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-8198 /* 0xffffdffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-8197 /* 0xffffdffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-8196 /* 0xffffdffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 13},			/* shli r3, r2, 13 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-8195 /* 0xffffdffd */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-8194 /* 0xffffdffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 13},			/* shli r3, r2, 13 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-8193 /* 0xffffdfff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8192 /* 0xffffe000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 13}}			/* shli r3, r2, 13 */
   },
  {-8191 /* 0xffffe001 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-8190 /* 0xffffe002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8189 /* 0xffffe003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8188 /* 0xffffe004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8187 /* 0xffffe005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8186 /* 0xffffe006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-8185 /* 0xffffe007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 10},			/* shli r4, r2, 10 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-8184 /* 0xffffe008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8183 /* 0xffffe009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-8182 /* 0xffffe00a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-7678 /* 0xffffe202 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-6145 /* 0xffffe7ff */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-5121 /* 0xffffebff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 10},			/* shli r4, r3, 10 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-4609 /* 0xffffedff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 9},			/* shli r4, r3, 9 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-4353 /* 0xffffeeff */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-4161 /* 0xffffefbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 9},			/* shli r3, r2, 9 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-4129 /* 0xffffefdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 9},			/* shli r3, r2, 9 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-4113 /* 0xffffefef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-4106 /* 0xffffeff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 12},			/* shli r4, r2, 12 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-4105 /* 0xffffeff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-4104 /* 0xffffeff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 12},			/* shli r3, r2, 12 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-4103 /* 0xffffeff9 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4102 /* 0xffffeffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-4101 /* 0xffffeffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-4100 /* 0xffffeffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 12},			/* shli r3, r2, 12 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-4099 /* 0xffffeffd */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-4098 /* 0xffffeffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 12},			/* shli r3, r2, 12 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-4097 /* 0xffffefff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4096 /* 0xfffff000 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 12}}			/* shli r3, r2, 12 */
   },
  {-4095 /* 0xfffff001 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-4094 /* 0xfffff002 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4093 /* 0xfffff003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4092 /* 0xfffff004 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4091 /* 0xfffff005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4090 /* 0xfffff006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-4089 /* 0xfffff007 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-4088 /* 0xfffff008 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4087 /* 0xfffff009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-4086 /* 0xfffff00a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-4078 /* 0xfffff012 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-3600 /* 0xfffff1f0 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-3073 /* 0xfffff3ff */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-3072 /* 0xfffff400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2912 /* 0xfffff4a0 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-2561 /* 0xfffff5ff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 9},			/* shli r4, r3, 9 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-2305 /* 0xfffff6ff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 8},			/* shli r4, r3, 8 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-2184 /* 0xfffff778 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-2177 /* 0xfffff77f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-2113 /* 0xfffff7bf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-2081 /* 0xfffff7df */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-2065 /* 0xfffff7ef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-2058 /* 0xfffff7f6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 11},			/* shli r4, r2, 11 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-2057 /* 0xfffff7f7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-2056 /* 0xfffff7f8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 11},			/* shli r3, r2, 11 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-2055 /* 0xfffff7f9 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2054 /* 0xfffff7fa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-2053 /* 0xfffff7fb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-2052 /* 0xfffff7fc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 11},			/* shli r3, r2, 11 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-2051 /* 0xfffff7fd */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-2050 /* 0xfffff7fe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 11},			/* shli r3, r2, 11 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-2049 /* 0xfffff7ff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2048 /* 0xfffff800 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 11}}			/* shli r3, r2, 11 */
   },
  {-2047 /* 0xfffff801 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-2046 /* 0xfffff802 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2045 /* 0xfffff803 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2044 /* 0xfffff804 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2043 /* 0xfffff805 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2042 /* 0xfffff806 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-2041 /* 0xfffff807 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-2040 /* 0xfffff808 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2039 /* 0xfffff809 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-2038 /* 0xfffff80a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-1537 /* 0xfffff9ff */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1512 /* 0xfffffa18 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-1500 /* 0xfffffa24 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-1396 /* 0xfffffa8c */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-1344 /* 0xfffffac0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-1312 /* 0xfffffae0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {-1281 /* 0xfffffaff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 8},			/* shli r4, r3, 8 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-1153 /* 0xfffffb7f */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-1089 /* 0xfffffbbf */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-1059 /* 0xfffffbdd */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-1057 /* 0xfffffbdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-1041 /* 0xfffffbef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-1034 /* 0xfffffbf6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 10},			/* shli r4, r2, 10 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-1033 /* 0xfffffbf7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-1032 /* 0xfffffbf8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 10},			/* shli r3, r2, 10 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-1031 /* 0xfffffbf9 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1030 /* 0xfffffbfa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-1029 /* 0xfffffbfb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-1028 /* 0xfffffbfc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 10},			/* shli r3, r2, 10 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-1027 /* 0xfffffbfd */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-1026 /* 0xfffffbfe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 10},			/* shli r3, r2, 10 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-1025 /* 0xfffffbff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1024 /* 0xfffffc00 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 10}}			/* shli r3, r2, 10 */
   },
  {-1023 /* 0xfffffc01 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-1022 /* 0xfffffc02 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1021 /* 0xfffffc03 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1020 /* 0xfffffc04 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1019 /* 0xfffffc05 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1018 /* 0xfffffc06 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-1017 /* 0xfffffc07 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-1016 /* 0xfffffc08 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1015 /* 0xfffffc09 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1014 /* 0xfffffc0a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-1013 /* 0xfffffc0b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-1012 /* 0xfffffc0c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-1011 /* 0xfffffc0d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {-1010 /* 0xfffffc0e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {3, 1, 3},			/* s1a r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-1009 /* 0xfffffc0f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-1008 /* 0xfffffc10 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-1007 /* 0xfffffc11 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-1006 /* 0xfffffc12 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-1005 /* 0xfffffc13 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 1}}			/* s1a r5, r4, r1 */
   },
  {-1004 /* 0xfffffc14 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-1003 /* 0xfffffc15 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {-1001 /* 0xfffffc17 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-1000 /* 0xfffffc18 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-999 /* 0xfffffc19 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {-997 /* 0xfffffc1b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-996 /* 0xfffffc1c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {4, 1, 3},			/* s2a r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-994 /* 0xfffffc1e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {3, 1, 3},			/* s1a r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-993 /* 0xfffffc1f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-992 /* 0xfffffc20 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-991 /* 0xfffffc21 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-990 /* 0xfffffc22 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-988 /* 0xfffffc24 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-987 /* 0xfffffc25 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {-984 /* 0xfffffc28 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-983 /* 0xfffffc29 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {-979 /* 0xfffffc2d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-976 /* 0xfffffc30 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-975 /* 0xfffffc31 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {-969 /* 0xfffffc37 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-968 /* 0xfffffc38 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {5, 1, 3},			/* s3a r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-967 /* 0xfffffc39 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-965 /* 0xfffffc3b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-964 /* 0xfffffc3c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {4, 1, 3},			/* s2a r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-963 /* 0xfffffc3d */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 1},			/* s1a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-962 /* 0xfffffc3e */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {3, 1, 3},			/* s1a r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-961 /* 0xfffffc3f */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-960 /* 0xfffffc40 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-959 /* 0xfffffc41 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-958 /* 0xfffffc42 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-957 /* 0xfffffc43 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-956 /* 0xfffffc44 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-955 /* 0xfffffc45 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 4}}			/* s2a r5, r4, r4 */
   },
  {-953 /* 0xfffffc47 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-952 /* 0xfffffc48 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-951 /* 0xfffffc49 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {-945 /* 0xfffffc4f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {-944 /* 0xfffffc50 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-943 /* 0xfffffc51 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-942 /* 0xfffffc52 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {-940 /* 0xfffffc54 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-936 /* 0xfffffc58 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-935 /* 0xfffffc59 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-929 /* 0xfffffc5f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-928 /* 0xfffffc60 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {-925 /* 0xfffffc63 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-924 /* 0xfffffc64 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {-920 /* 0xfffffc68 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-919 /* 0xfffffc69 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-916 /* 0xfffffc6c */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-913 /* 0xfffffc6f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-912 /* 0xfffffc70 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-911 /* 0xfffffc71 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-910 /* 0xfffffc72 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-905 /* 0xfffffc77 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-904 /* 0xfffffc78 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-903 /* 0xfffffc79 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {-902 /* 0xfffffc7a */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-901 /* 0xfffffc7b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-900 /* 0xfffffc7c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-899 /* 0xfffffc7d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-898 /* 0xfffffc7e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-897 /* 0xfffffc7f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-896 /* 0xfffffc80 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-895 /* 0xfffffc81 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-894 /* 0xfffffc82 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-893 /* 0xfffffc83 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-892 /* 0xfffffc84 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-891 /* 0xfffffc85 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-890 /* 0xfffffc86 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-889 /* 0xfffffc87 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-888 /* 0xfffffc88 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {-887 /* 0xfffffc89 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-886 /* 0xfffffc8a */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 1, 2},			/* s1a r4, r1, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-884 /* 0xfffffc8c */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 1, 2},			/* s2a r4, r1, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-881 /* 0xfffffc8f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-880 /* 0xfffffc90 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-879 /* 0xfffffc91 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {3, 4, 1}}			/* s1a r5, r4, r1 */
   },
  {-873 /* 0xfffffc97 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-872 /* 0xfffffc98 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-868 /* 0xfffffc9c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-865 /* 0xfffffc9f */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-864 /* 0xfffffca0 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {-863 /* 0xfffffca1 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-861 /* 0xfffffca3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-860 /* 0xfffffca4 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-856 /* 0xfffffca8 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-855 /* 0xfffffca9 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {-847 /* 0xfffffcb1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-837 /* 0xfffffcbb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-835 /* 0xfffffcbd */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-834 /* 0xfffffcbe */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {-832 /* 0xfffffcc0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 6}}			/* shli r5, r4, 6 */
   },
  {-831 /* 0xfffffcc1 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-829 /* 0xfffffcc3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-828 /* 0xfffffcc4 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-827 /* 0xfffffcc5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-824 /* 0xfffffcc8 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-823 /* 0xfffffcc9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-819 /* 0xfffffccd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-816 /* 0xfffffcd0 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-815 /* 0xfffffcd1 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-803 /* 0xfffffcdd */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-801 /* 0xfffffcdf */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-800 /* 0xfffffce0 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-799 /* 0xfffffce1 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-797 /* 0xfffffce3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-796 /* 0xfffffce4 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-795 /* 0xfffffce5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-793 /* 0xfffffce7 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-792 /* 0xfffffce8 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 8},			/* shli r4, r3, 8 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-791 /* 0xfffffce9 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-789 /* 0xfffffceb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-788 /* 0xfffffcec */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-785 /* 0xfffffcef */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-784 /* 0xfffffcf0 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-783 /* 0xfffffcf1 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-781 /* 0xfffffcf3 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-780 /* 0xfffffcf4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 8},			/* shli r4, r3, 8 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {-779 /* 0xfffffcf5 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-777 /* 0xfffffcf7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-776 /* 0xfffffcf8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-775 /* 0xfffffcf9 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-774 /* 0xfffffcfa */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 8},			/* shli r4, r3, 8 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-773 /* 0xfffffcfb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-772 /* 0xfffffcfc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-771 /* 0xfffffcfd */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 4}}			/* s1a r5, r4, r4 */
   },
  {-770 /* 0xfffffcfe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-769 /* 0xfffffcff */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-768 /* 0xfffffd00 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-767 /* 0xfffffd01 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-766 /* 0xfffffd02 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-765 /* 0xfffffd03 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-764 /* 0xfffffd04 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {-763 /* 0xfffffd05 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-762 /* 0xfffffd06 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-761 /* 0xfffffd07 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-760 /* 0xfffffd08 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-759 /* 0xfffffd09 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-757 /* 0xfffffd0b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-756 /* 0xfffffd0c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-755 /* 0xfffffd0d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-753 /* 0xfffffd0f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-752 /* 0xfffffd10 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-751 /* 0xfffffd11 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {-749 /* 0xfffffd13 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 1, 3},			/* s3a r4, r1, r3 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {-748 /* 0xfffffd14 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-744 /* 0xfffffd18 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-743 /* 0xfffffd19 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-741 /* 0xfffffd1b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-739 /* 0xfffffd1d */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-737 /* 0xfffffd1f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-736 /* 0xfffffd20 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {-735 /* 0xfffffd21 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {-732 /* 0xfffffd24 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-729 /* 0xfffffd27 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {-728 /* 0xfffffd28 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-720 /* 0xfffffd30 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-719 /* 0xfffffd31 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-715 /* 0xfffffd35 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-712 /* 0xfffffd38 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-711 /* 0xfffffd39 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {-708 /* 0xfffffd3c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-707 /* 0xfffffd3d */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-705 /* 0xfffffd3f */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-704 /* 0xfffffd40 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 6}}			/* shli r5, r4, 6 */
   },
  {-703 /* 0xfffffd41 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-701 /* 0xfffffd43 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-700 /* 0xfffffd44 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-699 /* 0xfffffd45 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-695 /* 0xfffffd49 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-693 /* 0xfffffd4b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-692 /* 0xfffffd4c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-688 /* 0xfffffd50 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-680 /* 0xfffffd58 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-679 /* 0xfffffd59 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-675 /* 0xfffffd5d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-673 /* 0xfffffd5f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-672 /* 0xfffffd60 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-671 /* 0xfffffd61 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-667 /* 0xfffffd65 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-664 /* 0xfffffd68 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-660 /* 0xfffffd6c */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {-659 /* 0xfffffd6d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-657 /* 0xfffffd6f */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {-656 /* 0xfffffd70 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-655 /* 0xfffffd71 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-651 /* 0xfffffd75 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-650 /* 0xfffffd76 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-649 /* 0xfffffd77 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-648 /* 0xfffffd78 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-647 /* 0xfffffd79 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 3},			/* shli r4, r3, 3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-645 /* 0xfffffd7b */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 4}}			/* s2a r5, r4, r4 */
   },
  {-644 /* 0xfffffd7c */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-643 /* 0xfffffd7d */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-642 /* 0xfffffd7e */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {-641 /* 0xfffffd7f */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-640 /* 0xfffffd80 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 7}}			/* shli r4, r3, 7 */
   },
  {-639 /* 0xfffffd81 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-638 /* 0xfffffd82 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-637 /* 0xfffffd83 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-636 /* 0xfffffd84 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-635 /* 0xfffffd85 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-634 /* 0xfffffd86 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-633 /* 0xfffffd87 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-632 /* 0xfffffd88 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 3},			/* shli r3, r1, 3 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-631 /* 0xfffffd89 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-630 /* 0xfffffd8a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-629 /* 0xfffffd8b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-627 /* 0xfffffd8d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-625 /* 0xfffffd8f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 4}}			/* s2a r5, r4, r4 */
   },
  {-624 /* 0xfffffd90 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-620 /* 0xfffffd94 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-619 /* 0xfffffd95 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-616 /* 0xfffffd98 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-615 /* 0xfffffd99 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-613 /* 0xfffffd9b */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {4, 3, 3},			/* s2a r4, r3, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-612 /* 0xfffffd9c */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {-611 /* 0xfffffd9d */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-609 /* 0xfffffd9f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-608 /* 0xfffffda0 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-607 /* 0xfffffda1 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-604 /* 0xfffffda4 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-603 /* 0xfffffda5 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-600 /* 0xfffffda8 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-599 /* 0xfffffda9 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-595 /* 0xfffffdad */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-594 /* 0xfffffdae */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-593 /* 0xfffffdaf */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-592 /* 0xfffffdb0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-591 /* 0xfffffdb1 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-589 /* 0xfffffdb3 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-588 /* 0xfffffdb4 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 3},			/* s2a r4, r3, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-585 /* 0xfffffdb7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {-584 /* 0xfffffdb8 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-583 /* 0xfffffdb9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-581 /* 0xfffffdbb */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {4, 3, 3},			/* s2a r4, r3, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-580 /* 0xfffffdbc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-579 /* 0xfffffdbd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-578 /* 0xfffffdbe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {-577 /* 0xfffffdbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-576 /* 0xfffffdc0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 6}}			/* shli r4, r3, 6 */
   },
  {-575 /* 0xfffffdc1 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-574 /* 0xfffffdc2 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-573 /* 0xfffffdc3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-572 /* 0xfffffdc4 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-571 /* 0xfffffdc5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-569 /* 0xfffffdc7 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-568 /* 0xfffffdc8 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 3},			/* shli r3, r1, 3 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-567 /* 0xfffffdc9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-566 /* 0xfffffdca */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-565 /* 0xfffffdcb */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-564 /* 0xfffffdcc */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-563 /* 0xfffffdcd */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-561 /* 0xfffffdcf */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-560 /* 0xfffffdd0 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-559 /* 0xfffffdd1 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-558 /* 0xfffffdd2 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-557 /* 0xfffffdd3 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-556 /* 0xfffffdd4 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-555 /* 0xfffffdd5 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-553 /* 0xfffffdd7 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-552 /* 0xfffffdd8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-551 /* 0xfffffdd9 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-549 /* 0xfffffddb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {-548 /* 0xfffffddc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {-547 /* 0xfffffddd */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-546 /* 0xfffffdde */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {-545 /* 0xfffffddf */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-544 /* 0xfffffde0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {-543 /* 0xfffffde1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-542 /* 0xfffffde2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-540 /* 0xfffffde4 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-539 /* 0xfffffde5 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-536 /* 0xfffffde8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-535 /* 0xfffffde9 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-533 /* 0xfffffdeb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-532 /* 0xfffffdec */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {-531 /* 0xfffffded */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {-530 /* 0xfffffdee */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-529 /* 0xfffffdef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-528 /* 0xfffffdf0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-527 /* 0xfffffdf1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-526 /* 0xfffffdf2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-525 /* 0xfffffdf3 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {-524 /* 0xfffffdf4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-523 /* 0xfffffdf5 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-522 /* 0xfffffdf6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-521 /* 0xfffffdf7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-520 /* 0xfffffdf8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 9},			/* shli r3, r2, 9 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-519 /* 0xfffffdf9 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-518 /* 0xfffffdfa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-517 /* 0xfffffdfb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-516 /* 0xfffffdfc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 9},			/* shli r3, r2, 9 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-515 /* 0xfffffdfd */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-514 /* 0xfffffdfe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 9},			/* shli r3, r2, 9 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-513 /* 0xfffffdff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-512 /* 0xfffffe00 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 9}}			/* shli r3, r2, 9 */
   },
  {-511 /* 0xfffffe01 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-510 /* 0xfffffe02 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-509 /* 0xfffffe03 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-508 /* 0xfffffe04 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-507 /* 0xfffffe05 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-506 /* 0xfffffe06 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-505 /* 0xfffffe07 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-504 /* 0xfffffe08 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-503 /* 0xfffffe09 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-502 /* 0xfffffe0a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-501 /* 0xfffffe0b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-500 /* 0xfffffe0c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-499 /* 0xfffffe0d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {-498 /* 0xfffffe0e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {3, 1, 3},			/* s1a r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-497 /* 0xfffffe0f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-496 /* 0xfffffe10 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-495 /* 0xfffffe11 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-494 /* 0xfffffe12 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-493 /* 0xfffffe13 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 1}}			/* s1a r5, r4, r1 */
   },
  {-492 /* 0xfffffe14 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-491 /* 0xfffffe15 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {-489 /* 0xfffffe17 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-488 /* 0xfffffe18 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-487 /* 0xfffffe19 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {-485 /* 0xfffffe1b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-484 /* 0xfffffe1c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 1, 3},			/* s2a r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-483 /* 0xfffffe1d */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 1},			/* s1a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-482 /* 0xfffffe1e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {3, 1, 3},			/* s1a r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-481 /* 0xfffffe1f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-480 /* 0xfffffe20 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-479 /* 0xfffffe21 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-478 /* 0xfffffe22 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-477 /* 0xfffffe23 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-476 /* 0xfffffe24 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-475 /* 0xfffffe25 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {-472 /* 0xfffffe28 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-471 /* 0xfffffe29 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {-468 /* 0xfffffe2c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-467 /* 0xfffffe2d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-465 /* 0xfffffe2f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {-464 /* 0xfffffe30 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-463 /* 0xfffffe31 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-462 /* 0xfffffe32 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-460 /* 0xfffffe34 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-457 /* 0xfffffe37 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-456 /* 0xfffffe38 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-455 /* 0xfffffe39 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {-454 /* 0xfffffe3a */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-453 /* 0xfffffe3b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-452 /* 0xfffffe3c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-451 /* 0xfffffe3d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-450 /* 0xfffffe3e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-449 /* 0xfffffe3f */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-448 /* 0xfffffe40 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-447 /* 0xfffffe41 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-446 /* 0xfffffe42 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-445 /* 0xfffffe43 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-444 /* 0xfffffe44 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-443 /* 0xfffffe45 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-442 /* 0xfffffe46 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-441 /* 0xfffffe47 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-440 /* 0xfffffe48 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {-439 /* 0xfffffe49 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-438 /* 0xfffffe4a */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 1, 2},			/* s1a r4, r1, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-436 /* 0xfffffe4c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 1, 2},			/* s2a r4, r1, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-433 /* 0xfffffe4f */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-432 /* 0xfffffe50 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-431 /* 0xfffffe51 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-429 /* 0xfffffe53 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-428 /* 0xfffffe54 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-424 /* 0xfffffe58 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-423 /* 0xfffffe59 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {-419 /* 0xfffffe5d */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-418 /* 0xfffffe5e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {-417 /* 0xfffffe5f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-416 /* 0xfffffe60 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {-415 /* 0xfffffe61 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-413 /* 0xfffffe63 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-412 /* 0xfffffe64 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-411 /* 0xfffffe65 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-409 /* 0xfffffe67 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-408 /* 0xfffffe68 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-407 /* 0xfffffe69 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-405 /* 0xfffffe6b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-404 /* 0xfffffe6c */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-403 /* 0xfffffe6d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-401 /* 0xfffffe6f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-400 /* 0xfffffe70 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-399 /* 0xfffffe71 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-397 /* 0xfffffe73 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-396 /* 0xfffffe74 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {-395 /* 0xfffffe75 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-393 /* 0xfffffe77 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-392 /* 0xfffffe78 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-391 /* 0xfffffe79 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-390 /* 0xfffffe7a */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-389 /* 0xfffffe7b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-388 /* 0xfffffe7c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-387 /* 0xfffffe7d */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 4}}			/* s1a r5, r4, r4 */
   },
  {-386 /* 0xfffffe7e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-385 /* 0xfffffe7f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-384 /* 0xfffffe80 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-383 /* 0xfffffe81 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-382 /* 0xfffffe82 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-381 /* 0xfffffe83 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-380 /* 0xfffffe84 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {-379 /* 0xfffffe85 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-378 /* 0xfffffe86 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-377 /* 0xfffffe87 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-376 /* 0xfffffe88 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-375 /* 0xfffffe89 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-373 /* 0xfffffe8b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-372 /* 0xfffffe8c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-371 /* 0xfffffe8d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-369 /* 0xfffffe8f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-368 /* 0xfffffe90 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-367 /* 0xfffffe91 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-365 /* 0xfffffe93 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 1, 3},			/* s3a r4, r1, r3 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {-364 /* 0xfffffe94 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-361 /* 0xfffffe97 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-360 /* 0xfffffe98 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-359 /* 0xfffffe99 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-357 /* 0xfffffe9b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-356 /* 0xfffffe9c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-355 /* 0xfffffe9d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 3},			/* shli r4, r3, 3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-353 /* 0xfffffe9f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-352 /* 0xfffffea0 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {-351 /* 0xfffffea1 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-349 /* 0xfffffea3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-348 /* 0xfffffea4 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-347 /* 0xfffffea5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-344 /* 0xfffffea8 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-343 /* 0xfffffea9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-341 /* 0xfffffeab */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-340 /* 0xfffffeac */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-339 /* 0xfffffead */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-337 /* 0xfffffeaf */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-336 /* 0xfffffeb0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-335 /* 0xfffffeb1 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-333 /* 0xfffffeb3 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-332 /* 0xfffffeb4 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-331 /* 0xfffffeb5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-330 /* 0xfffffeb6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-329 /* 0xfffffeb7 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-328 /* 0xfffffeb8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-327 /* 0xfffffeb9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-325 /* 0xfffffebb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 4}}			/* s2a r5, r4, r4 */
   },
  {-324 /* 0xfffffebc */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-323 /* 0xfffffebd */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-322 /* 0xfffffebe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {-321 /* 0xfffffebf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-320 /* 0xfffffec0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 6}}			/* shli r4, r3, 6 */
   },
  {-319 /* 0xfffffec1 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-318 /* 0xfffffec2 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-317 /* 0xfffffec3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-316 /* 0xfffffec4 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-315 /* 0xfffffec5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-314 /* 0xfffffec6 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-313 /* 0xfffffec7 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-312 /* 0xfffffec8 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 3},			/* shli r3, r1, 3 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-311 /* 0xfffffec9 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-310 /* 0xfffffeca */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-309 /* 0xfffffecb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-307 /* 0xfffffecd */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-306 /* 0xfffffece */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-305 /* 0xfffffecf */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 4}}			/* s2a r5, r4, r4 */
   },
  {-304 /* 0xfffffed0 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-303 /* 0xfffffed1 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-301 /* 0xfffffed3 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-300 /* 0xfffffed4 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-299 /* 0xfffffed5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-297 /* 0xfffffed7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {-296 /* 0xfffffed8 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-295 /* 0xfffffed9 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-293 /* 0xfffffedb */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-292 /* 0xfffffedc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {-291 /* 0xfffffedd */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-290 /* 0xfffffede */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {-289 /* 0xfffffedf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-288 /* 0xfffffee0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {-287 /* 0xfffffee1 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-286 /* 0xfffffee2 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-285 /* 0xfffffee3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-284 /* 0xfffffee4 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-283 /* 0xfffffee5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-281 /* 0xfffffee7 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-280 /* 0xfffffee8 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-279 /* 0xfffffee9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-278 /* 0xfffffeea */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-277 /* 0xfffffeeb */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-276 /* 0xfffffeec */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {-275 /* 0xfffffeed */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-274 /* 0xfffffeee */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-273 /* 0xfffffeef */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-272 /* 0xfffffef0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-271 /* 0xfffffef1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-270 /* 0xfffffef2 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-269 /* 0xfffffef3 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-268 /* 0xfffffef4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-267 /* 0xfffffef5 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-266 /* 0xfffffef6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-265 /* 0xfffffef7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-264 /* 0xfffffef8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-263 /* 0xfffffef9 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-262 /* 0xfffffefa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-261 /* 0xfffffefb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-260 /* 0xfffffefc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-259 /* 0xfffffefd */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-258 /* 0xfffffefe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-257 /* 0xfffffeff */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-256 /* 0xffffff00 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 8}}			/* shli r3, r2, 8 */
   },
  {-255 /* 0xffffff01 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-254 /* 0xffffff02 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-253 /* 0xffffff03 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-252 /* 0xffffff04 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-251 /* 0xffffff05 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-250 /* 0xffffff06 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-249 /* 0xffffff07 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-248 /* 0xffffff08 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-247 /* 0xffffff09 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-246 /* 0xffffff0a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-245 /* 0xffffff0b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-244 /* 0xffffff0c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-243 /* 0xffffff0d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {-242 /* 0xffffff0e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {3, 1, 3},			/* s1a r4, r1, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-241 /* 0xffffff0f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-240 /* 0xffffff10 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-239 /* 0xffffff11 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-238 /* 0xffffff12 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-237 /* 0xffffff13 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 1}}			/* s1a r5, r4, r1 */
   },
  {-236 /* 0xffffff14 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-235 /* 0xffffff15 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {-234 /* 0xffffff16 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {-233 /* 0xffffff17 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-232 /* 0xffffff18 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {-231 /* 0xffffff19 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {-230 /* 0xffffff1a */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-229 /* 0xffffff1b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-228 /* 0xffffff1c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-227 /* 0xffffff1d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-226 /* 0xffffff1e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-225 /* 0xffffff1f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-224 /* 0xffffff20 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-223 /* 0xffffff21 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-222 /* 0xffffff22 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-221 /* 0xffffff23 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-220 /* 0xffffff24 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-219 /* 0xffffff25 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {-218 /* 0xffffff26 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-217 /* 0xffffff27 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-216 /* 0xffffff28 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {-215 /* 0xffffff29 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-214 /* 0xffffff2a */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 1, 2},			/* s1a r4, r1, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-213 /* 0xffffff2b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 3},			/* shli r4, r3, 3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-212 /* 0xffffff2c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 1, 2},			/* s2a r4, r1, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-211 /* 0xffffff2d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-210 /* 0xffffff2e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {-209 /* 0xffffff2f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-208 /* 0xffffff30 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-207 /* 0xffffff31 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-205 /* 0xffffff33 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-204 /* 0xffffff34 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {-203 /* 0xffffff35 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-202 /* 0xffffff36 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-201 /* 0xffffff37 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-200 /* 0xffffff38 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-199 /* 0xffffff39 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-198 /* 0xffffff3a */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-197 /* 0xffffff3b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-196 /* 0xffffff3c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-195 /* 0xffffff3d */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 4}}			/* s1a r5, r4, r4 */
   },
  {-194 /* 0xffffff3e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-193 /* 0xffffff3f */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-192 /* 0xffffff40 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-191 /* 0xffffff41 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-190 /* 0xffffff42 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-189 /* 0xffffff43 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-188 /* 0xffffff44 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {-187 /* 0xffffff45 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-186 /* 0xffffff46 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-185 /* 0xffffff47 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-184 /* 0xffffff48 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-183 /* 0xffffff49 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-181 /* 0xffffff4b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-180 /* 0xffffff4c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-179 /* 0xffffff4d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-178 /* 0xffffff4e */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-177 /* 0xffffff4f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-176 /* 0xffffff50 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {-175 /* 0xffffff51 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-173 /* 0xffffff53 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-172 /* 0xffffff54 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-171 /* 0xffffff55 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-170 /* 0xffffff56 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-169 /* 0xffffff57 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-168 /* 0xffffff58 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-167 /* 0xffffff59 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-165 /* 0xffffff5b */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 4}}			/* s2a r5, r4, r4 */
   },
  {-164 /* 0xffffff5c */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-163 /* 0xffffff5d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-162 /* 0xffffff5e */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-161 /* 0xffffff5f */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-160 /* 0xffffff60 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {-159 /* 0xffffff61 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-158 /* 0xffffff62 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-157 /* 0xffffff63 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-156 /* 0xffffff64 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-155 /* 0xffffff65 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-154 /* 0xffffff66 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-153 /* 0xffffff67 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {-152 /* 0xffffff68 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 3},			/* shli r3, r1, 3 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-151 /* 0xffffff69 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-150 /* 0xffffff6a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-149 /* 0xffffff6b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-148 /* 0xffffff6c */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {-147 /* 0xffffff6d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-146 /* 0xffffff6e */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-145 /* 0xffffff6f */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-144 /* 0xffffff70 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {-143 /* 0xffffff71 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-142 /* 0xffffff72 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-141 /* 0xffffff73 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-140 /* 0xffffff74 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-139 /* 0xffffff75 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-138 /* 0xffffff76 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-137 /* 0xffffff77 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-136 /* 0xffffff78 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {-135 /* 0xffffff79 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-134 /* 0xffffff7a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-133 /* 0xffffff7b */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-132 /* 0xffffff7c */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-131 /* 0xffffff7d */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-130 /* 0xffffff7e */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-129 /* 0xffffff7f */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-128 /* 0xffffff80 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 7}}			/* shli r3, r2, 7 */
   },
  {-127 /* 0xffffff81 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-126 /* 0xffffff82 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-125 /* 0xffffff83 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-124 /* 0xffffff84 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-123 /* 0xffffff85 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-122 /* 0xffffff86 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-121 /* 0xffffff87 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-120 /* 0xffffff88 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-119 /* 0xffffff89 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-118 /* 0xffffff8a */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-117 /* 0xffffff8b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-116 /* 0xffffff8c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-115 /* 0xffffff8d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-114 /* 0xffffff8e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-113 /* 0xffffff8f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-112 /* 0xffffff90 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-111 /* 0xffffff91 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-110 /* 0xffffff92 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-109 /* 0xffffff93 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-108 /* 0xffffff94 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-107 /* 0xffffff95 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {-106 /* 0xffffff96 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {-105 /* 0xffffff97 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-104 /* 0xffffff98 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {-103 /* 0xffffff99 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {-102 /* 0xffffff9a */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 1, 2},			/* s1a r4, r1, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {-101 /* 0xffffff9b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-100 /* 0xffffff9c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-99 /* 0xffffff9d */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 4}}			/* s1a r5, r4, r4 */
   },
  {-98 /* 0xffffff9e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-97 /* 0xffffff9f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-96 /* 0xffffffa0 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-95 /* 0xffffffa1 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-94 /* 0xffffffa2 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-93 /* 0xffffffa3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-92 /* 0xffffffa4 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {-91 /* 0xffffffa5 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-90 /* 0xffffffa6 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-89 /* 0xffffffa7 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-88 /* 0xffffffa8 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-87 /* 0xffffffa9 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-86 /* 0xffffffaa */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {2, 1, 4}}			/* sub r5, r1, r4 */
   },
  {-85 /* 0xffffffab */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 4}}			/* s2a r5, r4, r4 */
   },
  {-84 /* 0xffffffac */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-83 /* 0xffffffad */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-82 /* 0xffffffae */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {-81 /* 0xffffffaf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 3}}			/* s3a r4, r3, r3 */
   },
  {-80 /* 0xffffffb0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {-79 /* 0xffffffb1 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-78 /* 0xffffffb2 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-77 /* 0xffffffb3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 2, 4}}			/* sub r5, r2, r4 */
   },
  {-76 /* 0xffffffb4 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-75 /* 0xffffffb5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-74 /* 0xffffffb6 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-73 /* 0xffffffb7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {-72 /* 0xffffffb8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 3}}			/* shli r4, r3, 3 */
   },
  {-71 /* 0xffffffb9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-70 /* 0xffffffba */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-69 /* 0xffffffbb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {-68 /* 0xffffffbc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {-67 /* 0xffffffbd */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-66 /* 0xffffffbe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-65 /* 0xffffffbf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-64 /* 0xffffffc0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 6}}			/* shli r3, r2, 6 */
   },
  {-63 /* 0xffffffc1 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-62 /* 0xffffffc2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-61 /* 0xffffffc3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-60 /* 0xffffffc4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-59 /* 0xffffffc5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-58 /* 0xffffffc6 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {-57 /* 0xffffffc7 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-56 /* 0xffffffc8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-55 /* 0xffffffc9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-54 /* 0xffffffca */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-53 /* 0xffffffcb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 3},			/* shli r3, r1, 3 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {-52 /* 0xffffffcc */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {-51 /* 0xffffffcd */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {3, 4, 4}}			/* s1a r5, r4, r4 */
   },
  {-50 /* 0xffffffce */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-49 /* 0xffffffcf */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-48 /* 0xffffffd0 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-47 /* 0xffffffd1 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-46 /* 0xffffffd2 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-45 /* 0xffffffd3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-44 /* 0xffffffd4 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {-43 /* 0xffffffd5 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {-42 /* 0xffffffd6 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-41 /* 0xffffffd7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {-40 /* 0xffffffd8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 3}}			/* shli r4, r3, 3 */
   },
  {-39 /* 0xffffffd9 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-38 /* 0xffffffda */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {-37 /* 0xffffffdb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {-36 /* 0xffffffdc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 2}}			/* shli r4, r3, 2 */
   },
  {-35 /* 0xffffffdd */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-34 /* 0xffffffde */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {-33 /* 0xffffffdf */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-32 /* 0xffffffe0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 5}}			/* shli r3, r2, 5 */
   },
  {-31 /* 0xffffffe1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-30 /* 0xffffffe2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-29 /* 0xffffffe3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-28 /* 0xffffffe4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-27 /* 0xffffffe5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-26 /* 0xffffffe6 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-25 /* 0xffffffe7 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-24 /* 0xffffffe8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-23 /* 0xffffffe9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-22 /* 0xffffffea */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-21 /* 0xffffffeb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-20 /* 0xffffffec */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 2}}			/* shli r4, r3, 2 */
   },
  {-19 /* 0xffffffed */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {2, 1, 3}}			/* sub r4, r1, r3 */
   },
  {-18 /* 0xffffffee */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 1}}			/* shli r4, r3, 1 */
   },
  {-17 /* 0xffffffef */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-16 /* 0xfffffff0 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 4}}			/* shli r3, r2, 4 */
   },
  {-15 /* 0xfffffff1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-14 /* 0xfffffff2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-13 /* 0xfffffff3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-12 /* 0xfffffff4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-11 /* 0xfffffff5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-10 /* 0xfffffff6 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-9 /* 0xfffffff7 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 2, 2}}			/* s3a r3, r2, r2 */
   },
  {-8 /* 0xfffffff8 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 3}}			/* shli r3, r2, 3 */
   },
  {-7 /* 0xfffffff9 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-6 /* 0xfffffffa */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 3},			/* shli r3, r1, 3 */
    {2, 2, 3}}			/* sub r4, r2, r3 */
   },
  {-5 /* 0xfffffffb */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 2, 2}}			/* s2a r3, r2, r2 */
   },
  {-4 /* 0xfffffffc */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 2}}			/* shli r3, r2, 2 */
   },
  {-3 /* 0xfffffffd */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2}}			/* sub r3, r1, r2 */
   },
  {-2 /* 0xfffffffe */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {6, 2, 1}}			/* shli r3, r2, 1 */
   },
  {-1 /* 0xffffffff */ ,
   {{2, 0, 1}}			/* sub r2, zero, r1 */
   },
  {2 /* 0x2 */ ,
   {{6, 1, 1}}			/* shli r2, r1, 1 */
   },
  {3 /* 0x3 */ ,
   {{3, 1, 1}}			/* s1a r2, r1, r1 */
   },
  {4 /* 0x4 */ ,
   {{6, 1, 2}}			/* shli r2, r1, 2 */
   },
  {5 /* 0x5 */ ,
   {{4, 1, 1}}			/* s2a r2, r1, r1 */
   },
  {6 /* 0x6 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 1}}			/* shli r3, r2, 1 */
   },
  {7 /* 0x7 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {8 /* 0x8 */ ,
   {{6, 1, 3}}			/* shli r2, r1, 3 */
   },
  {9 /* 0x9 */ ,
   {{5, 1, 1}}			/* s3a r2, r1, r1 */
   },
  {10 /* 0xa */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 1}}			/* shli r3, r2, 1 */
   },
  {11 /* 0xb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1}}			/* s1a r3, r2, r1 */
   },
  {12 /* 0xc */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 2}}			/* shli r3, r2, 2 */
   },
  {13 /* 0xd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1}}			/* s2a r3, r2, r1 */
   },
  {14 /* 0xe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {15 /* 0xf */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {16 /* 0x10 */ ,
   {{6, 1, 4}}			/* shli r2, r1, 4 */
   },
  {17 /* 0x11 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {18 /* 0x12 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 1}}			/* shli r3, r2, 1 */
   },
  {19 /* 0x13 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1}}			/* s1a r3, r2, r1 */
   },
  {20 /* 0x14 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 2}}			/* shli r3, r2, 2 */
   },
  {21 /* 0x15 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1}}			/* s2a r3, r2, r1 */
   },
  {22 /* 0x16 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {23 /* 0x17 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {24 /* 0x18 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 3}}			/* shli r3, r2, 3 */
   },
  {25 /* 0x19 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1}}			/* s3a r3, r2, r1 */
   },
  {26 /* 0x1a */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {27 /* 0x1b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2}}			/* s3a r3, r2, r2 */
   },
  {28 /* 0x1c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {29 /* 0x1d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {30 /* 0x1e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {31 /* 0x1f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {32 /* 0x20 */ ,
   {{6, 1, 5}}			/* shli r2, r1, 5 */
   },
  {33 /* 0x21 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {34 /* 0x22 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {35 /* 0x23 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36 /* 0x24 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 2}}			/* shli r3, r2, 2 */
   },
  {37 /* 0x25 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 2, 1}}			/* s2a r3, r2, r1 */
   },
  {38 /* 0x26 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {39 /* 0x27 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {40 /* 0x28 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 3}}			/* shli r3, r2, 3 */
   },
  {41 /* 0x29 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1}}			/* s3a r3, r2, r1 */
   },
  {42 /* 0x2a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {43 /* 0x2b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {44 /* 0x2c */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {45 /* 0x2d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2}}			/* s3a r3, r2, r2 */
   },
  {46 /* 0x2e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {47 /* 0x2f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {48 /* 0x30 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 4}}			/* shli r3, r2, 4 */
   },
  {49 /* 0x31 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {50 /* 0x32 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {51 /* 0x33 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {52 /* 0x34 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {53 /* 0x35 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {54 /* 0x36 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 1}}			/* shli r4, r3, 1 */
   },
  {55 /* 0x37 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {56 /* 0x38 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {57 /* 0x39 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {58 /* 0x3a */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {59 /* 0x3b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {60 /* 0x3c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {61 /* 0x3d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {62 /* 0x3e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {63 /* 0x3f */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {64 /* 0x40 */ ,
   {{6, 1, 6}}			/* shli r2, r1, 6 */
   },
  {65 /* 0x41 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {66 /* 0x42 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {67 /* 0x43 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68 /* 0x44 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {69 /* 0x45 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {70 /* 0x46 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {71 /* 0x47 */ ,
   {{2, 0, 1},			/* sub r2, zero, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {72 /* 0x48 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 3}}			/* shli r3, r2, 3 */
   },
  {73 /* 0x49 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 1}}			/* s3a r3, r2, r1 */
   },
  {74 /* 0x4a */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {75 /* 0x4b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {76 /* 0x4c */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {77 /* 0x4d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {78 /* 0x4e */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {79 /* 0x4f */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {80 /* 0x50 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 4}}			/* shli r3, r2, 4 */
   },
  {81 /* 0x51 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2}}			/* s3a r3, r2, r2 */
   },
  {82 /* 0x52 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {83 /* 0x53 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 1}}			/* s1a r4, r3, r1 */
   },
  {84 /* 0x54 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {85 /* 0x55 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {86 /* 0x56 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {87 /* 0x57 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {88 /* 0x58 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {89 /* 0x59 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {90 /* 0x5a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 1}}			/* shli r4, r3, 1 */
   },
  {91 /* 0x5b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {3, 3, 1}}			/* s1a r4, r3, r1 */
   },
  {92 /* 0x5c */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {93 /* 0x5d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {94 /* 0x5e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {95 /* 0x5f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {96 /* 0x60 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5}}			/* shli r3, r2, 5 */
   },
  {97 /* 0x61 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {98 /* 0x62 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {99 /* 0x63 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {100 /* 0x64 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {101 /* 0x65 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {4, 3, 1}}			/* s2a r4, r3, r1 */
   },
  {102 /* 0x66 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {103 /* 0x67 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {104 /* 0x68 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {105 /* 0x69 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {106 /* 0x6a */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 1, 1},			/* shli r4, r1, 1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {107 /* 0x6b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {108 /* 0x6c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 2}}			/* shli r4, r3, 2 */
   },
  {109 /* 0x6d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {4, 3, 1}}			/* s2a r4, r3, r1 */
   },
  {110 /* 0x6e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {111 /* 0x6f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {112 /* 0x70 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {113 /* 0x71 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {114 /* 0x72 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {115 /* 0x73 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {116 /* 0x74 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {117 /* 0x75 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 3}}			/* s3a r4, r3, r3 */
   },
  {118 /* 0x76 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {119 /* 0x77 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {120 /* 0x78 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {121 /* 0x79 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {122 /* 0x7a */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {123 /* 0x7b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {124 /* 0x7c */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {125 /* 0x7d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {126 /* 0x7e */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {127 /* 0x7f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {128 /* 0x80 */ ,
   {{6, 1, 7}}			/* shli r2, r1, 7 */
   },
  {129 /* 0x81 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {130 /* 0x82 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {131 /* 0x83 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {132 /* 0x84 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {133 /* 0x85 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134 /* 0x86 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {135 /* 0x87 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {136 /* 0x88 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {137 /* 0x89 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {138 /* 0x8a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {139 /* 0x8b */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {140 /* 0x8c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {141 /* 0x8d */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {142 /* 0x8e */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {143 /* 0x8f */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {144 /* 0x90 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 4}}			/* shli r3, r2, 4 */
   },
  {145 /* 0x91 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {146 /* 0x92 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {147 /* 0x93 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 1}}			/* s1a r4, r3, r1 */
   },
  {148 /* 0x94 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {149 /* 0x95 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {4, 3, 1}}			/* s2a r4, r3, r1 */
   },
  {150 /* 0x96 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {151 /* 0x97 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {152 /* 0x98 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {153 /* 0x99 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {154 /* 0x9a */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {155 /* 0x9b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {156 /* 0x9c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {157 /* 0x9d */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {158 /* 0x9e */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {159 /* 0x9f */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {160 /* 0xa0 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 5}}			/* shli r3, r2, 5 */
   },
  {161 /* 0xa1 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {162 /* 0xa2 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 1}}			/* shli r4, r3, 1 */
   },
  {163 /* 0xa3 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {3, 3, 1}}			/* s1a r4, r3, r1 */
   },
  {164 /* 0xa4 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {165 /* 0xa5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {166 /* 0xa6 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {167 /* 0xa7 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {168 /* 0xa8 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {169 /* 0xa9 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {170 /* 0xaa */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {171 /* 0xab */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {5, 3, 3}}			/* s3a r4, r3, r3 */
   },
  {172 /* 0xac */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {173 /* 0xad */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {174 /* 0xae */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {175 /* 0xaf */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 4}}			/* s2a r5, r4, r4 */
   },
  {176 /* 0xb0 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {177 /* 0xb1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {178 /* 0xb2 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {179 /* 0xb3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {180 /* 0xb4 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 2}}			/* shli r4, r3, 2 */
   },
  {181 /* 0xb5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {4, 3, 1}}			/* s2a r4, r3, r1 */
   },
  {182 /* 0xb6 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 1, 1},			/* shli r4, r1, 1 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {183 /* 0xb7 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {184 /* 0xb8 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {185 /* 0xb9 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {186 /* 0xba */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {187 /* 0xbb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {188 /* 0xbc */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {189 /* 0xbd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {190 /* 0xbe */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {191 /* 0xbf */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {192 /* 0xc0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6}}			/* shli r3, r2, 6 */
   },
  {193 /* 0xc1 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {194 /* 0xc2 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {195 /* 0xc3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {196 /* 0xc4 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {197 /* 0xc5 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {198 /* 0xc6 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {199 /* 0xc7 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {200 /* 0xc8 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {201 /* 0xc9 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {202 /* 0xca */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 1, 1},			/* shli r4, r1, 1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {203 /* 0xcb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {204 /* 0xcc */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {205 /* 0xcd */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {206 /* 0xce */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {207 /* 0xcf */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {208 /* 0xd0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {209 /* 0xd1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {210 /* 0xd2 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {211 /* 0xd3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {212 /* 0xd4 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {213 /* 0xd5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {214 /* 0xd6 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {215 /* 0xd7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {216 /* 0xd8 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 3}}			/* shli r4, r3, 3 */
   },
  {217 /* 0xd9 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {218 /* 0xda */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 1, 1},			/* shli r4, r1, 1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {219 /* 0xdb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {220 /* 0xdc */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {221 /* 0xdd */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {222 /* 0xde */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {223 /* 0xdf */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {224 /* 0xe0 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {225 /* 0xe1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {226 /* 0xe2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {227 /* 0xe3 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {228 /* 0xe4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {229 /* 0xe5 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 2, 1},			/* s1a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {230 /* 0xe6 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {231 /* 0xe7 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 1, 8},			/* shli r4, r1, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {232 /* 0xe8 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {233 /* 0xe9 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {234 /* 0xea */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {235 /* 0xeb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {236 /* 0xec */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {237 /* 0xed */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {238 /* 0xee */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {239 /* 0xef */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {240 /* 0xf0 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {241 /* 0xf1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {242 /* 0xf2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {243 /* 0xf3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 3}}			/* s3a r4, r3, r3 */
   },
  {244 /* 0xf4 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {245 /* 0xf5 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {246 /* 0xf6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {247 /* 0xf7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {248 /* 0xf8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {249 /* 0xf9 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {250 /* 0xfa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {251 /* 0xfb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {252 /* 0xfc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {253 /* 0xfd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {254 /* 0xfe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {255 /* 0xff */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {256 /* 0x100 */ ,
   {{6, 1, 8}}			/* shli r2, r1, 8 */
   },
  {257 /* 0x101 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {258 /* 0x102 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {259 /* 0x103 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {260 /* 0x104 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {261 /* 0x105 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262 /* 0x106 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {263 /* 0x107 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {264 /* 0x108 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {265 /* 0x109 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {266 /* 0x10a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {267 /* 0x10b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {1, 1, 3},			/* add r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {268 /* 0x10c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {269 /* 0x10d */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {270 /* 0x10e */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {271 /* 0x10f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {272 /* 0x110 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {273 /* 0x111 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {274 /* 0x112 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {275 /* 0x113 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {276 /* 0x114 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {277 /* 0x115 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {278 /* 0x116 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {279 /* 0x117 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {280 /* 0x118 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {281 /* 0x119 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 1},			/* s1a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {282 /* 0x11a */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 2, 1},			/* s1a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {283 /* 0x11b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {284 /* 0x11c */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {285 /* 0x11d */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {286 /* 0x11e */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {287 /* 0x11f */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {288 /* 0x120 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5}}			/* shli r3, r2, 5 */
   },
  {289 /* 0x121 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {290 /* 0x122 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {291 /* 0x123 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {292 /* 0x124 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {293 /* 0x125 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {4, 3, 1}}			/* s2a r4, r3, r1 */
   },
  {294 /* 0x126 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {295 /* 0x127 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {296 /* 0x128 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {297 /* 0x129 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {298 /* 0x12a */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {299 /* 0x12b */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {300 /* 0x12c */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {301 /* 0x12d */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {302 /* 0x12e */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {303 /* 0x12f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {304 /* 0x130 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {305 /* 0x131 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {306 /* 0x132 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {307 /* 0x133 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {308 /* 0x134 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {309 /* 0x135 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {310 /* 0x136 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {311 /* 0x137 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {312 /* 0x138 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {313 /* 0x139 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {314 /* 0x13a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {315 /* 0x13b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {316 /* 0x13c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {317 /* 0x13d */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {318 /* 0x13e */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {319 /* 0x13f */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {320 /* 0x140 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6}}			/* shli r3, r2, 6 */
   },
  {321 /* 0x141 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {322 /* 0x142 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {323 /* 0x143 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {324 /* 0x144 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {325 /* 0x145 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {326 /* 0x146 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {327 /* 0x147 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {328 /* 0x148 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {329 /* 0x149 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {330 /* 0x14a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {331 /* 0x14b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {332 /* 0x14c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {333 /* 0x14d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {334 /* 0x14e */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {335 /* 0x14f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 4}}			/* s2a r5, r4, r4 */
   },
  {336 /* 0x150 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {337 /* 0x151 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {338 /* 0x152 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {339 /* 0x153 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {340 /* 0x154 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {341 /* 0x155 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {342 /* 0x156 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {343 /* 0x157 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {344 /* 0x158 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {345 /* 0x159 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {346 /* 0x15a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {347 /* 0x15b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {348 /* 0x15c */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 2},			/* shli r4, r2, 2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {349 /* 0x15d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {350 /* 0x15e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {351 /* 0x15f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {352 /* 0x160 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {353 /* 0x161 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {354 /* 0x162 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {355 /* 0x163 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {356 /* 0x164 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {357 /* 0x165 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {358 /* 0x166 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {359 /* 0x167 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {360 /* 0x168 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 3}}			/* shli r4, r3, 3 */
   },
  {361 /* 0x169 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {362 /* 0x16a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 1, 1},			/* shli r4, r1, 1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {363 /* 0x16b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {364 /* 0x16c */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 1, 2},			/* shli r4, r1, 2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {365 /* 0x16d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {366 /* 0x16e */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {367 /* 0x16f */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {368 /* 0x170 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {369 /* 0x171 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 3}}			/* s3a r4, r3, r3 */
   },
  {370 /* 0x172 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {371 /* 0x173 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {372 /* 0x174 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {373 /* 0x175 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {374 /* 0x176 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {375 /* 0x177 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {376 /* 0x178 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {377 /* 0x179 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {378 /* 0x17a */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {379 /* 0x17b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {380 /* 0x17c */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {381 /* 0x17d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {382 /* 0x17e */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {383 /* 0x17f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {384 /* 0x180 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 7}}			/* shli r3, r2, 7 */
   },
  {385 /* 0x181 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {386 /* 0x182 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {387 /* 0x183 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {388 /* 0x184 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {389 /* 0x185 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {390 /* 0x186 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {391 /* 0x187 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {392 /* 0x188 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {393 /* 0x189 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {394 /* 0x18a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {395 /* 0x18b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {396 /* 0x18c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {397 /* 0x18d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {398 /* 0x18e */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {399 /* 0x18f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {400 /* 0x190 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {401 /* 0x191 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {402 /* 0x192 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {403 /* 0x193 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {404 /* 0x194 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {4, 1, 2},			/* s2a r4, r1, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {405 /* 0x195 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 3}}			/* s3a r4, r3, r3 */
   },
  {406 /* 0x196 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {407 /* 0x197 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {408 /* 0x198 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {409 /* 0x199 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {410 /* 0x19a */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {411 /* 0x19b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {412 /* 0x19c */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {413 /* 0x19d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {414 /* 0x19e */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {415 /* 0x19f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {416 /* 0x1a0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {417 /* 0x1a1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {418 /* 0x1a2 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {419 /* 0x1a3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {420 /* 0x1a4 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {421 /* 0x1a5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {422 /* 0x1a6 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {423 /* 0x1a7 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {424 /* 0x1a8 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {425 /* 0x1a9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {426 /* 0x1aa */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {427 /* 0x1ab */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {428 /* 0x1ac */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {429 /* 0x1ad */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {430 /* 0x1ae */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {431 /* 0x1af */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {432 /* 0x1b0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {433 /* 0x1b1 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {434 /* 0x1b2 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {435 /* 0x1b3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {436 /* 0x1b4 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {437 /* 0x1b5 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {438 /* 0x1b6 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {439 /* 0x1b7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {440 /* 0x1b8 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {441 /* 0x1b9 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {442 /* 0x1ba */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {443 /* 0x1bb */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {444 /* 0x1bc */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {445 /* 0x1bd */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {446 /* 0x1be */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {447 /* 0x1bf */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {448 /* 0x1c0 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {449 /* 0x1c1 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {450 /* 0x1c2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {451 /* 0x1c3 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {452 /* 0x1c4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {453 /* 0x1c5 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 2, 1},			/* s1a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {454 /* 0x1c6 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {455 /* 0x1c7 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {456 /* 0x1c8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {457 /* 0x1c9 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {458 /* 0x1ca */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {459 /* 0x1cb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {460 /* 0x1cc */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {461 /* 0x1cd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {462 /* 0x1ce */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {463 /* 0x1cf */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {464 /* 0x1d0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {465 /* 0x1d1 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 1, 2},			/* s1a r4, r1, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {467 /* 0x1d3 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {468 /* 0x1d4 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {469 /* 0x1d5 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {470 /* 0x1d6 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {471 /* 0x1d7 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {472 /* 0x1d8 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {473 /* 0x1d9 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {475 /* 0x1db */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {476 /* 0x1dc */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {477 /* 0x1dd */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {478 /* 0x1de */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {479 /* 0x1df */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {480 /* 0x1e0 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {481 /* 0x1e1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {482 /* 0x1e2 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {483 /* 0x1e3 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {484 /* 0x1e4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {485 /* 0x1e5 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {486 /* 0x1e6 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {487 /* 0x1e7 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {488 /* 0x1e8 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {489 /* 0x1e9 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 2, 1},			/* s1a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {490 /* 0x1ea */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {491 /* 0x1eb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {492 /* 0x1ec */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {493 /* 0x1ed */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {494 /* 0x1ee */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {495 /* 0x1ef */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {496 /* 0x1f0 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {497 /* 0x1f1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {498 /* 0x1f2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {499 /* 0x1f3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 1, 9},			/* shli r4, r1, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {500 /* 0x1f4 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {501 /* 0x1f5 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {502 /* 0x1f6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {503 /* 0x1f7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {504 /* 0x1f8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {505 /* 0x1f9 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {506 /* 0x1fa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {507 /* 0x1fb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {508 /* 0x1fc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {509 /* 0x1fd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {510 /* 0x1fe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {511 /* 0x1ff */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {512 /* 0x200 */ ,
   {{6, 1, 9}}			/* shli r2, r1, 9 */
   },
  {513 /* 0x201 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {514 /* 0x202 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {515 /* 0x203 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {516 /* 0x204 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {517 /* 0x205 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {518 /* 0x206 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {519 /* 0x207 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {520 /* 0x208 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {521 /* 0x209 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {522 /* 0x20a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {523 /* 0x20b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 1, 3},			/* add r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {524 /* 0x20c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {525 /* 0x20d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {526 /* 0x20e */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {527 /* 0x20f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {528 /* 0x210 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {529 /* 0x211 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {530 /* 0x212 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {531 /* 0x213 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {532 /* 0x214 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {533 /* 0x215 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {534 /* 0x216 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {535 /* 0x217 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {536 /* 0x218 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {537 /* 0x219 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {538 /* 0x21a */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {539 /* 0x21b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {540 /* 0x21c */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {541 /* 0x21d */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {542 /* 0x21e */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {543 /* 0x21f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {544 /* 0x220 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {545 /* 0x221 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {546 /* 0x222 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {547 /* 0x223 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {548 /* 0x224 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {549 /* 0x225 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {550 /* 0x226 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {551 /* 0x227 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 1},			/* s1a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {552 /* 0x228 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {553 /* 0x229 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 1},			/* s1a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {554 /* 0x22a */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 2, 1},			/* s1a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {555 /* 0x22b */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {556 /* 0x22c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {557 /* 0x22d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {558 /* 0x22e */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {559 /* 0x22f */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {560 /* 0x230 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {561 /* 0x231 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {562 /* 0x232 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {563 /* 0x233 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {564 /* 0x234 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {565 /* 0x235 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {566 /* 0x236 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {567 /* 0x237 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {568 /* 0x238 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {569 /* 0x239 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {570 /* 0x23a */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 1, 2},			/* s1a r4, r1, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {571 /* 0x23b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {572 /* 0x23c */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {573 /* 0x23d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {574 /* 0x23e */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {575 /* 0x23f */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {576 /* 0x240 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6}}			/* shli r3, r2, 6 */
   },
  {577 /* 0x241 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {578 /* 0x242 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {579 /* 0x243 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {580 /* 0x244 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {581 /* 0x245 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 1},			/* s1a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {582 /* 0x246 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {583 /* 0x247 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {584 /* 0x248 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {585 /* 0x249 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {586 /* 0x24a */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {587 /* 0x24b */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {588 /* 0x24c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {589 /* 0x24d */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {590 /* 0x24e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {591 /* 0x24f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {592 /* 0x250 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {593 /* 0x251 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {594 /* 0x252 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {595 /* 0x253 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {596 /* 0x254 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {597 /* 0x255 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {598 /* 0x256 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {599 /* 0x257 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {600 /* 0x258 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {601 /* 0x259 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {602 /* 0x25a */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {603 /* 0x25b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {604 /* 0x25c */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {605 /* 0x25d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {606 /* 0x25e */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {607 /* 0x25f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {608 /* 0x260 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {609 /* 0x261 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {610 /* 0x262 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {611 /* 0x263 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {612 /* 0x264 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {613 /* 0x265 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {614 /* 0x266 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {615 /* 0x267 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {616 /* 0x268 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {617 /* 0x269 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 2},			/* shli r3, r1, 2 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {619 /* 0x26b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {620 /* 0x26c */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {621 /* 0x26d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {623 /* 0x26f */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {624 /* 0x270 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {625 /* 0x271 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {626 /* 0x272 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {627 /* 0x273 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {628 /* 0x274 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {629 /* 0x275 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {630 /* 0x276 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {631 /* 0x277 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {632 /* 0x278 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {633 /* 0x279 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {634 /* 0x27a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {635 /* 0x27b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {636 /* 0x27c */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {637 /* 0x27d */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {638 /* 0x27e */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 1},			/* shli r3, r1, 1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {639 /* 0x27f */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {640 /* 0x280 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7}}			/* shli r3, r2, 7 */
   },
  {641 /* 0x281 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {642 /* 0x282 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {643 /* 0x283 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {644 /* 0x284 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {645 /* 0x285 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {646 /* 0x286 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {647 /* 0x287 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {648 /* 0x288 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 3}}			/* shli r4, r3, 3 */
   },
  {649 /* 0x289 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {650 /* 0x28a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {651 /* 0x28b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {652 /* 0x28c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {653 /* 0x28d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {654 /* 0x28e */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {655 /* 0x28f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 4}}			/* s2a r5, r4, r4 */
   },
  {656 /* 0x290 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {657 /* 0x291 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 3}}			/* s3a r4, r3, r3 */
   },
  {658 /* 0x292 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {659 /* 0x293 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {660 /* 0x294 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {661 /* 0x295 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {662 /* 0x296 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {663 /* 0x297 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {664 /* 0x298 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {665 /* 0x299 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {666 /* 0x29a */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 1},			/* shli r4, r2, 1 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {667 /* 0x29b */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {668 /* 0x29c */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {669 /* 0x29d */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 1},			/* s1a r4, r3, r1 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {670 /* 0x29e */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {4, 4, 4}}			/* s2a r5, r4, r4 */
   },
  {671 /* 0x29f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {672 /* 0x2a0 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {673 /* 0x2a1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {674 /* 0x2a2 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {675 /* 0x2a3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {676 /* 0x2a4 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {677 /* 0x2a5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {679 /* 0x2a7 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {5, 2, 4}}			/* s3a r5, r2, r4 */
   },
  {680 /* 0x2a8 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {681 /* 0x2a9 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {682 /* 0x2aa */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {684 /* 0x2ac */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 2},			/* shli r4, r2, 2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {685 /* 0x2ad */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {688 /* 0x2b0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 1, 1},			/* s2a r3, r1, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {689 /* 0x2b1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {690 /* 0x2b2 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {692 /* 0x2b4 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {693 /* 0x2b5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 1},			/* s3a r3, r1, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {694 /* 0x2b6 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 3, 3},			/* s2a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {695 /* 0x2b7 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {696 /* 0x2b8 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {697 /* 0x2b9 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {699 /* 0x2bb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {700 /* 0x2bc */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {4, 4, 4}}			/* s2a r5, r4, r4 */
   },
  {701 /* 0x2bd */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {702 /* 0x2be */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {703 /* 0x2bf */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {704 /* 0x2c0 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 6}}			/* shli r4, r3, 6 */
   },
  {705 /* 0x2c1 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {706 /* 0x2c2 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {707 /* 0x2c3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {708 /* 0x2c4 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {709 /* 0x2c5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {710 /* 0x2c6 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {711 /* 0x2c7 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {712 /* 0x2c8 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {713 /* 0x2c9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 4},			/* shli r3, r1, 4 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {714 /* 0x2ca */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 3, 3},			/* s2a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {715 /* 0x2cb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {716 /* 0x2cc */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {717 /* 0x2cd */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {719 /* 0x2cf */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {2, 4, 1}}			/* sub r5, r4, r1 */
   },
  {720 /* 0x2d0 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 4}}			/* shli r4, r3, 4 */
   },
  {721 /* 0x2d1 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {722 /* 0x2d2 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {723 /* 0x2d3 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {724 /* 0x2d4 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {725 /* 0x2d5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 4},			/* shli r4, r3, 4 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {726 /* 0x2d6 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {727 /* 0x2d7 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {728 /* 0x2d8 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {729 /* 0x2d9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 3}}			/* s3a r4, r3, r3 */
   },
  {730 /* 0x2da */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {731 /* 0x2db */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {3, 4, 1}}			/* s1a r5, r4, r1 */
   },
  {733 /* 0x2dd */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {735 /* 0x2df */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {736 /* 0x2e0 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {737 /* 0x2e1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {738 /* 0x2e2 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {739 /* 0x2e3 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {740 /* 0x2e4 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {741 /* 0x2e5 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {743 /* 0x2e7 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {744 /* 0x2e8 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {745 /* 0x2e9 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {747 /* 0x2eb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {748 /* 0x2ec */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {749 /* 0x2ed */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {750 /* 0x2ee */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {752 /* 0x2f0 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {753 /* 0x2f1 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {755 /* 0x2f3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {756 /* 0x2f4 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 2},			/* shli r3, r2, 2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {757 /* 0x2f5 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {758 /* 0x2f6 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {759 /* 0x2f7 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {760 /* 0x2f8 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {761 /* 0x2f9 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {762 /* 0x2fa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 1},			/* shli r3, r2, 1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {763 /* 0x2fb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {764 /* 0x2fc */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {765 /* 0x2fd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {766 /* 0x2fe */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {767 /* 0x2ff */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {768 /* 0x300 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8}}			/* shli r3, r2, 8 */
   },
  {769 /* 0x301 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {770 /* 0x302 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {771 /* 0x303 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {772 /* 0x304 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {773 /* 0x305 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {774 /* 0x306 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {775 /* 0x307 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {776 /* 0x308 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {777 /* 0x309 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {778 /* 0x30a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {779 /* 0x30b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {780 /* 0x30c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {781 /* 0x30d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {782 /* 0x30e */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {783 /* 0x30f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {784 /* 0x310 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {3, 3, 2}}			/* s1a r4, r3, r2 */
   },
  {785 /* 0x311 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 1, 2},			/* s3a r4, r1, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {786 /* 0x312 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {787 /* 0x313 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {3, 1, 3},			/* s1a r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {788 /* 0x314 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {789 /* 0x315 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 2, 4}}			/* s3a r5, r2, r4 */
   },
  {790 /* 0x316 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {791 /* 0x317 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {792 /* 0x318 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {793 /* 0x319 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {794 /* 0x31a */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {795 /* 0x31b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {796 /* 0x31c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {797 /* 0x31d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {798 /* 0x31e */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {799 /* 0x31f */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {800 /* 0x320 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {801 /* 0x321 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {802 /* 0x322 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {803 /* 0x323 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {804 /* 0x324 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {4, 1, 2},			/* s2a r4, r1, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {805 /* 0x325 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {806 /* 0x326 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {807 /* 0x327 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {808 /* 0x328 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {809 /* 0x329 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {810 /* 0x32a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {811 /* 0x32b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {812 /* 0x32c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {813 /* 0x32d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {815 /* 0x32f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {816 /* 0x330 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {817 /* 0x331 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {818 /* 0x332 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {819 /* 0x333 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {820 /* 0x334 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {821 /* 0x335 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {822 /* 0x336 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {823 /* 0x337 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {824 /* 0x338 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {825 /* 0x339 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {827 /* 0x33b */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {828 /* 0x33c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {829 /* 0x33d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {831 /* 0x33f */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {832 /* 0x340 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 6}}			/* shli r4, r3, 6 */
   },
  {833 /* 0x341 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {834 /* 0x342 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 2, 2},			/* s1a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {835 /* 0x343 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {836 /* 0x344 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 2},			/* s3a r4, r2, r2 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {837 /* 0x345 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {838 /* 0x346 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {840 /* 0x348 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {841 /* 0x349 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {842 /* 0x34a */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {843 /* 0x34b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {844 /* 0x34c */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {845 /* 0x34d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {846 /* 0x34e */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {848 /* 0x350 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {849 /* 0x351 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {850 /* 0x352 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {852 /* 0x354 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {853 /* 0x355 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {855 /* 0x357 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {856 /* 0x358 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {857 /* 0x359 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {858 /* 0x35a */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {859 /* 0x35b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {861 /* 0x35d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {862 /* 0x35e */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {863 /* 0x35f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 4, 1}}			/* sub r5, r4, r1 */
   },
  {864 /* 0x360 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {865 /* 0x361 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 1, 4}}			/* add r5, r1, r4 */
   },
  {866 /* 0x362 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 1, 3},			/* add r4, r1, r3 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {867 /* 0x363 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 2, 4}}			/* add r5, r2, r4 */
   },
  {868 /* 0x364 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {869 /* 0x365 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {870 /* 0x366 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {871 /* 0x367 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {872 /* 0x368 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {873 /* 0x369 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 1, 3},			/* add r4, r1, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {875 /* 0x36b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {876 /* 0x36c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {877 /* 0x36d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {879 /* 0x36f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {880 /* 0x370 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {881 /* 0x371 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 2},			/* s1a r3, r2, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {882 /* 0x372 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {884 /* 0x374 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {885 /* 0x375 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {888 /* 0x378 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {889 /* 0x379 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {2, 2, 1},			/* sub r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {890 /* 0x37a */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {891 /* 0x37b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {892 /* 0x37c */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {893 /* 0x37d */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {894 /* 0x37e */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {895 /* 0x37f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {896 /* 0x380 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {897 /* 0x381 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {898 /* 0x382 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {899 /* 0x383 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {900 /* 0x384 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {901 /* 0x385 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 2, 1},			/* s1a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {902 /* 0x386 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {903 /* 0x387 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {904 /* 0x388 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {905 /* 0x389 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {2, 1, 2},			/* sub r4, r1, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {906 /* 0x38a */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {908 /* 0x38c */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {909 /* 0x38d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {910 /* 0x38e */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {911 /* 0x38f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {912 /* 0x390 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {913 /* 0x391 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 1, 2},			/* s1a r4, r1, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {915 /* 0x393 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {916 /* 0x394 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {917 /* 0x395 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {918 /* 0x396 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {919 /* 0x397 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {920 /* 0x398 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {924 /* 0x39c */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {925 /* 0x39d */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {2, 1, 3},			/* sub r4, r1, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {927 /* 0x39f */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {928 /* 0x3a0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {929 /* 0x3a1 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 1, 2},			/* s2a r4, r1, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {932 /* 0x3a4 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {935 /* 0x3a7 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {936 /* 0x3a8 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {937 /* 0x3a9 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {939 /* 0x3ab */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {941 /* 0x3ad */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {943 /* 0x3af */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {944 /* 0x3b0 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {945 /* 0x3b1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 3, 4}}			/* sub r5, r3, r4 */
   },
  {948 /* 0x3b4 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {949 /* 0x3b5 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {950 /* 0x3b6 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {951 /* 0x3b7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {952 /* 0x3b8 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {953 /* 0x3b9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {955 /* 0x3bb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {4, 4, 4}}			/* s2a r5, r4, r4 */
   },
  {956 /* 0x3bc */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {957 /* 0x3bd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {958 /* 0x3be */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {959 /* 0x3bf */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {960 /* 0x3c0 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {961 /* 0x3c1 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {962 /* 0x3c2 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {963 /* 0x3c3 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {964 /* 0x3c4 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {965 /* 0x3c5 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {966 /* 0x3c6 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {967 /* 0x3c7 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {968 /* 0x3c8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {969 /* 0x3c9 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {3, 2, 1},			/* s1a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {970 /* 0x3ca */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {971 /* 0x3cb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {972 /* 0x3cc */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {973 /* 0x3cd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {975 /* 0x3cf */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {6, 3, 6},			/* shli r4, r3, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {976 /* 0x3d0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {979 /* 0x3d3 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {980 /* 0x3d4 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {981 /* 0x3d5 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {983 /* 0x3d7 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {984 /* 0x3d8 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {985 /* 0x3d9 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {987 /* 0x3db */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {988 /* 0x3dc */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {989 /* 0x3dd */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {990 /* 0x3de */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {991 /* 0x3df */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {992 /* 0x3e0 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {993 /* 0x3e1 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {994 /* 0x3e2 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {996 /* 0x3e4 */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {997 /* 0x3e5 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {999 /* 0x3e7 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1000 /* 0x3e8 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {1001 /* 0x3e9 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {4, 2, 1},			/* s2a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {1003 /* 0x3eb */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {1004 /* 0x3ec */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {1005 /* 0x3ed */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {1006 /* 0x3ee */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1007 /* 0x3ef */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1008 /* 0x3f0 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1009 /* 0x3f1 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {1010 /* 0x3f2 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {1011 /* 0x3f3 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 1, 10},			/* shli r4, r1, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1012 /* 0x3f4 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 2}}			/* shli r5, r4, 2 */
   },
  {1013 /* 0x3f5 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {1014 /* 0x3f6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1015 /* 0x3f7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1016 /* 0x3f8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1017 /* 0x3f9 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {1018 /* 0x3fa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {1019 /* 0x3fb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1020 /* 0x3fc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1021 /* 0x3fd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1022 /* 0x3fe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1023 /* 0x3ff */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {1024 /* 0x400 */ ,
   {{6, 1, 10}}			/* shli r2, r1, 10 */
   },
  {1025 /* 0x401 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {1026 /* 0x402 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {1027 /* 0x403 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1028 /* 0x404 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {1029 /* 0x405 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1030 /* 0x406 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {1031 /* 0x407 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {1032 /* 0x408 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {1033 /* 0x409 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1034 /* 0x40a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {1040 /* 0x410 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1049 /* 0x419 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {1056 /* 0x420 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1059 /* 0x423 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 2, 1},			/* s3a r4, r2, r1 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {1088 /* 0x440 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1100 /* 0x44c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {1104 /* 0x450 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {1108 /* 0x454 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {1136 /* 0x470 */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {1152 /* 0x480 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 7}}			/* shli r3, r2, 7 */
   },
  {1200 /* 0x4b0 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1204 /* 0x4b4 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {1242 /* 0x4da */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {1280 /* 0x500 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 8}}			/* shli r3, r2, 8 */
   },
  {1292 /* 0x50c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {1304 /* 0x518 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {1312 /* 0x520 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {1320 /* 0x528 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {1336 /* 0x538 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {1344 /* 0x540 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 6}}			/* shli r4, r3, 6 */
   },
  {1348 /* 0x544 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {1360 /* 0x550 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {1364 /* 0x554 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {1395 /* 0x573 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5},			/* shli r4, r3, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1448 /* 0x5a8 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {1460 /* 0x5b4 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {1461 /* 0x5b5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {1472 /* 0x5c0 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 5},			/* shli r3, r1, 5 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 6}}			/* shli r5, r4, 6 */
   },
  {1488 /* 0x5d0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1512 /* 0x5e8 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 3},			/* shli r3, r2, 3 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1536 /* 0x600 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 9}}			/* shli r3, r2, 9 */
   },
  {1568 /* 0x620 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {1576 /* 0x628 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {1649 /* 0x671 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {1664 /* 0x680 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 7}}			/* shli r4, r3, 7 */
   },
  {1684 /* 0x694 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {3, 2, 3},			/* s1a r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {1696 /* 0x6a0 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {4, 2, 2},			/* s2a r4, r2, r2 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {1744 /* 0x6d0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {1812 /* 0x714 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {2000 /* 0x7d0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {2012 /* 0x7dc */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2014 /* 0x7de */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2037 /* 0x7f5 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {4, 4, 1}}			/* s2a r5, r4, r1 */
   },
  {2038 /* 0x7f6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2039 /* 0x7f7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2040 /* 0x7f8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2041 /* 0x7f9 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {2042 /* 0x7fa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {2043 /* 0x7fb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2044 /* 0x7fc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2045 /* 0x7fd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2046 /* 0x7fe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2047 /* 0x7ff */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {2048 /* 0x800 */ ,
   {{6, 1, 11}}			/* shli r2, r1, 11 */
   },
  {2049 /* 0x801 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {2050 /* 0x802 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {2051 /* 0x803 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2052 /* 0x804 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {2053 /* 0x805 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2054 /* 0x806 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {2055 /* 0x807 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {2056 /* 0x808 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {2057 /* 0x809 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2058 /* 0x80a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {2064 /* 0x810 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2080 /* 0x820 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2100 /* 0x834 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 1, 11},			/* shli r4, r1, 11 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {2112 /* 0x840 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2144 /* 0x860 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {2176 /* 0x880 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2184 /* 0x888 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {2304 /* 0x900 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 8}}			/* shli r3, r2, 8 */
   },
  {2320 /* 0x910 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {5, 3, 2}}			/* s3a r4, r3, r2 */
   },
  {2408 /* 0x968 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {2560 /* 0xa00 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 9}}			/* shli r3, r2, 9 */
   },
  {2578 /* 0xa12 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {2592 /* 0xa20 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 5}}			/* shli r4, r3, 5 */
   },
  {2633 /* 0xa49 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {2704 /* 0xa90 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {2730 /* 0xaaa */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 5},			/* shli r3, r2, 5 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {2880 /* 0xb40 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 6}}			/* shli r4, r3, 6 */
   },
  {2896 /* 0xb50 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {3072 /* 0xc00 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 10}}			/* shli r3, r2, 10 */
   },
  {3079 /* 0xc07 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 2, 10},			/* shli r4, r2, 10 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {3112 /* 0xc28 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 10},			/* shli r4, r2, 10 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {3192 /* 0xc78 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 2},			/* s2a r3, r2, r2 */
    {6, 2, 10},			/* shli r4, r2, 10 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {3240 /* 0xca8 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {6, 4, 3}}			/* shli r5, r4, 3 */
   },
  {3264 /* 0xcc0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {6, 2, 10},			/* shli r4, r2, 10 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {3328 /* 0xd00 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 8}}			/* shli r4, r3, 8 */
   },
  {3453 /* 0xd7d */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {3529 /* 0xdc9 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3},			/* s3a r4, r2, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {3580 /* 0xdfc */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {3600 /* 0xe10 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 2, 3},			/* sub r4, r2, r3 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {3624 /* 0xe28 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {4000 /* 0xfa0 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 5}}			/* shli r5, r4, 5 */
   },
  {4025 /* 0xfb9 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {4073 /* 0xfe9 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 4, 1}}			/* s3a r5, r4, r1 */
   },
  {4086 /* 0xff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {4087 /* 0xff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4088 /* 0xff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4089 /* 0xff9 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {4090 /* 0xffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 11},			/* shli r3, r1, 11 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {4091 /* 0xffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4092 /* 0xffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4093 /* 0xffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4094 /* 0xffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4095 /* 0xfff */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {4096 /* 0x1000 */ ,
   {{6, 1, 12}}			/* shli r2, r1, 12 */
   },
  {4097 /* 0x1001 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {4098 /* 0x1002 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {4099 /* 0x1003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4100 /* 0x1004 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {4101 /* 0x1005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4102 /* 0x1006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {4103 /* 0x1007 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {4104 /* 0x1008 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {4105 /* 0x1009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4106 /* 0x100a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {4108 /* 0x100c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {4112 /* 0x1010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4128 /* 0x1020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4160 /* 0x1040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4184 /* 0x1058 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {4224 /* 0x1080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4352 /* 0x1100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4369 /* 0x1111 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 3, 8},			/* shli r4, r3, 8 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {4376 /* 0x1118 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {4416 /* 0x1140 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {1, 2, 3},			/* add r4, r2, r3 */
    {6, 4, 6}}			/* shli r5, r4, 6 */
   },
  {4433 /* 0x1151 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {4482 /* 0x1182 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {5, 3, 1},			/* s3a r4, r3, r1 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {4608 /* 0x1200 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 9}}			/* shli r3, r2, 9 */
   },
  {4712 /* 0x1268 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {5, 3, 4}}			/* s3a r5, r3, r4 */
   },
  {4864 /* 0x1300 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {3, 2, 1},			/* s1a r3, r2, r1 */
    {6, 3, 8}}			/* shli r4, r3, 8 */
   },
  {5000 /* 0x1388 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {5040 /* 0x13b0 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 4},			/* shli r3, r2, 4 */
    {6, 2, 10},			/* shli r4, r2, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {5120 /* 0x1400 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 10}}			/* shli r3, r2, 10 */
   },
  {5243 /* 0x147b */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 7},			/* shli r4, r3, 7 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {5285 /* 0x14a5 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 7},			/* shli r3, r2, 7 */
    {4, 2, 3},			/* s2a r4, r2, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {5329 /* 0x14d1 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {6144 /* 0x1800 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 11}}			/* shli r3, r2, 11 */
   },
  {6164 /* 0x1814 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 11},			/* shli r4, r2, 11 */
    {4, 3, 4}}			/* s2a r5, r3, r4 */
   },
  {6400 /* 0x1900 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 8}}			/* shli r4, r3, 8 */
   },
  {6406 /* 0x1906 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {3, 3, 3},			/* s1a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {6656 /* 0x1a00 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {4, 2, 1},			/* s2a r3, r2, r1 */
    {6, 3, 9}}			/* shli r4, r3, 9 */
   },
  {7040 /* 0x1b80 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 6},			/* shli r3, r1, 6 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 7}}			/* shli r5, r4, 7 */
   },
  {7169 /* 0x1c01 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {5, 2, 3}}			/* s3a r4, r2, r3 */
   },
  {7678 /* 0x1dfe */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {7682 /* 0x1e02 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 1, 2},			/* sub r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {3, 3, 4}}			/* s1a r5, r3, r4 */
   },
  {8000 /* 0x1f40 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 6}}			/* shli r5, r4, 6 */
   },
  {8048 /* 0x1f70 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 4}}			/* shli r5, r4, 4 */
   },
  {8182 /* 0x1ff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 10},			/* shli r4, r2, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {8183 /* 0x1ff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8184 /* 0x1ff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8185 /* 0x1ff9 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {8186 /* 0x1ffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 12},			/* shli r3, r1, 12 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {8187 /* 0x1ffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8188 /* 0x1ffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8189 /* 0x1ffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8190 /* 0x1ffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8191 /* 0x1fff */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {8192 /* 0x2000 */ ,
   {{6, 1, 13}}			/* shli r2, r1, 13 */
   },
  {8193 /* 0x2001 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {8194 /* 0x2002 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {8195 /* 0x2003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8196 /* 0x2004 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {8197 /* 0x2005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8198 /* 0x2006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {8199 /* 0x2007 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {8200 /* 0x2008 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {8201 /* 0x2009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8202 /* 0x200a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {8203 /* 0x200b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 10},			/* shli r3, r1, 10 */
    {1, 1, 3},			/* add r4, r1, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {8204 /* 0x200c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {4, 2, 3}}			/* s2a r4, r2, r3 */
   },
  {8208 /* 0x2010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8224 /* 0x2020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8256 /* 0x2040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8320 /* 0x2080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8448 /* 0x2100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8520 /* 0x2148 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 8},			/* shli r3, r1, 8 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {8640 /* 0x21c0 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {6, 2, 10},			/* shli r4, r2, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {8672 /* 0x21e0 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 3, 8},			/* shli r4, r3, 8 */
    {2, 4, 2}}			/* sub r5, r4, r2 */
   },
  {8704 /* 0x2200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8716 /* 0x220c */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {4, 3, 2},			/* s2a r4, r3, r2 */
    {4, 4, 3}}			/* s2a r5, r4, r3 */
   },
  {8728 /* 0x2218 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 9},			/* shli r3, r1, 9 */
    {3, 3, 2},			/* s1a r4, r3, r2 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {9216 /* 0x2400 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 10}}			/* shli r3, r2, 10 */
   },
  {9217 /* 0x2401 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 10},			/* shli r3, r2, 10 */
    {1, 1, 3}}			/* add r4, r1, r3 */
   },
  {9746 /* 0x2612 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {5, 3, 3},			/* s3a r4, r3, r3 */
    {3, 4, 2}}			/* s1a r5, r4, r2 */
   },
  {9810 /* 0x2652 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 6},			/* shli r3, r2, 6 */
    {5, 3, 2},			/* s3a r4, r3, r2 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {10240 /* 0x2800 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 11}}			/* shli r3, r2, 11 */
   },
  {10248 /* 0x2808 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {4, 3, 2}}			/* s2a r4, r3, r2 */
   },
  {10368 /* 0x2880 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 7}}			/* shli r4, r3, 7 */
   },
  {10456 /* 0x28d8 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {4, 3, 3},			/* s2a r4, r3, r3 */
    {5, 4, 2}}			/* s3a r5, r4, r2 */
   },
  {10832 /* 0x2a50 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {4, 1, 2},			/* s2a r3, r1, r2 */
    {4, 3, 3},			/* s2a r4, r3, r3 */
    {4, 4, 2}}			/* s2a r5, r4, r2 */
   },
  {11512 /* 0x2cf8 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {2, 3, 1},			/* sub r4, r3, r1 */
    {5, 4, 3}}			/* s3a r5, r4, r3 */
   },
  {11522 /* 0x2d02 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {4, 3, 1},			/* s2a r4, r3, r1 */
    {3, 4, 3}}			/* s1a r5, r4, r3 */
   },
  {11529 /* 0x2d09 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 8},			/* shli r3, r2, 8 */
    {1, 1, 3},			/* add r4, r1, r3 */
    {5, 4, 4}}			/* s3a r5, r4, r4 */
   },
  {12288 /* 0x3000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 12}}			/* shli r3, r2, 12 */
   },
  {12299 /* 0x300b */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 1, 2},			/* s3a r3, r1, r2 */
    {6, 2, 12},			/* shli r4, r2, 12 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {16000 /* 0x3e80 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 7},			/* shli r3, r1, 7 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 7}}			/* shli r5, r4, 7 */
   },
  {16374 /* 0x3ff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 11},			/* shli r4, r2, 11 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {16375 /* 0x3ff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16376 /* 0x3ff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16377 /* 0x3ff9 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {16378 /* 0x3ffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 13},			/* shli r3, r1, 13 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {16379 /* 0x3ffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16380 /* 0x3ffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16381 /* 0x3ffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16382 /* 0x3ffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16383 /* 0x3fff */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {16384 /* 0x4000 */ ,
   {{6, 1, 14}}			/* shli r2, r1, 14 */
   },
  {16385 /* 0x4001 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {16386 /* 0x4002 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {16387 /* 0x4003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16388 /* 0x4004 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {16389 /* 0x4005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16390 /* 0x4006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {16391 /* 0x4007 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {16392 /* 0x4008 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {16393 /* 0x4009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16394 /* 0x400a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {16400 /* 0x4010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16416 /* 0x4020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16448 /* 0x4040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16496 /* 0x4070 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {5, 2, 4}}			/* s3a r5, r2, r4 */
   },
  {16512 /* 0x4080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16640 /* 0x4100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16896 /* 0x4200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17408 /* 0x4400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18432 /* 0x4800 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 11}}			/* shli r3, r2, 11 */
   },
  {20480 /* 0x5000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 12}}			/* shli r3, r2, 12 */
   },
  {24576 /* 0x6000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 13}}			/* shli r3, r2, 13 */
   },
  {25600 /* 0x6400 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {5, 2, 1},			/* s3a r3, r2, r1 */
    {6, 3, 10}}			/* shli r4, r3, 10 */
   },
  {32758 /* 0x7ff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 12},			/* shli r4, r2, 12 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {32759 /* 0x7ff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {32760 /* 0x7ff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {32761 /* 0x7ff9 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {32762 /* 0x7ffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 14},			/* shli r3, r1, 14 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {32763 /* 0x7ffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {32764 /* 0x7ffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {32765 /* 0x7ffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {32766 /* 0x7ffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {32767 /* 0x7fff */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {32768 /* 0x8000 */ ,
   {{6, 1, 15}}			/* shli r2, r1, 15 */
   },
  {32769 /* 0x8001 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {32770 /* 0x8002 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {32771 /* 0x8003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {32772 /* 0x8004 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {32773 /* 0x8005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {32774 /* 0x8006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {32775 /* 0x8007 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {32776 /* 0x8008 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {32777 /* 0x8009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {32778 /* 0x800a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {32784 /* 0x8010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {32800 /* 0x8020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {32832 /* 0x8040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {32896 /* 0x8080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33024 /* 0x8100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33280 /* 0x8200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33792 /* 0x8400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34816 /* 0x8800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {36864 /* 0x9000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 12}}			/* shli r3, r2, 12 */
   },
  {40960 /* 0xa000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 13}}			/* shli r3, r2, 13 */
   },
  {49152 /* 0xc000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 14}}			/* shli r3, r2, 14 */
   },
  {65526 /* 0xfff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 13},			/* shli r4, r2, 13 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {65527 /* 0xfff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {65528 /* 0xfff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {65529 /* 0xfff9 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {65530 /* 0xfffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 15},			/* shli r3, r1, 15 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {65531 /* 0xfffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {65532 /* 0xfffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {65533 /* 0xfffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {65534 /* 0xfffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {65535 /* 0xffff */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {65536 /* 0x10000 */ ,
   {{6, 1, 16}}			/* shli r2, r1, 16 */
   },
  {65537 /* 0x10001 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {65538 /* 0x10002 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {65539 /* 0x10003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65540 /* 0x10004 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {65541 /* 0x10005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65542 /* 0x10006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {65543 /* 0x10007 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {65544 /* 0x10008 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {65545 /* 0x10009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65546 /* 0x1000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {65552 /* 0x10010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65568 /* 0x10020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65600 /* 0x10040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65664 /* 0x10080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {65792 /* 0x10100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {66048 /* 0x10200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {66560 /* 0x10400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67584 /* 0x10800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {69632 /* 0x11000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {73728 /* 0x12000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 13}}			/* shli r3, r2, 13 */
   },
  {81920 /* 0x14000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 14}}			/* shli r3, r2, 14 */
   },
  {98304 /* 0x18000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 15}}			/* shli r3, r2, 15 */
   },
  {131062 /* 0x1fff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 14},			/* shli r4, r2, 14 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {131063 /* 0x1fff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {131064 /* 0x1fff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {131065 /* 0x1fff9 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {131066 /* 0x1fffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 16},			/* shli r3, r1, 16 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {131067 /* 0x1fffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {131068 /* 0x1fffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {131069 /* 0x1fffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {131070 /* 0x1fffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {131071 /* 0x1ffff */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {131072 /* 0x20000 */ ,
   {{6, 1, 17}}			/* shli r2, r1, 17 */
   },
  {131073 /* 0x20001 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {131074 /* 0x20002 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {131075 /* 0x20003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131076 /* 0x20004 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {131077 /* 0x20005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131078 /* 0x20006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {131079 /* 0x20007 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {131080 /* 0x20008 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {131081 /* 0x20009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131082 /* 0x2000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {131088 /* 0x20010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131104 /* 0x20020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131136 /* 0x20040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131200 /* 0x20080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131328 /* 0x20100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {131584 /* 0x20200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {132096 /* 0x20400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {133120 /* 0x20800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {135168 /* 0x21000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {139264 /* 0x22000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {147456 /* 0x24000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 14}}			/* shli r3, r2, 14 */
   },
  {163840 /* 0x28000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 15}}			/* shli r3, r2, 15 */
   },
  {196608 /* 0x30000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 16}}			/* shli r3, r2, 16 */
   },
  {262134 /* 0x3fff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 15},			/* shli r4, r2, 15 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {262135 /* 0x3fff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {262136 /* 0x3fff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {262137 /* 0x3fff9 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {262138 /* 0x3fffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 17},			/* shli r3, r1, 17 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {262139 /* 0x3fffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {262140 /* 0x3fffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {262141 /* 0x3fffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {262142 /* 0x3fffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {262143 /* 0x3ffff */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {262144 /* 0x40000 */ ,
   {{6, 1, 18}}			/* shli r2, r1, 18 */
   },
  {262145 /* 0x40001 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {262146 /* 0x40002 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {262147 /* 0x40003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262148 /* 0x40004 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {262149 /* 0x40005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262150 /* 0x40006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {262151 /* 0x40007 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {262152 /* 0x40008 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {262153 /* 0x40009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262154 /* 0x4000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {262160 /* 0x40010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262176 /* 0x40020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262208 /* 0x40040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262272 /* 0x40080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262400 /* 0x40100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {262656 /* 0x40200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {263168 /* 0x40400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {264192 /* 0x40800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {266240 /* 0x41000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {270336 /* 0x42000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {278528 /* 0x44000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {294912 /* 0x48000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 15}}			/* shli r3, r2, 15 */
   },
  {327680 /* 0x50000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 16}}			/* shli r3, r2, 16 */
   },
  {393216 /* 0x60000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 17}}			/* shli r3, r2, 17 */
   },
  {524278 /* 0x7fff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 16},			/* shli r4, r2, 16 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {524279 /* 0x7fff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {524280 /* 0x7fff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {524281 /* 0x7fff9 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {524282 /* 0x7fffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 18},			/* shli r3, r1, 18 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {524283 /* 0x7fffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {524284 /* 0x7fffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {524285 /* 0x7fffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {524286 /* 0x7fffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {524287 /* 0x7ffff */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {524288 /* 0x80000 */ ,
   {{6, 1, 19}}			/* shli r2, r1, 19 */
   },
  {524289 /* 0x80001 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {524290 /* 0x80002 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {524291 /* 0x80003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524292 /* 0x80004 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {524293 /* 0x80005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524294 /* 0x80006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {524295 /* 0x80007 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {524296 /* 0x80008 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {524297 /* 0x80009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524298 /* 0x8000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {524304 /* 0x80010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524320 /* 0x80020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524352 /* 0x80040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524416 /* 0x80080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524544 /* 0x80100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {524800 /* 0x80200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {525312 /* 0x80400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {526336 /* 0x80800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {528384 /* 0x81000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {532480 /* 0x82000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {540672 /* 0x84000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {557056 /* 0x88000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {589824 /* 0x90000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 16}}			/* shli r3, r2, 16 */
   },
  {655360 /* 0xa0000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 17}}			/* shli r3, r2, 17 */
   },
  {786432 /* 0xc0000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 18}}			/* shli r3, r2, 18 */
   },
  {1048566 /* 0xffff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 17},			/* shli r4, r2, 17 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1048567 /* 0xffff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1048568 /* 0xffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1048569 /* 0xffff9 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {1048570 /* 0xffffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 19},			/* shli r3, r1, 19 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {1048571 /* 0xffffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1048572 /* 0xffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1048573 /* 0xffffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1048574 /* 0xffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1048575 /* 0xfffff */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {1048576 /* 0x100000 */ ,
   {{6, 1, 20}}			/* shli r2, r1, 20 */
   },
  {1048577 /* 0x100001 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {1048578 /* 0x100002 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {1048579 /* 0x100003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048580 /* 0x100004 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {1048581 /* 0x100005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048582 /* 0x100006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {1048583 /* 0x100007 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {1048584 /* 0x100008 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {1048585 /* 0x100009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048586 /* 0x10000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {1048592 /* 0x100010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048608 /* 0x100020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048640 /* 0x100040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048704 /* 0x100080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1048832 /* 0x100100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1049088 /* 0x100200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1049600 /* 0x100400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1050624 /* 0x100800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1052672 /* 0x101000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1056768 /* 0x102000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1064960 /* 0x104000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1081344 /* 0x108000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1114112 /* 0x110000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1179648 /* 0x120000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 17}}			/* shli r3, r2, 17 */
   },
  {1310720 /* 0x140000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 18}}			/* shli r3, r2, 18 */
   },
  {1572864 /* 0x180000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 19}}			/* shli r3, r2, 19 */
   },
  {2097142 /* 0x1ffff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 18},			/* shli r4, r2, 18 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2097143 /* 0x1ffff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2097144 /* 0x1ffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2097145 /* 0x1ffff9 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {2097146 /* 0x1ffffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 20},			/* shli r3, r1, 20 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {2097147 /* 0x1ffffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2097148 /* 0x1ffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2097149 /* 0x1ffffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2097150 /* 0x1ffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2097151 /* 0x1fffff */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {2097152 /* 0x200000 */ ,
   {{6, 1, 21}}			/* shli r2, r1, 21 */
   },
  {2097153 /* 0x200001 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {2097154 /* 0x200002 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {2097155 /* 0x200003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097156 /* 0x200004 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {2097157 /* 0x200005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097158 /* 0x200006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {2097159 /* 0x200007 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {2097160 /* 0x200008 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {2097161 /* 0x200009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097162 /* 0x20000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {2097168 /* 0x200010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097184 /* 0x200020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097216 /* 0x200040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097280 /* 0x200080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097408 /* 0x200100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2097664 /* 0x200200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2098176 /* 0x200400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2099200 /* 0x200800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2101248 /* 0x201000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2105344 /* 0x202000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2113536 /* 0x204000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2129920 /* 0x208000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2162688 /* 0x210000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2228224 /* 0x220000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {2359296 /* 0x240000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 18}}			/* shli r3, r2, 18 */
   },
  {2621440 /* 0x280000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 19}}			/* shli r3, r2, 19 */
   },
  {3145728 /* 0x300000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 20}}			/* shli r3, r2, 20 */
   },
  {4194294 /* 0x3ffff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 19},			/* shli r4, r2, 19 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {4194295 /* 0x3ffff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4194296 /* 0x3ffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4194297 /* 0x3ffff9 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {4194298 /* 0x3ffffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 21},			/* shli r3, r1, 21 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {4194299 /* 0x3ffffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4194300 /* 0x3ffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4194301 /* 0x3ffffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4194302 /* 0x3ffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {4194303 /* 0x3fffff */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {4194304 /* 0x400000 */ ,
   {{6, 1, 22}}			/* shli r2, r1, 22 */
   },
  {4194305 /* 0x400001 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {4194306 /* 0x400002 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {4194307 /* 0x400003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194308 /* 0x400004 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {4194309 /* 0x400005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194310 /* 0x400006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {4194311 /* 0x400007 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {4194312 /* 0x400008 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {4194313 /* 0x400009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194314 /* 0x40000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {4194320 /* 0x400010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194336 /* 0x400020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194368 /* 0x400040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194432 /* 0x400080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194560 /* 0x400100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4194816 /* 0x400200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4195328 /* 0x400400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4196352 /* 0x400800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4198400 /* 0x401000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4202496 /* 0x402000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4210688 /* 0x404000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4227072 /* 0x408000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4259840 /* 0x410000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4325376 /* 0x420000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4456448 /* 0x440000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {4718592 /* 0x480000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 19}}			/* shli r3, r2, 19 */
   },
  {5242880 /* 0x500000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 20}}			/* shli r3, r2, 20 */
   },
  {6291456 /* 0x600000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 21}}			/* shli r3, r2, 21 */
   },
  {8388598 /* 0x7ffff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 20},			/* shli r4, r2, 20 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {8388599 /* 0x7ffff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8388600 /* 0x7ffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8388601 /* 0x7ffff9 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {8388602 /* 0x7ffffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 22},			/* shli r3, r1, 22 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {8388603 /* 0x7ffffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8388604 /* 0x7ffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8388605 /* 0x7ffffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8388606 /* 0x7ffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {8388607 /* 0x7fffff */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {8388608 /* 0x800000 */ ,
   {{6, 1, 23}}			/* shli r2, r1, 23 */
   },
  {8388609 /* 0x800001 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {8388610 /* 0x800002 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {8388611 /* 0x800003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388612 /* 0x800004 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {8388613 /* 0x800005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388614 /* 0x800006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {8388615 /* 0x800007 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {8388616 /* 0x800008 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {8388617 /* 0x800009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388618 /* 0x80000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {8388624 /* 0x800010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388640 /* 0x800020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388672 /* 0x800040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388736 /* 0x800080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8388864 /* 0x800100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8389120 /* 0x800200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8389632 /* 0x800400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8390656 /* 0x800800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8392704 /* 0x801000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8396800 /* 0x802000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8404992 /* 0x804000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8421376 /* 0x808000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8454144 /* 0x810000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8519680 /* 0x820000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8650752 /* 0x840000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {8912896 /* 0x880000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {9437184 /* 0x900000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 20}}			/* shli r3, r2, 20 */
   },
  {10485760 /* 0xa00000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 21}}			/* shli r3, r2, 21 */
   },
  {11796480 /* 0xb40000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 18}}			/* shli r4, r3, 18 */
   },
  {12582912 /* 0xc00000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 22}}			/* shli r3, r2, 22 */
   },
  {16777206 /* 0xfffff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 21},			/* shli r4, r2, 21 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {16777207 /* 0xfffff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16777208 /* 0xfffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16777209 /* 0xfffff9 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {16777210 /* 0xfffffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 23},			/* shli r3, r1, 23 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {16777211 /* 0xfffffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16777212 /* 0xfffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16777213 /* 0xfffffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16777214 /* 0xfffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {16777215 /* 0xffffff */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {16777216 /* 0x1000000 */ ,
   {{6, 1, 24}}			/* shli r2, r1, 24 */
   },
  {16777217 /* 0x1000001 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {16777218 /* 0x1000002 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {16777219 /* 0x1000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777220 /* 0x1000004 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {16777221 /* 0x1000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777222 /* 0x1000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {16777223 /* 0x1000007 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {16777224 /* 0x1000008 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {16777225 /* 0x1000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777226 /* 0x100000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {16777232 /* 0x1000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777248 /* 0x1000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777280 /* 0x1000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777344 /* 0x1000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777472 /* 0x1000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16777728 /* 0x1000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16778240 /* 0x1000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16779264 /* 0x1000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16781312 /* 0x1001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16785408 /* 0x1002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16793600 /* 0x1004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16809984 /* 0x1008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16842752 /* 0x1010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {16843009 /* 0x1010101 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 3, 16},			/* shli r4, r3, 16 */
    {1, 3, 4}}			/* add r5, r3, r4 */
   },
  {16908288 /* 0x1020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17039360 /* 0x1040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17301504 /* 0x1080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {17825792 /* 0x1100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {18874368 /* 0x1200000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 21}}			/* shli r3, r2, 21 */
   },
  {20971520 /* 0x1400000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 22}}			/* shli r3, r2, 22 */
   },
  {23592960 /* 0x1680000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {5, 2, 2},			/* s3a r3, r2, r2 */
    {6, 3, 19}}			/* shli r4, r3, 19 */
   },
  {25165824 /* 0x1800000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 23}}			/* shli r3, r2, 23 */
   },
  {33554422 /* 0x1fffff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 22},			/* shli r4, r2, 22 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {33554423 /* 0x1fffff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {33554424 /* 0x1fffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {33554425 /* 0x1fffff9 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {33554426 /* 0x1fffffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 24},			/* shli r3, r1, 24 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {33554427 /* 0x1fffffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {33554428 /* 0x1fffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {33554429 /* 0x1fffffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {33554430 /* 0x1fffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {33554431 /* 0x1ffffff */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {33554432 /* 0x2000000 */ ,
   {{6, 1, 25}}			/* shli r2, r1, 25 */
   },
  {33554433 /* 0x2000001 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {33554434 /* 0x2000002 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {33554435 /* 0x2000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554436 /* 0x2000004 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {33554437 /* 0x2000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554438 /* 0x2000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {33554439 /* 0x2000007 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {33554440 /* 0x2000008 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {33554441 /* 0x2000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554442 /* 0x200000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {33554448 /* 0x2000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554464 /* 0x2000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554496 /* 0x2000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554560 /* 0x2000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554688 /* 0x2000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33554944 /* 0x2000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33555456 /* 0x2000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33556480 /* 0x2000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33558528 /* 0x2001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33562624 /* 0x2002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33570816 /* 0x2004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33587200 /* 0x2008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33619968 /* 0x2010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33685504 /* 0x2020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {33816576 /* 0x2040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34078720 /* 0x2080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {34603008 /* 0x2100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {35651584 /* 0x2200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {37748736 /* 0x2400000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 22}}			/* shli r3, r2, 22 */
   },
  {41943040 /* 0x2800000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 23}}			/* shli r3, r2, 23 */
   },
  {50331648 /* 0x3000000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 24}}			/* shli r3, r2, 24 */
   },
  {67108854 /* 0x3fffff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 23},			/* shli r4, r2, 23 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {67108855 /* 0x3fffff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {67108856 /* 0x3fffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {67108857 /* 0x3fffff9 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {67108858 /* 0x3fffffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 25},			/* shli r3, r1, 25 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {67108859 /* 0x3fffffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {67108860 /* 0x3fffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {67108861 /* 0x3fffffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {67108862 /* 0x3fffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {67108863 /* 0x3ffffff */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {67108864 /* 0x4000000 */ ,
   {{6, 1, 26}}			/* shli r2, r1, 26 */
   },
  {67108865 /* 0x4000001 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {67108866 /* 0x4000002 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {67108867 /* 0x4000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67108868 /* 0x4000004 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {67108869 /* 0x4000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67108870 /* 0x4000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {67108871 /* 0x4000007 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {67108872 /* 0x4000008 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {67108873 /* 0x4000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67108874 /* 0x400000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {67108880 /* 0x4000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67108896 /* 0x4000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67108928 /* 0x4000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67108992 /* 0x4000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67109120 /* 0x4000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67109376 /* 0x4000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67109888 /* 0x4000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67110912 /* 0x4000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67112960 /* 0x4001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67117056 /* 0x4002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67125248 /* 0x4004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67141632 /* 0x4008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67174400 /* 0x4010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67239936 /* 0x4020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67371008 /* 0x4040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {67633152 /* 0x4080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {68157440 /* 0x4100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {69206016 /* 0x4200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {71303168 /* 0x4400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {75497472 /* 0x4800000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 23}}			/* shli r3, r2, 23 */
   },
  {83886080 /* 0x5000000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 24}}			/* shli r3, r2, 24 */
   },
  {100663296 /* 0x6000000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 25}}			/* shli r3, r2, 25 */
   },
  {134217718 /* 0x7fffff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 24},			/* shli r4, r2, 24 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {134217719 /* 0x7fffff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {134217720 /* 0x7fffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {134217721 /* 0x7fffff9 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {134217722 /* 0x7fffffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 26},			/* shli r3, r1, 26 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {134217723 /* 0x7fffffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {134217724 /* 0x7fffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {134217725 /* 0x7fffffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {134217726 /* 0x7fffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {134217727 /* 0x7ffffff */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {134217728 /* 0x8000000 */ ,
   {{6, 1, 27}}			/* shli r2, r1, 27 */
   },
  {134217729 /* 0x8000001 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {134217730 /* 0x8000002 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {134217731 /* 0x8000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217732 /* 0x8000004 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {134217733 /* 0x8000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217734 /* 0x8000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {134217735 /* 0x8000007 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {134217736 /* 0x8000008 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {134217737 /* 0x8000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217738 /* 0x800000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {134217744 /* 0x8000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217760 /* 0x8000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217792 /* 0x8000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217856 /* 0x8000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134217984 /* 0x8000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134218240 /* 0x8000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134218752 /* 0x8000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134219776 /* 0x8000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134221824 /* 0x8001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134225920 /* 0x8002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134234112 /* 0x8004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134250496 /* 0x8008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134283264 /* 0x8010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134348800 /* 0x8020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134479872 /* 0x8040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {134742016 /* 0x8080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {135266304 /* 0x8100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {136314880 /* 0x8200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {138412032 /* 0x8400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {142606336 /* 0x8800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {150994944 /* 0x9000000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 24}}			/* shli r3, r2, 24 */
   },
  {167772160 /* 0xa000000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 25}}			/* shli r3, r2, 25 */
   },
  {201326592 /* 0xc000000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 26}}			/* shli r3, r2, 26 */
   },
  {268435446 /* 0xffffff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 25},			/* shli r4, r2, 25 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {268435447 /* 0xffffff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {268435448 /* 0xffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {268435449 /* 0xffffff9 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {268435450 /* 0xffffffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 27},			/* shli r3, r1, 27 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {268435451 /* 0xffffffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {268435452 /* 0xffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {268435453 /* 0xffffffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {268435454 /* 0xffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {268435455 /* 0xfffffff */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {268435456 /* 0x10000000 */ ,
   {{6, 1, 28}}			/* shli r2, r1, 28 */
   },
  {268435457 /* 0x10000001 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {268435458 /* 0x10000002 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {268435459 /* 0x10000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435460 /* 0x10000004 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {268435461 /* 0x10000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435462 /* 0x10000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {268435463 /* 0x10000007 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {268435464 /* 0x10000008 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {268435465 /* 0x10000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435466 /* 0x1000000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {268435472 /* 0x10000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435488 /* 0x10000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435520 /* 0x10000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435584 /* 0x10000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435712 /* 0x10000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268435968 /* 0x10000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268436480 /* 0x10000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268437504 /* 0x10000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268439552 /* 0x10001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268443648 /* 0x10002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268451840 /* 0x10004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268468224 /* 0x10008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268500992 /* 0x10010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268566528 /* 0x10020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268697600 /* 0x10040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {268959744 /* 0x10080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {269484032 /* 0x10100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {270532608 /* 0x10200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {272629760 /* 0x10400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {276824064 /* 0x10800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {285212672 /* 0x11000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {301989888 /* 0x12000000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 25}}			/* shli r3, r2, 25 */
   },
  {335544320 /* 0x14000000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 26}}			/* shli r3, r2, 26 */
   },
  {402653184 /* 0x18000000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 27}}			/* shli r3, r2, 27 */
   },
  {536870902 /* 0x1ffffff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 26},			/* shli r4, r2, 26 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {536870903 /* 0x1ffffff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {536870904 /* 0x1ffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {536870905 /* 0x1ffffff9 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {536870906 /* 0x1ffffffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 28},			/* shli r3, r1, 28 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {536870907 /* 0x1ffffffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {536870908 /* 0x1ffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {536870909 /* 0x1ffffffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {536870910 /* 0x1ffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {536870911 /* 0x1fffffff */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {536870912 /* 0x20000000 */ ,
   {{6, 1, 29}}			/* shli r2, r1, 29 */
   },
  {536870913 /* 0x20000001 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {536870914 /* 0x20000002 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {536870915 /* 0x20000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536870916 /* 0x20000004 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {536870917 /* 0x20000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536870918 /* 0x20000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {536870919 /* 0x20000007 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {536870920 /* 0x20000008 */ ,
   {{6, 1, 29},			/* shli r2, r1, 29 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {536870921 /* 0x20000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536870922 /* 0x2000000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {536870928 /* 0x20000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536870944 /* 0x20000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536870976 /* 0x20000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536871040 /* 0x20000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536871168 /* 0x20000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536871424 /* 0x20000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536871936 /* 0x20000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536872960 /* 0x20000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536875008 /* 0x20001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536879104 /* 0x20002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536887296 /* 0x20004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536903680 /* 0x20008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {536936448 /* 0x20010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {537001984 /* 0x20020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {537133056 /* 0x20040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {537395200 /* 0x20080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {537919488 /* 0x20100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {538968064 /* 0x20200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {541065216 /* 0x20400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {545259520 /* 0x20800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {553648128 /* 0x21000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {570425344 /* 0x22000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {603979776 /* 0x24000000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 26}}			/* shli r3, r2, 26 */
   },
  {671088640 /* 0x28000000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 27}}			/* shli r3, r2, 27 */
   },
  {805306368 /* 0x30000000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 28}}			/* shli r3, r2, 28 */
   },
  {1073741814 /* 0x3ffffff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 27},			/* shli r4, r2, 27 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {1073741815 /* 0x3ffffff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1073741816 /* 0x3ffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1073741817 /* 0x3ffffff9 */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {1073741818 /* 0x3ffffffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 29},			/* shli r3, r1, 29 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {1073741819 /* 0x3ffffffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1073741820 /* 0x3ffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1073741821 /* 0x3ffffffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1073741822 /* 0x3ffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {1073741823 /* 0x3fffffff */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   },
  {1073741824 /* 0x40000000 */ ,
   {{6, 1, 30}}			/* shli r2, r1, 30 */
   },
  {1073741825 /* 0x40000001 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {1, 1, 2}}			/* add r3, r1, r2 */
   },
  {1073741826 /* 0x40000002 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {3, 1, 2}}			/* s1a r3, r1, r2 */
   },
  {1073741827 /* 0x40000003 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073741828 /* 0x40000004 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {4, 1, 2}}			/* s2a r3, r1, r2 */
   },
  {1073741829 /* 0x40000005 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073741830 /* 0x40000006 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {1073741831 /* 0x40000007 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 1, 3}}			/* s3a r4, r1, r3 */
   },
  {1073741832 /* 0x40000008 */ ,
   {{6, 1, 30},			/* shli r2, r1, 30 */
    {5, 1, 2}}			/* s3a r3, r1, r2 */
   },
  {1073741833 /* 0x40000009 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073741834 /* 0x4000000a */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {3, 2, 3}}			/* s1a r4, r2, r3 */
   },
  {1073741840 /* 0x40000010 */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073741856 /* 0x40000020 */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073741888 /* 0x40000040 */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073741952 /* 0x40000080 */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073742080 /* 0x40000100 */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073742336 /* 0x40000200 */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073742848 /* 0x40000400 */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073743872 /* 0x40000800 */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073745920 /* 0x40001000 */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073750016 /* 0x40002000 */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073758208 /* 0x40004000 */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073774592 /* 0x40008000 */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073807360 /* 0x40010000 */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1073872896 /* 0x40020000 */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1074003968 /* 0x40040000 */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1074266112 /* 0x40080000 */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1074790400 /* 0x40100000 */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1075838976 /* 0x40200000 */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1077936128 /* 0x40400000 */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1082130432 /* 0x40800000 */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1090519040 /* 0x41000000 */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1107296256 /* 0x42000000 */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1140850688 /* 0x44000000 */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {1, 2, 3}}			/* add r4, r2, r3 */
   },
  {1207959552 /* 0x48000000 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 2, 27}}			/* shli r3, r2, 27 */
   },
  {1342177280 /* 0x50000000 */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 2, 28}}			/* shli r3, r2, 28 */
   },
  {1610612735 /* 0x5fffffff */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 29},			/* shli r3, r2, 29 */
    {2, 3, 1}}			/* sub r4, r3, r1 */
   },
  {1610612736 /* 0x60000000 */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 2, 29}}			/* shli r3, r2, 29 */
   },
  {1879048191 /* 0x6fffffff */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 3},			/* shli r4, r2, 3 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2013265919 /* 0x77ffffff */ ,
   {{6, 1, 27},			/* shli r2, r1, 27 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 4},			/* shli r4, r2, 4 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2080374783 /* 0x7bffffff */ ,
   {{6, 1, 26},			/* shli r2, r1, 26 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 5},			/* shli r4, r2, 5 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2113929215 /* 0x7dffffff */ ,
   {{6, 1, 25},			/* shli r2, r1, 25 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 6},			/* shli r4, r2, 6 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2130706431 /* 0x7effffff */ ,
   {{6, 1, 24},			/* shli r2, r1, 24 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 7},			/* shli r4, r2, 7 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2139095039 /* 0x7f7fffff */ ,
   {{6, 1, 23},			/* shli r2, r1, 23 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 8},			/* shli r4, r2, 8 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2143289343 /* 0x7fbfffff */ ,
   {{6, 1, 22},			/* shli r2, r1, 22 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 9},			/* shli r4, r2, 9 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2145386495 /* 0x7fdfffff */ ,
   {{6, 1, 21},			/* shli r2, r1, 21 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 10},			/* shli r4, r2, 10 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2146435071 /* 0x7fefffff */ ,
   {{6, 1, 20},			/* shli r2, r1, 20 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 11},			/* shli r4, r2, 11 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2146959359 /* 0x7ff7ffff */ ,
   {{6, 1, 19},			/* shli r2, r1, 19 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 12},			/* shli r4, r2, 12 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147221503 /* 0x7ffbffff */ ,
   {{6, 1, 18},			/* shli r2, r1, 18 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 13},			/* shli r4, r2, 13 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147352575 /* 0x7ffdffff */ ,
   {{6, 1, 17},			/* shli r2, r1, 17 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 14},			/* shli r4, r2, 14 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147418111 /* 0x7ffeffff */ ,
   {{6, 1, 16},			/* shli r2, r1, 16 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 15},			/* shli r4, r2, 15 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147450879 /* 0x7fff7fff */ ,
   {{6, 1, 15},			/* shli r2, r1, 15 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 16},			/* shli r4, r2, 16 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147467263 /* 0x7fffbfff */ ,
   {{6, 1, 14},			/* shli r2, r1, 14 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 17},			/* shli r4, r2, 17 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147475455 /* 0x7fffdfff */ ,
   {{6, 1, 13},			/* shli r2, r1, 13 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 18},			/* shli r4, r2, 18 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147479551 /* 0x7fffefff */ ,
   {{6, 1, 12},			/* shli r2, r1, 12 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 19},			/* shli r4, r2, 19 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147481599 /* 0x7ffff7ff */ ,
   {{6, 1, 11},			/* shli r2, r1, 11 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 20},			/* shli r4, r2, 20 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147482623 /* 0x7ffffbff */ ,
   {{6, 1, 10},			/* shli r2, r1, 10 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 21},			/* shli r4, r2, 21 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147483135 /* 0x7ffffdff */ ,
   {{6, 1, 9},			/* shli r2, r1, 9 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 22},			/* shli r4, r2, 22 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147483391 /* 0x7ffffeff */ ,
   {{6, 1, 8},			/* shli r2, r1, 8 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 23},			/* shli r4, r2, 23 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147483519 /* 0x7fffff7f */ ,
   {{6, 1, 7},			/* shli r2, r1, 7 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 24},			/* shli r4, r2, 24 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147483583 /* 0x7fffffbf */ ,
   {{6, 1, 6},			/* shli r2, r1, 6 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 25},			/* shli r4, r2, 25 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147483615 /* 0x7fffffdf */ ,
   {{6, 1, 5},			/* shli r2, r1, 5 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 26},			/* shli r4, r2, 26 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147483631 /* 0x7fffffef */ ,
   {{6, 1, 4},			/* shli r2, r1, 4 */
    {1, 1, 2},			/* add r3, r1, r2 */
    {6, 2, 27},			/* shli r4, r2, 27 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147483638 /* 0x7ffffff6 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {3, 1, 2},			/* s1a r3, r1, r2 */
    {6, 2, 28},			/* shli r4, r2, 28 */
    {2, 4, 3}}			/* sub r5, r4, r3 */
   },
  {2147483639 /* 0x7ffffff7 */ ,
   {{5, 1, 1},			/* s3a r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2147483640 /* 0x7ffffff8 */ ,
   {{6, 1, 3},			/* shli r2, r1, 3 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2147483641 /* 0x7ffffff9 */ ,
   {{6, 1, 28},			/* shli r2, r1, 28 */
    {2, 2, 1},			/* sub r3, r2, r1 */
    {5, 3, 1}}			/* s3a r4, r3, r1 */
   },
  {2147483642 /* 0x7ffffffa */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 30},			/* shli r3, r1, 30 */
    {2, 3, 2},			/* sub r4, r3, r2 */
    {6, 4, 1}}			/* shli r5, r4, 1 */
   },
  {2147483643 /* 0x7ffffffb */ ,
   {{4, 1, 1},			/* s2a r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2147483644 /* 0x7ffffffc */ ,
   {{6, 1, 2},			/* shli r2, r1, 2 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2147483645 /* 0x7ffffffd */ ,
   {{3, 1, 1},			/* s1a r2, r1, r1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2147483646 /* 0x7ffffffe */ ,
   {{6, 1, 1},			/* shli r2, r1, 1 */
    {6, 1, 31},			/* shli r3, r1, 31 */
    {2, 3, 2}}			/* sub r4, r3, r2 */
   },
  {2147483647 /* 0x7fffffff */ ,
   {{6, 1, 31},			/* shli r2, r1, 31 */
    {2, 2, 1}}			/* sub r3, r2, r1 */
   }
};

const int tilepro_multiply_insn_seq_table_size =
  (int) (sizeof tilepro_multiply_insn_seq_table
         / sizeof tilepro_multiply_insn_seq_table[0]);
