/* equation-parser.c generated by valac 0.40.6, the Vala compiler
 * generated from equation-parser.vala, do not modify */

/*
 * Copyright (C) 2012 Arth Patel
 * Copyright (C) 2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Operator Associativity. */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ASSOCIATIVITY (associativity_get_type ())

#define TYPE_PRECEDENCE (precedence_get_type ())

#define TYPE_PARSE_NODE (parse_node_get_type ())
#define PARSE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARSE_NODE, ParseNode))
#define PARSE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARSE_NODE, ParseNodeClass))
#define IS_PARSE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARSE_NODE))
#define IS_PARSE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARSE_NODE))
#define PARSE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARSE_NODE, ParseNodeClass))

typedef struct _ParseNode ParseNode;
typedef struct _ParseNodeClass ParseNodeClass;
typedef struct _ParseNodePrivate ParseNodePrivate;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;

#define TYPE_PARSER (parser_get_type ())
#define PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARSER, Parser))
#define PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARSER, ParserClass))
#define IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARSER))
#define IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARSER))
#define PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARSER, ParserClass))

typedef struct _Parser Parser;
typedef struct _ParserClass ParserClass;

#define TYPE_LEXER_TOKEN (lexer_token_get_type ())
#define LEXER_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEXER_TOKEN, LexerToken))
#define LEXER_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEXER_TOKEN, LexerTokenClass))
#define IS_LEXER_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEXER_TOKEN))
#define IS_LEXER_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEXER_TOKEN))
#define LEXER_TOKEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEXER_TOKEN, LexerTokenClass))

typedef struct _LexerToken LexerToken;
typedef struct _LexerTokenClass LexerTokenClass;
enum  {
	PARSE_NODE_0_PROPERTY,
	PARSE_NODE_NUM_PROPERTIES
};
static GParamSpec* parse_node_properties[PARSE_NODE_NUM_PROPERTIES];
#define _parser_unref0(var) ((var == NULL) ? NULL : (var = (parser_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_RNODE (rnode_get_type ())
#define RNODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RNODE, RNode))
#define RNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RNODE, RNodeClass))
#define IS_RNODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RNODE))
#define IS_RNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RNODE))
#define RNODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RNODE, RNodeClass))

typedef struct _RNode RNode;
typedef struct _RNodeClass RNodeClass;
typedef struct _RNodePrivate RNodePrivate;
enum  {
	RNODE_0_PROPERTY,
	RNODE_NUM_PROPERTIES
};
static GParamSpec* rnode_properties[RNODE_NUM_PROPERTIES];

#define TYPE_ERROR_CODE (error_code_get_type ())
typedef struct _LexerTokenPrivate LexerTokenPrivate;

#define TYPE_LEXER_TOKEN_TYPE (lexer_token_type_get_type ())

#define TYPE_LR_NODE (lr_node_get_type ())
#define LR_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LR_NODE, LRNode))
#define LR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LR_NODE, LRNodeClass))
#define IS_LR_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LR_NODE))
#define IS_LR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LR_NODE))
#define LR_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LR_NODE, LRNodeClass))

typedef struct _LRNode LRNode;
typedef struct _LRNodeClass LRNodeClass;
typedef struct _LRNodePrivate LRNodePrivate;
enum  {
	LR_NODE_0_PROPERTY,
	LR_NODE_NUM_PROPERTIES
};
static GParamSpec* lr_node_properties[LR_NODE_NUM_PROPERTIES];

#define TYPE_CONSTANT_NODE (constant_node_get_type ())
#define CONSTANT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONSTANT_NODE, ConstantNode))
#define CONSTANT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONSTANT_NODE, ConstantNodeClass))
#define IS_CONSTANT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONSTANT_NODE))
#define IS_CONSTANT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONSTANT_NODE))
#define CONSTANT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONSTANT_NODE, ConstantNodeClass))

typedef struct _ConstantNode ConstantNode;
typedef struct _ConstantNodeClass ConstantNodeClass;
typedef struct _ConstantNodePrivate ConstantNodePrivate;
enum  {
	CONSTANT_NODE_0_PROPERTY,
	CONSTANT_NODE_NUM_PROPERTIES
};
static GParamSpec* constant_node_properties[CONSTANT_NODE_NUM_PROPERTIES];
typedef struct _ParserPrivate ParserPrivate;

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_ASSIGN_NODE (assign_node_get_type ())
#define ASSIGN_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSIGN_NODE, AssignNode))
#define ASSIGN_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSIGN_NODE, AssignNodeClass))
#define IS_ASSIGN_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSIGN_NODE))
#define IS_ASSIGN_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSIGN_NODE))
#define ASSIGN_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSIGN_NODE, AssignNodeClass))

typedef struct _AssignNode AssignNode;
typedef struct _AssignNodeClass AssignNodeClass;
typedef struct _AssignNodePrivate AssignNodePrivate;
enum  {
	ASSIGN_NODE_0_PROPERTY,
	ASSIGN_NODE_NUM_PROPERTIES
};
static GParamSpec* assign_node_properties[ASSIGN_NODE_NUM_PROPERTIES];

#define TYPE_ASSIGN_FUNCTION_NODE (assign_function_node_get_type ())
#define ASSIGN_FUNCTION_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSIGN_FUNCTION_NODE, AssignFunctionNode))
#define ASSIGN_FUNCTION_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSIGN_FUNCTION_NODE, AssignFunctionNodeClass))
#define IS_ASSIGN_FUNCTION_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSIGN_FUNCTION_NODE))
#define IS_ASSIGN_FUNCTION_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSIGN_FUNCTION_NODE))
#define ASSIGN_FUNCTION_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSIGN_FUNCTION_NODE, AssignFunctionNodeClass))

typedef struct _AssignFunctionNode AssignFunctionNode;
typedef struct _AssignFunctionNodeClass AssignFunctionNodeClass;
typedef struct _AssignFunctionNodePrivate AssignFunctionNodePrivate;
enum  {
	ASSIGN_FUNCTION_NODE_0_PROPERTY,
	ASSIGN_FUNCTION_NODE_NUM_PROPERTIES
};
static GParamSpec* assign_function_node_properties[ASSIGN_FUNCTION_NODE_NUM_PROPERTIES];

#define TYPE_FUNCTION_MANAGER (function_manager_get_type ())
#define FUNCTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_MANAGER, FunctionManager))
#define FUNCTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_MANAGER, FunctionManagerClass))
#define IS_FUNCTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_MANAGER))
#define IS_FUNCTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_MANAGER))
#define FUNCTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_MANAGER, FunctionManagerClass))

typedef struct _FunctionManager FunctionManager;
typedef struct _FunctionManagerClass FunctionManagerClass;

#define TYPE_NAME_NODE (name_node_get_type ())
#define NAME_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NAME_NODE, NameNode))
#define NAME_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NAME_NODE, NameNodeClass))
#define IS_NAME_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NAME_NODE))
#define IS_NAME_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NAME_NODE))
#define NAME_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NAME_NODE, NameNodeClass))

typedef struct _NameNode NameNode;
typedef struct _NameNodeClass NameNodeClass;
typedef struct _NameNodePrivate NameNodePrivate;
enum  {
	NAME_NODE_0_PROPERTY,
	NAME_NODE_NUM_PROPERTIES
};
static GParamSpec* name_node_properties[NAME_NODE_NUM_PROPERTIES];

#define TYPE_VARIABLE_NODE (variable_node_get_type ())
#define VARIABLE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VARIABLE_NODE, VariableNode))
#define VARIABLE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VARIABLE_NODE, VariableNodeClass))
#define IS_VARIABLE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VARIABLE_NODE))
#define IS_VARIABLE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VARIABLE_NODE))
#define VARIABLE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VARIABLE_NODE, VariableNodeClass))

typedef struct _VariableNode VariableNode;
typedef struct _VariableNodeClass VariableNodeClass;
typedef struct _VariableNodePrivate VariableNodePrivate;
enum  {
	VARIABLE_NODE_0_PROPERTY,
	VARIABLE_NODE_NUM_PROPERTIES
};
static GParamSpec* variable_node_properties[VARIABLE_NODE_NUM_PROPERTIES];

#define TYPE_VARIABLE_WITH_POWER_NODE (variable_with_power_node_get_type ())
#define VARIABLE_WITH_POWER_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VARIABLE_WITH_POWER_NODE, VariableWithPowerNode))
#define VARIABLE_WITH_POWER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VARIABLE_WITH_POWER_NODE, VariableWithPowerNodeClass))
#define IS_VARIABLE_WITH_POWER_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VARIABLE_WITH_POWER_NODE))
#define IS_VARIABLE_WITH_POWER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VARIABLE_WITH_POWER_NODE))
#define VARIABLE_WITH_POWER_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VARIABLE_WITH_POWER_NODE, VariableWithPowerNodeClass))

typedef struct _VariableWithPowerNode VariableWithPowerNode;
typedef struct _VariableWithPowerNodeClass VariableWithPowerNodeClass;
typedef struct _VariableWithPowerNodePrivate VariableWithPowerNodePrivate;
enum  {
	VARIABLE_WITH_POWER_NODE_0_PROPERTY,
	VARIABLE_WITH_POWER_NODE_NUM_PROPERTIES
};
static GParamSpec* variable_with_power_node_properties[VARIABLE_WITH_POWER_NODE_NUM_PROPERTIES];

#define TYPE_FUNCTION_NAME_NODE (function_name_node_get_type ())
#define FUNCTION_NAME_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_NAME_NODE, FunctionNameNode))
#define FUNCTION_NAME_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_NAME_NODE, FunctionNameNodeClass))
#define IS_FUNCTION_NAME_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_NAME_NODE))
#define IS_FUNCTION_NAME_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_NAME_NODE))
#define FUNCTION_NAME_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_NAME_NODE, FunctionNameNodeClass))

typedef struct _FunctionNameNode FunctionNameNode;
typedef struct _FunctionNameNodeClass FunctionNameNodeClass;
typedef struct _FunctionNameNodePrivate FunctionNameNodePrivate;
enum  {
	FUNCTION_NAME_NODE_0_PROPERTY,
	FUNCTION_NAME_NODE_NUM_PROPERTIES
};
static GParamSpec* function_name_node_properties[FUNCTION_NAME_NODE_NUM_PROPERTIES];

#define TYPE_FUNCTION_ARGUMENTS_NODE (function_arguments_node_get_type ())
#define FUNCTION_ARGUMENTS_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_ARGUMENTS_NODE, FunctionArgumentsNode))
#define FUNCTION_ARGUMENTS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_ARGUMENTS_NODE, FunctionArgumentsNodeClass))
#define IS_FUNCTION_ARGUMENTS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_ARGUMENTS_NODE))
#define IS_FUNCTION_ARGUMENTS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_ARGUMENTS_NODE))
#define FUNCTION_ARGUMENTS_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_ARGUMENTS_NODE, FunctionArgumentsNodeClass))

typedef struct _FunctionArgumentsNode FunctionArgumentsNode;
typedef struct _FunctionArgumentsNodeClass FunctionArgumentsNodeClass;
typedef struct _FunctionArgumentsNodePrivate FunctionArgumentsNodePrivate;
enum  {
	FUNCTION_ARGUMENTS_NODE_0_PROPERTY,
	FUNCTION_ARGUMENTS_NODE_NUM_PROPERTIES
};
static GParamSpec* function_arguments_node_properties[FUNCTION_ARGUMENTS_NODE_NUM_PROPERTIES];

#define TYPE_FUNCTION_DESCRIPTION_NODE (function_description_node_get_type ())
#define FUNCTION_DESCRIPTION_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_DESCRIPTION_NODE, FunctionDescriptionNode))
#define FUNCTION_DESCRIPTION_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_DESCRIPTION_NODE, FunctionDescriptionNodeClass))
#define IS_FUNCTION_DESCRIPTION_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_DESCRIPTION_NODE))
#define IS_FUNCTION_DESCRIPTION_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_DESCRIPTION_NODE))
#define FUNCTION_DESCRIPTION_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_DESCRIPTION_NODE, FunctionDescriptionNodeClass))

typedef struct _FunctionDescriptionNode FunctionDescriptionNode;
typedef struct _FunctionDescriptionNodeClass FunctionDescriptionNodeClass;
typedef struct _FunctionDescriptionNodePrivate FunctionDescriptionNodePrivate;
enum  {
	FUNCTION_DESCRIPTION_NODE_0_PROPERTY,
	FUNCTION_DESCRIPTION_NODE_NUM_PROPERTIES
};
static GParamSpec* function_description_node_properties[FUNCTION_DESCRIPTION_NODE_NUM_PROPERTIES];

#define TYPE_FUNCTION_NODE (function_node_get_type ())
#define FUNCTION_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_NODE, FunctionNode))
#define FUNCTION_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_NODE, FunctionNodeClass))
#define IS_FUNCTION_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_NODE))
#define IS_FUNCTION_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_NODE))
#define FUNCTION_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_NODE, FunctionNodeClass))

typedef struct _FunctionNode FunctionNode;
typedef struct _FunctionNodeClass FunctionNodeClass;
typedef struct _FunctionNodePrivate FunctionNodePrivate;
enum  {
	FUNCTION_NODE_0_PROPERTY,
	FUNCTION_NODE_NUM_PROPERTIES
};
static GParamSpec* function_node_properties[FUNCTION_NODE_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_EXPRESSION_PARSER (expression_parser_get_type ())
#define EXPRESSION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPRESSION_PARSER, ExpressionParser))
#define EXPRESSION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPRESSION_PARSER, ExpressionParserClass))
#define IS_EXPRESSION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPRESSION_PARSER))
#define IS_EXPRESSION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPRESSION_PARSER))
#define EXPRESSION_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPRESSION_PARSER, ExpressionParserClass))

typedef struct _ExpressionParser ExpressionParser;
typedef struct _ExpressionParserClass ExpressionParserClass;

#define TYPE_UNARY_MINUS_NODE (unary_minus_node_get_type ())
#define UNARY_MINUS_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNARY_MINUS_NODE, UnaryMinusNode))
#define UNARY_MINUS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNARY_MINUS_NODE, UnaryMinusNodeClass))
#define IS_UNARY_MINUS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNARY_MINUS_NODE))
#define IS_UNARY_MINUS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNARY_MINUS_NODE))
#define UNARY_MINUS_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNARY_MINUS_NODE, UnaryMinusNodeClass))

typedef struct _UnaryMinusNode UnaryMinusNode;
typedef struct _UnaryMinusNodeClass UnaryMinusNodeClass;
typedef struct _UnaryMinusNodePrivate UnaryMinusNodePrivate;
enum  {
	UNARY_MINUS_NODE_0_PROPERTY,
	UNARY_MINUS_NODE_NUM_PROPERTIES
};
static GParamSpec* unary_minus_node_properties[UNARY_MINUS_NODE_NUM_PROPERTIES];

#define TYPE_ABSOLUTE_VALUE_NODE (absolute_value_node_get_type ())
#define ABSOLUTE_VALUE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSOLUTE_VALUE_NODE, AbsoluteValueNode))
#define ABSOLUTE_VALUE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSOLUTE_VALUE_NODE, AbsoluteValueNodeClass))
#define IS_ABSOLUTE_VALUE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSOLUTE_VALUE_NODE))
#define IS_ABSOLUTE_VALUE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSOLUTE_VALUE_NODE))
#define ABSOLUTE_VALUE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSOLUTE_VALUE_NODE, AbsoluteValueNodeClass))

typedef struct _AbsoluteValueNode AbsoluteValueNode;
typedef struct _AbsoluteValueNodeClass AbsoluteValueNodeClass;
typedef struct _AbsoluteValueNodePrivate AbsoluteValueNodePrivate;
enum  {
	ABSOLUTE_VALUE_NODE_0_PROPERTY,
	ABSOLUTE_VALUE_NODE_NUM_PROPERTIES
};
static GParamSpec* absolute_value_node_properties[ABSOLUTE_VALUE_NODE_NUM_PROPERTIES];

#define TYPE_FLOOR_NODE (floor_node_get_type ())
#define FLOOR_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLOOR_NODE, FloorNode))
#define FLOOR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FLOOR_NODE, FloorNodeClass))
#define IS_FLOOR_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLOOR_NODE))
#define IS_FLOOR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FLOOR_NODE))
#define FLOOR_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FLOOR_NODE, FloorNodeClass))

typedef struct _FloorNode FloorNode;
typedef struct _FloorNodeClass FloorNodeClass;
typedef struct _FloorNodePrivate FloorNodePrivate;
enum  {
	FLOOR_NODE_0_PROPERTY,
	FLOOR_NODE_NUM_PROPERTIES
};
static GParamSpec* floor_node_properties[FLOOR_NODE_NUM_PROPERTIES];

#define TYPE_CEILING_NODE (ceiling_node_get_type ())
#define CEILING_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CEILING_NODE, CeilingNode))
#define CEILING_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CEILING_NODE, CeilingNodeClass))
#define IS_CEILING_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CEILING_NODE))
#define IS_CEILING_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CEILING_NODE))
#define CEILING_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CEILING_NODE, CeilingNodeClass))

typedef struct _CeilingNode CeilingNode;
typedef struct _CeilingNodeClass CeilingNodeClass;
typedef struct _CeilingNodePrivate CeilingNodePrivate;
enum  {
	CEILING_NODE_0_PROPERTY,
	CEILING_NODE_NUM_PROPERTIES
};
static GParamSpec* ceiling_node_properties[CEILING_NODE_NUM_PROPERTIES];

#define TYPE_FRACTIONAL_COMPONENT_NODE (fractional_component_node_get_type ())
#define FRACTIONAL_COMPONENT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FRACTIONAL_COMPONENT_NODE, FractionalComponentNode))
#define FRACTIONAL_COMPONENT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FRACTIONAL_COMPONENT_NODE, FractionalComponentNodeClass))
#define IS_FRACTIONAL_COMPONENT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FRACTIONAL_COMPONENT_NODE))
#define IS_FRACTIONAL_COMPONENT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FRACTIONAL_COMPONENT_NODE))
#define FRACTIONAL_COMPONENT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FRACTIONAL_COMPONENT_NODE, FractionalComponentNodeClass))

typedef struct _FractionalComponentNode FractionalComponentNode;
typedef struct _FractionalComponentNodeClass FractionalComponentNodeClass;
typedef struct _FractionalComponentNodePrivate FractionalComponentNodePrivate;
enum  {
	FRACTIONAL_COMPONENT_NODE_0_PROPERTY,
	FRACTIONAL_COMPONENT_NODE_NUM_PROPERTIES
};
static GParamSpec* fractional_component_node_properties[FRACTIONAL_COMPONENT_NODE_NUM_PROPERTIES];

#define TYPE_ROUND_NODE (round_node_get_type ())
#define ROUND_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROUND_NODE, RoundNode))
#define ROUND_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROUND_NODE, RoundNodeClass))
#define IS_ROUND_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROUND_NODE))
#define IS_ROUND_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROUND_NODE))
#define ROUND_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROUND_NODE, RoundNodeClass))

typedef struct _RoundNode RoundNode;
typedef struct _RoundNodeClass RoundNodeClass;
typedef struct _RoundNodePrivate RoundNodePrivate;
enum  {
	ROUND_NODE_0_PROPERTY,
	ROUND_NODE_NUM_PROPERTIES
};
static GParamSpec* round_node_properties[ROUND_NODE_NUM_PROPERTIES];

#define TYPE_PERCENT_NODE (percent_node_get_type ())
#define PERCENT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PERCENT_NODE, PercentNode))
#define PERCENT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PERCENT_NODE, PercentNodeClass))
#define IS_PERCENT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PERCENT_NODE))
#define IS_PERCENT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PERCENT_NODE))
#define PERCENT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PERCENT_NODE, PercentNodeClass))

typedef struct _PercentNode PercentNode;
typedef struct _PercentNodeClass PercentNodeClass;
typedef struct _PercentNodePrivate PercentNodePrivate;
enum  {
	PERCENT_NODE_0_PROPERTY,
	PERCENT_NODE_NUM_PROPERTIES
};
static GParamSpec* percent_node_properties[PERCENT_NODE_NUM_PROPERTIES];

#define TYPE_FACTORIAL_NODE (factorial_node_get_type ())
#define FACTORIAL_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACTORIAL_NODE, FactorialNode))
#define FACTORIAL_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACTORIAL_NODE, FactorialNodeClass))
#define IS_FACTORIAL_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACTORIAL_NODE))
#define IS_FACTORIAL_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACTORIAL_NODE))
#define FACTORIAL_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACTORIAL_NODE, FactorialNodeClass))

typedef struct _FactorialNode FactorialNode;
typedef struct _FactorialNodeClass FactorialNodeClass;
typedef struct _FactorialNodePrivate FactorialNodePrivate;
enum  {
	FACTORIAL_NODE_0_PROPERTY,
	FACTORIAL_NODE_NUM_PROPERTIES
};
static GParamSpec* factorial_node_properties[FACTORIAL_NODE_NUM_PROPERTIES];

#define TYPE_ADD_NODE (add_node_get_type ())
#define ADD_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_NODE, AddNode))
#define ADD_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_NODE, AddNodeClass))
#define IS_ADD_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_NODE))
#define IS_ADD_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_NODE))
#define ADD_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_NODE, AddNodeClass))

typedef struct _AddNode AddNode;
typedef struct _AddNodeClass AddNodeClass;
typedef struct _AddNodePrivate AddNodePrivate;
enum  {
	ADD_NODE_0_PROPERTY,
	ADD_NODE_NUM_PROPERTIES
};
static GParamSpec* add_node_properties[ADD_NODE_NUM_PROPERTIES];

#define TYPE_SUBTRACT_NODE (subtract_node_get_type ())
#define SUBTRACT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBTRACT_NODE, SubtractNode))
#define SUBTRACT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBTRACT_NODE, SubtractNodeClass))
#define IS_SUBTRACT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBTRACT_NODE))
#define IS_SUBTRACT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBTRACT_NODE))
#define SUBTRACT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBTRACT_NODE, SubtractNodeClass))

typedef struct _SubtractNode SubtractNode;
typedef struct _SubtractNodeClass SubtractNodeClass;
typedef struct _SubtractNodePrivate SubtractNodePrivate;
enum  {
	SUBTRACT_NODE_0_PROPERTY,
	SUBTRACT_NODE_NUM_PROPERTIES
};
static GParamSpec* subtract_node_properties[SUBTRACT_NODE_NUM_PROPERTIES];

#define TYPE_MULTIPLY_NODE (multiply_node_get_type ())
#define MULTIPLY_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTIPLY_NODE, MultiplyNode))
#define MULTIPLY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTIPLY_NODE, MultiplyNodeClass))
#define IS_MULTIPLY_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTIPLY_NODE))
#define IS_MULTIPLY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTIPLY_NODE))
#define MULTIPLY_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTIPLY_NODE, MultiplyNodeClass))

typedef struct _MultiplyNode MultiplyNode;
typedef struct _MultiplyNodeClass MultiplyNodeClass;
typedef struct _MultiplyNodePrivate MultiplyNodePrivate;
enum  {
	MULTIPLY_NODE_0_PROPERTY,
	MULTIPLY_NODE_NUM_PROPERTIES
};
static GParamSpec* multiply_node_properties[MULTIPLY_NODE_NUM_PROPERTIES];

#define TYPE_DIVIDE_NODE (divide_node_get_type ())
#define DIVIDE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIVIDE_NODE, DivideNode))
#define DIVIDE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIVIDE_NODE, DivideNodeClass))
#define IS_DIVIDE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIVIDE_NODE))
#define IS_DIVIDE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIVIDE_NODE))
#define DIVIDE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIVIDE_NODE, DivideNodeClass))

typedef struct _DivideNode DivideNode;
typedef struct _DivideNodeClass DivideNodeClass;
typedef struct _DivideNodePrivate DivideNodePrivate;
enum  {
	DIVIDE_NODE_0_PROPERTY,
	DIVIDE_NODE_NUM_PROPERTIES
};
static GParamSpec* divide_node_properties[DIVIDE_NODE_NUM_PROPERTIES];

#define TYPE_MODULUS_DIVIDE_NODE (modulus_divide_node_get_type ())
#define MODULUS_DIVIDE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODULUS_DIVIDE_NODE, ModulusDivideNode))
#define MODULUS_DIVIDE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODULUS_DIVIDE_NODE, ModulusDivideNodeClass))
#define IS_MODULUS_DIVIDE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODULUS_DIVIDE_NODE))
#define IS_MODULUS_DIVIDE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODULUS_DIVIDE_NODE))
#define MODULUS_DIVIDE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODULUS_DIVIDE_NODE, ModulusDivideNodeClass))

typedef struct _ModulusDivideNode ModulusDivideNode;
typedef struct _ModulusDivideNodeClass ModulusDivideNodeClass;
typedef struct _ModulusDivideNodePrivate ModulusDivideNodePrivate;
enum  {
	MODULUS_DIVIDE_NODE_0_PROPERTY,
	MODULUS_DIVIDE_NODE_NUM_PROPERTIES
};
static GParamSpec* modulus_divide_node_properties[MODULUS_DIVIDE_NODE_NUM_PROPERTIES];

#define TYPE_XPOW_YNODE (xpow_ynode_get_type ())
#define XPOW_YNODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XPOW_YNODE, XPowYNode))
#define XPOW_YNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XPOW_YNODE, XPowYNodeClass))
#define IS_XPOW_YNODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XPOW_YNODE))
#define IS_XPOW_YNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XPOW_YNODE))
#define XPOW_YNODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XPOW_YNODE, XPowYNodeClass))

typedef struct _XPowYNode XPowYNode;
typedef struct _XPowYNodeClass XPowYNodeClass;

#define TYPE_ROOT_NODE (root_node_get_type ())
#define ROOT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROOT_NODE, RootNode))
#define ROOT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROOT_NODE, RootNodeClass))
#define IS_ROOT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROOT_NODE))
#define IS_ROOT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROOT_NODE))
#define ROOT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROOT_NODE, RootNodeClass))

typedef struct _RootNode RootNode;
typedef struct _RootNodeClass RootNodeClass;
typedef struct _RootNodePrivate RootNodePrivate;
enum  {
	ROOT_NODE_0_PROPERTY,
	ROOT_NODE_NUM_PROPERTIES
};
static GParamSpec* root_node_properties[ROOT_NODE_NUM_PROPERTIES];
typedef struct _XPowYNodePrivate XPowYNodePrivate;
enum  {
	XPOW_YNODE_0_PROPERTY,
	XPOW_YNODE_NUM_PROPERTIES
};
static GParamSpec* xpow_ynode_properties[XPOW_YNODE_NUM_PROPERTIES];

#define TYPE_XPOW_YINTEGER_NODE (xpow_yinteger_node_get_type ())
#define XPOW_YINTEGER_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XPOW_YINTEGER_NODE, XPowYIntegerNode))
#define XPOW_YINTEGER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XPOW_YINTEGER_NODE, XPowYIntegerNodeClass))
#define IS_XPOW_YINTEGER_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XPOW_YINTEGER_NODE))
#define IS_XPOW_YINTEGER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XPOW_YINTEGER_NODE))
#define XPOW_YINTEGER_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XPOW_YINTEGER_NODE, XPowYIntegerNodeClass))

typedef struct _XPowYIntegerNode XPowYIntegerNode;
typedef struct _XPowYIntegerNodeClass XPowYIntegerNodeClass;
typedef struct _XPowYIntegerNodePrivate XPowYIntegerNodePrivate;
enum  {
	XPOW_YINTEGER_NODE_0_PROPERTY,
	XPOW_YINTEGER_NODE_NUM_PROPERTIES
};
static GParamSpec* xpow_yinteger_node_properties[XPOW_YINTEGER_NODE_NUM_PROPERTIES];

#define TYPE_NOT_NODE (not_node_get_type ())
#define NOT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOT_NODE, NotNode))
#define NOT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOT_NODE, NotNodeClass))
#define IS_NOT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOT_NODE))
#define IS_NOT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOT_NODE))
#define NOT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOT_NODE, NotNodeClass))

typedef struct _NotNode NotNode;
typedef struct _NotNodeClass NotNodeClass;
typedef struct _NotNodePrivate NotNodePrivate;
enum  {
	NOT_NODE_0_PROPERTY,
	NOT_NODE_NUM_PROPERTIES
};
static GParamSpec* not_node_properties[NOT_NODE_NUM_PROPERTIES];

#define TYPE_AND_NODE (and_node_get_type ())
#define AND_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AND_NODE, AndNode))
#define AND_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AND_NODE, AndNodeClass))
#define IS_AND_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AND_NODE))
#define IS_AND_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AND_NODE))
#define AND_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AND_NODE, AndNodeClass))

typedef struct _AndNode AndNode;
typedef struct _AndNodeClass AndNodeClass;
typedef struct _AndNodePrivate AndNodePrivate;
enum  {
	AND_NODE_0_PROPERTY,
	AND_NODE_NUM_PROPERTIES
};
static GParamSpec* and_node_properties[AND_NODE_NUM_PROPERTIES];

#define TYPE_OR_NODE (or_node_get_type ())
#define OR_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OR_NODE, OrNode))
#define OR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OR_NODE, OrNodeClass))
#define IS_OR_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OR_NODE))
#define IS_OR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OR_NODE))
#define OR_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OR_NODE, OrNodeClass))

typedef struct _OrNode OrNode;
typedef struct _OrNodeClass OrNodeClass;
typedef struct _OrNodePrivate OrNodePrivate;
enum  {
	OR_NODE_0_PROPERTY,
	OR_NODE_NUM_PROPERTIES
};
static GParamSpec* or_node_properties[OR_NODE_NUM_PROPERTIES];

#define TYPE_XOR_NODE (xor_node_get_type ())
#define XOR_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XOR_NODE, XorNode))
#define XOR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XOR_NODE, XorNodeClass))
#define IS_XOR_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XOR_NODE))
#define IS_XOR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XOR_NODE))
#define XOR_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XOR_NODE, XorNodeClass))

typedef struct _XorNode XorNode;
typedef struct _XorNodeClass XorNodeClass;
typedef struct _XorNodePrivate XorNodePrivate;
enum  {
	XOR_NODE_0_PROPERTY,
	XOR_NODE_NUM_PROPERTIES
};
static GParamSpec* xor_node_properties[XOR_NODE_NUM_PROPERTIES];

#define TYPE_CONVERT_NODE (convert_node_get_type ())
#define CONVERT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONVERT_NODE, ConvertNode))
#define CONVERT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONVERT_NODE, ConvertNodeClass))
#define IS_CONVERT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONVERT_NODE))
#define IS_CONVERT_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONVERT_NODE))
#define CONVERT_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONVERT_NODE, ConvertNodeClass))

typedef struct _ConvertNode ConvertNode;
typedef struct _ConvertNodeClass ConvertNodeClass;
typedef struct _ConvertNodePrivate ConvertNodePrivate;
enum  {
	CONVERT_NODE_0_PROPERTY,
	CONVERT_NODE_NUM_PROPERTIES
};
static GParamSpec* convert_node_properties[CONVERT_NODE_NUM_PROPERTIES];

#define TYPE_CONVERT_BASE_NODE (convert_base_node_get_type ())
#define CONVERT_BASE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONVERT_BASE_NODE, ConvertBaseNode))
#define CONVERT_BASE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONVERT_BASE_NODE, ConvertBaseNodeClass))
#define IS_CONVERT_BASE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONVERT_BASE_NODE))
#define IS_CONVERT_BASE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONVERT_BASE_NODE))
#define CONVERT_BASE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONVERT_BASE_NODE, ConvertBaseNodeClass))

typedef struct _ConvertBaseNode ConvertBaseNode;
typedef struct _ConvertBaseNodeClass ConvertBaseNodeClass;
typedef struct _ConvertBaseNodePrivate ConvertBaseNodePrivate;
enum  {
	CONVERT_BASE_NODE_0_PROPERTY,
	CONVERT_BASE_NODE_NUM_PROPERTIES
};
static GParamSpec* convert_base_node_properties[CONVERT_BASE_NODE_NUM_PROPERTIES];

#define TYPE_CONVERT_NUMBER_NODE (convert_number_node_get_type ())
#define CONVERT_NUMBER_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONVERT_NUMBER_NODE, ConvertNumberNode))
#define CONVERT_NUMBER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONVERT_NUMBER_NODE, ConvertNumberNodeClass))
#define IS_CONVERT_NUMBER_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONVERT_NUMBER_NODE))
#define IS_CONVERT_NUMBER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONVERT_NUMBER_NODE))
#define CONVERT_NUMBER_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONVERT_NUMBER_NODE, ConvertNumberNodeClass))

typedef struct _ConvertNumberNode ConvertNumberNode;
typedef struct _ConvertNumberNodeClass ConvertNumberNodeClass;
typedef struct _ConvertNumberNodePrivate ConvertNumberNodePrivate;
enum  {
	CONVERT_NUMBER_NODE_0_PROPERTY,
	CONVERT_NUMBER_NODE_NUM_PROPERTIES
};
static GParamSpec* convert_number_node_properties[CONVERT_NUMBER_NODE_NUM_PROPERTIES];

#define TYPE_LEXER (lexer_get_type ())
#define LEXER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEXER, Lexer))
#define LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEXER, LexerClass))
#define IS_LEXER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEXER))
#define IS_LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEXER))
#define LEXER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEXER, LexerClass))

typedef struct _Lexer Lexer;
typedef struct _LexerClass LexerClass;
typedef struct _ParamSpecParser ParamSpecParser;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	ASSOCIATIVITY_LEFT,
	ASSOCIATIVITY_RIGHT
} Associativity;

typedef enum  {
	PRECEDENCE_UNKNOWN = 0,
	PRECEDENCE_CONVERT = 0,
	PRECEDENCE_UNIT = 1,
	PRECEDENCE_TOP = 2,
	PRECEDENCE_ADD_SUBTRACT = 3,
	PRECEDENCE_MULTIPLY = 4,
	PRECEDENCE_MOD = 5,
	PRECEDENCE_DIVIDE = 5,
	PRECEDENCE_NOT = 6,
	PRECEDENCE_FUNCTION = 7,
	PRECEDENCE_BOOLEAN = 8,
	PRECEDENCE_PERCENTAGE = 9,
	PRECEDENCE_UNARY_MINUS = 10,
	PRECEDENCE_POWER = 10,
	PRECEDENCE_ROOT = 10,
	PRECEDENCE_FACTORIAL = 11,
	PRECEDENCE_NUMBER_VARIABLE = 12,
	PRECEDENCE_DEPTH
} Precedence;

struct _ParseNode {
	GObject parent_instance;
	ParseNodePrivate * priv;
	Parser* parser;
	ParseNode* parent;
	ParseNode* left;
	ParseNode* right;
	GList* token_list;
	guint precedence;
	Associativity associativity;
	gchar* value;
};

struct _ParseNodeClass {
	GObjectClass parent_class;
	Number* (*solve) (ParseNode* self);
};

struct _RNode {
	ParseNode parent_instance;
	RNodePrivate * priv;
};

struct _RNodeClass {
	ParseNodeClass parent_class;
	Number* (*solve_r) (RNode* self, Number* r);
};

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

typedef enum  {
	LEXER_TOKEN_TYPE_UNKNOWN,
	LEXER_TOKEN_TYPE_PL_DECIMAL,
	LEXER_TOKEN_TYPE_PL_DIGIT,
	LEXER_TOKEN_TYPE_PL_HEX,
	LEXER_TOKEN_TYPE_PL_SUPER_DIGIT,
	LEXER_TOKEN_TYPE_PL_SUPER_MINUS,
	LEXER_TOKEN_TYPE_PL_SUB_DIGIT,
	LEXER_TOKEN_TYPE_PL_FRACTION,
	LEXER_TOKEN_TYPE_PL_DEGREE,
	LEXER_TOKEN_TYPE_PL_MINUTE,
	LEXER_TOKEN_TYPE_PL_SECOND,
	LEXER_TOKEN_TYPE_PL_LETTER,
	LEXER_TOKEN_TYPE_PL_EOS,
	LEXER_TOKEN_TYPE_PL_SKIP,
	LEXER_TOKEN_TYPE_ADD,
	LEXER_TOKEN_TYPE_SUBTRACT,
	LEXER_TOKEN_TYPE_MULTIPLY,
	LEXER_TOKEN_TYPE_DIVIDE,
	LEXER_TOKEN_TYPE_MOD,
	LEXER_TOKEN_TYPE_L_FLOOR,
	LEXER_TOKEN_TYPE_R_FLOOR,
	LEXER_TOKEN_TYPE_L_CEILING,
	LEXER_TOKEN_TYPE_R_CEILING,
	LEXER_TOKEN_TYPE_ROOT,
	LEXER_TOKEN_TYPE_ROOT_3,
	LEXER_TOKEN_TYPE_ROOT_4,
	LEXER_TOKEN_TYPE_NOT,
	LEXER_TOKEN_TYPE_AND,
	LEXER_TOKEN_TYPE_OR,
	LEXER_TOKEN_TYPE_XOR,
	LEXER_TOKEN_TYPE_IN,
	LEXER_TOKEN_TYPE_NUMBER,
	LEXER_TOKEN_TYPE_SUP_NUMBER,
	LEXER_TOKEN_TYPE_NSUP_NUMBER,
	LEXER_TOKEN_TYPE_SUB_NUMBER,
	LEXER_TOKEN_TYPE_FUNCTION,
	LEXER_TOKEN_TYPE_UNIT,
	LEXER_TOKEN_TYPE_VARIABLE,
	LEXER_TOKEN_TYPE_ASSIGN,
	LEXER_TOKEN_TYPE_L_R_BRACKET,
	LEXER_TOKEN_TYPE_R_R_BRACKET,
	LEXER_TOKEN_TYPE_L_S_BRACKET,
	LEXER_TOKEN_TYPE_R_S_BRACKET,
	LEXER_TOKEN_TYPE_L_C_BRACKET,
	LEXER_TOKEN_TYPE_R_C_BRACKET,
	LEXER_TOKEN_TYPE_ABS,
	LEXER_TOKEN_TYPE_POWER,
	LEXER_TOKEN_TYPE_FACTORIAL,
	LEXER_TOKEN_TYPE_PERCENTAGE,
	LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR
} LexerTokenType;

struct _LexerToken {
	GObject parent_instance;
	LexerTokenPrivate * priv;
	gchar* text;
	guint start_index;
	guint end_index;
	LexerTokenType type;
};

struct _LexerTokenClass {
	GObjectClass parent_class;
};

struct _LRNode {
	ParseNode parent_instance;
	LRNodePrivate * priv;
};

struct _LRNodeClass {
	ParseNodeClass parent_class;
	Number* (*solve_lr) (LRNode* self, Number* left, Number* r);
};

struct _ConstantNode {
	ParseNode parent_instance;
	ConstantNodePrivate * priv;
};

struct _ConstantNodeClass {
	ParseNodeClass parent_class;
};

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Parser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ParserPrivate * priv;
	gint number_base;
	gint wordlen;
	AngleUnit angle_units;
};

struct _ParserClass {
	GTypeClass parent_class;
	void (*finalize) (Parser *self);
	gboolean (*variable_is_defined) (Parser* self, const gchar* name);
	Number* (*get_variable) (Parser* self, const gchar* name);
	void (*set_variable) (Parser* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Parser* self, const gchar* name);
	gboolean (*unit_is_defined) (Parser* self, const gchar* name);
	Number* (*convert) (Parser* self, Number* x, const gchar* x_units, const gchar* z_units);
};

struct _AssignNode {
	RNode parent_instance;
	AssignNodePrivate * priv;
};

struct _AssignNodeClass {
	RNodeClass parent_class;
};

struct _AssignFunctionNode {
	ParseNode parent_instance;
	AssignFunctionNodePrivate * priv;
};

struct _AssignFunctionNodeClass {
	ParseNodeClass parent_class;
};

struct _NameNode {
	ParseNode parent_instance;
	NameNodePrivate * priv;
};

struct _NameNodeClass {
	ParseNodeClass parent_class;
};

struct _VariableNode {
	ParseNode parent_instance;
	VariableNodePrivate * priv;
};

struct _VariableNodeClass {
	ParseNodeClass parent_class;
};

struct _VariableWithPowerNode {
	ParseNode parent_instance;
	VariableWithPowerNodePrivate * priv;
};

struct _VariableWithPowerNodeClass {
	ParseNodeClass parent_class;
};

struct _FunctionNameNode {
	NameNode parent_instance;
	FunctionNameNodePrivate * priv;
};

struct _FunctionNameNodeClass {
	NameNodeClass parent_class;
};

struct _FunctionArgumentsNode {
	NameNode parent_instance;
	FunctionArgumentsNodePrivate * priv;
};

struct _FunctionArgumentsNodeClass {
	NameNodeClass parent_class;
};

struct _FunctionDescriptionNode {
	NameNode parent_instance;
	FunctionDescriptionNodePrivate * priv;
};

struct _FunctionDescriptionNodeClass {
	NameNodeClass parent_class;
};

struct _FunctionNode {
	ParseNode parent_instance;
	FunctionNodePrivate * priv;
};

struct _FunctionNodeClass {
	ParseNodeClass parent_class;
};

struct _UnaryMinusNode {
	RNode parent_instance;
	UnaryMinusNodePrivate * priv;
};

struct _UnaryMinusNodeClass {
	RNodeClass parent_class;
};

struct _AbsoluteValueNode {
	RNode parent_instance;
	AbsoluteValueNodePrivate * priv;
};

struct _AbsoluteValueNodeClass {
	RNodeClass parent_class;
};

struct _FloorNode {
	RNode parent_instance;
	FloorNodePrivate * priv;
};

struct _FloorNodeClass {
	RNodeClass parent_class;
};

struct _CeilingNode {
	RNode parent_instance;
	CeilingNodePrivate * priv;
};

struct _CeilingNodeClass {
	RNodeClass parent_class;
};

struct _FractionalComponentNode {
	RNode parent_instance;
	FractionalComponentNodePrivate * priv;
};

struct _FractionalComponentNodeClass {
	RNodeClass parent_class;
};

struct _RoundNode {
	RNode parent_instance;
	RoundNodePrivate * priv;
};

struct _RoundNodeClass {
	RNodeClass parent_class;
};

struct _PercentNode {
	RNode parent_instance;
	PercentNodePrivate * priv;
};

struct _PercentNodeClass {
	RNodeClass parent_class;
};

struct _FactorialNode {
	RNode parent_instance;
	FactorialNodePrivate * priv;
};

struct _FactorialNodeClass {
	RNodeClass parent_class;
};

struct _AddNode {
	LRNode parent_instance;
	AddNodePrivate * priv;
	gboolean do_percentage;
};

struct _AddNodeClass {
	LRNodeClass parent_class;
};

struct _SubtractNode {
	LRNode parent_instance;
	SubtractNodePrivate * priv;
	gboolean do_percentage;
};

struct _SubtractNodeClass {
	LRNodeClass parent_class;
};

struct _MultiplyNode {
	LRNode parent_instance;
	MultiplyNodePrivate * priv;
};

struct _MultiplyNodeClass {
	LRNodeClass parent_class;
};

struct _DivideNode {
	LRNode parent_instance;
	DivideNodePrivate * priv;
};

struct _DivideNodeClass {
	LRNodeClass parent_class;
};

struct _ModulusDivideNode {
	LRNode parent_instance;
	ModulusDivideNodePrivate * priv;
};

struct _ModulusDivideNodeClass {
	LRNodeClass parent_class;
};

struct _RootNode {
	RNode parent_instance;
	RootNodePrivate * priv;
};

struct _RootNodeClass {
	RNodeClass parent_class;
};

struct _RootNodePrivate {
	gint n;
	LexerToken* token_n;
};

struct _XPowYNode {
	LRNode parent_instance;
	XPowYNodePrivate * priv;
};

struct _XPowYNodeClass {
	LRNodeClass parent_class;
};

struct _XPowYIntegerNode {
	ParseNode parent_instance;
	XPowYIntegerNodePrivate * priv;
};

struct _XPowYIntegerNodeClass {
	ParseNodeClass parent_class;
};

struct _NotNode {
	RNode parent_instance;
	NotNodePrivate * priv;
};

struct _NotNodeClass {
	RNodeClass parent_class;
};

struct _AndNode {
	LRNode parent_instance;
	AndNodePrivate * priv;
};

struct _AndNodeClass {
	LRNodeClass parent_class;
};

struct _OrNode {
	LRNode parent_instance;
	OrNodePrivate * priv;
};

struct _OrNodeClass {
	LRNodeClass parent_class;
};

struct _XorNode {
	LRNode parent_instance;
	XorNodePrivate * priv;
};

struct _XorNodeClass {
	LRNodeClass parent_class;
};

struct _ConvertNode {
	LRNode parent_instance;
	ConvertNodePrivate * priv;
};

struct _ConvertNodeClass {
	LRNodeClass parent_class;
};

struct _ConvertBaseNode {
	ParseNode parent_instance;
	ConvertBaseNodePrivate * priv;
};

struct _ConvertBaseNodeClass {
	ParseNodeClass parent_class;
};

struct _ConvertNumberNode {
	ParseNode parent_instance;
	ConvertNumberNodePrivate * priv;
};

struct _ConvertNumberNodeClass {
	ParseNodeClass parent_class;
};

struct _ParserPrivate {
	gchar* input;
	ParseNode* root;
	ParseNode* right_most;
	Lexer* lexer;
	guint depth_level;
	ErrorCode error;
	gchar* error_token;
	gint error_token_start;
	gint error_token_end;
	guint representation_base;
};

struct _ParamSpecParser {
	GParamSpec parent_instance;
};


static gpointer parse_node_parent_class = NULL;
static gpointer rnode_parent_class = NULL;
static gpointer lr_node_parent_class = NULL;
static gpointer constant_node_parent_class = NULL;
static gpointer assign_node_parent_class = NULL;
static gpointer assign_function_node_parent_class = NULL;
static gpointer name_node_parent_class = NULL;
static gpointer variable_node_parent_class = NULL;
static gpointer variable_with_power_node_parent_class = NULL;
static gpointer function_name_node_parent_class = NULL;
static gpointer function_arguments_node_parent_class = NULL;
static gpointer function_description_node_parent_class = NULL;
static gpointer function_node_parent_class = NULL;
static gpointer unary_minus_node_parent_class = NULL;
static gpointer absolute_value_node_parent_class = NULL;
static gpointer floor_node_parent_class = NULL;
static gpointer ceiling_node_parent_class = NULL;
static gpointer fractional_component_node_parent_class = NULL;
static gpointer round_node_parent_class = NULL;
static gpointer percent_node_parent_class = NULL;
static gpointer factorial_node_parent_class = NULL;
static gpointer add_node_parent_class = NULL;
static gpointer subtract_node_parent_class = NULL;
static gpointer multiply_node_parent_class = NULL;
static gpointer divide_node_parent_class = NULL;
static gpointer modulus_divide_node_parent_class = NULL;
static gpointer root_node_parent_class = NULL;
static gpointer xpow_ynode_parent_class = NULL;
static gpointer xpow_yinteger_node_parent_class = NULL;
static gpointer not_node_parent_class = NULL;
static gpointer and_node_parent_class = NULL;
static gpointer or_node_parent_class = NULL;
static gpointer xor_node_parent_class = NULL;
static gpointer convert_node_parent_class = NULL;
static gpointer convert_base_node_parent_class = NULL;
static gpointer convert_number_node_parent_class = NULL;
static gpointer parser_parent_class = NULL;

GType associativity_get_type (void) G_GNUC_CONST;
GType precedence_get_type (void) G_GNUC_CONST;
GType parse_node_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
gpointer parser_ref (gpointer instance);
void parser_unref (gpointer instance);
GParamSpec* param_spec_parser (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_parser (GValue* value,
                       gpointer v_object);
void value_take_parser (GValue* value,
                        gpointer v_object);
gpointer value_get_parser (const GValue* value);
GType parser_get_type (void) G_GNUC_CONST;
GType lexer_token_get_type (void) G_GNUC_CONST;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
LexerToken* parse_node_token (ParseNode* self);
LexerToken* parse_node_first_token (ParseNode* self);
LexerToken* parse_node_last_token (ParseNode* self);
ParseNode* parse_node_new_WithList (Parser* parser,
                                    GList* token_list,
                                    guint precedence,
                                    Associativity associativity,
                                    const gchar* value);
ParseNode* parse_node_construct_WithList (GType object_type,
                                          Parser* parser,
                                          GList* token_list,
                                          guint precedence,
                                          Associativity associativity,
                                          const gchar* value);
ParseNode* parse_node_new (Parser* parser,
                           LexerToken* token,
                           guint precedence,
                           Associativity associativity,
                           const gchar* value);
ParseNode* parse_node_construct (GType object_type,
                                 Parser* parser,
                                 LexerToken* token,
                                 guint precedence,
                                 Associativity associativity,
                                 const gchar* value);
Number* parse_node_solve (ParseNode* self);
static Number* parse_node_real_solve (ParseNode* self);
static void parse_node_finalize (GObject * obj);
GType rnode_get_type (void) G_GNUC_CONST;
RNode* rnode_construct (GType object_type,
                        Parser* parser,
                        LexerToken* token,
                        guint precedence,
                        Associativity associativity);
static Number* rnode_real_solve (ParseNode* base);
Number* rnode_solve_r (RNode* self,
                       Number* r);
void number_check_flags (void);
const gchar* number_get_error (void);
GType error_code_get_type (void) G_GNUC_CONST;
void parser_set_error (Parser* self,
                       ErrorCode errorno,
                       const gchar* token,
                       guint token_start,
                       guint token_end);
GType lexer_token_type_get_type (void) G_GNUC_CONST;
void number_set_error (const gchar* value);
static Number* rnode_real_solve_r (RNode* self,
                            Number* r);
GType lr_node_get_type (void) G_GNUC_CONST;
LRNode* lr_node_construct (GType object_type,
                           Parser* parser,
                           LexerToken* token,
                           guint precedence,
                           Associativity associativity);
static Number* lr_node_real_solve (ParseNode* base);
Number* lr_node_solve_lr (LRNode* self,
                          Number* left,
                          Number* r);
static Number* lr_node_real_solve_lr (LRNode* self,
                               Number* left,
                               Number* r);
GType constant_node_get_type (void) G_GNUC_CONST;
ConstantNode* constant_node_new (Parser* parser,
                                 LexerToken* token,
                                 guint precedence,
                                 Associativity associativity);
ConstantNode* constant_node_construct (GType object_type,
                                       Parser* parser,
                                       LexerToken* token,
                                       guint precedence,
                                       Associativity associativity);
static Number* constant_node_real_solve (ParseNode* base);
Number* mp_set_from_string (const gchar* str,
                            gint default_base);
GType angle_unit_get_type (void) G_GNUC_CONST;
GType assign_node_get_type (void) G_GNUC_CONST;
AssignNode* assign_node_new (Parser* parser,
                             LexerToken* token,
                             guint precedence,
                             Associativity associativity);
AssignNode* assign_node_construct (GType object_type,
                                   Parser* parser,
                                   LexerToken* token,
                                   guint precedence,
                                   Associativity associativity);
static Number* assign_node_real_solve_r (RNode* base,
                                  Number* r);
void parser_set_variable (Parser* self,
                          const gchar* name,
                          Number* x);
GType assign_function_node_get_type (void) G_GNUC_CONST;
AssignFunctionNode* assign_function_node_new (Parser* parser,
                                              LexerToken* token,
                                              guint precedence,
                                              Associativity associativity);
AssignFunctionNode* assign_function_node_construct (GType object_type,
                                                    Parser* parser,
                                                    LexerToken* token,
                                                    guint precedence,
                                                    Associativity associativity);
static Number* assign_function_node_real_solve (ParseNode* base);
GType function_manager_get_type (void) G_GNUC_CONST;
FunctionManager* function_manager_get_default_function_manager (void);
gboolean function_manager_add_function_with_properties (FunctionManager* self,
                                                        const gchar* name,
                                                        const gchar* arguments,
                                                        const gchar* description,
                                                        Parser* root_parser);
Number* number_new_integer (gint64 real,
                            gint64 imag);
Number* number_construct_integer (GType object_type,
                                  gint64 real,
                                  gint64 imag);
GType name_node_get_type (void) G_GNUC_CONST;
NameNode* name_node_new (Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity,
                         const gchar* text);
NameNode* name_node_construct (GType object_type,
                               Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity,
                               const gchar* text);
GType variable_node_get_type (void) G_GNUC_CONST;
VariableNode* variable_node_new (Parser* parser,
                                 LexerToken* token,
                                 guint precedence,
                                 Associativity associativity);
VariableNode* variable_node_construct (GType object_type,
                                       Parser* parser,
                                       LexerToken* token,
                                       guint precedence,
                                       Associativity associativity);
static Number* variable_node_real_solve (ParseNode* base);
Number* parser_get_variable (Parser* self,
                             const gchar* name);
Number* number_multiply (Number* self,
                         Number* y);
GType variable_with_power_node_get_type (void) G_GNUC_CONST;
VariableWithPowerNode* variable_with_power_node_new (Parser* parser,
                                                     LexerToken* token,
                                                     guint precedence,
                                                     Associativity associativity,
                                                     const gchar* text);
VariableWithPowerNode* variable_with_power_node_construct (GType object_type,
                                                           Parser* parser,
                                                           LexerToken* token,
                                                           guint precedence,
                                                           Associativity associativity,
                                                           const gchar* text);
static Number* variable_with_power_node_real_solve (ParseNode* base);
gint super_atoi (const gchar* data);
Number* number_xpowy_integer (Number* self,
                              gint64 n);
GType function_name_node_get_type (void) G_GNUC_CONST;
FunctionNameNode* function_name_node_new (Parser* parser,
                                          LexerToken* token,
                                          guint precedence,
                                          Associativity associativity,
                                          const gchar* name);
FunctionNameNode* function_name_node_construct (GType object_type,
                                                Parser* parser,
                                                LexerToken* token,
                                                guint precedence,
                                                Associativity associativity,
                                                const gchar* name);
GType function_arguments_node_get_type (void) G_GNUC_CONST;
FunctionArgumentsNode* function_arguments_node_new (Parser* parser,
                                                    GList* token_list,
                                                    guint precedence,
                                                    Associativity associativity,
                                                    const gchar* arguments);
FunctionArgumentsNode* function_arguments_node_construct (GType object_type,
                                                          Parser* parser,
                                                          GList* token_list,
                                                          guint precedence,
                                                          Associativity associativity,
                                                          const gchar* arguments);
GType function_description_node_get_type (void) G_GNUC_CONST;
FunctionDescriptionNode* function_description_node_new (Parser* parser,
                                                        LexerToken* token,
                                                        guint precedence,
                                                        Associativity associativity,
                                                        const gchar* description);
FunctionDescriptionNode* function_description_node_construct (GType object_type,
                                                              Parser* parser,
                                                              LexerToken* token,
                                                              guint precedence,
                                                              Associativity associativity,
                                                              const gchar* description);
GType function_node_get_type (void) G_GNUC_CONST;
FunctionNode* function_node_new (Parser* parser,
                                 LexerToken* token,
                                 guint precedence,
                                 Associativity associativity,
                                 const gchar* text);
FunctionNode* function_node_construct (GType object_type,
                                       Parser* parser,
                                       LexerToken* token,
                                       guint precedence,
                                       Associativity associativity,
                                       const gchar* text);
static Number* function_node_real_solve (ParseNode* base);
GType expression_parser_get_type (void) G_GNUC_CONST;
ExpressionParser* expression_parser_new (const gchar* expression,
                                         Parser* root_parser);
ExpressionParser* expression_parser_construct (GType object_type,
                                               const gchar* expression,
                                               Parser* root_parser);
Number* parser_parse (Parser* self,
                      guint* representation_base,
                      ErrorCode* error_code,
                      gchar* * error_token,
                      guint* error_start,
                      guint* error_end);
static void _vala_array_add1 (Number** * array,
                       int* length,
                       int* size,
                       Number* value);
static void _vala_array_add2 (Number** * array,
                       int* length,
                       int* size,
                       Number* value);
Number* function_manager_evaluate_function (FunctionManager* self,
                                            const gchar* name,
                                            Number** arguments,
                                            int arguments_length1,
                                            Parser* parser);
GType unary_minus_node_get_type (void) G_GNUC_CONST;
UnaryMinusNode* unary_minus_node_new (Parser* parser,
                                      LexerToken* token,
                                      guint precedence,
                                      Associativity associativity);
UnaryMinusNode* unary_minus_node_construct (GType object_type,
                                            Parser* parser,
                                            LexerToken* token,
                                            guint precedence,
                                            Associativity associativity);
static Number* unary_minus_node_real_solve_r (RNode* base,
                                       Number* r);
Number* number_invert_sign (Number* self);
GType absolute_value_node_get_type (void) G_GNUC_CONST;
AbsoluteValueNode* absolute_value_node_new (Parser* parser,
                                            LexerToken* token,
                                            guint precedence,
                                            Associativity associativity);
AbsoluteValueNode* absolute_value_node_construct (GType object_type,
                                                  Parser* parser,
                                                  LexerToken* token,
                                                  guint precedence,
                                                  Associativity associativity);
static Number* absolute_value_node_real_solve_r (RNode* base,
                                          Number* r);
Number* number_abs (Number* self);
GType floor_node_get_type (void) G_GNUC_CONST;
FloorNode* floor_node_new (Parser* parser,
                           LexerToken* token,
                           guint precedence,
                           Associativity associativity);
FloorNode* floor_node_construct (GType object_type,
                                 Parser* parser,
                                 LexerToken* token,
                                 guint precedence,
                                 Associativity associativity);
static Number* floor_node_real_solve_r (RNode* base,
                                 Number* r);
Number* number_floor (Number* self);
GType ceiling_node_get_type (void) G_GNUC_CONST;
CeilingNode* ceiling_node_new (Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity);
CeilingNode* ceiling_node_construct (GType object_type,
                                     Parser* parser,
                                     LexerToken* token,
                                     guint precedence,
                                     Associativity associativity);
static Number* ceiling_node_real_solve_r (RNode* base,
                                   Number* r);
Number* number_ceiling (Number* self);
GType fractional_component_node_get_type (void) G_GNUC_CONST;
FractionalComponentNode* fractional_component_node_new (Parser* parser,
                                                        LexerToken* token,
                                                        guint precedence,
                                                        Associativity associativity);
FractionalComponentNode* fractional_component_node_construct (GType object_type,
                                                              Parser* parser,
                                                              LexerToken* token,
                                                              guint precedence,
                                                              Associativity associativity);
static Number* fractional_component_node_real_solve_r (RNode* base,
                                                Number* r);
Number* number_fractional_part (Number* self);
GType round_node_get_type (void) G_GNUC_CONST;
RoundNode* round_node_new (Parser* parser,
                           LexerToken* token,
                           guint precedence,
                           Associativity associativity);
RoundNode* round_node_construct (GType object_type,
                                 Parser* parser,
                                 LexerToken* token,
                                 guint precedence,
                                 Associativity associativity);
static Number* round_node_real_solve_r (RNode* base,
                                 Number* r);
Number* number_round (Number* self);
GType percent_node_get_type (void) G_GNUC_CONST;
PercentNode* percent_node_new (Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity);
PercentNode* percent_node_construct (GType object_type,
                                     Parser* parser,
                                     LexerToken* token,
                                     guint precedence,
                                     Associativity associativity);
static Number* percent_node_real_solve_r (RNode* base,
                                   Number* r);
Number* number_divide_integer (Number* self,
                               gint64 y);
GType factorial_node_get_type (void) G_GNUC_CONST;
FactorialNode* factorial_node_new (Parser* parser,
                                   LexerToken* token,
                                   guint precedence,
                                   Associativity associativity);
FactorialNode* factorial_node_construct (GType object_type,
                                         Parser* parser,
                                         LexerToken* token,
                                         guint precedence,
                                         Associativity associativity);
static Number* factorial_node_real_solve_r (RNode* base,
                                     Number* r);
Number* number_factorial (Number* self);
GType add_node_get_type (void) G_GNUC_CONST;
AddNode* add_node_new (Parser* parser,
                       LexerToken* token,
                       guint precedence,
                       Associativity associativity);
AddNode* add_node_construct (GType object_type,
                             Parser* parser,
                             LexerToken* token,
                             guint precedence,
                             Associativity associativity);
static Number* add_node_real_solve_lr (LRNode* base,
                                Number* l,
                                Number* r);
Number* number_add (Number* self,
                    Number* y);
static void add_node_finalize (GObject * obj);
GType subtract_node_get_type (void) G_GNUC_CONST;
SubtractNode* subtract_node_new (Parser* parser,
                                 LexerToken* token,
                                 guint precedence,
                                 Associativity associativity);
SubtractNode* subtract_node_construct (GType object_type,
                                       Parser* parser,
                                       LexerToken* token,
                                       guint precedence,
                                       Associativity associativity);
static Number* subtract_node_real_solve_lr (LRNode* base,
                                     Number* l,
                                     Number* r);
Number* number_subtract (Number* self,
                         Number* y);
static void subtract_node_finalize (GObject * obj);
GType multiply_node_get_type (void) G_GNUC_CONST;
MultiplyNode* multiply_node_new (Parser* parser,
                                 LexerToken* token,
                                 guint precedence,
                                 Associativity associativity);
MultiplyNode* multiply_node_construct (GType object_type,
                                       Parser* parser,
                                       LexerToken* token,
                                       guint precedence,
                                       Associativity associativity);
static Number* multiply_node_real_solve_lr (LRNode* base,
                                     Number* l,
                                     Number* r);
GType divide_node_get_type (void) G_GNUC_CONST;
DivideNode* divide_node_new (Parser* parser,
                             LexerToken* token,
                             guint precedence,
                             Associativity associativity);
DivideNode* divide_node_construct (GType object_type,
                                   Parser* parser,
                                   LexerToken* token,
                                   guint precedence,
                                   Associativity associativity);
static Number* divide_node_real_solve_lr (LRNode* base,
                                   Number* l,
                                   Number* r);
Number* number_divide (Number* self,
                       Number* y);
GType modulus_divide_node_get_type (void) G_GNUC_CONST;
ModulusDivideNode* modulus_divide_node_new (Parser* parser,
                                            LexerToken* token,
                                            guint precedence,
                                            Associativity associativity);
ModulusDivideNode* modulus_divide_node_construct (GType object_type,
                                                  Parser* parser,
                                                  LexerToken* token,
                                                  guint precedence,
                                                  Associativity associativity);
static Number* modulus_divide_node_real_solve (ParseNode* base);
GType xpow_ynode_get_type (void) G_GNUC_CONST;
Number* number_modular_exponentiation (Number* self,
                                       Number* exp,
                                       Number* mod);
static Number* modulus_divide_node_real_solve_lr (LRNode* base,
                                           Number* l,
                                           Number* r);
Number* number_modulus_divide (Number* self,
                               Number* y);
GType root_node_get_type (void) G_GNUC_CONST;
#define ROOT_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ROOT_NODE, RootNodePrivate))
RootNode* root_node_new (Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity,
                         gint n);
RootNode* root_node_construct (GType object_type,
                               Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity,
                               gint n);
RootNode* root_node_new_WithToken (Parser* parser,
                                   LexerToken* token,
                                   guint precedence,
                                   Associativity associativity,
                                   LexerToken* token_n);
RootNode* root_node_construct_WithToken (GType object_type,
                                         Parser* parser,
                                         LexerToken* token,
                                         guint precedence,
                                         Associativity associativity,
                                         LexerToken* token_n);
static Number* root_node_real_solve_r (RNode* base,
                                Number* r);
gint sub_atoi (const gchar* data);
Number* number_root (Number* self,
                     gint64 n);
static void root_node_finalize (GObject * obj);
XPowYNode* xpow_ynode_new (Parser* parser,
                           LexerToken* token,
                           guint precedence,
                           Associativity associativity);
XPowYNode* xpow_ynode_construct (GType object_type,
                                 Parser* parser,
                                 LexerToken* token,
                                 guint precedence,
                                 Associativity associativity);
static Number* xpow_ynode_real_solve_lr (LRNode* base,
                                  Number* l,
                                  Number* r);
Number* number_xpowy (Number* self,
                      Number* y);
GType xpow_yinteger_node_get_type (void) G_GNUC_CONST;
XPowYIntegerNode* xpow_yinteger_node_new (Parser* parser,
                                          LexerToken* token,
                                          guint precedence,
                                          Associativity associativity);
XPowYIntegerNode* xpow_yinteger_node_construct (GType object_type,
                                                Parser* parser,
                                                LexerToken* token,
                                                guint precedence,
                                                Associativity associativity);
static Number* xpow_yinteger_node_real_solve (ParseNode* base);
gint64 number_to_integer (Number* self);
GType not_node_get_type (void) G_GNUC_CONST;
NotNode* not_node_new (Parser* parser,
                       LexerToken* token,
                       guint precedence,
                       Associativity associativity);
NotNode* not_node_construct (GType object_type,
                             Parser* parser,
                             LexerToken* token,
                             guint precedence,
                             Associativity associativity);
static Number* not_node_real_solve_r (RNode* base,
                               Number* r);
gboolean mp_is_overflow (Number* x,
                         gint wordlen);
Number* number_not (Number* self,
                    gint wordlen);
GType and_node_get_type (void) G_GNUC_CONST;
AndNode* and_node_new (Parser* parser,
                       LexerToken* token,
                       guint precedence,
                       Associativity associativity);
AndNode* and_node_construct (GType object_type,
                             Parser* parser,
                             LexerToken* token,
                             guint precedence,
                             Associativity associativity);
static Number* and_node_real_solve_lr (LRNode* base,
                                Number* l,
                                Number* r);
Number* number_and (Number* self,
                    Number* y);
GType or_node_get_type (void) G_GNUC_CONST;
OrNode* or_node_new (Parser* parser,
                     LexerToken* token,
                     guint precedence,
                     Associativity associativity);
OrNode* or_node_construct (GType object_type,
                           Parser* parser,
                           LexerToken* token,
                           guint precedence,
                           Associativity associativity);
static Number* or_node_real_solve_lr (LRNode* base,
                               Number* l,
                               Number* r);
Number* number_or (Number* self,
                   Number* y);
GType xor_node_get_type (void) G_GNUC_CONST;
XorNode* xor_node_new (Parser* parser,
                       LexerToken* token,
                       guint precedence,
                       Associativity associativity);
XorNode* xor_node_construct (GType object_type,
                             Parser* parser,
                             LexerToken* token,
                             guint precedence,
                             Associativity associativity);
static Number* xor_node_real_solve_lr (LRNode* base,
                                Number* l,
                                Number* r);
Number* number_xor (Number* self,
                    Number* y);
GType convert_node_get_type (void) G_GNUC_CONST;
ConvertNode* convert_node_new (Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity);
ConvertNode* convert_node_construct (GType object_type,
                                     Parser* parser,
                                     LexerToken* token,
                                     guint precedence,
                                     Associativity associativity);
static Number* convert_node_real_solve_lr (LRNode* base,
                                    Number* l,
                                    Number* r);
Number* parser_convert (Parser* self,
                        Number* x,
                        const gchar* x_units,
                        const gchar* z_units);
GType convert_base_node_get_type (void) G_GNUC_CONST;
ConvertBaseNode* convert_base_node_new (Parser* parser,
                                        LexerToken* token,
                                        guint precedence,
                                        Associativity associativity,
                                        const gchar* value);
ConvertBaseNode* convert_base_node_construct (GType object_type,
                                              Parser* parser,
                                              LexerToken* token,
                                              guint precedence,
                                              Associativity associativity,
                                              const gchar* value);
static Number* convert_base_node_real_solve (ParseNode* base);
void parser_set_representation_base (Parser* self,
                                     guint new_base);
GType convert_number_node_get_type (void) G_GNUC_CONST;
ConvertNumberNode* convert_number_node_new (Parser* parser,
                                            LexerToken* token,
                                            guint precedence,
                                            Associativity associativity);
ConvertNumberNode* convert_number_node_construct (GType object_type,
                                                  Parser* parser,
                                                  LexerToken* token,
                                                  guint precedence,
                                                  Associativity associativity);
static Number* convert_number_node_real_solve (ParseNode* base);
GType lexer_get_type (void) G_GNUC_CONST;
#define PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PARSER, ParserPrivate))
Parser* parser_new (const gchar* input,
                    gint number_base,
                    gint wordlen,
                    AngleUnit angle_units);
Parser* parser_construct (GType object_type,
                          const gchar* input,
                          gint number_base,
                          gint wordlen,
                          AngleUnit angle_units);
Lexer* lexer_new (const gchar* input,
                  Parser* parser,
                  gint number_base);
Lexer* lexer_construct (GType object_type,
                        const gchar* input,
                        Parser* parser,
                        gint number_base);
gboolean parser_create_parse_tree (Parser* self,
                                   guint* representation_base,
                                   ErrorCode* error_code,
                                   gchar* * error_token,
                                   guint* error_start,
                                   guint* error_end);
void lexer_scan (Lexer* self);
static gboolean parser_statement (Parser* self);
LexerToken* lexer_get_next_token (Lexer* self);
gboolean parser_variable_is_defined (Parser* self,
                                     const gchar* name);
static gboolean parser_real_variable_is_defined (Parser* self,
                                          const gchar* name);
static Number* parser_real_get_variable (Parser* self,
                                  const gchar* name);
static void parser_real_set_variable (Parser* self,
                               const gchar* name,
                               Number* x);
gboolean parser_function_is_defined (Parser* self,
                                     const gchar* name);
static gboolean parser_real_function_is_defined (Parser* self,
                                          const gchar* name);
gboolean parser_unit_is_defined (Parser* self,
                                 const gchar* name);
static gboolean parser_real_unit_is_defined (Parser* self,
                                      const gchar* name);
static Number* parser_real_convert (Parser* self,
                             Number* x,
                             const gchar* x_units,
                             const gchar* z_units);
static Precedence parser_get_precedence (Parser* self,
                                  LexerTokenType type);
static Associativity parser_get_associativity_p (Parser* self,
                                          Precedence type);
static Associativity parser_get_associativity (Parser* self,
                                        LexerToken* token);
static guint parser_make_precedence_p (Parser* self,
                                Precedence p);
static guint parser_make_precedence_t (Parser* self,
                                LexerTokenType type);
static gboolean parser_cmp_nodes (Parser* self,
                           ParseNode* left,
                           ParseNode* right);
static void parser_insert_into_tree_all (Parser* self,
                                  ParseNode* node,
                                  gboolean unary_function);
static void parser_insert_into_tree (Parser* self,
                              ParseNode* node);
static void parser_insert_into_tree_unary (Parser* self,
                                    ParseNode* node);
static void parser_destroy_all_nodes (Parser* self,
                               ParseNode* node);
static gboolean parser_check_variable (Parser* self,
                                const gchar* name);
static gboolean parser_expression (Parser* self);
void lexer_roll_back (Lexer* self);
static gboolean parser_function_definition (Parser* self);
static gboolean parser_conversion (Parser* self);
static gboolean parser_expression_1 (Parser* self);
static gboolean parser_expression_2 (Parser* self);
static gboolean parser_variable (Parser* self);
static gboolean parser_function_invocation (Parser* self);
static gboolean parser_term (Parser* self);
static gboolean parser_term_2 (Parser* self);
static void parser_finalize (Parser * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType
associativity_get_type (void)
{
	static volatile gsize associativity_type_id__volatile = 0;
	if (g_once_init_enter (&associativity_type_id__volatile)) {
		static const GEnumValue values[] = {{ASSOCIATIVITY_LEFT, "ASSOCIATIVITY_LEFT", "left"}, {ASSOCIATIVITY_RIGHT, "ASSOCIATIVITY_RIGHT", "right"}, {0, NULL, NULL}};
		GType associativity_type_id;
		associativity_type_id = g_enum_register_static ("Associativity", values);
		g_once_init_leave (&associativity_type_id__volatile, associativity_type_id);
	}
	return associativity_type_id__volatile;
}


GType
precedence_get_type (void)
{
	static volatile gsize precedence_type_id__volatile = 0;
	if (g_once_init_enter (&precedence_type_id__volatile)) {
		static const GEnumValue values[] = {{PRECEDENCE_UNKNOWN, "PRECEDENCE_UNKNOWN", "unknown"}, {PRECEDENCE_CONVERT, "PRECEDENCE_CONVERT", "convert"}, {PRECEDENCE_UNIT, "PRECEDENCE_UNIT", "unit"}, {PRECEDENCE_TOP, "PRECEDENCE_TOP", "top"}, {PRECEDENCE_ADD_SUBTRACT, "PRECEDENCE_ADD_SUBTRACT", "add-subtract"}, {PRECEDENCE_MULTIPLY, "PRECEDENCE_MULTIPLY", "multiply"}, {PRECEDENCE_MOD, "PRECEDENCE_MOD", "mod"}, {PRECEDENCE_DIVIDE, "PRECEDENCE_DIVIDE", "divide"}, {PRECEDENCE_NOT, "PRECEDENCE_NOT", "not"}, {PRECEDENCE_FUNCTION, "PRECEDENCE_FUNCTION", "function"}, {PRECEDENCE_BOOLEAN, "PRECEDENCE_BOOLEAN", "boolean"}, {PRECEDENCE_PERCENTAGE, "PRECEDENCE_PERCENTAGE", "percentage"}, {PRECEDENCE_UNARY_MINUS, "PRECEDENCE_UNARY_MINUS", "unary-minus"}, {PRECEDENCE_POWER, "PRECEDENCE_POWER", "power"}, {PRECEDENCE_ROOT, "PRECEDENCE_ROOT", "root"}, {PRECEDENCE_FACTORIAL, "PRECEDENCE_FACTORIAL", "factorial"}, {PRECEDENCE_NUMBER_VARIABLE, "PRECEDENCE_NUMBER_VARIABLE", "number-variable"}, {PRECEDENCE_DEPTH, "PRECEDENCE_DEPTH", "depth"}, {0, NULL, NULL}};
		GType precedence_type_id;
		precedence_type_id = g_enum_register_static ("Precedence", values);
		g_once_init_leave (&precedence_type_id__volatile, precedence_type_id);
	}
	return precedence_type_id__volatile;
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


LexerToken*
parse_node_token (ParseNode* self)
{
	LexerToken* result = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	LexerToken* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->token_list;
	_vala_assert (g_list_length (_tmp0_) == ((guint) 1), "token_list.length() == 1");
	_tmp1_ = self->token_list;
	_tmp2_ = g_list_first (_tmp1_);
	_tmp3_ = _tmp2_->data;
	_tmp4_ = _g_object_ref0 ((LexerToken*) _tmp3_);
	result = _tmp4_;
	return result;
}


LexerToken*
parse_node_first_token (ParseNode* self)
{
	LexerToken* result = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	LexerToken* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->token_list;
	_tmp1_ = g_list_first (_tmp0_);
	_tmp2_ = _tmp1_->data;
	_tmp3_ = _g_object_ref0 ((LexerToken*) _tmp2_);
	result = _tmp3_;
	return result;
}


LexerToken*
parse_node_last_token (ParseNode* self)
{
	LexerToken* result = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	LexerToken* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->token_list;
	_tmp1_ = g_list_last (_tmp0_);
	_tmp2_ = _tmp1_->data;
	_tmp3_ = _g_object_ref0 ((LexerToken*) _tmp2_);
	result = _tmp3_;
	return result;
}


static gpointer
_parser_ref0 (gpointer self)
{
	return self ? parser_ref (self) : NULL;
}


ParseNode*
parse_node_construct_WithList (GType object_type,
                               Parser* parser,
                               GList* token_list,
                               guint precedence,
                               Associativity associativity,
                               const gchar* value)
{
	ParseNode * self = NULL;
	Parser* _tmp0_;
	GList* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ParseNode*) g_object_new (object_type, NULL);
	_tmp0_ = _parser_ref0 (parser);
	_parser_unref0 (self->parser);
	self->parser = _tmp0_;
	_tmp1_ = g_list_copy (token_list);
	__g_list_free__g_object_unref0_0 (self->token_list);
	self->token_list = _tmp1_;
	self->precedence = precedence;
	self->associativity = associativity;
	_tmp2_ = g_strdup (value);
	_g_free0 (self->value);
	self->value = _tmp2_;
	return self;
}


ParseNode*
parse_node_new_WithList (Parser* parser,
                         GList* token_list,
                         guint precedence,
                         Associativity associativity,
                         const gchar* value)
{
	return parse_node_construct_WithList (TYPE_PARSE_NODE, parser, token_list, precedence, associativity, value);
}


ParseNode*
parse_node_construct (GType object_type,
                      Parser* parser,
                      LexerToken* token,
                      guint precedence,
                      Associativity associativity,
                      const gchar* value)
{
	ParseNode * self = NULL;
	Parser* _tmp0_;
	LexerToken* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ParseNode*) g_object_new (object_type, NULL);
	_tmp0_ = _parser_ref0 (parser);
	_parser_unref0 (self->parser);
	self->parser = _tmp0_;
	__g_list_free__g_object_unref0_0 (self->token_list);
	self->token_list = NULL;
	_tmp1_ = _g_object_ref0 (token);
	self->token_list = g_list_insert (self->token_list, _tmp1_, 0);
	self->precedence = precedence;
	self->associativity = associativity;
	_tmp2_ = g_strdup (value);
	_g_free0 (self->value);
	self->value = _tmp2_;
	return self;
}


ParseNode*
parse_node_new (Parser* parser,
                LexerToken* token,
                guint precedence,
                Associativity associativity,
                const gchar* value)
{
	return parse_node_construct (TYPE_PARSE_NODE, parser, token, precedence, associativity, value);
}


static Number*
parse_node_real_solve (ParseNode* self)
{
	Number* result = NULL;
	result = NULL;
	return result;
}


Number*
parse_node_solve (ParseNode* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return PARSE_NODE_GET_CLASS (self)->solve (self);
}


static void
parse_node_class_init (ParseNodeClass * klass)
{
	parse_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode *)) parse_node_real_solve;
	G_OBJECT_CLASS (klass)->finalize = parse_node_finalize;
}


static void
parse_node_instance_init (ParseNode * self)
{
	self->parent = NULL;
	self->left = NULL;
	self->right = NULL;
}


static void
parse_node_finalize (GObject * obj)
{
	ParseNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PARSE_NODE, ParseNode);
	_parser_unref0 (self->parser);
	_g_object_unref0 (self->parent);
	_g_object_unref0 (self->left);
	_g_object_unref0 (self->right);
	__g_list_free__g_object_unref0_0 (self->token_list);
	_g_free0 (self->value);
	G_OBJECT_CLASS (parse_node_parent_class)->finalize (obj);
}


GType
parse_node_get_type (void)
{
	static volatile gsize parse_node_type_id__volatile = 0;
	if (g_once_init_enter (&parse_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ParseNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) parse_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ParseNode), 0, (GInstanceInitFunc) parse_node_instance_init, NULL };
		GType parse_node_type_id;
		parse_node_type_id = g_type_register_static (G_TYPE_OBJECT, "ParseNode", &g_define_type_info, 0);
		g_once_init_leave (&parse_node_type_id__volatile, parse_node_type_id);
	}
	return parse_node_type_id__volatile;
}


RNode*
rnode_construct (GType object_type,
                 Parser* parser,
                 LexerToken* token,
                 guint precedence,
                 Associativity associativity)
{
	RNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (RNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}


static Number*
rnode_real_solve (ParseNode* base)
{
	RNode * self;
	Number* result = NULL;
	Number* r = NULL;
	ParseNode* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* z = NULL;
	Number* _tmp3_;
	Number* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	self = (RNode*) base;
	_tmp0_ = ((ParseNode*) self)->right;
	_tmp1_ = parse_node_solve (_tmp0_);
	r = _tmp1_;
	_tmp2_ = r;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (r);
		return result;
	}
	_tmp3_ = r;
	_tmp4_ = rnode_solve_r (self, _tmp3_);
	z = _tmp4_;
	number_check_flags ();
	_tmp5_ = number_get_error ();
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp7_;
		ParseNode* _tmp8_;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp9_;
		ParseNode* _tmp10_;
		Parser* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		ParseNode* _tmp24_;
		LexerToken* _tmp25_;
		LexerToken* _tmp26_;
		guint _tmp27_;
		ParseNode* _tmp28_;
		LexerToken* _tmp29_;
		LexerToken* _tmp30_;
		guint _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp7_ = ((ParseNode*) self)->right;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		tmpleft = _tmp8_;
		_tmp9_ = ((ParseNode*) self)->right;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		tmpright = _tmp10_;
		while (TRUE) {
			ParseNode* _tmp11_;
			ParseNode* _tmp12_;
			ParseNode* _tmp13_;
			ParseNode* _tmp14_;
			ParseNode* _tmp15_;
			_tmp11_ = tmpleft;
			_tmp12_ = _tmp11_->left;
			if (!(_tmp12_ != NULL)) {
				break;
			}
			_tmp13_ = tmpleft;
			_tmp14_ = _tmp13_->left;
			_tmp15_ = _g_object_ref0 (_tmp14_);
			_g_object_unref0 (tmpleft);
			tmpleft = _tmp15_;
		}
		while (TRUE) {
			ParseNode* _tmp16_;
			ParseNode* _tmp17_;
			ParseNode* _tmp18_;
			ParseNode* _tmp19_;
			ParseNode* _tmp20_;
			_tmp16_ = tmpright;
			_tmp17_ = _tmp16_->right;
			if (!(_tmp17_ != NULL)) {
				break;
			}
			_tmp18_ = tmpright;
			_tmp19_ = _tmp18_->right;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (tmpright);
			tmpright = _tmp20_;
		}
		_tmp21_ = ((ParseNode*) self)->parser;
		_tmp22_ = number_get_error ();
		_tmp23_ = _tmp22_;
		_tmp24_ = tmpleft;
		_tmp25_ = parse_node_first_token (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_->start_index;
		_tmp28_ = tmpright;
		_tmp29_ = parse_node_last_token (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_->end_index;
		parser_set_error (_tmp21_, ERROR_CODE_MP, _tmp23_, _tmp27_, _tmp31_);
		_g_object_unref0 (_tmp30_);
		_g_object_unref0 (_tmp26_);
		_tmp32_ = number_get_error ();
		_tmp33_ = _tmp32_;
		number_set_error (NULL);
		_g_object_unref0 (tmpright);
		_g_object_unref0 (tmpleft);
	}
	result = z;
	_g_object_unref0 (r);
	return result;
}


static Number*
rnode_real_solve_r (RNode* self,
                    Number* r)
{
	g_critical ("Type `%s' does not implement abstract method `rnode_solve_r'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


Number*
rnode_solve_r (RNode* self,
               Number* r)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RNODE_GET_CLASS (self)->solve_r (self, r);
}


static void
rnode_class_init (RNodeClass * klass)
{
	rnode_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode *)) rnode_real_solve;
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode *, Number*)) rnode_real_solve_r;
}


static void
rnode_instance_init (RNode * self)
{
}


GType
rnode_get_type (void)
{
	static volatile gsize rnode_type_id__volatile = 0;
	if (g_once_init_enter (&rnode_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rnode_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RNode), 0, (GInstanceInitFunc) rnode_instance_init, NULL };
		GType rnode_type_id;
		rnode_type_id = g_type_register_static (TYPE_PARSE_NODE, "RNode", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rnode_type_id__volatile, rnode_type_id);
	}
	return rnode_type_id__volatile;
}


LRNode*
lr_node_construct (GType object_type,
                   Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity)
{
	LRNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (LRNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}


static Number*
lr_node_real_solve (ParseNode* base)
{
	LRNode * self;
	Number* result = NULL;
	Number* l = NULL;
	ParseNode* _tmp0_;
	Number* _tmp1_;
	Number* r = NULL;
	ParseNode* _tmp2_;
	Number* _tmp3_;
	gboolean _tmp4_ = FALSE;
	Number* _tmp5_;
	Number* z = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	self = (LRNode*) base;
	_tmp0_ = ((ParseNode*) self)->left;
	_tmp1_ = parse_node_solve (_tmp0_);
	l = _tmp1_;
	_tmp2_ = ((ParseNode*) self)->right;
	_tmp3_ = parse_node_solve (_tmp2_);
	r = _tmp3_;
	_tmp5_ = l;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		Number* _tmp6_;
		_tmp6_ = r;
		_tmp4_ = _tmp6_ == NULL;
	}
	if (_tmp4_) {
		result = NULL;
		_g_object_unref0 (r);
		_g_object_unref0 (l);
		return result;
	}
	_tmp7_ = l;
	_tmp8_ = r;
	_tmp9_ = lr_node_solve_lr (self, _tmp7_, _tmp8_);
	z = _tmp9_;
	number_check_flags ();
	_tmp10_ = number_get_error ();
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp12_;
		ParseNode* _tmp13_;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp14_;
		ParseNode* _tmp15_;
		Parser* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		ParseNode* _tmp29_;
		LexerToken* _tmp30_;
		LexerToken* _tmp31_;
		guint _tmp32_;
		ParseNode* _tmp33_;
		LexerToken* _tmp34_;
		LexerToken* _tmp35_;
		guint _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		_tmp12_ = ((ParseNode*) self)->left;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		tmpleft = _tmp13_;
		_tmp14_ = ((ParseNode*) self)->right;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		tmpright = _tmp15_;
		while (TRUE) {
			ParseNode* _tmp16_;
			ParseNode* _tmp17_;
			ParseNode* _tmp18_;
			ParseNode* _tmp19_;
			ParseNode* _tmp20_;
			_tmp16_ = tmpleft;
			_tmp17_ = _tmp16_->left;
			if (!(_tmp17_ != NULL)) {
				break;
			}
			_tmp18_ = tmpleft;
			_tmp19_ = _tmp18_->left;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (tmpleft);
			tmpleft = _tmp20_;
		}
		while (TRUE) {
			ParseNode* _tmp21_;
			ParseNode* _tmp22_;
			ParseNode* _tmp23_;
			ParseNode* _tmp24_;
			ParseNode* _tmp25_;
			_tmp21_ = tmpright;
			_tmp22_ = _tmp21_->right;
			if (!(_tmp22_ != NULL)) {
				break;
			}
			_tmp23_ = tmpright;
			_tmp24_ = _tmp23_->right;
			_tmp25_ = _g_object_ref0 (_tmp24_);
			_g_object_unref0 (tmpright);
			tmpright = _tmp25_;
		}
		_tmp26_ = ((ParseNode*) self)->parser;
		_tmp27_ = number_get_error ();
		_tmp28_ = _tmp27_;
		_tmp29_ = tmpleft;
		_tmp30_ = parse_node_first_token (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = _tmp31_->start_index;
		_tmp33_ = tmpright;
		_tmp34_ = parse_node_last_token (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = _tmp35_->end_index;
		parser_set_error (_tmp26_, ERROR_CODE_MP, _tmp28_, _tmp32_, _tmp36_);
		_g_object_unref0 (_tmp35_);
		_g_object_unref0 (_tmp31_);
		_tmp37_ = number_get_error ();
		_tmp38_ = _tmp37_;
		number_set_error (NULL);
		_g_object_unref0 (tmpright);
		_g_object_unref0 (tmpleft);
	}
	result = z;
	_g_object_unref0 (r);
	_g_object_unref0 (l);
	return result;
}


static Number*
lr_node_real_solve_lr (LRNode* self,
                       Number* left,
                       Number* r)
{
	g_critical ("Type `%s' does not implement abstract method `lr_node_solve_lr'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


Number*
lr_node_solve_lr (LRNode* self,
                  Number* left,
                  Number* r)
{
	g_return_val_if_fail (self != NULL, NULL);
	return LR_NODE_GET_CLASS (self)->solve_lr (self, left, r);
}


static void
lr_node_class_init (LRNodeClass * klass)
{
	lr_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode *)) lr_node_real_solve;
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode *, Number*, Number*)) lr_node_real_solve_lr;
}


static void
lr_node_instance_init (LRNode * self)
{
}


GType
lr_node_get_type (void)
{
	static volatile gsize lr_node_type_id__volatile = 0;
	if (g_once_init_enter (&lr_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LRNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lr_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LRNode), 0, (GInstanceInitFunc) lr_node_instance_init, NULL };
		GType lr_node_type_id;
		lr_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "LRNode", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&lr_node_type_id__volatile, lr_node_type_id);
	}
	return lr_node_type_id__volatile;
}


ConstantNode*
constant_node_construct (GType object_type,
                         Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	ConstantNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ConstantNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}


ConstantNode*
constant_node_new (Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity)
{
	return constant_node_construct (TYPE_CONSTANT_NODE, parser, token, precedence, associativity);
}


static Number*
constant_node_real_solve (ParseNode* base)
{
	ConstantNode * self;
	Number* result = NULL;
	LexerToken* _tmp0_;
	LexerToken* _tmp1_;
	const gchar* _tmp2_;
	Parser* _tmp3_;
	gint _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	self = (ConstantNode*) base;
	_tmp0_ = parse_node_token ((ParseNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->text;
	_tmp3_ = ((ParseNode*) self)->parser;
	_tmp4_ = _tmp3_->number_base;
	_tmp5_ = mp_set_from_string (_tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp1_);
	result = _tmp6_;
	return result;
}


static void
constant_node_class_init (ConstantNodeClass * klass)
{
	constant_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode *)) constant_node_real_solve;
}


static void
constant_node_instance_init (ConstantNode * self)
{
}


GType
constant_node_get_type (void)
{
	static volatile gsize constant_node_type_id__volatile = 0;
	if (g_once_init_enter (&constant_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConstantNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) constant_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConstantNode), 0, (GInstanceInitFunc) constant_node_instance_init, NULL };
		GType constant_node_type_id;
		constant_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "ConstantNode", &g_define_type_info, 0);
		g_once_init_leave (&constant_node_type_id__volatile, constant_node_type_id);
	}
	return constant_node_type_id__volatile;
}


AssignNode*
assign_node_construct (GType object_type,
                       Parser* parser,
                       LexerToken* token,
                       guint precedence,
                       Associativity associativity)
{
	AssignNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (AssignNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}


AssignNode*
assign_node_new (Parser* parser,
                 LexerToken* token,
                 guint precedence,
                 Associativity associativity)
{
	return assign_node_construct (TYPE_ASSIGN_NODE, parser, token, precedence, associativity);
}


static Number*
assign_node_real_solve_r (RNode* base,
                          Number* r)
{
	AssignNode * self;
	Number* result = NULL;
	Parser* _tmp0_;
	ParseNode* _tmp1_;
	LexerToken* _tmp2_;
	LexerToken* _tmp3_;
	const gchar* _tmp4_;
	Number* _tmp5_;
	self = (AssignNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = ((ParseNode*) self)->parser;
	_tmp1_ = ((ParseNode*) self)->left;
	_tmp2_ = parse_node_token (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->text;
	parser_set_variable (_tmp0_, _tmp4_, r);
	_g_object_unref0 (_tmp3_);
	_tmp5_ = _g_object_ref0 (r);
	result = _tmp5_;
	return result;
}


static void
assign_node_class_init (AssignNodeClass * klass)
{
	assign_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode *, Number*)) assign_node_real_solve_r;
}


static void
assign_node_instance_init (AssignNode * self)
{
}


GType
assign_node_get_type (void)
{
	static volatile gsize assign_node_type_id__volatile = 0;
	if (g_once_init_enter (&assign_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssignNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assign_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssignNode), 0, (GInstanceInitFunc) assign_node_instance_init, NULL };
		GType assign_node_type_id;
		assign_node_type_id = g_type_register_static (TYPE_RNODE, "AssignNode", &g_define_type_info, 0);
		g_once_init_leave (&assign_node_type_id__volatile, assign_node_type_id);
	}
	return assign_node_type_id__volatile;
}


AssignFunctionNode*
assign_function_node_construct (GType object_type,
                                Parser* parser,
                                LexerToken* token,
                                guint precedence,
                                Associativity associativity)
{
	AssignFunctionNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (AssignFunctionNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}


AssignFunctionNode*
assign_function_node_new (Parser* parser,
                          LexerToken* token,
                          guint precedence,
                          Associativity associativity)
{
	return assign_function_node_construct (TYPE_ASSIGN_FUNCTION_NODE, parser, token, precedence, associativity);
}


static Number*
assign_function_node_real_solve (ParseNode* base)
{
	AssignFunctionNode * self;
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ParseNode* _tmp3_;
	gchar* function_name = NULL;
	ParseNode* _tmp9_;
	ParseNode* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* arguments = NULL;
	ParseNode* _tmp13_;
	ParseNode* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* description = NULL;
	ParseNode* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp20_;
	FunctionManager* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	Parser* _tmp25_;
	self = (AssignFunctionNode*) base;
	_tmp3_ = ((ParseNode*) self)->left;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		ParseNode* _tmp4_;
		_tmp4_ = ((ParseNode*) self)->right;
		_tmp2_ = _tmp4_ == NULL;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		ParseNode* _tmp5_;
		ParseNode* _tmp6_;
		_tmp5_ = ((ParseNode*) self)->left;
		_tmp6_ = _tmp5_->left;
		_tmp1_ = _tmp6_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ParseNode* _tmp7_;
		ParseNode* _tmp8_;
		_tmp7_ = ((ParseNode*) self)->left;
		_tmp8_ = _tmp7_->right;
		_tmp0_ = _tmp8_ == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp9_ = ((ParseNode*) self)->left;
	_tmp10_ = _tmp9_->left;
	_tmp11_ = _tmp10_->value;
	_tmp12_ = g_strdup (_tmp11_);
	function_name = _tmp12_;
	_tmp13_ = ((ParseNode*) self)->left;
	_tmp14_ = _tmp13_->right;
	_tmp15_ = _tmp14_->value;
	_tmp16_ = g_strdup (_tmp15_);
	arguments = _tmp16_;
	_tmp17_ = ((ParseNode*) self)->right;
	_tmp18_ = _tmp17_->value;
	_tmp19_ = g_strdup (_tmp18_);
	description = _tmp19_;
	_tmp20_ = function_manager_get_default_function_manager ();
	function_manager = _tmp20_;
	_tmp21_ = function_manager;
	_tmp22_ = function_name;
	_tmp23_ = arguments;
	_tmp24_ = description;
	_tmp25_ = ((ParseNode*) self)->parser;
	if (function_manager_add_function_with_properties (_tmp21_, _tmp22_, _tmp23_, _tmp24_, _tmp25_)) {
		Number* _tmp26_;
		_tmp26_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp26_;
		_g_object_unref0 (function_manager);
		_g_free0 (description);
		_g_free0 (arguments);
		_g_free0 (function_name);
		return result;
	}
	result = NULL;
	_g_object_unref0 (function_manager);
	_g_free0 (description);
	_g_free0 (arguments);
	_g_free0 (function_name);
	return result;
}


static void
assign_function_node_class_init (AssignFunctionNodeClass * klass)
{
	assign_function_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode *)) assign_function_node_real_solve;
}


static void
assign_function_node_instance_init (AssignFunctionNode * self)
{
}


GType
assign_function_node_get_type (void)
{
	static volatile gsize assign_function_node_type_id__volatile = 0;
	if (g_once_init_enter (&assign_function_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssignFunctionNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assign_function_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssignFunctionNode), 0, (GInstanceInitFunc) assign_function_node_instance_init, NULL };
		GType assign_function_node_type_id;
		assign_function_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "AssignFunctionNode", &g_define_type_info, 0);
		g_once_init_leave (&assign_function_node_type_id__volatile, assign_function_node_type_id);
	}
	return assign_function_node_type_id__volatile;
}


NameNode*
name_node_construct (GType object_type,
                     Parser* parser,
                     LexerToken* token,
                     guint precedence,
                     Associativity associativity,
                     const gchar* text)
{
	NameNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (NameNode*) parse_node_construct (object_type, parser, token, precedence, associativity, text);
	return self;
}


NameNode*
name_node_new (Parser* parser,
               LexerToken* token,
               guint precedence,
               Associativity associativity,
               const gchar* text)
{
	return name_node_construct (TYPE_NAME_NODE, parser, token, precedence, associativity, text);
}


static void
name_node_class_init (NameNodeClass * klass)
{
	name_node_parent_class = g_type_class_peek_parent (klass);
}


static void
name_node_instance_init (NameNode * self)
{
}


GType
name_node_get_type (void)
{
	static volatile gsize name_node_type_id__volatile = 0;
	if (g_once_init_enter (&name_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NameNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) name_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NameNode), 0, (GInstanceInitFunc) name_node_instance_init, NULL };
		GType name_node_type_id;
		name_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "NameNode", &g_define_type_info, 0);
		g_once_init_leave (&name_node_type_id__volatile, name_node_type_id);
	}
	return name_node_type_id__volatile;
}


VariableNode*
variable_node_construct (GType object_type,
                         Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	VariableNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (VariableNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}


VariableNode*
variable_node_new (Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity)
{
	return variable_node_construct (TYPE_VARIABLE_NODE, parser, token, precedence, associativity);
}


static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	_tmp0_ = _vala_c;
	if (_tmp0_ != ((gunichar) 0)) {
		gchar* _tmp1_;
		_tmp1_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp1_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static Number*
variable_node_real_solve (ParseNode* base)
{
	VariableNode * self;
	Number* result = NULL;
	Number* ans = NULL;
	Parser* _tmp0_;
	LexerToken* _tmp1_;
	LexerToken* _tmp2_;
	const gchar* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* value = NULL;
	Number* _tmp7_;
	gint index = 0;
	gunichar c = 0U;
	self = (VariableNode*) base;
	_tmp0_ = ((ParseNode*) self)->parser;
	_tmp1_ = parse_node_token ((ParseNode*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->text;
	_tmp4_ = parser_get_variable (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	ans = _tmp5_;
	_tmp6_ = ans;
	if (_tmp6_ != NULL) {
		result = ans;
		return result;
	}
	_tmp7_ = number_new_integer ((gint64) 1, (gint64) 0);
	value = _tmp7_;
	index = 0;
	while (TRUE) {
		LexerToken* _tmp8_;
		LexerToken* _tmp9_;
		const gchar* _tmp10_;
		gunichar _tmp11_ = 0U;
		gboolean _tmp12_;
		gboolean _tmp13_;
		Number* t = NULL;
		Parser* _tmp14_;
		gunichar _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		Number* _tmp18_;
		Number* _tmp19_;
		Number* _tmp20_;
		Number* _tmp31_;
		Number* _tmp32_;
		Number* _tmp33_;
		_tmp8_ = parse_node_token ((ParseNode*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_->text;
		_tmp12_ = string_get_next_char (_tmp10_, &index, &_tmp11_);
		c = _tmp11_;
		_tmp13_ = !_tmp12_;
		_g_object_unref0 (_tmp9_);
		if (_tmp13_) {
			break;
		}
		_tmp14_ = ((ParseNode*) self)->parser;
		_tmp15_ = c;
		_tmp16_ = g_unichar_to_string (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = parser_get_variable (_tmp14_, _tmp17_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		t = _tmp19_;
		_tmp20_ = t;
		if (_tmp20_ == NULL) {
			Parser* _tmp21_;
			LexerToken* _tmp22_;
			LexerToken* _tmp23_;
			const gchar* _tmp24_;
			LexerToken* _tmp25_;
			LexerToken* _tmp26_;
			guint _tmp27_;
			LexerToken* _tmp28_;
			LexerToken* _tmp29_;
			guint _tmp30_;
			_tmp21_ = ((ParseNode*) self)->parser;
			_tmp22_ = parse_node_token ((ParseNode*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = _tmp23_->text;
			_tmp25_ = parse_node_first_token ((ParseNode*) self);
			_tmp26_ = _tmp25_;
			_tmp27_ = _tmp26_->start_index;
			_tmp28_ = parse_node_last_token ((ParseNode*) self);
			_tmp29_ = _tmp28_;
			_tmp30_ = _tmp29_->end_index;
			parser_set_error (_tmp21_, ERROR_CODE_UNKNOWN_VARIABLE, _tmp24_, _tmp27_, _tmp30_);
			_g_object_unref0 (_tmp29_);
			_g_object_unref0 (_tmp26_);
			_g_object_unref0 (_tmp23_);
			result = NULL;
			_g_object_unref0 (t);
			_g_object_unref0 (value);
			_g_object_unref0 (ans);
			return result;
		}
		_tmp31_ = value;
		_tmp32_ = t;
		_tmp33_ = number_multiply (_tmp31_, _tmp32_);
		_g_object_unref0 (value);
		value = _tmp33_;
		_g_object_unref0 (t);
	}
	result = value;
	_g_object_unref0 (ans);
	return result;
}


static void
variable_node_class_init (VariableNodeClass * klass)
{
	variable_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode *)) variable_node_real_solve;
}


static void
variable_node_instance_init (VariableNode * self)
{
}


GType
variable_node_get_type (void)
{
	static volatile gsize variable_node_type_id__volatile = 0;
	if (g_once_init_enter (&variable_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VariableNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) variable_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VariableNode), 0, (GInstanceInitFunc) variable_node_instance_init, NULL };
		GType variable_node_type_id;
		variable_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "VariableNode", &g_define_type_info, 0);
		g_once_init_leave (&variable_node_type_id__volatile, variable_node_type_id);
	}
	return variable_node_type_id__volatile;
}


VariableWithPowerNode*
variable_with_power_node_construct (GType object_type,
                                    Parser* parser,
                                    LexerToken* token,
                                    guint precedence,
                                    Associativity associativity,
                                    const gchar* text)
{
	VariableWithPowerNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	self = (VariableWithPowerNode*) parse_node_construct (object_type, parser, token, precedence, associativity, text);
	return self;
}


VariableWithPowerNode*
variable_with_power_node_new (Parser* parser,
                              LexerToken* token,
                              guint precedence,
                              Associativity associativity,
                              const gchar* text)
{
	return variable_with_power_node_construct (TYPE_VARIABLE_WITH_POWER_NODE, parser, token, precedence, associativity, text);
}


static Number*
variable_with_power_node_real_solve (ParseNode* base)
{
	VariableWithPowerNode * self;
	Number* result = NULL;
	gint pow = 0;
	const gchar* _tmp0_;
	Number* ans = NULL;
	Parser* _tmp1_;
	LexerToken* _tmp2_;
	LexerToken* _tmp3_;
	const gchar* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* value = NULL;
	Number* _tmp11_;
	gint index = 0;
	gunichar c = 0U;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	self = (VariableWithPowerNode*) base;
	_tmp0_ = ((ParseNode*) self)->value;
	pow = super_atoi (_tmp0_);
	_g_free0 (((ParseNode*) self)->value);
	((ParseNode*) self)->value = NULL;
	_tmp1_ = ((ParseNode*) self)->parser;
	_tmp2_ = parse_node_token ((ParseNode*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->text;
	_tmp5_ = parser_get_variable (_tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	ans = _tmp6_;
	_tmp7_ = ans;
	if (_tmp7_ != NULL) {
		Number* _tmp8_;
		gint _tmp9_;
		Number* _tmp10_;
		_tmp8_ = ans;
		_tmp9_ = pow;
		_tmp10_ = number_xpowy_integer (_tmp8_, (gint64) _tmp9_);
		result = _tmp10_;
		_g_object_unref0 (ans);
		return result;
	}
	_tmp11_ = number_new_integer ((gint64) 1, (gint64) 0);
	value = _tmp11_;
	index = 0;
	while (TRUE) {
		LexerToken* _tmp12_;
		LexerToken* _tmp13_;
		const gchar* _tmp14_;
		gunichar _tmp15_ = 0U;
		gboolean _tmp16_;
		gboolean _tmp17_;
		Number* t = NULL;
		Parser* _tmp18_;
		gunichar _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		Number* _tmp22_;
		Number* _tmp23_;
		Number* _tmp24_;
		gint i = 0;
		gint _tmp35_;
		gunichar next = 0U;
		LexerToken* _tmp36_;
		LexerToken* _tmp37_;
		const gchar* _tmp38_;
		gunichar _tmp39_ = 0U;
		gboolean _tmp40_;
		gboolean _tmp41_;
		Number* _tmp45_;
		Number* _tmp46_;
		Number* _tmp47_;
		_tmp12_ = parse_node_token ((ParseNode*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->text;
		_tmp16_ = string_get_next_char (_tmp14_, &index, &_tmp15_);
		c = _tmp15_;
		_tmp17_ = !_tmp16_;
		_g_object_unref0 (_tmp13_);
		if (_tmp17_) {
			break;
		}
		_tmp18_ = ((ParseNode*) self)->parser;
		_tmp19_ = c;
		_tmp20_ = g_unichar_to_string (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = parser_get_variable (_tmp18_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		t = _tmp23_;
		_tmp24_ = t;
		if (_tmp24_ == NULL) {
			Parser* _tmp25_;
			LexerToken* _tmp26_;
			LexerToken* _tmp27_;
			const gchar* _tmp28_;
			LexerToken* _tmp29_;
			LexerToken* _tmp30_;
			guint _tmp31_;
			LexerToken* _tmp32_;
			LexerToken* _tmp33_;
			guint _tmp34_;
			_tmp25_ = ((ParseNode*) self)->parser;
			_tmp26_ = parse_node_token ((ParseNode*) self);
			_tmp27_ = _tmp26_;
			_tmp28_ = _tmp27_->text;
			_tmp29_ = parse_node_first_token ((ParseNode*) self);
			_tmp30_ = _tmp29_;
			_tmp31_ = _tmp30_->start_index;
			_tmp32_ = parse_node_last_token ((ParseNode*) self);
			_tmp33_ = _tmp32_;
			_tmp34_ = _tmp33_->end_index;
			parser_set_error (_tmp25_, ERROR_CODE_UNKNOWN_VARIABLE, _tmp28_, _tmp31_, _tmp34_);
			_g_object_unref0 (_tmp33_);
			_g_object_unref0 (_tmp30_);
			_g_object_unref0 (_tmp27_);
			result = NULL;
			_g_object_unref0 (t);
			_g_object_unref0 (value);
			_g_object_unref0 (ans);
			return result;
		}
		_tmp35_ = index;
		i = _tmp35_;
		_tmp36_ = parse_node_token ((ParseNode*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = _tmp37_->text;
		_tmp40_ = string_get_next_char (_tmp38_, &i, &_tmp39_);
		next = _tmp39_;
		_tmp41_ = !_tmp40_;
		_g_object_unref0 (_tmp37_);
		if (_tmp41_) {
			Number* _tmp42_;
			gint _tmp43_;
			Number* _tmp44_;
			_tmp42_ = t;
			_tmp43_ = pow;
			_tmp44_ = number_xpowy_integer (_tmp42_, (gint64) _tmp43_);
			_g_object_unref0 (t);
			t = _tmp44_;
		}
		_tmp45_ = value;
		_tmp46_ = t;
		_tmp47_ = number_multiply (_tmp45_, _tmp46_);
		_g_object_unref0 (value);
		value = _tmp47_;
		_g_object_unref0 (t);
	}
	number_check_flags ();
	_tmp48_ = number_get_error ();
	_tmp49_ = _tmp48_;
	if (_tmp49_ != NULL) {
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp50_;
		ParseNode* _tmp51_;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp52_;
		ParseNode* _tmp53_;
		Parser* _tmp64_;
		const gchar* _tmp65_;
		const gchar* _tmp66_;
		ParseNode* _tmp67_;
		LexerToken* _tmp68_;
		LexerToken* _tmp69_;
		guint _tmp70_;
		ParseNode* _tmp71_;
		LexerToken* _tmp72_;
		LexerToken* _tmp73_;
		guint _tmp74_;
		const gchar* _tmp75_;
		const gchar* _tmp76_;
		_tmp50_ = ((ParseNode*) self)->left;
		_tmp51_ = _g_object_ref0 (_tmp50_);
		tmpleft = _tmp51_;
		_tmp52_ = ((ParseNode*) self)->right;
		_tmp53_ = _g_object_ref0 (_tmp52_);
		tmpright = _tmp53_;
		while (TRUE) {
			ParseNode* _tmp54_;
			ParseNode* _tmp55_;
			ParseNode* _tmp56_;
			ParseNode* _tmp57_;
			ParseNode* _tmp58_;
			_tmp54_ = tmpleft;
			_tmp55_ = _tmp54_->left;
			if (!(_tmp55_ != NULL)) {
				break;
			}
			_tmp56_ = tmpleft;
			_tmp57_ = _tmp56_->left;
			_tmp58_ = _g_object_ref0 (_tmp57_);
			_g_object_unref0 (tmpleft);
			tmpleft = _tmp58_;
		}
		while (TRUE) {
			ParseNode* _tmp59_;
			ParseNode* _tmp60_;
			ParseNode* _tmp61_;
			ParseNode* _tmp62_;
			ParseNode* _tmp63_;
			_tmp59_ = tmpright;
			_tmp60_ = _tmp59_->right;
			if (!(_tmp60_ != NULL)) {
				break;
			}
			_tmp61_ = tmpright;
			_tmp62_ = _tmp61_->right;
			_tmp63_ = _g_object_ref0 (_tmp62_);
			_g_object_unref0 (tmpright);
			tmpright = _tmp63_;
		}
		_tmp64_ = ((ParseNode*) self)->parser;
		_tmp65_ = number_get_error ();
		_tmp66_ = _tmp65_;
		_tmp67_ = tmpleft;
		_tmp68_ = parse_node_first_token (_tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = _tmp69_->start_index;
		_tmp71_ = tmpright;
		_tmp72_ = parse_node_last_token (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = _tmp73_->end_index;
		parser_set_error (_tmp64_, ERROR_CODE_MP, _tmp66_, _tmp70_, _tmp74_);
		_g_object_unref0 (_tmp73_);
		_g_object_unref0 (_tmp69_);
		_tmp75_ = number_get_error ();
		_tmp76_ = _tmp75_;
		number_set_error (NULL);
		_g_object_unref0 (tmpright);
		_g_object_unref0 (tmpleft);
	}
	result = value;
	_g_object_unref0 (ans);
	return result;
}


static void
variable_with_power_node_class_init (VariableWithPowerNodeClass * klass)
{
	variable_with_power_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode *)) variable_with_power_node_real_solve;
}


static void
variable_with_power_node_instance_init (VariableWithPowerNode * self)
{
}


GType
variable_with_power_node_get_type (void)
{
	static volatile gsize variable_with_power_node_type_id__volatile = 0;
	if (g_once_init_enter (&variable_with_power_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VariableWithPowerNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) variable_with_power_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VariableWithPowerNode), 0, (GInstanceInitFunc) variable_with_power_node_instance_init, NULL };
		GType variable_with_power_node_type_id;
		variable_with_power_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "VariableWithPowerNode", &g_define_type_info, 0);
		g_once_init_leave (&variable_with_power_node_type_id__volatile, variable_with_power_node_type_id);
	}
	return variable_with_power_node_type_id__volatile;
}


FunctionNameNode*
function_name_node_construct (GType object_type,
                              Parser* parser,
                              LexerToken* token,
                              guint precedence,
                              Associativity associativity,
                              const gchar* name)
{
	FunctionNameNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (FunctionNameNode*) name_node_construct (object_type, parser, token, precedence, associativity, name);
	return self;
}


FunctionNameNode*
function_name_node_new (Parser* parser,
                        LexerToken* token,
                        guint precedence,
                        Associativity associativity,
                        const gchar* name)
{
	return function_name_node_construct (TYPE_FUNCTION_NAME_NODE, parser, token, precedence, associativity, name);
}


static void
function_name_node_class_init (FunctionNameNodeClass * klass)
{
	function_name_node_parent_class = g_type_class_peek_parent (klass);
}


static void
function_name_node_instance_init (FunctionNameNode * self)
{
}


GType
function_name_node_get_type (void)
{
	static volatile gsize function_name_node_type_id__volatile = 0;
	if (g_once_init_enter (&function_name_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionNameNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_name_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionNameNode), 0, (GInstanceInitFunc) function_name_node_instance_init, NULL };
		GType function_name_node_type_id;
		function_name_node_type_id = g_type_register_static (TYPE_NAME_NODE, "FunctionNameNode", &g_define_type_info, 0);
		g_once_init_leave (&function_name_node_type_id__volatile, function_name_node_type_id);
	}
	return function_name_node_type_id__volatile;
}


FunctionArgumentsNode*
function_arguments_node_construct (GType object_type,
                                   Parser* parser,
                                   GList* token_list,
                                   guint precedence,
                                   Associativity associativity,
                                   const gchar* arguments)
{
	FunctionArgumentsNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	g_return_val_if_fail (arguments != NULL, NULL);
	self = (FunctionArgumentsNode*) parse_node_construct_WithList (object_type, parser, token_list, precedence, associativity, arguments);
	return self;
}


FunctionArgumentsNode*
function_arguments_node_new (Parser* parser,
                             GList* token_list,
                             guint precedence,
                             Associativity associativity,
                             const gchar* arguments)
{
	return function_arguments_node_construct (TYPE_FUNCTION_ARGUMENTS_NODE, parser, token_list, precedence, associativity, arguments);
}


static void
function_arguments_node_class_init (FunctionArgumentsNodeClass * klass)
{
	function_arguments_node_parent_class = g_type_class_peek_parent (klass);
}


static void
function_arguments_node_instance_init (FunctionArgumentsNode * self)
{
}


GType
function_arguments_node_get_type (void)
{
	static volatile gsize function_arguments_node_type_id__volatile = 0;
	if (g_once_init_enter (&function_arguments_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionArgumentsNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_arguments_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionArgumentsNode), 0, (GInstanceInitFunc) function_arguments_node_instance_init, NULL };
		GType function_arguments_node_type_id;
		function_arguments_node_type_id = g_type_register_static (TYPE_NAME_NODE, "FunctionArgumentsNode", &g_define_type_info, 0);
		g_once_init_leave (&function_arguments_node_type_id__volatile, function_arguments_node_type_id);
	}
	return function_arguments_node_type_id__volatile;
}


FunctionDescriptionNode*
function_description_node_construct (GType object_type,
                                     Parser* parser,
                                     LexerToken* token,
                                     guint precedence,
                                     Associativity associativity,
                                     const gchar* description)
{
	FunctionDescriptionNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	self = (FunctionDescriptionNode*) name_node_construct (object_type, parser, token, precedence, associativity, description);
	return self;
}


FunctionDescriptionNode*
function_description_node_new (Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity,
                               const gchar* description)
{
	return function_description_node_construct (TYPE_FUNCTION_DESCRIPTION_NODE, parser, token, precedence, associativity, description);
}


static void
function_description_node_class_init (FunctionDescriptionNodeClass * klass)
{
	function_description_node_parent_class = g_type_class_peek_parent (klass);
}


static void
function_description_node_instance_init (FunctionDescriptionNode * self)
{
}


GType
function_description_node_get_type (void)
{
	static volatile gsize function_description_node_type_id__volatile = 0;
	if (g_once_init_enter (&function_description_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionDescriptionNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_description_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionDescriptionNode), 0, (GInstanceInitFunc) function_description_node_instance_init, NULL };
		GType function_description_node_type_id;
		function_description_node_type_id = g_type_register_static (TYPE_NAME_NODE, "FunctionDescriptionNode", &g_define_type_info, 0);
		g_once_init_leave (&function_description_node_type_id__volatile, function_description_node_type_id);
	}
	return function_description_node_type_id__volatile;
}


FunctionNode*
function_node_construct (GType object_type,
                         Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity,
                         const gchar* text)
{
	FunctionNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (FunctionNode*) parse_node_construct (object_type, parser, token, precedence, associativity, text);
	return self;
}


FunctionNode*
function_node_new (Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity,
                   const gchar* text)
{
	return function_node_construct (TYPE_FUNCTION_NODE, parser, token, precedence, associativity, text);
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void
_vala_array_add1 (Number** * array,
                  int* length,
                  int* size,
                  Number* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Number*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add2 (Number** * array,
                  int* length,
                  int* size,
                  Number* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Number*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Number*
function_node_real_solve (ParseNode* base)
{
	FunctionNode * self;
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	ParseNode* _tmp1_;
	gchar* name = NULL;
	ParseNode* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gint pow = 0;
	const gchar* _tmp9_;
	gint _tmp11_;
	Number** args = NULL;
	Number** _tmp15_;
	gint args_length1;
	gint _args_size_;
	ParseNode* _tmp16_;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp77_;
	Number* tmp = NULL;
	FunctionManager* _tmp78_;
	const gchar* _tmp79_;
	Number** _tmp80_;
	gint _tmp80__length1;
	Parser* _tmp81_;
	Number* _tmp82_;
	Number* _tmp83_;
	const gchar* _tmp87_;
	const gchar* _tmp88_;
	self = (FunctionNode*) base;
	_tmp1_ = ((ParseNode*) self)->right;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ParseNode* _tmp2_;
		_tmp2_ = ((ParseNode*) self)->left;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		Parser* _tmp3_;
		_tmp3_ = ((ParseNode*) self)->parser;
		parser_set_error (_tmp3_, ERROR_CODE_UNKNOWN_FUNCTION, NULL, (guint) 0, (guint) 0);
		result = NULL;
		return result;
	}
	_tmp4_ = ((ParseNode*) self)->left;
	_tmp5_ = _tmp4_->value;
	_tmp6_ = g_strdup (_tmp5_);
	name = _tmp6_;
	_tmp7_ = name;
	if (_tmp7_ == NULL) {
		Parser* _tmp8_;
		_tmp8_ = ((ParseNode*) self)->parser;
		parser_set_error (_tmp8_, ERROR_CODE_UNKNOWN_FUNCTION, NULL, (guint) 0, (guint) 0);
		result = NULL;
		_g_free0 (name);
		return result;
	}
	pow = 1;
	_tmp9_ = ((ParseNode*) self)->value;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		_tmp10_ = ((ParseNode*) self)->value;
		pow = super_atoi (_tmp10_);
	}
	_tmp11_ = pow;
	if (_tmp11_ < 0) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gint _tmp14_;
		_tmp12_ = name;
		_tmp13_ = g_strconcat (_tmp12_, "⁻¹", NULL);
		_g_free0 (name);
		name = _tmp13_;
		_tmp14_ = pow;
		pow = -_tmp14_;
	}
	_tmp15_ = g_new0 (Number*, 0 + 1);
	args = _tmp15_;
	args_length1 = 0;
	_args_size_ = args_length1;
	_tmp16_ = ((ParseNode*) self)->right;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, TYPE_FUNCTION_ARGUMENTS_NODE)) {
		gchar* argument_list = NULL;
		ParseNode* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* temp = NULL;
		gchar* _tmp20_;
		gint depth = 0;
		gchar** arguments = NULL;
		const gchar* _tmp41_;
		gchar** _tmp42_;
		gchar** _tmp43_;
		gint arguments_length1;
		gint _arguments_size_;
		gchar** _tmp44_;
		gint _tmp44__length1;
		_tmp17_ = ((ParseNode*) self)->right;
		_tmp18_ = _tmp17_->value;
		_tmp19_ = g_strdup (_tmp18_);
		argument_list = _tmp19_;
		_tmp20_ = g_strdup ("");
		temp = _tmp20_;
		depth = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp21_ = FALSE;
				_tmp21_ = TRUE;
				while (TRUE) {
					gint _tmp23_;
					const gchar* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					gchar* ss = NULL;
					const gchar* _tmp27_;
					gint _tmp28_;
					gchar* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					gchar* _tmp40_;
					if (!_tmp21_) {
						gint _tmp22_;
						_tmp22_ = i;
						i = _tmp22_ + 1;
					}
					_tmp21_ = FALSE;
					_tmp23_ = i;
					_tmp24_ = argument_list;
					_tmp25_ = strlen (_tmp24_);
					_tmp26_ = _tmp25_;
					if (!(_tmp23_ < _tmp26_)) {
						break;
					}
					_tmp27_ = argument_list;
					_tmp28_ = i;
					_tmp29_ = string_substring (_tmp27_, (glong) _tmp28_, (glong) 1);
					ss = _tmp29_;
					_tmp30_ = ss;
					if (g_strcmp0 (_tmp30_, "(") == 0) {
						gint _tmp31_;
						_tmp31_ = depth;
						depth = _tmp31_ + 1;
					} else {
						const gchar* _tmp32_;
						_tmp32_ = ss;
						if (g_strcmp0 (_tmp32_, ")") == 0) {
							gint _tmp33_;
							_tmp33_ = depth;
							depth = _tmp33_ - 1;
						} else {
							gboolean _tmp34_ = FALSE;
							const gchar* _tmp35_;
							_tmp35_ = ss;
							if (g_strcmp0 (_tmp35_, ";") == 0) {
								gint _tmp36_;
								_tmp36_ = depth;
								_tmp34_ = _tmp36_ != 0;
							} else {
								_tmp34_ = FALSE;
							}
							if (_tmp34_) {
								gchar* _tmp37_;
								_tmp37_ = g_strdup ("$");
								_g_free0 (ss);
								ss = _tmp37_;
							}
						}
					}
					_tmp38_ = temp;
					_tmp39_ = ss;
					_tmp40_ = g_strconcat (_tmp38_, _tmp39_, NULL);
					_g_free0 (temp);
					temp = _tmp40_;
					_g_free0 (ss);
				}
			}
		}
		_tmp41_ = temp;
		_tmp43_ = _tmp42_ = g_strsplit_set (_tmp41_, ";", 0);
		arguments = _tmp43_;
		arguments_length1 = _vala_array_length (_tmp42_);
		_arguments_size_ = arguments_length1;
		_tmp44_ = arguments;
		_tmp44__length1 = arguments_length1;
		{
			gchar** argument_collection = NULL;
			gint argument_collection_length1 = 0;
			gint _argument_collection_size_ = 0;
			gint argument_it = 0;
			argument_collection = _tmp44_;
			argument_collection_length1 = _tmp44__length1;
			for (argument_it = 0; argument_it < _tmp44__length1; argument_it = argument_it + 1) {
				gchar* _tmp45_;
				gchar* argument = NULL;
				_tmp45_ = g_strdup (argument_collection[argument_it]);
				argument = _tmp45_;
				{
					const gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					ExpressionParser* argument_parser = NULL;
					const gchar* _tmp50_;
					Parser* _tmp51_;
					ExpressionParser* _tmp52_;
					guint representation_base = 0U;
					ErrorCode error_code = 0;
					gchar* error_token = NULL;
					guint error_start = 0U;
					guint error_end = 0U;
					Number* ans = NULL;
					ExpressionParser* _tmp53_;
					guint _tmp54_ = 0U;
					ErrorCode _tmp55_ = 0;
					gchar* _tmp56_ = NULL;
					guint _tmp57_ = 0U;
					guint _tmp58_ = 0U;
					Number* _tmp59_;
					gboolean _tmp60_ = FALSE;
					ErrorCode _tmp61_;
					_tmp46_ = argument;
					_tmp47_ = string_replace (_tmp46_, "$", ";");
					_tmp48_ = _tmp47_;
					_tmp49_ = string_strip (_tmp48_);
					_g_free0 (argument);
					argument = _tmp49_;
					_g_free0 (_tmp48_);
					_tmp50_ = argument;
					_tmp51_ = ((ParseNode*) self)->parser;
					_tmp52_ = expression_parser_new (_tmp50_, _tmp51_);
					argument_parser = _tmp52_;
					_tmp53_ = argument_parser;
					_tmp59_ = parser_parse ((Parser*) _tmp53_, &_tmp54_, &_tmp55_, &_tmp56_, &_tmp57_, &_tmp58_);
					representation_base = _tmp54_;
					error_code = _tmp55_;
					_g_free0 (error_token);
					error_token = _tmp56_;
					error_start = _tmp57_;
					error_end = _tmp58_;
					ans = _tmp59_;
					_tmp61_ = error_code;
					if (_tmp61_ == ERROR_CODE_NONE) {
						Number* _tmp62_;
						_tmp62_ = ans;
						_tmp60_ = _tmp62_ != NULL;
					} else {
						_tmp60_ = FALSE;
					}
					if (_tmp60_) {
						Number** _tmp63_;
						gint _tmp63__length1;
						Number* _tmp64_;
						Number* _tmp65_;
						_tmp63_ = args;
						_tmp63__length1 = args_length1;
						_tmp64_ = ans;
						_tmp65_ = _g_object_ref0 (_tmp64_);
						_vala_array_add1 (&args, &args_length1, &_args_size_, _tmp65_);
					} else {
						Parser* _tmp66_;
						const gchar* _tmp67_;
						guint _tmp68_;
						guint _tmp69_;
						_tmp66_ = ((ParseNode*) self)->parser;
						_tmp67_ = error_token;
						_tmp68_ = error_start;
						_tmp69_ = error_end;
						parser_set_error (_tmp66_, ERROR_CODE_UNKNOWN_VARIABLE, _tmp67_, _tmp68_, _tmp69_);
						result = NULL;
						_g_object_unref0 (ans);
						_g_free0 (error_token);
						_parser_unref0 (argument_parser);
						_g_free0 (argument);
						arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (temp);
						_g_free0 (argument_list);
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
						_g_free0 (name);
						return result;
					}
					_g_object_unref0 (ans);
					_g_free0 (error_token);
					_parser_unref0 (argument_parser);
					_g_free0 (argument);
				}
			}
		}
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (temp);
		_g_free0 (argument_list);
	} else {
		Number* ans = NULL;
		ParseNode* _tmp70_;
		Number* _tmp71_;
		Number* _tmp72_;
		_tmp70_ = ((ParseNode*) self)->right;
		_tmp71_ = parse_node_solve (_tmp70_);
		ans = _tmp71_;
		_tmp72_ = ans;
		if (_tmp72_ != NULL) {
			Number** _tmp73_;
			gint _tmp73__length1;
			Number* _tmp74_;
			Number* _tmp75_;
			_tmp73_ = args;
			_tmp73__length1 = args_length1;
			_tmp74_ = ans;
			_tmp75_ = _g_object_ref0 (_tmp74_);
			_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp75_);
		} else {
			Parser* _tmp76_;
			_tmp76_ = ((ParseNode*) self)->parser;
			parser_set_error (_tmp76_, ERROR_CODE_UNKNOWN_FUNCTION, NULL, (guint) 0, (guint) 0);
			result = NULL;
			_g_object_unref0 (ans);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_free0 (name);
			return result;
		}
		_g_object_unref0 (ans);
	}
	_tmp77_ = function_manager_get_default_function_manager ();
	function_manager = _tmp77_;
	_tmp78_ = function_manager;
	_tmp79_ = name;
	_tmp80_ = args;
	_tmp80__length1 = args_length1;
	_tmp81_ = ((ParseNode*) self)->parser;
	_tmp82_ = function_manager_evaluate_function (_tmp78_, _tmp79_, _tmp80_, _tmp80__length1, _tmp81_);
	tmp = _tmp82_;
	_tmp83_ = tmp;
	if (_tmp83_ != NULL) {
		Number* _tmp84_;
		gint _tmp85_;
		Number* _tmp86_;
		_tmp84_ = tmp;
		_tmp85_ = pow;
		_tmp86_ = number_xpowy_integer (_tmp84_, (gint64) _tmp85_);
		_g_object_unref0 (tmp);
		tmp = _tmp86_;
	}
	number_check_flags ();
	_tmp87_ = number_get_error ();
	_tmp88_ = _tmp87_;
	if (_tmp88_ != NULL) {
		Parser* _tmp89_;
		const gchar* _tmp90_;
		const gchar* _tmp91_;
		ParseNode* _tmp92_;
		LexerToken* _tmp93_;
		LexerToken* _tmp94_;
		guint _tmp95_;
		ParseNode* _tmp96_;
		LexerToken* _tmp97_;
		LexerToken* _tmp98_;
		guint _tmp99_;
		const gchar* _tmp100_;
		const gchar* _tmp101_;
		_tmp89_ = ((ParseNode*) self)->parser;
		_tmp90_ = number_get_error ();
		_tmp91_ = _tmp90_;
		_tmp92_ = ((ParseNode*) self)->right;
		_tmp93_ = parse_node_first_token (_tmp92_);
		_tmp94_ = _tmp93_;
		_tmp95_ = _tmp94_->start_index;
		_tmp96_ = ((ParseNode*) self)->right;
		_tmp97_ = parse_node_last_token (_tmp96_);
		_tmp98_ = _tmp97_;
		_tmp99_ = _tmp98_->end_index;
		parser_set_error (_tmp89_, ERROR_CODE_MP, _tmp91_, _tmp95_, _tmp99_);
		_g_object_unref0 (_tmp98_);
		_g_object_unref0 (_tmp94_);
		_tmp100_ = number_get_error ();
		_tmp101_ = _tmp100_;
		number_set_error (NULL);
	}
	result = tmp;
	_g_object_unref0 (function_manager);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (name);
	return result;
}


static void
function_node_class_init (FunctionNodeClass * klass)
{
	function_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode *)) function_node_real_solve;
}


static void
function_node_instance_init (FunctionNode * self)
{
}


GType
function_node_get_type (void)
{
	static volatile gsize function_node_type_id__volatile = 0;
	if (g_once_init_enter (&function_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionNode), 0, (GInstanceInitFunc) function_node_instance_init, NULL };
		GType function_node_type_id;
		function_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "FunctionNode", &g_define_type_info, 0);
		g_once_init_leave (&function_node_type_id__volatile, function_node_type_id);
	}
	return function_node_type_id__volatile;
}


UnaryMinusNode*
unary_minus_node_construct (GType object_type,
                            Parser* parser,
                            LexerToken* token,
                            guint precedence,
                            Associativity associativity)
{
	UnaryMinusNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (UnaryMinusNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}


UnaryMinusNode*
unary_minus_node_new (Parser* parser,
                      LexerToken* token,
                      guint precedence,
                      Associativity associativity)
{
	return unary_minus_node_construct (TYPE_UNARY_MINUS_NODE, parser, token, precedence, associativity);
}


static Number*
unary_minus_node_real_solve_r (RNode* base,
                               Number* r)
{
	UnaryMinusNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (UnaryMinusNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_invert_sign (r);
	result = _tmp0_;
	return result;
}


static void
unary_minus_node_class_init (UnaryMinusNodeClass * klass)
{
	unary_minus_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode *, Number*)) unary_minus_node_real_solve_r;
}


static void
unary_minus_node_instance_init (UnaryMinusNode * self)
{
}


GType
unary_minus_node_get_type (void)
{
	static volatile gsize unary_minus_node_type_id__volatile = 0;
	if (g_once_init_enter (&unary_minus_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnaryMinusNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unary_minus_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnaryMinusNode), 0, (GInstanceInitFunc) unary_minus_node_instance_init, NULL };
		GType unary_minus_node_type_id;
		unary_minus_node_type_id = g_type_register_static (TYPE_RNODE, "UnaryMinusNode", &g_define_type_info, 0);
		g_once_init_leave (&unary_minus_node_type_id__volatile, unary_minus_node_type_id);
	}
	return unary_minus_node_type_id__volatile;
}


AbsoluteValueNode*
absolute_value_node_construct (GType object_type,
                               Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity)
{
	AbsoluteValueNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (AbsoluteValueNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}


AbsoluteValueNode*
absolute_value_node_new (Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	return absolute_value_node_construct (TYPE_ABSOLUTE_VALUE_NODE, parser, token, precedence, associativity);
}


static Number*
absolute_value_node_real_solve_r (RNode* base,
                                  Number* r)
{
	AbsoluteValueNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (AbsoluteValueNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_abs (r);
	result = _tmp0_;
	return result;
}


static void
absolute_value_node_class_init (AbsoluteValueNodeClass * klass)
{
	absolute_value_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode *, Number*)) absolute_value_node_real_solve_r;
}


static void
absolute_value_node_instance_init (AbsoluteValueNode * self)
{
}


GType
absolute_value_node_get_type (void)
{
	static volatile gsize absolute_value_node_type_id__volatile = 0;
	if (g_once_init_enter (&absolute_value_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AbsoluteValueNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) absolute_value_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AbsoluteValueNode), 0, (GInstanceInitFunc) absolute_value_node_instance_init, NULL };
		GType absolute_value_node_type_id;
		absolute_value_node_type_id = g_type_register_static (TYPE_RNODE, "AbsoluteValueNode", &g_define_type_info, 0);
		g_once_init_leave (&absolute_value_node_type_id__volatile, absolute_value_node_type_id);
	}
	return absolute_value_node_type_id__volatile;
}


FloorNode*
floor_node_construct (GType object_type,
                      Parser* parser,
                      LexerToken* token,
                      guint precedence,
                      Associativity associativity)
{
	FloorNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (FloorNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}


FloorNode*
floor_node_new (Parser* parser,
                LexerToken* token,
                guint precedence,
                Associativity associativity)
{
	return floor_node_construct (TYPE_FLOOR_NODE, parser, token, precedence, associativity);
}


static Number*
floor_node_real_solve_r (RNode* base,
                         Number* r)
{
	FloorNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (FloorNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_floor (r);
	result = _tmp0_;
	return result;
}


static void
floor_node_class_init (FloorNodeClass * klass)
{
	floor_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode *, Number*)) floor_node_real_solve_r;
}


static void
floor_node_instance_init (FloorNode * self)
{
}


GType
floor_node_get_type (void)
{
	static volatile gsize floor_node_type_id__volatile = 0;
	if (g_once_init_enter (&floor_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FloorNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) floor_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FloorNode), 0, (GInstanceInitFunc) floor_node_instance_init, NULL };
		GType floor_node_type_id;
		floor_node_type_id = g_type_register_static (TYPE_RNODE, "FloorNode", &g_define_type_info, 0);
		g_once_init_leave (&floor_node_type_id__volatile, floor_node_type_id);
	}
	return floor_node_type_id__volatile;
}


CeilingNode*
ceiling_node_construct (GType object_type,
                        Parser* parser,
                        LexerToken* token,
                        guint precedence,
                        Associativity associativity)
{
	CeilingNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (CeilingNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}


CeilingNode*
ceiling_node_new (Parser* parser,
                  LexerToken* token,
                  guint precedence,
                  Associativity associativity)
{
	return ceiling_node_construct (TYPE_CEILING_NODE, parser, token, precedence, associativity);
}


static Number*
ceiling_node_real_solve_r (RNode* base,
                           Number* r)
{
	CeilingNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (CeilingNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_ceiling (r);
	result = _tmp0_;
	return result;
}


static void
ceiling_node_class_init (CeilingNodeClass * klass)
{
	ceiling_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode *, Number*)) ceiling_node_real_solve_r;
}


static void
ceiling_node_instance_init (CeilingNode * self)
{
}


GType
ceiling_node_get_type (void)
{
	static volatile gsize ceiling_node_type_id__volatile = 0;
	if (g_once_init_enter (&ceiling_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CeilingNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ceiling_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CeilingNode), 0, (GInstanceInitFunc) ceiling_node_instance_init, NULL };
		GType ceiling_node_type_id;
		ceiling_node_type_id = g_type_register_static (TYPE_RNODE, "CeilingNode", &g_define_type_info, 0);
		g_once_init_leave (&ceiling_node_type_id__volatile, ceiling_node_type_id);
	}
	return ceiling_node_type_id__volatile;
}


FractionalComponentNode*
fractional_component_node_construct (GType object_type,
                                     Parser* parser,
                                     LexerToken* token,
                                     guint precedence,
                                     Associativity associativity)
{
	FractionalComponentNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (FractionalComponentNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}


FractionalComponentNode*
fractional_component_node_new (Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity)
{
	return fractional_component_node_construct (TYPE_FRACTIONAL_COMPONENT_NODE, parser, token, precedence, associativity);
}


static Number*
fractional_component_node_real_solve_r (RNode* base,
                                        Number* r)
{
	FractionalComponentNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (FractionalComponentNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_fractional_part (r);
	result = _tmp0_;
	return result;
}


static void
fractional_component_node_class_init (FractionalComponentNodeClass * klass)
{
	fractional_component_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode *, Number*)) fractional_component_node_real_solve_r;
}


static void
fractional_component_node_instance_init (FractionalComponentNode * self)
{
}


GType
fractional_component_node_get_type (void)
{
	static volatile gsize fractional_component_node_type_id__volatile = 0;
	if (g_once_init_enter (&fractional_component_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FractionalComponentNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fractional_component_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FractionalComponentNode), 0, (GInstanceInitFunc) fractional_component_node_instance_init, NULL };
		GType fractional_component_node_type_id;
		fractional_component_node_type_id = g_type_register_static (TYPE_RNODE, "FractionalComponentNode", &g_define_type_info, 0);
		g_once_init_leave (&fractional_component_node_type_id__volatile, fractional_component_node_type_id);
	}
	return fractional_component_node_type_id__volatile;
}


RoundNode*
round_node_construct (GType object_type,
                      Parser* parser,
                      LexerToken* token,
                      guint precedence,
                      Associativity associativity)
{
	RoundNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (RoundNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}


RoundNode*
round_node_new (Parser* parser,
                LexerToken* token,
                guint precedence,
                Associativity associativity)
{
	return round_node_construct (TYPE_ROUND_NODE, parser, token, precedence, associativity);
}


static Number*
round_node_real_solve_r (RNode* base,
                         Number* r)
{
	RoundNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (RoundNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_round (r);
	result = _tmp0_;
	return result;
}


static void
round_node_class_init (RoundNodeClass * klass)
{
	round_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode *, Number*)) round_node_real_solve_r;
}


static void
round_node_instance_init (RoundNode * self)
{
}


GType
round_node_get_type (void)
{
	static volatile gsize round_node_type_id__volatile = 0;
	if (g_once_init_enter (&round_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RoundNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) round_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RoundNode), 0, (GInstanceInitFunc) round_node_instance_init, NULL };
		GType round_node_type_id;
		round_node_type_id = g_type_register_static (TYPE_RNODE, "RoundNode", &g_define_type_info, 0);
		g_once_init_leave (&round_node_type_id__volatile, round_node_type_id);
	}
	return round_node_type_id__volatile;
}


PercentNode*
percent_node_construct (GType object_type,
                        Parser* parser,
                        LexerToken* token,
                        guint precedence,
                        Associativity associativity)
{
	PercentNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (PercentNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}


PercentNode*
percent_node_new (Parser* parser,
                  LexerToken* token,
                  guint precedence,
                  Associativity associativity)
{
	return percent_node_construct (TYPE_PERCENT_NODE, parser, token, precedence, associativity);
}


static Number*
percent_node_real_solve_r (RNode* base,
                           Number* r)
{
	PercentNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (PercentNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_divide_integer (r, (gint64) 100);
	result = _tmp0_;
	return result;
}


static void
percent_node_class_init (PercentNodeClass * klass)
{
	percent_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode *, Number*)) percent_node_real_solve_r;
}


static void
percent_node_instance_init (PercentNode * self)
{
}


GType
percent_node_get_type (void)
{
	static volatile gsize percent_node_type_id__volatile = 0;
	if (g_once_init_enter (&percent_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PercentNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) percent_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PercentNode), 0, (GInstanceInitFunc) percent_node_instance_init, NULL };
		GType percent_node_type_id;
		percent_node_type_id = g_type_register_static (TYPE_RNODE, "PercentNode", &g_define_type_info, 0);
		g_once_init_leave (&percent_node_type_id__volatile, percent_node_type_id);
	}
	return percent_node_type_id__volatile;
}


FactorialNode*
factorial_node_construct (GType object_type,
                          Parser* parser,
                          LexerToken* token,
                          guint precedence,
                          Associativity associativity)
{
	FactorialNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (FactorialNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}


FactorialNode*
factorial_node_new (Parser* parser,
                    LexerToken* token,
                    guint precedence,
                    Associativity associativity)
{
	return factorial_node_construct (TYPE_FACTORIAL_NODE, parser, token, precedence, associativity);
}


static Number*
factorial_node_real_solve_r (RNode* base,
                             Number* r)
{
	FactorialNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (FactorialNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_factorial (r);
	result = _tmp0_;
	return result;
}


static void
factorial_node_class_init (FactorialNodeClass * klass)
{
	factorial_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode *, Number*)) factorial_node_real_solve_r;
}


static void
factorial_node_instance_init (FactorialNode * self)
{
}


GType
factorial_node_get_type (void)
{
	static volatile gsize factorial_node_type_id__volatile = 0;
	if (g_once_init_enter (&factorial_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FactorialNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) factorial_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FactorialNode), 0, (GInstanceInitFunc) factorial_node_instance_init, NULL };
		GType factorial_node_type_id;
		factorial_node_type_id = g_type_register_static (TYPE_RNODE, "FactorialNode", &g_define_type_info, 0);
		g_once_init_leave (&factorial_node_type_id__volatile, factorial_node_type_id);
	}
	return factorial_node_type_id__volatile;
}


AddNode*
add_node_construct (GType object_type,
                    Parser* parser,
                    LexerToken* token,
                    guint precedence,
                    Associativity associativity)
{
	AddNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (AddNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}


AddNode*
add_node_new (Parser* parser,
              LexerToken* token,
              guint precedence,
              Associativity associativity)
{
	return add_node_construct (TYPE_ADD_NODE, parser, token, precedence, associativity);
}


static Number*
add_node_real_solve_lr (LRNode* base,
                        Number* l,
                        Number* r)
{
	AddNode * self;
	Number* result = NULL;
	gboolean _tmp0_;
	self = (AddNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = self->do_percentage;
	if (_tmp0_) {
		Number* per = NULL;
		Number* _tmp1_;
		Number* _tmp2_;
		Number* _tmp3_;
		Number* _tmp4_;
		Number* _tmp5_;
		Number* _tmp6_;
		Number* _tmp7_;
		Number* _tmp8_;
		_tmp1_ = number_new_integer ((gint64) 100, (gint64) 0);
		_tmp2_ = _tmp1_;
		_tmp3_ = number_add (r, _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		per = _tmp4_;
		_tmp5_ = per;
		_tmp6_ = number_divide_integer (_tmp5_, (gint64) 100);
		_g_object_unref0 (per);
		per = _tmp6_;
		_tmp7_ = per;
		_tmp8_ = number_multiply (l, _tmp7_);
		result = _tmp8_;
		_g_object_unref0 (per);
		return result;
	} else {
		Number* _tmp9_;
		_tmp9_ = number_add (l, r);
		result = _tmp9_;
		return result;
	}
}


static void
add_node_class_init (AddNodeClass * klass)
{
	add_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode *, Number*, Number*)) add_node_real_solve_lr;
	G_OBJECT_CLASS (klass)->finalize = add_node_finalize;
}


static void
add_node_instance_init (AddNode * self)
{
	self->do_percentage = FALSE;
}


static void
add_node_finalize (GObject * obj)
{
	AddNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADD_NODE, AddNode);
	G_OBJECT_CLASS (add_node_parent_class)->finalize (obj);
}


GType
add_node_get_type (void)
{
	static volatile gsize add_node_type_id__volatile = 0;
	if (g_once_init_enter (&add_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AddNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) add_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AddNode), 0, (GInstanceInitFunc) add_node_instance_init, NULL };
		GType add_node_type_id;
		add_node_type_id = g_type_register_static (TYPE_LR_NODE, "AddNode", &g_define_type_info, 0);
		g_once_init_leave (&add_node_type_id__volatile, add_node_type_id);
	}
	return add_node_type_id__volatile;
}


SubtractNode*
subtract_node_construct (GType object_type,
                         Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	SubtractNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (SubtractNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}


SubtractNode*
subtract_node_new (Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity)
{
	return subtract_node_construct (TYPE_SUBTRACT_NODE, parser, token, precedence, associativity);
}


static Number*
subtract_node_real_solve_lr (LRNode* base,
                             Number* l,
                             Number* r)
{
	SubtractNode * self;
	Number* result = NULL;
	gboolean _tmp0_;
	self = (SubtractNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = self->do_percentage;
	if (_tmp0_) {
		Number* per = NULL;
		Number* _tmp1_;
		Number* _tmp2_;
		Number* _tmp3_;
		Number* _tmp4_;
		Number* _tmp5_;
		Number* _tmp6_;
		Number* _tmp7_;
		Number* _tmp8_;
		_tmp1_ = number_new_integer ((gint64) -100, (gint64) 0);
		_tmp2_ = _tmp1_;
		_tmp3_ = number_add (r, _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		per = _tmp4_;
		_tmp5_ = per;
		_tmp6_ = number_divide_integer (_tmp5_, (gint64) -100);
		_g_object_unref0 (per);
		per = _tmp6_;
		_tmp7_ = per;
		_tmp8_ = number_multiply (l, _tmp7_);
		result = _tmp8_;
		_g_object_unref0 (per);
		return result;
	} else {
		Number* _tmp9_;
		_tmp9_ = number_subtract (l, r);
		result = _tmp9_;
		return result;
	}
}


static void
subtract_node_class_init (SubtractNodeClass * klass)
{
	subtract_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode *, Number*, Number*)) subtract_node_real_solve_lr;
	G_OBJECT_CLASS (klass)->finalize = subtract_node_finalize;
}


static void
subtract_node_instance_init (SubtractNode * self)
{
	self->do_percentage = FALSE;
}


static void
subtract_node_finalize (GObject * obj)
{
	SubtractNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUBTRACT_NODE, SubtractNode);
	G_OBJECT_CLASS (subtract_node_parent_class)->finalize (obj);
}


GType
subtract_node_get_type (void)
{
	static volatile gsize subtract_node_type_id__volatile = 0;
	if (g_once_init_enter (&subtract_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SubtractNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) subtract_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SubtractNode), 0, (GInstanceInitFunc) subtract_node_instance_init, NULL };
		GType subtract_node_type_id;
		subtract_node_type_id = g_type_register_static (TYPE_LR_NODE, "SubtractNode", &g_define_type_info, 0);
		g_once_init_leave (&subtract_node_type_id__volatile, subtract_node_type_id);
	}
	return subtract_node_type_id__volatile;
}


MultiplyNode*
multiply_node_construct (GType object_type,
                         Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	MultiplyNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (MultiplyNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}


MultiplyNode*
multiply_node_new (Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity)
{
	return multiply_node_construct (TYPE_MULTIPLY_NODE, parser, token, precedence, associativity);
}


static Number*
multiply_node_real_solve_lr (LRNode* base,
                             Number* l,
                             Number* r)
{
	MultiplyNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (MultiplyNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_multiply (l, r);
	result = _tmp0_;
	return result;
}


static void
multiply_node_class_init (MultiplyNodeClass * klass)
{
	multiply_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode *, Number*, Number*)) multiply_node_real_solve_lr;
}


static void
multiply_node_instance_init (MultiplyNode * self)
{
}


GType
multiply_node_get_type (void)
{
	static volatile gsize multiply_node_type_id__volatile = 0;
	if (g_once_init_enter (&multiply_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MultiplyNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) multiply_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultiplyNode), 0, (GInstanceInitFunc) multiply_node_instance_init, NULL };
		GType multiply_node_type_id;
		multiply_node_type_id = g_type_register_static (TYPE_LR_NODE, "MultiplyNode", &g_define_type_info, 0);
		g_once_init_leave (&multiply_node_type_id__volatile, multiply_node_type_id);
	}
	return multiply_node_type_id__volatile;
}


DivideNode*
divide_node_construct (GType object_type,
                       Parser* parser,
                       LexerToken* token,
                       guint precedence,
                       Associativity associativity)
{
	DivideNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (DivideNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}


DivideNode*
divide_node_new (Parser* parser,
                 LexerToken* token,
                 guint precedence,
                 Associativity associativity)
{
	return divide_node_construct (TYPE_DIVIDE_NODE, parser, token, precedence, associativity);
}


static Number*
divide_node_real_solve_lr (LRNode* base,
                           Number* l,
                           Number* r)
{
	DivideNode * self;
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (DivideNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_divide (l, r);
	z = _tmp0_;
	_tmp1_ = number_get_error ();
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		guint token_start = 0U;
		guint token_end = 0U;
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp3_;
		ParseNode* _tmp4_;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp5_;
		ParseNode* _tmp6_;
		ParseNode* _tmp17_;
		LexerToken* _tmp18_;
		LexerToken* _tmp19_;
		gboolean _tmp20_;
		ParseNode* _tmp25_;
		LexerToken* _tmp26_;
		LexerToken* _tmp27_;
		gboolean _tmp28_;
		Parser* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		guint _tmp36_;
		guint _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		token_start = (guint) 0;
		token_end = (guint) 0;
		_tmp3_ = ((ParseNode*) self)->right;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		tmpleft = _tmp4_;
		_tmp5_ = ((ParseNode*) self)->right;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		tmpright = _tmp6_;
		while (TRUE) {
			ParseNode* _tmp7_;
			ParseNode* _tmp8_;
			ParseNode* _tmp9_;
			ParseNode* _tmp10_;
			ParseNode* _tmp11_;
			_tmp7_ = tmpleft;
			_tmp8_ = _tmp7_->left;
			if (!(_tmp8_ != NULL)) {
				break;
			}
			_tmp9_ = tmpleft;
			_tmp10_ = _tmp9_->left;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (tmpleft);
			tmpleft = _tmp11_;
		}
		while (TRUE) {
			ParseNode* _tmp12_;
			ParseNode* _tmp13_;
			ParseNode* _tmp14_;
			ParseNode* _tmp15_;
			ParseNode* _tmp16_;
			_tmp12_ = tmpright;
			_tmp13_ = _tmp12_->right;
			if (!(_tmp13_ != NULL)) {
				break;
			}
			_tmp14_ = tmpright;
			_tmp15_ = _tmp14_->right;
			_tmp16_ = _g_object_ref0 (_tmp15_);
			_g_object_unref0 (tmpright);
			tmpright = _tmp16_;
		}
		_tmp17_ = tmpleft;
		_tmp18_ = parse_node_first_token (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_ != NULL;
		_g_object_unref0 (_tmp19_);
		if (_tmp20_) {
			ParseNode* _tmp21_;
			LexerToken* _tmp22_;
			LexerToken* _tmp23_;
			guint _tmp24_;
			_tmp21_ = tmpleft;
			_tmp22_ = parse_node_first_token (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = _tmp23_->start_index;
			token_start = _tmp24_;
			_g_object_unref0 (_tmp23_);
		}
		_tmp25_ = tmpright;
		_tmp26_ = parse_node_last_token (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_ != NULL;
		_g_object_unref0 (_tmp27_);
		if (_tmp28_) {
			ParseNode* _tmp29_;
			LexerToken* _tmp30_;
			LexerToken* _tmp31_;
			guint _tmp32_;
			_tmp29_ = tmpright;
			_tmp30_ = parse_node_last_token (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = _tmp31_->end_index;
			token_end = _tmp32_;
			_g_object_unref0 (_tmp31_);
		}
		_tmp33_ = ((ParseNode*) self)->parser;
		_tmp34_ = number_get_error ();
		_tmp35_ = _tmp34_;
		_tmp36_ = token_start;
		_tmp37_ = token_end;
		parser_set_error (_tmp33_, ERROR_CODE_MP, _tmp35_, _tmp36_, _tmp37_);
		_tmp38_ = number_get_error ();
		_tmp39_ = _tmp38_;
		number_set_error (NULL);
		_g_object_unref0 (tmpright);
		_g_object_unref0 (tmpleft);
	}
	result = z;
	return result;
}


static void
divide_node_class_init (DivideNodeClass * klass)
{
	divide_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode *, Number*, Number*)) divide_node_real_solve_lr;
}


static void
divide_node_instance_init (DivideNode * self)
{
}


GType
divide_node_get_type (void)
{
	static volatile gsize divide_node_type_id__volatile = 0;
	if (g_once_init_enter (&divide_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DivideNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) divide_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DivideNode), 0, (GInstanceInitFunc) divide_node_instance_init, NULL };
		GType divide_node_type_id;
		divide_node_type_id = g_type_register_static (TYPE_LR_NODE, "DivideNode", &g_define_type_info, 0);
		g_once_init_leave (&divide_node_type_id__volatile, divide_node_type_id);
	}
	return divide_node_type_id__volatile;
}


ModulusDivideNode*
modulus_divide_node_construct (GType object_type,
                               Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity)
{
	ModulusDivideNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ModulusDivideNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}


ModulusDivideNode*
modulus_divide_node_new (Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	return modulus_divide_node_construct (TYPE_MODULUS_DIVIDE_NODE, parser, token, precedence, associativity);
}


static Number*
modulus_divide_node_real_solve (ParseNode* base)
{
	ModulusDivideNode * self;
	Number* result = NULL;
	ParseNode* _tmp0_;
	self = (ModulusDivideNode*) base;
	_tmp0_ = ((ParseNode*) self)->left;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_XPOW_YNODE)) {
		Number* base_value = NULL;
		ParseNode* _tmp1_;
		ParseNode* _tmp2_;
		Number* _tmp3_;
		Number* exponent = NULL;
		ParseNode* _tmp4_;
		ParseNode* _tmp5_;
		Number* _tmp6_;
		Number* mod = NULL;
		ParseNode* _tmp7_;
		Number* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		Number* _tmp11_;
		Number* z = NULL;
		Number* _tmp14_;
		Number* _tmp15_;
		Number* _tmp16_;
		Number* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp1_ = ((ParseNode*) self)->left;
		_tmp2_ = _tmp1_->left;
		_tmp3_ = parse_node_solve (_tmp2_);
		base_value = _tmp3_;
		_tmp4_ = ((ParseNode*) self)->left;
		_tmp5_ = _tmp4_->right;
		_tmp6_ = parse_node_solve (_tmp5_);
		exponent = _tmp6_;
		_tmp7_ = ((ParseNode*) self)->right;
		_tmp8_ = parse_node_solve (_tmp7_);
		mod = _tmp8_;
		_tmp11_ = base_value;
		if (_tmp11_ == NULL) {
			_tmp10_ = TRUE;
		} else {
			Number* _tmp12_;
			_tmp12_ = exponent;
			_tmp10_ = _tmp12_ == NULL;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			Number* _tmp13_;
			_tmp13_ = mod;
			_tmp9_ = _tmp13_ == NULL;
		}
		if (_tmp9_) {
			result = NULL;
			_g_object_unref0 (mod);
			_g_object_unref0 (exponent);
			_g_object_unref0 (base_value);
			return result;
		}
		_tmp14_ = base_value;
		_tmp15_ = exponent;
		_tmp16_ = mod;
		_tmp17_ = number_modular_exponentiation (_tmp14_, _tmp15_, _tmp16_);
		z = _tmp17_;
		number_check_flags ();
		_tmp18_ = number_get_error ();
		_tmp19_ = _tmp18_;
		if (_tmp19_ != NULL) {
			ParseNode* tmpleft = NULL;
			ParseNode* _tmp20_;
			ParseNode* _tmp21_;
			ParseNode* tmpright = NULL;
			ParseNode* _tmp22_;
			ParseNode* _tmp23_;
			Parser* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			ParseNode* _tmp37_;
			LexerToken* _tmp38_;
			LexerToken* _tmp39_;
			guint _tmp40_;
			ParseNode* _tmp41_;
			LexerToken* _tmp42_;
			LexerToken* _tmp43_;
			guint _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			_tmp20_ = ((ParseNode*) self)->left;
			_tmp21_ = _g_object_ref0 (_tmp20_);
			tmpleft = _tmp21_;
			_tmp22_ = ((ParseNode*) self)->right;
			_tmp23_ = _g_object_ref0 (_tmp22_);
			tmpright = _tmp23_;
			while (TRUE) {
				ParseNode* _tmp24_;
				ParseNode* _tmp25_;
				ParseNode* _tmp26_;
				ParseNode* _tmp27_;
				ParseNode* _tmp28_;
				_tmp24_ = tmpleft;
				_tmp25_ = _tmp24_->left;
				if (!(_tmp25_ != NULL)) {
					break;
				}
				_tmp26_ = tmpleft;
				_tmp27_ = _tmp26_->left;
				_tmp28_ = _g_object_ref0 (_tmp27_);
				_g_object_unref0 (tmpleft);
				tmpleft = _tmp28_;
			}
			while (TRUE) {
				ParseNode* _tmp29_;
				ParseNode* _tmp30_;
				ParseNode* _tmp31_;
				ParseNode* _tmp32_;
				ParseNode* _tmp33_;
				_tmp29_ = tmpright;
				_tmp30_ = _tmp29_->right;
				if (!(_tmp30_ != NULL)) {
					break;
				}
				_tmp31_ = tmpright;
				_tmp32_ = _tmp31_->right;
				_tmp33_ = _g_object_ref0 (_tmp32_);
				_g_object_unref0 (tmpright);
				tmpright = _tmp33_;
			}
			_tmp34_ = ((ParseNode*) self)->parser;
			_tmp35_ = number_get_error ();
			_tmp36_ = _tmp35_;
			_tmp37_ = tmpleft;
			_tmp38_ = parse_node_first_token (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = _tmp39_->start_index;
			_tmp41_ = tmpright;
			_tmp42_ = parse_node_last_token (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = _tmp43_->end_index;
			parser_set_error (_tmp34_, ERROR_CODE_MP, _tmp36_, _tmp40_, _tmp44_);
			_g_object_unref0 (_tmp43_);
			_g_object_unref0 (_tmp39_);
			_tmp45_ = number_get_error ();
			_tmp46_ = _tmp45_;
			number_set_error (NULL);
			_g_object_unref0 (tmpright);
			_g_object_unref0 (tmpleft);
		}
		result = z;
		_g_object_unref0 (mod);
		_g_object_unref0 (exponent);
		_g_object_unref0 (base_value);
		return result;
	} else {
		Number* l = NULL;
		ParseNode* _tmp47_;
		Number* _tmp48_;
		Number* r = NULL;
		ParseNode* _tmp49_;
		Number* _tmp50_;
		gboolean _tmp51_ = FALSE;
		Number* _tmp52_;
		Number* z = NULL;
		Number* _tmp54_;
		Number* _tmp55_;
		Number* _tmp56_;
		const gchar* _tmp57_;
		const gchar* _tmp58_;
		_tmp47_ = ((ParseNode*) self)->left;
		_tmp48_ = parse_node_solve (_tmp47_);
		l = _tmp48_;
		_tmp49_ = ((ParseNode*) self)->right;
		_tmp50_ = parse_node_solve (_tmp49_);
		r = _tmp50_;
		_tmp52_ = l;
		if (_tmp52_ == NULL) {
			_tmp51_ = TRUE;
		} else {
			Number* _tmp53_;
			_tmp53_ = r;
			_tmp51_ = _tmp53_ == NULL;
		}
		if (_tmp51_) {
			result = NULL;
			_g_object_unref0 (r);
			_g_object_unref0 (l);
			return result;
		}
		_tmp54_ = l;
		_tmp55_ = r;
		_tmp56_ = lr_node_solve_lr ((LRNode*) self, _tmp54_, _tmp55_);
		z = _tmp56_;
		number_check_flags ();
		_tmp57_ = number_get_error ();
		_tmp58_ = _tmp57_;
		if (_tmp58_ != NULL) {
			ParseNode* tmpleft = NULL;
			ParseNode* _tmp59_;
			ParseNode* _tmp60_;
			ParseNode* tmpright = NULL;
			ParseNode* _tmp61_;
			ParseNode* _tmp62_;
			Parser* _tmp73_;
			const gchar* _tmp74_;
			const gchar* _tmp75_;
			ParseNode* _tmp76_;
			LexerToken* _tmp77_;
			LexerToken* _tmp78_;
			guint _tmp79_;
			ParseNode* _tmp80_;
			LexerToken* _tmp81_;
			LexerToken* _tmp82_;
			guint _tmp83_;
			const gchar* _tmp84_;
			const gchar* _tmp85_;
			_tmp59_ = ((ParseNode*) self)->left;
			_tmp60_ = _g_object_ref0 (_tmp59_);
			tmpleft = _tmp60_;
			_tmp61_ = ((ParseNode*) self)->right;
			_tmp62_ = _g_object_ref0 (_tmp61_);
			tmpright = _tmp62_;
			while (TRUE) {
				ParseNode* _tmp63_;
				ParseNode* _tmp64_;
				ParseNode* _tmp65_;
				ParseNode* _tmp66_;
				ParseNode* _tmp67_;
				_tmp63_ = tmpleft;
				_tmp64_ = _tmp63_->left;
				if (!(_tmp64_ != NULL)) {
					break;
				}
				_tmp65_ = tmpleft;
				_tmp66_ = _tmp65_->left;
				_tmp67_ = _g_object_ref0 (_tmp66_);
				_g_object_unref0 (tmpleft);
				tmpleft = _tmp67_;
			}
			while (TRUE) {
				ParseNode* _tmp68_;
				ParseNode* _tmp69_;
				ParseNode* _tmp70_;
				ParseNode* _tmp71_;
				ParseNode* _tmp72_;
				_tmp68_ = tmpright;
				_tmp69_ = _tmp68_->right;
				if (!(_tmp69_ != NULL)) {
					break;
				}
				_tmp70_ = tmpright;
				_tmp71_ = _tmp70_->right;
				_tmp72_ = _g_object_ref0 (_tmp71_);
				_g_object_unref0 (tmpright);
				tmpright = _tmp72_;
			}
			_tmp73_ = ((ParseNode*) self)->parser;
			_tmp74_ = number_get_error ();
			_tmp75_ = _tmp74_;
			_tmp76_ = tmpleft;
			_tmp77_ = parse_node_first_token (_tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = _tmp78_->start_index;
			_tmp80_ = tmpright;
			_tmp81_ = parse_node_last_token (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = _tmp82_->end_index;
			parser_set_error (_tmp73_, ERROR_CODE_MP, _tmp75_, _tmp79_, _tmp83_);
			_g_object_unref0 (_tmp82_);
			_g_object_unref0 (_tmp78_);
			_tmp84_ = number_get_error ();
			_tmp85_ = _tmp84_;
			number_set_error (NULL);
			_g_object_unref0 (tmpright);
			_g_object_unref0 (tmpleft);
		}
		result = z;
		_g_object_unref0 (r);
		_g_object_unref0 (l);
		return result;
	}
}


static Number*
modulus_divide_node_real_solve_lr (LRNode* base,
                                   Number* l,
                                   Number* r)
{
	ModulusDivideNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (ModulusDivideNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_modulus_divide (l, r);
	result = _tmp0_;
	return result;
}


static void
modulus_divide_node_class_init (ModulusDivideNodeClass * klass)
{
	modulus_divide_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode *)) modulus_divide_node_real_solve;
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode *, Number*, Number*)) modulus_divide_node_real_solve_lr;
}


static void
modulus_divide_node_instance_init (ModulusDivideNode * self)
{
}


GType
modulus_divide_node_get_type (void)
{
	static volatile gsize modulus_divide_node_type_id__volatile = 0;
	if (g_once_init_enter (&modulus_divide_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ModulusDivideNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) modulus_divide_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ModulusDivideNode), 0, (GInstanceInitFunc) modulus_divide_node_instance_init, NULL };
		GType modulus_divide_node_type_id;
		modulus_divide_node_type_id = g_type_register_static (TYPE_LR_NODE, "ModulusDivideNode", &g_define_type_info, 0);
		g_once_init_leave (&modulus_divide_node_type_id__volatile, modulus_divide_node_type_id);
	}
	return modulus_divide_node_type_id__volatile;
}


RootNode*
root_node_construct (GType object_type,
                     Parser* parser,
                     LexerToken* token,
                     guint precedence,
                     Associativity associativity,
                     gint n)
{
	RootNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (RootNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	self->priv->n = n;
	_g_object_unref0 (self->priv->token_n);
	self->priv->token_n = NULL;
	return self;
}


RootNode*
root_node_new (Parser* parser,
               LexerToken* token,
               guint precedence,
               Associativity associativity,
               gint n)
{
	return root_node_construct (TYPE_ROOT_NODE, parser, token, precedence, associativity, n);
}


RootNode*
root_node_construct_WithToken (GType object_type,
                               Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity,
                               LexerToken* token_n)
{
	RootNode * self = NULL;
	LexerToken* _tmp0_;
	g_return_val_if_fail (parser != NULL, NULL);
	g_return_val_if_fail (token_n != NULL, NULL);
	self = (RootNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	self->priv->n = 0;
	_tmp0_ = _g_object_ref0 (token_n);
	_g_object_unref0 (self->priv->token_n);
	self->priv->token_n = _tmp0_;
	return self;
}


RootNode*
root_node_new_WithToken (Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity,
                         LexerToken* token_n)
{
	return root_node_construct_WithToken (TYPE_ROOT_NODE, parser, token, precedence, associativity, token_n);
}


static Number*
root_node_real_solve_r (RNode* base,
                        Number* r)
{
	RootNode * self;
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp5_;
	gint _tmp13_;
	Number* _tmp14_;
	self = (RootNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp1_ = self->priv->n;
	if (_tmp1_ == 0) {
		LexerToken* _tmp2_;
		_tmp2_ = self->priv->token_n;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		LexerToken* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->token_n;
		_tmp4_ = _tmp3_->text;
		self->priv->n = sub_atoi (_tmp4_);
	}
	_tmp5_ = self->priv->n;
	if (_tmp5_ == 0) {
		gchar* _error_ = NULL;
		gchar* _tmp6_;
		Parser* _tmp7_;
		const gchar* _tmp8_;
		LexerToken* _tmp9_;
		guint _tmp10_;
		LexerToken* _tmp11_;
		guint _tmp12_;
		_tmp6_ = g_strdup (_ ("The zeroth root of a number is undefined"));
		_error_ = _tmp6_;
		_tmp7_ = ((ParseNode*) self)->parser;
		_tmp8_ = _error_;
		_tmp9_ = self->priv->token_n;
		_tmp10_ = _tmp9_->start_index;
		_tmp11_ = self->priv->token_n;
		_tmp12_ = _tmp11_->end_index;
		parser_set_error (_tmp7_, ERROR_CODE_MP, _tmp8_, _tmp10_, _tmp12_);
		result = NULL;
		_g_free0 (_error_);
		return result;
	}
	_tmp13_ = self->priv->n;
	_tmp14_ = number_root (r, (gint64) _tmp13_);
	result = _tmp14_;
	return result;
}


static void
root_node_class_init (RootNodeClass * klass)
{
	root_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RootNodePrivate));
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode *, Number*)) root_node_real_solve_r;
	G_OBJECT_CLASS (klass)->finalize = root_node_finalize;
}


static void
root_node_instance_init (RootNode * self)
{
	self->priv = ROOT_NODE_GET_PRIVATE (self);
}


static void
root_node_finalize (GObject * obj)
{
	RootNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ROOT_NODE, RootNode);
	_g_object_unref0 (self->priv->token_n);
	G_OBJECT_CLASS (root_node_parent_class)->finalize (obj);
}


GType
root_node_get_type (void)
{
	static volatile gsize root_node_type_id__volatile = 0;
	if (g_once_init_enter (&root_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RootNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) root_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RootNode), 0, (GInstanceInitFunc) root_node_instance_init, NULL };
		GType root_node_type_id;
		root_node_type_id = g_type_register_static (TYPE_RNODE, "RootNode", &g_define_type_info, 0);
		g_once_init_leave (&root_node_type_id__volatile, root_node_type_id);
	}
	return root_node_type_id__volatile;
}


XPowYNode*
xpow_ynode_construct (GType object_type,
                      Parser* parser,
                      LexerToken* token,
                      guint precedence,
                      Associativity associativity)
{
	XPowYNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (XPowYNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}


XPowYNode*
xpow_ynode_new (Parser* parser,
                LexerToken* token,
                guint precedence,
                Associativity associativity)
{
	return xpow_ynode_construct (TYPE_XPOW_YNODE, parser, token, precedence, associativity);
}


static Number*
xpow_ynode_real_solve_lr (LRNode* base,
                          Number* l,
                          Number* r)
{
	XPowYNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (XPowYNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_xpowy (l, r);
	result = _tmp0_;
	return result;
}


static void
xpow_ynode_class_init (XPowYNodeClass * klass)
{
	xpow_ynode_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode *, Number*, Number*)) xpow_ynode_real_solve_lr;
}


static void
xpow_ynode_instance_init (XPowYNode * self)
{
}


GType
xpow_ynode_get_type (void)
{
	static volatile gsize xpow_ynode_type_id__volatile = 0;
	if (g_once_init_enter (&xpow_ynode_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XPowYNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xpow_ynode_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XPowYNode), 0, (GInstanceInitFunc) xpow_ynode_instance_init, NULL };
		GType xpow_ynode_type_id;
		xpow_ynode_type_id = g_type_register_static (TYPE_LR_NODE, "XPowYNode", &g_define_type_info, 0);
		g_once_init_leave (&xpow_ynode_type_id__volatile, xpow_ynode_type_id);
	}
	return xpow_ynode_type_id__volatile;
}


XPowYIntegerNode*
xpow_yinteger_node_construct (GType object_type,
                              Parser* parser,
                              LexerToken* token,
                              guint precedence,
                              Associativity associativity)
{
	XPowYIntegerNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (XPowYIntegerNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}


XPowYIntegerNode*
xpow_yinteger_node_new (Parser* parser,
                        LexerToken* token,
                        guint precedence,
                        Associativity associativity)
{
	return xpow_yinteger_node_construct (TYPE_XPOW_YINTEGER_NODE, parser, token, precedence, associativity);
}


static Number*
xpow_yinteger_node_real_solve (ParseNode* base)
{
	XPowYIntegerNode * self;
	Number* result = NULL;
	Number* val = NULL;
	ParseNode* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	gint64 pow = 0LL;
	ParseNode* _tmp8_;
	LexerToken* _tmp9_;
	LexerToken* _tmp10_;
	gboolean _tmp11_;
	Number* _tmp19_;
	Number* z = NULL;
	Number* _tmp20_;
	gint64 _tmp21_;
	Number* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	self = (XPowYIntegerNode*) base;
	_tmp0_ = ((ParseNode*) self)->left;
	_tmp1_ = parse_node_solve (_tmp0_);
	val = _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ == NULL) {
		ParseNode* _tmp3_;
		LexerToken* _tmp4_;
		LexerToken* _tmp5_;
		const gchar* _tmp6_;
		Number* _tmp7_;
		_tmp3_ = ((ParseNode*) self)->left;
		_tmp4_ = parse_node_token (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_->text;
		_tmp7_ = number_new_integer ((gint64) super_atoi (_tmp6_), (gint64) 0);
		_g_object_unref0 (val);
		val = _tmp7_;
		_g_object_unref0 (_tmp5_);
	}
	_tmp8_ = ((ParseNode*) self)->right;
	_tmp9_ = parse_node_token (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_ != NULL;
	_g_object_unref0 (_tmp10_);
	if (_tmp11_) {
		ParseNode* _tmp12_;
		LexerToken* _tmp13_;
		LexerToken* _tmp14_;
		const gchar* _tmp15_;
		_tmp12_ = ((ParseNode*) self)->right;
		_tmp13_ = parse_node_token (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->text;
		pow = (gint64) super_atoi (_tmp15_);
		_g_object_unref0 (_tmp14_);
	} else {
		ParseNode* _tmp16_;
		Number* _tmp17_;
		Number* _tmp18_;
		_tmp16_ = ((ParseNode*) self)->right;
		_tmp17_ = parse_node_solve (_tmp16_);
		_tmp18_ = _tmp17_;
		pow = number_to_integer (_tmp18_);
		_g_object_unref0 (_tmp18_);
	}
	_tmp19_ = val;
	if (_tmp19_ == NULL) {
		result = NULL;
		_g_object_unref0 (val);
		return result;
	}
	_tmp20_ = val;
	_tmp21_ = pow;
	_tmp22_ = number_xpowy_integer (_tmp20_, _tmp21_);
	z = _tmp22_;
	number_check_flags ();
	_tmp23_ = number_get_error ();
	_tmp24_ = _tmp23_;
	if (_tmp24_ != NULL) {
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp25_;
		ParseNode* _tmp26_;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp27_;
		ParseNode* _tmp28_;
		Parser* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		ParseNode* _tmp42_;
		LexerToken* _tmp43_;
		LexerToken* _tmp44_;
		guint _tmp45_;
		ParseNode* _tmp46_;
		LexerToken* _tmp47_;
		LexerToken* _tmp48_;
		guint _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		_tmp25_ = ((ParseNode*) self)->left;
		_tmp26_ = _g_object_ref0 (_tmp25_);
		tmpleft = _tmp26_;
		_tmp27_ = ((ParseNode*) self)->right;
		_tmp28_ = _g_object_ref0 (_tmp27_);
		tmpright = _tmp28_;
		while (TRUE) {
			ParseNode* _tmp29_;
			ParseNode* _tmp30_;
			ParseNode* _tmp31_;
			ParseNode* _tmp32_;
			ParseNode* _tmp33_;
			_tmp29_ = tmpleft;
			_tmp30_ = _tmp29_->left;
			if (!(_tmp30_ != NULL)) {
				break;
			}
			_tmp31_ = tmpleft;
			_tmp32_ = _tmp31_->left;
			_tmp33_ = _g_object_ref0 (_tmp32_);
			_g_object_unref0 (tmpleft);
			tmpleft = _tmp33_;
		}
		while (TRUE) {
			ParseNode* _tmp34_;
			ParseNode* _tmp35_;
			ParseNode* _tmp36_;
			ParseNode* _tmp37_;
			ParseNode* _tmp38_;
			_tmp34_ = tmpright;
			_tmp35_ = _tmp34_->right;
			if (!(_tmp35_ != NULL)) {
				break;
			}
			_tmp36_ = tmpright;
			_tmp37_ = _tmp36_->right;
			_tmp38_ = _g_object_ref0 (_tmp37_);
			_g_object_unref0 (tmpright);
			tmpright = _tmp38_;
		}
		_tmp39_ = ((ParseNode*) self)->parser;
		_tmp40_ = number_get_error ();
		_tmp41_ = _tmp40_;
		_tmp42_ = tmpleft;
		_tmp43_ = parse_node_first_token (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = _tmp44_->start_index;
		_tmp46_ = tmpright;
		_tmp47_ = parse_node_last_token (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = _tmp48_->end_index;
		parser_set_error (_tmp39_, ERROR_CODE_MP, _tmp41_, _tmp45_, _tmp49_);
		_g_object_unref0 (_tmp48_);
		_g_object_unref0 (_tmp44_);
		_tmp50_ = number_get_error ();
		_tmp51_ = _tmp50_;
		number_set_error (NULL);
		_g_object_unref0 (tmpright);
		_g_object_unref0 (tmpleft);
	}
	result = z;
	_g_object_unref0 (val);
	return result;
}


static void
xpow_yinteger_node_class_init (XPowYIntegerNodeClass * klass)
{
	xpow_yinteger_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode *)) xpow_yinteger_node_real_solve;
}


static void
xpow_yinteger_node_instance_init (XPowYIntegerNode * self)
{
}


/**
 * This class is a XPowY in which the right token is an nsup number.
 */
GType
xpow_yinteger_node_get_type (void)
{
	static volatile gsize xpow_yinteger_node_type_id__volatile = 0;
	if (g_once_init_enter (&xpow_yinteger_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XPowYIntegerNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xpow_yinteger_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XPowYIntegerNode), 0, (GInstanceInitFunc) xpow_yinteger_node_instance_init, NULL };
		GType xpow_yinteger_node_type_id;
		xpow_yinteger_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "XPowYIntegerNode", &g_define_type_info, 0);
		g_once_init_leave (&xpow_yinteger_node_type_id__volatile, xpow_yinteger_node_type_id);
	}
	return xpow_yinteger_node_type_id__volatile;
}


NotNode*
not_node_construct (GType object_type,
                    Parser* parser,
                    LexerToken* token,
                    guint precedence,
                    Associativity associativity)
{
	NotNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (NotNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}


NotNode*
not_node_new (Parser* parser,
              LexerToken* token,
              guint precedence,
              Associativity associativity)
{
	return not_node_construct (TYPE_NOT_NODE, parser, token, precedence, associativity);
}


static Number*
not_node_real_solve_r (RNode* base,
                       Number* r)
{
	NotNode * self;
	Number* result = NULL;
	Parser* _tmp0_;
	gint _tmp1_;
	Parser* _tmp4_;
	gint _tmp5_;
	Number* _tmp6_;
	self = (NotNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = ((ParseNode*) self)->parser;
	_tmp1_ = _tmp0_->wordlen;
	if (!mp_is_overflow (r, _tmp1_)) {
		Parser* _tmp2_;
		Number* _tmp3_;
		_tmp2_ = ((ParseNode*) self)->parser;
		parser_set_error (_tmp2_, ERROR_CODE_OVERFLOW, NULL, (guint) 0, (guint) 0);
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = ((ParseNode*) self)->parser;
	_tmp5_ = _tmp4_->wordlen;
	_tmp6_ = number_not (r, _tmp5_);
	result = _tmp6_;
	return result;
}


static void
not_node_class_init (NotNodeClass * klass)
{
	not_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode *, Number*)) not_node_real_solve_r;
}


static void
not_node_instance_init (NotNode * self)
{
}


GType
not_node_get_type (void)
{
	static volatile gsize not_node_type_id__volatile = 0;
	if (g_once_init_enter (&not_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) not_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotNode), 0, (GInstanceInitFunc) not_node_instance_init, NULL };
		GType not_node_type_id;
		not_node_type_id = g_type_register_static (TYPE_RNODE, "NotNode", &g_define_type_info, 0);
		g_once_init_leave (&not_node_type_id__volatile, not_node_type_id);
	}
	return not_node_type_id__volatile;
}


AndNode*
and_node_construct (GType object_type,
                    Parser* parser,
                    LexerToken* token,
                    guint precedence,
                    Associativity associativity)
{
	AndNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (AndNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}


AndNode*
and_node_new (Parser* parser,
              LexerToken* token,
              guint precedence,
              Associativity associativity)
{
	return and_node_construct (TYPE_AND_NODE, parser, token, precedence, associativity);
}


static Number*
and_node_real_solve_lr (LRNode* base,
                        Number* l,
                        Number* r)
{
	AndNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (AndNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_and (l, r);
	result = _tmp0_;
	return result;
}


static void
and_node_class_init (AndNodeClass * klass)
{
	and_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode *, Number*, Number*)) and_node_real_solve_lr;
}


static void
and_node_instance_init (AndNode * self)
{
}


GType
and_node_get_type (void)
{
	static volatile gsize and_node_type_id__volatile = 0;
	if (g_once_init_enter (&and_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AndNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) and_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AndNode), 0, (GInstanceInitFunc) and_node_instance_init, NULL };
		GType and_node_type_id;
		and_node_type_id = g_type_register_static (TYPE_LR_NODE, "AndNode", &g_define_type_info, 0);
		g_once_init_leave (&and_node_type_id__volatile, and_node_type_id);
	}
	return and_node_type_id__volatile;
}


OrNode*
or_node_construct (GType object_type,
                   Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity)
{
	OrNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (OrNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}


OrNode*
or_node_new (Parser* parser,
             LexerToken* token,
             guint precedence,
             Associativity associativity)
{
	return or_node_construct (TYPE_OR_NODE, parser, token, precedence, associativity);
}


static Number*
or_node_real_solve_lr (LRNode* base,
                       Number* l,
                       Number* r)
{
	OrNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (OrNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_or (l, r);
	result = _tmp0_;
	return result;
}


static void
or_node_class_init (OrNodeClass * klass)
{
	or_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode *, Number*, Number*)) or_node_real_solve_lr;
}


static void
or_node_instance_init (OrNode * self)
{
}


GType
or_node_get_type (void)
{
	static volatile gsize or_node_type_id__volatile = 0;
	if (g_once_init_enter (&or_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (OrNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) or_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OrNode), 0, (GInstanceInitFunc) or_node_instance_init, NULL };
		GType or_node_type_id;
		or_node_type_id = g_type_register_static (TYPE_LR_NODE, "OrNode", &g_define_type_info, 0);
		g_once_init_leave (&or_node_type_id__volatile, or_node_type_id);
	}
	return or_node_type_id__volatile;
}


XorNode*
xor_node_construct (GType object_type,
                    Parser* parser,
                    LexerToken* token,
                    guint precedence,
                    Associativity associativity)
{
	XorNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (XorNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}


XorNode*
xor_node_new (Parser* parser,
              LexerToken* token,
              guint precedence,
              Associativity associativity)
{
	return xor_node_construct (TYPE_XOR_NODE, parser, token, precedence, associativity);
}


static Number*
xor_node_real_solve_lr (LRNode* base,
                        Number* l,
                        Number* r)
{
	XorNode * self;
	Number* result = NULL;
	Number* _tmp0_;
	self = (XorNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_xor (l, r);
	result = _tmp0_;
	return result;
}


static void
xor_node_class_init (XorNodeClass * klass)
{
	xor_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode *, Number*, Number*)) xor_node_real_solve_lr;
}


static void
xor_node_instance_init (XorNode * self)
{
}


GType
xor_node_get_type (void)
{
	static volatile gsize xor_node_type_id__volatile = 0;
	if (g_once_init_enter (&xor_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XorNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xor_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XorNode), 0, (GInstanceInitFunc) xor_node_instance_init, NULL };
		GType xor_node_type_id;
		xor_node_type_id = g_type_register_static (TYPE_LR_NODE, "XorNode", &g_define_type_info, 0);
		g_once_init_leave (&xor_node_type_id__volatile, xor_node_type_id);
	}
	return xor_node_type_id__volatile;
}


ConvertNode*
convert_node_construct (GType object_type,
                        Parser* parser,
                        LexerToken* token,
                        guint precedence,
                        Associativity associativity)
{
	ConvertNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ConvertNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}


ConvertNode*
convert_node_new (Parser* parser,
                  LexerToken* token,
                  guint precedence,
                  Associativity associativity)
{
	return convert_node_construct (TYPE_CONVERT_NODE, parser, token, precedence, associativity);
}


static Number*
convert_node_real_solve_lr (LRNode* base,
                            Number* l,
                            Number* r)
{
	ConvertNode * self;
	Number* result = NULL;
	gchar* from = NULL;
	ParseNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* to = NULL;
	ParseNode* _tmp11_;
	const gchar* _tmp12_;
	Number* tmp = NULL;
	Number* _tmp22_;
	Number* ans = NULL;
	Parser* _tmp23_;
	Number* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	Number* _tmp27_;
	Number* _tmp28_;
	self = (ConvertNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = ((ParseNode*) self)->left;
	_tmp1_ = _tmp0_->value;
	if (_tmp1_ != NULL) {
		ParseNode* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		ParseNode* _tmp5_;
		_tmp2_ = ((ParseNode*) self)->left;
		_tmp3_ = _tmp2_->value;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (from);
		from = _tmp4_;
		_tmp5_ = ((ParseNode*) self)->left;
		_g_free0 (_tmp5_->value);
		_tmp5_->value = NULL;
	} else {
		ParseNode* _tmp6_;
		LexerToken* _tmp7_;
		LexerToken* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = ((ParseNode*) self)->left;
		_tmp7_ = parse_node_token (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_->text;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (from);
		from = _tmp10_;
		_g_object_unref0 (_tmp8_);
	}
	_tmp11_ = ((ParseNode*) self)->right;
	_tmp12_ = _tmp11_->value;
	if (_tmp12_ != NULL) {
		ParseNode* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		ParseNode* _tmp16_;
		_tmp13_ = ((ParseNode*) self)->right;
		_tmp14_ = _tmp13_->value;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (to);
		to = _tmp15_;
		_tmp16_ = ((ParseNode*) self)->right;
		_g_free0 (_tmp16_->value);
		_tmp16_->value = NULL;
	} else {
		ParseNode* _tmp17_;
		LexerToken* _tmp18_;
		LexerToken* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp17_ = ((ParseNode*) self)->right;
		_tmp18_ = parse_node_token (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_->text;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (to);
		to = _tmp21_;
		_g_object_unref0 (_tmp19_);
	}
	_tmp22_ = number_new_integer ((gint64) 1, (gint64) 0);
	tmp = _tmp22_;
	_tmp23_ = ((ParseNode*) self)->parser;
	_tmp24_ = tmp;
	_tmp25_ = from;
	_tmp26_ = to;
	_tmp27_ = parser_convert (_tmp23_, _tmp24_, _tmp25_, _tmp26_);
	ans = _tmp27_;
	_tmp28_ = ans;
	if (_tmp28_ == NULL) {
		Parser* _tmp29_;
		_tmp29_ = ((ParseNode*) self)->parser;
		parser_set_error (_tmp29_, ERROR_CODE_UNKNOWN_CONVERSION, NULL, (guint) 0, (guint) 0);
	}
	result = ans;
	_g_object_unref0 (tmp);
	_g_free0 (to);
	_g_free0 (from);
	return result;
}


static void
convert_node_class_init (ConvertNodeClass * klass)
{
	convert_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode *, Number*, Number*)) convert_node_real_solve_lr;
}


static void
convert_node_instance_init (ConvertNode * self)
{
}


GType
convert_node_get_type (void)
{
	static volatile gsize convert_node_type_id__volatile = 0;
	if (g_once_init_enter (&convert_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConvertNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) convert_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConvertNode), 0, (GInstanceInitFunc) convert_node_instance_init, NULL };
		GType convert_node_type_id;
		convert_node_type_id = g_type_register_static (TYPE_LR_NODE, "ConvertNode", &g_define_type_info, 0);
		g_once_init_leave (&convert_node_type_id__volatile, convert_node_type_id);
	}
	return convert_node_type_id__volatile;
}


ConvertBaseNode*
convert_base_node_construct (GType object_type,
                             Parser* parser,
                             LexerToken* token,
                             guint precedence,
                             Associativity associativity,
                             const gchar* value)
{
	ConvertBaseNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ConvertBaseNode*) parse_node_construct (object_type, parser, token, precedence, associativity, value);
	return self;
}


ConvertBaseNode*
convert_base_node_new (Parser* parser,
                       LexerToken* token,
                       guint precedence,
                       Associativity associativity,
                       const gchar* value)
{
	return convert_base_node_construct (TYPE_CONVERT_BASE_NODE, parser, token, precedence, associativity, value);
}


static Number*
convert_base_node_real_solve (ParseNode* base)
{
	ConvertBaseNode * self;
	Number* result = NULL;
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	ParseNode* _tmp36_;
	Number* _tmp37_;
	self = (ConvertBaseNode*) base;
	_tmp0_ = ((ParseNode*) self)->value;
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp3_ = name;
	if (_tmp3_ == NULL) {
		ParseNode* _tmp4_;
		_tmp4_ = ((ParseNode*) self)->right;
		_tmp2_ = _tmp4_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ParseNode* _tmp5_;
		LexerToken* _tmp6_;
		LexerToken* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = ((ParseNode*) self)->right;
		_tmp6_ = parse_node_token (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->text;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (name);
		name = _tmp9_;
		_g_object_unref0 (_tmp7_);
	}
	_tmp11_ = name;
	if (g_strcmp0 (_tmp11_, "hex") == 0) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = name;
		_tmp10_ = g_strcmp0 (_tmp12_, "hexadecimal") == 0;
	}
	if (_tmp10_) {
		Parser* _tmp13_;
		_tmp13_ = ((ParseNode*) self)->parser;
		parser_set_representation_base (_tmp13_, (guint) 16);
	} else {
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		_tmp15_ = name;
		if (g_strcmp0 (_tmp15_, "dec") == 0) {
			_tmp14_ = TRUE;
		} else {
			const gchar* _tmp16_;
			_tmp16_ = name;
			_tmp14_ = g_strcmp0 (_tmp16_, "decimal") == 0;
		}
		if (_tmp14_) {
			Parser* _tmp17_;
			_tmp17_ = ((ParseNode*) self)->parser;
			parser_set_representation_base (_tmp17_, (guint) 10);
		} else {
			gboolean _tmp18_ = FALSE;
			const gchar* _tmp19_;
			_tmp19_ = name;
			if (g_strcmp0 (_tmp19_, "oct") == 0) {
				_tmp18_ = TRUE;
			} else {
				const gchar* _tmp20_;
				_tmp20_ = name;
				_tmp18_ = g_strcmp0 (_tmp20_, "octal") == 0;
			}
			if (_tmp18_) {
				Parser* _tmp21_;
				_tmp21_ = ((ParseNode*) self)->parser;
				parser_set_representation_base (_tmp21_, (guint) 8);
			} else {
				gboolean _tmp22_ = FALSE;
				const gchar* _tmp23_;
				_tmp23_ = name;
				if (g_strcmp0 (_tmp23_, "bin") == 0) {
					_tmp22_ = TRUE;
				} else {
					const gchar* _tmp24_;
					_tmp24_ = name;
					_tmp22_ = g_strcmp0 (_tmp24_, "binary") == 0;
				}
				if (_tmp22_) {
					Parser* _tmp25_;
					_tmp25_ = ((ParseNode*) self)->parser;
					parser_set_representation_base (_tmp25_, (guint) 2);
				} else {
					Parser* _tmp26_;
					LexerToken* _tmp27_;
					LexerToken* _tmp28_;
					const gchar* _tmp29_;
					LexerToken* _tmp30_;
					LexerToken* _tmp31_;
					guint _tmp32_;
					LexerToken* _tmp33_;
					LexerToken* _tmp34_;
					guint _tmp35_;
					_tmp26_ = ((ParseNode*) self)->parser;
					_tmp27_ = parse_node_token ((ParseNode*) self);
					_tmp28_ = _tmp27_;
					_tmp29_ = _tmp28_->text;
					_tmp30_ = parse_node_first_token ((ParseNode*) self);
					_tmp31_ = _tmp30_;
					_tmp32_ = _tmp31_->start_index;
					_tmp33_ = parse_node_last_token ((ParseNode*) self);
					_tmp34_ = _tmp33_;
					_tmp35_ = _tmp34_->end_index;
					parser_set_error (_tmp26_, ERROR_CODE_UNKNOWN_CONVERSION, _tmp29_, _tmp32_, _tmp35_);
					_g_object_unref0 (_tmp34_);
					_g_object_unref0 (_tmp31_);
					_g_object_unref0 (_tmp28_);
					result = NULL;
					_g_free0 (name);
					return result;
				}
			}
		}
	}
	_tmp36_ = ((ParseNode*) self)->left;
	_tmp37_ = parse_node_solve (_tmp36_);
	result = _tmp37_;
	_g_free0 (name);
	return result;
}


static void
convert_base_node_class_init (ConvertBaseNodeClass * klass)
{
	convert_base_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode *)) convert_base_node_real_solve;
}


static void
convert_base_node_instance_init (ConvertBaseNode * self)
{
}


GType
convert_base_node_get_type (void)
{
	static volatile gsize convert_base_node_type_id__volatile = 0;
	if (g_once_init_enter (&convert_base_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConvertBaseNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) convert_base_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConvertBaseNode), 0, (GInstanceInitFunc) convert_base_node_instance_init, NULL };
		GType convert_base_node_type_id;
		convert_base_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "ConvertBaseNode", &g_define_type_info, 0);
		g_once_init_leave (&convert_base_node_type_id__volatile, convert_base_node_type_id);
	}
	return convert_base_node_type_id__volatile;
}


ConvertNumberNode*
convert_number_node_construct (GType object_type,
                               Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity)
{
	ConvertNumberNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ConvertNumberNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}


ConvertNumberNode*
convert_number_node_new (Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	return convert_number_node_construct (TYPE_CONVERT_NUMBER_NODE, parser, token, precedence, associativity);
}


static Number*
convert_number_node_real_solve (ParseNode* base)
{
	ConvertNumberNode * self;
	Number* result = NULL;
	gchar* from = NULL;
	ParseNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* to = NULL;
	ParseNode* _tmp11_;
	const gchar* _tmp12_;
	Number* tmp = NULL;
	ParseNode* _tmp22_;
	ParseNode* _tmp23_;
	Number* _tmp24_;
	Number* _tmp25_;
	Number* ans = NULL;
	Parser* _tmp26_;
	Number* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	Number* _tmp30_;
	Number* _tmp31_;
	self = (ConvertNumberNode*) base;
	_tmp0_ = ((ParseNode*) self)->left;
	_tmp1_ = _tmp0_->value;
	if (_tmp1_ != NULL) {
		ParseNode* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		ParseNode* _tmp5_;
		_tmp2_ = ((ParseNode*) self)->left;
		_tmp3_ = _tmp2_->value;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (from);
		from = _tmp4_;
		_tmp5_ = ((ParseNode*) self)->left;
		_g_free0 (_tmp5_->value);
		_tmp5_->value = NULL;
	} else {
		ParseNode* _tmp6_;
		LexerToken* _tmp7_;
		LexerToken* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = ((ParseNode*) self)->left;
		_tmp7_ = parse_node_token (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_->text;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (from);
		from = _tmp10_;
		_g_object_unref0 (_tmp8_);
	}
	_tmp11_ = ((ParseNode*) self)->right;
	_tmp12_ = _tmp11_->value;
	if (_tmp12_ != NULL) {
		ParseNode* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		ParseNode* _tmp16_;
		_tmp13_ = ((ParseNode*) self)->right;
		_tmp14_ = _tmp13_->value;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (to);
		to = _tmp15_;
		_tmp16_ = ((ParseNode*) self)->right;
		_g_free0 (_tmp16_->value);
		_tmp16_->value = NULL;
	} else {
		ParseNode* _tmp17_;
		LexerToken* _tmp18_;
		LexerToken* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp17_ = ((ParseNode*) self)->right;
		_tmp18_ = parse_node_token (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_->text;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (to);
		to = _tmp21_;
		_g_object_unref0 (_tmp19_);
	}
	_tmp22_ = ((ParseNode*) self)->left;
	_tmp23_ = _tmp22_->left;
	_tmp24_ = parse_node_solve (_tmp23_);
	tmp = _tmp24_;
	_tmp25_ = tmp;
	if (_tmp25_ == NULL) {
		result = NULL;
		_g_object_unref0 (tmp);
		_g_free0 (to);
		_g_free0 (from);
		return result;
	}
	_tmp26_ = ((ParseNode*) self)->parser;
	_tmp27_ = tmp;
	_tmp28_ = from;
	_tmp29_ = to;
	_tmp30_ = parser_convert (_tmp26_, _tmp27_, _tmp28_, _tmp29_);
	ans = _tmp30_;
	_tmp31_ = ans;
	if (_tmp31_ == NULL) {
		Parser* _tmp32_;
		_tmp32_ = ((ParseNode*) self)->parser;
		parser_set_error (_tmp32_, ERROR_CODE_UNKNOWN_CONVERSION, NULL, (guint) 0, (guint) 0);
	}
	result = ans;
	_g_object_unref0 (tmp);
	_g_free0 (to);
	_g_free0 (from);
	return result;
}


static void
convert_number_node_class_init (ConvertNumberNodeClass * klass)
{
	convert_number_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode *)) convert_number_node_real_solve;
}


static void
convert_number_node_instance_init (ConvertNumberNode * self)
{
}


GType
convert_number_node_get_type (void)
{
	static volatile gsize convert_number_node_type_id__volatile = 0;
	if (g_once_init_enter (&convert_number_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConvertNumberNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) convert_number_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConvertNumberNode), 0, (GInstanceInitFunc) convert_number_node_instance_init, NULL };
		GType convert_number_node_type_id;
		convert_number_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "ConvertNumberNode", &g_define_type_info, 0);
		g_once_init_leave (&convert_number_node_type_id__volatile, convert_number_node_type_id);
	}
	return convert_number_node_type_id__volatile;
}


Parser*
parser_construct (GType object_type,
                  const gchar* input,
                  gint number_base,
                  gint wordlen,
                  AngleUnit angle_units)
{
	Parser* self = NULL;
	gchar* _tmp0_;
	Lexer* _tmp1_;
	g_return_val_if_fail (input != NULL, NULL);
	self = (Parser*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (input);
	_g_free0 (self->priv->input);
	self->priv->input = _tmp0_;
	_tmp1_ = lexer_new (input, self, number_base);
	_g_object_unref0 (self->priv->lexer);
	self->priv->lexer = _tmp1_;
	_g_object_unref0 (self->priv->root);
	self->priv->root = NULL;
	self->priv->depth_level = (guint) 0;
	_g_object_unref0 (self->priv->right_most);
	self->priv->right_most = NULL;
	self->number_base = number_base;
	self->priv->representation_base = (guint) number_base;
	self->wordlen = wordlen;
	self->angle_units = angle_units;
	self->priv->error = ERROR_CODE_NONE;
	_g_free0 (self->priv->error_token);
	self->priv->error_token = NULL;
	self->priv->error_token_start = 0;
	self->priv->error_token_end = 0;
	return self;
}


Parser*
parser_new (const gchar* input,
            gint number_base,
            gint wordlen,
            AngleUnit angle_units)
{
	return parser_construct (TYPE_PARSER, input, number_base, wordlen, angle_units);
}


gboolean
parser_create_parse_tree (Parser* self,
                          guint* representation_base,
                          ErrorCode* error_code,
                          gchar* * error_token,
                          guint* error_start,
                          guint* error_end)
{
	guint _vala_representation_base = 0U;
	ErrorCode _vala_error_code = 0;
	gchar* _vala_error_token = NULL;
	guint _vala_error_start = 0U;
	guint _vala_error_end = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	Lexer* _tmp1_;
	gboolean ret = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp2_;
	LexerToken* _tmp3_;
	LexerToken* _tmp4_;
	LexerTokenType _tmp5_;
	LexerToken* _tmp22_;
	LexerTokenType _tmp23_;
	gboolean _tmp36_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->number_base;
	_vala_representation_base = (guint) _tmp0_;
	_tmp1_ = self->priv->lexer;
	lexer_scan (_tmp1_);
	ret = parser_statement (self);
	_tmp2_ = self->priv->lexer;
	_tmp3_ = lexer_get_next_token (_tmp2_);
	token = _tmp3_;
	_tmp4_ = token;
	_tmp5_ = _tmp4_->type;
	if (_tmp5_ == LEXER_TOKEN_TYPE_ASSIGN) {
		Lexer* _tmp6_;
		LexerToken* _tmp7_;
		LexerToken* _tmp8_;
		LexerTokenType _tmp9_;
		_tmp6_ = self->priv->lexer;
		_tmp7_ = lexer_get_next_token (_tmp6_);
		_g_object_unref0 (token);
		token = _tmp7_;
		_tmp8_ = token;
		_tmp9_ = _tmp8_->type;
		if (_tmp9_ != LEXER_TOKEN_TYPE_PL_EOS) {
			ErrorCode _tmp10_;
			ErrorCode _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			_tmp10_ = self->priv->error;
			if (_tmp10_ == ERROR_CODE_NONE) {
				LexerToken* _tmp11_;
				const gchar* _tmp12_;
				LexerToken* _tmp13_;
				guint _tmp14_;
				LexerToken* _tmp15_;
				guint _tmp16_;
				_tmp11_ = token;
				_tmp12_ = _tmp11_->text;
				_tmp13_ = token;
				_tmp14_ = _tmp13_->start_index;
				_tmp15_ = token;
				_tmp16_ = _tmp15_->end_index;
				parser_set_error (self, ERROR_CODE_INVALID, _tmp12_, _tmp14_, _tmp16_);
			}
			_tmp17_ = self->priv->error;
			_vala_error_code = _tmp17_;
			_tmp18_ = self->priv->error_token;
			_tmp19_ = g_strdup (_tmp18_);
			_g_free0 (_vala_error_token);
			_vala_error_token = _tmp19_;
			_tmp20_ = self->priv->error_token_start;
			_vala_error_start = (guint) _tmp20_;
			_tmp21_ = self->priv->error_token_end;
			_vala_error_end = (guint) _tmp21_;
			result = FALSE;
			_g_object_unref0 (token);
			if (representation_base) {
				*representation_base = _vala_representation_base;
			}
			if (error_code) {
				*error_code = _vala_error_code;
			}
			if (error_token) {
				*error_token = _vala_error_token;
			} else {
				_g_free0 (_vala_error_token);
			}
			if (error_start) {
				*error_start = _vala_error_start;
			}
			if (error_end) {
				*error_end = _vala_error_end;
			}
			return result;
		}
	}
	_tmp22_ = token;
	_tmp23_ = _tmp22_->type;
	if (_tmp23_ != LEXER_TOKEN_TYPE_PL_EOS) {
		ErrorCode _tmp24_;
		ErrorCode _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp24_ = self->priv->error;
		if (_tmp24_ == ERROR_CODE_NONE) {
			LexerToken* _tmp25_;
			const gchar* _tmp26_;
			LexerToken* _tmp27_;
			guint _tmp28_;
			LexerToken* _tmp29_;
			guint _tmp30_;
			_tmp25_ = token;
			_tmp26_ = _tmp25_->text;
			_tmp27_ = token;
			_tmp28_ = _tmp27_->start_index;
			_tmp29_ = token;
			_tmp30_ = _tmp29_->end_index;
			parser_set_error (self, ERROR_CODE_INVALID, _tmp26_, _tmp28_, _tmp30_);
		}
		_tmp31_ = self->priv->error;
		_vala_error_code = _tmp31_;
		_tmp32_ = self->priv->error_token;
		_tmp33_ = g_strdup (_tmp32_);
		_g_free0 (_vala_error_token);
		_vala_error_token = _tmp33_;
		_tmp34_ = self->priv->error_token_start;
		_vala_error_start = (guint) _tmp34_;
		_tmp35_ = self->priv->error_token_end;
		_vala_error_end = (guint) _tmp35_;
		result = FALSE;
		_g_object_unref0 (token);
		if (representation_base) {
			*representation_base = _vala_representation_base;
		}
		if (error_code) {
			*error_code = _vala_error_code;
		}
		if (error_token) {
			*error_token = _vala_error_token;
		} else {
			_g_free0 (_vala_error_token);
		}
		if (error_start) {
			*error_start = _vala_error_start;
		}
		if (error_end) {
			*error_end = _vala_error_end;
		}
		return result;
	}
	_tmp36_ = ret;
	if (!_tmp36_) {
		ErrorCode _tmp37_;
		ErrorCode _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		_tmp37_ = self->priv->error;
		if (_tmp37_ == ERROR_CODE_NONE) {
			parser_set_error (self, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
		}
		_tmp38_ = self->priv->error;
		_vala_error_code = _tmp38_;
		_tmp39_ = self->priv->error_token;
		_tmp40_ = g_strdup (_tmp39_);
		_g_free0 (_vala_error_token);
		_vala_error_token = _tmp40_;
		_tmp41_ = self->priv->error_token_start;
		_vala_error_start = (guint) _tmp41_;
		_tmp42_ = self->priv->error_token_end;
		_vala_error_end = (guint) _tmp42_;
		result = FALSE;
		_g_object_unref0 (token);
		if (representation_base) {
			*representation_base = _vala_representation_base;
		}
		if (error_code) {
			*error_code = _vala_error_code;
		}
		if (error_token) {
			*error_token = _vala_error_token;
		} else {
			_g_free0 (_vala_error_token);
		}
		if (error_start) {
			*error_start = _vala_error_start;
		}
		if (error_end) {
			*error_end = _vala_error_end;
		}
		return result;
	}
	_vala_error_code = ERROR_CODE_NONE;
	_g_free0 (_vala_error_token);
	_vala_error_token = NULL;
	_vala_error_start = (guint) 0;
	_vala_error_end = (guint) 0;
	result = TRUE;
	_g_object_unref0 (token);
	if (representation_base) {
		*representation_base = _vala_representation_base;
	}
	if (error_code) {
		*error_code = _vala_error_code;
	}
	if (error_token) {
		*error_token = _vala_error_token;
	} else {
		_g_free0 (_vala_error_token);
	}
	if (error_start) {
		*error_start = _vala_error_start;
	}
	if (error_end) {
		*error_end = _vala_error_end;
	}
	return result;
}


void
parser_set_error (Parser* self,
                  ErrorCode errorno,
                  const gchar* token,
                  guint token_start,
                  guint token_end)
{
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->error = errorno;
	_tmp0_ = g_strdup (token);
	_g_free0 (self->priv->error_token);
	self->priv->error_token = _tmp0_;
	_tmp1_ = self->priv->input;
	self->priv->error_token_start = g_utf8_strlen (_tmp1_, (gssize) token_start);
	_tmp2_ = self->priv->input;
	self->priv->error_token_end = g_utf8_strlen (_tmp2_, (gssize) token_end);
}


void
parser_set_representation_base (Parser* self,
                                guint new_base)
{
	g_return_if_fail (self != NULL);
	self->priv->representation_base = new_base;
}


static gboolean
parser_real_variable_is_defined (Parser* self,
                                 const gchar* name)
{
	gboolean result = FALSE;
	g_return_val_if_fail (name != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean
parser_variable_is_defined (Parser* self,
                            const gchar* name)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return PARSER_GET_CLASS (self)->variable_is_defined (self, name);
}


static Number*
parser_real_get_variable (Parser* self,
                          const gchar* name)
{
	Number* result = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	result = NULL;
	return result;
}


Number*
parser_get_variable (Parser* self,
                     const gchar* name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return PARSER_GET_CLASS (self)->get_variable (self, name);
}


static void
parser_real_set_variable (Parser* self,
                          const gchar* name,
                          Number* x)
{
	g_return_if_fail (name != NULL);
	g_return_if_fail (x != NULL);
}


void
parser_set_variable (Parser* self,
                     const gchar* name,
                     Number* x)
{
	g_return_if_fail (self != NULL);
	PARSER_GET_CLASS (self)->set_variable (self, name, x);
}


static gboolean
parser_real_function_is_defined (Parser* self,
                                 const gchar* name)
{
	gboolean result = FALSE;
	g_return_val_if_fail (name != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean
parser_function_is_defined (Parser* self,
                            const gchar* name)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return PARSER_GET_CLASS (self)->function_is_defined (self, name);
}


static gboolean
parser_real_unit_is_defined (Parser* self,
                             const gchar* name)
{
	gboolean result = FALSE;
	g_return_val_if_fail (name != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean
parser_unit_is_defined (Parser* self,
                        const gchar* name)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return PARSER_GET_CLASS (self)->unit_is_defined (self, name);
}


static Number*
parser_real_convert (Parser* self,
                     Number* x,
                     const gchar* x_units,
                     const gchar* z_units)
{
	Number* result = NULL;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	result = NULL;
	return result;
}


Number*
parser_convert (Parser* self,
                Number* x,
                const gchar* x_units,
                const gchar* z_units)
{
	g_return_val_if_fail (self != NULL, NULL);
	return PARSER_GET_CLASS (self)->convert (self, x, x_units, z_units);
}


Number*
parser_parse (Parser* self,
              guint* representation_base,
              ErrorCode* error_code,
              gchar* * error_token,
              guint* error_start,
              guint* error_end)
{
	guint _vala_representation_base = 0U;
	ErrorCode _vala_error_code = 0;
	gchar* _vala_error_token = NULL;
	guint _vala_error_start = 0U;
	guint _vala_error_end = 0U;
	Number* result = NULL;
	gboolean is_successfully_parsed = FALSE;
	guint _tmp0_ = 0U;
	ErrorCode _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gboolean _tmp5_;
	gboolean _tmp6_;
	Number* ans = NULL;
	ParseNode* _tmp7_;
	Number* _tmp8_;
	gboolean _tmp9_ = FALSE;
	Number* _tmp10_;
	guint _tmp14_;
	ErrorCode _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp5_ = parser_create_parse_tree (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	_vala_representation_base = _tmp0_;
	_vala_error_code = _tmp1_;
	_g_free0 (_vala_error_token);
	_vala_error_token = _tmp2_;
	_vala_error_start = _tmp3_;
	_vala_error_end = _tmp4_;
	is_successfully_parsed = _tmp5_;
	_tmp6_ = is_successfully_parsed;
	if (!_tmp6_) {
		result = NULL;
		if (representation_base) {
			*representation_base = _vala_representation_base;
		}
		if (error_code) {
			*error_code = _vala_error_code;
		}
		if (error_token) {
			*error_token = _vala_error_token;
		} else {
			_g_free0 (_vala_error_token);
		}
		if (error_start) {
			*error_start = _vala_error_start;
		}
		if (error_end) {
			*error_end = _vala_error_end;
		}
		return result;
	}
	_tmp7_ = self->priv->root;
	_tmp8_ = parse_node_solve (_tmp7_);
	ans = _tmp8_;
	_tmp10_ = ans;
	if (_tmp10_ == NULL) {
		ErrorCode _tmp11_;
		_tmp11_ = self->priv->error;
		_tmp9_ = _tmp11_ == ERROR_CODE_NONE;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gint _tmp12_;
		gint _tmp13_;
		_vala_error_code = ERROR_CODE_INVALID;
		_g_free0 (_vala_error_token);
		_vala_error_token = NULL;
		_tmp12_ = self->priv->error_token_start;
		_vala_error_start = (guint) _tmp12_;
		_tmp13_ = self->priv->error_token_end;
		_vala_error_end = (guint) _tmp13_;
		result = NULL;
		_g_object_unref0 (ans);
		if (representation_base) {
			*representation_base = _vala_representation_base;
		}
		if (error_code) {
			*error_code = _vala_error_code;
		}
		if (error_token) {
			*error_token = _vala_error_token;
		} else {
			_g_free0 (_vala_error_token);
		}
		if (error_start) {
			*error_start = _vala_error_start;
		}
		if (error_end) {
			*error_end = _vala_error_end;
		}
		return result;
	}
	_tmp14_ = self->priv->representation_base;
	_vala_representation_base = _tmp14_;
	_tmp15_ = self->priv->error;
	_vala_error_code = _tmp15_;
	_tmp16_ = self->priv->error_token;
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (_vala_error_token);
	_vala_error_token = _tmp17_;
	_tmp18_ = self->priv->error_token_start;
	_vala_error_start = (guint) _tmp18_;
	_tmp19_ = self->priv->error_token_end;
	_vala_error_end = (guint) _tmp19_;
	result = ans;
	if (representation_base) {
		*representation_base = _vala_representation_base;
	}
	if (error_code) {
		*error_code = _vala_error_code;
	}
	if (error_token) {
		*error_token = _vala_error_token;
	} else {
		_g_free0 (_vala_error_token);
	}
	if (error_start) {
		*error_start = _vala_error_start;
	}
	if (error_end) {
		*error_end = _vala_error_end;
	}
	return result;
}


static Precedence
parser_get_precedence (Parser* self,
                       LexerTokenType type)
{
	Precedence result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	if (type == LEXER_TOKEN_TYPE_ADD) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == LEXER_TOKEN_TYPE_SUBTRACT;
	}
	if (_tmp0_) {
		result = PRECEDENCE_ADD_SUBTRACT;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_MULTIPLY) {
		result = PRECEDENCE_MULTIPLY;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_MOD) {
		result = PRECEDENCE_MOD;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_DIVIDE) {
		result = PRECEDENCE_DIVIDE;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_NOT) {
		result = PRECEDENCE_NOT;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_ROOT) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = type == LEXER_TOKEN_TYPE_ROOT_3;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = type == LEXER_TOKEN_TYPE_ROOT_4;
	}
	if (_tmp1_) {
		result = PRECEDENCE_ROOT;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_FUNCTION) {
		result = PRECEDENCE_FUNCTION;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_AND) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = type == LEXER_TOKEN_TYPE_OR;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = type == LEXER_TOKEN_TYPE_XOR;
	}
	if (_tmp3_) {
		result = PRECEDENCE_BOOLEAN;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_PERCENTAGE) {
		result = PRECEDENCE_PERCENTAGE;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_POWER) {
		result = PRECEDENCE_POWER;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_FACTORIAL) {
		result = PRECEDENCE_FACTORIAL;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_NUMBER) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = type == LEXER_TOKEN_TYPE_VARIABLE;
	}
	if (_tmp5_) {
		result = PRECEDENCE_NUMBER_VARIABLE;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_UNIT) {
		result = PRECEDENCE_UNIT;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_IN) {
		result = PRECEDENCE_CONVERT;
		return result;
	}
	result = PRECEDENCE_TOP;
	return result;
}


static Associativity
parser_get_associativity_p (Parser* self,
                            Precedence type)
{
	Associativity result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	if (type == PRECEDENCE_BOOLEAN) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = type == PRECEDENCE_DIVIDE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = type == PRECEDENCE_MOD;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = type == PRECEDENCE_MULTIPLY;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == PRECEDENCE_ADD_SUBTRACT;
	}
	if (_tmp0_) {
		result = ASSOCIATIVITY_LEFT;
		return result;
	}
	if (type == PRECEDENCE_POWER) {
		result = ASSOCIATIVITY_RIGHT;
		return result;
	}
	result = ASSOCIATIVITY_LEFT;
	return result;
}


static Associativity
parser_get_associativity (Parser* self,
                          LexerToken* token)
{
	Associativity result = 0;
	LexerTokenType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (token != NULL, 0);
	_tmp0_ = token->type;
	result = parser_get_associativity_p (self, parser_get_precedence (self, _tmp0_));
	return result;
}


static guint
parser_make_precedence_p (Parser* self,
                          Precedence p)
{
	guint result = 0U;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->depth_level;
	result = p + (_tmp0_ * PRECEDENCE_DEPTH);
	return result;
}


static guint
parser_make_precedence_t (Parser* self,
                          LexerTokenType type)
{
	guint result = 0U;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->depth_level;
	result = parser_get_precedence (self, type) + (_tmp0_ * PRECEDENCE_DEPTH);
	return result;
}


static gboolean
parser_cmp_nodes (Parser* self,
                  ParseNode* left,
                  ParseNode* right)
{
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (left == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = left->precedence;
	_tmp1_ = right->precedence;
	if (_tmp0_ > _tmp1_) {
		result = TRUE;
		return result;
	} else {
		guint _tmp2_;
		guint _tmp3_;
		_tmp2_ = left->precedence;
		_tmp3_ = right->precedence;
		if (_tmp2_ < _tmp3_) {
			result = FALSE;
			return result;
		} else {
			Associativity _tmp4_;
			_tmp4_ = right->associativity;
			result = _tmp4_ != ASSOCIATIVITY_RIGHT;
			return result;
		}
	}
}


static void
parser_insert_into_tree_all (Parser* self,
                             ParseNode* node,
                             gboolean unary_function)
{
	ParseNode* _tmp0_;
	ParseNode* tmp = NULL;
	ParseNode* _tmp4_;
	ParseNode* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->priv->root;
	if (_tmp0_ == NULL) {
		ParseNode* _tmp1_;
		ParseNode* _tmp2_;
		ParseNode* _tmp3_;
		_tmp1_ = _g_object_ref0 (node);
		_g_object_unref0 (self->priv->root);
		self->priv->root = _tmp1_;
		_tmp2_ = self->priv->root;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (self->priv->right_most);
		self->priv->right_most = _tmp3_;
		return;
	}
	_tmp4_ = self->priv->right_most;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	tmp = _tmp5_;
	while (TRUE) {
		ParseNode* _tmp6_;
		ParseNode* _tmp7_;
		ParseNode* _tmp8_;
		ParseNode* _tmp9_;
		_tmp6_ = tmp;
		if (!parser_cmp_nodes (self, _tmp6_, node)) {
			break;
		}
		_tmp7_ = tmp;
		_tmp8_ = _tmp7_->parent;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (tmp);
		tmp = _tmp9_;
	}
	if (unary_function) {
		ParseNode* _tmp10_;
		ParseNode* _tmp30_;
		_tmp10_ = tmp;
		if (_tmp10_ == NULL) {
			ParseNode* _tmp11_;
			ParseNode* _tmp12_;
			ParseNode* _tmp13_;
			ParseNode* _tmp14_;
			ParseNode* _tmp15_;
			_tmp11_ = self->priv->root;
			_tmp12_ = _g_object_ref0 (_tmp11_);
			_g_object_unref0 (node->right);
			node->right = _tmp12_;
			_tmp13_ = node->right;
			_tmp14_ = _g_object_ref0 (node);
			_g_object_unref0 (_tmp13_->parent);
			_tmp13_->parent = _tmp14_;
			_tmp15_ = _g_object_ref0 (node);
			_g_object_unref0 (self->priv->root);
			self->priv->root = _tmp15_;
		} else {
			ParseNode* _tmp16_;
			ParseNode* _tmp17_;
			ParseNode* _tmp18_;
			ParseNode* _tmp19_;
			ParseNode* _tmp22_;
			ParseNode* _tmp23_;
			ParseNode* _tmp24_;
			ParseNode* _tmp25_;
			_tmp16_ = tmp;
			_tmp17_ = _tmp16_->right;
			_tmp18_ = _g_object_ref0 (_tmp17_);
			_g_object_unref0 (node->right);
			node->right = _tmp18_;
			_tmp19_ = node->right;
			if (_tmp19_ != NULL) {
				ParseNode* _tmp20_;
				ParseNode* _tmp21_;
				_tmp20_ = node->right;
				_tmp21_ = _g_object_ref0 (node);
				_g_object_unref0 (_tmp20_->parent);
				_tmp20_->parent = _tmp21_;
			}
			_tmp22_ = tmp;
			_tmp23_ = _g_object_ref0 (node);
			_g_object_unref0 (_tmp22_->right);
			_tmp22_->right = _tmp23_;
			_tmp24_ = tmp;
			_tmp25_ = _tmp24_->right;
			if (_tmp25_ != NULL) {
				ParseNode* _tmp26_;
				ParseNode* _tmp27_;
				ParseNode* _tmp28_;
				ParseNode* _tmp29_;
				_tmp26_ = tmp;
				_tmp27_ = _tmp26_->right;
				_tmp28_ = tmp;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				_g_object_unref0 (_tmp27_->parent);
				_tmp27_->parent = _tmp29_;
			}
		}
		_tmp30_ = _g_object_ref0 (node);
		_g_object_unref0 (self->priv->right_most);
		self->priv->right_most = _tmp30_;
		while (TRUE) {
			ParseNode* _tmp31_;
			ParseNode* _tmp32_;
			ParseNode* _tmp33_;
			ParseNode* _tmp34_;
			ParseNode* _tmp35_;
			_tmp31_ = self->priv->right_most;
			_tmp32_ = _tmp31_->right;
			if (!(_tmp32_ != NULL)) {
				break;
			}
			_tmp33_ = self->priv->right_most;
			_tmp34_ = _tmp33_->right;
			_tmp35_ = _g_object_ref0 (_tmp34_);
			_g_object_unref0 (self->priv->right_most);
			self->priv->right_most = _tmp35_;
		}
	} else {
		ParseNode* _tmp36_;
		ParseNode* _tmp56_;
		_tmp36_ = tmp;
		if (_tmp36_ == NULL) {
			ParseNode* _tmp37_;
			ParseNode* _tmp38_;
			ParseNode* _tmp39_;
			ParseNode* _tmp40_;
			ParseNode* _tmp41_;
			_tmp37_ = self->priv->root;
			_tmp38_ = _g_object_ref0 (_tmp37_);
			_g_object_unref0 (node->left);
			node->left = _tmp38_;
			_tmp39_ = node->left;
			_tmp40_ = _g_object_ref0 (node);
			_g_object_unref0 (_tmp39_->parent);
			_tmp39_->parent = _tmp40_;
			_tmp41_ = _g_object_ref0 (node);
			_g_object_unref0 (self->priv->root);
			self->priv->root = _tmp41_;
		} else {
			ParseNode* _tmp42_;
			ParseNode* _tmp43_;
			ParseNode* _tmp44_;
			ParseNode* _tmp45_;
			ParseNode* _tmp48_;
			ParseNode* _tmp49_;
			ParseNode* _tmp50_;
			ParseNode* _tmp51_;
			_tmp42_ = tmp;
			_tmp43_ = _tmp42_->right;
			_tmp44_ = _g_object_ref0 (_tmp43_);
			_g_object_unref0 (node->left);
			node->left = _tmp44_;
			_tmp45_ = node->left;
			if (_tmp45_ != NULL) {
				ParseNode* _tmp46_;
				ParseNode* _tmp47_;
				_tmp46_ = node->left;
				_tmp47_ = _g_object_ref0 (node);
				_g_object_unref0 (_tmp46_->parent);
				_tmp46_->parent = _tmp47_;
			}
			_tmp48_ = tmp;
			_tmp49_ = _g_object_ref0 (node);
			_g_object_unref0 (_tmp48_->right);
			_tmp48_->right = _tmp49_;
			_tmp50_ = tmp;
			_tmp51_ = _tmp50_->right;
			if (_tmp51_ != NULL) {
				ParseNode* _tmp52_;
				ParseNode* _tmp53_;
				ParseNode* _tmp54_;
				ParseNode* _tmp55_;
				_tmp52_ = tmp;
				_tmp53_ = _tmp52_->right;
				_tmp54_ = tmp;
				_tmp55_ = _g_object_ref0 (_tmp54_);
				_g_object_unref0 (_tmp53_->parent);
				_tmp53_->parent = _tmp55_;
			}
		}
		_tmp56_ = _g_object_ref0 (node);
		_g_object_unref0 (self->priv->right_most);
		self->priv->right_most = _tmp56_;
	}
	_g_object_unref0 (tmp);
}


static void
parser_insert_into_tree (Parser* self,
                         ParseNode* node)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	parser_insert_into_tree_all (self, node, FALSE);
}


static void
parser_insert_into_tree_unary (Parser* self,
                               ParseNode* node)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	parser_insert_into_tree_all (self, node, TRUE);
}


static void
parser_destroy_all_nodes (Parser* self,
                          ParseNode* node)
{
	ParseNode* _tmp0_;
	ParseNode* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if (node == NULL) {
		return;
	}
	_tmp0_ = node->left;
	parser_destroy_all_nodes (self, _tmp0_);
	_tmp1_ = node->right;
	parser_destroy_all_nodes (self, _tmp1_);
}


static gboolean
parser_check_variable (Parser* self,
                       const gchar* name)
{
	gboolean result = FALSE;
	gint index = 0;
	gunichar c = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	if (parser_variable_is_defined (self, name)) {
		result = TRUE;
		return result;
	}
	index = 0;
	while (TRUE) {
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		gunichar _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = string_get_next_char (name, &index, &_tmp0_);
		c = _tmp0_;
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = c;
		_tmp3_ = g_unichar_to_string (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = !parser_variable_is_defined (self, _tmp4_);
		_g_free0 (_tmp4_);
		if (_tmp5_) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static gboolean
parser_statement (Parser* self)
{
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	gboolean _tmp2_ = FALSE;
	LexerToken* _tmp3_;
	LexerTokenType _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp3_ = token;
	_tmp4_ = _tmp3_->type;
	if (_tmp4_ == LEXER_TOKEN_TYPE_VARIABLE) {
		_tmp2_ = TRUE;
	} else {
		LexerToken* _tmp5_;
		LexerTokenType _tmp6_;
		_tmp5_ = token;
		_tmp6_ = _tmp5_->type;
		_tmp2_ = _tmp6_ == LEXER_TOKEN_TYPE_FUNCTION;
	}
	if (_tmp2_) {
		LexerToken* token_old = NULL;
		LexerToken* _tmp7_;
		LexerToken* _tmp8_;
		Lexer* _tmp9_;
		LexerToken* _tmp10_;
		LexerToken* _tmp11_;
		LexerTokenType _tmp12_;
		_tmp7_ = token;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		token_old = _tmp8_;
		_tmp9_ = self->priv->lexer;
		_tmp10_ = lexer_get_next_token (_tmp9_);
		_g_object_unref0 (token);
		token = _tmp10_;
		_tmp11_ = token;
		_tmp12_ = _tmp11_->type;
		if (_tmp12_ == LEXER_TOKEN_TYPE_ASSIGN) {
			LexerToken* _tmp13_;
			LexerToken* _tmp14_;
			NameNode* _tmp15_;
			NameNode* _tmp16_;
			LexerToken* _tmp17_;
			LexerToken* _tmp18_;
			AssignNode* _tmp19_;
			AssignNode* _tmp20_;
			_tmp13_ = token_old;
			_tmp14_ = token_old;
			_tmp15_ = name_node_new (self, _tmp13_, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity (self, _tmp14_), NULL);
			_tmp16_ = _tmp15_;
			parser_insert_into_tree (self, (ParseNode*) _tmp16_);
			_g_object_unref0 (_tmp16_);
			_tmp17_ = token;
			_tmp18_ = token;
			_tmp19_ = assign_node_new (self, _tmp17_, (guint) 0, parser_get_associativity (self, _tmp18_));
			_tmp20_ = _tmp19_;
			parser_insert_into_tree (self, (ParseNode*) _tmp20_);
			_g_object_unref0 (_tmp20_);
			if (!parser_expression (self)) {
				result = FALSE;
				_g_object_unref0 (token_old);
				_g_object_unref0 (token);
				return result;
			}
			result = TRUE;
			_g_object_unref0 (token_old);
			_g_object_unref0 (token);
			return result;
		} else {
			Lexer* _tmp21_;
			Lexer* _tmp22_;
			LexerToken* _tmp23_;
			LexerTokenType _tmp24_;
			_tmp21_ = self->priv->lexer;
			lexer_roll_back (_tmp21_);
			_tmp22_ = self->priv->lexer;
			lexer_roll_back (_tmp22_);
			_tmp23_ = token;
			_tmp24_ = _tmp23_->type;
			if (_tmp24_ == LEXER_TOKEN_TYPE_L_R_BRACKET) {
				if (parser_function_definition (self)) {
					result = TRUE;
					_g_object_unref0 (token_old);
					_g_object_unref0 (token);
					return result;
				}
			}
			if (!parser_expression (self)) {
				result = FALSE;
				_g_object_unref0 (token_old);
				_g_object_unref0 (token);
				return result;
			}
			result = TRUE;
			_g_object_unref0 (token_old);
			_g_object_unref0 (token);
			return result;
		}
		_g_object_unref0 (token_old);
	} else {
		Lexer* _tmp25_;
		_tmp25_ = self->priv->lexer;
		lexer_roll_back (_tmp25_);
		if (!parser_expression (self)) {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
		result = TRUE;
		_g_object_unref0 (token);
		return result;
	}
	_g_object_unref0 (token);
}


static gboolean
parser_function_definition (Parser* self)
{
	gboolean result = FALSE;
	gint num_token_parsed = 0;
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	gint _tmp2_;
	gchar* function_name = NULL;
	LexerToken* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	Lexer* _tmp6_;
	LexerToken* _tmp7_;
	LexerToken* _tmp8_;
	gint _tmp9_;
	Lexer* _tmp10_;
	LexerToken* _tmp11_;
	gint _tmp12_;
	gchar* argument_list = NULL;
	gchar* _tmp13_;
	GList* token_list = NULL;
	LexerToken* _tmp28_;
	LexerTokenType _tmp29_;
	LexerToken* assign_token = NULL;
	Lexer* _tmp32_;
	LexerToken* _tmp33_;
	gint _tmp34_;
	LexerToken* _tmp35_;
	LexerTokenType _tmp36_;
	gchar* expression = NULL;
	gchar* _tmp39_;
	Lexer* _tmp40_;
	LexerToken* _tmp41_;
	const gchar* _tmp50_;
	FunctionNameNode* _tmp51_;
	FunctionNameNode* _tmp52_;
	FunctionNode* _tmp53_;
	FunctionNode* _tmp54_;
	GList* _tmp55_;
	const gchar* _tmp56_;
	FunctionArgumentsNode* _tmp57_;
	FunctionArgumentsNode* _tmp58_;
	LexerToken* _tmp59_;
	LexerToken* _tmp60_;
	AssignFunctionNode* _tmp61_;
	AssignFunctionNode* _tmp62_;
	const gchar* _tmp63_;
	FunctionDescriptionNode* _tmp64_;
	FunctionDescriptionNode* _tmp65_;
	g_return_val_if_fail (self != NULL, FALSE);
	num_token_parsed = 0;
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp2_ = num_token_parsed;
	num_token_parsed = _tmp2_ + 1;
	_tmp3_ = token;
	_tmp4_ = _tmp3_->text;
	_tmp5_ = g_strdup (_tmp4_);
	function_name = _tmp5_;
	_tmp6_ = self->priv->lexer;
	_tmp7_ = lexer_get_next_token (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp8_);
	_tmp9_ = num_token_parsed;
	num_token_parsed = _tmp9_ + 1;
	_tmp10_ = self->priv->lexer;
	_tmp11_ = lexer_get_next_token (_tmp10_);
	_g_object_unref0 (token);
	token = _tmp11_;
	_tmp12_ = num_token_parsed;
	num_token_parsed = _tmp12_ + 1;
	_tmp13_ = g_strdup ("");
	argument_list = _tmp13_;
	token_list = NULL;
	while (TRUE) {
		gboolean _tmp14_ = FALSE;
		LexerToken* _tmp15_;
		LexerTokenType _tmp16_;
		LexerToken* _tmp19_;
		LexerToken* _tmp20_;
		const gchar* _tmp21_;
		LexerToken* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		Lexer* _tmp25_;
		LexerToken* _tmp26_;
		gint _tmp27_;
		_tmp15_ = token;
		_tmp16_ = _tmp15_->type;
		if (_tmp16_ != LEXER_TOKEN_TYPE_R_R_BRACKET) {
			LexerToken* _tmp17_;
			LexerTokenType _tmp18_;
			_tmp17_ = token;
			_tmp18_ = _tmp17_->type;
			_tmp14_ = _tmp18_ != LEXER_TOKEN_TYPE_PL_EOS;
		} else {
			_tmp14_ = FALSE;
		}
		if (!_tmp14_) {
			break;
		}
		_tmp19_ = token;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		token_list = g_list_append (token_list, _tmp20_);
		_tmp21_ = argument_list;
		_tmp22_ = token;
		_tmp23_ = _tmp22_->text;
		_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
		_g_free0 (argument_list);
		argument_list = _tmp24_;
		_tmp25_ = self->priv->lexer;
		_tmp26_ = lexer_get_next_token (_tmp25_);
		_g_object_unref0 (token);
		token = _tmp26_;
		_tmp27_ = num_token_parsed;
		num_token_parsed = _tmp27_ + 1;
	}
	_tmp28_ = token;
	_tmp29_ = _tmp28_->type;
	if (_tmp29_ == LEXER_TOKEN_TYPE_PL_EOS) {
		while (TRUE) {
			gint _tmp30_;
			Lexer* _tmp31_;
			_tmp30_ = num_token_parsed;
			num_token_parsed = _tmp30_ - 1;
			if (!(_tmp30_ > 0)) {
				break;
			}
			_tmp31_ = self->priv->lexer;
			lexer_roll_back (_tmp31_);
		}
		result = FALSE;
		__g_list_free__g_object_unref0_0 (token_list);
		_g_free0 (argument_list);
		_g_free0 (function_name);
		_g_object_unref0 (token);
		return result;
	}
	_tmp32_ = self->priv->lexer;
	_tmp33_ = lexer_get_next_token (_tmp32_);
	assign_token = _tmp33_;
	_tmp34_ = num_token_parsed;
	num_token_parsed = _tmp34_ + 1;
	_tmp35_ = assign_token;
	_tmp36_ = _tmp35_->type;
	if (_tmp36_ != LEXER_TOKEN_TYPE_ASSIGN) {
		while (TRUE) {
			gint _tmp37_;
			Lexer* _tmp38_;
			_tmp37_ = num_token_parsed;
			num_token_parsed = _tmp37_ - 1;
			if (!(_tmp37_ > 0)) {
				break;
			}
			_tmp38_ = self->priv->lexer;
			lexer_roll_back (_tmp38_);
		}
		result = FALSE;
		_g_object_unref0 (assign_token);
		__g_list_free__g_object_unref0_0 (token_list);
		_g_free0 (argument_list);
		_g_free0 (function_name);
		_g_object_unref0 (token);
		return result;
	}
	_tmp39_ = g_strdup ("");
	expression = _tmp39_;
	_tmp40_ = self->priv->lexer;
	_tmp41_ = lexer_get_next_token (_tmp40_);
	_g_object_unref0 (token);
	token = _tmp41_;
	while (TRUE) {
		LexerToken* _tmp42_;
		LexerTokenType _tmp43_;
		const gchar* _tmp44_;
		LexerToken* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		Lexer* _tmp48_;
		LexerToken* _tmp49_;
		_tmp42_ = token;
		_tmp43_ = _tmp42_->type;
		if (!(_tmp43_ != LEXER_TOKEN_TYPE_PL_EOS)) {
			break;
		}
		_tmp44_ = expression;
		_tmp45_ = token;
		_tmp46_ = _tmp45_->text;
		_tmp47_ = g_strconcat (_tmp44_, _tmp46_, NULL);
		_g_free0 (expression);
		expression = _tmp47_;
		_tmp48_ = self->priv->lexer;
		_tmp49_ = lexer_get_next_token (_tmp48_);
		_g_object_unref0 (token);
		token = _tmp49_;
	}
	_tmp50_ = function_name;
	_tmp51_ = function_name_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), _tmp50_);
	_tmp52_ = _tmp51_;
	parser_insert_into_tree (self, (ParseNode*) _tmp52_);
	_g_object_unref0 (_tmp52_);
	_tmp53_ = function_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_FUNCTION), parser_get_associativity_p (self, PRECEDENCE_FUNCTION), NULL);
	_tmp54_ = _tmp53_;
	parser_insert_into_tree (self, (ParseNode*) _tmp54_);
	_g_object_unref0 (_tmp54_);
	_tmp55_ = token_list;
	_tmp56_ = argument_list;
	_tmp57_ = function_arguments_node_new (self, _tmp55_, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), _tmp56_);
	_tmp58_ = _tmp57_;
	parser_insert_into_tree (self, (ParseNode*) _tmp58_);
	_g_object_unref0 (_tmp58_);
	_tmp59_ = assign_token;
	_tmp60_ = assign_token;
	_tmp61_ = assign_function_node_new (self, _tmp59_, (guint) 0, parser_get_associativity (self, _tmp60_));
	_tmp62_ = _tmp61_;
	parser_insert_into_tree (self, (ParseNode*) _tmp62_);
	_g_object_unref0 (_tmp62_);
	_tmp63_ = expression;
	_tmp64_ = function_description_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), _tmp63_);
	_tmp65_ = _tmp64_;
	parser_insert_into_tree (self, (ParseNode*) _tmp65_);
	_g_object_unref0 (_tmp65_);
	result = TRUE;
	_g_free0 (expression);
	_g_object_unref0 (assign_token);
	__g_list_free__g_object_unref0_0 (token_list);
	_g_free0 (argument_list);
	_g_free0 (function_name);
	_g_object_unref0 (token);
	return result;
}


static gboolean
parser_conversion (Parser* self)
{
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	LexerToken* _tmp2_;
	LexerTokenType _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp2_ = token;
	_tmp3_ = _tmp2_->type;
	if (_tmp3_ == LEXER_TOKEN_TYPE_IN) {
		LexerToken* token_in = NULL;
		LexerToken* _tmp4_;
		LexerToken* _tmp5_;
		Lexer* _tmp6_;
		LexerToken* _tmp7_;
		LexerToken* _tmp8_;
		LexerTokenType _tmp9_;
		_tmp4_ = token;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		token_in = _tmp5_;
		_tmp6_ = self->priv->lexer;
		_tmp7_ = lexer_get_next_token (_tmp6_);
		_g_object_unref0 (token);
		token = _tmp7_;
		_tmp8_ = token;
		_tmp9_ = _tmp8_->type;
		if (_tmp9_ == LEXER_TOKEN_TYPE_UNIT) {
			LexerToken* token_to = NULL;
			LexerToken* _tmp10_;
			LexerToken* _tmp11_;
			Lexer* _tmp12_;
			LexerToken* _tmp13_;
			LexerToken* _tmp14_;
			LexerTokenType _tmp15_;
			_tmp10_ = token;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			token_to = _tmp11_;
			_tmp12_ = self->priv->lexer;
			_tmp13_ = lexer_get_next_token (_tmp12_);
			_g_object_unref0 (token);
			token = _tmp13_;
			_tmp14_ = token;
			_tmp15_ = _tmp14_->type;
			if (_tmp15_ == LEXER_TOKEN_TYPE_PL_EOS) {
				LexerToken* _tmp16_;
				LexerToken* _tmp17_;
				ConvertBaseNode* _tmp18_;
				ConvertBaseNode* _tmp19_;
				LexerToken* _tmp20_;
				LexerToken* _tmp21_;
				NameNode* _tmp22_;
				NameNode* _tmp23_;
				_tmp16_ = token_in;
				_tmp17_ = token_in;
				_tmp18_ = convert_base_node_new (self, _tmp16_, parser_make_precedence_p (self, PRECEDENCE_CONVERT), parser_get_associativity (self, _tmp17_), NULL);
				_tmp19_ = _tmp18_;
				parser_insert_into_tree (self, (ParseNode*) _tmp19_);
				_g_object_unref0 (_tmp19_);
				_tmp20_ = token_to;
				_tmp21_ = token_to;
				_tmp22_ = name_node_new (self, _tmp20_, parser_make_precedence_p (self, PRECEDENCE_UNIT), parser_get_associativity (self, _tmp21_), NULL);
				_tmp23_ = _tmp22_;
				parser_insert_into_tree (self, (ParseNode*) _tmp23_);
				_g_object_unref0 (_tmp23_);
				result = TRUE;
				_g_object_unref0 (token_to);
				_g_object_unref0 (token_in);
				_g_object_unref0 (token);
				return result;
			} else {
				Lexer* _tmp24_;
				Lexer* _tmp25_;
				Lexer* _tmp26_;
				_tmp24_ = self->priv->lexer;
				lexer_roll_back (_tmp24_);
				_tmp25_ = self->priv->lexer;
				lexer_roll_back (_tmp25_);
				_tmp26_ = self->priv->lexer;
				lexer_roll_back (_tmp26_);
				result = FALSE;
				_g_object_unref0 (token_to);
				_g_object_unref0 (token_in);
				_g_object_unref0 (token);
				return result;
			}
			_g_object_unref0 (token_to);
		} else {
			Lexer* _tmp27_;
			Lexer* _tmp28_;
			_tmp27_ = self->priv->lexer;
			lexer_roll_back (_tmp27_);
			_tmp28_ = self->priv->lexer;
			lexer_roll_back (_tmp28_);
			result = FALSE;
			_g_object_unref0 (token_in);
			_g_object_unref0 (token);
			return result;
		}
		_g_object_unref0 (token_in);
	} else {
		LexerToken* _tmp29_;
		LexerTokenType _tmp30_;
		_tmp29_ = token;
		_tmp30_ = _tmp29_->type;
		if (_tmp30_ == LEXER_TOKEN_TYPE_UNIT) {
			LexerToken* token_from = NULL;
			LexerToken* _tmp31_;
			LexerToken* _tmp32_;
			Lexer* _tmp33_;
			LexerToken* _tmp34_;
			LexerToken* _tmp35_;
			LexerTokenType _tmp36_;
			_tmp31_ = token;
			_tmp32_ = _g_object_ref0 (_tmp31_);
			token_from = _tmp32_;
			_tmp33_ = self->priv->lexer;
			_tmp34_ = lexer_get_next_token (_tmp33_);
			_g_object_unref0 (token);
			token = _tmp34_;
			_tmp35_ = token;
			_tmp36_ = _tmp35_->type;
			if (_tmp36_ == LEXER_TOKEN_TYPE_IN) {
				LexerToken* token_in = NULL;
				LexerToken* _tmp37_;
				LexerToken* _tmp38_;
				Lexer* _tmp39_;
				LexerToken* _tmp40_;
				LexerToken* _tmp41_;
				LexerTokenType _tmp42_;
				_tmp37_ = token;
				_tmp38_ = _g_object_ref0 (_tmp37_);
				token_in = _tmp38_;
				_tmp39_ = self->priv->lexer;
				_tmp40_ = lexer_get_next_token (_tmp39_);
				_g_object_unref0 (token);
				token = _tmp40_;
				_tmp41_ = token;
				_tmp42_ = _tmp41_->type;
				if (_tmp42_ == LEXER_TOKEN_TYPE_UNIT) {
					LexerToken* _tmp43_;
					LexerToken* _tmp44_;
					NameNode* _tmp45_;
					NameNode* _tmp46_;
					LexerToken* _tmp47_;
					LexerToken* _tmp48_;
					ConvertNumberNode* _tmp49_;
					ConvertNumberNode* _tmp50_;
					LexerToken* _tmp51_;
					LexerToken* _tmp52_;
					NameNode* _tmp53_;
					NameNode* _tmp54_;
					_tmp43_ = token_from;
					_tmp44_ = token_from;
					_tmp45_ = name_node_new (self, _tmp43_, parser_make_precedence_p (self, PRECEDENCE_UNIT), parser_get_associativity (self, _tmp44_), NULL);
					_tmp46_ = _tmp45_;
					parser_insert_into_tree (self, (ParseNode*) _tmp46_);
					_g_object_unref0 (_tmp46_);
					_tmp47_ = token_in;
					_tmp48_ = token_in;
					_tmp49_ = convert_number_node_new (self, _tmp47_, parser_make_precedence_p (self, PRECEDENCE_CONVERT), parser_get_associativity (self, _tmp48_));
					_tmp50_ = _tmp49_;
					parser_insert_into_tree (self, (ParseNode*) _tmp50_);
					_g_object_unref0 (_tmp50_);
					_tmp51_ = token;
					_tmp52_ = token;
					_tmp53_ = name_node_new (self, _tmp51_, parser_make_precedence_p (self, PRECEDENCE_UNIT), parser_get_associativity (self, _tmp52_), NULL);
					_tmp54_ = _tmp53_;
					parser_insert_into_tree (self, (ParseNode*) _tmp54_);
					_g_object_unref0 (_tmp54_);
					result = TRUE;
					_g_object_unref0 (token_in);
					_g_object_unref0 (token_from);
					_g_object_unref0 (token);
					return result;
				} else {
					Lexer* _tmp55_;
					Lexer* _tmp56_;
					Lexer* _tmp57_;
					_tmp55_ = self->priv->lexer;
					lexer_roll_back (_tmp55_);
					_tmp56_ = self->priv->lexer;
					lexer_roll_back (_tmp56_);
					_tmp57_ = self->priv->lexer;
					lexer_roll_back (_tmp57_);
					result = FALSE;
					_g_object_unref0 (token_in);
					_g_object_unref0 (token_from);
					_g_object_unref0 (token);
					return result;
				}
				_g_object_unref0 (token_in);
			} else {
				Lexer* _tmp58_;
				Lexer* _tmp59_;
				_tmp58_ = self->priv->lexer;
				lexer_roll_back (_tmp58_);
				_tmp59_ = self->priv->lexer;
				lexer_roll_back (_tmp59_);
				result = FALSE;
				_g_object_unref0 (token_from);
				_g_object_unref0 (token);
				return result;
			}
			_g_object_unref0 (token_from);
		} else {
			Lexer* _tmp60_;
			_tmp60_ = self->priv->lexer;
			lexer_roll_back (_tmp60_);
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
	}
	_g_object_unref0 (token);
}


static gboolean
parser_expression (Parser* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!parser_expression_1 (self)) {
		result = FALSE;
		return result;
	}
	if (!parser_expression_2 (self)) {
		result = FALSE;
		return result;
	}
	parser_conversion (self);
	result = TRUE;
	return result;
}


static gboolean
parser_expression_1 (Parser* self)
{
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	gboolean _tmp2_ = FALSE;
	LexerToken* _tmp3_;
	LexerTokenType _tmp4_;
	LexerToken* _tmp8_;
	LexerTokenType _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp3_ = token;
	_tmp4_ = _tmp3_->type;
	if (_tmp4_ == LEXER_TOKEN_TYPE_PL_EOS) {
		_tmp2_ = TRUE;
	} else {
		LexerToken* _tmp5_;
		LexerTokenType _tmp6_;
		_tmp5_ = token;
		_tmp6_ = _tmp5_->type;
		_tmp2_ = _tmp6_ == LEXER_TOKEN_TYPE_ASSIGN;
	}
	if (_tmp2_) {
		Lexer* _tmp7_;
		_tmp7_ = self->priv->lexer;
		lexer_roll_back (_tmp7_);
		result = FALSE;
		_g_object_unref0 (token);
		return result;
	}
	_tmp8_ = token;
	_tmp9_ = _tmp8_->type;
	if (_tmp9_ == LEXER_TOKEN_TYPE_L_R_BRACKET) {
		guint _tmp10_;
		Lexer* _tmp11_;
		LexerToken* _tmp12_;
		LexerToken* _tmp13_;
		LexerTokenType _tmp14_;
		_tmp10_ = self->priv->depth_level;
		self->priv->depth_level = _tmp10_ + 1;
		if (!parser_expression (self)) {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
		_tmp11_ = self->priv->lexer;
		_tmp12_ = lexer_get_next_token (_tmp11_);
		_g_object_unref0 (token);
		token = _tmp12_;
		_tmp13_ = token;
		_tmp14_ = _tmp13_->type;
		if (_tmp14_ == LEXER_TOKEN_TYPE_R_R_BRACKET) {
			guint _tmp15_;
			Lexer* _tmp16_;
			LexerToken* _tmp17_;
			Lexer* _tmp18_;
			LexerToken* _tmp19_;
			LexerTokenType _tmp20_;
			_tmp15_ = self->priv->depth_level;
			self->priv->depth_level = _tmp15_ - 1;
			_tmp16_ = self->priv->lexer;
			_tmp17_ = lexer_get_next_token (_tmp16_);
			_g_object_unref0 (token);
			token = _tmp17_;
			_tmp18_ = self->priv->lexer;
			lexer_roll_back (_tmp18_);
			_tmp19_ = token;
			_tmp20_ = _tmp19_->type;
			if (_tmp20_ == LEXER_TOKEN_TYPE_NUMBER) {
				MultiplyNode* _tmp21_;
				MultiplyNode* _tmp22_;
				_tmp21_ = multiply_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_MULTIPLY), parser_get_associativity_p (self, PRECEDENCE_MULTIPLY));
				_tmp22_ = _tmp21_;
				parser_insert_into_tree (self, (ParseNode*) _tmp22_);
				_g_object_unref0 (_tmp22_);
				if (!parser_expression (self)) {
					result = FALSE;
					_g_object_unref0 (token);
					return result;
				} else {
					result = TRUE;
					_g_object_unref0 (token);
					return result;
				}
			} else {
				result = TRUE;
				_g_object_unref0 (token);
				return result;
			}
		} else {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
	} else {
		LexerToken* _tmp23_;
		LexerTokenType _tmp24_;
		_tmp23_ = token;
		_tmp24_ = _tmp23_->type;
		if (_tmp24_ == LEXER_TOKEN_TYPE_L_S_BRACKET) {
			guint _tmp25_;
			LexerToken* _tmp26_;
			LexerToken* _tmp27_;
			RoundNode* _tmp28_;
			RoundNode* _tmp29_;
			Lexer* _tmp30_;
			LexerToken* _tmp31_;
			LexerToken* _tmp32_;
			LexerTokenType _tmp33_;
			_tmp25_ = self->priv->depth_level;
			self->priv->depth_level = _tmp25_ + 1;
			_tmp26_ = token;
			_tmp27_ = token;
			_tmp28_ = round_node_new (self, _tmp26_, parser_make_precedence_p (self, PRECEDENCE_TOP), parser_get_associativity (self, _tmp27_));
			_tmp29_ = _tmp28_;
			parser_insert_into_tree_unary (self, (ParseNode*) _tmp29_);
			_g_object_unref0 (_tmp29_);
			if (!parser_expression (self)) {
				result = FALSE;
				_g_object_unref0 (token);
				return result;
			}
			_tmp30_ = self->priv->lexer;
			_tmp31_ = lexer_get_next_token (_tmp30_);
			_g_object_unref0 (token);
			token = _tmp31_;
			_tmp32_ = token;
			_tmp33_ = _tmp32_->type;
			if (_tmp33_ == LEXER_TOKEN_TYPE_R_S_BRACKET) {
				guint _tmp34_;
				_tmp34_ = self->priv->depth_level;
				self->priv->depth_level = _tmp34_ - 1;
				result = TRUE;
				_g_object_unref0 (token);
				return result;
			} else {
				result = FALSE;
				_g_object_unref0 (token);
				return result;
			}
		} else {
			LexerToken* _tmp35_;
			LexerTokenType _tmp36_;
			_tmp35_ = token;
			_tmp36_ = _tmp35_->type;
			if (_tmp36_ == LEXER_TOKEN_TYPE_L_C_BRACKET) {
				guint _tmp37_;
				LexerToken* _tmp38_;
				LexerToken* _tmp39_;
				FractionalComponentNode* _tmp40_;
				FractionalComponentNode* _tmp41_;
				Lexer* _tmp42_;
				LexerToken* _tmp43_;
				LexerToken* _tmp44_;
				LexerTokenType _tmp45_;
				_tmp37_ = self->priv->depth_level;
				self->priv->depth_level = _tmp37_ + 1;
				_tmp38_ = token;
				_tmp39_ = token;
				_tmp40_ = fractional_component_node_new (self, _tmp38_, parser_make_precedence_p (self, PRECEDENCE_TOP), parser_get_associativity (self, _tmp39_));
				_tmp41_ = _tmp40_;
				parser_insert_into_tree_unary (self, (ParseNode*) _tmp41_);
				_g_object_unref0 (_tmp41_);
				if (!parser_expression (self)) {
					result = FALSE;
					_g_object_unref0 (token);
					return result;
				}
				_tmp42_ = self->priv->lexer;
				_tmp43_ = lexer_get_next_token (_tmp42_);
				_g_object_unref0 (token);
				token = _tmp43_;
				_tmp44_ = token;
				_tmp45_ = _tmp44_->type;
				if (_tmp45_ == LEXER_TOKEN_TYPE_R_C_BRACKET) {
					guint _tmp46_;
					_tmp46_ = self->priv->depth_level;
					self->priv->depth_level = _tmp46_ - 1;
					result = TRUE;
					_g_object_unref0 (token);
					return result;
				} else {
					result = FALSE;
					_g_object_unref0 (token);
					return result;
				}
			} else {
				LexerToken* _tmp47_;
				LexerTokenType _tmp48_;
				_tmp47_ = token;
				_tmp48_ = _tmp47_->type;
				if (_tmp48_ == LEXER_TOKEN_TYPE_ABS) {
					guint _tmp49_;
					LexerToken* _tmp50_;
					LexerToken* _tmp51_;
					AbsoluteValueNode* _tmp52_;
					AbsoluteValueNode* _tmp53_;
					Lexer* _tmp54_;
					LexerToken* _tmp55_;
					LexerToken* _tmp56_;
					LexerTokenType _tmp57_;
					_tmp49_ = self->priv->depth_level;
					self->priv->depth_level = _tmp49_ + 1;
					_tmp50_ = token;
					_tmp51_ = token;
					_tmp52_ = absolute_value_node_new (self, _tmp50_, parser_make_precedence_p (self, PRECEDENCE_TOP), parser_get_associativity (self, _tmp51_));
					_tmp53_ = _tmp52_;
					parser_insert_into_tree_unary (self, (ParseNode*) _tmp53_);
					_g_object_unref0 (_tmp53_);
					if (!parser_expression (self)) {
						result = FALSE;
						_g_object_unref0 (token);
						return result;
					}
					_tmp54_ = self->priv->lexer;
					_tmp55_ = lexer_get_next_token (_tmp54_);
					_g_object_unref0 (token);
					token = _tmp55_;
					_tmp56_ = token;
					_tmp57_ = _tmp56_->type;
					if (_tmp57_ == LEXER_TOKEN_TYPE_ABS) {
						guint _tmp58_;
						_tmp58_ = self->priv->depth_level;
						self->priv->depth_level = _tmp58_ - 1;
						result = TRUE;
						_g_object_unref0 (token);
						return result;
					} else {
						result = FALSE;
						_g_object_unref0 (token);
						return result;
					}
				} else {
					LexerToken* _tmp59_;
					LexerTokenType _tmp60_;
					_tmp59_ = token;
					_tmp60_ = _tmp59_->type;
					if (_tmp60_ == LEXER_TOKEN_TYPE_NOT) {
						LexerToken* _tmp61_;
						LexerToken* _tmp62_;
						NotNode* _tmp63_;
						NotNode* _tmp64_;
						_tmp61_ = token;
						_tmp62_ = token;
						_tmp63_ = not_node_new (self, _tmp61_, parser_make_precedence_p (self, PRECEDENCE_NOT), parser_get_associativity (self, _tmp62_));
						_tmp64_ = _tmp63_;
						parser_insert_into_tree_unary (self, (ParseNode*) _tmp64_);
						_g_object_unref0 (_tmp64_);
						if (!parser_expression (self)) {
							result = FALSE;
							_g_object_unref0 (token);
							return result;
						}
						result = TRUE;
						_g_object_unref0 (token);
						return result;
					} else {
						LexerToken* _tmp65_;
						LexerTokenType _tmp66_;
						_tmp65_ = token;
						_tmp66_ = _tmp65_->type;
						if (_tmp66_ == LEXER_TOKEN_TYPE_NUMBER) {
							LexerToken* _tmp67_;
							LexerToken* _tmp68_;
							LexerTokenType _tmp69_;
							LexerToken* _tmp70_;
							ConstantNode* _tmp71_;
							ConstantNode* _tmp72_;
							Lexer* _tmp73_;
							LexerToken* _tmp74_;
							Lexer* _tmp75_;
							gboolean _tmp76_ = FALSE;
							gboolean _tmp77_ = FALSE;
							gboolean _tmp78_ = FALSE;
							gboolean _tmp79_ = FALSE;
							gboolean _tmp80_ = FALSE;
							LexerToken* _tmp81_;
							LexerTokenType _tmp82_;
							_tmp67_ = token;
							_tmp68_ = token;
							_tmp69_ = _tmp68_->type;
							_tmp70_ = token;
							_tmp71_ = constant_node_new (self, _tmp67_, parser_make_precedence_t (self, _tmp69_), parser_get_associativity (self, _tmp70_));
							_tmp72_ = _tmp71_;
							parser_insert_into_tree (self, (ParseNode*) _tmp72_);
							_g_object_unref0 (_tmp72_);
							_tmp73_ = self->priv->lexer;
							_tmp74_ = lexer_get_next_token (_tmp73_);
							_g_object_unref0 (token);
							token = _tmp74_;
							_tmp75_ = self->priv->lexer;
							lexer_roll_back (_tmp75_);
							_tmp81_ = token;
							_tmp82_ = _tmp81_->type;
							if (_tmp82_ == LEXER_TOKEN_TYPE_FUNCTION) {
								_tmp80_ = TRUE;
							} else {
								LexerToken* _tmp83_;
								LexerTokenType _tmp84_;
								_tmp83_ = token;
								_tmp84_ = _tmp83_->type;
								_tmp80_ = _tmp84_ == LEXER_TOKEN_TYPE_VARIABLE;
							}
							if (_tmp80_) {
								_tmp79_ = TRUE;
							} else {
								LexerToken* _tmp85_;
								LexerTokenType _tmp86_;
								_tmp85_ = token;
								_tmp86_ = _tmp85_->type;
								_tmp79_ = _tmp86_ == LEXER_TOKEN_TYPE_SUB_NUMBER;
							}
							if (_tmp79_) {
								_tmp78_ = TRUE;
							} else {
								LexerToken* _tmp87_;
								LexerTokenType _tmp88_;
								_tmp87_ = token;
								_tmp88_ = _tmp87_->type;
								_tmp78_ = _tmp88_ == LEXER_TOKEN_TYPE_ROOT;
							}
							if (_tmp78_) {
								_tmp77_ = TRUE;
							} else {
								LexerToken* _tmp89_;
								LexerTokenType _tmp90_;
								_tmp89_ = token;
								_tmp90_ = _tmp89_->type;
								_tmp77_ = _tmp90_ == LEXER_TOKEN_TYPE_ROOT_3;
							}
							if (_tmp77_) {
								_tmp76_ = TRUE;
							} else {
								LexerToken* _tmp91_;
								LexerTokenType _tmp92_;
								_tmp91_ = token;
								_tmp92_ = _tmp91_->type;
								_tmp76_ = _tmp92_ == LEXER_TOKEN_TYPE_ROOT_4;
							}
							if (_tmp76_) {
								MultiplyNode* _tmp93_;
								MultiplyNode* _tmp94_;
								_tmp93_ = multiply_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_MULTIPLY), parser_get_associativity_p (self, PRECEDENCE_MULTIPLY));
								_tmp94_ = _tmp93_;
								parser_insert_into_tree (self, (ParseNode*) _tmp94_);
								_g_object_unref0 (_tmp94_);
								if (!parser_variable (self)) {
									result = FALSE;
									_g_object_unref0 (token);
									return result;
								} else {
									result = TRUE;
									_g_object_unref0 (token);
									return result;
								}
							} else {
								result = TRUE;
								_g_object_unref0 (token);
								return result;
							}
						} else {
							LexerToken* _tmp95_;
							LexerTokenType _tmp96_;
							_tmp95_ = token;
							_tmp96_ = _tmp95_->type;
							if (_tmp96_ == LEXER_TOKEN_TYPE_L_FLOOR) {
								guint _tmp97_;
								FloorNode* _tmp98_;
								FloorNode* _tmp99_;
								Lexer* _tmp100_;
								LexerToken* _tmp101_;
								LexerToken* _tmp102_;
								LexerTokenType _tmp103_;
								_tmp97_ = self->priv->depth_level;
								self->priv->depth_level = _tmp97_ + 1;
								_tmp98_ = floor_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_TOP), parser_get_associativity_p (self, PRECEDENCE_TOP));
								_tmp99_ = _tmp98_;
								parser_insert_into_tree_unary (self, (ParseNode*) _tmp99_);
								_g_object_unref0 (_tmp99_);
								if (!parser_expression (self)) {
									result = FALSE;
									_g_object_unref0 (token);
									return result;
								}
								_tmp100_ = self->priv->lexer;
								_tmp101_ = lexer_get_next_token (_tmp100_);
								_g_object_unref0 (token);
								token = _tmp101_;
								_tmp102_ = token;
								_tmp103_ = _tmp102_->type;
								if (_tmp103_ == LEXER_TOKEN_TYPE_R_FLOOR) {
									guint _tmp104_;
									_tmp104_ = self->priv->depth_level;
									self->priv->depth_level = _tmp104_ - 1;
									result = TRUE;
									_g_object_unref0 (token);
									return result;
								} else {
									result = FALSE;
									_g_object_unref0 (token);
									return result;
								}
							} else {
								LexerToken* _tmp105_;
								LexerTokenType _tmp106_;
								_tmp105_ = token;
								_tmp106_ = _tmp105_->type;
								if (_tmp106_ == LEXER_TOKEN_TYPE_L_CEILING) {
									guint _tmp107_;
									CeilingNode* _tmp108_;
									CeilingNode* _tmp109_;
									Lexer* _tmp110_;
									LexerToken* _tmp111_;
									LexerToken* _tmp112_;
									LexerTokenType _tmp113_;
									_tmp107_ = self->priv->depth_level;
									self->priv->depth_level = _tmp107_ + 1;
									_tmp108_ = ceiling_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_TOP), parser_get_associativity_p (self, PRECEDENCE_TOP));
									_tmp109_ = _tmp108_;
									parser_insert_into_tree_unary (self, (ParseNode*) _tmp109_);
									_g_object_unref0 (_tmp109_);
									if (!parser_expression (self)) {
										result = FALSE;
										_g_object_unref0 (token);
										return result;
									}
									_tmp110_ = self->priv->lexer;
									_tmp111_ = lexer_get_next_token (_tmp110_);
									_g_object_unref0 (token);
									token = _tmp111_;
									_tmp112_ = token;
									_tmp113_ = _tmp112_->type;
									if (_tmp113_ == LEXER_TOKEN_TYPE_R_CEILING) {
										guint _tmp114_;
										_tmp114_ = self->priv->depth_level;
										self->priv->depth_level = _tmp114_ - 1;
										result = TRUE;
										_g_object_unref0 (token);
										return result;
									} else {
										result = FALSE;
										_g_object_unref0 (token);
										return result;
									}
								} else {
									LexerToken* _tmp115_;
									LexerTokenType _tmp116_;
									_tmp115_ = token;
									_tmp116_ = _tmp115_->type;
									if (_tmp116_ == LEXER_TOKEN_TYPE_SUBTRACT) {
										LexerToken* _tmp117_;
										UnaryMinusNode* _tmp118_;
										UnaryMinusNode* _tmp119_;
										_tmp117_ = token;
										_tmp118_ = unary_minus_node_new (self, _tmp117_, parser_make_precedence_p (self, PRECEDENCE_UNARY_MINUS), parser_get_associativity_p (self, PRECEDENCE_UNARY_MINUS));
										_tmp119_ = _tmp118_;
										parser_insert_into_tree_unary (self, (ParseNode*) _tmp119_);
										_g_object_unref0 (_tmp119_);
										if (!parser_expression_1 (self)) {
											result = FALSE;
											_g_object_unref0 (token);
											return result;
										}
										result = TRUE;
										_g_object_unref0 (token);
										return result;
									} else {
										LexerToken* _tmp120_;
										LexerTokenType _tmp121_;
										_tmp120_ = token;
										_tmp121_ = _tmp120_->type;
										if (_tmp121_ == LEXER_TOKEN_TYPE_ADD) {
											Lexer* _tmp122_;
											LexerToken* _tmp123_;
											LexerToken* _tmp124_;
											LexerTokenType _tmp125_;
											_tmp122_ = self->priv->lexer;
											_tmp123_ = lexer_get_next_token (_tmp122_);
											_g_object_unref0 (token);
											token = _tmp123_;
											_tmp124_ = token;
											_tmp125_ = _tmp124_->type;
											if (_tmp125_ == LEXER_TOKEN_TYPE_NUMBER) {
												LexerToken* _tmp126_;
												LexerToken* _tmp127_;
												LexerTokenType _tmp128_;
												LexerToken* _tmp129_;
												ConstantNode* _tmp130_;
												ConstantNode* _tmp131_;
												_tmp126_ = token;
												_tmp127_ = token;
												_tmp128_ = _tmp127_->type;
												_tmp129_ = token;
												_tmp130_ = constant_node_new (self, _tmp126_, parser_make_precedence_t (self, _tmp128_), parser_get_associativity (self, _tmp129_));
												_tmp131_ = _tmp130_;
												parser_insert_into_tree (self, (ParseNode*) _tmp131_);
												_g_object_unref0 (_tmp131_);
												result = TRUE;
												_g_object_unref0 (token);
												return result;
											} else {
												result = FALSE;
												_g_object_unref0 (token);
												return result;
											}
										} else {
											Lexer* _tmp132_;
											_tmp132_ = self->priv->lexer;
											lexer_roll_back (_tmp132_);
											if (!parser_variable (self)) {
												result = FALSE;
												_g_object_unref0 (token);
												return result;
											} else {
												result = TRUE;
												_g_object_unref0 (token);
												return result;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (token);
}


static gboolean
parser_expression_2 (Parser* self)
{
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	LexerToken* _tmp2_;
	LexerTokenType _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp2_ = token;
	_tmp3_ = _tmp2_->type;
	if (_tmp3_ == LEXER_TOKEN_TYPE_L_R_BRACKET) {
		MultiplyNode* _tmp4_;
		MultiplyNode* _tmp5_;
		guint _tmp6_;
		Lexer* _tmp7_;
		LexerToken* _tmp8_;
		LexerToken* _tmp9_;
		LexerTokenType _tmp10_;
		_tmp4_ = multiply_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_MULTIPLY), parser_get_associativity_p (self, PRECEDENCE_MULTIPLY));
		_tmp5_ = _tmp4_;
		parser_insert_into_tree (self, (ParseNode*) _tmp5_);
		_g_object_unref0 (_tmp5_);
		_tmp6_ = self->priv->depth_level;
		self->priv->depth_level = _tmp6_ + 1;
		if (!parser_expression (self)) {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
		_tmp7_ = self->priv->lexer;
		_tmp8_ = lexer_get_next_token (_tmp7_);
		_g_object_unref0 (token);
		token = _tmp8_;
		_tmp9_ = token;
		_tmp10_ = _tmp9_->type;
		if (_tmp10_ == LEXER_TOKEN_TYPE_R_R_BRACKET) {
			guint _tmp11_;
			_tmp11_ = self->priv->depth_level;
			self->priv->depth_level = _tmp11_ - 1;
			if (!parser_expression_2 (self)) {
				result = FALSE;
				_g_object_unref0 (token);
				return result;
			}
			result = TRUE;
			_g_object_unref0 (token);
			return result;
		} else {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
	} else {
		LexerToken* _tmp12_;
		LexerTokenType _tmp13_;
		_tmp12_ = token;
		_tmp13_ = _tmp12_->type;
		if (_tmp13_ == LEXER_TOKEN_TYPE_POWER) {
			LexerToken* _tmp14_;
			LexerToken* _tmp15_;
			LexerTokenType _tmp16_;
			LexerToken* _tmp17_;
			XPowYNode* _tmp18_;
			XPowYNode* _tmp19_;
			_tmp14_ = token;
			_tmp15_ = token;
			_tmp16_ = _tmp15_->type;
			_tmp17_ = token;
			_tmp18_ = xpow_ynode_new (self, _tmp14_, parser_make_precedence_t (self, _tmp16_), parser_get_associativity (self, _tmp17_));
			_tmp19_ = _tmp18_;
			parser_insert_into_tree (self, (ParseNode*) _tmp19_);
			_g_object_unref0 (_tmp19_);
			if (!parser_expression_1 (self)) {
				result = FALSE;
				_g_object_unref0 (token);
				return result;
			}
			if (!parser_expression_2 (self)) {
				result = FALSE;
				_g_object_unref0 (token);
				return result;
			}
			result = TRUE;
			_g_object_unref0 (token);
			return result;
		} else {
			LexerToken* _tmp20_;
			LexerTokenType _tmp21_;
			_tmp20_ = token;
			_tmp21_ = _tmp20_->type;
			if (_tmp21_ == LEXER_TOKEN_TYPE_SUP_NUMBER) {
				XPowYIntegerNode* _tmp22_;
				XPowYIntegerNode* _tmp23_;
				LexerToken* _tmp24_;
				NameNode* _tmp25_;
				NameNode* _tmp26_;
				_tmp22_ = xpow_yinteger_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_POWER), parser_get_associativity_p (self, PRECEDENCE_POWER));
				_tmp23_ = _tmp22_;
				parser_insert_into_tree (self, (ParseNode*) _tmp23_);
				_g_object_unref0 (_tmp23_);
				_tmp24_ = token;
				_tmp25_ = name_node_new (self, _tmp24_, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), NULL);
				_tmp26_ = _tmp25_;
				parser_insert_into_tree (self, (ParseNode*) _tmp26_);
				_g_object_unref0 (_tmp26_);
				if (!parser_expression_2 (self)) {
					result = FALSE;
					_g_object_unref0 (token);
					return result;
				}
				result = TRUE;
				_g_object_unref0 (token);
				return result;
			} else {
				LexerToken* _tmp27_;
				LexerTokenType _tmp28_;
				_tmp27_ = token;
				_tmp28_ = _tmp27_->type;
				if (_tmp28_ == LEXER_TOKEN_TYPE_NSUP_NUMBER) {
					XPowYIntegerNode* _tmp29_;
					XPowYIntegerNode* _tmp30_;
					LexerToken* _tmp31_;
					NameNode* _tmp32_;
					NameNode* _tmp33_;
					_tmp29_ = xpow_yinteger_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_POWER), parser_get_associativity_p (self, PRECEDENCE_POWER));
					_tmp30_ = _tmp29_;
					parser_insert_into_tree (self, (ParseNode*) _tmp30_);
					_g_object_unref0 (_tmp30_);
					_tmp31_ = token;
					_tmp32_ = name_node_new (self, _tmp31_, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), NULL);
					_tmp33_ = _tmp32_;
					parser_insert_into_tree (self, (ParseNode*) _tmp33_);
					_g_object_unref0 (_tmp33_);
					if (!parser_expression_2 (self)) {
						result = FALSE;
						_g_object_unref0 (token);
						return result;
					}
					result = TRUE;
					_g_object_unref0 (token);
					return result;
				} else {
					LexerToken* _tmp34_;
					LexerTokenType _tmp35_;
					_tmp34_ = token;
					_tmp35_ = _tmp34_->type;
					if (_tmp35_ == LEXER_TOKEN_TYPE_FACTORIAL) {
						LexerToken* _tmp36_;
						LexerToken* _tmp37_;
						LexerTokenType _tmp38_;
						LexerToken* _tmp39_;
						FactorialNode* _tmp40_;
						FactorialNode* _tmp41_;
						_tmp36_ = token;
						_tmp37_ = token;
						_tmp38_ = _tmp37_->type;
						_tmp39_ = token;
						_tmp40_ = factorial_node_new (self, _tmp36_, parser_make_precedence_t (self, _tmp38_), parser_get_associativity (self, _tmp39_));
						_tmp41_ = _tmp40_;
						parser_insert_into_tree_unary (self, (ParseNode*) _tmp41_);
						_g_object_unref0 (_tmp41_);
						if (!parser_expression_2 (self)) {
							result = FALSE;
							_g_object_unref0 (token);
							return result;
						}
						result = TRUE;
						_g_object_unref0 (token);
						return result;
					} else {
						LexerToken* _tmp42_;
						LexerTokenType _tmp43_;
						_tmp42_ = token;
						_tmp43_ = _tmp42_->type;
						if (_tmp43_ == LEXER_TOKEN_TYPE_MULTIPLY) {
							LexerToken* _tmp44_;
							LexerToken* _tmp45_;
							LexerTokenType _tmp46_;
							LexerToken* _tmp47_;
							MultiplyNode* _tmp48_;
							MultiplyNode* _tmp49_;
							_tmp44_ = token;
							_tmp45_ = token;
							_tmp46_ = _tmp45_->type;
							_tmp47_ = token;
							_tmp48_ = multiply_node_new (self, _tmp44_, parser_make_precedence_t (self, _tmp46_), parser_get_associativity (self, _tmp47_));
							_tmp49_ = _tmp48_;
							parser_insert_into_tree (self, (ParseNode*) _tmp49_);
							_g_object_unref0 (_tmp49_);
							if (!parser_expression_1 (self)) {
								result = FALSE;
								_g_object_unref0 (token);
								return result;
							}
							if (!parser_expression_2 (self)) {
								result = FALSE;
								_g_object_unref0 (token);
								return result;
							}
							result = TRUE;
							_g_object_unref0 (token);
							return result;
						} else {
							LexerToken* _tmp50_;
							LexerTokenType _tmp51_;
							_tmp50_ = token;
							_tmp51_ = _tmp50_->type;
							if (_tmp51_ == LEXER_TOKEN_TYPE_PERCENTAGE) {
								LexerToken* _tmp52_;
								LexerToken* _tmp53_;
								LexerTokenType _tmp54_;
								LexerToken* _tmp55_;
								PercentNode* _tmp56_;
								PercentNode* _tmp57_;
								_tmp52_ = token;
								_tmp53_ = token;
								_tmp54_ = _tmp53_->type;
								_tmp55_ = token;
								_tmp56_ = percent_node_new (self, _tmp52_, parser_make_precedence_t (self, _tmp54_), parser_get_associativity (self, _tmp55_));
								_tmp57_ = _tmp56_;
								parser_insert_into_tree_unary (self, (ParseNode*) _tmp57_);
								_g_object_unref0 (_tmp57_);
								if (!parser_expression_2 (self)) {
									result = FALSE;
									_g_object_unref0 (token);
									return result;
								}
								result = TRUE;
								_g_object_unref0 (token);
								return result;
							} else {
								LexerToken* _tmp58_;
								LexerTokenType _tmp59_;
								_tmp58_ = token;
								_tmp59_ = _tmp58_->type;
								if (_tmp59_ == LEXER_TOKEN_TYPE_AND) {
									LexerToken* _tmp60_;
									LexerToken* _tmp61_;
									LexerTokenType _tmp62_;
									LexerToken* _tmp63_;
									AndNode* _tmp64_;
									AndNode* _tmp65_;
									_tmp60_ = token;
									_tmp61_ = token;
									_tmp62_ = _tmp61_->type;
									_tmp63_ = token;
									_tmp64_ = and_node_new (self, _tmp60_, parser_make_precedence_t (self, _tmp62_), parser_get_associativity (self, _tmp63_));
									_tmp65_ = _tmp64_;
									parser_insert_into_tree (self, (ParseNode*) _tmp65_);
									_g_object_unref0 (_tmp65_);
									if (!parser_expression_1 (self)) {
										result = FALSE;
										_g_object_unref0 (token);
										return result;
									}
									if (!parser_expression_2 (self)) {
										result = FALSE;
										_g_object_unref0 (token);
										return result;
									}
									result = TRUE;
									_g_object_unref0 (token);
									return result;
								} else {
									LexerToken* _tmp66_;
									LexerTokenType _tmp67_;
									_tmp66_ = token;
									_tmp67_ = _tmp66_->type;
									if (_tmp67_ == LEXER_TOKEN_TYPE_OR) {
										LexerToken* _tmp68_;
										LexerToken* _tmp69_;
										LexerTokenType _tmp70_;
										LexerToken* _tmp71_;
										OrNode* _tmp72_;
										OrNode* _tmp73_;
										_tmp68_ = token;
										_tmp69_ = token;
										_tmp70_ = _tmp69_->type;
										_tmp71_ = token;
										_tmp72_ = or_node_new (self, _tmp68_, parser_make_precedence_t (self, _tmp70_), parser_get_associativity (self, _tmp71_));
										_tmp73_ = _tmp72_;
										parser_insert_into_tree (self, (ParseNode*) _tmp73_);
										_g_object_unref0 (_tmp73_);
										if (!parser_expression_1 (self)) {
											result = FALSE;
											_g_object_unref0 (token);
											return result;
										}
										if (!parser_expression_2 (self)) {
											result = FALSE;
											_g_object_unref0 (token);
											return result;
										}
										result = TRUE;
										_g_object_unref0 (token);
										return result;
									} else {
										LexerToken* _tmp74_;
										LexerTokenType _tmp75_;
										_tmp74_ = token;
										_tmp75_ = _tmp74_->type;
										if (_tmp75_ == LEXER_TOKEN_TYPE_XOR) {
											LexerToken* _tmp76_;
											LexerToken* _tmp77_;
											LexerTokenType _tmp78_;
											LexerToken* _tmp79_;
											XorNode* _tmp80_;
											XorNode* _tmp81_;
											_tmp76_ = token;
											_tmp77_ = token;
											_tmp78_ = _tmp77_->type;
											_tmp79_ = token;
											_tmp80_ = xor_node_new (self, _tmp76_, parser_make_precedence_t (self, _tmp78_), parser_get_associativity (self, _tmp79_));
											_tmp81_ = _tmp80_;
											parser_insert_into_tree (self, (ParseNode*) _tmp81_);
											_g_object_unref0 (_tmp81_);
											if (!parser_expression_1 (self)) {
												result = FALSE;
												_g_object_unref0 (token);
												return result;
											}
											if (!parser_expression_2 (self)) {
												result = FALSE;
												_g_object_unref0 (token);
												return result;
											}
											result = TRUE;
											_g_object_unref0 (token);
											return result;
										} else {
											LexerToken* _tmp82_;
											LexerTokenType _tmp83_;
											_tmp82_ = token;
											_tmp83_ = _tmp82_->type;
											if (_tmp83_ == LEXER_TOKEN_TYPE_DIVIDE) {
												LexerToken* _tmp84_;
												LexerToken* _tmp85_;
												LexerTokenType _tmp86_;
												LexerToken* _tmp87_;
												DivideNode* _tmp88_;
												DivideNode* _tmp89_;
												_tmp84_ = token;
												_tmp85_ = token;
												_tmp86_ = _tmp85_->type;
												_tmp87_ = token;
												_tmp88_ = divide_node_new (self, _tmp84_, parser_make_precedence_t (self, _tmp86_), parser_get_associativity (self, _tmp87_));
												_tmp89_ = _tmp88_;
												parser_insert_into_tree (self, (ParseNode*) _tmp89_);
												_g_object_unref0 (_tmp89_);
												if (!parser_expression_1 (self)) {
													result = FALSE;
													_g_object_unref0 (token);
													return result;
												}
												if (!parser_expression_2 (self)) {
													result = FALSE;
													_g_object_unref0 (token);
													return result;
												}
												result = TRUE;
												_g_object_unref0 (token);
												return result;
											} else {
												LexerToken* _tmp90_;
												LexerTokenType _tmp91_;
												_tmp90_ = token;
												_tmp91_ = _tmp90_->type;
												if (_tmp91_ == LEXER_TOKEN_TYPE_MOD) {
													LexerToken* _tmp92_;
													LexerToken* _tmp93_;
													LexerTokenType _tmp94_;
													LexerToken* _tmp95_;
													ModulusDivideNode* _tmp96_;
													ModulusDivideNode* _tmp97_;
													_tmp92_ = token;
													_tmp93_ = token;
													_tmp94_ = _tmp93_->type;
													_tmp95_ = token;
													_tmp96_ = modulus_divide_node_new (self, _tmp92_, parser_make_precedence_t (self, _tmp94_), parser_get_associativity (self, _tmp95_));
													_tmp97_ = _tmp96_;
													parser_insert_into_tree (self, (ParseNode*) _tmp97_);
													_g_object_unref0 (_tmp97_);
													if (!parser_expression_1 (self)) {
														result = FALSE;
														_g_object_unref0 (token);
														return result;
													}
													if (!parser_expression_2 (self)) {
														result = FALSE;
														_g_object_unref0 (token);
														return result;
													}
													result = TRUE;
													_g_object_unref0 (token);
													return result;
												} else {
													LexerToken* _tmp98_;
													LexerTokenType _tmp99_;
													_tmp98_ = token;
													_tmp99_ = _tmp98_->type;
													if (_tmp99_ == LEXER_TOKEN_TYPE_ADD) {
														AddNode* node = NULL;
														LexerToken* _tmp100_;
														LexerToken* _tmp101_;
														LexerTokenType _tmp102_;
														LexerToken* _tmp103_;
														AddNode* _tmp104_;
														AddNode* _tmp105_;
														Lexer* _tmp106_;
														LexerToken* _tmp107_;
														LexerToken* _tmp108_;
														LexerTokenType _tmp109_;
														_tmp100_ = token;
														_tmp101_ = token;
														_tmp102_ = _tmp101_->type;
														_tmp103_ = token;
														_tmp104_ = add_node_new (self, _tmp100_, parser_make_precedence_t (self, _tmp102_), parser_get_associativity (self, _tmp103_));
														node = _tmp104_;
														_tmp105_ = node;
														parser_insert_into_tree (self, (ParseNode*) _tmp105_);
														if (!parser_expression_1 (self)) {
															result = FALSE;
															_g_object_unref0 (node);
															_g_object_unref0 (token);
															return result;
														}
														_tmp106_ = self->priv->lexer;
														_tmp107_ = lexer_get_next_token (_tmp106_);
														_g_object_unref0 (token);
														token = _tmp107_;
														_tmp108_ = token;
														_tmp109_ = _tmp108_->type;
														if (_tmp109_ == LEXER_TOKEN_TYPE_PERCENTAGE) {
															AddNode* _tmp110_;
															ParseNode* _tmp111_;
															guint _tmp112_;
															_tmp110_ = node;
															_tmp111_ = ((ParseNode*) _tmp110_)->right;
															_tmp112_ = _tmp111_->precedence;
															if (_tmp112_ > ((guint) PRECEDENCE_PERCENTAGE)) {
																AddNode* _tmp113_;
																AddNode* _tmp114_;
																_tmp113_ = node;
																((ParseNode*) _tmp113_)->precedence = (guint) PRECEDENCE_PERCENTAGE;
																_tmp114_ = node;
																_tmp114_->do_percentage = TRUE;
																result = TRUE;
																_g_object_unref0 (node);
																_g_object_unref0 (token);
																return result;
															} else {
																Lexer* _tmp115_;
																_tmp115_ = self->priv->lexer;
																lexer_roll_back (_tmp115_);
																if (!parser_expression_2 (self)) {
																	result = TRUE;
																	_g_object_unref0 (node);
																	_g_object_unref0 (token);
																	return result;
																}
															}
														} else {
															Lexer* _tmp116_;
															_tmp116_ = self->priv->lexer;
															lexer_roll_back (_tmp116_);
														}
														if (!parser_expression_2 (self)) {
															result = FALSE;
															_g_object_unref0 (node);
															_g_object_unref0 (token);
															return result;
														}
														result = TRUE;
														_g_object_unref0 (node);
														_g_object_unref0 (token);
														return result;
													} else {
														LexerToken* _tmp117_;
														LexerTokenType _tmp118_;
														_tmp117_ = token;
														_tmp118_ = _tmp117_->type;
														if (_tmp118_ == LEXER_TOKEN_TYPE_SUBTRACT) {
															SubtractNode* node = NULL;
															LexerToken* _tmp119_;
															LexerToken* _tmp120_;
															LexerTokenType _tmp121_;
															LexerToken* _tmp122_;
															SubtractNode* _tmp123_;
															SubtractNode* _tmp124_;
															Lexer* _tmp125_;
															LexerToken* _tmp126_;
															LexerToken* _tmp127_;
															LexerTokenType _tmp128_;
															_tmp119_ = token;
															_tmp120_ = token;
															_tmp121_ = _tmp120_->type;
															_tmp122_ = token;
															_tmp123_ = subtract_node_new (self, _tmp119_, parser_make_precedence_t (self, _tmp121_), parser_get_associativity (self, _tmp122_));
															node = _tmp123_;
															_tmp124_ = node;
															parser_insert_into_tree (self, (ParseNode*) _tmp124_);
															if (!parser_expression_1 (self)) {
																result = FALSE;
																_g_object_unref0 (node);
																_g_object_unref0 (token);
																return result;
															}
															_tmp125_ = self->priv->lexer;
															_tmp126_ = lexer_get_next_token (_tmp125_);
															_g_object_unref0 (token);
															token = _tmp126_;
															_tmp127_ = token;
															_tmp128_ = _tmp127_->type;
															if (_tmp128_ == LEXER_TOKEN_TYPE_PERCENTAGE) {
																SubtractNode* _tmp129_;
																ParseNode* _tmp130_;
																guint _tmp131_;
																_tmp129_ = node;
																_tmp130_ = ((ParseNode*) _tmp129_)->right;
																_tmp131_ = _tmp130_->precedence;
																if (_tmp131_ > ((guint) PRECEDENCE_PERCENTAGE)) {
																	SubtractNode* _tmp132_;
																	SubtractNode* _tmp133_;
																	_tmp132_ = node;
																	((ParseNode*) _tmp132_)->precedence = (guint) PRECEDENCE_PERCENTAGE;
																	_tmp133_ = node;
																	_tmp133_->do_percentage = TRUE;
																	result = TRUE;
																	_g_object_unref0 (node);
																	_g_object_unref0 (token);
																	return result;
																} else {
																	Lexer* _tmp134_;
																	_tmp134_ = self->priv->lexer;
																	lexer_roll_back (_tmp134_);
																	if (!parser_expression_2 (self)) {
																		result = TRUE;
																		_g_object_unref0 (node);
																		_g_object_unref0 (token);
																		return result;
																	}
																}
															} else {
																Lexer* _tmp135_;
																_tmp135_ = self->priv->lexer;
																lexer_roll_back (_tmp135_);
															}
															if (!parser_expression_2 (self)) {
																result = FALSE;
																_g_object_unref0 (node);
																_g_object_unref0 (token);
																return result;
															}
															result = TRUE;
															_g_object_unref0 (node);
															_g_object_unref0 (token);
															return result;
														} else {
															Lexer* _tmp136_;
															_tmp136_ = self->priv->lexer;
															lexer_roll_back (_tmp136_);
															result = TRUE;
															_g_object_unref0 (token);
															return result;
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (token);
}


static gboolean
parser_variable (Parser* self)
{
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	LexerToken* _tmp2_;
	LexerTokenType _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp2_ = token;
	_tmp3_ = _tmp2_->type;
	if (_tmp3_ == LEXER_TOKEN_TYPE_FUNCTION) {
		Lexer* _tmp4_;
		_tmp4_ = self->priv->lexer;
		lexer_roll_back (_tmp4_);
		if (!parser_function_invocation (self)) {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
		result = TRUE;
		_g_object_unref0 (token);
		return result;
	} else {
		LexerToken* _tmp5_;
		LexerTokenType _tmp6_;
		_tmp5_ = token;
		_tmp6_ = _tmp5_->type;
		if (_tmp6_ == LEXER_TOKEN_TYPE_SUB_NUMBER) {
			LexerToken* token_old = NULL;
			LexerToken* _tmp7_;
			LexerToken* _tmp8_;
			Lexer* _tmp9_;
			LexerToken* _tmp10_;
			LexerToken* _tmp11_;
			LexerTokenType _tmp12_;
			_tmp7_ = token;
			_tmp8_ = _g_object_ref0 (_tmp7_);
			token_old = _tmp8_;
			_tmp9_ = self->priv->lexer;
			_tmp10_ = lexer_get_next_token (_tmp9_);
			_g_object_unref0 (token);
			token = _tmp10_;
			_tmp11_ = token;
			_tmp12_ = _tmp11_->type;
			if (_tmp12_ == LEXER_TOKEN_TYPE_ROOT) {
				LexerToken* _tmp13_;
				LexerToken* _tmp14_;
				LexerTokenType _tmp15_;
				LexerToken* _tmp16_;
				LexerToken* _tmp17_;
				RootNode* _tmp18_;
				RootNode* _tmp19_;
				_tmp13_ = token;
				_tmp14_ = token;
				_tmp15_ = _tmp14_->type;
				_tmp16_ = token;
				_tmp17_ = token_old;
				_tmp18_ = root_node_new_WithToken (self, _tmp13_, parser_make_precedence_t (self, _tmp15_), parser_get_associativity (self, _tmp16_), _tmp17_);
				_tmp19_ = _tmp18_;
				parser_insert_into_tree_unary (self, (ParseNode*) _tmp19_);
				_g_object_unref0 (_tmp19_);
				if (!parser_expression (self)) {
					result = FALSE;
					_g_object_unref0 (token_old);
					_g_object_unref0 (token);
					return result;
				}
				result = TRUE;
				_g_object_unref0 (token_old);
				_g_object_unref0 (token);
				return result;
			} else {
				result = FALSE;
				_g_object_unref0 (token_old);
				_g_object_unref0 (token);
				return result;
			}
			_g_object_unref0 (token_old);
		} else {
			LexerToken* _tmp20_;
			LexerTokenType _tmp21_;
			_tmp20_ = token;
			_tmp21_ = _tmp20_->type;
			if (_tmp21_ == LEXER_TOKEN_TYPE_ROOT) {
				LexerToken* _tmp22_;
				LexerToken* _tmp23_;
				LexerTokenType _tmp24_;
				LexerToken* _tmp25_;
				RootNode* _tmp26_;
				RootNode* _tmp27_;
				_tmp22_ = token;
				_tmp23_ = token;
				_tmp24_ = _tmp23_->type;
				_tmp25_ = token;
				_tmp26_ = root_node_new (self, _tmp22_, parser_make_precedence_t (self, _tmp24_), parser_get_associativity (self, _tmp25_), 2);
				_tmp27_ = _tmp26_;
				parser_insert_into_tree_unary (self, (ParseNode*) _tmp27_);
				_g_object_unref0 (_tmp27_);
				if (!parser_expression (self)) {
					result = FALSE;
					_g_object_unref0 (token);
					return result;
				}
				result = TRUE;
				_g_object_unref0 (token);
				return result;
			} else {
				LexerToken* _tmp28_;
				LexerTokenType _tmp29_;
				_tmp28_ = token;
				_tmp29_ = _tmp28_->type;
				if (_tmp29_ == LEXER_TOKEN_TYPE_ROOT_3) {
					LexerToken* _tmp30_;
					LexerToken* _tmp31_;
					LexerTokenType _tmp32_;
					LexerToken* _tmp33_;
					RootNode* _tmp34_;
					RootNode* _tmp35_;
					_tmp30_ = token;
					_tmp31_ = token;
					_tmp32_ = _tmp31_->type;
					_tmp33_ = token;
					_tmp34_ = root_node_new (self, _tmp30_, parser_make_precedence_t (self, _tmp32_), parser_get_associativity (self, _tmp33_), 3);
					_tmp35_ = _tmp34_;
					parser_insert_into_tree_unary (self, (ParseNode*) _tmp35_);
					_g_object_unref0 (_tmp35_);
					if (!parser_expression (self)) {
						result = FALSE;
						_g_object_unref0 (token);
						return result;
					}
					result = TRUE;
					_g_object_unref0 (token);
					return result;
				} else {
					LexerToken* _tmp36_;
					LexerTokenType _tmp37_;
					_tmp36_ = token;
					_tmp37_ = _tmp36_->type;
					if (_tmp37_ == LEXER_TOKEN_TYPE_ROOT_4) {
						LexerToken* _tmp38_;
						LexerToken* _tmp39_;
						LexerTokenType _tmp40_;
						LexerToken* _tmp41_;
						RootNode* _tmp42_;
						RootNode* _tmp43_;
						_tmp38_ = token;
						_tmp39_ = token;
						_tmp40_ = _tmp39_->type;
						_tmp41_ = token;
						_tmp42_ = root_node_new (self, _tmp38_, parser_make_precedence_t (self, _tmp40_), parser_get_associativity (self, _tmp41_), 4);
						_tmp43_ = _tmp42_;
						parser_insert_into_tree_unary (self, (ParseNode*) _tmp43_);
						_g_object_unref0 (_tmp43_);
						if (!parser_expression (self)) {
							result = FALSE;
							_g_object_unref0 (token);
							return result;
						}
						result = TRUE;
						_g_object_unref0 (token);
						return result;
					} else {
						LexerToken* _tmp44_;
						LexerTokenType _tmp45_;
						_tmp44_ = token;
						_tmp45_ = _tmp44_->type;
						if (_tmp45_ == LEXER_TOKEN_TYPE_VARIABLE) {
							Lexer* _tmp46_;
							_tmp46_ = self->priv->lexer;
							lexer_roll_back (_tmp46_);
							if (!parser_term (self)) {
								result = FALSE;
								_g_object_unref0 (token);
								return result;
							}
							result = TRUE;
							_g_object_unref0 (token);
							return result;
						} else {
							result = FALSE;
							_g_object_unref0 (token);
							return result;
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (token);
}


static gboolean
parser_function_invocation (Parser* self)
{
	gboolean result = FALSE;
	guint _tmp0_;
	gint num_token_parsed = 0;
	LexerToken* fun_token = NULL;
	Lexer* _tmp1_;
	LexerToken* _tmp2_;
	gint _tmp3_;
	gchar* function_name = NULL;
	LexerToken* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	LexerToken* _tmp7_;
	const gchar* _tmp8_;
	FunctionNameNode* _tmp9_;
	FunctionNameNode* _tmp10_;
	LexerToken* token = NULL;
	Lexer* _tmp11_;
	LexerToken* _tmp12_;
	gint _tmp13_;
	gchar* power = NULL;
	gboolean _tmp14_ = FALSE;
	LexerToken* _tmp15_;
	LexerTokenType _tmp16_;
	LexerToken* _tmp25_;
	LexerToken* _tmp26_;
	LexerTokenType _tmp27_;
	LexerToken* _tmp28_;
	const gchar* _tmp29_;
	FunctionNode* _tmp30_;
	FunctionNode* _tmp31_;
	LexerToken* _tmp32_;
	LexerTokenType _tmp33_;
	guint _tmp84_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->depth_level;
	self->priv->depth_level = _tmp0_ + 1;
	num_token_parsed = 0;
	_tmp1_ = self->priv->lexer;
	_tmp2_ = lexer_get_next_token (_tmp1_);
	fun_token = _tmp2_;
	_tmp3_ = num_token_parsed;
	num_token_parsed = _tmp3_ + 1;
	_tmp4_ = fun_token;
	_tmp5_ = _tmp4_->text;
	_tmp6_ = g_strdup (_tmp5_);
	function_name = _tmp6_;
	_tmp7_ = fun_token;
	_tmp8_ = function_name;
	_tmp9_ = function_name_node_new (self, _tmp7_, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), _tmp8_);
	_tmp10_ = _tmp9_;
	parser_insert_into_tree (self, (ParseNode*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->lexer;
	_tmp12_ = lexer_get_next_token (_tmp11_);
	token = _tmp12_;
	_tmp13_ = num_token_parsed;
	num_token_parsed = _tmp13_ + 1;
	power = NULL;
	_tmp15_ = token;
	_tmp16_ = _tmp15_->type;
	if (_tmp16_ == LEXER_TOKEN_TYPE_SUP_NUMBER) {
		_tmp14_ = TRUE;
	} else {
		LexerToken* _tmp17_;
		LexerTokenType _tmp18_;
		_tmp17_ = token;
		_tmp18_ = _tmp17_->type;
		_tmp14_ = _tmp18_ == LEXER_TOKEN_TYPE_NSUP_NUMBER;
	}
	if (_tmp14_) {
		LexerToken* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		Lexer* _tmp22_;
		LexerToken* _tmp23_;
		gint _tmp24_;
		_tmp19_ = token;
		_tmp20_ = _tmp19_->text;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (power);
		power = _tmp21_;
		_tmp22_ = self->priv->lexer;
		_tmp23_ = lexer_get_next_token (_tmp22_);
		_g_object_unref0 (token);
		token = _tmp23_;
		_tmp24_ = num_token_parsed;
		num_token_parsed = _tmp24_ + 1;
	}
	_tmp25_ = fun_token;
	_tmp26_ = fun_token;
	_tmp27_ = _tmp26_->type;
	_tmp28_ = fun_token;
	_tmp29_ = power;
	_tmp30_ = function_node_new (self, _tmp25_, parser_make_precedence_t (self, _tmp27_), parser_get_associativity (self, _tmp28_), _tmp29_);
	_tmp31_ = _tmp30_;
	parser_insert_into_tree (self, (ParseNode*) _tmp31_);
	_g_object_unref0 (_tmp31_);
	_tmp32_ = token;
	_tmp33_ = _tmp32_->type;
	if (_tmp33_ == LEXER_TOKEN_TYPE_L_R_BRACKET) {
		Lexer* _tmp34_;
		LexerToken* _tmp35_;
		gint _tmp36_;
		gint m_depth = 0;
		gchar* argument_list = NULL;
		gchar* _tmp37_;
		GList* token_list = NULL;
		LexerToken* _tmp59_;
		LexerTokenType _tmp60_;
		GList* _tmp64_;
		const gchar* _tmp65_;
		FunctionArgumentsNode* _tmp66_;
		FunctionArgumentsNode* _tmp67_;
		_tmp34_ = self->priv->lexer;
		_tmp35_ = lexer_get_next_token (_tmp34_);
		_g_object_unref0 (token);
		token = _tmp35_;
		_tmp36_ = num_token_parsed;
		num_token_parsed = _tmp36_ + 1;
		m_depth = 1;
		_tmp37_ = g_strdup ("");
		argument_list = _tmp37_;
		token_list = NULL;
		while (TRUE) {
			gboolean _tmp38_ = FALSE;
			LexerToken* _tmp39_;
			LexerTokenType _tmp40_;
			LexerToken* _tmp43_;
			LexerTokenType _tmp44_;
			const gchar* _tmp52_;
			LexerToken* _tmp53_;
			const gchar* _tmp54_;
			gchar* _tmp55_;
			Lexer* _tmp56_;
			LexerToken* _tmp57_;
			gint _tmp58_;
			_tmp39_ = token;
			_tmp40_ = _tmp39_->type;
			if (_tmp40_ != LEXER_TOKEN_TYPE_PL_EOS) {
				LexerToken* _tmp41_;
				LexerTokenType _tmp42_;
				_tmp41_ = token;
				_tmp42_ = _tmp41_->type;
				_tmp38_ = _tmp42_ != LEXER_TOKEN_TYPE_ASSIGN;
			} else {
				_tmp38_ = FALSE;
			}
			if (!_tmp38_) {
				break;
			}
			_tmp43_ = token;
			_tmp44_ = _tmp43_->type;
			if (_tmp44_ == LEXER_TOKEN_TYPE_L_R_BRACKET) {
				gint _tmp45_;
				_tmp45_ = m_depth;
				m_depth = _tmp45_ + 1;
			} else {
				LexerToken* _tmp46_;
				LexerTokenType _tmp47_;
				_tmp46_ = token;
				_tmp47_ = _tmp46_->type;
				if (_tmp47_ == LEXER_TOKEN_TYPE_R_R_BRACKET) {
					gint _tmp48_;
					gint _tmp49_;
					_tmp48_ = m_depth;
					m_depth = _tmp48_ - 1;
					_tmp49_ = m_depth;
					if (_tmp49_ == 0) {
						break;
					}
				} else {
					LexerToken* _tmp50_;
					LexerToken* _tmp51_;
					_tmp50_ = token;
					_tmp51_ = _g_object_ref0 (_tmp50_);
					token_list = g_list_append (token_list, _tmp51_);
				}
			}
			_tmp52_ = argument_list;
			_tmp53_ = token;
			_tmp54_ = _tmp53_->text;
			_tmp55_ = g_strconcat (_tmp52_, _tmp54_, NULL);
			_g_free0 (argument_list);
			argument_list = _tmp55_;
			_tmp56_ = self->priv->lexer;
			_tmp57_ = lexer_get_next_token (_tmp56_);
			_g_object_unref0 (token);
			token = _tmp57_;
			_tmp58_ = num_token_parsed;
			num_token_parsed = _tmp58_ + 1;
		}
		_tmp59_ = token;
		_tmp60_ = _tmp59_->type;
		if (_tmp60_ != LEXER_TOKEN_TYPE_R_R_BRACKET) {
			guint _tmp63_;
			while (TRUE) {
				gint _tmp61_;
				Lexer* _tmp62_;
				_tmp61_ = num_token_parsed;
				num_token_parsed = _tmp61_ - 1;
				if (!(_tmp61_ > 0)) {
					break;
				}
				_tmp62_ = self->priv->lexer;
				lexer_roll_back (_tmp62_);
			}
			_tmp63_ = self->priv->depth_level;
			self->priv->depth_level = _tmp63_ - 1;
			result = FALSE;
			__g_list_free__g_object_unref0_0 (token_list);
			_g_free0 (argument_list);
			_g_free0 (power);
			_g_object_unref0 (token);
			_g_free0 (function_name);
			_g_object_unref0 (fun_token);
			return result;
		}
		_tmp64_ = token_list;
		_tmp65_ = argument_list;
		_tmp66_ = function_arguments_node_new (self, _tmp64_, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), _tmp65_);
		_tmp67_ = _tmp66_;
		parser_insert_into_tree (self, (ParseNode*) _tmp67_);
		_g_object_unref0 (_tmp67_);
		__g_list_free__g_object_unref0_0 (token_list);
		_g_free0 (argument_list);
	} else {
		Lexer* _tmp68_;
		Lexer* _tmp71_;
		LexerToken* _tmp72_;
		LexerToken* _tmp73_;
		LexerTokenType _tmp74_;
		guint _tmp82_;
		_tmp68_ = self->priv->lexer;
		lexer_roll_back (_tmp68_);
		if (!parser_expression_1 (self)) {
			Lexer* _tmp69_;
			guint _tmp70_;
			_tmp69_ = self->priv->lexer;
			lexer_roll_back (_tmp69_);
			_tmp70_ = self->priv->depth_level;
			self->priv->depth_level = _tmp70_ - 1;
			result = FALSE;
			_g_free0 (power);
			_g_object_unref0 (token);
			_g_free0 (function_name);
			_g_object_unref0 (fun_token);
			return result;
		}
		_tmp71_ = self->priv->lexer;
		_tmp72_ = lexer_get_next_token (_tmp71_);
		_g_object_unref0 (token);
		token = _tmp72_;
		_tmp73_ = token;
		_tmp74_ = _tmp73_->type;
		if (_tmp74_ == LEXER_TOKEN_TYPE_FACTORIAL) {
			LexerToken* _tmp75_;
			LexerToken* _tmp76_;
			LexerTokenType _tmp77_;
			LexerToken* _tmp78_;
			FactorialNode* _tmp79_;
			FactorialNode* _tmp80_;
			_tmp75_ = token;
			_tmp76_ = token;
			_tmp77_ = _tmp76_->type;
			_tmp78_ = token;
			_tmp79_ = factorial_node_new (self, _tmp75_, parser_make_precedence_t (self, _tmp77_), parser_get_associativity (self, _tmp78_));
			_tmp80_ = _tmp79_;
			parser_insert_into_tree_unary (self, (ParseNode*) _tmp80_);
			_g_object_unref0 (_tmp80_);
		} else {
			Lexer* _tmp81_;
			_tmp81_ = self->priv->lexer;
			lexer_roll_back (_tmp81_);
		}
		_tmp82_ = self->priv->depth_level;
		self->priv->depth_level = _tmp82_ - 1;
		if (!parser_expression_2 (self)) {
			Lexer* _tmp83_;
			_tmp83_ = self->priv->lexer;
			lexer_roll_back (_tmp83_);
			result = FALSE;
			_g_free0 (power);
			_g_object_unref0 (token);
			_g_free0 (function_name);
			_g_object_unref0 (fun_token);
			return result;
		}
		result = TRUE;
		_g_free0 (power);
		_g_object_unref0 (token);
		_g_free0 (function_name);
		_g_object_unref0 (fun_token);
		return result;
	}
	_tmp84_ = self->priv->depth_level;
	self->priv->depth_level = _tmp84_ - 1;
	result = TRUE;
	_g_free0 (power);
	_g_object_unref0 (token);
	_g_free0 (function_name);
	_g_object_unref0 (fun_token);
	return result;
}


static gboolean
parser_term (Parser* self)
{
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	LexerToken* _tmp2_;
	LexerTokenType _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp2_ = token;
	_tmp3_ = _tmp2_->type;
	if (_tmp3_ == LEXER_TOKEN_TYPE_VARIABLE) {
		LexerToken* token_old = NULL;
		LexerToken* _tmp4_;
		LexerToken* _tmp5_;
		Lexer* _tmp6_;
		LexerToken* _tmp7_;
		LexerToken* _tmp8_;
		const gchar* _tmp9_;
		LexerToken* _tmp24_;
		LexerTokenType _tmp25_;
		_tmp4_ = token;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		token_old = _tmp5_;
		_tmp6_ = self->priv->lexer;
		_tmp7_ = lexer_get_next_token (_tmp6_);
		_g_object_unref0 (token);
		token = _tmp7_;
		_tmp8_ = token_old;
		_tmp9_ = _tmp8_->text;
		if (!parser_check_variable (self, _tmp9_)) {
			LexerToken* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = token;
			_tmp11_ = _tmp10_->text;
			if (g_strcmp0 (_tmp11_, "(") == 0) {
				LexerToken* _tmp12_;
				const gchar* _tmp13_;
				LexerToken* _tmp14_;
				guint _tmp15_;
				LexerToken* _tmp16_;
				guint _tmp17_;
				_tmp12_ = token_old;
				_tmp13_ = _tmp12_->text;
				_tmp14_ = token_old;
				_tmp15_ = _tmp14_->start_index;
				_tmp16_ = token_old;
				_tmp17_ = _tmp16_->end_index;
				parser_set_error (self, ERROR_CODE_UNKNOWN_FUNCTION, _tmp13_, _tmp15_, _tmp17_);
			} else {
				LexerToken* _tmp18_;
				const gchar* _tmp19_;
				LexerToken* _tmp20_;
				guint _tmp21_;
				LexerToken* _tmp22_;
				guint _tmp23_;
				_tmp18_ = token_old;
				_tmp19_ = _tmp18_->text;
				_tmp20_ = token_old;
				_tmp21_ = _tmp20_->start_index;
				_tmp22_ = token_old;
				_tmp23_ = _tmp22_->end_index;
				parser_set_error (self, ERROR_CODE_UNKNOWN_VARIABLE, _tmp19_, _tmp21_, _tmp23_);
			}
			result = FALSE;
			_g_object_unref0 (token_old);
			_g_object_unref0 (token);
			return result;
		}
		_tmp24_ = token;
		_tmp25_ = _tmp24_->type;
		if (_tmp25_ == LEXER_TOKEN_TYPE_SUP_NUMBER) {
			LexerToken* _tmp26_;
			LexerToken* _tmp27_;
			LexerTokenType _tmp28_;
			LexerToken* _tmp29_;
			LexerToken* _tmp30_;
			const gchar* _tmp31_;
			VariableWithPowerNode* _tmp32_;
			VariableWithPowerNode* _tmp33_;
			_tmp26_ = token_old;
			_tmp27_ = token_old;
			_tmp28_ = _tmp27_->type;
			_tmp29_ = token_old;
			_tmp30_ = token;
			_tmp31_ = _tmp30_->text;
			_tmp32_ = variable_with_power_node_new (self, _tmp26_, parser_make_precedence_t (self, _tmp28_), parser_get_associativity (self, _tmp29_), _tmp31_);
			_tmp33_ = _tmp32_;
			parser_insert_into_tree (self, (ParseNode*) _tmp33_);
			_g_object_unref0 (_tmp33_);
		} else {
			Lexer* _tmp34_;
			LexerToken* _tmp35_;
			LexerToken* _tmp36_;
			LexerTokenType _tmp37_;
			LexerToken* _tmp38_;
			VariableNode* _tmp39_;
			VariableNode* _tmp40_;
			_tmp34_ = self->priv->lexer;
			lexer_roll_back (_tmp34_);
			_tmp35_ = token_old;
			_tmp36_ = token_old;
			_tmp37_ = _tmp36_->type;
			_tmp38_ = token_old;
			_tmp39_ = variable_node_new (self, _tmp35_, parser_make_precedence_t (self, _tmp37_), parser_get_associativity (self, _tmp38_));
			_tmp40_ = _tmp39_;
			parser_insert_into_tree (self, (ParseNode*) _tmp40_);
			_g_object_unref0 (_tmp40_);
		}
		if (!parser_term_2 (self)) {
			result = FALSE;
			_g_object_unref0 (token_old);
			_g_object_unref0 (token);
			return result;
		}
		result = TRUE;
		_g_object_unref0 (token_old);
		_g_object_unref0 (token);
		return result;
	} else {
		result = FALSE;
		_g_object_unref0 (token);
		return result;
	}
	_g_object_unref0 (token);
}


static gboolean
parser_term_2 (Parser* self)
{
	gboolean result = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	Lexer* _tmp2_;
	gboolean _tmp3_ = FALSE;
	LexerToken* _tmp4_;
	LexerTokenType _tmp5_;
	LexerToken* _tmp8_;
	LexerTokenType _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp2_ = self->priv->lexer;
	lexer_roll_back (_tmp2_);
	_tmp4_ = token;
	_tmp5_ = _tmp4_->type;
	if (_tmp5_ == LEXER_TOKEN_TYPE_PL_EOS) {
		_tmp3_ = TRUE;
	} else {
		LexerToken* _tmp6_;
		LexerTokenType _tmp7_;
		_tmp6_ = token;
		_tmp7_ = _tmp6_->type;
		_tmp3_ = _tmp7_ == LEXER_TOKEN_TYPE_ASSIGN;
	}
	if (_tmp3_) {
		result = TRUE;
		_g_object_unref0 (token);
		return result;
	}
	_tmp8_ = token;
	_tmp9_ = _tmp8_->type;
	if (_tmp9_ == LEXER_TOKEN_TYPE_VARIABLE) {
		MultiplyNode* _tmp10_;
		MultiplyNode* _tmp11_;
		_tmp10_ = multiply_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_MULTIPLY), parser_get_associativity_p (self, PRECEDENCE_MULTIPLY));
		_tmp11_ = _tmp10_;
		parser_insert_into_tree (self, (ParseNode*) _tmp11_);
		_g_object_unref0 (_tmp11_);
		if (!parser_term (self)) {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
		result = TRUE;
		_g_object_unref0 (token);
		return result;
	} else {
		result = TRUE;
		_g_object_unref0 (token);
		return result;
	}
	_g_object_unref0 (token);
}


static void
value_parser_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
value_parser_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		parser_unref (value->data[0].v_pointer);
	}
}


static void
value_parser_copy_value (const GValue* src_value,
                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = parser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
value_parser_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
value_parser_collect_value (GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Parser * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = parser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
value_parser_lcopy_value (const GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	Parser ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = parser_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
param_spec_parser (const gchar* name,
                   const gchar* nick,
                   const gchar* blurb,
                   GType object_type,
                   GParamFlags flags)
{
	ParamSpecParser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PARSER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
value_get_parser (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PARSER), NULL);
	return value->data[0].v_pointer;
}


void
value_set_parser (GValue* value,
                  gpointer v_object)
{
	Parser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		parser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		parser_unref (old);
	}
}


void
value_take_parser (GValue* value,
                   gpointer v_object)
{
	Parser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		parser_unref (old);
	}
}


static void
parser_class_init (ParserClass * klass)
{
	parser_parent_class = g_type_class_peek_parent (klass);
	((ParserClass *) klass)->finalize = parser_finalize;
	g_type_class_add_private (klass, sizeof (ParserPrivate));
	((ParserClass *) klass)->variable_is_defined = (gboolean (*) (Parser *, const gchar*)) parser_real_variable_is_defined;
	((ParserClass *) klass)->get_variable = (Number* (*) (Parser *, const gchar*)) parser_real_get_variable;
	((ParserClass *) klass)->set_variable = (void (*) (Parser *, const gchar*, Number*)) parser_real_set_variable;
	((ParserClass *) klass)->function_is_defined = (gboolean (*) (Parser *, const gchar*)) parser_real_function_is_defined;
	((ParserClass *) klass)->unit_is_defined = (gboolean (*) (Parser *, const gchar*)) parser_real_unit_is_defined;
	((ParserClass *) klass)->convert = (Number* (*) (Parser *, Number*, const gchar*, const gchar*)) parser_real_convert;
}


static void
parser_instance_init (Parser * self)
{
	self->priv = PARSER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
parser_finalize (Parser * obj)
{
	Parser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PARSER, Parser);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->input);
	_g_object_unref0 (self->priv->root);
	_g_object_unref0 (self->priv->right_most);
	_g_object_unref0 (self->priv->lexer);
	_g_free0 (self->priv->error_token);
}


GType
parser_get_type (void)
{
	static volatile gsize parser_type_id__volatile = 0;
	if (g_once_init_enter (&parser_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_parser_init, value_parser_free_value, value_parser_copy_value, value_parser_peek_pointer, "p", value_parser_collect_value, "p", value_parser_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Parser), 0, (GInstanceInitFunc) parser_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType parser_type_id;
		parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Parser", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&parser_type_id__volatile, parser_type_id);
	}
	return parser_type_id__volatile;
}


gpointer
parser_ref (gpointer instance)
{
	Parser * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
parser_unref (gpointer instance)
{
	Parser * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PARSER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



