// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/v3/notification.proto

package monitoring

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_api3 "google.golang.org/genproto/googleapis/api/label"
import google_protobuf4 "github.com/golang/protobuf/ptypes/wrappers"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Indicates whether the channel has been verified or not. It is illegal
// to specify this field in a
// [`CreateNotificationChannel`][google.monitoring.v3.NotificationChannelService.CreateNotificationChannel]
// or an
// [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
// operation.
type NotificationChannel_VerificationStatus int32

const (
	// Sentinel value used to indicate that the state is unknown, omitted, or
	// is not applicable (as in the case of channels that neither support
	// nor require verification in order to function).
	NotificationChannel_VERIFICATION_STATUS_UNSPECIFIED NotificationChannel_VerificationStatus = 0
	// The channel has yet to be verified and requires verification to function.
	// Note that this state also applies to the case where the verification
	// process has been initiated by sending a verification code but where
	// the verification code has not been submitted to complete the process.
	NotificationChannel_UNVERIFIED NotificationChannel_VerificationStatus = 1
	// It has been proven that notifications can be received on this
	// notification channel and that someone on the project has access
	// to messages that are delivered to that channel.
	NotificationChannel_VERIFIED NotificationChannel_VerificationStatus = 2
)

var NotificationChannel_VerificationStatus_name = map[int32]string{
	0: "VERIFICATION_STATUS_UNSPECIFIED",
	1: "UNVERIFIED",
	2: "VERIFIED",
}
var NotificationChannel_VerificationStatus_value = map[string]int32{
	"VERIFICATION_STATUS_UNSPECIFIED": 0,
	"UNVERIFIED":                      1,
	"VERIFIED":                        2,
}

func (x NotificationChannel_VerificationStatus) String() string {
	return proto.EnumName(NotificationChannel_VerificationStatus_name, int32(x))
}
func (NotificationChannel_VerificationStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor8, []int{1, 0}
}

// A description of a notification channel. The descriptor includes
// the properties of the channel and the set of labels or fields that
// must be specified to configure channels of a given type.
type NotificationChannelDescriptor struct {
	// The full REST resource name for this descriptor. The syntax is:
	//
	//     projects/[PROJECT_ID]/notificationChannelDescriptors/[TYPE]
	//
	// In the above, `[TYPE]` is the value of the `type` field.
	Name string `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
	// The type of notification channel, such as "email", "sms", etc.
	// Notification channel types are globally unique.
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// A human-readable name for the notification channel type.  This
	// form of the name is suitable for a user interface.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// A human-readable description of the notification channel
	// type. The description may include a description of the properties
	// of the channel and pointers to external documentation.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// The set of labels that must be defined to identify a particular
	// channel of the corresponding type. Each label includes a
	// description for how that field should be populated.
	Labels []*google_api3.LabelDescriptor `protobuf:"bytes,4,rep,name=labels" json:"labels,omitempty"`
	// The tiers that support this notification channel; the project service tier
	// must be one of the supported_tiers.
	SupportedTiers []ServiceTier `protobuf:"varint,5,rep,packed,name=supported_tiers,json=supportedTiers,enum=google.monitoring.v3.ServiceTier" json:"supported_tiers,omitempty"`
}

func (m *NotificationChannelDescriptor) Reset()                    { *m = NotificationChannelDescriptor{} }
func (m *NotificationChannelDescriptor) String() string            { return proto.CompactTextString(m) }
func (*NotificationChannelDescriptor) ProtoMessage()               {}
func (*NotificationChannelDescriptor) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{0} }

func (m *NotificationChannelDescriptor) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NotificationChannelDescriptor) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *NotificationChannelDescriptor) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *NotificationChannelDescriptor) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *NotificationChannelDescriptor) GetLabels() []*google_api3.LabelDescriptor {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *NotificationChannelDescriptor) GetSupportedTiers() []ServiceTier {
	if m != nil {
		return m.SupportedTiers
	}
	return nil
}

// A `NotificationChannel` is a medium through which an alert is
// delivered when a policy violation is detected. Examples of channels
// include email, SMS, and third-party messaging applications. Fields
// containing sensitive information like authentication tokens or
// contact info are only partially populated on retrieval.
type NotificationChannel struct {
	// The type of the notification channel. This field matches the
	// value of the [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type] field.
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// The full REST resource name for this channel. The syntax is:
	//
	//     projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
	//
	// The `[CHANNEL_ID]` is automatically assigned by the server on creation.
	Name string `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
	// An optional human-readable name for this notification channel. It is
	// recommended that you specify a non-empty and unique name in order to
	// make it easier to identify the channels in your project, though this is
	// not enforced. The display name is limited to 512 Unicode characters.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// An optional human-readable description of this notification channel. This
	// description may provide additional details, beyond the display
	// name, for the channel. This may not exceeed 1024 Unicode characters.
	Description string `protobuf:"bytes,4,opt,name=description" json:"description,omitempty"`
	// Configuration fields that define the channel and its behavior. The
	// permissible and required labels are specified in the
	// [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels] of the
	// `NotificationChannelDescriptor` corresponding to the `type` field.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// User-supplied key/value data that does not need to conform to
	// the corresponding `NotificationChannelDescriptor`'s schema, unlike
	// the `labels` field. This field is intended to be used for organizing
	// and identifying the `NotificationChannel` objects.
	//
	// The field can contain up to 64 entries. Each key and value is limited to
	// 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
	// values can contain only lowercase letters, numerals, underscores, and
	// dashes. Keys must begin with a letter.
	UserLabels map[string]string `protobuf:"bytes,8,rep,name=user_labels,json=userLabels" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Indicates whether this channel has been verified or not. On a
	// [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
	// or
	// [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
	// operation, this field is expected to be populated.
	//
	// If the value is `UNVERIFIED`, then it indicates that the channel is
	// non-functioning (it both requires verification and lacks verification);
	// otherwise, it is assumed that the channel works.
	//
	// If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
	// the channel is of a type that does not require verification or that
	// this specific channel has been exempted from verification because it was
	// created prior to verification being required for channels of this type.
	//
	// This field cannot be modified using a standard
	// [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
	// operation. To change the value of this field, you must call
	// [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
	VerificationStatus NotificationChannel_VerificationStatus `protobuf:"varint,9,opt,name=verification_status,json=verificationStatus,enum=google.monitoring.v3.NotificationChannel_VerificationStatus" json:"verification_status,omitempty"`
	// Whether notifications are forwarded to the described channel. This makes
	// it possible to disable delivery of notifications to a particular channel
	// without removing the channel from all alerting policies that reference
	// the channel. This is a more convenient approach when the change is
	// temporary and you want to receive notifications from the same set
	// of alerting policies on the channel at some point in the future.
	Enabled *google_protobuf4.BoolValue `protobuf:"bytes,11,opt,name=enabled" json:"enabled,omitempty"`
}

func (m *NotificationChannel) Reset()                    { *m = NotificationChannel{} }
func (m *NotificationChannel) String() string            { return proto.CompactTextString(m) }
func (*NotificationChannel) ProtoMessage()               {}
func (*NotificationChannel) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{1} }

func (m *NotificationChannel) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *NotificationChannel) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NotificationChannel) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *NotificationChannel) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *NotificationChannel) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *NotificationChannel) GetUserLabels() map[string]string {
	if m != nil {
		return m.UserLabels
	}
	return nil
}

func (m *NotificationChannel) GetVerificationStatus() NotificationChannel_VerificationStatus {
	if m != nil {
		return m.VerificationStatus
	}
	return NotificationChannel_VERIFICATION_STATUS_UNSPECIFIED
}

func (m *NotificationChannel) GetEnabled() *google_protobuf4.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func init() {
	proto.RegisterType((*NotificationChannelDescriptor)(nil), "google.monitoring.v3.NotificationChannelDescriptor")
	proto.RegisterType((*NotificationChannel)(nil), "google.monitoring.v3.NotificationChannel")
	proto.RegisterEnum("google.monitoring.v3.NotificationChannel_VerificationStatus", NotificationChannel_VerificationStatus_name, NotificationChannel_VerificationStatus_value)
}

func init() { proto.RegisterFile("google/monitoring/v3/notification.proto", fileDescriptor8) }

var fileDescriptor8 = []byte{
	// 599 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x94, 0xdd, 0x6e, 0xd3, 0x30,
	0x14, 0xc7, 0x49, 0xbb, 0x8e, 0xcd, 0x99, 0xba, 0xe1, 0x4d, 0x28, 0x0a, 0x5f, 0xdd, 0xb8, 0xa0,
	0x57, 0x89, 0xd4, 0x82, 0xc4, 0xf8, 0x92, 0xb6, 0xae, 0x43, 0x45, 0xac, 0x4c, 0xfd, 0x42, 0x9a,
	0x26, 0x55, 0x6e, 0xeb, 0x05, 0x8b, 0xc4, 0x8e, 0x6c, 0x27, 0xa8, 0x0f, 0xc1, 0x63, 0x70, 0x01,
	0x8f, 0xc2, 0x53, 0xa1, 0x38, 0x6e, 0x12, 0xb6, 0x48, 0x8c, 0x3b, 0x9f, 0x73, 0xfe, 0xe7, 0x7f,
	0xce, 0xf9, 0x35, 0x2a, 0x78, 0xe6, 0x31, 0xe6, 0xf9, 0xd8, 0x0d, 0x18, 0x25, 0x92, 0x71, 0x42,
	0x3d, 0x37, 0x6e, 0xbb, 0x94, 0x49, 0x72, 0x45, 0xe6, 0x48, 0x12, 0x46, 0x9d, 0x90, 0x33, 0xc9,
	0xe0, 0x5e, 0x2a, 0x74, 0x72, 0xa1, 0x13, 0xb7, 0xed, 0x87, 0xba, 0x1d, 0x85, 0xc4, 0x45, 0x94,
	0x32, 0xa9, 0x5a, 0x44, 0xda, 0x63, 0xdf, 0x2f, 0x54, 0x7d, 0x34, 0xc3, 0xbe, 0xce, 0xef, 0x97,
	0x0e, 0x9d, 0xb3, 0x20, 0x58, 0x8d, 0xb3, 0x1f, 0x6b, 0x89, 0x8a, 0x66, 0xd1, 0x95, 0xfb, 0x8d,
	0xa3, 0x30, 0xc4, 0x5c, 0x5b, 0x1f, 0x7c, 0xaf, 0x80, 0x47, 0xfd, 0xc2, 0x96, 0x9d, 0x2f, 0x88,
	0x52, 0xec, 0x9f, 0x60, 0x31, 0xe7, 0x24, 0x94, 0x8c, 0x43, 0x08, 0xd6, 0x28, 0x0a, 0xb0, 0xb5,
	0xde, 0x30, 0x9a, 0x9b, 0x03, 0xf5, 0x4e, 0x72, 0x72, 0x19, 0x62, 0xcb, 0x48, 0x73, 0xc9, 0x1b,
	0xee, 0x83, 0xad, 0x05, 0x11, 0xa1, 0x8f, 0x96, 0x53, 0xa5, 0xaf, 0xa8, 0x9a, 0xa9, 0x73, 0xfd,
	0xa4, 0xad, 0x01, 0xcc, 0x85, 0x36, 0x26, 0x8c, 0x5a, 0x55, 0xad, 0xc8, 0x53, 0xb0, 0x0d, 0xd6,
	0xd5, 0x81, 0xc2, 0x5a, 0x6b, 0x54, 0x9b, 0x66, 0xeb, 0x81, 0xa3, 0x71, 0xa1, 0x90, 0x38, 0x1f,
	0x93, 0x4a, 0xbe, 0xd9, 0x40, 0x4b, 0xe1, 0x07, 0xb0, 0x2d, 0xa2, 0x30, 0x64, 0x5c, 0xe2, 0xc5,
	0x54, 0x12, 0xcc, 0x85, 0x55, 0x6b, 0x54, 0x9b, 0xf5, 0xd6, 0xbe, 0x53, 0x06, 0xdb, 0x19, 0x62,
	0x1e, 0x93, 0x39, 0x1e, 0x11, 0xcc, 0x07, 0xf5, 0xac, 0x33, 0x09, 0xc5, 0xc1, 0x8f, 0x1a, 0xd8,
	0x2d, 0xe1, 0x51, 0x7a, 0x71, 0x19, 0x99, 0xeb, 0x14, 0xaa, 0xff, 0xa4, 0xb0, 0x76, 0x93, 0xc2,
	0x59, 0x46, 0xa1, 0xa6, 0x28, 0xbc, 0x28, 0xbf, 0xa3, 0x64, 0xcf, 0x94, 0x91, 0xe8, 0x52, 0xc9,
	0x97, 0x19, 0x9f, 0x0b, 0x60, 0x46, 0x02, 0xf3, 0xa9, 0xf6, 0xdc, 0x50, 0x9e, 0x87, 0xb7, 0xf7,
	0x1c, 0x0b, 0xcc, 0x8b, 0xbe, 0x20, 0xca, 0x12, 0x30, 0x00, 0xbb, 0x31, 0xe6, 0x59, 0xcb, 0x54,
	0x48, 0x24, 0x23, 0x61, 0x6d, 0x36, 0x8c, 0x66, 0xbd, 0xf5, 0xe6, 0xf6, 0x33, 0x26, 0x05, 0x93,
	0xa1, 0xf2, 0x18, 0xc0, 0xf8, 0x46, 0x0e, 0x3e, 0x07, 0x77, 0x31, 0x45, 0x33, 0x1f, 0x2f, 0x2c,
	0xb3, 0x61, 0x34, 0xcd, 0x96, 0xbd, 0x1a, 0xb1, 0xfa, 0xc0, 0x9d, 0x63, 0xc6, 0xfc, 0x09, 0xf2,
	0x23, 0x3c, 0x58, 0x49, 0xed, 0x43, 0x60, 0x16, 0xf6, 0x87, 0x3b, 0xa0, 0xfa, 0x15, 0x2f, 0xf5,
	0x4f, 0x99, 0x3c, 0xe1, 0x1e, 0xa8, 0xc5, 0x49, 0x8b, 0xfe, 0x68, 0xd3, 0xe0, 0x55, 0xe5, 0xa5,
	0x61, 0xbf, 0x05, 0xdb, 0xd7, 0xce, 0xff, 0x9f, 0xf6, 0x83, 0xcf, 0x00, 0xde, 0xbc, 0x0c, 0x3e,
	0x05, 0x4f, 0x26, 0xdd, 0x41, 0xef, 0xb4, 0xd7, 0x39, 0x1a, 0xf5, 0x3e, 0xf5, 0xa7, 0xc3, 0xd1,
	0xd1, 0x68, 0x3c, 0x9c, 0x8e, 0xfb, 0xc3, 0xf3, 0x6e, 0xa7, 0x77, 0xda, 0xeb, 0x9e, 0xec, 0xdc,
	0x81, 0x75, 0x00, 0xc6, 0xfd, 0x54, 0xd6, 0x3d, 0xd9, 0x31, 0xe0, 0x16, 0xd8, 0xc8, 0xa2, 0xca,
	0xf1, 0x4f, 0x03, 0x58, 0x73, 0x16, 0x94, 0x02, 0x3e, 0xbe, 0x57, 0x24, 0x7c, 0x9e, 0x80, 0x39,
	0x37, 0x2e, 0xde, 0x69, 0xa9, 0xc7, 0x7c, 0x44, 0x3d, 0x87, 0x71, 0xcf, 0xf5, 0x30, 0x55, 0xd8,
	0xdc, 0xb4, 0x84, 0x42, 0x22, 0xfe, 0xfe, 0x2f, 0x79, 0x9d, 0x47, 0xbf, 0x2a, 0xf6, 0xfb, 0xd4,
	0xa0, 0xe3, 0xb3, 0x68, 0xe1, 0x9c, 0xe5, 0x13, 0x27, 0xed, 0xdf, 0xab, 0xe2, 0xa5, 0x2a, 0x5e,
	0xe6, 0xc5, 0xcb, 0x49, 0x7b, 0xb6, 0xae, 0x86, 0xb4, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0xdf,
	0xb9, 0x3f, 0x8b, 0x24, 0x05, 0x00, 0x00,
}
