/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef IMPRESOURCEDIR_H_INCLUDED
#define IMPRESOURCEDIR_H_INCLUDED

#include <boost/shared_ptr.hpp>

class WPXInputStream;

namespace libebook
{

class IMPHeader;
class IMPResourceDirImpl;

/** Read the resource tree and provide access to it as an OLE stream.
  */
class IMPResourceDir
{
public:
  IMPResourceDir(WPXInputStream *input, const IMPHeader &header);

  /** Get OLE stream for this resource directory.
    *
    * The "files" in the stream are referenced by their names (i.e.,
    * random four-letter strings)..
    *
    * @return OLE stream
    */
  boost::shared_ptr<WPXInputStream> getNameStream() const;

  /** Get OLE stream for this resource directory.
    *
    * The "files" in the stream are referenced by their type.
    *
    * @return OLE stream
    */
  boost::shared_ptr<WPXInputStream> getTypeStream() const;

private:
  boost::shared_ptr<IMPResourceDirImpl> m_impl;
};

}

#endif // IMPRESOURCEDIR_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
