/* VideoSupport.c generated by valac 0.40.4, the Vala compiler
 * generated from VideoSupport.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <signal.h>
#include <sys/types.h>
#include <gio/gunixinputstream.h>
#include <sys/wait.h>
#include <glib/gstdio.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_VIDEO_IMPORT_PARAMS (video_import_params_get_type ())
#define VIDEO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParams))
#define VIDEO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParamsClass))
#define IS_VIDEO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_IMPORT_PARAMS))
#define IS_VIDEO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_IMPORT_PARAMS))
#define VIDEO_IMPORT_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParamsClass))

typedef struct _VideoImportParams VideoImportParams;
typedef struct _VideoImportParamsClass VideoImportParamsClass;
typedef struct _VideoImportParamsPrivate VideoImportParamsPrivate;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;

#define TYPE_VIDEO_ROW (video_row_get_type ())
#define VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_ROW, VideoRow))
#define VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_ROW, VideoRowClass))
#define IS_VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_ROW))
#define IS_VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_ROW))
#define VIDEO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_ROW, VideoRowClass))

typedef struct _VideoRow VideoRow;
typedef struct _VideoRowClass VideoRowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _thumbnails_unref0(var) ((var == NULL) ? NULL : (var = (thumbnails_unref (var), NULL)))
#define _video_row_unref0(var) ((var == NULL) ? NULL : (var = (video_row_unref (var), NULL)))
typedef struct _ParamSpecVideoImportParams ParamSpecVideoImportParams;

#define TYPE_VIDEO_READER (video_reader_get_type ())
#define VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_READER, VideoReader))
#define VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_READER, VideoReaderClass))
#define IS_VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_READER))
#define IS_VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_READER))
#define VIDEO_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_READER, VideoReaderClass))

typedef struct _VideoReader VideoReader;
typedef struct _VideoReaderClass VideoReaderClass;
typedef struct _VideoReaderPrivate VideoReaderPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_IMPORT_RESULT (import_result_get_type ())
#define _video_reader_unref0(var) ((var == NULL) ? NULL : (var = (video_reader_unref (var), NULL)))

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_VIDEO_METADATA (video_metadata_get_type ())
#define VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_METADATA, VideoMetadata))
#define VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_METADATA, VideoMetadataClass))
#define IS_VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_METADATA))
#define IS_VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_METADATA))
#define VIDEO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_METADATA, VideoMetadataClass))

typedef struct _VideoMetadata VideoMetadata;
typedef struct _VideoMetadataClass VideoMetadataClass;

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
typedef struct _VideoRowPrivate VideoRowPrivate;

#define TYPE_VIDEO_ID (video_id_get_type ())
typedef struct _VideoID VideoID;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_RATING (rating_get_type ())
typedef struct _ParamSpecVideoReader ParamSpecVideoReader;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;
typedef struct _VideoSourcePrivate VideoSourcePrivate;

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;

#define TYPE_DATEABLE (dateable_get_type ())
#define DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATEABLE, Dateable))
#define IS_DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATEABLE))
#define DATEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATEABLE, DateableIface))

typedef struct _Dateable Dateable;
typedef struct _DateableIface DateableIface;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
typedef struct _VideoPrivate VideoPrivate;
enum  {
	VIDEO_0_PROPERTY,
	VIDEO_NUM_PROPERTIES
};
static GParamSpec* video_properties[VIDEO_NUM_PROPERTIES];

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define TYPE_VIDEO_SOURCE_COLLECTION (video_source_collection_get_type ())
#define VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection))
#define VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))
#define IS_VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE_COLLECTION))
#define IS_VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE_COLLECTION))
#define VIDEO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))

typedef struct _VideoSourceCollection VideoSourceCollection;
typedef struct _VideoSourceCollectionClass VideoSourceCollectionClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_VIDEO_TABLE (video_table_get_type ())
#define VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_TABLE, VideoTable))
#define VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_TABLE, VideoTableClass))
#define IS_VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_TABLE))
#define IS_VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_TABLE))
#define VIDEO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_TABLE, VideoTableClass))

typedef struct _VideoTable VideoTable;
typedef struct _VideoTableClass VideoTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_EXPORTER (exporter_get_type ())
#define EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER, Exporter))
#define EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER, ExporterClass))
#define IS_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER))
#define IS_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER))
#define EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER, ExporterClass))

typedef struct _Exporter Exporter;
typedef struct _ExporterClass ExporterClass;

#define TYPE_EXPORTER_UI (exporter_ui_get_type ())
#define EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER_UI, ExporterUI))
#define EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER_UI, ExporterUIClass))
#define IS_EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER_UI))
#define IS_EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER_UI))
#define EXPORTER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER_UI, ExporterUIClass))

typedef struct _ExporterUI ExporterUI;
typedef struct _ExporterUIClass ExporterUIClass;

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;
#define _exporter_ui_unref0(var) ((var == NULL) ? NULL : (var = (exporter_ui_unref (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
#define _backing_file_state_unref0(var) ((var == NULL) ? NULL : (var = (backing_file_state_unref (var), NULL)))

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define VIDEO_TYPE_INTERPRETABLE_RESULTS (video_interpretable_results_get_type ())
#define VIDEO_INTERPRETABLE_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResults))
#define VIDEO_INTERPRETABLE_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResultsClass))
#define VIDEO_IS_INTERPRETABLE_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS))
#define VIDEO_IS_INTERPRETABLE_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIDEO_TYPE_INTERPRETABLE_RESULTS))
#define VIDEO_INTERPRETABLE_RESULTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResultsClass))

typedef struct _VideoInterpretableResults VideoInterpretableResults;
typedef struct _VideoInterpretableResultsClass VideoInterpretableResultsClass;
#define _video_interpretable_results_unref0(var) ((var == NULL) ? NULL : (var = (video_interpretable_results_unref (var), NULL)))
typedef struct _VideoInterpretableResultsPrivate VideoInterpretableResultsPrivate;
typedef struct _VideoParamSpecInterpretableResults VideoParamSpecInterpretableResults;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;
typedef struct _MediaSourceCollectionPrivate MediaSourceCollectionPrivate;

#define TYPE_DATABASE_SOURCE_HOLDING_TANK (database_source_holding_tank_get_type ())
#define DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank))
#define DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))
#define IS_DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define IS_DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define DATABASE_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))

typedef struct _DatabaseSourceHoldingTank DatabaseSourceHoldingTank;
typedef struct _DatabaseSourceHoldingTankClass DatabaseSourceHoldingTankClass;

#define TYPE_MEDIA_SOURCE_HOLDING_TANK (media_source_holding_tank_get_type ())
#define MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank))
#define MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))
#define IS_MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define IS_MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define MEDIA_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))

typedef struct _MediaSourceHoldingTank MediaSourceHoldingTank;
typedef struct _MediaSourceHoldingTankClass MediaSourceHoldingTankClass;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;
typedef struct _VideoSourceCollectionPrivate VideoSourceCollectionPrivate;

#define VIDEO_SOURCE_COLLECTION_TYPE_STATE (video_source_collection_state_get_type ())
#define _transaction_controller_unref0(var) ((var == NULL) ? NULL : (var = (transaction_controller_unref (var), NULL)))
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))

#define TYPE_VIDEO_MONITOR (video_monitor_get_type ())
#define VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_MONITOR, VideoMonitor))
#define VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_MONITOR, VideoMonitorClass))
#define IS_VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_MONITOR))
#define IS_VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_MONITOR))
#define VIDEO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_MONITOR, VideoMonitorClass))

typedef struct _VideoMonitor VideoMonitor;
typedef struct _VideoMonitorClass VideoMonitorClass;

#define TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER (media_source_transaction_controller_get_type ())
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))

typedef struct _MediaSourceTransactionController MediaSourceTransactionController;
typedef struct _MediaSourceTransactionControllerClass MediaSourceTransactionControllerClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	VIDEO_ERROR_FILE,
	VIDEO_ERROR_CONTENTS
} VideoError;
#define VIDEO_ERROR video_error_quark ()
struct _ImportID {
	gint64 id;
};

struct _VideoImportParams {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoImportParamsPrivate * priv;
	GFile* file;
	ImportID import_id;
	gchar* md5;
	time_t exposure_time_override;
	Thumbnails* thumbnails;
	VideoRow* row;
};

struct _VideoImportParamsClass {
	GTypeClass parent_class;
	void (*finalize) (VideoImportParams *self);
};

struct _ParamSpecVideoImportParams {
	GParamSpec parent_instance;
};

struct _VideoReader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoReaderPrivate * priv;
};

struct _VideoReaderClass {
	GTypeClass parent_class;
	void (*finalize) (VideoReader *self);
};

struct _VideoReaderPrivate {
	gdouble clip_duration;
	GdkPixbuf* preview_frame;
	GFile* file;
	GPid thumbnailer_pid;
	GDateTime* _timestamp;
};

typedef enum  {
	IMPORT_RESULT_SUCCESS,
	IMPORT_RESULT_FILE_ERROR,
	IMPORT_RESULT_DECODE_ERROR,
	IMPORT_RESULT_DATABASE_ERROR,
	IMPORT_RESULT_USER_ABORT,
	IMPORT_RESULT_NOT_A_FILE,
	IMPORT_RESULT_PHOTO_EXISTS,
	IMPORT_RESULT_UNSUPPORTED_FORMAT,
	IMPORT_RESULT_NOT_AN_IMAGE,
	IMPORT_RESULT_DISK_FAILURE,
	IMPORT_RESULT_DISK_FULL,
	IMPORT_RESULT_CAMERA_ERROR,
	IMPORT_RESULT_FILE_WRITE_ERROR,
	IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE
} ImportResult;

struct _VideoID {
	gint64 id;
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _VideoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoRowPrivate * priv;
	VideoID video_id;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	gint width;
	gint height;
	gdouble clip_duration;
	gboolean is_interpretable;
	time_t exposure_time;
	ImportID import_id;
	EventID event_id;
	gchar* md5;
	time_t time_created;
	Rating rating;
	gchar* title;
	gchar* backlinks;
	time_t time_reimported;
	guint64 flags;
	gchar* comment;
};

struct _VideoRowClass {
	GTypeClass parent_class;
	void (*finalize) (VideoRow *self);
};

struct _ParamSpecVideoReader {
	GParamSpec parent_instance;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	time_t (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, int* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	time_t (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _VideoSource {
	MediaSource parent_instance;
	VideoSourcePrivate * priv;
};

struct _VideoSourceClass {
	MediaSourceClass parent_class;
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _DateableIface {
	GTypeInterface parent_iface;
	void (*set_exposure_time) (Dateable* self, time_t target_time);
	time_t (*get_exposure_time) (Dateable* self);
};

struct _Video {
	VideoSource parent_instance;
	VideoPrivate * priv;
};

struct _VideoClass {
	VideoSourceClass parent_class;
};

struct _VideoPrivate {
	VideoRow* backing_row;
	GRecMutex __lock_backing_row;
};

typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
typedef void (*ExporterCompletionCallback) (Exporter* exporter, gboolean is_cancelled, void* user_data);
typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

struct _VideoInterpretableResults {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoInterpretableResultsPrivate * priv;
	Video* video;
	gboolean update_interpretable;
	gboolean is_interpretable;
	GdkPixbuf* new_thumbnail;
};

struct _VideoInterpretableResultsClass {
	GTypeClass parent_class;
	void (*finalize) (VideoInterpretableResults *self);
};

struct _VideoParamSpecInterpretableResults {
	GParamSpec parent_instance;
};

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _MediaSourceCollection {
	DatabaseSourceCollection parent_instance;
	MediaSourceCollectionPrivate * priv;
};

struct _MediaSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	MediaSourceHoldingTank* (*create_trashcan) (MediaSourceCollection* self);
	MediaSourceHoldingTank* (*create_offline_bin) (MediaSourceCollection* self);
	MediaMonitor* (*create_media_monitor) (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable);
	gchar* (*get_typename) (MediaSourceCollection* self);
	gboolean (*is_file_recognized) (MediaSourceCollection* self, GFile* file);
	MediaSource* (*fetch_by_numeric_id) (MediaSourceCollection* self, gint64 numeric_id);
	void (*notify_import_roll_altered) (MediaSourceCollection* self);
	void (*notify_flagged_contents_altered) (MediaSourceCollection* self);
	void (*notify_media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*notify_media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	MediaSource* (*fetch_by_source_id) (MediaSourceCollection* self, const gchar* source_id);
	GeeCollection* (*get_event_source_ids) (MediaSourceCollection* self, EventID* event_id);
	void (*import_many) (MediaSourceCollection* self, GeeCollection* media);
	void (*postprocess_imported_media) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	void (*master_file_replaced) (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file);
	void (*trashcan_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*import_roll_altered) (MediaSourceCollection* self);
	void (*offline_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*flagged_contents_altered) (MediaSourceCollection* self);
	TransactionController* (*get_transaction_controller) (MediaSourceCollection* self);
};

struct _VideoSourceCollection {
	MediaSourceCollection parent_instance;
	VideoSourceCollectionPrivate * priv;
};

struct _VideoSourceCollectionClass {
	MediaSourceCollectionClass parent_class;
};

struct _VideoSourceCollectionPrivate {
	TransactionController* _transaction_controller;
	GeeMultiMap* filesize_to_video;
};

typedef enum  {
	VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN,
	VIDEO_SOURCE_COLLECTION_STATE_ONLINE,
	VIDEO_SOURCE_COLLECTION_STATE_OFFLINE,
	VIDEO_SOURCE_COLLECTION_STATE_TRASH
} VideoSourceCollectionState;

typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, void* user_data);
typedef gboolean (*SourceHoldingTankCheckToKeep) (DataSource* source, Alteration* alteration, void* user_data);

static gpointer video_import_params_parent_class = NULL;
static gpointer video_reader_parent_class = NULL;
static gpointer video_parent_class = NULL;
static gboolean video_interpreter_state_changed;
static gboolean video_interpreter_state_changed = FALSE;
static gint video_current_state;
static gint video_current_state = 0;
static gboolean video_normal_regen_complete;
static gboolean video_normal_regen_complete = FALSE;
static gboolean video_offline_regen_complete;
static gboolean video_offline_regen_complete = FALSE;
extern VideoSourceCollection* video_global;
VideoSourceCollection* video_global = NULL;
static gpointer video_interpretable_results_parent_class = NULL;
static FlaggableIface * video_flaggable_parent_iface = NULL;
static MonitorableIface * video_monitorable_parent_iface = NULL;
static DateableIface * video_dateable_parent_iface = NULL;
static gpointer video_source_collection_parent_class = NULL;

GQuark video_error_quark (void);
gpointer video_import_params_ref (gpointer instance);
void video_import_params_unref (gpointer instance);
GParamSpec* param_spec_video_import_params (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_video_import_params (GValue* value,
                                    gpointer v_object);
void value_take_video_import_params (GValue* value,
                                     gpointer v_object);
gpointer value_get_video_import_params (const GValue* value);
GType video_import_params_get_type (void) G_GNUC_CONST;
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
gpointer thumbnails_ref (gpointer instance);
void thumbnails_unref (gpointer instance);
GParamSpec* param_spec_thumbnails (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_thumbnails (GValue* value,
                           gpointer v_object);
void value_take_thumbnails (GValue* value,
                            gpointer v_object);
gpointer value_get_thumbnails (const GValue* value);
GType thumbnails_get_type (void) G_GNUC_CONST;
gpointer video_row_ref (gpointer instance);
void video_row_unref (gpointer instance);
GParamSpec* param_spec_video_row (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_video_row (GValue* value,
                          gpointer v_object);
void value_take_video_row (GValue* value,
                           gpointer v_object);
gpointer value_get_video_row (const GValue* value);
GType video_row_get_type (void) G_GNUC_CONST;
#define IMPORT_ID_INVALID ((gint64) 0)
void import_id_init (ImportID *self,
                     gint64 id);
VideoRow* video_row_new (void);
VideoRow* video_row_construct (GType object_type);
VideoImportParams* video_import_params_new (GFile* file,
                                            ImportID* import_id,
                                            const gchar* md5,
                                            Thumbnails* thumbnails,
                                            time_t exposure_time_override);
VideoImportParams* video_import_params_construct (GType object_type,
                                                  GFile* file,
                                                  ImportID* import_id,
                                                  const gchar* md5,
                                                  Thumbnails* thumbnails,
                                                  time_t exposure_time_override);
static void video_import_params_finalize (VideoImportParams * obj);
gpointer video_reader_ref (gpointer instance);
void video_reader_unref (gpointer instance);
GParamSpec* param_spec_video_reader (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
void value_set_video_reader (GValue* value,
                             gpointer v_object);
void value_take_video_reader (GValue* value,
                              gpointer v_object);
gpointer value_get_video_reader (const GValue* value);
GType video_reader_get_type (void) G_GNUC_CONST;
#define VIDEO_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIDEO_READER, VideoReaderPrivate))
#define VIDEO_READER_UNKNOWN_CLIP_DURATION (-1.0)
#define VIDEO_READER_THUMBNAILER_TIMEOUT ((guint) 10000)
VideoReader* video_reader_new (GFile* file);
VideoReader* video_reader_construct (GType object_type,
                                     GFile* file);
gboolean video_reader_is_supported_video_file (GFile* file);
gboolean video_reader_is_supported_video_filename (const gchar* filename);
void disassemble_filename (const gchar* basename,
                           gchar* * name,
                           gchar* * ext);
gint utf8_ci_compare (void* a,
                      void* b);
GType import_result_get_type (void) G_GNUC_CONST;
ImportResult video_reader_prepare_for_import (VideoImportParams* params);
#define UTIL_FILE_ATTRIBUTES "standard::*,time::*,id::file,id::filesystem,etag::value"
#define DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES UTIL_FILE_ATTRIBUTES
GdkPixbuf* video_reader_read_preview_frame (VideoReader* self);
gdouble video_reader_read_clip_duration (VideoReader* self,
                                         GError** error);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_media_metadata (GValue* value,
                               gpointer v_object);
void value_take_media_metadata (GValue* value,
                                gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType video_metadata_get_type (void) G_GNUC_CONST;
VideoMetadata* video_reader_read_metadata (VideoReader* self,
                                           GError** error);
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_metadata_date_time (GValue* value,
                                   gpointer v_object);
void value_take_metadata_date_time (GValue* value,
                                    gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
MetadataDateTime* media_metadata_get_creation_date_time (MediaMetadata* self);
time_t metadata_date_time_get_timestamp (MetadataDateTime* self);
gchar* media_metadata_get_title (MediaMetadata* self);
gchar* media_metadata_get_comment (MediaMetadata* self);
GDateTime* video_reader_get_timestamp (VideoReader* self);
GType video_id_get_type (void) G_GNUC_CONST;
VideoID* video_id_dup (const VideoID* self);
void video_id_free (VideoID* self);
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
GType rating_get_type (void) G_GNUC_CONST;
#define VIDEO_ID_INVALID ((gint64) -1)
void video_id_init (VideoID *self,
                    gint64 id);
#define EVENT_ID_INVALID ((gint64) -1)
void event_id_init (EventID *self,
                    gint64 id);
Thumbnails* thumbnails_new (void);
Thumbnails* thumbnails_construct (GType object_type);
void thumbnail_cache_generate_for_video_frame (Thumbnails* thumbnails,
                                               GdkPixbuf* preview_frame);
static void video_reader_read_internal (VideoReader* self,
                                 GError** error);
static gboolean video_reader_does_file_exist (VideoReader* self);
static GDate* _g_date_dup (GDate* self);
static void video_reader_set_timestamp (VideoReader* self,
                                 GDateTime* value);
static gboolean video_reader_on_thumbnailer_timer (VideoReader* self);
static GdkPixbuf* video_reader_thumbnailer (VideoReader* self,
                                     const gchar* video_file);
GFile* app_dirs_get_thumbnailer_bin (void);
static gboolean _video_reader_on_thumbnailer_timer_gsource_func (gpointer self);
GdkPixbuf* resources_get_noninterpretable_badge_pixbuf (void);
VideoMetadata* video_metadata_new (void);
VideoMetadata* video_metadata_construct (GType object_type);
void media_metadata_read_from_file (MediaMetadata* self,
                                    GFile* file,
                                    GError** error);
static void video_reader_finalize (VideoReader * obj);
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_alteration (GValue* value,
                           gpointer v_object);
void value_take_alteration (GValue* value,
                            gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_source_snapshot (GValue* value,
                                gpointer v_object);
void value_take_source_snapshot (GValue* value,
                                 gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType indexable_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
gpointer backing_file_state_ref (gpointer instance);
void backing_file_state_unref (gpointer instance);
GParamSpec* param_spec_backing_file_state (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_backing_file_state (GValue* value,
                                   gpointer v_object);
void value_take_backing_file_state (GValue* value,
                                    gpointer v_object);
gpointer value_get_backing_file_state (const GValue* value);
GType backing_file_state_get_type (void) G_GNUC_CONST;
GType photo_exception_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
GType video_source_get_type (void) G_GNUC_CONST;
GType flaggable_get_type (void) G_GNUC_CONST;
GType monitorable_get_type (void) G_GNUC_CONST;
GType dateable_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
#define VIDEO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIDEO, VideoPrivate))
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_collection_get_type (void) G_GNUC_CONST;
GType video_source_collection_get_type (void) G_GNUC_CONST;
#define VIDEO_TYPENAME "video"
#define VIDEO_FLAG_TRASH ((guint64) 0x0000000000000001)
#define VIDEO_FLAG_OFFLINE ((guint64) 0x0000000000000002)
#define VIDEO_FLAG_FLAGGED ((guint64) 0x0000000000000004)
Video* video_new (VideoRow* row);
Video* video_construct (GType object_type,
                        VideoRow* row);
VideoSource* video_source_construct (GType object_type);
gchar* media_source_prep_title (const gchar* title);
void data_source_rehydrate_backlinks (DataSource* self,
                                      SourceCollection* unlinked_from,
                                      const gchar* dehydrated);
void video_init (ProgressMonitor monitor,
                 void* monitor_target);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gint configuration_facade_get_video_interpreter_state_cookie (ConfigurationFacade* self);
#define CONFIG_FACADE_NO_VIDEO_INTERPRETER_STATE -1
static gboolean __lambda12_ (GstPluginFeature* f);
static gboolean ___lambda12__gst_plugin_feature_filter (GstPluginFeature* feature,
                                                 gpointer self);
VideoSourceCollection* video_source_collection_new (void);
VideoSourceCollection* video_source_collection_construct (GType object_type);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_database_table (GValue* value,
                               gpointer v_object);
void value_take_database_table (GValue* value,
                                gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType video_table_get_type (void) G_GNUC_CONST;
VideoTable* video_table_get_instance (void);
GeeArrayList* video_table_get_all (VideoTable* self);
static void video_set_is_interpretable (Video* self,
                                 gboolean is_interpretable);
gboolean media_source_is_trashed (MediaSource* self);
gboolean media_source_is_offline (MediaSource* self);
void media_source_collection_add_many_to_trash (MediaSourceCollection* self,
                                                GeeCollection* sources);
void media_source_collection_add_many_to_offline (MediaSourceCollection* self,
                                                  GeeCollection* sources);
GeeCollection* data_collection_add_many (DataCollection* self,
                                         GeeCollection* objects,
                                         ProgressMonitor monitor,
                                         void* monitor_target);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
gboolean video_has_interpreter_state_changed (void);
void video_notify_normal_thumbs_regenerated (void);
static void video_save_interpreter_state (void);
void video_notify_offline_thumbs_regenerated (void);
void configuration_facade_set_video_interpreter_state_cookie (ConfigurationFacade* self,
                                                              gint state_cookie);
void video_terminate (void);
GType exporter_get_type (void) G_GNUC_CONST;
gpointer exporter_ui_ref (gpointer instance);
void exporter_ui_unref (gpointer instance);
GParamSpec* param_spec_exporter_ui (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
void value_set_exporter_ui (GValue* value,
                            gpointer v_object);
void value_take_exporter_ui (GValue* value,
                             gpointer v_object);
gpointer value_get_exporter_ui (const GValue* value);
GType exporter_ui_get_type (void) G_GNUC_CONST;
ExporterUI* video_export_many (GeeCollection* videos,
                               ExporterCompletionCallback done,
                               void* done_target,
                               gboolean export_in_place);
void scaling_for_original (Scaling* result);
GType export_format_parameters_get_type (void) G_GNUC_CONST;
GType export_format_mode_get_type (void) G_GNUC_CONST;
GType jpeg_quality_get_type (void) G_GNUC_CONST;
ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
void export_format_parameters_free (ExportFormatParameters* self);
void export_format_parameters_unmodified (ExportFormatParameters* result);
Exporter* exporter_new_for_temp_file (GeeCollection* to_export,
                                      Scaling* scaling,
                                      ExportFormatParameters* export_params);
Exporter* exporter_construct_for_temp_file (GType object_type,
                                            GeeCollection* to_export,
                                            Scaling* scaling,
                                            ExportFormatParameters* export_params);
ExporterUI* exporter_ui_new (Exporter* exporter);
ExporterUI* exporter_ui_construct (GType object_type,
                                   Exporter* exporter);
void exporter_ui_export (ExporterUI* self,
                         ExporterCompletionCallback completion_callback,
                         void* completion_callback_target);
GFile* export_ui_choose_file (const gchar* current_file_basename);
gchar* media_source_get_basename (MediaSource* self);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
void page_window_set_busy_cursor (PageWindow* self);
void video_export (Video* self,
                   GFile* dest_file,
                   GError** error);
void page_window_set_normal_cursor (PageWindow* self);
GtkResponseType export_error_dialog (GFile* dest,
                                     gboolean photos_remaining);
GFile* export_ui_choose_dir (const gchar* user_title);
Exporter* exporter_new (GeeCollection* to_export,
                        GFile* dir,
                        Scaling* scaling,
                        ExportFormatParameters* export_params,
                        gboolean auto_replace_all);
Exporter* exporter_construct (GType object_type,
                              GeeCollection* to_export,
                              GFile* dir,
                              Scaling* scaling,
                              ExportFormatParameters* export_params,
                              gboolean auto_replace_all);
static void video_real_commit_backlinks (DataSource* base,
                                  SourceCollection* sources,
                                  const gchar* backlinks);
GQuark database_error_quark (void);
void video_table_update_backlinks (VideoTable* self,
                                   VideoID* video_id,
                                   const gchar* backlinks,
                                   GError** error);
void video_get_video_id (Video* self,
                         VideoID* result);
gchar* data_object_to_string (DataObject* self);
static gboolean video_real_set_event_id (MediaSource* base,
                                  EventID* event_id);
gboolean video_table_set_event (VideoTable* self,
                                VideoID* video_id,
                                EventID* event_id);
gboolean video_is_duplicate (GFile* file,
                             const gchar* full_md5);
gboolean video_table_has_duplicate (VideoTable* self,
                                    GFile* file,
                                    const gchar* md5);
ImportResult video_import_create (VideoImportParams* params,
                                  Video* * video);
void video_table_add (VideoTable* self,
                      VideoRow* video_row,
                      VideoID* result,
                      GError** error);
gboolean video_id_is_invalid (VideoID *self);
void video_import_failed (Video* video);
void video_table_remove (VideoTable* self,
                         VideoID* videoID,
                         GError** error);
void app_window_database_error (GError* err);
static BackingFileState** video_real_get_backing_files_state (MediaSource* base,
                                                       int* result_length1);
BackingFileState* backing_file_state_new (const gchar* filepath,
                                          gint64 filesize,
                                          time_t modification_time,
                                          const gchar* md5);
BackingFileState* backing_file_state_construct (GType object_type,
                                                const gchar* filepath,
                                                gint64 filesize,
                                                time_t modification_time,
                                                const gchar* md5);
static GdkPixbuf* video_real_get_thumbnail (ThumbnailSource* base,
                                     gint scale,
                                     GError** error);
GdkPixbuf* thumbnail_cache_fetch (ThumbnailSource* source,
                                  gint scale,
                                  GError** error);
static gchar* video_real_get_master_md5 (MediaSource* base);
static GdkPixbuf* video_real_get_preview_pixbuf (MediaSource* base,
                                          Scaling* scaling,
                                          GError** error);
GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self,
                                           gint scale,
                                           GError** error);
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self,
                                      GdkPixbuf* pixbuf,
                                      GdkInterpType interp,
                                      gboolean scale_up);
static GdkPixbuf* video_real_create_thumbnail (ThumbnailSource* base,
                                        gint scale,
                                        GError** error);
GFile* media_source_get_file (MediaSource* self);
static gchar* video_real_get_typename (DataSource* base);
static gint64 video_real_get_instance_id (DataSource* base);
static void video_real_get_import_id (MediaSource* base,
                               ImportID* result);
static PhotoFileFormat video_real_get_preferred_thumbnail_format (ThumbnailSource* base);
PhotoFileFormat photo_file_format_get_system_default_format (void);
static gchar* video_real_get_title (MediaSource* base);
static void video_real_set_title (MediaSource* base,
                           const gchar* title);
void video_table_set_title (VideoTable* self,
                            VideoID* video_id,
                            const gchar* new_title,
                            GError** error);
void data_object_notify_altered (DataObject* self,
                                 Alteration* alteration);
Alteration* alteration_new (const gchar* subject,
                            const gchar* detail);
Alteration* alteration_construct (GType object_type,
                                  const gchar* subject,
                                  const gchar* detail);
static gchar* video_real_get_comment (MediaSource* base);
static gboolean video_real_set_comment (MediaSource* base,
                                 const gchar* comment);
void video_table_set_comment (VideoTable* self,
                              VideoID* video_id,
                              const gchar* new_comment,
                              GError** error);
static Rating video_real_get_rating (MediaSource* base);
static void video_real_set_rating (MediaSource* base,
                            Rating rating);
gboolean rating_is_valid (Rating self);
void video_table_set_rating (VideoTable* self,
                             VideoID* video_id,
                             Rating rating,
                             GError** error);
static void video_real_increase_rating (MediaSource* base);
void media_source_set_rating (MediaSource* self,
                              Rating rating);
Rating rating_increase (Rating self);
static void video_real_decrease_rating (MediaSource* base);
Rating rating_decrease (Rating self);
static gboolean video_real_is_trashed (MediaSource* base);
gboolean video_is_flag_set (Video* self,
                            guint64 flag);
static gboolean video_real_is_offline (Monitorable* base);
static void video_real_mark_offline (Monitorable* base);
guint64 video_add_flags (Video* self,
                         guint64 flags_to_add,
                         Alteration* additional_alteration);
static void video_real_mark_online (Monitorable* base);
guint64 video_remove_flags (Video* self,
                            guint64 flags_to_remove,
                            Alteration* additional_alteration);
gboolean video_get_is_interpretable (Video* self);
gpointer video_interpretable_results_ref (gpointer instance);
void video_interpretable_results_unref (gpointer instance);
GParamSpec* video_param_spec_interpretable_results (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
void video_value_set_interpretable_results (GValue* value,
                                            gpointer v_object);
void video_value_take_interpretable_results (GValue* value,
                                             gpointer v_object);
gpointer video_value_get_interpretable_results (const GValue* value);
GType video_interpretable_results_get_type (void) G_GNUC_CONST;
VideoInterpretableResults* video_check_is_interpretable (Video* self);
void video_interpretable_results_foreground_finish (VideoInterpretableResults* self);
static void video_real_trash (MediaSource* base);
static void video_real_untrash (MediaSource* base);
static gboolean video_real_is_flagged (Flaggable* base);
static void video_real_mark_flagged (Flaggable* base);
static void video_real_mark_unflagged (Flaggable* base);
static void video_real_get_event_id (MediaSource* base,
                              EventID* result);
static gchar* video_real_to_string (DataObject* base);
static time_t video_real_get_exposure_time (Dateable* base);
static void video_real_set_exposure_time (Dateable* base,
                                   time_t time);
void video_table_set_exposure_time (VideoTable* self,
                                    VideoID* video_id,
                                    time_t time,
                                    GError** error);
void video_get_frame_dimensions (Video* self,
                                 Dimensions* result);
void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
static void video_real_get_dimensions (MediaSource* base,
                                PhotoException disallowed_steps,
                                Dimensions* result);
static guint64 video_real_get_filesize (MediaSource* base);
guint64 media_source_get_master_filesize (MediaSource* self);
static guint64 video_real_get_master_filesize (MediaSource* base);
static time_t video_real_get_timestamp (MediaSource* base);
static void video_real_set_master_timestamp (Monitorable* base,
                                      GFileInfo* info);
void video_table_set_timestamp (VideoTable* self,
                                VideoID* video_id,
                                time_t timestamp,
                                GError** error);
gchar* video_get_filename (Video* self);
static GFile* video_real_get_file (MediaSource* base);
static GFile* video_real_get_master_file (MediaSource* base);
gdouble video_get_clip_duration (Video* self);
void video_table_update_is_interpretable (VideoTable* self,
                                          VideoID* video_id,
                                          gboolean is_interpretable,
                                          GError** error);
VideoInterpretableResults* video_interpretable_results_new (Video* video);
VideoInterpretableResults* video_interpretable_results_construct (GType object_type,
                                                                  Video* video);
static void video_real_destroy (DataSource* base);
void thumbnail_cache_remove (ThumbnailSource* source);
void data_source_destroy (DataSource* self);
static gboolean video_real_internal_delete_backing (DataSource* base,
                                             GError** error);
gboolean media_source_delete_original_file (MediaSource* self);
gboolean data_source_internal_delete_backing (DataSource* self,
                                              GError** error);
static void video_notify_flags_altered (Video* self,
                                 Alteration* additional_alteration);
Alteration* alteration_compress (Alteration* self,
                                 Alteration* other);
guint64 media_source_internal_add_flags (guint64 flags,
                                         guint64 selector);
void video_table_set_flags (VideoTable* self,
                            VideoID* video_id,
                            guint64 flags,
                            GError** error);
guint64 media_source_internal_remove_flags (guint64 flags,
                                            guint64 selector);
gboolean media_source_internal_is_flag_set (guint64 flags,
                                            guint64 selector);
static void video_real_set_master_file (Monitorable* base,
                                 GFile* file);
void video_table_set_filepath (VideoTable* self,
                               VideoID* video_id,
                               const gchar* filepath,
                               GError** error);
void media_source_notify_master_replaced (MediaSource* self,
                                          GFile* old_file,
                                          GFile* new_file);
Alteration* alteration_new_from_list (const gchar* list);
Alteration* alteration_construct_from_list (GType object_type,
                                            const gchar* list);
VideoMetadata* video_read_metadata (Video* self,
                                    GError** error);
void thumbnail_cache_replace (ThumbnailSource* source,
                              ThumbnailCacheSize size,
                              GdkPixbuf* replacement,
                              GError** error);
void thumbnail_source_notify_thumbnail_altered (ThumbnailSource* self);
static void video_interpretable_results_finalize (VideoInterpretableResults * obj);
static void video_finalize (GObject * obj);
GType marker_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_source_backlink (GValue* value,
                                gpointer v_object);
void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType database_source_holding_tank_get_type (void) G_GNUC_CONST;
GType media_source_holding_tank_get_type (void) G_GNUC_CONST;
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_workers (GValue* value,
                        gpointer v_object);
void value_take_workers (GValue* value,
                         gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
GType media_monitor_get_type (void) G_GNUC_CONST;
gpointer transaction_controller_ref (gpointer instance);
void transaction_controller_unref (gpointer instance);
GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
gpointer value_get_transaction_controller (const GValue* value);
GType transaction_controller_get_type (void) G_GNUC_CONST;
#define VIDEO_SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionPrivate))
GType video_source_collection_state_get_type (void) G_GNUC_CONST;
gint uint64_compare (guint64* a,
                     guint64* b);
static gint _uint64_compare_gcompare_data_func (gconstpointer a,
                                         gconstpointer b,
                                         gpointer self);
static guint64* _uint64_dup (guint64* self);
gint64 video_source_collection_get_video_key (DataSource* source);
static gint64 _video_source_collection_get_video_key_get_source_database_key (DataSource* source,
                                                                       gpointer self);
MediaSourceCollection* media_source_collection_construct (GType object_type,
                                                          const gchar* name,
                                                          GetSourceDatabaseKey source_key_func,
                                                          void* source_key_func_target);
MediaSourceHoldingTank* media_source_collection_get_trashcan (MediaSourceCollection* self);
static void video_source_collection_on_trashcan_contents_altered (VideoSourceCollection* self,
                                                           GeeCollection* added,
                                                           GeeCollection* removed);
static void _video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                 GeeCollection* added,
                                                                                                 GeeCollection* removed,
                                                                                                 gpointer self);
MediaSourceHoldingTank* media_source_collection_get_offline_bin (MediaSourceCollection* self);
static void video_source_collection_on_offline_contents_altered (VideoSourceCollection* self,
                                                          GeeCollection* added,
                                                          GeeCollection* removed);
static void _video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                GeeCollection* added,
                                                                                                GeeCollection* removed,
                                                                                                gpointer self);
static MediaSourceHoldingTank* video_source_collection_real_create_trashcan (MediaSourceCollection* base);
gboolean video_source_collection_is_video_trashed (DataSource* source);
static gboolean _video_source_collection_is_video_trashed_source_holding_tank_check_to_keep (DataSource* source,
                                                                                      Alteration* alteration,
                                                                                      gpointer self);
MediaSourceHoldingTank* media_source_holding_tank_new (MediaSourceCollection* sources,
                                                       SourceHoldingTankCheckToKeep check_to_keep,
                                                       void* check_to_keep_target,
                                                       GetSourceDatabaseKey get_key,
                                                       void* get_key_target);
MediaSourceHoldingTank* media_source_holding_tank_construct (GType object_type,
                                                             MediaSourceCollection* sources,
                                                             SourceHoldingTankCheckToKeep check_to_keep,
                                                             void* check_to_keep_target,
                                                             GetSourceDatabaseKey get_key,
                                                             void* get_key_target);
static MediaSourceHoldingTank* video_source_collection_real_create_offline_bin (MediaSourceCollection* base);
gboolean video_source_collection_is_video_offline (DataSource* source);
static gboolean _video_source_collection_is_video_offline_source_holding_tank_check_to_keep (DataSource* source,
                                                                                      Alteration* alteration,
                                                                                      gpointer self);
static MediaMonitor* video_source_collection_real_create_media_monitor (MediaSourceCollection* base,
                                                                 Workers* workers,
                                                                 GCancellable* cancellable);
VideoMonitor* video_monitor_new (GCancellable* cancellable);
VideoMonitor* video_monitor_construct (GType object_type,
                                       GCancellable* cancellable);
GType video_monitor_get_type (void) G_GNUC_CONST;
static gboolean video_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                            DataSource* source);
static gchar* video_source_collection_real_get_typename (MediaSourceCollection* base);
static gboolean video_source_collection_real_is_file_recognized (MediaSourceCollection* base,
                                                          GFile* file);
static MediaSource* video_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base,
                                                               gint64 numeric_id);
Video* video_source_collection_fetch (VideoSourceCollection* self,
                                      VideoID* video_id);
DataSource* database_source_collection_fetch_by_key (DatabaseSourceCollection* self,
                                                     gint64 key);
static GeeCollection* video_source_collection_real_get_event_source_ids (MediaSourceCollection* base,
                                                                  EventID* event_id);
GeeArrayList* video_table_get_event_source_ids (VideoTable* self,
                                                EventID* event_id);
Video* video_source_collection_get_state_by_file (VideoSourceCollection* self,
                                                  GFile* file,
                                                  VideoSourceCollectionState* state);
MediaSource* media_source_collection_fetch_by_master_file (MediaSourceCollection* self,
                                                           GFile* file);
MediaSource* media_source_holding_tank_fetch_by_master_file (MediaSourceHoldingTank* self,
                                                             GFile* file);
static void video_source_collection_compare_backing (VideoSourceCollection* self,
                                              Video* video,
                                              GFileInfo* info,
                                              GeeCollection* matching_master);
guint64 media_source_get_filesize (MediaSource* self);
time_t media_source_get_timestamp (MediaSource* self);
void video_source_collection_fetch_by_matching_backing (VideoSourceCollection* self,
                                                        GFileInfo* info,
                                                        GeeCollection* matching_master);
GeeCollection* data_collection_get_all (DataCollection* self);
GeeCollection* media_source_collection_get_offline_bin_contents (MediaSourceCollection* self);
static void video_source_collection_real_notify_contents_altered (DataCollection* base,
                                                           GeeIterable* added,
                                                           GeeIterable* removed);
void data_collection_notify_contents_altered (DataCollection* self,
                                              GeeIterable* added,
                                              GeeIterable* removed);
void video_source_collection_get_basename_filesize_duplicate (VideoSourceCollection* self,
                                                              const gchar* basename,
                                                              guint64 filesize,
                                                              VideoID* result);
GFile* media_source_get_master_file (MediaSource* self);
gboolean video_source_collection_has_basename_filesize_duplicate (VideoSourceCollection* self,
                                                                  const gchar* basename,
                                                                  guint64 filesize);
gboolean video_id_is_valid (VideoID *self);
MediaSourceTransactionController* media_source_transaction_controller_new (MediaSourceCollection* sources);
MediaSourceTransactionController* media_source_transaction_controller_construct (GType object_type,
                                                                                 MediaSourceCollection* sources);
GType media_source_transaction_controller_get_type (void) G_GNUC_CONST;
static void video_source_collection_finalize (DataCollection * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const gchar* VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS[4] = {"bdm", "bdmv", "cpi", "mpl"};

GQuark
video_error_quark (void)
{
	return g_quark_from_static_string ("video_error-quark");
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? g_object_ref (self) : NULL;
#line 1840 "VideoSupport.c"
}


static gpointer
_thumbnails_ref0 (gpointer self)
{
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? thumbnails_ref (self) : NULL;
#line 1849 "VideoSupport.c"
}


VideoImportParams*
video_import_params_construct (GType object_type,
                               GFile* file,
                               ImportID* import_id,
                               const gchar* md5,
                               Thumbnails* thumbnails,
                               time_t exposure_time_override)
{
	VideoImportParams* self = NULL;
	GFile* _tmp0_;
	ImportID _tmp1_;
	gchar* _tmp2_;
	Thumbnails* _tmp3_;
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (import_id != NULL, NULL);
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail ((thumbnails == NULL) || IS_THUMBNAILS (thumbnails), NULL);
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (VideoImportParams*) g_type_create_instance (object_type);
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = _g_object_ref0 (file);
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->file);
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->file = _tmp0_;
#line 31 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = *import_id;
#line 31 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->import_id = _tmp1_;
#line 32 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_strdup (md5);
#line 32 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (self->md5);
#line 32 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->md5 = _tmp2_;
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _thumbnails_ref0 (thumbnails);
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->thumbnails = _tmp3_;
#line 34 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->exposure_time_override = exposure_time_override;
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 1900 "VideoSupport.c"
}


VideoImportParams*
video_import_params_new (GFile* file,
                         ImportID* import_id,
                         const gchar* md5,
                         Thumbnails* thumbnails,
                         time_t exposure_time_override)
{
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_import_params_construct (TYPE_VIDEO_IMPORT_PARAMS, file, import_id, md5, thumbnails, exposure_time_override);
#line 1913 "VideoSupport.c"
}


static void
value_video_import_params_init (GValue* value)
{
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	value->data[0].v_pointer = NULL;
#line 1922 "VideoSupport.c"
}


static void
value_video_import_params_free_value (GValue* value)
{
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (value->data[0].v_pointer) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_import_params_unref (value->data[0].v_pointer);
#line 1933 "VideoSupport.c"
	}
}


static void
value_video_import_params_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (src_value->data[0].v_pointer) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = video_import_params_ref (src_value->data[0].v_pointer);
#line 1946 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1950 "VideoSupport.c"
	}
}


static gpointer
value_video_import_params_peek_pointer (const GValue* value)
{
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 1960 "VideoSupport.c"
}


static gchar*
value_video_import_params_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (collect_values[0].v_pointer) {
#line 1972 "VideoSupport.c"
		VideoImportParams * object;
		object = collect_values[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (object->parent_instance.g_class == NULL) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1979 "VideoSupport.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1983 "VideoSupport.c"
		}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = video_import_params_ref (object);
#line 1987 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 1991 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 1995 "VideoSupport.c"
}


static gchar*
value_video_import_params_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	VideoImportParams ** object_p;
	object_p = collect_values[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!object_p) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2011 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!value->data[0].v_pointer) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = NULL;
#line 2017 "VideoSupport.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = value->data[0].v_pointer;
#line 2021 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = video_import_params_ref (value->data[0].v_pointer);
#line 2025 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 2029 "VideoSupport.c"
}


GParamSpec*
param_spec_video_import_params (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecVideoImportParams* spec;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIDEO_IMPORT_PARAMS), NULL);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return G_PARAM_SPEC (spec);
#line 2049 "VideoSupport.c"
}


gpointer
value_get_video_import_params (const GValue* value)
{
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_IMPORT_PARAMS), NULL);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 2060 "VideoSupport.c"
}


void
value_set_video_import_params (GValue* value,
                               gpointer v_object)
{
	VideoImportParams * old;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_IMPORT_PARAMS));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_IMPORT_PARAMS));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_import_params_ref (value->data[0].v_pointer);
#line 2083 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 2087 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_import_params_unref (old);
#line 2093 "VideoSupport.c"
	}
}


void
value_take_video_import_params (GValue* value,
                                gpointer v_object)
{
	VideoImportParams * old;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_IMPORT_PARAMS));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_IMPORT_PARAMS));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 2115 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 2119 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_import_params_unref (old);
#line 2125 "VideoSupport.c"
	}
}


static void
video_import_params_class_init (VideoImportParamsClass * klass)
{
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_import_params_parent_class = g_type_class_peek_parent (klass);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((VideoImportParamsClass *) klass)->finalize = video_import_params_finalize;
#line 2137 "VideoSupport.c"
}


static void
video_import_params_instance_init (VideoImportParams * self)
{
	VideoRow* _tmp0_;
#line 18 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	import_id_init (&self->import_id, IMPORT_ID_INVALID);
#line 26 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_row_new ();
#line 26 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->row = _tmp0_;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->ref_count = 1;
#line 2153 "VideoSupport.c"
}


static void
video_import_params_finalize (VideoImportParams * obj)
{
	VideoImportParams * self;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_IMPORT_PARAMS, VideoImportParams);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_handlers_destroy (self);
#line 17 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->file);
#line 19 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (self->md5);
#line 23 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 26 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_row_unref0 (self->row);
#line 2173 "VideoSupport.c"
}


GType
video_import_params_get_type (void)
{
	static volatile gsize video_import_params_type_id__volatile = 0;
	if (g_once_init_enter (&video_import_params_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_video_import_params_init, value_video_import_params_free_value, value_video_import_params_copy_value, value_video_import_params_peek_pointer, "p", value_video_import_params_collect_value, "p", value_video_import_params_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (VideoImportParamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_import_params_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoImportParams), 0, (GInstanceInitFunc) video_import_params_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType video_import_params_type_id;
		video_import_params_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoImportParams", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&video_import_params_type_id__volatile, video_import_params_type_id);
	}
	return video_import_params_type_id__volatile;
}


gpointer
video_import_params_ref (gpointer instance)
{
	VideoImportParams * self;
	self = instance;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_atomic_int_inc (&self->ref_count);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return instance;
#line 2202 "VideoSupport.c"
}


void
video_import_params_unref (gpointer instance)
{
	VideoImportParams * self;
	self = instance;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		VIDEO_IMPORT_PARAMS_GET_CLASS (self)->finalize (self);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2217 "VideoSupport.c"
	}
}


VideoReader*
video_reader_construct (GType object_type,
                        GFile* file)
{
	VideoReader* self = NULL;
	GFile* _tmp0_;
#line 51 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 51 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (VideoReader*) g_type_create_instance (object_type);
#line 52 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = _g_object_ref0 (file);
#line 52 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->file);
#line 52 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->file = _tmp0_;
#line 51 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 2240 "VideoSupport.c"
}


VideoReader*
video_reader_new (GFile* file)
{
#line 51 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_reader_construct (TYPE_VIDEO_READER, file);
#line 2249 "VideoSupport.c"
}


gboolean
video_reader_is_supported_video_file (GFile* file)
{
	gboolean result = FALSE;
	gchar* mime_type = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	guchar* _tmp2_;
	guchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_;
	GError * _inner_error_ = NULL;
#line 55 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = g_file_get_basename (file);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_new0 (guchar, 0);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3__length1 = 0;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = g_content_type_guess (_tmp1_, _tmp3_, (gsize) 0, NULL);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = _tmp4_;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp1_);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	mime_type = _tmp5_;
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = mime_type;
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_strcmp0 (_tmp7_, "audio/ogg") == 0) {
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = g_file_has_uri_scheme (file, "file");
#line 2299 "VideoSupport.c"
	} else {
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = FALSE;
#line 2303 "VideoSupport.c"
	}
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp6_) {
#line 2307 "VideoSupport.c"
		{
			GFileInfo* info = NULL;
			GFileInfo* _tmp8_;
			gchar* content_type = NULL;
			GFileInfo* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_ = FALSE;
			const gchar* _tmp13_;
#line 60 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 60 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			info = _tmp8_;
#line 60 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2323 "VideoSupport.c"
				goto __catch503_g_error;
			}
#line 62 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = info;
#line 62 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = g_file_info_get_content_type (_tmp9_);
#line 62 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 62 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			content_type = _tmp11_;
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp13_ = content_type;
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp13_ != NULL) {
#line 2338 "VideoSupport.c"
				const gchar* _tmp14_;
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = content_type;
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = g_str_has_prefix (_tmp14_, "video/");
#line 2344 "VideoSupport.c"
			} else {
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = FALSE;
#line 2348 "VideoSupport.c"
			}
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp12_) {
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = TRUE;
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (content_type);
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (info);
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (mime_type);
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 2362 "VideoSupport.c"
			}
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (content_type);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (info);
#line 2368 "VideoSupport.c"
		}
		goto __finally503;
		__catch503_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp15_;
			const gchar* _tmp16_;
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_error_ = _inner_error_;
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_inner_error_ = NULL;
#line 67 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_ = _error_;
#line 67 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_ = _tmp15_->message;
#line 67 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_debug ("VideoSupport.vala:67: Failed to query content type: %s", _tmp16_);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_error_free0 (_error_);
#line 2388 "VideoSupport.c"
		}
		__finally503:
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2393 "VideoSupport.c"
			gboolean _tmp17_ = FALSE;
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (mime_type);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return _tmp17_;
#line 2403 "VideoSupport.c"
		}
	}
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp18_ = g_file_get_basename (file);
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = _tmp18_;
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = video_reader_is_supported_video_filename (_tmp19_);
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp19_);
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp20_;
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (mime_type);
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 2420 "VideoSupport.c"
}


gboolean
video_reader_is_supported_video_filename (const gchar* filename)
{
	gboolean result = FALSE;
	gchar* mime_type = NULL;
	guchar* _tmp0_;
	guchar* _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
#line 74 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (filename != NULL, FALSE);
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = g_new0 (guchar, 0);
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1__length1 = 0;
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_content_type_guess (filename, _tmp1_, (gsize) 0, NULL);
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (mime_type);
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	mime_type = _tmp2_;
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = (g_free (_tmp1_), NULL);
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = mime_type;
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_str_has_prefix (_tmp4_, "video/")) {
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = TRUE;
#line 2457 "VideoSupport.c"
	} else {
		const gchar* _tmp5_;
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = mime_type;
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = g_str_has_suffix (_tmp5_, "mp4");
#line 2464 "VideoSupport.c"
	}
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp3_) {
#line 2468 "VideoSupport.c"
		gchar* extension = NULL;
		gchar* name = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_;
#line 79 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		extension = NULL;
#line 80 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		name = NULL;
#line 81 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		disassemble_filename (filename, &_tmp6_, &_tmp7_);
#line 81 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (name);
#line 81 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		name = _tmp6_;
#line 81 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (extension);
#line 81 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		extension = _tmp7_;
#line 83 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = extension;
#line 83 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp8_ == NULL) {
#line 84 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = TRUE;
#line 84 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (name);
#line 84 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (extension);
#line 84 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (mime_type);
#line 84 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 2502 "VideoSupport.c"
		}
		{
			const gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			s_collection = VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS;
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			s_collection_length1 = G_N_ELEMENTS (VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS);
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			for (s_it = 0; s_it < G_N_ELEMENTS (VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS); s_it = s_it + 1) {
#line 2515 "VideoSupport.c"
				gchar* _tmp9_;
				gchar* s = NULL;
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = g_strdup (s_collection[s_it]);
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				s = _tmp9_;
#line 2522 "VideoSupport.c"
				{
					const gchar* _tmp10_;
					const gchar* _tmp11_;
#line 87 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp10_ = s;
#line 87 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp11_ = extension;
#line 87 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (utf8_ci_compare (_tmp10_, _tmp11_) == 0) {
#line 88 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						result = FALSE;
#line 88 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_g_free0 (s);
#line 88 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_g_free0 (name);
#line 88 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_g_free0 (extension);
#line 88 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_g_free0 (mime_type);
#line 88 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						return result;
#line 2544 "VideoSupport.c"
					}
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (s);
#line 2548 "VideoSupport.c"
				}
			}
		}
#line 91 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = TRUE;
#line 91 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (name);
#line 91 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (extension);
#line 91 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (mime_type);
#line 91 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2562 "VideoSupport.c"
	} else {
		const gchar* _tmp12_;
#line 93 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = mime_type;
#line 93 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:93: Skipping %s, unsupported mime type %s", filename, _tmp12_);
#line 94 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = FALSE;
#line 94 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (mime_type);
#line 94 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2575 "VideoSupport.c"
	}
#line 74 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (mime_type);
#line 2579 "VideoSupport.c"
}


ImportResult
video_reader_prepare_for_import (VideoImportParams* params)
{
	ImportResult result = 0;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* info = NULL;
	GFileInfo* _tmp6_;
	GFile* _tmp7_;
	GTimeVal timestamp = {0};
	GFileInfo* _tmp11_;
	GTimeVal _tmp12_ = {0};
	const gchar* _tmp13_;
	time_t exposure_time = 0;
	time_t _tmp14_;
	gchar* title = NULL;
	gchar* _tmp15_;
	gchar* comment = NULL;
	gchar* _tmp16_;
	VideoReader* reader = NULL;
	GFile* _tmp17_;
	VideoReader* _tmp18_;
	gboolean is_interpretable = FALSE;
	gdouble clip_duration = 0.0;
	GdkPixbuf* preview_frame = NULL;
	VideoReader* _tmp19_;
	GdkPixbuf* _tmp20_;
	time_t _tmp45_;
	VideoRow* _tmp51_;
	VideoRow* _tmp52_;
	GFile* _tmp53_;
	gchar* _tmp54_;
	VideoRow* _tmp55_;
	GFileInfo* _tmp56_;
	VideoRow* _tmp57_;
	GTimeVal _tmp58_;
	glong _tmp59_;
	VideoRow* _tmp60_;
	GdkPixbuf* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	VideoRow* _tmp64_;
	GdkPixbuf* _tmp65_;
	gint _tmp66_;
	gint _tmp67_;
	VideoRow* _tmp68_;
	gdouble _tmp69_;
	VideoRow* _tmp70_;
	gboolean _tmp71_;
	VideoRow* _tmp72_;
	time_t _tmp73_;
	VideoRow* _tmp74_;
	ImportID _tmp75_;
	VideoRow* _tmp76_;
	VideoRow* _tmp77_;
	const gchar* _tmp78_;
	gchar* _tmp79_;
	VideoRow* _tmp80_;
	VideoRow* _tmp81_;
	const gchar* _tmp82_;
	gchar* _tmp83_;
	VideoRow* _tmp84_;
	const gchar* _tmp85_;
	gchar* _tmp86_;
	VideoRow* _tmp87_;
	gchar* _tmp88_;
	VideoRow* _tmp89_;
	VideoRow* _tmp90_;
	Thumbnails* _tmp91_;
	GError * _inner_error_ = NULL;
#line 98 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_IMPORT_PARAMS (params), 0);
#line 102 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = params->file;
#line 102 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 102 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	file = _tmp1_;
#line 104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	info = NULL;
#line 2664 "VideoSupport.c"
	{
		GFileInfo* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp5_;
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = file;
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = g_file_query_info (_tmp3_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _tmp4_;
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2678 "VideoSupport.c"
			goto __catch504_g_error;
		}
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = _tmp2_;
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		info = _tmp5_;
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp2_);
#line 2691 "VideoSupport.c"
	}
	goto __finally504;
	__catch504_g_error:
	{
		GError* err = NULL;
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = IMPORT_RESULT_FILE_ERROR;
#line 109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2711 "VideoSupport.c"
	}
	__finally504:
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 2726 "VideoSupport.c"
	}
#line 112 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = info;
#line 112 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_file_info_get_file_type (_tmp6_) != G_FILE_TYPE_REGULAR) {
#line 113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = IMPORT_RESULT_NOT_A_FILE;
#line 113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2740 "VideoSupport.c"
	}
#line 115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = file;
#line 115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!video_reader_is_supported_video_file (_tmp7_)) {
#line 2746 "VideoSupport.c"
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 116 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = file;
#line 116 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = g_file_get_path (_tmp8_);
#line 116 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = _tmp9_;
#line 116 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_message ("Not importing %s: file is marked as a video file but doesn't have a" "supported extension", _tmp10_);
#line 116 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp10_);
#line 119 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
#line 119 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 119 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 119 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2768 "VideoSupport.c"
	}
#line 122 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp11_ = info;
#line 122 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_file_info_get_modification_time (_tmp11_, &_tmp12_);
#line 122 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	timestamp = _tmp12_;
#line 125 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = params->md5;
#line 125 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_assert (_tmp13_ != NULL, "params.md5 != null");
#line 127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp14_ = params->exposure_time_override;
#line 127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	exposure_time = _tmp14_;
#line 128 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp15_ = g_strdup ("");
#line 128 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	title = _tmp15_;
#line 129 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp16_ = g_strdup ("");
#line 129 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	comment = _tmp16_;
#line 131 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp17_ = file;
#line 131 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp18_ = video_reader_new (_tmp17_);
#line 131 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	reader = _tmp18_;
#line 132 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	is_interpretable = TRUE;
#line 133 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	clip_duration = 0.0;
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = reader;
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = video_reader_read_preview_frame (_tmp19_);
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	preview_frame = _tmp20_;
#line 2808 "VideoSupport.c"
	{
		gdouble _tmp21_ = 0.0;
		VideoReader* _tmp22_;
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp22_ = reader;
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp21_ = video_reader_read_clip_duration (_tmp22_, &_inner_error_);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == VIDEO_ERROR) {
#line 2820 "VideoSupport.c"
				goto __catch505_video_error;
			}
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (preview_frame);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_reader_unref0 (reader);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (comment);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (title);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (info);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (file);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return 0;
#line 2841 "VideoSupport.c"
		}
#line 136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		clip_duration = _tmp21_;
#line 2845 "VideoSupport.c"
	}
	goto __finally505;
	__catch505_video_error:
	{
		GError* err = NULL;
		GError* _tmp23_;
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp23_ = err;
#line 138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (g_error_matches (_tmp23_, VIDEO_ERROR, VIDEO_ERROR_FILE)) {
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = IMPORT_RESULT_FILE_ERROR;
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_error_free0 (err);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (preview_frame);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_reader_unref0 (reader);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (comment);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (title);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (info);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (file);
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 2878 "VideoSupport.c"
		} else {
			GError* _tmp24_;
#line 140 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp24_ = err;
#line 140 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (g_error_matches (_tmp24_, VIDEO_ERROR, VIDEO_ERROR_CONTENTS)) {
#line 141 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				is_interpretable = FALSE;
#line 142 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				clip_duration = 0.0;
#line 2889 "VideoSupport.c"
			} else {
#line 144 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_error ("VideoSupport.vala:144: can't prepare video for import: an unknown kind" \
" of video error occurred");
#line 2893 "VideoSupport.c"
			}
		}
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 2898 "VideoSupport.c"
	}
	__finally505:
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (reader);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (comment);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (title);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 2921 "VideoSupport.c"
	}
	{
		VideoMetadata* metadata = NULL;
		VideoReader* _tmp25_;
		VideoMetadata* _tmp26_;
		MetadataDateTime* creation_date_time = NULL;
		VideoMetadata* _tmp27_;
		MetadataDateTime* _tmp28_;
		gboolean _tmp29_ = FALSE;
		MetadataDateTime* _tmp30_;
		gchar* video_title = NULL;
		VideoMetadata* _tmp33_;
		gchar* _tmp34_;
		gchar* video_comment = NULL;
		VideoMetadata* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp40_;
#line 149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp25_ = reader;
#line 149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp26_ = video_reader_read_metadata (_tmp25_, &_inner_error_);
#line 149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		metadata = _tmp26_;
#line 149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2948 "VideoSupport.c"
			goto __catch506_g_error;
		}
#line 150 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp27_ = metadata;
#line 150 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp28_ = media_metadata_get_creation_date_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 150 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		creation_date_time = _tmp28_;
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp30_ = creation_date_time;
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp30_ != NULL) {
#line 2961 "VideoSupport.c"
			MetadataDateTime* _tmp31_;
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp31_ = creation_date_time;
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp29_ = metadata_date_time_get_timestamp (_tmp31_) != ((time_t) 0);
#line 2967 "VideoSupport.c"
		} else {
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp29_ = FALSE;
#line 2971 "VideoSupport.c"
		}
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp29_) {
#line 2975 "VideoSupport.c"
			MetadataDateTime* _tmp32_;
#line 153 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp32_ = creation_date_time;
#line 153 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			exposure_time = metadata_date_time_get_timestamp (_tmp32_);
#line 2981 "VideoSupport.c"
		}
#line 155 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp33_ = metadata;
#line 155 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp34_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 155 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_title = _tmp34_;
#line 156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp35_ = metadata;
#line 156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp36_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_comment = _tmp36_;
#line 157 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp37_ = video_title;
#line 157 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp37_ != NULL) {
#line 2999 "VideoSupport.c"
			const gchar* _tmp38_;
			gchar* _tmp39_;
#line 158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp38_ = video_title;
#line 158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp39_ = g_strdup (_tmp38_);
#line 158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (title);
#line 158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			title = _tmp39_;
#line 3010 "VideoSupport.c"
		}
#line 159 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp40_ = video_comment;
#line 159 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp40_ != NULL) {
#line 3016 "VideoSupport.c"
			const gchar* _tmp41_;
			gchar* _tmp42_;
#line 160 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp41_ = video_comment;
#line 160 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp42_ = g_strdup (_tmp41_);
#line 160 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (comment);
#line 160 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			comment = _tmp42_;
#line 3027 "VideoSupport.c"
		}
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (video_comment);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (video_title);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_metadata_date_time_unref0 (creation_date_time);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_media_metadata_unref0 (metadata);
#line 3037 "VideoSupport.c"
	}
	goto __finally506;
	__catch506_g_error:
	{
		GError* err = NULL;
		GError* _tmp43_;
		const gchar* _tmp44_;
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 162 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp43_ = err;
#line 162 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp44_ = _tmp43_->message;
#line 162 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_warning ("VideoSupport.vala:162: Unable to read video metadata: %s", _tmp44_);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 3057 "VideoSupport.c"
	}
	__finally506:
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (reader);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (comment);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (title);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 3080 "VideoSupport.c"
	}
#line 165 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp45_ = exposure_time;
#line 165 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp45_ == ((time_t) 0)) {
#line 3086 "VideoSupport.c"
		gint64 _tmp46_ = 0LL;
		VideoReader* _tmp47_;
		GDateTime* _tmp48_;
#line 167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp47_ = reader;
#line 167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp48_ = _tmp47_->priv->_timestamp;
#line 167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp48_ != NULL) {
#line 3096 "VideoSupport.c"
			VideoReader* _tmp49_;
			GDateTime* _tmp50_;
#line 168 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp49_ = reader;
#line 168 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp50_ = _tmp49_->priv->_timestamp;
#line 168 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp46_ = g_date_time_to_unix (_tmp50_);
#line 3105 "VideoSupport.c"
		} else {
#line 168 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp46_ = (gint64) 0;
#line 3109 "VideoSupport.c"
		}
#line 167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		exposure_time = (time_t) _tmp46_;
#line 3113 "VideoSupport.c"
	}
#line 171 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp51_ = params->row;
#line 171 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id_init (&_tmp51_->video_id, VIDEO_ID_INVALID);
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp52_ = params->row;
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp53_ = file;
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp54_ = g_file_get_path (_tmp53_);
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp52_->filepath);
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp52_->filepath = _tmp54_;
#line 173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp55_ = params->row;
#line 173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp56_ = info;
#line 173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp55_->filesize = g_file_info_get_size (_tmp56_);
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp57_ = params->row;
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp58_ = timestamp;
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp59_ = _tmp58_.tv_sec;
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp57_->timestamp = (time_t) _tmp59_;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp60_ = params->row;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp61_ = preview_frame;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp62_ = gdk_pixbuf_get_width (_tmp61_);
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp63_ = _tmp62_;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp60_->width = _tmp63_;
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp64_ = params->row;
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp65_ = preview_frame;
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp66_ = gdk_pixbuf_get_height (_tmp65_);
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp67_ = _tmp66_;
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp64_->height = _tmp67_;
#line 177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp68_ = params->row;
#line 177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp69_ = clip_duration;
#line 177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp68_->clip_duration = _tmp69_;
#line 178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp70_ = params->row;
#line 178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp71_ = is_interpretable;
#line 178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp70_->is_interpretable = _tmp71_;
#line 179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp72_ = params->row;
#line 179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp73_ = exposure_time;
#line 179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp72_->exposure_time = _tmp73_;
#line 180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp74_ = params->row;
#line 180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp75_ = params->import_id;
#line 180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp74_->import_id = _tmp75_;
#line 181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp76_ = params->row;
#line 181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	event_id_init (&_tmp76_->event_id, EVENT_ID_INVALID);
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp77_ = params->row;
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp78_ = params->md5;
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp79_ = g_strdup (_tmp78_);
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp77_->md5);
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp77_->md5 = _tmp79_;
#line 183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp80_ = params->row;
#line 183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp80_->time_created = (time_t) 0;
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp81_ = params->row;
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp82_ = title;
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp83_ = g_strdup (_tmp82_);
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp81_->title);
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp81_->title = _tmp83_;
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp84_ = params->row;
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp85_ = comment;
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp86_ = g_strdup (_tmp85_);
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp84_->comment);
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp84_->comment = _tmp86_;
#line 186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp87_ = params->row;
#line 186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp88_ = g_strdup ("");
#line 186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp87_->backlinks);
#line 186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp87_->backlinks = _tmp88_;
#line 187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp89_ = params->row;
#line 187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp89_->time_reimported = (time_t) 0;
#line 188 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp90_ = params->row;
#line 188 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp90_->flags = (guint64) 0;
#line 190 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp91_ = params->thumbnails;
#line 190 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp91_ != NULL) {
#line 3245 "VideoSupport.c"
		Thumbnails* _tmp92_;
		Thumbnails* _tmp93_;
		GdkPixbuf* _tmp94_;
#line 191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp92_ = thumbnails_new ();
#line 191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_thumbnails_unref0 (params->thumbnails);
#line 191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		params->thumbnails = _tmp92_;
#line 192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp93_ = params->thumbnails;
#line 192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp94_ = preview_frame;
#line 192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		thumbnail_cache_generate_for_video_frame (_tmp93_, _tmp94_);
#line 3261 "VideoSupport.c"
	}
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = IMPORT_RESULT_SUCCESS;
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (preview_frame);
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_reader_unref0 (reader);
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (comment);
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (title);
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (info);
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (file);
#line 198 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3279 "VideoSupport.c"
}


static GDate*
_g_date_dup (GDate* self)
{
	GDate* dup;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	dup = g_new0 (GDate, 1);
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	memcpy (dup, self, sizeof (GDate));
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return dup;
#line 3293 "VideoSupport.c"
}


static gpointer
__g_date_dup0 (gpointer self)
{
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? _g_date_dup (self) : NULL;
#line 3302 "VideoSupport.c"
}


static void
video_reader_read_internal (VideoReader* self,
                            GError** error)
{
	GError * _inner_error_ = NULL;
#line 201 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_READER (self));
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!video_reader_does_file_exist (self)) {
#line 3315 "VideoSupport.c"
		GFile* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->file;
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = g_file_get_path (_tmp0_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _tmp1_;
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = g_strdup_printf ("video file '%s' does not exist or is inaccessible", _tmp2_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = _tmp3_;
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = g_error_new_literal (VIDEO_ERROR, VIDEO_ERROR_FILE, _tmp4_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = _tmp5_;
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp4_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp2_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = _tmp6_;
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_inner_error_->domain == VIDEO_ERROR) {
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_propagate_error (error, _inner_error_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 3349 "VideoSupport.c"
		} else {
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 3357 "VideoSupport.c"
		}
	}
	{
		GstDiscoverer* d = NULL;
		GstDiscoverer* _tmp7_;
		GstDiscovererInfo* info = NULL;
		GstDiscoverer* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GstDiscovererInfo* _tmp12_;
		GstDiscovererInfo* _tmp13_;
		GstDiscovererInfo* _tmp14_;
		GDate* video_date = NULL;
		gboolean _tmp15_ = FALSE;
		GstDiscovererInfo* _tmp16_;
		GstTagList* _tmp17_;
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = gst_discoverer_new ((GstClockTime) (GST_SECOND * 5), &_inner_error_);
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		d = _tmp7_;
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3381 "VideoSupport.c"
			goto __catch507_g_error;
		}
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = d;
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = self->priv->file;
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = g_file_get_uri (_tmp9_);
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = _tmp10_;
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = gst_discoverer_discover_uri (_tmp8_, _tmp11_, &_inner_error_);
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp13_ = _tmp12_;
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp11_);
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		info = _tmp13_;
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (d);
#line 3404 "VideoSupport.c"
			goto __catch507_g_error;
		}
#line 210 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_ = info;
#line 210 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		self->priv->clip_duration = ((gdouble) gst_discoverer_info_get_duration (_tmp14_)) / 1000000000.0;
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_date = NULL;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp16_ = info;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp17_ = gst_discoverer_info_get_tags (_tmp16_);
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp17_ != NULL) {
#line 3419 "VideoSupport.c"
			GstDiscovererInfo* _tmp18_;
			GstTagList* _tmp19_;
			GDate _tmp20_ = {0};
			gboolean _tmp21_;
			GDate _tmp22_;
			GDate* _tmp23_;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = info;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp19_ = gst_discoverer_info_get_tags (_tmp18_);
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_ = gst_tag_list_get_date (_tmp19_, GST_TAG_DATE, &_tmp20_);
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (video_date);
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp22_ = _tmp20_;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_ = __g_date_dup0 (&_tmp22_);
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_date = _tmp23_;
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_ = _tmp21_;
#line 3442 "VideoSupport.c"
		} else {
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_ = FALSE;
#line 3446 "VideoSupport.c"
		}
#line 216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp15_) {
#line 3450 "VideoSupport.c"
			GDate* _tmp24_;
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp24_ = video_date;
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp24_ != NULL) {
#line 3456 "VideoSupport.c"
				GDate* _tmp25_;
				GDate* _tmp26_;
				GDate* _tmp27_;
				GDateTime* _tmp28_;
				GDateTime* _tmp29_;
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp25_ = video_date;
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp26_ = video_date;
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp27_ = video_date;
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp28_ = g_date_time_new_local ((gint) g_date_get_year (_tmp25_), (gint) g_date_get_month (_tmp26_), (gint) g_date_get_day (_tmp27_), 0, 0, (gdouble) 0);
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp29_ = _tmp28_;
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_reader_set_timestamp (self, _tmp29_);
#line 219 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_date_time_unref0 (_tmp29_);
#line 3476 "VideoSupport.c"
			}
		}
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (video_date);
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (d);
#line 3485 "VideoSupport.c"
	}
	goto __finally507;
	__catch507_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		GError* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp30_ = e;
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp31_ = _tmp30_->message;
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:224: Video read error: %s", _tmp31_);
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp32_ = e;
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp33_ = _tmp32_->message;
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp34_ = g_strdup_printf ("GStreamer couldn't extract clip information: %s", _tmp33_);
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp35_ = _tmp34_;
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp36_ = g_error_new_literal (VIDEO_ERROR, VIDEO_ERROR_CONTENTS, _tmp35_);
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp37_ = _tmp36_;
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp35_);
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = _tmp37_;
#line 225 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 3527 "VideoSupport.c"
		goto __finally507;
	}
	__finally507:
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_inner_error_->domain == VIDEO_ERROR) {
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_propagate_error (error, _inner_error_);
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 3539 "VideoSupport.c"
		} else {
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 3547 "VideoSupport.c"
		}
	}
}


static gboolean
video_reader_on_thumbnailer_timer (VideoReader* self)
{
	gboolean result = FALSE;
	GPid _tmp0_;
#line 231 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), FALSE);
#line 232 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_debug ("VideoSupport.vala:232: Thumbnailer timer called");
#line 233 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->thumbnailer_pid;
#line 233 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ != ((GPid) 0)) {
#line 3566 "VideoSupport.c"
		GPid _tmp1_;
		GPid _tmp2_;
#line 234 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->priv->thumbnailer_pid;
#line 234 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:234: Killing thumbnailer process: %d", (gint) _tmp1_);
#line 235 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = self->priv->thumbnailer_pid;
#line 235 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		kill ((pid_t) _tmp2_, SIGKILL);
#line 3577 "VideoSupport.c"
	}
#line 237 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = FALSE;
#line 237 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3583 "VideoSupport.c"
}


static gboolean
_video_reader_on_thumbnailer_timer_gsource_func (gpointer self)
{
	gboolean result;
	result = video_reader_on_thumbnailer_timer ((VideoReader*) self);
#line 260 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3594 "VideoSupport.c"
}


static GdkPixbuf*
video_reader_thumbnailer (VideoReader* self,
                          const gchar* video_file)
{
	GdkPixbuf* result = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** argv = NULL;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint argv_length1;
	gint _argv_size_;
	gint child_stdout = 0;
	GdkPixbuf* buf = NULL;
	gint child_status = 0;
	gint ret_waitpid = 0;
	GPid _tmp26_;
	gint _tmp27_ = 0;
	pid_t _tmp28_;
	gint _tmp29_;
	GPid _tmp33_;
	GError * _inner_error_ = NULL;
#line 242 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
#line 242 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (video_file != NULL, NULL);
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = app_dirs_get_thumbnailer_bin ();
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_file_get_path (_tmp1_);
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_debug ("VideoSupport.vala:244: Launching thumbnailer process: %s", _tmp3_);
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp3_);
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp1_);
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = app_dirs_get_thumbnailer_bin ();
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = _tmp4_;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = g_file_get_path (_tmp5_);
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = g_strdup (video_file);
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = g_new0 (gchar*, 2 + 1);
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_[0] = _tmp6_;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_[1] = _tmp7_;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_ = _tmp8_;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9__length1 = 2;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp5_);
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	argv = _tmp9_;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	argv_length1 = _tmp9__length1;
#line 245 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_argv_size_ = argv_length1;
#line 3671 "VideoSupport.c"
	{
		gchar** _tmp10_;
		gint _tmp10__length1;
		GPid _tmp11_ = 0;
		gint _tmp12_ = 0;
		GPid _tmp13_;
#line 248 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = argv;
#line 248 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10__length1 = argv_length1;
#line 248 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_spawn_async_with_pipes (NULL, _tmp10_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp11_, NULL, &_tmp12_, NULL, &_inner_error_);
#line 248 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		self->priv->thumbnailer_pid = _tmp11_;
#line 248 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		child_stdout = _tmp12_;
#line 248 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3690 "VideoSupport.c"
			goto __catch508_g_error;
		}
#line 251 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp13_ = self->priv->thumbnailer_pid;
#line 251 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:251: Spawned thumbnailer, child pid: %d", (gint) _tmp13_);
#line 3697 "VideoSupport.c"
	}
	goto __finally508;
	__catch508_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		GPid _tmp16_;
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 253 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_ = e;
#line 253 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp15_ = _tmp14_->message;
#line 253 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:253: Error spawning process: %s", _tmp15_);
#line 254 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp16_ = self->priv->thumbnailer_pid;
#line 254 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp16_ != ((GPid) 0)) {
#line 3720 "VideoSupport.c"
			GPid _tmp17_;
#line 255 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = self->priv->thumbnailer_pid;
#line 255 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_spawn_close_pid (_tmp17_);
#line 3726 "VideoSupport.c"
		}
#line 256 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 256 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 256 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 256 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 3736 "VideoSupport.c"
	}
	__finally508:
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 3749 "VideoSupport.c"
	}
#line 260 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, VIDEO_READER_THUMBNAILER_TIMEOUT, _video_reader_on_thumbnailer_timer_gsource_func, video_reader_ref (self), video_reader_unref);
#line 263 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	buf = NULL;
#line 3755 "VideoSupport.c"
	{
		GUnixInputStream* unix_input = NULL;
		gint _tmp18_;
		GUnixInputStream* _tmp19_;
		GdkPixbuf* _tmp20_ = NULL;
		GUnixInputStream* _tmp21_;
		GdkPixbuf* _tmp22_;
		GdkPixbuf* _tmp23_;
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp18_ = child_stdout;
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp19_ = (GUnixInputStream*) g_unix_input_stream_new (_tmp18_, TRUE);
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		unix_input = _tmp19_;
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp21_ = unix_input;
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp22_ = gdk_pixbuf_new_from_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp20_ = _tmp22_;
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (unix_input);
#line 3780 "VideoSupport.c"
			goto __catch509_g_error;
		}
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp23_ = _tmp20_;
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp20_ = NULL;
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (buf);
#line 266 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		buf = _tmp23_;
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp20_);
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (unix_input);
#line 3795 "VideoSupport.c"
	}
	goto __finally509;
	__catch509_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 268 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp24_ = e;
#line 268 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp25_ = _tmp24_->message;
#line 268 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:268: Error creating pixbuf: %s", _tmp25_);
#line 269 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (buf);
#line 269 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		buf = NULL;
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 3819 "VideoSupport.c"
	}
	__finally509:
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (buf);
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 3834 "VideoSupport.c"
	}
#line 273 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	child_status = 0;
#line 274 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_ = self->priv->thumbnailer_pid;
#line 274 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp28_ = waitpid ((pid_t) _tmp26_, &_tmp27_, 0);
#line 274 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	child_status = _tmp27_;
#line 274 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	ret_waitpid = (gint) _tmp28_;
#line 275 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp29_ = ret_waitpid;
#line 275 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp29_ < 0) {
#line 3850 "VideoSupport.c"
		gint _tmp30_;
#line 276 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp30_ = ret_waitpid;
#line 276 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:276: waitpid returned error code: %d", _tmp30_);
#line 277 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (buf);
#line 277 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		buf = NULL;
#line 3860 "VideoSupport.c"
	} else {
		gint _tmp31_;
#line 278 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp31_ = child_status;
#line 278 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (0 != WEXITSTATUS (_tmp31_)) {
#line 3867 "VideoSupport.c"
			gint _tmp32_;
#line 279 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp32_ = child_status;
#line 279 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_debug ("VideoSupport.vala:279: Thumbnailer exited with error code: %d", WEXITSTATUS (_tmp32_));
#line 281 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (buf);
#line 281 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			buf = NULL;
#line 3877 "VideoSupport.c"
		}
	}
#line 284 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp33_ = self->priv->thumbnailer_pid;
#line 284 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_spawn_close_pid (_tmp33_);
#line 285 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->thumbnailer_pid = (GPid) 0;
#line 286 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = buf;
#line 286 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 286 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3892 "VideoSupport.c"
}


static gboolean
video_reader_does_file_exist (VideoReader* self)
{
	gboolean result = FALSE;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
#line 289 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), FALSE);
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->file;
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = g_file_test (_tmp2_, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_REGULAR);
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp2_);
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp3_;
#line 290 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3920 "VideoSupport.c"
}


GdkPixbuf*
video_reader_read_preview_frame (VideoReader* self)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
#line 293 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
#line 294 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->preview_frame;
#line 294 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ != NULL) {
#line 3942 "VideoSupport.c"
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
#line 295 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->priv->preview_frame;
#line 295 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 295 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = _tmp2_;
#line 295 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 3953 "VideoSupport.c"
	}
#line 297 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!video_reader_does_file_exist (self)) {
#line 298 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 298 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 3961 "VideoSupport.c"
	}
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = self->priv->file;
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = g_file_get_path (_tmp3_);
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = _tmp4_;
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = video_reader_thumbnailer (self, _tmp5_);
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->preview_frame);
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->preview_frame = _tmp6_;
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp5_);
#line 302 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = self->priv->preview_frame;
#line 302 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (NULL == _tmp7_) {
#line 3981 "VideoSupport.c"
		GdkPixbuf* _tmp8_;
#line 303 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = resources_get_noninterpretable_badge_pixbuf ();
#line 303 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (self->priv->preview_frame);
#line 303 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		self->priv->preview_frame = _tmp8_;
#line 3989 "VideoSupport.c"
	}
#line 305 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_ = self->priv->preview_frame;
#line 305 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 305 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp10_;
#line 305 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3999 "VideoSupport.c"
}


gdouble
video_reader_read_clip_duration (VideoReader* self,
                                 GError** error)
{
	gdouble result = 0.0;
	gdouble _tmp0_;
	gdouble _tmp3_;
	GError * _inner_error_ = NULL;
#line 308 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), 0.0);
#line 309 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->clip_duration;
#line 309 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ == VIDEO_READER_UNKNOWN_CLIP_DURATION) {
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_read_internal (self, &_inner_error_);
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == VIDEO_ERROR) {
#line 4023 "VideoSupport.c"
				gdouble _tmp1_ = 0.0;
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_propagate_error (error, _inner_error_);
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp1_;
#line 4029 "VideoSupport.c"
			} else {
				gdouble _tmp2_ = 0.0;
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 310 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp2_;
#line 4038 "VideoSupport.c"
			}
		}
	}
#line 312 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = self->priv->clip_duration;
#line 312 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp3_;
#line 312 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 4048 "VideoSupport.c"
}


VideoMetadata*
video_reader_read_metadata (VideoReader* self,
                            GError** error)
{
	VideoMetadata* result = NULL;
	VideoMetadata* metadata = NULL;
	VideoMetadata* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError * _inner_error_ = NULL;
#line 315 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_metadata_new ();
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	metadata = _tmp0_;
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = self->priv->file;
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_file_get_path (_tmp1_);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = g_file_new_for_path (_tmp3_);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = _tmp4_;
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (metadata, TYPE_MEDIA_METADATA, MediaMetadata), _tmp5_, &_inner_error_);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp5_);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp3_);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_media_metadata_unref0 (metadata);
#line 317 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 4095 "VideoSupport.c"
	}
#line 319 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = metadata;
#line 319 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 4101 "VideoSupport.c"
}


GDateTime*
video_reader_get_timestamp (VideoReader* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->_timestamp;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 4118 "VideoSupport.c"
}


static gpointer
_g_date_time_ref0 (gpointer self)
{
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? g_date_time_ref (self) : NULL;
#line 4127 "VideoSupport.c"
}


static void
video_reader_set_timestamp (VideoReader* self,
                            GDateTime* value)
{
	GDateTime* _tmp0_;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_READER (self));
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = _g_date_time_ref0 (value);
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_date_time_unref0 (self->priv->_timestamp);
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->_timestamp = _tmp0_;
#line 4144 "VideoSupport.c"
}


static void
value_video_reader_init (GValue* value)
{
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	value->data[0].v_pointer = NULL;
#line 4153 "VideoSupport.c"
}


static void
value_video_reader_free_value (GValue* value)
{
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (value->data[0].v_pointer) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_unref (value->data[0].v_pointer);
#line 4164 "VideoSupport.c"
	}
}


static void
value_video_reader_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (src_value->data[0].v_pointer) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = video_reader_ref (src_value->data[0].v_pointer);
#line 4177 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4181 "VideoSupport.c"
	}
}


static gpointer
value_video_reader_peek_pointer (const GValue* value)
{
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 4191 "VideoSupport.c"
}


static gchar*
value_video_reader_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (collect_values[0].v_pointer) {
#line 4203 "VideoSupport.c"
		VideoReader * object;
		object = collect_values[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (object->parent_instance.g_class == NULL) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4210 "VideoSupport.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4214 "VideoSupport.c"
		}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = video_reader_ref (object);
#line 4218 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 4222 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 4226 "VideoSupport.c"
}


static gchar*
value_video_reader_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	VideoReader ** object_p;
	object_p = collect_values[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!object_p) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4242 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!value->data[0].v_pointer) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = NULL;
#line 4248 "VideoSupport.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = value->data[0].v_pointer;
#line 4252 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = video_reader_ref (value->data[0].v_pointer);
#line 4256 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 4260 "VideoSupport.c"
}


GParamSpec*
param_spec_video_reader (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecVideoReader* spec;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIDEO_READER), NULL);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return G_PARAM_SPEC (spec);
#line 4280 "VideoSupport.c"
}


gpointer
value_get_video_reader (const GValue* value)
{
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER), NULL);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 4291 "VideoSupport.c"
}


void
value_set_video_reader (GValue* value,
                        gpointer v_object)
{
	VideoReader * old;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_READER));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_ref (value->data[0].v_pointer);
#line 4314 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 4318 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_unref (old);
#line 4324 "VideoSupport.c"
	}
}


void
value_take_video_reader (GValue* value,
                         gpointer v_object)
{
	VideoReader * old;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_READER));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 4346 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 4350 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_unref (old);
#line 4356 "VideoSupport.c"
	}
}


static void
video_reader_class_init (VideoReaderClass * klass)
{
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_reader_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((VideoReaderClass *) klass)->finalize = video_reader_finalize;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_type_class_add_private (klass, sizeof (VideoReaderPrivate));
#line 4370 "VideoSupport.c"
}


static void
video_reader_instance_init (VideoReader * self)
{
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv = VIDEO_READER_GET_PRIVATE (self);
#line 45 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->clip_duration = VIDEO_READER_UNKNOWN_CLIP_DURATION;
#line 46 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->preview_frame = NULL;
#line 47 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->file = NULL;
#line 48 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->thumbnailer_pid = (GPid) 0;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->_timestamp = NULL;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->ref_count = 1;
#line 4391 "VideoSupport.c"
}


static void
video_reader_finalize (VideoReader * obj)
{
	VideoReader * self;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_READER, VideoReader);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_handlers_destroy (self);
#line 46 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->preview_frame);
#line 47 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->file);
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_date_time_unref0 (self->priv->_timestamp);
#line 4409 "VideoSupport.c"
}


GType
video_reader_get_type (void)
{
	static volatile gsize video_reader_type_id__volatile = 0;
	if (g_once_init_enter (&video_reader_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_video_reader_init, value_video_reader_free_value, value_video_reader_copy_value, value_video_reader_peek_pointer, "p", value_video_reader_collect_value, "p", value_video_reader_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (VideoReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoReader), 0, (GInstanceInitFunc) video_reader_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType video_reader_type_id;
		video_reader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoReader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&video_reader_type_id__volatile, video_reader_type_id);
	}
	return video_reader_type_id__volatile;
}


gpointer
video_reader_ref (gpointer instance)
{
	VideoReader * self;
	self = instance;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_atomic_int_inc (&self->ref_count);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return instance;
#line 4438 "VideoSupport.c"
}


void
video_reader_unref (gpointer instance)
{
	VideoReader * self;
	self = instance;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		VIDEO_READER_GET_CLASS (self)->finalize (self);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4453 "VideoSupport.c"
	}
}


static gpointer
_video_row_ref0 (gpointer self)
{
#line 367 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? video_row_ref (self) : NULL;
#line 4463 "VideoSupport.c"
}


Video*
video_construct (GType object_type,
                 VideoRow* row)
{
	Video * self = NULL;
	VideoRow* _tmp0_;
	VideoRow* _tmp1_;
	VideoRow* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	guint64 _tmp6_;
#line 366 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_ROW (row), NULL);
#line 366 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (Video*) video_source_construct (object_type);
#line 367 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = _video_row_ref0 (row);
#line 367 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_row_unref0 (self->priv->backing_row);
#line 367 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->backing_row = _tmp0_;
#line 370 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = self->priv->backing_row;
#line 370 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = self->priv->backing_row;
#line 370 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_->title;
#line 370 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = media_source_prep_title (_tmp3_);
#line 370 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp1_->title);
#line 370 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_->title = _tmp4_;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = row->flags;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if ((_tmp6_ & VIDEO_FLAG_TRASH) != ((guint64) 0)) {
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = TRUE;
#line 4507 "VideoSupport.c"
	} else {
		guint64 _tmp7_;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = row->flags;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = (_tmp7_ & VIDEO_FLAG_OFFLINE) != ((guint64) 0);
#line 4514 "VideoSupport.c"
	}
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp5_) {
#line 4518 "VideoSupport.c"
		VideoSourceCollection* _tmp8_;
		const gchar* _tmp9_;
#line 373 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = video_global;
#line 373 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = row->backlinks;
#line 373 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		data_source_rehydrate_backlinks (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp9_);
#line 4527 "VideoSupport.c"
	}
#line 366 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 4531 "VideoSupport.c"
}


Video*
video_new (VideoRow* row)
{
#line 366 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_construct (TYPE_VIDEO, row);
#line 4540 "VideoSupport.c"
}


static gboolean
__lambda12_ (GstPluginFeature* f)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
#line 407 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (GST_IS_PLUGIN_FEATURE (f), FALSE);
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = gst_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (f, gst_object_get_type (), GstObject));
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_str_has_prefix (_tmp1_, "vaapi");
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp1_);
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp2_;
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 4565 "VideoSupport.c"
}


static gboolean
___lambda12__gst_plugin_feature_filter (GstPluginFeature* feature,
                                        gpointer self)
{
	gboolean result;
	result = __lambda12_ (feature);
#line 407 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 4577 "VideoSupport.c"
}


static void
_g_object_unref0_ (gpointer var)
{
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 4586 "VideoSupport.c"
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 4595 "VideoSupport.c"
}


void
video_init (ProgressMonitor monitor,
            void* monitor_target)
{
	gchar** args = NULL;
	gint args_length1;
	gint _args_size_;
	GstRegistry* registry = NULL;
	GstRegistry* _tmp0_;
	GstRegistry* _tmp1_;
	gint saved_state = 0;
	ConfigFacade* _tmp2_;
	ConfigFacade* _tmp3_;
	gint _tmp4_;
	GstRegistry* _tmp5_;
	gint _tmp6_;
	GList* features = NULL;
	GstRegistry* _tmp9_;
	GList* _tmp10_;
	GList* _tmp11_;
	VideoSourceCollection* _tmp18_;
	GeeArrayList* all = NULL;
	VideoTable* _tmp19_;
	VideoTable* _tmp20_;
	GeeArrayList* _tmp21_;
	GeeArrayList* _tmp22_;
	GeeArrayList* all_videos = NULL;
	GeeArrayList* _tmp23_;
	GeeArrayList* trashed_videos = NULL;
	GeeArrayList* _tmp24_;
	GeeArrayList* offline_videos = NULL;
	GeeArrayList* _tmp25_;
	gint count = 0;
	GeeArrayList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	VideoSourceCollection* _tmp51_;
	GeeArrayList* _tmp52_;
	VideoSourceCollection* _tmp53_;
	GeeArrayList* _tmp54_;
	VideoSourceCollection* _tmp55_;
	GeeArrayList* _tmp56_;
	GeeCollection* _tmp57_;
	GeeCollection* _tmp58_;
#line 380 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_interpreter_state_changed = FALSE;
#line 381 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_current_state = -1;
#line 382 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_normal_regen_complete = FALSE;
#line 383 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_offline_regen_complete = FALSE;
#line 387 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	args = NULL;
#line 387 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	args_length1 = 0;
#line 387 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_args_size_ = args_length1;
#line 388 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	gst_init (&args_length1, &args);
#line 390 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = gst_registry_get ();
#line 390 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 390 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	registry = _tmp1_;
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = config_facade_get_instance ();
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = configuration_facade_get_video_interpreter_state_cookie (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp3_);
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	saved_state = _tmp4_;
#line 392 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = registry;
#line 392 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_current_state = (gint) gst_registry_get_feature_list_cookie (_tmp5_);
#line 393 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = saved_state;
#line 393 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp6_ == CONFIG_FACADE_NO_VIDEO_INTERPRETER_STATE) {
#line 394 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_message ("VideoSupport.vala:394: interpreter state cookie not found; assuming al" \
"l video thumbnails are out of date");
#line 395 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpreter_state_changed = TRUE;
#line 4687 "VideoSupport.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 396 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = saved_state;
#line 396 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = video_current_state;
#line 396 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp7_ != _tmp8_) {
#line 397 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_message ("VideoSupport.vala:397: interpreter state has changed; video thumbnails" \
" may be out of date");
#line 398 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_interpreter_state_changed = TRUE;
#line 4701 "VideoSupport.c"
		}
	}
#line 407 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_ = registry;
#line 407 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = gst_registry_feature_filter (_tmp9_, ___lambda12__gst_plugin_feature_filter, FALSE, NULL);
#line 407 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	features = _tmp10_;
#line 411 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp11_ = features;
#line 4712 "VideoSupport.c"
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
#line 411 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		feature_collection = _tmp11_;
#line 411 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
#line 4720 "VideoSupport.c"
			GstPluginFeature* _tmp12_;
			GstPluginFeature* feature = NULL;
#line 411 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = _g_object_ref0 ((GstPluginFeature*) feature_it->data);
#line 411 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			feature = _tmp12_;
#line 4727 "VideoSupport.c"
			{
				GstPluginFeature* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				GstRegistry* _tmp16_;
				GstPluginFeature* _tmp17_;
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = feature;
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = gst_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gst_object_get_type (), GstObject));
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_ = _tmp14_;
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_debug ("VideoSupport.vala:412: Removing registry feature %s", _tmp15_);
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (_tmp15_);
#line 413 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = registry;
#line 413 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = feature;
#line 413 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				gst_registry_remove_feature (_tmp16_, _tmp17_);
#line 411 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (feature);
#line 4752 "VideoSupport.c"
			}
		}
	}
#line 416 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp18_ = video_source_collection_new ();
#line 416 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_data_collection_unref0 (video_global);
#line 416 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_global = _tmp18_;
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = video_table_get_instance ();
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = _tmp19_;
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp21_ = video_table_get_all (_tmp20_);
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp22_ = _tmp21_;
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_database_table_unref0 (_tmp20_);
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	all = _tmp22_;
#line 419 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 419 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	all_videos = _tmp23_;
#line 420 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 420 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	trashed_videos = _tmp24_;
#line 421 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 421 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	offline_videos = _tmp25_;
#line 422 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_ = all;
#line 422 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 422 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp28_ = _tmp27_;
#line 422 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	count = _tmp28_;
#line 4794 "VideoSupport.c"
	{
		gint ctr = 0;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		ctr = 0;
#line 4799 "VideoSupport.c"
		{
			gboolean _tmp29_ = FALSE;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp29_ = TRUE;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			while (TRUE) {
#line 4806 "VideoSupport.c"
				gint _tmp31_;
				gint _tmp32_;
				Video* video = NULL;
				GeeArrayList* _tmp33_;
				gint _tmp34_;
				gpointer _tmp35_;
				VideoRow* _tmp36_;
				Video* _tmp37_;
				Video* _tmp38_;
				gboolean _tmp39_;
				Video* _tmp41_;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!_tmp29_) {
#line 4820 "VideoSupport.c"
					gint _tmp30_;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp30_ = ctr;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					ctr = _tmp30_ + 1;
#line 4826 "VideoSupport.c"
				}
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp29_ = FALSE;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp31_ = ctr;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp32_ = count;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!(_tmp31_ < _tmp32_)) {
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					break;
#line 4838 "VideoSupport.c"
				}
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp33_ = all;
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp34_ = ctr;
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp35_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp34_);
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp36_ = (VideoRow*) _tmp35_;
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp37_ = video_new (_tmp36_);
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp38_ = _tmp37_;
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_video_row_unref0 (_tmp36_);
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video = _tmp38_;
#line 426 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp39_ = video_interpreter_state_changed;
#line 426 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_tmp39_) {
#line 4860 "VideoSupport.c"
					Video* _tmp40_;
#line 427 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp40_ = video;
#line 427 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					video_set_is_interpretable (_tmp40_, FALSE);
#line 4866 "VideoSupport.c"
				}
#line 429 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp41_ = video;
#line 429 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (media_source_is_trashed (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_MEDIA_SOURCE, MediaSource))) {
#line 4872 "VideoSupport.c"
					GeeArrayList* _tmp42_;
					Video* _tmp43_;
#line 430 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp42_ = trashed_videos;
#line 430 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp43_ = video;
#line 430 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp43_);
#line 4881 "VideoSupport.c"
				} else {
					Video* _tmp44_;
#line 431 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp44_ = video;
#line 431 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (media_source_is_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_MEDIA_SOURCE, MediaSource))) {
#line 4888 "VideoSupport.c"
						GeeArrayList* _tmp45_;
						Video* _tmp46_;
#line 432 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp45_ = offline_videos;
#line 432 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp46_ = video;
#line 432 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp46_);
#line 4897 "VideoSupport.c"
					} else {
						GeeArrayList* _tmp47_;
						Video* _tmp48_;
#line 434 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp47_ = all_videos;
#line 434 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp48_ = video;
#line 434 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp48_);
#line 4907 "VideoSupport.c"
					}
				}
#line 436 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (monitor != NULL) {
#line 4912 "VideoSupport.c"
					gint _tmp49_;
					gint _tmp50_;
#line 437 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp49_ = ctr;
#line 437 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp50_ = count;
#line 437 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					monitor ((guint64) _tmp49_, (guint64) _tmp50_, TRUE, monitor_target);
#line 4921 "VideoSupport.c"
				}
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 4925 "VideoSupport.c"
			}
		}
	}
#line 440 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp51_ = video_global;
#line 440 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp52_ = trashed_videos;
#line 440 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	media_source_collection_add_many_to_trash (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEE_TYPE_COLLECTION, GeeCollection));
#line 441 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp53_ = video_global;
#line 441 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp54_ = offline_videos;
#line 441 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	media_source_collection_add_many_to_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, GEE_TYPE_COLLECTION, GeeCollection));
#line 442 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp55_ = video_global;
#line 442 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp56_ = all_videos;
#line 442 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp57_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
#line 442 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp58_ = _tmp57_;
#line 442 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp58_);
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (offline_videos);
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (trashed_videos);
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (all_videos);
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (all);
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	__g_list_free__g_object_unref0_0 (features);
#line 376 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (registry);
#line 4963 "VideoSupport.c"
}


gboolean
video_has_interpreter_state_changed (void)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 446 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_interpreter_state_changed;
#line 446 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 446 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 4978 "VideoSupport.c"
}


void
video_notify_normal_thumbs_regenerated (void)
{
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
#line 450 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_normal_regen_complete;
#line 450 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 451 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 4994 "VideoSupport.c"
	}
#line 453 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_message ("VideoSupport.vala:453: normal video thumbnail regeneration completed");
#line 455 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_normal_regen_complete = TRUE;
#line 456 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video_normal_regen_complete;
#line 456 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp2_) {
#line 5004 "VideoSupport.c"
		gboolean _tmp3_;
#line 456 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_offline_regen_complete;
#line 456 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp3_;
#line 5010 "VideoSupport.c"
	} else {
#line 456 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = FALSE;
#line 5014 "VideoSupport.c"
	}
#line 456 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_) {
#line 457 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_save_interpreter_state ();
#line 5020 "VideoSupport.c"
	}
}


void
video_notify_offline_thumbs_regenerated (void)
{
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
#line 461 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_offline_regen_complete;
#line 461 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 462 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 5037 "VideoSupport.c"
	}
#line 464 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_message ("VideoSupport.vala:464: offline video thumbnail regeneration completed");
#line 466 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_offline_regen_complete = TRUE;
#line 467 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video_normal_regen_complete;
#line 467 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp2_) {
#line 5047 "VideoSupport.c"
		gboolean _tmp3_;
#line 467 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_offline_regen_complete;
#line 467 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp3_;
#line 5053 "VideoSupport.c"
	} else {
#line 467 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = FALSE;
#line 5057 "VideoSupport.c"
	}
#line 467 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_) {
#line 468 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_save_interpreter_state ();
#line 5063 "VideoSupport.c"
	}
}


static void
video_save_interpreter_state (void)
{
	gboolean _tmp0_;
#line 472 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_interpreter_state_changed;
#line 472 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 5076 "VideoSupport.c"
		ConfigFacade* _tmp1_;
		ConfigFacade* _tmp2_;
		gint _tmp3_;
#line 473 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_message ("VideoSupport.vala:473: saving video interpreter state to configuration" \
" system");
#line 475 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = config_facade_get_instance ();
#line 475 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _tmp1_;
#line 475 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_current_state;
#line 475 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		configuration_facade_set_video_interpreter_state_cookie (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp3_);
#line 475 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp2_);
#line 476 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpreter_state_changed = FALSE;
#line 5094 "VideoSupport.c"
	}
}


void
video_terminate (void)
{
}


ExporterUI*
video_export_many (GeeCollection* videos,
                   ExporterCompletionCallback done,
                   void* done_target,
                   gboolean export_in_place)
{
	ExporterUI* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp9_;
	gint _tmp10_;
	GFile* export_dir = NULL;
	GFile* _tmp32_;
	GFile* _tmp33_;
	ExporterUI* exporter = NULL;
	GFile* _tmp34_;
	Scaling _tmp35_ = {0};
	ExportFormatParameters _tmp36_ = {0};
	Exporter* _tmp37_;
	Exporter* _tmp38_;
	ExporterUI* _tmp39_;
	ExporterUI* _tmp40_;
	ExporterUI* _tmp41_;
	GError * _inner_error_ = NULL;
#line 483 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (videos), NULL);
#line 485 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = gee_collection_get_size (videos);
#line 485 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 485 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_ == 0) {
#line 486 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 486 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 5141 "VideoSupport.c"
	}
#line 489 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (export_in_place) {
#line 5145 "VideoSupport.c"
		ExporterUI* temp_exporter = NULL;
		Scaling _tmp2_ = {0};
		ExportFormatParameters _tmp3_ = {0};
		Exporter* _tmp4_;
		Exporter* _tmp5_;
		ExporterUI* _tmp6_;
		ExporterUI* _tmp7_;
		ExporterUI* _tmp8_;
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		scaling_for_original (&_tmp2_);
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		export_format_parameters_unmodified (&_tmp3_);
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = exporter_new_for_temp_file (videos, &_tmp2_, &_tmp3_);
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = _tmp4_;
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = exporter_ui_new (_tmp5_);
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = _tmp6_;
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp5_);
#line 490 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		temp_exporter = _tmp7_;
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = temp_exporter;
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		exporter_ui_export (_tmp8_, done, done_target);
#line 493 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = temp_exporter;
#line 493 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 5178 "VideoSupport.c"
	}
#line 497 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_ = gee_collection_get_size (videos);
#line 497 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = _tmp9_;
#line 497 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp10_ == 1) {
#line 5186 "VideoSupport.c"
		Video* video = NULL;
		GFile* save_as = NULL;
		Video* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
		GFile* _tmp22_;
#line 498 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video = NULL;
#line 5197 "VideoSupport.c"
		{
			GeeIterator* _v_it = NULL;
			GeeIterator* _tmp11_;
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (videos, GEE_TYPE_ITERABLE, GeeIterable));
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_v_it = _tmp11_;
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			while (TRUE) {
#line 5207 "VideoSupport.c"
				GeeIterator* _tmp12_;
				Video* v = NULL;
				GeeIterator* _tmp13_;
				gpointer _tmp14_;
				Video* _tmp15_;
				Video* _tmp16_;
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = _v_it;
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!gee_iterator_next (_tmp12_)) {
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					break;
#line 5220 "VideoSupport.c"
				}
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = _v_it;
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = gee_iterator_get (_tmp13_);
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				v = (Video*) _tmp14_;
#line 500 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_ = v;
#line 500 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = _g_object_ref0 (_tmp15_);
#line 500 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 500 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video = _tmp16_;
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (v);
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				break;
#line 5240 "VideoSupport.c"
			}
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_v_it);
#line 5244 "VideoSupport.c"
		}
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp17_ = video;
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp18_ = media_source_get_basename (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MEDIA_SOURCE, MediaSource));
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp19_ = _tmp18_;
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp20_ = export_ui_choose_file (_tmp19_);
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp21_ = _tmp20_;
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp19_);
#line 504 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		save_as = _tmp21_;
#line 505 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp22_ = save_as;
#line 505 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp22_ == NULL) {
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = NULL;
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (save_as);
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (video);
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 5272 "VideoSupport.c"
		}
		{
			AppWindow* _tmp23_;
			AppWindow* _tmp24_;
			Video* _tmp25_;
			GFile* _tmp26_;
			AppWindow* _tmp27_;
			AppWindow* _tmp28_;
#line 509 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_ = app_window_get_instance ();
#line 509 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp24_ = _tmp23_;
#line 509 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_PAGE_WINDOW, PageWindow));
#line 509 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_tmp24_);
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp25_ = video;
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp26_ = save_as;
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_export (_tmp25_, _tmp26_, &_inner_error_);
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5297 "VideoSupport.c"
				goto __catch510_g_error;
			}
#line 511 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp27_ = app_window_get_instance ();
#line 511 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp28_ = _tmp27_;
#line 511 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_PAGE_WINDOW, PageWindow));
#line 511 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_tmp28_);
#line 5308 "VideoSupport.c"
		}
		goto __finally510;
		__catch510_g_error:
		{
			GError* err = NULL;
			AppWindow* _tmp29_;
			AppWindow* _tmp30_;
			GFile* _tmp31_;
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			err = _inner_error_;
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_inner_error_ = NULL;
#line 513 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp29_ = app_window_get_instance ();
#line 513 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp30_ = _tmp29_;
#line 513 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_PAGE_WINDOW, PageWindow));
#line 513 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_tmp30_);
#line 514 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp31_ = save_as;
#line 514 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			export_error_dialog (_tmp31_, FALSE);
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_error_free0 (err);
#line 5335 "VideoSupport.c"
		}
		__finally510:
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (save_as);
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (video);
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return NULL;
#line 5350 "VideoSupport.c"
		}
#line 517 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 517 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (save_as);
#line 517 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (video);
#line 517 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 5360 "VideoSupport.c"
	}
#line 521 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp32_ = export_ui_choose_dir (_ ("Export Videos"));
#line 521 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	export_dir = _tmp32_;
#line 522 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp33_ = export_dir;
#line 522 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp33_ == NULL) {
#line 523 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 523 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (export_dir);
#line 523 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 5376 "VideoSupport.c"
	}
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp34_ = export_dir;
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	scaling_for_original (&_tmp35_);
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	export_format_parameters_unmodified (&_tmp36_);
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp37_ = exporter_new (videos, _tmp34_, &_tmp35_, &_tmp36_, FALSE);
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp38_ = _tmp37_;
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp39_ = exporter_ui_new (_tmp38_);
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp40_ = _tmp39_;
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp38_);
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	exporter = _tmp40_;
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp41_ = exporter;
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	exporter_ui_export (_tmp41_, done, done_target);
#line 529 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = exporter;
#line 529 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (export_dir);
#line 529 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5406 "VideoSupport.c"
}


static void
video_real_commit_backlinks (DataSource* base,
                             SourceCollection* sources,
                             const gchar* backlinks)
{
	Video * self;
	GError * _inner_error_ = NULL;
#line 532 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 532 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((sources == NULL) || IS_SOURCE_COLLECTION (sources));
#line 5421 "VideoSupport.c"
	{
		VideoTable* _tmp0_;
		VideoTable* _tmp1_;
		VideoID _tmp2_ = {0};
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = video_table_get_instance ();
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp0_;
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_get_video_id (self, &_tmp2_);
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_update_backlinks (_tmp1_, &_tmp2_, backlinks, &_inner_error_);
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp1_);
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5440 "VideoSupport.c"
				goto __catch511_database_error;
			}
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 5449 "VideoSupport.c"
		}
		{
			VideoRow* _tmp3_;
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 5457 "VideoSupport.c"
			{
				VideoRow* _tmp4_;
				gchar* _tmp5_;
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = self->priv->backing_row;
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = g_strdup (backlinks);
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (_tmp4_->backlinks);
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_->backlinks = _tmp5_;
#line 5469 "VideoSupport.c"
			}
			__finally512:
			{
				VideoRow* _tmp6_;
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = self->priv->backing_row;
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5478 "VideoSupport.c"
			}
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 5484 "VideoSupport.c"
					goto __catch511_database_error;
				}
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 5493 "VideoSupport.c"
			}
		}
	}
	goto __finally511;
	__catch511_database_error:
	{
		GError* err = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 539 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 539 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = _tmp7_;
#line 539 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = err;
#line 539 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = _tmp9_->message;
#line 539 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_warning ("VideoSupport.vala:539: Unable to update link state for %s: %s", _tmp8_, _tmp10_);
#line 539 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp8_);
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 5523 "VideoSupport.c"
	}
	__finally511:
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 533 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 5534 "VideoSupport.c"
	}
}


static gboolean
video_real_set_event_id (MediaSource* base,
                         EventID* event_id)
{
	Video * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 543 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 543 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 5550 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		gboolean _tmp12_ = FALSE;
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 5558 "VideoSupport.c"
		{
			gboolean committed = FALSE;
			VideoTable* _tmp1_;
			VideoTable* _tmp2_;
			VideoRow* _tmp3_;
			VideoID _tmp4_;
			EventID _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = video_table_get_instance ();
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_;
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _tmp3_->video_id;
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = *event_id;
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = video_table_set_event (_tmp2_, &_tmp4_, &_tmp5_);
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_database_table_unref0 (_tmp2_);
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			committed = _tmp6_;
#line 547 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = committed;
#line 547 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp7_) {
#line 5588 "VideoSupport.c"
				VideoRow* _tmp8_;
				EventID _tmp9_;
#line 548 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = self->priv->backing_row;
#line 548 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = *event_id;
#line 548 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_->event_id = _tmp9_;
#line 5597 "VideoSupport.c"
			}
#line 550 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = committed;
#line 5601 "VideoSupport.c"
			{
				VideoRow* _tmp10_;
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = self->priv->backing_row;
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5608 "VideoSupport.c"
			}
#line 550 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 5612 "VideoSupport.c"
		}
		__finally513:
		{
			VideoRow* _tmp11_;
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = self->priv->backing_row;
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5621 "VideoSupport.c"
		}
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 544 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp12_;
#line 5629 "VideoSupport.c"
	}
}


gboolean
video_is_duplicate (GFile* file,
                    const gchar* full_md5)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	VideoTable* _tmp1_;
	VideoTable* _tmp2_;
	gboolean _tmp3_;
#line 554 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), FALSE);
#line 555 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (file != NULL) {
#line 555 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = TRUE;
#line 5649 "VideoSupport.c"
	} else {
#line 555 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = full_md5 != NULL;
#line 5653 "VideoSupport.c"
	}
#line 555 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_assert (_tmp0_, "file != null || full_md5 != null");
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = video_table_get_instance ();
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_table_has_duplicate (_tmp2_, file, full_md5);
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_database_table_unref0 (_tmp2_);
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp3_;
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5669 "VideoSupport.c"
}


ImportResult
video_import_create (VideoImportParams* params,
                     Video* * video)
{
	Video* _vala_video = NULL;
	ImportResult result = 0;
	VideoRow* _tmp6_;
	Video* _tmp7_;
	GError * _inner_error_ = NULL;
#line 563 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_IMPORT_PARAMS (params), 0);
#line 564 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_vala_video);
#line 564 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_video = NULL;
#line 5688 "VideoSupport.c"
	{
		VideoID _tmp0_ = {0};
		VideoTable* _tmp1_;
		VideoTable* _tmp2_;
		VideoRow* _tmp3_;
		VideoID _tmp4_ = {0};
		VideoID _tmp5_;
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = video_table_get_instance ();
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _tmp1_;
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = params->row;
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_add (_tmp2_, _tmp3_, &_tmp4_, &_inner_error_);
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = _tmp4_;
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp2_);
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = _tmp5_;
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5714 "VideoSupport.c"
				goto __catch514_database_error;
			}
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return 0;
#line 5723 "VideoSupport.c"
		}
#line 568 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (video_id_is_invalid (&_tmp0_)) {
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = IMPORT_RESULT_DATABASE_ERROR;
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (video) {
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				*video = _vala_video;
#line 5733 "VideoSupport.c"
			} else {
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (_vala_video);
#line 5737 "VideoSupport.c"
			}
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 5741 "VideoSupport.c"
		}
	}
	goto __finally514;
	__catch514_database_error:
	{
		GError* err = NULL;
#line 567 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 567 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = IMPORT_RESULT_DATABASE_ERROR;
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (video) {
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*video = _vala_video;
#line 5760 "VideoSupport.c"
		} else {
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_vala_video);
#line 5764 "VideoSupport.c"
		}
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 5768 "VideoSupport.c"
	}
	__finally514:
#line 567 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 567 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 567 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 567 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 5779 "VideoSupport.c"
	}
#line 575 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = params->row;
#line 575 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = video_new (_tmp6_);
#line 575 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_vala_video);
#line 575 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_video = _tmp7_;
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = IMPORT_RESULT_SUCCESS;
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (video) {
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*video = _vala_video;
#line 5795 "VideoSupport.c"
	} else {
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_vala_video);
#line 5799 "VideoSupport.c"
	}
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5803 "VideoSupport.c"
}


void
video_import_failed (Video* video)
{
	GError * _inner_error_ = NULL;
#line 580 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (video));
#line 5813 "VideoSupport.c"
	{
		VideoTable* _tmp0_;
		VideoTable* _tmp1_;
		VideoID _tmp2_ = {0};
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = video_table_get_instance ();
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp0_;
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_get_video_id (video, &_tmp2_);
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_remove (_tmp1_, &_tmp2_, &_inner_error_);
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp1_);
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5832 "VideoSupport.c"
				goto __catch515_database_error;
			}
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 5841 "VideoSupport.c"
		}
	}
	goto __finally515;
	__catch515_database_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = err;
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		app_window_database_error (_tmp3_);
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 5859 "VideoSupport.c"
	}
	__finally515:
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 581 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 5870 "VideoSupport.c"
	}
}


static BackingFileState**
video_real_get_backing_files_state (MediaSource* base,
                                    int* result_length1)
{
	Video * self;
	BackingFileState** result = NULL;
	BackingFileState** backing = NULL;
	BackingFileState** _tmp0_;
	gint backing_length1;
	gint _backing_size_;
	BackingFileState** _tmp13_;
	gint _tmp13__length1;
	GError * _inner_error_ = NULL;
#line 588 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 589 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = g_new0 (BackingFileState*, 1 + 1);
#line 589 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	backing = _tmp0_;
#line 589 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	backing_length1 = 1;
#line 589 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_backing_size_ = backing_length1;
#line 5898 "VideoSupport.c"
	{
		VideoRow* _tmp1_;
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->priv->backing_row;
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 5905 "VideoSupport.c"
		{
			VideoRow* _tmp2_;
			const gchar* _tmp3_;
			VideoRow* _tmp4_;
			gint64 _tmp5_;
			VideoRow* _tmp6_;
			time_t _tmp7_;
			VideoRow* _tmp8_;
			const gchar* _tmp9_;
			BackingFileState* _tmp10_;
			BackingFileState* _tmp11_;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = self->priv->backing_row;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = _tmp2_->filepath;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = _tmp4_->filesize;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = self->priv->backing_row;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = _tmp6_->timestamp;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = self->priv->backing_row;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = _tmp8_->md5;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = backing_file_state_new (_tmp3_, _tmp5_, _tmp7_, _tmp9_);
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_backing_file_state_unref0 (backing[0]);
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			backing[0] = _tmp10_;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = backing[0];
#line 5941 "VideoSupport.c"
		}
		__finally516:
		{
			VideoRow* _tmp12_;
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = self->priv->backing_row;
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5950 "VideoSupport.c"
		}
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			backing = (_vala_array_free (backing, backing_length1, (GDestroyNotify) backing_file_state_unref), NULL);
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return NULL;
#line 5962 "VideoSupport.c"
		}
	}
#line 595 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = backing;
#line 595 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13__length1 = backing_length1;
#line 595 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (result_length1) {
#line 595 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*result_length1 = _tmp13__length1;
#line 5973 "VideoSupport.c"
	}
#line 595 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp13_;
#line 595 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5979 "VideoSupport.c"
}


static GdkPixbuf*
video_real_get_thumbnail (ThumbnailSource* base,
                          gint scale,
                          GError** error)
{
	Video * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GError * _inner_error_ = NULL;
#line 598 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = thumbnail_cache_fetch (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), scale, &_inner_error_);
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = _tmp1_;
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 6006 "VideoSupport.c"
	}
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp0_;
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = NULL;
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp2_;
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp0_);
#line 599 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6018 "VideoSupport.c"
}


static gchar*
video_real_get_master_md5 (MediaSource* base)
{
	Video * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 602 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6030 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6037 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 604 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 604 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->md5;
#line 604 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 604 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp3_;
#line 6050 "VideoSupport.c"
			{
				VideoRow* _tmp4_;
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = self->priv->backing_row;
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6057 "VideoSupport.c"
			}
#line 604 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 6061 "VideoSupport.c"
		}
		__finally517:
		{
			VideoRow* _tmp5_;
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6070 "VideoSupport.c"
		}
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 603 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 6078 "VideoSupport.c"
	}
}


static GdkPixbuf*
video_real_get_preview_pixbuf (MediaSource* base,
                               Scaling* scaling,
                               GError** error)
{
	Video * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GError * _inner_error_ = NULL;
#line 608 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 608 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 609 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = thumbnail_source_get_thumbnail (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), (gint) THUMBNAIL_CACHE_SIZE_BIG, &_inner_error_);
#line 609 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	pixbuf = _tmp0_;
#line 609 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 609 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 609 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 6108 "VideoSupport.c"
	}
#line 611 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = scaling_perform_on_pixbuf (scaling, pixbuf, GDK_INTERP_NEAREST, TRUE);
#line 611 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 611 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (pixbuf);
#line 611 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6118 "VideoSupport.c"
}


static GdkPixbuf*
video_real_create_thumbnail (ThumbnailSource* base,
                             gint scale,
                             GError** error)
{
	Video * self;
	GdkPixbuf* result = NULL;
	VideoReader* reader = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	VideoReader* _tmp2_;
	VideoReader* _tmp3_;
	GdkPixbuf* frame = NULL;
	VideoReader* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_;
#line 614 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 615 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 615 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 615 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video_reader_new (_tmp1_);
#line 615 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 615 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp1_);
#line 615 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	reader = _tmp3_;
#line 616 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = reader;
#line 616 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = video_reader_read_preview_frame (_tmp4_);
#line 616 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	frame = _tmp5_;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = frame;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp7_ != NULL) {
#line 6163 "VideoSupport.c"
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = frame;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp6_);
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = _tmp9_;
#line 6174 "VideoSupport.c"
	} else {
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = resources_get_noninterpretable_badge_pixbuf ();
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = _tmp10_;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = gdk_pixbuf_copy (_tmp11_);
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp6_);
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = _tmp12_;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp11_);
#line 6191 "VideoSupport.c"
	}
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp6_;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (frame);
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_reader_unref0 (reader);
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6201 "VideoSupport.c"
}


static gchar*
video_real_get_typename (DataSource* base)
{
	Video * self;
	gchar* result = NULL;
	gchar* _tmp0_;
#line 621 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 622 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = g_strdup (VIDEO_TYPENAME);
#line 622 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 622 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6219 "VideoSupport.c"
}


static gint64
video_real_get_instance_id (DataSource* base)
{
	Video * self;
	gint64 result = 0LL;
	VideoID _tmp0_ = {0};
	gint64 _tmp1_;
#line 625 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 626 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_get_video_id (self, &_tmp0_);
#line 626 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_.id;
#line 626 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 626 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6240 "VideoSupport.c"
}


static void
video_real_get_import_id (MediaSource* base,
                          ImportID* result)
{
	Video * self;
	GError * _inner_error_ = NULL;
#line 629 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6252 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6259 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			ImportID _tmp2_;
#line 631 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 631 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->import_id;
#line 631 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*result = _tmp2_;
#line 6269 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6276 "VideoSupport.c"
			}
#line 631 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 6280 "VideoSupport.c"
		}
		__finally518:
		{
			VideoRow* _tmp4_;
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6289 "VideoSupport.c"
		}
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 630 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 6297 "VideoSupport.c"
	}
}


static PhotoFileFormat
video_real_get_preferred_thumbnail_format (ThumbnailSource* base)
{
	Video * self;
	PhotoFileFormat result = 0;
#line 635 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 636 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = photo_file_format_get_system_default_format ();
#line 636 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6313 "VideoSupport.c"
}


static gchar*
video_real_get_title (MediaSource* base)
{
	Video * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 639 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6325 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6332 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 641 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 641 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->title;
#line 641 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 641 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp3_;
#line 6345 "VideoSupport.c"
			{
				VideoRow* _tmp4_;
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = self->priv->backing_row;
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6352 "VideoSupport.c"
			}
#line 641 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 6356 "VideoSupport.c"
		}
		__finally519:
		{
			VideoRow* _tmp5_;
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6365 "VideoSupport.c"
		}
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 640 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 6373 "VideoSupport.c"
	}
}


static void
video_real_set_title (MediaSource* base,
                      const gchar* title)
{
	Video * self;
	gchar* new_title = NULL;
	gchar* _tmp0_;
	Alteration* _tmp19_;
	Alteration* _tmp20_;
	GError * _inner_error_ = NULL;
#line 645 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 646 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_prep_title (title);
#line 646 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	new_title = _tmp0_;
#line 6394 "VideoSupport.c"
	{
		VideoRow* _tmp1_;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->priv->backing_row;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6401 "VideoSupport.c"
		{
			VideoRow* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			VideoRow* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
#line 649 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = self->priv->backing_row;
#line 649 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = _tmp2_->title;
#line 649 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = new_title;
#line 649 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
#line 6417 "VideoSupport.c"
				{
					VideoRow* _tmp5_;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp5_ = self->priv->backing_row;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6424 "VideoSupport.c"
				}
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_title);
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6430 "VideoSupport.c"
			}
			{
				VideoTable* _tmp6_;
				VideoTable* _tmp7_;
				VideoRow* _tmp8_;
				VideoID _tmp9_;
				const gchar* _tmp10_;
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = video_table_get_instance ();
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = _tmp6_;
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = self->priv->backing_row;
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = _tmp8_->video_id;
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = new_title;
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_title (_tmp7_, &_tmp9_, _tmp10_, &_inner_error_);
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp7_);
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 6456 "VideoSupport.c"
						goto __catch521_database_error;
					}
					{
						VideoRow* _tmp11_;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp11_ = self->priv->backing_row;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6465 "VideoSupport.c"
					}
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (new_title);
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 653 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return;
#line 6475 "VideoSupport.c"
				}
			}
			goto __finally521;
			__catch521_database_error:
			{
				GError* e = NULL;
				GError* _tmp12_;
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = e;
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp12_);
#line 656 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 6493 "VideoSupport.c"
				{
					VideoRow* _tmp13_;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp13_ = self->priv->backing_row;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6500 "VideoSupport.c"
				}
#line 656 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_title);
#line 656 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6506 "VideoSupport.c"
			}
			__finally521:
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6511 "VideoSupport.c"
				{
					VideoRow* _tmp14_;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp14_ = self->priv->backing_row;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6518 "VideoSupport.c"
				}
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_title);
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6528 "VideoSupport.c"
			}
#line 660 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_ = self->priv->backing_row;
#line 660 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_ = new_title;
#line 660 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = g_strdup (_tmp16_);
#line 660 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (_tmp15_->title);
#line 660 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_->title = _tmp17_;
#line 6540 "VideoSupport.c"
		}
		__finally520:
		{
			VideoRow* _tmp18_;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = self->priv->backing_row;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6549 "VideoSupport.c"
		}
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (new_title);
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 6561 "VideoSupport.c"
		}
	}
#line 663 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = alteration_new ("metadata", "name");
#line 663 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = _tmp19_;
#line 663 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp20_);
#line 663 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp20_);
#line 645 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (new_title);
#line 6574 "VideoSupport.c"
}


static gchar*
video_real_get_comment (MediaSource* base)
{
	Video * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 666 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6586 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6593 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 668 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 668 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->comment;
#line 668 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 668 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp3_;
#line 6606 "VideoSupport.c"
			{
				VideoRow* _tmp4_;
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = self->priv->backing_row;
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6613 "VideoSupport.c"
			}
#line 668 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 6617 "VideoSupport.c"
		}
		__finally522:
		{
			VideoRow* _tmp5_;
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6626 "VideoSupport.c"
		}
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 667 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 6634 "VideoSupport.c"
	}
}


static gboolean
video_real_set_comment (MediaSource* base,
                        const gchar* comment)
{
	Video * self;
	gboolean result = FALSE;
	gchar* new_comment = NULL;
	gchar* _tmp0_;
	Alteration* _tmp22_;
	Alteration* _tmp23_;
	GError * _inner_error_ = NULL;
#line 672 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 673 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_prep_title (comment);
#line 673 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	new_comment = _tmp0_;
#line 6656 "VideoSupport.c"
	{
		VideoRow* _tmp1_;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->priv->backing_row;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6663 "VideoSupport.c"
		{
			VideoRow* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			VideoRow* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
#line 676 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = self->priv->backing_row;
#line 676 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = _tmp2_->comment;
#line 676 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = new_comment;
#line 676 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = TRUE;
#line 6681 "VideoSupport.c"
				{
					VideoRow* _tmp5_;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp5_ = self->priv->backing_row;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6688 "VideoSupport.c"
				}
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_comment);
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 6694 "VideoSupport.c"
			}
			{
				VideoTable* _tmp6_;
				VideoTable* _tmp7_;
				VideoRow* _tmp8_;
				VideoID _tmp9_;
				const gchar* _tmp10_;
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = video_table_get_instance ();
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = _tmp6_;
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = self->priv->backing_row;
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = _tmp8_->video_id;
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = new_comment;
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_comment (_tmp7_, &_tmp9_, _tmp10_, &_inner_error_);
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp7_);
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6718 "VideoSupport.c"
					gboolean _tmp12_ = FALSE;
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 6722 "VideoSupport.c"
						goto __catch524_database_error;
					}
					{
						VideoRow* _tmp11_;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp11_ = self->priv->backing_row;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6731 "VideoSupport.c"
					}
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (new_comment);
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 680 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return _tmp12_;
#line 6741 "VideoSupport.c"
				}
			}
			goto __finally524;
			__catch524_database_error:
			{
				GError* e = NULL;
				GError* _tmp13_;
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = e;
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp13_);
#line 683 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = FALSE;
#line 683 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 6761 "VideoSupport.c"
				{
					VideoRow* _tmp14_;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp14_ = self->priv->backing_row;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6768 "VideoSupport.c"
				}
#line 683 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_comment);
#line 683 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 6774 "VideoSupport.c"
			}
			__finally524:
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6779 "VideoSupport.c"
				gboolean _tmp16_ = FALSE;
				{
					VideoRow* _tmp15_;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp15_ = self->priv->backing_row;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6787 "VideoSupport.c"
				}
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_comment);
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp16_;
#line 6797 "VideoSupport.c"
			}
#line 687 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = self->priv->backing_row;
#line 687 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = new_comment;
#line 687 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp19_ = g_strdup (_tmp18_);
#line 687 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (_tmp17_->comment);
#line 687 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_->comment = _tmp19_;
#line 6809 "VideoSupport.c"
		}
		__finally523:
		{
			VideoRow* _tmp20_;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp20_ = self->priv->backing_row;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6818 "VideoSupport.c"
		}
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6822 "VideoSupport.c"
			gboolean _tmp21_ = FALSE;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (new_comment);
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return _tmp21_;
#line 6832 "VideoSupport.c"
		}
	}
#line 690 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp22_ = alteration_new ("metadata", "comment");
#line 690 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = _tmp22_;
#line 690 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp23_);
#line 690 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp23_);
#line 692 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = TRUE;
#line 692 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (new_comment);
#line 692 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6849 "VideoSupport.c"
}


static Rating
video_real_get_rating (MediaSource* base)
{
	Video * self;
	Rating result = 0;
	GError * _inner_error_ = NULL;
#line 696 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6861 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6868 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			Rating _tmp2_;
#line 698 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 698 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->rating;
#line 698 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 6878 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6885 "VideoSupport.c"
			}
#line 698 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 6889 "VideoSupport.c"
		}
		__finally525:
		{
			VideoRow* _tmp4_;
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6898 "VideoSupport.c"
		}
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 697 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 6906 "VideoSupport.c"
	}
}


static void
video_real_set_rating (MediaSource* base,
                       Rating rating)
{
	Video * self;
	Alteration* _tmp14_;
	Alteration* _tmp15_;
	GError * _inner_error_ = NULL;
#line 702 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6921 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6928 "VideoSupport.c"
		{
			gboolean _tmp1_ = FALSE;
			VideoRow* _tmp12_;
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (!rating_is_valid (rating)) {
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp1_ = TRUE;
#line 6936 "VideoSupport.c"
			} else {
				VideoRow* _tmp2_;
				Rating _tmp3_;
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp2_ = self->priv->backing_row;
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = _tmp2_->rating;
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp1_ = rating == _tmp3_;
#line 6946 "VideoSupport.c"
			}
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp1_) {
#line 6950 "VideoSupport.c"
				{
					VideoRow* _tmp4_;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp4_ = self->priv->backing_row;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6957 "VideoSupport.c"
				}
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6961 "VideoSupport.c"
			}
			{
				VideoTable* _tmp5_;
				VideoTable* _tmp6_;
				VideoID _tmp7_ = {0};
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = video_table_get_instance ();
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = _tmp5_;
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_get_video_id (self, &_tmp7_);
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_rating (_tmp6_, &_tmp7_, rating, &_inner_error_);
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp6_);
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 6981 "VideoSupport.c"
						goto __catch527_database_error;
					}
					{
						VideoRow* _tmp8_;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp8_ = self->priv->backing_row;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6990 "VideoSupport.c"
					}
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 708 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return;
#line 6998 "VideoSupport.c"
				}
			}
			goto __finally527;
			__catch527_database_error:
			{
				GError* e = NULL;
				GError* _tmp9_;
#line 707 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 707 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = e;
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp9_);
#line 711 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 7016 "VideoSupport.c"
				{
					VideoRow* _tmp10_;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp10_ = self->priv->backing_row;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7023 "VideoSupport.c"
				}
#line 711 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 7027 "VideoSupport.c"
			}
			__finally527:
#line 707 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7032 "VideoSupport.c"
				{
					VideoRow* _tmp11_;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp11_ = self->priv->backing_row;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7039 "VideoSupport.c"
				}
#line 707 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 707 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 707 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 7047 "VideoSupport.c"
			}
#line 715 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = self->priv->backing_row;
#line 715 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_->rating = rating;
#line 7053 "VideoSupport.c"
		}
		__finally526:
		{
			VideoRow* _tmp13_;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp13_ = self->priv->backing_row;
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7062 "VideoSupport.c"
		}
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 703 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7072 "VideoSupport.c"
		}
	}
#line 718 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp14_ = alteration_new ("metadata", "rating");
#line 718 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp15_ = _tmp14_;
#line 718 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp15_);
#line 718 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp15_);
#line 7083 "VideoSupport.c"
}


static void
video_real_increase_rating (MediaSource* base)
{
	Video * self;
	GError * _inner_error_ = NULL;
#line 721 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7094 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7101 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			Rating _tmp2_;
#line 723 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 723 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->rating;
#line 723 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), rating_increase (_tmp2_));
#line 7111 "VideoSupport.c"
		}
		__finally528:
		{
			VideoRow* _tmp3_;
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7120 "VideoSupport.c"
		}
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 722 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7130 "VideoSupport.c"
		}
	}
}


static void
video_real_decrease_rating (MediaSource* base)
{
	Video * self;
	GError * _inner_error_ = NULL;
#line 727 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7143 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7150 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			Rating _tmp2_;
#line 729 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 729 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->rating;
#line 729 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), rating_decrease (_tmp2_));
#line 7160 "VideoSupport.c"
		}
		__finally529:
		{
			VideoRow* _tmp3_;
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7169 "VideoSupport.c"
		}
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 728 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7179 "VideoSupport.c"
		}
	}
}


static gboolean
video_real_is_trashed (MediaSource* base)
{
	Video * self;
	gboolean result = FALSE;
#line 733 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 734 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = video_is_flag_set (self, VIDEO_FLAG_TRASH);
#line 734 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 7196 "VideoSupport.c"
}


static gboolean
video_real_is_offline (Monitorable* base)
{
	Video * self;
	gboolean result = FALSE;
#line 737 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 738 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = video_is_flag_set (self, VIDEO_FLAG_OFFLINE);
#line 738 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 7211 "VideoSupport.c"
}


static void
video_real_mark_offline (Monitorable* base)
{
	Video * self;
#line 741 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 742 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_add_flags (self, VIDEO_FLAG_OFFLINE, NULL);
#line 7223 "VideoSupport.c"
}


static void
video_real_mark_online (Monitorable* base)
{
	Video * self;
	gboolean _tmp0_ = FALSE;
#line 745 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 746 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_remove_flags (self, VIDEO_FLAG_OFFLINE, NULL);
#line 748 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!video_get_is_interpretable (self)) {
#line 748 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = video_has_interpreter_state_changed ();
#line 7240 "VideoSupport.c"
	} else {
#line 748 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = FALSE;
#line 7244 "VideoSupport.c"
	}
#line 748 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 7248 "VideoSupport.c"
		VideoInterpretableResults* _tmp1_;
		VideoInterpretableResults* _tmp2_;
#line 749 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = video_check_is_interpretable (self);
#line 749 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _tmp1_;
#line 749 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_foreground_finish (_tmp2_);
#line 749 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_interpretable_results_unref0 (_tmp2_);
#line 7259 "VideoSupport.c"
	}
}


static void
video_real_trash (MediaSource* base)
{
	Video * self;
#line 752 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 753 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_add_flags (self, VIDEO_FLAG_TRASH, NULL);
#line 7272 "VideoSupport.c"
}


static void
video_real_untrash (MediaSource* base)
{
	Video * self;
#line 756 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 757 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_remove_flags (self, VIDEO_FLAG_TRASH, NULL);
#line 7284 "VideoSupport.c"
}


static gboolean
video_real_is_flagged (Flaggable* base)
{
	Video * self;
	gboolean result = FALSE;
#line 760 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 761 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = video_is_flag_set (self, VIDEO_FLAG_FLAGGED);
#line 761 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 7299 "VideoSupport.c"
}


static void
video_real_mark_flagged (Flaggable* base)
{
	Video * self;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
#line 764 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 765 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = alteration_new ("metadata", "flagged");
#line 765 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 765 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_add_flags (self, VIDEO_FLAG_FLAGGED, _tmp1_);
#line 765 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp1_);
#line 7319 "VideoSupport.c"
}


static void
video_real_mark_unflagged (Flaggable* base)
{
	Video * self;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
#line 768 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 769 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = alteration_new ("metadata", "flagged");
#line 769 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 769 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_remove_flags (self, VIDEO_FLAG_FLAGGED, _tmp1_);
#line 769 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp1_);
#line 7339 "VideoSupport.c"
}


static void
video_real_get_event_id (MediaSource* base,
                         EventID* result)
{
	Video * self;
	GError * _inner_error_ = NULL;
#line 772 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7351 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7358 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			EventID _tmp2_;
#line 774 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 774 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->event_id;
#line 774 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*result = _tmp2_;
#line 7368 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7375 "VideoSupport.c"
			}
#line 774 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7379 "VideoSupport.c"
		}
		__finally530:
		{
			VideoRow* _tmp4_;
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7388 "VideoSupport.c"
		}
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 773 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7396 "VideoSupport.c"
	}
}


static gchar*
video_real_to_string (DataObject* base)
{
	Video * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 778 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7409 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7416 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			VideoID _tmp2_;
			gint64 _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			VideoRow* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->video_id;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = _tmp2_.id;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = _tmp4_;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = self->priv->backing_row;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = _tmp6_->filepath;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = g_strdup_printf ("[%s] %s", _tmp5_, _tmp7_);
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = _tmp8_;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (_tmp5_);
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp9_;
#line 7449 "VideoSupport.c"
			{
				VideoRow* _tmp10_;
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = self->priv->backing_row;
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7456 "VideoSupport.c"
			}
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7460 "VideoSupport.c"
		}
		__finally531:
		{
			VideoRow* _tmp11_;
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = self->priv->backing_row;
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7469 "VideoSupport.c"
		}
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 779 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 7477 "VideoSupport.c"
	}
}


void
video_get_video_id (Video* self,
                    VideoID* result)
{
	GError * _inner_error_ = NULL;
#line 784 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 7489 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7496 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			VideoID _tmp2_;
#line 786 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 786 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->video_id;
#line 786 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*result = _tmp2_;
#line 7506 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7513 "VideoSupport.c"
			}
#line 786 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7517 "VideoSupport.c"
		}
		__finally532:
		{
			VideoRow* _tmp4_;
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7526 "VideoSupport.c"
		}
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 785 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7534 "VideoSupport.c"
	}
}


static time_t
video_real_get_exposure_time (Dateable* base)
{
	Video * self;
	time_t result = 0;
	GError * _inner_error_ = NULL;
#line 790 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7547 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		time_t _tmp5_ = 0;
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7555 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			time_t _tmp2_;
#line 792 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 792 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->exposure_time;
#line 792 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 7565 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7572 "VideoSupport.c"
			}
#line 792 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7576 "VideoSupport.c"
		}
		__finally533:
		{
			VideoRow* _tmp4_;
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7585 "VideoSupport.c"
		}
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 791 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 7593 "VideoSupport.c"
	}
}


static void
video_real_set_exposure_time (Dateable* base,
                              time_t time)
{
	Video * self;
	Alteration* _tmp10_;
	Alteration* _tmp11_;
	GError * _inner_error_ = NULL;
#line 796 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7608 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7615 "VideoSupport.c"
		{
			VideoRow* _tmp8_;
			{
				VideoTable* _tmp1_;
				VideoTable* _tmp2_;
				VideoRow* _tmp3_;
				VideoID _tmp4_;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp1_ = video_table_get_instance ();
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp2_ = _tmp1_;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = _tmp3_->video_id;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_exposure_time (_tmp2_, &_tmp4_, time, &_inner_error_);
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp2_);
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7637 "VideoSupport.c"
					goto __catch535_g_error;
				}
			}
			goto __finally535;
			__catch535_g_error:
			{
				GError* e = NULL;
				GError* _tmp5_;
				const gchar* _tmp6_;
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = e;
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = _tmp5_->message;
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_debug ("VideoSupport.vala:801: Warning - %s", _tmp6_);
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 7659 "VideoSupport.c"
			}
			__finally535:
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7664 "VideoSupport.c"
				{
					VideoRow* _tmp7_;
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp7_ = self->priv->backing_row;
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7671 "VideoSupport.c"
				}
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 7679 "VideoSupport.c"
			}
#line 803 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = self->priv->backing_row;
#line 803 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_->exposure_time = time;
#line 7685 "VideoSupport.c"
		}
		__finally534:
		{
			VideoRow* _tmp9_;
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = self->priv->backing_row;
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7694 "VideoSupport.c"
		}
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 797 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7704 "VideoSupport.c"
		}
	}
#line 806 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = alteration_new ("metadata", "exposure-time");
#line 806 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp11_ = _tmp10_;
#line 806 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp11_);
#line 806 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp11_);
#line 7715 "VideoSupport.c"
}


void
video_get_frame_dimensions (Video* self,
                            Dimensions* result)
{
	GError * _inner_error_ = NULL;
#line 809 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 7726 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7733 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			gint _tmp2_;
			VideoRow* _tmp3_;
			gint _tmp4_;
			Dimensions _tmp5_ = {0};
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->width;
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _tmp3_->height;
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			dimensions_init (&_tmp5_, _tmp2_, _tmp4_);
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*result = _tmp5_;
#line 7752 "VideoSupport.c"
			{
				VideoRow* _tmp6_;
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = self->priv->backing_row;
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7759 "VideoSupport.c"
			}
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7763 "VideoSupport.c"
		}
		__finally536:
		{
			VideoRow* _tmp7_;
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = self->priv->backing_row;
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7772 "VideoSupport.c"
		}
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 810 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7780 "VideoSupport.c"
	}
}


static void
video_real_get_dimensions (MediaSource* base,
                           PhotoException disallowed_steps,
                           Dimensions* result)
{
	Video * self;
	Dimensions _tmp0_ = {0};
#line 815 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 816 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_get_frame_dimensions (self, &_tmp0_);
#line 816 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	*result = _tmp0_;
#line 816 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return;
#line 7800 "VideoSupport.c"
}


static guint64
video_real_get_filesize (MediaSource* base)
{
	Video * self;
	guint64 result = 0ULL;
#line 819 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 820 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = media_source_get_master_filesize (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 820 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 7815 "VideoSupport.c"
}


static guint64
video_real_get_master_filesize (MediaSource* base)
{
	Video * self;
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 823 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7827 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		guint64 _tmp5_ = 0ULL;
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7835 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			gint64 _tmp2_;
#line 825 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 825 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->filesize;
#line 825 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = (guint64) _tmp2_;
#line 7845 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7852 "VideoSupport.c"
			}
#line 825 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7856 "VideoSupport.c"
		}
		__finally537:
		{
			VideoRow* _tmp4_;
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7865 "VideoSupport.c"
		}
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 824 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 7873 "VideoSupport.c"
	}
}


static time_t
video_real_get_timestamp (MediaSource* base)
{
	Video * self;
	time_t result = 0;
	GError * _inner_error_ = NULL;
#line 829 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7886 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		time_t _tmp5_ = 0;
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7894 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			time_t _tmp2_;
#line 831 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 831 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->timestamp;
#line 831 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 7904 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7911 "VideoSupport.c"
			}
#line 831 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7915 "VideoSupport.c"
		}
		__finally538:
		{
			VideoRow* _tmp4_;
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7924 "VideoSupport.c"
		}
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 830 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 7932 "VideoSupport.c"
	}
}


static void
video_real_set_master_timestamp (Monitorable* base,
                                 GFileInfo* info)
{
	Video * self;
	GTimeVal time_val = {0};
	GTimeVal _tmp0_ = {0};
	Alteration* _tmp18_;
	Alteration* _tmp19_;
	GError * _inner_error_ = NULL;
#line 835 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 835 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 836 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_file_info_get_modification_time (info, &_tmp0_);
#line 836 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	time_val = _tmp0_;
#line 7955 "VideoSupport.c"
	{
		{
			VideoRow* _tmp1_;
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7963 "VideoSupport.c"
			{
				VideoRow* _tmp2_;
				time_t _tmp3_;
				GTimeVal _tmp4_;
				glong _tmp5_;
				VideoTable* _tmp7_;
				VideoTable* _tmp8_;
				VideoRow* _tmp9_;
				VideoID _tmp10_;
				GTimeVal _tmp11_;
				glong _tmp12_;
				VideoRow* _tmp13_;
				GTimeVal _tmp14_;
				glong _tmp15_;
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp2_ = self->priv->backing_row;
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = _tmp2_->timestamp;
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = time_val;
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = _tmp4_.tv_sec;
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_tmp3_ == ((time_t) _tmp5_)) {
#line 7988 "VideoSupport.c"
					{
						VideoRow* _tmp6_;
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp6_ = self->priv->backing_row;
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7995 "VideoSupport.c"
					}
#line 841 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return;
#line 7999 "VideoSupport.c"
				}
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = video_table_get_instance ();
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = _tmp7_;
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = self->priv->backing_row;
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = _tmp9_->video_id;
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = time_val;
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = _tmp11_.tv_sec;
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_timestamp (_tmp8_, &_tmp10_, (time_t) _tmp12_, &_inner_error_);
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp8_);
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8019 "VideoSupport.c"
					goto __finally540;
				}
#line 844 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = self->priv->backing_row;
#line 844 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = time_val;
#line 844 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_ = _tmp14_.tv_sec;
#line 844 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_->timestamp = (time_t) _tmp15_;
#line 8030 "VideoSupport.c"
			}
			__finally540:
			{
				VideoRow* _tmp16_;
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = self->priv->backing_row;
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8039 "VideoSupport.c"
			}
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 8045 "VideoSupport.c"
					goto __catch539_database_error;
				}
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 839 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 8054 "VideoSupport.c"
			}
		}
	}
	goto __finally539;
	__catch539_database_error:
	{
		GError* err = NULL;
		GError* _tmp17_;
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 847 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp17_ = err;
#line 847 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		app_window_database_error (_tmp17_);
#line 849 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 849 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 8075 "VideoSupport.c"
	}
	__finally539:
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 8086 "VideoSupport.c"
	}
#line 852 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp18_ = alteration_new ("metadata", "master-timestamp");
#line 852 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = _tmp18_;
#line 852 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp19_);
#line 852 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp19_);
#line 8096 "VideoSupport.c"
}


gchar*
video_get_filename (Video* self)
{
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 855 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), NULL);
#line 8107 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8114 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 857 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 857 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->filepath;
#line 857 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 857 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp3_;
#line 8127 "VideoSupport.c"
			{
				VideoRow* _tmp4_;
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = self->priv->backing_row;
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8134 "VideoSupport.c"
			}
#line 857 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 8138 "VideoSupport.c"
		}
		__finally541:
		{
			VideoRow* _tmp5_;
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8147 "VideoSupport.c"
		}
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 856 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 8155 "VideoSupport.c"
	}
}


static GFile*
video_real_get_file (MediaSource* base)
{
	Video * self;
	GFile* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
#line 861 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_get_filename (self);
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp1_);
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp3_;
#line 862 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 8185 "VideoSupport.c"
}


static GFile*
video_real_get_master_file (MediaSource* base)
{
	Video * self;
	GFile* result = NULL;
	GFile* _tmp0_;
#line 865 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 866 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 866 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 866 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 8203 "VideoSupport.c"
}


void
video_export (Video* self,
              GFile* dest_file,
              GError** error)
{
	GFile* source_file = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError * _inner_error_ = NULL;
#line 869 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 869 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE (dest_file));
#line 870 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_get_filename (self);
#line 870 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 870 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 870 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 870 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp1_);
#line 870 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	source_file = _tmp3_;
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_file_copy (source_file, dest_file, G_FILE_COPY_OVERWRITE | G_FILE_COPY_TARGET_DEFAULT_PERMS, NULL, NULL, NULL, &_inner_error_);
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (source_file);
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 8244 "VideoSupport.c"
	}
#line 869 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (source_file);
#line 8248 "VideoSupport.c"
}


gdouble
video_get_clip_duration (Video* self)
{
	gdouble result = 0.0;
	GError * _inner_error_ = NULL;
#line 875 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), 0.0);
#line 8259 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		gdouble _tmp5_ = 0.0;
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8267 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			gdouble _tmp2_;
#line 877 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 877 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->clip_duration;
#line 877 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 8277 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8284 "VideoSupport.c"
			}
#line 877 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 8288 "VideoSupport.c"
		}
		__finally542:
		{
			VideoRow* _tmp4_;
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8297 "VideoSupport.c"
		}
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 876 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 8305 "VideoSupport.c"
	}
}


gboolean
video_get_is_interpretable (Video* self)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 881 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), FALSE);
#line 8317 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		gboolean _tmp5_ = FALSE;
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8325 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			gboolean _tmp2_;
#line 883 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 883 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->is_interpretable;
#line 883 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 8335 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8342 "VideoSupport.c"
			}
#line 883 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 8346 "VideoSupport.c"
		}
		__finally543:
		{
			VideoRow* _tmp4_;
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8355 "VideoSupport.c"
		}
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 882 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 8363 "VideoSupport.c"
	}
}


static void
video_set_is_interpretable (Video* self,
                            gboolean is_interpretable)
{
	GError * _inner_error_ = NULL;
#line 887 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 8375 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8382 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			gboolean _tmp2_;
			VideoRow* _tmp4_;
#line 889 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 889 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->is_interpretable;
#line 889 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp2_ == is_interpretable) {
#line 8393 "VideoSupport.c"
				{
					VideoRow* _tmp3_;
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp3_ = self->priv->backing_row;
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8400 "VideoSupport.c"
				}
#line 890 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 8404 "VideoSupport.c"
			}
#line 892 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 892 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_->is_interpretable = is_interpretable;
#line 8410 "VideoSupport.c"
		}
		__finally544:
		{
			VideoRow* _tmp5_;
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8419 "VideoSupport.c"
		}
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 888 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 8429 "VideoSupport.c"
		}
	}
	{
		VideoTable* _tmp6_;
		VideoTable* _tmp7_;
		VideoID _tmp8_ = {0};
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = video_table_get_instance ();
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = _tmp6_;
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_get_video_id (self, &_tmp8_);
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_update_is_interpretable (_tmp7_, &_tmp8_, is_interpretable, &_inner_error_);
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp7_);
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 8450 "VideoSupport.c"
				goto __catch545_database_error;
			}
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 896 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 8459 "VideoSupport.c"
		}
	}
	goto __finally545;
	__catch545_database_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = e;
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		app_window_database_error (_tmp9_);
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 8477 "VideoSupport.c"
	}
	__finally545:
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 895 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 8488 "VideoSupport.c"
	}
}


VideoInterpretableResults*
video_check_is_interpretable (Video* self)
{
	VideoInterpretableResults* result = NULL;
	VideoInterpretableResults* results = NULL;
	VideoInterpretableResults* _tmp0_;
	gdouble clip_duration = 0.0;
	GdkPixbuf* preview_frame = NULL;
	VideoReader* backing_file_reader = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	VideoReader* _tmp3_;
	VideoReader* _tmp4_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	VideoInterpretableResults* _tmp21_;
	VideoInterpretableResults* _tmp22_;
	VideoInterpretableResults* _tmp23_;
	GdkPixbuf* _tmp24_;
	GdkPixbuf* _tmp25_;
	GError * _inner_error_ = NULL;
#line 905 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), NULL);
#line 906 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_interpretable_results_new (self);
#line 906 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	results = _tmp0_;
#line 908 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	clip_duration = -1.0;
#line 909 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	preview_frame = NULL;
#line 911 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 911 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 911 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_reader_new (_tmp2_);
#line 911 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 911 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp2_);
#line 911 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	backing_file_reader = _tmp4_;
#line 8538 "VideoSupport.c"
	{
		gdouble _tmp5_ = 0.0;
		VideoReader* _tmp6_;
		VideoReader* _tmp7_;
		GdkPixbuf* _tmp8_;
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = backing_file_reader;
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = video_reader_read_clip_duration (_tmp6_, &_inner_error_);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == VIDEO_ERROR) {
#line 8552 "VideoSupport.c"
				goto __catch546_video_error;
			}
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_reader_unref0 (backing_file_reader);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (preview_frame);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_interpretable_results_unref0 (results);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return NULL;
#line 8567 "VideoSupport.c"
		}
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		clip_duration = _tmp5_;
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = backing_file_reader;
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = video_reader_read_preview_frame (_tmp7_);
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		preview_frame = _tmp8_;
#line 8579 "VideoSupport.c"
	}
	goto __finally546;
	__catch546_video_error:
	{
		GError* e = NULL;
		VideoInterpretableResults* _tmp9_;
		VideoInterpretableResults* _tmp10_;
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 918 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = results;
#line 918 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_->update_interpretable = video_get_is_interpretable (self);
#line 919 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = results;
#line 919 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_->is_interpretable = FALSE;
#line 921 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = results;
#line 921 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 921 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (backing_file_reader);
#line 921 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 921 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 8609 "VideoSupport.c"
	}
	__finally546:
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (backing_file_reader);
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_interpretable_results_unref0 (results);
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 912 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 8626 "VideoSupport.c"
	}
#line 925 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (video_get_is_interpretable (self)) {
#line 8630 "VideoSupport.c"
		VideoInterpretableResults* _tmp11_;
		VideoInterpretableResults* _tmp12_;
#line 926 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = results;
#line 926 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_->update_interpretable = FALSE;
#line 927 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = results;
#line 927 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_->is_interpretable = TRUE;
#line 929 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = results;
#line 929 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (backing_file_reader);
#line 929 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 929 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 8649 "VideoSupport.c"
	}
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp14_ = _tmp13_;
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp15_ = g_file_get_basename (_tmp14_);
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp16_ = _tmp15_;
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_debug ("VideoSupport.vala:932: video %s has become interpretable", _tmp16_);
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp16_);
#line 932 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp14_);
#line 8665 "VideoSupport.c"
	{
		VideoRow* _tmp17_;
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp17_ = self->priv->backing_row;
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8672 "VideoSupport.c"
		{
			VideoRow* _tmp18_;
			gdouble _tmp19_;
#line 936 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = self->priv->backing_row;
#line 936 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp19_ = clip_duration;
#line 936 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_->clip_duration = _tmp19_;
#line 8682 "VideoSupport.c"
		}
		__finally547:
		{
			VideoRow* _tmp20_;
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp20_ = self->priv->backing_row;
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8691 "VideoSupport.c"
		}
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_reader_unref0 (backing_file_reader);
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (preview_frame);
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_interpretable_results_unref0 (results);
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 935 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return NULL;
#line 8707 "VideoSupport.c"
		}
	}
#line 939 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp21_ = results;
#line 939 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp21_->update_interpretable = TRUE;
#line 940 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp22_ = results;
#line 940 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp22_->is_interpretable = TRUE;
#line 941 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = results;
#line 941 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = preview_frame;
#line 941 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_ = _g_object_ref0 (_tmp24_);
#line 941 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp23_->new_thumbnail);
#line 941 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_->new_thumbnail = _tmp25_;
#line 943 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = results;
#line 943 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_reader_unref0 (backing_file_reader);
#line 943 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (preview_frame);
#line 943 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 8736 "VideoSupport.c"
}


static void
video_real_destroy (DataSource* base)
{
	Video * self;
	VideoID video_id = {0};
	VideoID _tmp0_ = {0};
	GError * _inner_error_ = NULL;
#line 946 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 947 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_get_video_id (self, &_tmp0_);
#line 947 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id = _tmp0_;
#line 949 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	thumbnail_cache_remove (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
#line 8755 "VideoSupport.c"
	{
		VideoTable* _tmp1_;
		VideoTable* _tmp2_;
		VideoID _tmp3_;
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = video_table_get_instance ();
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _tmp1_;
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_id;
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_remove (_tmp2_, &_tmp3_, &_inner_error_);
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp2_);
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 8774 "VideoSupport.c"
				goto __catch548_database_error;
			}
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 952 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 8783 "VideoSupport.c"
		}
	}
	goto __finally548;
	__catch548_database_error:
	{
		GError* err = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = _tmp4_;
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_error ("VideoSupport.vala:954: failed to remove video %s from video table", _tmp5_);
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp5_);
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 8806 "VideoSupport.c"
	}
	__finally548:
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 8817 "VideoSupport.c"
	}
#line 957 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	DATA_SOURCE_CLASS (video_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_VIDEO_SOURCE, VideoSource), TYPE_DATA_SOURCE, DataSource));
#line 8821 "VideoSupport.c"
}


static gboolean
video_real_internal_delete_backing (DataSource* base,
                                    GError** error)
{
	Video * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 960 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 961 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	ret = media_source_delete_original_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = DATA_SOURCE_CLASS (video_parent_class)->internal_delete_backing (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_VIDEO_SOURCE, VideoSource), TYPE_DATA_SOURCE, DataSource), &_inner_error_);
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8843 "VideoSupport.c"
		gboolean _tmp2_ = FALSE;
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp2_;
#line 8849 "VideoSupport.c"
	}
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_) {
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = ret;
#line 8855 "VideoSupport.c"
	} else {
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = FALSE;
#line 8859 "VideoSupport.c"
	}
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 964 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 8865 "VideoSupport.c"
}


static void
video_notify_flags_altered (Video* self,
                            Alteration* additional_alteration)
{
	Alteration* alteration = NULL;
	Alteration* _tmp0_;
	Alteration* _tmp3_;
#line 967 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 967 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration));
#line 968 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = alteration_new ("metadata", "flags");
#line 968 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	alteration = _tmp0_;
#line 969 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (additional_alteration != NULL) {
#line 8886 "VideoSupport.c"
		Alteration* _tmp1_;
		Alteration* _tmp2_;
#line 970 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = alteration;
#line 970 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = alteration_compress (_tmp1_, additional_alteration);
#line 970 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_alteration_unref0 (alteration);
#line 970 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		alteration = _tmp2_;
#line 8897 "VideoSupport.c"
	}
#line 972 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = alteration;
#line 972 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp3_);
#line 967 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (alteration);
#line 8905 "VideoSupport.c"
}


guint64
video_add_flags (Video* self,
                 guint64 flags_to_add,
                 Alteration* additional_alteration)
{
	guint64 result = 0ULL;
	guint64 new_flags = 0ULL;
	GError * _inner_error_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), 0ULL);
#line 975 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 8921 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8928 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			guint64 _tmp2_;
			VideoRow* _tmp3_;
			guint64 _tmp4_;
			guint64 _tmp5_;
			VideoRow* _tmp21_;
			guint64 _tmp22_;
#line 978 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 978 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->flags;
#line 978 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			new_flags = media_source_internal_add_flags (_tmp2_, flags_to_add);
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _tmp3_->flags;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = new_flags;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp4_ == _tmp5_) {
#line 8951 "VideoSupport.c"
				VideoRow* _tmp6_;
				guint64 _tmp7_;
#line 980 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = self->priv->backing_row;
#line 980 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = _tmp6_->flags;
#line 980 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = _tmp7_;
#line 8960 "VideoSupport.c"
				{
					VideoRow* _tmp8_;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp8_ = self->priv->backing_row;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8967 "VideoSupport.c"
				}
#line 980 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 8971 "VideoSupport.c"
			}
			{
				VideoTable* _tmp9_;
				VideoTable* _tmp10_;
				VideoID _tmp11_ = {0};
				guint64 _tmp12_;
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = video_table_get_instance ();
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = _tmp9_;
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_get_video_id (self, &_tmp11_);
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = new_flags;
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_flags (_tmp10_, &_tmp11_, _tmp12_, &_inner_error_);
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp10_);
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8992 "VideoSupport.c"
					guint64 _tmp14_ = 0ULL;
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 8996 "VideoSupport.c"
						goto __catch550_database_error;
					}
					{
						VideoRow* _tmp13_;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp13_ = self->priv->backing_row;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9005 "VideoSupport.c"
					}
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 983 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return _tmp14_;
#line 9013 "VideoSupport.c"
				}
			}
			goto __finally550;
			__catch550_database_error:
			{
				GError* e = NULL;
				GError* _tmp15_;
				VideoRow* _tmp16_;
				guint64 _tmp17_;
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_ = e;
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp15_);
#line 986 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = self->priv->backing_row;
#line 986 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = _tmp16_->flags;
#line 986 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = _tmp17_;
#line 986 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 9039 "VideoSupport.c"
				{
					VideoRow* _tmp18_;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp18_ = self->priv->backing_row;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9046 "VideoSupport.c"
				}
#line 986 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 9050 "VideoSupport.c"
			}
			__finally550:
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9055 "VideoSupport.c"
				guint64 _tmp20_ = 0ULL;
				{
					VideoRow* _tmp19_;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp19_ = self->priv->backing_row;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9063 "VideoSupport.c"
				}
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp20_;
#line 9071 "VideoSupport.c"
			}
#line 989 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_ = self->priv->backing_row;
#line 989 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp22_ = new_flags;
#line 989 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_->flags = _tmp22_;
#line 9079 "VideoSupport.c"
		}
		__finally549:
		{
			VideoRow* _tmp23_;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_ = self->priv->backing_row;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9088 "VideoSupport.c"
		}
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9092 "VideoSupport.c"
			guint64 _tmp24_ = 0ULL;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return _tmp24_;
#line 9100 "VideoSupport.c"
		}
	}
#line 992 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_notify_flags_altered (self, additional_alteration);
#line 994 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = new_flags;
#line 994 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 9109 "VideoSupport.c"
}


guint64
video_remove_flags (Video* self,
                    guint64 flags_to_remove,
                    Alteration* additional_alteration)
{
	guint64 result = 0ULL;
	guint64 new_flags = 0ULL;
	GError * _inner_error_ = NULL;
#line 997 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), 0ULL);
#line 997 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 9125 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 9132 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			guint64 _tmp2_;
			VideoRow* _tmp3_;
			guint64 _tmp4_;
			guint64 _tmp5_;
			VideoRow* _tmp21_;
			guint64 _tmp22_;
#line 1000 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 1000 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->flags;
#line 1000 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			new_flags = media_source_internal_remove_flags (_tmp2_, flags_to_remove);
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _tmp3_->flags;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = new_flags;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp4_ == _tmp5_) {
#line 9155 "VideoSupport.c"
				VideoRow* _tmp6_;
				guint64 _tmp7_;
#line 1002 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = self->priv->backing_row;
#line 1002 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = _tmp6_->flags;
#line 1002 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = _tmp7_;
#line 9164 "VideoSupport.c"
				{
					VideoRow* _tmp8_;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp8_ = self->priv->backing_row;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9171 "VideoSupport.c"
				}
#line 1002 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 9175 "VideoSupport.c"
			}
			{
				VideoTable* _tmp9_;
				VideoTable* _tmp10_;
				VideoID _tmp11_ = {0};
				guint64 _tmp12_;
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = video_table_get_instance ();
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = _tmp9_;
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_get_video_id (self, &_tmp11_);
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = new_flags;
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_flags (_tmp10_, &_tmp11_, _tmp12_, &_inner_error_);
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp10_);
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9196 "VideoSupport.c"
					guint64 _tmp14_ = 0ULL;
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 9200 "VideoSupport.c"
						goto __catch552_database_error;
					}
					{
						VideoRow* _tmp13_;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp13_ = self->priv->backing_row;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9209 "VideoSupport.c"
					}
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 1005 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return _tmp14_;
#line 9217 "VideoSupport.c"
				}
			}
			goto __finally552;
			__catch552_database_error:
			{
				GError* e = NULL;
				GError* _tmp15_;
				VideoRow* _tmp16_;
				guint64 _tmp17_;
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_ = e;
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp15_);
#line 1008 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = self->priv->backing_row;
#line 1008 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = _tmp16_->flags;
#line 1008 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = _tmp17_;
#line 1008 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 9243 "VideoSupport.c"
				{
					VideoRow* _tmp18_;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp18_ = self->priv->backing_row;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9250 "VideoSupport.c"
				}
#line 1008 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 9254 "VideoSupport.c"
			}
			__finally552:
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9259 "VideoSupport.c"
				guint64 _tmp20_ = 0ULL;
				{
					VideoRow* _tmp19_;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp19_ = self->priv->backing_row;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9267 "VideoSupport.c"
				}
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp20_;
#line 9275 "VideoSupport.c"
			}
#line 1011 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_ = self->priv->backing_row;
#line 1011 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp22_ = new_flags;
#line 1011 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_->flags = _tmp22_;
#line 9283 "VideoSupport.c"
		}
		__finally551:
		{
			VideoRow* _tmp23_;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_ = self->priv->backing_row;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9292 "VideoSupport.c"
		}
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9296 "VideoSupport.c"
			guint64 _tmp24_ = 0ULL;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return _tmp24_;
#line 9304 "VideoSupport.c"
		}
	}
#line 1014 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_notify_flags_altered (self, additional_alteration);
#line 1016 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = new_flags;
#line 1016 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 9313 "VideoSupport.c"
}


gboolean
video_is_flag_set (Video* self,
                   guint64 flag)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1019 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), FALSE);
#line 9325 "VideoSupport.c"
	{
		VideoRow* _tmp0_;
		gboolean _tmp5_ = FALSE;
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 9333 "VideoSupport.c"
		{
			VideoRow* _tmp1_;
			guint64 _tmp2_;
#line 1021 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 1021 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->flags;
#line 1021 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = media_source_internal_is_flag_set (_tmp2_, flag);
#line 9343 "VideoSupport.c"
			{
				VideoRow* _tmp3_;
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9350 "VideoSupport.c"
			}
#line 1021 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 9354 "VideoSupport.c"
		}
		__finally553:
		{
			VideoRow* _tmp4_;
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9363 "VideoSupport.c"
		}
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 1020 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 9371 "VideoSupport.c"
	}
}


static void
video_real_set_master_file (Monitorable* base,
                            GFile* file)
{
	Video * self;
	gchar* new_filepath = NULL;
	gchar* _tmp0_;
	gchar* old_filepath = NULL;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GFile* _tmp21_;
	GFile* _tmp22_;
	Alteration* _tmp23_;
	Alteration* _tmp24_;
	GError * _inner_error_ = NULL;
#line 1025 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 1025 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 1026 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = g_file_get_path (file);
#line 1026 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	new_filepath = _tmp0_;
#line 1027 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old_filepath = NULL;
#line 9401 "VideoSupport.c"
	{
		{
			VideoRow* _tmp1_;
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 9409 "VideoSupport.c"
			{
				VideoRow* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				VideoRow* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				VideoTable* _tmp9_;
				VideoTable* _tmp10_;
				VideoRow* _tmp11_;
				VideoID _tmp12_;
				const gchar* _tmp13_;
				VideoRow* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp2_ = self->priv->backing_row;
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = _tmp2_->filepath;
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = new_filepath;
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
#line 9433 "VideoSupport.c"
					{
						VideoRow* _tmp5_;
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp5_ = self->priv->backing_row;
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9440 "VideoSupport.c"
					}
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (old_filepath);
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (new_filepath);
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return;
#line 9448 "VideoSupport.c"
				}
#line 1033 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = self->priv->backing_row;
#line 1033 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = _tmp6_->filepath;
#line 1033 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = g_strdup (_tmp7_);
#line 1033 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (old_filepath);
#line 1033 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				old_filepath = _tmp8_;
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = video_table_get_instance ();
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = _tmp9_;
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = self->priv->backing_row;
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = _tmp11_->video_id;
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = new_filepath;
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_filepath (_tmp10_, &_tmp12_, _tmp13_, &_inner_error_);
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp10_);
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9476 "VideoSupport.c"
					goto __finally555;
				}
#line 1036 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = self->priv->backing_row;
#line 1036 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_ = new_filepath;
#line 1036 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = g_strdup (_tmp15_);
#line 1036 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (_tmp14_->filepath);
#line 1036 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_->filepath = _tmp16_;
#line 9489 "VideoSupport.c"
			}
			__finally555:
			{
				VideoRow* _tmp17_;
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = self->priv->backing_row;
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9498 "VideoSupport.c"
			}
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 9504 "VideoSupport.c"
					goto __catch554_database_error;
				}
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (old_filepath);
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_filepath);
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 9517 "VideoSupport.c"
			}
		}
	}
	goto __finally554;
	__catch554_database_error:
	{
		GError* err = NULL;
		GError* _tmp18_;
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 1039 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp18_ = err;
#line 1039 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		app_window_database_error (_tmp18_);
#line 1041 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 1041 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (old_filepath);
#line 1041 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (new_filepath);
#line 1041 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 9542 "VideoSupport.c"
	}
	__finally554:
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (old_filepath);
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (new_filepath);
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 9557 "VideoSupport.c"
	}
#line 1044 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = old_filepath;
#line 1044 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_assert (_tmp19_ != NULL, "old_filepath != null");
#line 1045 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = old_filepath;
#line 1045 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp21_ = g_file_new_for_path (_tmp20_);
#line 1045 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp22_ = _tmp21_;
#line 1045 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	media_source_notify_master_replaced (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp22_, file);
#line 1045 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp22_);
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = alteration_new_from_list ("backing:master,metadata:name");
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = _tmp23_;
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp24_);
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp24_);
#line 1025 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (old_filepath);
#line 1025 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (new_filepath);
#line 9585 "VideoSupport.c"
}


VideoMetadata*
video_read_metadata (Video* self,
                     GError** error)
{
	VideoMetadata* result = NULL;
	VideoMetadata* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	VideoReader* _tmp3_;
	VideoReader* _tmp4_;
	VideoMetadata* _tmp5_;
	VideoMetadata* _tmp6_;
	VideoMetadata* _tmp7_;
	GError * _inner_error_ = NULL;
#line 1050 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), NULL);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_reader_new (_tmp2_);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = video_reader_read_metadata (_tmp4_, &_inner_error_);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = _tmp5_;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_reader_unref0 (_tmp4_);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp2_);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = _tmp6_;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 9629 "VideoSupport.c"
	}
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = _tmp0_;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = NULL;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp7_;
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_media_metadata_unref0 (_tmp0_);
#line 1051 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 9641 "VideoSupport.c"
}


VideoInterpretableResults*
video_interpretable_results_construct (GType object_type,
                                       Video* video)
{
	VideoInterpretableResults* self = NULL;
	Video* _tmp0_;
#line 336 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (video), NULL);
#line 336 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (VideoInterpretableResults*) g_type_create_instance (object_type);
#line 337 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = _g_object_ref0 (video);
#line 337 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->video);
#line 337 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->video = _tmp0_;
#line 336 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 9663 "VideoSupport.c"
}


VideoInterpretableResults*
video_interpretable_results_new (Video* video)
{
#line 336 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_interpretable_results_construct (VIDEO_TYPE_INTERPRETABLE_RESULTS, video);
#line 9672 "VideoSupport.c"
}


void
video_interpretable_results_foreground_finish (VideoInterpretableResults* self)
{
	gboolean _tmp0_;
	GdkPixbuf* _tmp3_;
	GError * _inner_error_ = NULL;
#line 340 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (VIDEO_IS_INTERPRETABLE_RESULTS (self));
#line 341 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->update_interpretable;
#line 341 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 9688 "VideoSupport.c"
		Video* _tmp1_;
		gboolean _tmp2_;
#line 342 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->video;
#line 342 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = self->is_interpretable;
#line 342 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_set_is_interpretable (_tmp1_, _tmp2_);
#line 9697 "VideoSupport.c"
	}
#line 344 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = self->new_thumbnail;
#line 344 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp3_ != NULL) {
#line 9703 "VideoSupport.c"
		{
			Video* _tmp4_;
			GdkPixbuf* _tmp5_;
			Video* _tmp6_;
			GdkPixbuf* _tmp7_;
			Video* _tmp8_;
#line 346 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->video;
#line 346 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->new_thumbnail;
#line 346 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			thumbnail_cache_replace (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), THUMBNAIL_CACHE_SIZE_BIG, _tmp5_, &_inner_error_);
#line 346 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9718 "VideoSupport.c"
				goto __catch556_g_error;
			}
#line 347 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = self->video;
#line 347 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = self->new_thumbnail;
#line 347 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			thumbnail_cache_replace (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), THUMBNAIL_CACHE_SIZE_MEDIUM, _tmp7_, &_inner_error_);
#line 347 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9729 "VideoSupport.c"
				goto __catch556_g_error;
			}
#line 349 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = self->video;
#line 349 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			thumbnail_source_notify_thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
#line 9736 "VideoSupport.c"
		}
		goto __finally556;
		__catch556_g_error:
		{
			GError* err = NULL;
			Video* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			GError* _tmp12_;
			const gchar* _tmp13_;
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			err = _inner_error_;
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_inner_error_ = NULL;
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = self->video;
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_OBJECT, DataObject));
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = _tmp10_;
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = err;
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp13_ = _tmp12_->message;
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_message ("VideoSupport.vala:351: Unable to update video thumbnails for %s: %s", _tmp11_, _tmp13_);
#line 351 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (_tmp11_);
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_error_free0 (err);
#line 9767 "VideoSupport.c"
		}
		__finally556:
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 9778 "VideoSupport.c"
		}
	}
}


static void
video_value_interpretable_results_init (GValue* value)
{
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	value->data[0].v_pointer = NULL;
#line 9789 "VideoSupport.c"
}


static void
video_value_interpretable_results_free_value (GValue* value)
{
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (value->data[0].v_pointer) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_unref (value->data[0].v_pointer);
#line 9800 "VideoSupport.c"
	}
}


static void
video_value_interpretable_results_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (src_value->data[0].v_pointer) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = video_interpretable_results_ref (src_value->data[0].v_pointer);
#line 9813 "VideoSupport.c"
	} else {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = NULL;
#line 9817 "VideoSupport.c"
	}
}


static gpointer
video_value_interpretable_results_peek_pointer (const GValue* value)
{
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 9827 "VideoSupport.c"
}


static gchar*
video_value_interpretable_results_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (collect_values[0].v_pointer) {
#line 9839 "VideoSupport.c"
		VideoInterpretableResults * object;
		object = collect_values[0].v_pointer;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (object->parent_instance.g_class == NULL) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9846 "VideoSupport.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9850 "VideoSupport.c"
		}
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = video_interpretable_results_ref (object);
#line 9854 "VideoSupport.c"
	} else {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 9858 "VideoSupport.c"
	}
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 9862 "VideoSupport.c"
}


static gchar*
video_value_interpretable_results_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	VideoInterpretableResults ** object_p;
	object_p = collect_values[0].v_pointer;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!object_p) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 9878 "VideoSupport.c"
	}
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!value->data[0].v_pointer) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = NULL;
#line 9884 "VideoSupport.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = value->data[0].v_pointer;
#line 9888 "VideoSupport.c"
	} else {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = video_interpretable_results_ref (value->data[0].v_pointer);
#line 9892 "VideoSupport.c"
	}
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 9896 "VideoSupport.c"
}


GParamSpec*
video_param_spec_interpretable_results (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	VideoParamSpecInterpretableResults* spec;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (g_type_is_a (object_type, VIDEO_TYPE_INTERPRETABLE_RESULTS), NULL);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return G_PARAM_SPEC (spec);
#line 9916 "VideoSupport.c"
}


gpointer
video_value_get_interpretable_results (const GValue* value)
{
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS), NULL);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 9927 "VideoSupport.c"
}


void
video_value_set_interpretable_results (GValue* value,
                                       gpointer v_object)
{
	VideoInterpretableResults * old;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS));
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIDEO_TYPE_INTERPRETABLE_RESULTS));
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_ref (value->data[0].v_pointer);
#line 9950 "VideoSupport.c"
	} else {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 9954 "VideoSupport.c"
	}
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_unref (old);
#line 9960 "VideoSupport.c"
	}
}


void
video_value_take_interpretable_results (GValue* value,
                                        gpointer v_object)
{
	VideoInterpretableResults * old;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS));
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIDEO_TYPE_INTERPRETABLE_RESULTS));
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 9982 "VideoSupport.c"
	} else {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 9986 "VideoSupport.c"
	}
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_unref (old);
#line 9992 "VideoSupport.c"
	}
}


static void
video_interpretable_results_class_init (VideoInterpretableResultsClass * klass)
{
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_interpretable_results_parent_class = g_type_class_peek_parent (klass);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((VideoInterpretableResultsClass *) klass)->finalize = video_interpretable_results_finalize;
#line 10004 "VideoSupport.c"
}


static void
video_interpretable_results_instance_init (VideoInterpretableResults * self)
{
#line 332 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->update_interpretable = FALSE;
#line 333 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->is_interpretable = FALSE;
#line 334 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->new_thumbnail = NULL;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->ref_count = 1;
#line 10019 "VideoSupport.c"
}


static void
video_interpretable_results_finalize (VideoInterpretableResults * obj)
{
	VideoInterpretableResults * self;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResults);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_handlers_destroy (self);
#line 331 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->video);
#line 334 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->new_thumbnail);
#line 10035 "VideoSupport.c"
}


GType
video_interpretable_results_get_type (void)
{
	static volatile gsize video_interpretable_results_type_id__volatile = 0;
	if (g_once_init_enter (&video_interpretable_results_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { video_value_interpretable_results_init, video_value_interpretable_results_free_value, video_value_interpretable_results_copy_value, video_value_interpretable_results_peek_pointer, "p", video_value_interpretable_results_collect_value, "p", video_value_interpretable_results_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (VideoInterpretableResultsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_interpretable_results_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoInterpretableResults), 0, (GInstanceInitFunc) video_interpretable_results_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType video_interpretable_results_type_id;
		video_interpretable_results_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoInterpretableResults", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&video_interpretable_results_type_id__volatile, video_interpretable_results_type_id);
	}
	return video_interpretable_results_type_id__volatile;
}


gpointer
video_interpretable_results_ref (gpointer instance)
{
	VideoInterpretableResults * self;
	self = instance;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_atomic_int_inc (&self->ref_count);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return instance;
#line 10064 "VideoSupport.c"
}


void
video_interpretable_results_unref (gpointer instance)
{
	VideoInterpretableResults * self;
	self = instance;
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		VIDEO_INTERPRETABLE_RESULTS_GET_CLASS (self)->finalize (self);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 10079 "VideoSupport.c"
	}
}


static void
video_class_init (VideoClass * klass)
{
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_parent_class = g_type_class_peek_parent (klass);
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_type_class_add_private (klass, sizeof (VideoPrivate));
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->commit_backlinks = (void (*) (DataSource *, SourceCollection*, const gchar*)) video_real_commit_backlinks;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->set_event_id = (gboolean (*) (MediaSource *, EventID*)) video_real_set_event_id;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_backing_files_state = (BackingFileState** (*) (MediaSource *, int*)) video_real_get_backing_files_state;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*) (ThumbnailSource *, gint, GError**)) video_real_get_thumbnail;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_master_md5 = (gchar* (*) (MediaSource *)) video_real_get_master_md5;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_preview_pixbuf = (GdkPixbuf* (*) (MediaSource *, Scaling*, GError**)) video_real_get_preview_pixbuf;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((ThumbnailSourceClass *) klass)->create_thumbnail = (GdkPixbuf* (*) (ThumbnailSource *, gint, GError**)) video_real_create_thumbnail;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource *)) video_real_get_typename;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource *)) video_real_get_instance_id;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_import_id = (void (*) (MediaSource *, ImportID*)) video_real_get_import_id;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((ThumbnailSourceClass *) klass)->get_preferred_thumbnail_format = (PhotoFileFormat (*) (ThumbnailSource *)) video_real_get_preferred_thumbnail_format;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_title = (gchar* (*) (MediaSource *)) video_real_get_title;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->set_title = (void (*) (MediaSource *, const gchar*)) video_real_set_title;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_comment = (gchar* (*) (MediaSource *)) video_real_get_comment;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->set_comment = (gboolean (*) (MediaSource *, const gchar*)) video_real_set_comment;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_rating = (Rating (*) (MediaSource *)) video_real_get_rating;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->set_rating = (void (*) (MediaSource *, Rating)) video_real_set_rating;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->increase_rating = (void (*) (MediaSource *)) video_real_increase_rating;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->decrease_rating = (void (*) (MediaSource *)) video_real_decrease_rating;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->is_trashed = (gboolean (*) (MediaSource *)) video_real_is_trashed;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->is_offline = (gboolean (*) (MediaSource *)) video_real_is_offline;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->mark_offline = (void (*) (MediaSource *)) video_real_mark_offline;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->mark_online = (void (*) (MediaSource *)) video_real_mark_online;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->trash = (void (*) (MediaSource *)) video_real_trash;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->untrash = (void (*) (MediaSource *)) video_real_untrash;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_event_id = (void (*) (MediaSource *, EventID*)) video_real_get_event_id;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject *)) video_real_to_string;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_exposure_time = (time_t (*) (MediaSource *)) video_real_get_exposure_time;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_dimensions = (void (*) (MediaSource *, PhotoException, Dimensions*)) video_real_get_dimensions;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_filesize = (guint64 (*) (MediaSource *)) video_real_get_filesize;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_master_filesize = (guint64 (*) (MediaSource *)) video_real_get_master_filesize;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_timestamp = (time_t (*) (MediaSource *)) video_real_get_timestamp;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_file = (GFile* (*) (MediaSource *)) video_real_get_file;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_master_file = (GFile* (*) (MediaSource *)) video_real_get_master_file;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->destroy = (void (*) (DataSource *)) video_real_destroy;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->internal_delete_backing = (gboolean (*) (DataSource *, GError**)) video_real_internal_delete_backing;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_OBJECT_CLASS (klass)->finalize = video_finalize;
#line 10165 "VideoSupport.c"
}


static void
video_flaggable_interface_init (FlaggableIface * iface)
{
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_flaggable_parent_iface = g_type_interface_peek_parent (iface);
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->is_flagged = (gboolean (*) (Flaggable *)) video_real_is_flagged;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->mark_flagged = (void (*) (Flaggable *)) video_real_mark_flagged;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->mark_unflagged = (void (*) (Flaggable *)) video_real_mark_unflagged;
#line 10180 "VideoSupport.c"
}


static void
video_monitorable_interface_init (MonitorableIface * iface)
{
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_monitorable_parent_iface = g_type_interface_peek_parent (iface);
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->is_offline = (gboolean (*) (Monitorable *)) video_real_is_offline;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->mark_offline = (void (*) (Monitorable *)) video_real_mark_offline;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->mark_online = (void (*) (Monitorable *)) video_real_mark_online;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->set_master_timestamp = (void (*) (Monitorable *, GFileInfo*)) video_real_set_master_timestamp;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->set_master_file = (void (*) (Monitorable *, GFile*)) video_real_set_master_file;
#line 10199 "VideoSupport.c"
}


static void
video_dateable_interface_init (DateableIface * iface)
{
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_dateable_parent_iface = g_type_interface_peek_parent (iface);
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->get_exposure_time = (time_t (*) (Dateable *)) video_real_get_exposure_time;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->set_exposure_time = (void (*) (Dateable *, time_t)) video_real_set_exposure_time;
#line 10212 "VideoSupport.c"
}


static void
video_instance_init (Video * self)
{
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv = VIDEO_GET_PRIVATE (self);
#line 364 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_rec_mutex_init (&self->priv->__lock_backing_row);
#line 10223 "VideoSupport.c"
}


static void
video_finalize (GObject * obj)
{
	Video * self;
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO, Video);
#line 364 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_rec_mutex_clear (&self->priv->__lock_backing_row);
#line 364 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_row_unref0 (self->priv->backing_row);
#line 323 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_OBJECT_CLASS (video_parent_class)->finalize (obj);
#line 10239 "VideoSupport.c"
}


GType
video_get_type (void)
{
	static volatile gsize video_type_id__volatile = 0;
	if (g_once_init_enter (&video_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Video), 0, (GInstanceInitFunc) video_instance_init, NULL };
		static const GInterfaceInfo flaggable_info = { (GInterfaceInitFunc) video_flaggable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo monitorable_info = { (GInterfaceInitFunc) video_monitorable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo dateable_info = { (GInterfaceInitFunc) video_dateable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType video_type_id;
		video_type_id = g_type_register_static (TYPE_VIDEO_SOURCE, "Video", &g_define_type_info, 0);
		g_type_add_interface_static (video_type_id, TYPE_FLAGGABLE, &flaggable_info);
		g_type_add_interface_static (video_type_id, TYPE_MONITORABLE, &monitorable_info);
		g_type_add_interface_static (video_type_id, TYPE_DATEABLE, &dateable_info);
		g_once_init_leave (&video_type_id__volatile, video_type_id);
	}
	return video_type_id__volatile;
}


GType
video_source_collection_state_get_type (void)
{
	static volatile gsize video_source_collection_state_type_id__volatile = 0;
	if (g_once_init_enter (&video_source_collection_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN, "VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN", "unknown"}, {VIDEO_SOURCE_COLLECTION_STATE_ONLINE, "VIDEO_SOURCE_COLLECTION_STATE_ONLINE", "online"}, {VIDEO_SOURCE_COLLECTION_STATE_OFFLINE, "VIDEO_SOURCE_COLLECTION_STATE_OFFLINE", "offline"}, {VIDEO_SOURCE_COLLECTION_STATE_TRASH, "VIDEO_SOURCE_COLLECTION_STATE_TRASH", "trash"}, {0, NULL, NULL}};
		GType video_source_collection_state_type_id;
		video_source_collection_state_type_id = g_enum_register_static ("VideoSourceCollectionState", values);
		g_once_init_leave (&video_source_collection_state_type_id__volatile, video_source_collection_state_type_id);
	}
	return video_source_collection_state_type_id__volatile;
}


static gint
_uint64_compare_gcompare_data_func (gconstpointer a,
                                    gconstpointer b,
                                    gpointer self)
{
	gint result;
	result = uint64_compare ((guint64*) a, (guint64*) b);
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10286 "VideoSupport.c"
}


static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	dup = g_new0 (guint64, 1);
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	memcpy (dup, self, sizeof (guint64));
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return dup;
#line 10300 "VideoSupport.c"
}


static gint64
_video_source_collection_get_video_key_get_source_database_key (DataSource* source,
                                                                gpointer self)
{
	gint64 result;
	result = video_source_collection_get_video_key (source);
#line 1077 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10312 "VideoSupport.c"
}


static void
_video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                            GeeCollection* added,
                                                                                            GeeCollection* removed,
                                                                                            gpointer self)
{
#line 1079 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_source_collection_on_trashcan_contents_altered ((VideoSourceCollection*) self, added, removed);
#line 10324 "VideoSupport.c"
}


static void
_video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                           GeeCollection* added,
                                                                                           GeeCollection* removed,
                                                                                           gpointer self)
{
#line 1080 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_source_collection_on_offline_contents_altered ((VideoSourceCollection*) self, added, removed);
#line 10336 "VideoSupport.c"
}


VideoSourceCollection*
video_source_collection_construct (GType object_type)
{
	VideoSourceCollection* self = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSourceHoldingTank* _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
#line 1077 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (VideoSourceCollection*) media_source_collection_construct (object_type, "VideoSourceCollection", _video_source_collection_get_video_key_get_source_database_key, NULL);
#line 1079 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1079 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 1079 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), "contents-altered", (GCallback) _video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered, self);
#line 1079 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_source_holding_tank_unref0 (_tmp1_);
#line 1080 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1080 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 1080 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), "contents-altered", (GCallback) _video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered, self);
#line 1080 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_source_holding_tank_unref0 (_tmp3_);
#line 1076 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 10368 "VideoSupport.c"
}


VideoSourceCollection*
video_source_collection_new (void)
{
#line 1076 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_source_collection_construct (TYPE_VIDEO_SOURCE_COLLECTION);
#line 10377 "VideoSupport.c"
}


static gboolean
_video_source_collection_is_video_trashed_source_holding_tank_check_to_keep (DataSource* source,
                                                                             Alteration* alteration,
                                                                             gpointer self)
{
	gboolean result;
	result = video_source_collection_is_video_trashed (source);
#line 1084 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10390 "VideoSupport.c"
}


static MediaSourceHoldingTank*
video_source_collection_real_create_trashcan (MediaSourceCollection* base)
{
	VideoSourceCollection * self;
	MediaSourceHoldingTank* result = NULL;
	MediaSourceHoldingTank* _tmp0_;
#line 1083 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1084 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_holding_tank_new (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), _video_source_collection_is_video_trashed_source_holding_tank_check_to_keep, NULL, _video_source_collection_get_video_key_get_source_database_key, NULL);
#line 1084 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 1084 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10408 "VideoSupport.c"
}


static gboolean
_video_source_collection_is_video_offline_source_holding_tank_check_to_keep (DataSource* source,
                                                                             Alteration* alteration,
                                                                             gpointer self)
{
	gboolean result;
	result = video_source_collection_is_video_offline (source);
#line 1088 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10421 "VideoSupport.c"
}


static MediaSourceHoldingTank*
video_source_collection_real_create_offline_bin (MediaSourceCollection* base)
{
	VideoSourceCollection * self;
	MediaSourceHoldingTank* result = NULL;
	MediaSourceHoldingTank* _tmp0_;
#line 1087 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1088 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_holding_tank_new (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), _video_source_collection_is_video_offline_source_holding_tank_check_to_keep, NULL, _video_source_collection_get_video_key_get_source_database_key, NULL);
#line 1088 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 1088 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10439 "VideoSupport.c"
}


static MediaMonitor*
video_source_collection_real_create_media_monitor (MediaSourceCollection* base,
                                                   Workers* workers,
                                                   GCancellable* cancellable)
{
	VideoSourceCollection * self;
	MediaMonitor* result = NULL;
	VideoMonitor* _tmp0_;
#line 1091 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1091 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_WORKERS (workers), NULL);
#line 1091 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_CANCELLABLE (cancellable), NULL);
#line 1092 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_monitor_new (cancellable);
#line 1092 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_MONITOR, MediaMonitor);
#line 1092 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10463 "VideoSupport.c"
}


static gboolean
video_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                   DataSource* source)
{
	VideoSourceCollection * self;
	gboolean result = FALSE;
#line 1095 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1095 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 1096 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (source, TYPE_VIDEO);
#line 1096 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10481 "VideoSupport.c"
}


static gchar*
video_source_collection_real_get_typename (MediaSourceCollection* base)
{
	VideoSourceCollection * self;
	gchar* result = NULL;
	gchar* _tmp0_;
#line 1099 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1100 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = g_strdup (VIDEO_TYPENAME);
#line 1100 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 1100 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10499 "VideoSupport.c"
}


static gboolean
video_source_collection_real_is_file_recognized (MediaSourceCollection* base,
                                                 GFile* file)
{
	VideoSourceCollection * self;
	gboolean result = FALSE;
#line 1103 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1103 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 1104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = video_reader_is_supported_video_file (file);
#line 1104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10517 "VideoSupport.c"
}


static void
video_source_collection_on_trashcan_contents_altered (VideoSourceCollection* self,
                                                      GeeCollection* added,
                                                      GeeCollection* removed)
{
#line 1107 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1107 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 1107 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 1109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "trashcan-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_COLLECTION, GeeCollection));
#line 10534 "VideoSupport.c"
}


static void
video_source_collection_on_offline_contents_altered (VideoSourceCollection* self,
                                                     GeeCollection* added,
                                                     GeeCollection* removed)
{
#line 1113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 1113 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 1115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "offline-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_COLLECTION, GeeCollection));
#line 10551 "VideoSupport.c"
}


static MediaSource*
video_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base,
                                                  gint64 numeric_id)
{
	VideoSourceCollection * self;
	MediaSource* result = NULL;
	VideoID _tmp0_ = {0};
	Video* _tmp1_;
#line 1119 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1120 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id_init (&_tmp0_, numeric_id);
#line 1120 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = video_source_collection_fetch (self, &_tmp0_);
#line 1120 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_MEDIA_SOURCE, MediaSource);
#line 1120 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10573 "VideoSupport.c"
}


gint64
video_source_collection_get_video_key (DataSource* source)
{
	gint64 result = 0LL;
	Video* video = NULL;
	Video* _tmp0_;
	VideoID video_id = {0};
	VideoID _tmp1_ = {0};
	VideoID _tmp2_;
	gint64 _tmp3_;
#line 1123 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0LL);
#line 1124 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_VIDEO, Video));
#line 1124 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video = _tmp0_;
#line 1125 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_get_video_id (video, &_tmp1_);
#line 1125 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id = _tmp1_;
#line 1127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video_id;
#line 1127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_.id;
#line 1127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp3_;
#line 1127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (video);
#line 1127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10607 "VideoSupport.c"
}


gboolean
video_source_collection_is_video_trashed (DataSource* source)
{
	gboolean result = FALSE;
#line 1130 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 1131 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = media_source_is_trashed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_VIDEO, Video), TYPE_MEDIA_SOURCE, MediaSource));
#line 1131 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10621 "VideoSupport.c"
}


gboolean
video_source_collection_is_video_offline (DataSource* source)
{
	gboolean result = FALSE;
#line 1134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 1135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = media_source_is_offline (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_VIDEO, Video), TYPE_MEDIA_SOURCE, MediaSource));
#line 1135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10635 "VideoSupport.c"
}


Video*
video_source_collection_fetch (VideoSourceCollection* self,
                               VideoID* video_id)
{
	Video* result = NULL;
	VideoID _tmp0_;
	gint64 _tmp1_;
	DataSource* _tmp2_;
#line 1138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_SOURCE_COLLECTION (self), NULL);
#line 1138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (video_id != NULL, NULL);
#line 1139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = *video_id;
#line 1139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_.id;
#line 1139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = database_source_collection_fetch_by_key (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), _tmp1_);
#line 1139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_VIDEO, Video);
#line 1139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10661 "VideoSupport.c"
}


static GeeCollection*
video_source_collection_real_get_event_source_ids (MediaSourceCollection* base,
                                                   EventID* event_id)
{
	VideoSourceCollection * self;
	GeeCollection* result = NULL;
	VideoTable* _tmp0_;
	VideoTable* _tmp1_;
	EventID _tmp2_;
	GeeArrayList* _tmp3_;
	GeeCollection* _tmp4_;
#line 1142 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1142 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (event_id != NULL, NULL);
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_table_get_instance ();
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = *event_id;
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_table_get_event_source_ids (_tmp1_, &_tmp2_);
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_database_table_unref0 (_tmp1_);
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp4_;
#line 1143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10696 "VideoSupport.c"
}


Video*
video_source_collection_get_state_by_file (VideoSourceCollection* self,
                                           GFile* file,
                                           VideoSourceCollectionState* state)
{
	VideoSourceCollectionState _vala_state = 0;
	Video* result = NULL;
	Video* video = NULL;
	MediaSource* _tmp0_;
	Video* _tmp1_;
	MediaSourceHoldingTank* _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
	MediaSource* _tmp4_;
	Video* _tmp5_;
	MediaSourceHoldingTank* _tmp6_;
	MediaSourceHoldingTank* _tmp7_;
	MediaSource* _tmp8_;
	Video* _tmp9_;
#line 1146 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_SOURCE_COLLECTION (self), NULL);
#line 1146 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 1147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_collection_fetch_by_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), file);
#line 1147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_VIDEO, Video);
#line 1148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = video;
#line 1148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_ != NULL) {
#line 1149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_ONLINE;
#line 1151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = video;
#line 1151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (state) {
#line 1151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*state = _vala_state;
#line 10738 "VideoSupport.c"
		}
#line 1151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 10742 "VideoSupport.c"
	}
#line 1154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 1154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = media_source_holding_tank_fetch_by_master_file (_tmp3_, file);
#line 1154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (video);
#line 1154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_VIDEO, Video);
#line 1154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_source_holding_tank_unref0 (_tmp3_);
#line 1155 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = video;
#line 1155 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp5_ != NULL) {
#line 1156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_TRASH;
#line 1158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = video;
#line 1158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (state) {
#line 1158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*state = _vala_state;
#line 10768 "VideoSupport.c"
		}
#line 1158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 10772 "VideoSupport.c"
	}
#line 1161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = _tmp6_;
#line 1161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = media_source_holding_tank_fetch_by_master_file (_tmp7_, file);
#line 1161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (video);
#line 1161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_VIDEO, Video);
#line 1161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_source_holding_tank_unref0 (_tmp7_);
#line 1162 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_ = video;
#line 1162 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp9_ != NULL) {
#line 1163 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_OFFLINE;
#line 1165 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = video;
#line 1165 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (state) {
#line 1165 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*state = _vala_state;
#line 10798 "VideoSupport.c"
		}
#line 1165 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 10802 "VideoSupport.c"
	}
#line 1168 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_state = VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN;
#line 1170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = NULL;
#line 1170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (video);
#line 1170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (state) {
#line 1170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*state = _vala_state;
#line 10814 "VideoSupport.c"
	}
#line 1170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10818 "VideoSupport.c"
}


static void
video_source_collection_compare_backing (VideoSourceCollection* self,
                                         Video* video,
                                         GFileInfo* info,
                                         GeeCollection* matching_master)
{
	GTimeVal _tmp0_ = {0};
	glong _tmp1_;
#line 1173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (video));
#line 1173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 1173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (GEE_IS_COLLECTION (matching_master));
#line 1174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (media_source_get_filesize (G_TYPE_CHECK_INSTANCE_CAST (video, TYPE_MEDIA_SOURCE, MediaSource)) != ((guint64) g_file_info_get_size (info))) {
#line 1175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 10842 "VideoSupport.c"
	}
#line 1177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_file_info_get_modification_time (info, &_tmp0_);
#line 1177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_.tv_sec;
#line 1177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (media_source_get_timestamp (G_TYPE_CHECK_INSTANCE_CAST (video, TYPE_MEDIA_SOURCE, MediaSource)) == ((time_t) _tmp1_)) {
#line 1178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		gee_collection_add (matching_master, video);
#line 10852 "VideoSupport.c"
	}
}


void
video_source_collection_fetch_by_matching_backing (VideoSourceCollection* self,
                                                   GFileInfo* info,
                                                   GeeCollection* matching_master)
{
#line 1181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 1181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (GEE_IS_COLLECTION (matching_master));
#line 10868 "VideoSupport.c"
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp0_;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = _tmp2_;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp1_);
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_object_it = _tmp3_;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		while (TRUE) {
#line 10889 "VideoSupport.c"
			GeeIterator* _tmp4_;
			DataObject* object = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			DataObject* _tmp7_;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _object_it;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				break;
#line 10901 "VideoSupport.c"
			}
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = _object_it;
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			object = (DataObject*) _tmp6_;
#line 1183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = object;
#line 1183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_source_collection_compare_backing (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_VIDEO, Video), info, matching_master);
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (object);
#line 10915 "VideoSupport.c"
		}
#line 1182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_object_it);
#line 10919 "VideoSupport.c"
	}
	{
		GeeIterator* _media_it = NULL;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = media_source_collection_get_offline_bin_contents (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = _tmp8_;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = _tmp10_;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp9_);
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_media_it = _tmp11_;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		while (TRUE) {
#line 10941 "VideoSupport.c"
			GeeIterator* _tmp12_;
			MediaSource* media = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			MediaSource* _tmp15_;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = _media_it;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (!gee_iterator_next (_tmp12_)) {
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				break;
#line 10953 "VideoSupport.c"
			}
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp13_ = _media_it;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			media = (MediaSource*) _tmp14_;
#line 1186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_ = media;
#line 1186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_source_collection_compare_backing (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_VIDEO, Video), info, matching_master);
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (media);
#line 10967 "VideoSupport.c"
		}
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_media_it);
#line 10971 "VideoSupport.c"
	}
}


static void
video_source_collection_real_notify_contents_altered (DataCollection* base,
                                                      GeeIterable* added,
                                                      GeeIterable* removed)
{
	VideoSourceCollection * self;
#line 1189 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1189 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_ITERABLE (added));
#line 1189 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_ITERABLE (removed));
#line 1191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (added != NULL) {
#line 10990 "VideoSupport.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp0_;
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp0_ = gee_iterable_iterator (added);
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_object_it = _tmp0_;
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			while (TRUE) {
#line 11000 "VideoSupport.c"
				GeeIterator* _tmp1_;
				DataObject* object = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				Video* video = NULL;
				DataObject* _tmp4_;
				Video* _tmp5_;
				GeeMultiMap* _tmp6_;
				Video* _tmp7_;
				guint64 _tmp8_;
				Video* _tmp9_;
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp1_ = _object_it;
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!gee_iterator_next (_tmp1_)) {
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					break;
#line 11018 "VideoSupport.c"
				}
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp2_ = _object_it;
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = gee_iterator_get (_tmp2_);
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				object = (DataObject*) _tmp3_;
#line 1193 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = object;
#line 1193 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_VIDEO, Video));
#line 1193 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video = _tmp5_;
#line 1195 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = self->priv->filesize_to_video;
#line 1195 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = video;
#line 1195 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = media_source_get_master_filesize (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1195 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = video;
#line 1195 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				gee_multi_map_set (_tmp6_, &_tmp8_, _tmp9_);
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (object);
#line 11046 "VideoSupport.c"
			}
#line 1192 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_object_it);
#line 11050 "VideoSupport.c"
		}
	}
#line 1199 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (removed != NULL) {
#line 11055 "VideoSupport.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp10_;
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = gee_iterable_iterator (removed);
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_object_it = _tmp10_;
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			while (TRUE) {
#line 11065 "VideoSupport.c"
				GeeIterator* _tmp11_;
				DataObject* object = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				Video* video = NULL;
				DataObject* _tmp14_;
				Video* _tmp15_;
				GeeMultiMap* _tmp16_;
				Video* _tmp17_;
				guint64 _tmp18_;
				Video* _tmp19_;
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = _object_it;
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!gee_iterator_next (_tmp11_)) {
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					break;
#line 11083 "VideoSupport.c"
				}
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = _object_it;
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = gee_iterator_get (_tmp12_);
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				object = (DataObject*) _tmp13_;
#line 1201 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = object;
#line 1201 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_VIDEO, Video));
#line 1201 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video = _tmp15_;
#line 1203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = self->priv->filesize_to_video;
#line 1203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = video;
#line 1203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = media_source_get_master_filesize (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp19_ = video;
#line 1203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				gee_multi_map_remove (_tmp16_, &_tmp18_, _tmp19_);
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (object);
#line 11111 "VideoSupport.c"
			}
#line 1200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_object_it);
#line 11115 "VideoSupport.c"
		}
	}
#line 1207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	DATA_COLLECTION_CLASS (video_source_collection_parent_class)->notify_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), TYPE_DATA_COLLECTION, DataCollection), added, removed);
#line 11120 "VideoSupport.c"
}


void
video_source_collection_get_basename_filesize_duplicate (VideoSourceCollection* self,
                                                         const gchar* basename,
                                                         guint64 filesize,
                                                         VideoID* result)
{
	VideoID _tmp15_ = {0};
#line 1210 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1210 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (basename != NULL);
#line 11135 "VideoSupport.c"
	{
		GeeIterator* _video_it = NULL;
		GeeMultiMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->filesize_to_video;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = gee_multi_map_get (_tmp0_, &filesize);
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _tmp1_;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = _tmp3_;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp2_);
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_it = _tmp4_;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		while (TRUE) {
#line 11159 "VideoSupport.c"
			GeeIterator* _tmp5_;
			Video* video = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Video* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = _video_it;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (!gee_iterator_next (_tmp5_)) {
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				break;
#line 11175 "VideoSupport.c"
			}
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = _video_it;
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video = (Video*) _tmp7_;
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = video;
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = _tmp9_;
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = g_file_get_basename (_tmp10_);
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = utf8_ci_compare (_tmp11_, basename) == 0;
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_tmp10_);
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp12_) {
#line 11197 "VideoSupport.c"
				Video* _tmp13_;
				VideoID _tmp14_ = {0};
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = video;
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_get_video_id (_tmp13_, &_tmp14_);
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				*result = _tmp14_;
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (_video_it);
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 11212 "VideoSupport.c"
			}
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (video);
#line 11216 "VideoSupport.c"
		}
#line 1211 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_video_it);
#line 11220 "VideoSupport.c"
	}
#line 1216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id_init (&_tmp15_, VIDEO_ID_INVALID);
#line 1216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	*result = _tmp15_;
#line 1216 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return;
#line 11228 "VideoSupport.c"
}


gboolean
video_source_collection_has_basename_filesize_duplicate (VideoSourceCollection* self,
                                                         const gchar* basename,
                                                         guint64 filesize)
{
	gboolean result = FALSE;
	VideoID _tmp0_ = {0};
#line 1220 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_SOURCE_COLLECTION (self), FALSE);
#line 1220 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (basename != NULL, FALSE);
#line 1221 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_source_collection_get_basename_filesize_duplicate (self, basename, filesize, &_tmp0_);
#line 1221 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = video_id_is_valid (&_tmp0_);
#line 1221 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 11249 "VideoSupport.c"
}


static TransactionController*
video_source_collection_real_get_transaction_controller (MediaSourceCollection* base)
{
	TransactionController* result;
	VideoSourceCollection* self;
	TransactionController* _tmp0_;
	TransactionController* _tmp2_;
#line 1064 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1065 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->_transaction_controller;
#line 1065 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ == NULL) {
#line 11266 "VideoSupport.c"
		MediaSourceTransactionController* _tmp1_;
#line 1066 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = media_source_transaction_controller_new (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1066 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_transaction_controller_unref0 (self->priv->_transaction_controller);
#line 1066 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		self->priv->_transaction_controller = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TRANSACTION_CONTROLLER, TransactionController);
#line 11274 "VideoSupport.c"
	}
#line 1068 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = self->priv->_transaction_controller;
#line 1068 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp2_;
#line 1068 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 11282 "VideoSupport.c"
}


static void
video_source_collection_class_init (VideoSourceCollectionClass * klass)
{
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_source_collection_parent_class = g_type_class_peek_parent (klass);
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataCollectionClass *) klass)->finalize = video_source_collection_finalize;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_type_class_add_private (klass, sizeof (VideoSourceCollectionPrivate));
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->create_trashcan = (MediaSourceHoldingTank* (*) (MediaSourceCollection *)) video_source_collection_real_create_trashcan;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->create_offline_bin = (MediaSourceHoldingTank* (*) (MediaSourceCollection *)) video_source_collection_real_create_offline_bin;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->create_media_monitor = (MediaMonitor* (*) (MediaSourceCollection *, Workers*, GCancellable*)) video_source_collection_real_create_media_monitor;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection *, DataSource*)) video_source_collection_real_holds_type_of_source;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->get_typename = (gchar* (*) (MediaSourceCollection *)) video_source_collection_real_get_typename;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->is_file_recognized = (gboolean (*) (MediaSourceCollection *, GFile*)) video_source_collection_real_is_file_recognized;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->fetch_by_numeric_id = (MediaSource* (*) (MediaSourceCollection *, gint64)) video_source_collection_real_fetch_by_numeric_id;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->get_event_source_ids = (GeeCollection* (*) (MediaSourceCollection *, EventID*)) video_source_collection_real_get_event_source_ids;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataCollectionClass *) klass)->notify_contents_altered = (void (*) (DataCollection *, GeeIterable*, GeeIterable*)) video_source_collection_real_notify_contents_altered;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	MEDIA_SOURCE_COLLECTION_CLASS (klass)->get_transaction_controller = video_source_collection_real_get_transaction_controller;
#line 11315 "VideoSupport.c"
}


static void
video_source_collection_instance_init (VideoSourceCollection * self)
{
	GeeTreeMultiMap* _tmp0_;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv = VIDEO_SOURCE_COLLECTION_GET_PRIVATE (self);
#line 1072 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->_transaction_controller = NULL;
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = gee_tree_multi_map_new (G_TYPE_UINT64, (GBoxedCopyFunc) _uint64_dup, (GDestroyNotify) g_free, TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _uint64_compare_gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->filesize_to_video = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
#line 11331 "VideoSupport.c"
}


static void
video_source_collection_finalize (DataCollection * obj)
{
	VideoSourceCollection * self;
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1072 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_transaction_controller_unref0 (self->priv->_transaction_controller);
#line 1073 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->filesize_to_video);
#line 1055 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	DATA_COLLECTION_CLASS (video_source_collection_parent_class)->finalize (obj);
#line 11347 "VideoSupport.c"
}


GType
video_source_collection_get_type (void)
{
	static volatile gsize video_source_collection_type_id__volatile = 0;
	if (g_once_init_enter (&video_source_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoSourceCollection), 0, (GInstanceInitFunc) video_source_collection_instance_init, NULL };
		GType video_source_collection_type_id;
		video_source_collection_type_id = g_type_register_static (TYPE_MEDIA_SOURCE_COLLECTION, "VideoSourceCollection", &g_define_type_info, 0);
		g_once_init_leave (&video_source_collection_type_id__volatile, video_source_collection_type_id);
	}
	return video_source_collection_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



