/*
 * Fast index for tag data, based on integer indexes
 *
 * Copyright (C) 2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <tagcoll/diskindex/int.h>

using namespace std;

namespace tagcoll {
namespace diskindex {

int IntIndexer::encodedSize() const
{
	// First the size of the offset array, plus all the array sizes
	int bufsize = size() * 2;
	
	// Then the size of all the arrays
	for (const_iterator i = begin(); i != end(); i++)
		bufsize += i->size();

	// Then the int with the number of items
	return bufsize * sizeof(int);
}

void IntIndexer::encode(char* cbuf) const
{
	int* buf = (int*)cbuf;
	int pos = size();
	for (size_t i = 0; i < size(); i++)
	{
		buf[i] = pos;
		buf[pos++] = (*this)[i].size();
		for (set<int>::const_iterator j = (*this)[i].begin(); j != (*this)[i].end(); j++)
			buf[pos++] = *j;
	}
}

}
}

// vim:set ts=4 sw=4:
