/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_OSTA.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfg_ostkAdd
su(bsystem): cmdline
ty(pe): L0H
sy(nopsis): 
sh(ort description): Insert a new output stack item into the output stack
he(ader files): 
lo(ng description): Creates a new output stack item and insert it before
	a specified item.\par
	If \tok{where == NULL}, the new item is inserted to the top of the
	output stack, thus, it becomes the active one.\newline
	All members are zero'ed out.
pr(erequistes): 
va(lue): pointer to the newly created item
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_osta.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <string.h>
#endif
#include <portable.h>
#include "dynstr.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_OSTA.C 1.4 1999/12/13 02:22:01 ska Exp ska $";
#endif

struct Cfg_oStackGetopt *cfg_ostkAdd(struct Cfg_Getopt * const optstru
	, struct Cfg_oStackGetopt * where)
{	struct Cfg_oStackGetopt *p;

	DBG_ENTER("cfg_ostkAdd", Suppl_cmdline)

	assert(optstru);

	chkHeap
	p = Ecalloc(sizeof(struct Cfg_oStackGetopt));
	if(!C(_oHead))				/* first and only item */
		C(_oHead) = p->C_nxt = p->C_prv = p;
	else {
		if(!where)
			where = C(_oHead);
		else if(where == C(_oHead))		/* changes the first item in ring */
			C(_oHead) = p;

		p->C_prv = where->C_prv;
		p->C_nxt = where;
		p->C_prv->C_nxt = where->C_prv = p;
	}

	chkHeap
	DBG_LEAVE( p)
}
