/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGARGB.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgArgBoolean(Cfg_Getopt * const optstru)

	Return the current argument in its native boolean format.
	Must not be called unless optArgType() returned CFG_TBOOLEAN.

	This function can only return true/false, but never switch or
	something like that.

	Return:
		if called when optArgType() != CFG_TBOOLEAN: undefined
		else: the integer value

ob(ject): cfgArgBoolean
su(bsystem): cmdline
sh(ort description): Return the current argument as boolean
lo(ng description): Returns the current argument in its native boolean
 format, either \em{true} or \em{false}, but never \em{switch}.
pr(erequistes): \item optstru != NULL \item optArgType() == CFG_TBOOLEAN
va(lue):  \em{undefined}: if called with optArgType() != CFG_TBOOLEAN
	\item else: integer value for \em{true} or \em{false}
re(lated to): cfgGetopt cfgGetoptInit cfgArgInteger
se(condary subsystems): inifile
fi(le): cfgargb.c
in(itialized by): cfgGetoptInit cfgGetopt

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGARGB.C 1.3 1999/12/13 02:22:08 ska Exp ska $";
#endif

int cfgArgBoolean(struct Cfg_Getopt * const optstru)
{	DBG_ENTER("cfgArgBoolean", Suppl_cmdline)
	assert(optstru);
	assert(optArgType() == CFG_TBOOLEAN);
	assert(S(argBooleanFct));

	DBG_RETURN_BI((S(argBooleanFct))(optstru))
}
