/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGARGS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	char *cfgArgString(Cfg_Getopt * const optstru)

	Return the current argument as string.
	Every type has a string representation, so this function can be
	called whatever value optArgType() returns. However, if it
	returns CFG_TERROR, this function returns NULL.

	Return:
		NULL: no argument
		else: the string represantation

ob(ject): cfgArgString
su(bsystem): cmdline
sh(ort description): Return the current argument as string
lo(ng description): Returns the current argument as '\0'-terminated
 string.
pr(erequistes): \item optstru != NULL
va(lue):  \tok{NULL}: if there is no argument at all
	\item else: pointer to a static buffer containing the string
re(lated to): cfgGetopt cfgGetoptInit cfgArgBoolean
se(condary subsystems): inifile
fi(le): cfgargs.c
in(itialized by): cfgGetoptInit cfgGetopt

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGARGS.C 1.3 1999/12/13 02:22:08 ska Exp ska $";
#endif

char *cfgArgString(struct Cfg_Getopt * const optstru)
{	DBG_ENTER("cfgArgString", Suppl_cmdline)
	assert(optstru);

	DBG_RETURN_BS((S(argStringFct))
		? (S(argStringFct))(optstru)
		: C(arg))
}
