/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGICBOI.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgCreateBooleanINI(char *name, int num)

ob(ject): cfgCreateBooleanINI
su(bsystem): inifile/1
sh(ort description):  Append a boolean value to the INI file
lo(ng description): Append a boolean value to the INI file currently opened for writing.
pr: \para{name} != NULL
re(lated to):
fi(le): cfgicboi.c
in(itialized by): cfgCreateINI cfgCreateSectionINI cfgEraseSection

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"
#include "msgs.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGICBOI.C 1.4 1999/12/13 02:22:17 ska Exp ska $";
#endif

int cfgCreateBooleanINI(const char * const name, int num)
{	DBG_ENTER("cfgCreateBooleanINI", Suppl_inifile1)
	DBG_ARGUMENTS( ("name\"%s\", value=%d", name, num) )
	DBG_RETURN_BI( cfgi_putValue(name, CFG_TBOOLEAN, num? CFG_TRUE: CFG_FALSE))
}
