/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

public class AutoFormattingTime {
    private final int width;
    private final int precision;
    double timeInSeconds;
    private final String formatString;

    public AutoFormattingTime(double timeInSeconds, int width, int precision) {
        this.width = width;
        this.timeInSeconds = timeInSeconds;
        this.precision = precision;
        this.formatString = "%" + width + "." + precision + "f %s";
    }

    public AutoFormattingTime(double timeInSeconds, int precision) {
        this(timeInSeconds, 6, precision);
    }

    public AutoFormattingTime(double timeInSeconds) {
        this(timeInSeconds, 1);
    }

    public double getTimeInSeconds() {
        return this.timeInSeconds;
    }

    public int getWidth() {
        return this.width;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String toString() {
        double unitTime = this.timeInSeconds;
        String unit = "s";
        if (this.timeInSeconds > 120.0) {
            unitTime = this.timeInSeconds / 60.0;
            unit = "m";
            if (unitTime > 120.0) {
                unitTime /= 60.0;
                unit = "h";
                if (unitTime > 100.0) {
                    unitTime /= 24.0;
                    unit = "d";
                    if (unitTime > 20.0) {
                        unitTime /= 7.0;
                        unit = "w";
                    }
                }
            }
        }
        return String.format(this.formatString, unitTime, unit);
    }
}

