/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;

public class LineNumberRangeFinder
implements LineNumberInfoVisitor {
    private int lowestLineNumber = Integer.MAX_VALUE;
    private int highestLineNumber = 0;
    private boolean hasSource;

    public int getLowestLineNumber() {
        return this.lowestLineNumber;
    }

    public int getHighestLineNumber() {
        return this.highestLineNumber;
    }

    public boolean hasSource() {
        return this.hasSource;
    }

    @Override
    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        int n = lineNumberInfo.u2lineNumber;
        if (this.lowestLineNumber > n) {
            this.lowestLineNumber = n;
        }
        if (this.highestLineNumber < n) {
            this.highestLineNumber = n;
        }
        if (lineNumberInfo.getSource() != null) {
            this.hasSource = true;
        }
    }
}

