#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 BetaRays
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Yume Nikki
# send your bug reports to contact@dotslashplay.it
###

script_version=20230103.1

GAME_ID='yume-nikki'
GAME_NAME='Yume Nikki'

## This archive is no longer available for sale from Playism store,
## as they are now only a Steam keys reseller.
ARCHIVE_BASE_0='YumeNikki_EN.zip'
ARCHIVE_BASE_0_MD5='fd1e659f777ad81bd61ebd6df573140e'
ARCHIVE_BASE_0_SIZE='66000'
ARCHIVE_BASE_0_VERSION='0.10a-playism'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
RPG_RT.*
Harmony.dll'
CONTENT_GAME_DATA_FILES='
Map*.lmu
Backdrop
Battle
Battle2
BattleCharSet
BattleWeapon
CharSet
ChipSet
FaceSet
Frame
GameOver
Monster
Movie
Music
Panorama
Picture
Sound
System
System2
Title'
CONTENT_DOC_DATA_PATH='YumeNikki_EN'
CONTENT_DOC_DATA_FILES='
*.txt'

APP_MAIN_EXE='RPG_RT.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Japanese fonts and locales are required

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Japanese locale is required for correct fonts display
export LC_ALL=ja_JP.UTF-8'
PKG_BIN_DEPS_DEB='fonts-wqy-microhei'
PKG_BIN_DEPS_ARCH='wqy-microhei'
PKG_BIN_DEPS_GENTOO='media-fonts/wqy-microhei'

# Add required dependency for the extration of the inner .lzh archive

SCRIPT_DEPS="$SCRIPT_DEPS lha"

# Add required dependencies for tweaking the encoding of file names and contents

SCRIPT_DEPS="$SCRIPT_DEPS iconv convmv"

# Load common functions

target_version='2.20'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
INNER_ARCHIVE="${PLAYIT_WORKDIR}/gamedata/YumeNikki_EN/YumeNikki.lzh"
INNER_ARCHIVE_TYPE='lha'
archive_extraction 'INNER_ARCHIVE'
rm "$INNER_ARCHIVE"
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Convert the files names to UTF-8 encoding
	encoding_source='SHIFT-JIS'
	encoding_target='UTF-8'
	convmv_options="--notest -f $encoding_source -t $encoding_target"
	find "${PLAYIT_WORKDIR}/gamedata" -exec \
		convmv $convmv_options {} + >/dev/null 2>/dev/null
	
	# Fix Windows-style paths
	sed --in-place 's/¥/\\/g' 'YumeNikki_EN/YumeNikkiREADME.txt'

	# Convert the text files contents to UTF-8 encoding
	shell_command='contents=$(iconv --from-code CP932 --to-code UTF-8 "$1")'
	shell_command="$shell_command"'; printf "%s" "$contents" > "$1"'
	find 'YumeNikki_EN' -name '*.txt' -exec \
		sh -c "$shell_command" -- '{}' \;
)

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
