!{\src2tex{textfont=tt}}
!!****f* ABINIT/wrscr
!! NAME
!! wrscr
!!
!! FUNCTION
!! Write screening (epsilon-twiddle^-1) on file _SCR
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, R. Shaltaf)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtfil=file names (only dtfil%filnam_ds(4) is used)
!!  epsm1(npwsigx,npwsigx,nomega)=screening matrix, for different frequencies, at q point iq
!!  gvec(3,npwsigx)=coordinates of G vectors
!!  hdr=header of the file to be written
!!  iq=index of q point of epsm1 to be written
!!  nbnds=number of bands
!!  nomega=number of frequencies
!!  npwsigx=number of plane waves for sigx (input variable)
!!  npwwfn=number of plane waves for wfn (input variable)
!!  nq=number of q points
!!  omega(nomega)=set of frequencies
!!  q(3,nq)=coordinates of q points
!!  title(2)=title (to be described)
!!  unitnum(optional parameter) it gives the file unit number,needed
!!  only if called from mrgscr
!!
!! OUTPUT
!!  (only writing of file)
!!
!! PARENTS
!!      mrgscr,screening
!!
!! CHILDREN
!!      hdr_io,hdr_io_netcdf
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine wrscr(dtfil,hdr,dtset,npwsigx,npwwfn,npwmax,nbnds,nq,nomega,q,omega,&
& gvec,iq,epsm1,title,unitnum,nop,op)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_13io_mpi
#else
 use defs_interfaces, except_this_one => wrscr
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iq,nbnds,nomega,nop,npwmax,npwsigx,npwwfn,nq
 integer,intent(in),optional :: unitnum
 type(datafiles_type),intent(in) :: dtfil
 type(dataset_type),intent(in) :: dtset
 type(hdr_type),intent(inout) :: hdr
!arrays
 integer,intent(in) :: gvec(3,npwmax)
 real(dp) :: op(3,3,nop)
 real(dp),intent(in) :: q(3,nq)
 complex,intent(in) :: epsm1(npwsigx,npwsigx,nomega),omega(nomega)
 character(len=80),intent(in) :: title(2)

!Local variables-------------------------------
!scalars
 integer,parameter :: unitem1=24
 integer :: bantot,date,fform=1002,intxc,io,istat,ixc,natom,nkpt,npwvec,nq_temp
 integer :: nspden,nspinor,nsppol,nsym,rdwr,readnetcdf,unitnu
 character(len=500) :: message
 character(len=fnlen) :: filscr
!arrays
 integer :: ngfft(3)
 real(dp) :: qdiff(3)
 real(dp),allocatable :: qd_temp(:,:)
!no_abirules
 complex (kind(0.0_dp)),allocatable :: epsm1d(:,:),omegad(:)
 logical :: found, partial

! *************************************************************************

!DEBUG
!write(6,*)' wrscr : enter '
!ENDDEBUG

 allocate(epsm1d(npwsigx,npwsigx),omegad(nomega),stat=istat)
 if(istat/=0) then 
  write(message,'(a)')' wrscr: out of memory in epsm1d' 
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if 

 if(unitnum>0)then
  unitnu=unitnum
 else
  unitnu=unitem1
 end if

 partial=.false.
 if(dtset%nqptdm>0.and.dtset%nqptdm<nq)then
  partial=.true.
 end if

!the header of SCR should be written if iq=1 or if iq is equivalent to
!the first element of qptdm

 found=.false.
! added by RShaltaf 07/06/06
!  write(*,*)hdr%nsym,int(hdr%symrel)
!  write(*,*)nop,int(op)
  hdr%nsym=nop
  hdr%symrel(:,:,1:nop)=op(:,:,1:nop)

 if(partial)then
  qdiff(:)=q(:,iq)-dtset%qptdm(:,1)
  if(all(abs(qdiff(:))<1.0e-3))found=.true.
 end if

 if(iq==1.or.found) then

  if(partial)then
   nq_temp=dtset%nqptdm
   allocate(qd_temp(3,nq_temp))
   !PMA problem under gfortran in t87 v3
   !qd_temp(:,:)=dtset%qptdm(:,:)
   qd_temp(:,1:min(dtset%nqptdm,size(dtset%qptdm,2)))=dtset%qptdm(:,1:min(dtset%nqptdm,size(dtset%qptdm,2)))
  else
   nq_temp=nq
   allocate(qd_temp(3,nq))
   qd_temp(:,:)=q(:,:)
  end if

  filscr=trim(dtfil%filnam_ds(4))//'_SCR'

  open(unit=unitnu,file=filscr,status='unknown',form='unformatted')
  ! open(unit=66,status='unknown',form='unformatted')
  !write the header of the SCR file
  rdwr=2
  readnetcdf = 0 ! should make EM1 also a netcdf file
  if (readnetcdf == 0) then
   call hdr_io(fform,hdr,rdwr,unitnu)
  else if (readnetcdf == 1) then
   call hdr_io_netcdf(fform,hdr,rdwr,unitnu)
  end if
  write(unitnu) title
  write(unitnu) npwsigx,npwwfn,nbnds,nq_temp,nomega
!! in case of writing partail screening file, one has to write the g array for the biggest among npwsigx and npwwfn
!! this is nessecery  to be able to calculate the FFT mesh correctly in mrgscr
!! this should not be a problem as the partial screenig file
!! will be only input ONLY for the mrgscr code, the output of mrgscr
!! will have the correct format for ABINIT

   npwvec=npwsigx ! default for full files

  if(partial)then
   npwvec=npwmax ! default for partial
  end if

  write(unitnu) gvec(1:3,1:npwvec)

  omegad(:) = omega(:)
  !WARNING: nq may be different from nq_temp which is the actual size of
  ! qd_temp.
  write(unitnu) qd_temp(1:3,1:nq_temp)
  write(unitnu) omegad(1:nomega)
  deallocate(qd_temp)
 end if

!write a record for each q and each omega
 do io=1,nomega
  epsm1d(:,:) = epsm1(:,:,io)
  write(unitnu) epsm1d(1:npwsigx,1:npwsigx)
 end do

 if(iq==nq) close(unitnu)

 deallocate(epsm1d,omegad)

end subroutine wrscr
!!***
