# -*- coding: utf-8 -*-
#   thanks to Dave Arter <davea@sucs.org>
#   Copyright (c) 2005 Dave Arter

import os
import sys
import gtk

from APTonCD.core.utils import get_icon
from APTonCD.core import utils
from APTonCD.widgets.progresswindow import ProgressDialog
from APTonCD.core.gui import processEvents
from APTonCD.core import constants

class Files:
    
    def __init__(self, Source = None, Destination = None):
        self.source = Source
        self.destination = Destination
        
    def set_source(self, filename): self.source = filename
    def get_source(self): return self.source
    Source = property(fget = get_source, fset = set_source)
    
    def set_destination(self, filename): self.destination = filename
    def get_destination(self): return self.destination
    Destination = property(fget = get_destination, fset = set_destination)
    
    
class RestoreFiles:

    def __init__(self,xid = None, script_location = None ):
        
        self.files = []
        self.window_by_id = gtk.gdk.window_foreign_new(int(xid))
        self.script = script_location
        self.process_files()
        self.progress = ProgressDialog(self.window_by_id)
        self.progress.can_cancel_progress = False
        self.progress.title = constants.MESSAGE_0073
        self.progress.description = constants.MESSAGE_0074
        self.progress.stop = len(self.files)
        self.progress.show()
        self.restore_files()
        self.progress.destroy()
        
    def process_files(self):
        ifile = open(self.script,'r')

        for n in ifile.readlines():
            copy_list = n.split('|')
            self.files.append(Files(copy_list[0],copy_list[1]))
        
    def restore_files(self):
        index = 0
        for n in self.files:
            self.progress.update_progress(index + 1)
            os.system('cp %s %s' % (n.Source, n.Destination))
            index += 1
            processEvents()

if __name__ == '__main__':
    
    restore = RestoreFiles(sys.argv[1], sys.argv[2])
    sys.exit(1)
