// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __path_iterator__
#define __path_iterator__

// A path iterator is used to iterate the contents of the paths
// a project is managing. But only files matching a given pattern 
// are iterated. 

#include "Puma/Filename.h"
#include <list>
#include <string>

#include "ProjectFile.h"

namespace Puma {

class PathManager;
class RegComp;
 
class PathIterator {
  friend class PathManager;

  RegComp *_regexp;  // Search pattern.
  std::list<std::string> _files;
  std::list<std::string>::const_iterator _iter;
  std::string _current;

public:
  PathIterator (const char *);     // Expects a regular expression.
  ~PathIterator ();                // for the files to match.

  // Set the search pattern.
  void pattern (const char *);

  // retrieve information about the currently referenced ProjectFile
  const char *file () const;
};

} // namespace Puma

#endif /* __path_iterator__ */
