/**
* Copyright 1981-2012 ECMWF.
*
* This software is licensed under the terms of the Apache Licence 
* Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
*
* In applying this licence, ECMWF does not waive the privileges and immunities 
* granted to it by virtue of its status as an intergovernmental organisation 
* nor does it submit to any jurisdiction.
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>

#define IA_CONT 00001

#ifndef CRAY
#ifdef FORTRAN_NO_UNDERSCORE
#define MY_IALLOC my_ialloc 
#else
#define MY_IALLOC my_ialloc_
#endif
#endif

void MY_IALLOC( FILE ** kunit, long * isize, long * kret)
{
#ifdef CRAY
int fdesc;
int status;
#endif

    *kret = 0;
#ifdef CRAY
    fdesc = fileno( *kunit);
    status = ialloc( fdesc, *isize, IA_CONT, 0);
    if ( status == -1 ) *kret = 1;
#endif
    return;

}
