/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.bounce.DummyIcon;

public class MenuUtilities {
    public static void alignMenu(JMenu menu) {
        MenuUtilities.alignComponents(menu.getMenuComponents());
    }

    public static void alignMenu(JPopupMenu menu) {
        MenuUtilities.alignComponents(menu.getComponents());
    }

    private static void alignComponents(Component[] components) {
        Dimension size = new Dimension(0, 0);
        if (UIManager.getLookAndFeel().getName().toLowerCase().indexOf("windows") == -1) {
            Insets margin = null;
            Icon check = null;
            EmptyBorder border = null;
            for (Component component : components) {
                if (component instanceof JMenuItem) {
                    if (component instanceof JCheckBoxMenuItem || component instanceof JRadioButtonMenuItem && check == null) {
                        margin = ((JMenuItem)component).getMargin();
                        check = UIManager.getIcon("CheckBoxMenuItem.checkIcon");
                    }
                    MenuUtilities.updateSize((JMenuItem)component, size);
                    continue;
                }
                if (!(component instanceof JMenu)) continue;
                MenuUtilities.updateSize((JMenuItem)component, size);
            }
            if (check != null && margin != null) {
                border = new EmptyBorder(margin.top, margin.left + check.getIconWidth(), margin.bottom, margin.right);
            }
            for (Component component : components) {
                if (component instanceof JMenuItem) {
                    if (component instanceof JCheckBoxMenuItem || component instanceof JRadioButtonMenuItem) {
                        MenuUtilities.alignCheck((JMenuItem)component, size, null);
                        continue;
                    }
                    MenuUtilities.align((JMenuItem)component, size, border);
                    continue;
                }
                if (!(component instanceof JMenu)) continue;
                MenuUtilities.align((JMenu)component, size, border);
            }
        } else {
            for (Component component : components) {
                if (component instanceof JMenuItem) {
                    MenuUtilities.updateSize((JMenuItem)component, size);
                    continue;
                }
                if (!(component instanceof JMenu)) continue;
                MenuUtilities.updateSize((JMenu)component, size);
            }
            for (Component component : components) {
                if (component instanceof JMenuItem) {
                    if (component instanceof JRadioButtonMenuItem) {
                        MenuUtilities.alignCheck((JMenuItem)component, size, new EmptyBorder(2, 5, 2, 2));
                        continue;
                    }
                    if (component instanceof JCheckBoxMenuItem) {
                        MenuUtilities.alignCheck((JMenuItem)component, size, null);
                        continue;
                    }
                    MenuUtilities.align((JMenuItem)component, size, null);
                    continue;
                }
                if (!(component instanceof JMenu)) continue;
                MenuUtilities.align((JMenu)component, size, null);
            }
        }
    }

    private static void alignCheck(JMenuItem item, Dimension size, Border border) {
        Icon icon = item.getIcon();
        if (border != null) {
            item.setBorder(border);
        }
        if (icon != null && icon.getIconWidth() < size.width) {
            item.setIconTextGap(item.getIconTextGap() + (size.width - icon.getIconWidth()) / 2);
        } else if (icon == null) {
            item.setIcon(new DummyIcon(size));
        }
    }

    private static void align(AbstractButton button, Dimension size, Border border) {
        Icon icon = button.getIcon();
        if (border != null) {
            button.setBorder(border);
        }
        if (icon != null && icon.getIconWidth() < size.width) {
            Insets insets = button.getMargin();
            button.setBorder(new EmptyBorder(insets.top, insets.left + (size.width - icon.getIconWidth()), insets.bottom, insets.right));
        } else if (icon == null) {
            button.setIcon(new DummyIcon(size));
        }
    }

    private static void updateSize(AbstractButton button, Dimension size) {
        Icon icon = button.getIcon();
        if (icon != null) {
            size.width = Math.max(size.width, icon.getIconWidth());
            size.height = Math.max(size.height, icon.getIconHeight());
        }
    }
}

