/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.icc.lut;

import ucar.jpeg.colorspace.ColorSpace;
import ucar.jpeg.icc.RestrictedICCProfile;
import ucar.jpeg.icc.lut.LookUpTableFP;
import ucar.jpeg.icc.lut.MonochromeTransformException;
import ucar.jpeg.jj2000.j2k.image.DataBlkFloat;
import ucar.jpeg.jj2000.j2k.image.DataBlkInt;

public class MonochromeTransformTosRGB {
    private static final String eol = System.getProperty("line.separator");
    public static final double ksRGBShadowCutoff = 0.0031308;
    public static final double ksRGBShadowSlope = 12.92;
    public static final double ksRGB8ShadowSlope = 3294.6;
    public static final double ksRGBExponent = 0.4166666666666667;
    public static final double ksRGB8ScaleAfterExp = 269.025;
    public static final double ksRGB8ReduceAfterExp = 14.025;
    private short[] lut = null;
    private int dwInputMaxValue = 0;
    private LookUpTableFP fLut = null;

    public String toString() {
        StringBuffer rep = new StringBuffer("[MonochromeTransformTosRGB ");
        StringBuffer body = new StringBuffer("  ");
        body.append(eol).append("ksRGBShadowSlope= ").append(String.valueOf(12.92));
        body.append(eol).append("ksRGBShadowCutoff= ").append(String.valueOf(0.0031308));
        body.append(eol).append("ksRGBShadowSlope= ").append(String.valueOf(12.92));
        body.append(eol).append("ksRGB8ShadowSlope= ").append(String.valueOf(3294.6));
        body.append(eol).append("ksRGBExponent= ").append(String.valueOf(0.4166666666666667));
        body.append(eol).append("ksRGB8ScaleAfterExp= ").append(String.valueOf(269.025));
        body.append(eol).append("ksRGB8ReduceAfterExp= ").append(String.valueOf(14.025));
        body.append(eol).append("dwInputMaxValue= ").append(String.valueOf(this.dwInputMaxValue));
        body.append(eol).append("[lut = [short[" + this.lut.length + "]]]");
        body.append(eol).append("fLut=  " + this.fLut.toString());
        rep.append(ColorSpace.indent("  ", body));
        return rep.append("]").toString();
    }

    public MonochromeTransformTosRGB(RestrictedICCProfile ricc, int dwInputMaxValue, int dwInputShiftValue) {
        int i;
        if (ricc.getType() != 0) {
            throw new IllegalArgumentException("MonochromeTransformTosRGB: wrong type ICCProfile supplied");
        }
        this.dwInputMaxValue = dwInputMaxValue;
        this.lut = new short[dwInputMaxValue + 1];
        this.fLut = LookUpTableFP.createInstance(ricc.trc[0], dwInputMaxValue + 1);
        for (i = 0; i <= dwInputMaxValue && (double)this.fLut.lut[i] <= 0.0031308; ++i) {
            this.lut[i] = (short)(Math.floor(3294.6 * (double)this.fLut.lut[i] + 0.5) - (double)dwInputShiftValue);
        }
        while (i <= dwInputMaxValue) {
            this.lut[i] = (short)(Math.floor(269.025 * Math.pow(this.fLut.lut[i], 0.4166666666666667) - 14.025 + 0.5) - (double)dwInputShiftValue);
            ++i;
        }
    }

    public void apply(DataBlkInt inb, DataBlkInt outb) throws MonochromeTransformException {
        int[] in = (int[])inb.getData();
        int[] out = (int[])outb.getData();
        if (out == null || out.length < in.length) {
            out = new int[in.length];
            outb.setData(out);
        }
        outb.uly = inb.uly;
        outb.ulx = inb.ulx;
        outb.h = inb.h;
        outb.w = inb.w;
        outb.offset = inb.offset;
        outb.scanw = inb.scanw;
        int o = inb.offset;
        for (int i = 0; i < inb.h * inb.w; ++i) {
            int j = in[i];
            if (j < 0) {
                j = 0;
            } else if (j > this.dwInputMaxValue) {
                j = this.dwInputMaxValue;
            }
            out[i] = this.lut[j];
        }
    }

    public void apply(DataBlkFloat inb, DataBlkFloat outb) throws MonochromeTransformException {
        float[] in = (float[])inb.getData();
        float[] out = (float[])outb.getData();
        if (out == null || out.length < in.length) {
            out = new float[in.length];
            outb.setData(out);
            outb.uly = inb.uly;
            outb.ulx = inb.ulx;
            outb.h = inb.h;
            outb.w = inb.w;
            outb.offset = inb.offset;
            outb.scanw = inb.scanw;
        }
        int o = inb.offset;
        for (int i = 0; i < inb.h * inb.w; ++i) {
            int j = (int)in[i];
            if (j < 0) {
                j = 0;
            } else if (j > this.dwInputMaxValue) {
                j = this.dwInputMaxValue;
            }
            out[i] = this.lut[j];
        }
    }
}

