/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.icc.types;

import java.io.IOException;
import java.io.RandomAccessFile;
import ucar.jpeg.icc.ICCProfile;
import ucar.jpeg.icc.types.ICCDateTime;
import ucar.jpeg.icc.types.ICCProfileVersion;
import ucar.jpeg.icc.types.XYZNumber;

public class ICCProfileHeader {
    private static final String eol = System.getProperty("line.separator");
    private byte[] header = null;
    public static int kdwProfileSignature = ICCProfile.getInt(new String("acsp").getBytes(), 0);
    public static int kdwProfileSigReverse = ICCProfile.getInt(new String("psca").getBytes(), 0);
    private static final String kdwInputProfile = "scnr";
    private static final String kdwDisplayProfile = "mntr";
    private static final String kdwRGBData = "RGB ";
    private static final String kdwGrayData = "GRAY";
    private static final String kdwXYZData = "XYZ ";
    private static final String kdwGrayTRCTag = "kTRC";
    private static final String kdwRedColorantTag = "rXYZ";
    private static final String kdwGreenColorantTag = "gXYZ";
    private static final String kdwBlueColorantTag = "bXYZ";
    private static final String kdwRedTRCTag = "rTRC";
    private static final String kdwGreenTRCTag = "gTRC";
    private static final String kdwBlueTRCTag = "bTRC";
    private static final int offProfileSize = 0;
    private static final int offCMMTypeSignature = 4;
    private static final int offProfileVersion = 8;
    private static final int offProfileClass = 12;
    private static final int offColorSpaceType = 16;
    private static final int offPCSType = 20;
    private static final int offDateTime = 24;
    private static final int offProfileSignature = 36;
    private static final int offPlatformSignature = 40;
    private static final int offCMMFlags = 44;
    private static final int offDeviceManufacturer = 48;
    private static final int offDeviceModel = 52;
    private static final int offDeviceAttributes1 = 56;
    private static final int offDeviceAttributesReserved = 60;
    private static final int offRenderingIntent = 64;
    private static final int offPCSIlluminant = 68;
    private static final int offCreatorSig = 80;
    private static final int offReserved = 84;
    public static final int size = 128;
    public int dwProfileSize;
    public int dwCMMTypeSignature;
    public int dwProfileClass;
    public int dwColorSpaceType;
    public int dwPCSType;
    public int dwProfileSignature;
    public int dwPlatformSignature;
    public int dwCMMFlags;
    public int dwDeviceManufacturer;
    public int dwDeviceModel;
    public int dwDeviceAttributes1;
    public int dwDeviceAttributesReserved;
    public int dwRenderingIntent;
    public int dwCreatorSig;
    public byte[] reserved = new byte[44];
    public ICCProfileVersion profileVersion;
    public ICCDateTime dateTime;
    public XYZNumber PCSIlluminant;

    public ICCProfileHeader() {
    }

    public ICCProfileHeader(byte[] data) {
        this.dwProfileSize = ICCProfile.getInt(data, 0);
        this.dwCMMTypeSignature = ICCProfile.getInt(data, 4);
        this.dwProfileClass = ICCProfile.getInt(data, 12);
        this.dwColorSpaceType = ICCProfile.getInt(data, 16);
        this.dwPCSType = ICCProfile.getInt(data, 20);
        this.dwProfileSignature = ICCProfile.getInt(data, 36);
        this.dwPlatformSignature = ICCProfile.getInt(data, 40);
        this.dwCMMFlags = ICCProfile.getInt(data, 44);
        this.dwDeviceManufacturer = ICCProfile.getInt(data, 48);
        this.dwDeviceModel = ICCProfile.getInt(data, 52);
        this.dwDeviceAttributes1 = ICCProfile.getInt(data, 60);
        this.dwDeviceAttributesReserved = ICCProfile.getInt(data, 60);
        this.dwRenderingIntent = ICCProfile.getInt(data, 64);
        this.dwCreatorSig = ICCProfile.getInt(data, 80);
        this.profileVersion = ICCProfile.getICCProfileVersion(data, 8);
        this.dateTime = ICCProfile.getICCDateTime(data, 24);
        this.PCSIlluminant = ICCProfile.getXYZNumber(data, 68);
        for (int i = 0; i < this.reserved.length; ++i) {
            this.reserved[i] = data[84 + i];
        }
    }

    public void write(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        raf.write(this.dwProfileSize);
        raf.seek(4L);
        raf.write(this.dwCMMTypeSignature);
        raf.seek(8L);
        this.profileVersion.write(raf);
        raf.seek(12L);
        raf.write(this.dwProfileClass);
        raf.seek(16L);
        raf.write(this.dwColorSpaceType);
        raf.seek(20L);
        raf.write(this.dwPCSType);
        raf.seek(24L);
        this.dateTime.write(raf);
        raf.seek(36L);
        raf.write(this.dwProfileSignature);
        raf.seek(40L);
        raf.write(this.dwPlatformSignature);
        raf.seek(44L);
        raf.write(this.dwCMMFlags);
        raf.seek(48L);
        raf.write(this.dwDeviceManufacturer);
        raf.seek(52L);
        raf.write(this.dwDeviceModel);
        raf.seek(56L);
        raf.write(this.dwDeviceAttributes1);
        raf.seek(60L);
        raf.write(this.dwDeviceAttributesReserved);
        raf.seek(64L);
        raf.write(this.dwRenderingIntent);
        raf.seek(68L);
        this.PCSIlluminant.write(raf);
        raf.seek(80L);
        raf.write(this.dwCreatorSig);
        raf.seek(84L);
        raf.write(this.reserved);
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("[ICCProfileHeader: ");
        rep.append(eol + "         ProfileSize: " + Integer.toHexString(this.dwProfileSize));
        rep.append(eol + "    CMMTypeSignature: " + Integer.toHexString(this.dwCMMTypeSignature));
        rep.append(eol + "        ProfileClass: " + Integer.toHexString(this.dwProfileClass));
        rep.append(eol + "      ColorSpaceType: " + Integer.toHexString(this.dwColorSpaceType));
        rep.append(eol + "           dwPCSType: " + Integer.toHexString(this.dwPCSType));
        rep.append(eol + "  dwProfileSignature: " + Integer.toHexString(this.dwProfileSignature));
        rep.append(eol + " dwPlatformSignature: " + Integer.toHexString(this.dwPlatformSignature));
        rep.append(eol + "          dwCMMFlags: " + Integer.toHexString(this.dwCMMFlags));
        rep.append(eol + "dwDeviceManufacturer: " + Integer.toHexString(this.dwDeviceManufacturer));
        rep.append(eol + "       dwDeviceModel: " + Integer.toHexString(this.dwDeviceModel));
        rep.append(eol + " dwDeviceAttributes1: " + Integer.toHexString(this.dwDeviceAttributes1));
        rep.append(eol + "   dwRenderingIntent: " + Integer.toHexString(this.dwRenderingIntent));
        rep.append(eol + "        dwCreatorSig: " + Integer.toHexString(this.dwCreatorSig));
        rep.append(eol + "      profileVersion: " + this.profileVersion);
        rep.append(eol + "            dateTime: " + this.dateTime);
        rep.append(eol + "       PCSIlluminant: " + this.PCSIlluminant);
        return rep.append("]").toString();
    }
}

