/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import ucar.nc2.NetcdfFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumTypedef {
    private String name;
    private Map<Integer, String> map;

    public EnumTypedef(String name, Map<Integer, String> map) {
        this.name = name;
        this.map = map;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.name;
    }

    public List<String> getEnumStrings() {
        return new ArrayList<String>(this.map.values());
    }

    public String lookupEnumString(int e) {
        String result = this.map.get(e);
        return result == null ? "Unknown enum value= " + e : result;
    }

    public String writeCDL(boolean strict) {
        StringBuilder buff = new StringBuilder();
        String name = strict ? NetcdfFile.escapeName(this.getName()) : this.getName();
        buff.append("  enum ").append(name).append(" { ");
        int count = 0;
        List<Object> keyset = Arrays.asList(this.map.keySet().toArray());
        for (Object key : keyset) {
            String s = this.map.get(key);
            if (0 < count++) {
                buff.append(", ");
            }
            if (strict) {
                buff.append(NetcdfFile.escapeName(s)).append(" = ").append(key);
                continue;
            }
            buff.append("'").append(s).append("' = ").append(key);
        }
        buff.append("};");
        return buff.toString();
    }
}

