/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import ucar.netcdf.RandomAccessFile;
import visad.DataImpl;
import visad.VisADException;
import visad.data.visad.BinaryFile;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryFieldImpl;
import visad.data.visad.object.BinaryFlatField;
import visad.data.visad.object.BinaryGriddedDoubleSet;
import visad.data.visad.object.BinaryGriddedSet;
import visad.data.visad.object.BinaryIntegerSet;
import visad.data.visad.object.BinaryIrregularSet;
import visad.data.visad.object.BinaryLinearSet;
import visad.data.visad.object.BinaryList1DSet;
import visad.data.visad.object.BinaryMathType;
import visad.data.visad.object.BinaryProductSet;
import visad.data.visad.object.BinaryReal;
import visad.data.visad.object.BinaryRealTuple;
import visad.data.visad.object.BinarySerializedObject;
import visad.data.visad.object.BinarySimpleSet;
import visad.data.visad.object.BinarySingletonSet;
import visad.data.visad.object.BinaryText;
import visad.data.visad.object.BinaryTuple;
import visad.data.visad.object.BinaryUnionSet;
import visad.data.visad.object.BinaryUnit;

public class BinaryReader
implements BinaryFile {
    private DataInput file;
    private boolean isRandom;
    private int version;
    private BinaryObjectCache unitCache;
    private BinaryObjectCache errorCache;
    private BinaryObjectCache cSysCache;
    private BinaryObjectCache typeCache;

    public BinaryReader(String name) throws IOException {
        this(new File(name));
    }

    public BinaryReader(File ref) throws IOException {
        this(new FileInputStream(ref));
    }

    public BinaryReader(InputStream stream) throws IOException {
        this.file = new DataInputStream(new BufferedInputStream(stream));
        this.isRandom = false;
        this.version = this.checkMagic(this.file);
        this.unitCache = new BinaryObjectCache();
        this.errorCache = new BinaryObjectCache();
        this.cSysCache = new BinaryObjectCache();
        this.typeCache = new BinaryObjectCache();
    }

    public BinaryReader(java.io.RandomAccessFile raf) throws IOException {
        this.file = raf;
        this.isRandom = true;
        this.version = this.checkMagic(this.file);
        this.unitCache = new BinaryObjectCache();
        this.errorCache = new BinaryObjectCache();
        this.cSysCache = new BinaryObjectCache();
        this.typeCache = new BinaryObjectCache();
    }

    public BinaryReader(RandomAccessFile raf) throws IOException {
        this.file = raf;
        this.isRandom = true;
        this.version = this.checkMagic(this.file);
        this.unitCache = new BinaryObjectCache();
        this.errorCache = new BinaryObjectCache();
        this.cSysCache = new BinaryObjectCache();
        this.typeCache = new BinaryObjectCache();
    }

    private int checkMagic(DataInput file) throws IOException {
        int version = BinaryReader.readMagic(file);
        if (version < 1) {
            throw new IOException("File is not in VisAD binary format");
        }
        if (version > 1) {
            throw new IOException("Don't understand VisAD Binary format version " + version);
        }
        return version;
    }

    public void close() throws IOException {
        if (this.file instanceof InputStream) {
            ((InputStream)((Object)this.file)).close();
        } else if (this.file instanceof java.io.RandomAccessFile) {
            ((java.io.RandomAccessFile)this.file).close();
        } else if (this.file instanceof RandomAccessFile) {
            ((RandomAccessFile)this.file).close();
        } else {
            throw new IOException("Unknown file class \"" + this.file.getClass().getName() + "\"");
        }
    }

    public DataImpl getData() throws IOException, VisADException {
        long uTime = 0L;
        long mTime = 0L;
        long eTime = 0L;
        long dsTime = 0L;
        long dTime = 0L;
        long csTime = 0L;
        long totStart = 0L;
        totStart = System.currentTimeMillis();
        DataImpl data = null;
        block10: while (data == null) {
            byte directive;
            try {
                directive = this.file.readByte();
            }
            catch (EOFException eofe) {
                break;
            }
            long tmpStart = System.currentTimeMillis();
            switch (directive) {
                case 1: {
                    BinaryCoordinateSystem.read(this);
                    continue block10;
                }
                case 2: {
                    data = this.readData();
                    continue block10;
                }
                case 3: {
                    data = (DataImpl)BinarySerializedObject.read(this.file);
                    continue block10;
                }
                case 4: {
                    BinaryErrorEstimate.read(this);
                    continue block10;
                }
                case 5: {
                    BinaryMathType.read(this);
                    continue block10;
                }
                case 7: {
                    BinaryUnit.read(this);
                    continue block10;
                }
            }
            throw new IOException("Unknown directive " + directive);
        }
        return data;
    }

    public final BinaryObjectCache getCoordinateSystemCache() {
        return this.cSysCache;
    }

    public final BinaryObjectCache getErrorEstimateCache() {
        return this.errorCache;
    }

    public final long getFilePointer() throws IOException {
        if (this.file instanceof java.io.RandomAccessFile) {
            return ((java.io.RandomAccessFile)this.file).getFilePointer();
        }
        if (this.file instanceof RandomAccessFile) {
            return ((RandomAccessFile)this.file).getFilePointer();
        }
        return -1L;
    }

    public final DataInput getInput() {
        return this.file;
    }

    public final BinaryObjectCache getTypeCache() {
        return this.typeCache;
    }

    public final BinaryObjectCache getUnitCache() {
        return this.unitCache;
    }

    public static boolean isMagic(byte[] block) {
        ByteArrayInputStream bs = new ByteArrayInputStream(block);
        DataInputStream dis = new DataInputStream(bs);
        try {
            return BinaryReader.readMagic(dis) <= 1;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public final boolean isRandom() {
        return this.isRandom;
    }

    public DataImpl readData() throws IOException, VisADException {
        DataImpl data;
        long fsTime = 0L;
        long ffTime = 0L;
        long fTime = 0L;
        long dsTime = 0L;
        long totStart = 0L;
        long g3sTime = 0L;
        long g2sTime = 0L;
        long g1sTime = 0L;
        long gsTime = 0L;
        long g3dsTime = 0L;
        long g2dsTime = 0L;
        long g1dsTime = 0L;
        long iNsTime = 0L;
        long i3sTime = 0L;
        long i2sTime = 0L;
        long i1sTime = 0L;
        long irsTime = 0L;
        long ir3sTime = 0L;
        long ir2sTime = 0L;
        long ir1sTime = 0L;
        long llsTime = 0L;
        long lNsTime = 0L;
        long l3sTime = 0L;
        long l2sTime = 0L;
        long l1sTime = 0L;
        long usTime = 0L;
        long tuTime = 0L;
        long tTime = 0L;
        long ssTime = 0L;
        long rtTime = 0L;
        long rTime = 0L;
        long psTime = 0L;
        long liTime = 0L;
        totStart = System.currentTimeMillis();
        int objLen = this.file.readInt();
        byte dataType = this.file.readByte();
        long tmpStart = System.currentTimeMillis();
        switch (dataType) {
            case 32: {
                data = BinarySimpleSet.read(this, dataType);
                break;
            }
            case 20: {
                data = BinaryFieldImpl.read(this);
                break;
            }
            case 21: {
                data = BinaryFlatField.read(this, objLen - 6, this.isRandom());
                break;
            }
            case 33: {
                data = BinarySimpleSet.read(this, dataType);
                break;
            }
            case 47: {
                data = BinaryGriddedDoubleSet.read(this, dataType);
                break;
            }
            case 48: {
                data = BinaryGriddedDoubleSet.read(this, dataType);
                break;
            }
            case 49: {
                data = BinaryGriddedDoubleSet.read(this, dataType);
                break;
            }
            case 43: {
                data = BinaryGriddedSet.read(this, dataType);
                break;
            }
            case 44: {
                data = BinaryGriddedSet.read(this, dataType);
                break;
            }
            case 45: {
                data = BinaryGriddedSet.read(this, dataType);
                break;
            }
            case 46: {
                data = BinaryGriddedSet.read(this, dataType);
                break;
            }
            case 55: {
                data = BinaryIntegerSet.read(this, dataType);
                break;
            }
            case 56: {
                data = BinaryIntegerSet.read(this, dataType);
                break;
            }
            case 57: {
                data = BinaryIntegerSet.read(this, dataType);
                break;
            }
            case 58: {
                data = BinaryIntegerSet.read(this, dataType);
                break;
            }
            case 40: {
                data = BinaryIrregularSet.read(this, dataType);
                break;
            }
            case 41: {
                data = BinaryIrregularSet.read(this, dataType);
                break;
            }
            case 42: {
                data = BinaryIrregularSet.read(this, dataType);
                break;
            }
            case 39: {
                data = BinaryIrregularSet.read(this, dataType);
                break;
            }
            case 50: {
                data = BinaryLinearSet.read(this, dataType);
                break;
            }
            case 51: {
                data = BinaryLinearSet.read(this, dataType);
                break;
            }
            case 52: {
                data = BinaryLinearSet.read(this, dataType);
                break;
            }
            case 53: {
                data = BinaryLinearSet.read(this, dataType);
                break;
            }
            case 54: {
                data = BinaryLinearSet.read(this, dataType);
                break;
            }
            case 34: {
                data = BinaryList1DSet.read(this);
                break;
            }
            case 60: {
                data = null;
                break;
            }
            case 38: {
                data = BinaryProductSet.read(this);
                break;
            }
            case 3: {
                data = BinaryReal.read(this);
                break;
            }
            case 11: {
                data = BinaryRealTuple.read(this);
                break;
            }
            case 36: {
                data = BinarySingletonSet.read(this);
                break;
            }
            case 2: {
                data = BinaryText.read(this);
                break;
            }
            case 10: {
                data = BinaryTuple.read(this);
                break;
            }
            case 37: {
                data = BinaryUnionSet.read(this);
                break;
            }
            default: {
                throw new IOException("Unknown Data type " + dataType);
            }
        }
        return data;
    }

    private static final int readMagic(DataInput stream) throws IOException {
        byte[] magic = "VisADBin".getBytes();
        try {
            for (int i = 0; i < magic.length; ++i) {
                if (stream.readByte() == magic[i]) continue;
                return -1;
            }
        }
        catch (IOException ioe) {
            return -1;
        }
        try {
            return stream.readInt();
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public final void seek(long pos) throws IOException {
        if (this.file instanceof java.io.RandomAccessFile) {
            ((java.io.RandomAccessFile)this.file).seek(pos);
        } else if (this.file instanceof RandomAccessFile) {
            ((RandomAccessFile)this.file).seek(pos);
        } else {
            throw new IOException("Seek not supported for " + this.file.getClass().getName());
        }
    }
}

