#!/local/bin/perl

################################################################################
# WWW.ROSS.NET CGI/PERL SCRIPT
# ============================
# Copyright (c) Ross N. Williams 1997. All rights reserved.
#
# This is a page in the Ross N. Williams web at http://www.ross.net/
#
#    Name    : Ross N. Williams.
#    WWW     : http://www.ross.net/
#    Email   : ross@ross.net
#    Phone   : +61 8 8232-6262
#    Fax     : +61 8 8232-6264
#    Snail   : PO Box 3066, Rundle Mall SA 5000, Australia.
#
# This web was created by Ross N. Williams (http://www.ross.net/).
################################################################################


# This number used to protect the hidden directories.
# But nowadays, I use .htaccess protection instead.
$passnumber = "44810328";

# Set up paths.
$dir_ross         = "/web/data/clients/ross";
$dir_confidential = $dir_ross . "/confidential";
$dir_scripts      = $dir_confidential . "/scripts_"   . $passnumber;
$dir_databases    = $dir_confidential . "/databases_" . $passnumber;

$visitors_file = $dir_databases . "/visitors";
$changes_file  = $dir_databases . "/changes.txt";
$quotes_file   = $dir_databases . "/quotes.txt";

@INC = (@INC,$dir_scripts);

require ("lib_assert.pl");
require ("lib_changes.pl");
require ("lib_checkin.pl");
require ("lib_cookie.pl");
require ("lib_country.pl");
require ("lib_datetime.pl");
require ("lib_email.pl");
require ("lib_file.pl");
require ("lib_form.pl");
require ("lib_html.pl");
require ("lib_misc.pl");
require ("lib_path.pl");
require ("lib_protect.pl");
require ("lib_random.pl");
require ("lib_record.pl");
require ("lib_ross.pl");
require ("lib_rv.pl");
require ("lib_search.pl");
require ("lib_semaphore.pl");
require ("lib_string.pl");
require ("lib_trace.pl");
require ("lib_visitors.pl");



&form_parse_and_clean();
if ($form{'Email'} eq '')
  { &html_page('mailing_list_modify_e_e.txt'); }
if ($form{'Action'} eq '')
  { &html_page('mailing_list_modify_e_e.txt'); }

$email = $form{'Email'};
if (!&email_address_is_legal($email))
  { &html_page('mailing_list_modify_e.txt'); }

$email_from = 'web@ross.net';
$email_to   = 'majordomo@lists.internode.on.net';
$email_subj = 'FunnelWeb: Orders from the FunnelWeb web to Major Domo.';
$email_cc   = $email;
&email_open;
if ($form{'Action'} eq "Unsubscribe")
  { &email_line("unsubscribe fw-users $email"); }
else
  { &email_line("subscribe fw-users $email"); }
&email_close;

&html_page("mailing_list_modify.txt");

exit(0);
