package CExpr::Ref;

use 5.6.0;
use strict;
use warnings;

use CExpr;

our @ISA = qw/CExpr/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $name = shift;

    my $self = {name => $name,
               };
    bless $self, $class;

    return $self;
  }

sub kind
  {
    return 'ordinary';
  }

sub name
  {
    my $self = shift;
    return $self->{name};
  }

sub dump_c
  {
    my $self = shift;

    return $self->{name};
  }

sub compute
  {
    my $self = shift;

    return $self->{value}->compute;
  }

sub get_refs
  {
    my $self = shift;
    return ($self);
  }

sub layout
  {
    my $self = shift;
    my $accept_incomplete = shift;
    my $namespace = shift;

    $accept_incomplete = 0;

    my $data = $namespace->get($self->kind, $self->name);
    die "Identifier $self->{name} is unknown" unless $data;

    if ($data->isa('CType::Enum'))
      {
        # Whoops, this enum hasn't been laid out yet. Try it now.
        $data->layout(0, $namespace);
        $data = $namespace->get($self->kind, $self->name);
        # If we still haven't got it, then this identifier must be
        # defined later in the enum, so that's an error.
        if ($data->isa('CType::Enum'))
          {
            die "Identifier $self->{name} is not defined yet";
          }
      }

    if ($data->isa('CDecl'))
      {
        # NYI
        die;
      }
    elsif ($data->isa('CDecl::Enumerator'))
      {
        $self->{value} = $data->value;
      }
    else
      {
        die "Unhandled value type " . ref $data;
      }
  }

1;
