// generated by go run gen.go; DO NOT EDIT

package publicsuffix

const version = "publicsuffix.org's effective_tld_names.dat, hg revision 063babcbcbcc (2014-12-29)"

const (
	nodesBitsChildren   = 9
	nodesBitsICANN      = 1
	nodesBitsTextOffset = 15
	nodesBitsTextLength = 6

	childrenBitsWildcard = 1
	childrenBitsNodeType = 2
	childrenBitsHi       = 14
	childrenBitsLo       = 14
)

const (
	nodeTypeNormal     = 0
	nodeTypeException  = 1
	nodeTypeParentOnly = 2
)

// numTLD is the number of top level domains.
const numTLD = 1039

// Text is the combined text of all labels.
const text = "bielawashingtondclkasukabeerhcloudcontrolappalacebinorilskasumig" +
	"aurawa-mazowszexhibitionavigationavuotnakatsugawabiellaakesvuemi" +
	"eleccebizenakaniikawatanagurabieszczadygeyachiyodatsunanjoetsuru" +
	"taharabievatmpalanakayamatsuurabifukagawassamukawataricohdavvenj" +
	"argamvikasuyameiwamarylhurstjordalshalsenavyatkanazawabihorology" +
	"ukuhashimoichinosekigaharabikedavvesiidazaifuchukotkakegawatch-a" +
	"nd-clockaszubyurihonjournalistjohnayoroceanographiquehimejinfini" +
	"tires3-website-us-east-1bilbaogakijoburgliwicembroideryusuharabi" +
	"llustrationfshostre-totenkawabiomutashinainfoggiabirdartdecoalop" +
	"padovald-aostathelleitungsenhs3-website-us-gov-west-1birkenesodd" +
	"tangenovarabirthplacemergencyberlevagangaviikarugausdalorenskogl" +
	"obalatinabeauxartsandcrafts3-website-us-west-1bjarkoyusuisserveb" +
	"bs3-website-us-west-2bjerkreimperiabjugniizabloombergbauernikkoe" +
	"benhavnikolaeventsakuhokkaidonnakamagayahabaghdadyndns-homeftpac" +
	"cessakuragawabluenoharabmsakurainsureiseninohelsinkitakatakamori" +
	"okamchatkameokameyamashinatsukigatakanabedzin-addrammenuernbergl" +
	"obodoes-itatarstaninomiyakonojosoyrovnoslombardyndns-at-homednsa" +
	"kyotanabellevuedatinglogowegrowestfalenirasakinuyamanouchikuhoku" +
	"ryugasakitaurayasudabmwfarmequipmentateyamabnpparibaselburgloppe" +
	"nzaokinawashirosatobishimagnitkafjordyndns-ip6bolzanordreisa-gee" +
	"katowicemrbomloabathsbcargodoesntexistanbullensakerbondyndns-mai" +
	"losangelesalangenishiazainvestmentsalatrobellunordre-landyndns-o" +
	"ffice-on-the-webcambridgestonewportlligatewayuulminamiechizenish" +
	"igovtatsunostrodabonnishiharabostonakijinsekikogenishiizunazukis" +
	"-a-candidatepilepsykkylvenetogoldpointelligencepsongdalenishikat" +
	"akatoris-a-catererbotanicalgardenishikatsuragivingmailoteneis-a-" +
	"celticsfanishikawazukaneyamaxunjargabotanicgardenishimerabotanyc" +
	"arrierboutiquebecartierbozentsujiieu-central-1bradescorporationi" +
	"shinomiyashironostrolekaniepceverbankatsushikabeiarnrtattoolszty" +
	"nsettlersalondonetskatsuyamasfjordenishinoomotegostrowiecartoona" +
	"rteducationalchikugojomediabrandywinevalleyuzawabrasiljan-mayeni" +
	"shinoshimatsuzakis-a-chefarmerseinewyorkshireggiocalabriabremang" +
	"erbresciabrindisiciliabristolgaulardalottevje-og-hornnesaltdalot" +
	"tokigawabritishcolumbialowiezachpomorskienishiokoppegardyndns-pi" +
	"csalvadordalikes-piedmontblancashirepair-traffic-controlleyuzhno" +
	"-sakhalinskaufenishitosashimizunaminamiawajikis-a-conservativefs" +
	"nillfjordyndns-remotegildeskalmykiabroadcastleasinglesalzburgmin" +
	"akamichigangwonishiwakis-a-cpaderbornissandvikcoromantovaldaosta" +
	"tionissedalouvrepbodyndns-at-workinggroupowiataxindianmarketingm" +
	"odalenisshinguernseybroke-itgorybrokerbronnoysundyndns-serverban" +
	"iabrumunddalowiczest-a-la-masioniyodogawabrunelblagdenesnaaseral" +
	"ingenkainanaejrietiendaburyatiabrusselsamegawabruxellesjaguarchi" +
	"tecturecipesaro-urbino-pesarourbinopesaromaintenancexpressexyzgo" +
	"rabryanskleppaleostrowwlkpalermomasvuotnakatombetsupportjeldsund" +
	"yndns-webhoppdalucaniabryneuesamnangerbuyshousesamsungmxboxeroxj" +
	"aworznobuzenrwhalingqldyndns-wikirovogradoybuzzgorzeleccollectio" +
	"nbwhoswhokksundyndns-workshopalmspringsakerbzhitomirkutskodjeffe" +
	"rsoncloudcontrolledekaluganskypescaravantaacloudfrontariocntoyoo" +
	"karasjohkaminokawanishiaizubangecollegersundcolognewhampshireggi" +
	"o-calabriacolonialwilliamsburgrossetouchijiwadell-ogliastrakhana" +
	"migawacoloradoplateaudnedalncolumbusantiquesantabarbaracommunity" +
	"chyllestadcomobaracompanynysabaerobaticasertaipeigersundyroyrvik" +
	"nakamurataitogitsuliernewspapercompute-1computerhistoryofscience" +
	"-fictioncondoshichikashukujitawaraconferenceconstructionconsulad" +
	"oharuovattorneyagawalesundconsultanthropologyconsultingvolluroyc" +
	"ontemporaryartgalleryazanconagawakkanaibetsubamericanartanddesig" +
	"nieznodawarahkkeravjudygarlandcontractorskenconventureshinodesas" +
	"hibetsuikinkobayashikaoizumizakiracookingroundhandlingroznycoolb" +
	"ia-tempio-olbiatempioolbialystokkecoopocznorfolkebiblebtimnetzgr" +
	"adcopenhagencyclopedicasinore-og-uvdaluccapetowncorsicadaquesant" +
	"acruziparachutingrparaglidingruecorvettemasekhabarovskhakassiaco" +
	"senzagannakadomari-elasticbeanstalkharkivalleaostavropolicecostu" +
	"medio-campidano-mediocampidanomediocouncilustercoursesantafedera" +
	"tioncqponcranbrookuwanalyticsanukis-a-designercreditcardcremonas" +
	"horokanaiecrewindmillutskharkovalled-aostakazakis-a-doctoraycric" +
	"ketrzyncrimearthruhereggio-emilia-romagnagatorokunohealthcareers" +
	"aotomelbournecrotonewjerseycrowncrsapodhaleluxembourguidelloglia" +
	"stradercruisesapporocuisinellahppiacenzakopaneraircraftoyosatosh" +
	"imaculturalcentertainmentoyotaris-a-financialadvisor-aurdaluxury" +
	"cuneocupcakecxn--0trq7p7nnferraraferreroticahcesuoloanswedenfets" +
	"undfguitarsaratovalledaostaketomisatomaritimekeepingujolsterfhva" +
	"lerfiguerestaurantoyotomiyazakis-a-geekhersonfilateliafilminamif" +
	"uranofinaluzernfinancefineartsardegnaklodzkodairafinlandfinnoyfi" +
	"rebaseappspotenzamamicrolightingulenfirenzefirestonexusdecorativ" +
	"eartsardiniafirmdaleclercateringebuildersvpanamafishingolfarmste" +
	"adfitjarfitnessettlementoyotsukaidovre-eikerfjalerdalvivano-fran" +
	"kivskhmelnitskiyamashikeflesbergunmarcheapartmentsarlflightsarps" +
	"borganicfdflogisticsarufutsunomiyawakasaikaitakoelnfloraflorence" +
	"floridafloristanohataiwanairguardfloromskoguchikuzenflowersasaya" +
	"maflsmidthachinohekinannestadflynnhubalsanagochihayaakasakawagoe" +
	"164fndfolldalfootballooninguovdageaidnulsanfranciscotlandfor-bet" +
	"ter-thanawafor-ourfor-somedizinhistorischesaseboknowsitallfor-th" +
	"edmarketsaskatchewanggouvicenzaforexeterforgotdnsassaris-a-green" +
	"forli-cesena-forlicesenaforliguriaforsalegalsaceforsandasuolocal" +
	"historyfortmissoulan-udefensejnyfortworthachiojiyaitakaharulvikh" +
	"melnytskyivallee-aosteroyforuminamiiserniafosnesatxn--1ctwolomin" +
	"amatakinouefotherokuapparisor-fronfredrikstadtoyourafreiburgushi" +
	"kamifuranoshiroomurafreightoystre-slidrettozawafribourgwangjuifm" +
	"inamiizukamitondabayashiogamagoriziafriuli-v-giuliafriuli-ve-giu" +
	"liafriuli-vegiuliafriuli-venezia-giuliafriuli-veneziagiuliafriul" +
	"i-vgiuliafriuliv-giuliafriulive-giuliafriulivegiuliafriulivenezi" +
	"a-giuliafriuliveneziagiuliafriulivgiuliafrlfrogansaudafrognfrola" +
	"ndfrom-akunemurorankoshigayabukidsauheradfrom-alfrom-arfrom-azjc" +
	"bnlfrom-camerakershuscountryestateshinanomachippubetsubetsugaruh" +
	"rfrom-coldwarszawafrom-ctozsdevenesavannahgafrom-dchernigovernme" +
	"ntjomelhusgardenfrom-degreefrom-flandersaves-the-whalessandria-t" +
	"rani-barletta-andriatranibarlettaandriafrom-gafrom-higashiagatsu" +
	"magois-a-gurunsaitokuyamafrom-iafrom-idfrom-ilfrom-in-the-bandai" +
	"wafunefrom-ksavonamsosnowiechernihivguccircleborkautokeinofrom-k" +
	"yotobetsumidatlantichernivtsicilyngenfrom-langevagrarboretumbria" +
	"from-mangonohejis-a-hard-workerfrom-mdfrom-meeresaxofrom-microso" +
	"ftwaremarkerfrom-mnfrom-mochizukiryuohkurafrom-msayokkaichirurgi" +
	"ens-dentistesbschoenbrunnfrom-mtnfrom-nchernovtsydneyfrom-ndfrom" +
	"-nefrom-nhkhvalleeaosteigenfrom-njeonnamerikawauefrom-nminamimak" +
	"is-a-hunterfrom-nvanylvenicefrom-nyfrom-ohtawaramotoineppugliafr" +
	"om-oketogurafrom-orfrom-pacifichiryukyuragifudaigokaseekazimierz" +
	"-dolnyfrom-praxis-a-anarchistoireggioemiliaromagnakanojohanamaki" +
	"noharafrom-rittohmaniwakuratenris-a-knightrainingxn--1lqs03nfrom" +
	"-schmidtre-gauldalfrom-sdfrom-tnfrom-txn--1lqs71dfrom-utazunzenf" +
	"rom-vadsogndalfrom-vtranapleschokoladenfrom-wafrom-wielunnerfrom" +
	"-wvaomoriguchiharamcoacharterfrom-wyfrosinonefrostalowa-wolawafr" +
	"oyahikobearalvahkikuchikumagayagawallonieruchomoscienceandindust" +
	"rynfstcgrouparliamentranbyfujiiderafujikawaguchikonefujiminohach" +
	"irogatakahashimamakitahatakahatakaishimogosenfujinomiyadafujioka" +
	"yamannosegawafujisatoshonairlinebraskaunbieidsvollfujisawafujish" +
	"iroishidakabiratorideliverybnikahokutogakushimotoganewmexicoffee" +
	"dbacklabusinessebydgoszczecincinnativeamericanantiquescholarship" +
	"schoolkuszlgzminamiminowafujiyoshidafukayabeardudinkakamigaharav" +
	"ennagasakikugawalterfukuchiyamadafukudominichitachinakagawawildl" +
	"ifestylefukuis-a-landscaperugiafukumitsukefukuokazakisarazure-mo" +
	"bilegnicampobassociateschulevangerfukuroishigakishiwadafukusakis" +
	"ofukushimansionschwarzparmafukuyamagatajimidoris-a-lawyerfunabas" +
	"hiriuchinadafunagatajiris-a-liberalfunahashikamiamakusatsumasend" +
	"aisennangooglecodespotrani-andria-barletta-trani-andriafundaciof" +
	"uoiskujukuriyamanxn--1qqw23afuosskoczowindowschweizwithgoogleapi" +
	"sa-hockeynutraniandriabarlettatraniandriafurniturehabikinokawair" +
	"portland-4-salernogatagajobsciencecentersciencehistoryfurubiraqu" +
	"arelleangaviikagaminogiessenvironmentalconservationfurudonostiaf" +
	"urukawaharafusognefussafetysfjordfutabayamaguchinomigawafutboldl" +
	"ygoingnowhere-for-moregontrailroadfuttsurugashimaoris-a-libertar" +
	"ianfvgfylkesbiblackfridayfyresdalhannanmokuizumodenakanotoddenha" +
	"nnovhadanotairescientistor-elvdalhanyuzenhapmirumarnardalhappous" +
	"livinghistoryhareidsbergenharstadharvestcelebrationhasamarahasam" +
	"inami-alpsienakasatsunairteledatabaseballangenoamishirasatobamag" +
	"azinedre-eikerhasudahasvikmscrapper-sitehatogayaizuwakamatsubush" +
	"ikusakadogawahatoyamazakitakamiizumisanofieldhatsukaichiharahatt" +
	"fjelldalhawaiijimarriottranoyhayashimamotobunkyonanaoshimabariak" +
	"ehazuminobuseljordhemnescrappinghemsedalherokusslattuminamisanri" +
	"kubetsupplyheroyhigashichichibusheyhigashihiroshimanehigashiizum" +
	"ozakitakyushuaiahigashikagawahigashikagurasoedahigashikawakitaai" +
	"kitamidsundhigashikurumeetnedalhigashimatsushimarugame-hostinghi" +
	"gashimatsuyamakitaakitadaitoigawahigashimurayamalatvuopmifunehig" +
	"ashinarusells-for-lesserveftparservegame-servercellikescandynath" +
	"omebuiltransportrapaniiminamiashigarahigashinehigashiomihachiman" +
	"agementravellinohigashiosakasayamamotorcycleservicesettsurgeonsh" +
	"alloffameldalhigashishirakawamatakanezawahigashisumiyoshikawamin" +
	"amiaikitamotosumitakaginowanidhigashitsunotteroyhigashiurausukit" +
	"anakagusukumodernhigashiyamatokoriyamanakakogawahigashiyodogawah" +
	"igashiyoshinogaris-a-musicianhiraizumisatohnoshoooshikamaishimod" +
	"atextileirvikokonoehirakatashinagawahiranairtraffichitosetoeihei" +
	"jis-a-cubicle-slaveroykenhirarahiratsukagawahirayakagehistoricho" +
	"usesevastopolewismillerhitachiomiyaginozawaonsenhitachiotagopart" +
	"is-a-nascarfanhitoyoshimihamadahitradinghjartdalhjelmelandholeck" +
	"obierzyceholidayhomelinuxn--2m4a15ehomessinashikitashiobarahomeu" +
	"nixn--30rr7yhondahonefossewloclawekolobrzegyptianpachigasakieven" +
	"assisibenikihokumakogeniwaizumiotsukumiyamazonawshakotankomagane" +
	"hongorgets-itrdhonjyoichiropractichloehornindalhorsells-for-ustk" +
	"arasuyamazoehortendofinternetreehotelefonicapebretonamiastarostw" +
	"odzislawritesthisblogspotrentino-a-adigehotmailhoyangerhoylandet" +
	"roitrentino-aadigehurdalhurumajis-a-nursells-itrentino-alto-adig" +
	"ehyogoris-a-painteractivegarsheis-a-patsfanhyugawaraiwchocolatel" +
	"evisionjewishartrentino-sudtiroljfkomitamamurajgorajlchofunatori" +
	"kuzentakatairajoyoitakaokamikitayamatotakadajpnjprshimonosekikaw" +
	"ajurkozagawakozakis-a-teacherkassymantechnologykragerotikamisuna" +
	"gawakrakowroclawtcmwtfarsundkrasnoyarskomonokredstonekristiansan" +
	"defjordkristiansundkrodsheradkrokstadelval-daostavalleykryminami" +
	"tanekumatorinokumejimasudakumenanyokaichibaikaliszczytnordkappgk" +
	"unisakis-a-techietis-a-photographermesaverdelmenhorstalbansharis" +
	"-a-personaltrainerkunitachiaraisaijoshkar-olanshimotsumakunitomi" +
	"gusukukis-a-therapistoiakunneppulawykunstsammlungkunstunddesignk" +
	"ureitrentino-sued-tirolkurgankurobelaudiokurogimimatakasagotemba" +
	"ixadakuroisohuissier-justicekuromatsunaishobaraholtalengerdalask" +
	"anittedalvdalkurotakikawasakis-an-accountantsharpartnershellasko" +
	"yabenorddalkurskomorotsukamishihoronobeokamiminershimosuwalkis-a" +
	"-socialistmeincheonkushirogawakustanais-an-actorkusupplieshinich" +
	"inankutchannelkutnokuzbassnoasagamiharakuzumakis-an-actressherbr" +
	"ookegawakvafjordkvalsundkvamlidlugolekadenagahamaroygardenglandk" +
	"vanangenkvinesdalkvinnheradkviteseidskogkvitsoykwwwkyowariasahik" +
	"awamishimatsumaebashikshacknetrentino-suedtirolmissileksvikongsb" +
	"ergmisugitokonamegatakashimatsumotofukemitakeharamitourismolensk" +
	"ongsvingermitoyoakemiuramiyazurewebsiteshikagamiishikarikaturind" +
	"almiyotamanomjondalenmonmouthagamonticellombardiamondshinjukuman" +
	"omontrealestateofdelawarendalenvikingatlantakasugais-an-entertai" +
	"nermonza-brianzaporizhzhiamonza-e-della-brianzaramonzabrianzamon" +
	"zaebrianzamonzaedellabrianzamordoviajessheiminamiuonumateramolis" +
	"ellsyourhomeipartshinjournalismolapyatigorskomvuxn--32vp30haebar" +
	"uminamiogunionmoriyamatsunomoriyoshiokamitsuemormoneymoroyamatsu" +
	"sakahogithubusercontentrentinoa-adigemortgagemoscowmoseushistory" +
	"mosjoenmoskeneshinkamigotoyohashimotokyotangomosshinshinotsurger" +
	"ymosvikoninjamisonmovistargardmtpchonanbuildingretajimakanegasak" +
	"itagawamuenstermugivestbyklebesbyglandmuikamogawamukochikushinon" +
	"senergymulhousembokumamotoyamassa-carrara-massacarraramassabuske" +
	"rudineustarnbergmunakatanemuncieszynmuosattemurmanskonskowolaqui" +
	"larvikommunalforbundmurotorcraftrentinoaadigemusashimurayamatsus" +
	"higemusashinoharamuseetrentinoalto-adigemuseumverenigingmutsuzaw" +
	"amyphotoshibajddarchaeologyeongnamegawakuyachimatainaikawababia-" +
	"goracleaningmytis-a-bookkeeperminamiyamashirokawanabelgorodeopas" +
	"senger-associationpaviapharmacienshinshiropharmacymrussiaphilade" +
	"lphiaareadmyblogsitephilatelyphilipshintokushimaphoenixn--3bst00" +
	"minanophotographysiopiagetmyipartysvardoomdnsaliascolipicenord-f" +
	"ronpictetrentinoaltoadigepictureshintomikasaharapiemontepilotshi" +
	"nyoshitomiokanmakitchenpippuwajimapiszpittsburghofashionpizzapko" +
	"nyvelodingenplanetariumincommbankonantanangerplantationplantshio" +
	"jirishirifujiedaplazaplchoseikakudamatsueplomzaporizhzhelpasaden" +
	"akhodkanagawaplumbingopmnpodlasiellakasamatsudoosandnessjoenpodz" +
	"onepohlpokerpolkowicepoltavalle-aostatoilpomorzeszowpordenonepor" +
	"nporsangerporsangugeporsgrunnanposts-and-telecommunicationshioya" +
	"nagawapoznanprdpreservationpresidioprincipeprivneprochowiceprodu" +
	"ctionshirahamatonbetsurgutsiracusaikis-bytomakomaibaraprofastlyp" +
	"rojectrentinos-tirolpromombetsurfauskedsmokorsetagayaseljejuegos" +
	"hikiminokamoenairforcertificationpropertieshirakoenigpropertyume" +
	"npruszkowprzeworskogptzpvtrentinostirolpzqsldsolundsolutionshira" +
	"ois-certifieducatorahimeshimageandsoundandvisionsomasomnamsskoga" +
	"neis-into-carshimokawasoosopotrentinosudtirolsor-odalsor-varange" +
	"rsorfoldsorreisahayakawakamiichikaiseiyokoshibahikariwanumatakay" +
	"amasortlandsorumisakis-an-artisteinkjerusalembetsukuis-a-republi" +
	"cancerresearchaeologicaliforniasouthcarolinazawasouthwesterniika" +
	"ppusowaspace-to-rentalshiraokanonjis-foundationspbaltimore-og-ro" +
	"msdalimoldepotaruibmdnepropetrovskaruizawaustrheimatunduhrenneso" +
	"yokote-burggfamilyokoze12spiegelspjelkavikoryolasitespreadbettin" +
	"gspydebergsrvareseminestordalstorenburgstorfjordstpetersburgstud" +
	"yndns-blogdnshiratakahagis-gonestuff-4-salezajskosaigawastuttgar" +
	"trentinosued-tirolsurreysusakis-into-cartoonshimokitayamasusonos" +
	"uzakanumazurysuzukanzakiwakunigamihoboleslawiechoshibukawasuzuki" +
	"s-into-gameshimonitayanagis-a-rockstarachowicesvalbardurbannefra" +
	"nkfurtrentinosuedtirolsveiosvelvikosakaerodromedecinemailsvizzer" +
	"aswidnicapitalswiebodzindianapolis-a-bloggerswinoujscienceandhis" +
	"toryswisshikis-leetrentino-altoadigesxn--3ds443gtuis-savedtulava" +
	"gisketurystykarasjoksneshishikuis-into-animegurovigorlicetuscany" +
	"tushumanitieshisokanoyakutiatuvalle-d-aostavangertverdalvaroyvba" +
	"mbleasecn-north-1vchoyodobashibuyachtsangovdonskoshimizumakiyose" +
	"mitevegaskvollvenneslaskerveronarashinoverranversailleshisuifuel" +
	"veruminnesotaketakasakis-an-anarchistoricalsocietysneshimojis-a-" +
	"playerversicherungvestfoldvestneshitaramavestre-slidreamhostersh" +
	"izukuishimofusaintlouis-a-bruinsfanshiranukannamiharuvestre-tote" +
	"nnishiawakuravestvagoyvevelstadvibo-valentiavibovalentiavideovil" +
	"lasmatartcenterprisesakikonaioirasebastopologyeonggiehtavuoatnad" +
	"exchangeiseiroumuenchendoftheinternetcimmobilienebakkeshibechamb" +
	"agriculturennebudapest-a-la-maisondriodejaneirochestervinnicarbo" +
	"nia-iglesias-carboniaiglesiascarboniavinnytsiavirginiavirtualvir" +
	"tuelvistaprinternationalfirearmshizuokanraviterboltroandinosaure" +
	"portrentottoris-lostfoldvladikavkazanvladimirvladivostokaizukara" +
	"tevlogvoldavolgogradvolkenkunderseaportrogstadvologdanskoshunant" +
	"okashikiyosumypetshimotsukevolyngdalvoronezhytomyrvossevangenvot" +
	"evotingvotoyakokamisatohobby-sitevrnxn--4it168dxn--4it797kostrom" +
	"ahabororoskoleirfjordxn--4pvxshowaxn--54b7fta0cchtraeumtgeradeat" +
	"nurembergrimstadxn--55qw42gxn--55qx5dxn--5js045dxn--5rtp49chungb" +
	"ukazoxn--5rtq34kosugexn--6btw5axn--6frz82gxn--6orx2rxn--6qq986b3" +
	"xlxn--7t0a264chungnamdalseidfjordxn--80adxhkshriramsterdamberkel" +
	"eyxn--80ao21axn--80asehdbarcelonagareyamalopolskanlandnipropetro" +
	"vskarumaifareastcoastaldefencebetsukubahcavuotnagaivuotnagaokaky" +
	"otambadajozorakkestadultargiheyakumoduminamidaitomandalindaskimi" +
	"tsubatamiasakuchinotsuchiurakawalbrzychattanooganord-odalindesne" +
	"s3-eu-west-1xn--80aswgxn--80augustowadaejeonbukotohiradomainsura" +
	"ncexn--8ltr62kotouraxn--8pvr4uxn--90a3academykolaivanovosibirski" +
	"ervaapsteiermarkhangelskiptveterinairealtorlandxn--90azhagebosta" +
	"dxn--9dbhblg6diethnologyxn--9et52uxn--andy-iraxn--aroport-byanai" +
	"zuxn--asky-iraxn--aurskog-hland-jnbarclaycards3-fips-us-gov-west" +
	"-1xn--avery-yuasakakinokis-slickomakiyokawaraxn--b-5gaxn--b4w605" +
	"ferdxn--bdddj-mrabdxn--bearalvhki-y4axn--berlevg-jxaxn--bhcavuot" +
	"na-s4axn--bhccavuotna-k7axn--bidr-5nachikatsuuraxn--bievt-0qaxn-" +
	"-bjarky-fyandexposedogawarabikomaezakirunortonsbergxn--bjddar-pt" +
	"akkofuefukihabmerxn--blt-elaborxn--bmlo-grajeworldxn--bod-2narit" +
	"akurashikis-uberleetrentino-s-tirollagrigentomologyeongbukomatsu" +
	"shimashikiyosatokamachildrensgardenxn--brnny-wuaccident-investig" +
	"ationjukudoyamaceratabuseat-band-campaniamallamadridvagsoyerimo-" +
	"i-ranaamesjevuemielnoboribetsuitachikawakayamagadancechirebungoo" +
	"nomichinomiyakeisenbahnxn--brnnysund-m8accident-preventionlineat" +
	"-urlxn--brum-voagatromsaitamatsukuris-not-certifiedunetworkanger" +
	"xn--btsfjord-9zaxn--c1avgxn--c3s14misasaguris-an-engineeringerik" +
	"exn--cg4bkis-very-badaddjamalborkdalxn--ciqpnxn--clchc0ea0b2g2a9" +
	"gcdxn--comunicaes-v6a2oxn--correios-e-telecomunicaes-ghc29axn--c" +
	"zr694barclays3-sa-east-1xn--czrs0tromsolarssonxn--czru2dxn--czrw" +
	"28bargainstitutelekommunikationaturalhistorymuseumcentereviews3-" +
	"us-gov-west-1xn--d1acj3barreauctionaturalsciencesnaturelles3-us-" +
	"west-1xn--d1atrusteexn--d5qv7z876churcheltenham-radio-operaunite" +
	"lemarkazunoxn--davvenjrga-y4axn--djrs72d6uyxn--djty4kouhokutamak" +
	"izunokunimilitaryxn--dnna-grandrapidsigdalxn--drbak-wuaxn--dyry-" +
	"iraxn--eckvdtc9dxn--efvn9simbirskooris-a-soxfanxn--efvy88haibara" +
	"kitahiroshimaritimodellingxn--ehqz56nxn--elqq16hakatanotogawaxn-" +
	"-eveni-0qa01gaxn--f6qx53axn--finny-yuaxn--fiq228c5hsimple-urlxn-" +
	"-fiq64barrel-of-knowledgeometre-experts-comptablest-mon-blogueur" +
	"ovisionaturbruksgymnaturhistorisches3-us-west-2xn--fiqs8sirdalxn" +
	"--fiqz9slgbtrentinosud-tirolxn--fjord-lraxn--fjq720axn--fl-ziaxn" +
	"--flor-jraxn--flw351exn--fpcrj9c3dxn--frde-granexn--frna-woarais" +
	"-very-evillagexn--frya-hraxn--fzc2c9e2chuvashiaxn--gecrj9circusc" +
	"ulturecreationxn--ggaviika-8ya47hakodatexasiaxn--gildeskl-g0axn-" +
	"-givuotna-8yaotsurnadalxn--gjvik-wuaxn--gls-elacaixaxn--gmq050is" +
	"-very-gooddaxn--gmqw5axn--h-2failxn--h1aeghakonexn--h2brj9citica" +
	"sadelamonedaxn--hbmer-xqaxn--hcesuolo-7ya35barrell-of-knowledgeo" +
	"rgiauthordalandroidiscountydalillesandiegotsukisosakitagatakaham" +
	"arburgjemnes3-ap-southeast-1xn--hery-iraxn--hgebostad-g3axn--hmm" +
	"rfeasta-s4acityeatsanjotoyonezawaxn--hnefoss-q1axn--hobl-iraxn--" +
	"holtlen-hxaxn--hpmir-xqaxn--hxt814exn--hyanger-q1axn--hylandet-5" +
	"4axn--i1b6b1a6a2exn--imr513nxn--indery-fyaroslavlaanderenxn--io0" +
	"a7is-very-nicexn--j1amhakubanxn--j6w193gxn--jlster-byasakaiminat" +
	"oyokawaxn--jrpeland-54axn--k7yn95exn--karmy-yuaxn--kbrq7oxn--kcr" +
	"x77d1x4axn--kfjord-iuaxn--klbu-woaxn--klt787dxn--kltp7dxn--kltx9" +
	"axn--klty5xn--3e0b707exn--koluokta-7ya57hakuis-a-linux-useranish" +
	"iaritabashijonawatexn--kprw13dxn--kpry57dxn--kput3is-very-sweetr" +
	"entino-stirolxn--krager-gyasugis-with-thebandontexisteingeekomfo" +
	"rbalsfjordivttasvuotnakaiwamizawaustraliaisondre-landebudejjuedi" +
	"schesapeakebayerndirectoryggeelvinckarpaczeladz-2xn--kranghke-b0" +
	"axn--krdsherad-m8axn--krehamn-dxaxn--krjohka-hwab49jetztrentino-" +
	"sud-tirolxn--ksnes-uuaxn--kvfjord-nxaxn--kvitsy-fyasuokaratsugin" +
	"amikatagamilanoxn--kvnangen-k0axn--l-1fairwindslupskopervikommun" +
	"exn--l1accentureklamurskjaknoluoktaikicks-assedicivilaviationxn-" +
	"-laheadju-7yatominamibosojavaksdalxn--langevg-jxaxn--lcvr32dxn--" +
	"ldingen-q1axn--leagaviika-52bashkiriautomotivelandiscoveryokamik" +
	"awanehonbetsuruokamakurazakirkenes3-ap-southeast-2xn--lesund-hua" +
	"xn--lgbbat1ad8jevnakerxn--lgrd-poacivilisationxn--lhppi-xqaxn--l" +
	"inds-pratoyonakagyokutomskounosunndalxn--lns-qlavangenxn--loabt-" +
	"0qaxn--lrdal-sraxn--lrenskog-54axn--lt-liacivilizationxn--lten-g" +
	"ranvindafjordxn--lury-iraxn--mely-iraxn--merker-kuaxn--mgb2ddesn" +
	"zxn--mgb9awbfcastresistancexn--mgba3a3ejtrysilkoseis-a-studental" +
	"xn--mgba3a4f16axn--mgba3a4franamizuholdingsmileikangerxn--mgbaam" +
	"7a8hakusandoyxn--mgbab2bdxn--mgbayh7gpaduaxn--mgbb9fbpobanazawax" +
	"n--mgbbh1a71exn--mgbc0a9azcgxn--mgberp4a5d4a87gxn--mgberp4a5d4ar" +
	"xn--mgbqly7c0a67fbcivilwarmiamibungotakadaxn--mgbqly7cvafranzisk" +
	"anerimarinexn--mgbt3dhdxn--mgbtf8flatangerxn--mgbx4cd0abogadocsc" +
	"bgxn--mjndalen-64axn--mk0axisleofmanchesterxn--mkru45issmarterth" +
	"anyouthadselfipirangaxn--mlatvuopmi-s4axn--mli-tlazioxn--mlselv-" +
	"iuaxn--moreke-juaxn--mori-qsakatakatsukiwatarailwayxn--mosjen-ey" +
	"atsukareliaxn--mot-tlaxn--mre-og-romsdal-qqbasilicataniautoscana" +
	"dagestangeologyomitanobihirosakikamijimatta-varjjatarantomobenev" +
	"entochiokinoshimalselvendrellimanowarudastronomyokohamamatsudaeg" +
	"ubs3-ap-northeast-1xn--msy-ula0haldenxn--mtta-vrjjat-k7aflakstad" +
	"aokagakibichuozuerichampionshiphopenair-surveillanceoxn--muost-0" +
	"qaxn--mxtq1misawaxn--ngbc5azdxn--ngbe9e0axn--nit225kouyamashikok" +
	"uchuoxn--nmesjevuemie-tcbalestrandabergamoarekepnordlandxn--nnx3" +
	"88axn--nodessakegawaxn--nqv7fs00emaxn--nry-yla5gxn--ntso0iqx3axn" +
	"--ntsq17gxn--nttery-byaeseoullensvangxn--nvuotna-hwaxn--nyqy26ax" +
	"n--o1achelyabinskydivingxn--o3cw4halsagaeroclubindallaspeziaxn--" +
	"od0algxn--od0aq3batochigifts3-website-ap-northeast-1xn--ogbpf8fl" +
	"ekkefjordxn--oppegrd-ixaxn--ostery-fyatsushiroxn--osyro-wuaxn--p" +
	"1acfagentsolognexn--p1aiwatexn--pgbs0dhammarfeastafricanonoichik" +
	"awamisatodayxn--porsgu-sta26fedjelenia-goraxn--pssu33lxn--q9jyb4" +
	"claimsannanxn--qcka1pmclickchristiansburgripexn--qqqt11misconfus" +
	"edxn--rady-iraxn--rdal-poaxn--rde-ulaxn--rdy-0nabariwatsukiyonow" +
	"ruzhgorodoyxn--rennesy-v1axn--rhkkervju-01afermobilyxn--rholt-mr" +
	"agoworse-thandaxn--rhqv96gxn--rht27zxn--rht3dxn--rht61exn--risa-" +
	"5naroyxn--risr-iraxn--rland-uuaxn--rlingen-mxaxn--rmskog-byawara" +
	"xn--rny31hamurakamigoris-a-llamarumorimachidaxn--rros-gratangenx" +
	"n--rskog-uuaxn--rst-0narusawaxn--rsta-francaiseharaxn--ryken-vua" +
	"xn--ryrvik-byawatahamaxn--s-1faithandsoniigatakamatsukawaxn--s9b" +
	"rj9clinicodynaliascoli-picenord-aurdalukowilliamhillupinkddieldd" +
	"anuorrissadollsannohembygdsforbundxn--sandnessjen-ogbizhevskouzu" +
	"shimasoyxn--sandy-yuaxn--seral-lraxn--ses554gxn--sgne-gratis-a-b" +
	"ulls-fanxn--skierv-utazasnesoddenmarketplacexn--skjervy-v1axn--s" +
	"kjk-soaxn--sknit-yqaxn--sknland-fxaxn--slat-5narutokorozawaxn--s" +
	"lt-elabourxn--smla-hraxn--smna-grazxn--snase-nraxn--sndre-land-0" +
	"cbatsfjordnpagespeedmobilizerobiravocatanzaroweddingjerdrumemori" +
	"alimitedivtasvuodnaharimamurogawaukraanghkemerovodkagoshimaizuru" +
	"btsovskjervoyagemologicallfinanz-1xn--snes-poaxn--snsa-roaxn--sr" +
	"-aurdal-l8axn--sr-fron-q1axn--sr-odal-q1axn--sr-varanger-ggbauha" +
	"ustevollinkasaokaminoyamatsuriinetarnobrzegjerstadotsuruginankok" +
	"ubunjiitatebayashiibahccavuotnagaraumallorcabbottarumizusawavoue" +
	"squarezzoologyonabarudmurtiaurskog-holandroverhalla-speziamuseme" +
	"ntambovalle-daostavernarvikarlsoyekaterinburgdyniaeroportalahead" +
	"judaicaarborteaches-yogasawaracing12000xn--srfold-byaxn--srreisa" +
	"-q1axn--srum-graxn--stfold-9xaxn--stjrdal-s1axn--stjrdalshalsen-" +
	"sqbbcngjesdalinzaiiyamanobeeldengeluidownloadrangedalipetskashib" +
	"atakarazukamiokamikoaniihamatamakawajimarylandrobakrehamnatuurwe" +
	"tenschappenaumburgjovikashiharaxaustinnasushiobaraquariumeloyali" +
	"stockholmestrandigitalillehammerfest-le-patrondheimemerckarmoyok" +
	"osukariyaltaijibigawagroks-theaternopilawakembuchikujobojibestad" +
	"gcagliaridagawatchandclock-uralsk12xn--stre-toten-zcbbvacationsn" +
	"asaarlandurhamburglassassinationalheritagematsubarakawachinagano" +
	"haraogashimadachicagoboats3-website-ap-southeast-1xn--tjme-hraxn" +
	"--tn0agrinetbankzxn--tnsberg-q1axn--tor131oxn--trany-yuaxn--trgs" +
	"tad-r1axn--trna-woaxn--troms-zuaxn--tysvr-vraxn--uc0atvedestrand" +
	"xn--uc0ay4axn--uist22hangglidingxn--uisz3gxn--unjrga-rtamayufuet" +
	"tertdasnetzxn--unup4yxn--uuwu58axn--vads-jraxn--vard-jraxn--vegr" +
	"shei-c0axn--vermgensberater-ctbeppubolognagasukesennumalvikashiw" +
	"araxn--vermgensberatung-pwberlincolnaustdalivornoceanographics3-" +
	"website-ap-southeast-2xn--vestvgy-ixa6oxn--vg-yiabruzzoologicala" +
	"bamagasakishimabaragusartsaritsynxn--vgan-qoaxn--vgsy-qoa0jewelr" +
	"yxn--vgu402clintonoshoesanokfhskgroks-thisayamanashichinoheguris" +
	"-a-democratoyonoxn--vhquvarggatrevisokndalxn--vler-qoaxn--vre-ei" +
	"ker-k8axn--vrggt-xqadxn--vry-yla5gxn--vuq861bernuorockartuzyonag" +
	"oyaxn--wcvs22dxn--wgbh1clothingrongaxn--wgbl6axn--xhq521beskidyn" +
	"-o-saurlandes3-website-eu-west-1xn--xkc2al3hye2axn--xkc2dl3a5ee0" +
	"hangoutsystemscloudapparocherkasyzranzanxn--yer-znarviikananporo" +
	"xn--yfro4i67oxn--ygarden-p1axn--ygbi2ammxn--45brj9christmasakimo" +
	"betsuwanouchikuseihichisobetsuldalucernexn--ystre-slidre-ujbetai" +
	"naboxfordealstahaugesundvrdnsdojogaszkolajollanbibaidarqhachijor" +
	"pelandyndns-freemasonryonaguniversityoriikashiwazakiwienaval-d-a" +
	"osta-valleyoutubentleyukindustriesteambulancebinagisodegauraxn--" +
	"zbx025dxn--zf0ao64axn--zf0avxn--45q11chromedicaltanissettaishino" +
	"makinderoyxn--zfr164bhartipschlesisches3-website-sa-east-1xxxn--" +
	"4gbriminingxz"

// nodes is the list of nodes. Each node is represented as a uint32, which
// encodes the node's children, wildcard bit and node type (as an index into
// the children array), ICANN bit and text.
//
// In the //-comment after each node's data, the nodes indexes of the children
// are formatted as (n0x1234-n0x1256), with * denoting the wildcard bit. The
// nodeType is printed as + for normal, ! for exception, and o for parent-only
// nodes that have children but don't match a domain label in their own right.
// An I denotes an ICANN domain.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 9 bits] children index
//	[ 1 bits] ICANN bit
//	[15 bits] text index
//	[ 6 bits] text length
var nodes = [...]uint32{
	0x00364ac3, // n0x0000 c0x0000 (---------------)  + I abb
	0x00364ac6, // n0x0001 c0x0000 (---------------)  + I abbott
	0x0033fd87, // n0x0002 c0x0000 (---------------)  + I abogado
	0x01a00b82, // n0x0003 c0x0006 (n0x040f-n0x0415)  + I ac
	0x002fe987, // n0x0004 c0x0000 (---------------)  + I academy
	0x003321c9, // n0x0005 c0x0000 (---------------)  + I accenture
	0x002ac88a, // n0x0006 c0x0000 (---------------)  + I accountant
	0x002ac88b, // n0x0007 c0x0000 (---------------)  + I accountants
	0x002a04c6, // n0x0008 c0x0000 (---------------)  + I active
	0x002388c5, // n0x0009 c0x0000 (---------------)  + I actor
	0x01e02902, // n0x000a c0x0007 (n0x0415-n0x0416)  + I ad
	0x0026d143, // n0x000b c0x0000 (---------------)  + I ads
	0x002fb4c5, // n0x000c c0x0000 (---------------)  + I adult
	0x0220d2c2, // n0x000d c0x0008 (n0x0416-n0x041e)  + I ae
	0x02633784, // n0x000e c0x0009 (n0x041e-n0x0477)  + I aero
	0x02a0b5c2, // n0x000f c0x000a (n0x0477-n0x047c)  + I af
	0x0024ddc3, // n0x0010 c0x0000 (---------------)  + I afl
	0x0034fc46, // n0x0011 c0x0000 (---------------)  + I africa
	0x02e02602, // n0x0012 c0x000b (n0x047c-n0x0481)  + I ag
	0x0023b206, // n0x0013 c0x0000 (---------------)  + I agency
	0x03205a42, // n0x0014 c0x000c (n0x0481-n0x0485)  + I ai
	0x00269b83, // n0x0015 c0x0000 (---------------)  + I aig
	0x002d2388, // n0x0016 c0x0000 (---------------)  + I airforce
	0x00285586, // n0x0017 c0x0000 (---------------)  + I airtel
	0x03600b02, // n0x0018 c0x000d (n0x0485-n0x048b)  + I al
	0x003615c9, // n0x0019 c0x0000 (---------------)  + I allfinanz
	0x00253a86, // n0x001a c0x0000 (---------------)  + I alsace
	0x00203582, // n0x001b c0x0000 (---------------)  + I am
	0x002f8c49, // n0x001c c0x0000 (---------------)  + I amsterdam
	0x03a02342, // n0x001d c0x000e (n0x048b-n0x048f)  + I an
	0x0023f509, // n0x001e c0x0000 (---------------)  + I analytics
	0x00322307, // n0x001f c0x0000 (---------------)  + I android
	0x03e07702, // n0x0020 c0x000f (n0x048f-n0x0495)  + I ao
	0x0024ca0a, // n0x0021 c0x0000 (---------------)  + I apartments
	0x0023be02, // n0x0022 c0x0000 (---------------)  + I aq
	0x0027ef49, // n0x0023 c0x0000 (---------------)  + I aquarelle
	0x042030c2, // n0x0024 c0x0010 (n0x0495-n0x049e)  + I ar
	0x0026e3c6, // n0x0025 c0x0000 (---------------)  + I aramco
	0x00229ec5, // n0x0026 c0x0000 (---------------)  + I archi
	0x003289c4, // n0x0027 c0x0000 (---------------)  + I army
	0x04aacb84, // n0x0028 c0x0012 (n0x049f-n0x04a5)  + I arpa
	0x0021dfc4, // n0x0029 c0x0000 (---------------)  + I arte
	0x04e00182, // n0x002a c0x0013 (n0x04a5-n0x04a6)  + I as
	0x0031ea44, // n0x002b c0x0000 (---------------)  + I asia
	0x0027834a, // n0x002c c0x0000 (---------------)  + I associates
	0x05201702, // n0x002d c0x0014 (n0x04a6-n0x04ad)  + I at
	0x002361c8, // n0x002e c0x0000 (---------------)  + I attorney
	0x05a01002, // n0x002f c0x0016 (n0x04ae-n0x04c0)  + I au
	0x00312707, // n0x0030 c0x0000 (---------------)  + I auction
	0x002aa905, // n0x0031 c0x0000 (---------------)  + I audio
	0x003220c6, // n0x0032 c0x0000 (---------------)  + I author
	0x00262c44, // n0x0033 c0x0000 (---------------)  + I auto
	0x00343dc5, // n0x0034 c0x0000 (---------------)  + I autos
	0x06a00102, // n0x0035 c0x001a (n0x04ce-n0x04cf)  + I aw
	0x0021a6c2, // n0x0036 c0x0000 (---------------)  + I ax
	0x0036b783, // n0x0037 c0x0000 (---------------)  + I axa
	0x06e01202, // n0x0038 c0x001b (n0x04cf-n0x04db)  + I az
	0x00277e05, // n0x0039 c0x0000 (---------------)  + I azure
	0x072076c2, // n0x003a c0x001c (n0x04db-n0x04e5)  + I ba
	0x00261e84, // n0x003b c0x0000 (---------------)  + I band
	0x0021c844, // n0x003c c0x0000 (---------------)  + I bank
	0x00210ac3, // n0x003d c0x0000 (---------------)  + I bar
	0x002f9609, // n0x003e c0x0000 (---------------)  + I barcelona
	0x0030188b, // n0x003f c0x0000 (---------------)  + I barclaycard
	0x00310148, // n0x0040 c0x0000 (---------------)  + I barclays
	0x00311088, // n0x0041 c0x0000 (---------------)  + I bargains
	0x00362ec7, // n0x0042 c0x0000 (---------------)  + I bauhaus
	0x0032e2c6, // n0x0043 c0x0000 (---------------)  + I bayern
	0x0760bfc2, // n0x0044 c0x001d (n0x04e5-n0x04ef)  + I bb
	0x00369083, // n0x0045 c0x0000 (---------------)  + I bbc
	0x0036ed04, // n0x0046 c0x0000 (---------------)  + I bbva
	0x003690c3, // n0x0047 c0x0000 (---------------)  + I bcn
	0x01703202, // n0x0048 c0x0005 (---------------)* o I bd
	0x07a00602, // n0x0049 c0x001e (n0x04ef-n0x04f1)  + I be
	0x00200604, // n0x004a c0x0000 (---------------)  + I beer
	0x003833c7, // n0x004b c0x0000 (---------------)  + I bentley
	0x00376686, // n0x004c c0x0000 (---------------)  + I berlin
	0x0036de84, // n0x004d c0x0000 (---------------)  + I best
	0x07f3a2c2, // n0x004e c0x001f (n0x04f1-n0x04f2)  + I bf
	0x08340002, // n0x004f c0x0020 (n0x04f2-n0x0516)  + I bg
	0x0862c202, // n0x0050 c0x0021 (n0x0516-n0x051b)  + I bh
	0x00385506, // n0x0051 c0x0000 (---------------)  + I bharti
	0x08a00002, // n0x0052 c0x0022 (n0x051b-n0x0520)  + I bi
	0x0023ac45, // n0x0053 c0x0000 (---------------)  + I bible
	0x00304743, // n0x0054 c0x0000 (---------------)  + I bid
	0x00205684, // n0x0055 c0x0000 (---------------)  + I bike
	0x002cc444, // n0x0056 c0x0000 (---------------)  + I bing
	0x002cc445, // n0x0057 c0x0000 (---------------)  + I bingo
	0x00208743, // n0x0058 c0x0000 (---------------)  + I bio
	0x08e02183, // n0x0059 c0x0023 (n0x0520-n0x0527)  + I biz
	0x0920bb82, // n0x005a c0x0024 (n0x0527-n0x052b)  + I bj
	0x00282385, // n0x005b c0x0000 (---------------)  + I black
	0x0028238b, // n0x005c c0x0000 (---------------)  + I blackfriday
	0x0020cb09, // n0x005d c0x0000 (---------------)  + I bloomberg
	0x0020e344, // n0x005e c0x0000 (---------------)  + I blue
	0x0960e5c2, // n0x005f c0x0025 (n0x052b-n0x0530)  + I bm
	0x0020e5c3, // n0x0060 c0x0000 (---------------)  + I bms
	0x00212503, // n0x0061 c0x0000 (---------------)  + I bmw
	0x01612ac2, // n0x0062 c0x0005 (---------------)* o I bn
	0x0025d003, // n0x0063 c0x0000 (---------------)  + I bnl
	0x00212aca, // n0x0064 c0x0000 (---------------)  + I bnpparibas
	0x09a10042, // n0x0065 c0x0026 (n0x0530-n0x0539)  + I bo
	0x00370545, // n0x0066 c0x0000 (---------------)  + I boats
	0x00214283, // n0x0067 c0x0000 (---------------)  + I bom
	0x00214cc4, // n0x0068 c0x0000 (---------------)  + I bond
	0x002c4503, // n0x0069 c0x0000 (---------------)  + I boo
	0x00219483, // n0x006a c0x0000 (---------------)  + I bot
	0x0021b188, // n0x006b c0x0000 (---------------)  + I boutique
	0x09e07bc2, // n0x006c c0x0027 (n0x0539-n0x057f)  + I br
	0x0021bb88, // n0x006d c0x0000 (---------------)  + I bradesco
	0x002164cb, // n0x006e c0x0000 (---------------)  + I bridgestone
	0x00227806, // n0x006f c0x0000 (---------------)  + I broker
	0x002297c8, // n0x0070 c0x0000 (---------------)  + I brussels
	0x0a607242, // n0x0071 c0x0029 (n0x0580-n0x0585)  + I bs
	0x0aa3ad82, // n0x0072 c0x002a (n0x0585-n0x058a)  + I bt
	0x002ee388, // n0x0073 c0x0000 (---------------)  + I budapest
	0x0024a845, // n0x0074 c0x0000 (---------------)  + I build
	0x0024a848, // n0x0075 c0x0000 (---------------)  + I builders
	0x002741c8, // n0x0076 c0x0000 (---------------)  + I business
	0x0022c983, // n0x0077 c0x0000 (---------------)  + I buy
	0x0022dac4, // n0x0078 c0x0000 (---------------)  + I buzz
	0x0036ed42, // n0x0079 c0x0000 (---------------)  + I bv
	0x0ae2e042, // n0x007a c0x002b (n0x058a-n0x058c)  + I bw
	0x0b206302, // n0x007b c0x002c (n0x058c-n0x0590)  + I by
	0x0b62eac2, // n0x007c c0x002d (n0x0590-n0x0596)  + I bz
	0x0022eac3, // n0x007d c0x0000 (---------------)  + I bzh
	0x0ba14582, // n0x007e c0x002e (n0x0596-n0x05a7)  + I ca
	0x00364a83, // n0x007f c0x0000 (---------------)  + I cab
	0x00219603, // n0x0080 c0x0000 (---------------)  + I cal
	0x00361584, // n0x0081 c0x0000 (---------------)  + I call
	0x0025d206, // n0x0082 c0x0000 (---------------)  + I camera
	0x0023e184, // n0x0083 c0x0000 (---------------)  + I camp
	0x002d800e, // n0x0084 c0x0000 (---------------)  + I cancerresearch
	0x0034fd45, // n0x0085 c0x0000 (---------------)  + I canon
	0x0023ba08, // n0x0086 c0x0000 (---------------)  + I capetown
	0x002e21c7, // n0x0087 c0x0000 (---------------)  + I capital
	0x0022f847, // n0x0088 c0x0000 (---------------)  + I caravan
	0x00301a45, // n0x0089 c0x0000 (---------------)  + I cards
	0x00241e44, // n0x008a c0x0000 (---------------)  + I care
	0x00241e46, // n0x008b c0x0000 (---------------)  + I career
	0x00241e47, // n0x008c c0x0000 (---------------)  + I careers
	0x002d5284, // n0x008d c0x0000 (---------------)  + I cars
	0x0021b407, // n0x008e c0x0000 (---------------)  + I cartier
	0x00320f84, // n0x008f c0x0000 (---------------)  + I casa
	0x00222744, // n0x0090 c0x0000 (---------------)  + I cash
	0x0023b546, // n0x0091 c0x0000 (---------------)  + I casino
	0x002192c3, // n0x0092 c0x0000 (---------------)  + I cat
	0x0024a608, // n0x0093 c0x0000 (---------------)  + I catering
	0x003495c3, // n0x0094 c0x0000 (---------------)  + I cba
	0x0025cfc3, // n0x0095 c0x0000 (---------------)  + I cbn
	0x0be020c2, // n0x0096 c0x002f (n0x05a7-n0x05ab)  + I cc
	0x0c30f042, // n0x0097 c0x0030 (n0x05ab-n0x05ac)  + I cd
	0x002442c6, // n0x0098 c0x0000 (---------------)  + I center
	0x00347c83, // n0x0099 c0x0000 (---------------)  + I ceo
	0x003808c4, // n0x009a c0x0000 (---------------)  + I cern
	0x0c64d1c2, // n0x009b c0x0031 (n0x05ac-n0x05ad)  + I cf
	0x0034f083, // n0x009c c0x0000 (---------------)  + I cfa
	0x0024d1c3, // n0x009d c0x0000 (---------------)  + I cfd
	0x0021aa82, // n0x009e c0x0000 (---------------)  + I cg
	0x0ca02ac2, // n0x009f c0x0032 (n0x05ad-n0x05ae)  + I ch
	0x002af1c7, // n0x00a0 c0x0000 (---------------)  + I channel
	0x0020f104, // n0x00a1 c0x0000 (---------------)  + I chat
	0x0024c945, // n0x00a2 c0x0000 (---------------)  + I cheap
	0x0029c845, // n0x00a3 c0x0000 (---------------)  + I chloe
	0x0037fc89, // n0x00a4 c0x0000 (---------------)  + I christmas
	0x00384946, // n0x00a5 c0x0000 (---------------)  + I chrome
	0x00313846, // n0x00a6 c0x0000 (---------------)  + I church
	0x0ce20182, // n0x00a7 c0x0033 (n0x05ae-n0x05bd)  + I ci
	0x002629c6, // n0x00a8 c0x0000 (---------------)  + I circle
	0x00320e85, // n0x00a9 c0x0000 (---------------)  + I citic
	0x003242c4, // n0x00aa c0x0000 (---------------)  + I city
	0x003242c8, // n0x00ab c0x0000 (---------------)  + I cityeats
	0x0d206182, // n0x00ac c0x0034 (n0x05bd-n0x05be)* o I ck
	0x0d600402, // n0x00ad c0x0035 (n0x05be-n0x05c2)  + I cl
	0x00351006, // n0x00ae c0x0000 (---------------)  + I claims
	0x002c4108, // n0x00af c0x0000 (---------------)  + I cleaning
	0x00351585, // n0x00b0 c0x0000 (---------------)  + I click
	0x003590c6, // n0x00b1 c0x0000 (---------------)  + I clinic
	0x0037c5c8, // n0x00b2 c0x0000 (---------------)  + I clothing
	0x0034cac4, // n0x00b3 c0x0000 (---------------)  + I club
	0x0daa4442, // n0x00b4 c0x0036 (n0x05c2-n0x05c6)  + I cm
	0x0de2fe42, // n0x00b5 c0x0037 (n0x05c6-n0x05f3)  + I cn
	0x0ea00882, // n0x00b6 c0x003a (n0x05f5-n0x0602)  + I co
	0x0026e4c5, // n0x00b7 c0x0000 (---------------)  + I coach
	0x0027b385, // n0x00b8 c0x0000 (---------------)  + I codes
	0x00273e86, // n0x00b9 c0x0000 (---------------)  + I coffee
	0x00230807, // n0x00ba c0x0000 (---------------)  + I college
	0x00230b07, // n0x00bb c0x0000 (---------------)  + I cologne
	0x0ee32dc3, // n0x00bc c0x003b (n0x0602-n0x06c7)  + I com
	0x002ca648, // n0x00bd c0x0000 (---------------)  + I commbank
	0x00232dc9, // n0x00be c0x0000 (---------------)  + I community
	0x00233487, // n0x00bf c0x0000 (---------------)  + I company
	0x00234a08, // n0x00c0 c0x0000 (---------------)  + I computer
	0x00235206, // n0x00c1 c0x0000 (---------------)  + I condos
	0x00235b0c, // n0x00c2 c0x0000 (---------------)  + I construction
	0x00236b4a, // n0x00c3 c0x0000 (---------------)  + I consulting
	0x0023878b, // n0x00c4 c0x0000 (---------------)  + I contractors
	0x00239887, // n0x00c5 c0x0000 (---------------)  + I cooking
	0x00239ec4, // n0x00c6 c0x0000 (---------------)  + I cool
	0x0023a884, // n0x00c7 c0x0000 (---------------)  + I coop
	0x0023bc07, // n0x00c8 c0x0000 (---------------)  + I corsica
	0x0025d547, // n0x00c9 c0x0000 (---------------)  + I country
	0x0023ebc7, // n0x00ca c0x0000 (---------------)  + I courses
	0x0fe0b542, // n0x00cb c0x003f (n0x06e9-n0x06f0)  + I cr
	0x0023fb86, // n0x00cc c0x0000 (---------------)  + I credit
	0x0023fb8a, // n0x00cd c0x0000 (---------------)  + I creditcard
	0x00240f07, // n0x00ce c0x0000 (---------------)  + I cricket
	0x002426c5, // n0x00cf c0x0000 (---------------)  + I crown
	0x00242803, // n0x00d0 c0x0000 (---------------)  + I crs
	0x002431c7, // n0x00d1 c0x0000 (---------------)  + I cruises
	0x0033ff43, // n0x00d2 c0x0000 (---------------)  + I csc
	0x10243502, // n0x00d3 c0x0040 (n0x06f0-n0x06f6)  + I cu
	0x0024350a, // n0x00d4 c0x0000 (---------------)  + I cuisinella
	0x10733d82, // n0x00d5 c0x0041 (n0x06f6-n0x06f7)  + I cv
	0x10b4c782, // n0x00d6 c0x0042 (n0x06f7-n0x06fb)  + I cw
	0x10e45302, // n0x00d7 c0x0043 (n0x06fb-n0x06fd)  + I cx
	0x0160a6c2, // n0x00d8 c0x0005 (---------------)* o I cy
	0x002c5c05, // n0x00d9 c0x0000 (---------------)  + I cymru
	0x11202882, // n0x00da c0x0044 (n0x06fd-n0x06fe)  + I cz
	0x00229545, // n0x00db c0x0000 (---------------)  + I dabur
	0x0020db83, // n0x00dc c0x0000 (---------------)  + I dad
	0x0030ac05, // n0x00dd c0x0000 (---------------)  + I dance
	0x00218204, // n0x00de c0x0000 (---------------)  + I date
	0x002113c6, // n0x00df c0x0000 (---------------)  + I dating
	0x00202c06, // n0x00e0 c0x0000 (---------------)  + I datsun
	0x00282583, // n0x00e1 c0x0000 (---------------)  + I day
	0x002003c4, // n0x00e2 c0x0000 (---------------)  + I dclk
	0x11607cc2, // n0x00e3 c0x0045 (n0x06fe-n0x0706)  + I de
	0x00381205, // n0x00e4 c0x0000 (---------------)  + I deals
	0x0025f546, // n0x00e5 c0x0000 (---------------)  + I degree
	0x002734c8, // n0x00e6 c0x0000 (---------------)  + I delivery
	0x00231b44, // n0x00e7 c0x0000 (---------------)  + I dell
	0x0037a0c8, // n0x00e8 c0x0000 (---------------)  + I democrat
	0x0033ae86, // n0x00e9 c0x0000 (---------------)  + I dental
	0x00266107, // n0x00ea c0x0000 (---------------)  + I dentist
	0x00237ec4, // n0x00eb c0x0000 (---------------)  + I desi
	0x00237ec6, // n0x00ec c0x0000 (---------------)  + I design
	0x0025e703, // n0x00ed c0x0000 (---------------)  + I dev
	0x002b5b88, // n0x00ee c0x0000 (---------------)  + I diamonds
	0x00300344, // n0x00ef c0x0000 (---------------)  + I diet
	0x0036c3c7, // n0x00f0 c0x0000 (---------------)  + I digital
	0x0032e446, // n0x00f1 c0x0000 (---------------)  + I direct
	0x0032e449, // n0x00f2 c0x0000 (---------------)  + I directory
	0x00322488, // n0x00f3 c0x0000 (---------------)  + I discount
	0x0022ee82, // n0x00f4 c0x0000 (---------------)  + I dj
	0x11aa46c2, // n0x00f5 c0x0046 (n0x0706-n0x0707)  + I dk
	0x11e22502, // n0x00f6 c0x0047 (n0x0707-n0x070c)  + I dm
	0x0035f243, // n0x00f7 c0x0000 (---------------)  + I dnp
	0x12209082, // n0x00f8 c0x0048 (n0x070c-n0x0716)  + I do
	0x0033fec4, // n0x00f9 c0x0000 (---------------)  + I docs
	0x002288c3, // n0x00fa c0x0000 (---------------)  + I dog
	0x00235fc4, // n0x00fb c0x0000 (---------------)  + I doha
	0x002fdd87, // n0x00fc c0x0000 (---------------)  + I domains
	0x002ccb46, // n0x00fd c0x0000 (---------------)  + I doosan
	0x00369948, // n0x00fe c0x0000 (---------------)  + I download
	0x002e0d46, // n0x00ff c0x0000 (---------------)  + I durban
	0x00309cc4, // n0x0100 c0x0000 (---------------)  + I dvag
	0x1260fa42, // n0x0101 c0x0049 (n0x0716-n0x071e)  + I dz
	0x002412c5, // n0x0102 c0x0000 (---------------)  + I earth
	0x002f5f43, // n0x0103 c0x0000 (---------------)  + I eat
	0x12a02082, // n0x0104 c0x004a (n0x071e-n0x072a)  + I ec
	0x0022f445, // n0x0105 c0x0000 (---------------)  + I edeka
	0x0021e083, // n0x0106 c0x0000 (---------------)  + I edu
	0x0021e089, // n0x0107 c0x0000 (---------------)  + I education
	0x12e00642, // n0x0108 c0x004b (n0x072a-n0x0734)  + I ee
	0x13205d82, // n0x0109 c0x004c (n0x0734-n0x073d)  + I eg
	0x002e1d05, // n0x010a c0x0000 (---------------)  + I email
	0x0036ccc6, // n0x010b c0x0000 (---------------)  + I emerck
	0x002bf046, // n0x010c c0x0000 (---------------)  + I energy
	0x0030dc48, // n0x010d c0x0000 (---------------)  + I engineer
	0x0030dc4b, // n0x010e c0x0000 (---------------)  + I engineering
	0x002ec28b, // n0x010f c0x0000 (---------------)  + I enterprises
	0x00218b85, // n0x0110 c0x0000 (---------------)  + I epson
	0x002126c9, // n0x0111 c0x0000 (---------------)  + I equipment
	0x01600682, // n0x0112 c0x0005 (---------------)* o I er
	0x0020ce04, // n0x0113 c0x0000 (---------------)  + I erni
	0x13601e42, // n0x0114 c0x004d (n0x073d-n0x0742)  + I es
	0x00364fc3, // n0x0115 c0x0000 (---------------)  + I esq
	0x0025d706, // n0x0116 c0x0000 (---------------)  + I estate
	0x13e02e82, // n0x0117 c0x004f (n0x0743-n0x074a)  + I et
	0x0021b882, // n0x0118 c0x0000 (---------------)  + I eu
	0x00319f4a, // n0x0119 c0x0000 (---------------)  + I eurovision
	0x002bbd83, // n0x011a c0x0000 (---------------)  + I eus
	0x0020d306, // n0x011b c0x0000 (---------------)  + I events
	0x0021c748, // n0x011c c0x0000 (---------------)  + I everbank
	0x002ed008, // n0x011d c0x0000 (---------------)  + I exchange
	0x00319806, // n0x011e c0x0000 (---------------)  + I expert
	0x00305347, // n0x011f c0x0000 (---------------)  + I exposed
	0x0034f0c4, // n0x0120 c0x0000 (---------------)  + I fage
	0x00320744, // n0x0121 c0x0000 (---------------)  + I fail
	0x00331989, // n0x0122 c0x0000 (---------------)  + I fairwinds
	0x00358745, // n0x0123 c0x0000 (---------------)  + I faith
	0x0021a1c3, // n0x0124 c0x0000 (---------------)  + I fan
	0x002ea804, // n0x0125 c0x0000 (---------------)  + I fans
	0x002125c4, // n0x0126 c0x0000 (---------------)  + I farm
	0x002c9c47, // n0x0127 c0x0000 (---------------)  + I fashion
	0x002d0e44, // n0x0128 c0x0000 (---------------)  + I fast
	0x00273f48, // n0x0129 c0x0000 (---------------)  + I feedback
	0x00245847, // n0x012a c0x0000 (---------------)  + I ferrero
	0x14206f02, // n0x012b c0x0050 (n0x074a-n0x074d)  + I fi
	0x00248145, // n0x012c c0x0000 (---------------)  + I final
	0x002483c7, // n0x012d c0x0000 (---------------)  + I finance
	0x00244909, // n0x012e c0x0000 (---------------)  + I financial
	0x00249ac9, // n0x012f c0x0000 (---------------)  + I firestone
	0x0024a308, // n0x0130 c0x0000 (---------------)  + I firmdale
	0x0024ac04, // n0x0131 c0x0000 (---------------)  + I fish
	0x0024ac07, // n0x0132 c0x0000 (---------------)  + I fishing
	0x0024b083, // n0x0133 c0x0000 (---------------)  + I fit
	0x0024b207, // n0x0134 c0x0000 (---------------)  + I fitness
	0x01613802, // n0x0135 c0x0005 (---------------)* o I fj
	0x016a1842, // n0x0136 c0x0005 (---------------)* o I fk
	0x0024cd47, // n0x0137 c0x0000 (---------------)  + I flights
	0x0024e1c7, // n0x0138 c0x0000 (---------------)  + I florist
	0x0024ed07, // n0x0139 c0x0000 (---------------)  + I flowers
	0x0024f088, // n0x013a c0x0000 (---------------)  + I flsmidth
	0x0024f743, // n0x013b c0x0000 (---------------)  + I fly
	0x00257f82, // n0x013c c0x0000 (---------------)  + I fm
	0x00208ac2, // n0x013d c0x0000 (---------------)  + I fo
	0x00250343, // n0x013e c0x0000 (---------------)  + I foo
	0x00250348, // n0x013f c0x0000 (---------------)  + I football
	0x00381144, // n0x0140 c0x0000 (---------------)  + I ford
	0x002527c5, // n0x0141 c0x0000 (---------------)  + I forex
	0x00253887, // n0x0142 c0x0000 (---------------)  + I forsale
	0x002d994a, // n0x0143 c0x0000 (---------------)  + I foundation
	0x1462fc02, // n0x0144 c0x0051 (n0x074d-n0x0765)  + I fr
	0x0025ba03, // n0x0145 c0x0000 (---------------)  + I frl
	0x0025bac7, // n0x0146 c0x0000 (---------------)  + I frogans
	0x0027bdc4, // n0x0147 c0x0000 (---------------)  + I fund
	0x0027da49, // n0x0148 c0x0000 (---------------)  + I furniture
	0x00280e06, // n0x0149 c0x0000 (---------------)  + I futbol
	0x00200fc2, // n0x014a c0x0000 (---------------)  + I ga
	0x00237383, // n0x014b c0x0000 (---------------)  + I gal
	0x00237387, // n0x014c c0x0000 (---------------)  + I gallery
	0x002196c6, // n0x014d c0x0000 (---------------)  + I garden
	0x0020cd02, // n0x014e c0x0000 (---------------)  + I gb
	0x0035acc4, // n0x014f c0x0000 (---------------)  + I gbiz
	0x00218cc2, // n0x0150 c0x0000 (---------------)  + I gd
	0x002dd243, // n0x0151 c0x0000 (---------------)  + I gdn
	0x14a029c2, // n0x0152 c0x0052 (n0x0765-n0x076c)  + I ge
	0x00250803, // n0x0153 c0x0000 (---------------)  + I gea
	0x00307a04, // n0x0154 c0x0000 (---------------)  + I gent
	0x00282142, // n0x0155 c0x0000 (---------------)  + I gf
	0x14e08b42, // n0x0156 c0x0053 (n0x076c-n0x076f)  + I gg
	0x0032e684, // n0x0157 c0x0000 (---------------)  + I ggee
	0x1520db02, // n0x0158 c0x0054 (n0x076f-n0x0774)  + I gh
	0x15608b82, // n0x0159 c0x0055 (n0x0774-n0x077a)  + I gi
	0x0034d5c4, // n0x015a c0x0000 (---------------)  + I gift
	0x0034d5c5, // n0x015b c0x0000 (---------------)  + I gifts
	0x002be445, // n0x015c c0x0000 (---------------)  + I gives
	0x00219b06, // n0x015d c0x0000 (---------------)  + I giving
	0x002079c2, // n0x015e c0x0000 (---------------)  + I gl
	0x0036f445, // n0x015f c0x0000 (---------------)  + I glass
	0x00224c83, // n0x0160 c0x0000 (---------------)  + I gle
	0x0020af86, // n0x0161 c0x0000 (---------------)  + I global
	0x0020ff85, // n0x0162 c0x0000 (---------------)  + I globo
	0x00219c42, // n0x0163 c0x0000 (---------------)  + I gm
	0x00219c45, // n0x0164 c0x0000 (---------------)  + I gmail
	0x00226f83, // n0x0165 c0x0000 (---------------)  + I gmo
	0x0022cd43, // n0x0166 c0x0000 (---------------)  + I gmx
	0x15a0c982, // n0x0167 c0x0056 (n0x077a-n0x0780)  + I gn
	0x00218749, // n0x0168 c0x0000 (---------------)  + I goldpoint
	0x0024ad84, // n0x0169 c0x0000 (---------------)  + I golf
	0x0027b203, // n0x016a c0x0000 (---------------)  + I goo
	0x0027b204, // n0x016b c0x0000 (---------------)  + I goog
	0x0027b206, // n0x016c c0x0000 (---------------)  + I google
	0x00297e83, // n0x016d c0x0000 (---------------)  + I gop
	0x00252ac3, // n0x016e c0x0000 (---------------)  + I got
	0x00209ac3, // n0x016f c0x0000 (---------------)  + I gov
	0x15ed2d02, // n0x0170 c0x0057 (n0x0780-n0x0786)  + I gp
	0x0022d4c2, // n0x0171 c0x0000 (---------------)  + I gq
	0x16206b02, // n0x0172 c0x0058 (n0x0786-n0x078c)  + I gr
	0x00376d88, // n0x0173 c0x0000 (---------------)  + I graphics
	0x0035bd86, // n0x0174 c0x0000 (---------------)  + I gratis
	0x00252ec5, // n0x0175 c0x0000 (---------------)  + I green
	0x00351a05, // n0x0176 c0x0000 (---------------)  + I gripe
	0x00226905, // n0x0177 c0x0000 (---------------)  + I group
	0x00209602, // n0x0178 c0x0000 (---------------)  + I gs
	0x166002c2, // n0x0179 c0x0059 (n0x078c-n0x0793)  + I gt
	0x01602642, // n0x017a c0x0005 (---------------)* o I gu
	0x00262905, // n0x017b c0x0000 (---------------)  + I gucci
	0x002ce404, // n0x017c c0x0000 (---------------)  + I guge
	0x00242d05, // n0x017d c0x0000 (---------------)  + I guide
	0x00246107, // n0x017e c0x0000 (---------------)  + I guitars
	0x00261244, // n0x017f c0x0000 (---------------)  + I guru
	0x002252c2, // n0x0180 c0x0000 (---------------)  + I gw
	0x16a04f82, // n0x0181 c0x005a (n0x0793-n0x0796)  + I gy
	0x0036f2c7, // n0x0182 c0x0000 (---------------)  + I hamburg
	0x0037e007, // n0x0183 c0x0000 (---------------)  + I hangout
	0x00362f84, // n0x0184 c0x0000 (---------------)  + I haus
	0x00241cca, // n0x0185 c0x0000 (---------------)  + I healthcare
	0x002cbd84, // n0x0186 c0x0000 (---------------)  + I help
	0x00241484, // n0x0187 c0x0000 (---------------)  + I here
	0x002a7806, // n0x0188 c0x0000 (---------------)  + I hermes
	0x00347706, // n0x0189 c0x0000 (---------------)  + I hiphop
	0x00276b07, // n0x018a c0x0000 (---------------)  + I hitachi
	0x00262843, // n0x018b c0x0000 (---------------)  + I hiv
	0x16e301c2, // n0x018c c0x005b (n0x0796-n0x07ae)  + I hk
	0x0024c142, // n0x018d c0x0000 (---------------)  + I hm
	0x17206802, // n0x018e c0x005c (n0x07ae-n0x07b4)  + I hn
	0x0033b8c8, // n0x018f c0x0000 (---------------)  + I holdings
	0x00299247, // n0x0190 c0x0000 (---------------)  + I holiday
	0x002998c5, // n0x0191 c0x0000 (---------------)  + I homes
	0x0029a305, // n0x0192 c0x0000 (---------------)  + I honda
	0x0029cbc5, // n0x0193 c0x0000 (---------------)  + I horse
	0x00208344, // n0x0194 c0x0000 (---------------)  + I host
	0x0028cdc7, // n0x0195 c0x0000 (---------------)  + I hosting
	0x0029ea07, // n0x0196 c0x0000 (---------------)  + I hotmail
	0x0022ca85, // n0x0197 c0x0000 (---------------)  + I house
	0x002cfd43, // n0x0198 c0x0000 (---------------)  + I how
	0x17636902, // n0x0199 c0x005d (n0x07b4-n0x07b8)  + I hr
	0x002144c4, // n0x019a c0x0000 (---------------)  + I hsbc
	0x17a496c2, // n0x019b c0x005e (n0x07b8-n0x07c9)  + I ht
	0x17e045c2, // n0x019c c0x005f (n0x07c9-n0x07e9)  + I hu
	0x002da443, // n0x019d c0x0000 (---------------)  + I ibm
	0x00207ac3, // n0x019e c0x0000 (---------------)  + I ice
	0x18205942, // n0x019f c0x0060 (n0x07e9-n0x07f4)  + I id
	0x18600042, // n0x01a0 c0x0061 (n0x07f4-n0x07f6)  + I ie
	0x00257f43, // n0x01a1 c0x0000 (---------------)  + I ifm
	0x00363745, // n0x01a2 c0x0000 (---------------)  + I iinet
	0x18a00d82, // n0x01a3 c0x0062 (n0x07f6-n0x07f7)* o I il
	0x192051c2, // n0x01a4 c0x0064 (n0x07f8-n0x07ff)  + I im
	0x002ed984, // n0x01a5 c0x0000 (---------------)  + I immo
	0x002ed98a, // n0x01a6 c0x0000 (---------------)  + I immobilien
	0x19a00242, // n0x01a7 c0x0066 (n0x0801-n0x080e)  + I in
	0x0038360a, // n0x01a8 c0x0000 (---------------)  + I industries
	0x00206e88, // n0x01a9 c0x0000 (---------------)  + I infiniti
	0x19e08a44, // n0x01aa c0x0067 (n0x080e-n0x0818)  + I info
	0x00200243, // n0x01ab c0x0000 (---------------)  + I ing
	0x0020ec03, // n0x01ac c0x0000 (---------------)  + I ink
	0x003111c9, // n0x01ad c0x0000 (---------------)  + I institute
	0x0020e7c6, // n0x01ae c0x0000 (---------------)  + I insure
	0x1a2188c3, // n0x01af c0x0068 (n0x0818-n0x0819)  + I int
	0x002f02cd, // n0x01b0 c0x0000 (---------------)  + I international
	0x0021560b, // n0x01b1 c0x0000 (---------------)  + I investments
	0x1a601542, // n0x01b2 c0x0069 (n0x0819-n0x081c)  + I io
	0x00341348, // n0x01b3 c0x0000 (---------------)  + I ipiranga
	0x1aa06c42, // n0x01b4 c0x006a (n0x081c-n0x0822)  + I iq
	0x1ae07042, // n0x01b5 c0x006b (n0x0822-n0x082b)  + I ir
	0x002cb045, // n0x01b6 c0x0000 (---------------)  + I irish
	0x1b2066c2, // n0x01b7 c0x006c (n0x082b-n0x0832)  + I is
	0x002066c3, // n0x01b8 c0x0000 (---------------)  + I ist
	0x002148c8, // n0x01b9 c0x0000 (---------------)  + I istanbul
	0x1b6014c2, // n0x01ba c0x006d (n0x0832-n0x09a3)  + I it
	0x00212204, // n0x01bb c0x0000 (---------------)  + I itau
	0x002a0d03, // n0x01bc c0x0000 (---------------)  + I iwc
	0x00229dc6, // n0x01bd c0x0000 (---------------)  + I jaguar
	0x00333644, // n0x01be c0x0000 (---------------)  + I java
	0x0025cf83, // n0x01bf c0x0000 (---------------)  + I jcb
	0x1ba0c582, // n0x01c0 c0x006e (n0x09a3-n0x09a6)  + I je
	0x0032fcc5, // n0x01c1 c0x0000 (---------------)  + I jetzt
	0x002a1cc3, // n0x01c2 c0x0000 (---------------)  + I jlc
	0x01770dc2, // n0x01c3 c0x0005 (---------------)* o I jm
	0x1be02e02, // n0x01c4 c0x006f (n0x09a6-n0x09ae)  + I jo
	0x0027e604, // n0x01c5 c0x0000 (---------------)  + I jobs
	0x00207886, // n0x01c6 c0x0000 (---------------)  + I joburg
	0x00324543, // n0x01c7 c0x0000 (---------------)  + I jot
	0x002a2383, // n0x01c8 c0x0000 (---------------)  + I joy
	0x1c2a2b02, // n0x01c9 c0x0070 (n0x09ae-n0x0a1d)  + I jp
	0x002a2bc4, // n0x01ca c0x0000 (---------------)  + I jprs
	0x002d1e86, // n0x01cb c0x0000 (---------------)  + I juegos
	0x00223286, // n0x01cc c0x0000 (---------------)  + I kaufen
	0x00359e04, // n0x01cd c0x0000 (---------------)  + I kddi
	0x01601e02, // n0x01ce c0x0005 (---------------)* o I ke
	0x003796c3, // n0x01cf c0x0000 (---------------)  + I kfh
	0x29f797c2, // n0x01d0 c0x00a7 (n0x10b1-n0x10b7)  + I kg
	0x016230c2, // n0x01d1 c0x0005 (---------------)* o I kh
	0x2a205482, // n0x01d2 c0x00a8 (n0x10b7-n0x10be)  + I ki
	0x002d2083, // n0x01d3 c0x0000 (---------------)  + I kim
	0x00385086, // n0x01d4 c0x0000 (---------------)  + I kinder
	0x002c9407, // n0x01d5 c0x0000 (---------------)  + I kitchen
	0x00382c84, // n0x01d6 c0x0000 (---------------)  + I kiwi
	0x2a686642, // n0x01d7 c0x00a9 (n0x10be-n0x10cf)  + I km
	0x2aa33fc2, // n0x01d8 c0x00aa (n0x10cf-n0x10d3)  + I kn
	0x0024db85, // n0x01d9 c0x0000 (---------------)  + I koeln
	0x2ae2b602, // n0x01da c0x00ab (n0x10d3-n0x10d9)  + I kp
	0x2b20c642, // n0x01db c0x00ac (n0x10d9-n0x10f7)  + I kr
	0x0032f143, // n0x01dc c0x0000 (---------------)  + I krd
	0x002a4b04, // n0x01dd c0x0000 (---------------)  + I kred
	0x016b1bc2, // n0x01de c0x0005 (---------------)* o I kw
	0x2b611002, // n0x01df c0x00ad (n0x10f7-n0x10fc)  + I ky
	0x00262fc5, // n0x01e0 c0x0000 (---------------)  + I kyoto
	0x2bb713c2, // n0x01e1 c0x00ae (n0x10fc-n0x1102)  + I kz
	0x2be000c2, // n0x01e2 c0x00af (n0x1102-n0x110b)  + I la
	0x0031fb47, // n0x01e3 c0x0000 (---------------)  + I lacaixa
	0x00215d44, // n0x01e4 c0x0000 (---------------)  + I land
	0x00365949, // n0x01e5 c0x0000 (---------------)  + I landrover
	0x0020b0c3, // n0x01e6 c0x0000 (---------------)  + I lat
	0x00215907, // n0x01e7 c0x0000 (---------------)  + I latrobe
	0x00279cc6, // n0x01e8 c0x0000 (---------------)  + I lawyer
	0x2c207682, // n0x01e9 c0x00b0 (n0x110b-n0x1110)  + I lb
	0x2c61e302, // n0x01ea c0x00b1 (n0x1110-n0x1116)  + I lc
	0x0022be83, // n0x01eb c0x0000 (---------------)  + I lds
	0x002e6085, // n0x01ec c0x0000 (---------------)  + I lease
	0x0024a487, // n0x01ed c0x0000 (---------------)  + I leclerc
	0x002539c5, // n0x01ee c0x0000 (---------------)  + I legal
	0x0031b204, // n0x01ef c0x0000 (---------------)  + I lgbt
	0x00206682, // n0x01f0 c0x0000 (---------------)  + I li
	0x0032d987, // n0x01f1 c0x0000 (---------------)  + I liaison
	0x002b0704, // n0x01f2 c0x0000 (---------------)  + I lidl
	0x00276fc4, // n0x01f3 c0x0000 (---------------)  + I life
	0x00276fc9, // n0x01f4 c0x0000 (---------------)  + I lifestyle
	0x00249608, // n0x01f5 c0x0000 (---------------)  + I lighting
	0x002222c4, // n0x01f6 c0x0000 (---------------)  + I like
	0x00360047, // n0x01f7 c0x0000 (---------------)  + I limited
	0x002da104, // n0x01f8 c0x0000 (---------------)  + I limo
	0x00376747, // n0x01f9 c0x0000 (---------------)  + I lincoln
	0x002fce05, // n0x01fa c0x0000 (---------------)  + I linde
	0x003631c4, // n0x01fb c0x0000 (---------------)  + I link
	0x0025a6c4, // n0x01fc c0x0000 (---------------)  + I live
	0x2ca00442, // n0x01fd c0x00b2 (n0x1116-n0x1124)  + I lk
	0x00245c84, // n0x01fe c0x0000 (---------------)  + I loan
	0x00245c85, // n0x01ff c0x0000 (---------------)  + I loans
	0x0021d286, // n0x0200 c0x0000 (---------------)  + I london
	0x00220945, // n0x0201 c0x0000 (---------------)  + I lotte
	0x00220f45, // n0x0202 c0x0000 (---------------)  + I lotto
	0x2ce81742, // n0x0203 c0x00b3 (n0x1124-n0x1129)  + I lr
	0x2d200dc2, // n0x0204 c0x00b4 (n0x1129-n0x112b)  + I ls
	0x2d61a082, // n0x0205 c0x00b5 (n0x112b-n0x112c)  + I lt
	0x00220e43, // n0x0206 c0x0000 (---------------)  + I ltd
	0x00220e44, // n0x0207 c0x0000 (---------------)  + I ltda
	0x00208042, // n0x0208 c0x0000 (---------------)  + I lu
	0x00359cc5, // n0x0209 c0x0000 (---------------)  + I lupin
	0x00242ac4, // n0x020a c0x0000 (---------------)  + I luxe
	0x00244e86, // n0x020b c0x0000 (---------------)  + I luxury
	0x2da18582, // n0x020c c0x00b6 (n0x112c-n0x1135)  + I lv
	0x2de3a682, // n0x020d c0x00b7 (n0x1135-n0x113e)  + I ly
	0x2e2011c2, // n0x020e c0x00b8 (n0x113e-n0x1144)  + I ma
	0x00309b86, // n0x020f c0x0000 (---------------)  + I madrid
	0x002fa184, // n0x0210 c0x0000 (---------------)  + I maif
	0x002ee706, // n0x0211 c0x0000 (---------------)  + I maison
	0x00211c83, // n0x0212 c0x0000 (---------------)  + I man
	0x0028ff4a, // n0x0213 c0x0000 (---------------)  + I management
	0x00264145, // n0x0214 c0x0000 (---------------)  + I mango
	0x00226d86, // n0x0215 c0x0000 (---------------)  + I market
	0x00226d89, // n0x0216 c0x0000 (---------------)  + I marketing
	0x00252087, // n0x0217 c0x0000 (---------------)  + I markets
	0x00288408, // n0x0218 c0x0000 (---------------)  + I marriott
	0x2e60f0c2, // n0x0219 c0x00b9 (n0x1144-n0x1146)  + I mc
	0x0024a3c2, // n0x021a c0x0000 (---------------)  + I md
	0x2ea04342, // n0x021b c0x00ba (n0x1146-n0x114e)  + I me
	0x0021e585, // n0x021c c0x0000 (---------------)  + I media
	0x0028c584, // n0x021d c0x0000 (---------------)  + I meet
	0x00242109, // n0x021e c0x0000 (---------------)  + I melbourne
	0x0036cc84, // n0x021f c0x0000 (---------------)  + I meme
	0x0035fe88, // n0x0220 c0x0000 (---------------)  + I memorial
	0x0020fd04, // n0x0221 c0x0000 (---------------)  + I menu
	0x0020f283, // n0x0222 c0x0000 (---------------)  + I meo
	0x2ef39dc2, // n0x0223 c0x00bb (n0x114e-n0x1156)  + I mg
	0x002e9dc2, // n0x0224 c0x0000 (---------------)  + I mh
	0x0033e685, // n0x0225 c0x0000 (---------------)  + I miami
	0x00264e49, // n0x0226 c0x0000 (---------------)  + I microsoft
	0x00240443, // n0x0227 c0x0000 (---------------)  + I mil
	0x002769c4, // n0x0228 c0x0000 (---------------)  + I mini
	0x2f340582, // n0x0229 c0x00bc (n0x1156-n0x115d)  + I mk
	0x2f614302, // n0x022a c0x00bd (n0x115d-n0x1164)  + I ml
	0x0160fcc2, // n0x022b c0x0005 (---------------)* o I mm
	0x0034fa03, // n0x022c c0x0000 (---------------)  + I mma
	0x2fa2c7c2, // n0x022d c0x00be (n0x1164-n0x1168)  + I mn
	0x2fe05202, // n0x022e c0x00bf (n0x1168-n0x116d)  + I mo
	0x00277f84, // n0x022f c0x0000 (---------------)  + I mobi
	0x00353b86, // n0x0230 c0x0000 (---------------)  + I mobily
	0x00226fc4, // n0x0231 c0x0000 (---------------)  + I moda
	0x002d2283, // n0x0232 c0x0000 (---------------)  + I moe
	0x00205203, // n0x0233 c0x0000 (---------------)  + I moi
	0x0023fec6, // n0x0234 c0x0000 (---------------)  + I monash
	0x002bac05, // n0x0235 c0x0000 (---------------)  + I money
	0x00222549, // n0x0236 c0x0000 (---------------)  + I montblanc
	0x002bab46, // n0x0237 c0x0000 (---------------)  + I mormon
	0x002bb948, // n0x0238 c0x0000 (---------------)  + I mortgage
	0x002bbb46, // n0x0239 c0x0000 (---------------)  + I moscow
	0x0029088b, // n0x023a c0x0000 (---------------)  + I motorcycles
	0x002bd483, // n0x023b c0x0000 (---------------)  + I mov
	0x002bd488, // n0x023c c0x0000 (---------------)  + I movistar
	0x00203302, // n0x023d c0x0000 (---------------)  + I mp
	0x0031fe42, // n0x023e c0x0000 (---------------)  + I mq
	0x30214202, // n0x023f c0x00c0 (n0x116d-n0x116f)  + I mr
	0x3060e602, // n0x0240 c0x00c1 (n0x116f-n0x1174)  + I ms
	0x30a66782, // n0x0241 c0x00c2 (n0x1174-n0x1178)  + I mt
	0x00266783, // n0x0242 c0x0000 (---------------)  + I mtn
	0x002bd784, // n0x0243 c0x0000 (---------------)  + I mtpc
	0x30e03b02, // n0x0244 c0x00c3 (n0x1178-n0x117f)  + I mu
	0x312c2a06, // n0x0245 c0x00c4 (n0x117f-n0x13a3)  + I museum
	0x31604102, // n0x0246 c0x00c5 (n0x13a3-n0x13b1)  + I mv
	0x31a12542, // n0x0247 c0x00c6 (n0x13b1-n0x13bc)  + I mw
	0x31e2cd82, // n0x0248 c0x00c7 (n0x13bc-n0x13c2)  + I mx
	0x32224782, // n0x0249 c0x00c8 (n0x13c2-n0x13c9)  + I my
	0x326cbb02, // n0x024a c0x00c9 (n0x13c9-n0x13ca)* o I mz
	0x32a015c2, // n0x024b c0x00ca (n0x13ca-n0x13db)  + I na
	0x002ecf45, // n0x024c c0x0000 (---------------)  + I nadex
	0x0037bf46, // n0x024d c0x0000 (---------------)  + I nagoya
	0x32e67944, // n0x024e c0x00cb (n0x13db-n0x13dd)  + I name
	0x00204a04, // n0x024f c0x0000 (---------------)  + I navy
	0x33a0a682, // n0x0250 c0x00ce (n0x13df-n0x13e0)  + I nc
	0x00209e82, // n0x0251 c0x0000 (---------------)  + I ne
	0x33e18643, // n0x0252 c0x00cf (n0x13e0-n0x140f)  + I net
	0x00371247, // n0x0253 c0x0000 (---------------)  + I netbank
	0x0030cd07, // n0x0254 c0x0000 (---------------)  + I network
	0x002c0107, // n0x0255 c0x0000 (---------------)  + I neustar
	0x00216703, // n0x0256 c0x0000 (---------------)  + I new
	0x00234584, // n0x0257 c0x0000 (---------------)  + I news
	0x00249c85, // n0x0258 c0x0000 (---------------)  + I nexus
	0x34e06ec2, // n0x0259 c0x00d3 (n0x1416-n0x1420)  + I nf
	0x35200282, // n0x025a c0x00d4 (n0x1420-n0x1429)  + I ng
	0x0024ad43, // n0x025b c0x0000 (---------------)  + I ngo
	0x00267203, // n0x025c c0x0000 (---------------)  + I nhk
	0x01602382, // n0x025d c0x0005 (---------------)* o I ni
	0x00359184, // n0x025e c0x0000 (---------------)  + I nico
	0x002bd205, // n0x025f c0x0000 (---------------)  + I ninja
	0x00225906, // n0x0260 c0x0000 (---------------)  + I nissan
	0x35648cc2, // n0x0261 c0x00d5 (n0x1429-n0x142c)  + I nl
	0x35a00cc2, // n0x0262 c0x00d6 (n0x142c-n0x1702)  + I no
	0x00305a06, // n0x0263 c0x0000 (---------------)  + I norton
	0x00352f46, // n0x0264 c0x0000 (---------------)  + I nowruz
	0x01612b02, // n0x0265 c0x0005 (---------------)* o I np
	0x3de1ccc2, // n0x0266 c0x00f7 (n0x172a-n0x1731)  + I nr
	0x002f09c3, // n0x0267 c0x0000 (---------------)  + I nra
	0x0022d2c3, // n0x0268 c0x0000 (---------------)  + I nrw
	0x0034b343, // n0x0269 c0x0000 (---------------)  + I ntt
	0x3e20fd82, // n0x026a c0x00f8 (n0x1731-n0x1734)  + I nu
	0x0021af43, // n0x026b c0x0000 (---------------)  + I nyc
	0x3e613002, // n0x026c c0x00f9 (n0x1734-n0x1744)  + I nz
	0x00213483, // n0x026d c0x0000 (---------------)  + I obi
	0x002130c7, // n0x026e c0x0000 (---------------)  + I okinawa
	0x3ee087c2, // n0x026f c0x00fb (n0x1745-n0x174e)  + I om
	0x002166c3, // n0x0270 c0x0000 (---------------)  + I one
	0x00218c43, // n0x0271 c0x0000 (---------------)  + I ong
	0x0030be03, // n0x0272 c0x0000 (---------------)  + I onl
	0x00294bc3, // n0x0273 c0x0000 (---------------)  + I ooo
	0x002c4046, // n0x0274 c0x0000 (---------------)  + I oracle
	0x3f24d043, // n0x0275 c0x00fc (n0x174e-n0x1784)  + I org
	0x0024d047, // n0x0276 c0x0000 (---------------)  + I organic
	0x002905c5, // n0x0277 c0x0000 (---------------)  + I osaka
	0x0024b686, // n0x0278 c0x0000 (---------------)  + I otsuka
	0x00283083, // n0x0279 c0x0000 (---------------)  + I ovh
	0x3fa00ac2, // n0x027a c0x00fe (n0x1786-n0x1791)  + I pa
	0x0035f2c4, // n0x027b c0x0000 (---------------)  + I page
	0x00243a87, // n0x027c c0x0000 (---------------)  + I panerai
	0x00256585, // n0x027d c0x0000 (---------------)  + I paris
	0x0028e704, // n0x027e c0x0000 (---------------)  + I pars
	0x002acc08, // n0x027f c0x0000 (---------------)  + I partners
	0x002b9345, // n0x0280 c0x0000 (---------------)  + I parts
	0x002c7745, // n0x0281 c0x0000 (---------------)  + I party
	0x3fe0c782, // n0x0282 c0x00ff (n0x1791-n0x1798)  + I pe
	0x4034dec2, // n0x0283 c0x0100 (n0x1798-n0x179b)  + I pf
	0x016a6f42, // n0x0284 c0x0005 (---------------)* o I pg
	0x40606bc2, // n0x0285 c0x0101 (n0x179b-n0x17a3)  + I ph
	0x002c5a88, // n0x0286 c0x0000 (---------------)  + I pharmacy
	0x002c6747, // n0x0287 c0x0000 (---------------)  + I philips
	0x002a75c5, // n0x0288 c0x0000 (---------------)  + I photo
	0x002c718b, // n0x0289 c0x0000 (---------------)  + I photography
	0x002c30c6, // n0x028a c0x0000 (---------------)  + I photos
	0x002c7386, // n0x028b c0x0000 (---------------)  + I physio
	0x002c7506, // n0x028c c0x0000 (---------------)  + I piaget
	0x00221f84, // n0x028d c0x0000 (---------------)  + I pics
	0x002c80c6, // n0x028e c0x0000 (---------------)  + I pictet
	0x002c8648, // n0x028f c0x0000 (---------------)  + I pictures
	0x00246c03, // n0x0290 c0x0000 (---------------)  + I pin
	0x00359d44, // n0x0291 c0x0000 (---------------)  + I pink
	0x002c9e05, // n0x0292 c0x0000 (---------------)  + I pizza
	0x40ac9f42, // n0x0293 c0x0102 (n0x17a3-n0x17b1)  + I pk
	0x40e0a402, // n0x0294 c0x0103 (n0x17b1-n0x1856)  + I pl
	0x0020a405, // n0x0295 c0x0000 (---------------)  + I place
	0x002cc348, // n0x0296 c0x0000 (---------------)  + I plumbing
	0x002127c2, // n0x0297 c0x0000 (---------------)  + I pm
	0x416a2b42, // n0x0298 c0x0105 (n0x185f-n0x1864)  + I pn
	0x002cd0c4, // n0x0299 c0x0000 (---------------)  + I pohl
	0x002cd1c5, // n0x029a c0x0000 (---------------)  + I poker
	0x002cdf44, // n0x029b c0x0000 (---------------)  + I porn
	0x002ce7c4, // n0x029c c0x0000 (---------------)  + I post
	0x41a2ad42, // n0x029d c0x0106 (n0x1864-n0x1871)  + I pr
	0x0026a2c5, // n0x029e c0x0000 (---------------)  + I praxi
	0x0022ad45, // n0x029f c0x0000 (---------------)  + I press
	0x41ecfc43, // n0x02a0 c0x0107 (n0x1871-n0x1878)  + I pro
	0x002cfec4, // n0x02a1 c0x0000 (---------------)  + I prod
	0x002cfecb, // n0x02a2 c0x0000 (---------------)  + I productions
	0x002d0d84, // n0x02a3 c0x0000 (---------------)  + I prof
	0x002d1505, // n0x02a4 c0x0000 (---------------)  + I promo
	0x002d284a, // n0x02a5 c0x0000 (---------------)  + I properties
	0x002d2d48, // n0x02a6 c0x0000 (---------------)  + I property
	0x42218402, // n0x02a7 c0x0108 (n0x1878-n0x187f)  + I ps
	0x4269ab02, // n0x02a8 c0x0109 (n0x187f-n0x1888)  + I pt
	0x0025dbc3, // n0x02a9 c0x0000 (---------------)  + I pub
	0x42b76602, // n0x02aa c0x010a (n0x1888-n0x188e)  + I pw
	0x42eb9882, // n0x02ab c0x010b (n0x188e-n0x1895)  + I py
	0x43304ec2, // n0x02ac c0x010c (n0x1895-n0x189d)  + I qa
	0x0023f144, // n0x02ad c0x0000 (---------------)  + I qpon
	0x0021b2c6, // n0x02ae c0x0000 (---------------)  + I quebec
	0x00367706, // n0x02af c0x0000 (---------------)  + I racing
	0x43607082, // n0x02b0 c0x010d (n0x189d-n0x18a1)  + I re
	0x002c6184, // n0x02b1 c0x0000 (---------------)  + I read
	0x002ff907, // n0x02b2 c0x0000 (---------------)  + I realtor
	0x0022a147, // n0x02b3 c0x0000 (---------------)  + I recipes
	0x0023fbc3, // n0x02b4 c0x0000 (---------------)  + I red
	0x002a4b48, // n0x02b5 c0x0000 (---------------)  + I redstone
	0x0027dc05, // n0x02b6 c0x0000 (---------------)  + I rehab
	0x0020e8c5, // n0x02b7 c0x0000 (---------------)  + I reise
	0x0020e8c6, // n0x02b8 c0x0000 (---------------)  + I reisen
	0x002aa044, // n0x02b9 c0x0000 (---------------)  + I reit
	0x0020ae03, // n0x02ba c0x0000 (---------------)  + I ren
	0x0029e644, // n0x02bb c0x0000 (---------------)  + I rent
	0x002d9407, // n0x02bc c0x0000 (---------------)  + I rentals
	0x00222886, // n0x02bd c0x0000 (---------------)  + I repair
	0x002f0f86, // n0x02be c0x0000 (---------------)  + I report
	0x002d7e4a, // n0x02bf c0x0000 (---------------)  + I republican
	0x00247204, // n0x02c0 c0x0000 (---------------)  + I rest
	0x0024720a, // n0x02c1 c0x0000 (---------------)  + I restaurant
	0x00311dc6, // n0x02c2 c0x0000 (---------------)  + I review
	0x00311dc7, // n0x02c3 c0x0000 (---------------)  + I reviews
	0x00296ec4, // n0x02c4 c0x0000 (---------------)  + I rich
	0x00203d05, // n0x02c5 c0x0000 (---------------)  + I ricoh
	0x0020ef83, // n0x02c6 c0x0000 (---------------)  + I rio
	0x00351a43, // n0x02c7 c0x0000 (---------------)  + I rip
	0x43a00982, // n0x02c8 c0x010e (n0x18a1-n0x18ad)  + I ro
	0x0037e5c6, // n0x02c9 c0x0000 (---------------)  + I rocher
	0x002e0785, // n0x02ca c0x0000 (---------------)  + I rocks
	0x002c4e05, // n0x02cb c0x0000 (---------------)  + I rodeo
	0x00257344, // n0x02cc c0x0000 (---------------)  + I room
	0x43e04642, // n0x02cd c0x010f (n0x18ad-n0x18b3)  + I rs
	0x0024a9c4, // n0x02ce c0x0000 (---------------)  + I rsvp
	0x44202f82, // n0x02cf c0x0110 (n0x18b3-n0x1937)  + I ru
	0x0025df44, // n0x02d0 c0x0000 (---------------)  + I ruhr
	0x4462d302, // n0x02d1 c0x0111 (n0x1937-n0x1940)  + I rw
	0x00269846, // n0x02d2 c0x0000 (---------------)  + I ryukyu
	0x44a03a82, // n0x02d3 c0x0112 (n0x1940-n0x1948)  + I sa
	0x0036f048, // n0x02d4 c0x0000 (---------------)  + I saarland
	0x00280544, // n0x02d5 c0x0000 (---------------)  + I safe
	0x0020e0c6, // n0x02d6 c0x0000 (---------------)  + I sakura
	0x00253944, // n0x02d7 c0x0000 (---------------)  + I sale
	0x0021d205, // n0x02d8 c0x0000 (---------------)  + I salon
	0x0022cbc7, // n0x02d9 c0x0000 (---------------)  + I samsung
	0x002259c7, // n0x02da c0x0000 (---------------)  + I sandvik
	0x002259cf, // n0x02db c0x0000 (---------------)  + I sandvikcoromant
	0x00287906, // n0x02dc c0x0000 (---------------)  + I sanofi
	0x00242883, // n0x02dd c0x0000 (---------------)  + I sap
	0x00242884, // n0x02de c0x0000 (---------------)  + I sapo
	0x0024cc44, // n0x02df c0x0000 (---------------)  + I sarl
	0x00264c04, // n0x02e0 c0x0000 (---------------)  + I saxo
	0x44e14502, // n0x02e1 c0x0113 (n0x1948-n0x194d)  + I sb
	0x00266303, // n0x02e2 c0x0000 (---------------)  + I sbs
	0x4521bcc2, // n0x02e3 c0x0114 (n0x194d-n0x1952)  + I sc
	0x0022f803, // n0x02e4 c0x0000 (---------------)  + I sca
	0x0033ff83, // n0x02e5 c0x0000 (---------------)  + I scb
	0x0026c047, // n0x02e6 c0x0000 (---------------)  + I schmidt
	0x00274d4c, // n0x02e7 c0x0000 (---------------)  + I scholarships
	0x00275006, // n0x02e8 c0x0000 (---------------)  + I school
	0x00278586, // n0x02e9 c0x0000 (---------------)  + I schule
	0x002793c7, // n0x02ea c0x0000 (---------------)  + I schwarz
	0x00234e47, // n0x02eb c0x0000 (---------------)  + I science
	0x0021bcc4, // n0x02ec c0x0000 (---------------)  + I scor
	0x00250c44, // n0x02ed c0x0000 (---------------)  + I scot
	0x4560acc2, // n0x02ee c0x0115 (n0x1952-n0x195a)  + I sd
	0x45a04982, // n0x02ef c0x0116 (n0x195a-n0x1983)  + I se
	0x003095c4, // n0x02f0 c0x0000 (---------------)  + I seat
	0x00269d04, // n0x02f1 c0x0000 (---------------)  + I seek
	0x002bf005, // n0x02f2 c0x0000 (---------------)  + I sener
	0x00290b08, // n0x02f3 c0x0000 (---------------)  + I services
	0x0029a603, // n0x02f4 c0x0000 (---------------)  + I sew
	0x0022ae43, // n0x02f5 c0x0000 (---------------)  + I sex
	0x0022ae44, // n0x02f6 c0x0000 (---------------)  + I sexy
	0x45e5f242, // n0x02f7 c0x0117 (n0x1983-n0x198a)  + I sg
	0x462001c2, // n0x02f8 c0x0118 (n0x198a-n0x198f)  + I sh
	0x002acb05, // n0x02f9 c0x0000 (---------------)  + I sharp
	0x00215484, // n0x02fa c0x0000 (---------------)  + I shia
	0x002b2487, // n0x02fb c0x0000 (---------------)  + I shiksha
	0x003794c5, // n0x02fc c0x0000 (---------------)  + I shoes
	0x002f8b07, // n0x02fd c0x0000 (---------------)  + I shriram
	0x002058c2, // n0x02fe c0x0000 (---------------)  + I si
	0x00224bc7, // n0x02ff c0x0000 (---------------)  + I singles
	0x00229d82, // n0x0300 c0x0000 (---------------)  + I sj
	0x46600e02, // n0x0301 c0x0119 (n0x198f-n0x1990)  + I sk
	0x0022f6c3, // n0x0302 c0x0000 (---------------)  + I sky
	0x0022f6c5, // n0x0303 c0x0000 (---------------)  + I skype
	0x46a109c2, // n0x0304 c0x011a (n0x1990-n0x1995)  + I sl
	0x0024f102, // n0x0305 c0x0000 (---------------)  + I sm
	0x0033ba85, // n0x0306 c0x0000 (---------------)  + I smile
	0x46e14782, // n0x0307 c0x011b (n0x1995-n0x199c)  + I sn
	0x47209f02, // n0x0308 c0x011c (n0x199c-n0x199f)  + I so
	0x002ae046, // n0x0309 c0x0000 (---------------)  + I social
	0x00264f88, // n0x030a c0x0000 (---------------)  + I software
	0x002ab284, // n0x030b c0x0000 (---------------)  + I sohu
	0x00310945, // n0x030c c0x0000 (---------------)  + I solar
	0x002d3cc9, // n0x030d c0x0000 (---------------)  + I solutions
	0x002107c3, // n0x030e c0x0000 (---------------)  + I soy
	0x002d91c5, // n0x030f c0x0000 (---------------)  + I space
	0x002db647, // n0x0310 c0x0000 (---------------)  + I spiegel
	0x002dbd0d, // n0x0311 c0x0000 (---------------)  + I spreadbetting
	0x002dc282, // n0x0312 c0x0000 (---------------)  + I sr
	0x47604682, // n0x0313 c0x011d (n0x199f-n0x19ab)  + I st
	0x00346f05, // n0x0314 c0x0000 (---------------)  + I stada
	0x002cd887, // n0x0315 c0x0000 (---------------)  + I statoil
	0x00270103, // n0x0316 c0x0000 (---------------)  + I stc
	0x00270108, // n0x0317 c0x0000 (---------------)  + I stcgroup
	0x0036c009, // n0x0318 c0x0000 (---------------)  + I stockholm
	0x002dcf05, // n0x0319 c0x0000 (---------------)  + I study
	0x002770c5, // n0x031a c0x0000 (---------------)  + I style
	0x00200502, // n0x031b c0x0000 (---------------)  + I su
	0x002aec88, // n0x031c c0x0000 (---------------)  + I supplies
	0x0028a146, // n0x031d c0x0000 (---------------)  + I supply
	0x0022bc47, // n0x031e c0x0000 (---------------)  + I support
	0x002d1744, // n0x031f c0x0000 (---------------)  + I surf
	0x002bce87, // n0x0320 c0x0000 (---------------)  + I surgery
	0x002dfe86, // n0x0321 c0x0000 (---------------)  + I suzuki
	0x47a01e82, // n0x0322 c0x011e (n0x19ab-n0x19b0)  + I sv
	0x002e3105, // n0x0323 c0x0000 (---------------)  + I swiss
	0x47ee3902, // n0x0324 c0x011f (n0x19b0-n0x19b1)  + I sx
	0x48218442, // n0x0325 c0x0120 (n0x19b1-n0x19b7)  + I sy
	0x00266bc6, // n0x0326 c0x0000 (---------------)  + I sydney
	0x002a3808, // n0x0327 c0x0000 (---------------)  + I symantec
	0x0037e1c7, // n0x0328 c0x0000 (---------------)  + I systems
	0x48601302, // n0x0329 c0x0121 (n0x19b7-n0x19ba)  + I sz
	0x00232b83, // n0x032a c0x0000 (---------------)  + I tab
	0x00233ac6, // n0x032b c0x0000 (---------------)  + I taipei
	0x00210245, // n0x032c c0x0000 (---------------)  + I tatar
	0x0021cd46, // n0x032d c0x0000 (---------------)  + I tattoo
	0x00226b43, // n0x032e c0x0000 (---------------)  + I tax
	0x00205ec2, // n0x032f c0x0000 (---------------)  + I tc
	0x002ed903, // n0x0330 c0x0000 (---------------)  + I tci
	0x48a08dc2, // n0x0331 c0x0122 (n0x19ba-n0x19bb)  + I td
	0x002a394a, // n0x0332 c0x0000 (---------------)  + I technology
	0x00218943, // n0x0333 c0x0000 (---------------)  + I tel
	0x0029d88a, // n0x0334 c0x0000 (---------------)  + I telefonica
	0x0023c987, // n0x0335 c0x0000 (---------------)  + I temasek
	0x002eaf86, // n0x0336 c0x0000 (---------------)  + I tennis
	0x00211842, // n0x0337 c0x0000 (---------------)  + I tf
	0x002276c2, // n0x0338 c0x0000 (---------------)  + I tg
	0x48e09382, // n0x0339 c0x0123 (n0x19bb-n0x19c2)  + I th
	0x00229446, // n0x033a c0x0000 (---------------)  + I tienda
	0x00385604, // n0x033b c0x0000 (---------------)  + I tips
	0x00207005, // n0x033c c0x0000 (---------------)  + I tires
	0x002a16c5, // n0x033d c0x0000 (---------------)  + I tirol
	0x492046c2, // n0x033e c0x0124 (n0x19c2-n0x19d1)  + I tj
	0x00204b42, // n0x033f c0x0000 (---------------)  + I tk
	0x49616882, // n0x0340 c0x0125 (n0x19d1-n0x19d2)  + I tl
	0x49a032c2, // n0x0341 c0x0126 (n0x19d2-n0x19da)  + I tm
	0x49e01942, // n0x0342 c0x0127 (n0x19da-n0x19ee)  + I tn
	0x4a200302, // n0x0343 c0x0128 (n0x19ee-n0x19f4)  + I to
	0x003501c5, // n0x0344 c0x0000 (---------------)  + I today
	0x002bc8c5, // n0x0345 c0x0000 (---------------)  + I tokyo
	0x0021ce05, // n0x0346 c0x0000 (---------------)  + I tools
	0x00297203, // n0x0347 c0x0000 (---------------)  + I top
	0x00240dc5, // n0x0348 c0x0000 (---------------)  + I toray
	0x002c3187, // n0x0349 c0x0000 (---------------)  + I toshiba
	0x0023bb04, // n0x034a c0x0000 (---------------)  + I town
	0x00257684, // n0x034b c0x0000 (---------------)  + I toys
	0x0020df02, // n0x034c c0x0000 (---------------)  + I tp
	0x4a600942, // n0x034d c0x0129 (n0x19f4-n0x1a09)  + I tr
	0x00243045, // n0x034e c0x0000 (---------------)  + I trade
	0x00298847, // n0x034f c0x0000 (---------------)  + I trading
	0x0026ba48, // n0x0350 c0x0000 (---------------)  + I training
	0x00290186, // n0x0351 c0x0000 (---------------)  + I travel
	0x00313345, // n0x0352 c0x0000 (---------------)  + I trust
	0x4b21cdc2, // n0x0353 c0x012c (n0x1a0b-n0x1a1c)  + I tt
	0x002e3c03, // n0x0354 c0x0000 (---------------)  + I tui
	0x002e5005, // n0x0355 c0x0000 (---------------)  + I tushu
	0x4b68dc82, // n0x0356 c0x012d (n0x1a1c-n0x1a20)  + I tv
	0x4ba548c2, // n0x0357 c0x012e (n0x1a20-n0x1a2e)  + I tw
	0x4be3af02, // n0x0358 c0x012f (n0x1a2e-n0x1a3a)  + I tz
	0x4c229e82, // n0x0359 c0x0130 (n0x1a3a-n0x1a88)  + I ua
	0x00346003, // n0x035a c0x0000 (---------------)  + I ubs
	0x4c601b02, // n0x035b c0x0131 (n0x1a88-n0x1a90)  + I ug
	0x4ca00542, // n0x035c c0x0132 (n0x1a90-n0x1a9b)  + I uk
	0x003826ca, // n0x035d c0x0000 (---------------)  + I university
	0x00215b43, // n0x035e c0x0000 (---------------)  + I uno
	0x00245c03, // n0x035f c0x0000 (---------------)  + I uol
	0x4d6073c2, // n0x0360 c0x0135 (n0x1a9d-n0x1adc)  + I us
	0x5ba04282, // n0x0361 c0x016e (n0x1b7f-n0x1b85)  + I uy
	0x5be1eac2, // n0x0362 c0x016f (n0x1b85-n0x1b89)  + I uz
	0x00203242, // n0x0363 c0x0000 (---------------)  + I va
	0x0036ed89, // n0x0364 c0x0000 (---------------)  + I vacations
	0x002b1004, // n0x0365 c0x0000 (---------------)  + I vana
	0x5c2e6442, // n0x0366 c0x0170 (n0x1b89-n0x1b8f)  + I vc
	0x5c603f02, // n0x0367 c0x0171 (n0x1b8f-n0x1ba0)  + I ve
	0x002e7105, // n0x0368 c0x0000 (---------------)  + I vegas
	0x00238bc8, // n0x0369 c0x0000 (---------------)  + I ventures
	0x002e918c, // n0x036a c0x0000 (---------------)  + I versicherung
	0x0023c8c3, // n0x036b c0x0000 (---------------)  + I vet
	0x0025a082, // n0x036c c0x0000 (---------------)  + I vg
	0x5ca01642, // n0x036d c0x0172 (n0x1ba0-n0x1ba5)  + I vi
	0x002b8846, // n0x036e c0x0000 (---------------)  + I viajes
	0x002ebe05, // n0x036f c0x0000 (---------------)  + I video
	0x002ebf46, // n0x0370 c0x0000 (---------------)  + I villas
	0x002efb86, // n0x0371 c0x0000 (---------------)  + I virgin
	0x002a1046, // n0x0372 c0x0000 (---------------)  + I vision
	0x002bd505, // n0x0373 c0x0000 (---------------)  + I vista
	0x002f010a, // n0x0374 c0x0000 (---------------)  + I vistaprint
	0x0024bd44, // n0x0375 c0x0000 (---------------)  + I viva
	0x00326bca, // n0x0376 c0x0000 (---------------)  + I vlaanderen
	0x5ce0d142, // n0x0377 c0x0173 (n0x1ba5-n0x1bb1)  + I vn
	0x00360bc5, // n0x0378 c0x0000 (---------------)  + I vodka
	0x002f3f44, // n0x0379 c0x0000 (---------------)  + I vote
	0x002f4046, // n0x037a c0x0000 (---------------)  + I voting
	0x002f41c4, // n0x037b c0x0000 (---------------)  + I voto
	0x00361286, // n0x037c c0x0000 (---------------)  + I voyage
	0x5d201882, // n0x037d c0x0174 (n0x1bb1-n0x1bb5)  + I vu
	0x00236485, // n0x037e c0x0000 (---------------)  + I wales
	0x00276386, // n0x037f c0x0000 (---------------)  + I walter
	0x00252444, // n0x0380 c0x0000 (---------------)  + I wang
	0x00252447, // n0x0381 c0x0000 (---------------)  + I wanggou
	0x00205e45, // n0x0382 c0x0000 (---------------)  + I watch
	0x00216346, // n0x0383 c0x0000 (---------------)  + I webcam
	0x002071c7, // n0x0384 c0x0000 (---------------)  + I website
	0x00245dc3, // n0x0385 c0x0000 (---------------)  + I wed
	0x0035fb47, // n0x0386 c0x0000 (---------------)  + I wedding
	0x00212582, // n0x0387 c0x0000 (---------------)  + I wf
	0x0022e087, // n0x0388 c0x0000 (---------------)  + I whoswho
	0x00382d04, // n0x0389 c0x0000 (---------------)  + I wien
	0x0022d744, // n0x038a c0x0000 (---------------)  + I wiki
	0x00359a4b, // n0x038b c0x0000 (---------------)  + I williamhill
	0x0021e843, // n0x038c c0x0000 (---------------)  + I win
	0x0027c987, // n0x038d c0x0000 (---------------)  + I windows
	0x00273d43, // n0x038e c0x0000 (---------------)  + I wme
	0x00226744, // n0x038f c0x0000 (---------------)  + I work
	0x0022e545, // n0x0390 c0x0000 (---------------)  + I works
	0x00306b45, // n0x0391 c0x0000 (---------------)  + I world
	0x5d6012c2, // n0x0392 c0x0175 (n0x1bb5-n0x1bbc)  + I ws
	0x002a43c3, // n0x0393 c0x0000 (---------------)  + I wtc
	0x002a44c3, // n0x0394 c0x0000 (---------------)  + I wtf
	0x0022cdc4, // n0x0395 c0x0000 (---------------)  + I xbox
	0x0022ce85, // n0x0396 c0x0000 (---------------)  + I xerox
	0x00226bc3, // n0x0397 c0x0000 (---------------)  + I xin
	0x0027c44b, // n0x0398 c0x0000 (---------------)  + I xn--1qqw23a
	0x0029a08a, // n0x0399 c0x0000 (---------------)  + I xn--30rr7y
	0x002c6d8b, // n0x039a c0x0000 (---------------)  + I xn--3bst00m
	0x002e394b, // n0x039b c0x0000 (---------------)  + I xn--3ds443g
	0x0032a28c, // n0x039c c0x0000 (---------------)  + I xn--3e0b707e
	0x0037fa0b, // n0x039d c0x0000 (---------------)  + I xn--45brj9c
	0x0038470a, // n0x039e c0x0000 (---------------)  + I xn--45q11c
	0x00385f0a, // n0x039f c0x0000 (---------------)  + I xn--4gbrim
	0x002f588e, // n0x03a0 c0x0000 (---------------)  + I xn--54b7fta0cc
	0x002f640b, // n0x03a1 c0x0000 (---------------)  + I xn--55qw42g
	0x002f66ca, // n0x03a2 c0x0000 (---------------)  + I xn--55qx5d
	0x002f77cb, // n0x03a3 c0x0000 (---------------)  + I xn--6frz82g
	0x002f7d0e, // n0x03a4 c0x0000 (---------------)  + I xn--6qq986b3xl
	0x002f884c, // n0x03a5 c0x0000 (---------------)  + I xn--80adxhks
	0x002f908b, // n0x03a6 c0x0000 (---------------)  + I xn--80ao21a
	0x002f934c, // n0x03a7 c0x0000 (---------------)  + I xn--80asehdb
	0x002fd30a, // n0x03a8 c0x0000 (---------------)  + I xn--80aswg
	0x5dafe78a, // n0x03a9 c0x0176 (n0x1bbc-n0x1bc2)  + I xn--90a3ac
	0x0030060a, // n0x03aa c0x0000 (---------------)  + I xn--9et52u
	0x00302d8e, // n0x03ab c0x0000 (---------------)  + I xn--b4w605ferd
	0x0030d409, // n0x03ac c0x0000 (---------------)  + I xn--c1avg
	0x0030e04a, // n0x03ad c0x0000 (---------------)  + I xn--cg4bki
	0x0030eb56, // n0x03ae c0x0000 (---------------)  + I xn--clchc0ea0b2g2a9gcd
	0x0030fecb, // n0x03af c0x0000 (---------------)  + I xn--czr694b
	0x0031060a, // n0x03b0 c0x0000 (---------------)  + I xn--czrs0t
	0x00310b8a, // n0x03b1 c0x0000 (---------------)  + I xn--czru2d
	0x0031234b, // n0x03b2 c0x0000 (---------------)  + I xn--d1acj3b
	0x003160cd, // n0x03b3 c0x0000 (---------------)  + I xn--eckvdtc9d
	0x00316bcb, // n0x03b4 c0x0000 (---------------)  + I xn--efvy88h
	0x0031898e, // n0x03b5 c0x0000 (---------------)  + I xn--fiq228c5hs
	0x00318f4a, // n0x03b6 c0x0000 (---------------)  + I xn--fiq64b
	0x0031abca, // n0x03b7 c0x0000 (---------------)  + I xn--fiqs8s
	0x0031af8a, // n0x03b8 c0x0000 (---------------)  + I xn--fiqz9s
	0x0031ba4b, // n0x03b9 c0x0000 (---------------)  + I xn--fjq720a
	0x0031c28b, // n0x03ba c0x0000 (---------------)  + I xn--flw351e
	0x0031c54d, // n0x03bb c0x0000 (---------------)  + I xn--fpcrj9c3d
	0x0031d68d, // n0x03bc c0x0000 (---------------)  + I xn--fzc2c9e2c
	0x0031dbcb, // n0x03bd c0x0000 (---------------)  + I xn--gecrj9c
	0x00320c0b, // n0x03be c0x0000 (---------------)  + I xn--h2brj9c
	0x0032560b, // n0x03bf c0x0000 (---------------)  + I xn--hxt814e
	0x0032608f, // n0x03c0 c0x0000 (---------------)  + I xn--i1b6b1a6a2e
	0x0032644b, // n0x03c1 c0x0000 (---------------)  + I xn--imr513n
	0x00326e4a, // n0x03c2 c0x0000 (---------------)  + I xn--io0a7i
	0x00327389, // n0x03c3 c0x0000 (---------------)  + I xn--j1amh
	0x0032774b, // n0x03c4 c0x0000 (---------------)  + I xn--j6w193g
	0x00328e4f, // n0x03c5 c0x0000 (---------------)  + I xn--kcrx77d1x4a
	0x0032b4cb, // n0x03c6 c0x0000 (---------------)  + I xn--kprw13d
	0x0032b78b, // n0x03c7 c0x0000 (---------------)  + I xn--kpry57d
	0x0032ba4a, // n0x03c8 c0x0000 (---------------)  + I xn--kput3i
	0x00332049, // n0x03c9 c0x0000 (---------------)  + I xn--l1acc
	0x0033600f, // n0x03ca c0x0000 (---------------)  + I xn--lgbbat1ad8j
	0x00339ccc, // n0x03cb c0x0000 (---------------)  + I xn--mgb2ddes
	0x0033a04c, // n0x03cc c0x0000 (---------------)  + I xn--mgb9awbf
	0x0033a6ce, // n0x03cd c0x0000 (---------------)  + I xn--mgba3a3ejt
	0x0033b00f, // n0x03ce c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0033b3ce, // n0x03cf c0x0000 (---------------)  + I xn--mgba3a4fra
	0x0033bd8e, // n0x03d0 c0x0000 (---------------)  + I xn--mgbaam7a8h
	0x0033c34c, // n0x03d1 c0x0000 (---------------)  + I xn--mgbab2bd
	0x0033c64e, // n0x03d2 c0x0000 (---------------)  + I xn--mgbayh7gpa
	0x0033ca8e, // n0x03d3 c0x0000 (---------------)  + I xn--mgbb9fbpob
	0x0033cfce, // n0x03d4 c0x0000 (---------------)  + I xn--mgbbh1a71e
	0x0033d34f, // n0x03d5 c0x0000 (---------------)  + I xn--mgbc0a9azcg
	0x0033d713, // n0x03d6 c0x0000 (---------------)  + I xn--mgberp4a5d4a87g
	0x0033dbd1, // n0x03d7 c0x0000 (---------------)  + I xn--mgberp4a5d4ar
	0x0033e013, // n0x03d8 c0x0000 (---------------)  + I xn--mgbqly7c0a67fbc
	0x0033ea90, // n0x03d9 c0x0000 (---------------)  + I xn--mgbqly7cvafr
	0x0033f2cc, // n0x03da c0x0000 (---------------)  + I xn--mgbt3dhd
	0x0033f5cc, // n0x03db c0x0000 (---------------)  + I xn--mgbtf8fl
	0x0033fa8e, // n0x03dc c0x0000 (---------------)  + I xn--mgbx4cd0ab
	0x0034808a, // n0x03dd c0x0000 (---------------)  + I xn--mxtq1m
	0x0034844c, // n0x03de c0x0000 (---------------)  + I xn--ngbc5azd
	0x0034874c, // n0x03df c0x0000 (---------------)  + I xn--ngbe9e0a
	0x00349e0b, // n0x03e0 c0x0000 (---------------)  + I xn--nnx388a
	0x0034a0c8, // n0x03e1 c0x0000 (---------------)  + I xn--node
	0x0034a509, // n0x03e2 c0x0000 (---------------)  + I xn--nqv7f
	0x0034a50f, // n0x03e3 c0x0000 (---------------)  + I xn--nqv7fs00ema
	0x0034bd0b, // n0x03e4 c0x0000 (---------------)  + I xn--nyqy26a
	0x0034c60a, // n0x03e5 c0x0000 (---------------)  + I xn--o3cw4h
	0x0034dd0c, // n0x03e6 c0x0000 (---------------)  + I xn--ogbpf8fl
	0x0034eec9, // n0x03e7 c0x0000 (---------------)  + I xn--p1acf
	0x0034f408, // n0x03e8 c0x0000 (---------------)  + I xn--p1ai
	0x0034f70b, // n0x03e9 c0x0000 (---------------)  + I xn--pgbs0dh
	0x00350d8b, // n0x03ea c0x0000 (---------------)  + I xn--q9jyb4c
	0x003512cc, // n0x03eb c0x0000 (---------------)  + I xn--qcka1pmc
	0x003543cb, // n0x03ec c0x0000 (---------------)  + I xn--rhqv96g
	0x00358e4b, // n0x03ed c0x0000 (---------------)  + I xn--s9brj9c
	0x0035b88b, // n0x03ee c0x0000 (---------------)  + I xn--ses554g
	0x003742ca, // n0x03ef c0x0000 (---------------)  + I xn--unup4y
	0x00375217, // n0x03f0 c0x0000 (---------------)  + I xn--vermgensberater-ctb
	0x003760d8, // n0x03f1 c0x0000 (---------------)  + I xn--vermgensberatung-pwb
	0x0037a409, // n0x03f2 c0x0000 (---------------)  + I xn--vhquv
	0x0037b88b, // n0x03f3 c0x0000 (---------------)  + I xn--vuq861b
	0x0037c38a, // n0x03f4 c0x0000 (---------------)  + I xn--wgbh1c
	0x0037c90a, // n0x03f5 c0x0000 (---------------)  + I xn--wgbl6a
	0x0037cb8b, // n0x03f6 c0x0000 (---------------)  + I xn--xhq521b
	0x0037d810, // n0x03f7 c0x0000 (---------------)  + I xn--xkc2al3hye2a
	0x0037dc11, // n0x03f8 c0x0000 (---------------)  + I xn--xkc2dl3a5ee0h
	0x0037f00d, // n0x03f9 c0x0000 (---------------)  + I xn--yfro4i67o
	0x0037f70d, // n0x03fa c0x0000 (---------------)  + I xn--ygbi2ammx
	0x0038528b, // n0x03fb c0x0000 (---------------)  + I xn--zfr164b
	0x00385e83, // n0x03fc c0x0000 (---------------)  + I xxx
	0x0022aec3, // n0x03fd c0x0000 (---------------)  + I xyz
	0x002e6806, // n0x03fe c0x0000 (---------------)  + I yachts
	0x0021a607, // n0x03ff c0x0000 (---------------)  + I yamaxun
	0x00305246, // n0x0400 c0x0000 (---------------)  + I yandex
	0x0161ef02, // n0x0401 c0x0005 (---------------)* o I ye
	0x002e6549, // n0x0402 c0x0000 (---------------)  + I yodobashi
	0x00367504, // n0x0403 c0x0000 (---------------)  + I yoga
	0x00345bc8, // n0x0404 c0x0000 (---------------)  + I yokohama
	0x00383287, // n0x0405 c0x0000 (---------------)  + I youtube
	0x0023f602, // n0x0406 c0x0000 (---------------)  + I yt
	0x016028c2, // n0x0407 c0x0005 (---------------)* o I za
	0x002b7b44, // n0x0408 c0x0000 (---------------)  + I zara
	0x0035f684, // n0x0409 c0x0000 (---------------)  + I zero
	0x0023c103, // n0x040a c0x0000 (---------------)  + I zip
	0x01675302, // n0x040b c0x0005 (---------------)* o I zm
	0x002ccfc4, // n0x040c c0x0000 (---------------)  + I zone
	0x00347387, // n0x040d c0x0000 (---------------)  + I zuerich
	0x0167cc82, // n0x040e c0x0005 (---------------)* o I zw
	0x00232dc3, // n0x040f c0x0000 (---------------)  + I com
	0x0021e083, // n0x0410 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0411 c0x0000 (---------------)  + I gov
	0x00240443, // n0x0412 c0x0000 (---------------)  + I mil
	0x00218643, // n0x0413 c0x0000 (---------------)  + I net
	0x0024d043, // n0x0414 c0x0000 (---------------)  + I org
	0x002104c3, // n0x0415 c0x0000 (---------------)  + I nom
	0x00200b82, // n0x0416 c0x0000 (---------------)  + I ac
	0x0009e448, // n0x0417 c0x0000 (---------------)  +   blogspot
	0x00200882, // n0x0418 c0x0000 (---------------)  + I co
	0x00209ac3, // n0x0419 c0x0000 (---------------)  + I gov
	0x00240443, // n0x041a c0x0000 (---------------)  + I mil
	0x00218643, // n0x041b c0x0000 (---------------)  + I net
	0x0024d043, // n0x041c c0x0000 (---------------)  + I org
	0x00251983, // n0x041d c0x0000 (---------------)  + I sch
	0x00308bd6, // n0x041e c0x0000 (---------------)  + I accident-investigation
	0x0030b9d3, // n0x041f c0x0000 (---------------)  + I accident-prevention
	0x00233789, // n0x0420 c0x0000 (---------------)  + I aerobatic
	0x0034c9c8, // n0x0421 c0x0000 (---------------)  + I aeroclub
	0x002e1989, // n0x0422 c0x0000 (---------------)  + I aerodrome
	0x0034f106, // n0x0423 c0x0000 (---------------)  + I agents
	0x00347910, // n0x0424 c0x0000 (---------------)  + I air-surveillance
	0x00222953, // n0x0425 c0x0000 (---------------)  + I air-traffic-control
	0x00243bc8, // n0x0426 c0x0000 (---------------)  + I aircraft
	0x00272647, // n0x0427 c0x0000 (---------------)  + I airline
	0x0027df47, // n0x0428 c0x0000 (---------------)  + I airport
	0x00295a4a, // n0x0429 c0x0000 (---------------)  + I airtraffic
	0x00383909, // n0x042a c0x0000 (---------------)  + I ambulance
	0x00365e49, // n0x042b c0x0000 (---------------)  + I amusement
	0x002c51cb, // n0x042c c0x0000 (---------------)  + I association
	0x003220c6, // n0x042d c0x0000 (---------------)  + I author
	0x0025044a, // n0x042e c0x0000 (---------------)  + I ballooning
	0x00227806, // n0x042f c0x0000 (---------------)  + I broker
	0x00367143, // n0x0430 c0x0000 (---------------)  + I caa
	0x00214585, // n0x0431 c0x0000 (---------------)  + I cargo
	0x0024a608, // n0x0432 c0x0000 (---------------)  + I catering
	0x002d250d, // n0x0433 c0x0000 (---------------)  + I certification
	0x003474cc, // n0x0434 c0x0000 (---------------)  + I championship
	0x0026e587, // n0x0435 c0x0000 (---------------)  + I charter
	0x00332c0d, // n0x0436 c0x0000 (---------------)  + I civilaviation
	0x0034cac4, // n0x0437 c0x0000 (---------------)  + I club
	0x0023588a, // n0x0438 c0x0000 (---------------)  + I conference
	0x0023668a, // n0x0439 c0x0000 (---------------)  + I consultant
	0x00236b4a, // n0x043a c0x0000 (---------------)  + I consulting
	0x00200887, // n0x043b c0x0000 (---------------)  + I control
	0x0023e8c7, // n0x043c c0x0000 (---------------)  + I council
	0x00240284, // n0x043d c0x0000 (---------------)  + I crew
	0x00237ec6, // n0x043e c0x0000 (---------------)  + I design
	0x0036dfc4, // n0x043f c0x0000 (---------------)  + I dgca
	0x002d42c8, // n0x0440 c0x0000 (---------------)  + I educator
	0x0020a509, // n0x0441 c0x0000 (---------------)  + I emergency
	0x0030dc46, // n0x0442 c0x0000 (---------------)  + I engine
	0x0030dc48, // n0x0443 c0x0000 (---------------)  + I engineer
	0x0024430d, // n0x0444 c0x0000 (---------------)  + I entertainment
	0x002126c9, // n0x0445 c0x0000 (---------------)  + I equipment
	0x002ed008, // n0x0446 c0x0000 (---------------)  + I exchange
	0x0022acc7, // n0x0447 c0x0000 (---------------)  + I express
	0x0023ee8a, // n0x0448 c0x0000 (---------------)  + I federation
	0x0024cd46, // n0x0449 c0x0000 (---------------)  + I flight
	0x00257507, // n0x044a c0x0000 (---------------)  + I freight
	0x002e7f04, // n0x044b c0x0000 (---------------)  + I fuel
	0x0023c587, // n0x044c c0x0000 (---------------)  + I gliding
	0x0025ee0a, // n0x044d c0x0000 (---------------)  + I government
	0x00239a0e, // n0x044e c0x0000 (---------------)  + I groundhandling
	0x00226905, // n0x044f c0x0000 (---------------)  + I group
	0x0037354b, // n0x0450 c0x0000 (---------------)  + I hanggliding
	0x0028efc9, // n0x0451 c0x0000 (---------------)  + I homebuilt
	0x002fde89, // n0x0452 c0x0000 (---------------)  + I insurance
	0x00206507, // n0x0453 c0x0000 (---------------)  + I journal
	0x0020650a, // n0x0454 c0x0000 (---------------)  + I journalist
	0x00224b07, // n0x0455 c0x0000 (---------------)  + I leasing
	0x0024d2c9, // n0x0456 c0x0000 (---------------)  + I logistics
	0x00285f48, // n0x0457 c0x0000 (---------------)  + I magazine
	0x0022aa4b, // n0x0458 c0x0000 (---------------)  + I maintenance
	0x0035c84b, // n0x0459 c0x0000 (---------------)  + I marketplace
	0x0021e585, // n0x045a c0x0000 (---------------)  + I media
	0x002494ca, // n0x045b c0x0000 (---------------)  + I microlight
	0x00317449, // n0x045c c0x0000 (---------------)  + I modelling
	0x002015ca, // n0x045d c0x0000 (---------------)  + I navigation
	0x0023c18b, // n0x045e c0x0000 (---------------)  + I parachuting
	0x0023c48b, // n0x045f c0x0000 (---------------)  + I paragliding
	0x002c4f55, // n0x0460 c0x0000 (---------------)  + I passenger-association
	0x002c8e05, // n0x0461 c0x0000 (---------------)  + I pilot
	0x0022ad45, // n0x0462 c0x0000 (---------------)  + I press
	0x002cfeca, // n0x0463 c0x0000 (---------------)  + I production
	0x0031e10a, // n0x0464 c0x0000 (---------------)  + I recreation
	0x00226387, // n0x0465 c0x0000 (---------------)  + I repbody
	0x00207083, // n0x0466 c0x0000 (---------------)  + I res
	0x002d8188, // n0x0467 c0x0000 (---------------)  + I research
	0x002c158a, // n0x0468 c0x0000 (---------------)  + I rotorcraft
	0x00280546, // n0x0469 c0x0000 (---------------)  + I safety
	0x002833c9, // n0x046a c0x0000 (---------------)  + I scientist
	0x00290b08, // n0x046b c0x0000 (---------------)  + I services
	0x002f5744, // n0x046c c0x0000 (---------------)  + I show
	0x0034c3c9, // n0x046d c0x0000 (---------------)  + I skydiving
	0x00264f88, // n0x046e c0x0000 (---------------)  + I software
	0x0033adc7, // n0x046f c0x0000 (---------------)  + I student
	0x00226b44, // n0x0470 c0x0000 (---------------)  + I taxi
	0x00243046, // n0x0471 c0x0000 (---------------)  + I trader
	0x00298847, // n0x0472 c0x0000 (---------------)  + I trading
	0x002a82c7, // n0x0473 c0x0000 (---------------)  + I trainer
	0x002ba245, // n0x0474 c0x0000 (---------------)  + I union
	0x0022674c, // n0x0475 c0x0000 (---------------)  + I workinggroup
	0x0022e545, // n0x0476 c0x0000 (---------------)  + I works
	0x00232dc3, // n0x0477 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0478 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0479 c0x0000 (---------------)  + I gov
	0x00218643, // n0x047a c0x0000 (---------------)  + I net
	0x0024d043, // n0x047b c0x0000 (---------------)  + I org
	0x00200882, // n0x047c c0x0000 (---------------)  + I co
	0x00232dc3, // n0x047d c0x0000 (---------------)  + I com
	0x00218643, // n0x047e c0x0000 (---------------)  + I net
	0x002104c3, // n0x047f c0x0000 (---------------)  + I nom
	0x0024d043, // n0x0480 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x0481 c0x0000 (---------------)  + I com
	0x00218643, // n0x0482 c0x0000 (---------------)  + I net
	0x00215fc3, // n0x0483 c0x0000 (---------------)  + I off
	0x0024d043, // n0x0484 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x0485 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0486 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0487 c0x0000 (---------------)  + I gov
	0x00240443, // n0x0488 c0x0000 (---------------)  + I mil
	0x00218643, // n0x0489 c0x0000 (---------------)  + I net
	0x0024d043, // n0x048a c0x0000 (---------------)  + I org
	0x00232dc3, // n0x048b c0x0000 (---------------)  + I com
	0x0021e083, // n0x048c c0x0000 (---------------)  + I edu
	0x00218643, // n0x048d c0x0000 (---------------)  + I net
	0x0024d043, // n0x048e c0x0000 (---------------)  + I org
	0x00200882, // n0x048f c0x0000 (---------------)  + I co
	0x00205742, // n0x0490 c0x0000 (---------------)  + I ed
	0x00236d82, // n0x0491 c0x0000 (---------------)  + I gv
	0x002014c2, // n0x0492 c0x0000 (---------------)  + I it
	0x00204f42, // n0x0493 c0x0000 (---------------)  + I og
	0x00226402, // n0x0494 c0x0000 (---------------)  + I pb
	0x04632dc3, // n0x0495 c0x0011 (n0x049e-n0x049f)  + I com
	0x0021e083, // n0x0496 c0x0000 (---------------)  + I edu
	0x003704c3, // n0x0497 c0x0000 (---------------)  + I gob
	0x00209ac3, // n0x0498 c0x0000 (---------------)  + I gov
	0x002188c3, // n0x0499 c0x0000 (---------------)  + I int
	0x00240443, // n0x049a c0x0000 (---------------)  + I mil
	0x00218643, // n0x049b c0x0000 (---------------)  + I net
	0x0024d043, // n0x049c c0x0000 (---------------)  + I org
	0x0022a0c3, // n0x049d c0x0000 (---------------)  + I tur
	0x0009e448, // n0x049e c0x0000 (---------------)  +   blogspot
	0x0024ffc4, // n0x049f c0x0000 (---------------)  + I e164
	0x0020fac7, // n0x04a0 c0x0000 (---------------)  + I in-addr
	0x00213ac3, // n0x04a1 c0x0000 (---------------)  + I ip6
	0x0027a544, // n0x04a2 c0x0000 (---------------)  + I iris
	0x00206383, // n0x04a3 c0x0000 (---------------)  + I uri
	0x00206583, // n0x04a4 c0x0000 (---------------)  + I urn
	0x00209ac3, // n0x04a5 c0x0000 (---------------)  + I gov
	0x00200b82, // n0x04a6 c0x0000 (---------------)  + I ac
	0x00002183, // n0x04a7 c0x0000 (---------------)  +   biz
	0x05600882, // n0x04a8 c0x0015 (n0x04ad-n0x04ae)  + I co
	0x00236d82, // n0x04a9 c0x0000 (---------------)  + I gv
	0x00008a44, // n0x04aa c0x0000 (---------------)  +   info
	0x00200d02, // n0x04ab c0x0000 (---------------)  + I or
	0x000cfac4, // n0x04ac c0x0000 (---------------)  +   priv
	0x0009e448, // n0x04ad c0x0000 (---------------)  +   blogspot
	0x002388c3, // n0x04ae c0x0000 (---------------)  + I act
	0x002a4783, // n0x04af c0x0000 (---------------)  + I asn
	0x05e32dc3, // n0x04b0 c0x0017 (n0x04c0-n0x04c1)  + I com
	0x00235884, // n0x04b1 c0x0000 (---------------)  + I conf
	0x0621e083, // n0x04b2 c0x0018 (n0x04c1-n0x04c9)  + I edu
	0x06609ac3, // n0x04b3 c0x0019 (n0x04c9-n0x04ce)  + I gov
	0x00205942, // n0x04b4 c0x0000 (---------------)  + I id
	0x00208a44, // n0x04b5 c0x0000 (---------------)  + I info
	0x00218643, // n0x04b6 c0x0000 (---------------)  + I net
	0x00245d43, // n0x04b7 c0x0000 (---------------)  + I nsw
	0x00200902, // n0x04b8 c0x0000 (---------------)  + I nt
	0x0024d043, // n0x04b9 c0x0000 (---------------)  + I org
	0x0021b602, // n0x04ba c0x0000 (---------------)  + I oz
	0x0022d503, // n0x04bb c0x0000 (---------------)  + I qld
	0x00203a82, // n0x04bc c0x0000 (---------------)  + I sa
	0x00208883, // n0x04bd c0x0000 (---------------)  + I tas
	0x00252603, // n0x04be c0x0000 (---------------)  + I vic
	0x00200142, // n0x04bf c0x0000 (---------------)  + I wa
	0x0009e448, // n0x04c0 c0x0000 (---------------)  +   blogspot
	0x002388c3, // n0x04c1 c0x0000 (---------------)  + I act
	0x00245d43, // n0x04c2 c0x0000 (---------------)  + I nsw
	0x00200902, // n0x04c3 c0x0000 (---------------)  + I nt
	0x0022d503, // n0x04c4 c0x0000 (---------------)  + I qld
	0x00203a82, // n0x04c5 c0x0000 (---------------)  + I sa
	0x00208883, // n0x04c6 c0x0000 (---------------)  + I tas
	0x00252603, // n0x04c7 c0x0000 (---------------)  + I vic
	0x00200142, // n0x04c8 c0x0000 (---------------)  + I wa
	0x0022d503, // n0x04c9 c0x0000 (---------------)  + I qld
	0x00203a82, // n0x04ca c0x0000 (---------------)  + I sa
	0x00208883, // n0x04cb c0x0000 (---------------)  + I tas
	0x00252603, // n0x04cc c0x0000 (---------------)  + I vic
	0x00200142, // n0x04cd c0x0000 (---------------)  + I wa
	0x00232dc3, // n0x04ce c0x0000 (---------------)  + I com
	0x00202183, // n0x04cf c0x0000 (---------------)  + I biz
	0x00232dc3, // n0x04d0 c0x0000 (---------------)  + I com
	0x0021e083, // n0x04d1 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x04d2 c0x0000 (---------------)  + I gov
	0x00208a44, // n0x04d3 c0x0000 (---------------)  + I info
	0x002188c3, // n0x04d4 c0x0000 (---------------)  + I int
	0x00240443, // n0x04d5 c0x0000 (---------------)  + I mil
	0x00267944, // n0x04d6 c0x0000 (---------------)  + I name
	0x00218643, // n0x04d7 c0x0000 (---------------)  + I net
	0x0024d043, // n0x04d8 c0x0000 (---------------)  + I org
	0x00200a82, // n0x04d9 c0x0000 (---------------)  + I pp
	0x002cfc43, // n0x04da c0x0000 (---------------)  + I pro
	0x00200882, // n0x04db c0x0000 (---------------)  + I co
	0x00232dc3, // n0x04dc c0x0000 (---------------)  + I com
	0x0021e083, // n0x04dd c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x04de c0x0000 (---------------)  + I gov
	0x00240443, // n0x04df c0x0000 (---------------)  + I mil
	0x00218643, // n0x04e0 c0x0000 (---------------)  + I net
	0x0024d043, // n0x04e1 c0x0000 (---------------)  + I org
	0x00204642, // n0x04e2 c0x0000 (---------------)  + I rs
	0x00272984, // n0x04e3 c0x0000 (---------------)  + I unbi
	0x00261304, // n0x04e4 c0x0000 (---------------)  + I unsa
	0x00202183, // n0x04e5 c0x0000 (---------------)  + I biz
	0x00200882, // n0x04e6 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x04e7 c0x0000 (---------------)  + I com
	0x0021e083, // n0x04e8 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x04e9 c0x0000 (---------------)  + I gov
	0x00208a44, // n0x04ea c0x0000 (---------------)  + I info
	0x00218643, // n0x04eb c0x0000 (---------------)  + I net
	0x0024d043, // n0x04ec c0x0000 (---------------)  + I org
	0x002dc745, // n0x04ed c0x0000 (---------------)  + I store
	0x0028dc82, // n0x04ee c0x0000 (---------------)  + I tv
	0x00200b82, // n0x04ef c0x0000 (---------------)  + I ac
	0x0009e448, // n0x04f0 c0x0000 (---------------)  +   blogspot
	0x00209ac3, // n0x04f1 c0x0000 (---------------)  + I gov
	0x00245441, // n0x04f2 c0x0000 (---------------)  + I 0
	0x002075c1, // n0x04f3 c0x0000 (---------------)  + I 1
	0x0020c501, // n0x04f4 c0x0000 (---------------)  + I 2
	0x00207141, // n0x04f5 c0x0000 (---------------)  + I 3
	0x00250081, // n0x04f6 c0x0000 (---------------)  + I 4
	0x00299841, // n0x04f7 c0x0000 (---------------)  + I 5
	0x00213b41, // n0x04f8 c0x0000 (---------------)  + I 6
	0x00245541, // n0x04f9 c0x0000 (---------------)  + I 7
	0x002f4b41, // n0x04fa c0x0000 (---------------)  + I 8
	0x002f4dc1, // n0x04fb c0x0000 (---------------)  + I 9
	0x00200101, // n0x04fc c0x0000 (---------------)  + I a
	0x00200001, // n0x04fd c0x0000 (---------------)  + I b
	0x00200401, // n0x04fe c0x0000 (---------------)  + I c
	0x002003c1, // n0x04ff c0x0000 (---------------)  + I d
	0x00200081, // n0x0500 c0x0000 (---------------)  + I e
	0x00203841, // n0x0501 c0x0000 (---------------)  + I f
	0x002002c1, // n0x0502 c0x0000 (---------------)  + I g
	0x00200201, // n0x0503 c0x0000 (---------------)  + I h
	0x00200041, // n0x0504 c0x0000 (---------------)  + I i
	0x00202e01, // n0x0505 c0x0000 (---------------)  + I j
	0x00200481, // n0x0506 c0x0000 (---------------)  + I k
	0x002000c1, // n0x0507 c0x0000 (---------------)  + I l
	0x00200f41, // n0x0508 c0x0000 (---------------)  + I m
	0x00200281, // n0x0509 c0x0000 (---------------)  + I n
	0x00200341, // n0x050a c0x0000 (---------------)  + I o
	0x00200a81, // n0x050b c0x0000 (---------------)  + I p
	0x00206c81, // n0x050c c0x0000 (---------------)  + I q
	0x002006c1, // n0x050d c0x0000 (---------------)  + I r
	0x002001c1, // n0x050e c0x0000 (---------------)  + I s
	0x00200301, // n0x050f c0x0000 (---------------)  + I t
	0x00200541, // n0x0510 c0x0000 (---------------)  + I u
	0x00201641, // n0x0511 c0x0000 (---------------)  + I v
	0x00200141, // n0x0512 c0x0000 (---------------)  + I w
	0x002013c1, // n0x0513 c0x0000 (---------------)  + I x
	0x00202981, // n0x0514 c0x0000 (---------------)  + I y
	0x00201241, // n0x0515 c0x0000 (---------------)  + I z
	0x00232dc3, // n0x0516 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0517 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0518 c0x0000 (---------------)  + I gov
	0x00218643, // n0x0519 c0x0000 (---------------)  + I net
	0x0024d043, // n0x051a c0x0000 (---------------)  + I org
	0x00200882, // n0x051b c0x0000 (---------------)  + I co
	0x00232dc3, // n0x051c c0x0000 (---------------)  + I com
	0x0021e083, // n0x051d c0x0000 (---------------)  + I edu
	0x00200d02, // n0x051e c0x0000 (---------------)  + I or
	0x0024d043, // n0x051f c0x0000 (---------------)  + I org
	0x0000dc06, // n0x0520 c0x0000 (---------------)  +   dyndns
	0x00050e4a, // n0x0521 c0x0000 (---------------)  +   for-better
	0x00081388, // n0x0522 c0x0000 (---------------)  +   for-more
	0x00051488, // n0x0523 c0x0000 (---------------)  +   for-some
	0x00051e87, // n0x0524 c0x0000 (---------------)  +   for-the
	0x00141246, // n0x0525 c0x0000 (---------------)  +   selfip
	0x0002c186, // n0x0526 c0x0000 (---------------)  +   webhop
	0x00278344, // n0x0527 c0x0000 (---------------)  + I asso
	0x003125c7, // n0x0528 c0x0000 (---------------)  + I barreau
	0x0009e448, // n0x0529 c0x0000 (---------------)  +   blogspot
	0x00252544, // n0x052a c0x0000 (---------------)  + I gouv
	0x00232dc3, // n0x052b c0x0000 (---------------)  + I com
	0x0021e083, // n0x052c c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x052d c0x0000 (---------------)  + I gov
	0x00218643, // n0x052e c0x0000 (---------------)  + I net
	0x0024d043, // n0x052f c0x0000 (---------------)  + I org
	0x00232dc3, // n0x0530 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0531 c0x0000 (---------------)  + I edu
	0x003704c3, // n0x0532 c0x0000 (---------------)  + I gob
	0x00209ac3, // n0x0533 c0x0000 (---------------)  + I gov
	0x002188c3, // n0x0534 c0x0000 (---------------)  + I int
	0x00240443, // n0x0535 c0x0000 (---------------)  + I mil
	0x00218643, // n0x0536 c0x0000 (---------------)  + I net
	0x0024d043, // n0x0537 c0x0000 (---------------)  + I org
	0x0028dc82, // n0x0538 c0x0000 (---------------)  + I tv
	0x002c6203, // n0x0539 c0x0000 (---------------)  + I adm
	0x00244b43, // n0x053a c0x0000 (---------------)  + I adv
	0x00263c03, // n0x053b c0x0000 (---------------)  + I agr
	0x00203582, // n0x053c c0x0000 (---------------)  + I am
	0x00381d43, // n0x053d c0x0000 (---------------)  + I arq
	0x00208d43, // n0x053e c0x0000 (---------------)  + I art
	0x00213403, // n0x053f c0x0000 (---------------)  + I ato
	0x00200001, // n0x0540 c0x0000 (---------------)  + I b
	0x00208743, // n0x0541 c0x0000 (---------------)  + I bio
	0x0029e444, // n0x0542 c0x0000 (---------------)  + I blog
	0x002da483, // n0x0543 c0x0000 (---------------)  + I bmd
	0x002ed943, // n0x0544 c0x0000 (---------------)  + I cim
	0x00369103, // n0x0545 c0x0000 (---------------)  + I cng
	0x0022fe43, // n0x0546 c0x0000 (---------------)  + I cnt
	0x0a232dc3, // n0x0547 c0x0028 (n0x057f-n0x0580)  + I com
	0x0023a884, // n0x0548 c0x0000 (---------------)  + I coop
	0x002e6183, // n0x0549 c0x0000 (---------------)  + I ecn
	0x00208e43, // n0x054a c0x0000 (---------------)  + I eco
	0x0021e083, // n0x054b c0x0000 (---------------)  + I edu
	0x002370c3, // n0x054c c0x0000 (---------------)  + I emp
	0x002abd43, // n0x054d c0x0000 (---------------)  + I eng
	0x0027b443, // n0x054e c0x0000 (---------------)  + I esp
	0x002ed8c3, // n0x054f c0x0000 (---------------)  + I etc
	0x00226e83, // n0x0550 c0x0000 (---------------)  + I eti
	0x002125c3, // n0x0551 c0x0000 (---------------)  + I far
	0x0024d284, // n0x0552 c0x0000 (---------------)  + I flog
	0x00257f82, // n0x0553 c0x0000 (---------------)  + I fm
	0x002500c3, // n0x0554 c0x0000 (---------------)  + I fnd
	0x002562c3, // n0x0555 c0x0000 (---------------)  + I fot
	0x002700c3, // n0x0556 c0x0000 (---------------)  + I fst
	0x00367843, // n0x0557 c0x0000 (---------------)  + I g12
	0x002db283, // n0x0558 c0x0000 (---------------)  + I ggf
	0x00209ac3, // n0x0559 c0x0000 (---------------)  + I gov
	0x00316683, // n0x055a c0x0000 (---------------)  + I imb
	0x002202c3, // n0x055b c0x0000 (---------------)  + I ind
	0x00206e83, // n0x055c c0x0000 (---------------)  + I inf
	0x00204703, // n0x055d c0x0000 (---------------)  + I jor
	0x002ab543, // n0x055e c0x0000 (---------------)  + I jus
	0x002308c3, // n0x055f c0x0000 (---------------)  + I leg
	0x00242a43, // n0x0560 c0x0000 (---------------)  + I lel
	0x002035c3, // n0x0561 c0x0000 (---------------)  + I mat
	0x00210e83, // n0x0562 c0x0000 (---------------)  + I med
	0x00240443, // n0x0563 c0x0000 (---------------)  + I mil
	0x00203302, // n0x0564 c0x0000 (---------------)  + I mp
	0x00294543, // n0x0565 c0x0000 (---------------)  + I mus
	0x00218643, // n0x0566 c0x0000 (---------------)  + I net
	0x016104c3, // n0x0567 c0x0005 (---------------)* o I nom
	0x00282d83, // n0x0568 c0x0000 (---------------)  + I not
	0x00200903, // n0x0569 c0x0000 (---------------)  + I ntr
	0x00210083, // n0x056a c0x0000 (---------------)  + I odo
	0x0024d043, // n0x056b c0x0000 (---------------)  + I org
	0x002a6f03, // n0x056c c0x0000 (---------------)  + I ppg
	0x002cfc43, // n0x056d c0x0000 (---------------)  + I pro
	0x00274fc3, // n0x056e c0x0000 (---------------)  + I psc
	0x00285203, // n0x056f c0x0000 (---------------)  + I psi
	0x002d3a43, // n0x0570 c0x0000 (---------------)  + I qsl
	0x00313c05, // n0x0571 c0x0000 (---------------)  + I radio
	0x0022a143, // n0x0572 c0x0000 (---------------)  + I rec
	0x0031b1c3, // n0x0573 c0x0000 (---------------)  + I slg
	0x002dc283, // n0x0574 c0x0000 (---------------)  + I srv
	0x00226b44, // n0x0575 c0x0000 (---------------)  + I taxi
	0x002b6343, // n0x0576 c0x0000 (---------------)  + I teo
	0x002032c3, // n0x0577 c0x0000 (---------------)  + I tmp
	0x0029c303, // n0x0578 c0x0000 (---------------)  + I trd
	0x0022a0c3, // n0x0579 c0x0000 (---------------)  + I tur
	0x0028dc82, // n0x057a c0x0000 (---------------)  + I tv
	0x0023c8c3, // n0x057b c0x0000 (---------------)  + I vet
	0x002f2084, // n0x057c c0x0000 (---------------)  + I vlog
	0x0022d744, // n0x057d c0x0000 (---------------)  + I wiki
	0x00275243, // n0x057e c0x0000 (---------------)  + I zlg
	0x0009e448, // n0x057f c0x0000 (---------------)  +   blogspot
	0x00232dc3, // n0x0580 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0581 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0582 c0x0000 (---------------)  + I gov
	0x00218643, // n0x0583 c0x0000 (---------------)  + I net
	0x0024d043, // n0x0584 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x0585 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0586 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0587 c0x0000 (---------------)  + I gov
	0x00218643, // n0x0588 c0x0000 (---------------)  + I net
	0x0024d043, // n0x0589 c0x0000 (---------------)  + I org
	0x00200882, // n0x058a c0x0000 (---------------)  + I co
	0x0024d043, // n0x058b c0x0000 (---------------)  + I org
	0x00232dc3, // n0x058c c0x0000 (---------------)  + I com
	0x00209ac3, // n0x058d c0x0000 (---------------)  + I gov
	0x00240443, // n0x058e c0x0000 (---------------)  + I mil
	0x00215fc2, // n0x058f c0x0000 (---------------)  + I of
	0x00232dc3, // n0x0590 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0591 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0592 c0x0000 (---------------)  + I gov
	0x00218643, // n0x0593 c0x0000 (---------------)  + I net
	0x0024d043, // n0x0594 c0x0000 (---------------)  + I org
	0x000028c2, // n0x0595 c0x0000 (---------------)  +   za
	0x002005c2, // n0x0596 c0x0000 (---------------)  + I ab
	0x00214542, // n0x0597 c0x0000 (---------------)  + I bc
	0x0009e448, // n0x0598 c0x0000 (---------------)  +   blogspot
	0x00000882, // n0x0599 c0x0000 (---------------)  +   co
	0x0030f002, // n0x059a c0x0000 (---------------)  + I gc
	0x00207b82, // n0x059b c0x0000 (---------------)  + I mb
	0x0020fe82, // n0x059c c0x0000 (---------------)  + I nb
	0x00206ec2, // n0x059d c0x0000 (---------------)  + I nf
	0x00248cc2, // n0x059e c0x0000 (---------------)  + I nl
	0x0020ae82, // n0x059f c0x0000 (---------------)  + I ns
	0x00200902, // n0x05a0 c0x0000 (---------------)  + I nt
	0x0020fd82, // n0x05a1 c0x0000 (---------------)  + I nu
	0x00200342, // n0x05a2 c0x0000 (---------------)  + I on
	0x0020c782, // n0x05a3 c0x0000 (---------------)  + I pe
	0x003513c2, // n0x05a4 c0x0000 (---------------)  + I qc
	0x00200e02, // n0x05a5 c0x0000 (---------------)  + I sk
	0x00218482, // n0x05a6 c0x0000 (---------------)  + I yk
	0x0000dec9, // n0x05a7 c0x0000 (---------------)  +   ftpaccess
	0x0008e90b, // n0x05a8 c0x0000 (---------------)  +   game-server
	0x000c3048, // n0x05a9 c0x0000 (---------------)  +   myphotos
	0x000895c9, // n0x05aa c0x0000 (---------------)  +   scrapping
	0x00209ac3, // n0x05ab c0x0000 (---------------)  + I gov
	0x0009e448, // n0x05ac c0x0000 (---------------)  +   blogspot
	0x0009e448, // n0x05ad c0x0000 (---------------)  +   blogspot
	0x00200b82, // n0x05ae c0x0000 (---------------)  + I ac
	0x00278344, // n0x05af c0x0000 (---------------)  + I asso
	0x00200882, // n0x05b0 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x05b1 c0x0000 (---------------)  + I com
	0x00205742, // n0x05b2 c0x0000 (---------------)  + I ed
	0x0021e083, // n0x05b3 c0x0000 (---------------)  + I edu
	0x00209ac2, // n0x05b4 c0x0000 (---------------)  + I go
	0x00252544, // n0x05b5 c0x0000 (---------------)  + I gouv
	0x002188c3, // n0x05b6 c0x0000 (---------------)  + I int
	0x0024a3c2, // n0x05b7 c0x0000 (---------------)  + I md
	0x00218643, // n0x05b8 c0x0000 (---------------)  + I net
	0x00200d02, // n0x05b9 c0x0000 (---------------)  + I or
	0x0024d043, // n0x05ba c0x0000 (---------------)  + I org
	0x0022ad46, // n0x05bb c0x0000 (---------------)  + I presse
	0x00300b8f, // n0x05bc c0x0000 (---------------)  + I xn--aroport-bya
	0x006b1c03, // n0x05bd c0x0001 (---------------)  ! I www
	0x00200882, // n0x05be c0x0000 (---------------)  + I co
	0x003704c3, // n0x05bf c0x0000 (---------------)  + I gob
	0x00209ac3, // n0x05c0 c0x0000 (---------------)  + I gov
	0x00240443, // n0x05c1 c0x0000 (---------------)  + I mil
	0x00200882, // n0x05c2 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x05c3 c0x0000 (---------------)  + I com
	0x00209ac3, // n0x05c4 c0x0000 (---------------)  + I gov
	0x00218643, // n0x05c5 c0x0000 (---------------)  + I net
	0x00200b82, // n0x05c6 c0x0000 (---------------)  + I ac
	0x00203042, // n0x05c7 c0x0000 (---------------)  + I ah
	0x0e29ba09, // n0x05c8 c0x0038 (n0x05f3-n0x05f4)  o I amazonaws
	0x0020bb82, // n0x05c9 c0x0000 (---------------)  + I bj
	0x00232dc3, // n0x05ca c0x0000 (---------------)  + I com
	0x0023f102, // n0x05cb c0x0000 (---------------)  + I cq
	0x0021e083, // n0x05cc c0x0000 (---------------)  + I edu
	0x00213802, // n0x05cd c0x0000 (---------------)  + I fj
	0x00218cc2, // n0x05ce c0x0000 (---------------)  + I gd
	0x00209ac3, // n0x05cf c0x0000 (---------------)  + I gov
	0x00209602, // n0x05d0 c0x0000 (---------------)  + I gs
	0x0026bc02, // n0x05d1 c0x0000 (---------------)  + I gx
	0x002752c2, // n0x05d2 c0x0000 (---------------)  + I gz
	0x00203082, // n0x05d3 c0x0000 (---------------)  + I ha
	0x00300202, // n0x05d4 c0x0000 (---------------)  + I hb
	0x002093c2, // n0x05d5 c0x0000 (---------------)  + I he
	0x00200202, // n0x05d6 c0x0000 (---------------)  + I hi
	0x002301c2, // n0x05d7 c0x0000 (---------------)  + I hk
	0x0029c882, // n0x05d8 c0x0000 (---------------)  + I hl
	0x00206802, // n0x05d9 c0x0000 (---------------)  + I hn
	0x002a1cc2, // n0x05da c0x0000 (---------------)  + I jl
	0x002ddb42, // n0x05db c0x0000 (---------------)  + I js
	0x00303c42, // n0x05dc c0x0000 (---------------)  + I jx
	0x00232682, // n0x05dd c0x0000 (---------------)  + I ln
	0x00240443, // n0x05de c0x0000 (---------------)  + I mil
	0x00205202, // n0x05df c0x0000 (---------------)  + I mo
	0x00218643, // n0x05e0 c0x0000 (---------------)  + I net
	0x00226d42, // n0x05e1 c0x0000 (---------------)  + I nm
	0x0027c402, // n0x05e2 c0x0000 (---------------)  + I nx
	0x0024d043, // n0x05e3 c0x0000 (---------------)  + I org
	0x00381dc2, // n0x05e4 c0x0000 (---------------)  + I qh
	0x0021bcc2, // n0x05e5 c0x0000 (---------------)  + I sc
	0x0020acc2, // n0x05e6 c0x0000 (---------------)  + I sd
	0x002001c2, // n0x05e7 c0x0000 (---------------)  + I sh
	0x00214782, // n0x05e8 c0x0000 (---------------)  + I sn
	0x002e3902, // n0x05e9 c0x0000 (---------------)  + I sx
	0x002046c2, // n0x05ea c0x0000 (---------------)  + I tj
	0x002548c2, // n0x05eb c0x0000 (---------------)  + I tw
	0x0022cf82, // n0x05ec c0x0000 (---------------)  + I xj
	0x002f66ca, // n0x05ed c0x0000 (---------------)  + I xn--55qx5d
	0x00326e4a, // n0x05ee c0x0000 (---------------)  + I xn--io0a7i
	0x0034cf0a, // n0x05ef c0x0000 (---------------)  + I xn--od0alg
	0x003862c2, // n0x05f0 c0x0000 (---------------)  + I xz
	0x0020dc42, // n0x05f1 c0x0000 (---------------)  + I yn
	0x0025cf42, // n0x05f2 c0x0000 (---------------)  + I zj
	0x0e4347c7, // n0x05f3 c0x0039 (n0x05f4-n0x05f5)  +   compute
	0x000e61ca, // n0x05f4 c0x0000 (---------------)  +   cn-north-1
	0x0020b384, // n0x05f5 c0x0000 (---------------)  + I arts
	0x00232dc3, // n0x05f6 c0x0000 (---------------)  + I com
	0x0021e083, // n0x05f7 c0x0000 (---------------)  + I edu
	0x0024a304, // n0x05f8 c0x0000 (---------------)  + I firm
	0x00209ac3, // n0x05f9 c0x0000 (---------------)  + I gov
	0x00208a44, // n0x05fa c0x0000 (---------------)  + I info
	0x002188c3, // n0x05fb c0x0000 (---------------)  + I int
	0x00240443, // n0x05fc c0x0000 (---------------)  + I mil
	0x00218643, // n0x05fd c0x0000 (---------------)  + I net
	0x002104c3, // n0x05fe c0x0000 (---------------)  + I nom
	0x0024d043, // n0x05ff c0x0000 (---------------)  + I org
	0x0022a143, // n0x0600 c0x0000 (---------------)  + I rec
	0x002071c3, // n0x0601 c0x0000 (---------------)  + I web
	0x0014fc46, // n0x0602 c0x0000 (---------------)  +   africa
	0x0f29ba09, // n0x0603 c0x003c (n0x06c7-n0x06de)  o I amazonaws
	0x00049187, // n0x0604 c0x0000 (---------------)  +   appspot
	0x000030c2, // n0x0605 c0x0000 (---------------)  +   ar
	0x00180eca, // n0x0606 c0x0000 (---------------)  +   betainabox
	0x000dd187, // n0x0607 c0x0000 (---------------)  +   blogdns
	0x0009e448, // n0x0608 c0x0000 (---------------)  +   blogspot
	0x00007bc2, // n0x0609 c0x0000 (---------------)  +   br
	0x0010acc7, // n0x060a c0x0000 (---------------)  +   cechire
	0x0000074f, // n0x060b c0x0000 (---------------)  +   cloudcontrolapp
	0x0002f10f, // n0x060c c0x0000 (---------------)  +   cloudcontrolled
	0x0002fe42, // n0x060d c0x0000 (---------------)  +   cn
	0x00000882, // n0x060e c0x0000 (---------------)  +   co
	0x0007b388, // n0x060f c0x0000 (---------------)  +   codespot
	0x00007cc2, // n0x0610 c0x0000 (---------------)  +   de
	0x000c7a88, // n0x0611 c0x0000 (---------------)  +   dnsalias
	0x00181687, // n0x0612 c0x0000 (---------------)  +   dnsdojo
	0x000146cb, // n0x0613 c0x0000 (---------------)  +   doesntexist
	0x0012cb09, // n0x0614 c0x0000 (---------------)  +   dontexist
	0x000c7987, // n0x0615 c0x0000 (---------------)  +   doomdns
	0x000e9ccc, // n0x0616 c0x0000 (---------------)  +   dreamhosters
	0x0017cf4a, // n0x0617 c0x0000 (---------------)  +   dyn-o-saur
	0x00159288, // n0x0618 c0x0000 (---------------)  +   dynalias
	0x00010b8e, // n0x0619 c0x0000 (---------------)  +   dyndns-at-home
	0x000264ce, // n0x061a c0x0000 (---------------)  +   dyndns-at-work
	0x000dcfcb, // n0x061b c0x0000 (---------------)  +   dyndns-blog
	0x0018214b, // n0x061c c0x0000 (---------------)  +   dyndns-free
	0x0000dc0b, // n0x061d c0x0000 (---------------)  +   dyndns-home
	0x00013909, // n0x061e c0x0000 (---------------)  +   dyndns-ip
	0x00014d8b, // n0x061f c0x0000 (---------------)  +   dyndns-mail
	0x00015e0d, // n0x0620 c0x0000 (---------------)  +   dyndns-office
	0x00021dcb, // n0x0621 c0x0000 (---------------)  +   dyndns-pics
	0x0002420d, // n0x0622 c0x0000 (---------------)  +   dyndns-remote
	0x00027c0d, // n0x0623 c0x0000 (---------------)  +   dyndns-server
	0x0002bfca, // n0x0624 c0x0000 (---------------)  +   dyndns-web
	0x0002d58b, // n0x0625 c0x0000 (---------------)  +   dyndns-wiki
	0x0002e38b, // n0x0626 c0x0000 (---------------)  +   dyndns-work
	0x0003d4d0, // n0x0627 c0x0000 (---------------)  +   elasticbeanstalk
	0x000ee4cf, // n0x0628 c0x0000 (---------------)  +   est-a-la-maison
	0x0002844f, // n0x0629 c0x0000 (---------------)  +   est-a-la-masion
	0x0016c84d, // n0x062a c0x0000 (---------------)  +   est-le-patron
	0x00119c10, // n0x062b c0x0000 (---------------)  +   est-mon-blogueur
	0x0001b882, // n0x062c c0x0000 (---------------)  +   eu
	0x00048f8b, // n0x062d c0x0000 (---------------)  +   firebaseapp
	0x0004f748, // n0x062e c0x0000 (---------------)  +   flynnhub
	0x0005c087, // n0x062f c0x0000 (---------------)  +   from-ak
	0x0005ca47, // n0x0630 c0x0000 (---------------)  +   from-al
	0x0005cc07, // n0x0631 c0x0000 (---------------)  +   from-ar
	0x0005d0c7, // n0x0632 c0x0000 (---------------)  +   from-ca
	0x0005e487, // n0x0633 c0x0000 (---------------)  +   from-ct
	0x0005eb07, // n0x0634 c0x0000 (---------------)  +   from-dc
	0x0005f407, // n0x0635 c0x0000 (---------------)  +   from-de
	0x0005f6c7, // n0x0636 c0x0000 (---------------)  +   from-fl
	0x000609c7, // n0x0637 c0x0000 (---------------)  +   from-ga
	0x00060b87, // n0x0638 c0x0000 (---------------)  +   from-hi
	0x00061647, // n0x0639 c0x0000 (---------------)  +   from-ia
	0x00061807, // n0x063a c0x0000 (---------------)  +   from-id
	0x000619c7, // n0x063b c0x0000 (---------------)  +   from-il
	0x00061b87, // n0x063c c0x0000 (---------------)  +   from-in
	0x00062187, // n0x063d c0x0000 (---------------)  +   from-ks
	0x00062e87, // n0x063e c0x0000 (---------------)  +   from-ky
	0x00064007, // n0x063f c0x0000 (---------------)  +   from-ma
	0x000647c7, // n0x0640 c0x0000 (---------------)  +   from-md
	0x00064d07, // n0x0641 c0x0000 (---------------)  +   from-mi
	0x00065307, // n0x0642 c0x0000 (---------------)  +   from-mn
	0x000654c7, // n0x0643 c0x0000 (---------------)  +   from-mo
	0x00065a87, // n0x0644 c0x0000 (---------------)  +   from-ms
	0x00066647, // n0x0645 c0x0000 (---------------)  +   from-mt
	0x00066847, // n0x0646 c0x0000 (---------------)  +   from-nc
	0x00066d47, // n0x0647 c0x0000 (---------------)  +   from-nd
	0x00066f07, // n0x0648 c0x0000 (---------------)  +   from-ne
	0x000670c7, // n0x0649 c0x0000 (---------------)  +   from-nh
	0x000676c7, // n0x064a c0x0000 (---------------)  +   from-nj
	0x00067c47, // n0x064b c0x0000 (---------------)  +   from-nm
	0x000682c7, // n0x064c c0x0000 (---------------)  +   from-nv
	0x000688c7, // n0x064d c0x0000 (---------------)  +   from-oh
	0x00068f87, // n0x064e c0x0000 (---------------)  +   from-ok
	0x00069307, // n0x064f c0x0000 (---------------)  +   from-or
	0x000694c7, // n0x0650 c0x0000 (---------------)  +   from-pa
	0x0006a187, // n0x0651 c0x0000 (---------------)  +   from-pr
	0x0006b187, // n0x0652 c0x0000 (---------------)  +   from-ri
	0x0006bf07, // n0x0653 c0x0000 (---------------)  +   from-sc
	0x0006c487, // n0x0654 c0x0000 (---------------)  +   from-sd
	0x0006c647, // n0x0655 c0x0000 (---------------)  +   from-tn
	0x0006c807, // n0x0656 c0x0000 (---------------)  +   from-tx
	0x0006cc47, // n0x0657 c0x0000 (---------------)  +   from-ut
	0x0006cfc7, // n0x0658 c0x0000 (---------------)  +   from-va
	0x0006d387, // n0x0659 c0x0000 (---------------)  +   from-vt
	0x0006d9c7, // n0x065a c0x0000 (---------------)  +   from-wa
	0x0006db87, // n0x065b c0x0000 (---------------)  +   from-wi
	0x0006df07, // n0x065c c0x0000 (---------------)  +   from-wv
	0x0006e747, // n0x065d c0x0000 (---------------)  +   from-wy
	0x0000cd02, // n0x065e c0x0000 (---------------)  +   gb
	0x000c75c7, // n0x065f c0x0000 (---------------)  +   getmyip
	0x000bb191, // n0x0660 c0x0000 (---------------)  +   githubusercontent
	0x0007cdca, // n0x0661 c0x0000 (---------------)  +   googleapis
	0x0007b20a, // n0x0662 c0x0000 (---------------)  +   googlecode
	0x00052ac6, // n0x0663 c0x0000 (---------------)  +   gotdns
	0x00006b02, // n0x0664 c0x0000 (---------------)  +   gr
	0x00056389, // n0x0665 c0x0000 (---------------)  +   herokuapp
	0x00089a09, // n0x0666 c0x0000 (---------------)  +   herokussl
	0x000301c2, // n0x0667 c0x0000 (---------------)  +   hk
	0x000f45ca, // n0x0668 c0x0000 (---------------)  +   hobby-site
	0x00099409, // n0x0669 c0x0000 (---------------)  +   homelinux
	0x00099ec8, // n0x066a c0x0000 (---------------)  +   homeunix
	0x000045c2, // n0x066b c0x0000 (---------------)  +   hu
	0x001099c9, // n0x066c c0x0000 (---------------)  +   iamallama
	0x0006a3ce, // n0x066d c0x0000 (---------------)  +   is-a-anarchist
	0x000e280c, // n0x066e c0x0000 (---------------)  +   is-a-blogger
	0x000c43cf, // n0x066f c0x0000 (---------------)  +   is-a-bookkeeper
	0x0015be8e, // n0x0670 c0x0000 (---------------)  +   is-a-bulls-fan
	0x0001918c, // n0x0671 c0x0000 (---------------)  +   is-a-caterer
	0x0001f409, // n0x0672 c0x0000 (---------------)  +   is-a-chef
	0x00023b51, // n0x0673 c0x0000 (---------------)  +   is-a-conservative
	0x00025588, // n0x0674 c0x0000 (---------------)  +   is-a-cpa
	0x00096052, // n0x0675 c0x0000 (---------------)  +   is-a-cubicle-slave
	0x00179f8d, // n0x0676 c0x0000 (---------------)  +   is-a-democrat
	0x0003f84d, // n0x0677 c0x0000 (---------------)  +   is-a-designer
	0x00040bcb, // n0x0678 c0x0000 (---------------)  +   is-a-doctor
	0x000447d5, // n0x0679 c0x0000 (---------------)  +   is-a-financialadvisor
	0x00047789, // n0x067a c0x0000 (---------------)  +   is-a-geek
	0x00052d8a, // n0x067b c0x0000 (---------------)  +   is-a-green
	0x00061109, // n0x067c c0x0000 (---------------)  +   is-a-guru
	0x000643d0, // n0x067d c0x0000 (---------------)  +   is-a-hard-worker
	0x0006800b, // n0x067e c0x0000 (---------------)  +   is-a-hunter
	0x0007730f, // n0x067f c0x0000 (---------------)  +   is-a-landscaper
	0x00079b8b, // n0x0680 c0x0000 (---------------)  +   is-a-lawyer
	0x0007a5cc, // n0x0681 c0x0000 (---------------)  +   is-a-liberal
	0x00081cd0, // n0x0682 c0x0000 (---------------)  +   is-a-libertarian
	0x0015658a, // n0x0683 c0x0000 (---------------)  +   is-a-llama
	0x0009440d, // n0x0684 c0x0000 (---------------)  +   is-a-musician
	0x0009800e, // n0x0685 c0x0000 (---------------)  +   is-a-nascarfan
	0x0009f7ca, // n0x0686 c0x0000 (---------------)  +   is-a-nurse
	0x000a01cc, // n0x0687 c0x0000 (---------------)  +   is-a-painter
	0x000a7f94, // n0x0688 c0x0000 (---------------)  +   is-a-personaltrainer
	0x000a7491, // n0x0689 c0x0000 (---------------)  +   is-a-photographer
	0x000e8ecb, // n0x068a c0x0000 (---------------)  +   is-a-player
	0x000d7d0f, // n0x068b c0x0000 (---------------)  +   is-a-republican
	0x000e064d, // n0x068c c0x0000 (---------------)  +   is-a-rockstar
	0x000adf0e, // n0x068d c0x0000 (---------------)  +   is-a-socialist
	0x0013ac8c, // n0x068e c0x0000 (---------------)  +   is-a-student
	0x000a344c, // n0x068f c0x0000 (---------------)  +   is-a-teacher
	0x000a718b, // n0x0690 c0x0000 (---------------)  +   is-a-techie
	0x000a91ce, // n0x0691 c0x0000 (---------------)  +   is-a-therapist
	0x000ac710, // n0x0692 c0x0000 (---------------)  +   is-an-accountant
	0x000ae94b, // n0x0693 c0x0000 (---------------)  +   is-an-actor
	0x000afb8d, // n0x0694 c0x0000 (---------------)  +   is-an-actress
	0x000e858f, // n0x0695 c0x0000 (---------------)  +   is-an-anarchist
	0x000d750c, // n0x0696 c0x0000 (---------------)  +   is-an-artist
	0x0010dace, // n0x0697 c0x0000 (---------------)  +   is-an-engineer
	0x000b6c91, // n0x0698 c0x0000 (---------------)  +   is-an-entertainer
	0x000d404c, // n0x0699 c0x0000 (---------------)  +   is-certified
	0x000dd607, // n0x069a c0x0000 (---------------)  +   is-gone
	0x000e47cd, // n0x069b c0x0000 (---------------)  +   is-into-anime
	0x000d508c, // n0x069c c0x0000 (---------------)  +   is-into-cars
	0x000de750, // n0x069d c0x0000 (---------------)  +   is-into-cartoons
	0x000dffcd, // n0x069e c0x0000 (---------------)  +   is-into-games
	0x000e3307, // n0x069f c0x0000 (---------------)  +   is-leet
	0x0010c8d0, // n0x06a0 c0x0000 (---------------)  +   is-not-certified
	0x00102608, // n0x06a1 c0x0000 (---------------)  +   is-slick
	0x0010724b, // n0x06a2 c0x0000 (---------------)  +   is-uberleet
	0x0012c78f, // n0x06a3 c0x0000 (---------------)  +   is-with-theband
	0x00013e48, // n0x06a4 c0x0000 (---------------)  +   isa-geek
	0x0007cfcd, // n0x06a5 c0x0000 (---------------)  +   isa-hockeynut
	0x00140d50, // n0x06a6 c0x0000 (---------------)  +   issmarterthanyou
	0x000a2b03, // n0x06a7 c0x0000 (---------------)  +   jpn
	0x0000c642, // n0x06a8 c0x0000 (---------------)  +   kr
	0x000222c9, // n0x06a9 c0x0000 (---------------)  +   likes-pie
	0x0008ec8a, // n0x06aa c0x0000 (---------------)  +   likescandy
	0x00073d83, // n0x06ab c0x0000 (---------------)  +   mex
	0x0010bf08, // n0x06ac c0x0000 (---------------)  +   neat-url
	0x00008287, // n0x06ad c0x0000 (---------------)  +   nfshost
	0x00000cc2, // n0x06ae c0x0000 (---------------)  +   no
	0x00113d8a, // n0x06af c0x0000 (---------------)  +   operaunite
	0x0017e10f, // n0x06b0 c0x0000 (---------------)  +   outsystemscloud
	0x0015f2d2, // n0x06b1 c0x0000 (---------------)  +   pagespeedmobilizer
	0x001513c2, // n0x06b2 c0x0000 (---------------)  +   qc
	0x000006c7, // n0x06b3 c0x0000 (---------------)  +   rhcloud
	0x00000982, // n0x06b4 c0x0000 (---------------)  +   ro
	0x00002f82, // n0x06b5 c0x0000 (---------------)  +   ru
	0x00003a82, // n0x06b6 c0x0000 (---------------)  +   sa
	0x0005f9d0, // n0x06b7 c0x0000 (---------------)  +   saves-the-whales
	0x00004982, // n0x06b8 c0x0000 (---------------)  +   se
	0x00141246, // n0x06b9 c0x0000 (---------------)  +   selfip
	0x0008e20e, // n0x06ba c0x0000 (---------------)  +   sells-for-less
	0x0009cc8b, // n0x06bb c0x0000 (---------------)  +   sells-for-u
	0x0000be88, // n0x06bc c0x0000 (---------------)  +   servebbs
	0x00118cca, // n0x06bd c0x0000 (---------------)  +   simple-url
	0x000d91cd, // n0x06be c0x0000 (---------------)  +   space-to-rent
	0x0016730c, // n0x06bf c0x0000 (---------------)  +   teaches-yoga
	0x00000542, // n0x06c0 c0x0000 (---------------)  +   uk
	0x000073c2, // n0x06c1 c0x0000 (---------------)  +   us
	0x00004282, // n0x06c2 c0x0000 (---------------)  +   uy
	0x0007ccca, // n0x06c3 c0x0000 (---------------)  +   withgoogle
	0x0009e1ce, // n0x06c4 c0x0000 (---------------)  +   writesthisblog
	0x000dbb08, // n0x06c5 c0x0000 (---------------)  +   yolasite
	0x000028c2, // n0x06c6 c0x0000 (---------------)  +   za
	0x0f4347c7, // n0x06c7 c0x003d (n0x06de-n0x06e7)  +   compute
	0x0f8347c9, // n0x06c8 c0x003e (n0x06e7-n0x06e9)  +   compute-1
	0x00012d43, // n0x06c9 c0x0000 (---------------)  +   elb
	0x00007102, // n0x06ca c0x0000 (---------------)  +   s3
	0x00146091, // n0x06cb c0x0000 (---------------)  +   s3-ap-northeast-1
	0x001232d1, // n0x06cc c0x0000 (---------------)  +   s3-ap-southeast-1
	0x00135851, // n0x06cd c0x0000 (---------------)  +   s3-ap-southeast-2
	0x000fd00c, // n0x06ce c0x0000 (---------------)  +   s3-eu-west-1
	0x00101b55, // n0x06cf c0x0000 (---------------)  +   s3-fips-us-gov-west-1
	0x0011030c, // n0x06d0 c0x0000 (---------------)  +   s3-sa-east-1
	0x00111f50, // n0x06d1 c0x0000 (---------------)  +   s3-us-gov-west-1
	0x00112e8c, // n0x06d2 c0x0000 (---------------)  +   s3-us-west-1
	0x0011a8cc, // n0x06d3 c0x0000 (---------------)  +   s3-us-west-2
	0x0014d6d9, // n0x06d4 c0x0000 (---------------)  +   s3-website-ap-northeast-1
	0x00170659, // n0x06d5 c0x0000 (---------------)  +   s3-website-ap-southeast-1
	0x00176f59, // n0x06d6 c0x0000 (---------------)  +   s3-website-ap-southeast-2
	0x0017d314, // n0x06d7 c0x0000 (---------------)  +   s3-website-eu-west-1
	0x00185994, // n0x06d8 c0x0000 (---------------)  +   s3-website-sa-east-1
	0x00007114, // n0x06d9 c0x0000 (---------------)  +   s3-website-us-east-1
	0x00009758, // n0x06da c0x0000 (---------------)  +   s3-website-us-gov-west-1
	0x0000b694, // n0x06db c0x0000 (---------------)  +   s3-website-us-west-1
	0x0000c054, // n0x06dc c0x0000 (---------------)  +   s3-website-us-west-2
	0x000073c9, // n0x06dd c0x0000 (---------------)  +   us-east-1
	0x0014614e, // n0x06de c0x0000 (---------------)  +   ap-northeast-1
	0x0012338e, // n0x06df c0x0000 (---------------)  +   ap-southeast-1
	0x0013590e, // n0x06e0 c0x0000 (---------------)  +   ap-southeast-2
	0x0001b88c, // n0x06e1 c0x0000 (---------------)  +   eu-central-1
	0x000fd0c9, // n0x06e2 c0x0000 (---------------)  +   eu-west-1
	0x001103c9, // n0x06e3 c0x0000 (---------------)  +   sa-east-1
	0x00009a0d, // n0x06e4 c0x0000 (---------------)  +   us-gov-west-1
	0x0000b949, // n0x06e5 c0x0000 (---------------)  +   us-west-1
	0x0000c309, // n0x06e6 c0x0000 (---------------)  +   us-west-2
	0x001617c3, // n0x06e7 c0x0000 (---------------)  +   z-1
	0x0012eb83, // n0x06e8 c0x0000 (---------------)  +   z-2
	0x00200b82, // n0x06e9 c0x0000 (---------------)  + I ac
	0x00200882, // n0x06ea c0x0000 (---------------)  + I co
	0x00205742, // n0x06eb c0x0000 (---------------)  + I ed
	0x00206f02, // n0x06ec c0x0000 (---------------)  + I fi
	0x00209ac2, // n0x06ed c0x0000 (---------------)  + I go
	0x00200d02, // n0x06ee c0x0000 (---------------)  + I or
	0x00203a82, // n0x06ef c0x0000 (---------------)  + I sa
	0x00232dc3, // n0x06f0 c0x0000 (---------------)  + I com
	0x0021e083, // n0x06f1 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x06f2 c0x0000 (---------------)  + I gov
	0x00206e83, // n0x06f3 c0x0000 (---------------)  + I inf
	0x00218643, // n0x06f4 c0x0000 (---------------)  + I net
	0x0024d043, // n0x06f5 c0x0000 (---------------)  + I org
	0x0009e448, // n0x06f6 c0x0000 (---------------)  +   blogspot
	0x00232dc3, // n0x06f7 c0x0000 (---------------)  + I com
	0x0021e083, // n0x06f8 c0x0000 (---------------)  + I edu
	0x00218643, // n0x06f9 c0x0000 (---------------)  + I net
	0x0024d043, // n0x06fa c0x0000 (---------------)  + I org
	0x00009343, // n0x06fb c0x0000 (---------------)  +   ath
	0x00209ac3, // n0x06fc c0x0000 (---------------)  + I gov
	0x0009e448, // n0x06fd c0x0000 (---------------)  +   blogspot
	0x0009e448, // n0x06fe c0x0000 (---------------)  +   blogspot
	0x00032dc3, // n0x06ff c0x0000 (---------------)  +   com
	0x00173f0f, // n0x0700 c0x0000 (---------------)  +   fuettertdasnetz
	0x0012cc8a, // n0x0701 c0x0000 (---------------)  +   isteingeek
	0x000ae1c7, // n0x0702 c0x0000 (---------------)  +   istmein
	0x0003ad0a, // n0x0703 c0x0000 (---------------)  +   lebtimnetz
	0x0000948a, // n0x0704 c0x0000 (---------------)  +   leitungsen
	0x000f5c4d, // n0x0705 c0x0000 (---------------)  +   traeumtgerade
	0x0009e448, // n0x0706 c0x0000 (---------------)  +   blogspot
	0x00232dc3, // n0x0707 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0708 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0709 c0x0000 (---------------)  + I gov
	0x00218643, // n0x070a c0x0000 (---------------)  + I net
	0x0024d043, // n0x070b c0x0000 (---------------)  + I org
	0x00208d43, // n0x070c c0x0000 (---------------)  + I art
	0x00232dc3, // n0x070d c0x0000 (---------------)  + I com
	0x0021e083, // n0x070e c0x0000 (---------------)  + I edu
	0x003704c3, // n0x070f c0x0000 (---------------)  + I gob
	0x00209ac3, // n0x0710 c0x0000 (---------------)  + I gov
	0x00240443, // n0x0711 c0x0000 (---------------)  + I mil
	0x00218643, // n0x0712 c0x0000 (---------------)  + I net
	0x0024d043, // n0x0713 c0x0000 (---------------)  + I org
	0x002d3a83, // n0x0714 c0x0000 (---------------)  + I sld
	0x002071c3, // n0x0715 c0x0000 (---------------)  + I web
	0x00208d43, // n0x0716 c0x0000 (---------------)  + I art
	0x00278344, // n0x0717 c0x0000 (---------------)  + I asso
	0x00232dc3, // n0x0718 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0719 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x071a c0x0000 (---------------)  + I gov
	0x00218643, // n0x071b c0x0000 (---------------)  + I net
	0x0024d043, // n0x071c c0x0000 (---------------)  + I org
	0x002369c3, // n0x071d c0x0000 (---------------)  + I pol
	0x00232dc3, // n0x071e c0x0000 (---------------)  + I com
	0x0021e083, // n0x071f c0x0000 (---------------)  + I edu
	0x00206f03, // n0x0720 c0x0000 (---------------)  + I fin
	0x003704c3, // n0x0721 c0x0000 (---------------)  + I gob
	0x00209ac3, // n0x0722 c0x0000 (---------------)  + I gov
	0x00208a44, // n0x0723 c0x0000 (---------------)  + I info
	0x0036e803, // n0x0724 c0x0000 (---------------)  + I k12
	0x00210e83, // n0x0725 c0x0000 (---------------)  + I med
	0x00240443, // n0x0726 c0x0000 (---------------)  + I mil
	0x00218643, // n0x0727 c0x0000 (---------------)  + I net
	0x0024d043, // n0x0728 c0x0000 (---------------)  + I org
	0x002cfc43, // n0x0729 c0x0000 (---------------)  + I pro
	0x00233b03, // n0x072a c0x0000 (---------------)  + I aip
	0x00232dc3, // n0x072b c0x0000 (---------------)  + I com
	0x0021e083, // n0x072c c0x0000 (---------------)  + I edu
	0x00287a03, // n0x072d c0x0000 (---------------)  + I fie
	0x00209ac3, // n0x072e c0x0000 (---------------)  + I gov
	0x0027a703, // n0x072f c0x0000 (---------------)  + I lib
	0x00210e83, // n0x0730 c0x0000 (---------------)  + I med
	0x0024d043, // n0x0731 c0x0000 (---------------)  + I org
	0x0022e843, // n0x0732 c0x0000 (---------------)  + I pri
	0x00382984, // n0x0733 c0x0000 (---------------)  + I riik
	0x00232dc3, // n0x0734 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0735 c0x0000 (---------------)  + I edu
	0x00299f83, // n0x0736 c0x0000 (---------------)  + I eun
	0x00209ac3, // n0x0737 c0x0000 (---------------)  + I gov
	0x00240443, // n0x0738 c0x0000 (---------------)  + I mil
	0x00267944, // n0x0739 c0x0000 (---------------)  + I name
	0x00218643, // n0x073a c0x0000 (---------------)  + I net
	0x0024d043, // n0x073b c0x0000 (---------------)  + I org
	0x00220143, // n0x073c c0x0000 (---------------)  + I sci
	0x13a32dc3, // n0x073d c0x004e (n0x0742-n0x0743)  + I com
	0x0021e083, // n0x073e c0x0000 (---------------)  + I edu
	0x003704c3, // n0x073f c0x0000 (---------------)  + I gob
	0x002104c3, // n0x0740 c0x0000 (---------------)  + I nom
	0x0024d043, // n0x0741 c0x0000 (---------------)  + I org
	0x0009e448, // n0x0742 c0x0000 (---------------)  +   blogspot
	0x00202183, // n0x0743 c0x0000 (---------------)  + I biz
	0x00232dc3, // n0x0744 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0745 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0746 c0x0000 (---------------)  + I gov
	0x00208a44, // n0x0747 c0x0000 (---------------)  + I info
	0x00267944, // n0x0748 c0x0000 (---------------)  + I name
	0x0024d043, // n0x0749 c0x0000 (---------------)  + I org
	0x00322285, // n0x074a c0x0000 (---------------)  + I aland
	0x0009e448, // n0x074b c0x0000 (---------------)  +   blogspot
	0x00023ac3, // n0x074c c0x0000 (---------------)  +   iki
	0x00366c48, // n0x074d c0x0000 (---------------)  + I aeroport
	0x00332a87, // n0x074e c0x0000 (---------------)  + I assedic
	0x00278344, // n0x074f c0x0000 (---------------)  + I asso
	0x0035f846, // n0x0750 c0x0000 (---------------)  + I avocat
	0x00364ec6, // n0x0751 c0x0000 (---------------)  + I avoues
	0x0009e448, // n0x0752 c0x0000 (---------------)  +   blogspot
	0x00262983, // n0x0753 c0x0000 (---------------)  + I cci
	0x002edec9, // n0x0754 c0x0000 (---------------)  + I chambagri
	0x00265e15, // n0x0755 c0x0000 (---------------)  + I chirurgiens-dentistes
	0x00232dc3, // n0x0756 c0x0000 (---------------)  + I com
	0x00319812, // n0x0757 c0x0000 (---------------)  + I experts-comptables
	0x003195cf, // n0x0758 c0x0000 (---------------)  + I geometre-expert
	0x00252544, // n0x0759 c0x0000 (---------------)  + I gouv
	0x002bdb85, // n0x075a c0x0000 (---------------)  + I greta
	0x002ab310, // n0x075b c0x0000 (---------------)  + I huissier-justice
	0x002e1b47, // n0x075c c0x0000 (---------------)  + I medecin
	0x002104c3, // n0x075d c0x0000 (---------------)  + I nom
	0x00283208, // n0x075e c0x0000 (---------------)  + I notaires
	0x002c55ca, // n0x075f c0x0000 (---------------)  + I pharmacien
	0x002167c4, // n0x0760 c0x0000 (---------------)  + I port
	0x002cf303, // n0x0761 c0x0000 (---------------)  + I prd
	0x0022ad46, // n0x0762 c0x0000 (---------------)  + I presse
	0x002032c2, // n0x0763 c0x0000 (---------------)  + I tm
	0x002ff6cb, // n0x0764 c0x0000 (---------------)  + I veterinaire
	0x00232dc3, // n0x0765 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0766 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0767 c0x0000 (---------------)  + I gov
	0x00240443, // n0x0768 c0x0000 (---------------)  + I mil
	0x00218643, // n0x0769 c0x0000 (---------------)  + I net
	0x0024d043, // n0x076a c0x0000 (---------------)  + I org
	0x002d35c3, // n0x076b c0x0000 (---------------)  + I pvt
	0x00200882, // n0x076c c0x0000 (---------------)  + I co
	0x00218643, // n0x076d c0x0000 (---------------)  + I net
	0x0024d043, // n0x076e c0x0000 (---------------)  + I org
	0x00232dc3, // n0x076f c0x0000 (---------------)  + I com
	0x0021e083, // n0x0770 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0771 c0x0000 (---------------)  + I gov
	0x00240443, // n0x0772 c0x0000 (---------------)  + I mil
	0x0024d043, // n0x0773 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x0774 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0775 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0776 c0x0000 (---------------)  + I gov
	0x00220e43, // n0x0777 c0x0000 (---------------)  + I ltd
	0x00226fc3, // n0x0778 c0x0000 (---------------)  + I mod
	0x0024d043, // n0x0779 c0x0000 (---------------)  + I org
	0x00200b82, // n0x077a c0x0000 (---------------)  + I ac
	0x00232dc3, // n0x077b c0x0000 (---------------)  + I com
	0x0021e083, // n0x077c c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x077d c0x0000 (---------------)  + I gov
	0x00218643, // n0x077e c0x0000 (---------------)  + I net
	0x0024d043, // n0x077f c0x0000 (---------------)  + I org
	0x00278344, // n0x0780 c0x0000 (---------------)  + I asso
	0x00232dc3, // n0x0781 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0782 c0x0000 (---------------)  + I edu
	0x00277f84, // n0x0783 c0x0000 (---------------)  + I mobi
	0x00218643, // n0x0784 c0x0000 (---------------)  + I net
	0x0024d043, // n0x0785 c0x0000 (---------------)  + I org
	0x0009e448, // n0x0786 c0x0000 (---------------)  +   blogspot
	0x00232dc3, // n0x0787 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0788 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0789 c0x0000 (---------------)  + I gov
	0x00218643, // n0x078a c0x0000 (---------------)  + I net
	0x0024d043, // n0x078b c0x0000 (---------------)  + I org
	0x00232dc3, // n0x078c c0x0000 (---------------)  + I com
	0x0021e083, // n0x078d c0x0000 (---------------)  + I edu
	0x003704c3, // n0x078e c0x0000 (---------------)  + I gob
	0x002202c3, // n0x078f c0x0000 (---------------)  + I ind
	0x00240443, // n0x0790 c0x0000 (---------------)  + I mil
	0x00218643, // n0x0791 c0x0000 (---------------)  + I net
	0x0024d043, // n0x0792 c0x0000 (---------------)  + I org
	0x00200882, // n0x0793 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x0794 c0x0000 (---------------)  + I com
	0x00218643, // n0x0795 c0x0000 (---------------)  + I net
	0x0009e448, // n0x0796 c0x0000 (---------------)  +   blogspot
	0x00232dc3, // n0x0797 c0x0000 (---------------)  + I com
	0x0021e083, // n0x0798 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x0799 c0x0000 (---------------)  + I gov
	0x00309c83, // n0x079a c0x0000 (---------------)  + I idv
	0x000746c3, // n0x079b c0x0000 (---------------)  +   inc
	0x00020e43, // n0x079c c0x0000 (---------------)  +   ltd
	0x00218643, // n0x079d c0x0000 (---------------)  + I net
	0x0024d043, // n0x079e c0x0000 (---------------)  + I org
	0x002f66ca, // n0x079f c0x0000 (---------------)  + I xn--55qx5d
	0x0030e909, // n0x07a0 c0x0000 (---------------)  + I xn--ciqpn
	0x0031fd0b, // n0x07a1 c0x0000 (---------------)  + I xn--gmq050i
	0x0032030a, // n0x07a2 c0x0000 (---------------)  + I xn--gmqw5a
	0x00326e4a, // n0x07a3 c0x0000 (---------------)  + I xn--io0a7i
	0x00333c4b, // n0x07a4 c0x0000 (---------------)  + I xn--lcvr32d
	0x0034048a, // n0x07a5 c0x0000 (---------------)  + I xn--mk0axi
	0x0034808a, // n0x07a6 c0x0000 (---------------)  + I xn--mxtq1m
	0x0034cf0a, // n0x07a7 c0x0000 (---------------)  + I xn--od0alg
	0x0034d18b, // n0x07a8 c0x0000 (---------------)  + I xn--od0aq3b
	0x00370f89, // n0x07a9 c0x0000 (---------------)  + I xn--tn0ag
	0x00372b4a, // n0x07aa c0x0000 (---------------)  + I xn--uc0atv
	0x0037300b, // n0x07ab c0x0000 (---------------)  + I xn--uc0ay4a
	0x0037c0cb, // n0x07ac c0x0000 (---------------)  + I xn--wcvs22d
	0x003844ca, // n0x07ad c0x0000 (---------------)  + I xn--zf0avx
	0x00232dc3, // n0x07ae c0x0000 (---------------)  + I com
	0x0021e083, // n0x07af c0x0000 (---------------)  + I edu
	0x003704c3, // n0x07b0 c0x0000 (---------------)  + I gob
	0x00240443, // n0x07b1 c0x0000 (---------------)  + I mil
	0x00218643, // n0x07b2 c0x0000 (---------------)  + I net
	0x0024d043, // n0x07b3 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x07b4 c0x0000 (---------------)  + I com
	0x0025c084, // n0x07b5 c0x0000 (---------------)  + I from
	0x002021c2, // n0x07b6 c0x0000 (---------------)  + I iz
	0x00267944, // n0x07b7 c0x0000 (---------------)  + I name
	0x002fb4c5, // n0x07b8 c0x0000 (---------------)  + I adult
	0x00208d43, // n0x07b9 c0x0000 (---------------)  + I art
	0x00278344, // n0x07ba c0x0000 (---------------)  + I asso
	0x00232dc3, // n0x07bb c0x0000 (---------------)  + I com
	0x0023a884, // n0x07bc c0x0000 (---------------)  + I coop
	0x0021e083, // n0x07bd c0x0000 (---------------)  + I edu
	0x0024a304, // n0x07be c0x0000 (---------------)  + I firm
	0x00252544, // n0x07bf c0x0000 (---------------)  + I gouv
	0x00208a44, // n0x07c0 c0x0000 (---------------)  + I info
	0x00210e83, // n0x07c1 c0x0000 (---------------)  + I med
	0x00218643, // n0x07c2 c0x0000 (---------------)  + I net
	0x0024d043, // n0x07c3 c0x0000 (---------------)  + I org
	0x002a80c5, // n0x07c4 c0x0000 (---------------)  + I perso
	0x002369c3, // n0x07c5 c0x0000 (---------------)  + I pol
	0x002cfc43, // n0x07c6 c0x0000 (---------------)  + I pro
	0x0027f043, // n0x07c7 c0x0000 (---------------)  + I rel
	0x0022e644, // n0x07c8 c0x0000 (---------------)  + I shop
	0x003678c4, // n0x07c9 c0x0000 (---------------)  + I 2000
	0x00263c05, // n0x07ca c0x0000 (---------------)  + I agrar
	0x0009e448, // n0x07cb c0x0000 (---------------)  +   blogspot
	0x002f0bc4, // n0x07cc c0x0000 (---------------)  + I bolt
	0x0023b546, // n0x07cd c0x0000 (---------------)  + I casino
	0x003242c4, // n0x07ce c0x0000 (---------------)  + I city
	0x00200882, // n0x07cf c0x0000 (---------------)  + I co
	0x00245947, // n0x07d0 c0x0000 (---------------)  + I erotica
	0x002a3cc7, // n0x07d1 c0x0000 (---------------)  + I erotika
	0x00247d84, // n0x07d2 c0x0000 (---------------)  + I film
	0x00255645, // n0x07d3 c0x0000 (---------------)  + I forum
	0x002e01c5, // n0x07d4 c0x0000 (---------------)  + I games
	0x0029d805, // n0x07d5 c0x0000 (---------------)  + I hotel
	0x00208a44, // n0x07d6 c0x0000 (---------------)  + I info
	0x002b6888, // n0x07d7 c0x0000 (---------------)  + I ingatlan
	0x003817c6, // n0x07d8 c0x0000 (---------------)  + I jogasz
	0x002c9f88, // n0x07d9 c0x0000 (---------------)  + I konyvelo
	0x002cc885, // n0x07da c0x0000 (---------------)  + I lakas
	0x0021e585, // n0x07db c0x0000 (---------------)  + I media
	0x00234584, // n0x07dc c0x0000 (---------------)  + I news
	0x0024d043, // n0x07dd c0x0000 (---------------)  + I org
	0x002cfac4, // n0x07de c0x0000 (---------------)  + I priv
	0x00332386, // n0x07df c0x0000 (---------------)  + I reklam
	0x0022ae43, // n0x07e0 c0x0000 (---------------)  + I sex
	0x0022e644, // n0x07e1 c0x0000 (---------------)  + I shop
	0x0028f2c5, // n0x07e2 c0x0000 (---------------)  + I sport
	0x00234404, // n0x07e3 c0x0000 (---------------)  + I suli
	0x00201304, // n0x07e4 c0x0000 (---------------)  + I szex
	0x002032c2, // n0x07e5 c0x0000 (---------------)  + I tm
	0x0025e606, // n0x07e6 c0x0000 (---------------)  + I tozsde
	0x0035c4c6, // n0x07e7 c0x0000 (---------------)  + I utazas
	0x002ebe05, // n0x07e8 c0x0000 (---------------)  + I video
	0x00200b82, // n0x07e9 c0x0000 (---------------)  + I ac
	0x00202183, // n0x07ea c0x0000 (---------------)  + I biz
	0x00200882, // n0x07eb c0x0000 (---------------)  + I co
	0x00238ec4, // n0x07ec c0x0000 (---------------)  + I desa
	0x00209ac2, // n0x07ed c0x0000 (---------------)  + I go
	0x00240443, // n0x07ee c0x0000 (---------------)  + I mil
	0x00224782, // n0x07ef c0x0000 (---------------)  + I my
	0x00218643, // n0x07f0 c0x0000 (---------------)  + I net
	0x00200d02, // n0x07f1 c0x0000 (---------------)  + I or
	0x00251983, // n0x07f2 c0x0000 (---------------)  + I sch
	0x002071c3, // n0x07f3 c0x0000 (---------------)  + I web
	0x0009e448, // n0x07f4 c0x0000 (---------------)  +   blogspot
	0x00209ac3, // n0x07f5 c0x0000 (---------------)  + I gov
	0x18e00882, // n0x07f6 c0x0063 (n0x07f7-n0x07f8)  o I co
	0x0009e448, // n0x07f7 c0x0000 (---------------)  +   blogspot
	0x00200b82, // n0x07f8 c0x0000 (---------------)  + I ac
	0x19600882, // n0x07f9 c0x0065 (n0x07ff-n0x0801)  + I co
	0x00232dc3, // n0x07fa c0x0000 (---------------)  + I com
	0x00218643, // n0x07fb c0x0000 (---------------)  + I net
	0x0024d043, // n0x07fc c0x0000 (---------------)  + I org
	0x0021cdc2, // n0x07fd c0x0000 (---------------)  + I tt
	0x0028dc82, // n0x07fe c0x0000 (---------------)  + I tv
	0x00220e43, // n0x07ff c0x0000 (---------------)  + I ltd
	0x002cb543, // n0x0800 c0x0000 (---------------)  + I plc
	0x00200b82, // n0x0801 c0x0000 (---------------)  + I ac
	0x0009e448, // n0x0802 c0x0000 (---------------)  +   blogspot
	0x00200882, // n0x0803 c0x0000 (---------------)  + I co
	0x0021e083, // n0x0804 c0x0000 (---------------)  + I edu
	0x0024a304, // n0x0805 c0x0000 (---------------)  + I firm
	0x0020a0c3, // n0x0806 c0x0000 (---------------)  + I gen
	0x00209ac3, // n0x0807 c0x0000 (---------------)  + I gov
	0x002202c3, // n0x0808 c0x0000 (---------------)  + I ind
	0x00240443, // n0x0809 c0x0000 (---------------)  + I mil
	0x00218643, // n0x080a c0x0000 (---------------)  + I net
	0x00219583, // n0x080b c0x0000 (---------------)  + I nic
	0x0024d043, // n0x080c c0x0000 (---------------)  + I org
	0x00207083, // n0x080d c0x0000 (---------------)  + I res
	0x00119193, // n0x080e c0x0000 (---------------)  +   barrel-of-knowledge
	0x00121ad4, // n0x080f c0x0000 (---------------)  +   barrell-of-knowledge
	0x0000dc06, // n0x0810 c0x0000 (---------------)  +   dyndns
	0x000512c7, // n0x0811 c0x0000 (---------------)  +   for-our
	0x0016d549, // n0x0812 c0x0000 (---------------)  +   groks-the
	0x0017980a, // n0x0813 c0x0000 (---------------)  +   groks-this
	0x0008124d, // n0x0814 c0x0000 (---------------)  +   here-for-more
	0x00051c0a, // n0x0815 c0x0000 (---------------)  +   knowsitall
	0x00141246, // n0x0816 c0x0000 (---------------)  +   selfip
	0x0002c186, // n0x0817 c0x0000 (---------------)  +   webhop
	0x0021b882, // n0x0818 c0x0000 (---------------)  + I eu
	0x00232dc3, // n0x0819 c0x0000 (---------------)  + I com
	0x000bb186, // n0x081a c0x0000 (---------------)  +   github
	0x000926c3, // n0x081b c0x0000 (---------------)  +   nid
	0x00232dc3, // n0x081c c0x0000 (---------------)  + I com
	0x0021e083, // n0x081d c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x081e c0x0000 (---------------)  + I gov
	0x00240443, // n0x081f c0x0000 (---------------)  + I mil
	0x00218643, // n0x0820 c0x0000 (---------------)  + I net
	0x0024d043, // n0x0821 c0x0000 (---------------)  + I org
	0x00200b82, // n0x0822 c0x0000 (---------------)  + I ac
	0x00200882, // n0x0823 c0x0000 (---------------)  + I co
	0x00209ac3, // n0x0824 c0x0000 (---------------)  + I gov
	0x00205942, // n0x0825 c0x0000 (---------------)  + I id
	0x00218643, // n0x0826 c0x0000 (---------------)  + I net
	0x0024d043, // n0x0827 c0x0000 (---------------)  + I org
	0x00251983, // n0x0828 c0x0000 (---------------)  + I sch
	0x0033b00f, // n0x0829 c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0033b3ce, // n0x082a c0x0000 (---------------)  + I xn--mgba3a4fra
	0x00232dc3, // n0x082b c0x0000 (---------------)  + I com
	0x00045147, // n0x082c c0x0000 (---------------)  +   cupcake
	0x0021e083, // n0x082d c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x082e c0x0000 (---------------)  + I gov
	0x002188c3, // n0x082f c0x0000 (---------------)  + I int
	0x00218643, // n0x0830 c0x0000 (---------------)  + I net
	0x0024d043, // n0x0831 c0x0000 (---------------)  + I org
	0x0021e683, // n0x0832 c0x0000 (---------------)  + I abr
	0x00377c07, // n0x0833 c0x0000 (---------------)  + I abruzzo
	0x00202602, // n0x0834 c0x0000 (---------------)  + I ag
	0x00307909, // n0x0835 c0x0000 (---------------)  + I agrigento
	0x00200b02, // n0x0836 c0x0000 (---------------)  + I al
	0x0025fccb, // n0x0837 c0x0000 (---------------)  + I alessandria
	0x0029fdca, // n0x0838 c0x0000 (---------------)  + I alto-adige
	0x002c8409, // n0x0839 c0x0000 (---------------)  + I altoadige
	0x00202342, // n0x083a c0x0000 (---------------)  + I an
	0x002375c6, // n0x083b c0x0000 (---------------)  + I ancona
	0x0027b6d5, // n0x083c c0x0000 (---------------)  + I andria-barletta-trani
	0x0025fe15, // n0x083d c0x0000 (---------------)  + I andria-trani-barletta
	0x0027d413, // n0x083e c0x0000 (---------------)  + I andriabarlettatrani
	0x00260393, // n0x083f c0x0000 (---------------)  + I andriatranibarletta
	0x00207702, // n0x0840 c0x0000 (---------------)  + I ao
	0x00209245, // n0x0841 c0x0000 (---------------)  + I aosta
	0x00382fcc, // n0x0842 c0x0000 (---------------)  + I aosta-valley
	0x002a5b0b, // n0x0843 c0x0000 (---------------)  + I aostavalley
	0x00255445, // n0x0844 c0x0000 (---------------)  + I aoste
	0x00200a42, // n0x0845 c0x0000 (---------------)  + I ap
	0x0023be02, // n0x0846 c0x0000 (---------------)  + I aq
	0x002c0f06, // n0x0847 c0x0000 (---------------)  + I aquila
	0x002030c2, // n0x0848 c0x0000 (---------------)  + I ar
	0x003650c6, // n0x0849 c0x0000 (---------------)  + I arezzo
	0x0035940d, // n0x084a c0x0000 (---------------)  + I ascoli-piceno
	0x002c7c0c, // n0x084b c0x0000 (---------------)  + I ascolipiceno
	0x0023d544, // n0x084c c0x0000 (---------------)  + I asti
	0x00201702, // n0x084d c0x0000 (---------------)  + I at
	0x00201602, // n0x084e c0x0000 (---------------)  + I av
	0x00290208, // n0x084f c0x0000 (---------------)  + I avellino
	0x002076c2, // n0x0850 c0x0000 (---------------)  + I ba
	0x0024f906, // n0x0851 c0x0000 (---------------)  + I balsan
	0x00288e84, // n0x0852 c0x0000 (---------------)  + I bari
	0x0027b895, // n0x0853 c0x0000 (---------------)  + I barletta-trani-andria
	0x0027d593, // n0x0854 c0x0000 (---------------)  + I barlettatraniandria
	0x00212c83, // n0x0855 c0x0000 (---------------)  + I bas
	0x00343aca, // n0x0856 c0x0000 (---------------)  + I basilicata
	0x00215a47, // n0x0857 c0x0000 (---------------)  + I belluno
	0x00344ec9, // n0x0858 c0x0000 (---------------)  + I benevento
	0x003498c7, // n0x0859 c0x0000 (---------------)  + I bergamo
	0x00340002, // n0x085a c0x0000 (---------------)  + I bg
	0x00200002, // n0x085b c0x0000 (---------------)  + I bi
	0x00201c46, // n0x085c c0x0000 (---------------)  + I biella
	0x0020cb02, // n0x085d c0x0000 (---------------)  + I bl
	0x0009e448, // n0x085e c0x0000 (---------------)  +   blogspot
	0x00212ac2, // n0x085f c0x0000 (---------------)  + I bn
	0x00210042, // n0x0860 c0x0000 (---------------)  + I bo
	0x003758c7, // n0x0861 c0x0000 (---------------)  + I bologna
	0x00213b87, // n0x0862 c0x0000 (---------------)  + I bolzano
	0x0021b5c5, // n0x0863 c0x0000 (---------------)  + I bozen
	0x00207bc2, // n0x0864 c0x0000 (---------------)  + I br
	0x00220087, // n0x0865 c0x0000 (---------------)  + I brescia
	0x00220248, // n0x0866 c0x0000 (---------------)  + I brindisi
	0x00207242, // n0x0867 c0x0000 (---------------)  + I bs
	0x0023ad82, // n0x0868 c0x0000 (---------------)  + I bt
	0x0022eac2, // n0x0869 c0x0000 (---------------)  + I bz
	0x00214582, // n0x086a c0x0000 (---------------)  + I ca
	0x0036e048, // n0x086b c0x0000 (---------------)  + I cagliari
	0x00219603, // n0x086c c0x0000 (---------------)  + I cal
	0x0021fc48, // n0x086d c0x0000 (---------------)  + I calabria
	0x00384b4d, // n0x086e c0x0000 (---------------)  + I caltanissetta
	0x00216403, // n0x086f c0x0000 (---------------)  + I cam
	0x00309848, // n0x0870 c0x0000 (---------------)  + I campania
	0x0023e18f, // n0x0871 c0x0000 (---------------)  + I campidano-medio
	0x0023e54e, // n0x0872 c0x0000 (---------------)  + I campidanomedio
	0x002781ca, // n0x0873 c0x0000 (---------------)  + I campobasso
	0x002eeed1, // n0x0874 c0x0000 (---------------)  + I carbonia-iglesias
	0x002ef350, // n0x0875 c0x0000 (---------------)  + I carboniaiglesias
	0x002bf88d, // n0x0876 c0x0000 (---------------)  + I carrara-massa
	0x002bfbcc, // n0x0877 c0x0000 (---------------)  + I carraramassa
	0x00233987, // n0x0878 c0x0000 (---------------)  + I caserta
	0x00343c47, // n0x0879 c0x0000 (---------------)  + I catania
	0x0035f909, // n0x087a c0x0000 (---------------)  + I catanzaro
	0x0023d642, // n0x087b c0x0000 (---------------)  + I cb
	0x00200bc2, // n0x087c c0x0000 (---------------)  + I ce
	0x0025318c, // n0x087d c0x0000 (---------------)  + I cesena-forli
	0x0025348b, // n0x087e c0x0000 (---------------)  + I cesenaforli
	0x00202ac2, // n0x087f c0x0000 (---------------)  + I ch
	0x002a7346, // n0x0880 c0x0000 (---------------)  + I chieti
	0x00220182, // n0x0881 c0x0000 (---------------)  + I ci
	0x00200402, // n0x0882 c0x0000 (---------------)  + I cl
	0x0022fe42, // n0x0883 c0x0000 (---------------)  + I cn
	0x00200882, // n0x0884 c0x0000 (---------------)  + I co
	0x00233284, // n0x0885 c0x0000 (---------------)  + I como
	0x0023cf87, // n0x0886 c0x0000 (---------------)  + I cosenza
	0x0020b542, // n0x0887 c0x0000 (---------------)  + I cr
	0x0023fe07, // n0x0888 c0x0000 (---------------)  + I cremona
	0x00242347, // n0x0889 c0x0000 (---------------)  + I crotone
	0x0021a142, // n0x088a c0x0000 (---------------)  + I cs
	0x0022a082, // n0x088b c0x0000 (---------------)  + I ct
	0x00245005, // n0x088c c0x0000 (---------------)  + I cuneo
	0x00202882, // n0x088d c0x0000 (---------------)  + I cz
	0x00231b4e, // n0x088e c0x0000 (---------------)  + I dell-ogliastra
	0x00242dcd, // n0x088f c0x0000 (---------------)  + I dellogliastra
	0x0021e083, // n0x0890 c0x0000 (---------------)  + I edu
	0x002416ce, // n0x0891 c0x0000 (---------------)  + I emilia-romagna
	0x0026a94d, // n0x0892 c0x0000 (---------------)  + I emiliaromagna
	0x002141c3, // n0x0893 c0x0000 (---------------)  + I emr
	0x00202242, // n0x0894 c0x0000 (---------------)  + I en
	0x00276004, // n0x0895 c0x0000 (---------------)  + I enna
	0x0033a302, // n0x0896 c0x0000 (---------------)  + I fc
	0x00223342, // n0x0897 c0x0000 (---------------)  + I fe
	0x00353ac5, // n0x0898 c0x0000 (---------------)  + I fermo
	0x00245687, // n0x0899 c0x0000 (---------------)  + I ferrara
	0x002460c2, // n0x089a c0x0000 (---------------)  + I fg
	0x00206f02, // n0x089b c0x0000 (---------------)  + I fi
	0x00249907, // n0x089c c0x0000 (---------------)  + I firenze
	0x0024de08, // n0x089d c0x0000 (---------------)  + I florence
	0x00257f82, // n0x089e c0x0000 (---------------)  + I fm
	0x00208ac6, // n0x089f c0x0000 (---------------)  + I foggia
	0x0025300c, // n0x08a0 c0x0000 (---------------)  + I forli-cesena
	0x0025334b, // n0x08a1 c0x0000 (---------------)  + I forlicesena
	0x0022fc02, // n0x08a2 c0x0000 (---------------)  + I fr
	0x0025890f, // n0x08a3 c0x0000 (---------------)  + I friuli-v-giulia
	0x00258cd0, // n0x08a4 c0x0000 (---------------)  + I friuli-ve-giulia
	0x002590cf, // n0x08a5 c0x0000 (---------------)  + I friuli-vegiulia
	0x00259495, // n0x08a6 c0x0000 (---------------)  + I friuli-venezia-giulia
	0x002599d4, // n0x08a7 c0x0000 (---------------)  + I friuli-veneziagiulia
	0x00259ece, // n0x08a8 c0x0000 (---------------)  + I friuli-vgiulia
	0x0025a24e, // n0x08a9 c0x0000 (---------------)  + I friuliv-giulia
	0x0025a5cf, // n0x08aa c0x0000 (---------------)  + I friulive-giulia
	0x0025a98e, // n0x08ab c0x0000 (---------------)  + I friulivegiulia
	0x0025ad14, // n0x08ac c0x0000 (---------------)  + I friulivenezia-giulia
	0x0025b213, // n0x08ad c0x0000 (---------------)  + I friuliveneziagiulia
	0x0025b6cd, // n0x08ae c0x0000 (---------------)  + I friulivgiulia
	0x0026e909, // n0x08af c0x0000 (---------------)  + I frosinone
	0x002820c3, // n0x08b0 c0x0000 (---------------)  + I fvg
	0x002029c2, // n0x08b1 c0x0000 (---------------)  + I ge
	0x00285ac5, // n0x08b2 c0x0000 (---------------)  + I genoa
	0x0020a0c6, // n0x08b3 c0x0000 (---------------)  + I genova
	0x00209ac2, // n0x08b4 c0x0000 (---------------)  + I go
	0x00258747, // n0x08b5 c0x0000 (---------------)  + I gorizia
	0x00209ac3, // n0x08b6 c0x0000 (---------------)  + I gov
	0x00206b02, // n0x08b7 c0x0000 (---------------)  + I gr
	0x00231748, // n0x08b8 c0x0000 (---------------)  + I grosseto
	0x002ef111, // n0x08b9 c0x0000 (---------------)  + I iglesias-carbonia
	0x002ef550, // n0x08ba c0x0000 (---------------)  + I iglesiascarbonia
	0x002051c2, // n0x08bb c0x0000 (---------------)  + I im
	0x0020c707, // n0x08bc c0x0000 (---------------)  + I imperia
	0x002066c2, // n0x08bd c0x0000 (---------------)  + I is
	0x002558c7, // n0x08be c0x0000 (---------------)  + I isernia
	0x0020c642, // n0x08bf c0x0000 (---------------)  + I kr
	0x00365c49, // n0x08c0 c0x0000 (---------------)  + I la-spezia
	0x002c0ec7, // n0x08c1 c0x0000 (---------------)  + I laquila
	0x0034cd08, // n0x08c2 c0x0000 (---------------)  + I laspezia
	0x0020b0c6, // n0x08c3 c0x0000 (---------------)  + I latina
	0x002cb443, // n0x08c4 c0x0000 (---------------)  + I laz
	0x00341c05, // n0x08c5 c0x0000 (---------------)  + I lazio
	0x0021e302, // n0x08c6 c0x0000 (---------------)  + I lc
	0x00202042, // n0x08c7 c0x0000 (---------------)  + I le
	0x00202045, // n0x08c8 c0x0000 (---------------)  + I lecce
	0x0022dd05, // n0x08c9 c0x0000 (---------------)  + I lecco
	0x00206682, // n0x08ca c0x0000 (---------------)  + I li
	0x00216903, // n0x08cb c0x0000 (---------------)  + I lig
	0x002536c7, // n0x08cc c0x0000 (---------------)  + I liguria
	0x00376a87, // n0x08cd c0x0000 (---------------)  + I livorno
	0x00200782, // n0x08ce c0x0000 (---------------)  + I lo
	0x002ca104, // n0x08cf c0x0000 (---------------)  + I lodi
	0x00210a03, // n0x08d0 c0x0000 (---------------)  + I lom
	0x002b5a09, // n0x08d1 c0x0000 (---------------)  + I lombardia
	0x00210a08, // n0x08d2 c0x0000 (---------------)  + I lombardy
	0x0021a082, // n0x08d3 c0x0000 (---------------)  + I lt
	0x00208042, // n0x08d4 c0x0000 (---------------)  + I lu
	0x0022c3c7, // n0x08d5 c0x0000 (---------------)  + I lucania
	0x0023b945, // n0x08d6 c0x0000 (---------------)  + I lucca
	0x00309348, // n0x08d7 c0x0000 (---------------)  + I macerata
	0x00225c87, // n0x08d8 c0x0000 (---------------)  + I mantova
	0x00204483, // n0x08d9 c0x0000 (---------------)  + I mar
	0x0024c886, // n0x08da c0x0000 (---------------)  + I marche
	0x002bf70d, // n0x08db c0x0000 (---------------)  + I massa-carrara
	0x002bfa8c, // n0x08dc c0x0000 (---------------)  + I massacarrara
	0x002b8d46, // n0x08dd c0x0000 (---------------)  + I matera
	0x00207b82, // n0x08de c0x0000 (---------------)  + I mb
	0x0020f0c2, // n0x08df c0x0000 (---------------)  + I mc
	0x00204342, // n0x08e0 c0x0000 (---------------)  + I me
	0x0023e00f, // n0x08e1 c0x0000 (---------------)  + I medio-campidano
	0x0023e40e, // n0x08e2 c0x0000 (---------------)  + I mediocampidano
	0x00299947, // n0x08e3 c0x0000 (---------------)  + I messina
	0x00200f42, // n0x08e4 c0x0000 (---------------)  + I mi
	0x00331245, // n0x08e5 c0x0000 (---------------)  + I milan
	0x00331246, // n0x08e6 c0x0000 (---------------)  + I milano
	0x0022c7c2, // n0x08e7 c0x0000 (---------------)  + I mn
	0x00205202, // n0x08e8 c0x0000 (---------------)  + I mo
	0x00282b86, // n0x08e9 c0x0000 (---------------)  + I modena
	0x002b3e43, // n0x08ea c0x0000 (---------------)  + I mol
	0x002b8ec6, // n0x08eb c0x0000 (---------------)  + I molise
	0x002b70c5, // n0x08ec c0x0000 (---------------)  + I monza
	0x002b70cd, // n0x08ed c0x0000 (---------------)  + I monza-brianza
	0x002b7695, // n0x08ee c0x0000 (---------------)  + I monza-e-della-brianza
	0x002b7c4c, // n0x08ef c0x0000 (---------------)  + I monzabrianza
	0x002b7f4d, // n0x08f0 c0x0000 (---------------)  + I monzaebrianza
	0x002b8292, // n0x08f1 c0x0000 (---------------)  + I monzaedellabrianza
	0x0020e602, // n0x08f2 c0x0000 (---------------)  + I ms
	0x00266782, // n0x08f3 c0x0000 (---------------)  + I mt
	0x002015c2, // n0x08f4 c0x0000 (---------------)  + I na
	0x0026d5c6, // n0x08f5 c0x0000 (---------------)  + I naples
	0x002e26c6, // n0x08f6 c0x0000 (---------------)  + I napoli
	0x00200cc2, // n0x08f7 c0x0000 (---------------)  + I no
	0x0020a146, // n0x08f8 c0x0000 (---------------)  + I novara
	0x0020fd82, // n0x08f9 c0x0000 (---------------)  + I nu
	0x0037bbc5, // n0x08fa c0x0000 (---------------)  + I nuoro
	0x00204f42, // n0x08fb c0x0000 (---------------)  + I og
	0x00231c89, // n0x08fc c0x0000 (---------------)  + I ogliastra
	0x00239f4c, // n0x08fd c0x0000 (---------------)  + I olbia-tempio
	0x0023a28b, // n0x08fe c0x0000 (---------------)  + I olbiatempio
	0x00200d02, // n0x08ff c0x0000 (---------------)  + I or
	0x0024e248, // n0x0900 c0x0000 (---------------)  + I oristano
	0x00201902, // n0x0901 c0x0000 (---------------)  + I ot
	0x00200ac2, // n0x0902 c0x0000 (---------------)  + I pa
	0x00209006, // n0x0903 c0x0000 (---------------)  + I padova
	0x0033c945, // n0x0904 c0x0000 (---------------)  + I padua
	0x0022b647, // n0x0905 c0x0000 (---------------)  + I palermo
	0x00279585, // n0x0906 c0x0000 (---------------)  + I parma
	0x002c5485, // n0x0907 c0x0000 (---------------)  + I pavia
	0x0021c6c2, // n0x0908 c0x0000 (---------------)  + I pc
	0x0022c302, // n0x0909 c0x0000 (---------------)  + I pd
	0x0020c782, // n0x090a c0x0000 (---------------)  + I pe
	0x00277607, // n0x090b c0x0000 (---------------)  + I perugia
	0x0022a24d, // n0x090c c0x0000 (---------------)  + I pesaro-urbino
	0x0022a5cc, // n0x090d c0x0000 (---------------)  + I pesarourbino
	0x0022f787, // n0x090e c0x0000 (---------------)  + I pescara
	0x002a6f42, // n0x090f c0x0000 (---------------)  + I pg
	0x00218302, // n0x0910 c0x0000 (---------------)  + I pi
	0x00243808, // n0x0911 c0x0000 (---------------)  + I piacenza
	0x00222448, // n0x0912 c0x0000 (---------------)  + I piedmont
	0x002c8c08, // n0x0913 c0x0000 (---------------)  + I piemonte
	0x0027cf84, // n0x0914 c0x0000 (---------------)  + I pisa
	0x002a9447, // n0x0915 c0x0000 (---------------)  + I pistoia
	0x002cc583, // n0x0916 c0x0000 (---------------)  + I pmn
	0x002a2b42, // n0x0917 c0x0000 (---------------)  + I pn
	0x002167c2, // n0x0918 c0x0000 (---------------)  + I po
	0x002cdd09, // n0x0919 c0x0000 (---------------)  + I pordenone
	0x00249287, // n0x091a c0x0000 (---------------)  + I potenza
	0x0022ad42, // n0x091b c0x0000 (---------------)  + I pr
	0x00337145, // n0x091c c0x0000 (---------------)  + I prato
	0x0029ab02, // n0x091d c0x0000 (---------------)  + I pt
	0x00234882, // n0x091e c0x0000 (---------------)  + I pu
	0x00268e03, // n0x091f c0x0000 (---------------)  + I pug
	0x00268e06, // n0x0920 c0x0000 (---------------)  + I puglia
	0x002d35c2, // n0x0921 c0x0000 (---------------)  + I pv
	0x002d39c2, // n0x0922 c0x0000 (---------------)  + I pz
	0x00201082, // n0x0923 c0x0000 (---------------)  + I ra
	0x00378446, // n0x0924 c0x0000 (---------------)  + I ragusa
	0x00275f47, // n0x0925 c0x0000 (---------------)  + I ravenna
	0x00229f02, // n0x0926 c0x0000 (---------------)  + I rc
	0x00207082, // n0x0927 c0x0000 (---------------)  + I re
	0x00230ecf, // n0x0928 c0x0000 (---------------)  + I reggio-calabria
	0x0024150d, // n0x0929 c0x0000 (---------------)  + I reggio-emilia
	0x0021face, // n0x092a c0x0000 (---------------)  + I reggiocalabria
	0x0026a7cc, // n0x092b c0x0000 (---------------)  + I reggioemilia
	0x00204042, // n0x092c c0x0000 (---------------)  + I rg
	0x00200d42, // n0x092d c0x0000 (---------------)  + I ri
	0x00229385, // n0x092e c0x0000 (---------------)  + I rieti
	0x003860c6, // n0x092f c0x0000 (---------------)  + I rimini
	0x00212642, // n0x0930 c0x0000 (---------------)  + I rm
	0x002065c2, // n0x0931 c0x0000 (---------------)  + I rn
	0x00200982, // n0x0932 c0x0000 (---------------)  + I ro
	0x00225c04, // n0x0933 c0x0000 (---------------)  + I roma
	0x002e1ac4, // n0x0934 c0x0000 (---------------)  + I rome
	0x002e4b86, // n0x0935 c0x0000 (---------------)  + I rovigo
	0x00203a82, // n0x0936 c0x0000 (---------------)  + I sa
	0x0027e2c7, // n0x0937 c0x0000 (---------------)  + I salerno
	0x0022a2c3, // n0x0938 c0x0000 (---------------)  + I sar
	0x00248748, // n0x0939 c0x0000 (---------------)  + I sardegna
	0x0024a108, // n0x093a c0x0000 (---------------)  + I sardinia
	0x00252c07, // n0x093b c0x0000 (---------------)  + I sassari
	0x00262306, // n0x093c c0x0000 (---------------)  + I savona
	0x002058c2, // n0x093d c0x0000 (---------------)  + I si
	0x002203c3, // n0x093e c0x0000 (---------------)  + I sic
	0x002203c7, // n0x093f c0x0000 (---------------)  + I sicilia
	0x002636c6, // n0x0940 c0x0000 (---------------)  + I sicily
	0x00285245, // n0x0941 c0x0000 (---------------)  + I siena
	0x002d0688, // n0x0942 c0x0000 (---------------)  + I siracusa
	0x00209f02, // n0x0943 c0x0000 (---------------)  + I so
	0x002ee7c7, // n0x0944 c0x0000 (---------------)  + I sondrio
	0x0022e802, // n0x0945 c0x0000 (---------------)  + I sp
	0x002dc282, // n0x0946 c0x0000 (---------------)  + I sr
	0x00203a42, // n0x0947 c0x0000 (---------------)  + I ss
	0x002b2989, // n0x0948 c0x0000 (---------------)  + I suedtirol
	0x00201e82, // n0x0949 c0x0000 (---------------)  + I sv
	0x00202542, // n0x094a c0x0000 (---------------)  + I ta
	0x0022fa03, // n0x094b c0x0000 (---------------)  + I taa
	0x00344c87, // n0x094c c0x0000 (---------------)  + I taranto
	0x00207302, // n0x094d c0x0000 (---------------)  + I te
	0x0023a0cc, // n0x094e c0x0000 (---------------)  + I tempio-olbia
	0x0023a3cb, // n0x094f c0x0000 (---------------)  + I tempioolbia
	0x002b8dc6, // n0x0950 c0x0000 (---------------)  + I teramo
	0x002d8e05, // n0x0951 c0x0000 (---------------)  + I terni
	0x00201942, // n0x0952 c0x0000 (---------------)  + I tn
	0x00200302, // n0x0953 c0x0000 (---------------)  + I to
	0x002a6206, // n0x0954 c0x0000 (---------------)  + I torino
	0x00223503, // n0x0955 c0x0000 (---------------)  + I tos
	0x00343e47, // n0x0956 c0x0000 (---------------)  + I toscana
	0x0020df02, // n0x0957 c0x0000 (---------------)  + I tp
	0x00200942, // n0x0958 c0x0000 (---------------)  + I tr
	0x0027b555, // n0x0959 c0x0000 (---------------)  + I trani-andria-barletta
	0x0025ffd5, // n0x095a c0x0000 (---------------)  + I trani-barletta-andria
	0x0027d2d3, // n0x095b c0x0000 (---------------)  + I traniandriabarletta
	0x00260513, // n0x095c c0x0000 (---------------)  + I tranibarlettaandria
	0x0028f3c7, // n0x095d c0x0000 (---------------)  + I trapani
	0x0029e608, // n0x095e c0x0000 (---------------)  + I trentino
	0x0029e610, // n0x095f c0x0000 (---------------)  + I trentino-a-adige
	0x0029f0cf, // n0x0960 c0x0000 (---------------)  + I trentino-aadige
	0x0029fb93, // n0x0961 c0x0000 (---------------)  + I trentino-alto-adige
	0x002e3492, // n0x0962 c0x0000 (---------------)  + I trentino-altoadige
	0x003074d0, // n0x0963 c0x0000 (---------------)  + I trentino-s-tirol
	0x0032bf8f, // n0x0964 c0x0000 (---------------)  + I trentino-stirol
	0x0032fdd2, // n0x0965 c0x0000 (---------------)  + I trentino-sud-tirol
	0x002a13d1, // n0x0966 c0x0000 (---------------)  + I trentino-sudtirol
	0x002aa113, // n0x0967 c0x0000 (---------------)  + I trentino-sued-tirol
	0x002b2752, // n0x0968 c0x0000 (---------------)  + I trentino-suedtirol
	0x002bb58f, // n0x0969 c0x0000 (---------------)  + I trentinoa-adige
	0x002c17ce, // n0x096a c0x0000 (---------------)  + I trentinoaadige
	0x002c2592, // n0x096b c0x0000 (---------------)  + I trentinoalto-adige
	0x002c8211, // n0x096c c0x0000 (---------------)  + I trentinoaltoadige
	0x002d114f, // n0x096d c0x0000 (---------------)  + I trentinos-tirol
	0x002d364e, // n0x096e c0x0000 (---------------)  + I trentinostirol
	0x0031b2d1, // n0x096f c0x0000 (---------------)  + I trentinosud-tirol
	0x002d5750, // n0x0970 c0x0000 (---------------)  + I trentinosudtirol
	0x002de012, // n0x0971 c0x0000 (---------------)  + I trentinosued-tirol
	0x002e1151, // n0x0972 c0x0000 (---------------)  + I trentinosuedtirol
	0x002f10c6, // n0x0973 c0x0000 (---------------)  + I trento
	0x0037a787, // n0x0974 c0x0000 (---------------)  + I treviso
	0x00383747, // n0x0975 c0x0000 (---------------)  + I trieste
	0x00201a82, // n0x0976 c0x0000 (---------------)  + I ts
	0x002b4e85, // n0x0977 c0x0000 (---------------)  + I turin
	0x002e4e47, // n0x0978 c0x0000 (---------------)  + I tuscany
	0x0028dc82, // n0x0979 c0x0000 (---------------)  + I tv
	0x00200802, // n0x097a c0x0000 (---------------)  + I ud
	0x002c0045, // n0x097b c0x0000 (---------------)  + I udine
	0x00221483, // n0x097c c0x0000 (---------------)  + I umb
	0x00263e86, // n0x097d c0x0000 (---------------)  + I umbria
	0x0022a40d, // n0x097e c0x0000 (---------------)  + I urbino-pesaro
	0x0022a74c, // n0x097f c0x0000 (---------------)  + I urbinopesaro
	0x00203242, // n0x0980 c0x0000 (---------------)  + I va
	0x00382e4b, // n0x0981 c0x0000 (---------------)  + I val-d-aosta
	0x002a59ca, // n0x0982 c0x0000 (---------------)  + I val-daosta
	0x0020910a, // n0x0983 c0x0000 (---------------)  + I vald-aosta
	0x00225dc9, // n0x0984 c0x0000 (---------------)  + I valdaosta
	0x002cd68b, // n0x0985 c0x0000 (---------------)  + I valle-aosta
	0x002e578d, // n0x0986 c0x0000 (---------------)  + I valle-d-aosta
	0x0036618c, // n0x0987 c0x0000 (---------------)  + I valle-daosta
	0x0023da0a, // n0x0988 c0x0000 (---------------)  + I valleaosta
	0x0024078c, // n0x0989 c0x0000 (---------------)  + I valled-aosta
	0x0024640b, // n0x098a c0x0000 (---------------)  + I valledaosta
	0x0025528c, // n0x098b c0x0000 (---------------)  + I vallee-aoste
	0x0026730b, // n0x098c c0x0000 (---------------)  + I valleeaoste
	0x0026e083, // n0x098d c0x0000 (---------------)  + I vao
	0x002dc306, // n0x098e c0x0000 (---------------)  + I varese
	0x002e5f42, // n0x098f c0x0000 (---------------)  + I vb
	0x002e6442, // n0x0990 c0x0000 (---------------)  + I vc
	0x0023b883, // n0x0991 c0x0000 (---------------)  + I vda
	0x00203f02, // n0x0992 c0x0000 (---------------)  + I ve
	0x00203f03, // n0x0993 c0x0000 (---------------)  + I ven
	0x002185c6, // n0x0994 c0x0000 (---------------)  + I veneto
	0x00259647, // n0x0995 c0x0000 (---------------)  + I venezia
	0x00268586, // n0x0996 c0x0000 (---------------)  + I venice
	0x00227e88, // n0x0997 c0x0000 (---------------)  + I verbania
	0x0028eb08, // n0x0998 c0x0000 (---------------)  + I vercelli
	0x002e7686, // n0x0999 c0x0000 (---------------)  + I verona
	0x00201642, // n0x099a c0x0000 (---------------)  + I vi
	0x002eb7cd, // n0x099b c0x0000 (---------------)  + I vibo-valentia
	0x002ebb0c, // n0x099c c0x0000 (---------------)  + I vibovalentia
	0x00252607, // n0x099d c0x0000 (---------------)  + I vicenza
	0x002f0a87, // n0x099e c0x0000 (---------------)  + I viterbo
	0x00226342, // n0x099f c0x0000 (---------------)  + I vr
	0x0023ccc2, // n0x09a0 c0x0000 (---------------)  + I vs
	0x002170c2, // n0x09a1 c0x0000 (---------------)  + I vt
	0x00203ec2, // n0x09a2 c0x0000 (---------------)  + I vv
	0x00200882, // n0x09a3 c0x0000 (---------------)  + I co
	0x00218643, // n0x09a4 c0x0000 (---------------)  + I net
	0x0024d043, // n0x09a5 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x09a6 c0x0000 (---------------)  + I com
	0x0021e083, // n0x09a7 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x09a8 c0x0000 (---------------)  + I gov
	0x00240443, // n0x09a9 c0x0000 (---------------)  + I mil
	0x00267944, // n0x09aa c0x0000 (---------------)  + I name
	0x00218643, // n0x09ab c0x0000 (---------------)  + I net
	0x0024d043, // n0x09ac c0x0000 (---------------)  + I org
	0x00251983, // n0x09ad c0x0000 (---------------)  + I sch
	0x00200b82, // n0x09ae c0x0000 (---------------)  + I ac
	0x00202902, // n0x09af c0x0000 (---------------)  + I ad
	0x1c665d85, // n0x09b0 c0x0071 (n0x0a1d-n0x0a51)  + I aichi
	0x1ca12185, // n0x09b1 c0x0072 (n0x0a51-n0x0a6d)  + I akita
	0x1ce6e0c6, // n0x09b2 c0x0073 (n0x0a6d-n0x0a83)  + I aomori
	0x0009e448, // n0x09b3 c0x0000 (---------------)  +   blogspot
	0x1d2a6985, // n0x09b4 c0x0074 (n0x0a83-n0x0abd)  + I chiba
	0x00200882, // n0x09b5 c0x0000 (---------------)  + I co
	0x00205742, // n0x09b6 c0x0000 (---------------)  + I ed
	0x1d606d05, // n0x09b7 c0x0075 (n0x0abd-n0x0ad3)  + I ehime
	0x1da77205, // n0x09b8 c0x0076 (n0x0ad3-n0x0ae2)  + I fukui
	0x1de77a87, // n0x09b9 c0x0077 (n0x0ae2-n0x0b21)  + I fukuoka
	0x1e279049, // n0x09ba c0x0078 (n0x0b21-n0x0b54)  + I fukushima
	0x1e669a44, // n0x09bb c0x0079 (n0x0b54-n0x0b7a)  + I gifu
	0x00209ac2, // n0x09bc c0x0000 (---------------)  + I go
	0x00206b02, // n0x09bd c0x0000 (---------------)  + I gr
	0x1ea4c7c5, // n0x09be c0x007a (n0x0b7a-n0x0b9e)  + I gunma
	0x1ee8aa89, // n0x09bf c0x007b (n0x0b9e-n0x0bb7)  + I hiroshima
	0x1f20d548, // n0x09c0 c0x007c (n0x0bb7-n0x0c45)  + I hokkaido
	0x1f6a0045, // n0x09c1 c0x007d (n0x0c45-n0x0c73)  + I hyogo
	0x1fb16ec7, // n0x09c2 c0x007e (n0x0c73-n0x0ca6)  + I ibaraki
	0x1fe1a288, // n0x09c3 c0x007f (n0x0ca6-n0x0cb9)  + I ishikawa
	0x2034f5c5, // n0x09c4 c0x0080 (n0x0cb9-n0x0cdb)  + I iwate
	0x206038c6, // n0x09c5 c0x0081 (n0x0cdb-n0x0cea)  + I kagawa
	0x20b60c89, // n0x09c6 c0x0082 (n0x0cea-n0x0cfe)  + I kagoshima
	0x20ecc148, // n0x09c7 c0x0083 (n0x0cfe-n0x0d1c)  + I kanagawa
	0x212ac548, // n0x09c8 c0x0084 (n0x0d1c-n0x0d1d)* o I kawasaki
	0x2168b0ca, // n0x09c9 c0x0085 (n0x0d1d-n0x0d1e)* o I kitakyushu
	0x21a6f144, // n0x09ca c0x0086 (n0x0d1e-n0x0d1f)* o I kobe
	0x21ebecc5, // n0x09cb c0x0087 (n0x0d1f-n0x0d3e)  + I kochi
	0x222bf488, // n0x09cc c0x0088 (n0x0d3e-n0x0d58)  + I kumamoto
	0x22662fc5, // n0x09cd c0x0089 (n0x0d58-n0x0d77)  + I kyoto
	0x00219682, // n0x09ce c0x0000 (---------------)  + I lg
	0x22a01f83, // n0x09cf c0x008a (n0x0d77-n0x0d95)  + I mie
	0x22e977c6, // n0x09d0 c0x008b (n0x0d95-n0x0db6)  + I miyagi
	0x232475c8, // n0x09d1 c0x008c (n0x0db6-n0x0dd1)  + I miyazaki
	0x2376fe86, // n0x09d2 c0x008d (n0x0dd1-n0x0e1c)  + I nagano
	0x23a76088, // n0x09d3 c0x008e (n0x0e1c-n0x0e32)  + I nagasaki
	0x23f7bf46, // n0x09d4 c0x008f (n0x0e32-n0x0e33)* o I nagoya
	0x242e7784, // n0x09d5 c0x0090 (n0x0e33-n0x0e59)  + I nara
	0x00209e82, // n0x09d6 c0x0000 (---------------)  + I ne
	0x247589c7, // n0x09d7 c0x0091 (n0x0e59-n0x0e7b)  + I niigata
	0x24aa2444, // n0x09d8 c0x0092 (n0x0e7b-n0x0e8e)  + I oita
	0x24e71f47, // n0x09d9 c0x0093 (n0x0e8e-n0x0ea8)  + I okayama
	0x252130c7, // n0x09da c0x0094 (n0x0ea8-n0x0ed2)  + I okinawa
	0x00200d02, // n0x09db c0x0000 (---------------)  + I or
	0x256905c5, // n0x09dc c0x0095 (n0x0ed2-n0x0f04)  + I osaka
	0x25aaf744, // n0x09dd c0x0096 (n0x0f04-n0x0f1e)  + I saga
	0x25f0c587, // n0x09de c0x0097 (n0x0f1e-n0x0f63)  + I saitama
	0x26243347, // n0x09df c0x0098 (n0x0f63-n0x0f64)* o I sapporo
	0x2667af06, // n0x09e0 c0x0099 (n0x0f64-n0x0f65)* o I sendai
	0x26a5c545, // n0x09e1 c0x009a (n0x0f65-n0x0f7c)  + I shiga
	0x26e8ab87, // n0x09e2 c0x009b (n0x0f7c-n0x0f93)  + I shimane
	0x272f07c8, // n0x09e3 c0x009c (n0x0f93-n0x0fb7)  + I shizuoka
	0x2774d487, // n0x09e4 c0x009d (n0x0fb7-n0x0fd6)  + I tochigi
	0x27ac69c9, // n0x09e5 c0x009e (n0x0fd6-n0x0fe7)  + I tokushima
	0x27ebc8c5, // n0x09e6 c0x009f (n0x0fe7-n0x1020)  + I tokyo
	0x282f11c7, // n0x09e7 c0x00a0 (n0x1020-n0x102d)  + I tottori
	0x286873c6, // n0x09e8 c0x00a1 (n0x102d-n0x1045)  + I toyama
	0x28b0a988, // n0x09e9 c0x00a2 (n0x1045-n0x1062)  + I wakayama
	0x0024534d, // n0x09ea c0x0000 (---------------)  + I xn--0trq7p7nn
	0x00255c89, // n0x09eb c0x0000 (---------------)  + I xn--1ctwo
	0x0026bc4b, // n0x09ec c0x0000 (---------------)  + I xn--1lqs03n
	0x0026c98b, // n0x09ed c0x0000 (---------------)  + I xn--1lqs71d
	0x0029960b, // n0x09ee c0x0000 (---------------)  + I xn--2m4a15e
	0x002b9c0b, // n0x09ef c0x0000 (---------------)  + I xn--32vp30h
	0x002f490b, // n0x09f0 c0x0000 (---------------)  + I xn--4it168d
	0x002f4bcb, // n0x09f1 c0x0000 (---------------)  + I xn--4it797k
	0x002f5549, // n0x09f2 c0x0000 (---------------)  + I xn--4pvxs
	0x002f694b, // n0x09f3 c0x0000 (---------------)  + I xn--5js045d
	0x002f6c0b, // n0x09f4 c0x0000 (---------------)  + I xn--5rtp49c
	0x002f714b, // n0x09f5 c0x0000 (---------------)  + I xn--5rtq34k
	0x002f754a, // n0x09f6 c0x0000 (---------------)  + I xn--6btw5a
	0x002f7a8a, // n0x09f7 c0x0000 (---------------)  + I xn--6orx2r
	0x002f808c, // n0x09f8 c0x0000 (---------------)  + I xn--7t0a264c
	0x002fe0cb, // n0x09f9 c0x0000 (---------------)  + I xn--8ltr62k
	0x002fe50a, // n0x09fa c0x0000 (---------------)  + I xn--8pvr4u
	0x0030d64a, // n0x09fb c0x0000 (---------------)  + I xn--c3s14m
	0x0031350e, // n0x09fc c0x0000 (---------------)  + I xn--d5qv7z876c
	0x0031474e, // n0x09fd c0x0000 (---------------)  + I xn--djrs72d6uy
	0x00314aca, // n0x09fe c0x0000 (---------------)  + I xn--djty4k
	0x0031640a, // n0x09ff c0x0000 (---------------)  + I xn--efvn9s
	0x0031768b, // n0x0a00 c0x0000 (---------------)  + I xn--ehqz56n
	0x0031794b, // n0x0a01 c0x0000 (---------------)  + I xn--elqq16h
	0x0031838b, // n0x0a02 c0x0000 (---------------)  + I xn--f6qx53a
	0x003285cb, // n0x0a03 c0x0000 (---------------)  + I xn--k7yn95e
	0x00328bca, // n0x0a04 c0x0000 (---------------)  + I xn--kbrq7o
	0x0032988b, // n0x0a05 c0x0000 (---------------)  + I xn--klt787d
	0x00329b4a, // n0x0a06 c0x0000 (---------------)  + I xn--kltp7d
	0x00329dca, // n0x0a07 c0x0000 (---------------)  + I xn--kltx9a
	0x0032a04a, // n0x0a08 c0x0000 (---------------)  + I xn--klty5x
	0x00340acb, // n0x0a09 c0x0000 (---------------)  + I xn--mkru45i
	0x00348a4b, // n0x0a0a c0x0000 (---------------)  + I xn--nit225k
	0x0034ac0e, // n0x0a0b c0x0000 (---------------)  + I xn--ntso0iqx3a
	0x0034af8b, // n0x0a0c c0x0000 (---------------)  + I xn--ntsq17g
	0x00350acb, // n0x0a0d c0x0000 (---------------)  + I xn--pssu33l
	0x00351b4b, // n0x0a0e c0x0000 (---------------)  + I xn--qqqt11m
	0x0035468a, // n0x0a0f c0x0000 (---------------)  + I xn--rht27z
	0x00354909, // n0x0a10 c0x0000 (---------------)  + I xn--rht3d
	0x00354b4a, // n0x0a11 c0x0000 (---------------)  + I xn--rht61e
	0x0035600a, // n0x0a12 c0x0000 (---------------)  + I xn--rny31h
	0x0037180b, // n0x0a13 c0x0000 (---------------)  + I xn--tor131o
	0x003732cb, // n0x0a14 c0x0000 (---------------)  + I xn--uist22h
	0x0037380a, // n0x0a15 c0x0000 (---------------)  + I xn--uisz3g
	0x0037454b, // n0x0a16 c0x0000 (---------------)  + I xn--uuwu58a
	0x0037904b, // n0x0a17 c0x0000 (---------------)  + I xn--vgu402c
	0x00383f0b, // n0x0a18 c0x0000 (---------------)  + I xn--zbx025d
	0x28e797c8, // n0x0a19 c0x00a3 (n0x1062-n0x1084)  + I yamagata
	0x292809c9, // n0x0a1a c0x00a4 (n0x1084-n0x1094)  + I yamaguchi
	0x29779ac9, // n0x0a1b c0x00a5 (n0x1094-n0x10b0)  + I yamanashi
	0x29b45bc8, // n0x0a1c c0x00a6 (n0x10b0-n0x10b1)* o I yokohama
	0x002a8745, // n0x0a1d c0x0000 (---------------)  + I aisai
	0x00203583, // n0x0a1e c0x0000 (---------------)  + I ama
	0x00202d84, // n0x0a1f c0x0000 (---------------)  + I anjo
	0x00375ac5, // n0x0a20 c0x0000 (---------------)  + I asuke
	0x00269786, // n0x0a21 c0x0000 (---------------)  + I chiryu
	0x00276ac5, // n0x0a22 c0x0000 (---------------)  + I chita
	0x002802c4, // n0x0a23 c0x0000 (---------------)  + I fuso
	0x00258648, // n0x0a24 c0x0000 (---------------)  + I gamagori
	0x00354285, // n0x0a25 c0x0000 (---------------)  + I handa
	0x00289044, // n0x0a26 c0x0000 (---------------)  + I hazu
	0x0024f407, // n0x0a27 c0x0000 (---------------)  + I hekinan
	0x00292c0a, // n0x0a28 c0x0000 (---------------)  + I higashiura
	0x0030b0ca, // n0x0a29 c0x0000 (---------------)  + I ichinomiya
	0x002d8a47, // n0x0a2a c0x0000 (---------------)  + I inazawa
	0x00211b47, // n0x0a2b c0x0000 (---------------)  + I inuyama
	0x002e3187, // n0x0a2c c0x0000 (---------------)  + I isshiki
	0x0026b507, // n0x0a2d c0x0000 (---------------)  + I iwakura
	0x0021c585, // n0x0a2e c0x0000 (---------------)  + I kanie
	0x0036d0c6, // n0x0a2f c0x0000 (---------------)  + I kariya
	0x002b6b07, // n0x0a30 c0x0000 (---------------)  + I kasugai
	0x00239784, // n0x0a31 c0x0000 (---------------)  + I kira
	0x002f3186, // n0x0a32 c0x0000 (---------------)  + I kiyosu
	0x003027c6, // n0x0a33 c0x0000 (---------------)  + I komaki
	0x002ca805, // n0x0a34 c0x0000 (---------------)  + I konan
	0x0029bcc4, // n0x0a35 c0x0000 (---------------)  + I kota
	0x002985c6, // n0x0a36 c0x0000 (---------------)  + I mihama
	0x00291c87, // n0x0a37 c0x0000 (---------------)  + I miyoshi
	0x00221a46, // n0x0a38 c0x0000 (---------------)  + I nishio
	0x00227147, // n0x0a39 c0x0000 (---------------)  + I nisshin
	0x002078c3, // n0x0a3a c0x0000 (---------------)  + I obu
	0x0024ea46, // n0x0a3b c0x0000 (---------------)  + I oguchi
	0x00236005, // n0x0a3c c0x0000 (---------------)  + I oharu
	0x00277b87, // n0x0a3d c0x0000 (---------------)  + I okazaki
	0x002b1d4a, // n0x0a3e c0x0000 (---------------)  + I owariasahi
	0x00231844, // n0x0a3f c0x0000 (---------------)  + I seto
	0x00219888, // n0x0a40 c0x0000 (---------------)  + I shikatsu
	0x002c5849, // n0x0a41 c0x0000 (---------------)  + I shinshiro
	0x002e9807, // n0x0a42 c0x0000 (---------------)  + I shitara
	0x00203006, // n0x0a43 c0x0000 (---------------)  + I tahara
	0x00322e48, // n0x0a44 c0x0000 (---------------)  + I takahama
	0x00213449, // n0x0a45 c0x0000 (---------------)  + I tobishima
	0x00295e44, // n0x0a46 c0x0000 (---------------)  + I toei
	0x002186c4, // n0x0a47 c0x0000 (---------------)  + I togo
	0x002f1d45, // n0x0a48 c0x0000 (---------------)  + I tokai
	0x002b3248, // n0x0a49 c0x0000 (---------------)  + I tokoname
	0x002b4307, // n0x0a4a c0x0000 (---------------)  + I toyoake
	0x002bc609, // n0x0a4b c0x0000 (---------------)  + I toyohashi
	0x00327fc8, // n0x0a4c c0x0000 (---------------)  + I toyokawa
	0x003245c6, // n0x0a4d c0x0000 (---------------)  + I toyone
	0x00244606, // n0x0a4e c0x0000 (---------------)  + I toyota
	0x0028ca08, // n0x0a4f c0x0000 (---------------)  + I tsushima
	0x003332c6, // n0x0a50 c0x0000 (---------------)  + I yatomi
	0x00212185, // n0x0a51 c0x0000 (---------------)  + I akita
	0x0027afc6, // n0x0a52 c0x0000 (---------------)  + I daisen
	0x00272348, // n0x0a53 c0x0000 (---------------)  + I fujisato
	0x0021e486, // n0x0a54 c0x0000 (---------------)  + I gojome
	0x00270f0b, // n0x0a55 c0x0000 (---------------)  + I hachirogata
	0x00283e46, // n0x0a56 c0x0000 (---------------)  + I happou
	0x0028df4d, // n0x0a57 c0x0000 (---------------)  + I higashinaruse
	0x00206445, // n0x0a58 c0x0000 (---------------)  + I honjo
	0x0029c3c6, // n0x0a59 c0x0000 (---------------)  + I honjyo
	0x00202405, // n0x0a5a c0x0000 (---------------)  + I ikawa
	0x0036a389, // n0x0a5b c0x0000 (---------------)  + I kamikoani
	0x0036a247, // n0x0a5c c0x0000 (---------------)  + I kamioka
	0x003310c8, // n0x0a5d c0x0000 (---------------)  + I katagami
	0x00314146, // n0x0a5e c0x0000 (---------------)  + I kazuno
	0x0028d389, // n0x0a5f c0x0000 (---------------)  + I kitaakita
	0x002e1846, // n0x0a60 c0x0000 (---------------)  + I kosaka
	0x002b1cc5, // n0x0a61 c0x0000 (---------------)  + I kyowa
	0x002467c6, // n0x0a62 c0x0000 (---------------)  + I misato
	0x002a5f86, // n0x0a63 c0x0000 (---------------)  + I mitane
	0x002ba6c9, // n0x0a64 c0x0000 (---------------)  + I moriyoshi
	0x00273706, // n0x0a65 c0x0000 (---------------)  + I nikaho
	0x00257207, // n0x0a66 c0x0000 (---------------)  + I noshiro
	0x00294f85, // n0x0a67 c0x0000 (---------------)  + I odate
	0x00207743, // n0x0a68 c0x0000 (---------------)  + I oga
	0x00271085, // n0x0a69 c0x0000 (---------------)  + I ogata
	0x002bf347, // n0x0a6a c0x0000 (---------------)  + I semboku
	0x002db006, // n0x0a6b c0x0000 (---------------)  + I yokote
	0x00206349, // n0x0a6c c0x0000 (---------------)  + I yurihonjo
	0x0026e0c6, // n0x0a6d c0x0000 (---------------)  + I aomori
	0x00264206, // n0x0a6e c0x0000 (---------------)  + I gonohe
	0x0024f249, // n0x0a6f c0x0000 (---------------)  + I hachinohe
	0x0027a9c9, // n0x0a70 c0x0000 (---------------)  + I hashikami
	0x00295907, // n0x0a71 c0x0000 (---------------)  + I hiranai
	0x00344608, // n0x0a72 c0x0000 (---------------)  + I hirosaki
	0x002e0449, // n0x0a73 c0x0000 (---------------)  + I itayanagi
	0x00278908, // n0x0a74 c0x0000 (---------------)  + I kuroishi
	0x003482c6, // n0x0a75 c0x0000 (---------------)  + I misawa
	0x002c2e05, // n0x0a76 c0x0000 (---------------)  + I mutsu
	0x0023d20a, // n0x0a77 c0x0000 (---------------)  + I nakadomari
	0x00264286, // n0x0a78 c0x0000 (---------------)  + I noheji
	0x002ec746, // n0x0a79 c0x0000 (---------------)  + I oirase
	0x00292605, // n0x0a7a c0x0000 (---------------)  + I owani
	0x00241b48, // n0x0a7b c0x0000 (---------------)  + I rokunohe
	0x0035a387, // n0x0a7c c0x0000 (---------------)  + I sannohe
	0x00379c4a, // n0x0a7d c0x0000 (---------------)  + I shichinohe
	0x0024ac86, // n0x0a7e c0x0000 (---------------)  + I shingo
	0x00305fc5, // n0x0a7f c0x0000 (---------------)  + I takko
	0x002fd846, // n0x0a80 c0x0000 (---------------)  + I towada
	0x0025de07, // n0x0a81 c0x0000 (---------------)  + I tsugaru
	0x00202ec7, // n0x0a82 c0x0000 (---------------)  + I tsuruta
	0x00305685, // n0x0a83 c0x0000 (---------------)  + I abiko
	0x002b1e85, // n0x0a84 c0x0000 (---------------)  + I asahi
	0x002bd846, // n0x0a85 c0x0000 (---------------)  + I chonan
	0x002cb5c6, // n0x0a86 c0x0000 (---------------)  + I chosei
	0x002dfb86, // n0x0a87 c0x0000 (---------------)  + I choshi
	0x00347284, // n0x0a88 c0x0000 (---------------)  + I chuo
	0x00279e49, // n0x0a89 c0x0000 (---------------)  + I funabashi
	0x00281886, // n0x0a8a c0x0000 (---------------)  + I futtsu
	0x00231f0a, // n0x0a8b c0x0000 (---------------)  + I hanamigawa
	0x00287d08, // n0x0a8c c0x0000 (---------------)  + I ichihara
	0x0034fec8, // n0x0a8d c0x0000 (---------------)  + I ichikawa
	0x0030b0ca, // n0x0a8e c0x0000 (---------------)  + I ichinomiya
	0x00369345, // n0x0a8f c0x0000 (---------------)  + I inzai
	0x00291bc5, // n0x0a90 c0x0000 (---------------)  + I isumi
	0x0020d808, // n0x0a91 c0x0000 (---------------)  + I kamagaya
	0x002bea48, // n0x0a92 c0x0000 (---------------)  + I kamogawa
	0x00375e87, // n0x0a93 c0x0000 (---------------)  + I kashiwa
	0x00219046, // n0x0a94 c0x0000 (---------------)  + I katori
	0x00304a08, // n0x0a95 c0x0000 (---------------)  + I katsuura
	0x002fbf07, // n0x0a96 c0x0000 (---------------)  + I kimitsu
	0x00277cc8, // n0x0a97 c0x0000 (---------------)  + I kisarazu
	0x002a3306, // n0x0a98 c0x0000 (---------------)  + I kozaki
	0x0027c108, // n0x0a99 c0x0000 (---------------)  + I kujukuri
	0x00288b46, // n0x0a9a c0x0000 (---------------)  + I kyonan
	0x002cca07, // n0x0a9b c0x0000 (---------------)  + I matsudo
	0x00279a46, // n0x0a9c c0x0000 (---------------)  + I midori
	0x002985c6, // n0x0a9d c0x0000 (---------------)  + I mihama
	0x003333ca, // n0x0a9e c0x0000 (---------------)  + I minamiboso
	0x00233306, // n0x0a9f c0x0000 (---------------)  + I mobara
	0x002c2e09, // n0x0aa0 c0x0000 (---------------)  + I mutsuzawa
	0x00364746, // n0x0aa1 c0x0000 (---------------)  + I nagara
	0x002f97ca, // n0x0aa2 c0x0000 (---------------)  + I nagareyama
	0x002e7789, // n0x0aa3 c0x0000 (---------------)  + I narashino
	0x00306ec6, // n0x0aa4 c0x0000 (---------------)  + I narita
	0x00238104, // n0x0aa5 c0x0000 (---------------)  + I noda
	0x00285b8d, // n0x0aa6 c0x0000 (---------------)  + I oamishirasato
	0x00280c47, // n0x0aa7 c0x0000 (---------------)  + I omigawa
	0x003090c6, // n0x0aa8 c0x0000 (---------------)  + I onjuku
	0x002ac405, // n0x0aa9 c0x0000 (---------------)  + I otaki
	0x002e18c5, // n0x0aaa c0x0000 (---------------)  + I sakae
	0x0020e0c6, // n0x0aab c0x0000 (---------------)  + I sakura
	0x002ea189, // n0x0aac c0x0000 (---------------)  + I shimofusa
	0x002d2a87, // n0x0aad c0x0000 (---------------)  + I shirako
	0x00272f86, // n0x0aae c0x0000 (---------------)  + I shiroi
	0x002e7d86, // n0x0aaf c0x0000 (---------------)  + I shisui
	0x00383cc9, // n0x0ab0 c0x0000 (---------------)  + I sodegaura
	0x00322bc4, // n0x0ab1 c0x0000 (---------------)  + I sosa
	0x0024db04, // n0x0ab2 c0x0000 (---------------)  + I tako
	0x002128c8, // n0x0ab3 c0x0000 (---------------)  + I tateyama
	0x00273bc6, // n0x0ab4 c0x0000 (---------------)  + I togane
	0x00294a08, // n0x0ab5 c0x0000 (---------------)  + I tohnosho
	0x00246748, // n0x0ab6 c0x0000 (---------------)  + I tomisato
	0x002122c7, // n0x0ab7 c0x0000 (---------------)  + I urayasu
	0x002c3a49, // n0x0ab8 c0x0000 (---------------)  + I yachimata
	0x00202a47, // n0x0ab9 c0x0000 (---------------)  + I yachiyo
	0x002a684a, // n0x0aba c0x0000 (---------------)  + I yokaichiba
	0x002d698f, // n0x0abb c0x0000 (---------------)  + I yokoshibahikari
	0x0024b64a, // n0x0abc c0x0000 (---------------)  + I yotsukaido
	0x00229185, // n0x0abd c0x0000 (---------------)  + I ainan
	0x00272585, // n0x0abe c0x0000 (---------------)  + I honai
	0x00218f05, // n0x0abf c0x0000 (---------------)  + I ikata
	0x00288dc7, // n0x0ac0 c0x0000 (---------------)  + I imabari
	0x00202b43, // n0x0ac1 c0x0000 (---------------)  + I iyo
	0x00344808, // n0x0ac2 c0x0000 (---------------)  + I kamijima
	0x0029b286, // n0x0ac3 c0x0000 (---------------)  + I kihoku
	0x0029b389, // n0x0ac4 c0x0000 (---------------)  + I kumakogen
	0x0037fe06, // n0x0ac5 c0x0000 (---------------)  + I masaki
	0x002ba507, // n0x0ac6 c0x0000 (---------------)  + I matsuno
	0x0028d149, // n0x0ac7 c0x0000 (---------------)  + I matsuyama
	0x00330fc8, // n0x0ac8 c0x0000 (---------------)  + I namikata
	0x0036a547, // n0x0ac9 c0x0000 (---------------)  + I niihama
	0x00347343, // n0x0aca c0x0000 (---------------)  + I ozu
	0x002a87c5, // n0x0acb c0x0000 (---------------)  + I saijo
	0x002d68c5, // n0x0acc c0x0000 (---------------)  + I seiyo
	0x00348e8b, // n0x0acd c0x0000 (---------------)  + I shikokuchuo
	0x00263084, // n0x0ace c0x0000 (---------------)  + I tobe
	0x0021dec4, // n0x0acf c0x0000 (---------------)  + I toon
	0x00270b06, // n0x0ad0 c0x0000 (---------------)  + I uchiko
	0x002c96c7, // n0x0ad1 c0x0000 (---------------)  + I uwajima
	0x0035830a, // n0x0ad2 c0x0000 (---------------)  + I yawatahama
	0x00216d87, // n0x0ad3 c0x0000 (---------------)  + I echizen
	0x00295ec7, // n0x0ad4 c0x0000 (---------------)  + I eiheiji
	0x00277205, // n0x0ad5 c0x0000 (---------------)  + I fukui
	0x002056c5, // n0x0ad6 c0x0000 (---------------)  + I ikeda
	0x0021d4c9, // n0x0ad7 c0x0000 (---------------)  + I katsuyama
	0x002985c6, // n0x0ad8 c0x0000 (---------------)  + I mihama
	0x00216c0d, // n0x0ad9 c0x0000 (---------------)  + I minamiechizen
	0x00285e85, // n0x0ada c0x0000 (---------------)  + I obama
	0x002903c3, // n0x0adb c0x0000 (---------------)  + I ohi
	0x00210683, // n0x0adc c0x0000 (---------------)  + I ono
	0x002336c5, // n0x0add c0x0000 (---------------)  + I sabae
	0x00327d85, // n0x0ade c0x0000 (---------------)  + I sakai
	0x00322e48, // n0x0adf c0x0000 (---------------)  + I takahama
	0x00281947, // n0x0ae0 c0x0000 (---------------)  + I tsuruga
	0x0024d886, // n0x0ae1 c0x0000 (---------------)  + I wakasa
	0x00293506, // n0x0ae2 c0x0000 (---------------)  + I ashiya
	0x0022d1c5, // n0x0ae3 c0x0000 (---------------)  + I buzen
	0x0021e347, // n0x0ae4 c0x0000 (---------------)  + I chikugo
	0x00211dc7, // n0x0ae5 c0x0000 (---------------)  + I chikuho
	0x0036dbc7, // n0x0ae6 c0x0000 (---------------)  + I chikujo
	0x002bed4a, // n0x0ae7 c0x0000 (---------------)  + I chikushino
	0x0024eb08, // n0x0ae8 c0x0000 (---------------)  + I chikuzen
	0x00347284, // n0x0ae9 c0x0000 (---------------)  + I chuo
	0x00205987, // n0x0aea c0x0000 (---------------)  + I dazaifu
	0x00276507, // n0x0aeb c0x0000 (---------------)  + I fukuchi
	0x00317bc6, // n0x0aec c0x0000 (---------------)  + I hakata
	0x00260cc7, // n0x0aed c0x0000 (---------------)  + I higashi
	0x002c4a48, // n0x0aee c0x0000 (---------------)  + I hirokawa
	0x003799c8, // n0x0aef c0x0000 (---------------)  + I hisayama
	0x00258106, // n0x0af0 c0x0000 (---------------)  + I iizuka
	0x0020f5c8, // n0x0af1 c0x0000 (---------------)  + I inatsuki
	0x00273784, // n0x0af2 c0x0000 (---------------)  + I kaho
	0x002b6b06, // n0x0af3 c0x0000 (---------------)  + I kasuga
	0x002041c6, // n0x0af4 c0x0000 (---------------)  + I kasuya
	0x003029c6, // n0x0af5 c0x0000 (---------------)  + I kawara
	0x0030b346, // n0x0af6 c0x0000 (---------------)  + I keisen
	0x00293a84, // n0x0af7 c0x0000 (---------------)  + I koga
	0x0026b5c6, // n0x0af8 c0x0000 (---------------)  + I kurate
	0x002aaa46, // n0x0af9 c0x0000 (---------------)  + I kurogi
	0x0028c486, // n0x0afa c0x0000 (---------------)  + I kurume
	0x00216c06, // n0x0afb c0x0000 (---------------)  + I minami
	0x00210546, // n0x0afc c0x0000 (---------------)  + I miyako
	0x0029b946, // n0x0afd c0x0000 (---------------)  + I miyama
	0x0024d788, // n0x0afe c0x0000 (---------------)  + I miyawaka
	0x002e6d08, // n0x0aff c0x0000 (---------------)  + I mizumaki
	0x002c0408, // n0x0b00 c0x0000 (---------------)  + I munakata
	0x00276cc8, // n0x0b01 c0x0000 (---------------)  + I nakagawa
	0x0020d786, // n0x0b02 c0x0000 (---------------)  + I nakama
	0x00215405, // n0x0b03 c0x0000 (---------------)  + I nishi
	0x0027e406, // n0x0b04 c0x0000 (---------------)  + I nogata
	0x002a00c5, // n0x0b05 c0x0000 (---------------)  + I ogori
	0x00347047, // n0x0b06 c0x0000 (---------------)  + I okagaki
	0x00230345, // n0x0b07 c0x0000 (---------------)  + I okawa
	0x002130c3, // n0x0b08 c0x0000 (---------------)  + I oki
	0x002087c5, // n0x0b09 c0x0000 (---------------)  + I omuta
	0x0037c804, // n0x0b0a c0x0000 (---------------)  + I onga
	0x00210685, // n0x0b0b c0x0000 (---------------)  + I onojo
	0x00242043, // n0x0b0c c0x0000 (---------------)  + I oto
	0x002ddc47, // n0x0b0d c0x0000 (---------------)  + I saigawa
	0x0030d908, // n0x0b0e c0x0000 (---------------)  + I sasaguri
	0x00227206, // n0x0b0f c0x0000 (---------------)  + I shingu
	0x002c8f4d, // n0x0b10 c0x0000 (---------------)  + I shinyoshitomi
	0x00272546, // n0x0b11 c0x0000 (---------------)  + I shonai
	0x0028ba85, // n0x0b12 c0x0000 (---------------)  + I soeda
	0x002aa343, // n0x0b13 c0x0000 (---------------)  + I sue
	0x002a8589, // n0x0b14 c0x0000 (---------------)  + I tachiarai
	0x002be046, // n0x0b15 c0x0000 (---------------)  + I tagawa
	0x0020ed06, // n0x0b16 c0x0000 (---------------)  + I takata
	0x002f4544, // n0x0b17 c0x0000 (---------------)  + I toho
	0x0024b5c7, // n0x0b18 c0x0000 (---------------)  + I toyotsu
	0x00239106, // n0x0b19 c0x0000 (---------------)  + I tsuiki
	0x00306205, // n0x0b1a c0x0000 (---------------)  + I ukiha
	0x00200f03, // n0x0b1b c0x0000 (---------------)  + I umi
	0x0020bd44, // n0x0b1c c0x0000 (---------------)  + I usui
	0x002766c6, // n0x0b1d c0x0000 (---------------)  + I yamada
	0x002042c4, // n0x0b1e c0x0000 (---------------)  + I yame
	0x002cef88, // n0x0b1f c0x0000 (---------------)  + I yanagawa
	0x00204fc9, // n0x0b20 c0x0000 (---------------)  + I yukuhashi
	0x002305c9, // n0x0b21 c0x0000 (---------------)  + I aizubange
	0x0029480a, // n0x0b22 c0x0000 (---------------)  + I aizumisato
	0x00286bcd, // n0x0b23 c0x0000 (---------------)  + I aizuwakamatsu
	0x0024fd87, // n0x0b24 c0x0000 (---------------)  + I asakawa
	0x00261e86, // n0x0b25 c0x0000 (---------------)  + I bandai
	0x00218204, // n0x0b26 c0x0000 (---------------)  + I date
	0x00279049, // n0x0b27 c0x0000 (---------------)  + I fukushima
	0x0027fcc8, // n0x0b28 c0x0000 (---------------)  + I furudono
	0x00280846, // n0x0b29 c0x0000 (---------------)  + I futaba
	0x00251146, // n0x0b2a c0x0000 (---------------)  + I hanawa
	0x00260cc7, // n0x0b2b c0x0000 (---------------)  + I higashi
	0x002dd346, // n0x0b2c c0x0000 (---------------)  + I hirata
	0x0021c286, // n0x0b2d c0x0000 (---------------)  + I hirono
	0x00364146, // n0x0b2e c0x0000 (---------------)  + I iitate
	0x0021314a, // n0x0b2f c0x0000 (---------------)  + I inawashiro
	0x0021a288, // n0x0b30 c0x0000 (---------------)  + I ishikawa
	0x00225485, // n0x0b31 c0x0000 (---------------)  + I iwaki
	0x002395c9, // n0x0b32 c0x0000 (---------------)  + I izumizaki
	0x002b4a8a, // n0x0b33 c0x0000 (---------------)  + I kagamiishi
	0x0021a508, // n0x0b34 c0x0000 (---------------)  + I kaneyama
	0x00291648, // n0x0b35 c0x0000 (---------------)  + I kawamata
	0x0020ec88, // n0x0b36 c0x0000 (---------------)  + I kitakata
	0x00299bcc, // n0x0b37 c0x0000 (---------------)  + I kitashiobara
	0x00316805, // n0x0b38 c0x0000 (---------------)  + I koori
	0x00293788, // n0x0b39 c0x0000 (---------------)  + I koriyama
	0x00315146, // n0x0b3a c0x0000 (---------------)  + I kunimi
	0x002eabc6, // n0x0b3b c0x0000 (---------------)  + I miharu
	0x002b20c7, // n0x0b3c c0x0000 (---------------)  + I mishima
	0x00216c85, // n0x0b3d c0x0000 (---------------)  + I namie
	0x0027b145, // n0x0b3e c0x0000 (---------------)  + I nango
	0x00230489, // n0x0b3f c0x0000 (---------------)  + I nishiaizu
	0x00216f07, // n0x0b40 c0x0000 (---------------)  + I nishigo
	0x0029b345, // n0x0b41 c0x0000 (---------------)  + I okuma
	0x0021da87, // n0x0b42 c0x0000 (---------------)  + I omotego
	0x00210683, // n0x0b43 c0x0000 (---------------)  + I ono
	0x002b5145, // n0x0b44 c0x0000 (---------------)  + I otama
	0x00229988, // n0x0b45 c0x0000 (---------------)  + I samegawa
	0x002718c7, // n0x0b46 c0x0000 (---------------)  + I shimogo
	0x00291509, // n0x0b47 c0x0000 (---------------)  + I shirakawa
	0x002f5745, // n0x0b48 c0x0000 (---------------)  + I showa
	0x002d4c04, // n0x0b49 c0x0000 (---------------)  + I soma
	0x00296908, // n0x0b4a c0x0000 (---------------)  + I sukagawa
	0x00384e07, // n0x0b4b c0x0000 (---------------)  + I taishin
	0x0036a708, // n0x0b4c c0x0000 (---------------)  + I tamakawa
	0x00202548, // n0x0b4d c0x0000 (---------------)  + I tanagura
	0x00219dc5, // n0x0b4e c0x0000 (---------------)  + I tenei
	0x0025c686, // n0x0b4f c0x0000 (---------------)  + I yabuki
	0x00293606, // n0x0b50 c0x0000 (---------------)  + I yamato
	0x00363549, // n0x0b51 c0x0000 (---------------)  + I yamatsuri
	0x00300ec7, // n0x0b52 c0x0000 (---------------)  + I yanaizu
	0x002a0b06, // n0x0b53 c0x0000 (---------------)  + I yugawa
	0x0029abc7, // n0x0b54 c0x0000 (---------------)  + I anpachi
	0x00202243, // n0x0b55 c0x0000 (---------------)  + I ena
	0x00269a44, // n0x0b56 c0x0000 (---------------)  + I gifu
	0x00363e05, // n0x0b57 c0x0000 (---------------)  + I ginan
	0x00214644, // n0x0b58 c0x0000 (---------------)  + I godo
	0x00246cc4, // n0x0b59 c0x0000 (---------------)  + I gujo
	0x00271247, // n0x0b5a c0x0000 (---------------)  + I hashima
	0x00380487, // n0x0b5b c0x0000 (---------------)  + I hichiso
	0x00273144, // n0x0b5c c0x0000 (---------------)  + I hida
	0x00291350, // n0x0b5d c0x0000 (---------------)  + I higashishirakawa
	0x0036d387, // n0x0b5e c0x0000 (---------------)  + I ibigawa
	0x002056c5, // n0x0b5f c0x0000 (---------------)  + I ikeda
	0x00275ccc, // n0x0b60 c0x0000 (---------------)  + I kakamigahara
	0x00202304, // n0x0b61 c0x0000 (---------------)  + I kani
	0x002c8a08, // n0x0b62 c0x0000 (---------------)  + I kasahara
	0x002cc909, // n0x0b63 c0x0000 (---------------)  + I kasamatsu
	0x00267ac6, // n0x0b64 c0x0000 (---------------)  + I kawaue
	0x00322cc8, // n0x0b65 c0x0000 (---------------)  + I kitagata
	0x00230284, // n0x0b66 c0x0000 (---------------)  + I mino
	0x002d2108, // n0x0b67 c0x0000 (---------------)  + I minokamo
	0x002b39c6, // n0x0b68 c0x0000 (---------------)  + I mitake
	0x002236c8, // n0x0b69 c0x0000 (---------------)  + I mizunami
	0x00292246, // n0x0b6a c0x0000 (---------------)  + I motosu
	0x0020198b, // n0x0b6b c0x0000 (---------------)  + I nakatsugawa
	0x00207745, // n0x0b6c c0x0000 (---------------)  + I ogaki
	0x002bb008, // n0x0b6d c0x0000 (---------------)  + I sakahogi
	0x00205404, // n0x0b6e c0x0000 (---------------)  + I seki
	0x0020540a, // n0x0b6f c0x0000 (---------------)  + I sekigahara
	0x00291509, // n0x0b70 c0x0000 (---------------)  + I shirakawa
	0x00279946, // n0x0b71 c0x0000 (---------------)  + I tajimi
	0x002d6ec8, // n0x0b72 c0x0000 (---------------)  + I takayama
	0x002da345, // n0x0b73 c0x0000 (---------------)  + I tarui
	0x00221004, // n0x0b74 c0x0000 (---------------)  + I toki
	0x002c8906, // n0x0b75 c0x0000 (---------------)  + I tomika
	0x00380148, // n0x0b76 c0x0000 (---------------)  + I wanouchi
	0x002797c8, // n0x0b77 c0x0000 (---------------)  + I yamagata
	0x0031f2c6, // n0x0b78 c0x0000 (---------------)  + I yaotsu
	0x002068c4, // n0x0b79 c0x0000 (---------------)  + I yoro
	0x0023d186, // n0x0b7a c0x0000 (---------------)  + I annaka
	0x00202ac7, // n0x0b7b c0x0000 (---------------)  + I chiyoda
	0x00271e47, // n0x0b7c c0x0000 (---------------)  + I fujioka
	0x00260ccf, // n0x0b7d c0x0000 (---------------)  + I higashiagatsuma
	0x002ec447, // n0x0b7e c0x0000 (---------------)  + I isesaki
	0x00306f87, // n0x0b7f c0x0000 (---------------)  + I itakura
	0x002eaa85, // n0x0b80 c0x0000 (---------------)  + I kanna
	0x002f0945, // n0x0b81 c0x0000 (---------------)  + I kanra
	0x002955c9, // n0x0b82 c0x0000 (---------------)  + I katashina
	0x002c3d86, // n0x0b83 c0x0000 (---------------)  + I kawaba
	0x002657c5, // n0x0b84 c0x0000 (---------------)  + I kiryu
	0x0027acc7, // n0x0b85 c0x0000 (---------------)  + I kusatsu
	0x002b2348, // n0x0b86 c0x0000 (---------------)  + I maebashi
	0x00204345, // n0x0b87 c0x0000 (---------------)  + I meiwa
	0x00279a46, // n0x0b88 c0x0000 (---------------)  + I midori
	0x00224f48, // n0x0b89 c0x0000 (---------------)  + I minakami
	0x0036fe8a, // n0x0b8a c0x0000 (---------------)  + I naganohara
	0x0026ac08, // n0x0b8b c0x0000 (---------------)  + I nakanojo
	0x00282907, // n0x0b8c c0x0000 (---------------)  + I nanmoku
	0x002d6dc6, // n0x0b8d c0x0000 (---------------)  + I numata
	0x00239586, // n0x0b8e c0x0000 (---------------)  + I oizumi
	0x0021be03, // n0x0b8f c0x0000 (---------------)  + I ora
	0x00211083, // n0x0b90 c0x0000 (---------------)  + I ota
	0x002dfc49, // n0x0b91 c0x0000 (---------------)  + I shibukawa
	0x002e02c9, // n0x0b92 c0x0000 (---------------)  + I shimonita
	0x002c68c6, // n0x0b93 c0x0000 (---------------)  + I shinto
	0x002f5745, // n0x0b94 c0x0000 (---------------)  + I showa
	0x002e83c8, // n0x0b95 c0x0000 (---------------)  + I takasaki
	0x002d6ec8, // n0x0b96 c0x0000 (---------------)  + I takayama
	0x002a1988, // n0x0b97 c0x0000 (---------------)  + I tamamura
	0x003641cb, // n0x0b98 c0x0000 (---------------)  + I tatebayashi
	0x002c9187, // n0x0b99 c0x0000 (---------------)  + I tomioka
	0x00352d89, // n0x0b9a c0x0000 (---------------)  + I tsukiyono
	0x00260f48, // n0x0b9b c0x0000 (---------------)  + I tsumagoi
	0x0020e3c4, // n0x0b9c c0x0000 (---------------)  + I ueno
	0x002ba7c8, // n0x0b9d c0x0000 (---------------)  + I yoshioka
	0x00284f09, // n0x0b9e c0x0000 (---------------)  + I asaminami
	0x00261f45, // n0x0b9f c0x0000 (---------------)  + I daiwa
	0x002bdc07, // n0x0ba0 c0x0000 (---------------)  + I etajima
	0x00205ac5, // n0x0ba1 c0x0000 (---------------)  + I fuchu
	0x002796c8, // n0x0ba2 c0x0000 (---------------)  + I fukuyama
	0x00287b4b, // n0x0ba3 c0x0000 (---------------)  + I hatsukaichi
	0x0028a8d0, // n0x0ba4 c0x0000 (---------------)  + I higashihiroshima
	0x0029c005, // n0x0ba5 c0x0000 (---------------)  + I hongo
	0x0021798c, // n0x0ba6 c0x0000 (---------------)  + I jinsekikogen
	0x0024da45, // n0x0ba7 c0x0000 (---------------)  + I kaita
	0x00277283, // n0x0ba8 c0x0000 (---------------)  + I kui
	0x002b5ec6, // n0x0ba9 c0x0000 (---------------)  + I kumano
	0x002a9fc4, // n0x0baa c0x0000 (---------------)  + I kure
	0x002af846, // n0x0bab c0x0000 (---------------)  + I mihara
	0x00291c87, // n0x0bac c0x0000 (---------------)  + I miyoshi
	0x00201984, // n0x0bad c0x0000 (---------------)  + I naka
	0x0030afc8, // n0x0bae c0x0000 (---------------)  + I onomichi
	0x003446cd, // n0x0baf c0x0000 (---------------)  + I osakikamijima
	0x002e8285, // n0x0bb0 c0x0000 (---------------)  + I otake
	0x0024fdc4, // n0x0bb1 c0x0000 (---------------)  + I saka
	0x00228ec4, // n0x0bb2 c0x0000 (---------------)  + I sera
	0x0032ae09, // n0x0bb3 c0x0000 (---------------)  + I seranishi
	0x002aee48, // n0x0bb4 c0x0000 (---------------)  + I shinichi
	0x002aba07, // n0x0bb5 c0x0000 (---------------)  + I shobara
	0x002b3a48, // n0x0bb6 c0x0000 (---------------)  + I takehara
	0x00279f08, // n0x0bb7 c0x0000 (---------------)  + I abashiri
	0x00273285, // n0x0bb8 c0x0000 (---------------)  + I abira
	0x00237947, // n0x0bb9 c0x0000 (---------------)  + I aibetsu
	0x00273207, // n0x0bba c0x0000 (---------------)  + I akabira
	0x002edc87, // n0x0bbb c0x0000 (---------------)  + I akkeshi
	0x002b1e89, // n0x0bbc c0x0000 (---------------)  + I asahikawa
	0x00238f89, // n0x0bbd c0x0000 (---------------)  + I ashibetsu
	0x0023ff86, // n0x0bbe c0x0000 (---------------)  + I ashoro
	0x002bfdc6, // n0x0bbf c0x0000 (---------------)  + I assabu
	0x00260f06, // n0x0bc0 c0x0000 (---------------)  + I atsuma
	0x00381bc5, // n0x0bc1 c0x0000 (---------------)  + I bibai
	0x00272a04, // n0x0bc2 c0x0000 (---------------)  + I biei
	0x002037c6, // n0x0bc3 c0x0000 (---------------)  + I bifuka
	0x00204d86, // n0x0bc4 c0x0000 (---------------)  + I bihoro
	0x002732c8, // n0x0bc5 c0x0000 (---------------)  + I biratori
	0x0025dacb, // n0x0bc6 c0x0000 (---------------)  + I chippubetsu
	0x00295c87, // n0x0bc7 c0x0000 (---------------)  + I chitose
	0x00218204, // n0x0bc8 c0x0000 (---------------)  + I date
	0x002fa746, // n0x0bc9 c0x0000 (---------------)  + I ebetsu
	0x002d7ac7, // n0x0bca c0x0000 (---------------)  + I embetsu
	0x0029b545, // n0x0bcb c0x0000 (---------------)  + I eniwa
	0x00309e85, // n0x0bcc c0x0000 (---------------)  + I erimo
	0x00232a84, // n0x0bcd c0x0000 (---------------)  + I esan
	0x00238f06, // n0x0bce c0x0000 (---------------)  + I esashi
	0x00203848, // n0x0bcf c0x0000 (---------------)  + I fukagawa
	0x00279049, // n0x0bd0 c0x0000 (---------------)  + I fukushima
	0x00247fc6, // n0x0bd1 c0x0000 (---------------)  + I furano
	0x0027ed88, // n0x0bd2 c0x0000 (---------------)  + I furubira
	0x002f5046, // n0x0bd3 c0x0000 (---------------)  + I haboro
	0x0031e808, // n0x0bd4 c0x0000 (---------------)  + I hakodate
	0x002d028c, // n0x0bd5 c0x0000 (---------------)  + I hamatonbetsu
	0x00273146, // n0x0bd6 c0x0000 (---------------)  + I hidaka
	0x0028b74d, // n0x0bd7 c0x0000 (---------------)  + I higashikagura
	0x0028bbcb, // n0x0bd8 c0x0000 (---------------)  + I higashikawa
	0x002572c5, // n0x0bd9 c0x0000 (---------------)  + I hiroo
	0x00211f07, // n0x0bda c0x0000 (---------------)  + I hokuryu
	0x00273806, // n0x0bdb c0x0000 (---------------)  + I hokuto
	0x00335148, // n0x0bdc c0x0000 (---------------)  + I honbetsu
	0x00240009, // n0x0bdd c0x0000 (---------------)  + I horokanai
	0x002ad7c8, // n0x0bde c0x0000 (---------------)  + I horonobe
	0x002056c5, // n0x0bdf c0x0000 (---------------)  + I ikeda
	0x002bdd07, // n0x0be0 c0x0000 (---------------)  + I imakane
	0x002b4c08, // n0x0be1 c0x0000 (---------------)  + I ishikari
	0x0032d609, // n0x0be2 c0x0000 (---------------)  + I iwamizawa
	0x0024e546, // n0x0be3 c0x0000 (---------------)  + I iwanai
	0x0025700a, // n0x0be4 c0x0000 (---------------)  + I kamifurano
	0x00334ec8, // n0x0be5 c0x0000 (---------------)  + I kamikawa
	0x002ad60b, // n0x0be6 c0x0000 (---------------)  + I kamishihoro
	0x002a3e0c, // n0x0be7 c0x0000 (---------------)  + I kamisunagawa
	0x002d2208, // n0x0be8 c0x0000 (---------------)  + I kamoenai
	0x00275986, // n0x0be9 c0x0000 (---------------)  + I kayabe
	0x0036da88, // n0x0bea c0x0000 (---------------)  + I kembuchi
	0x002ec587, // n0x0beb c0x0000 (---------------)  + I kikonai
	0x0037ff09, // n0x0bec c0x0000 (---------------)  + I kimobetsu
	0x0031700d, // n0x0bed c0x0000 (---------------)  + I kitahiroshima
	0x0028c006, // n0x0bee c0x0000 (---------------)  + I kitami
	0x00308208, // n0x0bef c0x0000 (---------------)  + I kiyosato
	0x002e6bc9, // n0x0bf0 c0x0000 (---------------)  + I koshimizu
	0x002a9608, // n0x0bf1 c0x0000 (---------------)  + I kunneppu
	0x0027c208, // n0x0bf2 c0x0000 (---------------)  + I kuriyama
	0x002ab70c, // n0x0bf3 c0x0000 (---------------)  + I kuromatsunai
	0x002ae4c7, // n0x0bf4 c0x0000 (---------------)  + I kushiro
	0x002af107, // n0x0bf5 c0x0000 (---------------)  + I kutchan
	0x002b1cc5, // n0x0bf6 c0x0000 (---------------)  + I kyowa
	0x0024c447, // n0x0bf7 c0x0000 (---------------)  + I mashike
	0x002b2208, // n0x0bf8 c0x0000 (---------------)  + I matsumae
	0x002c8986, // n0x0bf9 c0x0000 (---------------)  + I mikasa
	0x00247e4c, // n0x0bfa c0x0000 (---------------)  + I minamifurano
	0x002d15c8, // n0x0bfb c0x0000 (---------------)  + I mombetsu
	0x002bbcc8, // n0x0bfc c0x0000 (---------------)  + I moseushi
	0x00203b06, // n0x0bfd c0x0000 (---------------)  + I mukawa
	0x0025c307, // n0x0bfe c0x0000 (---------------)  + I muroran
	0x00240184, // n0x0bff c0x0000 (---------------)  + I naie
	0x00276cc8, // n0x0c00 c0x0000 (---------------)  + I nakagawa
	0x0028530c, // n0x0c01 c0x0000 (---------------)  + I nakasatsunai
	0x0022b9cc, // n0x0c02 c0x0000 (---------------)  + I nakatombetsu
	0x00229205, // n0x0c03 c0x0000 (---------------)  + I nanae
	0x0037ee47, // n0x0c04 c0x0000 (---------------)  + I nanporo
	0x00206846, // n0x0c05 c0x0000 (---------------)  + I nayoro
	0x0025c286, // n0x0c06 c0x0000 (---------------)  + I nemuro
	0x002d8ec8, // n0x0c07 c0x0000 (---------------)  + I niikappu
	0x0029b204, // n0x0c08 c0x0000 (---------------)  + I niki
	0x00221a4b, // n0x0c09 c0x0000 (---------------)  + I nishiokoppe
	0x0030a4cb, // n0x0c0a c0x0000 (---------------)  + I noboribetsu
	0x002d6dc6, // n0x0c0b c0x0000 (---------------)  + I numata
	0x00344547, // n0x0c0c c0x0000 (---------------)  + I obihiro
	0x0035f745, // n0x0c0d c0x0000 (---------------)  + I obira
	0x002690c5, // n0x0c0e c0x0000 (---------------)  + I oketo
	0x00221b86, // n0x0c0f c0x0000 (---------------)  + I okoppe
	0x002da305, // n0x0c10 c0x0000 (---------------)  + I otaru
	0x00263045, // n0x0c11 c0x0000 (---------------)  + I otobe
	0x002b3807, // n0x0c12 c0x0000 (---------------)  + I otofuke
	0x00268c49, // n0x0c13 c0x0000 (---------------)  + I otoineppu
	0x002ed344, // n0x0c14 c0x0000 (---------------)  + I oumu
	0x002fb245, // n0x0c15 c0x0000 (---------------)  + I ozora
	0x002c95c5, // n0x0c16 c0x0000 (---------------)  + I pippu
	0x0025c408, // n0x0c17 c0x0000 (---------------)  + I rankoshi
	0x0030ae05, // n0x0c18 c0x0000 (---------------)  + I rebun
	0x00289f89, // n0x0c19 c0x0000 (---------------)  + I rikubetsu
	0x002cb087, // n0x0c1a c0x0000 (---------------)  + I rishiri
	0x002cb08b, // n0x0c1b c0x0000 (---------------)  + I rishirifuji
	0x0022a946, // n0x0c1c c0x0000 (---------------)  + I saroma
	0x0024d4c9, // n0x0c1d c0x0000 (---------------)  + I sarufutsu
	0x0029bc08, // n0x0c1e c0x0000 (---------------)  + I shakotan
	0x002a7e85, // n0x0c1f c0x0000 (---------------)  + I shari
	0x002edd88, // n0x0c20 c0x0000 (---------------)  + I shibecha
	0x00238fc8, // n0x0c21 c0x0000 (---------------)  + I shibetsu
	0x0021ca47, // n0x0c22 c0x0000 (---------------)  + I shikabe
	0x00239447, // n0x0c23 c0x0000 (---------------)  + I shikaoi
	0x002712c9, // n0x0c24 c0x0000 (---------------)  + I shimamaki
	0x00223607, // n0x0c25 c0x0000 (---------------)  + I shimizu
	0x002d5349, // n0x0c26 c0x0000 (---------------)  + I shimokawa
	0x002bcc0c, // n0x0c27 c0x0000 (---------------)  + I shinshinotsu
	0x002c68c8, // n0x0c28 c0x0000 (---------------)  + I shintoku
	0x002ea8c9, // n0x0c29 c0x0000 (---------------)  + I shiranuka
	0x002d3ec7, // n0x0c2a c0x0000 (---------------)  + I shiraoi
	0x00279fc9, // n0x0c2b c0x0000 (---------------)  + I shiriuchi
	0x003805c7, // n0x0c2c c0x0000 (---------------)  + I sobetsu
	0x002a3f08, // n0x0c2d c0x0000 (---------------)  + I sunagawa
	0x00332845, // n0x0c2e c0x0000 (---------------)  + I taiki
	0x002b6a86, // n0x0c2f c0x0000 (---------------)  + I takasu
	0x002ac448, // n0x0c30 c0x0000 (---------------)  + I takikawa
	0x002560c8, // n0x0c31 c0x0000 (---------------)  + I takinoue
	0x002b4949, // n0x0c32 c0x0000 (---------------)  + I teshikaga
	0x00263087, // n0x0c33 c0x0000 (---------------)  + I tobetsu
	0x0026b385, // n0x0c34 c0x0000 (---------------)  + I tohma
	0x002d0a49, // n0x0c35 c0x0000 (---------------)  + I tomakomai
	0x002468c6, // n0x0c36 c0x0000 (---------------)  + I tomari
	0x002873c4, // n0x0c37 c0x0000 (---------------)  + I toya
	0x002f4246, // n0x0c38 c0x0000 (---------------)  + I toyako
	0x00247448, // n0x0c39 c0x0000 (---------------)  + I toyotomi
	0x00256b47, // n0x0c3a c0x0000 (---------------)  + I toyoura
	0x0025dcc8, // n0x0c3b c0x0000 (---------------)  + I tsubetsu
	0x0020f689, // n0x0c3c c0x0000 (---------------)  + I tsukigata
	0x002fc647, // n0x0c3d c0x0000 (---------------)  + I urakawa
	0x00292dc6, // n0x0c3e c0x0000 (---------------)  + I urausu
	0x00211fc4, // n0x0c3f c0x0000 (---------------)  + I uryu
	0x00208849, // n0x0c40 c0x0000 (---------------)  + I utashinai
	0x002377c8, // n0x0c41 c0x0000 (---------------)  + I wakkanai
	0x002039c7, // n0x0c42 c0x0000 (---------------)  + I wassamu
	0x002fb786, // n0x0c43 c0x0000 (---------------)  + I yakumo
	0x0029c4c6, // n0x0c44 c0x0000 (---------------)  + I yoichi
	0x002ec6c4, // n0x0c45 c0x0000 (---------------)  + I aioi
	0x002b3506, // n0x0c46 c0x0000 (---------------)  + I akashi
	0x00210603, // n0x0c47 c0x0000 (---------------)  + I ako
	0x00378049, // n0x0c48 c0x0000 (---------------)  + I amagasaki
	0x00207706, // n0x0c49 c0x0000 (---------------)  + I aogaki
	0x002aad85, // n0x0c4a c0x0000 (---------------)  + I asago
	0x00293506, // n0x0c4b c0x0000 (---------------)  + I ashiya
	0x002239c5, // n0x0c4c c0x0000 (---------------)  + I awaji
	0x00278dc8, // n0x0c4d c0x0000 (---------------)  + I fukusaki
	0x002d1f47, // n0x0c4e c0x0000 (---------------)  + I goshiki
	0x003604c6, // n0x0c4f c0x0000 (---------------)  + I harima
	0x00206d46, // n0x0c50 c0x0000 (---------------)  + I himeji
	0x0034fec8, // n0x0c51 c0x0000 (---------------)  + I ichikawa
	0x00295747, // n0x0c52 c0x0000 (---------------)  + I inagawa
	0x0028c045, // n0x0c53 c0x0000 (---------------)  + I itami
	0x00293a08, // n0x0c54 c0x0000 (---------------)  + I kakogawa
	0x003563c8, // n0x0c55 c0x0000 (---------------)  + I kamigori
	0x00334ec8, // n0x0c56 c0x0000 (---------------)  + I kamikawa
	0x0024d905, // n0x0c57 c0x0000 (---------------)  + I kasai
	0x002b6b06, // n0x0c58 c0x0000 (---------------)  + I kasuga
	0x00230389, // n0x0c59 c0x0000 (---------------)  + I kawanishi
	0x002a2684, // n0x0c5a c0x0000 (---------------)  + I miki
	0x0022384b, // n0x0c5b c0x0000 (---------------)  + I minamiawaji
	0x0021bf8b, // n0x0c5c c0x0000 (---------------)  + I nishinomiya
	0x00225389, // n0x0c5d c0x0000 (---------------)  + I nishiwaki
	0x00210683, // n0x0c5e c0x0000 (---------------)  + I ono
	0x00253cc5, // n0x0c5f c0x0000 (---------------)  + I sanda
	0x00351146, // n0x0c60 c0x0000 (---------------)  + I sannan
	0x0024ee88, // n0x0c61 c0x0000 (---------------)  + I sasayama
	0x00265c04, // n0x0c62 c0x0000 (---------------)  + I sayo
	0x00227206, // n0x0c63 c0x0000 (---------------)  + I shingu
	0x002bee89, // n0x0c64 c0x0000 (---------------)  + I shinonsen
	0x002e5305, // n0x0c65 c0x0000 (---------------)  + I shiso
	0x002b3746, // n0x0c66 c0x0000 (---------------)  + I sumoto
	0x00384e06, // n0x0c67 c0x0000 (---------------)  + I taishi
	0x0020ed04, // n0x0c68 c0x0000 (---------------)  + I taka
	0x0036a04a, // n0x0c69 c0x0000 (---------------)  + I takarazuka
	0x002aacc8, // n0x0c6a c0x0000 (---------------)  + I takasago
	0x002560c6, // n0x0c6b c0x0000 (---------------)  + I takino
	0x002fb045, // n0x0c6c c0x0000 (---------------)  + I tamba
	0x00217107, // n0x0c6d c0x0000 (---------------)  + I tatsuno
	0x0022fec7, // n0x0c6e c0x0000 (---------------)  + I toyooka
	0x0025c684, // n0x0c6f c0x0000 (---------------)  + I yabu
	0x0021c1c7, // n0x0c70 c0x0000 (---------------)  + I yashiro
	0x002a6844, // n0x0c71 c0x0000 (---------------)  + I yoka
	0x00302946, // n0x0c72 c0x0000 (---------------)  + I yokawa
	0x00216cc3, // n0x0c73 c0x0000 (---------------)  + I ami
	0x002b1e85, // n0x0c74 c0x0000 (---------------)  + I asahi
	0x0032ca45, // n0x0c75 c0x0000 (---------------)  + I bando
	0x00380288, // n0x0c76 c0x0000 (---------------)  + I chikusei
	0x00269b45, // n0x0c77 c0x0000 (---------------)  + I daigo
	0x00272e89, // n0x0c78 c0x0000 (---------------)  + I fujishiro
	0x00276b07, // n0x0c79 c0x0000 (---------------)  + I hitachi
	0x00276b0b, // n0x0c7a c0x0000 (---------------)  + I hitachinaka
	0x002975cc, // n0x0c7b c0x0000 (---------------)  + I hitachiomiya
	0x00297c0a, // n0x0c7c c0x0000 (---------------)  + I hitachiota
	0x00316ec7, // n0x0c7d c0x0000 (---------------)  + I ibaraki
	0x00208983, // n0x0c7e c0x0000 (---------------)  + I ina
	0x00299a48, // n0x0c7f c0x0000 (---------------)  + I inashiki
	0x0024dac5, // n0x0c80 c0x0000 (---------------)  + I itako
	0x002043c5, // n0x0c81 c0x0000 (---------------)  + I iwama
	0x00210744, // n0x0c82 c0x0000 (---------------)  + I joso
	0x002a3e06, // n0x0c83 c0x0000 (---------------)  + I kamisu
	0x002cc906, // n0x0c84 c0x0000 (---------------)  + I kasama
	0x002b3547, // n0x0c85 c0x0000 (---------------)  + I kashima
	0x00200e4b, // n0x0c86 c0x0000 (---------------)  + I kasumigaura
	0x00293a84, // n0x0c87 c0x0000 (---------------)  + I koga
	0x002df804, // n0x0c88 c0x0000 (---------------)  + I miho
	0x00258284, // n0x0c89 c0x0000 (---------------)  + I mito
	0x002ba386, // n0x0c8a c0x0000 (---------------)  + I moriya
	0x00201984, // n0x0c8b c0x0000 (---------------)  + I naka
	0x002b3348, // n0x0c8c c0x0000 (---------------)  + I namegata
	0x0031ce85, // n0x0c8d c0x0000 (---------------)  + I oarai
	0x00228905, // n0x0c8e c0x0000 (---------------)  + I ogawa
	0x002a18c7, // n0x0c8f c0x0000 (---------------)  + I omitama
	0x00212009, // n0x0c90 c0x0000 (---------------)  + I ryugasaki
	0x00327d85, // n0x0c91 c0x0000 (---------------)  + I sakai
	0x0020e0ca, // n0x0c92 c0x0000 (---------------)  + I sakuragawa
	0x00294e89, // n0x0c93 c0x0000 (---------------)  + I shimodate
	0x002a8b8a, // n0x0c94 c0x0000 (---------------)  + I shimotsuma
	0x00213289, // n0x0c95 c0x0000 (---------------)  + I shirosato
	0x002d90c4, // n0x0c96 c0x0000 (---------------)  + I sowa
	0x002e7e45, // n0x0c97 c0x0000 (---------------)  + I suifu
	0x002dd448, // n0x0c98 c0x0000 (---------------)  + I takahagi
	0x0030c64b, // n0x0c99 c0x0000 (---------------)  + I tamatsukuri
	0x002f1d45, // n0x0c9a c0x0000 (---------------)  + I tokai
	0x00344dc6, // n0x0c9b c0x0000 (---------------)  + I tomobe
	0x00216684, // n0x0c9c c0x0000 (---------------)  + I tone
	0x002733c6, // n0x0c9d c0x0000 (---------------)  + I toride
	0x002fc4c9, // n0x0c9e c0x0000 (---------------)  + I tsuchiura
	0x002fa807, // n0x0c9f c0x0000 (---------------)  + I tsukuba
	0x0026e288, // n0x0ca0 c0x0000 (---------------)  + I uchihara
	0x00286f46, // n0x0ca1 c0x0000 (---------------)  + I ushiku
	0x00202a47, // n0x0ca2 c0x0000 (---------------)  + I yachiyo
	0x002797c8, // n0x0ca3 c0x0000 (---------------)  + I yamagata
	0x00355e86, // n0x0ca4 c0x0000 (---------------)  + I yawara
	0x00383544, // n0x0ca5 c0x0000 (---------------)  + I yuki
	0x0033b707, // n0x0ca6 c0x0000 (---------------)  + I anamizu
	0x0032aa05, // n0x0ca7 c0x0000 (---------------)  + I hakui
	0x0033c0c7, // n0x0ca8 c0x0000 (---------------)  + I hakusan
	0x002038c4, // n0x0ca9 c0x0000 (---------------)  + I kaga
	0x00273786, // n0x0caa c0x0000 (---------------)  + I kahoku
	0x00204b88, // n0x0cab c0x0000 (---------------)  + I kanazawa
	0x0028bd88, // n0x0cac c0x0000 (---------------)  + I kawakita
	0x00307e47, // n0x0cad c0x0000 (---------------)  + I komatsu
	0x00282c88, // n0x0cae c0x0000 (---------------)  + I nakanoto
	0x00288c05, // n0x0caf c0x0000 (---------------)  + I nanao
	0x002104c4, // n0x0cb0 c0x0000 (---------------)  + I nomi
	0x0034fdc8, // n0x0cb1 c0x0000 (---------------)  + I nonoichi
	0x00282d84, // n0x0cb2 c0x0000 (---------------)  + I noto
	0x00218e85, // n0x0cb3 c0x0000 (---------------)  + I shika
	0x002df344, // n0x0cb4 c0x0000 (---------------)  + I suzu
	0x002fc007, // n0x0cb5 c0x0000 (---------------)  + I tsubata
	0x00363cc7, // n0x0cb6 c0x0000 (---------------)  + I tsurugi
	0x0027a108, // n0x0cb7 c0x0000 (---------------)  + I uchinada
	0x002c9706, // n0x0cb8 c0x0000 (---------------)  + I wajima
	0x00269ac5, // n0x0cb9 c0x0000 (---------------)  + I fudai
	0x00272c88, // n0x0cba c0x0000 (---------------)  + I fujisawa
	0x0026ae08, // n0x0cbb c0x0000 (---------------)  + I hanamaki
	0x00294749, // n0x0cbc c0x0000 (---------------)  + I hiraizumi
	0x0021c286, // n0x0cbd c0x0000 (---------------)  + I hirono
	0x00379cc8, // n0x0cbe c0x0000 (---------------)  + I ichinohe
	0x0020528a, // n0x0cbf c0x0000 (---------------)  + I ichinoseki
	0x0029b5c8, // n0x0cc0 c0x0000 (---------------)  + I iwaizumi
	0x0034f5c5, // n0x0cc1 c0x0000 (---------------)  + I iwate
	0x0036dd06, // n0x0cc2 c0x0000 (---------------)  + I joboji
	0x00294d48, // n0x0cc3 c0x0000 (---------------)  + I kamaishi
	0x002bddca, // n0x0cc4 c0x0000 (---------------)  + I kanegasaki
	0x002fa087, // n0x0cc5 c0x0000 (---------------)  + I karumai
	0x0027de85, // n0x0cc6 c0x0000 (---------------)  + I kawai
	0x002875c8, // n0x0cc7 c0x0000 (---------------)  + I kitakami
	0x00235604, // n0x0cc8 c0x0000 (---------------)  + I kuji
	0x00241bc6, // n0x0cc9 c0x0000 (---------------)  + I kunohe
	0x002af9c8, // n0x0cca c0x0000 (---------------)  + I kuzumaki
	0x00210546, // n0x0ccb c0x0000 (---------------)  + I miyako
	0x00364d08, // n0x0ccc c0x0000 (---------------)  + I mizusawa
	0x0020ef07, // n0x0ccd c0x0000 (---------------)  + I morioka
	0x0020ea06, // n0x0cce c0x0000 (---------------)  + I ninohe
	0x00238104, // n0x0ccf c0x0000 (---------------)  + I noda
	0x002a1dc7, // n0x0cd0 c0x0000 (---------------)  + I ofunato
	0x002f2e04, // n0x0cd1 c0x0000 (---------------)  + I oshu
	0x002fc487, // n0x0cd2 c0x0000 (---------------)  + I otsuchi
	0x002a1f8d, // n0x0cd3 c0x0000 (---------------)  + I rikuzentakata
	0x00225405, // n0x0cd4 c0x0000 (---------------)  + I shiwa
	0x002e9f8b, // n0x0cd5 c0x0000 (---------------)  + I shizukuishi
	0x00292346, // n0x0cd6 c0x0000 (---------------)  + I sumita
	0x0024e348, // n0x0cd7 c0x0000 (---------------)  + I tanohata
	0x003793c4, // n0x0cd8 c0x0000 (---------------)  + I tono
	0x0020d986, // n0x0cd9 c0x0000 (---------------)  + I yahaba
	0x002766c6, // n0x0cda c0x0000 (---------------)  + I yamada
	0x0026f707, // n0x0cdb c0x0000 (---------------)  + I ayagawa
	0x0028b40d, // n0x0cdc c0x0000 (---------------)  + I higashikagawa
	0x002d9707, // n0x0cdd c0x0000 (---------------)  + I kanonji
	0x002fdb88, // n0x0cde c0x0000 (---------------)  + I kotohira
	0x00272085, // n0x0cdf c0x0000 (---------------)  + I manno
	0x0028cb88, // n0x0ce0 c0x0000 (---------------)  + I marugame
	0x002b4286, // n0x0ce1 c0x0000 (---------------)  + I mitoyo
	0x00288c88, // n0x0ce2 c0x0000 (---------------)  + I naoshima
	0x0023f706, // n0x0ce3 c0x0000 (---------------)  + I sanuki
	0x00363bc7, // n0x0ce4 c0x0000 (---------------)  + I tadotsu
	0x00358b09, // n0x0ce5 c0x0000 (---------------)  + I takamatsu
	0x003793c7, // n0x0ce6 c0x0000 (---------------)  + I tonosho
	0x00280b08, // n0x0ce7 c0x0000 (---------------)  + I uchinomi
	0x0026cd85, // n0x0ce8 c0x0000 (---------------)  + I utazu
	0x0021b648, // n0x0ce9 c0x0000 (---------------)  + I zentsuji
	0x0025c1c5, // n0x0cea c0x0000 (---------------)  + I akune
	0x00249405, // n0x0ceb c0x0000 (---------------)  + I amami
	0x00345145, // n0x0cec c0x0000 (---------------)  + I hioki
	0x00213e43, // n0x0ced c0x0000 (---------------)  + I isa
	0x0020e944, // n0x0cee c0x0000 (---------------)  + I isen
	0x002395c5, // n0x0cef c0x0000 (---------------)  + I izumi
	0x00360c89, // n0x0cf0 c0x0000 (---------------)  + I kagoshima
	0x002e5446, // n0x0cf1 c0x0000 (---------------)  + I kanoya
	0x002c4b48, // n0x0cf2 c0x0000 (---------------)  + I kawanabe
	0x00239205, // n0x0cf3 c0x0000 (---------------)  + I kinko
	0x00348cc7, // n0x0cf4 c0x0000 (---------------)  + I kouyama
	0x0033548a, // n0x0cf5 c0x0000 (---------------)  + I makurazaki
	0x002b3689, // n0x0cf6 c0x0000 (---------------)  + I matsumoto
	0x002a5e8a, // n0x0cf7 c0x0000 (---------------)  + I minamitane
	0x002c0488, // n0x0cf8 c0x0000 (---------------)  + I nakatane
	0x0021d8cc, // n0x0cf9 c0x0000 (---------------)  + I nishinoomote
	0x0027ad4d, // n0x0cfa c0x0000 (---------------)  + I satsumasendai
	0x002d5583, // n0x0cfb c0x0000 (---------------)  + I soo
	0x00364c08, // n0x0cfc c0x0000 (---------------)  + I tarumizu
	0x0020bd05, // n0x0cfd c0x0000 (---------------)  + I yusui
	0x002c3d06, // n0x0cfe c0x0000 (---------------)  + I aikawa
	0x00330e46, // n0x0cff c0x0000 (---------------)  + I atsugi
	0x002d1c85, // n0x0d00 c0x0000 (---------------)  + I ayase
	0x0029acc9, // n0x0d01 c0x0000 (---------------)  + I chigasaki
	0x00383b05, // n0x0d02 c0x0000 (---------------)  + I ebina
	0x00272c88, // n0x0d03 c0x0000 (---------------)  + I fujisawa
	0x00283106, // n0x0d04 c0x0000 (---------------)  + I hadano
	0x00320a86, // n0x0d05 c0x0000 (---------------)  + I hakone
	0x002967c9, // n0x0d06 c0x0000 (---------------)  + I hiratsuka
	0x00357b07, // n0x0d07 c0x0000 (---------------)  + I isehara
	0x002d6806, // n0x0d08 c0x0000 (---------------)  + I kaisei
	0x00335408, // n0x0d09 c0x0000 (---------------)  + I kamakura
	0x003028c8, // n0x0d0a c0x0000 (---------------)  + I kiyokawa
	0x00345dc7, // n0x0d0b c0x0000 (---------------)  + I matsuda
	0x0028f5ce, // n0x0d0c c0x0000 (---------------)  + I minamiashigara
	0x002b44c5, // n0x0d0d c0x0000 (---------------)  + I miura
	0x0032d505, // n0x0d0e c0x0000 (---------------)  + I nakai
	0x00210448, // n0x0d0f c0x0000 (---------------)  + I ninomiya
	0x00238147, // n0x0d10 c0x0000 (---------------)  + I odawara
	0x00205242, // n0x0d11 c0x0000 (---------------)  + I oi
	0x002ab204, // n0x0d12 c0x0000 (---------------)  + I oiso
	0x002af74a, // n0x0d13 c0x0000 (---------------)  + I sagamihara
	0x00203a88, // n0x0d14 c0x0000 (---------------)  + I samukawa
	0x002d7bc6, // n0x0d15 c0x0000 (---------------)  + I tsukui
	0x0028d288, // n0x0d16 c0x0000 (---------------)  + I yamakita
	0x00293606, // n0x0d17 c0x0000 (---------------)  + I yamato
	0x0036cf48, // n0x0d18 c0x0000 (---------------)  + I yokosuka
	0x002a0b08, // n0x0d19 c0x0000 (---------------)  + I yugawara
	0x002493c4, // n0x0d1a c0x0000 (---------------)  + I zama
	0x0035af85, // n0x0d1b c0x0000 (---------------)  + I zushi
	0x007242c4, // n0x0d1c c0x0001 (---------------)  ! I city
	0x007242c4, // n0x0d1d c0x0001 (---------------)  ! I city
	0x007242c4, // n0x0d1e c0x0001 (---------------)  ! I city
	0x002077c3, // n0x0d1f c0x0000 (---------------)  + I aki
	0x002ed186, // n0x0d20 c0x0000 (---------------)  + I geisei
	0x00273146, // n0x0d21 c0x0000 (---------------)  + I hidaka
	0x0029278c, // n0x0d22 c0x0000 (---------------)  + I higashitsuno
	0x00200c83, // n0x0d23 c0x0000 (---------------)  + I ino
	0x0027f346, // n0x0d24 c0x0000 (---------------)  + I kagami
	0x00225044, // n0x0d25 c0x0000 (---------------)  + I kami
	0x002bdfc8, // n0x0d26 c0x0000 (---------------)  + I kitagawa
	0x002becc5, // n0x0d27 c0x0000 (---------------)  + I kochi
	0x002af846, // n0x0d28 c0x0000 (---------------)  + I mihara
	0x002bf588, // n0x0d29 c0x0000 (---------------)  + I motoyama
	0x002c1506, // n0x0d2a c0x0000 (---------------)  + I muroto
	0x00360446, // n0x0d2b c0x0000 (---------------)  + I nahari
	0x00234008, // n0x0d2c c0x0000 (---------------)  + I nakamura
	0x00363e87, // n0x0d2d c0x0000 (---------------)  + I nankoku
	0x002233c9, // n0x0d2e c0x0000 (---------------)  + I nishitosa
	0x002287ca, // n0x0d2f c0x0000 (---------------)  + I niyodogawa
	0x0024fb04, // n0x0d30 c0x0000 (---------------)  + I ochi
	0x00230345, // n0x0d31 c0x0000 (---------------)  + I okawa
	0x002bc5c5, // n0x0d32 c0x0000 (---------------)  + I otoyo
	0x00322a46, // n0x0d33 c0x0000 (---------------)  + I otsuki
	0x0024fdc6, // n0x0d34 c0x0000 (---------------)  + I sakawa
	0x002931c6, // n0x0d35 c0x0000 (---------------)  + I sukumo
	0x002de606, // n0x0d36 c0x0000 (---------------)  + I susaki
	0x00223504, // n0x0d37 c0x0000 (---------------)  + I tosa
	0x0022350b, // n0x0d38 c0x0000 (---------------)  + I tosashimizu
	0x0022fec4, // n0x0d39 c0x0000 (---------------)  + I toyo
	0x00217185, // n0x0d3a c0x0000 (---------------)  + I tsuno
	0x0029f6c5, // n0x0d3b c0x0000 (---------------)  + I umaji
	0x00212386, // n0x0d3c c0x0000 (---------------)  + I yasuda
	0x00207d88, // n0x0d3d c0x0000 (---------------)  + I yusuhara
	0x0027ac07, // n0x0d3e c0x0000 (---------------)  + I amakusa
	0x00370044, // n0x0d3f c0x0000 (---------------)  + I arao
	0x0028ba43, // n0x0d40 c0x0000 (---------------)  + I aso
	0x002e6485, // n0x0d41 c0x0000 (---------------)  + I choyo
	0x00337407, // n0x0d42 c0x0000 (---------------)  + I gyokuto
	0x00298389, // n0x0d43 c0x0000 (---------------)  + I hitoyoshi
	0x0027ab0b, // n0x0d44 c0x0000 (---------------)  + I kamiamakusa
	0x002b3547, // n0x0d45 c0x0000 (---------------)  + I kashima
	0x0026f407, // n0x0d46 c0x0000 (---------------)  + I kikuchi
	0x002ddbc4, // n0x0d47 c0x0000 (---------------)  + I kosa
	0x002bf488, // n0x0d48 c0x0000 (---------------)  + I kumamoto
	0x003080c7, // n0x0d49 c0x0000 (---------------)  + I mashiki
	0x0028ddc6, // n0x0d4a c0x0000 (---------------)  + I mifune
	0x00255f48, // n0x0d4b c0x0000 (---------------)  + I minamata
	0x002ba04b, // n0x0d4c c0x0000 (---------------)  + I minamioguni
	0x00375a06, // n0x0d4d c0x0000 (---------------)  + I nagasu
	0x00217509, // n0x0d4e c0x0000 (---------------)  + I nishihara
	0x002ba1c5, // n0x0d4f c0x0000 (---------------)  + I oguni
	0x00347343, // n0x0d50 c0x0000 (---------------)  + I ozu
	0x002b3746, // n0x0d51 c0x0000 (---------------)  + I sumoto
	0x0020ee08, // n0x0d52 c0x0000 (---------------)  + I takamori
	0x0020f703, // n0x0d53 c0x0000 (---------------)  + I uki
	0x00262c83, // n0x0d54 c0x0000 (---------------)  + I uto
	0x002797c6, // n0x0d55 c0x0000 (---------------)  + I yamaga
	0x00293606, // n0x0d56 c0x0000 (---------------)  + I yamato
	0x0034e90a, // n0x0d57 c0x0000 (---------------)  + I yatsushiro
	0x002759c5, // n0x0d58 c0x0000 (---------------)  + I ayabe
	0x0027650b, // n0x0d59 c0x0000 (---------------)  + I fukuchiyama
	0x0029344b, // n0x0d5a c0x0000 (---------------)  + I higashiyama
	0x00207c83, // n0x0d5b c0x0000 (---------------)  + I ide
	0x0021e883, // n0x0d5c c0x0000 (---------------)  + I ine
	0x002a2384, // n0x0d5d c0x0000 (---------------)  + I joyo
	0x0020f207, // n0x0d5e c0x0000 (---------------)  + I kameoka
	0x0020ee84, // n0x0d5f c0x0000 (---------------)  + I kamo
	0x0020ec84, // n0x0d60 c0x0000 (---------------)  + I kita
	0x00314fc4, // n0x0d61 c0x0000 (---------------)  + I kizu
	0x0029b8c8, // n0x0d62 c0x0000 (---------------)  + I kumiyama
	0x002faf88, // n0x0d63 c0x0000 (---------------)  + I kyotamba
	0x00211009, // n0x0d64 c0x0000 (---------------)  + I kyotanabe
	0x002bc948, // n0x0d65 c0x0000 (---------------)  + I kyotango
	0x00360e47, // n0x0d66 c0x0000 (---------------)  + I maizuru
	0x00216c06, // n0x0d67 c0x0000 (---------------)  + I minami
	0x002c478f, // n0x0d68 c0x0000 (---------------)  + I minamiyamashiro
	0x002b4606, // n0x0d69 c0x0000 (---------------)  + I miyazu
	0x002bec44, // n0x0d6a c0x0000 (---------------)  + I muko
	0x002fadca, // n0x0d6b c0x0000 (---------------)  + I nagaokakyo
	0x00337307, // n0x0d6c c0x0000 (---------------)  + I nakagyo
	0x002ca886, // n0x0d6d c0x0000 (---------------)  + I nantan
	0x00287409, // n0x0d6e c0x0000 (---------------)  + I oyamazaki
	0x00210f85, // n0x0d6f c0x0000 (---------------)  + I sakyo
	0x002cb685, // n0x0d70 c0x0000 (---------------)  + I seika
	0x002110c6, // n0x0d71 c0x0000 (---------------)  + I tanabe
	0x0021b783, // n0x0d72 c0x0000 (---------------)  + I uji
	0x00235649, // n0x0d73 c0x0000 (---------------)  + I ujitawara
	0x0021a406, // n0x0d74 c0x0000 (---------------)  + I wazuka
	0x0020f449, // n0x0d75 c0x0000 (---------------)  + I yamashina
	0x00358306, // n0x0d76 c0x0000 (---------------)  + I yawata
	0x002b1e85, // n0x0d77 c0x0000 (---------------)  + I asahi
	0x0020b185, // n0x0d78 c0x0000 (---------------)  + I inabe
	0x0020e943, // n0x0d79 c0x0000 (---------------)  + I ise
	0x0020f348, // n0x0d7a c0x0000 (---------------)  + I kameyama
	0x0024fe47, // n0x0d7b c0x0000 (---------------)  + I kawagoe
	0x0029b284, // n0x0d7c c0x0000 (---------------)  + I kiho
	0x00322b48, // n0x0d7d c0x0000 (---------------)  + I kisosaki
	0x002df584, // n0x0d7e c0x0000 (---------------)  + I kiwa
	0x002a4986, // n0x0d7f c0x0000 (---------------)  + I komono
	0x002b5ec6, // n0x0d80 c0x0000 (---------------)  + I kumano
	0x0023f446, // n0x0d81 c0x0000 (---------------)  + I kuwana
	0x002baec9, // n0x0d82 c0x0000 (---------------)  + I matsusaka
	0x00204345, // n0x0d83 c0x0000 (---------------)  + I meiwa
	0x002985c6, // n0x0d84 c0x0000 (---------------)  + I mihama
	0x00255749, // n0x0d85 c0x0000 (---------------)  + I minamiise
	0x002b30c6, // n0x0d86 c0x0000 (---------------)  + I misugi
	0x0029b946, // n0x0d87 c0x0000 (---------------)  + I miyama
	0x00352b86, // n0x0d88 c0x0000 (---------------)  + I nabari
	0x00213545, // n0x0d89 c0x0000 (---------------)  + I shima
	0x002df346, // n0x0d8a c0x0000 (---------------)  + I suzuka
	0x00363bc4, // n0x0d8b c0x0000 (---------------)  + I tado
	0x00332845, // n0x0d8c c0x0000 (---------------)  + I taiki
	0x002560c4, // n0x0d8d c0x0000 (---------------)  + I taki
	0x00314ec6, // n0x0d8e c0x0000 (---------------)  + I tamaki
	0x00285e44, // n0x0d8f c0x0000 (---------------)  + I toba
	0x00201a83, // n0x0d90 c0x0000 (---------------)  + I tsu
	0x0027fd85, // n0x0d91 c0x0000 (---------------)  + I udono
	0x00238cc8, // n0x0d92 c0x0000 (---------------)  + I ureshino
	0x00342a07, // n0x0d93 c0x0000 (---------------)  + I watarai
	0x00265c89, // n0x0d94 c0x0000 (---------------)  + I yokkaichi
	0x0027ffc8, // n0x0d95 c0x0000 (---------------)  + I furukawa
	0x0028c7d1, // n0x0d96 c0x0000 (---------------)  + I higashimatsushima
	0x00384e8a, // n0x0d97 c0x0000 (---------------)  + I ishinomaki
	0x002d6d07, // n0x0d98 c0x0000 (---------------)  + I iwanuma
	0x002cb746, // n0x0d99 c0x0000 (---------------)  + I kakuda
	0x00225044, // n0x0d9a c0x0000 (---------------)  + I kami
	0x002ac548, // n0x0d9b c0x0000 (---------------)  + I kawasaki
	0x00375b89, // n0x0d9c c0x0000 (---------------)  + I kesennuma
	0x00356788, // n0x0d9d c0x0000 (---------------)  + I marumori
	0x0028c98a, // n0x0d9e c0x0000 (---------------)  + I matsushima
	0x00289d4d, // n0x0d9f c0x0000 (---------------)  + I minamisanriku
	0x002467c6, // n0x0da0 c0x0000 (---------------)  + I misato
	0x00234106, // n0x0da1 c0x0000 (---------------)  + I murata
	0x002a1e86, // n0x0da2 c0x0000 (---------------)  + I natori
	0x00305507, // n0x0da3 c0x0000 (---------------)  + I ogawara
	0x002fdc45, // n0x0da4 c0x0000 (---------------)  + I ohira
	0x00237687, // n0x0da5 c0x0000 (---------------)  + I onagawa
	0x00322c05, // n0x0da6 c0x0000 (---------------)  + I osaki
	0x002cb1c4, // n0x0da7 c0x0000 (---------------)  + I rifu
	0x002dc406, // n0x0da8 c0x0000 (---------------)  + I semine
	0x00369f07, // n0x0da9 c0x0000 (---------------)  + I shibata
	0x0023534d, // n0x0daa c0x0000 (---------------)  + I shichikashuku
	0x00294c87, // n0x0dab c0x0000 (---------------)  + I shikama
	0x00258548, // n0x0dac c0x0000 (---------------)  + I shiogama
	0x00272f89, // n0x0dad c0x0000 (---------------)  + I shiroishi
	0x0027e506, // n0x0dae c0x0000 (---------------)  + I tagajo
	0x0024e4c5, // n0x0daf c0x0000 (---------------)  + I taiwa
	0x00242084, // n0x0db0 c0x0000 (---------------)  + I tome
	0x00247546, // n0x0db1 c0x0000 (---------------)  + I tomiya
	0x002c3946, // n0x0db2 c0x0000 (---------------)  + I wakuya
	0x00203c06, // n0x0db3 c0x0000 (---------------)  + I watari
	0x00290788, // n0x0db4 c0x0000 (---------------)  + I yamamoto
	0x00213043, // n0x0db5 c0x0000 (---------------)  + I zao
	0x00203503, // n0x0db6 c0x0000 (---------------)  + I aya
	0x00200c05, // n0x0db7 c0x0000 (---------------)  + I ebino
	0x00269c06, // n0x0db8 c0x0000 (---------------)  + I gokase
	0x002a0ac5, // n0x0db9 c0x0000 (---------------)  + I hyuga
	0x00287148, // n0x0dba c0x0000 (---------------)  + I kadogawa
	0x00291e4a, // n0x0dbb c0x0000 (---------------)  + I kawaminami
	0x00207804, // n0x0dbc c0x0000 (---------------)  + I kijo
	0x002bdfc8, // n0x0dbd c0x0000 (---------------)  + I kitagawa
	0x0020ec88, // n0x0dbe c0x0000 (---------------)  + I kitakata
	0x002121c7, // n0x0dbf c0x0000 (---------------)  + I kitaura
	0x002392c9, // n0x0dc0 c0x0000 (---------------)  + I kobayashi
	0x002a8e08, // n0x0dc1 c0x0000 (---------------)  + I kunitomi
	0x002790c7, // n0x0dc2 c0x0000 (---------------)  + I kushima
	0x002aabc6, // n0x0dc3 c0x0000 (---------------)  + I mimata
	0x0021054a, // n0x0dc4 c0x0000 (---------------)  + I miyakonojo
	0x002475c8, // n0x0dc5 c0x0000 (---------------)  + I miyazaki
	0x002ad449, // n0x0dc6 c0x0000 (---------------)  + I morotsuka
	0x002aef08, // n0x0dc7 c0x0000 (---------------)  + I nichinan
	0x0021ac09, // n0x0dc8 c0x0000 (---------------)  + I nishimera
	0x002ad8c7, // n0x0dc9 c0x0000 (---------------)  + I nobeoka
	0x00261385, // n0x0dca c0x0000 (---------------)  + I saito
	0x003643c6, // n0x0dcb c0x0000 (---------------)  + I shiiba
	0x002c8808, // n0x0dcc c0x0000 (---------------)  + I shintomi
	0x00254cc8, // n0x0dcd c0x0000 (---------------)  + I takaharu
	0x0020f848, // n0x0dce c0x0000 (---------------)  + I takanabe
	0x00240a08, // n0x0dcf c0x0000 (---------------)  + I takazaki
	0x00217185, // n0x0dd0 c0x0000 (---------------)  + I tsuno
	0x00202a84, // n0x0dd1 c0x0000 (---------------)  + I achi
	0x0036f9c8, // n0x0dd2 c0x0000 (---------------)  + I agematsu
	0x00274b04, // n0x0dd3 c0x0000 (---------------)  + I anan
	0x00213084, // n0x0dd4 c0x0000 (---------------)  + I aoki
	0x002b1e85, // n0x0dd5 c0x0000 (---------------)  + I asahi
	0x00289087, // n0x0dd6 c0x0000 (---------------)  + I azumino
	0x00211dc9, // n0x0dd7 c0x0000 (---------------)  + I chikuhoku
	0x0026f507, // n0x0dd8 c0x0000 (---------------)  + I chikuma
	0x002052c5, // n0x0dd9 c0x0000 (---------------)  + I chino
	0x00270d06, // n0x0dda c0x0000 (---------------)  + I fujimi
	0x00327586, // n0x0ddb c0x0000 (---------------)  + I hakuba
	0x00203084, // n0x0ddc c0x0000 (---------------)  + I hara
	0x00296b06, // n0x0ddd c0x0000 (---------------)  + I hiraya
	0x00205904, // n0x0dde c0x0000 (---------------)  + I iida
	0x00288306, // n0x0ddf c0x0000 (---------------)  + I iijima
	0x00369446, // n0x0de0 c0x0000 (---------------)  + I iiyama
	0x00217d46, // n0x0de1 c0x0000 (---------------)  + I iizuna
	0x002056c5, // n0x0de2 c0x0000 (---------------)  + I ikeda
	0x00287007, // n0x0de3 c0x0000 (---------------)  + I ikusaka
	0x00208983, // n0x0de4 c0x0000 (---------------)  + I ina
	0x002da849, // n0x0de5 c0x0000 (---------------)  + I karuizawa
	0x002d6508, // n0x0de6 c0x0000 (---------------)  + I kawakami
	0x00278f44, // n0x0de7 c0x0000 (---------------)  + I kiso
	0x00278f4d, // n0x0de8 c0x0000 (---------------)  + I kisofukushima
	0x0028be88, // n0x0de9 c0x0000 (---------------)  + I kitaaiki
	0x0029be08, // n0x0dea c0x0000 (---------------)  + I komagane
	0x002ad3c6, // n0x0deb c0x0000 (---------------)  + I komoro
	0x00358c09, // n0x0dec c0x0000 (---------------)  + I matsukawa
	0x002b3689, // n0x0ded c0x0000 (---------------)  + I matsumoto
	0x002fc1c5, // n0x0dee c0x0000 (---------------)  + I miasa
	0x00291f4a, // n0x0def c0x0000 (---------------)  + I minamiaiki
	0x00267dca, // n0x0df0 c0x0000 (---------------)  + I minamimaki
	0x0027534c, // n0x0df1 c0x0000 (---------------)  + I minamiminowa
	0x002754c6, // n0x0df2 c0x0000 (---------------)  + I minowa
	0x00271cc6, // n0x0df3 c0x0000 (---------------)  + I miyada
	0x002b5086, // n0x0df4 c0x0000 (---------------)  + I miyota
	0x00265609, // n0x0df5 c0x0000 (---------------)  + I mochizuki
	0x0036fe86, // n0x0df6 c0x0000 (---------------)  + I nagano
	0x002376c6, // n0x0df7 c0x0000 (---------------)  + I nagawa
	0x00383bc6, // n0x0df8 c0x0000 (---------------)  + I nagiso
	0x00276cc8, // n0x0df9 c0x0000 (---------------)  + I nakagawa
	0x0026ac06, // n0x0dfa c0x0000 (---------------)  + I nakano
	0x0029794b, // n0x0dfb c0x0000 (---------------)  + I nozawaonsen
	0x00289205, // n0x0dfc c0x0000 (---------------)  + I obuse
	0x00228905, // n0x0dfd c0x0000 (---------------)  + I ogawa
	0x00271f45, // n0x0dfe c0x0000 (---------------)  + I okaya
	0x0025da06, // n0x0dff c0x0000 (---------------)  + I omachi
	0x00210503, // n0x0e00 c0x0000 (---------------)  + I omi
	0x0023f3c6, // n0x0e01 c0x0000 (---------------)  + I ookuwa
	0x00294c07, // n0x0e02 c0x0000 (---------------)  + I ooshika
	0x002ac405, // n0x0e03 c0x0000 (---------------)  + I otaki
	0x002446c5, // n0x0e04 c0x0000 (---------------)  + I otari
	0x002e18c5, // n0x0e05 c0x0000 (---------------)  + I sakae
	0x003023c6, // n0x0e06 c0x0000 (---------------)  + I sakaki
	0x0020d444, // n0x0e07 c0x0000 (---------------)  + I saku
	0x0020d446, // n0x0e08 c0x0000 (---------------)  + I sakuho
	0x002adc49, // n0x0e09 c0x0000 (---------------)  + I shimosuwa
	0x0025d88c, // n0x0e0a c0x0000 (---------------)  + I shinanomachi
	0x002caf08, // n0x0e0b c0x0000 (---------------)  + I shiojiri
	0x002add84, // n0x0e0c c0x0000 (---------------)  + I suwa
	0x002defc6, // n0x0e0d c0x0000 (---------------)  + I suzaka
	0x00292446, // n0x0e0e c0x0000 (---------------)  + I takagi
	0x0020ee08, // n0x0e0f c0x0000 (---------------)  + I takamori
	0x002d6ec8, // n0x0e10 c0x0000 (---------------)  + I takayama
	0x0025d789, // n0x0e11 c0x0000 (---------------)  + I tateshina
	0x00217107, // n0x0e12 c0x0000 (---------------)  + I tatsuno
	0x00273909, // n0x0e13 c0x0000 (---------------)  + I togakushi
	0x00269186, // n0x0e14 c0x0000 (---------------)  + I togura
	0x0022ebc4, // n0x0e15 c0x0000 (---------------)  + I tomi
	0x00211344, // n0x0e16 c0x0000 (---------------)  + I ueda
	0x00278cc4, // n0x0e17 c0x0000 (---------------)  + I wada
	0x002797c8, // n0x0e18 c0x0000 (---------------)  + I yamagata
	0x00211c0a, // n0x0e19 c0x0000 (---------------)  + I yamanouchi
	0x00327d06, // n0x0e1a c0x0000 (---------------)  + I yasaka
	0x00330c47, // n0x0e1b c0x0000 (---------------)  + I yasuoka
	0x00231987, // n0x0e1c c0x0000 (---------------)  + I chijiwa
	0x0024d5c5, // n0x0e1d c0x0000 (---------------)  + I futsu
	0x002bc584, // n0x0e1e c0x0000 (---------------)  + I goto
	0x00284ec6, // n0x0e1f c0x0000 (---------------)  + I hasami
	0x002fdc86, // n0x0e20 c0x0000 (---------------)  + I hirado
	0x00223ac3, // n0x0e21 c0x0000 (---------------)  + I iki
	0x002d6347, // n0x0e22 c0x0000 (---------------)  + I isahaya
	0x00202448, // n0x0e23 c0x0000 (---------------)  + I kawatana
	0x002fc30a, // n0x0e24 c0x0000 (---------------)  + I kuchinotsu
	0x002035c8, // n0x0e25 c0x0000 (---------------)  + I matsuura
	0x00276088, // n0x0e26 c0x0000 (---------------)  + I nagasaki
	0x00285e85, // n0x0e27 c0x0000 (---------------)  + I obama
	0x002573c5, // n0x0e28 c0x0000 (---------------)  + I omura
	0x00295d85, // n0x0e29 c0x0000 (---------------)  + I oseto
	0x0024d986, // n0x0e2a c0x0000 (---------------)  + I saikai
	0x00251a86, // n0x0e2b c0x0000 (---------------)  + I sasebo
	0x003803c5, // n0x0e2c c0x0000 (---------------)  + I seihi
	0x00378289, // n0x0e2d c0x0000 (---------------)  + I shimabara
	0x002bc38c, // n0x0e2e c0x0000 (---------------)  + I shinkamigoto
	0x002342c7, // n0x0e2f c0x0000 (---------------)  + I togitsu
	0x0028ca08, // n0x0e30 c0x0000 (---------------)  + I tsushima
	0x0026ce85, // n0x0e31 c0x0000 (---------------)  + I unzen
	0x007242c4, // n0x0e32 c0x0001 (---------------)  ! I city
	0x0032ca84, // n0x0e33 c0x0000 (---------------)  + I ando
	0x00271a04, // n0x0e34 c0x0000 (---------------)  + I gose
	0x00379e46, // n0x0e35 c0x0000 (---------------)  + I heguri
	0x00293fce, // n0x0e36 c0x0000 (---------------)  + I higashiyoshino
	0x0020aac7, // n0x0e37 c0x0000 (---------------)  + I ikaruga
	0x00305705, // n0x0e38 c0x0000 (---------------)  + I ikoma
	0x002a260c, // n0x0e39 c0x0000 (---------------)  + I kamikitayama
	0x002c92c7, // n0x0e3a c0x0000 (---------------)  + I kanmaki
	0x00369e87, // n0x0e3b c0x0000 (---------------)  + I kashiba
	0x0036b589, // n0x0e3c c0x0000 (---------------)  + I kashihara
	0x00219949, // n0x0e3d c0x0000 (---------------)  + I katsuragi
	0x0027de85, // n0x0e3e c0x0000 (---------------)  + I kawai
	0x002d6508, // n0x0e3f c0x0000 (---------------)  + I kawakami
	0x00230389, // n0x0e40 c0x0000 (---------------)  + I kawanishi
	0x002dba45, // n0x0e41 c0x0000 (---------------)  + I koryo
	0x002ac348, // n0x0e42 c0x0000 (---------------)  + I kurotaki
	0x002ba9c6, // n0x0e43 c0x0000 (---------------)  + I mitsue
	0x0030b246, // n0x0e44 c0x0000 (---------------)  + I miyake
	0x002e7784, // n0x0e45 c0x0000 (---------------)  + I nara
	0x00272148, // n0x0e46 c0x0000 (---------------)  + I nosegawa
	0x00254b43, // n0x0e47 c0x0000 (---------------)  + I oji
	0x0037e404, // n0x0e48 c0x0000 (---------------)  + I ouda
	0x002e6505, // n0x0e49 c0x0000 (---------------)  + I oyodo
	0x0020e647, // n0x0e4a c0x0000 (---------------)  + I sakurai
	0x002e6945, // n0x0e4b c0x0000 (---------------)  + I sango
	0x00205149, // n0x0e4c c0x0000 (---------------)  + I shimoichi
	0x002deb0d, // n0x0e4d c0x0000 (---------------)  + I shimokitayama
	0x002b9446, // n0x0e4e c0x0000 (---------------)  + I shinjo
	0x00358944, // n0x0e4f c0x0000 (---------------)  + I soni
	0x00218fc8, // n0x0e50 c0x0000 (---------------)  + I takatori
	0x00268a8a, // n0x0e51 c0x0000 (---------------)  + I tawaramoto
	0x00208587, // n0x0e52 c0x0000 (---------------)  + I tenkawa
	0x0026b6c5, // n0x0e53 c0x0000 (---------------)  + I tenri
	0x00212443, // n0x0e54 c0x0000 (---------------)  + I uda
	0x0029360e, // n0x0e55 c0x0000 (---------------)  + I yamatokoriyama
	0x002a280c, // n0x0e56 c0x0000 (---------------)  + I yamatotakada
	0x0029d147, // n0x0e57 c0x0000 (---------------)  + I yamazoe
	0x00294187, // n0x0e58 c0x0000 (---------------)  + I yoshino
	0x00203903, // n0x0e59 c0x0000 (---------------)  + I aga
	0x0036fec5, // n0x0e5a c0x0000 (---------------)  + I agano
	0x00271a05, // n0x0e5b c0x0000 (---------------)  + I gosen
	0x0028d648, // n0x0e5c c0x0000 (---------------)  + I itoigawa
	0x0028af09, // n0x0e5d c0x0000 (---------------)  + I izumozaki
	0x00202e06, // n0x0e5e c0x0000 (---------------)  + I joetsu
	0x0020ee84, // n0x0e5f c0x0000 (---------------)  + I kamo
	0x002d6c46, // n0x0e60 c0x0000 (---------------)  + I kariwa
	0x00382a4b, // n0x0e61 c0x0000 (---------------)  + I kashiwazaki
	0x002b8acc, // n0x0e62 c0x0000 (---------------)  + I minamiuonuma
	0x002778c7, // n0x0e63 c0x0000 (---------------)  + I mitsuke
	0x002be985, // n0x0e64 c0x0000 (---------------)  + I muika
	0x003562c8, // n0x0e65 c0x0000 (---------------)  + I murakami
	0x00345b85, // n0x0e66 c0x0000 (---------------)  + I myoko
	0x002fadc7, // n0x0e67 c0x0000 (---------------)  + I nagaoka
	0x003589c7, // n0x0e68 c0x0000 (---------------)  + I niigata
	0x00254b45, // n0x0e69 c0x0000 (---------------)  + I ojiya
	0x00210503, // n0x0e6a c0x0000 (---------------)  + I omi
	0x0035a204, // n0x0e6b c0x0000 (---------------)  + I sado
	0x00324485, // n0x0e6c c0x0000 (---------------)  + I sanjo
	0x002ed245, // n0x0e6d c0x0000 (---------------)  + I seiro
	0x002ed246, // n0x0e6e c0x0000 (---------------)  + I seirou
	0x002a2e48, // n0x0e6f c0x0000 (---------------)  + I sekikawa
	0x00369f07, // n0x0e70 c0x0000 (---------------)  + I shibata
	0x00331146, // n0x0e71 c0x0000 (---------------)  + I tagami
	0x002c3c06, // n0x0e72 c0x0000 (---------------)  + I tainai
	0x00345086, // n0x0e73 c0x0000 (---------------)  + I tochio
	0x00308389, // n0x0e74 c0x0000 (---------------)  + I tokamachi
	0x00237a47, // n0x0e75 c0x0000 (---------------)  + I tsubame
	0x00202c86, // n0x0e76 c0x0000 (---------------)  + I tsunan
	0x002b8c46, // n0x0e77 c0x0000 (---------------)  + I uonuma
	0x0026f046, // n0x0e78 c0x0000 (---------------)  + I yahiko
	0x002a2405, // n0x0e79 c0x0000 (---------------)  + I yoita
	0x0021ea86, // n0x0e7a c0x0000 (---------------)  + I yuzawa
	0x00375785, // n0x0e7b c0x0000 (---------------)  + I beppu
	0x0030ae88, // n0x0e7c c0x0000 (---------------)  + I bungoono
	0x0033e7cb, // n0x0e7d c0x0000 (---------------)  + I bungotakada
	0x00284cc6, // n0x0e7e c0x0000 (---------------)  + I hasama
	0x002319c4, // n0x0e7f c0x0000 (---------------)  + I hiji
	0x002d4509, // n0x0e80 c0x0000 (---------------)  + I himeshima
	0x00276b04, // n0x0e81 c0x0000 (---------------)  + I hita
	0x002ba948, // n0x0e82 c0x0000 (---------------)  + I kamitsue
	0x00295307, // n0x0e83 c0x0000 (---------------)  + I kokonoe
	0x0027c104, // n0x0e84 c0x0000 (---------------)  + I kuju
	0x002a6fc8, // n0x0e85 c0x0000 (---------------)  + I kunisaki
	0x002aec04, // n0x0e86 c0x0000 (---------------)  + I kusu
	0x002a2444, // n0x0e87 c0x0000 (---------------)  + I oita
	0x002d0805, // n0x0e88 c0x0000 (---------------)  + I saiki
	0x002e82c6, // n0x0e89 c0x0000 (---------------)  + I taketa
	0x0029b807, // n0x0e8a c0x0000 (---------------)  + I tsukumi
	0x00232883, // n0x0e8b c0x0000 (---------------)  + I usa
	0x00292e85, // n0x0e8c c0x0000 (---------------)  + I usuki
	0x00373e84, // n0x0e8d c0x0000 (---------------)  + I yufu
	0x0032d546, // n0x0e8e c0x0000 (---------------)  + I akaiwa
	0x002fc248, // n0x0e8f c0x0000 (---------------)  + I asakuchi
	0x00202185, // n0x0e90 c0x0000 (---------------)  + I bizen
	0x00288749, // n0x0e91 c0x0000 (---------------)  + I hayashima
	0x002d0c45, // n0x0e92 c0x0000 (---------------)  + I ibara
	0x0027f348, // n0x0e93 c0x0000 (---------------)  + I kagamino
	0x00363287, // n0x0e94 c0x0000 (---------------)  + I kasaoka
	0x00347188, // n0x0e95 c0x0000 (---------------)  + I kibichuo
	0x002a6687, // n0x0e96 c0x0000 (---------------)  + I kumenan
	0x00307049, // n0x0e97 c0x0000 (---------------)  + I kurashiki
	0x0026b446, // n0x0e98 c0x0000 (---------------)  + I maniwa
	0x002d73c6, // n0x0e99 c0x0000 (---------------)  + I misaki
	0x002e0584, // n0x0e9a c0x0000 (---------------)  + I nagi
	0x0028f505, // n0x0e9b c0x0000 (---------------)  + I niimi
	0x002eb04c, // n0x0e9c c0x0000 (---------------)  + I nishiawakura
	0x00271f47, // n0x0e9d c0x0000 (---------------)  + I okayama
	0x00272447, // n0x0e9e c0x0000 (---------------)  + I satosho
	0x00231848, // n0x0e9f c0x0000 (---------------)  + I setouchi
	0x002b9446, // n0x0ea0 c0x0000 (---------------)  + I shinjo
	0x00294b44, // n0x0ea1 c0x0000 (---------------)  + I shoo
	0x003335c4, // n0x0ea2 c0x0000 (---------------)  + I soja
	0x00271149, // n0x0ea3 c0x0000 (---------------)  + I takahashi
	0x002b5186, // n0x0ea4 c0x0000 (---------------)  + I tamano
	0x0021d547, // n0x0ea5 c0x0000 (---------------)  + I tsuyama
	0x0036da04, // n0x0ea6 c0x0000 (---------------)  + I wake
	0x00296c06, // n0x0ea7 c0x0000 (---------------)  + I yakage
	0x00382645, // n0x0ea8 c0x0000 (---------------)  + I aguni
	0x00292547, // n0x0ea9 c0x0000 (---------------)  + I ginowan
	0x002978c6, // n0x0eaa c0x0000 (---------------)  + I ginoza
	0x00256ec9, // n0x0eab c0x0000 (---------------)  + I gushikami
	0x002b9e87, // n0x0eac c0x0000 (---------------)  + I haebaru
	0x00260cc7, // n0x0ead c0x0000 (---------------)  + I higashi
	0x00296646, // n0x0eae c0x0000 (---------------)  + I hirara
	0x002fb6c5, // n0x0eaf c0x0000 (---------------)  + I iheya
	0x00278a08, // n0x0eb0 c0x0000 (---------------)  + I ishigaki
	0x0021a288, // n0x0eb1 c0x0000 (---------------)  + I ishikawa
	0x002fbb86, // n0x0eb2 c0x0000 (---------------)  + I itoman
	0x002021c5, // n0x0eb3 c0x0000 (---------------)  + I izena
	0x002b0946, // n0x0eb4 c0x0000 (---------------)  + I kadena
	0x00211b03, // n0x0eb5 c0x0000 (---------------)  + I kin
	0x0028d4c9, // n0x0eb6 c0x0000 (---------------)  + I kitadaito
	0x00292f4e, // n0x0eb7 c0x0000 (---------------)  + I kitanakagusuku
	0x002a6388, // n0x0eb8 c0x0000 (---------------)  + I kumejima
	0x002df688, // n0x0eb9 c0x0000 (---------------)  + I kunigami
	0x002fb98b, // n0x0eba c0x0000 (---------------)  + I minamidaito
	0x00288986, // n0x0ebb c0x0000 (---------------)  + I motobu
	0x0024fa44, // n0x0ebc c0x0000 (---------------)  + I nago
	0x0027a944, // n0x0ebd c0x0000 (---------------)  + I naha
	0x0029304a, // n0x0ebe c0x0000 (---------------)  + I nakagusuku
	0x00217887, // n0x0ebf c0x0000 (---------------)  + I nakijin
	0x00202d45, // n0x0ec0 c0x0000 (---------------)  + I nanjo
	0x00217509, // n0x0ec1 c0x0000 (---------------)  + I nishihara
	0x002aab05, // n0x0ec2 c0x0000 (---------------)  + I ogimi
	0x002130c7, // n0x0ec3 c0x0000 (---------------)  + I okinawa
	0x0020d704, // n0x0ec4 c0x0000 (---------------)  + I onna
	0x002e8d47, // n0x0ec5 c0x0000 (---------------)  + I shimoji
	0x00246648, // n0x0ec6 c0x0000 (---------------)  + I taketomi
	0x002e98c6, // n0x0ec7 c0x0000 (---------------)  + I tarama
	0x002f2fc9, // n0x0ec8 c0x0000 (---------------)  + I tokashiki
	0x002a8f0a, // n0x0ec9 c0x0000 (---------------)  + I tomigusuku
	0x00217806, // n0x0eca c0x0000 (---------------)  + I tonaki
	0x0028b9c6, // n0x0ecb c0x0000 (---------------)  + I urasoe
	0x0029f645, // n0x0ecc c0x0000 (---------------)  + I uruma
	0x0034b545, // n0x0ecd c0x0000 (---------------)  + I yaese
	0x00344387, // n0x0ece c0x0000 (---------------)  + I yomitan
	0x00365348, // n0x0ecf c0x0000 (---------------)  + I yonabaru
	0x00382588, // n0x0ed0 c0x0000 (---------------)  + I yonaguni
	0x002493c6, // n0x0ed1 c0x0000 (---------------)  + I zamami
	0x002ad045, // n0x0ed2 c0x0000 (---------------)  + I abeno
	0x0024fb4e, // n0x0ed3 c0x0000 (---------------)  + I chihayaakasaka
	0x00347284, // n0x0ed4 c0x0000 (---------------)  + I chuo
	0x0028d5c5, // n0x0ed5 c0x0000 (---------------)  + I daito
	0x00270689, // n0x0ed6 c0x0000 (---------------)  + I fujiidera
	0x0027dc88, // n0x0ed7 c0x0000 (---------------)  + I habikino
	0x00282846, // n0x0ed8 c0x0000 (---------------)  + I hannan
	0x0029040c, // n0x0ed9 c0x0000 (---------------)  + I higashiosaka
	0x00291a50, // n0x0eda c0x0000 (---------------)  + I higashisumiyoshi
	0x00293c0f, // n0x0edb c0x0000 (---------------)  + I higashiyodogawa
	0x002954c8, // n0x0edc c0x0000 (---------------)  + I hirakata
	0x00316ec7, // n0x0edd c0x0000 (---------------)  + I ibaraki
	0x002056c5, // n0x0ede c0x0000 (---------------)  + I ikeda
	0x002395c5, // n0x0edf c0x0000 (---------------)  + I izumi
	0x0029b689, // n0x0ee0 c0x0000 (---------------)  + I izumiotsu
	0x002877c9, // n0x0ee1 c0x0000 (---------------)  + I izumisano
	0x0023d286, // n0x0ee2 c0x0000 (---------------)  + I kadoma
	0x002f1dc7, // n0x0ee3 c0x0000 (---------------)  + I kaizuka
	0x0037edc5, // n0x0ee4 c0x0000 (---------------)  + I kanan
	0x00375e89, // n0x0ee5 c0x0000 (---------------)  + I kashiwara
	0x00317c46, // n0x0ee6 c0x0000 (---------------)  + I katano
	0x0036fccd, // n0x0ee7 c0x0000 (---------------)  + I kawachinagano
	0x00278b89, // n0x0ee8 c0x0000 (---------------)  + I kishiwada
	0x0020ec84, // n0x0ee9 c0x0000 (---------------)  + I kita
	0x002a6108, // n0x0eea c0x0000 (---------------)  + I kumatori
	0x0036fa89, // n0x0eeb c0x0000 (---------------)  + I matsubara
	0x00327ec6, // n0x0eec c0x0000 (---------------)  + I minato
	0x00270e05, // n0x0eed c0x0000 (---------------)  + I minoh
	0x002d73c6, // n0x0eee c0x0000 (---------------)  + I misaki
	0x0026e149, // n0x0eef c0x0000 (---------------)  + I moriguchi
	0x00236308, // n0x0ef0 c0x0000 (---------------)  + I neyagawa
	0x00215405, // n0x0ef1 c0x0000 (---------------)  + I nishi
	0x00205384, // n0x0ef2 c0x0000 (---------------)  + I nose
	0x002905cb, // n0x0ef3 c0x0000 (---------------)  + I osakasayama
	0x00327d85, // n0x0ef4 c0x0000 (---------------)  + I sakai
	0x0024ef06, // n0x0ef5 c0x0000 (---------------)  + I sayama
	0x0027b086, // n0x0ef6 c0x0000 (---------------)  + I sennan
	0x00290cc6, // n0x0ef7 c0x0000 (---------------)  + I settsu
	0x0032b20b, // n0x0ef8 c0x0000 (---------------)  + I shijonawate
	0x00288849, // n0x0ef9 c0x0000 (---------------)  + I shimamoto
	0x0030a705, // n0x0efa c0x0000 (---------------)  + I suita
	0x00346f47, // n0x0efb c0x0000 (---------------)  + I tadaoka
	0x00384e06, // n0x0efc c0x0000 (---------------)  + I taishi
	0x0027a486, // n0x0efd c0x0000 (---------------)  + I tajiri
	0x00271788, // n0x0efe c0x0000 (---------------)  + I takaishi
	0x003427c9, // n0x0eff c0x0000 (---------------)  + I takatsuki
	0x0025830c, // n0x0f00 c0x0000 (---------------)  + I tondabayashi
	0x00337208, // n0x0f01 c0x0000 (---------------)  + I toyonaka
	0x0037a286, // n0x0f02 c0x0000 (---------------)  + I toyono
	0x0031f2c3, // n0x0f03 c0x0000 (---------------)  + I yao
	0x00288ec6, // n0x0f04 c0x0000 (---------------)  + I ariake
	0x00306f05, // n0x0f05 c0x0000 (---------------)  + I arita
	0x00276848, // n0x0f06 c0x0000 (---------------)  + I fukudomi
	0x00229086, // n0x0f07 c0x0000 (---------------)  + I genkai
	0x0036a608, // n0x0f08 c0x0000 (---------------)  + I hamatama
	0x00216e05, // n0x0f09 c0x0000 (---------------)  + I hizen
	0x00317285, // n0x0f0a c0x0000 (---------------)  + I imari
	0x002ada08, // n0x0f0b c0x0000 (---------------)  + I kamimine
	0x002df447, // n0x0f0c c0x0000 (---------------)  + I kanzaki
	0x00330d87, // n0x0f0d c0x0000 (---------------)  + I karatsu
	0x002b3547, // n0x0f0e c0x0000 (---------------)  + I kashima
	0x00322cc8, // n0x0f0f c0x0000 (---------------)  + I kitagata
	0x00271488, // n0x0f10 c0x0000 (---------------)  + I kitahata
	0x0024c346, // n0x0f11 c0x0000 (---------------)  + I kiyama
	0x00314d07, // n0x0f12 c0x0000 (---------------)  + I kouhoku
	0x00269907, // n0x0f13 c0x0000 (---------------)  + I kyuragi
	0x0032af0a, // n0x0f14 c0x0000 (---------------)  + I nishiarita
	0x00234303, // n0x0f15 c0x0000 (---------------)  + I ogi
	0x0025da06, // n0x0f16 c0x0000 (---------------)  + I omachi
	0x00211d45, // n0x0f17 c0x0000 (---------------)  + I ouchi
	0x002af744, // n0x0f18 c0x0000 (---------------)  + I saga
	0x00272f89, // n0x0f19 c0x0000 (---------------)  + I shiroishi
	0x00306fc4, // n0x0f1a c0x0000 (---------------)  + I taku
	0x002e08c4, // n0x0f1b c0x0000 (---------------)  + I tara
	0x002922c4, // n0x0f1c c0x0000 (---------------)  + I tosu
	0x0029418b, // n0x0f1d c0x0000 (---------------)  + I yoshinogari
	0x0036fc07, // n0x0f1e c0x0000 (---------------)  + I arakawa
	0x0024fd85, // n0x0f1f c0x0000 (---------------)  + I asaka
	0x0028a5c8, // n0x0f20 c0x0000 (---------------)  + I chichibu
	0x00270d06, // n0x0f21 c0x0000 (---------------)  + I fujimi
	0x00270d08, // n0x0f22 c0x0000 (---------------)  + I fujimino
	0x00275906, // n0x0f23 c0x0000 (---------------)  + I fukaya
	0x00282f85, // n0x0f24 c0x0000 (---------------)  + I hanno
	0x00283845, // n0x0f25 c0x0000 (---------------)  + I hanyu
	0x00286386, // n0x0f26 c0x0000 (---------------)  + I hasuda
	0x00286a08, // n0x0f27 c0x0000 (---------------)  + I hatogaya
	0x00287348, // n0x0f28 c0x0000 (---------------)  + I hatoyama
	0x00273146, // n0x0f29 c0x0000 (---------------)  + I hidaka
	0x0028a40f, // n0x0f2a c0x0000 (---------------)  + I higashichichibu
	0x0028cf90, // n0x0f2b c0x0000 (---------------)  + I higashimatsuyama
	0x00206445, // n0x0f2c c0x0000 (---------------)  + I honjo
	0x00208983, // n0x0f2d c0x0000 (---------------)  + I ina
	0x00283b45, // n0x0f2e c0x0000 (---------------)  + I iruma
	0x00352cc8, // n0x0f2f c0x0000 (---------------)  + I iwatsuki
	0x002876c9, // n0x0f30 c0x0000 (---------------)  + I kamiizumi
	0x00334ec8, // n0x0f31 c0x0000 (---------------)  + I kamikawa
	0x002f43c8, // n0x0f32 c0x0000 (---------------)  + I kamisato
	0x00200488, // n0x0f33 c0x0000 (---------------)  + I kasukabe
	0x0024fe47, // n0x0f34 c0x0000 (---------------)  + I kawagoe
	0x002709c9, // n0x0f35 c0x0000 (---------------)  + I kawaguchi
	0x0036a808, // n0x0f36 c0x0000 (---------------)  + I kawajima
	0x002f7044, // n0x0f37 c0x0000 (---------------)  + I kazo
	0x00292148, // n0x0f38 c0x0000 (---------------)  + I kitamoto
	0x0025c4c9, // n0x0f39 c0x0000 (---------------)  + I koshigaya
	0x00337647, // n0x0f3a c0x0000 (---------------)  + I kounosu
	0x002a9104, // n0x0f3b c0x0000 (---------------)  + I kuki
	0x0026f5c8, // n0x0f3c c0x0000 (---------------)  + I kumagaya
	0x00286dca, // n0x0f3d c0x0000 (---------------)  + I matsubushi
	0x002c7006, // n0x0f3e c0x0000 (---------------)  + I minano
	0x002467c6, // n0x0f3f c0x0000 (---------------)  + I misato
	0x0021c149, // n0x0f40 c0x0000 (---------------)  + I miyashiro
	0x00291c87, // n0x0f41 c0x0000 (---------------)  + I miyoshi
	0x002bad48, // n0x0f42 c0x0000 (---------------)  + I moroyama
	0x002419c8, // n0x0f43 c0x0000 (---------------)  + I nagatoro
	0x002c37c8, // n0x0f44 c0x0000 (---------------)  + I namegawa
	0x0020c9c5, // n0x0f45 c0x0000 (---------------)  + I niiza
	0x002fcb45, // n0x0f46 c0x0000 (---------------)  + I ogano
	0x00228905, // n0x0f47 c0x0000 (---------------)  + I ogawa
	0x002719c5, // n0x0f48 c0x0000 (---------------)  + I ogose
	0x002b0047, // n0x0f49 c0x0000 (---------------)  + I okegawa
	0x00210505, // n0x0f4a c0x0000 (---------------)  + I omiya
	0x002ac405, // n0x0f4b c0x0000 (---------------)  + I otaki
	0x0037e886, // n0x0f4c c0x0000 (---------------)  + I ranzan
	0x00334e07, // n0x0f4d c0x0000 (---------------)  + I ryokami
	0x0030c587, // n0x0f4e c0x0000 (---------------)  + I saitama
	0x002870c6, // n0x0f4f c0x0000 (---------------)  + I sakado
	0x002c09c5, // n0x0f50 c0x0000 (---------------)  + I satte
	0x0024ef06, // n0x0f51 c0x0000 (---------------)  + I sayama
	0x00299b05, // n0x0f52 c0x0000 (---------------)  + I shiki
	0x002d9588, // n0x0f53 c0x0000 (---------------)  + I shiraoka
	0x002e53c4, // n0x0f54 c0x0000 (---------------)  + I soka
	0x002b3146, // n0x0f55 c0x0000 (---------------)  + I sugito
	0x003501c4, // n0x0f56 c0x0000 (---------------)  + I toda
	0x00221008, // n0x0f57 c0x0000 (---------------)  + I tokigawa
	0x0035dc4a, // n0x0f58 c0x0000 (---------------)  + I tokorozawa
	0x0028194c, // n0x0f59 c0x0000 (---------------)  + I tsurugashima
	0x00201045, // n0x0f5a c0x0000 (---------------)  + I urawa
	0x003055c6, // n0x0f5b c0x0000 (---------------)  + I warabi
	0x002584c6, // n0x0f5c c0x0000 (---------------)  + I yashio
	0x002db446, // n0x0f5d c0x0000 (---------------)  + I yokoze
	0x00352ec4, // n0x0f5e c0x0000 (---------------)  + I yono
	0x00382905, // n0x0f5f c0x0000 (---------------)  + I yorii
	0x00275747, // n0x0f60 c0x0000 (---------------)  + I yoshida
	0x00291d09, // n0x0f61 c0x0000 (---------------)  + I yoshikawa
	0x00298487, // n0x0f62 c0x0000 (---------------)  + I yoshimi
	0x007242c4, // n0x0f63 c0x0001 (---------------)  ! I city
	0x007242c4, // n0x0f64 c0x0001 (---------------)  ! I city
	0x002ab985, // n0x0f65 c0x0000 (---------------)  + I aisho
	0x002b5784, // n0x0f66 c0x0000 (---------------)  + I gamo
	0x0028fb8a, // n0x0f67 c0x0000 (---------------)  + I higashiomi
	0x00270b86, // n0x0f68 c0x0000 (---------------)  + I hikone
	0x002f4344, // n0x0f69 c0x0000 (---------------)  + I koka
	0x002ca805, // n0x0f6a c0x0000 (---------------)  + I konan
	0x0033ab85, // n0x0f6b c0x0000 (---------------)  + I kosei
	0x002fdb84, // n0x0f6c c0x0000 (---------------)  + I koto
	0x0027acc7, // n0x0f6d c0x0000 (---------------)  + I kusatsu
	0x002d0bc7, // n0x0f6e c0x0000 (---------------)  + I maibara
	0x002ba388, // n0x0f6f c0x0000 (---------------)  + I moriyama
	0x002b0a48, // n0x0f70 c0x0000 (---------------)  + I nagahama
	0x00215409, // n0x0f71 c0x0000 (---------------)  + I nishiazai
	0x00317d48, // n0x0f72 c0x0000 (---------------)  + I notogawa
	0x0028fd4b, // n0x0f73 c0x0000 (---------------)  + I omihachiman
	0x0024b684, // n0x0f74 c0x0000 (---------------)  + I otsu
	0x0026b2c5, // n0x0f75 c0x0000 (---------------)  + I ritto
	0x00265845, // n0x0f76 c0x0000 (---------------)  + I ryuoh
	0x002b34c9, // n0x0f77 c0x0000 (---------------)  + I takashima
	0x003427c9, // n0x0f78 c0x0000 (---------------)  + I takatsuki
	0x002d4408, // n0x0f79 c0x0000 (---------------)  + I torahime
	0x00243d88, // n0x0f7a c0x0000 (---------------)  + I toyosato
	0x00212384, // n0x0f7b c0x0000 (---------------)  + I yasu
	0x00292485, // n0x0f7c c0x0000 (---------------)  + I akagi
	0x00203583, // n0x0f7d c0x0000 (---------------)  + I ama
	0x00322a05, // n0x0f7e c0x0000 (---------------)  + I gotsu
	0x00298646, // n0x0f7f c0x0000 (---------------)  + I hamada
	0x0028ad4c, // n0x0f80 c0x0000 (---------------)  + I higashiizumo
	0x0021a306, // n0x0f81 c0x0000 (---------------)  + I hikawa
	0x002d2006, // n0x0f82 c0x0000 (---------------)  + I hikimi
	0x00282ac5, // n0x0f83 c0x0000 (---------------)  + I izumo
	0x00302448, // n0x0f84 c0x0000 (---------------)  + I kakinoki
	0x002a6506, // n0x0f85 c0x0000 (---------------)  + I masuda
	0x002cb8c6, // n0x0f86 c0x0000 (---------------)  + I matsue
	0x002467c6, // n0x0f87 c0x0000 (---------------)  + I misato
	0x0021ef8c, // n0x0f88 c0x0000 (---------------)  + I nishinoshima
	0x00203dc4, // n0x0f89 c0x0000 (---------------)  + I ohda
	0x003451ca, // n0x0f8a c0x0000 (---------------)  + I okinoshima
	0x00282a08, // n0x0f8b c0x0000 (---------------)  + I okuizumo
	0x0028ab87, // n0x0f8c c0x0000 (---------------)  + I shimane
	0x00373d86, // n0x0f8d c0x0000 (---------------)  + I tamayu
	0x00380087, // n0x0f8e c0x0000 (---------------)  + I tsuwano
	0x002ce685, // n0x0f8f c0x0000 (---------------)  + I unnan
	0x002fb786, // n0x0f90 c0x0000 (---------------)  + I yakumo
	0x0032c646, // n0x0f91 c0x0000 (---------------)  + I yasugi
	0x00342fc7, // n0x0f92 c0x0000 (---------------)  + I yatsuka
	0x002a0c44, // n0x0f93 c0x0000 (---------------)  + I arai
	0x002fc105, // n0x0f94 c0x0000 (---------------)  + I atami
	0x00270684, // n0x0f95 c0x0000 (---------------)  + I fuji
	0x002cb247, // n0x0f96 c0x0000 (---------------)  + I fujieda
	0x002708c8, // n0x0f97 c0x0000 (---------------)  + I fujikawa
	0x00271b4a, // n0x0f98 c0x0000 (---------------)  + I fujinomiya
	0x00278887, // n0x0f99 c0x0000 (---------------)  + I fukuroi
	0x002aae47, // n0x0f9a c0x0000 (---------------)  + I gotemba
	0x00316e47, // n0x0f9b c0x0000 (---------------)  + I haibara
	0x00345cc9, // n0x0f9c c0x0000 (---------------)  + I hamamatsu
	0x0028ad4a, // n0x0f9d c0x0000 (---------------)  + I higashiizu
	0x002234c3, // n0x0f9e c0x0000 (---------------)  + I ito
	0x003429c5, // n0x0f9f c0x0000 (---------------)  + I iwata
	0x00217d83, // n0x0fa0 c0x0000 (---------------)  + I izu
	0x00315009, // n0x0fa1 c0x0000 (---------------)  + I izunokuni
	0x00205cc8, // n0x0fa2 c0x0000 (---------------)  + I kakegawa
	0x002eaa87, // n0x0fa3 c0x0000 (---------------)  + I kannami
	0x00334fc9, // n0x0fa4 c0x0000 (---------------)  + I kawanehon
	0x0021a386, // n0x0fa5 c0x0000 (---------------)  + I kawazu
	0x00276208, // n0x0fa6 c0x0000 (---------------)  + I kikugawa
	0x002ddbc5, // n0x0fa7 c0x0000 (---------------)  + I kosai
	0x0026af0a, // n0x0fa8 c0x0000 (---------------)  + I makinohara
	0x0021f209, // n0x0fa9 c0x0000 (---------------)  + I matsuzaki
	0x00257fc9, // n0x0faa c0x0000 (---------------)  + I minamiizu
	0x002b20c7, // n0x0fab c0x0000 (---------------)  + I mishima
	0x00356889, // n0x0fac c0x0000 (---------------)  + I morimachi
	0x00217c48, // n0x0fad c0x0000 (---------------)  + I nishiizu
	0x002df146, // n0x0fae c0x0000 (---------------)  + I numazu
	0x00305788, // n0x0faf c0x0000 (---------------)  + I omaezaki
	0x003701c7, // n0x0fb0 c0x0000 (---------------)  + I shimada
	0x00223607, // n0x0fb1 c0x0000 (---------------)  + I shimizu
	0x00294e87, // n0x0fb2 c0x0000 (---------------)  + I shimoda
	0x002f07c8, // n0x0fb3 c0x0000 (---------------)  + I shizuoka
	0x002dee46, // n0x0fb4 c0x0000 (---------------)  + I susono
	0x00286b85, // n0x0fb5 c0x0000 (---------------)  + I yaizu
	0x00275747, // n0x0fb6 c0x0000 (---------------)  + I yoshida
	0x0028b4c8, // n0x0fb7 c0x0000 (---------------)  + I ashikaga
	0x0034d404, // n0x0fb8 c0x0000 (---------------)  + I bato
	0x002b5704, // n0x0fb9 c0x0000 (---------------)  + I haga
	0x002d6707, // n0x0fba c0x0000 (---------------)  + I ichikai
	0x00261fc7, // n0x0fbb c0x0000 (---------------)  + I iwafune
	0x0023020a, // n0x0fbc c0x0000 (---------------)  + I kaminokawa
	0x002df0c6, // n0x0fbd c0x0000 (---------------)  + I kanuma
	0x0029cfca, // n0x0fbe c0x0000 (---------------)  + I karasuyama
	0x002ab147, // n0x0fbf c0x0000 (---------------)  + I kuroiso
	0x00348e07, // n0x0fc0 c0x0000 (---------------)  + I mashiko
	0x0033e744, // n0x0fc1 c0x0000 (---------------)  + I mibu
	0x002d5404, // n0x0fc2 c0x0000 (---------------)  + I moka
	0x00224446, // n0x0fc3 c0x0000 (---------------)  + I motegi
	0x0036b984, // n0x0fc4 c0x0000 (---------------)  + I nasu
	0x0036b98c, // n0x0fc5 c0x0000 (---------------)  + I nasushiobara
	0x0020ce85, // n0x0fc6 c0x0000 (---------------)  + I nikko
	0x00218e09, // n0x0fc7 c0x0000 (---------------)  + I nishikata
	0x0027f4c4, // n0x0fc8 c0x0000 (---------------)  + I nogi
	0x002fdc45, // n0x0fc9 c0x0000 (---------------)  + I ohira
	0x00268a08, // n0x0fca c0x0000 (---------------)  + I ohtawara
	0x00287405, // n0x0fcb c0x0000 (---------------)  + I oyama
	0x0020e0c6, // n0x0fcc c0x0000 (---------------)  + I sakura
	0x00287904, // n0x0fcd c0x0000 (---------------)  + I sano
	0x002f344a, // n0x0fce c0x0000 (---------------)  + I shimotsuke
	0x002cee86, // n0x0fcf c0x0000 (---------------)  + I shioya
	0x002917ca, // n0x0fd0 c0x0000 (---------------)  + I takanezawa
	0x0034d487, // n0x0fd1 c0x0000 (---------------)  + I tochigi
	0x00201a85, // n0x0fd2 c0x0000 (---------------)  + I tsuga
	0x0021b785, // n0x0fd3 c0x0000 (---------------)  + I ujiie
	0x0024d60a, // n0x0fd4 c0x0000 (---------------)  + I utsunomiya
	0x00254c05, // n0x0fd5 c0x0000 (---------------)  + I yaita
	0x00294806, // n0x0fd6 c0x0000 (---------------)  + I aizumi
	0x00274b04, // n0x0fd7 c0x0000 (---------------)  + I anan
	0x002a6946, // n0x0fd8 c0x0000 (---------------)  + I ichiba
	0x00344445, // n0x0fd9 c0x0000 (---------------)  + I itano
	0x00229146, // n0x0fda c0x0000 (---------------)  + I kainan
	0x00307e4c, // n0x0fdb c0x0000 (---------------)  + I komatsushima
	0x002c1e8a, // n0x0fdc c0x0000 (---------------)  + I matsushige
	0x00267ec4, // n0x0fdd c0x0000 (---------------)  + I mima
	0x00216c06, // n0x0fde c0x0000 (---------------)  + I minami
	0x00291c87, // n0x0fdf c0x0000 (---------------)  + I miyoshi
	0x002be3c4, // n0x0fe0 c0x0000 (---------------)  + I mugi
	0x00276cc8, // n0x0fe1 c0x0000 (---------------)  + I nakagawa
	0x0035db46, // n0x0fe2 c0x0000 (---------------)  + I naruto
	0x0024f9c9, // n0x0fe3 c0x0000 (---------------)  + I sanagochi
	0x002e45c9, // n0x0fe4 c0x0000 (---------------)  + I shishikui
	0x002c69c9, // n0x0fe5 c0x0000 (---------------)  + I tokushima
	0x00223a06, // n0x0fe6 c0x0000 (---------------)  + I wajiki
	0x003702c6, // n0x0fe7 c0x0000 (---------------)  + I adachi
	0x003058c7, // n0x0fe8 c0x0000 (---------------)  + I akiruno
	0x003781c8, // n0x0fe9 c0x0000 (---------------)  + I akishima
	0x003700c9, // n0x0fea c0x0000 (---------------)  + I aogashima
	0x0036fc07, // n0x0feb c0x0000 (---------------)  + I arakawa
	0x00288a86, // n0x0fec c0x0000 (---------------)  + I bunkyo
	0x00202ac7, // n0x0fed c0x0000 (---------------)  + I chiyoda
	0x002a1d45, // n0x0fee c0x0000 (---------------)  + I chofu
	0x00347284, // n0x0fef c0x0000 (---------------)  + I chuo
	0x00305487, // n0x0ff0 c0x0000 (---------------)  + I edogawa
	0x00205ac5, // n0x0ff1 c0x0000 (---------------)  + I fuchu
	0x00280485, // n0x0ff2 c0x0000 (---------------)  + I fussa
	0x00381e07, // n0x0ff3 c0x0000 (---------------)  + I hachijo
	0x00254a08, // n0x0ff4 c0x0000 (---------------)  + I hachioji
	0x00356246, // n0x0ff5 c0x0000 (---------------)  + I hamura
	0x0028c2cd, // n0x0ff6 c0x0000 (---------------)  + I higashikurume
	0x0028d84f, // n0x0ff7 c0x0000 (---------------)  + I higashimurayama
	0x0029344d, // n0x0ff8 c0x0000 (---------------)  + I higashiyamato
	0x00205304, // n0x0ff9 c0x0000 (---------------)  + I hino
	0x00238dc6, // n0x0ffa c0x0000 (---------------)  + I hinode
	0x002c2248, // n0x0ffb c0x0000 (---------------)  + I hinohara
	0x00383b85, // n0x0ffc c0x0000 (---------------)  + I inagi
	0x0032b0c8, // n0x0ffd c0x0000 (---------------)  + I itabashi
	0x0021c90a, // n0x0ffe c0x0000 (---------------)  + I katsushika
	0x0020ec84, // n0x0fff c0x0000 (---------------)  + I kita
	0x002e6e86, // n0x1000 c0x0000 (---------------)  + I kiyose
	0x00248a87, // n0x1001 c0x0000 (---------------)  + I kodaira
	0x002d4f07, // n0x1002 c0x0000 (---------------)  + I koganei
	0x00363f49, // n0x1003 c0x0000 (---------------)  + I kokubunji
	0x00305745, // n0x1004 c0x0000 (---------------)  + I komae
	0x002fdb84, // n0x1005 c0x0000 (---------------)  + I koto
	0x0035aeca, // n0x1006 c0x0000 (---------------)  + I kouzushima
	0x002a8489, // n0x1007 c0x0000 (---------------)  + I kunitachi
	0x00356987, // n0x1008 c0x0000 (---------------)  + I machida
	0x002e4a86, // n0x1009 c0x0000 (---------------)  + I meguro
	0x00327ec6, // n0x100a c0x0000 (---------------)  + I minato
	0x002923c6, // n0x100b c0x0000 (---------------)  + I mitaka
	0x0033b7c6, // n0x100c c0x0000 (---------------)  + I mizuho
	0x002c1b4f, // n0x100d c0x0000 (---------------)  + I musashimurayama
	0x002c2109, // n0x100e c0x0000 (---------------)  + I musashino
	0x0026ac06, // n0x100f c0x0000 (---------------)  + I nakano
	0x0033f046, // n0x1010 c0x0000 (---------------)  + I nerima
	0x00367549, // n0x1011 c0x0000 (---------------)  + I ogasawara
	0x00314e07, // n0x1012 c0x0000 (---------------)  + I okutama
	0x0020de03, // n0x1013 c0x0000 (---------------)  + I ome
	0x0021f106, // n0x1014 c0x0000 (---------------)  + I oshima
	0x00211083, // n0x1015 c0x0000 (---------------)  + I ota
	0x002d1b48, // n0x1016 c0x0000 (---------------)  + I setagaya
	0x002e66c7, // n0x1017 c0x0000 (---------------)  + I shibuya
	0x002956c9, // n0x1018 c0x0000 (---------------)  + I shinagawa
	0x002b5d48, // n0x1019 c0x0000 (---------------)  + I shinjuku
	0x00330ec8, // n0x101a c0x0000 (---------------)  + I suginami
	0x002631c6, // n0x101b c0x0000 (---------------)  + I sumida
	0x0030a7c9, // n0x101c c0x0000 (---------------)  + I tachikawa
	0x00234205, // n0x101d c0x0000 (---------------)  + I taito
	0x002a1984, // n0x101e c0x0000 (---------------)  + I tama
	0x00243f07, // n0x101f c0x0000 (---------------)  + I toshima
	0x00265685, // n0x1020 c0x0000 (---------------)  + I chizu
	0x00205304, // n0x1021 c0x0000 (---------------)  + I hino
	0x002800c8, // n0x1022 c0x0000 (---------------)  + I kawahara
	0x00217b44, // n0x1023 c0x0000 (---------------)  + I koge
	0x002fe347, // n0x1024 c0x0000 (---------------)  + I kotoura
	0x0030d886, // n0x1025 c0x0000 (---------------)  + I misasa
	0x002bd905, // n0x1026 c0x0000 (---------------)  + I nanbu
	0x002aef08, // n0x1027 c0x0000 (---------------)  + I nichinan
	0x00327d8b, // n0x1028 c0x0000 (---------------)  + I sakaiminato
	0x002f11c7, // n0x1029 c0x0000 (---------------)  + I tottori
	0x0024d886, // n0x102a c0x0000 (---------------)  + I wakasa
	0x002b4684, // n0x102b c0x0000 (---------------)  + I yazu
	0x0037bec6, // n0x102c c0x0000 (---------------)  + I yonago
	0x002b1e85, // n0x102d c0x0000 (---------------)  + I asahi
	0x00205ac5, // n0x102e c0x0000 (---------------)  + I fuchu
	0x002777c9, // n0x102f c0x0000 (---------------)  + I fukumitsu
	0x0027a8c9, // n0x1030 c0x0000 (---------------)  + I funahashi
	0x00223644, // n0x1031 c0x0000 (---------------)  + I himi
	0x00223685, // n0x1032 c0x0000 (---------------)  + I imizu
	0x00216c45, // n0x1033 c0x0000 (---------------)  + I inami
	0x0026ad86, // n0x1034 c0x0000 (---------------)  + I johana
	0x002d6608, // n0x1035 c0x0000 (---------------)  + I kamiichi
	0x002aa746, // n0x1036 c0x0000 (---------------)  + I kurobe
	0x0020228b, // n0x1037 c0x0000 (---------------)  + I nakaniikawa
	0x0026794a, // n0x1038 c0x0000 (---------------)  + I namerikawa
	0x002f2f05, // n0x1039 c0x0000 (---------------)  + I nanto
	0x002838c6, // n0x103a c0x0000 (---------------)  + I nyuzen
	0x002acfc5, // n0x103b c0x0000 (---------------)  + I oyabe
	0x002a2245, // n0x103c c0x0000 (---------------)  + I taira
	0x002a24c7, // n0x103d c0x0000 (---------------)  + I takaoka
	0x002128c8, // n0x103e c0x0000 (---------------)  + I tateyama
	0x00273904, // n0x103f c0x0000 (---------------)  + I toga
	0x0029dc46, // n0x1040 c0x0000 (---------------)  + I tonami
	0x002873c6, // n0x1041 c0x0000 (---------------)  + I toyama
	0x00217e07, // n0x1042 c0x0000 (---------------)  + I unazuki
	0x00347304, // n0x1043 c0x0000 (---------------)  + I uozu
	0x002766c6, // n0x1044 c0x0000 (---------------)  + I yamada
	0x0036e185, // n0x1045 c0x0000 (---------------)  + I arida
	0x0036e189, // n0x1046 c0x0000 (---------------)  + I aridagawa
	0x003704c4, // n0x1047 c0x0000 (---------------)  + I gobo
	0x002bc709, // n0x1048 c0x0000 (---------------)  + I hashimoto
	0x00273146, // n0x1049 c0x0000 (---------------)  + I hidaka
	0x002ae588, // n0x104a c0x0000 (---------------)  + I hirogawa
	0x00216c45, // n0x104b c0x0000 (---------------)  + I inami
	0x00231a85, // n0x104c c0x0000 (---------------)  + I iwade
	0x00229146, // n0x104d c0x0000 (---------------)  + I kainan
	0x00258209, // n0x104e c0x0000 (---------------)  + I kamitonda
	0x00219949, // n0x104f c0x0000 (---------------)  + I katsuragi
	0x002d2086, // n0x1050 c0x0000 (---------------)  + I kimino
	0x0027dd88, // n0x1051 c0x0000 (---------------)  + I kinokawa
	0x002a2708, // n0x1052 c0x0000 (---------------)  + I kitayama
	0x002acf84, // n0x1053 c0x0000 (---------------)  + I koya
	0x002a3104, // n0x1054 c0x0000 (---------------)  + I koza
	0x002a3108, // n0x1055 c0x0000 (---------------)  + I kozagawa
	0x003091c8, // n0x1056 c0x0000 (---------------)  + I kudoyama
	0x00273a09, // n0x1057 c0x0000 (---------------)  + I kushimoto
	0x002985c6, // n0x1058 c0x0000 (---------------)  + I mihama
	0x002467c6, // n0x1059 c0x0000 (---------------)  + I misato
	0x003048cd, // n0x105a c0x0000 (---------------)  + I nachikatsuura
	0x00227206, // n0x105b c0x0000 (---------------)  + I shingu
	0x002d0149, // n0x105c c0x0000 (---------------)  + I shirahama
	0x0036d285, // n0x105d c0x0000 (---------------)  + I taiji
	0x002110c6, // n0x105e c0x0000 (---------------)  + I tanabe
	0x0030a988, // n0x105f c0x0000 (---------------)  + I wakayama
	0x00302305, // n0x1060 c0x0000 (---------------)  + I yuasa
	0x00269944, // n0x1061 c0x0000 (---------------)  + I yura
	0x002b1e85, // n0x1062 c0x0000 (---------------)  + I asahi
	0x0027a308, // n0x1063 c0x0000 (---------------)  + I funagata
	0x0028f949, // n0x1064 c0x0000 (---------------)  + I higashine
	0x00270744, // n0x1065 c0x0000 (---------------)  + I iide
	0x00273786, // n0x1066 c0x0000 (---------------)  + I kahoku
	0x003633ca, // n0x1067 c0x0000 (---------------)  + I kaminoyama
	0x0021a508, // n0x1068 c0x0000 (---------------)  + I kaneyama
	0x00230389, // n0x1069 c0x0000 (---------------)  + I kawanishi
	0x003605ca, // n0x106a c0x0000 (---------------)  + I mamurogawa
	0x00334f46, // n0x106b c0x0000 (---------------)  + I mikawa
	0x0028da08, // n0x106c c0x0000 (---------------)  + I murayama
	0x002fab85, // n0x106d c0x0000 (---------------)  + I nagai
	0x00203448, // n0x106e c0x0000 (---------------)  + I nakayama
	0x002a6785, // n0x106f c0x0000 (---------------)  + I nanyo
	0x0021a249, // n0x1070 c0x0000 (---------------)  + I nishikawa
	0x0033cd89, // n0x1071 c0x0000 (---------------)  + I obanazawa
	0x00202e42, // n0x1072 c0x0000 (---------------)  + I oe
	0x002ba1c5, // n0x1073 c0x0000 (---------------)  + I oguni
	0x00265906, // n0x1074 c0x0000 (---------------)  + I ohkura
	0x00273087, // n0x1075 c0x0000 (---------------)  + I oishida
	0x0034c905, // n0x1076 c0x0000 (---------------)  + I sagae
	0x003426c6, // n0x1077 c0x0000 (---------------)  + I sakata
	0x0034a308, // n0x1078 c0x0000 (---------------)  + I sakegawa
	0x002b9446, // n0x1079 c0x0000 (---------------)  + I shinjo
	0x002dd309, // n0x107a c0x0000 (---------------)  + I shirataka
	0x00272546, // n0x107b c0x0000 (---------------)  + I shonai
	0x00271608, // n0x107c c0x0000 (---------------)  + I takahata
	0x0029d3c5, // n0x107d c0x0000 (---------------)  + I tendo
	0x00257a46, // n0x107e c0x0000 (---------------)  + I tozawa
	0x00335288, // n0x107f c0x0000 (---------------)  + I tsuruoka
	0x002797c8, // n0x1080 c0x0000 (---------------)  + I yamagata
	0x003694c8, // n0x1081 c0x0000 (---------------)  + I yamanobe
	0x00324648, // n0x1082 c0x0000 (---------------)  + I yonezawa
	0x0021ea84, // n0x1083 c0x0000 (---------------)  + I yuza
	0x00229583, // n0x1084 c0x0000 (---------------)  + I abu
	0x002dd544, // n0x1085 c0x0000 (---------------)  + I hagi
	0x002b4c86, // n0x1086 c0x0000 (---------------)  + I hikari
	0x002a1d84, // n0x1087 c0x0000 (---------------)  + I hofu
	0x002df5c7, // n0x1088 c0x0000 (---------------)  + I iwakuni
	0x002cb7c9, // n0x1089 c0x0000 (---------------)  + I kudamatsu
	0x002b3c45, // n0x108a c0x0000 (---------------)  + I mitou
	0x002419c6, // n0x108b c0x0000 (---------------)  + I nagato
	0x0021f106, // n0x108c c0x0000 (---------------)  + I oshima
	0x002a2c8b, // n0x108d c0x0000 (---------------)  + I shimonoseki
	0x002f2e46, // n0x108e c0x0000 (---------------)  + I shunan
	0x003094c6, // n0x108f c0x0000 (---------------)  + I tabuse
	0x00261448, // n0x1090 c0x0000 (---------------)  + I tokuyama
	0x00244606, // n0x1091 c0x0000 (---------------)  + I toyota
	0x0025dc03, // n0x1092 c0x0000 (---------------)  + I ube
	0x00216b03, // n0x1093 c0x0000 (---------------)  + I yuu
	0x00347284, // n0x1094 c0x0000 (---------------)  + I chuo
	0x002352c5, // n0x1095 c0x0000 (---------------)  + I doshi
	0x00306107, // n0x1096 c0x0000 (---------------)  + I fuefuki
	0x002708c8, // n0x1097 c0x0000 (---------------)  + I fujikawa
	0x002708cf, // n0x1098 c0x0000 (---------------)  + I fujikawaguchiko
	0x0027564b, // n0x1099 c0x0000 (---------------)  + I fujiyoshida
	0x002d6408, // n0x109a c0x0000 (---------------)  + I hayakawa
	0x00273806, // n0x109b c0x0000 (---------------)  + I hokuto
	0x0034fece, // n0x109c c0x0000 (---------------)  + I ichikawamisato
	0x0020d603, // n0x109d c0x0000 (---------------)  + I kai
	0x00306084, // n0x109e c0x0000 (---------------)  + I kofu
	0x002f2dc5, // n0x109f c0x0000 (---------------)  + I koshu
	0x002f73c6, // n0x10a0 c0x0000 (---------------)  + I kosuge
	0x00284fcb, // n0x10a1 c0x0000 (---------------)  + I minami-alps
	0x00289146, // n0x10a2 c0x0000 (---------------)  + I minobu
	0x00224fc9, // n0x10a3 c0x0000 (---------------)  + I nakamichi
	0x002bd905, // n0x10a4 c0x0000 (---------------)  + I nanbu
	0x00357548, // n0x10a5 c0x0000 (---------------)  + I narusawa
	0x00211988, // n0x10a6 c0x0000 (---------------)  + I nirasaki
	0x0021980c, // n0x10a7 c0x0000 (---------------)  + I nishikatsura
	0x002941c6, // n0x10a8 c0x0000 (---------------)  + I oshino
	0x00322a46, // n0x10a9 c0x0000 (---------------)  + I otsuki
	0x002f5745, // n0x10aa c0x0000 (---------------)  + I showa
	0x002808c8, // n0x10ab c0x0000 (---------------)  + I tabayama
	0x00202ec5, // n0x10ac c0x0000 (---------------)  + I tsuru
	0x0020e3c8, // n0x10ad c0x0000 (---------------)  + I uenohara
	0x0029388a, // n0x10ae c0x0000 (---------------)  + I yamanakako
	0x00379ac9, // n0x10af c0x0000 (---------------)  + I yamanashi
	0x007242c4, // n0x10b0 c0x0001 (---------------)  ! I city
	0x00232dc3, // n0x10b1 c0x0000 (---------------)  + I com
	0x0021e083, // n0x10b2 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x10b3 c0x0000 (---------------)  + I gov
	0x00240443, // n0x10b4 c0x0000 (---------------)  + I mil
	0x00218643, // n0x10b5 c0x0000 (---------------)  + I net
	0x0024d043, // n0x10b6 c0x0000 (---------------)  + I org
	0x00202183, // n0x10b7 c0x0000 (---------------)  + I biz
	0x00232dc3, // n0x10b8 c0x0000 (---------------)  + I com
	0x0021e083, // n0x10b9 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x10ba c0x0000 (---------------)  + I gov
	0x00208a44, // n0x10bb c0x0000 (---------------)  + I info
	0x00218643, // n0x10bc c0x0000 (---------------)  + I net
	0x0024d043, // n0x10bd c0x0000 (---------------)  + I org
	0x00203a03, // n0x10be c0x0000 (---------------)  + I ass
	0x00278344, // n0x10bf c0x0000 (---------------)  + I asso
	0x00232dc3, // n0x10c0 c0x0000 (---------------)  + I com
	0x0023a884, // n0x10c1 c0x0000 (---------------)  + I coop
	0x0021e083, // n0x10c2 c0x0000 (---------------)  + I edu
	0x00252544, // n0x10c3 c0x0000 (---------------)  + I gouv
	0x00209ac3, // n0x10c4 c0x0000 (---------------)  + I gov
	0x002e1b47, // n0x10c5 c0x0000 (---------------)  + I medecin
	0x00240443, // n0x10c6 c0x0000 (---------------)  + I mil
	0x002104c3, // n0x10c7 c0x0000 (---------------)  + I nom
	0x00283208, // n0x10c8 c0x0000 (---------------)  + I notaires
	0x0024d043, // n0x10c9 c0x0000 (---------------)  + I org
	0x002c55cb, // n0x10ca c0x0000 (---------------)  + I pharmaciens
	0x002cf303, // n0x10cb c0x0000 (---------------)  + I prd
	0x0022ad46, // n0x10cc c0x0000 (---------------)  + I presse
	0x002032c2, // n0x10cd c0x0000 (---------------)  + I tm
	0x002ff6cb, // n0x10ce c0x0000 (---------------)  + I veterinaire
	0x0021e083, // n0x10cf c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x10d0 c0x0000 (---------------)  + I gov
	0x00218643, // n0x10d1 c0x0000 (---------------)  + I net
	0x0024d043, // n0x10d2 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x10d3 c0x0000 (---------------)  + I com
	0x0021e083, // n0x10d4 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x10d5 c0x0000 (---------------)  + I gov
	0x0024d043, // n0x10d6 c0x0000 (---------------)  + I org
	0x00222883, // n0x10d7 c0x0000 (---------------)  + I rep
	0x00208103, // n0x10d8 c0x0000 (---------------)  + I tra
	0x00200b82, // n0x10d9 c0x0000 (---------------)  + I ac
	0x0009e448, // n0x10da c0x0000 (---------------)  +   blogspot
	0x00232845, // n0x10db c0x0000 (---------------)  + I busan
	0x002f6e88, // n0x10dc c0x0000 (---------------)  + I chungbuk
	0x002f8348, // n0x10dd c0x0000 (---------------)  + I chungnam
	0x00200882, // n0x10de c0x0000 (---------------)  + I co
	0x00345f05, // n0x10df c0x0000 (---------------)  + I daegu
	0x002fd947, // n0x10e0 c0x0000 (---------------)  + I daejeon
	0x00201e42, // n0x10e1 c0x0000 (---------------)  + I es
	0x00225207, // n0x10e2 c0x0000 (---------------)  + I gangwon
	0x00209ac2, // n0x10e3 c0x0000 (---------------)  + I go
	0x00257d87, // n0x10e4 c0x0000 (---------------)  + I gwangju
	0x00307c49, // n0x10e5 c0x0000 (---------------)  + I gyeongbuk
	0x002ecb08, // n0x10e6 c0x0000 (---------------)  + I gyeonggi
	0x002c3649, // n0x10e7 c0x0000 (---------------)  + I gyeongnam
	0x00209702, // n0x10e8 c0x0000 (---------------)  + I hs
	0x002ae307, // n0x10e9 c0x0000 (---------------)  + I incheon
	0x002d1e04, // n0x10ea c0x0000 (---------------)  + I jeju
	0x002fda07, // n0x10eb c0x0000 (---------------)  + I jeonbuk
	0x00267847, // n0x10ec c0x0000 (---------------)  + I jeonnam
	0x003797c2, // n0x10ed c0x0000 (---------------)  + I kg
	0x00240443, // n0x10ee c0x0000 (---------------)  + I mil
	0x0020e602, // n0x10ef c0x0000 (---------------)  + I ms
	0x00209e82, // n0x10f0 c0x0000 (---------------)  + I ne
	0x00200d02, // n0x10f1 c0x0000 (---------------)  + I or
	0x0020c782, // n0x10f2 c0x0000 (---------------)  + I pe
	0x00207082, // n0x10f3 c0x0000 (---------------)  + I re
	0x0021bcc2, // n0x10f4 c0x0000 (---------------)  + I sc
	0x0034b605, // n0x10f5 c0x0000 (---------------)  + I seoul
	0x00250985, // n0x10f6 c0x0000 (---------------)  + I ulsan
	0x00232dc3, // n0x10f7 c0x0000 (---------------)  + I com
	0x0021e083, // n0x10f8 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x10f9 c0x0000 (---------------)  + I gov
	0x00218643, // n0x10fa c0x0000 (---------------)  + I net
	0x0024d043, // n0x10fb c0x0000 (---------------)  + I org
	0x00232dc3, // n0x10fc c0x0000 (---------------)  + I com
	0x0021e083, // n0x10fd c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x10fe c0x0000 (---------------)  + I gov
	0x00240443, // n0x10ff c0x0000 (---------------)  + I mil
	0x00218643, // n0x1100 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1101 c0x0000 (---------------)  + I org
	0x00000401, // n0x1102 c0x0000 (---------------)  +   c
	0x00232dc3, // n0x1103 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1104 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1105 c0x0000 (---------------)  + I gov
	0x00208a44, // n0x1106 c0x0000 (---------------)  + I info
	0x002188c3, // n0x1107 c0x0000 (---------------)  + I int
	0x00218643, // n0x1108 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1109 c0x0000 (---------------)  + I org
	0x0020c783, // n0x110a c0x0000 (---------------)  + I per
	0x00232dc3, // n0x110b c0x0000 (---------------)  + I com
	0x0021e083, // n0x110c c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x110d c0x0000 (---------------)  + I gov
	0x00218643, // n0x110e c0x0000 (---------------)  + I net
	0x0024d043, // n0x110f c0x0000 (---------------)  + I org
	0x00200882, // n0x1110 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x1111 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1112 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1113 c0x0000 (---------------)  + I gov
	0x00218643, // n0x1114 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1115 c0x0000 (---------------)  + I org
	0x002af5c4, // n0x1116 c0x0000 (---------------)  + I assn
	0x00232dc3, // n0x1117 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1118 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1119 c0x0000 (---------------)  + I gov
	0x0023c403, // n0x111a c0x0000 (---------------)  + I grp
	0x0029d805, // n0x111b c0x0000 (---------------)  + I hotel
	0x002188c3, // n0x111c c0x0000 (---------------)  + I int
	0x00220e43, // n0x111d c0x0000 (---------------)  + I ltd
	0x00218643, // n0x111e c0x0000 (---------------)  + I net
	0x0024ad43, // n0x111f c0x0000 (---------------)  + I ngo
	0x0024d043, // n0x1120 c0x0000 (---------------)  + I org
	0x00251983, // n0x1121 c0x0000 (---------------)  + I sch
	0x002783c3, // n0x1122 c0x0000 (---------------)  + I soc
	0x002071c3, // n0x1123 c0x0000 (---------------)  + I web
	0x00232dc3, // n0x1124 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1125 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1126 c0x0000 (---------------)  + I gov
	0x00218643, // n0x1127 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1128 c0x0000 (---------------)  + I org
	0x00200882, // n0x1129 c0x0000 (---------------)  + I co
	0x0024d043, // n0x112a c0x0000 (---------------)  + I org
	0x00209ac3, // n0x112b c0x0000 (---------------)  + I gov
	0x002a4783, // n0x112c c0x0000 (---------------)  + I asn
	0x00232dc3, // n0x112d c0x0000 (---------------)  + I com
	0x00235884, // n0x112e c0x0000 (---------------)  + I conf
	0x0021e083, // n0x112f c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1130 c0x0000 (---------------)  + I gov
	0x00205942, // n0x1131 c0x0000 (---------------)  + I id
	0x00240443, // n0x1132 c0x0000 (---------------)  + I mil
	0x00218643, // n0x1133 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1134 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x1135 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1136 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1137 c0x0000 (---------------)  + I gov
	0x00205942, // n0x1138 c0x0000 (---------------)  + I id
	0x00210e83, // n0x1139 c0x0000 (---------------)  + I med
	0x00218643, // n0x113a c0x0000 (---------------)  + I net
	0x0024d043, // n0x113b c0x0000 (---------------)  + I org
	0x002cb543, // n0x113c c0x0000 (---------------)  + I plc
	0x00251983, // n0x113d c0x0000 (---------------)  + I sch
	0x00200b82, // n0x113e c0x0000 (---------------)  + I ac
	0x00200882, // n0x113f c0x0000 (---------------)  + I co
	0x00209ac3, // n0x1140 c0x0000 (---------------)  + I gov
	0x00218643, // n0x1141 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1142 c0x0000 (---------------)  + I org
	0x0022ad45, // n0x1143 c0x0000 (---------------)  + I press
	0x00278344, // n0x1144 c0x0000 (---------------)  + I asso
	0x002032c2, // n0x1145 c0x0000 (---------------)  + I tm
	0x00200b82, // n0x1146 c0x0000 (---------------)  + I ac
	0x00200882, // n0x1147 c0x0000 (---------------)  + I co
	0x0021e083, // n0x1148 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1149 c0x0000 (---------------)  + I gov
	0x00234383, // n0x114a c0x0000 (---------------)  + I its
	0x00218643, // n0x114b c0x0000 (---------------)  + I net
	0x0024d043, // n0x114c c0x0000 (---------------)  + I org
	0x002cfac4, // n0x114d c0x0000 (---------------)  + I priv
	0x00232dc3, // n0x114e c0x0000 (---------------)  + I com
	0x0021e083, // n0x114f c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1150 c0x0000 (---------------)  + I gov
	0x00240443, // n0x1151 c0x0000 (---------------)  + I mil
	0x002104c3, // n0x1152 c0x0000 (---------------)  + I nom
	0x0024d043, // n0x1153 c0x0000 (---------------)  + I org
	0x002cf303, // n0x1154 c0x0000 (---------------)  + I prd
	0x002032c2, // n0x1155 c0x0000 (---------------)  + I tm
	0x00232dc3, // n0x1156 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1157 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1158 c0x0000 (---------------)  + I gov
	0x00206e83, // n0x1159 c0x0000 (---------------)  + I inf
	0x00267944, // n0x115a c0x0000 (---------------)  + I name
	0x00218643, // n0x115b c0x0000 (---------------)  + I net
	0x0024d043, // n0x115c c0x0000 (---------------)  + I org
	0x00232dc3, // n0x115d c0x0000 (---------------)  + I com
	0x0021e083, // n0x115e c0x0000 (---------------)  + I edu
	0x00252544, // n0x115f c0x0000 (---------------)  + I gouv
	0x00209ac3, // n0x1160 c0x0000 (---------------)  + I gov
	0x00218643, // n0x1161 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1162 c0x0000 (---------------)  + I org
	0x0022ad46, // n0x1163 c0x0000 (---------------)  + I presse
	0x0021e083, // n0x1164 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1165 c0x0000 (---------------)  + I gov
	0x0001af43, // n0x1166 c0x0000 (---------------)  +   nyc
	0x0024d043, // n0x1167 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x1168 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1169 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x116a c0x0000 (---------------)  + I gov
	0x00218643, // n0x116b c0x0000 (---------------)  + I net
	0x0024d043, // n0x116c c0x0000 (---------------)  + I org
	0x0009e448, // n0x116d c0x0000 (---------------)  +   blogspot
	0x00209ac3, // n0x116e c0x0000 (---------------)  + I gov
	0x00232dc3, // n0x116f c0x0000 (---------------)  + I com
	0x0021e083, // n0x1170 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1171 c0x0000 (---------------)  + I gov
	0x00218643, // n0x1172 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1173 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x1174 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1175 c0x0000 (---------------)  + I edu
	0x00218643, // n0x1176 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1177 c0x0000 (---------------)  + I org
	0x00200b82, // n0x1178 c0x0000 (---------------)  + I ac
	0x00200882, // n0x1179 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x117a c0x0000 (---------------)  + I com
	0x00209ac3, // n0x117b c0x0000 (---------------)  + I gov
	0x00218643, // n0x117c c0x0000 (---------------)  + I net
	0x00200d02, // n0x117d c0x0000 (---------------)  + I or
	0x0024d043, // n0x117e c0x0000 (---------------)  + I org
	0x002fe987, // n0x117f c0x0000 (---------------)  + I academy
	0x002ee00b, // n0x1180 c0x0000 (---------------)  + I agriculture
	0x00222943, // n0x1181 c0x0000 (---------------)  + I air
	0x0024e648, // n0x1182 c0x0000 (---------------)  + I airguard
	0x00377f47, // n0x1183 c0x0000 (---------------)  + I alabama
	0x002abec6, // n0x1184 c0x0000 (---------------)  + I alaska
	0x002f8e05, // n0x1185 c0x0000 (---------------)  + I amber
	0x00383909, // n0x1186 c0x0000 (---------------)  + I ambulance
	0x00237b48, // n0x1187 c0x0000 (---------------)  + I american
	0x00237b49, // n0x1188 c0x0000 (---------------)  + I americana
	0x00274990, // n0x1189 c0x0000 (---------------)  + I americanantiques
	0x00237b4b, // n0x118a c0x0000 (---------------)  + I americanart
	0x002f8c49, // n0x118b c0x0000 (---------------)  + I amsterdam
	0x00205fc3, // n0x118c c0x0000 (---------------)  + I and
	0x002e0e49, // n0x118d c0x0000 (---------------)  + I annefrank
	0x00236846, // n0x118e c0x0000 (---------------)  + I anthro
	0x0023684c, // n0x118f c0x0000 (---------------)  + I anthropology
	0x00232908, // n0x1190 c0x0000 (---------------)  + I antiques
	0x0036bc48, // n0x1191 c0x0000 (---------------)  + I aquarium
	0x00263cc9, // n0x1192 c0x0000 (---------------)  + I arboretum
	0x002d828e, // n0x1193 c0x0000 (---------------)  + I archaeological
	0x002c340b, // n0x1194 c0x0000 (---------------)  + I archaeology
	0x00229ecc, // n0x1195 c0x0000 (---------------)  + I architecture
	0x00208d43, // n0x1196 c0x0000 (---------------)  + I art
	0x00237d4c, // n0x1197 c0x0000 (---------------)  + I artanddesign
	0x002ec189, // n0x1198 c0x0000 (---------------)  + I artcenter
	0x00208d47, // n0x1199 c0x0000 (---------------)  + I artdeco
	0x0021dfcc, // n0x119a c0x0000 (---------------)  + I arteducation
	0x002372ca, // n0x119b c0x0000 (---------------)  + I artgallery
	0x0020b384, // n0x119c c0x0000 (---------------)  + I arts
	0x0020b38d, // n0x119d c0x0000 (---------------)  + I artsandcrafts
	0x002ec048, // n0x119e c0x0000 (---------------)  + I asmatart
	0x0036f4cd, // n0x119f c0x0000 (---------------)  + I assassination
	0x0029b006, // n0x11a0 c0x0000 (---------------)  + I assisi
	0x002c51cb, // n0x11a1 c0x0000 (---------------)  + I association
	0x003459c9, // n0x11a2 c0x0000 (---------------)  + I astronomy
	0x002b6947, // n0x11a3 c0x0000 (---------------)  + I atlanta
	0x0036b806, // n0x11a4 c0x0000 (---------------)  + I austin
	0x0032d809, // n0x11a5 c0x0000 (---------------)  + I australia
	0x0033490a, // n0x11a6 c0x0000 (---------------)  + I automotive
	0x00332d48, // n0x11a7 c0x0000 (---------------)  + I aviation
	0x0026a344, // n0x11a8 c0x0000 (---------------)  + I axis
	0x002fb107, // n0x11a9 c0x0000 (---------------)  + I badajoz
	0x0020da87, // n0x11aa c0x0000 (---------------)  + I baghdad
	0x0030b4c4, // n0x11ab c0x0000 (---------------)  + I bahn
	0x00349604, // n0x11ac c0x0000 (---------------)  + I bale
	0x002d9c49, // n0x11ad c0x0000 (---------------)  + I baltimore
	0x002f9609, // n0x11ae c0x0000 (---------------)  + I barcelona
	0x00285848, // n0x11af c0x0000 (---------------)  + I baseball
	0x00212c85, // n0x11b0 c0x0000 (---------------)  + I basel
	0x00214405, // n0x11b1 c0x0000 (---------------)  + I baths
	0x0020cd46, // n0x11b2 c0x0000 (---------------)  + I bauern
	0x0020b249, // n0x11b3 c0x0000 (---------------)  + I beauxarts
	0x0036964d, // n0x11b4 c0x0000 (---------------)  + I beeldengeluid
	0x002111c8, // n0x11b5 c0x0000 (---------------)  + I bellevue
	0x0020cc47, // n0x11b6 c0x0000 (---------------)  + I bergbau
	0x002f8e88, // n0x11b7 c0x0000 (---------------)  + I berkeley
	0x00376686, // n0x11b8 c0x0000 (---------------)  + I berlin
	0x0037bb04, // n0x11b9 c0x0000 (---------------)  + I bern
	0x0023ac45, // n0x11ba c0x0000 (---------------)  + I bible
	0x00207606, // n0x11bb c0x0000 (---------------)  + I bilbao
	0x00207f84, // n0x11bc c0x0000 (---------------)  + I bill
	0x00208c47, // n0x11bd c0x0000 (---------------)  + I birdart
	0x0020a2ca, // n0x11be c0x0000 (---------------)  + I birthplace
	0x00217444, // n0x11bf c0x0000 (---------------)  + I bonn
	0x00217746, // n0x11c0 c0x0000 (---------------)  + I boston
	0x00219489, // n0x11c1 c0x0000 (---------------)  + I botanical
	0x0021948f, // n0x11c2 c0x0000 (---------------)  + I botanicalgarden
	0x0021a90d, // n0x11c3 c0x0000 (---------------)  + I botanicgarden
	0x0021ae46, // n0x11c4 c0x0000 (---------------)  + I botany
	0x0021e6d0, // n0x11c5 c0x0000 (---------------)  + I brandywinevalley
	0x0021ec06, // n0x11c6 c0x0000 (---------------)  + I brasil
	0x00220587, // n0x11c7 c0x0000 (---------------)  + I bristol
	0x00221207, // n0x11c8 c0x0000 (---------------)  + I british
	0x0022120f, // n0x11c9 c0x0000 (---------------)  + I britishcolumbia
	0x002248c9, // n0x11ca c0x0000 (---------------)  + I broadcast
	0x00228a46, // n0x11cb c0x0000 (---------------)  + I brunel
	0x002297c7, // n0x11cc c0x0000 (---------------)  + I brussel
	0x002297c8, // n0x11cd c0x0000 (---------------)  + I brussels
	0x00229b89, // n0x11ce c0x0000 (---------------)  + I bruxelles
	0x002bd9c8, // n0x11cf c0x0000 (---------------)  + I building
	0x002c9ac7, // n0x11d0 c0x0000 (---------------)  + I burghof
	0x00232843, // n0x11d1 c0x0000 (---------------)  + I bus
	0x0028a746, // n0x11d2 c0x0000 (---------------)  + I bushey
	0x0023bd48, // n0x11d3 c0x0000 (---------------)  + I cadaques
	0x002d854a, // n0x11d4 c0x0000 (---------------)  + I california
	0x00216409, // n0x11d5 c0x0000 (---------------)  + I cambridge
	0x002180c3, // n0x11d6 c0x0000 (---------------)  + I can
	0x00343f06, // n0x11d7 c0x0000 (---------------)  + I canada
	0x0029da8a, // n0x11d8 c0x0000 (---------------)  + I capebreton
	0x0021afc7, // n0x11d9 c0x0000 (---------------)  + I carrier
	0x0021de0a, // n0x11da c0x0000 (---------------)  + I cartoonart
	0x00320f8e, // n0x11db c0x0000 (---------------)  + I casadelamoneda
	0x00224a06, // n0x11dc c0x0000 (---------------)  + I castle
	0x0033a347, // n0x11dd c0x0000 (---------------)  + I castres
	0x0021a006, // n0x11de c0x0000 (---------------)  + I celtic
	0x002442c6, // n0x11df c0x0000 (---------------)  + I center
	0x002fc94b, // n0x11e0 c0x0000 (---------------)  + I chattanooga
	0x0031394a, // n0x11e1 c0x0000 (---------------)  + I cheltenham
	0x0032e04d, // n0x11e2 c0x0000 (---------------)  + I chesapeakebay
	0x00370387, // n0x11e3 c0x0000 (---------------)  + I chicago
	0x00308508, // n0x11e4 c0x0000 (---------------)  + I children
	0x00308509, // n0x11e5 c0x0000 (---------------)  + I childrens
	0x0030850f, // n0x11e6 c0x0000 (---------------)  + I childrensgarden
	0x0029c58c, // n0x11e7 c0x0000 (---------------)  + I chiropractic
	0x002a0d89, // n0x11e8 c0x0000 (---------------)  + I chocolate
	0x003516ce, // n0x11e9 c0x0000 (---------------)  + I christiansburg
	0x0027468a, // n0x11ea c0x0000 (---------------)  + I cincinnati
	0x002e1c46, // n0x11eb c0x0000 (---------------)  + I cinema
	0x0031de46, // n0x11ec c0x0000 (---------------)  + I circus
	0x0033688c, // n0x11ed c0x0000 (---------------)  + I civilisation
	0x00338a8c, // n0x11ee c0x0000 (---------------)  + I civilization
	0x0033e488, // n0x11ef c0x0000 (---------------)  + I civilwar
	0x003792c7, // n0x11f0 c0x0000 (---------------)  + I clinton
	0x002060c5, // n0x11f1 c0x0000 (---------------)  + I clock
	0x00208e84, // n0x11f2 c0x0000 (---------------)  + I coal
	0x002fa40e, // n0x11f3 c0x0000 (---------------)  + I coastaldefence
	0x00359204, // n0x11f4 c0x0000 (---------------)  + I cody
	0x0025e187, // n0x11f5 c0x0000 (---------------)  + I coldwar
	0x0022ddca, // n0x11f6 c0x0000 (---------------)  + I collection
	0x00231294, // n0x11f7 c0x0000 (---------------)  + I colonialwilliamsburg
	0x0023218f, // n0x11f8 c0x0000 (---------------)  + I coloradoplateau
	0x002213c8, // n0x11f9 c0x0000 (---------------)  + I columbia
	0x00232708, // n0x11fa c0x0000 (---------------)  + I columbus
	0x002ceb4d, // n0x11fb c0x0000 (---------------)  + I communication
	0x002ceb4e, // n0x11fc c0x0000 (---------------)  + I communications
	0x00232dc9, // n0x11fd c0x0000 (---------------)  + I community
	0x00234a08, // n0x11fe c0x0000 (---------------)  + I computer
	0x00234a0f, // n0x11ff c0x0000 (---------------)  + I computerhistory
	0x00236fcc, // n0x1200 c0x0000 (---------------)  + I contemporary
	0x00236fcf, // n0x1201 c0x0000 (---------------)  + I contemporaryart
	0x00238b07, // n0x1202 c0x0000 (---------------)  + I convent
	0x0023b08a, // n0x1203 c0x0000 (---------------)  + I copenhagen
	0x0021bd0b, // n0x1204 c0x0000 (---------------)  + I corporation
	0x0023c808, // n0x1205 c0x0000 (---------------)  + I corvette
	0x0023dec7, // n0x1206 c0x0000 (---------------)  + I costume
	0x0025d54d, // n0x1207 c0x0000 (---------------)  + I countryestate
	0x00322546, // n0x1208 c0x0000 (---------------)  + I county
	0x0020b546, // n0x1209 c0x0000 (---------------)  + I crafts
	0x0023f249, // n0x120a c0x0000 (---------------)  + I cranbrook
	0x0031e188, // n0x120b c0x0000 (---------------)  + I creation
	0x002440c8, // n0x120c c0x0000 (---------------)  + I cultural
	0x002440ce, // n0x120d c0x0000 (---------------)  + I culturalcenter
	0x002ee107, // n0x120e c0x0000 (---------------)  + I culture
	0x0020a6c5, // n0x120f c0x0000 (---------------)  + I cyber
	0x002c5c05, // n0x1210 c0x0000 (---------------)  + I cymru
	0x00222244, // n0x1211 c0x0000 (---------------)  + I dali
	0x0034cc46, // n0x1212 c0x0000 (---------------)  + I dallas
	0x00285748, // n0x1213 c0x0000 (---------------)  + I database
	0x0020fbc3, // n0x1214 c0x0000 (---------------)  + I ddr
	0x00249dce, // n0x1215 c0x0000 (---------------)  + I decorativearts
	0x002b6448, // n0x1216 c0x0000 (---------------)  + I delaware
	0x002a7a8b, // n0x1217 c0x0000 (---------------)  + I delmenhorst
	0x0035c787, // n0x1218 c0x0000 (---------------)  + I denmark
	0x002da245, // n0x1219 c0x0000 (---------------)  + I depot
	0x00237ec6, // n0x121a c0x0000 (---------------)  + I design
	0x0029ef47, // n0x121b c0x0000 (---------------)  + I detroit
	0x002f0dc8, // n0x121c c0x0000 (---------------)  + I dinosaur
	0x00334c49, // n0x121d c0x0000 (---------------)  + I discovery
	0x0035a285, // n0x121e c0x0000 (---------------)  + I dolls
	0x0027fdc8, // n0x121f c0x0000 (---------------)  + I donostia
	0x0036f206, // n0x1220 c0x0000 (---------------)  + I durham
	0x0034fb4a, // n0x1221 c0x0000 (---------------)  + I eastafrica
	0x002fa309, // n0x1222 c0x0000 (---------------)  + I eastcoast
	0x0021e089, // n0x1223 c0x0000 (---------------)  + I education
	0x0021e08b, // n0x1224 c0x0000 (---------------)  + I educational
	0x0029aa48, // n0x1225 c0x0000 (---------------)  + I egyptian
	0x0030b389, // n0x1226 c0x0000 (---------------)  + I eisenbahn
	0x00212d46, // n0x1227 c0x0000 (---------------)  + I elburg
	0x003454ca, // n0x1228 c0x0000 (---------------)  + I elvendrell
	0x00207b4a, // n0x1229 c0x0000 (---------------)  + I embroidery
	0x0023b28c, // n0x122a c0x0000 (---------------)  + I encyclopedic
	0x002b0e07, // n0x122b c0x0000 (---------------)  + I england
	0x00307a4a, // n0x122c c0x0000 (---------------)  + I entomology
	0x0027f68b, // n0x122d c0x0000 (---------------)  + I environment
	0x0027f699, // n0x122e c0x0000 (---------------)  + I environmentalconservation
	0x002182c8, // n0x122f c0x0000 (---------------)  + I epilepsy
	0x0022adc5, // n0x1230 c0x0000 (---------------)  + I essex
	0x0025d706, // n0x1231 c0x0000 (---------------)  + I estate
	0x003003c9, // n0x1232 c0x0000 (---------------)  + I ethnology
	0x00252886, // n0x1233 c0x0000 (---------------)  + I exeter
	0x0020138a, // n0x1234 c0x0000 (---------------)  + I exhibition
	0x002db306, // n0x1235 c0x0000 (---------------)  + I family
	0x002125c4, // n0x1236 c0x0000 (---------------)  + I farm
	0x002125cd, // n0x1237 c0x0000 (---------------)  + I farmequipment
	0x0021f607, // n0x1238 c0x0000 (---------------)  + I farmers
	0x0024ae49, // n0x1239 c0x0000 (---------------)  + I farmstead
	0x00287a05, // n0x123a c0x0000 (---------------)  + I field
	0x002470c8, // n0x123b c0x0000 (---------------)  + I figueres
	0x00247b49, // n0x123c c0x0000 (---------------)  + I filatelia
	0x00247d84, // n0x123d c0x0000 (---------------)  + I film
	0x00248587, // n0x123e c0x0000 (---------------)  + I fineart
	0x00248588, // n0x123f c0x0000 (---------------)  + I finearts
	0x00248c47, // n0x1240 c0x0000 (---------------)  + I finland
	0x0025f808, // n0x1241 c0x0000 (---------------)  + I flanders
	0x0024e007, // n0x1242 c0x0000 (---------------)  + I florida
	0x002d2445, // n0x1243 c0x0000 (---------------)  + I force
	0x002541cc, // n0x1244 c0x0000 (---------------)  + I fortmissoula
	0x00254809, // n0x1245 c0x0000 (---------------)  + I fortworth
	0x002d994a, // n0x1246 c0x0000 (---------------)  + I foundation
	0x00357989, // n0x1247 c0x0000 (---------------)  + I francaise
	0x002e0f49, // n0x1248 c0x0000 (---------------)  + I frankfurt
	0x0033ee0c, // n0x1249 c0x0000 (---------------)  + I franziskaner
	0x0038230b, // n0x124a c0x0000 (---------------)  + I freemasonry
	0x00256d08, // n0x124b c0x0000 (---------------)  + I freiburg
	0x00257bc8, // n0x124c c0x0000 (---------------)  + I fribourg
	0x0025bac4, // n0x124d c0x0000 (---------------)  + I frog
	0x0027bdc8, // n0x124e c0x0000 (---------------)  + I fundacio
	0x0027da49, // n0x124f c0x0000 (---------------)  + I furniture
	0x00237387, // n0x1250 c0x0000 (---------------)  + I gallery
	0x002196c6, // n0x1251 c0x0000 (---------------)  + I garden
	0x00216987, // n0x1252 c0x0000 (---------------)  + I gateway
	0x0032e6c9, // n0x1253 c0x0000 (---------------)  + I geelvinck
	0x0036138b, // n0x1254 c0x0000 (---------------)  + I gemological
	0x00344207, // n0x1255 c0x0000 (---------------)  + I geology
	0x00321f47, // n0x1256 c0x0000 (---------------)  + I georgia
	0x0027f547, // n0x1257 c0x0000 (---------------)  + I giessen
	0x0036f444, // n0x1258 c0x0000 (---------------)  + I glas
	0x0036f445, // n0x1259 c0x0000 (---------------)  + I glass
	0x0029c0c5, // n0x125a c0x0000 (---------------)  + I gorge
	0x0031568b, // n0x125b c0x0000 (---------------)  + I grandrapids
	0x0035e7c4, // n0x125c c0x0000 (---------------)  + I graz
	0x00227308, // n0x125d c0x0000 (---------------)  + I guernsey
	0x00290fca, // n0x125e c0x0000 (---------------)  + I halloffame
	0x0036f2c7, // n0x125f c0x0000 (---------------)  + I hamburg
	0x00358847, // n0x1260 c0x0000 (---------------)  + I handson
	0x00284852, // n0x1261 c0x0000 (---------------)  + I harvestcelebration
	0x00288206, // n0x1262 c0x0000 (---------------)  + I hawaii
	0x00241cc6, // n0x1263 c0x0000 (---------------)  + I health
	0x002dab8e, // n0x1264 c0x0000 (---------------)  + I heimatunduhren
	0x002ace06, // n0x1265 c0x0000 (---------------)  + I hellas
	0x0020eb08, // n0x1266 c0x0000 (---------------)  + I helsinki
	0x0035a4cf, // n0x1267 c0x0000 (---------------)  + I hembygdsforbund
	0x0036f888, // n0x1268 c0x0000 (---------------)  + I heritage
	0x0026a648, // n0x1269 c0x0000 (---------------)  + I histoire
	0x002e884a, // n0x126a c0x0000 (---------------)  + I historical
	0x002e8851, // n0x126b c0x0000 (---------------)  + I historicalsociety
	0x00296d8e, // n0x126c c0x0000 (---------------)  + I historichouses
	0x002517ca, // n0x126d c0x0000 (---------------)  + I historisch
	0x002517cc, // n0x126e c0x0000 (---------------)  + I historisches
	0x00234c07, // n0x126f c0x0000 (---------------)  + I history
	0x00234c10, // n0x1270 c0x0000 (---------------)  + I historyofscience
	0x00204e08, // n0x1271 c0x0000 (---------------)  + I horology
	0x0022ca85, // n0x1272 c0x0000 (---------------)  + I house
	0x002e50ca, // n0x1273 c0x0000 (---------------)  + I humanities
	0x00207fcc, // n0x1274 c0x0000 (---------------)  + I illustration
	0x002d468d, // n0x1275 c0x0000 (---------------)  + I imageandsound
	0x00226c06, // n0x1276 c0x0000 (---------------)  + I indian
	0x002e2587, // n0x1277 c0x0000 (---------------)  + I indiana
	0x002e258c, // n0x1278 c0x0000 (---------------)  + I indianapolis
	0x00226c0c, // n0x1279 c0x0000 (---------------)  + I indianmarket
	0x002188cc, // n0x127a c0x0000 (---------------)  + I intelligence
	0x002a038b, // n0x127b c0x0000 (---------------)  + I interactive
	0x0027eec4, // n0x127c c0x0000 (---------------)  + I iraq
	0x0021c2c4, // n0x127d c0x0000 (---------------)  + I iron
	0x003406c9, // n0x127e c0x0000 (---------------)  + I isleofman
	0x002bd2c7, // n0x127f c0x0000 (---------------)  + I jamison
	0x0022eec9, // n0x1280 c0x0000 (---------------)  + I jefferson
	0x002d7909, // n0x1281 c0x0000 (---------------)  + I jerusalem
	0x00378e87, // n0x1282 c0x0000 (---------------)  + I jewelry
	0x002a11c6, // n0x1283 c0x0000 (---------------)  + I jewish
	0x002a11c9, // n0x1284 c0x0000 (---------------)  + I jewishart
	0x002a1803, // n0x1285 c0x0000 (---------------)  + I jfk
	0x002b954a, // n0x1286 c0x0000 (---------------)  + I journalism
	0x00367007, // n0x1287 c0x0000 (---------------)  + I judaica
	0x002384cb, // n0x1288 c0x0000 (---------------)  + I judygarland
	0x0032deca, // n0x1289 c0x0000 (---------------)  + I juedisches
	0x00257ec4, // n0x128a c0x0000 (---------------)  + I juif
	0x002f1f06, // n0x128b c0x0000 (---------------)  + I karate
	0x002b4d09, // n0x128c c0x0000 (---------------)  + I karikatur
	0x0025c784, // n0x128d c0x0000 (---------------)  + I kids
	0x0020cf4a, // n0x128e c0x0000 (---------------)  + I koebenhavn
	0x0024db85, // n0x128f c0x0000 (---------------)  + I koeln
	0x002a9905, // n0x1290 c0x0000 (---------------)  + I kunst
	0x002a990d, // n0x1291 c0x0000 (---------------)  + I kunstsammlung
	0x002a9c4e, // n0x1292 c0x0000 (---------------)  + I kunstunddesign
	0x00306685, // n0x1293 c0x0000 (---------------)  + I labor
	0x0035e106, // n0x1294 c0x0000 (---------------)  + I labour
	0x003819c7, // n0x1295 c0x0000 (---------------)  + I lajolla
	0x0022268a, // n0x1296 c0x0000 (---------------)  + I lancashire
	0x0037d1c6, // n0x1297 c0x0000 (---------------)  + I landes
	0x002a8ac4, // n0x1298 c0x0000 (---------------)  + I lans
	0x003109c7, // n0x1299 c0x0000 (---------------)  + I larsson
	0x0029730b, // n0x129a c0x0000 (---------------)  + I lewismiller
	0x00376747, // n0x129b c0x0000 (---------------)  + I lincoln
	0x00369304, // n0x129c c0x0000 (---------------)  + I linz
	0x00284006, // n0x129d c0x0000 (---------------)  + I living
	0x0028400d, // n0x129e c0x0000 (---------------)  + I livinghistory
	0x00253ecc, // n0x129f c0x0000 (---------------)  + I localhistory
	0x0021d286, // n0x12a0 c0x0000 (---------------)  + I london
	0x0021500a, // n0x12a1 c0x0000 (---------------)  + I losangeles
	0x00226286, // n0x12a2 c0x0000 (---------------)  + I louvre
	0x0036be88, // n0x12a3 c0x0000 (---------------)  + I loyalist
	0x00380847, // n0x12a4 c0x0000 (---------------)  + I lucerne
	0x00242aca, // n0x12a5 c0x0000 (---------------)  + I luxembourg
	0x00248246, // n0x12a6 c0x0000 (---------------)  + I luzern
	0x00276743, // n0x12a7 c0x0000 (---------------)  + I mad
	0x00309b86, // n0x12a8 c0x0000 (---------------)  + I madrid
	0x00364908, // n0x12a9 c0x0000 (---------------)  + I mallorca
	0x0034084a, // n0x12aa c0x0000 (---------------)  + I manchester
	0x00279207, // n0x12ab c0x0000 (---------------)  + I mansion
	0x00279208, // n0x12ac c0x0000 (---------------)  + I mansions
	0x0027c384, // n0x12ad c0x0000 (---------------)  + I manx
	0x00322fc7, // n0x12ae c0x0000 (---------------)  + I marburg
	0x00246948, // n0x12af c0x0000 (---------------)  + I maritime
	0x003172c8, // n0x12b0 c0x0000 (---------------)  + I maritimo
	0x0036a988, // n0x12b1 c0x0000 (---------------)  + I maryland
	0x0020448a, // n0x12b2 c0x0000 (---------------)  + I marylhurst
	0x0021e585, // n0x12b3 c0x0000 (---------------)  + I media
	0x00384a47, // n0x12b4 c0x0000 (---------------)  + I medical
	0x00251613, // n0x12b5 c0x0000 (---------------)  + I medizinhistorisches
	0x00264ac6, // n0x12b6 c0x0000 (---------------)  + I meeres
	0x0035fe88, // n0x12b7 c0x0000 (---------------)  + I memorial
	0x002a78c9, // n0x12b8 c0x0000 (---------------)  + I mesaverde
	0x002250c8, // n0x12b9 c0x0000 (---------------)  + I michigan
	0x0026324b, // n0x12ba c0x0000 (---------------)  + I midatlantic
	0x00315248, // n0x12bb c0x0000 (---------------)  + I military
	0x00240444, // n0x12bc c0x0000 (---------------)  + I mill
	0x002adb06, // n0x12bd c0x0000 (---------------)  + I miners
	0x00386146, // n0x12be c0x0000 (---------------)  + I mining
	0x002e8109, // n0x12bf c0x0000 (---------------)  + I minnesota
	0x002b2bc7, // n0x12c0 c0x0000 (---------------)  + I missile
	0x002542c8, // n0x12c1 c0x0000 (---------------)  + I missoula
	0x002932c6, // n0x12c2 c0x0000 (---------------)  + I modern
	0x0022b784, // n0x12c3 c0x0000 (---------------)  + I moma
	0x002bac05, // n0x12c4 c0x0000 (---------------)  + I money
	0x002b5548, // n0x12c5 c0x0000 (---------------)  + I monmouth
	0x002b580a, // n0x12c6 c0x0000 (---------------)  + I monticello
	0x002b6048, // n0x12c7 c0x0000 (---------------)  + I montreal
	0x002bbb46, // n0x12c8 c0x0000 (---------------)  + I moscow
	0x0029088a, // n0x12c9 c0x0000 (---------------)  + I motorcycle
	0x002ed3c8, // n0x12ca c0x0000 (---------------)  + I muenchen
	0x002be1c8, // n0x12cb c0x0000 (---------------)  + I muenster
	0x002bf1c8, // n0x12cc c0x0000 (---------------)  + I mulhouse
	0x002c0686, // n0x12cd c0x0000 (---------------)  + I muncie
	0x002c2446, // n0x12ce c0x0000 (---------------)  + I museet
	0x00311b0c, // n0x12cf c0x0000 (---------------)  + I museumcenter
	0x002c2a10, // n0x12d0 c0x0000 (---------------)  + I museumvereniging
	0x00294545, // n0x12d1 c0x0000 (---------------)  + I music
	0x002f0408, // n0x12d2 c0x0000 (---------------)  + I national
	0x002f0410, // n0x12d3 c0x0000 (---------------)  + I nationalfirearms
	0x0036f690, // n0x12d4 c0x0000 (---------------)  + I nationalheritage
	0x0027480e, // n0x12d5 c0x0000 (---------------)  + I nativeamerican
	0x0031178e, // n0x12d6 c0x0000 (---------------)  + I naturalhistory
	0x00311794, // n0x12d7 c0x0000 (---------------)  + I naturalhistorymuseum
	0x0031288f, // n0x12d8 c0x0000 (---------------)  + I naturalsciences
	0x00312c46, // n0x12d9 c0x0000 (---------------)  + I nature
	0x0031a4d1, // n0x12da c0x0000 (---------------)  + I naturhistorisches
	0x0036ae13, // n0x12db c0x0000 (---------------)  + I natuurwetenschappen
	0x0036b288, // n0x12dc c0x0000 (---------------)  + I naumburg
	0x00382dc5, // n0x12dd c0x0000 (---------------)  + I naval
	0x00272788, // n0x12de c0x0000 (---------------)  + I nebraska
	0x0022c645, // n0x12df c0x0000 (---------------)  + I neues
	0x00230c4c, // n0x12e0 c0x0000 (---------------)  + I newhampshire
	0x00242489, // n0x12e1 c0x0000 (---------------)  + I newjersey
	0x00273cc9, // n0x12e2 c0x0000 (---------------)  + I newmexico
	0x00216707, // n0x12e3 c0x0000 (---------------)  + I newport
	0x00234589, // n0x12e4 c0x0000 (---------------)  + I newspaper
	0x0021f847, // n0x12e5 c0x0000 (---------------)  + I newyork
	0x0021c606, // n0x12e6 c0x0000 (---------------)  + I niepce
	0x0023aa47, // n0x12e7 c0x0000 (---------------)  + I norfolk
	0x002e6285, // n0x12e8 c0x0000 (---------------)  + I north
	0x0022d2c3, // n0x12e9 c0x0000 (---------------)  + I nrw
	0x0020fd89, // n0x12ea c0x0000 (---------------)  + I nuernberg
	0x002f6009, // n0x12eb c0x0000 (---------------)  + I nuremberg
	0x0021af43, // n0x12ec c0x0000 (---------------)  + I nyc
	0x002335c4, // n0x12ed c0x0000 (---------------)  + I nyny
	0x00376c0d, // n0x12ee c0x0000 (---------------)  + I oceanographic
	0x0020698f, // n0x12ef c0x0000 (---------------)  + I oceanographique
	0x002f4f85, // n0x12f0 c0x0000 (---------------)  + I omaha
	0x0030be06, // n0x12f1 c0x0000 (---------------)  + I online
	0x0022fc87, // n0x12f2 c0x0000 (---------------)  + I ontario
	0x00347807, // n0x12f3 c0x0000 (---------------)  + I openair
	0x002814c6, // n0x12f4 c0x0000 (---------------)  + I oregon
	0x002814cb, // n0x12f5 c0x0000 (---------------)  + I oregontrail
	0x00297dc5, // n0x12f6 c0x0000 (---------------)  + I otago
	0x003810c6, // n0x12f7 c0x0000 (---------------)  + I oxford
	0x00269607, // n0x12f8 c0x0000 (---------------)  + I pacific
	0x00225709, // n0x12f9 c0x0000 (---------------)  + I paderborn
	0x00200ac6, // n0x12fa c0x0000 (---------------)  + I palace
	0x0022b305, // n0x12fb c0x0000 (---------------)  + I paleo
	0x0022e70b, // n0x12fc c0x0000 (---------------)  + I palmsprings
	0x0024aa86, // n0x12fd c0x0000 (---------------)  + I panama
	0x00256585, // n0x12fe c0x0000 (---------------)  + I paris
	0x002cbe48, // n0x12ff c0x0000 (---------------)  + I pasadena
	0x002c5a88, // n0x1300 c0x0000 (---------------)  + I pharmacy
	0x002c5e4c, // n0x1301 c0x0000 (---------------)  + I philadelphia
	0x002c5e50, // n0x1302 c0x0000 (---------------)  + I philadelphiaarea
	0x002c6509, // n0x1303 c0x0000 (---------------)  + I philately
	0x002c6c07, // n0x1304 c0x0000 (---------------)  + I phoenix
	0x002c718b, // n0x1305 c0x0000 (---------------)  + I photography
	0x002c8e06, // n0x1306 c0x0000 (---------------)  + I pilots
	0x002c998a, // n0x1307 c0x0000 (---------------)  + I pittsburgh
	0x002ca30b, // n0x1308 c0x0000 (---------------)  + I planetarium
	0x002cab4a, // n0x1309 c0x0000 (---------------)  + I plantation
	0x002cadc6, // n0x130a c0x0000 (---------------)  + I plants
	0x002cb405, // n0x130b c0x0000 (---------------)  + I plaza
	0x00366d46, // n0x130c c0x0000 (---------------)  + I portal
	0x0027e008, // n0x130d c0x0000 (---------------)  + I portland
	0x002167ca, // n0x130e c0x0000 (---------------)  + I portlligat
	0x002ce7dc, // n0x130f c0x0000 (---------------)  + I posts-and-telecommunications
	0x002cf3cc, // n0x1310 c0x0000 (---------------)  + I preservation
	0x002cf6c8, // n0x1311 c0x0000 (---------------)  + I presidio
	0x0022ad45, // n0x1312 c0x0000 (---------------)  + I press
	0x002d0fc7, // n0x1313 c0x0000 (---------------)  + I project
	0x002d7ec6, // n0x1314 c0x0000 (---------------)  + I public
	0x00375845, // n0x1315 c0x0000 (---------------)  + I pubol
	0x0021b2c6, // n0x1316 c0x0000 (---------------)  + I quebec
	0x00281688, // n0x1317 c0x0000 (---------------)  + I railroad
	0x00342b07, // n0x1318 c0x0000 (---------------)  + I railway
	0x002d8188, // n0x1319 c0x0000 (---------------)  + I research
	0x0033a44a, // n0x131a c0x0000 (---------------)  + I resistance
	0x002ee8cc, // n0x131b c0x0000 (---------------)  + I riodejaneiro
	0x002eeb49, // n0x131c c0x0000 (---------------)  + I rochester
	0x0037bc87, // n0x131d c0x0000 (---------------)  + I rockart
	0x00225c04, // n0x131e c0x0000 (---------------)  + I roma
	0x002c5cc6, // n0x131f c0x0000 (---------------)  + I russia
	0x002ea34a, // n0x1320 c0x0000 (---------------)  + I saintlouis
	0x002d7a05, // n0x1321 c0x0000 (---------------)  + I salem
	0x0022204c, // n0x1322 c0x0000 (---------------)  + I salvadordali
	0x00224d48, // n0x1323 c0x0000 (---------------)  + I salzburg
	0x00322888, // n0x1324 c0x0000 (---------------)  + I sandiego
	0x00250a0c, // n0x1325 c0x0000 (---------------)  + I sanfrancisco
	0x00232acc, // n0x1326 c0x0000 (---------------)  + I santabarbara
	0x0023bf09, // n0x1327 c0x0000 (---------------)  + I santacruz
	0x0023ed47, // n0x1328 c0x0000 (---------------)  + I santafe
	0x0025220c, // n0x1329 c0x0000 (---------------)  + I saskatchewan
	0x00255bc4, // n0x132a c0x0000 (---------------)  + I satx
	0x0025e88a, // n0x132b c0x0000 (---------------)  + I savannahga
	0x003856cc, // n0x132c c0x0000 (---------------)  + I schlesisches
	0x0026638b, // n0x132d c0x0000 (---------------)  + I schoenbrunn
	0x0026d70b, // n0x132e c0x0000 (---------------)  + I schokoladen
	0x00275006, // n0x132f c0x0000 (---------------)  + I school
	0x0027cb07, // n0x1330 c0x0000 (---------------)  + I schweiz
	0x00234e47, // n0x1331 c0x0000 (---------------)  + I science
	0x00234e4f, // n0x1332 c0x0000 (---------------)  + I science-fiction
	0x002e2cd1, // n0x1333 c0x0000 (---------------)  + I scienceandhistory
	0x0026fc12, // n0x1334 c0x0000 (---------------)  + I scienceandindustry
	0x0027e6cd, // n0x1335 c0x0000 (---------------)  + I sciencecenter
	0x0027e6ce, // n0x1336 c0x0000 (---------------)  + I sciencecenters
	0x0027ea0e, // n0x1337 c0x0000 (---------------)  + I sciencehistory
	0x00312a48, // n0x1338 c0x0000 (---------------)  + I sciences
	0x00312a52, // n0x1339 c0x0000 (---------------)  + I sciencesnaturelles
	0x00250c48, // n0x133a c0x0000 (---------------)  + I scotland
	0x002f2807, // n0x133b c0x0000 (---------------)  + I seaport
	0x0024b38a, // n0x133c c0x0000 (---------------)  + I settlement
	0x0021d048, // n0x133d c0x0000 (---------------)  + I settlers
	0x002acdc5, // n0x133e c0x0000 (---------------)  + I shell
	0x002afe8a, // n0x133f c0x0000 (---------------)  + I sherbrooke
	0x0029b107, // n0x1340 c0x0000 (---------------)  + I sibenik
	0x0033aac4, // n0x1341 c0x0000 (---------------)  + I silk
	0x00221943, // n0x1342 c0x0000 (---------------)  + I ski
	0x002f5245, // n0x1343 c0x0000 (---------------)  + I skole
	0x002e8ac7, // n0x1344 c0x0000 (---------------)  + I society
	0x0034f247, // n0x1345 c0x0000 (---------------)  + I sologne
	0x002d488e, // n0x1346 c0x0000 (---------------)  + I soundandvision
	0x002d87cd, // n0x1347 c0x0000 (---------------)  + I southcarolina
	0x002d8c09, // n0x1348 c0x0000 (---------------)  + I southwest
	0x002d91c5, // n0x1349 c0x0000 (---------------)  + I space
	0x002dc043, // n0x134a c0x0000 (---------------)  + I spy
	0x00365006, // n0x134b c0x0000 (---------------)  + I square
	0x00256a45, // n0x134c c0x0000 (---------------)  + I stadt
	0x002a7cc8, // n0x134d c0x0000 (---------------)  + I stalbans
	0x002c01c9, // n0x134e c0x0000 (---------------)  + I starnberg
	0x0025d745, // n0x134f c0x0000 (---------------)  + I state
	0x002b628f, // n0x1350 c0x0000 (---------------)  + I stateofdelaware
	0x00225f47, // n0x1351 c0x0000 (---------------)  + I station
	0x00383845, // n0x1352 c0x0000 (---------------)  + I steam
	0x002ff18a, // n0x1353 c0x0000 (---------------)  + I steiermark
	0x00206706, // n0x1354 c0x0000 (---------------)  + I stjohn
	0x0036c009, // n0x1355 c0x0000 (---------------)  + I stockholm
	0x002dcc0c, // n0x1356 c0x0000 (---------------)  + I stpetersburg
	0x002dde09, // n0x1357 c0x0000 (---------------)  + I stuttgart
	0x0020bd86, // n0x1358 c0x0000 (---------------)  + I suisse
	0x00290dcc, // n0x1359 c0x0000 (---------------)  + I surgeonshall
	0x002de486, // n0x135a c0x0000 (---------------)  + I surrey
	0x002e1e48, // n0x135b c0x0000 (---------------)  + I svizzera
	0x00245d86, // n0x135c c0x0000 (---------------)  + I sweden
	0x00266bc6, // n0x135d c0x0000 (---------------)  + I sydney
	0x0029bd44, // n0x135e c0x0000 (---------------)  + I tank
	0x002a4403, // n0x135f c0x0000 (---------------)  + I tcm
	0x002a394a, // n0x1360 c0x0000 (---------------)  + I technology
	0x00311391, // n0x1361 c0x0000 (---------------)  + I telekommunikation
	0x002a0f4a, // n0x1362 c0x0000 (---------------)  + I television
	0x0031e985, // n0x1363 c0x0000 (---------------)  + I texas
	0x00295047, // n0x1364 c0x0000 (---------------)  + I textile
	0x0036d6c7, // n0x1365 c0x0000 (---------------)  + I theater
	0x00246a44, // n0x1366 c0x0000 (---------------)  + I time
	0x00246a4b, // n0x1367 c0x0000 (---------------)  + I timekeeping
	0x002ec988, // n0x1368 c0x0000 (---------------)  + I topology
	0x002a6206, // n0x1369 c0x0000 (---------------)  + I torino
	0x002318c5, // n0x136a c0x0000 (---------------)  + I touch
	0x0023bb04, // n0x136b c0x0000 (---------------)  + I town
	0x0028f1c9, // n0x136c c0x0000 (---------------)  + I transport
	0x0029d704, // n0x136d c0x0000 (---------------)  + I tree
	0x00222d07, // n0x136e c0x0000 (---------------)  + I trolley
	0x00313345, // n0x136f c0x0000 (---------------)  + I trust
	0x00313347, // n0x1370 c0x0000 (---------------)  + I trustee
	0x002dadc5, // n0x1371 c0x0000 (---------------)  + I uhren
	0x00216b83, // n0x1372 c0x0000 (---------------)  + I ulm
	0x002f26c8, // n0x1373 c0x0000 (---------------)  + I undersea
	0x003826ca, // n0x1374 c0x0000 (---------------)  + I university
	0x00232883, // n0x1375 c0x0000 (---------------)  + I usa
	0x0023288a, // n0x1376 c0x0000 (---------------)  + I usantiques
	0x00378506, // n0x1377 c0x0000 (---------------)  + I usarts
	0x0025d4cf, // n0x1378 c0x0000 (---------------)  + I uscountryestate
	0x0031df49, // n0x1379 c0x0000 (---------------)  + I usculture
	0x00249d50, // n0x137a c0x0000 (---------------)  + I usdecorativearts
	0x0025f208, // n0x137b c0x0000 (---------------)  + I usgarden
	0x002bbdc9, // n0x137c c0x0000 (---------------)  + I ushistory
	0x0028b247, // n0x137d c0x0000 (---------------)  + I ushuaia
	0x00283f8f, // n0x137e c0x0000 (---------------)  + I uslivinghistory
	0x00202fc4, // n0x137f c0x0000 (---------------)  + I utah
	0x002525c4, // n0x1380 c0x0000 (---------------)  + I uvic
	0x0021e946, // n0x1381 c0x0000 (---------------)  + I valley
	0x0022f946, // n0x1382 c0x0000 (---------------)  + I vantaa
	0x002e7b4a, // n0x1383 c0x0000 (---------------)  + I versailles
	0x002b67c6, // n0x1384 c0x0000 (---------------)  + I viking
	0x0031d1c7, // n0x1385 c0x0000 (---------------)  + I village
	0x002efb88, // n0x1386 c0x0000 (---------------)  + I virginia
	0x002efd87, // n0x1387 c0x0000 (---------------)  + I virtual
	0x002eff47, // n0x1388 c0x0000 (---------------)  + I virtuel
	0x00326bca, // n0x1389 c0x0000 (---------------)  + I vlaanderen
	0x002f250b, // n0x138a c0x0000 (---------------)  + I volkenkunde
	0x00236485, // n0x138b c0x0000 (---------------)  + I wales
	0x0026f848, // n0x138c c0x0000 (---------------)  + I wallonie
	0x00235783, // n0x138d c0x0000 (---------------)  + I war
	0x0020014c, // n0x138e c0x0000 (---------------)  + I washingtondc
	0x00205e4f, // n0x138f c0x0000 (---------------)  + I watch-and-clock
	0x0036e34d, // n0x1390 c0x0000 (---------------)  + I watchandclock
	0x002d8d47, // n0x1391 c0x0000 (---------------)  + I western
	0x00211789, // n0x1392 c0x0000 (---------------)  + I westfalen
	0x0022d347, // n0x1393 c0x0000 (---------------)  + I whaling
	0x00276ec8, // n0x1394 c0x0000 (---------------)  + I wildlife
	0x0023148c, // n0x1395 c0x0000 (---------------)  + I williamsburg
	0x00240348, // n0x1396 c0x0000 (---------------)  + I windmill
	0x0022e548, // n0x1397 c0x0000 (---------------)  + I workshop
	0x0030004e, // n0x1398 c0x0000 (---------------)  + I xn--9dbhblg6di
	0x0030f0d4, // n0x1399 c0x0000 (---------------)  + I xn--comunicaes-v6a2o
	0x0030f5e4, // n0x139a c0x0000 (---------------)  + I xn--correios-e-telecomunicaes-ghc29a
	0x0032084a, // n0x139b c0x0000 (---------------)  + I xn--h1aegh
	0x0033794b, // n0x139c c0x0000 (---------------)  + I xn--lns-qla
	0x0021f904, // n0x139d c0x0000 (---------------)  + I york
	0x0021f909, // n0x139e c0x0000 (---------------)  + I yorkshire
	0x002e6f08, // n0x139f c0x0000 (---------------)  + I yosemite
	0x00341085, // n0x13a0 c0x0000 (---------------)  + I youth
	0x00377d4a, // n0x13a1 c0x0000 (---------------)  + I zoological
	0x003651c7, // n0x13a2 c0x0000 (---------------)  + I zoology
	0x00233784, // n0x13a3 c0x0000 (---------------)  + I aero
	0x00202183, // n0x13a4 c0x0000 (---------------)  + I biz
	0x00232dc3, // n0x13a5 c0x0000 (---------------)  + I com
	0x0023a884, // n0x13a6 c0x0000 (---------------)  + I coop
	0x0021e083, // n0x13a7 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x13a8 c0x0000 (---------------)  + I gov
	0x00208a44, // n0x13a9 c0x0000 (---------------)  + I info
	0x002188c3, // n0x13aa c0x0000 (---------------)  + I int
	0x00240443, // n0x13ab c0x0000 (---------------)  + I mil
	0x002c2a06, // n0x13ac c0x0000 (---------------)  + I museum
	0x00267944, // n0x13ad c0x0000 (---------------)  + I name
	0x00218643, // n0x13ae c0x0000 (---------------)  + I net
	0x0024d043, // n0x13af c0x0000 (---------------)  + I org
	0x002cfc43, // n0x13b0 c0x0000 (---------------)  + I pro
	0x00200b82, // n0x13b1 c0x0000 (---------------)  + I ac
	0x00202183, // n0x13b2 c0x0000 (---------------)  + I biz
	0x00200882, // n0x13b3 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x13b4 c0x0000 (---------------)  + I com
	0x0023a884, // n0x13b5 c0x0000 (---------------)  + I coop
	0x0021e083, // n0x13b6 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x13b7 c0x0000 (---------------)  + I gov
	0x002188c3, // n0x13b8 c0x0000 (---------------)  + I int
	0x002c2a06, // n0x13b9 c0x0000 (---------------)  + I museum
	0x00218643, // n0x13ba c0x0000 (---------------)  + I net
	0x0024d043, // n0x13bb c0x0000 (---------------)  + I org
	0x0009e448, // n0x13bc c0x0000 (---------------)  +   blogspot
	0x00232dc3, // n0x13bd c0x0000 (---------------)  + I com
	0x0021e083, // n0x13be c0x0000 (---------------)  + I edu
	0x003704c3, // n0x13bf c0x0000 (---------------)  + I gob
	0x00218643, // n0x13c0 c0x0000 (---------------)  + I net
	0x0024d043, // n0x13c1 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x13c2 c0x0000 (---------------)  + I com
	0x0021e083, // n0x13c3 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x13c4 c0x0000 (---------------)  + I gov
	0x00240443, // n0x13c5 c0x0000 (---------------)  + I mil
	0x00267944, // n0x13c6 c0x0000 (---------------)  + I name
	0x00218643, // n0x13c7 c0x0000 (---------------)  + I net
	0x0024d043, // n0x13c8 c0x0000 (---------------)  + I org
	0x00685648, // n0x13c9 c0x0001 (---------------)  ! I teledata
	0x00214582, // n0x13ca c0x0000 (---------------)  + I ca
	0x002020c2, // n0x13cb c0x0000 (---------------)  + I cc
	0x00200882, // n0x13cc c0x0000 (---------------)  + I co
	0x00232dc3, // n0x13cd c0x0000 (---------------)  + I com
	0x0020fc02, // n0x13ce c0x0000 (---------------)  + I dr
	0x00200242, // n0x13cf c0x0000 (---------------)  + I in
	0x00208a44, // n0x13d0 c0x0000 (---------------)  + I info
	0x00277f84, // n0x13d1 c0x0000 (---------------)  + I mobi
	0x0022cd82, // n0x13d2 c0x0000 (---------------)  + I mx
	0x00267944, // n0x13d3 c0x0000 (---------------)  + I name
	0x00200d02, // n0x13d4 c0x0000 (---------------)  + I or
	0x0024d043, // n0x13d5 c0x0000 (---------------)  + I org
	0x002cfc43, // n0x13d6 c0x0000 (---------------)  + I pro
	0x00275006, // n0x13d7 c0x0000 (---------------)  + I school
	0x0028dc82, // n0x13d8 c0x0000 (---------------)  + I tv
	0x002073c2, // n0x13d9 c0x0000 (---------------)  + I us
	0x002012c2, // n0x13da c0x0000 (---------------)  + I ws
	0x33241483, // n0x13db c0x00cc (n0x13dd-n0x13de)  o I her
	0x33634c03, // n0x13dc c0x00cd (n0x13de-n0x13df)  o I his
	0x00052a06, // n0x13dd c0x0000 (---------------)  +   forgot
	0x00052a06, // n0x13de c0x0000 (---------------)  +   forgot
	0x00278344, // n0x13df c0x0000 (---------------)  + I asso
	0x0010964c, // n0x13e0 c0x0000 (---------------)  +   at-band-camp
	0x00077e0c, // n0x13e1 c0x0000 (---------------)  +   azure-mobile
	0x000b46cd, // n0x13e2 c0x0000 (---------------)  +   azurewebsites
	0x000dd187, // n0x13e3 c0x0000 (---------------)  +   blogdns
	0x00027508, // n0x13e4 c0x0000 (---------------)  +   broke-it
	0x0002c98a, // n0x13e5 c0x0000 (---------------)  +   buyshouses
	0x0017e388, // n0x13e6 c0x0000 (---------------)  +   cloudapp
	0x0002faca, // n0x13e7 c0x0000 (---------------)  +   cloudfront
	0x000c7a88, // n0x13e8 c0x0000 (---------------)  +   dnsalias
	0x00181687, // n0x13e9 c0x0000 (---------------)  +   dnsdojo
	0x000100c7, // n0x13ea c0x0000 (---------------)  +   does-it
	0x0012cb09, // n0x13eb c0x0000 (---------------)  +   dontexist
	0x00159288, // n0x13ec c0x0000 (---------------)  +   dynalias
	0x0008ee89, // n0x13ed c0x0000 (---------------)  +   dynathome
	0x0009d40d, // n0x13ee c0x0000 (---------------)  +   endofinternet
	0x342d0e46, // n0x13ef c0x00d0 (n0x140f-n0x1411)  o I fastly
	0x0005cdc7, // n0x13f0 c0x0000 (---------------)  +   from-az
	0x0005e047, // n0x13f1 c0x0000 (---------------)  +   from-co
	0x00063947, // n0x13f2 c0x0000 (---------------)  +   from-la
	0x00068707, // n0x13f3 c0x0000 (---------------)  +   from-ny
	0x0000cd02, // n0x13f4 c0x0000 (---------------)  +   gb
	0x0009c187, // n0x13f5 c0x0000 (---------------)  +   gets-it
	0x00113b0c, // n0x13f6 c0x0000 (---------------)  +   ham-radio-op
	0x0000ddc7, // n0x13f7 c0x0000 (---------------)  +   homeftp
	0x000b9206, // n0x13f8 c0x0000 (---------------)  +   homeip
	0x00099409, // n0x13f9 c0x0000 (---------------)  +   homelinux
	0x00099ec8, // n0x13fa c0x0000 (---------------)  +   homeunix
	0x000045c2, // n0x13fb c0x0000 (---------------)  +   hu
	0x00000242, // n0x13fc c0x0000 (---------------)  +   in
	0x00061ccb, // n0x13fd c0x0000 (---------------)  +   in-the-band
	0x0001f409, // n0x13fe c0x0000 (---------------)  +   is-a-chef
	0x00047789, // n0x13ff c0x0000 (---------------)  +   is-a-geek
	0x00013e48, // n0x1400 c0x0000 (---------------)  +   isa-geek
	0x000a2b02, // n0x1401 c0x0000 (---------------)  +   jp
	0x00132909, // n0x1402 c0x0000 (---------------)  +   kicks-ass
	0x00015fcd, // n0x1403 c0x0000 (---------------)  +   office-on-the
	0x000ccf07, // n0x1404 c0x0000 (---------------)  +   podzone
	0x000866cd, // n0x1405 c0x0000 (---------------)  +   scrapper-site
	0x00004982, // n0x1406 c0x0000 (---------------)  +   se
	0x00141246, // n0x1407 c0x0000 (---------------)  +   selfip
	0x0009f9c8, // n0x1408 c0x0000 (---------------)  +   sells-it
	0x0000be88, // n0x1409 c0x0000 (---------------)  +   servebbs
	0x0008e548, // n0x140a c0x0000 (---------------)  +   serveftp
	0x00041388, // n0x140b c0x0000 (---------------)  +   thruhere
	0x00000542, // n0x140c c0x0000 (---------------)  +   uk
	0x0002c186, // n0x140d c0x0000 (---------------)  +   webhop
	0x000028c2, // n0x140e c0x0000 (---------------)  +   za
	0x346cfec4, // n0x140f c0x00d1 (n0x1411-n0x1413)  o I prod
	0x34a89b83, // n0x1410 c0x00d2 (n0x1413-n0x1416)  o I ssl
	0x00000101, // n0x1411 c0x0000 (---------------)  +   a
	0x0000af86, // n0x1412 c0x0000 (---------------)  +   global
	0x00000101, // n0x1413 c0x0000 (---------------)  +   a
	0x00000001, // n0x1414 c0x0000 (---------------)  +   b
	0x0000af86, // n0x1415 c0x0000 (---------------)  +   global
	0x0020b384, // n0x1416 c0x0000 (---------------)  + I arts
	0x00232dc3, // n0x1417 c0x0000 (---------------)  + I com
	0x0024a304, // n0x1418 c0x0000 (---------------)  + I firm
	0x00208a44, // n0x1419 c0x0000 (---------------)  + I info
	0x00218643, // n0x141a c0x0000 (---------------)  + I net
	0x00256305, // n0x141b c0x0000 (---------------)  + I other
	0x0020c783, // n0x141c c0x0000 (---------------)  + I per
	0x0022a143, // n0x141d c0x0000 (---------------)  + I rec
	0x002dc745, // n0x141e c0x0000 (---------------)  + I store
	0x002071c3, // n0x141f c0x0000 (---------------)  + I web
	0x00232dc3, // n0x1420 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1421 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1422 c0x0000 (---------------)  + I gov
	0x00240443, // n0x1423 c0x0000 (---------------)  + I mil
	0x00277f84, // n0x1424 c0x0000 (---------------)  + I mobi
	0x00267944, // n0x1425 c0x0000 (---------------)  + I name
	0x00218643, // n0x1426 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1427 c0x0000 (---------------)  + I org
	0x00251983, // n0x1428 c0x0000 (---------------)  + I sch
	0x0009e448, // n0x1429 c0x0000 (---------------)  +   blogspot
	0x0036ed42, // n0x142a c0x0000 (---------------)  + I bv
	0x00000882, // n0x142b c0x0000 (---------------)  +   co
	0x35e01d82, // n0x142c c0x00d7 (n0x1702-n0x1703)  + I aa
	0x00367188, // n0x142d c0x0000 (---------------)  + I aarborte
	0x002292c6, // n0x142e c0x0000 (---------------)  + I aejrie
	0x002137c6, // n0x142f c0x0000 (---------------)  + I afjord
	0x00228c47, // n0x1430 c0x0000 (---------------)  + I agdenes
	0x36203042, // n0x1431 c0x00d8 (n0x1703-n0x1704)  + I ah
	0x3665d348, // n0x1432 c0x00d9 (n0x1704-n0x1705)  o I akershus
	0x0033264a, // n0x1433 c0x0000 (---------------)  + I aknoluokta
	0x0036ac48, // n0x1434 c0x0000 (---------------)  + I akrehamn
	0x00200b02, // n0x1435 c0x0000 (---------------)  + I al
	0x00366e49, // n0x1436 c0x0000 (---------------)  + I alaheadju
	0x002364c7, // n0x1437 c0x0000 (---------------)  + I alesund
	0x00219646, // n0x1438 c0x0000 (---------------)  + I algard
	0x00381289, // n0x1439 c0x0000 (---------------)  + I alstahaug
	0x0036d204, // n0x143a c0x0000 (---------------)  + I alta
	0x002ac1c6, // n0x143b c0x0000 (---------------)  + I alvdal
	0x002b0684, // n0x143c c0x0000 (---------------)  + I amli
	0x00268bc4, // n0x143d c0x0000 (---------------)  + I amot
	0x00253d09, // n0x143e c0x0000 (---------------)  + I andasuolo
	0x0032dc86, // n0x143f c0x0000 (---------------)  + I andebu
	0x0033c205, // n0x1440 c0x0000 (---------------)  + I andoy
	0x00220845, // n0x1441 c0x0000 (---------------)  + I ardal
	0x002650c7, // n0x1442 c0x0000 (---------------)  + I aremark
	0x002b6587, // n0x1443 c0x0000 (---------------)  + I arendal
	0x00283c44, // n0x1444 c0x0000 (---------------)  + I arna
	0x00228e86, // n0x1445 c0x0000 (---------------)  + I aseral
	0x002e7545, // n0x1446 c0x0000 (---------------)  + I asker
	0x002fbe85, // n0x1447 c0x0000 (---------------)  + I askim
	0x002acf05, // n0x1448 c0x0000 (---------------)  + I askoy
	0x002e71c7, // n0x1449 c0x0000 (---------------)  + I askvoll
	0x0035c5c5, // n0x144a c0x0000 (---------------)  + I asnes
	0x002324c9, // n0x144b c0x0000 (---------------)  + I audnedaln
	0x00360805, // n0x144c c0x0000 (---------------)  + I aukra
	0x002f0f04, // n0x144d c0x0000 (---------------)  + I aure
	0x0037d107, // n0x144e c0x0000 (---------------)  + I aurland
	0x003656ce, // n0x144f c0x0000 (---------------)  + I aurskog-holand
	0x00362fc9, // n0x1450 c0x0000 (---------------)  + I austevoll
	0x002daa49, // n0x1451 c0x0000 (---------------)  + I austrheim
	0x00296406, // n0x1452 c0x0000 (---------------)  + I averoy
	0x0030e488, // n0x1453 c0x0000 (---------------)  + I badaddja
	0x002fa94b, // n0x1454 c0x0000 (---------------)  + I bahcavuotna
	0x003644cc, // n0x1455 c0x0000 (---------------)  + I bahccavuotna
	0x00381c46, // n0x1456 c0x0000 (---------------)  + I baidar
	0x002c32c7, // n0x1457 c0x0000 (---------------)  + I bajddar
	0x0020b045, // n0x1458 c0x0000 (---------------)  + I balat
	0x0034960a, // n0x1459 c0x0000 (---------------)  + I balestrand
	0x00285949, // n0x145a c0x0000 (---------------)  + I ballangen
	0x0032d049, // n0x145b c0x0000 (---------------)  + I balsfjord
	0x002e5f86, // n0x145c c0x0000 (---------------)  + I bamble
	0x002e0c85, // n0x145d c0x0000 (---------------)  + I bardu
	0x002b9f45, // n0x145e c0x0000 (---------------)  + I barum
	0x0035f049, // n0x145f c0x0000 (---------------)  + I batsfjord
	0x0026f1cb, // n0x1460 c0x0000 (---------------)  + I bearalvahki
	0x00275a86, // n0x1461 c0x0000 (---------------)  + I beardu
	0x0021cb86, // n0x1462 c0x0000 (---------------)  + I beiarn
	0x0020cc44, // n0x1463 c0x0000 (---------------)  + I berg
	0x00284506, // n0x1464 c0x0000 (---------------)  + I bergen
	0x0020a748, // n0x1465 c0x0000 (---------------)  + I berlevag
	0x00203186, // n0x1466 c0x0000 (---------------)  + I bievat
	0x0034cb86, // n0x1467 c0x0000 (---------------)  + I bindal
	0x00209d48, // n0x1468 c0x0000 (---------------)  + I birkenes
	0x0020bb87, // n0x1469 c0x0000 (---------------)  + I bjarkoy
	0x0020c549, // n0x146a c0x0000 (---------------)  + I bjerkreim
	0x0020c8c5, // n0x146b c0x0000 (---------------)  + I bjugn
	0x0009e448, // n0x146c c0x0000 (---------------)  +   blogspot
	0x00210044, // n0x146d c0x0000 (---------------)  + I bodo
	0x00251b84, // n0x146e c0x0000 (---------------)  + I bokn
	0x00214285, // n0x146f c0x0000 (---------------)  + I bomlo
	0x0021fe49, // n0x1470 c0x0000 (---------------)  + I bremanger
	0x00227987, // n0x1471 c0x0000 (---------------)  + I bronnoy
	0x0022798b, // n0x1472 c0x0000 (---------------)  + I bronnoysund
	0x0022808a, // n0x1473 c0x0000 (---------------)  + I brumunddal
	0x0022c585, // n0x1474 c0x0000 (---------------)  + I bryne
	0x36a07902, // n0x1475 c0x00da (n0x1705-n0x1706)  + I bu
	0x0032dd87, // n0x1476 c0x0000 (---------------)  + I budejju
	0x36ebfec8, // n0x1477 c0x00db (n0x1706-n0x1707)  o I buskerud
	0x002be7c7, // n0x1478 c0x0000 (---------------)  + I bygland
	0x002be5c5, // n0x1479 c0x0000 (---------------)  + I bykle
	0x00245a8a, // n0x147a c0x0000 (---------------)  + I cahcesuolo
	0x00000882, // n0x147b c0x0000 (---------------)  +   co
	0x00203e4b, // n0x147c c0x0000 (---------------)  + I davvenjarga
	0x0020578a, // n0x147d c0x0000 (---------------)  + I davvesiida
	0x002f5f06, // n0x147e c0x0000 (---------------)  + I deatnu
	0x002da243, // n0x147f c0x0000 (---------------)  + I dep
	0x00359e8d, // n0x1480 c0x0000 (---------------)  + I dielddanuorri
	0x003601cc, // n0x1481 c0x0000 (---------------)  + I divtasvuodna
	0x0032d24d, // n0x1482 c0x0000 (---------------)  + I divttasvuotna
	0x0020d6c5, // n0x1483 c0x0000 (---------------)  + I donna
	0x0024b845, // n0x1484 c0x0000 (---------------)  + I dovre
	0x0020fc07, // n0x1485 c0x0000 (---------------)  + I drammen
	0x00369b09, // n0x1486 c0x0000 (---------------)  + I drangedal
	0x0036ab46, // n0x1487 c0x0000 (---------------)  + I drobak
	0x00233dc5, // n0x1488 c0x0000 (---------------)  + I dyroy
	0x00230908, // n0x1489 c0x0000 (---------------)  + I egersund
	0x00272a83, // n0x148a c0x0000 (---------------)  + I eid
	0x002f8648, // n0x148b c0x0000 (---------------)  + I eidfjord
	0x00284408, // n0x148c c0x0000 (---------------)  + I eidsberg
	0x002b1847, // n0x148d c0x0000 (---------------)  + I eidskog
	0x00272a88, // n0x148e c0x0000 (---------------)  + I eidsvoll
	0x00233bc9, // n0x148f c0x0000 (---------------)  + I eigersund
	0x002e7f87, // n0x1490 c0x0000 (---------------)  + I elverum
	0x002edb87, // n0x1491 c0x0000 (---------------)  + I enebakk
	0x002abd48, // n0x1492 c0x0000 (---------------)  + I engerdal
	0x0028c604, // n0x1493 c0x0000 (---------------)  + I etne
	0x0028c607, // n0x1494 c0x0000 (---------------)  + I etnedal
	0x0029af08, // n0x1495 c0x0000 (---------------)  + I evenassi
	0x0025e746, // n0x1496 c0x0000 (---------------)  + I evenes
	0x00220a4f, // n0x1497 c0x0000 (---------------)  + I evje-og-hornnes
	0x002a4547, // n0x1498 c0x0000 (---------------)  + I farsund
	0x002d1806, // n0x1499 c0x0000 (---------------)  + I fauske
	0x00350705, // n0x149a c0x0000 (---------------)  + I fedje
	0x00245f03, // n0x149b c0x0000 (---------------)  + I fet
	0x00245f07, // n0x149c c0x0000 (---------------)  + I fetsund
	0x00379703, // n0x149d c0x0000 (---------------)  + I fhs
	0x00248e06, // n0x149e c0x0000 (---------------)  + I finnoy
	0x0024b086, // n0x149f c0x0000 (---------------)  + I fitjar
	0x0024bb06, // n0x14a0 c0x0000 (---------------)  + I fjaler
	0x00288005, // n0x14a1 c0x0000 (---------------)  + I fjell
	0x0025f803, // n0x14a2 c0x0000 (---------------)  + I fla
	0x00346e08, // n0x14a3 c0x0000 (---------------)  + I flakstad
	0x0033f849, // n0x14a4 c0x0000 (---------------)  + I flatanger
	0x0034df8b, // n0x14a5 c0x0000 (---------------)  + I flekkefjord
	0x0024c608, // n0x14a6 c0x0000 (---------------)  + I flesberg
	0x0024dcc5, // n0x14a7 c0x0000 (---------------)  + I flora
	0x0024e845, // n0x14a8 c0x0000 (---------------)  + I floro
	0x37257f82, // n0x14a9 c0x00dc (n0x1707-n0x1708)  + I fm
	0x0023ab09, // n0x14aa c0x0000 (---------------)  + I folkebibl
	0x00250187, // n0x14ab c0x0000 (---------------)  + I folldal
	0x00381145, // n0x14ac c0x0000 (---------------)  + I forde
	0x00253c07, // n0x14ad c0x0000 (---------------)  + I forsand
	0x00255a86, // n0x14ae c0x0000 (---------------)  + I fosnes
	0x0033b685, // n0x14af c0x0000 (---------------)  + I frana
	0x0025688b, // n0x14b0 c0x0000 (---------------)  + I fredrikstad
	0x00256d04, // n0x14b1 c0x0000 (---------------)  + I frei
	0x0025bd85, // n0x14b2 c0x0000 (---------------)  + I frogn
	0x0025bec7, // n0x14b3 c0x0000 (---------------)  + I froland
	0x0026eb46, // n0x14b4 c0x0000 (---------------)  + I frosta
	0x0026ef85, // n0x14b5 c0x0000 (---------------)  + I froya
	0x0027bfc7, // n0x14b6 c0x0000 (---------------)  + I fuoisku
	0x0027c707, // n0x14b7 c0x0000 (---------------)  + I fuossko
	0x002ea2c4, // n0x14b8 c0x0000 (---------------)  + I fusa
	0x0028218a, // n0x14b9 c0x0000 (---------------)  + I fylkesbibl
	0x00282648, // n0x14ba c0x0000 (---------------)  + I fyresdal
	0x002fac09, // n0x14bb c0x0000 (---------------)  + I gaivuotna
	0x00253a45, // n0x14bc c0x0000 (---------------)  + I galsa
	0x00204086, // n0x14bd c0x0000 (---------------)  + I gamvik
	0x0020a90a, // n0x14be c0x0000 (---------------)  + I gangaviika
	0x00220746, // n0x14bf c0x0000 (---------------)  + I gaular
	0x0020ac07, // n0x14c0 c0x0000 (---------------)  + I gausdal
	0x002ecc8d, // n0x14c1 c0x0000 (---------------)  + I giehtavuoatna
	0x00224549, // n0x14c2 c0x0000 (---------------)  + I gildeskal
	0x002e4005, // n0x14c3 c0x0000 (---------------)  + I giske
	0x00323147, // n0x14c4 c0x0000 (---------------)  + I gjemnes
	0x0035fcc8, // n0x14c5 c0x0000 (---------------)  + I gjerdrum
	0x00363a88, // n0x14c6 c0x0000 (---------------)  + I gjerstad
	0x00369187, // n0x14c7 c0x0000 (---------------)  + I gjesdal
	0x0036b446, // n0x14c8 c0x0000 (---------------)  + I gjovik
	0x00212e87, // n0x14c9 c0x0000 (---------------)  + I gloppen
	0x00218743, // n0x14ca c0x0000 (---------------)  + I gol
	0x00315684, // n0x14cb c0x0000 (---------------)  + I gran
	0x0031cac5, // n0x14cc c0x0000 (---------------)  + I grane
	0x00338fc7, // n0x14cd c0x0000 (---------------)  + I granvin
	0x00356d89, // n0x14ce c0x0000 (---------------)  + I gratangen
	0x002f6208, // n0x14cf c0x0000 (---------------)  + I grimstad
	0x0037c785, // n0x14d0 c0x0000 (---------------)  + I grong
	0x0023c704, // n0x14d1 c0x0000 (---------------)  + I grue
	0x002497c5, // n0x14d2 c0x0000 (---------------)  + I gulen
	0x0025068d, // n0x14d3 c0x0000 (---------------)  + I guovdageaidnu
	0x00203082, // n0x14d4 c0x0000 (---------------)  + I ha
	0x003062c6, // n0x14d5 c0x0000 (---------------)  + I habmer
	0x00341186, // n0x14d6 c0x0000 (---------------)  + I hadsel
	0x002ffdca, // n0x14d7 c0x0000 (---------------)  + I hagebostad
	0x003467c6, // n0x14d8 c0x0000 (---------------)  + I halden
	0x0034c845, // n0x14d9 c0x0000 (---------------)  + I halsa
	0x002b0b45, // n0x14da c0x0000 (---------------)  + I hamar
	0x002b0b47, // n0x14db c0x0000 (---------------)  + I hamaroy
	0x0034f98c, // n0x14dc c0x0000 (---------------)  + I hammarfeasta
	0x0036c68a, // n0x14dd c0x0000 (---------------)  + I hammerfest
	0x00283a46, // n0x14de c0x0000 (---------------)  + I hapmir
	0x0026e385, // n0x14df c0x0000 (---------------)  + I haram
	0x00284346, // n0x14e0 c0x0000 (---------------)  + I hareid
	0x00284687, // n0x14e1 c0x0000 (---------------)  + I harstad
	0x00286506, // n0x14e2 c0x0000 (---------------)  + I hasvik
	0x00287f0c, // n0x14e3 c0x0000 (---------------)  + I hattfjelldal
	0x003813c9, // n0x14e4 c0x0000 (---------------)  + I haugesund
	0x37651fc7, // n0x14e5 c0x00dd (n0x1708-n0x170b)  o I hedmark
	0x00289485, // n0x14e6 c0x0000 (---------------)  + I hemne
	0x00289486, // n0x14e7 c0x0000 (---------------)  + I hemnes
	0x00289808, // n0x14e8 c0x0000 (---------------)  + I hemsedal
	0x0025c905, // n0x14e9 c0x0000 (---------------)  + I herad
	0x002987c5, // n0x14ea c0x0000 (---------------)  + I hitra
	0x00298a08, // n0x14eb c0x0000 (---------------)  + I hjartdal
	0x00298c0a, // n0x14ec c0x0000 (---------------)  + I hjelmeland
	0x37a9c882, // n0x14ed c0x00de (n0x170b-n0x170c)  + I hl
	0x37e4c142, // n0x14ee c0x00df (n0x170c-n0x170d)  + I hm
	0x002df885, // n0x14ef c0x0000 (---------------)  + I hobol
	0x002a1d83, // n0x14f0 c0x0000 (---------------)  + I hof
	0x0022e1c8, // n0x14f1 c0x0000 (---------------)  + I hokksund
	0x00274dc3, // n0x14f2 c0x0000 (---------------)  + I hol
	0x00298e84, // n0x14f3 c0x0000 (---------------)  + I hole
	0x0036c14b, // n0x14f4 c0x0000 (---------------)  + I holmestrand
	0x002abbc8, // n0x14f5 c0x0000 (---------------)  + I holtalen
	0x0029a448, // n0x14f6 c0x0000 (---------------)  + I honefoss
	0x38322189, // n0x14f7 c0x00e0 (n0x170d-n0x170e)  o I hordaland
	0x0029c989, // n0x14f8 c0x0000 (---------------)  + I hornindal
	0x0029d306, // n0x14f9 c0x0000 (---------------)  + I horten
	0x0029ebc8, // n0x14fa c0x0000 (---------------)  + I hoyanger
	0x0029edc9, // n0x14fb c0x0000 (---------------)  + I hoylandet
	0x0029f486, // n0x14fc c0x0000 (---------------)  + I hurdal
	0x0029f605, // n0x14fd c0x0000 (---------------)  + I hurum
	0x00246f46, // n0x14fe c0x0000 (---------------)  + I hvaler
	0x00233049, // n0x14ff c0x0000 (---------------)  + I hyllestad
	0x0036de47, // n0x1500 c0x0000 (---------------)  + I ibestad
	0x00257906, // n0x1501 c0x0000 (---------------)  + I idrett
	0x003850c7, // n0x1502 c0x0000 (---------------)  + I inderoy
	0x00334ac7, // n0x1503 c0x0000 (---------------)  + I iveland
	0x00262884, // n0x1504 c0x0000 (---------------)  + I ivgu
	0x3861ed89, // n0x1505 c0x00e1 (n0x170e-n0x170f)  + I jan-mayen
	0x002b8908, // n0x1506 c0x0000 (---------------)  + I jessheim
	0x00336388, // n0x1507 c0x0000 (---------------)  + I jevnaker
	0x00246d47, // n0x1508 c0x0000 (---------------)  + I jolster
	0x002b5346, // n0x1509 c0x0000 (---------------)  + I jondal
	0x00381f49, // n0x150a c0x0000 (---------------)  + I jorpeland
	0x00213787, // n0x150b c0x0000 (---------------)  + I kafjord
	0x0023000a, // n0x150c c0x0000 (---------------)  + I karasjohka
	0x002e4308, // n0x150d c0x0000 (---------------)  + I karasjok
	0x00366687, // n0x150e c0x0000 (---------------)  + I karlsoy
	0x0036ce06, // n0x150f c0x0000 (---------------)  + I karmoy
	0x00262c0a, // n0x1510 c0x0000 (---------------)  + I kautokeino
	0x00335688, // n0x1511 c0x0000 (---------------)  + I kirkenes
	0x00274105, // n0x1512 c0x0000 (---------------)  + I klabu
	0x0022b205, // n0x1513 c0x0000 (---------------)  + I klepp
	0x00331e87, // n0x1514 c0x0000 (---------------)  + I kommune
	0x002b2e89, // n0x1515 c0x0000 (---------------)  + I kongsberg
	0x002b3fcb, // n0x1516 c0x0000 (---------------)  + I kongsvinger
	0x00331cc8, // n0x1517 c0x0000 (---------------)  + I kopervik
	0x00360889, // n0x1518 c0x0000 (---------------)  + I kraanghke
	0x002a3bc7, // n0x1519 c0x0000 (---------------)  + I kragero
	0x002a4d4c, // n0x151a c0x0000 (---------------)  + I kristiansand
	0x002a51cc, // n0x151b c0x0000 (---------------)  + I kristiansund
	0x002a54ca, // n0x151c c0x0000 (---------------)  + I krodsherad
	0x002a574c, // n0x151d c0x0000 (---------------)  + I krokstadelva
	0x002b0208, // n0x151e c0x0000 (---------------)  + I kvafjord
	0x002b0408, // n0x151f c0x0000 (---------------)  + I kvalsund
	0x002b0604, // n0x1520 c0x0000 (---------------)  + I kvam
	0x002b0fc9, // n0x1521 c0x0000 (---------------)  + I kvanangen
	0x002b1209, // n0x1522 c0x0000 (---------------)  + I kvinesdal
	0x002b144a, // n0x1523 c0x0000 (---------------)  + I kvinnherad
	0x002b16c9, // n0x1524 c0x0000 (---------------)  + I kviteseid
	0x002b1a07, // n0x1525 c0x0000 (---------------)  + I kvitsoy
	0x00201d4c, // n0x1526 c0x0000 (---------------)  + I laakesvuemie
	0x00243706, // n0x1527 c0x0000 (---------------)  + I lahppi
	0x00263a88, // n0x1528 c0x0000 (---------------)  + I langevag
	0x00220806, // n0x1529 c0x0000 (---------------)  + I lardal
	0x002c1006, // n0x152a c0x0000 (---------------)  + I larvik
	0x002e3f07, // n0x152b c0x0000 (---------------)  + I lavagis
	0x00337b88, // n0x152c c0x0000 (---------------)  + I lavangen
	0x0027f10b, // n0x152d c0x0000 (---------------)  + I leangaviika
	0x002be687, // n0x152e c0x0000 (---------------)  + I lebesby
	0x0033bb49, // n0x152f c0x0000 (---------------)  + I leikanger
	0x002f5309, // n0x1530 c0x0000 (---------------)  + I leirfjord
	0x00295187, // n0x1531 c0x0000 (---------------)  + I leirvik
	0x0021c504, // n0x1532 c0x0000 (---------------)  + I leka
	0x002b2d07, // n0x1533 c0x0000 (---------------)  + I leksvik
	0x002b6706, // n0x1534 c0x0000 (---------------)  + I lenvik
	0x0024bbc6, // n0x1535 c0x0000 (---------------)  + I lerdal
	0x00229d05, // n0x1536 c0x0000 (---------------)  + I lesja
	0x00278688, // n0x1537 c0x0000 (---------------)  + I levanger
	0x00234484, // n0x1538 c0x0000 (---------------)  + I lier
	0x00234486, // n0x1539 c0x0000 (---------------)  + I lierne
	0x0036c54b, // n0x153a c0x0000 (---------------)  + I lillehammer
	0x00322749, // n0x153b c0x0000 (---------------)  + I lillesand
	0x002fbd86, // n0x153c c0x0000 (---------------)  + I lindas
	0x002fce09, // n0x153d c0x0000 (---------------)  + I lindesnes
	0x00214346, // n0x153e c0x0000 (---------------)  + I loabat
	0x002ca108, // n0x153f c0x0000 (---------------)  + I lodingen
	0x00210a03, // n0x1540 c0x0000 (---------------)  + I lom
	0x00208f45, // n0x1541 c0x0000 (---------------)  + I loppa
	0x0020ad89, // n0x1542 c0x0000 (---------------)  + I lorenskog
	0x00219d45, // n0x1543 c0x0000 (---------------)  + I loten
	0x002d3bc4, // n0x1544 c0x0000 (---------------)  + I lund
	0x0026dd86, // n0x1545 c0x0000 (---------------)  + I lunner
	0x00236e85, // n0x1546 c0x0000 (---------------)  + I luroy
	0x0023ea46, // n0x1547 c0x0000 (---------------)  + I luster
	0x002f3747, // n0x1548 c0x0000 (---------------)  + I lyngdal
	0x002637c6, // n0x1549 c0x0000 (---------------)  + I lyngen
	0x0028db8b, // n0x154a c0x0000 (---------------)  + I malatvuopmi
	0x003453c7, // n0x154b c0x0000 (---------------)  + I malselv
	0x00375d46, // n0x154c c0x0000 (---------------)  + I malvik
	0x002fbc46, // n0x154d c0x0000 (---------------)  + I mandal
	0x00265186, // n0x154e c0x0000 (---------------)  + I marker
	0x00283c09, // n0x154f c0x0000 (---------------)  + I marnardal
	0x0021d68a, // n0x1550 c0x0000 (---------------)  + I masfjorden
	0x0035b0c5, // n0x1551 c0x0000 (---------------)  + I masoy
	0x0034498d, // n0x1552 c0x0000 (---------------)  + I matta-varjjat
	0x00298d06, // n0x1553 c0x0000 (---------------)  + I meland
	0x002911c6, // n0x1554 c0x0000 (---------------)  + I meldal
	0x0025f106, // n0x1555 c0x0000 (---------------)  + I melhus
	0x0036be05, // n0x1556 c0x0000 (---------------)  + I meloy
	0x0025d287, // n0x1557 c0x0000 (---------------)  + I meraker
	0x0028c107, // n0x1558 c0x0000 (---------------)  + I midsund
	0x0026c10e, // n0x1559 c0x0000 (---------------)  + I midtre-gauldal
	0x00240443, // n0x155a c0x0000 (---------------)  + I mil
	0x002b5309, // n0x155b c0x0000 (---------------)  + I mjondalen
	0x00309f49, // n0x155c c0x0000 (---------------)  + I mo-i-rana
	0x00349a07, // n0x155d c0x0000 (---------------)  + I moareke
	0x00226fc7, // n0x155e c0x0000 (---------------)  + I modalen
	0x002fb885, // n0x155f c0x0000 (---------------)  + I modum
	0x002da185, // n0x1560 c0x0000 (---------------)  + I molde
	0x38ad9d8f, // n0x1561 c0x00e2 (n0x170f-n0x1711)  o I more-og-romsdal
	0x002bc007, // n0x1562 c0x0000 (---------------)  + I mosjoen
	0x002bc1c8, // n0x1563 c0x0000 (---------------)  + I moskenes
	0x002bcb44, // n0x1564 c0x0000 (---------------)  + I moss
	0x002bd046, // n0x1565 c0x0000 (---------------)  + I mosvik
	0x38e14202, // n0x1566 c0x00e3 (n0x1711-n0x1712)  + I mr
	0x002c0906, // n0x1567 c0x0000 (---------------)  + I muosat
	0x002c2a06, // n0x1568 c0x0000 (---------------)  + I museum
	0x0030a10e, // n0x1569 c0x0000 (---------------)  + I naamesjevuemie
	0x002f848a, // n0x156a c0x0000 (---------------)  + I namdalseid
	0x00262406, // n0x156b c0x0000 (---------------)  + I namsos
	0x002d4dca, // n0x156c c0x0000 (---------------)  + I namsskogan
	0x0024f509, // n0x156d c0x0000 (---------------)  + I nannestad
	0x00355045, // n0x156e c0x0000 (---------------)  + I naroy
	0x0037ec48, // n0x156f c0x0000 (---------------)  + I narviika
	0x00366546, // n0x1570 c0x0000 (---------------)  + I narvik
	0x003768c8, // n0x1571 c0x0000 (---------------)  + I naustdal
	0x00201808, // n0x1572 c0x0000 (---------------)  + I navuotna
	0x002860cb, // n0x1573 c0x0000 (---------------)  + I nedre-eiker
	0x00228d45, // n0x1574 c0x0000 (---------------)  + I nesna
	0x0035c648, // n0x1575 c0x0000 (---------------)  + I nesodden
	0x00209e8c, // n0x1576 c0x0000 (---------------)  + I nesoddtangen
	0x002742c7, // n0x1577 c0x0000 (---------------)  + I nesseby
	0x0024b2c6, // n0x1578 c0x0000 (---------------)  + I nesset
	0x002260c8, // n0x1579 c0x0000 (---------------)  + I nissedal
	0x002ac048, // n0x157a c0x0000 (---------------)  + I nittedal
	0x39248cc2, // n0x157b c0x00e4 (n0x1712-n0x1713)  + I nl
	0x003596cb, // n0x157c c0x0000 (---------------)  + I nord-aurdal
	0x002c7e89, // n0x157d c0x0000 (---------------)  + I nord-fron
	0x002fcc09, // n0x157e c0x0000 (---------------)  + I nord-odal
	0x002ad107, // n0x157f c0x0000 (---------------)  + I norddal
	0x002a6d88, // n0x1580 c0x0000 (---------------)  + I nordkapp
	0x39749c08, // n0x1581 c0x00e5 (n0x1713-n0x1717)  o I nordland
	0x00215b8b, // n0x1582 c0x0000 (---------------)  + I nordre-land
	0x00213cc9, // n0x1583 c0x0000 (---------------)  + I nordreisa
	0x0023b64d, // n0x1584 c0x0000 (---------------)  + I nore-og-uvdal
	0x00282d88, // n0x1585 c0x0000 (---------------)  + I notodden
	0x00292a08, // n0x1586 c0x0000 (---------------)  + I notteroy
	0x39a00902, // n0x1587 c0x00e6 (n0x1717-n0x1718)  + I nt
	0x00320204, // n0x1588 c0x0000 (---------------)  + I odda
	0x39e15fc2, // n0x1589 c0x00e7 (n0x1718-n0x1719)  + I of
	0x002e4486, // n0x158a c0x0000 (---------------)  + I oksnes
	0x3a2009c2, // n0x158b c0x00e8 (n0x1719-n0x171a)  + I ol
	0x0022b7ca, // n0x158c c0x0000 (---------------)  + I omasvuotna
	0x0022c286, // n0x158d c0x0000 (---------------)  + I oppdal
	0x00221c08, // n0x158e c0x0000 (---------------)  + I oppegard
	0x0030ce08, // n0x158f c0x0000 (---------------)  + I orkanger
	0x0030e786, // n0x1590 c0x0000 (---------------)  + I orkdal
	0x002ffa46, // n0x1591 c0x0000 (---------------)  + I orland
	0x002d3386, // n0x1592 c0x0000 (---------------)  + I orskog
	0x002a7c45, // n0x1593 c0x0000 (---------------)  + I orsta
	0x0023cfc4, // n0x1594 c0x0000 (---------------)  + I osen
	0x3a610984, // n0x1595 c0x00e9 (n0x171a-n0x171b)  + I oslo
	0x00210786, // n0x1596 c0x0000 (---------------)  + I osoyro
	0x00255487, // n0x1597 c0x0000 (---------------)  + I osteroy
	0x3aaf1447, // n0x1598 c0x00ea (n0x171b-n0x171c)  o I ostfold
	0x0020838b, // n0x1599 c0x0000 (---------------)  + I ostre-toten
	0x00365a89, // n0x159a c0x0000 (---------------)  + I overhalla
	0x0024b88a, // n0x159b c0x0000 (---------------)  + I ovre-eiker
	0x00309e04, // n0x159c c0x0000 (---------------)  + I oyer
	0x002b0c88, // n0x159d c0x0000 (---------------)  + I oygarden
	0x002576cd, // n0x159e c0x0000 (---------------)  + I oystre-slidre
	0x002ce049, // n0x159f c0x0000 (---------------)  + I porsanger
	0x002ce288, // n0x15a0 c0x0000 (---------------)  + I porsangu
	0x002ce509, // n0x15a1 c0x0000 (---------------)  + I porsgrunn
	0x002cfac4, // n0x15a2 c0x0000 (---------------)  + I priv
	0x0021bbc4, // n0x15a3 c0x0000 (---------------)  + I rade
	0x0022d985, // n0x15a4 c0x0000 (---------------)  + I radoy
	0x0023828b, // n0x15a5 c0x0000 (---------------)  + I rahkkeravju
	0x002abb46, // n0x15a6 c0x0000 (---------------)  + I raholt
	0x002a8705, // n0x15a7 c0x0000 (---------------)  + I raisa
	0x002fb309, // n0x15a8 c0x0000 (---------------)  + I rakkestad
	0x00228f48, // n0x15a9 c0x0000 (---------------)  + I ralingen
	0x0026d544, // n0x15aa c0x0000 (---------------)  + I rana
	0x00349789, // n0x15ab c0x0000 (---------------)  + I randaberg
	0x00364845, // n0x15ac c0x0000 (---------------)  + I rauma
	0x002b65c8, // n0x15ad c0x0000 (---------------)  + I rendalen
	0x002ee247, // n0x15ae c0x0000 (---------------)  + I rennebu
	0x002dae48, // n0x15af c0x0000 (---------------)  + I rennesoy
	0x002b4f06, // n0x15b0 c0x0000 (---------------)  + I rindal
	0x0024a707, // n0x15b1 c0x0000 (---------------)  + I ringebu
	0x0030de09, // n0x15b2 c0x0000 (---------------)  + I ringerike
	0x0022e889, // n0x15b3 c0x0000 (---------------)  + I ringsaker
	0x00256605, // n0x15b4 c0x0000 (---------------)  + I risor
	0x0035a145, // n0x15b5 c0x0000 (---------------)  + I rissa
	0x3ae0a7c2, // n0x15b6 c0x00eb (n0x171c-n0x171d)  + I rl
	0x002f0cc4, // n0x15b7 c0x0000 (---------------)  + I roan
	0x00353185, // n0x15b8 c0x0000 (---------------)  + I rodoy
	0x00307806, // n0x15b9 c0x0000 (---------------)  + I rollag
	0x0030c4c5, // n0x15ba c0x0000 (---------------)  + I romsa
	0x0024e907, // n0x15bb c0x0000 (---------------)  + I romskog
	0x002f5145, // n0x15bc c0x0000 (---------------)  + I roros
	0x0026eb84, // n0x15bd c0x0000 (---------------)  + I rost
	0x002964c6, // n0x15be c0x0000 (---------------)  + I royken
	0x00233e47, // n0x15bf c0x0000 (---------------)  + I royrvik
	0x002360c6, // n0x15c0 c0x0000 (---------------)  + I ruovat
	0x0032e605, // n0x15c1 c0x0000 (---------------)  + I rygge
	0x00215248, // n0x15c2 c0x0000 (---------------)  + I salangen
	0x00215885, // n0x15c3 c0x0000 (---------------)  + I salat
	0x00220dc7, // n0x15c4 c0x0000 (---------------)  + I saltdal
	0x0022c749, // n0x15c5 c0x0000 (---------------)  + I samnanger
	0x002a4f4a, // n0x15c6 c0x0000 (---------------)  + I sandefjord
	0x002ccc07, // n0x15c7 c0x0000 (---------------)  + I sandnes
	0x002ccc0c, // n0x15c8 c0x0000 (---------------)  + I sandnessjoen
	0x0033c1c6, // n0x15c9 c0x0000 (---------------)  + I sandoy
	0x0024cec9, // n0x15ca c0x0000 (---------------)  + I sarpsborg
	0x0025bc45, // n0x15cb c0x0000 (---------------)  + I sauda
	0x0025c848, // n0x15cc c0x0000 (---------------)  + I sauherad
	0x00212d03, // n0x15cd c0x0000 (---------------)  + I sel
	0x00212d05, // n0x15ce c0x0000 (---------------)  + I selbu
	0x002d1d45, // n0x15cf c0x0000 (---------------)  + I selje
	0x002892c7, // n0x15d0 c0x0000 (---------------)  + I seljord
	0x3b21a182, // n0x15d1 c0x00ec (n0x171d-n0x171e)  + I sf
	0x002cc787, // n0x15d2 c0x0000 (---------------)  + I siellak
	0x00315906, // n0x15d3 c0x0000 (---------------)  + I sigdal
	0x0021ecc6, // n0x15d4 c0x0000 (---------------)  + I siljan
	0x0031ae06, // n0x15d5 c0x0000 (---------------)  + I sirdal
	0x002abf86, // n0x15d6 c0x0000 (---------------)  + I skanit
	0x002f9b88, // n0x15d7 c0x0000 (---------------)  + I skanland
	0x002728c5, // n0x15d8 c0x0000 (---------------)  + I skaun
	0x002d18c7, // n0x15d9 c0x0000 (---------------)  + I skedsmo
	0x002d18cd, // n0x15da c0x0000 (---------------)  + I skedsmokorset
	0x00221943, // n0x15db c0x0000 (---------------)  + I ski
	0x00221945, // n0x15dc c0x0000 (---------------)  + I skien
	0x002fef47, // n0x15dd c0x0000 (---------------)  + I skierva
	0x002ff588, // n0x15de c0x0000 (---------------)  + I skiptvet
	0x00332585, // n0x15df c0x0000 (---------------)  + I skjak
	0x00361148, // n0x15e0 c0x0000 (---------------)  + I skjervoy
	0x0022edc6, // n0x15e1 c0x0000 (---------------)  + I skodje
	0x00289bc7, // n0x15e2 c0x0000 (---------------)  + I slattum
	0x002b9745, // n0x15e3 c0x0000 (---------------)  + I smola
	0x00228dc6, // n0x15e4 c0x0000 (---------------)  + I snaase
	0x0036ef85, // n0x15e5 c0x0000 (---------------)  + I snasa
	0x00223fca, // n0x15e6 c0x0000 (---------------)  + I snillfjord
	0x002af646, // n0x15e7 c0x0000 (---------------)  + I snoasa
	0x0026d1c7, // n0x15e8 c0x0000 (---------------)  + I sogndal
	0x00280345, // n0x15e9 c0x0000 (---------------)  + I sogne
	0x0037a8c7, // n0x15ea c0x0000 (---------------)  + I sokndal
	0x00310944, // n0x15eb c0x0000 (---------------)  + I sola
	0x002d3b46, // n0x15ec c0x0000 (---------------)  + I solund
	0x002d4d05, // n0x15ed c0x0000 (---------------)  + I somna
	0x0032da8b, // n0x15ee c0x0000 (---------------)  + I sondre-land
	0x00218c09, // n0x15ef c0x0000 (---------------)  + I songdalen
	0x00244c4a, // n0x15f0 c0x0000 (---------------)  + I sor-aurdal
	0x00256688, // n0x15f1 c0x0000 (---------------)  + I sor-fron
	0x002d5b48, // n0x15f2 c0x0000 (---------------)  + I sor-odal
	0x002d5d4c, // n0x15f3 c0x0000 (---------------)  + I sor-varanger
	0x002d6047, // n0x15f4 c0x0000 (---------------)  + I sorfold
	0x002d6208, // n0x15f5 c0x0000 (---------------)  + I sorreisa
	0x002d70c8, // n0x15f6 c0x0000 (---------------)  + I sortland
	0x002d72c5, // n0x15f7 c0x0000 (---------------)  + I sorum
	0x002db80a, // n0x15f8 c0x0000 (---------------)  + I spjelkavik
	0x002dc049, // n0x15f9 c0x0000 (---------------)  + I spydeberg
	0x3b604682, // n0x15fa c0x00ed (n0x171e-n0x171f)  + I st
	0x00344106, // n0x15fb c0x0000 (---------------)  + I stange
	0x002092c4, // n0x15fc c0x0000 (---------------)  + I stat
	0x002092c9, // n0x15fd c0x0000 (---------------)  + I stathelle
	0x002e5a09, // n0x15fe c0x0000 (---------------)  + I stavanger
	0x003663c7, // n0x15ff c0x0000 (---------------)  + I stavern
	0x00267507, // n0x1600 c0x0000 (---------------)  + I steigen
	0x002d7789, // n0x1601 c0x0000 (---------------)  + I steinkjer
	0x00204688, // n0x1602 c0x0000 (---------------)  + I stjordal
	0x0020468f, // n0x1603 c0x0000 (---------------)  + I stjordalshalsen
	0x0023a706, // n0x1604 c0x0000 (---------------)  + I stokke
	0x0028358b, // n0x1605 c0x0000 (---------------)  + I stor-elvdal
	0x002dc585, // n0x1606 c0x0000 (---------------)  + I stord
	0x002dc587, // n0x1607 c0x0000 (---------------)  + I stordal
	0x002dc9c9, // n0x1608 c0x0000 (---------------)  + I storfjord
	0x00349706, // n0x1609 c0x0000 (---------------)  + I strand
	0x00349707, // n0x160a c0x0000 (---------------)  + I stranda
	0x0026ff85, // n0x160b c0x0000 (---------------)  + I stryn
	0x00235ec4, // n0x160c c0x0000 (---------------)  + I sula
	0x00380706, // n0x160d c0x0000 (---------------)  + I suldal
	0x00227b44, // n0x160e c0x0000 (---------------)  + I sund
	0x00337787, // n0x160f c0x0000 (---------------)  + I sunndal
	0x0031f3c8, // n0x1610 c0x0000 (---------------)  + I surnadal
	0x3bae0b88, // n0x1611 c0x00ee (n0x171f-n0x1720)  + I svalbard
	0x002e1585, // n0x1612 c0x0000 (---------------)  + I sveio
	0x002e16c7, // n0x1613 c0x0000 (---------------)  + I svelvik
	0x00218449, // n0x1614 c0x0000 (---------------)  + I sykkylven
	0x00202544, // n0x1615 c0x0000 (---------------)  + I tana
	0x002ca948, // n0x1616 c0x0000 (---------------)  + I tananger
	0x3bf13f88, // n0x1617 c0x00ef (n0x1720-n0x1722)  o I telemark
	0x00246a44, // n0x1618 c0x0000 (---------------)  + I time
	0x00236cc8, // n0x1619 c0x0000 (---------------)  + I tingvoll
	0x0036b8c4, // n0x161a c0x0000 (---------------)  + I tinn
	0x0022bdc9, // n0x161b c0x0000 (---------------)  + I tjeldsund
	0x0025f045, // n0x161c c0x0000 (---------------)  + I tjome
	0x3c2032c2, // n0x161d c0x00f0 (n0x1722-n0x1723)  + I tm
	0x0023a745, // n0x161e c0x0000 (---------------)  + I tokke
	0x00220685, // n0x161f c0x0000 (---------------)  + I tolga
	0x00305ac8, // n0x1620 c0x0000 (---------------)  + I tonsberg
	0x00238947, // n0x1621 c0x0000 (---------------)  + I torsken
	0x3c600942, // n0x1622 c0x00f1 (n0x1723-n0x1724)  + I tr
	0x0026d505, // n0x1623 c0x0000 (---------------)  + I trana
	0x00270506, // n0x1624 c0x0000 (---------------)  + I tranby
	0x002885c6, // n0x1625 c0x0000 (---------------)  + I tranoy
	0x002f0c88, // n0x1626 c0x0000 (---------------)  + I troandin
	0x002f2988, // n0x1627 c0x0000 (---------------)  + I trogstad
	0x0030c486, // n0x1628 c0x0000 (---------------)  + I tromsa
	0x00310846, // n0x1629 c0x0000 (---------------)  + I tromso
	0x0036ca89, // n0x162a c0x0000 (---------------)  + I trondheim
	0x0033aa06, // n0x162b c0x0000 (---------------)  + I trysil
	0x00372d4b, // n0x162c c0x0000 (---------------)  + I tvedestrand
	0x00322645, // n0x162d c0x0000 (---------------)  + I tydal
	0x0021cf86, // n0x162e c0x0000 (---------------)  + I tynset
	0x00280648, // n0x162f c0x0000 (---------------)  + I tysfjord
	0x002e8c06, // n0x1630 c0x0000 (---------------)  + I tysnes
	0x002c7806, // n0x1631 c0x0000 (---------------)  + I tysvar
	0x00214a4a, // n0x1632 c0x0000 (---------------)  + I ullensaker
	0x0034b6ca, // n0x1633 c0x0000 (---------------)  + I ullensvang
	0x00254e85, // n0x1634 c0x0000 (---------------)  + I ulvik
	0x0021a747, // n0x1635 c0x0000 (---------------)  + I unjarga
	0x002d0606, // n0x1636 c0x0000 (---------------)  + I utsira
	0x3ca03242, // n0x1637 c0x00f2 (n0x1724-n0x1725)  + I va
	0x002ff087, // n0x1638 c0x0000 (---------------)  + I vaapste
	0x0026d105, // n0x1639 c0x0000 (---------------)  + I vadso
	0x0020a884, // n0x163a c0x0000 (---------------)  + I vaga
	0x0020a885, // n0x163b c0x0000 (---------------)  + I vagan
	0x00309d06, // n0x163c c0x0000 (---------------)  + I vagsoy
	0x003336c7, // n0x163d c0x0000 (---------------)  + I vaksdal
	0x0021e945, // n0x163e c0x0000 (---------------)  + I valle
	0x00278704, // n0x163f c0x0000 (---------------)  + I vang
	0x00268448, // n0x1640 c0x0000 (---------------)  + I vanylven
	0x002c78c5, // n0x1641 c0x0000 (---------------)  + I vardo
	0x0037a607, // n0x1642 c0x0000 (---------------)  + I varggat
	0x002e5e05, // n0x1643 c0x0000 (---------------)  + I varoy
	0x00223f05, // n0x1644 c0x0000 (---------------)  + I vefsn
	0x0028e884, // n0x1645 c0x0000 (---------------)  + I vega
	0x002a05c9, // n0x1646 c0x0000 (---------------)  + I vegarshei
	0x002e7388, // n0x1647 c0x0000 (---------------)  + I vennesla
	0x002e5c86, // n0x1648 c0x0000 (---------------)  + I verdal
	0x002e79c6, // n0x1649 c0x0000 (---------------)  + I verran
	0x002be4c6, // n0x164a c0x0000 (---------------)  + I vestby
	0x3cee9488, // n0x164b c0x00f3 (n0x1725-n0x1726)  o I vestfold
	0x002e9687, // n0x164c c0x0000 (---------------)  + I vestnes
	0x002e9a4d, // n0x164d c0x0000 (---------------)  + I vestre-slidre
	0x002ead4c, // n0x164e c0x0000 (---------------)  + I vestre-toten
	0x002eb349, // n0x164f c0x0000 (---------------)  + I vestvagoy
	0x002eb589, // n0x1650 c0x0000 (---------------)  + I vevelstad
	0x3d3306c2, // n0x1651 c0x00f4 (n0x1726-n0x1727)  + I vf
	0x00378c43, // n0x1652 c0x0000 (---------------)  + I vgs
	0x00204143, // n0x1653 c0x0000 (---------------)  + I vik
	0x00233f45, // n0x1654 c0x0000 (---------------)  + I vikna
	0x003390ca, // n0x1655 c0x0000 (---------------)  + I vindafjord
	0x0030c346, // n0x1656 c0x0000 (---------------)  + I voagat
	0x002f2185, // n0x1657 c0x0000 (---------------)  + I volda
	0x002f3c84, // n0x1658 c0x0000 (---------------)  + I voss
	0x002f3c8b, // n0x1659 c0x0000 (---------------)  + I vossevangen
	0x0030088c, // n0x165a c0x0000 (---------------)  + I xn--andy-ira
	0x0030108c, // n0x165b c0x0000 (---------------)  + I xn--asky-ira
	0x00301395, // n0x165c c0x0000 (---------------)  + I xn--aurskog-hland-jnb
	0x0030208d, // n0x165d c0x0000 (---------------)  + I xn--avery-yua
	0x0030310f, // n0x165e c0x0000 (---------------)  + I xn--bdddj-mrabd
	0x003034d2, // n0x165f c0x0000 (---------------)  + I xn--bearalvhki-y4a
	0x0030394f, // n0x1660 c0x0000 (---------------)  + I xn--berlevg-jxa
	0x00303d12, // n0x1661 c0x0000 (---------------)  + I xn--bhcavuotna-s4a
	0x00304193, // n0x1662 c0x0000 (---------------)  + I xn--bhccavuotna-k7a
	0x0030464d, // n0x1663 c0x0000 (---------------)  + I xn--bidr-5nac
	0x00304c0d, // n0x1664 c0x0000 (---------------)  + I xn--bievt-0qa
	0x00304f4e, // n0x1665 c0x0000 (---------------)  + I xn--bjarky-fya
	0x00305cce, // n0x1666 c0x0000 (---------------)  + I xn--bjddar-pta
	0x0030644c, // n0x1667 c0x0000 (---------------)  + I xn--blt-elab
	0x003067cc, // n0x1668 c0x0000 (---------------)  + I xn--bmlo-gra
	0x00306c8b, // n0x1669 c0x0000 (---------------)  + I xn--bod-2na
	0x003088ce, // n0x166a c0x0000 (---------------)  + I xn--brnny-wuac
	0x0030b5d2, // n0x166b c0x0000 (---------------)  + I xn--brnnysund-m8ac
	0x0030c10c, // n0x166c c0x0000 (---------------)  + I xn--brum-voa
	0x0030d010, // n0x166d c0x0000 (---------------)  + I xn--btsfjord-9za
	0x003142d2, // n0x166e c0x0000 (---------------)  + I xn--davvenjrga-y4a
	0x0031544c, // n0x166f c0x0000 (---------------)  + I xn--dnna-gra
	0x00315a8d, // n0x1670 c0x0000 (---------------)  + I xn--drbak-wua
	0x00315dcc, // n0x1671 c0x0000 (---------------)  + I xn--dyry-ira
	0x00317f51, // n0x1672 c0x0000 (---------------)  + I xn--eveni-0qa01ga
	0x0031864d, // n0x1673 c0x0000 (---------------)  + I xn--finny-yua
	0x0031b70d, // n0x1674 c0x0000 (---------------)  + I xn--fjord-lra
	0x0031bd0a, // n0x1675 c0x0000 (---------------)  + I xn--fl-zia
	0x0031bf8c, // n0x1676 c0x0000 (---------------)  + I xn--flor-jra
	0x0031c88c, // n0x1677 c0x0000 (---------------)  + I xn--frde-gra
	0x0031cc0c, // n0x1678 c0x0000 (---------------)  + I xn--frna-woa
	0x0031d38c, // n0x1679 c0x0000 (---------------)  + I xn--frya-hra
	0x0031e393, // n0x167a c0x0000 (---------------)  + I xn--ggaviika-8ya47h
	0x0031eb50, // n0x167b c0x0000 (---------------)  + I xn--gildeskl-g0a
	0x0031ef50, // n0x167c c0x0000 (---------------)  + I xn--givuotna-8ya
	0x0031f5cd, // n0x167d c0x0000 (---------------)  + I xn--gjvik-wua
	0x0031f90c, // n0x167e c0x0000 (---------------)  + I xn--gls-elac
	0x00320589, // n0x167f c0x0000 (---------------)  + I xn--h-2fa
	0x0032130d, // n0x1680 c0x0000 (---------------)  + I xn--hbmer-xqa
	0x00321653, // n0x1681 c0x0000 (---------------)  + I xn--hcesuolo-7ya35b
	0x00323a11, // n0x1682 c0x0000 (---------------)  + I xn--hgebostad-g3a
	0x00323e53, // n0x1683 c0x0000 (---------------)  + I xn--hmmrfeasta-s4ac
	0x0032484f, // n0x1684 c0x0000 (---------------)  + I xn--hnefoss-q1a
	0x00324c0c, // n0x1685 c0x0000 (---------------)  + I xn--hobl-ira
	0x00324f0f, // n0x1686 c0x0000 (---------------)  + I xn--holtlen-hxa
	0x003252cd, // n0x1687 c0x0000 (---------------)  + I xn--hpmir-xqa
	0x003258cf, // n0x1688 c0x0000 (---------------)  + I xn--hyanger-q1a
	0x00325c90, // n0x1689 c0x0000 (---------------)  + I xn--hylandet-54a
	0x0032670e, // n0x168a c0x0000 (---------------)  + I xn--indery-fya
	0x00327a0e, // n0x168b c0x0000 (---------------)  + I xn--jlster-bya
	0x003281d0, // n0x168c c0x0000 (---------------)  + I xn--jrpeland-54a
	0x0032888d, // n0x168d c0x0000 (---------------)  + I xn--karmy-yua
	0x0032920e, // n0x168e c0x0000 (---------------)  + I xn--kfjord-iua
	0x0032958c, // n0x168f c0x0000 (---------------)  + I xn--klbu-woa
	0x0032a593, // n0x1690 c0x0000 (---------------)  + I xn--koluokta-7ya57h
	0x0032c34e, // n0x1691 c0x0000 (---------------)  + I xn--krager-gya
	0x0032ec50, // n0x1692 c0x0000 (---------------)  + I xn--kranghke-b0a
	0x0032f051, // n0x1693 c0x0000 (---------------)  + I xn--krdsherad-m8a
	0x0032f48f, // n0x1694 c0x0000 (---------------)  + I xn--krehamn-dxa
	0x0032f853, // n0x1695 c0x0000 (---------------)  + I xn--krjohka-hwab49j
	0x0033024d, // n0x1696 c0x0000 (---------------)  + I xn--ksnes-uua
	0x0033058f, // n0x1697 c0x0000 (---------------)  + I xn--kvfjord-nxa
	0x0033094e, // n0x1698 c0x0000 (---------------)  + I xn--kvitsy-fya
	0x003313d0, // n0x1699 c0x0000 (---------------)  + I xn--kvnangen-k0a
	0x003317c9, // n0x169a c0x0000 (---------------)  + I xn--l-1fa
	0x00332f50, // n0x169b c0x0000 (---------------)  + I xn--laheadju-7ya
	0x0033388f, // n0x169c c0x0000 (---------------)  + I xn--langevg-jxa
	0x00333f0f, // n0x169d c0x0000 (---------------)  + I xn--ldingen-q1a
	0x003342d2, // n0x169e c0x0000 (---------------)  + I xn--leagaviika-52b
	0x00335c8e, // n0x169f c0x0000 (---------------)  + I xn--lesund-hua
	0x0033658d, // n0x16a0 c0x0000 (---------------)  + I xn--lgrd-poac
	0x00336b8d, // n0x16a1 c0x0000 (---------------)  + I xn--lhppi-xqa
	0x00336ecd, // n0x16a2 c0x0000 (---------------)  + I xn--linds-pra
	0x00337d8d, // n0x16a3 c0x0000 (---------------)  + I xn--loabt-0qa
	0x003380cd, // n0x16a4 c0x0000 (---------------)  + I xn--lrdal-sra
	0x00338410, // n0x16a5 c0x0000 (---------------)  + I xn--lrenskog-54a
	0x0033880b, // n0x16a6 c0x0000 (---------------)  + I xn--lt-liac
	0x00338d8c, // n0x16a7 c0x0000 (---------------)  + I xn--lten-gra
	0x0033934c, // n0x16a8 c0x0000 (---------------)  + I xn--lury-ira
	0x0033964c, // n0x16a9 c0x0000 (---------------)  + I xn--mely-ira
	0x0033994e, // n0x16aa c0x0000 (---------------)  + I xn--merker-kua
	0x00340090, // n0x16ab c0x0000 (---------------)  + I xn--mjndalen-64a
	0x00341552, // n0x16ac c0x0000 (---------------)  + I xn--mlatvuopmi-s4a
	0x003419cb, // n0x16ad c0x0000 (---------------)  + I xn--mli-tla
	0x00341d4e, // n0x16ae c0x0000 (---------------)  + I xn--mlselv-iua
	0x003420ce, // n0x16af c0x0000 (---------------)  + I xn--moreke-jua
	0x00342cce, // n0x16b0 c0x0000 (---------------)  + I xn--mosjen-eya
	0x003432cb, // n0x16b1 c0x0000 (---------------)  + I xn--mot-tla
	0x3d743596, // n0x16b2 c0x00f5 (n0x1727-n0x1729)  o I xn--mre-og-romsdal-qqb
	0x003464cd, // n0x16b3 c0x0000 (---------------)  + I xn--msy-ula0h
	0x00346954, // n0x16b4 c0x0000 (---------------)  + I xn--mtta-vrjjat-k7af
	0x00347d4d, // n0x16b5 c0x0000 (---------------)  + I xn--muost-0qa
	0x00349155, // n0x16b6 c0x0000 (---------------)  + I xn--nmesjevuemie-tcba
	0x0034a8cd, // n0x16b7 c0x0000 (---------------)  + I xn--nry-yla5g
	0x0034b24f, // n0x16b8 c0x0000 (---------------)  + I xn--nttery-byae
	0x0034b94f, // n0x16b9 c0x0000 (---------------)  + I xn--nvuotna-hwa
	0x0034e24f, // n0x16ba c0x0000 (---------------)  + I xn--oppegrd-ixa
	0x0034e60e, // n0x16bb c0x0000 (---------------)  + I xn--ostery-fya
	0x0034eb8d, // n0x16bc c0x0000 (---------------)  + I xn--osyro-wua
	0x00350311, // n0x16bd c0x0000 (---------------)  + I xn--porsgu-sta26f
	0x0035208c, // n0x16be c0x0000 (---------------)  + I xn--rady-ira
	0x0035238c, // n0x16bf c0x0000 (---------------)  + I xn--rdal-poa
	0x0035268b, // n0x16c0 c0x0000 (---------------)  + I xn--rde-ula
	0x0035294c, // n0x16c1 c0x0000 (---------------)  + I xn--rdy-0nab
	0x003532cf, // n0x16c2 c0x0000 (---------------)  + I xn--rennesy-v1a
	0x00353692, // n0x16c3 c0x0000 (---------------)  + I xn--rhkkervju-01af
	0x00353d0d, // n0x16c4 c0x0000 (---------------)  + I xn--rholt-mra
	0x00354dcc, // n0x16c5 c0x0000 (---------------)  + I xn--risa-5na
	0x0035518c, // n0x16c6 c0x0000 (---------------)  + I xn--risr-ira
	0x0035548d, // n0x16c7 c0x0000 (---------------)  + I xn--rland-uua
	0x003557cf, // n0x16c8 c0x0000 (---------------)  + I xn--rlingen-mxa
	0x00355b8e, // n0x16c9 c0x0000 (---------------)  + I xn--rmskog-bya
	0x00356b4c, // n0x16ca c0x0000 (---------------)  + I xn--rros-gra
	0x00356fcd, // n0x16cb c0x0000 (---------------)  + I xn--rskog-uua
	0x0035730b, // n0x16cc c0x0000 (---------------)  + I xn--rst-0na
	0x0035774c, // n0x16cd c0x0000 (---------------)  + I xn--rsta-fra
	0x00357ccd, // n0x16ce c0x0000 (---------------)  + I xn--ryken-vua
	0x0035800e, // n0x16cf c0x0000 (---------------)  + I xn--ryrvik-bya
	0x00358589, // n0x16d0 c0x0000 (---------------)  + I xn--s-1fa
	0x0035a893, // n0x16d1 c0x0000 (---------------)  + I xn--sandnessjen-ogb
	0x0035b20d, // n0x16d2 c0x0000 (---------------)  + I xn--sandy-yua
	0x0035b54d, // n0x16d3 c0x0000 (---------------)  + I xn--seral-lra
	0x0035bb4c, // n0x16d4 c0x0000 (---------------)  + I xn--sgne-gra
	0x0035c20e, // n0x16d5 c0x0000 (---------------)  + I xn--skierv-uta
	0x0035cb0f, // n0x16d6 c0x0000 (---------------)  + I xn--skjervy-v1a
	0x0035cecc, // n0x16d7 c0x0000 (---------------)  + I xn--skjk-soa
	0x0035d1cd, // n0x16d8 c0x0000 (---------------)  + I xn--sknit-yqa
	0x0035d50f, // n0x16d9 c0x0000 (---------------)  + I xn--sknland-fxa
	0x0035d8cc, // n0x16da c0x0000 (---------------)  + I xn--slat-5na
	0x0035decc, // n0x16db c0x0000 (---------------)  + I xn--slt-elab
	0x0035e28c, // n0x16dc c0x0000 (---------------)  + I xn--smla-hra
	0x0035e58c, // n0x16dd c0x0000 (---------------)  + I xn--smna-gra
	0x0035e8cd, // n0x16de c0x0000 (---------------)  + I xn--snase-nra
	0x0035ec12, // n0x16df c0x0000 (---------------)  + I xn--sndre-land-0cb
	0x0036188c, // n0x16e0 c0x0000 (---------------)  + I xn--snes-poa
	0x00361b8c, // n0x16e1 c0x0000 (---------------)  + I xn--snsa-roa
	0x00361e91, // n0x16e2 c0x0000 (---------------)  + I xn--sr-aurdal-l8a
	0x003622cf, // n0x16e3 c0x0000 (---------------)  + I xn--sr-fron-q1a
	0x0036268f, // n0x16e4 c0x0000 (---------------)  + I xn--sr-odal-q1a
	0x00362a53, // n0x16e5 c0x0000 (---------------)  + I xn--sr-varanger-ggb
	0x003679ce, // n0x16e6 c0x0000 (---------------)  + I xn--srfold-bya
	0x00367d4f, // n0x16e7 c0x0000 (---------------)  + I xn--srreisa-q1a
	0x0036810c, // n0x16e8 c0x0000 (---------------)  + I xn--srum-gra
	0x3db6840e, // n0x16e9 c0x00f6 (n0x1729-n0x172a)  o I xn--stfold-9xa
	0x0036878f, // n0x16ea c0x0000 (---------------)  + I xn--stjrdal-s1a
	0x00368b56, // n0x16eb c0x0000 (---------------)  + I xn--stjrdalshalsen-sqb
	0x0036e8d2, // n0x16ec c0x0000 (---------------)  + I xn--stre-toten-zcb
	0x00370c8c, // n0x16ed c0x0000 (---------------)  + I xn--tjme-hra
	0x0037144f, // n0x16ee c0x0000 (---------------)  + I xn--tnsberg-q1a
	0x00371acd, // n0x16ef c0x0000 (---------------)  + I xn--trany-yua
	0x00371e0f, // n0x16f0 c0x0000 (---------------)  + I xn--trgstad-r1a
	0x003721cc, // n0x16f1 c0x0000 (---------------)  + I xn--trna-woa
	0x003724cd, // n0x16f2 c0x0000 (---------------)  + I xn--troms-zua
	0x0037280d, // n0x16f3 c0x0000 (---------------)  + I xn--tysvr-vra
	0x00373a8e, // n0x16f4 c0x0000 (---------------)  + I xn--unjrga-rta
	0x0037480c, // n0x16f5 c0x0000 (---------------)  + I xn--vads-jra
	0x00374b0c, // n0x16f6 c0x0000 (---------------)  + I xn--vard-jra
	0x00374e10, // n0x16f7 c0x0000 (---------------)  + I xn--vegrshei-c0a
	0x00377591, // n0x16f8 c0x0000 (---------------)  + I xn--vestvgy-ixa6o
	0x003779cb, // n0x16f9 c0x0000 (---------------)  + I xn--vg-yiab
	0x0037884c, // n0x16fa c0x0000 (---------------)  + I xn--vgan-qoa
	0x00378b4e, // n0x16fb c0x0000 (---------------)  + I xn--vgsy-qoa0j
	0x0037ad91, // n0x16fc c0x0000 (---------------)  + I xn--vre-eiker-k8a
	0x0037b1ce, // n0x16fd c0x0000 (---------------)  + I xn--vrggt-xqad
	0x0037b54d, // n0x16fe c0x0000 (---------------)  + I xn--vry-yla5g
	0x0037ea0b, // n0x16ff c0x0000 (---------------)  + I xn--yer-zna
	0x0037f34f, // n0x1700 c0x0000 (---------------)  + I xn--ygarden-p1a
	0x00380a14, // n0x1701 c0x0000 (---------------)  + I xn--ystre-slidre-ujb
	0x00209602, // n0x1702 c0x0000 (---------------)  + I gs
	0x00209602, // n0x1703 c0x0000 (---------------)  + I gs
	0x00209e83, // n0x1704 c0x0000 (---------------)  + I nes
	0x00209602, // n0x1705 c0x0000 (---------------)  + I gs
	0x00209e83, // n0x1706 c0x0000 (---------------)  + I nes
	0x00209602, // n0x1707 c0x0000 (---------------)  + I gs
	0x002053c2, // n0x1708 c0x0000 (---------------)  + I os
	0x00246f85, // n0x1709 c0x0000 (---------------)  + I valer
	0x0037aa8c, // n0x170a c0x0000 (---------------)  + I xn--vler-qoa
	0x00209602, // n0x170b c0x0000 (---------------)  + I gs
	0x00209602, // n0x170c c0x0000 (---------------)  + I gs
	0x002053c2, // n0x170d c0x0000 (---------------)  + I os
	0x00209602, // n0x170e c0x0000 (---------------)  + I gs
	0x0028a2c5, // n0x170f c0x0000 (---------------)  + I heroy
	0x002a4f45, // n0x1710 c0x0000 (---------------)  + I sande
	0x00209602, // n0x1711 c0x0000 (---------------)  + I gs
	0x00209602, // n0x1712 c0x0000 (---------------)  + I gs
	0x00210042, // n0x1713 c0x0000 (---------------)  + I bo
	0x0028a2c5, // n0x1714 c0x0000 (---------------)  + I heroy
	0x00302b49, // n0x1715 c0x0000 (---------------)  + I xn--b-5ga
	0x0032370c, // n0x1716 c0x0000 (---------------)  + I xn--hery-ira
	0x00209602, // n0x1717 c0x0000 (---------------)  + I gs
	0x00209602, // n0x1718 c0x0000 (---------------)  + I gs
	0x00209602, // n0x1719 c0x0000 (---------------)  + I gs
	0x00209602, // n0x171a c0x0000 (---------------)  + I gs
	0x00246f85, // n0x171b c0x0000 (---------------)  + I valer
	0x00209602, // n0x171c c0x0000 (---------------)  + I gs
	0x00209602, // n0x171d c0x0000 (---------------)  + I gs
	0x00209602, // n0x171e c0x0000 (---------------)  + I gs
	0x00209602, // n0x171f c0x0000 (---------------)  + I gs
	0x00210042, // n0x1720 c0x0000 (---------------)  + I bo
	0x00302b49, // n0x1721 c0x0000 (---------------)  + I xn--b-5ga
	0x00209602, // n0x1722 c0x0000 (---------------)  + I gs
	0x00209602, // n0x1723 c0x0000 (---------------)  + I gs
	0x00209602, // n0x1724 c0x0000 (---------------)  + I gs
	0x002a4f45, // n0x1725 c0x0000 (---------------)  + I sande
	0x00209602, // n0x1726 c0x0000 (---------------)  + I gs
	0x002a4f45, // n0x1727 c0x0000 (---------------)  + I sande
	0x0032370c, // n0x1728 c0x0000 (---------------)  + I xn--hery-ira
	0x0037aa8c, // n0x1729 c0x0000 (---------------)  + I xn--vler-qoa
	0x00202183, // n0x172a c0x0000 (---------------)  + I biz
	0x00232dc3, // n0x172b c0x0000 (---------------)  + I com
	0x0021e083, // n0x172c c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x172d c0x0000 (---------------)  + I gov
	0x00208a44, // n0x172e c0x0000 (---------------)  + I info
	0x00218643, // n0x172f c0x0000 (---------------)  + I net
	0x0024d043, // n0x1730 c0x0000 (---------------)  + I org
	0x0001f6c8, // n0x1731 c0x0000 (---------------)  +   merseine
	0x000adb04, // n0x1732 c0x0000 (---------------)  +   mine
	0x000b2588, // n0x1733 c0x0000 (---------------)  +   shacknet
	0x00200b82, // n0x1734 c0x0000 (---------------)  + I ac
	0x3ea00882, // n0x1735 c0x00fa (n0x1744-n0x1745)  + I co
	0x00240f03, // n0x1736 c0x0000 (---------------)  + I cri
	0x00213f44, // n0x1737 c0x0000 (---------------)  + I geek
	0x0020a0c3, // n0x1738 c0x0000 (---------------)  + I gen
	0x00217044, // n0x1739 c0x0000 (---------------)  + I govt
	0x00241cc6, // n0x173a c0x0000 (---------------)  + I health
	0x00207a43, // n0x173b c0x0000 (---------------)  + I iwi
	0x00382c84, // n0x173c c0x0000 (---------------)  + I kiwi
	0x00281bc5, // n0x173d c0x0000 (---------------)  + I maori
	0x00240443, // n0x173e c0x0000 (---------------)  + I mil
	0x00218643, // n0x173f c0x0000 (---------------)  + I net
	0x0024d043, // n0x1740 c0x0000 (---------------)  + I org
	0x002702ca, // n0x1741 c0x0000 (---------------)  + I parliament
	0x00275006, // n0x1742 c0x0000 (---------------)  + I school
	0x0034244c, // n0x1743 c0x0000 (---------------)  + I xn--mori-qsa
	0x0009e448, // n0x1744 c0x0000 (---------------)  +   blogspot
	0x00200882, // n0x1745 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x1746 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1747 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1748 c0x0000 (---------------)  + I gov
	0x00210e83, // n0x1749 c0x0000 (---------------)  + I med
	0x002c2a06, // n0x174a c0x0000 (---------------)  + I museum
	0x00218643, // n0x174b c0x0000 (---------------)  + I net
	0x0024d043, // n0x174c c0x0000 (---------------)  + I org
	0x002cfc43, // n0x174d c0x0000 (---------------)  + I pro
	0x0000d2c2, // n0x174e c0x0000 (---------------)  +   ae
	0x000dd187, // n0x174f c0x0000 (---------------)  +   blogdns
	0x000c6308, // n0x1750 c0x0000 (---------------)  +   blogsite
	0x00080ed2, // n0x1751 c0x0000 (---------------)  +   boldlygoingnowhere
	0x000c7a88, // n0x1752 c0x0000 (---------------)  +   dnsalias
	0x00181687, // n0x1753 c0x0000 (---------------)  +   dnsdojo
	0x000146cb, // n0x1754 c0x0000 (---------------)  +   doesntexist
	0x0012cb09, // n0x1755 c0x0000 (---------------)  +   dontexist
	0x000c7987, // n0x1756 c0x0000 (---------------)  +   doomdns
	0x001815c6, // n0x1757 c0x0000 (---------------)  +   dvrdns
	0x00159288, // n0x1758 c0x0000 (---------------)  +   dynalias
	0x3f40dc06, // n0x1759 c0x00fd (n0x1784-n0x1786)  +   dyndns
	0x0009d40d, // n0x175a c0x0000 (---------------)  +   endofinternet
	0x000ed550, // n0x175b c0x0000 (---------------)  +   endoftheinternet
	0x00064987, // n0x175c c0x0000 (---------------)  +   from-me
	0x0008cc89, // n0x175d c0x0000 (---------------)  +   game-host
	0x00052ac6, // n0x175e c0x0000 (---------------)  +   gotdns
	0x000301c2, // n0x175f c0x0000 (---------------)  +   hk
	0x000f45ca, // n0x1760 c0x0000 (---------------)  +   hobby-site
	0x00010e07, // n0x1761 c0x0000 (---------------)  +   homedns
	0x0000ddc7, // n0x1762 c0x0000 (---------------)  +   homeftp
	0x00099409, // n0x1763 c0x0000 (---------------)  +   homelinux
	0x00099ec8, // n0x1764 c0x0000 (---------------)  +   homeunix
	0x000ea54e, // n0x1765 c0x0000 (---------------)  +   is-a-bruinsfan
	0x00017f8e, // n0x1766 c0x0000 (---------------)  +   is-a-candidate
	0x00019ecf, // n0x1767 c0x0000 (---------------)  +   is-a-celticsfan
	0x0001f409, // n0x1768 c0x0000 (---------------)  +   is-a-chef
	0x00047789, // n0x1769 c0x0000 (---------------)  +   is-a-geek
	0x0006b7cb, // n0x176a c0x0000 (---------------)  +   is-a-knight
	0x0012ab0f, // n0x176b c0x0000 (---------------)  +   is-a-linux-user
	0x000a07cc, // n0x176c c0x0000 (---------------)  +   is-a-patsfan
	0x0011690b, // n0x176d c0x0000 (---------------)  +   is-a-soxfan
	0x000d9888, // n0x176e c0x0000 (---------------)  +   is-found
	0x000f1347, // n0x176f c0x0000 (---------------)  +   is-lost
	0x000e3c88, // n0x1770 c0x0000 (---------------)  +   is-saved
	0x0010e28b, // n0x1771 c0x0000 (---------------)  +   is-very-bad
	0x0011cf8c, // n0x1772 c0x0000 (---------------)  +   is-very-evil
	0x0011ff8c, // n0x1773 c0x0000 (---------------)  +   is-very-good
	0x0012708c, // n0x1774 c0x0000 (---------------)  +   is-very-nice
	0x0012bc8d, // n0x1775 c0x0000 (---------------)  +   is-very-sweet
	0x00013e48, // n0x1776 c0x0000 (---------------)  +   isa-geek
	0x00132909, // n0x1777 c0x0000 (---------------)  +   kicks-ass
	0x00151dcb, // n0x1778 c0x0000 (---------------)  +   misconfused
	0x000ccf07, // n0x1779 c0x0000 (---------------)  +   podzone
	0x000c618a, // n0x177a c0x0000 (---------------)  +   readmyblog
	0x00141246, // n0x177b c0x0000 (---------------)  +   selfip
	0x000b8fcd, // n0x177c c0x0000 (---------------)  +   sellsyourhome
	0x0000be88, // n0x177d c0x0000 (---------------)  +   servebbs
	0x0008e548, // n0x177e c0x0000 (---------------)  +   serveftp
	0x0008e7c9, // n0x177f c0x0000 (---------------)  +   servegame
	0x000dd7cc, // n0x1780 c0x0000 (---------------)  +   stuff-4-sale
	0x000073c2, // n0x1781 c0x0000 (---------------)  +   us
	0x0002c186, // n0x1782 c0x0000 (---------------)  +   webhop
	0x000028c2, // n0x1783 c0x0000 (---------------)  +   za
	0x00009ac2, // n0x1784 c0x0000 (---------------)  +   go
	0x0000ddc4, // n0x1785 c0x0000 (---------------)  +   home
	0x00217403, // n0x1786 c0x0000 (---------------)  + I abo
	0x00200b82, // n0x1787 c0x0000 (---------------)  + I ac
	0x00232dc3, // n0x1788 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1789 c0x0000 (---------------)  + I edu
	0x003704c3, // n0x178a c0x0000 (---------------)  + I gob
	0x00200243, // n0x178b c0x0000 (---------------)  + I ing
	0x00210e83, // n0x178c c0x0000 (---------------)  + I med
	0x00218643, // n0x178d c0x0000 (---------------)  + I net
	0x002104c3, // n0x178e c0x0000 (---------------)  + I nom
	0x0024d043, // n0x178f c0x0000 (---------------)  + I org
	0x002d3a83, // n0x1790 c0x0000 (---------------)  + I sld
	0x00232dc3, // n0x1791 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1792 c0x0000 (---------------)  + I edu
	0x003704c3, // n0x1793 c0x0000 (---------------)  + I gob
	0x00240443, // n0x1794 c0x0000 (---------------)  + I mil
	0x00218643, // n0x1795 c0x0000 (---------------)  + I net
	0x002104c3, // n0x1796 c0x0000 (---------------)  + I nom
	0x0024d043, // n0x1797 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x1798 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1799 c0x0000 (---------------)  + I edu
	0x0024d043, // n0x179a c0x0000 (---------------)  + I org
	0x00232dc3, // n0x179b c0x0000 (---------------)  + I com
	0x0021e083, // n0x179c c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x179d c0x0000 (---------------)  + I gov
	0x00200041, // n0x179e c0x0000 (---------------)  + I i
	0x00240443, // n0x179f c0x0000 (---------------)  + I mil
	0x00218643, // n0x17a0 c0x0000 (---------------)  + I net
	0x0024ad43, // n0x17a1 c0x0000 (---------------)  + I ngo
	0x0024d043, // n0x17a2 c0x0000 (---------------)  + I org
	0x00202183, // n0x17a3 c0x0000 (---------------)  + I biz
	0x00232dc3, // n0x17a4 c0x0000 (---------------)  + I com
	0x0021e083, // n0x17a5 c0x0000 (---------------)  + I edu
	0x00291143, // n0x17a6 c0x0000 (---------------)  + I fam
	0x003704c3, // n0x17a7 c0x0000 (---------------)  + I gob
	0x00269c03, // n0x17a8 c0x0000 (---------------)  + I gok
	0x00264203, // n0x17a9 c0x0000 (---------------)  + I gon
	0x00297e83, // n0x17aa c0x0000 (---------------)  + I gop
	0x0021dbc3, // n0x17ab c0x0000 (---------------)  + I gos
	0x00209ac3, // n0x17ac c0x0000 (---------------)  + I gov
	0x00208a44, // n0x17ad c0x0000 (---------------)  + I info
	0x00218643, // n0x17ae c0x0000 (---------------)  + I net
	0x0024d043, // n0x17af c0x0000 (---------------)  + I org
	0x002071c3, // n0x17b0 c0x0000 (---------------)  + I web
	0x0036d504, // n0x17b1 c0x0000 (---------------)  + I agro
	0x0020d643, // n0x17b2 c0x0000 (---------------)  + I aid
	0x00008d43, // n0x17b3 c0x0000 (---------------)  +   art
	0x00203283, // n0x17b4 c0x0000 (---------------)  + I atm
	0x002fd708, // n0x17b5 c0x0000 (---------------)  + I augustow
	0x00262c44, // n0x17b6 c0x0000 (---------------)  + I auto
	0x002c3e8a, // n0x17b7 c0x0000 (---------------)  + I babia-gora
	0x0020f9c6, // n0x17b8 c0x0000 (---------------)  + I bedzin
	0x0037ce07, // n0x17b9 c0x0000 (---------------)  + I beskidy
	0x0022150a, // n0x17ba c0x0000 (---------------)  + I bialowieza
	0x0023a5c9, // n0x17bb c0x0000 (---------------)  + I bialystok
	0x00200007, // n0x17bc c0x0000 (---------------)  + I bielawa
	0x0020274a, // n0x17bd c0x0000 (---------------)  + I bieszczady
	0x00202183, // n0x17be c0x0000 (---------------)  + I biz
	0x002df90b, // n0x17bf c0x0000 (---------------)  + I boleslawiec
	0x00274409, // n0x17c0 c0x0000 (---------------)  + I bydgoszcz
	0x002d09c5, // n0x17c1 c0x0000 (---------------)  + I bytom
	0x002c0747, // n0x17c2 c0x0000 (---------------)  + I cieszyn
	0x00000882, // n0x17c3 c0x0000 (---------------)  +   co
	0x00232dc3, // n0x17c4 c0x0000 (---------------)  + I com
	0x0032ea07, // n0x17c5 c0x0000 (---------------)  + I czeladz
	0x002283c5, // n0x17c6 c0x0000 (---------------)  + I czest
	0x002b0789, // n0x17c7 c0x0000 (---------------)  + I dlugoleka
	0x0021e083, // n0x17c8 c0x0000 (---------------)  + I edu
	0x00228b46, // n0x17c9 c0x0000 (---------------)  + I elblag
	0x002af303, // n0x17ca c0x0000 (---------------)  + I elk
	0x00018cc3, // n0x17cb c0x0000 (---------------)  +   gda
	0x000f2c86, // n0x17cc c0x0000 (---------------)  +   gdansk
	0x00166b06, // n0x17cd c0x0000 (---------------)  +   gdynia
	0x000079c7, // n0x17ce c0x0000 (---------------)  +   gliwice
	0x00211506, // n0x17cf c0x0000 (---------------)  + I glogow
	0x00224f05, // n0x17d0 c0x0000 (---------------)  + I gmina
	0x00237fc7, // n0x17d1 c0x0000 (---------------)  + I gniezno
	0x002e4c87, // n0x17d2 c0x0000 (---------------)  + I gorlice
	0x41209ac3, // n0x17d3 c0x0104 (n0x1856-n0x185f)  + I gov
	0x00306a07, // n0x17d4 c0x0000 (---------------)  + I grajewo
	0x0033ba43, // n0x17d5 c0x0000 (---------------)  + I gsm
	0x0036d945, // n0x17d6 c0x0000 (---------------)  + I ilawa
	0x00208a44, // n0x17d7 c0x0000 (---------------)  + I info
	0x0022cfc8, // n0x17d8 c0x0000 (---------------)  + I jaworzno
	0x003507cc, // n0x17d9 c0x0000 (---------------)  + I jelenia-gora
	0x002a1b85, // n0x17da c0x0000 (---------------)  + I jgora
	0x002a6b06, // n0x17db c0x0000 (---------------)  + I kalisz
	0x0032e8c7, // n0x17dc c0x0000 (---------------)  + I karpacz
	0x0037bd47, // n0x17dd c0x0000 (---------------)  + I kartuzy
	0x002061c7, // n0x17de c0x0000 (---------------)  + I kaszuby
	0x00214008, // n0x17df c0x0000 (---------------)  + I katowice
	0x00269dcf, // n0x17e0 c0x0000 (---------------)  + I kazimierz-dolny
	0x00349b45, // n0x17e1 c0x0000 (---------------)  + I kepno
	0x00241007, // n0x17e2 c0x0000 (---------------)  + I ketrzyn
	0x00248947, // n0x17e3 c0x0000 (---------------)  + I klodzko
	0x00298fca, // n0x17e4 c0x0000 (---------------)  + I kobierzyce
	0x0029a889, // n0x17e5 c0x0000 (---------------)  + I kolobrzeg
	0x002bd185, // n0x17e6 c0x0000 (---------------)  + I konin
	0x002c0cca, // n0x17e7 c0x0000 (---------------)  + I konskowola
	0x000a4106, // n0x17e8 c0x0000 (---------------)  +   krakow
	0x002af385, // n0x17e9 c0x0000 (---------------)  + I kutno
	0x002b9804, // n0x17ea c0x0000 (---------------)  + I lapy
	0x00262ac6, // n0x17eb c0x0000 (---------------)  + I lebork
	0x00278087, // n0x17ec c0x0000 (---------------)  + I legnica
	0x002dda47, // n0x17ed c0x0000 (---------------)  + I lezajsk
	0x00345708, // n0x17ee c0x0000 (---------------)  + I limanowa
	0x002cba85, // n0x17ef c0x0000 (---------------)  + I lomza
	0x002282c6, // n0x17f0 c0x0000 (---------------)  + I lowicz
	0x0034cb05, // n0x17f1 c0x0000 (---------------)  + I lubin
	0x00359945, // n0x17f2 c0x0000 (---------------)  + I lukow
	0x00214f44, // n0x17f3 c0x0000 (---------------)  + I mail
	0x0030e687, // n0x17f4 c0x0000 (---------------)  + I malbork
	0x002f99ca, // n0x17f5 c0x0000 (---------------)  + I malopolska
	0x002011c8, // n0x17f6 c0x0000 (---------------)  + I mazowsze
	0x002df1c6, // n0x17f7 c0x0000 (---------------)  + I mazury
	0x00010e83, // n0x17f8 c0x0000 (---------------)  +   med
	0x0021e585, // n0x17f9 c0x0000 (---------------)  + I media
	0x0029dd46, // n0x17fa c0x0000 (---------------)  + I miasta
	0x00201f86, // n0x17fb c0x0000 (---------------)  + I mielec
	0x0030a3c6, // n0x17fc c0x0000 (---------------)  + I mielno
	0x00240443, // n0x17fd c0x0000 (---------------)  + I mil
	0x00353f87, // n0x17fe c0x0000 (---------------)  + I mragowo
	0x002488c5, // n0x17ff c0x0000 (---------------)  + I naklo
	0x00218643, // n0x1800 c0x0000 (---------------)  + I net
	0x0026f98d, // n0x1801 c0x0000 (---------------)  + I nieruchomosci
	0x002104c3, // n0x1802 c0x0000 (---------------)  + I nom
	0x00345808, // n0x1803 c0x0000 (---------------)  + I nowaruda
	0x00233644, // n0x1804 c0x0000 (---------------)  + I nysa
	0x0026ee45, // n0x1805 c0x0000 (---------------)  + I olawa
	0x00298ec6, // n0x1806 c0x0000 (---------------)  + I olecko
	0x00275106, // n0x1807 c0x0000 (---------------)  + I olkusz
	0x0021ce87, // n0x1808 c0x0000 (---------------)  + I olsztyn
	0x0023a907, // n0x1809 c0x0000 (---------------)  + I opoczno
	0x00297245, // n0x180a c0x0000 (---------------)  + I opole
	0x0024d043, // n0x180b c0x0000 (---------------)  + I org
	0x00217287, // n0x180c c0x0000 (---------------)  + I ostroda
	0x0021c3c9, // n0x180d c0x0000 (---------------)  + I ostroleka
	0x0021dc09, // n0x180e c0x0000 (---------------)  + I ostrowiec
	0x0022b40a, // n0x180f c0x0000 (---------------)  + I ostrowwlkp
	0x0021c6c2, // n0x1810 c0x0000 (---------------)  + I pc
	0x0036d904, // n0x1811 c0x0000 (---------------)  + I pila
	0x002c9884, // n0x1812 c0x0000 (---------------)  + I pisz
	0x00242907, // n0x1813 c0x0000 (---------------)  + I podhale
	0x002cc648, // n0x1814 c0x0000 (---------------)  + I podlasie
	0x002cd309, // n0x1815 c0x0000 (---------------)  + I polkowice
	0x00221809, // n0x1816 c0x0000 (---------------)  + I pomorskie
	0x002cda47, // n0x1817 c0x0000 (---------------)  + I pomorze
	0x00226a06, // n0x1818 c0x0000 (---------------)  + I powiat
	0x000cf186, // n0x1819 c0x0000 (---------------)  +   poznan
	0x002cfac4, // n0x181a c0x0000 (---------------)  + I priv
	0x002cfc4a, // n0x181b c0x0000 (---------------)  + I prochowice
	0x002d3048, // n0x181c c0x0000 (---------------)  + I pruszkow
	0x002d3249, // n0x181d c0x0000 (---------------)  + I przeworsk
	0x002a9786, // n0x181e c0x0000 (---------------)  + I pulawy
	0x002fdd05, // n0x181f c0x0000 (---------------)  + I radom
	0x00201088, // n0x1820 c0x0000 (---------------)  + I rawa-maz
	0x002b614a, // n0x1821 c0x0000 (---------------)  + I realestate
	0x0027f043, // n0x1822 c0x0000 (---------------)  + I rel
	0x00273646, // n0x1823 c0x0000 (---------------)  + I rybnik
	0x002cdb47, // n0x1824 c0x0000 (---------------)  + I rzeszow
	0x003795c5, // n0x1825 c0x0000 (---------------)  + I sanok
	0x002546c5, // n0x1826 c0x0000 (---------------)  + I sejny
	0x0022ae43, // n0x1827 c0x0000 (---------------)  + I sex
	0x0022e644, // n0x1828 c0x0000 (---------------)  + I shop
	0x0022b1c5, // n0x1829 c0x0000 (---------------)  + I sklep
	0x0027c807, // n0x182a c0x0000 (---------------)  + I skoczow
	0x002e74c5, // n0x182b c0x0000 (---------------)  + I slask
	0x00331b86, // n0x182c c0x0000 (---------------)  + I slupsk
	0x000d5645, // n0x182d c0x0000 (---------------)  +   sopot
	0x002624c3, // n0x182e c0x0000 (---------------)  + I sos
	0x002624c9, // n0x182f c0x0000 (---------------)  + I sosnowiec
	0x0026ec0c, // n0x1830 c0x0000 (---------------)  + I stalowa-wola
	0x002e088c, // n0x1831 c0x0000 (---------------)  + I starachowice
	0x002bd588, // n0x1832 c0x0000 (---------------)  + I stargard
	0x002add87, // n0x1833 c0x0000 (---------------)  + I suwalki
	0x002e2048, // n0x1834 c0x0000 (---------------)  + I swidnica
	0x002e238a, // n0x1835 c0x0000 (---------------)  + I swiebodzin
	0x002e2b0b, // n0x1836 c0x0000 (---------------)  + I swinoujscie
	0x00274548, // n0x1837 c0x0000 (---------------)  + I szczecin
	0x002a6c08, // n0x1838 c0x0000 (---------------)  + I szczytno
	0x003818c6, // n0x1839 c0x0000 (---------------)  + I szkola
	0x002fb5c5, // n0x183a c0x0000 (---------------)  + I targi
	0x0036384a, // n0x183b c0x0000 (---------------)  + I tarnobrzeg
	0x002276c5, // n0x183c c0x0000 (---------------)  + I tgory
	0x002032c2, // n0x183d c0x0000 (---------------)  + I tm
	0x002b3cc7, // n0x183e c0x0000 (---------------)  + I tourism
	0x00290186, // n0x183f c0x0000 (---------------)  + I travel
	0x00332305, // n0x1840 c0x0000 (---------------)  + I turek
	0x002e4149, // n0x1841 c0x0000 (---------------)  + I turystyka
	0x00232f85, // n0x1842 c0x0000 (---------------)  + I tychy
	0x0029cf05, // n0x1843 c0x0000 (---------------)  + I ustka
	0x002fc789, // n0x1844 c0x0000 (---------------)  + I walbrzych
	0x0033e5c6, // n0x1845 c0x0000 (---------------)  + I warmia
	0x0025e288, // n0x1846 c0x0000 (---------------)  + I warszawa
	0x00276e43, // n0x1847 c0x0000 (---------------)  + I waw
	0x00211646, // n0x1848 c0x0000 (---------------)  + I wegrow
	0x0026dcc6, // n0x1849 c0x0000 (---------------)  + I wielun
	0x0029a685, // n0x184a c0x0000 (---------------)  + I wlocl
	0x0029a689, // n0x184b c0x0000 (---------------)  + I wloclawek
	0x0029dfc9, // n0x184c c0x0000 (---------------)  + I wodzislaw
	0x00255e47, // n0x184d c0x0000 (---------------)  + I wolomin
	0x000a4244, // n0x184e c0x0000 (---------------)  +   wroc
	0x002a4247, // n0x184f c0x0000 (---------------)  + I wroclaw
	0x00221709, // n0x1850 c0x0000 (---------------)  + I zachpomor
	0x0023d0c5, // n0x1851 c0x0000 (---------------)  + I zagan
	0x00043988, // n0x1852 c0x0000 (---------------)  +   zakopane
	0x0035fa45, // n0x1853 c0x0000 (---------------)  + I zarow
	0x0022af45, // n0x1854 c0x0000 (---------------)  + I zgora
	0x0022db89, // n0x1855 c0x0000 (---------------)  + I zgorzelec
	0x00200ac2, // n0x1856 c0x0000 (---------------)  + I pa
	0x002167c2, // n0x1857 c0x0000 (---------------)  + I po
	0x00209f02, // n0x1858 c0x0000 (---------------)  + I so
	0x002dc282, // n0x1859 c0x0000 (---------------)  + I sr
	0x0029de09, // n0x185a c0x0000 (---------------)  + I starostwo
	0x00201b02, // n0x185b c0x0000 (---------------)  + I ug
	0x00200f02, // n0x185c c0x0000 (---------------)  + I um
	0x002269c4, // n0x185d c0x0000 (---------------)  + I upow
	0x0023f482, // n0x185e c0x0000 (---------------)  + I uw
	0x00200882, // n0x185f c0x0000 (---------------)  + I co
	0x0021e083, // n0x1860 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1861 c0x0000 (---------------)  + I gov
	0x00218643, // n0x1862 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1863 c0x0000 (---------------)  + I org
	0x00200b82, // n0x1864 c0x0000 (---------------)  + I ac
	0x00202183, // n0x1865 c0x0000 (---------------)  + I biz
	0x00232dc3, // n0x1866 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1867 c0x0000 (---------------)  + I edu
	0x00209c03, // n0x1868 c0x0000 (---------------)  + I est
	0x00209ac3, // n0x1869 c0x0000 (---------------)  + I gov
	0x00208a44, // n0x186a c0x0000 (---------------)  + I info
	0x0029e0c4, // n0x186b c0x0000 (---------------)  + I isla
	0x00267944, // n0x186c c0x0000 (---------------)  + I name
	0x00218643, // n0x186d c0x0000 (---------------)  + I net
	0x0024d043, // n0x186e c0x0000 (---------------)  + I org
	0x002cfc43, // n0x186f c0x0000 (---------------)  + I pro
	0x002d0d84, // n0x1870 c0x0000 (---------------)  + I prof
	0x002bfb83, // n0x1871 c0x0000 (---------------)  + I aca
	0x00210ac3, // n0x1872 c0x0000 (---------------)  + I bar
	0x002256c3, // n0x1873 c0x0000 (---------------)  + I cpa
	0x002abd43, // n0x1874 c0x0000 (---------------)  + I eng
	0x002a3043, // n0x1875 c0x0000 (---------------)  + I jur
	0x002000c3, // n0x1876 c0x0000 (---------------)  + I law
	0x00210e83, // n0x1877 c0x0000 (---------------)  + I med
	0x00232dc3, // n0x1878 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1879 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x187a c0x0000 (---------------)  + I gov
	0x00218643, // n0x187b c0x0000 (---------------)  + I net
	0x0024d043, // n0x187c c0x0000 (---------------)  + I org
	0x002cba43, // n0x187d c0x0000 (---------------)  + I plo
	0x002e6143, // n0x187e c0x0000 (---------------)  + I sec
	0x0009e448, // n0x187f c0x0000 (---------------)  +   blogspot
	0x00232dc3, // n0x1880 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1881 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1882 c0x0000 (---------------)  + I gov
	0x002188c3, // n0x1883 c0x0000 (---------------)  + I int
	0x00218643, // n0x1884 c0x0000 (---------------)  + I net
	0x0023e704, // n0x1885 c0x0000 (---------------)  + I nome
	0x0024d043, // n0x1886 c0x0000 (---------------)  + I org
	0x002d7ec4, // n0x1887 c0x0000 (---------------)  + I publ
	0x002aa845, // n0x1888 c0x0000 (---------------)  + I belau
	0x00200882, // n0x1889 c0x0000 (---------------)  + I co
	0x00205742, // n0x188a c0x0000 (---------------)  + I ed
	0x00209ac2, // n0x188b c0x0000 (---------------)  + I go
	0x00209e82, // n0x188c c0x0000 (---------------)  + I ne
	0x00200d02, // n0x188d c0x0000 (---------------)  + I or
	0x00232dc3, // n0x188e c0x0000 (---------------)  + I com
	0x0023a884, // n0x188f c0x0000 (---------------)  + I coop
	0x0021e083, // n0x1890 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1891 c0x0000 (---------------)  + I gov
	0x00240443, // n0x1892 c0x0000 (---------------)  + I mil
	0x00218643, // n0x1893 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1894 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x1895 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1896 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1897 c0x0000 (---------------)  + I gov
	0x00240443, // n0x1898 c0x0000 (---------------)  + I mil
	0x00267944, // n0x1899 c0x0000 (---------------)  + I name
	0x00218643, // n0x189a c0x0000 (---------------)  + I net
	0x0024d043, // n0x189b c0x0000 (---------------)  + I org
	0x00251983, // n0x189c c0x0000 (---------------)  + I sch
	0x00278344, // n0x189d c0x0000 (---------------)  + I asso
	0x0009e448, // n0x189e c0x0000 (---------------)  +   blogspot
	0x00232dc3, // n0x189f c0x0000 (---------------)  + I com
	0x002104c3, // n0x18a0 c0x0000 (---------------)  + I nom
	0x0020b384, // n0x18a1 c0x0000 (---------------)  + I arts
	0x0009e448, // n0x18a2 c0x0000 (---------------)  +   blogspot
	0x00232dc3, // n0x18a3 c0x0000 (---------------)  + I com
	0x0024a304, // n0x18a4 c0x0000 (---------------)  + I firm
	0x00208a44, // n0x18a5 c0x0000 (---------------)  + I info
	0x002104c3, // n0x18a6 c0x0000 (---------------)  + I nom
	0x00200902, // n0x18a7 c0x0000 (---------------)  + I nt
	0x0024d043, // n0x18a8 c0x0000 (---------------)  + I org
	0x0022a143, // n0x18a9 c0x0000 (---------------)  + I rec
	0x002dc745, // n0x18aa c0x0000 (---------------)  + I store
	0x002032c2, // n0x18ab c0x0000 (---------------)  + I tm
	0x002b1c03, // n0x18ac c0x0000 (---------------)  + I www
	0x00200b82, // n0x18ad c0x0000 (---------------)  + I ac
	0x00200882, // n0x18ae c0x0000 (---------------)  + I co
	0x0021e083, // n0x18af c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x18b0 c0x0000 (---------------)  + I gov
	0x00200242, // n0x18b1 c0x0000 (---------------)  + I in
	0x0024d043, // n0x18b2 c0x0000 (---------------)  + I org
	0x00200b82, // n0x18b3 c0x0000 (---------------)  + I ac
	0x00202907, // n0x18b4 c0x0000 (---------------)  + I adygeya
	0x0036d205, // n0x18b5 c0x0000 (---------------)  + I altai
	0x002340c4, // n0x18b6 c0x0000 (---------------)  + I amur
	0x00332486, // n0x18b7 c0x0000 (---------------)  + I amursk
	0x002ff34b, // n0x18b8 c0x0000 (---------------)  + I arkhangelsk
	0x00231d89, // n0x18b9 c0x0000 (---------------)  + I astrakhan
	0x002a6a46, // n0x18ba c0x0000 (---------------)  + I baikal
	0x00334709, // n0x18bb c0x0000 (---------------)  + I bashkiria
	0x002c4cc8, // n0x18bc c0x0000 (---------------)  + I belgorod
	0x00208c43, // n0x18bd c0x0000 (---------------)  + I bir
	0x0009e448, // n0x18be c0x0000 (---------------)  +   blogspot
	0x0022b087, // n0x18bf c0x0000 (---------------)  + I bryansk
	0x002295c8, // n0x18c0 c0x0000 (---------------)  + I buryatia
	0x0033ffc3, // n0x18c1 c0x0000 (---------------)  + I cbg
	0x00313944, // n0x18c2 c0x0000 (---------------)  + I chel
	0x0034c18b, // n0x18c3 c0x0000 (---------------)  + I chelyabinsk
	0x00276ac5, // n0x18c4 c0x0000 (---------------)  + I chita
	0x00205b48, // n0x18c5 c0x0000 (---------------)  + I chukotka
	0x0031d989, // n0x18c6 c0x0000 (---------------)  + I chuvashia
	0x002a4443, // n0x18c7 c0x0000 (---------------)  + I cmw
	0x00232dc3, // n0x18c8 c0x0000 (---------------)  + I com
	0x00344008, // n0x18c9 c0x0000 (---------------)  + I dagestan
	0x00275b87, // n0x18ca c0x0000 (---------------)  + I dudinka
	0x002db146, // n0x18cb c0x0000 (---------------)  + I e-burg
	0x0021e083, // n0x18cc c0x0000 (---------------)  + I edu
	0x002fa247, // n0x18cd c0x0000 (---------------)  + I fareast
	0x00209ac3, // n0x18ce c0x0000 (---------------)  + I gov
	0x00239d46, // n0x18cf c0x0000 (---------------)  + I grozny
	0x002188c3, // n0x18d0 c0x0000 (---------------)  + I int
	0x0022ec87, // n0x18d1 c0x0000 (---------------)  + I irkutsk
	0x002fec47, // n0x18d2 c0x0000 (---------------)  + I ivanovo
	0x0035ad47, // n0x18d3 c0x0000 (---------------)  + I izhevsk
	0x0030e605, // n0x18d4 c0x0000 (---------------)  + I jamal
	0x00203fc3, // n0x18d5 c0x0000 (---------------)  + I jar
	0x002a888b, // n0x18d6 c0x0000 (---------------)  + I joshkar-ola
	0x0036e648, // n0x18d7 c0x0000 (---------------)  + I k-uralsk
	0x002246c8, // n0x18d8 c0x0000 (---------------)  + I kalmykia
	0x0022f506, // n0x18d9 c0x0000 (---------------)  + I kaluga
	0x0020f049, // n0x18da c0x0000 (---------------)  + I kamchatka
	0x00343107, // n0x18db c0x0000 (---------------)  + I karelia
	0x002f1805, // n0x18dc c0x0000 (---------------)  + I kazan
	0x00351684, // n0x18dd c0x0000 (---------------)  + I kchr
	0x00360a48, // n0x18de c0x0000 (---------------)  + I kemerovo
	0x0023cb0a, // n0x18df c0x0000 (---------------)  + I khabarovsk
	0x0023cd49, // n0x18e0 c0x0000 (---------------)  + I khakassia
	0x00267283, // n0x18e1 c0x0000 (---------------)  + I khv
	0x0022d7c5, // n0x18e2 c0x0000 (---------------)  + I kirov
	0x00286643, // n0x18e3 c0x0000 (---------------)  + I kms
	0x002d2bc6, // n0x18e4 c0x0000 (---------------)  + I koenig
	0x002a1884, // n0x18e5 c0x0000 (---------------)  + I komi
	0x002f4e48, // n0x18e6 c0x0000 (---------------)  + I kostroma
	0x002a470b, // n0x18e7 c0x0000 (---------------)  + I krasnoyarsk
	0x00327605, // n0x18e8 c0x0000 (---------------)  + I kuban
	0x002aa5c6, // n0x18e9 c0x0000 (---------------)  + I kurgan
	0x002ad2c5, // n0x18ea c0x0000 (---------------)  + I kursk
	0x002ae788, // n0x18eb c0x0000 (---------------)  + I kustanai
	0x002af4c7, // n0x18ec c0x0000 (---------------)  + I kuzbass
	0x00369d07, // n0x18ed c0x0000 (---------------)  + I lipetsk
	0x0030ab07, // n0x18ee c0x0000 (---------------)  + I magadan
	0x00213608, // n0x18ef c0x0000 (---------------)  + I magnitka
	0x0023d384, // n0x18f0 c0x0000 (---------------)  + I mari
	0x0023d387, // n0x18f1 c0x0000 (---------------)  + I mari-el
	0x0033f146, // n0x18f2 c0x0000 (---------------)  + I marine
	0x00240443, // n0x18f3 c0x0000 (---------------)  + I mil
	0x002b8708, // n0x18f4 c0x0000 (---------------)  + I mordovia
	0x0024e983, // n0x18f5 c0x0000 (---------------)  + I msk
	0x002c0b08, // n0x18f6 c0x0000 (---------------)  + I murmansk
	0x002c4305, // n0x18f7 c0x0000 (---------------)  + I mytis
	0x002cbfc8, // n0x18f8 c0x0000 (---------------)  + I nakhodka
	0x0021e287, // n0x18f9 c0x0000 (---------------)  + I nalchik
	0x00218643, // n0x18fa c0x0000 (---------------)  + I net
	0x00371383, // n0x18fb c0x0000 (---------------)  + I nkz
	0x00283004, // n0x18fc c0x0000 (---------------)  + I nnov
	0x00200cc7, // n0x18fd c0x0000 (---------------)  + I norilsk
	0x0020a143, // n0x18fe c0x0000 (---------------)  + I nov
	0x002fed0b, // n0x18ff c0x0000 (---------------)  + I novosibirsk
	0x0020ae83, // n0x1900 c0x0000 (---------------)  + I nsk
	0x0024e944, // n0x1901 c0x0000 (---------------)  + I omsk
	0x002dc7c8, // n0x1902 c0x0000 (---------------)  + I orenburg
	0x0024d043, // n0x1903 c0x0000 (---------------)  + I org
	0x002dba85, // n0x1904 c0x0000 (---------------)  + I oryol
	0x002f5205, // n0x1905 c0x0000 (---------------)  + I oskol
	0x00203346, // n0x1906 c0x0000 (---------------)  + I palana
	0x00212f85, // n0x1907 c0x0000 (---------------)  + I penza
	0x002c46c4, // n0x1908 c0x0000 (---------------)  + I perm
	0x00200a82, // n0x1909 c0x0000 (---------------)  + I pp
	0x002d3503, // n0x190a c0x0000 (---------------)  + I ptz
	0x002b988a, // n0x190b c0x0000 (---------------)  + I pyatigorsk
	0x0032e3c3, // n0x190c c0x0000 (---------------)  + I rnd
	0x00360f89, // n0x190d c0x0000 (---------------)  + I rubtsovsk
	0x002374c6, // n0x190e c0x0000 (---------------)  + I ryazan
	0x00223048, // n0x190f c0x0000 (---------------)  + I sakhalin
	0x00284d46, // n0x1910 c0x0000 (---------------)  + I samara
	0x00246287, // n0x1911 c0x0000 (---------------)  + I saratov
	0x00316648, // n0x1912 c0x0000 (---------------)  + I simbirsk
	0x002b3e08, // n0x1913 c0x0000 (---------------)  + I smolensk
	0x00339f83, // n0x1914 c0x0000 (---------------)  + I snz
	0x002d9bc3, // n0x1915 c0x0000 (---------------)  + I spb
	0x0023dbc9, // n0x1916 c0x0000 (---------------)  + I stavropol
	0x002eb3c3, // n0x1917 c0x0000 (---------------)  + I stv
	0x002d0506, // n0x1918 c0x0000 (---------------)  + I surgut
	0x0037e7c6, // n0x1919 c0x0000 (---------------)  + I syzran
	0x00366046, // n0x191a c0x0000 (---------------)  + I tambov
	0x00210249, // n0x191b c0x0000 (---------------)  + I tatarstan
	0x0029e284, // n0x191c c0x0000 (---------------)  + I test
	0x0022bac3, // n0x191d c0x0000 (---------------)  + I tom
	0x00337545, // n0x191e c0x0000 (---------------)  + I tomsk
	0x00378609, // n0x191f c0x0000 (---------------)  + I tsaritsyn
	0x0021d443, // n0x1920 c0x0000 (---------------)  + I tsk
	0x002e3e84, // n0x1921 c0x0000 (---------------)  + I tula
	0x002e5704, // n0x1922 c0x0000 (---------------)  + I tuva
	0x002e5c44, // n0x1923 c0x0000 (---------------)  + I tver
	0x002d2ec6, // n0x1924 c0x0000 (---------------)  + I tyumen
	0x00365503, // n0x1925 c0x0000 (---------------)  + I udm
	0x00365508, // n0x1926 c0x0000 (---------------)  + I udmurtia
	0x00254408, // n0x1927 c0x0000 (---------------)  + I ulan-ude
	0x002e6a86, // n0x1928 c0x0000 (---------------)  + I vdonsk
	0x002f160b, // n0x1929 c0x0000 (---------------)  + I vladikavkaz
	0x002f1948, // n0x192a c0x0000 (---------------)  + I vladimir
	0x002f1b4b, // n0x192b c0x0000 (---------------)  + I vladivostok
	0x002f22c9, // n0x192c c0x0000 (---------------)  + I volgograd
	0x002f2b87, // n0x192d c0x0000 (---------------)  + I vologda
	0x002f3908, // n0x192e c0x0000 (---------------)  + I voronezh
	0x002f4843, // n0x192f c0x0000 (---------------)  + I vrn
	0x00204a86, // n0x1930 c0x0000 (---------------)  + I vyatka
	0x002e5547, // n0x1931 c0x0000 (---------------)  + I yakutia
	0x0028db05, // n0x1932 c0x0000 (---------------)  + I yamal
	0x00326a09, // n0x1933 c0x0000 (---------------)  + I yaroslavl
	0x0036680d, // n0x1934 c0x0000 (---------------)  + I yekaterinburg
	0x00222e91, // n0x1935 c0x0000 (---------------)  + I yuzhno-sakhalinsk
	0x0023af45, // n0x1936 c0x0000 (---------------)  + I zgrad
	0x00200b82, // n0x1937 c0x0000 (---------------)  + I ac
	0x00200882, // n0x1938 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x1939 c0x0000 (---------------)  + I com
	0x0021e083, // n0x193a c0x0000 (---------------)  + I edu
	0x00252544, // n0x193b c0x0000 (---------------)  + I gouv
	0x00209ac3, // n0x193c c0x0000 (---------------)  + I gov
	0x002188c3, // n0x193d c0x0000 (---------------)  + I int
	0x00240443, // n0x193e c0x0000 (---------------)  + I mil
	0x00218643, // n0x193f c0x0000 (---------------)  + I net
	0x00232dc3, // n0x1940 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1941 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1942 c0x0000 (---------------)  + I gov
	0x00210e83, // n0x1943 c0x0000 (---------------)  + I med
	0x00218643, // n0x1944 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1945 c0x0000 (---------------)  + I org
	0x0025dbc3, // n0x1946 c0x0000 (---------------)  + I pub
	0x00251983, // n0x1947 c0x0000 (---------------)  + I sch
	0x00232dc3, // n0x1948 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1949 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x194a c0x0000 (---------------)  + I gov
	0x00218643, // n0x194b c0x0000 (---------------)  + I net
	0x0024d043, // n0x194c c0x0000 (---------------)  + I org
	0x00232dc3, // n0x194d c0x0000 (---------------)  + I com
	0x0021e083, // n0x194e c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x194f c0x0000 (---------------)  + I gov
	0x00218643, // n0x1950 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1951 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x1952 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1953 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1954 c0x0000 (---------------)  + I gov
	0x00208a44, // n0x1955 c0x0000 (---------------)  + I info
	0x00210e83, // n0x1956 c0x0000 (---------------)  + I med
	0x00218643, // n0x1957 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1958 c0x0000 (---------------)  + I org
	0x0028dc82, // n0x1959 c0x0000 (---------------)  + I tv
	0x00200101, // n0x195a c0x0000 (---------------)  + I a
	0x00200b82, // n0x195b c0x0000 (---------------)  + I ac
	0x00200001, // n0x195c c0x0000 (---------------)  + I b
	0x00303202, // n0x195d c0x0000 (---------------)  + I bd
	0x0009e448, // n0x195e c0x0000 (---------------)  +   blogspot
	0x0021e6c5, // n0x195f c0x0000 (---------------)  + I brand
	0x00200401, // n0x1960 c0x0000 (---------------)  + I c
	0x00032dc3, // n0x1961 c0x0000 (---------------)  +   com
	0x002003c1, // n0x1962 c0x0000 (---------------)  + I d
	0x00200081, // n0x1963 c0x0000 (---------------)  + I e
	0x00203841, // n0x1964 c0x0000 (---------------)  + I f
	0x00246f02, // n0x1965 c0x0000 (---------------)  + I fh
	0x00379704, // n0x1966 c0x0000 (---------------)  + I fhsk
	0x00246f03, // n0x1967 c0x0000 (---------------)  + I fhv
	0x002002c1, // n0x1968 c0x0000 (---------------)  + I g
	0x00200201, // n0x1969 c0x0000 (---------------)  + I h
	0x00200041, // n0x196a c0x0000 (---------------)  + I i
	0x00200481, // n0x196b c0x0000 (---------------)  + I k
	0x0032cec7, // n0x196c c0x0000 (---------------)  + I komforb
	0x002c114f, // n0x196d c0x0000 (---------------)  + I kommunalforbund
	0x002b9ac6, // n0x196e c0x0000 (---------------)  + I komvux
	0x002000c1, // n0x196f c0x0000 (---------------)  + I l
	0x00381b06, // n0x1970 c0x0000 (---------------)  + I lanbib
	0x00200f41, // n0x1971 c0x0000 (---------------)  + I m
	0x00200281, // n0x1972 c0x0000 (---------------)  + I n
	0x0031a18e, // n0x1973 c0x0000 (---------------)  + I naturbruksgymn
	0x00200341, // n0x1974 c0x0000 (---------------)  + I o
	0x0024d043, // n0x1975 c0x0000 (---------------)  + I org
	0x00200a81, // n0x1976 c0x0000 (---------------)  + I p
	0x00297f05, // n0x1977 c0x0000 (---------------)  + I parti
	0x00200a82, // n0x1978 c0x0000 (---------------)  + I pp
	0x0022ad45, // n0x1979 c0x0000 (---------------)  + I press
	0x002006c1, // n0x197a c0x0000 (---------------)  + I r
	0x002001c1, // n0x197b c0x0000 (---------------)  + I s
	0x00200301, // n0x197c c0x0000 (---------------)  + I t
	0x002032c2, // n0x197d c0x0000 (---------------)  + I tm
	0x00200541, // n0x197e c0x0000 (---------------)  + I u
	0x00200141, // n0x197f c0x0000 (---------------)  + I w
	0x002013c1, // n0x1980 c0x0000 (---------------)  + I x
	0x00202981, // n0x1981 c0x0000 (---------------)  + I y
	0x00201241, // n0x1982 c0x0000 (---------------)  + I z
	0x0009e448, // n0x1983 c0x0000 (---------------)  +   blogspot
	0x00232dc3, // n0x1984 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1985 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1986 c0x0000 (---------------)  + I gov
	0x00218643, // n0x1987 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1988 c0x0000 (---------------)  + I org
	0x0020c783, // n0x1989 c0x0000 (---------------)  + I per
	0x00232dc3, // n0x198a c0x0000 (---------------)  + I com
	0x00209ac3, // n0x198b c0x0000 (---------------)  + I gov
	0x00240443, // n0x198c c0x0000 (---------------)  + I mil
	0x00218643, // n0x198d c0x0000 (---------------)  + I net
	0x0024d043, // n0x198e c0x0000 (---------------)  + I org
	0x0009e448, // n0x198f c0x0000 (---------------)  +   blogspot
	0x00232dc3, // n0x1990 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1991 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1992 c0x0000 (---------------)  + I gov
	0x00218643, // n0x1993 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1994 c0x0000 (---------------)  + I org
	0x00208d43, // n0x1995 c0x0000 (---------------)  + I art
	0x00232dc3, // n0x1996 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1997 c0x0000 (---------------)  + I edu
	0x00252544, // n0x1998 c0x0000 (---------------)  + I gouv
	0x0024d043, // n0x1999 c0x0000 (---------------)  + I org
	0x002a80c5, // n0x199a c0x0000 (---------------)  + I perso
	0x003826c4, // n0x199b c0x0000 (---------------)  + I univ
	0x00232dc3, // n0x199c c0x0000 (---------------)  + I com
	0x00218643, // n0x199d c0x0000 (---------------)  + I net
	0x0024d043, // n0x199e c0x0000 (---------------)  + I org
	0x00200882, // n0x199f c0x0000 (---------------)  + I co
	0x00232dc3, // n0x19a0 c0x0000 (---------------)  + I com
	0x00235e09, // n0x19a1 c0x0000 (---------------)  + I consulado
	0x0021e083, // n0x19a2 c0x0000 (---------------)  + I edu
	0x002aaf09, // n0x19a3 c0x0000 (---------------)  + I embaixada
	0x00209ac3, // n0x19a4 c0x0000 (---------------)  + I gov
	0x00240443, // n0x19a5 c0x0000 (---------------)  + I mil
	0x00218643, // n0x19a6 c0x0000 (---------------)  + I net
	0x0024d043, // n0x19a7 c0x0000 (---------------)  + I org
	0x002cf8c8, // n0x19a8 c0x0000 (---------------)  + I principe
	0x00241fc7, // n0x19a9 c0x0000 (---------------)  + I saotome
	0x002dc745, // n0x19aa c0x0000 (---------------)  + I store
	0x00232dc3, // n0x19ab c0x0000 (---------------)  + I com
	0x0021e083, // n0x19ac c0x0000 (---------------)  + I edu
	0x003704c3, // n0x19ad c0x0000 (---------------)  + I gob
	0x0024d043, // n0x19ae c0x0000 (---------------)  + I org
	0x0023fbc3, // n0x19af c0x0000 (---------------)  + I red
	0x00209ac3, // n0x19b0 c0x0000 (---------------)  + I gov
	0x00232dc3, // n0x19b1 c0x0000 (---------------)  + I com
	0x0021e083, // n0x19b2 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x19b3 c0x0000 (---------------)  + I gov
	0x00240443, // n0x19b4 c0x0000 (---------------)  + I mil
	0x00218643, // n0x19b5 c0x0000 (---------------)  + I net
	0x0024d043, // n0x19b6 c0x0000 (---------------)  + I org
	0x00200b82, // n0x19b7 c0x0000 (---------------)  + I ac
	0x00200882, // n0x19b8 c0x0000 (---------------)  + I co
	0x0024d043, // n0x19b9 c0x0000 (---------------)  + I org
	0x0009e448, // n0x19ba c0x0000 (---------------)  +   blogspot
	0x00200b82, // n0x19bb c0x0000 (---------------)  + I ac
	0x00200882, // n0x19bc c0x0000 (---------------)  + I co
	0x00209ac2, // n0x19bd c0x0000 (---------------)  + I go
	0x00200242, // n0x19be c0x0000 (---------------)  + I in
	0x00200f42, // n0x19bf c0x0000 (---------------)  + I mi
	0x00218643, // n0x19c0 c0x0000 (---------------)  + I net
	0x00200d02, // n0x19c1 c0x0000 (---------------)  + I or
	0x00200b82, // n0x19c2 c0x0000 (---------------)  + I ac
	0x00202183, // n0x19c3 c0x0000 (---------------)  + I biz
	0x00200882, // n0x19c4 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x19c5 c0x0000 (---------------)  + I com
	0x0021e083, // n0x19c6 c0x0000 (---------------)  + I edu
	0x00209ac2, // n0x19c7 c0x0000 (---------------)  + I go
	0x00209ac3, // n0x19c8 c0x0000 (---------------)  + I gov
	0x002188c3, // n0x19c9 c0x0000 (---------------)  + I int
	0x00240443, // n0x19ca c0x0000 (---------------)  + I mil
	0x00267944, // n0x19cb c0x0000 (---------------)  + I name
	0x00218643, // n0x19cc c0x0000 (---------------)  + I net
	0x00219583, // n0x19cd c0x0000 (---------------)  + I nic
	0x0024d043, // n0x19ce c0x0000 (---------------)  + I org
	0x0029e284, // n0x19cf c0x0000 (---------------)  + I test
	0x002071c3, // n0x19d0 c0x0000 (---------------)  + I web
	0x00209ac3, // n0x19d1 c0x0000 (---------------)  + I gov
	0x00200882, // n0x19d2 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x19d3 c0x0000 (---------------)  + I com
	0x0021e083, // n0x19d4 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x19d5 c0x0000 (---------------)  + I gov
	0x00240443, // n0x19d6 c0x0000 (---------------)  + I mil
	0x00218643, // n0x19d7 c0x0000 (---------------)  + I net
	0x002104c3, // n0x19d8 c0x0000 (---------------)  + I nom
	0x0024d043, // n0x19d9 c0x0000 (---------------)  + I org
	0x00371147, // n0x19da c0x0000 (---------------)  + I agrinet
	0x00232dc3, // n0x19db c0x0000 (---------------)  + I com
	0x00254587, // n0x19dc c0x0000 (---------------)  + I defense
	0x0030cc46, // n0x19dd c0x0000 (---------------)  + I edunet
	0x0020ae43, // n0x19de c0x0000 (---------------)  + I ens
	0x00206f03, // n0x19df c0x0000 (---------------)  + I fin
	0x00209ac3, // n0x19e0 c0x0000 (---------------)  + I gov
	0x002202c3, // n0x19e1 c0x0000 (---------------)  + I ind
	0x00208a44, // n0x19e2 c0x0000 (---------------)  + I info
	0x002ea3c4, // n0x19e3 c0x0000 (---------------)  + I intl
	0x002ca586, // n0x19e4 c0x0000 (---------------)  + I mincom
	0x0020f603, // n0x19e5 c0x0000 (---------------)  + I nat
	0x00218643, // n0x19e6 c0x0000 (---------------)  + I net
	0x0024d043, // n0x19e7 c0x0000 (---------------)  + I org
	0x002a80c5, // n0x19e8 c0x0000 (---------------)  + I perso
	0x0021cc84, // n0x19e9 c0x0000 (---------------)  + I rnrt
	0x002273c3, // n0x19ea c0x0000 (---------------)  + I rns
	0x0037bb83, // n0x19eb c0x0000 (---------------)  + I rnu
	0x002b3cc7, // n0x19ec c0x0000 (---------------)  + I tourism
	0x002ee1c5, // n0x19ed c0x0000 (---------------)  + I turen
	0x00232dc3, // n0x19ee c0x0000 (---------------)  + I com
	0x0021e083, // n0x19ef c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x19f0 c0x0000 (---------------)  + I gov
	0x00240443, // n0x19f1 c0x0000 (---------------)  + I mil
	0x00218643, // n0x19f2 c0x0000 (---------------)  + I net
	0x0024d043, // n0x19f3 c0x0000 (---------------)  + I org
	0x00201602, // n0x19f4 c0x0000 (---------------)  + I av
	0x0020bfc3, // n0x19f5 c0x0000 (---------------)  + I bbs
	0x002111c3, // n0x19f6 c0x0000 (---------------)  + I bel
	0x00202183, // n0x19f7 c0x0000 (---------------)  + I biz
	0x4aa32dc3, // n0x19f8 c0x012a (n0x1a09-n0x1a0a)  + I com
	0x0020fc02, // n0x19f9 c0x0000 (---------------)  + I dr
	0x0021e083, // n0x19fa c0x0000 (---------------)  + I edu
	0x0020a0c3, // n0x19fb c0x0000 (---------------)  + I gen
	0x00209ac3, // n0x19fc c0x0000 (---------------)  + I gov
	0x00208a44, // n0x19fd c0x0000 (---------------)  + I info
	0x0036e803, // n0x19fe c0x0000 (---------------)  + I k12
	0x00349b43, // n0x19ff c0x0000 (---------------)  + I kep
	0x00240443, // n0x1a00 c0x0000 (---------------)  + I mil
	0x00267944, // n0x1a01 c0x0000 (---------------)  + I name
	0x4ae0a682, // n0x1a02 c0x012b (n0x1a0a-n0x1a0b)  + I nc
	0x00218643, // n0x1a03 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1a04 c0x0000 (---------------)  + I org
	0x002369c3, // n0x1a05 c0x0000 (---------------)  + I pol
	0x00218943, // n0x1a06 c0x0000 (---------------)  + I tel
	0x0028dc82, // n0x1a07 c0x0000 (---------------)  + I tv
	0x002071c3, // n0x1a08 c0x0000 (---------------)  + I web
	0x0009e448, // n0x1a09 c0x0000 (---------------)  +   blogspot
	0x00209ac3, // n0x1a0a c0x0000 (---------------)  + I gov
	0x00233784, // n0x1a0b c0x0000 (---------------)  + I aero
	0x00202183, // n0x1a0c c0x0000 (---------------)  + I biz
	0x00200882, // n0x1a0d c0x0000 (---------------)  + I co
	0x00232dc3, // n0x1a0e c0x0000 (---------------)  + I com
	0x0023a884, // n0x1a0f c0x0000 (---------------)  + I coop
	0x0021e083, // n0x1a10 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1a11 c0x0000 (---------------)  + I gov
	0x00208a44, // n0x1a12 c0x0000 (---------------)  + I info
	0x002188c3, // n0x1a13 c0x0000 (---------------)  + I int
	0x0027e604, // n0x1a14 c0x0000 (---------------)  + I jobs
	0x00277f84, // n0x1a15 c0x0000 (---------------)  + I mobi
	0x002c2a06, // n0x1a16 c0x0000 (---------------)  + I museum
	0x00267944, // n0x1a17 c0x0000 (---------------)  + I name
	0x00218643, // n0x1a18 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1a19 c0x0000 (---------------)  + I org
	0x002cfc43, // n0x1a1a c0x0000 (---------------)  + I pro
	0x00290186, // n0x1a1b c0x0000 (---------------)  + I travel
	0x00050f4b, // n0x1a1c c0x0000 (---------------)  +   better-than
	0x0000dc06, // n0x1a1d c0x0000 (---------------)  +   dyndns
	0x0001618a, // n0x1a1e c0x0000 (---------------)  +   on-the-web
	0x001540ca, // n0x1a1f c0x0000 (---------------)  +   worse-than
	0x0009e448, // n0x1a20 c0x0000 (---------------)  +   blogspot
	0x0034cac4, // n0x1a21 c0x0000 (---------------)  + I club
	0x00232dc3, // n0x1a22 c0x0000 (---------------)  + I com
	0x00202144, // n0x1a23 c0x0000 (---------------)  + I ebiz
	0x0021e083, // n0x1a24 c0x0000 (---------------)  + I edu
	0x0028cc84, // n0x1a25 c0x0000 (---------------)  + I game
	0x00209ac3, // n0x1a26 c0x0000 (---------------)  + I gov
	0x00309c83, // n0x1a27 c0x0000 (---------------)  + I idv
	0x00240443, // n0x1a28 c0x0000 (---------------)  + I mil
	0x00218643, // n0x1a29 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1a2a c0x0000 (---------------)  + I org
	0x00310e0b, // n0x1a2b c0x0000 (---------------)  + I xn--czrw28b
	0x00372b4a, // n0x1a2c c0x0000 (---------------)  + I xn--uc0atv
	0x003841cc, // n0x1a2d c0x0000 (---------------)  + I xn--zf0ao64a
	0x00200b82, // n0x1a2e c0x0000 (---------------)  + I ac
	0x00200882, // n0x1a2f c0x0000 (---------------)  + I co
	0x00209ac2, // n0x1a30 c0x0000 (---------------)  + I go
	0x0029d805, // n0x1a31 c0x0000 (---------------)  + I hotel
	0x00208a44, // n0x1a32 c0x0000 (---------------)  + I info
	0x00204342, // n0x1a33 c0x0000 (---------------)  + I me
	0x00240443, // n0x1a34 c0x0000 (---------------)  + I mil
	0x00277f84, // n0x1a35 c0x0000 (---------------)  + I mobi
	0x00209e82, // n0x1a36 c0x0000 (---------------)  + I ne
	0x00200d02, // n0x1a37 c0x0000 (---------------)  + I or
	0x0021bcc2, // n0x1a38 c0x0000 (---------------)  + I sc
	0x0028dc82, // n0x1a39 c0x0000 (---------------)  + I tv
	0x002a3649, // n0x1a3a c0x0000 (---------------)  + I cherkassy
	0x0037e648, // n0x1a3b c0x0000 (---------------)  + I cherkasy
	0x0025ec89, // n0x1a3c c0x0000 (---------------)  + I chernigov
	0x002626c9, // n0x1a3d c0x0000 (---------------)  + I chernihiv
	0x002634ca, // n0x1a3e c0x0000 (---------------)  + I chernivtsi
	0x002669ca, // n0x1a3f c0x0000 (---------------)  + I chernovtsy
	0x00206182, // n0x1a40 c0x0000 (---------------)  + I ck
	0x0022fe42, // n0x1a41 c0x0000 (---------------)  + I cn
	0x00200882, // n0x1a42 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x1a43 c0x0000 (---------------)  + I com
	0x0020b542, // n0x1a44 c0x0000 (---------------)  + I cr
	0x002411c6, // n0x1a45 c0x0000 (---------------)  + I crimea
	0x00333d82, // n0x1a46 c0x0000 (---------------)  + I cv
	0x0020dcc2, // n0x1a47 c0x0000 (---------------)  + I dn
	0x002da50e, // n0x1a48 c0x0000 (---------------)  + I dnepropetrovsk
	0x002f9d4e, // n0x1a49 c0x0000 (---------------)  + I dnipropetrovsk
	0x00276947, // n0x1a4a c0x0000 (---------------)  + I dominic
	0x0021d347, // n0x1a4b c0x0000 (---------------)  + I donetsk
	0x00218802, // n0x1a4c c0x0000 (---------------)  + I dp
	0x0021e083, // n0x1a4d c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1a4e c0x0000 (---------------)  + I gov
	0x00203802, // n0x1a4f c0x0000 (---------------)  + I if
	0x00200242, // n0x1a50 c0x0000 (---------------)  + I in
	0x0024bd8f, // n0x1a51 c0x0000 (---------------)  + I ivano-frankivsk
	0x002230c2, // n0x1a52 c0x0000 (---------------)  + I kh
	0x0023d887, // n0x1a53 c0x0000 (---------------)  + I kharkiv
	0x00240607, // n0x1a54 c0x0000 (---------------)  + I kharkov
	0x00247987, // n0x1a55 c0x0000 (---------------)  + I kherson
	0x0024c10c, // n0x1a56 c0x0000 (---------------)  + I khmelnitskiy
	0x00254f8c, // n0x1a57 c0x0000 (---------------)  + I khmelnytskyi
	0x0029ae84, // n0x1a58 c0x0000 (---------------)  + I kiev
	0x0022d7ca, // n0x1a59 c0x0000 (---------------)  + I kirovograd
	0x00286642, // n0x1a5a c0x0000 (---------------)  + I km
	0x0020c642, // n0x1a5b c0x0000 (---------------)  + I kr
	0x002a5dc4, // n0x1a5c c0x0000 (---------------)  + I krym
	0x0021f9c2, // n0x1a5d c0x0000 (---------------)  + I ks
	0x002b0202, // n0x1a5e c0x0000 (---------------)  + I kv
	0x002551c4, // n0x1a5f c0x0000 (---------------)  + I kyiv
	0x00219682, // n0x1a60 c0x0000 (---------------)  + I lg
	0x0021a082, // n0x1a61 c0x0000 (---------------)  + I lt
	0x0022f587, // n0x1a62 c0x0000 (---------------)  + I lugansk
	0x00240505, // n0x1a63 c0x0000 (---------------)  + I lutsk
	0x00218582, // n0x1a64 c0x0000 (---------------)  + I lv
	0x0024bd04, // n0x1a65 c0x0000 (---------------)  + I lviv
	0x00340582, // n0x1a66 c0x0000 (---------------)  + I mk
	0x002feac8, // n0x1a67 c0x0000 (---------------)  + I mykolaiv
	0x00218643, // n0x1a68 c0x0000 (---------------)  + I net
	0x0020d188, // n0x1a69 c0x0000 (---------------)  + I nikolaev
	0x00202bc2, // n0x1a6a c0x0000 (---------------)  + I od
	0x00238e85, // n0x1a6b c0x0000 (---------------)  + I odesa
	0x0034a206, // n0x1a6c c0x0000 (---------------)  + I odessa
	0x0024d043, // n0x1a6d c0x0000 (---------------)  + I org
	0x0020a402, // n0x1a6e c0x0000 (---------------)  + I pl
	0x002cd547, // n0x1a6f c0x0000 (---------------)  + I poltava
	0x00200a82, // n0x1a70 c0x0000 (---------------)  + I pp
	0x002cfb05, // n0x1a71 c0x0000 (---------------)  + I rivne
	0x00210885, // n0x1a72 c0x0000 (---------------)  + I rovno
	0x0020bf02, // n0x1a73 c0x0000 (---------------)  + I rv
	0x00214502, // n0x1a74 c0x0000 (---------------)  + I sb
	0x002ec84a, // n0x1a75 c0x0000 (---------------)  + I sebastopol
	0x002970ca, // n0x1a76 c0x0000 (---------------)  + I sevastopol
	0x0024f102, // n0x1a77 c0x0000 (---------------)  + I sm
	0x002f3284, // n0x1a78 c0x0000 (---------------)  + I sumy
	0x00207302, // n0x1a79 c0x0000 (---------------)  + I te
	0x0036d7c8, // n0x1a7a c0x0000 (---------------)  + I ternopil
	0x0021eac2, // n0x1a7b c0x0000 (---------------)  + I uz
	0x00353048, // n0x1a7c c0x0000 (---------------)  + I uzhgorod
	0x002eed87, // n0x1a7d c0x0000 (---------------)  + I vinnica
	0x002ef949, // n0x1a7e c0x0000 (---------------)  + I vinnytsia
	0x0020d142, // n0x1a7f c0x0000 (---------------)  + I vn
	0x002f36c5, // n0x1a80 c0x0000 (---------------)  + I volyn
	0x0036d1c5, // n0x1a81 c0x0000 (---------------)  + I yalta
	0x002cbb4b, // n0x1a82 c0x0000 (---------------)  + I zaporizhzhe
	0x002b738c, // n0x1a83 c0x0000 (---------------)  + I zaporizhzhia
	0x0022eb08, // n0x1a84 c0x0000 (---------------)  + I zhitomir
	0x002f3a88, // n0x1a85 c0x0000 (---------------)  + I zhytomyr
	0x00279542, // n0x1a86 c0x0000 (---------------)  + I zp
	0x0021cf42, // n0x1a87 c0x0000 (---------------)  + I zt
	0x00200b82, // n0x1a88 c0x0000 (---------------)  + I ac
	0x00200882, // n0x1a89 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x1a8a c0x0000 (---------------)  + I com
	0x00209ac2, // n0x1a8b c0x0000 (---------------)  + I go
	0x00209e82, // n0x1a8c c0x0000 (---------------)  + I ne
	0x00200d02, // n0x1a8d c0x0000 (---------------)  + I or
	0x0024d043, // n0x1a8e c0x0000 (---------------)  + I org
	0x0021bcc2, // n0x1a8f c0x0000 (---------------)  + I sc
	0x00200b82, // n0x1a90 c0x0000 (---------------)  + I ac
	0x4ce00882, // n0x1a91 c0x0133 (n0x1a9b-n0x1a9c)  + I co
	0x4d209ac3, // n0x1a92 c0x0134 (n0x1a9c-n0x1a9d)  + I gov
	0x00220e43, // n0x1a93 c0x0000 (---------------)  + I ltd
	0x00204342, // n0x1a94 c0x0000 (---------------)  + I me
	0x00218643, // n0x1a95 c0x0000 (---------------)  + I net
	0x002096c3, // n0x1a96 c0x0000 (---------------)  + I nhs
	0x0024d043, // n0x1a97 c0x0000 (---------------)  + I org
	0x002cb543, // n0x1a98 c0x0000 (---------------)  + I plc
	0x0023dd46, // n0x1a99 c0x0000 (---------------)  + I police
	0x01651983, // n0x1a9a c0x0005 (---------------)* o I sch
	0x0009e448, // n0x1a9b c0x0000 (---------------)  +   blogspot
	0x00090b07, // n0x1a9c c0x0000 (---------------)  +   service
	0x4da019c2, // n0x1a9d c0x0136 (n0x1adc-n0x1adf)  + I ak
	0x4de00b02, // n0x1a9e c0x0137 (n0x1adf-n0x1ae2)  + I al
	0x4e2030c2, // n0x1a9f c0x0138 (n0x1ae2-n0x1ae5)  + I ar
	0x4e600182, // n0x1aa0 c0x0139 (n0x1ae5-n0x1ae8)  + I as
	0x4ea01202, // n0x1aa1 c0x013a (n0x1ae8-n0x1aeb)  + I az
	0x4ee14582, // n0x1aa2 c0x013b (n0x1aeb-n0x1aee)  + I ca
	0x4f200882, // n0x1aa3 c0x013c (n0x1aee-n0x1af1)  + I co
	0x4f62a082, // n0x1aa4 c0x013d (n0x1af1-n0x1af4)  + I ct
	0x4fa003c2, // n0x1aa5 c0x013e (n0x1af4-n0x1af7)  + I dc
	0x4fe07cc2, // n0x1aa6 c0x013f (n0x1af7-n0x1afa)  + I de
	0x002e2103, // n0x1aa7 c0x0000 (---------------)  + I dni
	0x0023ee83, // n0x1aa8 c0x0000 (---------------)  + I fed
	0x5024c602, // n0x1aa9 c0x0140 (n0x1afa-n0x1afd)  + I fl
	0x50600fc2, // n0x1aaa c0x0141 (n0x1afd-n0x1b00)  + I ga
	0x50a02642, // n0x1aab c0x0142 (n0x1b00-n0x1b03)  + I gu
	0x50e00202, // n0x1aac c0x0143 (n0x1b03-n0x1b05)  + I hi
	0x51208bc2, // n0x1aad c0x0144 (n0x1b05-n0x1b08)  + I ia
	0x51605942, // n0x1aae c0x0145 (n0x1b08-n0x1b0b)  + I id
	0x51a00d82, // n0x1aaf c0x0146 (n0x1b0b-n0x1b0e)  + I il
	0x51e00242, // n0x1ab0 c0x0147 (n0x1b0e-n0x1b11)  + I in
	0x000d0905, // n0x1ab1 c0x0000 (---------------)  +   is-by
	0x00213e43, // n0x1ab2 c0x0000 (---------------)  + I isa
	0x0025c784, // n0x1ab3 c0x0000 (---------------)  + I kids
	0x5221f9c2, // n0x1ab4 c0x0148 (n0x1b11-n0x1b14)  + I ks
	0x52611002, // n0x1ab5 c0x0149 (n0x1b14-n0x1b17)  + I ky
	0x52a000c2, // n0x1ab6 c0x014a (n0x1b17-n0x1b1a)  + I la
	0x0007e10b, // n0x1ab7 c0x0000 (---------------)  +   land-4-sale
	0x52e011c2, // n0x1ab8 c0x014b (n0x1b1a-n0x1b1d)  + I ma
	0x5364a3c2, // n0x1ab9 c0x014d (n0x1b20-n0x1b23)  + I md
	0x53a04342, // n0x1aba c0x014e (n0x1b23-n0x1b26)  + I me
	0x53e00f42, // n0x1abb c0x014f (n0x1b26-n0x1b29)  + I mi
	0x5422c7c2, // n0x1abc c0x0150 (n0x1b29-n0x1b2c)  + I mn
	0x54605202, // n0x1abd c0x0151 (n0x1b2c-n0x1b2f)  + I mo
	0x54a0e602, // n0x1abe c0x0152 (n0x1b2f-n0x1b32)  + I ms
	0x54e66782, // n0x1abf c0x0153 (n0x1b32-n0x1b35)  + I mt
	0x5520a682, // n0x1ac0 c0x0154 (n0x1b35-n0x1b38)  + I nc
	0x55600382, // n0x1ac1 c0x0155 (n0x1b38-n0x1b3a)  + I nd
	0x55a09e82, // n0x1ac2 c0x0156 (n0x1b3a-n0x1b3d)  + I ne
	0x55e096c2, // n0x1ac3 c0x0157 (n0x1b3d-n0x1b40)  + I nh
	0x56202dc2, // n0x1ac4 c0x0158 (n0x1b40-n0x1b43)  + I nj
	0x56626d42, // n0x1ac5 c0x0159 (n0x1b43-n0x1b46)  + I nm
	0x0036ef43, // n0x1ac6 c0x0000 (---------------)  + I nsn
	0x56a15642, // n0x1ac7 c0x015a (n0x1b46-n0x1b49)  + I nv
	0x56e1af42, // n0x1ac8 c0x015b (n0x1b49-n0x1b4c)  + I ny
	0x57203dc2, // n0x1ac9 c0x015c (n0x1b4c-n0x1b4f)  + I oh
	0x5760d582, // n0x1aca c0x015d (n0x1b4f-n0x1b52)  + I ok
	0x57a00d02, // n0x1acb c0x015e (n0x1b52-n0x1b55)  + I or
	0x57e00ac2, // n0x1acc c0x015f (n0x1b55-n0x1b58)  + I pa
	0x5822ad42, // n0x1acd c0x0160 (n0x1b58-n0x1b5b)  + I pr
	0x58600d42, // n0x1ace c0x0161 (n0x1b5b-n0x1b5e)  + I ri
	0x58a1bcc2, // n0x1acf c0x0162 (n0x1b5e-n0x1b61)  + I sc
	0x58e0acc2, // n0x1ad0 c0x0163 (n0x1b61-n0x1b63)  + I sd
	0x000dd7cc, // n0x1ad1 c0x0000 (---------------)  +   stuff-4-sale
	0x59201942, // n0x1ad2 c0x0164 (n0x1b63-n0x1b66)  + I tn
	0x59655c42, // n0x1ad3 c0x0165 (n0x1b66-n0x1b69)  + I tx
	0x59a02fc2, // n0x1ad4 c0x0166 (n0x1b69-n0x1b6c)  + I ut
	0x59e03242, // n0x1ad5 c0x0167 (n0x1b6c-n0x1b6f)  + I va
	0x5a201642, // n0x1ad6 c0x0168 (n0x1b6f-n0x1b72)  + I vi
	0x5a6170c2, // n0x1ad7 c0x0169 (n0x1b72-n0x1b75)  + I vt
	0x5aa00142, // n0x1ad8 c0x016a (n0x1b75-n0x1b78)  + I wa
	0x5ae07a82, // n0x1ad9 c0x016b (n0x1b78-n0x1b7b)  + I wi
	0x5b26e042, // n0x1ada c0x016c (n0x1b7b-n0x1b7c)  + I wv
	0x5b61f8c2, // n0x1adb c0x016d (n0x1b7c-n0x1b7f)  + I wy
	0x002020c2, // n0x1adc c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1add c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1ade c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1adf c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1ae0 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1ae1 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1ae2 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1ae3 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1ae4 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1ae5 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1ae6 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1ae7 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1ae8 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1ae9 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1aea c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1aeb c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1aec c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1aed c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1aee c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1aef c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1af0 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1af1 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1af2 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1af3 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1af4 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1af5 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1af6 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1af7 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1af8 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1af9 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1afa c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1afb c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1afc c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1afd c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1afe c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1aff c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b00 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b01 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b02 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b03 c0x0000 (---------------)  + I cc
	0x0027a703, // n0x1b04 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b05 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b06 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b07 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b08 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b09 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b0a c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b0b c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b0c c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b0d c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b0e c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b0f c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b10 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b11 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b12 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b13 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b14 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b15 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b16 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b17 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b18 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b19 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b1a c0x0000 (---------------)  + I cc
	0x5336e803, // n0x1b1b c0x014c (n0x1b1d-n0x1b20)  + I k12
	0x0027a703, // n0x1b1c c0x0000 (---------------)  + I lib
	0x002f5bc4, // n0x1b1d c0x0000 (---------------)  + I chtr
	0x0037e546, // n0x1b1e c0x0000 (---------------)  + I paroch
	0x002d35c3, // n0x1b1f c0x0000 (---------------)  + I pvt
	0x002020c2, // n0x1b20 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b21 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b22 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b23 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b24 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b25 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b26 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b27 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b28 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b29 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b2a c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b2b c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b2c c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b2d c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b2e c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b2f c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b30 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b31 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b32 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b33 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b34 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b35 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b36 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b37 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b38 c0x0000 (---------------)  + I cc
	0x0027a703, // n0x1b39 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b3a c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b3b c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b3c c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b3d c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b3e c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b3f c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b40 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b41 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b42 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b43 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b44 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b45 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b46 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b47 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b48 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b49 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b4a c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b4b c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b4c c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b4d c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b4e c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b4f c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b50 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b51 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b52 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b53 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b54 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b55 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b56 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b57 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b58 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b59 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b5a c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b5b c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b5c c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b5d c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b5e c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b5f c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b60 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b61 c0x0000 (---------------)  + I cc
	0x0027a703, // n0x1b62 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b63 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b64 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b65 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b66 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b67 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b68 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b69 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b6a c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b6b c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b6c c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b6d c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b6e c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b6f c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b70 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b71 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b72 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b73 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b74 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b75 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b76 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b77 c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b78 c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b79 c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b7a c0x0000 (---------------)  + I lib
	0x002020c2, // n0x1b7b c0x0000 (---------------)  + I cc
	0x002020c2, // n0x1b7c c0x0000 (---------------)  + I cc
	0x0036e803, // n0x1b7d c0x0000 (---------------)  + I k12
	0x0027a703, // n0x1b7e c0x0000 (---------------)  + I lib
	0x00232dc3, // n0x1b7f c0x0000 (---------------)  + I com
	0x0021e083, // n0x1b80 c0x0000 (---------------)  + I edu
	0x00345fc3, // n0x1b81 c0x0000 (---------------)  + I gub
	0x00240443, // n0x1b82 c0x0000 (---------------)  + I mil
	0x00218643, // n0x1b83 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1b84 c0x0000 (---------------)  + I org
	0x00200882, // n0x1b85 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x1b86 c0x0000 (---------------)  + I com
	0x00218643, // n0x1b87 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1b88 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x1b89 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1b8a c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1b8b c0x0000 (---------------)  + I gov
	0x00240443, // n0x1b8c c0x0000 (---------------)  + I mil
	0x00218643, // n0x1b8d c0x0000 (---------------)  + I net
	0x0024d043, // n0x1b8e c0x0000 (---------------)  + I org
	0x0020b384, // n0x1b8f c0x0000 (---------------)  + I arts
	0x00200882, // n0x1b90 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x1b91 c0x0000 (---------------)  + I com
	0x002db583, // n0x1b92 c0x0000 (---------------)  + I e12
	0x0021e083, // n0x1b93 c0x0000 (---------------)  + I edu
	0x0024a304, // n0x1b94 c0x0000 (---------------)  + I firm
	0x003704c3, // n0x1b95 c0x0000 (---------------)  + I gob
	0x00209ac3, // n0x1b96 c0x0000 (---------------)  + I gov
	0x00208a44, // n0x1b97 c0x0000 (---------------)  + I info
	0x002188c3, // n0x1b98 c0x0000 (---------------)  + I int
	0x00240443, // n0x1b99 c0x0000 (---------------)  + I mil
	0x00218643, // n0x1b9a c0x0000 (---------------)  + I net
	0x0024d043, // n0x1b9b c0x0000 (---------------)  + I org
	0x0022a143, // n0x1b9c c0x0000 (---------------)  + I rec
	0x002dc745, // n0x1b9d c0x0000 (---------------)  + I store
	0x0022a003, // n0x1b9e c0x0000 (---------------)  + I tec
	0x002071c3, // n0x1b9f c0x0000 (---------------)  + I web
	0x00200882, // n0x1ba0 c0x0000 (---------------)  + I co
	0x00232dc3, // n0x1ba1 c0x0000 (---------------)  + I com
	0x0036e803, // n0x1ba2 c0x0000 (---------------)  + I k12
	0x00218643, // n0x1ba3 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1ba4 c0x0000 (---------------)  + I org
	0x00200b82, // n0x1ba5 c0x0000 (---------------)  + I ac
	0x00202183, // n0x1ba6 c0x0000 (---------------)  + I biz
	0x00232dc3, // n0x1ba7 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1ba8 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1ba9 c0x0000 (---------------)  + I gov
	0x00241cc6, // n0x1baa c0x0000 (---------------)  + I health
	0x00208a44, // n0x1bab c0x0000 (---------------)  + I info
	0x002188c3, // n0x1bac c0x0000 (---------------)  + I int
	0x00267944, // n0x1bad c0x0000 (---------------)  + I name
	0x00218643, // n0x1bae c0x0000 (---------------)  + I net
	0x0024d043, // n0x1baf c0x0000 (---------------)  + I org
	0x002cfc43, // n0x1bb0 c0x0000 (---------------)  + I pro
	0x00232dc3, // n0x1bb1 c0x0000 (---------------)  + I com
	0x0021e083, // n0x1bb2 c0x0000 (---------------)  + I edu
	0x00218643, // n0x1bb3 c0x0000 (---------------)  + I net
	0x0024d043, // n0x1bb4 c0x0000 (---------------)  + I org
	0x00232dc3, // n0x1bb5 c0x0000 (---------------)  + I com
	0x0000dc06, // n0x1bb6 c0x0000 (---------------)  +   dyndns
	0x0021e083, // n0x1bb7 c0x0000 (---------------)  + I edu
	0x00209ac3, // n0x1bb8 c0x0000 (---------------)  + I gov
	0x000f3306, // n0x1bb9 c0x0000 (---------------)  +   mypets
	0x00218643, // n0x1bba c0x0000 (---------------)  + I net
	0x0024d043, // n0x1bbb c0x0000 (---------------)  + I org
	0x002fd588, // n0x1bbc c0x0000 (---------------)  + I xn--80au
	0x002ffbc9, // n0x1bbd c0x0000 (---------------)  + I xn--90azh
	0x0030d409, // n0x1bbe c0x0000 (---------------)  + I xn--c1avg
	0x00313188, // n0x1bbf c0x0000 (---------------)  + I xn--d1at
	0x0034bfc8, // n0x1bc0 c0x0000 (---------------)  + I xn--o1ac
	0x0034bfc9, // n0x1bc1 c0x0000 (---------------)  + I xn--o1ach
}

// children is the list of nodes' children, the parent's wildcard bit and the
// parent's node type. If a node has no children then their children index
// will be in the range [0, 6), depending on the wildcard bit and node type.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 1 bits] wildcard bit
//	[ 2 bits] node type
//	[14 bits] high nodes index (exclusive) of children
//	[14 bits] low nodes index (inclusive) of children
var children = [...]uint32{
	0x00000000, // c0x0000 (---------------)  +
	0x10000000, // c0x0001 (---------------)  !
	0x20000000, // c0x0002 (---------------)  o
	0x40000000, // c0x0003 (---------------)* +
	0x50000000, // c0x0004 (---------------)* !
	0x60000000, // c0x0005 (---------------)* o
	0x0105440f, // c0x0006 (n0x040f-n0x0415)  +
	0x01058415, // c0x0007 (n0x0415-n0x0416)  +
	0x01078416, // c0x0008 (n0x0416-n0x041e)  +
	0x011dc41e, // c0x0009 (n0x041e-n0x0477)  +
	0x011f0477, // c0x000a (n0x0477-n0x047c)  +
	0x0120447c, // c0x000b (n0x047c-n0x0481)  +
	0x01214481, // c0x000c (n0x0481-n0x0485)  +
	0x0122c485, // c0x000d (n0x0485-n0x048b)  +
	0x0123c48b, // c0x000e (n0x048b-n0x048f)  +
	0x0125448f, // c0x000f (n0x048f-n0x0495)  +
	0x01278495, // c0x0010 (n0x0495-n0x049e)  +
	0x0127c49e, // c0x0011 (n0x049e-n0x049f)  +
	0x0129449f, // c0x0012 (n0x049f-n0x04a5)  +
	0x012984a5, // c0x0013 (n0x04a5-n0x04a6)  +
	0x012b44a6, // c0x0014 (n0x04a6-n0x04ad)  +
	0x012b84ad, // c0x0015 (n0x04ad-n0x04ae)  +
	0x013004ae, // c0x0016 (n0x04ae-n0x04c0)  +
	0x013044c0, // c0x0017 (n0x04c0-n0x04c1)  +
	0x013244c1, // c0x0018 (n0x04c1-n0x04c9)  +
	0x013384c9, // c0x0019 (n0x04c9-n0x04ce)  +
	0x0133c4ce, // c0x001a (n0x04ce-n0x04cf)  +
	0x0136c4cf, // c0x001b (n0x04cf-n0x04db)  +
	0x013944db, // c0x001c (n0x04db-n0x04e5)  +
	0x013bc4e5, // c0x001d (n0x04e5-n0x04ef)  +
	0x013c44ef, // c0x001e (n0x04ef-n0x04f1)  +
	0x013c84f1, // c0x001f (n0x04f1-n0x04f2)  +
	0x014584f2, // c0x0020 (n0x04f2-n0x0516)  +
	0x0146c516, // c0x0021 (n0x0516-n0x051b)  +
	0x0148051b, // c0x0022 (n0x051b-n0x0520)  +
	0x0149c520, // c0x0023 (n0x0520-n0x0527)  +
	0x014ac527, // c0x0024 (n0x0527-n0x052b)  +
	0x014c052b, // c0x0025 (n0x052b-n0x0530)  +
	0x014e4530, // c0x0026 (n0x0530-n0x0539)  +
	0x015fc539, // c0x0027 (n0x0539-n0x057f)  +
	0x0160057f, // c0x0028 (n0x057f-n0x0580)  +
	0x01614580, // c0x0029 (n0x0580-n0x0585)  +
	0x01628585, // c0x002a (n0x0585-n0x058a)  +
	0x0163058a, // c0x002b (n0x058a-n0x058c)  +
	0x0164058c, // c0x002c (n0x058c-n0x0590)  +
	0x01658590, // c0x002d (n0x0590-n0x0596)  +
	0x0169c596, // c0x002e (n0x0596-n0x05a7)  +
	0x016ac5a7, // c0x002f (n0x05a7-n0x05ab)  +
	0x016b05ab, // c0x0030 (n0x05ab-n0x05ac)  +
	0x016b45ac, // c0x0031 (n0x05ac-n0x05ad)  +
	0x016b85ad, // c0x0032 (n0x05ad-n0x05ae)  +
	0x016f45ae, // c0x0033 (n0x05ae-n0x05bd)  +
	0x616f85bd, // c0x0034 (n0x05bd-n0x05be)* o
	0x017085be, // c0x0035 (n0x05be-n0x05c2)  +
	0x017185c2, // c0x0036 (n0x05c2-n0x05c6)  +
	0x017cc5c6, // c0x0037 (n0x05c6-n0x05f3)  +
	0x217d05f3, // c0x0038 (n0x05f3-n0x05f4)  o
	0x017d45f4, // c0x0039 (n0x05f4-n0x05f5)  +
	0x018085f5, // c0x003a (n0x05f5-n0x0602)  +
	0x01b1c602, // c0x003b (n0x0602-n0x06c7)  +
	0x21b786c7, // c0x003c (n0x06c7-n0x06de)  o
	0x01b9c6de, // c0x003d (n0x06de-n0x06e7)  +
	0x01ba46e7, // c0x003e (n0x06e7-n0x06e9)  +
	0x01bc06e9, // c0x003f (n0x06e9-n0x06f0)  +
	0x01bd86f0, // c0x0040 (n0x06f0-n0x06f6)  +
	0x01bdc6f6, // c0x0041 (n0x06f6-n0x06f7)  +
	0x01bec6f7, // c0x0042 (n0x06f7-n0x06fb)  +
	0x01bf46fb, // c0x0043 (n0x06fb-n0x06fd)  +
	0x01bf86fd, // c0x0044 (n0x06fd-n0x06fe)  +
	0x01c186fe, // c0x0045 (n0x06fe-n0x0706)  +
	0x01c1c706, // c0x0046 (n0x0706-n0x0707)  +
	0x01c30707, // c0x0047 (n0x0707-n0x070c)  +
	0x01c5870c, // c0x0048 (n0x070c-n0x0716)  +
	0x01c78716, // c0x0049 (n0x0716-n0x071e)  +
	0x01ca871e, // c0x004a (n0x071e-n0x072a)  +
	0x01cd072a, // c0x004b (n0x072a-n0x0734)  +
	0x01cf4734, // c0x004c (n0x0734-n0x073d)  +
	0x01d0873d, // c0x004d (n0x073d-n0x0742)  +
	0x01d0c742, // c0x004e (n0x0742-n0x0743)  +
	0x01d28743, // c0x004f (n0x0743-n0x074a)  +
	0x01d3474a, // c0x0050 (n0x074a-n0x074d)  +
	0x01d9474d, // c0x0051 (n0x074d-n0x0765)  +
	0x01db0765, // c0x0052 (n0x0765-n0x076c)  +
	0x01dbc76c, // c0x0053 (n0x076c-n0x076f)  +
	0x01dd076f, // c0x0054 (n0x076f-n0x0774)  +
	0x01de8774, // c0x0055 (n0x0774-n0x077a)  +
	0x01e0077a, // c0x0056 (n0x077a-n0x0780)  +
	0x01e18780, // c0x0057 (n0x0780-n0x0786)  +
	0x01e30786, // c0x0058 (n0x0786-n0x078c)  +
	0x01e4c78c, // c0x0059 (n0x078c-n0x0793)  +
	0x01e58793, // c0x005a (n0x0793-n0x0796)  +
	0x01eb8796, // c0x005b (n0x0796-n0x07ae)  +
	0x01ed07ae, // c0x005c (n0x07ae-n0x07b4)  +
	0x01ee07b4, // c0x005d (n0x07b4-n0x07b8)  +
	0x01f247b8, // c0x005e (n0x07b8-n0x07c9)  +
	0x01fa47c9, // c0x005f (n0x07c9-n0x07e9)  +
	0x01fd07e9, // c0x0060 (n0x07e9-n0x07f4)  +
	0x01fd87f4, // c0x0061 (n0x07f4-n0x07f6)  +
	0x61fdc7f6, // c0x0062 (n0x07f6-n0x07f7)* o
	0x21fe07f7, // c0x0063 (n0x07f7-n0x07f8)  o
	0x01ffc7f8, // c0x0064 (n0x07f8-n0x07ff)  +
	0x020047ff, // c0x0065 (n0x07ff-n0x0801)  +
	0x02038801, // c0x0066 (n0x0801-n0x080e)  +
	0x0206080e, // c0x0067 (n0x080e-n0x0818)  +
	0x02064818, // c0x0068 (n0x0818-n0x0819)  +
	0x02070819, // c0x0069 (n0x0819-n0x081c)  +
	0x0208881c, // c0x006a (n0x081c-n0x0822)  +
	0x020ac822, // c0x006b (n0x0822-n0x082b)  +
	0x020c882b, // c0x006c (n0x082b-n0x0832)  +
	0x0268c832, // c0x006d (n0x0832-n0x09a3)  +
	0x026989a3, // c0x006e (n0x09a3-n0x09a6)  +
	0x026b89a6, // c0x006f (n0x09a6-n0x09ae)  +
	0x028749ae, // c0x0070 (n0x09ae-n0x0a1d)  +
	0x02944a1d, // c0x0071 (n0x0a1d-n0x0a51)  +
	0x029b4a51, // c0x0072 (n0x0a51-n0x0a6d)  +
	0x02a0ca6d, // c0x0073 (n0x0a6d-n0x0a83)  +
	0x02af4a83, // c0x0074 (n0x0a83-n0x0abd)  +
	0x02b4cabd, // c0x0075 (n0x0abd-n0x0ad3)  +
	0x02b88ad3, // c0x0076 (n0x0ad3-n0x0ae2)  +
	0x02c84ae2, // c0x0077 (n0x0ae2-n0x0b21)  +
	0x02d50b21, // c0x0078 (n0x0b21-n0x0b54)  +
	0x02de8b54, // c0x0079 (n0x0b54-n0x0b7a)  +
	0x02e78b7a, // c0x007a (n0x0b7a-n0x0b9e)  +
	0x02edcb9e, // c0x007b (n0x0b9e-n0x0bb7)  +
	0x03114bb7, // c0x007c (n0x0bb7-n0x0c45)  +
	0x031ccc45, // c0x007d (n0x0c45-n0x0c73)  +
	0x03298c73, // c0x007e (n0x0c73-n0x0ca6)  +
	0x032e4ca6, // c0x007f (n0x0ca6-n0x0cb9)  +
	0x0336ccb9, // c0x0080 (n0x0cb9-n0x0cdb)  +
	0x033a8cdb, // c0x0081 (n0x0cdb-n0x0cea)  +
	0x033f8cea, // c0x0082 (n0x0cea-n0x0cfe)  +
	0x03470cfe, // c0x0083 (n0x0cfe-n0x0d1c)  +
	0x63474d1c, // c0x0084 (n0x0d1c-n0x0d1d)* o
	0x63478d1d, // c0x0085 (n0x0d1d-n0x0d1e)* o
	0x6347cd1e, // c0x0086 (n0x0d1e-n0x0d1f)* o
	0x034f8d1f, // c0x0087 (n0x0d1f-n0x0d3e)  +
	0x03560d3e, // c0x0088 (n0x0d3e-n0x0d58)  +
	0x035dcd58, // c0x0089 (n0x0d58-n0x0d77)  +
	0x03654d77, // c0x008a (n0x0d77-n0x0d95)  +
	0x036d8d95, // c0x008b (n0x0d95-n0x0db6)  +
	0x03744db6, // c0x008c (n0x0db6-n0x0dd1)  +
	0x03870dd1, // c0x008d (n0x0dd1-n0x0e1c)  +
	0x038c8e1c, // c0x008e (n0x0e1c-n0x0e32)  +
	0x638cce32, // c0x008f (n0x0e32-n0x0e33)* o
	0x03964e33, // c0x0090 (n0x0e33-n0x0e59)  +
	0x039ece59, // c0x0091 (n0x0e59-n0x0e7b)  +
	0x03a38e7b, // c0x0092 (n0x0e7b-n0x0e8e)  +
	0x03aa0e8e, // c0x0093 (n0x0e8e-n0x0ea8)  +
	0x03b48ea8, // c0x0094 (n0x0ea8-n0x0ed2)  +
	0x03c10ed2, // c0x0095 (n0x0ed2-n0x0f04)  +
	0x03c78f04, // c0x0096 (n0x0f04-n0x0f1e)  +
	0x03d8cf1e, // c0x0097 (n0x0f1e-n0x0f63)  +
	0x63d90f63, // c0x0098 (n0x0f63-n0x0f64)* o
	0x63d94f64, // c0x0099 (n0x0f64-n0x0f65)* o
	0x03df0f65, // c0x009a (n0x0f65-n0x0f7c)  +
	0x03e4cf7c, // c0x009b (n0x0f7c-n0x0f93)  +
	0x03edcf93, // c0x009c (n0x0f93-n0x0fb7)  +
	0x03f58fb7, // c0x009d (n0x0fb7-n0x0fd6)  +
	0x03f9cfd6, // c0x009e (n0x0fd6-n0x0fe7)  +
	0x04080fe7, // c0x009f (n0x0fe7-n0x1020)  +
	0x040b5020, // c0x00a0 (n0x1020-n0x102d)  +
	0x0411502d, // c0x00a1 (n0x102d-n0x1045)  +
	0x04189045, // c0x00a2 (n0x1045-n0x1062)  +
	0x04211062, // c0x00a3 (n0x1062-n0x1084)  +
	0x04251084, // c0x00a4 (n0x1084-n0x1094)  +
	0x042c1094, // c0x00a5 (n0x1094-n0x10b0)  +
	0x642c50b0, // c0x00a6 (n0x10b0-n0x10b1)* o
	0x042dd0b1, // c0x00a7 (n0x10b1-n0x10b7)  +
	0x042f90b7, // c0x00a8 (n0x10b7-n0x10be)  +
	0x0433d0be, // c0x00a9 (n0x10be-n0x10cf)  +
	0x0434d0cf, // c0x00aa (n0x10cf-n0x10d3)  +
	0x043650d3, // c0x00ab (n0x10d3-n0x10d9)  +
	0x043dd0d9, // c0x00ac (n0x10d9-n0x10f7)  +
	0x043f10f7, // c0x00ad (n0x10f7-n0x10fc)  +
	0x044090fc, // c0x00ae (n0x10fc-n0x1102)  +
	0x0442d102, // c0x00af (n0x1102-n0x110b)  +
	0x0444110b, // c0x00b0 (n0x110b-n0x1110)  +
	0x04459110, // c0x00b1 (n0x1110-n0x1116)  +
	0x04491116, // c0x00b2 (n0x1116-n0x1124)  +
	0x044a5124, // c0x00b3 (n0x1124-n0x1129)  +
	0x044ad129, // c0x00b4 (n0x1129-n0x112b)  +
	0x044b112b, // c0x00b5 (n0x112b-n0x112c)  +
	0x044d512c, // c0x00b6 (n0x112c-n0x1135)  +
	0x044f9135, // c0x00b7 (n0x1135-n0x113e)  +
	0x0451113e, // c0x00b8 (n0x113e-n0x1144)  +
	0x04519144, // c0x00b9 (n0x1144-n0x1146)  +
	0x04539146, // c0x00ba (n0x1146-n0x114e)  +
	0x0455914e, // c0x00bb (n0x114e-n0x1156)  +
	0x04575156, // c0x00bc (n0x1156-n0x115d)  +
	0x0459115d, // c0x00bd (n0x115d-n0x1164)  +
	0x045a1164, // c0x00be (n0x1164-n0x1168)  +
	0x045b5168, // c0x00bf (n0x1168-n0x116d)  +
	0x045bd16d, // c0x00c0 (n0x116d-n0x116f)  +
	0x045d116f, // c0x00c1 (n0x116f-n0x1174)  +
	0x045e1174, // c0x00c2 (n0x1174-n0x1178)  +
	0x045fd178, // c0x00c3 (n0x1178-n0x117f)  +
	0x04e8d17f, // c0x00c4 (n0x117f-n0x13a3)  +
	0x04ec53a3, // c0x00c5 (n0x13a3-n0x13b1)  +
	0x04ef13b1, // c0x00c6 (n0x13b1-n0x13bc)  +
	0x04f093bc, // c0x00c7 (n0x13bc-n0x13c2)  +
	0x04f253c2, // c0x00c8 (n0x13c2-n0x13c9)  +
	0x64f293c9, // c0x00c9 (n0x13c9-n0x13ca)* o
	0x04f6d3ca, // c0x00ca (n0x13ca-n0x13db)  +
	0x04f753db, // c0x00cb (n0x13db-n0x13dd)  +
	0x24f793dd, // c0x00cc (n0x13dd-n0x13de)  o
	0x24f7d3de, // c0x00cd (n0x13de-n0x13df)  o
	0x04f813df, // c0x00ce (n0x13df-n0x13e0)  +
	0x0503d3e0, // c0x00cf (n0x13e0-n0x140f)  +
	0x2504540f, // c0x00d0 (n0x140f-n0x1411)  o
	0x2504d411, // c0x00d1 (n0x1411-n0x1413)  o
	0x25059413, // c0x00d2 (n0x1413-n0x1416)  o
	0x05081416, // c0x00d3 (n0x1416-n0x1420)  +
	0x050a5420, // c0x00d4 (n0x1420-n0x1429)  +
	0x050b1429, // c0x00d5 (n0x1429-n0x142c)  +
	0x05c0942c, // c0x00d6 (n0x142c-n0x1702)  +
	0x05c0d702, // c0x00d7 (n0x1702-n0x1703)  +
	0x05c11703, // c0x00d8 (n0x1703-n0x1704)  +
	0x25c15704, // c0x00d9 (n0x1704-n0x1705)  o
	0x05c19705, // c0x00da (n0x1705-n0x1706)  +
	0x25c1d706, // c0x00db (n0x1706-n0x1707)  o
	0x05c21707, // c0x00dc (n0x1707-n0x1708)  +
	0x25c2d708, // c0x00dd (n0x1708-n0x170b)  o
	0x05c3170b, // c0x00de (n0x170b-n0x170c)  +
	0x05c3570c, // c0x00df (n0x170c-n0x170d)  +
	0x25c3970d, // c0x00e0 (n0x170d-n0x170e)  o
	0x05c3d70e, // c0x00e1 (n0x170e-n0x170f)  +
	0x25c4570f, // c0x00e2 (n0x170f-n0x1711)  o
	0x05c49711, // c0x00e3 (n0x1711-n0x1712)  +
	0x05c4d712, // c0x00e4 (n0x1712-n0x1713)  +
	0x25c5d713, // c0x00e5 (n0x1713-n0x1717)  o
	0x05c61717, // c0x00e6 (n0x1717-n0x1718)  +
	0x05c65718, // c0x00e7 (n0x1718-n0x1719)  +
	0x05c69719, // c0x00e8 (n0x1719-n0x171a)  +
	0x05c6d71a, // c0x00e9 (n0x171a-n0x171b)  +
	0x25c7171b, // c0x00ea (n0x171b-n0x171c)  o
	0x05c7571c, // c0x00eb (n0x171c-n0x171d)  +
	0x05c7971d, // c0x00ec (n0x171d-n0x171e)  +
	0x05c7d71e, // c0x00ed (n0x171e-n0x171f)  +
	0x05c8171f, // c0x00ee (n0x171f-n0x1720)  +
	0x25c89720, // c0x00ef (n0x1720-n0x1722)  o
	0x05c8d722, // c0x00f0 (n0x1722-n0x1723)  +
	0x05c91723, // c0x00f1 (n0x1723-n0x1724)  +
	0x05c95724, // c0x00f2 (n0x1724-n0x1725)  +
	0x25c99725, // c0x00f3 (n0x1725-n0x1726)  o
	0x05c9d726, // c0x00f4 (n0x1726-n0x1727)  +
	0x25ca5727, // c0x00f5 (n0x1727-n0x1729)  o
	0x25ca9729, // c0x00f6 (n0x1729-n0x172a)  o
	0x05cc572a, // c0x00f7 (n0x172a-n0x1731)  +
	0x05cd1731, // c0x00f8 (n0x1731-n0x1734)  +
	0x05d11734, // c0x00f9 (n0x1734-n0x1744)  +
	0x05d15744, // c0x00fa (n0x1744-n0x1745)  +
	0x05d39745, // c0x00fb (n0x1745-n0x174e)  +
	0x05e1174e, // c0x00fc (n0x174e-n0x1784)  +
	0x05e19784, // c0x00fd (n0x1784-n0x1786)  +
	0x05e45786, // c0x00fe (n0x1786-n0x1791)  +
	0x05e61791, // c0x00ff (n0x1791-n0x1798)  +
	0x05e6d798, // c0x0100 (n0x1798-n0x179b)  +
	0x05e8d79b, // c0x0101 (n0x179b-n0x17a3)  +
	0x05ec57a3, // c0x0102 (n0x17a3-n0x17b1)  +
	0x061597b1, // c0x0103 (n0x17b1-n0x1856)  +
	0x0617d856, // c0x0104 (n0x1856-n0x185f)  +
	0x0619185f, // c0x0105 (n0x185f-n0x1864)  +
	0x061c5864, // c0x0106 (n0x1864-n0x1871)  +
	0x061e1871, // c0x0107 (n0x1871-n0x1878)  +
	0x061fd878, // c0x0108 (n0x1878-n0x187f)  +
	0x0622187f, // c0x0109 (n0x187f-n0x1888)  +
	0x06239888, // c0x010a (n0x1888-n0x188e)  +
	0x0625588e, // c0x010b (n0x188e-n0x1895)  +
	0x06275895, // c0x010c (n0x1895-n0x189d)  +
	0x0628589d, // c0x010d (n0x189d-n0x18a1)  +
	0x062b58a1, // c0x010e (n0x18a1-n0x18ad)  +
	0x062cd8ad, // c0x010f (n0x18ad-n0x18b3)  +
	0x064dd8b3, // c0x0110 (n0x18b3-n0x1937)  +
	0x06501937, // c0x0111 (n0x1937-n0x1940)  +
	0x06521940, // c0x0112 (n0x1940-n0x1948)  +
	0x06535948, // c0x0113 (n0x1948-n0x194d)  +
	0x0654994d, // c0x0114 (n0x194d-n0x1952)  +
	0x06569952, // c0x0115 (n0x1952-n0x195a)  +
	0x0660d95a, // c0x0116 (n0x195a-n0x1983)  +
	0x06629983, // c0x0117 (n0x1983-n0x198a)  +
	0x0663d98a, // c0x0118 (n0x198a-n0x198f)  +
	0x0664198f, // c0x0119 (n0x198f-n0x1990)  +
	0x06655990, // c0x011a (n0x1990-n0x1995)  +
	0x06671995, // c0x011b (n0x1995-n0x199c)  +
	0x0667d99c, // c0x011c (n0x199c-n0x199f)  +
	0x066ad99f, // c0x011d (n0x199f-n0x19ab)  +
	0x066c19ab, // c0x011e (n0x19ab-n0x19b0)  +
	0x066c59b0, // c0x011f (n0x19b0-n0x19b1)  +
	0x066dd9b1, // c0x0120 (n0x19b1-n0x19b7)  +
	0x066e99b7, // c0x0121 (n0x19b7-n0x19ba)  +
	0x066ed9ba, // c0x0122 (n0x19ba-n0x19bb)  +
	0x067099bb, // c0x0123 (n0x19bb-n0x19c2)  +
	0x067459c2, // c0x0124 (n0x19c2-n0x19d1)  +
	0x067499d1, // c0x0125 (n0x19d1-n0x19d2)  +
	0x067699d2, // c0x0126 (n0x19d2-n0x19da)  +
	0x067b99da, // c0x0127 (n0x19da-n0x19ee)  +
	0x067d19ee, // c0x0128 (n0x19ee-n0x19f4)  +
	0x068259f4, // c0x0129 (n0x19f4-n0x1a09)  +
	0x06829a09, // c0x012a (n0x1a09-n0x1a0a)  +
	0x0682da0a, // c0x012b (n0x1a0a-n0x1a0b)  +
	0x06871a0b, // c0x012c (n0x1a0b-n0x1a1c)  +
	0x06881a1c, // c0x012d (n0x1a1c-n0x1a20)  +
	0x068b9a20, // c0x012e (n0x1a20-n0x1a2e)  +
	0x068e9a2e, // c0x012f (n0x1a2e-n0x1a3a)  +
	0x06a21a3a, // c0x0130 (n0x1a3a-n0x1a88)  +
	0x06a41a88, // c0x0131 (n0x1a88-n0x1a90)  +
	0x06a6da90, // c0x0132 (n0x1a90-n0x1a9b)  +
	0x06a71a9b, // c0x0133 (n0x1a9b-n0x1a9c)  +
	0x06a75a9c, // c0x0134 (n0x1a9c-n0x1a9d)  +
	0x06b71a9d, // c0x0135 (n0x1a9d-n0x1adc)  +
	0x06b7dadc, // c0x0136 (n0x1adc-n0x1adf)  +
	0x06b89adf, // c0x0137 (n0x1adf-n0x1ae2)  +
	0x06b95ae2, // c0x0138 (n0x1ae2-n0x1ae5)  +
	0x06ba1ae5, // c0x0139 (n0x1ae5-n0x1ae8)  +
	0x06badae8, // c0x013a (n0x1ae8-n0x1aeb)  +
	0x06bb9aeb, // c0x013b (n0x1aeb-n0x1aee)  +
	0x06bc5aee, // c0x013c (n0x1aee-n0x1af1)  +
	0x06bd1af1, // c0x013d (n0x1af1-n0x1af4)  +
	0x06bddaf4, // c0x013e (n0x1af4-n0x1af7)  +
	0x06be9af7, // c0x013f (n0x1af7-n0x1afa)  +
	0x06bf5afa, // c0x0140 (n0x1afa-n0x1afd)  +
	0x06c01afd, // c0x0141 (n0x1afd-n0x1b00)  +
	0x06c0db00, // c0x0142 (n0x1b00-n0x1b03)  +
	0x06c15b03, // c0x0143 (n0x1b03-n0x1b05)  +
	0x06c21b05, // c0x0144 (n0x1b05-n0x1b08)  +
	0x06c2db08, // c0x0145 (n0x1b08-n0x1b0b)  +
	0x06c39b0b, // c0x0146 (n0x1b0b-n0x1b0e)  +
	0x06c45b0e, // c0x0147 (n0x1b0e-n0x1b11)  +
	0x06c51b11, // c0x0148 (n0x1b11-n0x1b14)  +
	0x06c5db14, // c0x0149 (n0x1b14-n0x1b17)  +
	0x06c69b17, // c0x014a (n0x1b17-n0x1b1a)  +
	0x06c75b1a, // c0x014b (n0x1b1a-n0x1b1d)  +
	0x06c81b1d, // c0x014c (n0x1b1d-n0x1b20)  +
	0x06c8db20, // c0x014d (n0x1b20-n0x1b23)  +
	0x06c99b23, // c0x014e (n0x1b23-n0x1b26)  +
	0x06ca5b26, // c0x014f (n0x1b26-n0x1b29)  +
	0x06cb1b29, // c0x0150 (n0x1b29-n0x1b2c)  +
	0x06cbdb2c, // c0x0151 (n0x1b2c-n0x1b2f)  +
	0x06cc9b2f, // c0x0152 (n0x1b2f-n0x1b32)  +
	0x06cd5b32, // c0x0153 (n0x1b32-n0x1b35)  +
	0x06ce1b35, // c0x0154 (n0x1b35-n0x1b38)  +
	0x06ce9b38, // c0x0155 (n0x1b38-n0x1b3a)  +
	0x06cf5b3a, // c0x0156 (n0x1b3a-n0x1b3d)  +
	0x06d01b3d, // c0x0157 (n0x1b3d-n0x1b40)  +
	0x06d0db40, // c0x0158 (n0x1b40-n0x1b43)  +
	0x06d19b43, // c0x0159 (n0x1b43-n0x1b46)  +
	0x06d25b46, // c0x015a (n0x1b46-n0x1b49)  +
	0x06d31b49, // c0x015b (n0x1b49-n0x1b4c)  +
	0x06d3db4c, // c0x015c (n0x1b4c-n0x1b4f)  +
	0x06d49b4f, // c0x015d (n0x1b4f-n0x1b52)  +
	0x06d55b52, // c0x015e (n0x1b52-n0x1b55)  +
	0x06d61b55, // c0x015f (n0x1b55-n0x1b58)  +
	0x06d6db58, // c0x0160 (n0x1b58-n0x1b5b)  +
	0x06d79b5b, // c0x0161 (n0x1b5b-n0x1b5e)  +
	0x06d85b5e, // c0x0162 (n0x1b5e-n0x1b61)  +
	0x06d8db61, // c0x0163 (n0x1b61-n0x1b63)  +
	0x06d99b63, // c0x0164 (n0x1b63-n0x1b66)  +
	0x06da5b66, // c0x0165 (n0x1b66-n0x1b69)  +
	0x06db1b69, // c0x0166 (n0x1b69-n0x1b6c)  +
	0x06dbdb6c, // c0x0167 (n0x1b6c-n0x1b6f)  +
	0x06dc9b6f, // c0x0168 (n0x1b6f-n0x1b72)  +
	0x06dd5b72, // c0x0169 (n0x1b72-n0x1b75)  +
	0x06de1b75, // c0x016a (n0x1b75-n0x1b78)  +
	0x06dedb78, // c0x016b (n0x1b78-n0x1b7b)  +
	0x06df1b7b, // c0x016c (n0x1b7b-n0x1b7c)  +
	0x06dfdb7c, // c0x016d (n0x1b7c-n0x1b7f)  +
	0x06e15b7f, // c0x016e (n0x1b7f-n0x1b85)  +
	0x06e25b85, // c0x016f (n0x1b85-n0x1b89)  +
	0x06e3db89, // c0x0170 (n0x1b89-n0x1b8f)  +
	0x06e81b8f, // c0x0171 (n0x1b8f-n0x1ba0)  +
	0x06e95ba0, // c0x0172 (n0x1ba0-n0x1ba5)  +
	0x06ec5ba5, // c0x0173 (n0x1ba5-n0x1bb1)  +
	0x06ed5bb1, // c0x0174 (n0x1bb1-n0x1bb5)  +
	0x06ef1bb5, // c0x0175 (n0x1bb5-n0x1bbc)  +
	0x06f09bbc, // c0x0176 (n0x1bbc-n0x1bc2)  +
}

// max children 374 (capacity 511)
// max text offset 24971 (capacity 32767)
// max text length 36 (capacity 63)
// max hi 7106 (capacity 16383)
// max lo 7100 (capacity 16383)
