
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMetaType.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMetaType>
#include <QDataStream>
#include <QDebug>
#include <QPartialOrdering>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMetaType

//  Constructor QMetaType::QMetaType(int type)


static void _init_ctor_QMetaType_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QMetaType> ();
}

static void _call_ctor_QMetaType_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QMetaType *> (new QMetaType (arg1));
}


//  Constructor QMetaType::QMetaType()


static void _init_ctor_QMetaType_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QMetaType> ();
}

static void _call_ctor_QMetaType_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMetaType *> (new QMetaType ());
}


// qsizetype QMetaType::alignOf()


static void _init_f_alignOf_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qsizetype > ();
}

static void _call_f_alignOf_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qsizetype > ((qsizetype)((QMetaType *)cls)->alignOf ());
}


// QPartialOrdering QMetaType::compare(const void *lhs, const void *rhs)


static void _init_f_compare_c3394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lhs");
  decl->add_arg<const void * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rhs");
  decl->add_arg<const void * > (argspec_1);
  decl->set_return<QPartialOrdering > ();
}

static void _call_f_compare_c3394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const void *arg1 = gsi::arg_reader<const void * >() (args, heap);
  const void *arg2 = gsi::arg_reader<const void * >() (args, heap);
  ret.write<QPartialOrdering > ((QPartialOrdering)((QMetaType *)cls)->compare (arg1, arg2));
}


// void *QMetaType::construct(void *where, const void *copy)


static void _init_f_construct_c2699 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("where");
  decl->add_arg<void * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("copy", true, "nullptr");
  decl->add_arg<const void * > (argspec_1);
  decl->set_return<void * > ();
}

static void _call_f_construct_c2699 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  void *arg1 = gsi::arg_reader<void * >() (args, heap);
  const void *arg2 = args ? gsi::arg_reader<const void * >() (args, heap) : gsi::arg_maker<const void * >() (nullptr, heap);
  ret.write<void * > ((void *)((QMetaType *)cls)->construct (arg1, arg2));
}


// void *QMetaType::create(const void *copy)


static void _init_f_create_c1751 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("copy", true, "nullptr");
  decl->add_arg<const void * > (argspec_0);
  decl->set_return<void * > ();
}

static void _call_f_create_c1751 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const void *arg1 = args ? gsi::arg_reader<const void * >() (args, heap) : gsi::arg_maker<const void * >() (nullptr, heap);
  ret.write<void * > ((void *)((QMetaType *)cls)->create (arg1));
}


// bool QMetaType::debugStream(QDebug &dbg, const void *rhs)


static void _init_f_debugStream_2829 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dbg");
  decl->add_arg<QDebug & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rhs");
  decl->add_arg<const void * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_debugStream_2829 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDebug &arg1 = gsi::arg_reader<QDebug & >() (args, heap);
  const void *arg2 = gsi::arg_reader<const void * >() (args, heap);
  ret.write<bool > ((bool)((QMetaType *)cls)->debugStream (arg1, arg2));
}


// void QMetaType::destroy(void *data)


static void _init_f_destroy_c1056 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<void * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_destroy_c1056 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  void *arg1 = gsi::arg_reader<void * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMetaType *)cls)->destroy (arg1);
}


// void QMetaType::destruct(void *data)


static void _init_f_destruct_c1056 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<void * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_destruct_c1056 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  void *arg1 = gsi::arg_reader<void * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMetaType *)cls)->destruct (arg1);
}


// bool QMetaType::equals(const void *lhs, const void *rhs)


static void _init_f_equals_c3394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lhs");
  decl->add_arg<const void * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rhs");
  decl->add_arg<const void * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_equals_c3394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const void *arg1 = gsi::arg_reader<const void * >() (args, heap);
  const void *arg2 = gsi::arg_reader<const void * >() (args, heap);
  ret.write<bool > ((bool)((QMetaType *)cls)->equals (arg1, arg2));
}


// QFlags<QMetaType::TypeFlag> QMetaType::flags()


static void _init_f_flags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QMetaType::TypeFlag> > ();
}

static void _call_f_flags_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QMetaType::TypeFlag> > ((QFlags<QMetaType::TypeFlag>)((QMetaType *)cls)->flags ());
}


// bool QMetaType::hasRegisteredDataStreamOperators()


static void _init_f_hasRegisteredDataStreamOperators_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasRegisteredDataStreamOperators_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMetaType *)cls)->hasRegisteredDataStreamOperators ());
}


// bool QMetaType::hasRegisteredDebugStreamOperator()


static void _init_f_hasRegisteredDebugStreamOperator_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasRegisteredDebugStreamOperator_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMetaType *)cls)->hasRegisteredDebugStreamOperator ());
}


// int QMetaType::id(int)


static void _init_f_id_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_id_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<int > ((int)((QMetaType *)cls)->id (arg1));
}


// bool QMetaType::isEqualityComparable()


static void _init_f_isEqualityComparable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEqualityComparable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMetaType *)cls)->isEqualityComparable ());
}


// bool QMetaType::isOrdered()


static void _init_f_isOrdered_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isOrdered_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMetaType *)cls)->isOrdered ());
}


// bool QMetaType::isRegistered()


static void _init_f_isRegistered_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRegistered_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMetaType *)cls)->isRegistered ());
}


// bool QMetaType::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMetaType *)cls)->isValid ());
}


// bool QMetaType::load(QDataStream &stream, void *data)


static void _init_f_load_c2645 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stream");
  decl->add_arg<QDataStream & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<void * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_load_c2645 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDataStream &arg1 = gsi::arg_reader<QDataStream & >() (args, heap);
  void *arg2 = gsi::arg_reader<void * >() (args, heap);
  ret.write<bool > ((bool)((QMetaType *)cls)->load (arg1, arg2));
}


// const char *QMetaType::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const char * > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const char * > ((const char *)((QMetaType *)cls)->name ());
}


// bool QMetaType::save(QDataStream &stream, const void *data)


static void _init_f_save_c3340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stream");
  decl->add_arg<QDataStream & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<const void * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_save_c3340 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDataStream &arg1 = gsi::arg_reader<QDataStream & >() (args, heap);
  const void *arg2 = gsi::arg_reader<const void * >() (args, heap);
  ret.write<bool > ((bool)((QMetaType *)cls)->save (arg1, arg2));
}


// qsizetype QMetaType::sizeOf()


static void _init_f_sizeOf_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qsizetype > ();
}

static void _call_f_sizeOf_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qsizetype > ((qsizetype)((QMetaType *)cls)->sizeOf ());
}


// static bool QMetaType::canConvert(QMetaType fromType, QMetaType toType)


static void _init_f_canConvert_2544 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fromType");
  decl->add_arg<QMetaType > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("toType");
  decl->add_arg<QMetaType > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_canConvert_2544 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMetaType arg1 = gsi::arg_reader<QMetaType >() (args, heap);
  QMetaType arg2 = gsi::arg_reader<QMetaType >() (args, heap);
  ret.write<bool > ((bool)QMetaType::canConvert (arg1, arg2));
}


// static bool QMetaType::canView(QMetaType fromType, QMetaType toType)


static void _init_f_canView_2544 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fromType");
  decl->add_arg<QMetaType > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("toType");
  decl->add_arg<QMetaType > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_canView_2544 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMetaType arg1 = gsi::arg_reader<QMetaType >() (args, heap);
  QMetaType arg2 = gsi::arg_reader<QMetaType >() (args, heap);
  ret.write<bool > ((bool)QMetaType::canView (arg1, arg2));
}


// static bool QMetaType::compare(const void *lhs, const void *rhs, int typeId, int *result)


static void _init_f_compare_4898 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lhs");
  decl->add_arg<const void * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rhs");
  decl->add_arg<const void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("typeId");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("result");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_compare_4898 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const void *arg1 = gsi::arg_reader<const void * >() (args, heap);
  const void *arg2 = gsi::arg_reader<const void * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int *arg4 = gsi::arg_reader<int * >() (args, heap);
  ret.write<bool > ((bool)QMetaType::compare (arg1, arg2, arg3, arg4));
}


// static void *QMetaType::construct(int type, void *where, const void *copy)


static void _init_f_construct_3358 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("where");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("copy");
  decl->add_arg<const void * > (argspec_2);
  decl->set_return<void * > ();
}

static void _call_f_construct_3358 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  void *arg2 = gsi::arg_reader<void * >() (args, heap);
  const void *arg3 = gsi::arg_reader<const void * >() (args, heap);
  ret.write<void * > ((void *)QMetaType::construct (arg1, arg2, arg3));
}


// static bool QMetaType::convert(QMetaType fromType, const void *from, QMetaType toType, void *to)


static void _init_f_convert_5135 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fromType");
  decl->add_arg<QMetaType > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("from");
  decl->add_arg<const void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("toType");
  decl->add_arg<QMetaType > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("to");
  decl->add_arg<void * > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_convert_5135 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMetaType arg1 = gsi::arg_reader<QMetaType >() (args, heap);
  const void *arg2 = gsi::arg_reader<const void * >() (args, heap);
  QMetaType arg3 = gsi::arg_reader<QMetaType >() (args, heap);
  void *arg4 = gsi::arg_reader<void * >() (args, heap);
  ret.write<bool > ((bool)QMetaType::convert (arg1, arg2, arg3, arg4));
}


// static bool QMetaType::convert(const void *from, int fromTypeId, void *to, int toTypeId)


static void _init_f_convert_4017 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const void * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fromTypeId");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("to");
  decl->add_arg<void * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("toTypeId");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_convert_4017 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const void *arg1 = gsi::arg_reader<const void * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  void *arg3 = gsi::arg_reader<void * >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)QMetaType::convert (arg1, arg2, arg3, arg4));
}


// static void *QMetaType::create(int type, const void *copy)


static void _init_f_create_2410 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("copy", true, "nullptr");
  decl->add_arg<const void * > (argspec_1);
  decl->set_return<void * > ();
}

static void _call_f_create_2410 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const void *arg2 = args ? gsi::arg_reader<const void * >() (args, heap) : gsi::arg_maker<const void * >() (nullptr, heap);
  ret.write<void * > ((void *)QMetaType::create (arg1, arg2));
}


// static bool QMetaType::debugStream(QDebug &dbg, const void *rhs, int typeId)


static void _init_f_debugStream_3488 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dbg");
  decl->add_arg<QDebug & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rhs");
  decl->add_arg<const void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("typeId");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_debugStream_3488 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDebug &arg1 = gsi::arg_reader<QDebug & >() (args, heap);
  const void *arg2 = gsi::arg_reader<const void * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)QMetaType::debugStream (arg1, arg2, arg3));
}


// static void QMetaType::destroy(int type, void *data)


static void _init_f_destroy_1715 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<void * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_destroy_1715 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  void *arg2 = gsi::arg_reader<void * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QMetaType::destroy (arg1, arg2);
}


// static void QMetaType::destruct(int type, void *where)


static void _init_f_destruct_1715 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("where");
  decl->add_arg<void * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_destruct_1715 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  void *arg2 = gsi::arg_reader<void * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QMetaType::destruct (arg1, arg2);
}


// static bool QMetaType::equals(const void *lhs, const void *rhs, int typeId, int *result)


static void _init_f_equals_4898 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lhs");
  decl->add_arg<const void * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rhs");
  decl->add_arg<const void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("typeId");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("result");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_equals_4898 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const void *arg1 = gsi::arg_reader<const void * >() (args, heap);
  const void *arg2 = gsi::arg_reader<const void * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int *arg4 = gsi::arg_reader<int * >() (args, heap);
  ret.write<bool > ((bool)QMetaType::equals (arg1, arg2, arg3, arg4));
}


// static QMetaType QMetaType::fromName(QByteArrayView name)


static void _init_f_fromName_1843 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<QByteArrayView > (argspec_0);
  decl->set_return<QMetaType > ();
}

static void _call_f_fromName_1843 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QByteArrayView arg1 = gsi::arg_reader<QByteArrayView >() (args, heap);
  ret.write<QMetaType > ((QMetaType)QMetaType::fromName (arg1));
}


// static bool QMetaType::hasRegisteredConverterFunction(QMetaType fromType, QMetaType toType)


static void _init_f_hasRegisteredConverterFunction_2544 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fromType");
  decl->add_arg<QMetaType > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("toType");
  decl->add_arg<QMetaType > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_hasRegisteredConverterFunction_2544 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMetaType arg1 = gsi::arg_reader<QMetaType >() (args, heap);
  QMetaType arg2 = gsi::arg_reader<QMetaType >() (args, heap);
  ret.write<bool > ((bool)QMetaType::hasRegisteredConverterFunction (arg1, arg2));
}


// static bool QMetaType::hasRegisteredDebugStreamOperator(int typeId)


static void _init_f_hasRegisteredDebugStreamOperator_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("typeId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasRegisteredDebugStreamOperator_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)QMetaType::hasRegisteredDebugStreamOperator (arg1));
}


// static bool QMetaType::hasRegisteredMutableViewFunction(QMetaType fromType, QMetaType toType)


static void _init_f_hasRegisteredMutableViewFunction_2544 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fromType");
  decl->add_arg<QMetaType > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("toType");
  decl->add_arg<QMetaType > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_hasRegisteredMutableViewFunction_2544 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMetaType arg1 = gsi::arg_reader<QMetaType >() (args, heap);
  QMetaType arg2 = gsi::arg_reader<QMetaType >() (args, heap);
  ret.write<bool > ((bool)QMetaType::hasRegisteredMutableViewFunction (arg1, arg2));
}


// static bool QMetaType::isRegistered(int type)


static void _init_f_isRegistered_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isRegistered_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)QMetaType::isRegistered (arg1));
}


// static bool QMetaType::load(QDataStream &stream, int type, void *data)


static void _init_f_load_3304 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stream");
  decl->add_arg<QDataStream & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data");
  decl->add_arg<void * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_load_3304 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDataStream &arg1 = gsi::arg_reader<QDataStream & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  void *arg3 = gsi::arg_reader<void * >() (args, heap);
  ret.write<bool > ((bool)QMetaType::load (arg1, arg2, arg3));
}


// static void QMetaType::registerNormalizedTypedef(const ::QByteArray &normalizedTypeName, QMetaType type)


static void _init_f_registerNormalizedTypedef_3643 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("normalizedTypeName");
  decl->add_arg<const ::QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<QMetaType > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_registerNormalizedTypedef_3643 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const ::QByteArray &arg1 = gsi::arg_reader<const ::QByteArray & >() (args, heap);
  QMetaType arg2 = gsi::arg_reader<QMetaType >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QMetaType::registerNormalizedTypedef (arg1, arg2);
}


// static bool QMetaType::save(QDataStream &stream, int type, const void *data)


static void _init_f_save_3999 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stream");
  decl->add_arg<QDataStream & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data");
  decl->add_arg<const void * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_save_3999 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDataStream &arg1 = gsi::arg_reader<QDataStream & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const void *arg3 = gsi::arg_reader<const void * >() (args, heap);
  ret.write<bool > ((bool)QMetaType::save (arg1, arg2, arg3));
}


// static int QMetaType::sizeOf(int type)


static void _init_f_sizeOf_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_sizeOf_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)QMetaType::sizeOf (arg1));
}


// static int QMetaType::type(const char *typeName)


static void _init_f_type_1731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("typeName");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_type_1731 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)QMetaType::type (arg1));
}


// static int QMetaType::type(const ::QByteArray &typeName)


static void _init_f_type_2425 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("typeName");
  decl->add_arg<const ::QByteArray & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_type_2425 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const ::QByteArray &arg1 = gsi::arg_reader<const ::QByteArray & >() (args, heap);
  ret.write<int > ((int)QMetaType::type (arg1));
}


// static QFlags<QMetaType::TypeFlag> QMetaType::typeFlags(int type)


static void _init_f_typeFlags_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QFlags<QMetaType::TypeFlag> > ();
}

static void _call_f_typeFlags_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QFlags<QMetaType::TypeFlag> > ((QFlags<QMetaType::TypeFlag>)QMetaType::typeFlags (arg1));
}


// static const char *QMetaType::typeName(int type)


static void _init_f_typeName_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  decl->set_return<const char * > ();
}

static void _call_f_typeName_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<const char * > ((const char *)QMetaType::typeName (arg1));
}


// static void QMetaType::unregisterConverterFunction(QMetaType from, QMetaType to)


static void _init_f_unregisterConverterFunction_2544 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<QMetaType > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<QMetaType > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_unregisterConverterFunction_2544 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMetaType arg1 = gsi::arg_reader<QMetaType >() (args, heap);
  QMetaType arg2 = gsi::arg_reader<QMetaType >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QMetaType::unregisterConverterFunction (arg1, arg2);
}


// static void QMetaType::unregisterMetaType(QMetaType type)


static void _init_f_unregisterMetaType_1326 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<QMetaType > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unregisterMetaType_1326 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMetaType arg1 = gsi::arg_reader<QMetaType >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QMetaType::unregisterMetaType (arg1);
}


// static void QMetaType::unregisterMutableViewFunction(QMetaType from, QMetaType to)


static void _init_f_unregisterMutableViewFunction_2544 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<QMetaType > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<QMetaType > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_unregisterMutableViewFunction_2544 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMetaType arg1 = gsi::arg_reader<QMetaType >() (args, heap);
  QMetaType arg2 = gsi::arg_reader<QMetaType >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QMetaType::unregisterMutableViewFunction (arg1, arg2);
}


// static bool QMetaType::view(QMetaType fromType, void *from, QMetaType toType, void *to)


static void _init_f_view_4440 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fromType");
  decl->add_arg<QMetaType > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("from");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("toType");
  decl->add_arg<QMetaType > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("to");
  decl->add_arg<void * > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_view_4440 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMetaType arg1 = gsi::arg_reader<QMetaType >() (args, heap);
  void *arg2 = gsi::arg_reader<void * >() (args, heap);
  QMetaType arg3 = gsi::arg_reader<QMetaType >() (args, heap);
  void *arg4 = gsi::arg_reader<void * >() (args, heap);
  ret.write<bool > ((bool)QMetaType::view (arg1, arg2, arg3, arg4));
}



namespace gsi
{

static gsi::Methods methods_QMetaType () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMetaType::QMetaType(int type)\nThis method creates an object of class QMetaType.", &_init_ctor_QMetaType_767, &_call_ctor_QMetaType_767);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMetaType::QMetaType()\nThis method creates an object of class QMetaType.", &_init_ctor_QMetaType_0, &_call_ctor_QMetaType_0);
  methods += new qt_gsi::GenericMethod ("alignOf", "@brief Method qsizetype QMetaType::alignOf()\n", true, &_init_f_alignOf_c0, &_call_f_alignOf_c0);
  methods += new qt_gsi::GenericMethod ("compare", "@brief Method QPartialOrdering QMetaType::compare(const void *lhs, const void *rhs)\n", true, &_init_f_compare_c3394, &_call_f_compare_c3394);
  methods += new qt_gsi::GenericMethod ("construct", "@brief Method void *QMetaType::construct(void *where, const void *copy)\n", true, &_init_f_construct_c2699, &_call_f_construct_c2699);
  methods += new qt_gsi::GenericMethod ("qt_create", "@brief Method void *QMetaType::create(const void *copy)\n", true, &_init_f_create_c1751, &_call_f_create_c1751);
  methods += new qt_gsi::GenericMethod ("debugStream", "@brief Method bool QMetaType::debugStream(QDebug &dbg, const void *rhs)\n", false, &_init_f_debugStream_2829, &_call_f_debugStream_2829);
  methods += new qt_gsi::GenericMethod ("qt_destroy", "@brief Method void QMetaType::destroy(void *data)\n", true, &_init_f_destroy_c1056, &_call_f_destroy_c1056);
  methods += new qt_gsi::GenericMethod ("destruct", "@brief Method void QMetaType::destruct(void *data)\n", true, &_init_f_destruct_c1056, &_call_f_destruct_c1056);
  methods += new qt_gsi::GenericMethod ("equals", "@brief Method bool QMetaType::equals(const void *lhs, const void *rhs)\n", true, &_init_f_equals_c3394, &_call_f_equals_c3394);
  methods += new qt_gsi::GenericMethod ("flags", "@brief Method QFlags<QMetaType::TypeFlag> QMetaType::flags()\n", true, &_init_f_flags_c0, &_call_f_flags_c0);
  methods += new qt_gsi::GenericMethod ("hasRegisteredDataStreamOperators", "@brief Method bool QMetaType::hasRegisteredDataStreamOperators()\n", true, &_init_f_hasRegisteredDataStreamOperators_c0, &_call_f_hasRegisteredDataStreamOperators_c0);
  methods += new qt_gsi::GenericMethod ("hasRegisteredDebugStreamOperator", "@brief Method bool QMetaType::hasRegisteredDebugStreamOperator()\n", true, &_init_f_hasRegisteredDebugStreamOperator_c0, &_call_f_hasRegisteredDebugStreamOperator_c0);
  methods += new qt_gsi::GenericMethod ("id", "@brief Method int QMetaType::id(int)\n", true, &_init_f_id_c767, &_call_f_id_c767);
  methods += new qt_gsi::GenericMethod ("isEqualityComparable?", "@brief Method bool QMetaType::isEqualityComparable()\n", true, &_init_f_isEqualityComparable_c0, &_call_f_isEqualityComparable_c0);
  methods += new qt_gsi::GenericMethod ("isOrdered?", "@brief Method bool QMetaType::isOrdered()\n", true, &_init_f_isOrdered_c0, &_call_f_isOrdered_c0);
  methods += new qt_gsi::GenericMethod ("isRegistered?", "@brief Method bool QMetaType::isRegistered()\n", true, &_init_f_isRegistered_c0, &_call_f_isRegistered_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QMetaType::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("load", "@brief Method bool QMetaType::load(QDataStream &stream, void *data)\n", true, &_init_f_load_c2645, &_call_f_load_c2645);
  methods += new qt_gsi::GenericMethod ("name", "@brief Method const char *QMetaType::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
  methods += new qt_gsi::GenericMethod ("save", "@brief Method bool QMetaType::save(QDataStream &stream, const void *data)\n", true, &_init_f_save_c3340, &_call_f_save_c3340);
  methods += new qt_gsi::GenericMethod ("sizeOf", "@brief Method qsizetype QMetaType::sizeOf()\n", true, &_init_f_sizeOf_c0, &_call_f_sizeOf_c0);
  methods += new qt_gsi::GenericStaticMethod ("canConvert", "@brief Static method bool QMetaType::canConvert(QMetaType fromType, QMetaType toType)\nThis method is static and can be called without an instance.", &_init_f_canConvert_2544, &_call_f_canConvert_2544);
  methods += new qt_gsi::GenericStaticMethod ("canView", "@brief Static method bool QMetaType::canView(QMetaType fromType, QMetaType toType)\nThis method is static and can be called without an instance.", &_init_f_canView_2544, &_call_f_canView_2544);
  methods += new qt_gsi::GenericStaticMethod ("compare", "@brief Static method bool QMetaType::compare(const void *lhs, const void *rhs, int typeId, int *result)\nThis method is static and can be called without an instance.", &_init_f_compare_4898, &_call_f_compare_4898);
  methods += new qt_gsi::GenericStaticMethod ("construct", "@brief Static method void *QMetaType::construct(int type, void *where, const void *copy)\nThis method is static and can be called without an instance.", &_init_f_construct_3358, &_call_f_construct_3358);
  methods += new qt_gsi::GenericStaticMethod ("convert", "@brief Static method bool QMetaType::convert(QMetaType fromType, const void *from, QMetaType toType, void *to)\nThis method is static and can be called without an instance.", &_init_f_convert_5135, &_call_f_convert_5135);
  methods += new qt_gsi::GenericStaticMethod ("convert", "@brief Static method bool QMetaType::convert(const void *from, int fromTypeId, void *to, int toTypeId)\nThis method is static and can be called without an instance.", &_init_f_convert_4017, &_call_f_convert_4017);
  methods += new qt_gsi::GenericStaticMethod ("qt_create", "@brief Static method void *QMetaType::create(int type, const void *copy)\nThis method is static and can be called without an instance.", &_init_f_create_2410, &_call_f_create_2410);
  methods += new qt_gsi::GenericStaticMethod ("debugStream", "@brief Static method bool QMetaType::debugStream(QDebug &dbg, const void *rhs, int typeId)\nThis method is static and can be called without an instance.", &_init_f_debugStream_3488, &_call_f_debugStream_3488);
  methods += new qt_gsi::GenericStaticMethod ("qt_destroy", "@brief Static method void QMetaType::destroy(int type, void *data)\nThis method is static and can be called without an instance.", &_init_f_destroy_1715, &_call_f_destroy_1715);
  methods += new qt_gsi::GenericStaticMethod ("destruct", "@brief Static method void QMetaType::destruct(int type, void *where)\nThis method is static and can be called without an instance.", &_init_f_destruct_1715, &_call_f_destruct_1715);
  methods += new qt_gsi::GenericStaticMethod ("equals", "@brief Static method bool QMetaType::equals(const void *lhs, const void *rhs, int typeId, int *result)\nThis method is static and can be called without an instance.", &_init_f_equals_4898, &_call_f_equals_4898);
  methods += new qt_gsi::GenericStaticMethod ("fromName", "@brief Static method QMetaType QMetaType::fromName(QByteArrayView name)\nThis method is static and can be called without an instance.", &_init_f_fromName_1843, &_call_f_fromName_1843);
  methods += new qt_gsi::GenericStaticMethod ("hasRegisteredConverterFunction", "@brief Static method bool QMetaType::hasRegisteredConverterFunction(QMetaType fromType, QMetaType toType)\nThis method is static and can be called without an instance.", &_init_f_hasRegisteredConverterFunction_2544, &_call_f_hasRegisteredConverterFunction_2544);
  methods += new qt_gsi::GenericStaticMethod ("hasRegisteredDebugStreamOperator", "@brief Static method bool QMetaType::hasRegisteredDebugStreamOperator(int typeId)\nThis method is static and can be called without an instance.", &_init_f_hasRegisteredDebugStreamOperator_767, &_call_f_hasRegisteredDebugStreamOperator_767);
  methods += new qt_gsi::GenericStaticMethod ("hasRegisteredMutableViewFunction", "@brief Static method bool QMetaType::hasRegisteredMutableViewFunction(QMetaType fromType, QMetaType toType)\nThis method is static and can be called without an instance.", &_init_f_hasRegisteredMutableViewFunction_2544, &_call_f_hasRegisteredMutableViewFunction_2544);
  methods += new qt_gsi::GenericStaticMethod ("isRegistered?", "@brief Static method bool QMetaType::isRegistered(int type)\nThis method is static and can be called without an instance.", &_init_f_isRegistered_767, &_call_f_isRegistered_767);
  methods += new qt_gsi::GenericStaticMethod ("load", "@brief Static method bool QMetaType::load(QDataStream &stream, int type, void *data)\nThis method is static and can be called without an instance.", &_init_f_load_3304, &_call_f_load_3304);
  methods += new qt_gsi::GenericStaticMethod ("registerNormalizedTypedef", "@brief Static method void QMetaType::registerNormalizedTypedef(const ::QByteArray &normalizedTypeName, QMetaType type)\nThis method is static and can be called without an instance.", &_init_f_registerNormalizedTypedef_3643, &_call_f_registerNormalizedTypedef_3643);
  methods += new qt_gsi::GenericStaticMethod ("save", "@brief Static method bool QMetaType::save(QDataStream &stream, int type, const void *data)\nThis method is static and can be called without an instance.", &_init_f_save_3999, &_call_f_save_3999);
  methods += new qt_gsi::GenericStaticMethod ("sizeOf", "@brief Static method int QMetaType::sizeOf(int type)\nThis method is static and can be called without an instance.", &_init_f_sizeOf_767, &_call_f_sizeOf_767);
  methods += new qt_gsi::GenericStaticMethod ("type", "@brief Static method int QMetaType::type(const char *typeName)\nThis method is static and can be called without an instance.", &_init_f_type_1731, &_call_f_type_1731);
  methods += new qt_gsi::GenericStaticMethod ("type", "@brief Static method int QMetaType::type(const ::QByteArray &typeName)\nThis method is static and can be called without an instance.", &_init_f_type_2425, &_call_f_type_2425);
  methods += new qt_gsi::GenericStaticMethod ("typeFlags", "@brief Static method QFlags<QMetaType::TypeFlag> QMetaType::typeFlags(int type)\nThis method is static and can be called without an instance.", &_init_f_typeFlags_767, &_call_f_typeFlags_767);
  methods += new qt_gsi::GenericStaticMethod ("typeName", "@brief Static method const char *QMetaType::typeName(int type)\nThis method is static and can be called without an instance.", &_init_f_typeName_767, &_call_f_typeName_767);
  methods += new qt_gsi::GenericStaticMethod ("unregisterConverterFunction", "@brief Static method void QMetaType::unregisterConverterFunction(QMetaType from, QMetaType to)\nThis method is static and can be called without an instance.", &_init_f_unregisterConverterFunction_2544, &_call_f_unregisterConverterFunction_2544);
  methods += new qt_gsi::GenericStaticMethod ("unregisterMetaType", "@brief Static method void QMetaType::unregisterMetaType(QMetaType type)\nThis method is static and can be called without an instance.", &_init_f_unregisterMetaType_1326, &_call_f_unregisterMetaType_1326);
  methods += new qt_gsi::GenericStaticMethod ("unregisterMutableViewFunction", "@brief Static method void QMetaType::unregisterMutableViewFunction(QMetaType from, QMetaType to)\nThis method is static and can be called without an instance.", &_init_f_unregisterMutableViewFunction_2544, &_call_f_unregisterMutableViewFunction_2544);
  methods += new qt_gsi::GenericStaticMethod ("view", "@brief Static method bool QMetaType::view(QMetaType fromType, void *from, QMetaType toType, void *to)\nThis method is static and can be called without an instance.", &_init_f_view_4440, &_call_f_view_4440);
  return methods;
}

gsi::Class<QMetaType> decl_QMetaType ("QtCore", "QMetaType",
  methods_QMetaType (),
  "@qt\n@brief Binding of QMetaType");


GSI_QTCORE_PUBLIC gsi::Class<QMetaType> &qtdecl_QMetaType () { return decl_QMetaType; }

}


//  Implementation of the enum wrapper class for QMetaType::TypeFlag
namespace qt_gsi
{

static gsi::Enum<QMetaType::TypeFlag> decl_QMetaType_TypeFlag_Enum ("QtCore", "QMetaType_TypeFlag",
    gsi::enum_const ("NeedsConstruction", QMetaType::NeedsConstruction, "@brief Enum constant QMetaType::NeedsConstruction") +
    gsi::enum_const ("NeedsDestruction", QMetaType::NeedsDestruction, "@brief Enum constant QMetaType::NeedsDestruction") +
    gsi::enum_const ("RelocatableType", QMetaType::RelocatableType, "@brief Enum constant QMetaType::RelocatableType") +
    gsi::enum_const ("MovableType", QMetaType::MovableType, "@brief Enum constant QMetaType::MovableType") +
    gsi::enum_const ("PointerToQObject", QMetaType::PointerToQObject, "@brief Enum constant QMetaType::PointerToQObject") +
    gsi::enum_const ("IsEnumeration", QMetaType::IsEnumeration, "@brief Enum constant QMetaType::IsEnumeration") +
    gsi::enum_const ("SharedPointerToQObject", QMetaType::SharedPointerToQObject, "@brief Enum constant QMetaType::SharedPointerToQObject") +
    gsi::enum_const ("WeakPointerToQObject", QMetaType::WeakPointerToQObject, "@brief Enum constant QMetaType::WeakPointerToQObject") +
    gsi::enum_const ("TrackingPointerToQObject", QMetaType::TrackingPointerToQObject, "@brief Enum constant QMetaType::TrackingPointerToQObject") +
    gsi::enum_const ("IsUnsignedEnumeration", QMetaType::IsUnsignedEnumeration, "@brief Enum constant QMetaType::IsUnsignedEnumeration") +
    gsi::enum_const ("IsGadget", QMetaType::IsGadget, "@brief Enum constant QMetaType::IsGadget") +
    gsi::enum_const ("PointerToGadget", QMetaType::PointerToGadget, "@brief Enum constant QMetaType::PointerToGadget") +
    gsi::enum_const ("IsPointer", QMetaType::IsPointer, "@brief Enum constant QMetaType::IsPointer") +
    gsi::enum_const ("IsQmlList", QMetaType::IsQmlList, "@brief Enum constant QMetaType::IsQmlList") +
    gsi::enum_const ("IsConst", QMetaType::IsConst, "@brief Enum constant QMetaType::IsConst"),
  "@qt\n@brief This class represents the QMetaType::TypeFlag enum");

static gsi::QFlagsClass<QMetaType::TypeFlag > decl_QMetaType_TypeFlag_Enums ("QtCore", "QMetaType_QFlags_TypeFlag",
  "@qt\n@brief This class represents the QFlags<QMetaType::TypeFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMetaType> inject_QMetaType_TypeFlag_Enum_in_parent (decl_QMetaType_TypeFlag_Enum.defs ());
static gsi::ClassExt<QMetaType> decl_QMetaType_TypeFlag_Enum_as_child (decl_QMetaType_TypeFlag_Enum, "TypeFlag");
static gsi::ClassExt<QMetaType> decl_QMetaType_TypeFlag_Enums_as_child (decl_QMetaType_TypeFlag_Enums, "QFlags_TypeFlag");

}

