
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTableWidget.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTableWidget>
#include <QAbstractItemDelegate>
#include <QAbstractItemModel>
#include <QAction>
#include <QActionEvent>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHeaderView>
#include <QHideEvent>
#include <QIcon>
#include <QInputContext>
#include <QInputMethodEvent>
#include <QItemSelection>
#include <QItemSelectionModel>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMimeData>
#include <QModelIndex>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScrollBar>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionViewItem>
#include <QTableWidgetItem>
#include <QTableWidgetSelectionRange>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTableWidget

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTableWidget::staticMetaObject);
}


// QWidget *QTableWidget::cellWidget(int row, int column)


static void _init_f_cellWidget_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QWidget * > ();
}

static void _call_f_cellWidget_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QWidget * > ((QWidget *)((QTableWidget *)cls)->cellWidget (arg1, arg2));
}


// void QTableWidget::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->clear ();
}


// void QTableWidget::clearContents()


static void _init_f_clearContents_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearContents_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->clearContents ();
}


// void QTableWidget::closePersistentEditor(QTableWidgetItem *item)


static void _init_f_closePersistentEditor_2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_closePersistentEditor_2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTableWidgetItem *arg1 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->closePersistentEditor (arg1);
}


// int QTableWidget::column(const QTableWidgetItem *item)


static void _init_f_column_c2897 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTableWidgetItem * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_column_c2897 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTableWidgetItem *arg1 = gsi::arg_reader<const QTableWidgetItem * >() (args, heap);
  ret.write<int > ((int)((QTableWidget *)cls)->column (arg1));
}


// int QTableWidget::columnCount()


static void _init_f_columnCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_columnCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTableWidget *)cls)->columnCount ());
}


// int QTableWidget::currentColumn()


static void _init_f_currentColumn_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentColumn_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTableWidget *)cls)->currentColumn ());
}


// QTableWidgetItem *QTableWidget::currentItem()


static void _init_f_currentItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTableWidgetItem * > ();
}

static void _call_f_currentItem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTableWidgetItem * > ((QTableWidgetItem *)((QTableWidget *)cls)->currentItem ());
}


// int QTableWidget::currentRow()


static void _init_f_currentRow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentRow_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTableWidget *)cls)->currentRow ());
}


// void QTableWidget::editItem(QTableWidgetItem *item)


static void _init_f_editItem_2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_editItem_2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTableWidgetItem *arg1 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->editItem (arg1);
}


// QList<QTableWidgetItem*> QTableWidget::findItems(const QString &text, QFlags<Qt::MatchFlag> flags)


static void _init_f_findItems_c4233 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<QFlags<Qt::MatchFlag> > (argspec_1);
  decl->set_return<QList<QTableWidgetItem*> > ();
}

static void _call_f_findItems_c4233 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<Qt::MatchFlag> arg2 = gsi::arg_reader<QFlags<Qt::MatchFlag> >() (args, heap);
  ret.write<QList<QTableWidgetItem*> > ((QList<QTableWidgetItem*>)((QTableWidget *)cls)->findItems (arg1, arg2));
}


// QTableWidgetItem *QTableWidget::horizontalHeaderItem(int column)


static void _init_f_horizontalHeaderItem_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTableWidgetItem * > ();
}

static void _call_f_horizontalHeaderItem_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QTableWidgetItem * > ((QTableWidgetItem *)((QTableWidget *)cls)->horizontalHeaderItem (arg1));
}


// void QTableWidget::insertColumn(int column)


static void _init_f_insertColumn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertColumn_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->insertColumn (arg1);
}


// void QTableWidget::insertRow(int row)


static void _init_f_insertRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertRow_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->insertRow (arg1);
}


// bool QTableWidget::isItemSelected(const QTableWidgetItem *item)


static void _init_f_isItemSelected_c2897 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTableWidgetItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isItemSelected_c2897 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTableWidgetItem *arg1 = gsi::arg_reader<const QTableWidgetItem * >() (args, heap);
  ret.write<bool > ((bool)((QTableWidget *)cls)->isItemSelected (arg1));
}


// bool QTableWidget::isSortingEnabled()


static void _init_f_isSortingEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSortingEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTableWidget *)cls)->isSortingEnabled ());
}


// QTableWidgetItem *QTableWidget::item(int row, int column)


static void _init_f_item_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QTableWidgetItem * > ();
}

static void _call_f_item_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QTableWidgetItem * > ((QTableWidgetItem *)((QTableWidget *)cls)->item (arg1, arg2));
}


// QTableWidgetItem *QTableWidget::itemAt(const QPoint &p)


static void _init_f_itemAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QTableWidgetItem * > ();
}

static void _call_f_itemAt_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QTableWidgetItem * > ((QTableWidgetItem *)((QTableWidget *)cls)->itemAt (arg1));
}


// QTableWidgetItem *QTableWidget::itemAt(int x, int y)


static void _init_f_itemAt_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QTableWidgetItem * > ();
}

static void _call_f_itemAt_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QTableWidgetItem * > ((QTableWidgetItem *)((QTableWidget *)cls)->itemAt (arg1, arg2));
}


// const QTableWidgetItem *QTableWidget::itemPrototype()


static void _init_f_itemPrototype_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QTableWidgetItem * > ();
}

static void _call_f_itemPrototype_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QTableWidgetItem * > ((const QTableWidgetItem *)((QTableWidget *)cls)->itemPrototype ());
}


// void QTableWidget::openPersistentEditor(QTableWidgetItem *item)


static void _init_f_openPersistentEditor_2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_openPersistentEditor_2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTableWidgetItem *arg1 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->openPersistentEditor (arg1);
}


// void QTableWidget::removeCellWidget(int row, int column)


static void _init_f_removeCellWidget_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_removeCellWidget_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->removeCellWidget (arg1, arg2);
}


// void QTableWidget::removeColumn(int column)


static void _init_f_removeColumn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeColumn_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->removeColumn (arg1);
}


// void QTableWidget::removeRow(int row)


static void _init_f_removeRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeRow_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->removeRow (arg1);
}


// int QTableWidget::row(const QTableWidgetItem *item)


static void _init_f_row_c2897 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTableWidgetItem * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_row_c2897 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTableWidgetItem *arg1 = gsi::arg_reader<const QTableWidgetItem * >() (args, heap);
  ret.write<int > ((int)((QTableWidget *)cls)->row (arg1));
}


// int QTableWidget::rowCount()


static void _init_f_rowCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_rowCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTableWidget *)cls)->rowCount ());
}


// void QTableWidget::scrollToItem(const QTableWidgetItem *item, QAbstractItemView::ScrollHint hint)


static void _init_f_scrollToItem_6078 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTableWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemView::EnsureVisible");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scrollToItem_6078 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTableWidgetItem *arg1 = gsi::arg_reader<const QTableWidgetItem * >() (args, heap);
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemView::ScrollHint>(heap, QAbstractItemView::EnsureVisible), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->scrollToItem (arg1, qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollHint>(arg2).cref());
}


// QList<QTableWidgetItem*> QTableWidget::selectedItems()


static void _init_f_selectedItems_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QTableWidgetItem*> > ();
}

static void _call_f_selectedItems_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QTableWidgetItem*> > ((QList<QTableWidgetItem*>)((QTableWidget *)cls)->selectedItems ());
}


// QList<QTableWidgetSelectionRange> QTableWidget::selectedRanges()


static void _init_f_selectedRanges_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QTableWidgetSelectionRange> > ();
}

static void _call_f_selectedRanges_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QTableWidgetSelectionRange> > ((QList<QTableWidgetSelectionRange>)((QTableWidget *)cls)->selectedRanges ());
}


// void QTableWidget::setCellWidget(int row, int column, QWidget *widget)


static void _init_f_setCellWidget_2633 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setCellWidget_2633 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  QWidget *arg3 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setCellWidget (arg1, arg2, arg3);
}


// void QTableWidget::setColumnCount(int columns)


static void _init_f_setColumnCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("columns");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColumnCount_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setColumnCount (arg1);
}


// void QTableWidget::setCurrentCell(int row, int column)


static void _init_f_setCurrentCell_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCurrentCell_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setCurrentCell (arg1, arg2);
}


// void QTableWidget::setCurrentCell(int row, int column, QFlags<QItemSelectionModel::SelectionFlag> command)


static void _init_f_setCurrentCell_5789 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("command");
  decl->add_arg<QFlags<QItemSelectionModel::SelectionFlag> > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setCurrentCell_5789 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  QFlags<QItemSelectionModel::SelectionFlag> arg3 = gsi::arg_reader<QFlags<QItemSelectionModel::SelectionFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setCurrentCell (arg1, arg2, arg3);
}


// void QTableWidget::setCurrentItem(QTableWidgetItem *item)


static void _init_f_setCurrentItem_2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentItem_2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTableWidgetItem *arg1 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setCurrentItem (arg1);
}


// void QTableWidget::setCurrentItem(QTableWidgetItem *item, QFlags<QItemSelectionModel::SelectionFlag> command)


static void _init_f_setCurrentItem_6565 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<QFlags<QItemSelectionModel::SelectionFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCurrentItem_6565 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTableWidgetItem *arg1 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  QFlags<QItemSelectionModel::SelectionFlag> arg2 = gsi::arg_reader<QFlags<QItemSelectionModel::SelectionFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setCurrentItem (arg1, arg2);
}


// void QTableWidget::setHorizontalHeaderItem(int column, QTableWidgetItem *item)


static void _init_f_setHorizontalHeaderItem_2861 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setHorizontalHeaderItem_2861 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QTableWidgetItem *arg2 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setHorizontalHeaderItem (arg1, arg2);
}


// void QTableWidget::setHorizontalHeaderLabels(const QStringList &labels)


static void _init_f_setHorizontalHeaderLabels_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("labels");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHorizontalHeaderLabels_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setHorizontalHeaderLabels (arg1);
}


// void QTableWidget::setItem(int row, int column, QTableWidgetItem *item)


static void _init_f_setItem_3520 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setItem_3520 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  QTableWidgetItem *arg3 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  qt_gsi::qt_keep (arg3);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setItem (arg1, arg2, arg3);
}


// void QTableWidget::setItemPrototype(const QTableWidgetItem *item)


static void _init_f_setItemPrototype_2897 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTableWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemPrototype_2897 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTableWidgetItem *arg1 = gsi::arg_reader<const QTableWidgetItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setItemPrototype (arg1);
}


// void QTableWidget::setItemSelected(const QTableWidgetItem *item, bool select)


static void _init_f_setItemSelected_3653 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTableWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("select");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemSelected_3653 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTableWidgetItem *arg1 = gsi::arg_reader<const QTableWidgetItem * >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setItemSelected (arg1, arg2);
}


// void QTableWidget::setRangeSelected(const QTableWidgetSelectionRange &range, bool select)


static void _init_f_setRangeSelected_4677 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("range");
  decl->add_arg<const QTableWidgetSelectionRange & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("select");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRangeSelected_4677 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTableWidgetSelectionRange &arg1 = gsi::arg_reader<const QTableWidgetSelectionRange & >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setRangeSelected (arg1, arg2);
}


// void QTableWidget::setRowCount(int rows)


static void _init_f_setRowCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rows");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRowCount_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setRowCount (arg1);
}


// void QTableWidget::setSortingEnabled(bool enable)


static void _init_f_setSortingEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSortingEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setSortingEnabled (arg1);
}


// void QTableWidget::setVerticalHeaderItem(int row, QTableWidgetItem *item)


static void _init_f_setVerticalHeaderItem_2861 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setVerticalHeaderItem_2861 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QTableWidgetItem *arg2 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setVerticalHeaderItem (arg1, arg2);
}


// void QTableWidget::setVerticalHeaderLabels(const QStringList &labels)


static void _init_f_setVerticalHeaderLabels_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("labels");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVerticalHeaderLabels_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->setVerticalHeaderLabels (arg1);
}


// void QTableWidget::sortItems(int column, Qt::SortOrder order)


static void _init_f_sortItems_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order", true, "Qt::AscendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sortItems_2340 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::AscendingOrder), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget *)cls)->sortItems (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}


// QTableWidgetItem *QTableWidget::takeHorizontalHeaderItem(int column)


static void _init_f_takeHorizontalHeaderItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QTableWidgetItem * > ();
}

static void _call_f_takeHorizontalHeaderItem_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QTableWidgetItem * > ((QTableWidgetItem *)((QTableWidget *)cls)->takeHorizontalHeaderItem (arg1));
}


// QTableWidgetItem *QTableWidget::takeItem(int row, int column)


static void _init_f_takeItem_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return_new<QTableWidgetItem * > ();
}

static void _call_f_takeItem_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QTableWidgetItem * > ((QTableWidgetItem *)((QTableWidget *)cls)->takeItem (arg1, arg2));
}


// QTableWidgetItem *QTableWidget::takeVerticalHeaderItem(int row)


static void _init_f_takeVerticalHeaderItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QTableWidgetItem * > ();
}

static void _call_f_takeVerticalHeaderItem_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QTableWidgetItem * > ((QTableWidgetItem *)((QTableWidget *)cls)->takeVerticalHeaderItem (arg1));
}


// QTableWidgetItem *QTableWidget::verticalHeaderItem(int row)


static void _init_f_verticalHeaderItem_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTableWidgetItem * > ();
}

static void _call_f_verticalHeaderItem_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QTableWidgetItem * > ((QTableWidgetItem *)((QTableWidget *)cls)->verticalHeaderItem (arg1));
}


// int QTableWidget::visualColumn(int logicalColumn)


static void _init_f_visualColumn_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalColumn");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_visualColumn_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QTableWidget *)cls)->visualColumn (arg1));
}


// QRect QTableWidget::visualItemRect(const QTableWidgetItem *item)


static void _init_f_visualItemRect_c2897 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTableWidgetItem * > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_visualItemRect_c2897 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTableWidgetItem *arg1 = gsi::arg_reader<const QTableWidgetItem * >() (args, heap);
  ret.write<QRect > ((QRect)((QTableWidget *)cls)->visualItemRect (arg1));
}


// int QTableWidget::visualRow(int logicalRow)


static void _init_f_visualRow_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalRow");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_visualRow_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QTableWidget *)cls)->visualRow (arg1));
}


// static QString QTableWidget::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QTableWidget::tr (arg1, arg2));
}


// static QString QTableWidget::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QTableWidget::tr (arg1, arg2, arg3));
}


// static QString QTableWidget::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QTableWidget::trUtf8 (arg1, arg2));
}


// static QString QTableWidget::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QTableWidget::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QTableWidget () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("cellWidget", "@brief Method QWidget *QTableWidget::cellWidget(int row, int column)\n", true, &_init_f_cellWidget_c1426, &_call_f_cellWidget_c1426);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QTableWidget::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("clearContents", "@brief Method void QTableWidget::clearContents()\n", false, &_init_f_clearContents_0, &_call_f_clearContents_0);
  methods += new qt_gsi::GenericMethod ("closePersistentEditor", "@brief Method void QTableWidget::closePersistentEditor(QTableWidgetItem *item)\n", false, &_init_f_closePersistentEditor_2202, &_call_f_closePersistentEditor_2202);
  methods += new qt_gsi::GenericMethod ("column", "@brief Method int QTableWidget::column(const QTableWidgetItem *item)\n", true, &_init_f_column_c2897, &_call_f_column_c2897);
  methods += new qt_gsi::GenericMethod (":columnCount", "@brief Method int QTableWidget::columnCount()\n", true, &_init_f_columnCount_c0, &_call_f_columnCount_c0);
  methods += new qt_gsi::GenericMethod ("currentColumn", "@brief Method int QTableWidget::currentColumn()\n", true, &_init_f_currentColumn_c0, &_call_f_currentColumn_c0);
  methods += new qt_gsi::GenericMethod (":currentItem", "@brief Method QTableWidgetItem *QTableWidget::currentItem()\n", true, &_init_f_currentItem_c0, &_call_f_currentItem_c0);
  methods += new qt_gsi::GenericMethod ("currentRow", "@brief Method int QTableWidget::currentRow()\n", true, &_init_f_currentRow_c0, &_call_f_currentRow_c0);
  methods += new qt_gsi::GenericMethod ("editItem", "@brief Method void QTableWidget::editItem(QTableWidgetItem *item)\n", false, &_init_f_editItem_2202, &_call_f_editItem_2202);
  methods += new qt_gsi::GenericMethod ("findItems", "@brief Method QList<QTableWidgetItem*> QTableWidget::findItems(const QString &text, QFlags<Qt::MatchFlag> flags)\n", true, &_init_f_findItems_c4233, &_call_f_findItems_c4233);
  methods += new qt_gsi::GenericMethod ("horizontalHeaderItem", "@brief Method QTableWidgetItem *QTableWidget::horizontalHeaderItem(int column)\n", true, &_init_f_horizontalHeaderItem_c767, &_call_f_horizontalHeaderItem_c767);
  methods += new qt_gsi::GenericMethod ("insertColumn", "@brief Method void QTableWidget::insertColumn(int column)\n", false, &_init_f_insertColumn_767, &_call_f_insertColumn_767);
  methods += new qt_gsi::GenericMethod ("insertRow", "@brief Method void QTableWidget::insertRow(int row)\n", false, &_init_f_insertRow_767, &_call_f_insertRow_767);
  methods += new qt_gsi::GenericMethod ("isItemSelected?", "@brief Method bool QTableWidget::isItemSelected(const QTableWidgetItem *item)\n", true, &_init_f_isItemSelected_c2897, &_call_f_isItemSelected_c2897);
  methods += new qt_gsi::GenericMethod ("isSortingEnabled?|:sortingEnabled", "@brief Method bool QTableWidget::isSortingEnabled()\n", true, &_init_f_isSortingEnabled_c0, &_call_f_isSortingEnabled_c0);
  methods += new qt_gsi::GenericMethod ("item", "@brief Method QTableWidgetItem *QTableWidget::item(int row, int column)\n", true, &_init_f_item_c1426, &_call_f_item_c1426);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Method QTableWidgetItem *QTableWidget::itemAt(const QPoint &p)\n", true, &_init_f_itemAt_c1916, &_call_f_itemAt_c1916);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Method QTableWidgetItem *QTableWidget::itemAt(int x, int y)\n", true, &_init_f_itemAt_c1426, &_call_f_itemAt_c1426);
  methods += new qt_gsi::GenericMethod (":itemPrototype", "@brief Method const QTableWidgetItem *QTableWidget::itemPrototype()\n", true, &_init_f_itemPrototype_c0, &_call_f_itemPrototype_c0);
  methods += new qt_gsi::GenericMethod ("openPersistentEditor", "@brief Method void QTableWidget::openPersistentEditor(QTableWidgetItem *item)\n", false, &_init_f_openPersistentEditor_2202, &_call_f_openPersistentEditor_2202);
  methods += new qt_gsi::GenericMethod ("removeCellWidget", "@brief Method void QTableWidget::removeCellWidget(int row, int column)\n", false, &_init_f_removeCellWidget_1426, &_call_f_removeCellWidget_1426);
  methods += new qt_gsi::GenericMethod ("removeColumn", "@brief Method void QTableWidget::removeColumn(int column)\n", false, &_init_f_removeColumn_767, &_call_f_removeColumn_767);
  methods += new qt_gsi::GenericMethod ("removeRow", "@brief Method void QTableWidget::removeRow(int row)\n", false, &_init_f_removeRow_767, &_call_f_removeRow_767);
  methods += new qt_gsi::GenericMethod ("row", "@brief Method int QTableWidget::row(const QTableWidgetItem *item)\n", true, &_init_f_row_c2897, &_call_f_row_c2897);
  methods += new qt_gsi::GenericMethod (":rowCount", "@brief Method int QTableWidget::rowCount()\n", true, &_init_f_rowCount_c0, &_call_f_rowCount_c0);
  methods += new qt_gsi::GenericMethod ("scrollToItem", "@brief Method void QTableWidget::scrollToItem(const QTableWidgetItem *item, QAbstractItemView::ScrollHint hint)\n", false, &_init_f_scrollToItem_6078, &_call_f_scrollToItem_6078);
  methods += new qt_gsi::GenericMethod ("selectedItems", "@brief Method QList<QTableWidgetItem*> QTableWidget::selectedItems()\n", false, &_init_f_selectedItems_0, &_call_f_selectedItems_0);
  methods += new qt_gsi::GenericMethod ("selectedRanges", "@brief Method QList<QTableWidgetSelectionRange> QTableWidget::selectedRanges()\n", true, &_init_f_selectedRanges_c0, &_call_f_selectedRanges_c0);
  methods += new qt_gsi::GenericMethod ("setCellWidget", "@brief Method void QTableWidget::setCellWidget(int row, int column, QWidget *widget)\n", false, &_init_f_setCellWidget_2633, &_call_f_setCellWidget_2633);
  methods += new qt_gsi::GenericMethod ("setColumnCount|columnCount=", "@brief Method void QTableWidget::setColumnCount(int columns)\n", false, &_init_f_setColumnCount_767, &_call_f_setColumnCount_767);
  methods += new qt_gsi::GenericMethod ("setCurrentCell", "@brief Method void QTableWidget::setCurrentCell(int row, int column)\n", false, &_init_f_setCurrentCell_1426, &_call_f_setCurrentCell_1426);
  methods += new qt_gsi::GenericMethod ("setCurrentCell", "@brief Method void QTableWidget::setCurrentCell(int row, int column, QFlags<QItemSelectionModel::SelectionFlag> command)\n", false, &_init_f_setCurrentCell_5789, &_call_f_setCurrentCell_5789);
  methods += new qt_gsi::GenericMethod ("setCurrentItem|currentItem=", "@brief Method void QTableWidget::setCurrentItem(QTableWidgetItem *item)\n", false, &_init_f_setCurrentItem_2202, &_call_f_setCurrentItem_2202);
  methods += new qt_gsi::GenericMethod ("setCurrentItem", "@brief Method void QTableWidget::setCurrentItem(QTableWidgetItem *item, QFlags<QItemSelectionModel::SelectionFlag> command)\n", false, &_init_f_setCurrentItem_6565, &_call_f_setCurrentItem_6565);
  methods += new qt_gsi::GenericMethod ("setHorizontalHeaderItem", "@brief Method void QTableWidget::setHorizontalHeaderItem(int column, QTableWidgetItem *item)\n", false, &_init_f_setHorizontalHeaderItem_2861, &_call_f_setHorizontalHeaderItem_2861);
  methods += new qt_gsi::GenericMethod ("setHorizontalHeaderLabels", "@brief Method void QTableWidget::setHorizontalHeaderLabels(const QStringList &labels)\n", false, &_init_f_setHorizontalHeaderLabels_2437, &_call_f_setHorizontalHeaderLabels_2437);
  methods += new qt_gsi::GenericMethod ("setItem", "@brief Method void QTableWidget::setItem(int row, int column, QTableWidgetItem *item)\n", false, &_init_f_setItem_3520, &_call_f_setItem_3520);
  methods += new qt_gsi::GenericMethod ("setItemPrototype|itemPrototype=", "@brief Method void QTableWidget::setItemPrototype(const QTableWidgetItem *item)\n", false, &_init_f_setItemPrototype_2897, &_call_f_setItemPrototype_2897);
  methods += new qt_gsi::GenericMethod ("setItemSelected", "@brief Method void QTableWidget::setItemSelected(const QTableWidgetItem *item, bool select)\n", false, &_init_f_setItemSelected_3653, &_call_f_setItemSelected_3653);
  methods += new qt_gsi::GenericMethod ("setRangeSelected", "@brief Method void QTableWidget::setRangeSelected(const QTableWidgetSelectionRange &range, bool select)\n", false, &_init_f_setRangeSelected_4677, &_call_f_setRangeSelected_4677);
  methods += new qt_gsi::GenericMethod ("setRowCount|rowCount=", "@brief Method void QTableWidget::setRowCount(int rows)\n", false, &_init_f_setRowCount_767, &_call_f_setRowCount_767);
  methods += new qt_gsi::GenericMethod ("setSortingEnabled|sortingEnabled=", "@brief Method void QTableWidget::setSortingEnabled(bool enable)\n", false, &_init_f_setSortingEnabled_864, &_call_f_setSortingEnabled_864);
  methods += new qt_gsi::GenericMethod ("setVerticalHeaderItem", "@brief Method void QTableWidget::setVerticalHeaderItem(int row, QTableWidgetItem *item)\n", false, &_init_f_setVerticalHeaderItem_2861, &_call_f_setVerticalHeaderItem_2861);
  methods += new qt_gsi::GenericMethod ("setVerticalHeaderLabels", "@brief Method void QTableWidget::setVerticalHeaderLabels(const QStringList &labels)\n", false, &_init_f_setVerticalHeaderLabels_2437, &_call_f_setVerticalHeaderLabels_2437);
  methods += new qt_gsi::GenericMethod ("sortItems", "@brief Method void QTableWidget::sortItems(int column, Qt::SortOrder order)\n", false, &_init_f_sortItems_2340, &_call_f_sortItems_2340);
  methods += new qt_gsi::GenericMethod ("takeHorizontalHeaderItem", "@brief Method QTableWidgetItem *QTableWidget::takeHorizontalHeaderItem(int column)\n", false, &_init_f_takeHorizontalHeaderItem_767, &_call_f_takeHorizontalHeaderItem_767);
  methods += new qt_gsi::GenericMethod ("takeItem", "@brief Method QTableWidgetItem *QTableWidget::takeItem(int row, int column)\n", false, &_init_f_takeItem_1426, &_call_f_takeItem_1426);
  methods += new qt_gsi::GenericMethod ("takeVerticalHeaderItem", "@brief Method QTableWidgetItem *QTableWidget::takeVerticalHeaderItem(int row)\n", false, &_init_f_takeVerticalHeaderItem_767, &_call_f_takeVerticalHeaderItem_767);
  methods += new qt_gsi::GenericMethod ("verticalHeaderItem", "@brief Method QTableWidgetItem *QTableWidget::verticalHeaderItem(int row)\n", true, &_init_f_verticalHeaderItem_c767, &_call_f_verticalHeaderItem_c767);
  methods += new qt_gsi::GenericMethod ("visualColumn", "@brief Method int QTableWidget::visualColumn(int logicalColumn)\n", true, &_init_f_visualColumn_c767, &_call_f_visualColumn_c767);
  methods += new qt_gsi::GenericMethod ("visualItemRect", "@brief Method QRect QTableWidget::visualItemRect(const QTableWidgetItem *item)\n", true, &_init_f_visualItemRect_c2897, &_call_f_visualItemRect_c2897);
  methods += new qt_gsi::GenericMethod ("visualRow", "@brief Method int QTableWidget::visualRow(int logicalRow)\n", true, &_init_f_visualRow_c767, &_call_f_visualRow_c767);
  methods += gsi::qt_signal<const QModelIndex & > ("activated(const QModelIndex &)", "activated", gsi::arg("index"), "@brief Signal declaration for QTableWidget::activated(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, int > ("cellActivated(int, int)", "cellActivated", gsi::arg("row"), gsi::arg("column"), "@brief Signal declaration for QTableWidget::cellActivated(int row, int column)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, int > ("cellChanged(int, int)", "cellChanged", gsi::arg("row"), gsi::arg("column"), "@brief Signal declaration for QTableWidget::cellChanged(int row, int column)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, int > ("cellClicked(int, int)", "cellClicked", gsi::arg("row"), gsi::arg("column"), "@brief Signal declaration for QTableWidget::cellClicked(int row, int column)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, int > ("cellDoubleClicked(int, int)", "cellDoubleClicked", gsi::arg("row"), gsi::arg("column"), "@brief Signal declaration for QTableWidget::cellDoubleClicked(int row, int column)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, int > ("cellEntered(int, int)", "cellEntered", gsi::arg("row"), gsi::arg("column"), "@brief Signal declaration for QTableWidget::cellEntered(int row, int column)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, int > ("cellPressed(int, int)", "cellPressed", gsi::arg("row"), gsi::arg("column"), "@brief Signal declaration for QTableWidget::cellPressed(int row, int column)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("clicked(const QModelIndex &)", "clicked", gsi::arg("index"), "@brief Signal declaration for QTableWidget::clicked(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, int, int, int > ("currentCellChanged(int, int, int, int)", "currentCellChanged", gsi::arg("currentRow"), gsi::arg("currentColumn"), gsi::arg("previousRow"), gsi::arg("previousColumn"), "@brief Signal declaration for QTableWidget::currentCellChanged(int currentRow, int currentColumn, int previousRow, int previousColumn)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QTableWidgetItem *, QTableWidgetItem * > ("currentItemChanged(QTableWidgetItem *, QTableWidgetItem *)", "currentItemChanged", gsi::arg("current"), gsi::arg("previous"), "@brief Signal declaration for QTableWidget::currentItemChanged(QTableWidgetItem *current, QTableWidgetItem *previous)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QTableWidget::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QTableWidget::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("doubleClicked(const QModelIndex &)", "doubleClicked", gsi::arg("index"), "@brief Signal declaration for QTableWidget::doubleClicked(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("entered(const QModelIndex &)", "entered", gsi::arg("index"), "@brief Signal declaration for QTableWidget::entered(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QTableWidgetItem * > ("itemActivated(QTableWidgetItem *)", "itemActivated", gsi::arg("item"), "@brief Signal declaration for QTableWidget::itemActivated(QTableWidgetItem *item)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QTableWidgetItem * > ("itemChanged(QTableWidgetItem *)", "itemChanged", gsi::arg("item"), "@brief Signal declaration for QTableWidget::itemChanged(QTableWidgetItem *item)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QTableWidgetItem * > ("itemClicked(QTableWidgetItem *)", "itemClicked", gsi::arg("item"), "@brief Signal declaration for QTableWidget::itemClicked(QTableWidgetItem *item)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QTableWidgetItem * > ("itemDoubleClicked(QTableWidgetItem *)", "itemDoubleClicked", gsi::arg("item"), "@brief Signal declaration for QTableWidget::itemDoubleClicked(QTableWidgetItem *item)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QTableWidgetItem * > ("itemEntered(QTableWidgetItem *)", "itemEntered", gsi::arg("item"), "@brief Signal declaration for QTableWidget::itemEntered(QTableWidgetItem *item)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QTableWidgetItem * > ("itemPressed(QTableWidgetItem *)", "itemPressed", gsi::arg("item"), "@brief Signal declaration for QTableWidget::itemPressed(QTableWidgetItem *item)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("itemSelectionChanged()", "itemSelectionChanged", "@brief Signal declaration for QTableWidget::itemSelectionChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("pressed(const QModelIndex &)", "pressed", gsi::arg("index"), "@brief Signal declaration for QTableWidget::pressed(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("viewportEntered()", "viewportEntered", "@brief Signal declaration for QTableWidget::viewportEntered()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTableWidget::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTableWidget::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTableWidget::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTableWidget::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QTableView> &qtdecl_QTableView ();

qt_gsi::QtNativeClass<QTableWidget> decl_QTableWidget (qtdecl_QTableView (), "QtGui", "QTableWidget_Native",
  methods_QTableWidget (),
  "@hide\n@alias QTableWidget");

GSI_QTGUI_PUBLIC gsi::Class<QTableWidget> &qtdecl_QTableWidget () { return decl_QTableWidget; }

}


class QTableWidget_Adaptor : public QTableWidget, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTableWidget_Adaptor();

  //  [adaptor ctor] QTableWidget::QTableWidget(QWidget *parent)
  QTableWidget_Adaptor() : QTableWidget()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTableWidget::QTableWidget(QWidget *parent)
  QTableWidget_Adaptor(QWidget *parent) : QTableWidget(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTableWidget::QTableWidget(int rows, int columns, QWidget *parent)
  QTableWidget_Adaptor(int rows, int columns) : QTableWidget(rows, columns)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTableWidget::QTableWidget(int rows, int columns, QWidget *parent)
  QTableWidget_Adaptor(int rows, int columns, QWidget *parent) : QTableWidget(rows, columns, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QTableWidget::columnCountChanged(int oldCount, int newCount)
  void fp_QTableWidget_columnCountChanged_1426 (int oldCount, int newCount) {
    QTableWidget::columnCountChanged(oldCount, newCount);
  }

  //  [expose] void QTableWidget::columnMoved(int column, int oldIndex, int newIndex)
  void fp_QTableWidget_columnMoved_2085 (int column, int oldIndex, int newIndex) {
    QTableWidget::columnMoved(column, oldIndex, newIndex);
  }

  //  [expose] void QTableWidget::columnResized(int column, int oldWidth, int newWidth)
  void fp_QTableWidget_columnResized_2085 (int column, int oldWidth, int newWidth) {
    QTableWidget::columnResized(column, oldWidth, newWidth);
  }

  //  [expose] void QTableWidget::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QTableWidget_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QTableWidget::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QTableWidget::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QTableWidget_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QTableWidget::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] QPoint QTableWidget::dirtyRegionOffset()
  QPoint fp_QTableWidget_dirtyRegionOffset_c0 () const {
    return QTableWidget::dirtyRegionOffset();
  }

  //  [expose] void QTableWidget::doAutoScroll()
  void fp_QTableWidget_doAutoScroll_0 () {
    QTableWidget::doAutoScroll();
  }

  //  [expose] void QTableWidget::drawFrame(QPainter *)
  void fp_QTableWidget_drawFrame_1426 (QPainter *arg1) {
    QTableWidget::drawFrame(arg1);
  }

  //  [expose] QAbstractItemView::DropIndicatorPosition QTableWidget::dropIndicatorPosition()
  unsigned int fp_QTableWidget_dropIndicatorPosition_c0 () const {
    return (unsigned int)(QTableWidget::dropIndicatorPosition());
  }

  //  [expose] void QTableWidget::executeDelayedItemsLayout()
  void fp_QTableWidget_executeDelayedItemsLayout_0 () {
    QTableWidget::executeDelayedItemsLayout();
  }

  //  [expose] bool QTableWidget::focusNextChild()
  bool fp_QTableWidget_focusNextChild_0 () {
    return QTableWidget::focusNextChild();
  }

  //  [expose] bool QTableWidget::focusPreviousChild()
  bool fp_QTableWidget_focusPreviousChild_0 () {
    return QTableWidget::focusPreviousChild();
  }

  //  [expose] int QTableWidget::horizontalStepsPerItem()
  int fp_QTableWidget_horizontalStepsPerItem_c0 () const {
    return QTableWidget::horizontalStepsPerItem();
  }

  //  [expose] QModelIndex QTableWidget::indexFromItem(QTableWidgetItem *item)
  QModelIndex fp_QTableWidget_indexFromItem_c2202 (QTableWidgetItem *item) const {
    return QTableWidget::indexFromItem(item);
  }

  //  [expose] QTableWidgetItem *QTableWidget::itemFromIndex(const QModelIndex &index)
  QTableWidgetItem * fp_QTableWidget_itemFromIndex_c2395 (const QModelIndex &index) const {
    return QTableWidget::itemFromIndex(index);
  }

  //  [expose] QList<QTableWidgetItem*> QTableWidget::items(const QMimeData *data)
  QList<QTableWidgetItem*> fp_QTableWidget_items_c2168 (const QMimeData *data) const {
    return QTableWidget::items(data);
  }

  //  [expose] int QTableWidget::receivers(const char *signal)
  int fp_QTableWidget_receivers_c1731 (const char *signal) const {
    return QTableWidget::receivers(signal);
  }

  //  [expose] void QTableWidget::resetInputContext()
  void fp_QTableWidget_resetInputContext_0 () {
    QTableWidget::resetInputContext();
  }

  //  [expose] void QTableWidget::rowCountChanged(int oldCount, int newCount)
  void fp_QTableWidget_rowCountChanged_1426 (int oldCount, int newCount) {
    QTableWidget::rowCountChanged(oldCount, newCount);
  }

  //  [expose] void QTableWidget::rowMoved(int row, int oldIndex, int newIndex)
  void fp_QTableWidget_rowMoved_2085 (int row, int oldIndex, int newIndex) {
    QTableWidget::rowMoved(row, oldIndex, newIndex);
  }

  //  [expose] void QTableWidget::rowResized(int row, int oldHeight, int newHeight)
  void fp_QTableWidget_rowResized_2085 (int row, int oldHeight, int newHeight) {
    QTableWidget::rowResized(row, oldHeight, newHeight);
  }

  //  [expose] void QTableWidget::scheduleDelayedItemsLayout()
  void fp_QTableWidget_scheduleDelayedItemsLayout_0 () {
    QTableWidget::scheduleDelayedItemsLayout();
  }

  //  [expose] void QTableWidget::scrollDirtyRegion(int dx, int dy)
  void fp_QTableWidget_scrollDirtyRegion_1426 (int dx, int dy) {
    QTableWidget::scrollDirtyRegion(dx, dy);
  }

  //  [expose] QObject *QTableWidget::sender()
  QObject * fp_QTableWidget_sender_c0 () const {
    return QTableWidget::sender();
  }

  //  [expose] void QTableWidget::setDirtyRegion(const QRegion &region)
  void fp_QTableWidget_setDirtyRegion_2006 (const QRegion &region) {
    QTableWidget::setDirtyRegion(region);
  }

  //  [expose] void QTableWidget::setHorizontalStepsPerItem(int steps)
  void fp_QTableWidget_setHorizontalStepsPerItem_767 (int steps) {
    QTableWidget::setHorizontalStepsPerItem(steps);
  }

  //  [expose] void QTableWidget::setState(QAbstractItemView::State state)
  void fp_QTableWidget_setState_2776 (unsigned int state) {
    QTableWidget::setState(QAbstractItemView::State(state));
  }

  //  [expose] void QTableWidget::setVerticalStepsPerItem(int steps)
  void fp_QTableWidget_setVerticalStepsPerItem_767 (int steps) {
    QTableWidget::setVerticalStepsPerItem(steps);
  }

  //  [expose] void QTableWidget::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QTableWidget_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QTableWidget::setViewportMargins(left, top, right, bottom);
  }

  //  [expose] void QTableWidget::setViewportMargins(const QMargins &margins)
  void fp_QTableWidget_setViewportMargins_2115 (const QMargins &margins) {
    QTableWidget::setViewportMargins(margins);
  }

  //  [expose] void QTableWidget::setupViewport(QWidget *viewport)
  void fp_QTableWidget_setupViewport_1315 (QWidget *viewport) {
    QTableWidget::setupViewport(viewport);
  }

  //  [expose] void QTableWidget::startAutoScroll()
  void fp_QTableWidget_startAutoScroll_0 () {
    QTableWidget::startAutoScroll();
  }

  //  [expose] QAbstractItemView::State QTableWidget::state()
  unsigned int fp_QTableWidget_state_c0 () const {
    return (unsigned int)(QTableWidget::state());
  }

  //  [expose] void QTableWidget::stopAutoScroll()
  void fp_QTableWidget_stopAutoScroll_0 () {
    QTableWidget::stopAutoScroll();
  }

  //  [expose] void QTableWidget::updateMicroFocus()
  void fp_QTableWidget_updateMicroFocus_0 () {
    QTableWidget::updateMicroFocus();
  }

  //  [expose] int QTableWidget::verticalStepsPerItem()
  int fp_QTableWidget_verticalStepsPerItem_c0 () const {
    return QTableWidget::verticalStepsPerItem();
  }

  //  [adaptor impl] void QTableWidget::doItemsLayout()
  void cbs_doItemsLayout_0_0()
  {
    QTableWidget::doItemsLayout();
  }

  virtual void doItemsLayout()
  {
    if (cb_doItemsLayout_0_0.can_issue()) {
      cb_doItemsLayout_0_0.issue<QTableWidget_Adaptor>(&QTableWidget_Adaptor::cbs_doItemsLayout_0_0);
    } else {
      QTableWidget::doItemsLayout();
    }
  }

  //  [adaptor impl] bool QTableWidget::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QTableWidget::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTableWidget_Adaptor, bool, QObject *, QEvent *>(&QTableWidget_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QTableWidget::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QTableWidget::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QTableWidget::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QTableWidget_Adaptor, int, int>(&QTableWidget_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QTableWidget::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QModelIndex QTableWidget::indexAt(const QPoint &p)
  QModelIndex cbs_indexAt_c1916_0(const QPoint &p) const
  {
    return QTableWidget::indexAt(p);
  }

  virtual QModelIndex indexAt(const QPoint &p) const
  {
    if (cb_indexAt_c1916_0.can_issue()) {
      return cb_indexAt_c1916_0.issue<QTableWidget_Adaptor, QModelIndex, const QPoint &>(&QTableWidget_Adaptor::cbs_indexAt_c1916_0, p);
    } else {
      return QTableWidget::indexAt(p);
    }
  }

  //  [adaptor impl] QVariant QTableWidget::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QTableWidget::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QTableWidget_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QTableWidget_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QTableWidget::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] void QTableWidget::keyboardSearch(const QString &search)
  void cbs_keyboardSearch_2025_0(const QString &search)
  {
    QTableWidget::keyboardSearch(search);
  }

  virtual void keyboardSearch(const QString &search)
  {
    if (cb_keyboardSearch_2025_0.can_issue()) {
      cb_keyboardSearch_2025_0.issue<QTableWidget_Adaptor, const QString &>(&QTableWidget_Adaptor::cbs_keyboardSearch_2025_0, search);
    } else {
      QTableWidget::keyboardSearch(search);
    }
  }

  //  [adaptor impl] QSize QTableWidget::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QTableWidget::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QTableWidget_Adaptor, QSize>(&QTableWidget_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QTableWidget::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QTableWidget::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QTableWidget::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QTableWidget_Adaptor, QPaintEngine *>(&QTableWidget_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QTableWidget::paintEngine();
    }
  }

  //  [adaptor impl] void QTableWidget::reset()
  void cbs_reset_0_0()
  {
    QTableWidget::reset();
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QTableWidget_Adaptor>(&QTableWidget_Adaptor::cbs_reset_0_0);
    } else {
      QTableWidget::reset();
    }
  }

  //  [adaptor impl] void QTableWidget::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  void cbs_scrollTo_5576_1(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & hint)
  {
    QTableWidget::scrollTo(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollHint>(hint).cref());
  }

  virtual void scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  {
    if (cb_scrollTo_5576_1.can_issue()) {
      cb_scrollTo_5576_1.issue<QTableWidget_Adaptor, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type &>(&QTableWidget_Adaptor::cbs_scrollTo_5576_1, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::ScrollHint>(hint));
    } else {
      QTableWidget::scrollTo(index, hint);
    }
  }

  //  [adaptor impl] void QTableWidget::selectAll()
  void cbs_selectAll_0_0()
  {
    QTableWidget::selectAll();
  }

  virtual void selectAll()
  {
    if (cb_selectAll_0_0.can_issue()) {
      cb_selectAll_0_0.issue<QTableWidget_Adaptor>(&QTableWidget_Adaptor::cbs_selectAll_0_0);
    } else {
      QTableWidget::selectAll();
    }
  }

  //  [adaptor impl] void QTableWidget::setRootIndex(const QModelIndex &index)
  void cbs_setRootIndex_2395_0(const QModelIndex &index)
  {
    QTableWidget::setRootIndex(index);
  }

  virtual void setRootIndex(const QModelIndex &index)
  {
    if (cb_setRootIndex_2395_0.can_issue()) {
      cb_setRootIndex_2395_0.issue<QTableWidget_Adaptor, const QModelIndex &>(&QTableWidget_Adaptor::cbs_setRootIndex_2395_0, index);
    } else {
      QTableWidget::setRootIndex(index);
    }
  }

  //  [adaptor impl] void QTableWidget::setSelectionModel(QItemSelectionModel *selectionModel)
  void cbs_setSelectionModel_2533_0(QItemSelectionModel *selectionModel)
  {
    QTableWidget::setSelectionModel(selectionModel);
  }

  virtual void setSelectionModel(QItemSelectionModel *selectionModel)
  {
    if (cb_setSelectionModel_2533_0.can_issue()) {
      cb_setSelectionModel_2533_0.issue<QTableWidget_Adaptor, QItemSelectionModel *>(&QTableWidget_Adaptor::cbs_setSelectionModel_2533_0, selectionModel);
    } else {
      QTableWidget::setSelectionModel(selectionModel);
    }
  }

  //  [adaptor impl] void QTableWidget::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QTableWidget::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QTableWidget_Adaptor, bool>(&QTableWidget_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QTableWidget::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QTableWidget::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QTableWidget::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QTableWidget_Adaptor, QSize>(&QTableWidget_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QTableWidget::sizeHint();
    }
  }

  //  [adaptor impl] QRect QTableWidget::visualRect(const QModelIndex &index)
  QRect cbs_visualRect_c2395_0(const QModelIndex &index) const
  {
    return QTableWidget::visualRect(index);
  }

  virtual QRect visualRect(const QModelIndex &index) const
  {
    if (cb_visualRect_c2395_0.can_issue()) {
      return cb_visualRect_c2395_0.issue<QTableWidget_Adaptor, QRect, const QModelIndex &>(&QTableWidget_Adaptor::cbs_visualRect_c2395_0, index);
    } else {
      return QTableWidget::visualRect(index);
    }
  }

  //  [adaptor impl] void QTableWidget::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QTableWidget::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QTableWidget_Adaptor, QActionEvent *>(&QTableWidget_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QTableWidget::actionEvent(arg1);
    }
  }

  //  [emitter impl] void QTableWidget::activated(const QModelIndex &index)
  void emitter_QTableWidget_activated_2395(const QModelIndex &index)
  {
    emit QTableWidget::activated(index);
  }

  //  [emitter impl] void QTableWidget::cellActivated(int row, int column)
  void emitter_QTableWidget_cellActivated_1426(int row, int column)
  {
    emit QTableWidget::cellActivated(row, column);
  }

  //  [emitter impl] void QTableWidget::cellChanged(int row, int column)
  void emitter_QTableWidget_cellChanged_1426(int row, int column)
  {
    emit QTableWidget::cellChanged(row, column);
  }

  //  [emitter impl] void QTableWidget::cellClicked(int row, int column)
  void emitter_QTableWidget_cellClicked_1426(int row, int column)
  {
    emit QTableWidget::cellClicked(row, column);
  }

  //  [emitter impl] void QTableWidget::cellDoubleClicked(int row, int column)
  void emitter_QTableWidget_cellDoubleClicked_1426(int row, int column)
  {
    emit QTableWidget::cellDoubleClicked(row, column);
  }

  //  [emitter impl] void QTableWidget::cellEntered(int row, int column)
  void emitter_QTableWidget_cellEntered_1426(int row, int column)
  {
    emit QTableWidget::cellEntered(row, column);
  }

  //  [emitter impl] void QTableWidget::cellPressed(int row, int column)
  void emitter_QTableWidget_cellPressed_1426(int row, int column)
  {
    emit QTableWidget::cellPressed(row, column);
  }

  //  [adaptor impl] void QTableWidget::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QTableWidget::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QTableWidget_Adaptor, QEvent *>(&QTableWidget_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QTableWidget::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QTableWidget::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QTableWidget::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTableWidget_Adaptor, QChildEvent *>(&QTableWidget_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QTableWidget::childEvent(arg1);
    }
  }

  //  [emitter impl] void QTableWidget::clicked(const QModelIndex &index)
  void emitter_QTableWidget_clicked_2395(const QModelIndex &index)
  {
    emit QTableWidget::clicked(index);
  }

  //  [adaptor impl] void QTableWidget::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  void cbs_closeEditor_4926_0(QWidget *editor, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & hint)
  {
    QTableWidget::closeEditor(editor, qt_gsi::QtToCppAdaptor<QAbstractItemDelegate::EndEditHint>(hint).cref());
  }

  virtual void closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  {
    if (cb_closeEditor_4926_0.can_issue()) {
      cb_closeEditor_4926_0.issue<QTableWidget_Adaptor, QWidget *, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type &>(&QTableWidget_Adaptor::cbs_closeEditor_4926_0, editor, qt_gsi::CppToQtAdaptor<QAbstractItemDelegate::EndEditHint>(hint));
    } else {
      QTableWidget::closeEditor(editor, hint);
    }
  }

  //  [adaptor impl] void QTableWidget::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QTableWidget::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QTableWidget_Adaptor, QCloseEvent *>(&QTableWidget_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QTableWidget::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QTableWidget::commitData(QWidget *editor)
  void cbs_commitData_1315_0(QWidget *editor)
  {
    QTableWidget::commitData(editor);
  }

  virtual void commitData(QWidget *editor)
  {
    if (cb_commitData_1315_0.can_issue()) {
      cb_commitData_1315_0.issue<QTableWidget_Adaptor, QWidget *>(&QTableWidget_Adaptor::cbs_commitData_1315_0, editor);
    } else {
      QTableWidget::commitData(editor);
    }
  }

  //  [adaptor impl] void QTableWidget::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QTableWidget::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QTableWidget_Adaptor, QContextMenuEvent *>(&QTableWidget_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QTableWidget::contextMenuEvent(arg1);
    }
  }

  //  [emitter impl] void QTableWidget::currentCellChanged(int currentRow, int currentColumn, int previousRow, int previousColumn)
  void emitter_QTableWidget_currentCellChanged_2744(int currentRow, int currentColumn, int previousRow, int previousColumn)
  {
    emit QTableWidget::currentCellChanged(currentRow, currentColumn, previousRow, previousColumn);
  }

  //  [adaptor impl] void QTableWidget::currentChanged(const QModelIndex &current, const QModelIndex &previous)
  void cbs_currentChanged_4682_0(const QModelIndex &current, const QModelIndex &previous)
  {
    QTableWidget::currentChanged(current, previous);
  }

  virtual void currentChanged(const QModelIndex &current, const QModelIndex &previous)
  {
    if (cb_currentChanged_4682_0.can_issue()) {
      cb_currentChanged_4682_0.issue<QTableWidget_Adaptor, const QModelIndex &, const QModelIndex &>(&QTableWidget_Adaptor::cbs_currentChanged_4682_0, current, previous);
    } else {
      QTableWidget::currentChanged(current, previous);
    }
  }

  //  [emitter impl] void QTableWidget::currentItemChanged(QTableWidgetItem *current, QTableWidgetItem *previous)
  void emitter_QTableWidget_currentItemChanged_4296(QTableWidgetItem *current, QTableWidgetItem *previous)
  {
    emit QTableWidget::currentItemChanged(current, previous);
  }

  //  [emitter impl] void QTableWidget::customContextMenuRequested(const QPoint &pos)
  void emitter_QTableWidget_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QTableWidget::customContextMenuRequested(pos);
  }

  //  [adaptor impl] void QTableWidget::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QTableWidget::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTableWidget_Adaptor, QEvent *>(&QTableWidget_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QTableWidget::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QTableWidget::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  void cbs_dataChanged_4682_0(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  {
    QTableWidget::dataChanged(topLeft, bottomRight);
  }

  virtual void dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  {
    if (cb_dataChanged_4682_0.can_issue()) {
      cb_dataChanged_4682_0.issue<QTableWidget_Adaptor, const QModelIndex &, const QModelIndex &>(&QTableWidget_Adaptor::cbs_dataChanged_4682_0, topLeft, bottomRight);
    } else {
      QTableWidget::dataChanged(topLeft, bottomRight);
    }
  }

  //  [emitter impl] void QTableWidget::destroyed(QObject *)
  void emitter_QTableWidget_destroyed_1302(QObject *arg1)
  {
    emit QTableWidget::destroyed(arg1);
  }

  //  [adaptor impl] void QTableWidget::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QTableWidget::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QTableWidget_Adaptor, const char *>(&QTableWidget_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QTableWidget::disconnectNotify(signal);
    }
  }

  //  [emitter impl] void QTableWidget::doubleClicked(const QModelIndex &index)
  void emitter_QTableWidget_doubleClicked_2395(const QModelIndex &index)
  {
    emit QTableWidget::doubleClicked(index);
  }

  //  [adaptor impl] void QTableWidget::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QTableWidget::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QTableWidget_Adaptor, QDragEnterEvent *>(&QTableWidget_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QTableWidget::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QTableWidget::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QTableWidget::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QTableWidget_Adaptor, QDragLeaveEvent *>(&QTableWidget_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QTableWidget::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QTableWidget::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QTableWidget::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QTableWidget_Adaptor, QDragMoveEvent *>(&QTableWidget_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QTableWidget::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QTableWidget::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QTableWidget::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QTableWidget_Adaptor, QDropEvent *>(&QTableWidget_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QTableWidget::dropEvent(event);
    }
  }

  //  [adaptor impl] bool QTableWidget::dropMimeData(int row, int column, const QMimeData *data, Qt::DropAction action)
  bool cbs_dropMimeData_5138_0(int row, int column, const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action)
  {
    return QTableWidget::dropMimeData(row, column, data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref());
  }

  virtual bool dropMimeData(int row, int column, const QMimeData *data, Qt::DropAction action)
  {
    if (cb_dropMimeData_5138_0.can_issue()) {
      return cb_dropMimeData_5138_0.issue<QTableWidget_Adaptor, bool, int, int, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &>(&QTableWidget_Adaptor::cbs_dropMimeData_5138_0, row, column, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action));
    } else {
      return QTableWidget::dropMimeData(row, column, data, action);
    }
  }

  //  [adaptor impl] bool QTableWidget::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  bool cbs_edit_6773_0(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & trigger, QEvent *event)
  {
    return QTableWidget::edit(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::EditTrigger>(trigger).cref(), event);
  }

  virtual bool edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  {
    if (cb_edit_6773_0.can_issue()) {
      return cb_edit_6773_0.issue<QTableWidget_Adaptor, bool, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type &, QEvent *>(&QTableWidget_Adaptor::cbs_edit_6773_0, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::EditTrigger>(trigger), event);
    } else {
      return QTableWidget::edit(index, trigger, event);
    }
  }

  //  [adaptor impl] void QTableWidget::editorDestroyed(QObject *editor)
  void cbs_editorDestroyed_1302_0(QObject *editor)
  {
    QTableWidget::editorDestroyed(editor);
  }

  virtual void editorDestroyed(QObject *editor)
  {
    if (cb_editorDestroyed_1302_0.can_issue()) {
      cb_editorDestroyed_1302_0.issue<QTableWidget_Adaptor, QObject *>(&QTableWidget_Adaptor::cbs_editorDestroyed_1302_0, editor);
    } else {
      QTableWidget::editorDestroyed(editor);
    }
  }

  //  [adaptor impl] void QTableWidget::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QTableWidget::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QTableWidget_Adaptor, bool>(&QTableWidget_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QTableWidget::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QTableWidget::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QTableWidget::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QTableWidget_Adaptor, QEvent *>(&QTableWidget_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QTableWidget::enterEvent(arg1);
    }
  }

  //  [emitter impl] void QTableWidget::entered(const QModelIndex &index)
  void emitter_QTableWidget_entered_2395(const QModelIndex &index)
  {
    emit QTableWidget::entered(index);
  }

  //  [adaptor impl] bool QTableWidget::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QTableWidget::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTableWidget_Adaptor, bool, QEvent *>(&QTableWidget_Adaptor::cbs_event_1217_0, e);
    } else {
      return QTableWidget::event(e);
    }
  }

  //  [adaptor impl] void QTableWidget::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QTableWidget::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QTableWidget_Adaptor, QFocusEvent *>(&QTableWidget_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QTableWidget::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QTableWidget::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QTableWidget::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QTableWidget_Adaptor, bool, bool>(&QTableWidget_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QTableWidget::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QTableWidget::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QTableWidget::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QTableWidget_Adaptor, QFocusEvent *>(&QTableWidget_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QTableWidget::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QTableWidget::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QTableWidget::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QTableWidget_Adaptor, const QFont &>(&QTableWidget_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QTableWidget::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QTableWidget::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QTableWidget::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QTableWidget_Adaptor, QHideEvent *>(&QTableWidget_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QTableWidget::hideEvent(arg1);
    }
  }

  //  [adaptor impl] int QTableWidget::horizontalOffset()
  int cbs_horizontalOffset_c0_0() const
  {
    return QTableWidget::horizontalOffset();
  }

  virtual int horizontalOffset() const
  {
    if (cb_horizontalOffset_c0_0.can_issue()) {
      return cb_horizontalOffset_c0_0.issue<QTableWidget_Adaptor, int>(&QTableWidget_Adaptor::cbs_horizontalOffset_c0_0);
    } else {
      return QTableWidget::horizontalOffset();
    }
  }

  //  [adaptor impl] void QTableWidget::horizontalScrollbarAction(int action)
  void cbs_horizontalScrollbarAction_767_0(int action)
  {
    QTableWidget::horizontalScrollbarAction(action);
  }

  virtual void horizontalScrollbarAction(int action)
  {
    if (cb_horizontalScrollbarAction_767_0.can_issue()) {
      cb_horizontalScrollbarAction_767_0.issue<QTableWidget_Adaptor, int>(&QTableWidget_Adaptor::cbs_horizontalScrollbarAction_767_0, action);
    } else {
      QTableWidget::horizontalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QTableWidget::horizontalScrollbarValueChanged(int value)
  void cbs_horizontalScrollbarValueChanged_767_0(int value)
  {
    QTableWidget::horizontalScrollbarValueChanged(value);
  }

  virtual void horizontalScrollbarValueChanged(int value)
  {
    if (cb_horizontalScrollbarValueChanged_767_0.can_issue()) {
      cb_horizontalScrollbarValueChanged_767_0.issue<QTableWidget_Adaptor, int>(&QTableWidget_Adaptor::cbs_horizontalScrollbarValueChanged_767_0, value);
    } else {
      QTableWidget::horizontalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] void QTableWidget::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QTableWidget::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QTableWidget_Adaptor, QInputMethodEvent *>(&QTableWidget_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QTableWidget::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] bool QTableWidget::isIndexHidden(const QModelIndex &index)
  bool cbs_isIndexHidden_c2395_0(const QModelIndex &index) const
  {
    return QTableWidget::isIndexHidden(index);
  }

  virtual bool isIndexHidden(const QModelIndex &index) const
  {
    if (cb_isIndexHidden_c2395_0.can_issue()) {
      return cb_isIndexHidden_c2395_0.issue<QTableWidget_Adaptor, bool, const QModelIndex &>(&QTableWidget_Adaptor::cbs_isIndexHidden_c2395_0, index);
    } else {
      return QTableWidget::isIndexHidden(index);
    }
  }

  //  [emitter impl] void QTableWidget::itemActivated(QTableWidgetItem *item)
  void emitter_QTableWidget_itemActivated_2202(QTableWidgetItem *item)
  {
    emit QTableWidget::itemActivated(item);
  }

  //  [emitter impl] void QTableWidget::itemChanged(QTableWidgetItem *item)
  void emitter_QTableWidget_itemChanged_2202(QTableWidgetItem *item)
  {
    emit QTableWidget::itemChanged(item);
  }

  //  [emitter impl] void QTableWidget::itemClicked(QTableWidgetItem *item)
  void emitter_QTableWidget_itemClicked_2202(QTableWidgetItem *item)
  {
    emit QTableWidget::itemClicked(item);
  }

  //  [emitter impl] void QTableWidget::itemDoubleClicked(QTableWidgetItem *item)
  void emitter_QTableWidget_itemDoubleClicked_2202(QTableWidgetItem *item)
  {
    emit QTableWidget::itemDoubleClicked(item);
  }

  //  [emitter impl] void QTableWidget::itemEntered(QTableWidgetItem *item)
  void emitter_QTableWidget_itemEntered_2202(QTableWidgetItem *item)
  {
    emit QTableWidget::itemEntered(item);
  }

  //  [emitter impl] void QTableWidget::itemPressed(QTableWidgetItem *item)
  void emitter_QTableWidget_itemPressed_2202(QTableWidgetItem *item)
  {
    emit QTableWidget::itemPressed(item);
  }

  //  [emitter impl] void QTableWidget::itemSelectionChanged()
  void emitter_QTableWidget_itemSelectionChanged_0()
  {
    emit QTableWidget::itemSelectionChanged();
  }

  //  [adaptor impl] void QTableWidget::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QTableWidget::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QTableWidget_Adaptor, QKeyEvent *>(&QTableWidget_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QTableWidget::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QTableWidget::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QTableWidget::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QTableWidget_Adaptor, QKeyEvent *>(&QTableWidget_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QTableWidget::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QTableWidget::languageChange()
  void cbs_languageChange_0_0()
  {
    QTableWidget::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QTableWidget_Adaptor>(&QTableWidget_Adaptor::cbs_languageChange_0_0);
    } else {
      QTableWidget::languageChange();
    }
  }

  //  [adaptor impl] void QTableWidget::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QTableWidget::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QTableWidget_Adaptor, QEvent *>(&QTableWidget_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QTableWidget::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QTableWidget::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QTableWidget::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QTableWidget_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QTableWidget_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QTableWidget::metric(arg1);
    }
  }

  //  [adaptor impl] QMimeData *QTableWidget::mimeData(const QList<QTableWidgetItem*> items)
  QMimeData * cbs_mimeData_c3368_0(const QList<QTableWidgetItem*> items) const
  {
    return QTableWidget::mimeData(items);
  }

  virtual QMimeData * mimeData(const QList<QTableWidgetItem*> items) const
  {
    if (cb_mimeData_c3368_0.can_issue()) {
      return cb_mimeData_c3368_0.issue<QTableWidget_Adaptor, QMimeData *, const QList<QTableWidgetItem*> >(&QTableWidget_Adaptor::cbs_mimeData_c3368_0, items);
    } else {
      return QTableWidget::mimeData(items);
    }
  }

  //  [adaptor impl] QStringList QTableWidget::mimeTypes()
  QStringList cbs_mimeTypes_c0_0() const
  {
    return QTableWidget::mimeTypes();
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return cb_mimeTypes_c0_0.issue<QTableWidget_Adaptor, QStringList>(&QTableWidget_Adaptor::cbs_mimeTypes_c0_0);
    } else {
      return QTableWidget::mimeTypes();
    }
  }

  //  [adaptor impl] void QTableWidget::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QTableWidget::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QTableWidget_Adaptor, QMouseEvent *>(&QTableWidget_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QTableWidget::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QTableWidget::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QTableWidget::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QTableWidget_Adaptor, QMouseEvent *>(&QTableWidget_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QTableWidget::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QTableWidget::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QTableWidget::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QTableWidget_Adaptor, QMouseEvent *>(&QTableWidget_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QTableWidget::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QTableWidget::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QTableWidget::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QTableWidget_Adaptor, QMouseEvent *>(&QTableWidget_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QTableWidget::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] QModelIndex QTableWidget::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  QModelIndex cbs_moveCursor_6476_0(unsigned int cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  {
    return QTableWidget::moveCursor(QAbstractItemView::CursorAction(cursorAction), modifiers);
  }

  virtual QModelIndex moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  {
    if (cb_moveCursor_6476_0.can_issue()) {
      return cb_moveCursor_6476_0.issue<QTableWidget_Adaptor, QModelIndex, unsigned int, QFlags<Qt::KeyboardModifier> >(&QTableWidget_Adaptor::cbs_moveCursor_6476_0, (unsigned int)(cursorAction), modifiers);
    } else {
      return QTableWidget::moveCursor(cursorAction, modifiers);
    }
  }

  //  [adaptor impl] void QTableWidget::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QTableWidget::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QTableWidget_Adaptor, QMoveEvent *>(&QTableWidget_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QTableWidget::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QTableWidget::paintEvent(QPaintEvent *e)
  void cbs_paintEvent_1725_0(QPaintEvent *e)
  {
    QTableWidget::paintEvent(e);
  }

  virtual void paintEvent(QPaintEvent *e)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QTableWidget_Adaptor, QPaintEvent *>(&QTableWidget_Adaptor::cbs_paintEvent_1725_0, e);
    } else {
      QTableWidget::paintEvent(e);
    }
  }

  //  [adaptor impl] void QTableWidget::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QTableWidget::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QTableWidget_Adaptor, const QPalette &>(&QTableWidget_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QTableWidget::paletteChange(arg1);
    }
  }

  //  [emitter impl] void QTableWidget::pressed(const QModelIndex &index)
  void emitter_QTableWidget_pressed_2395(const QModelIndex &index)
  {
    emit QTableWidget::pressed(index);
  }

  //  [adaptor impl] void QTableWidget::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QTableWidget::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QTableWidget_Adaptor, QResizeEvent *>(&QTableWidget_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QTableWidget::resizeEvent(event);
    }
  }

  //  [adaptor impl] void QTableWidget::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  void cbs_rowsAboutToBeRemoved_3713_0(const QModelIndex &parent, int start, int end)
  {
    QTableWidget::rowsAboutToBeRemoved(parent, start, end);
  }

  virtual void rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsAboutToBeRemoved_3713_0.can_issue()) {
      cb_rowsAboutToBeRemoved_3713_0.issue<QTableWidget_Adaptor, const QModelIndex &, int, int>(&QTableWidget_Adaptor::cbs_rowsAboutToBeRemoved_3713_0, parent, start, end);
    } else {
      QTableWidget::rowsAboutToBeRemoved(parent, start, end);
    }
  }

  //  [adaptor impl] void QTableWidget::rowsInserted(const QModelIndex &parent, int start, int end)
  void cbs_rowsInserted_3713_0(const QModelIndex &parent, int start, int end)
  {
    QTableWidget::rowsInserted(parent, start, end);
  }

  virtual void rowsInserted(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsInserted_3713_0.can_issue()) {
      cb_rowsInserted_3713_0.issue<QTableWidget_Adaptor, const QModelIndex &, int, int>(&QTableWidget_Adaptor::cbs_rowsInserted_3713_0, parent, start, end);
    } else {
      QTableWidget::rowsInserted(parent, start, end);
    }
  }

  //  [adaptor impl] void QTableWidget::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QTableWidget::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QTableWidget_Adaptor, int, int>(&QTableWidget_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QTableWidget::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QTableWidget::selectedIndexes()
  QList<QModelIndex> cbs_selectedIndexes_c0_0() const
  {
    return QTableWidget::selectedIndexes();
  }

  virtual QList<QModelIndex> selectedIndexes() const
  {
    if (cb_selectedIndexes_c0_0.can_issue()) {
      return cb_selectedIndexes_c0_0.issue<QTableWidget_Adaptor, QList<QModelIndex> >(&QTableWidget_Adaptor::cbs_selectedIndexes_c0_0);
    } else {
      return QTableWidget::selectedIndexes();
    }
  }

  //  [adaptor impl] void QTableWidget::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  void cbs_selectionChanged_5346_0(const QItemSelection &selected, const QItemSelection &deselected)
  {
    QTableWidget::selectionChanged(selected, deselected);
  }

  virtual void selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  {
    if (cb_selectionChanged_5346_0.can_issue()) {
      cb_selectionChanged_5346_0.issue<QTableWidget_Adaptor, const QItemSelection &, const QItemSelection &>(&QTableWidget_Adaptor::cbs_selectionChanged_5346_0, selected, deselected);
    } else {
      QTableWidget::selectionChanged(selected, deselected);
    }
  }

  //  [adaptor impl] QFlags<QItemSelectionModel::SelectionFlag> QTableWidget::selectionCommand(const QModelIndex &index, const QEvent *event)
  QFlags<QItemSelectionModel::SelectionFlag> cbs_selectionCommand_c4199_1(const QModelIndex &index, const QEvent *event) const
  {
    return QTableWidget::selectionCommand(index, event);
  }

  virtual QFlags<QItemSelectionModel::SelectionFlag> selectionCommand(const QModelIndex &index, const QEvent *event) const
  {
    if (cb_selectionCommand_c4199_1.can_issue()) {
      return cb_selectionCommand_c4199_1.issue<QTableWidget_Adaptor, QFlags<QItemSelectionModel::SelectionFlag>, const QModelIndex &, const QEvent *>(&QTableWidget_Adaptor::cbs_selectionCommand_c4199_1, index, event);
    } else {
      return QTableWidget::selectionCommand(index, event);
    }
  }

  //  [adaptor impl] void QTableWidget::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  void cbs_setSelection_6155_0(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    QTableWidget::setSelection(rect, command);
  }

  virtual void setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    if (cb_setSelection_6155_0.can_issue()) {
      cb_setSelection_6155_0.issue<QTableWidget_Adaptor, const QRect &, QFlags<QItemSelectionModel::SelectionFlag> >(&QTableWidget_Adaptor::cbs_setSelection_6155_0, rect, command);
    } else {
      QTableWidget::setSelection(rect, command);
    }
  }

  //  [adaptor impl] void QTableWidget::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QTableWidget::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QTableWidget_Adaptor, QShowEvent *>(&QTableWidget_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QTableWidget::showEvent(arg1);
    }
  }

  //  [adaptor impl] int QTableWidget::sizeHintForColumn(int column)
  int cbs_sizeHintForColumn_c767_0(int column) const
  {
    return QTableWidget::sizeHintForColumn(column);
  }

  virtual int sizeHintForColumn(int column) const
  {
    if (cb_sizeHintForColumn_c767_0.can_issue()) {
      return cb_sizeHintForColumn_c767_0.issue<QTableWidget_Adaptor, int, int>(&QTableWidget_Adaptor::cbs_sizeHintForColumn_c767_0, column);
    } else {
      return QTableWidget::sizeHintForColumn(column);
    }
  }

  //  [adaptor impl] int QTableWidget::sizeHintForRow(int row)
  int cbs_sizeHintForRow_c767_0(int row) const
  {
    return QTableWidget::sizeHintForRow(row);
  }

  virtual int sizeHintForRow(int row) const
  {
    if (cb_sizeHintForRow_c767_0.can_issue()) {
      return cb_sizeHintForRow_c767_0.issue<QTableWidget_Adaptor, int, int>(&QTableWidget_Adaptor::cbs_sizeHintForRow_c767_0, row);
    } else {
      return QTableWidget::sizeHintForRow(row);
    }
  }

  //  [adaptor impl] void QTableWidget::startDrag(QFlags<Qt::DropAction> supportedActions)
  void cbs_startDrag_2456_0(QFlags<Qt::DropAction> supportedActions)
  {
    QTableWidget::startDrag(supportedActions);
  }

  virtual void startDrag(QFlags<Qt::DropAction> supportedActions)
  {
    if (cb_startDrag_2456_0.can_issue()) {
      cb_startDrag_2456_0.issue<QTableWidget_Adaptor, QFlags<Qt::DropAction> >(&QTableWidget_Adaptor::cbs_startDrag_2456_0, supportedActions);
    } else {
      QTableWidget::startDrag(supportedActions);
    }
  }

  //  [adaptor impl] void QTableWidget::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QTableWidget::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QTableWidget_Adaptor, QStyle &>(&QTableWidget_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QTableWidget::styleChange(arg1);
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QTableWidget::supportedDropActions()
  QFlags<Qt::DropAction> cbs_supportedDropActions_c0_0() const
  {
    return QTableWidget::supportedDropActions();
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return cb_supportedDropActions_c0_0.issue<QTableWidget_Adaptor, QFlags<Qt::DropAction> >(&QTableWidget_Adaptor::cbs_supportedDropActions_c0_0);
    } else {
      return QTableWidget::supportedDropActions();
    }
  }

  //  [adaptor impl] void QTableWidget::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QTableWidget::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QTableWidget_Adaptor, QTabletEvent *>(&QTableWidget_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QTableWidget::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QTableWidget::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QTableWidget::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTableWidget_Adaptor, QTimerEvent *>(&QTableWidget_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QTableWidget::timerEvent(event);
    }
  }

  //  [adaptor impl] void QTableWidget::updateEditorData()
  void cbs_updateEditorData_0_0()
  {
    QTableWidget::updateEditorData();
  }

  virtual void updateEditorData()
  {
    if (cb_updateEditorData_0_0.can_issue()) {
      cb_updateEditorData_0_0.issue<QTableWidget_Adaptor>(&QTableWidget_Adaptor::cbs_updateEditorData_0_0);
    } else {
      QTableWidget::updateEditorData();
    }
  }

  //  [adaptor impl] void QTableWidget::updateEditorGeometries()
  void cbs_updateEditorGeometries_0_0()
  {
    QTableWidget::updateEditorGeometries();
  }

  virtual void updateEditorGeometries()
  {
    if (cb_updateEditorGeometries_0_0.can_issue()) {
      cb_updateEditorGeometries_0_0.issue<QTableWidget_Adaptor>(&QTableWidget_Adaptor::cbs_updateEditorGeometries_0_0);
    } else {
      QTableWidget::updateEditorGeometries();
    }
  }

  //  [adaptor impl] void QTableWidget::updateGeometries()
  void cbs_updateGeometries_0_0()
  {
    QTableWidget::updateGeometries();
  }

  virtual void updateGeometries()
  {
    if (cb_updateGeometries_0_0.can_issue()) {
      cb_updateGeometries_0_0.issue<QTableWidget_Adaptor>(&QTableWidget_Adaptor::cbs_updateGeometries_0_0);
    } else {
      QTableWidget::updateGeometries();
    }
  }

  //  [adaptor impl] int QTableWidget::verticalOffset()
  int cbs_verticalOffset_c0_0() const
  {
    return QTableWidget::verticalOffset();
  }

  virtual int verticalOffset() const
  {
    if (cb_verticalOffset_c0_0.can_issue()) {
      return cb_verticalOffset_c0_0.issue<QTableWidget_Adaptor, int>(&QTableWidget_Adaptor::cbs_verticalOffset_c0_0);
    } else {
      return QTableWidget::verticalOffset();
    }
  }

  //  [adaptor impl] void QTableWidget::verticalScrollbarAction(int action)
  void cbs_verticalScrollbarAction_767_0(int action)
  {
    QTableWidget::verticalScrollbarAction(action);
  }

  virtual void verticalScrollbarAction(int action)
  {
    if (cb_verticalScrollbarAction_767_0.can_issue()) {
      cb_verticalScrollbarAction_767_0.issue<QTableWidget_Adaptor, int>(&QTableWidget_Adaptor::cbs_verticalScrollbarAction_767_0, action);
    } else {
      QTableWidget::verticalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QTableWidget::verticalScrollbarValueChanged(int value)
  void cbs_verticalScrollbarValueChanged_767_0(int value)
  {
    QTableWidget::verticalScrollbarValueChanged(value);
  }

  virtual void verticalScrollbarValueChanged(int value)
  {
    if (cb_verticalScrollbarValueChanged_767_0.can_issue()) {
      cb_verticalScrollbarValueChanged_767_0.issue<QTableWidget_Adaptor, int>(&QTableWidget_Adaptor::cbs_verticalScrollbarValueChanged_767_0, value);
    } else {
      QTableWidget::verticalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] QStyleOptionViewItem QTableWidget::viewOptions()
  QStyleOptionViewItem cbs_viewOptions_c0_0() const
  {
    return QTableWidget::viewOptions();
  }

  virtual QStyleOptionViewItem viewOptions() const
  {
    if (cb_viewOptions_c0_0.can_issue()) {
      return cb_viewOptions_c0_0.issue<QTableWidget_Adaptor, QStyleOptionViewItem>(&QTableWidget_Adaptor::cbs_viewOptions_c0_0);
    } else {
      return QTableWidget::viewOptions();
    }
  }

  //  [emitter impl] void QTableWidget::viewportEntered()
  void emitter_QTableWidget_viewportEntered_0()
  {
    emit QTableWidget::viewportEntered();
  }

  //  [adaptor impl] bool QTableWidget::viewportEvent(QEvent *event)
  bool cbs_viewportEvent_1217_0(QEvent *event)
  {
    return QTableWidget::viewportEvent(event);
  }

  virtual bool viewportEvent(QEvent *event)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QTableWidget_Adaptor, bool, QEvent *>(&QTableWidget_Adaptor::cbs_viewportEvent_1217_0, event);
    } else {
      return QTableWidget::viewportEvent(event);
    }
  }

  //  [adaptor impl] QRegion QTableWidget::visualRegionForSelection(const QItemSelection &selection)
  QRegion cbs_visualRegionForSelection_c2727_0(const QItemSelection &selection) const
  {
    return QTableWidget::visualRegionForSelection(selection);
  }

  virtual QRegion visualRegionForSelection(const QItemSelection &selection) const
  {
    if (cb_visualRegionForSelection_c2727_0.can_issue()) {
      return cb_visualRegionForSelection_c2727_0.issue<QTableWidget_Adaptor, QRegion, const QItemSelection &>(&QTableWidget_Adaptor::cbs_visualRegionForSelection_c2727_0, selection);
    } else {
      return QTableWidget::visualRegionForSelection(selection);
    }
  }

  //  [adaptor impl] void QTableWidget::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QTableWidget::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QTableWidget_Adaptor, QWheelEvent *>(&QTableWidget_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QTableWidget::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QTableWidget::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QTableWidget::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QTableWidget_Adaptor, bool>(&QTableWidget_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QTableWidget::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_doItemsLayout_0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexAt_c1916_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_keyboardSearch_2025_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_scrollTo_5576_1;
  gsi::Callback cb_selectAll_0_0;
  gsi::Callback cb_setRootIndex_2395_0;
  gsi::Callback cb_setSelectionModel_2533_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_visualRect_c2395_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEditor_4926_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_commitData_1315_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_currentChanged_4682_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_dataChanged_4682_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_dropMimeData_5138_0;
  gsi::Callback cb_edit_6773_0;
  gsi::Callback cb_editorDestroyed_1302_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_horizontalOffset_c0_0;
  gsi::Callback cb_horizontalScrollbarAction_767_0;
  gsi::Callback cb_horizontalScrollbarValueChanged_767_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_isIndexHidden_c2395_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mimeData_c3368_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveCursor_6476_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_rowsAboutToBeRemoved_3713_0;
  gsi::Callback cb_rowsInserted_3713_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_selectedIndexes_c0_0;
  gsi::Callback cb_selectionChanged_5346_0;
  gsi::Callback cb_selectionCommand_c4199_1;
  gsi::Callback cb_setSelection_6155_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_sizeHintForColumn_c767_0;
  gsi::Callback cb_sizeHintForRow_c767_0;
  gsi::Callback cb_startDrag_2456_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateEditorData_0_0;
  gsi::Callback cb_updateEditorGeometries_0_0;
  gsi::Callback cb_updateGeometries_0_0;
  gsi::Callback cb_verticalOffset_c0_0;
  gsi::Callback cb_verticalScrollbarAction_767_0;
  gsi::Callback cb_verticalScrollbarValueChanged_767_0;
  gsi::Callback cb_viewOptions_c0_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_visualRegionForSelection_c2727_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QTableWidget_Adaptor::~QTableWidget_Adaptor() { }

//  Constructor QTableWidget::QTableWidget(QWidget *parent) (adaptor class)

static void _init_ctor_QTableWidget_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QTableWidget_Adaptor> ();
}

static void _call_ctor_QTableWidget_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  ret.write<QTableWidget_Adaptor *> (new QTableWidget_Adaptor (arg1));
}


//  Constructor QTableWidget::QTableWidget(int rows, int columns, QWidget *parent) (adaptor class)

static void _init_ctor_QTableWidget_Adaptor_2633 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rows");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("columns");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return_new<QTableWidget_Adaptor> ();
}

static void _call_ctor_QTableWidget_Adaptor_2633 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  QWidget *arg3 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  ret.write<QTableWidget_Adaptor *> (new QTableWidget_Adaptor (arg1, arg2, arg3));
}


// void QTableWidget::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// emitter void QTableWidget::activated(const QModelIndex &index)

static void _init_emitter_activated_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_activated_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_activated_2395 (arg1);
}


// emitter void QTableWidget::cellActivated(int row, int column)

static void _init_emitter_cellActivated_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_cellActivated_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_cellActivated_1426 (arg1, arg2);
}


// emitter void QTableWidget::cellChanged(int row, int column)

static void _init_emitter_cellChanged_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_cellChanged_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_cellChanged_1426 (arg1, arg2);
}


// emitter void QTableWidget::cellClicked(int row, int column)

static void _init_emitter_cellClicked_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_cellClicked_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_cellClicked_1426 (arg1, arg2);
}


// emitter void QTableWidget::cellDoubleClicked(int row, int column)

static void _init_emitter_cellDoubleClicked_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_cellDoubleClicked_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_cellDoubleClicked_1426 (arg1, arg2);
}


// emitter void QTableWidget::cellEntered(int row, int column)

static void _init_emitter_cellEntered_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_cellEntered_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_cellEntered_1426 (arg1, arg2);
}


// emitter void QTableWidget::cellPressed(int row, int column)

static void _init_emitter_cellPressed_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_cellPressed_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_cellPressed_1426 (arg1, arg2);
}


// void QTableWidget::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QTableWidget::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QTableWidget::clicked(const QModelIndex &index)

static void _init_emitter_clicked_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_clicked_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_clicked_2395 (arg1);
}


// void QTableWidget::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)

static void _init_cbs_closeEditor_4926_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_closeEditor_4926_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_closeEditor_4926_0 (arg1, arg2);
}

static void _set_callback_cbs_closeEditor_4926_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_closeEditor_4926_0 = cb;
}


// void QTableWidget::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// exposed void QTableWidget::columnCountChanged(int oldCount, int newCount)

static void _init_fp_columnCountChanged_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldCount");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("newCount");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_columnCountChanged_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_columnCountChanged_1426 (arg1, arg2);
}


// exposed void QTableWidget::columnMoved(int column, int oldIndex, int newIndex)

static void _init_fp_columnMoved_2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldIndex");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("newIndex");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_columnMoved_2085 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_columnMoved_2085 (arg1, arg2, arg3);
}


// exposed void QTableWidget::columnResized(int column, int oldWidth, int newWidth)

static void _init_fp_columnResized_2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldWidth");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("newWidth");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_columnResized_2085 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_columnResized_2085 (arg1, arg2, arg3);
}


// void QTableWidget::commitData(QWidget *editor)

static void _init_cbs_commitData_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_commitData_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_commitData_1315_0 (arg1);
}

static void _set_callback_cbs_commitData_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_commitData_1315_0 = cb;
}


// void QTableWidget::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QTableWidget::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_create_2208 (arg1, arg2, arg3);
}


// emitter void QTableWidget::currentCellChanged(int currentRow, int currentColumn, int previousRow, int previousColumn)

static void _init_emitter_currentCellChanged_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("currentRow");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("currentColumn");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("previousRow");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("previousColumn");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_emitter_currentCellChanged_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_currentCellChanged_2744 (arg1, arg2, arg3, arg4);
}


// void QTableWidget::currentChanged(const QModelIndex &current, const QModelIndex &previous)

static void _init_cbs_currentChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("current");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("previous");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_currentChanged_4682_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_currentChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_currentChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_currentChanged_4682_0 = cb;
}


// emitter void QTableWidget::currentItemChanged(QTableWidgetItem *current, QTableWidgetItem *previous)

static void _init_emitter_currentItemChanged_4296 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("current");
  decl->add_arg<QTableWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("previous");
  decl->add_arg<QTableWidgetItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_currentItemChanged_4296 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTableWidgetItem *arg1 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  QTableWidgetItem *arg2 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_currentItemChanged_4296 (arg1, arg2);
}


// emitter void QTableWidget::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_customContextMenuRequested_1916 (arg1);
}


// void QTableWidget::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QTableWidget::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)

static void _init_cbs_dataChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_dataChanged_4682_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_dataChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_dataChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_dataChanged_4682_0 = cb;
}


// exposed void QTableWidget::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_destroy_1620 (arg1, arg2);
}


// emitter void QTableWidget::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_destroyed_1302 (arg1);
}


// exposed QPoint QTableWidget::dirtyRegionOffset()

static void _init_fp_dirtyRegionOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_fp_dirtyRegionOffset_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QTableWidget_Adaptor *)cls)->fp_QTableWidget_dirtyRegionOffset_c0 ());
}


// void QTableWidget::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// exposed void QTableWidget::doAutoScroll()

static void _init_fp_doAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_doAutoScroll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_doAutoScroll_0 ();
}


// void QTableWidget::doItemsLayout()

static void _init_cbs_doItemsLayout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_doItemsLayout_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_doItemsLayout_0_0 ();
}

static void _set_callback_cbs_doItemsLayout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_doItemsLayout_0_0 = cb;
}


// emitter void QTableWidget::doubleClicked(const QModelIndex &index)

static void _init_emitter_doubleClicked_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_doubleClicked_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_doubleClicked_2395 (arg1);
}


// void QTableWidget::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QTableWidget::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QTableWidget::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// exposed void QTableWidget::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_drawFrame_1426 (arg1);
}


// void QTableWidget::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// exposed QAbstractItemView::DropIndicatorPosition QTableWidget::dropIndicatorPosition()

static void _init_fp_dropIndicatorPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_dropIndicatorPosition_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<unsigned int > ((unsigned int)((QTableWidget_Adaptor *)cls)->fp_QTableWidget_dropIndicatorPosition_c0 ());
}


// bool QTableWidget::dropMimeData(int row, int column, const QMimeData *data, Qt::DropAction action)

static void _init_cbs_dropMimeData_5138_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data");
  decl->add_arg<const QMimeData * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_5138_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QMimeData *arg3 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg4 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  ret.write<bool > ((bool)((QTableWidget_Adaptor *)cls)->cbs_dropMimeData_5138_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_dropMimeData_5138_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_dropMimeData_5138_0 = cb;
}


// bool QTableWidget::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)

static void _init_cbs_edit_6773_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("trigger");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("event");
  decl->add_arg<QEvent * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_edit_6773_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > (heap);
  QEvent *arg3 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTableWidget_Adaptor *)cls)->cbs_edit_6773_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_edit_6773_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_edit_6773_0 = cb;
}


// void QTableWidget::editorDestroyed(QObject *editor)

static void _init_cbs_editorDestroyed_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_editorDestroyed_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_editorDestroyed_1302_0 (arg1);
}

static void _set_callback_cbs_editorDestroyed_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_editorDestroyed_1302_0 = cb;
}


// void QTableWidget::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}


// void QTableWidget::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// emitter void QTableWidget::entered(const QModelIndex &index)

static void _init_emitter_entered_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_entered_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_entered_2395 (arg1);
}


// bool QTableWidget::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTableWidget_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QTableWidget::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTableWidget_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed void QTableWidget::executeDelayedItemsLayout()

static void _init_fp_executeDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_executeDelayedItemsLayout_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_executeDelayedItemsLayout_0 ();
}


// void QTableWidget::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QTableWidget::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTableWidget_Adaptor *)cls)->fp_QTableWidget_focusNextChild_0 ());
}


// bool QTableWidget::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QTableWidget_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QTableWidget::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QTableWidget::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTableWidget_Adaptor *)cls)->fp_QTableWidget_focusPreviousChild_0 ());
}


// void QTableWidget::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = args.read<const QFont & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}


// int QTableWidget::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QTableWidget_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QTableWidget::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// int QTableWidget::horizontalOffset()

static void _init_cbs_horizontalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_horizontalOffset_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTableWidget_Adaptor *)cls)->cbs_horizontalOffset_c0_0 ());
}

static void _set_callback_cbs_horizontalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_horizontalOffset_c0_0 = cb;
}


// void QTableWidget::horizontalScrollbarAction(int action)

static void _init_cbs_horizontalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarAction_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_horizontalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_horizontalScrollbarAction_767_0 = cb;
}


// void QTableWidget::horizontalScrollbarValueChanged(int value)

static void _init_cbs_horizontalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_horizontalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_horizontalScrollbarValueChanged_767_0 = cb;
}


// exposed int QTableWidget::horizontalStepsPerItem()

static void _init_fp_horizontalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_horizontalStepsPerItem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTableWidget_Adaptor *)cls)->fp_QTableWidget_horizontalStepsPerItem_c0 ());
}


// QModelIndex QTableWidget::indexAt(const QPoint &p)

static void _init_cbs_indexAt_c1916_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_indexAt_c1916_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QTableWidget_Adaptor *)cls)->cbs_indexAt_c1916_0 (arg1));
}

static void _set_callback_cbs_indexAt_c1916_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_indexAt_c1916_0 = cb;
}


// exposed QModelIndex QTableWidget::indexFromItem(QTableWidgetItem *item)

static void _init_fp_indexFromItem_c2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_indexFromItem_c2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTableWidgetItem *arg1 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QTableWidget_Adaptor *)cls)->fp_QTableWidget_indexFromItem_c2202 (arg1));
}


// void QTableWidget::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QTableWidget::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QTableWidget_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// bool QTableWidget::isIndexHidden(const QModelIndex &index)

static void _init_cbs_isIndexHidden_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isIndexHidden_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QTableWidget_Adaptor *)cls)->cbs_isIndexHidden_c2395_0 (arg1));
}

static void _set_callback_cbs_isIndexHidden_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_isIndexHidden_c2395_0 = cb;
}


// emitter void QTableWidget::itemActivated(QTableWidgetItem *item)

static void _init_emitter_itemActivated_2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_itemActivated_2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTableWidgetItem *arg1 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_itemActivated_2202 (arg1);
}


// emitter void QTableWidget::itemChanged(QTableWidgetItem *item)

static void _init_emitter_itemChanged_2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_itemChanged_2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTableWidgetItem *arg1 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_itemChanged_2202 (arg1);
}


// emitter void QTableWidget::itemClicked(QTableWidgetItem *item)

static void _init_emitter_itemClicked_2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_itemClicked_2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTableWidgetItem *arg1 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_itemClicked_2202 (arg1);
}


// emitter void QTableWidget::itemDoubleClicked(QTableWidgetItem *item)

static void _init_emitter_itemDoubleClicked_2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_itemDoubleClicked_2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTableWidgetItem *arg1 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_itemDoubleClicked_2202 (arg1);
}


// emitter void QTableWidget::itemEntered(QTableWidgetItem *item)

static void _init_emitter_itemEntered_2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_itemEntered_2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTableWidgetItem *arg1 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_itemEntered_2202 (arg1);
}


// exposed QTableWidgetItem *QTableWidget::itemFromIndex(const QModelIndex &index)

static void _init_fp_itemFromIndex_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QTableWidgetItem * > ();
}

static void _call_fp_itemFromIndex_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QTableWidgetItem * > ((QTableWidgetItem *)((QTableWidget_Adaptor *)cls)->fp_QTableWidget_itemFromIndex_c2395 (arg1));
}


// emitter void QTableWidget::itemPressed(QTableWidgetItem *item)

static void _init_emitter_itemPressed_2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTableWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_itemPressed_2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTableWidgetItem *arg1 = gsi::arg_reader<QTableWidgetItem * >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_itemPressed_2202 (arg1);
}


// emitter void QTableWidget::itemSelectionChanged()

static void _init_emitter_itemSelectionChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_itemSelectionChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_itemSelectionChanged_0 ();
}


// exposed QList<QTableWidgetItem*> QTableWidget::items(const QMimeData *data)

static void _init_fp_items_c2168 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  decl->set_return<QList<QTableWidgetItem*> > ();
}

static void _call_fp_items_c2168 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = gsi::arg_reader<const QMimeData * >() (args, heap);
  ret.write<QList<QTableWidgetItem*> > ((QList<QTableWidgetItem*>)((QTableWidget_Adaptor *)cls)->fp_QTableWidget_items_c2168 (arg1));
}


// void QTableWidget::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QTableWidget::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QTableWidget::keyboardSearch(const QString &search)

static void _init_cbs_keyboardSearch_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("search");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyboardSearch_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_keyboardSearch_2025_0 (arg1);
}

static void _set_callback_cbs_keyboardSearch_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_keyboardSearch_2025_0 = cb;
}


// void QTableWidget::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}


// void QTableWidget::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QTableWidget::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QTableWidget_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QMimeData *QTableWidget::mimeData(const QList<QTableWidgetItem*> items)

static void _init_cbs_mimeData_c3368_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const QList<QTableWidgetItem*> > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3368_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QTableWidgetItem*> arg1 = args.read<const QList<QTableWidgetItem*> > (heap);
  ret.write<QMimeData * > ((QMimeData *)((QTableWidget_Adaptor *)cls)->cbs_mimeData_c3368_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3368_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_mimeData_c3368_0 = cb;
}


// QStringList QTableWidget::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QTableWidget_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}


// QSize QTableWidget::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTableWidget_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QTableWidget::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QTableWidget::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QTableWidget::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QTableWidget::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// QModelIndex QTableWidget::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)

static void _init_cbs_moveCursor_6476_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursorAction");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("modifiers");
  decl->add_arg<QFlags<Qt::KeyboardModifier> > (argspec_1);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_moveCursor_6476_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  QFlags<Qt::KeyboardModifier> arg2 = args.read<QFlags<Qt::KeyboardModifier> > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QTableWidget_Adaptor *)cls)->cbs_moveCursor_6476_0 (arg1, arg2));
}

static void _set_callback_cbs_moveCursor_6476_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_moveCursor_6476_0 = cb;
}


// void QTableWidget::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// QPaintEngine *QTableWidget::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QTableWidget_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QTableWidget::paintEvent(QPaintEvent *e)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// void QTableWidget::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = args.read<const QPalette & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}


// emitter void QTableWidget::pressed(const QModelIndex &index)

static void _init_emitter_pressed_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_pressed_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_pressed_2395 (arg1);
}


// exposed int QTableWidget::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QTableWidget_Adaptor *)cls)->fp_QTableWidget_receivers_c1731 (arg1));
}


// void QTableWidget::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_reset_0_0 = cb;
}


// exposed void QTableWidget::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_resetInputContext_0 ();
}


// void QTableWidget::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed void QTableWidget::rowCountChanged(int oldCount, int newCount)

static void _init_fp_rowCountChanged_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldCount");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("newCount");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_rowCountChanged_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_rowCountChanged_1426 (arg1, arg2);
}


// exposed void QTableWidget::rowMoved(int row, int oldIndex, int newIndex)

static void _init_fp_rowMoved_2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldIndex");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("newIndex");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_rowMoved_2085 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_rowMoved_2085 (arg1, arg2, arg3);
}


// exposed void QTableWidget::rowResized(int row, int oldHeight, int newHeight)

static void _init_fp_rowResized_2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldHeight");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("newHeight");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_rowResized_2085 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_rowResized_2085 (arg1, arg2, arg3);
}


// void QTableWidget::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsAboutToBeRemoved_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsAboutToBeRemoved_3713_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_rowsAboutToBeRemoved_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsAboutToBeRemoved_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_rowsAboutToBeRemoved_3713_0 = cb;
}


// void QTableWidget::rowsInserted(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsInserted_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsInserted_3713_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_rowsInserted_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsInserted_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_rowsInserted_3713_0 = cb;
}


// exposed void QTableWidget::scheduleDelayedItemsLayout()

static void _init_fp_scheduleDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_scheduleDelayedItemsLayout_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_scheduleDelayedItemsLayout_0 ();
}


// void QTableWidget::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}


// exposed void QTableWidget::scrollDirtyRegion(int dx, int dy)

static void _init_fp_scrollDirtyRegion_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_scrollDirtyRegion_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_scrollDirtyRegion_1426 (arg1, arg2);
}


// void QTableWidget::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)

static void _init_cbs_scrollTo_5576_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollTo_5576_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_scrollTo_5576_1 (arg1, arg2);
}

static void _set_callback_cbs_scrollTo_5576_1 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_scrollTo_5576_1 = cb;
}


// void QTableWidget::selectAll()

static void _init_cbs_selectAll_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_selectAll_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_selectAll_0_0 ();
}

static void _set_callback_cbs_selectAll_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_selectAll_0_0 = cb;
}


// QList<QModelIndex> QTableWidget::selectedIndexes()

static void _init_cbs_selectedIndexes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_cbs_selectedIndexes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QTableWidget_Adaptor *)cls)->cbs_selectedIndexes_c0_0 ());
}

static void _set_callback_cbs_selectedIndexes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_selectedIndexes_c0_0 = cb;
}


// void QTableWidget::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)

static void _init_cbs_selectionChanged_5346_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selected");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("deselected");
  decl->add_arg<const QItemSelection & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_selectionChanged_5346_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = args.read<const QItemSelection & > (heap);
  const QItemSelection &arg2 = args.read<const QItemSelection & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_selectionChanged_5346_0 (arg1, arg2);
}

static void _set_callback_cbs_selectionChanged_5346_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_selectionChanged_5346_0 = cb;
}


// QFlags<QItemSelectionModel::SelectionFlag> QTableWidget::selectionCommand(const QModelIndex &index, const QEvent *event)

static void _init_cbs_selectionCommand_c4199_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<const QEvent * > (argspec_1);
  decl->set_return<QFlags<QItemSelectionModel::SelectionFlag> > ();
}

static void _call_cbs_selectionCommand_c4199_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QEvent *arg2 = args.read<const QEvent * > (heap);
  ret.write<QFlags<QItemSelectionModel::SelectionFlag> > ((QFlags<QItemSelectionModel::SelectionFlag>)((QTableWidget_Adaptor *)cls)->cbs_selectionCommand_c4199_1 (arg1, arg2));
}

static void _set_callback_cbs_selectionCommand_c4199_1 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_selectionCommand_c4199_1 = cb;
}


// exposed QObject *QTableWidget::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QTableWidget_Adaptor *)cls)->fp_QTableWidget_sender_c0 ());
}


// exposed void QTableWidget::setDirtyRegion(const QRegion &region)

static void _init_fp_setDirtyRegion_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setDirtyRegion_2006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_setDirtyRegion_2006 (arg1);
}


// exposed void QTableWidget::setHorizontalStepsPerItem(int steps)

static void _init_fp_setHorizontalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setHorizontalStepsPerItem_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_setHorizontalStepsPerItem_767 (arg1);
}


// void QTableWidget::setRootIndex(const QModelIndex &index)

static void _init_cbs_setRootIndex_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setRootIndex_2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_setRootIndex_2395_0 (arg1);
}

static void _set_callback_cbs_setRootIndex_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_setRootIndex_2395_0 = cb;
}


// void QTableWidget::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)

static void _init_cbs_setSelection_6155_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<QFlags<QItemSelectionModel::SelectionFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setSelection_6155_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  QFlags<QItemSelectionModel::SelectionFlag> arg2 = args.read<QFlags<QItemSelectionModel::SelectionFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_setSelection_6155_0 (arg1, arg2);
}

static void _set_callback_cbs_setSelection_6155_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_setSelection_6155_0 = cb;
}


// void QTableWidget::setSelectionModel(QItemSelectionModel *selectionModel)

static void _init_cbs_setSelectionModel_2533_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionModel");
  decl->add_arg<QItemSelectionModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSelectionModel_2533_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QItemSelectionModel *arg1 = args.read<QItemSelectionModel * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_setSelectionModel_2533_0 (arg1);
}

static void _set_callback_cbs_setSelectionModel_2533_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_setSelectionModel_2533_0 = cb;
}


// exposed void QTableWidget::setState(QAbstractItemView::State state)

static void _init_fp_setState_2776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setState_2776 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_setState_2776 (arg1);
}


// exposed void QTableWidget::setVerticalStepsPerItem(int steps)

static void _init_fp_setVerticalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setVerticalStepsPerItem_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_setVerticalStepsPerItem_767 (arg1);
}


// exposed void QTableWidget::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}


// exposed void QTableWidget::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = gsi::arg_reader<const QMargins & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_setViewportMargins_2115 (arg1);
}


// void QTableWidget::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// exposed void QTableWidget::setupViewport(QWidget *viewport)

static void _init_fp_setupViewport_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setupViewport_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_setupViewport_1315 (arg1);
}


// void QTableWidget::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QTableWidget::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTableWidget_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// int QTableWidget::sizeHintForColumn(int column)

static void _init_cbs_sizeHintForColumn_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForColumn_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QTableWidget_Adaptor *)cls)->cbs_sizeHintForColumn_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForColumn_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_sizeHintForColumn_c767_0 = cb;
}


// int QTableWidget::sizeHintForRow(int row)

static void _init_cbs_sizeHintForRow_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForRow_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QTableWidget_Adaptor *)cls)->cbs_sizeHintForRow_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForRow_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_sizeHintForRow_c767_0 = cb;
}


// exposed void QTableWidget::startAutoScroll()

static void _init_fp_startAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_startAutoScroll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_startAutoScroll_0 ();
}


// void QTableWidget::startDrag(QFlags<Qt::DropAction> supportedActions)

static void _init_cbs_startDrag_2456_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("supportedActions");
  decl->add_arg<QFlags<Qt::DropAction> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_startDrag_2456_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::DropAction> arg1 = args.read<QFlags<Qt::DropAction> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_startDrag_2456_0 (arg1);
}

static void _set_callback_cbs_startDrag_2456_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_startDrag_2456_0 = cb;
}


// exposed QAbstractItemView::State QTableWidget::state()

static void _init_fp_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<unsigned int > ((unsigned int)((QTableWidget_Adaptor *)cls)->fp_QTableWidget_state_c0 ());
}


// exposed void QTableWidget::stopAutoScroll()

static void _init_fp_stopAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_stopAutoScroll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_stopAutoScroll_0 ();
}


// void QTableWidget::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle &arg1 = args.read<QStyle & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}


// QFlags<Qt::DropAction> QTableWidget::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QTableWidget_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}


// void QTableWidget::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QTableWidget::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QTableWidget::updateEditorData()

static void _init_cbs_updateEditorData_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorData_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_updateEditorData_0_0 ();
}

static void _set_callback_cbs_updateEditorData_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_updateEditorData_0_0 = cb;
}


// void QTableWidget::updateEditorGeometries()

static void _init_cbs_updateEditorGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorGeometries_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_updateEditorGeometries_0_0 ();
}

static void _set_callback_cbs_updateEditorGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_updateEditorGeometries_0_0 = cb;
}


// void QTableWidget::updateGeometries()

static void _init_cbs_updateGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometries_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_updateGeometries_0_0 ();
}

static void _set_callback_cbs_updateGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_updateGeometries_0_0 = cb;
}


// exposed void QTableWidget::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->fp_QTableWidget_updateMicroFocus_0 ();
}


// int QTableWidget::verticalOffset()

static void _init_cbs_verticalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_verticalOffset_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTableWidget_Adaptor *)cls)->cbs_verticalOffset_c0_0 ());
}

static void _set_callback_cbs_verticalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_verticalOffset_c0_0 = cb;
}


// void QTableWidget::verticalScrollbarAction(int action)

static void _init_cbs_verticalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarAction_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_verticalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_verticalScrollbarAction_767_0 = cb;
}


// void QTableWidget::verticalScrollbarValueChanged(int value)

static void _init_cbs_verticalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_verticalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_verticalScrollbarValueChanged_767_0 = cb;
}


// exposed int QTableWidget::verticalStepsPerItem()

static void _init_fp_verticalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_verticalStepsPerItem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTableWidget_Adaptor *)cls)->fp_QTableWidget_verticalStepsPerItem_c0 ());
}


// QStyleOptionViewItem QTableWidget::viewOptions()

static void _init_cbs_viewOptions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStyleOptionViewItem > ();
}

static void _call_cbs_viewOptions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStyleOptionViewItem > ((QStyleOptionViewItem)((QTableWidget_Adaptor *)cls)->cbs_viewOptions_c0_0 ());
}

static void _set_callback_cbs_viewOptions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_viewOptions_c0_0 = cb;
}


// emitter void QTableWidget::viewportEntered()

static void _init_emitter_viewportEntered_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_viewportEntered_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTableWidget_Adaptor *)cls)->emitter_QTableWidget_viewportEntered_0 ();
}


// bool QTableWidget::viewportEvent(QEvent *event)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTableWidget_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}


// QRect QTableWidget::visualRect(const QModelIndex &index)

static void _init_cbs_visualRect_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_cbs_visualRect_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QRect > ((QRect)((QTableWidget_Adaptor *)cls)->cbs_visualRect_c2395_0 (arg1));
}

static void _set_callback_cbs_visualRect_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_visualRect_c2395_0 = cb;
}


// QRegion QTableWidget::visualRegionForSelection(const QItemSelection &selection)

static void _init_cbs_visualRegionForSelection_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QRegion > ();
}

static void _call_cbs_visualRegionForSelection_c2727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = args.read<const QItemSelection & > (heap);
  ret.write<QRegion > ((QRegion)((QTableWidget_Adaptor *)cls)->cbs_visualRegionForSelection_c2727_0 (arg1));
}

static void _set_callback_cbs_visualRegionForSelection_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_visualRegionForSelection_c2727_0 = cb;
}


// void QTableWidget::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// void QTableWidget::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTableWidget_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTableWidget_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}


namespace gsi
{

gsi::Class<QTableWidget> &qtdecl_QTableWidget ();

static gsi::Methods methods_QTableWidget_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTableWidget::QTableWidget(QWidget *parent)\nThis method creates an object of class QTableWidget.", &_init_ctor_QTableWidget_Adaptor_1315, &_call_ctor_QTableWidget_Adaptor_1315);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTableWidget::QTableWidget(int rows, int columns, QWidget *parent)\nThis method creates an object of class QTableWidget.", &_init_ctor_QTableWidget_Adaptor_2633, &_call_ctor_QTableWidget_Adaptor_2633);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QTableWidget::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("emit_activated", "@brief Emitter for signal void QTableWidget::activated(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_activated_2395, &_call_emitter_activated_2395);
  methods += new qt_gsi::GenericMethod ("emit_cellActivated", "@brief Emitter for signal void QTableWidget::cellActivated(int row, int column)\nCall this method to emit this signal.", false, &_init_emitter_cellActivated_1426, &_call_emitter_cellActivated_1426);
  methods += new qt_gsi::GenericMethod ("emit_cellChanged", "@brief Emitter for signal void QTableWidget::cellChanged(int row, int column)\nCall this method to emit this signal.", false, &_init_emitter_cellChanged_1426, &_call_emitter_cellChanged_1426);
  methods += new qt_gsi::GenericMethod ("emit_cellClicked", "@brief Emitter for signal void QTableWidget::cellClicked(int row, int column)\nCall this method to emit this signal.", false, &_init_emitter_cellClicked_1426, &_call_emitter_cellClicked_1426);
  methods += new qt_gsi::GenericMethod ("emit_cellDoubleClicked", "@brief Emitter for signal void QTableWidget::cellDoubleClicked(int row, int column)\nCall this method to emit this signal.", false, &_init_emitter_cellDoubleClicked_1426, &_call_emitter_cellDoubleClicked_1426);
  methods += new qt_gsi::GenericMethod ("emit_cellEntered", "@brief Emitter for signal void QTableWidget::cellEntered(int row, int column)\nCall this method to emit this signal.", false, &_init_emitter_cellEntered_1426, &_call_emitter_cellEntered_1426);
  methods += new qt_gsi::GenericMethod ("emit_cellPressed", "@brief Emitter for signal void QTableWidget::cellPressed(int row, int column)\nCall this method to emit this signal.", false, &_init_emitter_cellPressed_1426, &_call_emitter_cellPressed_1426);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QTableWidget::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTableWidget::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_clicked", "@brief Emitter for signal void QTableWidget::clicked(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_clicked_2395, &_call_emitter_clicked_2395);
  methods += new qt_gsi::GenericMethod ("*closeEditor", "@brief Virtual method void QTableWidget::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0);
  methods += new qt_gsi::GenericMethod ("*closeEditor", "@hide", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0, &_set_callback_cbs_closeEditor_4926_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QTableWidget::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*columnCountChanged", "@brief Method void QTableWidget::columnCountChanged(int oldCount, int newCount)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_columnCountChanged_1426, &_call_fp_columnCountChanged_1426);
  methods += new qt_gsi::GenericMethod ("*columnMoved", "@brief Method void QTableWidget::columnMoved(int column, int oldIndex, int newIndex)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_columnMoved_2085, &_call_fp_columnMoved_2085);
  methods += new qt_gsi::GenericMethod ("*columnResized", "@brief Method void QTableWidget::columnResized(int column, int oldWidth, int newWidth)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_columnResized_2085, &_call_fp_columnResized_2085);
  methods += new qt_gsi::GenericMethod ("*commitData", "@brief Virtual method void QTableWidget::commitData(QWidget *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0);
  methods += new qt_gsi::GenericMethod ("*commitData", "@hide", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0, &_set_callback_cbs_commitData_1315_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QTableWidget::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QTableWidget::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_currentCellChanged", "@brief Emitter for signal void QTableWidget::currentCellChanged(int currentRow, int currentColumn, int previousRow, int previousColumn)\nCall this method to emit this signal.", false, &_init_emitter_currentCellChanged_2744, &_call_emitter_currentCellChanged_2744);
  methods += new qt_gsi::GenericMethod ("*currentChanged", "@brief Virtual method void QTableWidget::currentChanged(const QModelIndex &current, const QModelIndex &previous)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0);
  methods += new qt_gsi::GenericMethod ("*currentChanged", "@hide", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0, &_set_callback_cbs_currentChanged_4682_0);
  methods += new qt_gsi::GenericMethod ("emit_currentItemChanged", "@brief Emitter for signal void QTableWidget::currentItemChanged(QTableWidgetItem *current, QTableWidgetItem *previous)\nCall this method to emit this signal.", false, &_init_emitter_currentItemChanged_4296, &_call_emitter_currentItemChanged_4296);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QTableWidget::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTableWidget::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*dataChanged", "@brief Virtual method void QTableWidget::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dataChanged_4682_0, &_call_cbs_dataChanged_4682_0);
  methods += new qt_gsi::GenericMethod ("*dataChanged", "@hide", false, &_init_cbs_dataChanged_4682_0, &_call_cbs_dataChanged_4682_0, &_set_callback_cbs_dataChanged_4682_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QTableWidget::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QTableWidget::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*dirtyRegionOffset", "@brief Method QPoint QTableWidget::dirtyRegionOffset()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dirtyRegionOffset_c0, &_call_fp_dirtyRegionOffset_c0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTableWidget::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*doAutoScroll", "@brief Method void QTableWidget::doAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_doAutoScroll_0, &_call_fp_doAutoScroll_0);
  methods += new qt_gsi::GenericMethod ("doItemsLayout", "@brief Virtual method void QTableWidget::doItemsLayout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0);
  methods += new qt_gsi::GenericMethod ("doItemsLayout", "@hide", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0, &_set_callback_cbs_doItemsLayout_0_0);
  methods += new qt_gsi::GenericMethod ("emit_doubleClicked", "@brief Emitter for signal void QTableWidget::doubleClicked(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_doubleClicked_2395, &_call_emitter_doubleClicked_2395);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QTableWidget::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QTableWidget::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QTableWidget::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*drawFrame", "@brief Method void QTableWidget::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QTableWidget::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropIndicatorPosition", "@brief Method QAbstractItemView::DropIndicatorPosition QTableWidget::dropIndicatorPosition()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dropIndicatorPosition_c0, &_call_fp_dropIndicatorPosition_c0);
  methods += new qt_gsi::GenericMethod ("*dropMimeData", "@brief Virtual method bool QTableWidget::dropMimeData(int row, int column, const QMimeData *data, Qt::DropAction action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_5138_0, &_call_cbs_dropMimeData_5138_0);
  methods += new qt_gsi::GenericMethod ("*dropMimeData", "@hide", false, &_init_cbs_dropMimeData_5138_0, &_call_cbs_dropMimeData_5138_0, &_set_callback_cbs_dropMimeData_5138_0);
  methods += new qt_gsi::GenericMethod ("*edit", "@brief Virtual method bool QTableWidget::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0);
  methods += new qt_gsi::GenericMethod ("*edit", "@hide", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0, &_set_callback_cbs_edit_6773_0);
  methods += new qt_gsi::GenericMethod ("*editorDestroyed", "@brief Virtual method void QTableWidget::editorDestroyed(QObject *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0);
  methods += new qt_gsi::GenericMethod ("*editorDestroyed", "@hide", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0, &_set_callback_cbs_editorDestroyed_1302_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QTableWidget::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QTableWidget::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_entered", "@brief Emitter for signal void QTableWidget::entered(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_entered_2395, &_call_emitter_entered_2395);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QTableWidget::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QTableWidget::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*executeDelayedItemsLayout", "@brief Method void QTableWidget::executeDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_executeDelayedItemsLayout_0, &_call_fp_executeDelayedItemsLayout_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QTableWidget::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QTableWidget::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QTableWidget::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QTableWidget::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QTableWidget::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QTableWidget::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QTableWidget::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QTableWidget::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*horizontalOffset", "@brief Virtual method int QTableWidget::horizontalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("*horizontalOffset", "@hide", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0, &_set_callback_cbs_horizontalOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@brief Virtual method void QTableWidget::horizontalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0);
  methods += new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@hide", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0, &_set_callback_cbs_horizontalScrollbarAction_767_0);
  methods += new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@brief Virtual method void QTableWidget::horizontalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0);
  methods += new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@hide", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0, &_set_callback_cbs_horizontalScrollbarValueChanged_767_0);
  methods += new qt_gsi::GenericMethod ("*horizontalStepsPerItem", "@brief Method int QTableWidget::horizontalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_horizontalStepsPerItem_c0, &_call_fp_horizontalStepsPerItem_c0);
  methods += new qt_gsi::GenericMethod ("indexAt", "@brief Virtual method QModelIndex QTableWidget::indexAt(const QPoint &p)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0);
  methods += new qt_gsi::GenericMethod ("indexAt", "@hide", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0, &_set_callback_cbs_indexAt_c1916_0);
  methods += new qt_gsi::GenericMethod ("*indexFromItem", "@brief Method QModelIndex QTableWidget::indexFromItem(QTableWidgetItem *item)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_indexFromItem_c2202, &_call_fp_indexFromItem_c2202);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QTableWidget::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QTableWidget::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isIndexHidden", "@brief Virtual method bool QTableWidget::isIndexHidden(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0);
  methods += new qt_gsi::GenericMethod ("*isIndexHidden", "@hide", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0, &_set_callback_cbs_isIndexHidden_c2395_0);
  methods += new qt_gsi::GenericMethod ("emit_itemActivated", "@brief Emitter for signal void QTableWidget::itemActivated(QTableWidgetItem *item)\nCall this method to emit this signal.", false, &_init_emitter_itemActivated_2202, &_call_emitter_itemActivated_2202);
  methods += new qt_gsi::GenericMethod ("emit_itemChanged", "@brief Emitter for signal void QTableWidget::itemChanged(QTableWidgetItem *item)\nCall this method to emit this signal.", false, &_init_emitter_itemChanged_2202, &_call_emitter_itemChanged_2202);
  methods += new qt_gsi::GenericMethod ("emit_itemClicked", "@brief Emitter for signal void QTableWidget::itemClicked(QTableWidgetItem *item)\nCall this method to emit this signal.", false, &_init_emitter_itemClicked_2202, &_call_emitter_itemClicked_2202);
  methods += new qt_gsi::GenericMethod ("emit_itemDoubleClicked", "@brief Emitter for signal void QTableWidget::itemDoubleClicked(QTableWidgetItem *item)\nCall this method to emit this signal.", false, &_init_emitter_itemDoubleClicked_2202, &_call_emitter_itemDoubleClicked_2202);
  methods += new qt_gsi::GenericMethod ("emit_itemEntered", "@brief Emitter for signal void QTableWidget::itemEntered(QTableWidgetItem *item)\nCall this method to emit this signal.", false, &_init_emitter_itemEntered_2202, &_call_emitter_itemEntered_2202);
  methods += new qt_gsi::GenericMethod ("*itemFromIndex", "@brief Method QTableWidgetItem *QTableWidget::itemFromIndex(const QModelIndex &index)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_itemFromIndex_c2395, &_call_fp_itemFromIndex_c2395);
  methods += new qt_gsi::GenericMethod ("emit_itemPressed", "@brief Emitter for signal void QTableWidget::itemPressed(QTableWidgetItem *item)\nCall this method to emit this signal.", false, &_init_emitter_itemPressed_2202, &_call_emitter_itemPressed_2202);
  methods += new qt_gsi::GenericMethod ("emit_itemSelectionChanged", "@brief Emitter for signal void QTableWidget::itemSelectionChanged()\nCall this method to emit this signal.", false, &_init_emitter_itemSelectionChanged_0, &_call_emitter_itemSelectionChanged_0);
  methods += new qt_gsi::GenericMethod ("*items", "@brief Method QList<QTableWidgetItem*> QTableWidget::items(const QMimeData *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_items_c2168, &_call_fp_items_c2168);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QTableWidget::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QTableWidget::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("keyboardSearch", "@brief Virtual method void QTableWidget::keyboardSearch(const QString &search)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0);
  methods += new qt_gsi::GenericMethod ("keyboardSearch", "@hide", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0, &_set_callback_cbs_keyboardSearch_2025_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QTableWidget::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QTableWidget::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QTableWidget::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*mimeData", "@brief Virtual method QMimeData *QTableWidget::mimeData(const QList<QTableWidgetItem*> items)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3368_0, &_call_cbs_mimeData_c3368_0);
  methods += new qt_gsi::GenericMethod ("*mimeData", "@hide", true, &_init_cbs_mimeData_c3368_0, &_call_cbs_mimeData_c3368_0, &_set_callback_cbs_mimeData_c3368_0);
  methods += new qt_gsi::GenericMethod ("*mimeTypes", "@brief Virtual method QStringList QTableWidget::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("*mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QTableWidget::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QTableWidget::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QTableWidget::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QTableWidget::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QTableWidget::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveCursor", "@brief Virtual method QModelIndex QTableWidget::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0);
  methods += new qt_gsi::GenericMethod ("*moveCursor", "@hide", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0, &_set_callback_cbs_moveCursor_6476_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QTableWidget::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QTableWidget::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QTableWidget::paintEvent(QPaintEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QTableWidget::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("emit_pressed", "@brief Emitter for signal void QTableWidget::pressed(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_pressed_2395, &_call_emitter_pressed_2395);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QTableWidget::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QTableWidget::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("*resetInputContext", "@brief Method void QTableWidget::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QTableWidget::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*rowCountChanged", "@brief Method void QTableWidget::rowCountChanged(int oldCount, int newCount)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_rowCountChanged_1426, &_call_fp_rowCountChanged_1426);
  methods += new qt_gsi::GenericMethod ("*rowMoved", "@brief Method void QTableWidget::rowMoved(int row, int oldIndex, int newIndex)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_rowMoved_2085, &_call_fp_rowMoved_2085);
  methods += new qt_gsi::GenericMethod ("*rowResized", "@brief Method void QTableWidget::rowResized(int row, int oldHeight, int newHeight)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_rowResized_2085, &_call_fp_rowResized_2085);
  methods += new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@brief Virtual method void QTableWidget::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0);
  methods += new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@hide", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0, &_set_callback_cbs_rowsAboutToBeRemoved_3713_0);
  methods += new qt_gsi::GenericMethod ("*rowsInserted", "@brief Virtual method void QTableWidget::rowsInserted(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0);
  methods += new qt_gsi::GenericMethod ("*rowsInserted", "@hide", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0, &_set_callback_cbs_rowsInserted_3713_0);
  methods += new qt_gsi::GenericMethod ("*scheduleDelayedItemsLayout", "@brief Method void QTableWidget::scheduleDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scheduleDelayedItemsLayout_0, &_call_fp_scheduleDelayedItemsLayout_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QTableWidget::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*scrollDirtyRegion", "@brief Method void QTableWidget::scrollDirtyRegion(int dx, int dy)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scrollDirtyRegion_1426, &_call_fp_scrollDirtyRegion_1426);
  methods += new qt_gsi::GenericMethod ("scrollTo", "@brief Virtual method void QTableWidget::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1);
  methods += new qt_gsi::GenericMethod ("scrollTo", "@hide", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1, &_set_callback_cbs_scrollTo_5576_1);
  methods += new qt_gsi::GenericMethod ("selectAll", "@brief Virtual method void QTableWidget::selectAll()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0);
  methods += new qt_gsi::GenericMethod ("selectAll", "@hide", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0, &_set_callback_cbs_selectAll_0_0);
  methods += new qt_gsi::GenericMethod ("*selectedIndexes", "@brief Virtual method QList<QModelIndex> QTableWidget::selectedIndexes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0);
  methods += new qt_gsi::GenericMethod ("*selectedIndexes", "@hide", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0, &_set_callback_cbs_selectedIndexes_c0_0);
  methods += new qt_gsi::GenericMethod ("*selectionChanged", "@brief Virtual method void QTableWidget::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0);
  methods += new qt_gsi::GenericMethod ("*selectionChanged", "@hide", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0, &_set_callback_cbs_selectionChanged_5346_0);
  methods += new qt_gsi::GenericMethod ("*selectionCommand", "@brief Virtual method QFlags<QItemSelectionModel::SelectionFlag> QTableWidget::selectionCommand(const QModelIndex &index, const QEvent *event)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1);
  methods += new qt_gsi::GenericMethod ("*selectionCommand", "@hide", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1, &_set_callback_cbs_selectionCommand_c4199_1);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QTableWidget::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*setDirtyRegion", "@brief Method void QTableWidget::setDirtyRegion(const QRegion &region)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setDirtyRegion_2006, &_call_fp_setDirtyRegion_2006);
  methods += new qt_gsi::GenericMethod ("*setHorizontalStepsPerItem", "@brief Method void QTableWidget::setHorizontalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setHorizontalStepsPerItem_767, &_call_fp_setHorizontalStepsPerItem_767);
  methods += new qt_gsi::GenericMethod ("setRootIndex", "@brief Virtual method void QTableWidget::setRootIndex(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0);
  methods += new qt_gsi::GenericMethod ("setRootIndex", "@hide", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0, &_set_callback_cbs_setRootIndex_2395_0);
  methods += new qt_gsi::GenericMethod ("*setSelection", "@brief Virtual method void QTableWidget::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0);
  methods += new qt_gsi::GenericMethod ("*setSelection", "@hide", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0, &_set_callback_cbs_setSelection_6155_0);
  methods += new qt_gsi::GenericMethod ("setSelectionModel", "@brief Virtual method void QTableWidget::setSelectionModel(QItemSelectionModel *selectionModel)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0);
  methods += new qt_gsi::GenericMethod ("setSelectionModel", "@hide", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0, &_set_callback_cbs_setSelectionModel_2533_0);
  methods += new qt_gsi::GenericMethod ("*setState", "@brief Method void QTableWidget::setState(QAbstractItemView::State state)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setState_2776, &_call_fp_setState_2776);
  methods += new qt_gsi::GenericMethod ("*setVerticalStepsPerItem", "@brief Method void QTableWidget::setVerticalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setVerticalStepsPerItem_767, &_call_fp_setVerticalStepsPerItem_767);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QTableWidget::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QTableWidget::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QTableWidget::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*setupViewport", "@brief Method void QTableWidget::setupViewport(QWidget *viewport)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setupViewport_1315, &_call_fp_setupViewport_1315);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QTableWidget::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QTableWidget::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*sizeHintForColumn", "@brief Virtual method int QTableWidget::sizeHintForColumn(int column)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0);
  methods += new qt_gsi::GenericMethod ("*sizeHintForColumn", "@hide", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0, &_set_callback_cbs_sizeHintForColumn_c767_0);
  methods += new qt_gsi::GenericMethod ("*sizeHintForRow", "@brief Virtual method int QTableWidget::sizeHintForRow(int row)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0);
  methods += new qt_gsi::GenericMethod ("*sizeHintForRow", "@hide", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0, &_set_callback_cbs_sizeHintForRow_c767_0);
  methods += new qt_gsi::GenericMethod ("*startAutoScroll", "@brief Method void QTableWidget::startAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_startAutoScroll_0, &_call_fp_startAutoScroll_0);
  methods += new qt_gsi::GenericMethod ("*startDrag", "@brief Virtual method void QTableWidget::startDrag(QFlags<Qt::DropAction> supportedActions)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0);
  methods += new qt_gsi::GenericMethod ("*startDrag", "@hide", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0, &_set_callback_cbs_startDrag_2456_0);
  methods += new qt_gsi::GenericMethod ("*state", "@brief Method QAbstractItemView::State QTableWidget::state()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_state_c0, &_call_fp_state_c0);
  methods += new qt_gsi::GenericMethod ("*stopAutoScroll", "@brief Method void QTableWidget::stopAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_stopAutoScroll_0, &_call_fp_stopAutoScroll_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QTableWidget::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QTableWidget::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("*supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QTableWidget::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTableWidget::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateEditorData", "@brief Virtual method void QTableWidget::updateEditorData()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0);
  methods += new qt_gsi::GenericMethod ("*updateEditorData", "@hide", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0, &_set_callback_cbs_updateEditorData_0_0);
  methods += new qt_gsi::GenericMethod ("*updateEditorGeometries", "@brief Virtual method void QTableWidget::updateEditorGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0);
  methods += new qt_gsi::GenericMethod ("*updateEditorGeometries", "@hide", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0, &_set_callback_cbs_updateEditorGeometries_0_0);
  methods += new qt_gsi::GenericMethod ("*updateGeometries", "@brief Virtual method void QTableWidget::updateGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0);
  methods += new qt_gsi::GenericMethod ("*updateGeometries", "@hide", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0, &_set_callback_cbs_updateGeometries_0_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QTableWidget::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*verticalOffset", "@brief Virtual method int QTableWidget::verticalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("*verticalOffset", "@hide", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0, &_set_callback_cbs_verticalOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@brief Virtual method void QTableWidget::verticalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0);
  methods += new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@hide", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0, &_set_callback_cbs_verticalScrollbarAction_767_0);
  methods += new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@brief Virtual method void QTableWidget::verticalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0);
  methods += new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@hide", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0, &_set_callback_cbs_verticalScrollbarValueChanged_767_0);
  methods += new qt_gsi::GenericMethod ("*verticalStepsPerItem", "@brief Method int QTableWidget::verticalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_verticalStepsPerItem_c0, &_call_fp_verticalStepsPerItem_c0);
  methods += new qt_gsi::GenericMethod ("*viewOptions", "@brief Virtual method QStyleOptionViewItem QTableWidget::viewOptions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0);
  methods += new qt_gsi::GenericMethod ("*viewOptions", "@hide", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0, &_set_callback_cbs_viewOptions_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_viewportEntered", "@brief Emitter for signal void QTableWidget::viewportEntered()\nCall this method to emit this signal.", false, &_init_emitter_viewportEntered_0, &_call_emitter_viewportEntered_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QTableWidget::viewportEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("visualRect", "@brief Virtual method QRect QTableWidget::visualRect(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0);
  methods += new qt_gsi::GenericMethod ("visualRect", "@hide", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0, &_set_callback_cbs_visualRect_c2395_0);
  methods += new qt_gsi::GenericMethod ("*visualRegionForSelection", "@brief Virtual method QRegion QTableWidget::visualRegionForSelection(const QItemSelection &selection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0);
  methods += new qt_gsi::GenericMethod ("*visualRegionForSelection", "@hide", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0, &_set_callback_cbs_visualRegionForSelection_c2727_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QTableWidget::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QTableWidget::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
  return methods;
}

gsi::Class<QTableWidget_Adaptor> decl_QTableWidget_Adaptor (qtdecl_QTableWidget (), "QtGui", "QTableWidget",
  methods_QTableWidget_Adaptor (),
  "@qt\n@brief Binding of QTableWidget");

}

