/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.SchemaType;

public class ResultDocument
extends Instruction {
    private Expression href;
    private Properties outputProperties;
    private String baseURI;
    private int validationAction;
    private SchemaType schemaType;

    public ResultDocument(Properties properties, Expression expression, String string, int n, SchemaType schemaType) {
        this.outputProperties = properties;
        this.href = expression;
        this.baseURI = string;
        this.validationAction = n;
        this.schemaType = schemaType;
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("result-document");
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        String string;
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        Result result = null;
        OutputURIResolver outputURIResolver = null;
        if (this.href == null) {
            result = controller.getPrincipalResult();
        } else {
            String string2;
            outputURIResolver = controller.getOutputURIResolver();
            result = outputURIResolver.resolve(string2 = this.href.evaluateAsString(xPathContext), controller.getPrincipalResultURI());
            if (result == null) {
                outputURIResolver = StandardOutputResolver.getInstance();
                result = outputURIResolver.resolve(string2, controller.getPrincipalResultURI());
            }
        }
        boolean bl = controller.getConfiguration().isTiming();
        if (bl) {
            System.err.println("Writing to " + result.getSystemId());
        }
        if ((string = this.outputProperties.getProperty("{http://saxon.sf.net/}next-in-chain")) != null) {
            result = controller.prepareNextStylesheet(string, this.baseURI, result);
        }
        controller.changeOutputDestination(this.outputProperties, result, true, this.validationAction, this.schemaType);
        this.processChildren(xPathContext);
        controller.resetOutputDestination(sequenceReceiver);
        if (outputURIResolver != null) {
            outputURIResolver.close(result);
        }
        return null;
    }
}

