#if   !defined(__WALLFACTORY_HPP)
#define __WALLFACTORY_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__ABSTRACTALLOCATOR_HPP)
#include <AbstractAllocator.hpp>
#endif

#if   !defined(__WALLFLYWEIGHT_HPP)
#include <WallFlyweight.hpp>
#endif

DECLARE_CLASS( WallFactory );

/**
The WallFactory is provided to manage the WallFlyweight and
the sharing of same.
*/

class WallFactory : public CORELINUX(AbstractAllocator<WallFlyweight>)
{
public:

   //
   // Constructors and destructor
   //

                        /// Default constructor
                        
                        WallFactory( void );

                        /// Copy constructor

                        WallFactory( WallFactoryCref );

                        /// Virtual Destructor

   virtual              ~WallFactory( void );

   //
   // Operator overloads
   //

            /// Assignment operator

            WallFactoryRef operator=( WallFactoryCref );   

            /// Equality operator

            bool  operator==( WallFactoryCref ) const;

   //
   // We let the public factory methods in AbstractAllocator
   // go to town so there is no more public interface required
   // here
   //

protected:

   //
   // Factory implementations required from AbstractAllocator
   //

            /**
            allocates a object 
            @param WallFlyweight pointer
            */

   virtual  WallFlyweightPtr  allocateObject( void ) ;

            /**
            de-allocates a object
            @param WallFlyweight pointer
            */

   virtual  void     deallocateObject( WallFlyweightPtr ) ;

private:

   //
   // Because a wall can be shared, we only need one
   // true instance. Therefore, we create a static that
   // is used for all allocates
   //

            /// The solitary wall used in the universe

   static   WallFlyweight  theFlyweight;

};

#endif

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/21 02:38:47 $
   $Locker:  $
*/

