/* vfs-trash-impl-thunar-vfs.c generated by valac 0.10.4, the Vala compiler
 * generated from vfs-trash-impl-thunar-vfs.vala, do not modify */

/*
 * Desktop Agnostic Library: Trash implementation with Thunar VFS.
 *
 * Copyright (C) 2008, 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <libdesktop-agnostic/vfs.h>
#include <thunar-vfs/thunar-vfs.h>


#define XFCE_TYPE_TRASH (xfce_trash_get_type ())
#define XFCE_TRASH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFCE_TYPE_TRASH, XfceTrash))
#define XFCE_IS_TRASH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFCE_TYPE_TRASH))
#define XFCE_TRASH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), XFCE_TYPE_TRASH, XfceTrashIface))

typedef struct _XfceTrash XfceTrash;
typedef struct _XfceTrashIface XfceTrashIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _XfceTrashDBusProxy XfceTrashDBusProxy;
typedef DBusGProxyClass XfceTrashDBusProxyClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_STATE (desktop_agnostic_vfs_trash_state_get_type ())

#define DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS (desktop_agnostic_vfs_trash_thunar_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS, DesktopAgnosticVFSTrashThunarVFS))
#define DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS, DesktopAgnosticVFSTrashThunarVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS, DesktopAgnosticVFSTrashThunarVFSClass))

typedef struct _DesktopAgnosticVFSTrashThunarVFS DesktopAgnosticVFSTrashThunarVFS;
typedef struct _DesktopAgnosticVFSTrashThunarVFSClass DesktopAgnosticVFSTrashThunarVFSClass;
typedef struct _DesktopAgnosticVFSTrashThunarVFSPrivate DesktopAgnosticVFSTrashThunarVFSPrivate;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _XfceTrashIface {
	GTypeInterface parent_iface;
	void (*DisplayTrash) (XfceTrash* self, const char* display, GError** error);
	void (*EmptyTrash) (XfceTrash* self, const char* display, GError** error);
	void (*MoveToTrash) (XfceTrash* self, char** uris, int uris_length1, const char* display, GError** error);
	gboolean (*QueryTrash) (XfceTrash* self, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _XfceTrashDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

typedef enum  {
	DESKTOP_AGNOSTIC_VFS_TRASH_STATE_UNKNOWN = -1,
	DESKTOP_AGNOSTIC_VFS_TRASH_STATE_EMPTY,
	DESKTOP_AGNOSTIC_VFS_TRASH_STATE_FULL
} DesktopAgnosticVFSTrashState;

struct _DesktopAgnosticVFSTrashThunarVFS {
	GObject parent_instance;
	DesktopAgnosticVFSTrashThunarVFSPrivate * priv;
	ThunarVfsPath* trash;
};

struct _DesktopAgnosticVFSTrashThunarVFSClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSTrashThunarVFSPrivate {
	DBusGConnection* dbus;
	XfceTrash* xfce_trash;
	guint _file_count;
	ThunarVfsJob* job;
};


static gpointer desktop_agnostic_vfs_trash_thunar_vfs_parent_class = NULL;
static DesktopAgnosticVFSTrashIface* desktop_agnostic_vfs_trash_thunar_vfs_desktop_agnostic_vfs_trash_parent_iface = NULL;

XfceTrash* xfce_trash_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType xfce_trash_get_type (void) G_GNUC_CONST;
void xfce_trash_DisplayTrash (XfceTrash* self, const char* display, GError** error);
void xfce_trash_EmptyTrash (XfceTrash* self, const char* display, GError** error);
void xfce_trash_MoveToTrash (XfceTrash* self, char** uris, int uris_length1, const char* display, GError** error);
gboolean xfce_trash_QueryTrash (XfceTrash* self, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void xfce_trash_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _xfce_trash_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult xfce_trash_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_xfce_trash_introspect (XfceTrash* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_xfce_trash_property_get_all (XfceTrash* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_xfce_trash_DisplayTrash (XfceTrash* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_xfce_trash_EmptyTrash (XfceTrash* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_xfce_trash_MoveToTrash (XfceTrash* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_xfce_trash_QueryTrash (XfceTrash* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_xfce_trash_trash_changed (GObject* _sender, gboolean full, DBusConnection* _connection);
GType xfce_trash_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_xfce_trash_trash_changed (XfceTrash* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult xfce_trash_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	XFCE_TRASH_DBUS_PROXY_DUMMY_PROPERTY
};
static void xfce_trash_dbus_proxy_DisplayTrash (XfceTrash* self, const char* display, GError** error);
static void xfce_trash_dbus_proxy_EmptyTrash (XfceTrash* self, const char* display, GError** error);
static void xfce_trash_dbus_proxy_MoveToTrash (XfceTrash* self, char** uris, int uris_length1, const char* display, GError** error);
static gboolean xfce_trash_dbus_proxy_QueryTrash (XfceTrash* self, GError** error);
static void xfce_trash_dbus_proxy_xfce_trash__interface_init (XfceTrashIface* iface);
static void xfce_trash_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void xfce_trash_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType desktop_agnostic_vfs_trash_state_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_vfs_trash_thunar_vfs_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS, DesktopAgnosticVFSTrashThunarVFSPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS_FILE_COUNT
};
static void desktop_agnostic_vfs_trash_thunar_vfs_on_trash_changed (DesktopAgnosticVFSTrashThunarVFS* self, gboolean full);
static void desktop_agnostic_vfs_trash_thunar_vfs_update_file_count (DesktopAgnosticVFSTrashThunarVFS* self, DesktopAgnosticVFSTrashState state);
static void desktop_agnostic_vfs_trash_thunar_vfs_on_trash_count (DesktopAgnosticVFSTrashThunarVFS* self, ThunarVfsJob* job, guint64 total_size, guint file_count, guint dir_count, guint unreadable_dir_count);
static void _desktop_agnostic_vfs_trash_thunar_vfs_on_trash_count_thunar_vfs_job_status_ready (ThunarVfsJob* _sender, guint64 total_size, guint file_count, guint directory_count, guint unreadable_directory_count, gpointer self);
static void desktop_agnostic_vfs_trash_thunar_vfs_on_job_finished (DesktopAgnosticVFSTrashThunarVFS* self, ThunarVfsJob* job);
static void _desktop_agnostic_vfs_trash_thunar_vfs_on_job_finished_thunar_vfs_job_finished (ThunarVfsJob* _sender, gpointer self);
static void desktop_agnostic_vfs_trash_thunar_vfs_real_send_to_trash (DesktopAgnosticVFSTrash* base, DesktopAgnosticVFSFile* file, GError** error);
static void desktop_agnostic_vfs_trash_thunar_vfs_real_empty (DesktopAgnosticVFSTrash* base);
DesktopAgnosticVFSTrashThunarVFS* desktop_agnostic_vfs_trash_thunar_vfs_new (void);
DesktopAgnosticVFSTrashThunarVFS* desktop_agnostic_vfs_trash_thunar_vfs_construct (GType object_type);
static void _desktop_agnostic_vfs_trash_thunar_vfs_on_trash_changed_xfce_trash_trash_changed (XfceTrash* _sender, gboolean full, gpointer self);
static GObject * desktop_agnostic_vfs_trash_thunar_vfs_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void desktop_agnostic_vfs_trash_thunar_vfs_finalize (GObject* obj);
static void desktop_agnostic_vfs_trash_thunar_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _xfce_trash_dbus_path_vtable = {_xfce_trash_dbus_unregister, xfce_trash_dbus_message};
static const _DBusObjectVTable _xfce_trash_dbus_vtable = {xfce_trash_dbus_register_object};


void xfce_trash_DisplayTrash (XfceTrash* self, const char* display, GError** error) {
	XFCE_TRASH_GET_INTERFACE (self)->DisplayTrash (self, display, error);
}


void xfce_trash_EmptyTrash (XfceTrash* self, const char* display, GError** error) {
	XFCE_TRASH_GET_INTERFACE (self)->EmptyTrash (self, display, error);
}


void xfce_trash_MoveToTrash (XfceTrash* self, char** uris, int uris_length1, const char* display, GError** error) {
	XFCE_TRASH_GET_INTERFACE (self)->MoveToTrash (self, uris, uris_length1, display, error);
}


gboolean xfce_trash_QueryTrash (XfceTrash* self, GError** error) {
	return XFCE_TRASH_GET_INTERFACE (self)->QueryTrash (self, error);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _xfce_trash_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_xfce_trash_introspect (XfceTrash* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.xfce.Trash\">\n  <method name=\"DisplayTrash\">\n    <arg name=\"display\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"EmptyTrash\">\n    <arg name=\"display\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"MoveToTrash\">\n    <arg name=\"uris\" type=\"as\" direction=\"in\"/>\n    <arg name=\"display\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"QueryTrash\">\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"TrashChanged\">\n    <arg name=\"full\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_xfce_trash_property_get_all (XfceTrash* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.xfce.Trash") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_xfce_trash_DisplayTrash (XfceTrash* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* display = NULL;
	const char* _tmp1_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	display = g_strdup (_tmp1_);
	xfce_trash_DisplayTrash (self, display, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (display);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_xfce_trash_EmptyTrash (XfceTrash* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* display = NULL;
	const char* _tmp2_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp2_);
	dbus_message_iter_next (&iter);
	display = g_strdup (_tmp2_);
	xfce_trash_EmptyTrash (self, display, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (display);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_xfce_trash_MoveToTrash (XfceTrash* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char** uris = NULL;
	int uris_length1;
	char** _tmp3_;
	int _tmp3__length;
	int _tmp3__size;
	int _tmp3__length1;
	DBusMessageIter _tmp4_;
	char* display = NULL;
	const char* _tmp6_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "ass")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	uris_length1 = 0;
	_tmp3_ = g_new (char*, 5);
	_tmp3__length = 0;
	_tmp3__size = 4;
	_tmp3__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp4_);
	for (; dbus_message_iter_get_arg_type (&_tmp4_); _tmp3__length1++) {
		const char* _tmp5_;
		if (_tmp3__size == _tmp3__length) {
			_tmp3__size = 2 * _tmp3__size;
			_tmp3_ = g_renew (char*, _tmp3_, _tmp3__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp4_, &_tmp5_);
		dbus_message_iter_next (&_tmp4_);
		_tmp3_[_tmp3__length++] = g_strdup (_tmp5_);
	}
	uris_length1 = _tmp3__length1;
	_tmp3_[_tmp3__length] = NULL;
	dbus_message_iter_next (&iter);
	uris = _tmp3_;
	dbus_message_iter_get_basic (&iter, &_tmp6_);
	dbus_message_iter_next (&iter);
	display = g_strdup (_tmp6_);
	xfce_trash_MoveToTrash (self, uris, uris_length1, display, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (display);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_xfce_trash_QueryTrash (XfceTrash* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp7_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result = xfce_trash_QueryTrash (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp7_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp7_);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult xfce_trash_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_xfce_trash_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_xfce_trash_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.xfce.Trash", "DisplayTrash")) {
		result = _dbus_xfce_trash_DisplayTrash (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.xfce.Trash", "EmptyTrash")) {
		result = _dbus_xfce_trash_EmptyTrash (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.xfce.Trash", "MoveToTrash")) {
		result = _dbus_xfce_trash_MoveToTrash (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.xfce.Trash", "QueryTrash")) {
		result = _dbus_xfce_trash_QueryTrash (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_xfce_trash_trash_changed (GObject* _sender, gboolean full, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_bool_t _tmp8_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.xfce.Trash", "TrashChanged");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp8_ = full;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp8_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void xfce_trash_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_xfce_trash_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "trash-changed", (GCallback) _dbus_xfce_trash_trash_changed, connection);
}


static void xfce_trash_base_init (XfceTrashIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("trash_changed", XFCE_TYPE_TRASH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
		g_type_set_qdata (XFCE_TYPE_TRASH, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_xfce_trash_dbus_vtable));
	}
}


GType xfce_trash_get_type (void) {
	static volatile gsize xfce_trash_type_id__volatile = 0;
	if (g_once_init_enter (&xfce_trash_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XfceTrashIface), (GBaseInitFunc) xfce_trash_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType xfce_trash_type_id;
		xfce_trash_type_id = g_type_register_static (G_TYPE_INTERFACE, "XfceTrash", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (xfce_trash_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (xfce_trash_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &xfce_trash_dbus_proxy_get_type);
		g_once_init_leave (&xfce_trash_type_id__volatile, xfce_trash_type_id);
	}
	return xfce_trash_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (XfceTrashDBusProxy, xfce_trash_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (XFCE_TYPE_TRASH, xfce_trash_dbus_proxy_xfce_trash__interface_init) );
XfceTrash* xfce_trash_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	XfceTrash* self;
	self = g_object_new (xfce_trash_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.xfce.Trash", NULL);
	return self;
}


static GObject* xfce_trash_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (xfce_trash_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), xfce_trash_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s',interface='org.xfce.Trash'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_xfce_trash_trash_changed (XfceTrash* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gboolean full = FALSE;
	dbus_bool_t _tmp0_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "b")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	full = _tmp0_;
	g_signal_emit_by_name (self, "trash-changed", full);
}


DBusHandlerResult xfce_trash_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.xfce.Trash", "TrashChanged")) {
			_dbus_handle_xfce_trash_trash_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void xfce_trash_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((XfceTrashDBusProxy*) self)->disposed) {
		return;
	}
	((XfceTrashDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), xfce_trash_dbus_proxy_filter, self);
	G_OBJECT_CLASS (xfce_trash_dbus_proxy_parent_class)->dispose (self);
}


static void xfce_trash_dbus_proxy_class_init (XfceTrashDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = xfce_trash_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = xfce_trash_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = xfce_trash_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = xfce_trash_dbus_proxy_set_property;
}


static void xfce_trash_dbus_proxy_init (XfceTrashDBusProxy* self) {
}


static void xfce_trash_dbus_proxy_DisplayTrash (XfceTrash* self, const char* display, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp1_;
	if (((XfceTrashDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.xfce.Trash", "DisplayTrash");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp1_ = display;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp1_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp2_;
			_edomain = DBUS_GERROR;
			_tmp2_ = _dbus_error.name + 27;
			if (strcmp (_tmp2_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp2_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp2_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp2_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp2_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp2_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp2_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp2_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp2_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp2_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp2_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp2_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp2_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp2_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp2_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp2_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp2_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp2_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp2_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp2_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp2_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp2_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp2_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp2_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp2_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp2_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp2_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp2_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp2_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp2_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp2_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp2_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp2_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void xfce_trash_dbus_proxy_EmptyTrash (XfceTrash* self, const char* display, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp3_;
	if (((XfceTrashDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.xfce.Trash", "EmptyTrash");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp3_ = display;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp3_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp4_;
			_edomain = DBUS_GERROR;
			_tmp4_ = _dbus_error.name + 27;
			if (strcmp (_tmp4_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp4_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp4_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp4_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp4_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp4_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp4_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp4_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp4_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp4_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp4_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp4_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp4_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp4_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp4_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp4_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp4_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp4_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp4_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp4_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp4_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp4_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp4_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp4_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp4_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp4_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp4_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp4_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp4_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp4_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp4_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp4_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp4_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void xfce_trash_dbus_proxy_MoveToTrash (XfceTrash* self, char** uris, int uris_length1, const char* display, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char** _tmp5_;
	DBusMessageIter _tmp6_;
	int _tmp7_;
	const char* _tmp9_;
	if (((XfceTrashDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.xfce.Trash", "MoveToTrash");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp5_ = uris;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp6_);
	for (_tmp7_ = 0; _tmp7_ < uris_length1; _tmp7_++) {
		const char* _tmp8_;
		_tmp8_ = *_tmp5_;
		dbus_message_iter_append_basic (&_tmp6_, DBUS_TYPE_STRING, &_tmp8_);
		_tmp5_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp6_);
	_tmp9_ = display;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp9_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp10_;
			_edomain = DBUS_GERROR;
			_tmp10_ = _dbus_error.name + 27;
			if (strcmp (_tmp10_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp10_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp10_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp10_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp10_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp10_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp10_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp10_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp10_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp10_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp10_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp10_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp10_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp10_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp10_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp10_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp10_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp10_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp10_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp10_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp10_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp10_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp10_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp10_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp10_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp10_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp10_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp10_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp10_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp10_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp10_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp10_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp10_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gboolean xfce_trash_dbus_proxy_QueryTrash (XfceTrash* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	gboolean _result;
	dbus_bool_t _tmp11_;
	if (((XfceTrashDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.xfce.Trash", "QueryTrash");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp12_;
			_edomain = DBUS_GERROR;
			_tmp12_ = _dbus_error.name + 27;
			if (strcmp (_tmp12_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp12_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp12_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp12_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp12_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp12_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp12_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp12_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp12_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp12_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp12_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp12_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp12_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp12_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp12_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp12_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp12_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp12_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp12_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp12_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp12_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp12_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp12_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp12_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp12_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp12_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp12_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp12_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp12_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp12_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp12_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp12_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp12_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "b")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "b", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp11_);
	dbus_message_iter_next (&_iter);
	_result = _tmp11_;
	dbus_message_unref (_reply);
	return _result;
}


static void xfce_trash_dbus_proxy_xfce_trash__interface_init (XfceTrashIface* iface) {
	iface->DisplayTrash = xfce_trash_dbus_proxy_DisplayTrash;
	iface->EmptyTrash = xfce_trash_dbus_proxy_EmptyTrash;
	iface->MoveToTrash = xfce_trash_dbus_proxy_MoveToTrash;
	iface->QueryTrash = xfce_trash_dbus_proxy_QueryTrash;
}


static void xfce_trash_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void xfce_trash_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


GType desktop_agnostic_vfs_trash_state_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_trash_state_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_trash_state_type_id__volatile)) {
		static const GEnumValue values[] = {{DESKTOP_AGNOSTIC_VFS_TRASH_STATE_UNKNOWN, "DESKTOP_AGNOSTIC_VFS_TRASH_STATE_UNKNOWN", "unknown"}, {DESKTOP_AGNOSTIC_VFS_TRASH_STATE_EMPTY, "DESKTOP_AGNOSTIC_VFS_TRASH_STATE_EMPTY", "empty"}, {DESKTOP_AGNOSTIC_VFS_TRASH_STATE_FULL, "DESKTOP_AGNOSTIC_VFS_TRASH_STATE_FULL", "full"}, {0, NULL, NULL}};
		GType desktop_agnostic_vfs_trash_state_type_id;
		desktop_agnostic_vfs_trash_state_type_id = g_enum_register_static ("DesktopAgnosticVFSTrashState", values);
		g_once_init_leave (&desktop_agnostic_vfs_trash_state_type_id__volatile, desktop_agnostic_vfs_trash_state_type_id);
	}
	return desktop_agnostic_vfs_trash_state_type_id__volatile;
}


static void desktop_agnostic_vfs_trash_thunar_vfs_on_trash_changed (DesktopAgnosticVFSTrashThunarVFS* self, gboolean full) {
	DesktopAgnosticVFSTrashState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	if (full) {
		_tmp0_ = DESKTOP_AGNOSTIC_VFS_TRASH_STATE_FULL;
	} else {
		_tmp0_ = DESKTOP_AGNOSTIC_VFS_TRASH_STATE_EMPTY;
	}
	desktop_agnostic_vfs_trash_thunar_vfs_update_file_count (self, _tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _desktop_agnostic_vfs_trash_thunar_vfs_on_trash_count_thunar_vfs_job_status_ready (ThunarVfsJob* _sender, guint64 total_size, guint file_count, guint directory_count, guint unreadable_directory_count, gpointer self) {
	desktop_agnostic_vfs_trash_thunar_vfs_on_trash_count (self, _sender, total_size, file_count, directory_count, unreadable_directory_count);
}


static void _desktop_agnostic_vfs_trash_thunar_vfs_on_job_finished_thunar_vfs_job_finished (ThunarVfsJob* _sender, gpointer self) {
	desktop_agnostic_vfs_trash_thunar_vfs_on_job_finished (self, _sender);
}


static void desktop_agnostic_vfs_trash_thunar_vfs_update_file_count (DesktopAgnosticVFSTrashThunarVFS* self, DesktopAgnosticVFSTrashState state) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (state == DESKTOP_AGNOSTIC_VFS_TRASH_STATE_EMPTY) {
		self->priv->_file_count = (guint) 0;
		g_signal_emit_by_name ((DesktopAgnosticVFSTrash*) self, "file-count-changed");
	} else {
		{
			ThunarVfsJob* _tmp0_;
			ThunarVfsJob* _tmp1_;
			_tmp0_ = thunar_vfs_deep_count (self->trash, THUNAR_VFS_DEEP_COUNT_FLAGS_NONE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			self->priv->job = (_tmp1_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (self->priv->job), _tmp1_);
			g_signal_connect_object (self->priv->job, "status-ready", (GCallback) _desktop_agnostic_vfs_trash_thunar_vfs_on_trash_count_thunar_vfs_job_status_ready, self, 0);
			g_signal_connect_object (self->priv->job, "finished", (GCallback) _desktop_agnostic_vfs_trash_thunar_vfs_on_job_finished_thunar_vfs_job_finished, self, 0);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vfs-trash-impl-thunar-vfs.vala:89: Could not retrieve contents of Tras" \
"h: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally3:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void desktop_agnostic_vfs_trash_thunar_vfs_on_job_finished (DesktopAgnosticVFSTrashThunarVFS* self, ThunarVfsJob* job) {
	ThunarVfsJob* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (job != NULL);
	self->priv->job = (_tmp0_ = NULL, _g_object_unref0 (self->priv->job), _tmp0_);
}


static void desktop_agnostic_vfs_trash_thunar_vfs_on_trash_count (DesktopAgnosticVFSTrashThunarVFS* self, ThunarVfsJob* job, guint64 total_size, guint file_count, guint dir_count, guint unreadable_dir_count) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (job != NULL);
	self->priv->_file_count = (file_count + (dir_count - 1)) + unreadable_dir_count;
	g_signal_emit_by_name ((DesktopAgnosticVFSTrash*) self, "file-count-changed");
}


static void desktop_agnostic_vfs_trash_thunar_vfs_real_send_to_trash (DesktopAgnosticVFSTrash* base, DesktopAgnosticVFSFile* file, GError** error) {
	DesktopAgnosticVFSTrashThunarVFS * self;
	gint uris_length1;
	gint _uris_size_;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char** uris;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSTrashThunarVFS*) base;
	g_return_if_fail (file != NULL);
	uris = (_tmp1_ = (_tmp0_ = g_new0 (char*, 1 + 1), _tmp0_[0] = desktop_agnostic_vfs_file_get_uri (file), _tmp0_), uris_length1 = 1, _uris_size_ = uris_length1, _tmp1_);
	xfce_trash_MoveToTrash (self->priv->xfce_trash, uris, uris_length1, "", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
}


static void desktop_agnostic_vfs_trash_thunar_vfs_real_empty (DesktopAgnosticVFSTrash* base) {
	DesktopAgnosticVFSTrashThunarVFS * self;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSTrashThunarVFS*) base;
	{
		xfce_trash_EmptyTrash (self->priv->xfce_trash, "", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch4_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally4;
	__catch4_dbus_gerror:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("vfs-trash-impl-thunar-vfs.vala:136: VFS Trash Error (Thunar VFS): %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


DesktopAgnosticVFSTrashThunarVFS* desktop_agnostic_vfs_trash_thunar_vfs_construct (GType object_type) {
	DesktopAgnosticVFSTrashThunarVFS * self = NULL;
	self = (DesktopAgnosticVFSTrashThunarVFS*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSTrashThunarVFS* desktop_agnostic_vfs_trash_thunar_vfs_new (void) {
	return desktop_agnostic_vfs_trash_thunar_vfs_construct (DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS);
}


static guint desktop_agnostic_vfs_trash_thunar_vfs_real_get_file_count (DesktopAgnosticVFSTrash* base) {
	guint result;
	DesktopAgnosticVFSTrashThunarVFS* self;
	self = (DesktopAgnosticVFSTrashThunarVFS*) base;
	result = self->priv->_file_count;
	return result;
}


static void _desktop_agnostic_vfs_trash_thunar_vfs_on_trash_changed_xfce_trash_trash_changed (XfceTrash* _sender, gboolean full, gpointer self) {
	desktop_agnostic_vfs_trash_thunar_vfs_on_trash_changed (self, full);
}


static GObject * desktop_agnostic_vfs_trash_thunar_vfs_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DesktopAgnosticVFSTrashThunarVFS * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (desktop_agnostic_vfs_trash_thunar_vfs_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS (obj);
	_inner_error_ = NULL;
	{
		ThunarVfsMonitor* monitor;
		DBusGConnection* _tmp0_;
		DBusGConnection* _tmp1_;
		XfceTrash* _tmp2_;
		monitor = NULL;
		self->trash = thunar_vfs_path_get_for_trash ();
		_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (monitor);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		self->priv->dbus = (_tmp1_ = _tmp0_, _dbus_g_connection_unref0 (self->priv->dbus), _tmp1_);
		self->priv->xfce_trash = (_tmp2_ = xfce_trash_dbus_proxy_new (self->priv->dbus, "org.xfce.Thunar", "/org/xfce/FileManager"), _g_object_unref0 (self->priv->xfce_trash), _tmp2_);
		g_signal_connect_object (self->priv->xfce_trash, "trash-changed", (GCallback) _desktop_agnostic_vfs_trash_thunar_vfs_on_trash_changed_xfce_trash_trash_changed, self, 0);
		self->priv->_file_count = (guint) 0;
		desktop_agnostic_vfs_trash_thunar_vfs_update_file_count (self, DESKTOP_AGNOSTIC_VFS_TRASH_STATE_UNKNOWN);
		_g_object_unref0 (monitor);
	}
	return obj;
}


static void desktop_agnostic_vfs_trash_thunar_vfs_class_init (DesktopAgnosticVFSTrashThunarVFSClass * klass) {
	desktop_agnostic_vfs_trash_thunar_vfs_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSTrashThunarVFSPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_trash_thunar_vfs_get_property;
	G_OBJECT_CLASS (klass)->constructor = desktop_agnostic_vfs_trash_thunar_vfs_constructor;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_trash_thunar_vfs_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS_FILE_COUNT, "file-count");
}


static void desktop_agnostic_vfs_trash_thunar_vfs_desktop_agnostic_vfs_trash_interface_init (DesktopAgnosticVFSTrashIface * iface) {
	desktop_agnostic_vfs_trash_thunar_vfs_desktop_agnostic_vfs_trash_parent_iface = g_type_interface_peek_parent (iface);
	iface->send_to_trash = desktop_agnostic_vfs_trash_thunar_vfs_real_send_to_trash;
	iface->empty = desktop_agnostic_vfs_trash_thunar_vfs_real_empty;
	iface->get_file_count = desktop_agnostic_vfs_trash_thunar_vfs_real_get_file_count;
}


static void desktop_agnostic_vfs_trash_thunar_vfs_instance_init (DesktopAgnosticVFSTrashThunarVFS * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_trash_thunar_vfs_finalize (GObject* obj) {
	DesktopAgnosticVFSTrashThunarVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS (obj);
	_dbus_g_connection_unref0 (self->priv->dbus);
	_g_object_unref0 (self->priv->xfce_trash);
	_g_object_unref0 (self->priv->job);
	G_OBJECT_CLASS (desktop_agnostic_vfs_trash_thunar_vfs_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_trash_thunar_vfs_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_trash_thunar_vfs_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_trash_thunar_vfs_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSTrashThunarVFSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_trash_thunar_vfs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSTrashThunarVFS), 0, (GInstanceInitFunc) desktop_agnostic_vfs_trash_thunar_vfs_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_trash_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_trash_thunar_vfs_desktop_agnostic_vfs_trash_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_vfs_trash_thunar_vfs_type_id;
		desktop_agnostic_vfs_trash_thunar_vfs_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSTrashThunarVFS", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_trash_thunar_vfs_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_TRASH, &desktop_agnostic_vfs_trash_info);
		g_once_init_leave (&desktop_agnostic_vfs_trash_thunar_vfs_type_id__volatile, desktop_agnostic_vfs_trash_thunar_vfs_type_id);
	}
	return desktop_agnostic_vfs_trash_thunar_vfs_type_id__volatile;
}


static void desktop_agnostic_vfs_trash_thunar_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSTrashThunarVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS_FILE_COUNT:
		g_value_set_uint (value, desktop_agnostic_vfs_trash_get_file_count ((DesktopAgnosticVFSTrash*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




