/*
 * Codepage definitions for libfvde
 *
 * Copyright (C) 2011-2018, Omar Choudary <choudary.omar@gmail.com>,
 *                          Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _LIBFVDE_CODEPAGE_H )
#define _LIBFVDE_CODEPAGE_H

#include <libfvde/types.h>

#if defined( __cplusplus )
extern "C" {
#endif

/* The codepage definitions
 */
enum LIBFVDE_CODEPAGES
{
	LIBFVDE_CODEPAGE_ASCII				= 20127,

	LIBFVDE_CODEPAGE_ISO_8859_1			= 28591,
	LIBFVDE_CODEPAGE_ISO_8859_2			= 28592,
	LIBFVDE_CODEPAGE_ISO_8859_3			= 28593,
	LIBFVDE_CODEPAGE_ISO_8859_4			= 28594,
	LIBFVDE_CODEPAGE_ISO_8859_5			= 28595,
	LIBFVDE_CODEPAGE_ISO_8859_6			= 28596,
	LIBFVDE_CODEPAGE_ISO_8859_7			= 28597,
	LIBFVDE_CODEPAGE_ISO_8859_8			= 28598,
	LIBFVDE_CODEPAGE_ISO_8859_9			= 28599,
	LIBFVDE_CODEPAGE_ISO_8859_10			= 28600,
	LIBFVDE_CODEPAGE_ISO_8859_11			= 28601,
	LIBFVDE_CODEPAGE_ISO_8859_13			= 28603,
	LIBFVDE_CODEPAGE_ISO_8859_14			= 28604,
	LIBFVDE_CODEPAGE_ISO_8859_15			= 28605,
	LIBFVDE_CODEPAGE_ISO_8859_16			= 28606,

	LIBFVDE_CODEPAGE_KOI8_R				= 20866,
	LIBFVDE_CODEPAGE_KOI8_U				= 21866,

	LIBFVDE_CODEPAGE_WINDOWS_874			= 874,
	LIBFVDE_CODEPAGE_WINDOWS_932			= 932,
	LIBFVDE_CODEPAGE_WINDOWS_936			= 936,
	LIBFVDE_CODEPAGE_WINDOWS_949			= 949,
	LIBFVDE_CODEPAGE_WINDOWS_950			= 950,
	LIBFVDE_CODEPAGE_WINDOWS_1250			= 1250,
	LIBFVDE_CODEPAGE_WINDOWS_1251			= 1251,
	LIBFVDE_CODEPAGE_WINDOWS_1252			= 1252,
	LIBFVDE_CODEPAGE_WINDOWS_1253			= 1253,
	LIBFVDE_CODEPAGE_WINDOWS_1254			= 1254,
	LIBFVDE_CODEPAGE_WINDOWS_1255			= 1255,
	LIBFVDE_CODEPAGE_WINDOWS_1256			= 1256,
	LIBFVDE_CODEPAGE_WINDOWS_1257			= 1257,
	LIBFVDE_CODEPAGE_WINDOWS_1258			= 1258
};

#define LIBFVDE_CODEPAGE_US_ASCII			LIBFVDE_CODEPAGE_ASCII

#define LIBFVDE_CODEPAGE_ISO_WESTERN_EUROPEAN		LIBFVDE_CODEPAGE_ISO_8859_1
#define LIBFVDE_CODEPAGE_ISO_CENTRAL_EUROPEAN		LIBFVDE_CODEPAGE_ISO_8859_2
#define LIBFVDE_CODEPAGE_ISO_SOUTH_EUROPEAN		LIBFVDE_CODEPAGE_ISO_8859_3
#define LIBFVDE_CODEPAGE_ISO_NORTH_EUROPEAN		LIBFVDE_CODEPAGE_ISO_8859_4
#define LIBFVDE_CODEPAGE_ISO_CYRILLIC			LIBFVDE_CODEPAGE_ISO_8859_5
#define LIBFVDE_CODEPAGE_ISO_ARABIC			LIBFVDE_CODEPAGE_ISO_8859_6
#define LIBFVDE_CODEPAGE_ISO_GREEK			LIBFVDE_CODEPAGE_ISO_8859_7
#define LIBFVDE_CODEPAGE_ISO_HEBREW			LIBFVDE_CODEPAGE_ISO_8859_8
#define LIBFVDE_CODEPAGE_ISO_TURKISH			LIBFVDE_CODEPAGE_ISO_8859_9
#define LIBFVDE_CODEPAGE_ISO_NORDIC			LIBFVDE_CODEPAGE_ISO_8859_10
#define LIBFVDE_CODEPAGE_ISO_THAI			LIBFVDE_CODEPAGE_ISO_8859_11
#define LIBFVDE_CODEPAGE_ISO_BALTIC			LIBFVDE_CODEPAGE_ISO_8859_13
#define LIBFVDE_CODEPAGE_ISO_CELTIC			LIBFVDE_CODEPAGE_ISO_8859_14

#define LIBFVDE_CODEPAGE_ISO_LATIN_1			LIBFVDE_CODEPAGE_ISO_8859_1
#define LIBFVDE_CODEPAGE_ISO_LATIN_2			LIBFVDE_CODEPAGE_ISO_8859_2
#define LIBFVDE_CODEPAGE_ISO_LATIN_3			LIBFVDE_CODEPAGE_ISO_8859_3
#define LIBFVDE_CODEPAGE_ISO_LATIN_4			LIBFVDE_CODEPAGE_ISO_8859_4
#define LIBFVDE_CODEPAGE_ISO_LATIN_5			LIBFVDE_CODEPAGE_ISO_8859_9
#define LIBFVDE_CODEPAGE_ISO_LATIN_6			LIBFVDE_CODEPAGE_ISO_8859_10
#define LIBFVDE_CODEPAGE_ISO_LATIN_7			LIBFVDE_CODEPAGE_ISO_8859_13
#define LIBFVDE_CODEPAGE_ISO_LATIN_8			LIBFVDE_CODEPAGE_ISO_8859_14
#define LIBFVDE_CODEPAGE_ISO_LATIN_9			LIBFVDE_CODEPAGE_ISO_8859_15
#define LIBFVDE_CODEPAGE_ISO_LATIN_10			LIBFVDE_CODEPAGE_ISO_8859_16

#define LIBFVDE_CODEPAGE_KOI8_RUSSIAN			LIBFVDE_CODEPAGE_KOI8_R
#define LIBFVDE_CODEPAGE_KOI8_UKRAINIAN			LIBFVDE_CODEPAGE_KOI8_U

#define LIBFVDE_CODEPAGE_WINDOWS_THAI			LIBFVDE_CODEPAGE_WINDOWS_874
#define LIBFVDE_CODEPAGE_WINDOWS_JAPANESE		LIBFVDE_CODEPAGE_WINDOWS_932
#define LIBFVDE_CODEPAGE_WINDOWS_CHINESE_SIMPLIFIED	LIBFVDE_CODEPAGE_WINDOWS_936
#define LIBFVDE_CODEPAGE_WINDOWS_KOREAN			LIBFVDE_CODEPAGE_WINDOWS_949
#define LIBFVDE_CODEPAGE_WINDOWS_CHINESE_TRADITIONAL	LIBFVDE_CODEPAGE_WINDOWS_950
#define LIBFVDE_CODEPAGE_WINDOWS_CENTRAL_EUROPEAN	LIBFVDE_CODEPAGE_WINDOWS_1250
#define LIBFVDE_CODEPAGE_WINDOWS_CYRILLIC		LIBFVDE_CODEPAGE_WINDOWS_1251
#define LIBFVDE_CODEPAGE_WINDOWS_WESTERN_EUROPEAN	LIBFVDE_CODEPAGE_WINDOWS_1252
#define LIBFVDE_CODEPAGE_WINDOWS_GREEK			LIBFVDE_CODEPAGE_WINDOWS_1253
#define LIBFVDE_CODEPAGE_WINDOWS_TURKISH		LIBFVDE_CODEPAGE_WINDOWS_1254
#define LIBFVDE_CODEPAGE_WINDOWS_HEBREW			LIBFVDE_CODEPAGE_WINDOWS_1255
#define LIBFVDE_CODEPAGE_WINDOWS_ARABIC			LIBFVDE_CODEPAGE_WINDOWS_1256
#define LIBFVDE_CODEPAGE_WINDOWS_BALTIC			LIBFVDE_CODEPAGE_WINDOWS_1257
#define LIBFVDE_CODEPAGE_WINDOWS_VIETNAMESE		LIBFVDE_CODEPAGE_WINDOWS_1258

#if defined( __cplusplus )
}
#endif

#endif /* !defined( _LIBFVDE_CODEPAGE_H ) */

