# Stefan Achatz 2012
#
# Tries to find libatk and sets following variables according to found capabilities:
#
# ATK_FOUND
# ATK_INCLUDE_DIRS
# ATK_LIBRARIES

FIND_PACKAGE(PkgConfig)
PKG_CHECK_MODULES(PKG_ATK atk)

FIND_PATH(ATK_INCLUDE_DIRS atk/atk.h
  HINTS
    ${PKG_ATK_INCLUDE_DIRS}
    ${PKG_ATK_INCLUDEDIR}
)

FIND_LIBRARY(ATK_LIBRARIES atk-1.0
  HINTS ${PKG_ATK_LIBRARY_DIRS}
)

IF(ATK_LIBRARIES AND ATK_INCLUDE_DIRS)
  SET(ATK_FOUND true)
ENDIF()

IF(ATK_FIND_REQUIRED AND NOT ATK_FOUND)
  MESSAGE(FATAL_ERROR "Could not find ATK")
ENDIF()
